//SY20ZR00 JOB 1,PDS-7003,MSGCLASS=A,CLASS=A,REGION=256K
//*
//*   PROBLEM DESCRIPTION(S):
//*     PDS -
//*       Refit TSO PDS command version 7.0 to run on MVT.
//*
//*       This is version 7.0.03 of the MVT PDS command.
//*
//*       All native PDS 7.0 subcommands are supported under MVT.
//*       Supported subcommands are:
//*
//*         ATTRIB   - Display (or modify) load module attributes
//*         ALIAS    - Assign an alias to a member
//*         CHANGE   - Change to a different data set
//*         COMPARE  - Compare two members
//*         COMPRESS - Compress the data set
//*         CONTROL  - Set program control variables
//*         DISPLAY  - Display all or part of the directory
//*         DIRENTRY - Dump a member's directory entry
//*         DELETE   - Delete a member
//*         DSNAME   - Display the current data set allocation
//*         END      - Terminate the PDS command
//*         EXEC     - Execute PDS subcommands from a CLIST source
//*         FIND     - List lines containing a search string
//*         FIXPDS   - Modify the allocated partitioned data set
//*         FSE      - Edit a member with the fse command
//*         HELP     - Display subcommand help for PDS
//*         HISTORY  - List history of a load module
//*         IF       - Test a member for given attributes
//*         LIST     - List contents of a member
//*         MAP      - Map a load module
//*         MEMBERS  - Display members in a group
//*         OPTIONS  - Display the subcommand menu
//*         OUTCOPY  - Output IEBCOPY SELECT statements
//*         PATTERN  - Display directory based on member name segments
//*         RECALL   - Display or reissue the previous subcommand
//*         RENAME   - Rename a member
//*         RESTORE  - Resurrect a previously deleted member
//*         REVIEW   - Browse data with the REVIEW command
//*         SUBMIT   - Submit a JCL member
//*         TSO      - Execute a TSO command
//*         TSOEDIT  - Edit a member with TSO edit
//*         USAGE    - List data set statistics
//*         VERIFY   - Check the data set for validity errors
//*
//*       The following external programs are required for the
//*       indicated subcommands:
//*
//*       Subcommand   Programs             Source
//*       ----------   ------------------   ---------------------------
//*       REVIEW       REVIEW               CBT FILE 296; CBT FILE 300
//*       COMPARE      COMPARE, COMPAREB    CBT FILE 296; CBT FILE 300
//*
//*       A PDS help member is also included.
//*
//*       Because ISPF is not available, ISPF-related subcommands
//*       BROWSE, EDIT/SPFEDIT, ISPMODE and MEMLIST are not available
//*       in MVT.  Subcommands that link to other external command
//*       processors, DSPRINT, PRINTOFF and TSOLIST, are also disabled
//*       in the MVT environment.
//*
//*       MVT does not provide the System Track Allocation Routine
//*       (STAR), which supports the TRKCALC macro.  STAR logic
//*       from MVS 3.8 has been rewritten as a local subroutine
//*       and included with PDS.  The STAR subroutine to apply
//*       tolerance factors has been modified to support all devices
//*       that require it (the MVS 3.8 version is hard-coded for 2314
//*       only).  Because this requires more registers than are used
//*       by the MVS version, the caller of TRKCALC must provide the
//*       address of a standard save area in R13, and specify
//*       REGSAVE=YES on the TRKCALC macro invocation.  PDS usage of
//*       TRKCALC includes REGSAVE=YES.
//*
//*       Several macros not available or incomplete in MVT have
//*       been created or supplied from MVS 3.8 macro libraries.
//*       They are:
//*
//*         ESTAE    (mapped to MVT STAE)
//*         IHADVCT  (Device Characteristics Table mapping)
//*         IHASDWA  (SDWA, first 104 bytes)
//*         IKJEFFDF (DAIRFAIL parm list)
//*         IKJEFFMT (IKJEFF02 message handler parameter list)
//*         IKJTSMSG (IKJEFF02 message handler message description)
//*         SETRP    (generates MVT STAE return linkage)
//*         STFSMODE (set full screen mode, acts as a no-op)
//*         STLINENO (set next non-full-screen line number)
//*         TRKCALC  (modified to call local STAR subroutine)
//*
//*       By default, PDS uses the unit name "SYSDA" for allocating disk
//*       data sets.  To use a different unit, change the conditional
//*       assembly variable &DAUNIT in member PDSGEN70 to the desired
//*       value.
//*
//*   SPECIAL CONDITIONS:
//*     DEPENDENCY:
//*       Assembly of PDS requires the OS/VS XF assembler IFOX00.
//*
//*     DEPENDENCY:
//*       PDS uses System/370 instructions.  The hardware or hardware
//*       emulator MVT is running on must support System/370 instructions,
//*       or the version of MVT being used must include software
//*       simulation of System/370 instructions.
//*
//*     DEPENDENCY:
//*       STLINENO acts as a no-op unless usermod TMVT818 or
//*       equivalent is installed to add STLINENO functionality
//*       to MVT SVC 94.
//*
//*   COMMENTS:
//*     LAST CHANGE:  2021/08/18
//*
//*     REWORK HISTORY:
//*      2021/08/18 $D06 7.0.03: Change default unit from SYSALLDA
//*                              to SYSDA.
//*      2017/08/01 $D05 7.0.02: Support for translator history.
//*      2010/05/04 $D04 7.0.01: Support extended DIRENTRY display.
//*      2010/05/04 $D03 7.0.01: Support for MAP JCL.
//*      2010/05/04 $D02 7.0.01: Fix AMODE errors.
//*      2010/05/04 $D01 7.0.01: Refit to support MVT.
//*
//*     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:
//*
//*     MODULES
//*       PDS7003
//*
//*     MACROS
//*       PDS7003 (help member)
//*       ESTAE
//*       IHADVCT
//*       IHASDWA
//*       IKJEFFDF
//*       IKJEFFMT
//*       IKJTSMSG
//*       SETRP
//*       SGSTAR
//*       STARRTN
//*       STFSMODE
//*       STLINENO
//*       TRKCALC
//*
//*       Note:  All macros except the help member PDS7003 are
//*       installed in the private library SYS2.PDS.R703.ASM and
//*       will not be placed in system libraries.
//*
//*     DISK SPACE REQUIREMENTS:
//*        PDS requires disk space as follows:
//*
//*        component        DASD type   tracks
//*        ---------        ---------   ------
//*        PDS load module  3330        10
//*        PDS source       3330        155
//*        help member      3330        25
//*
//*     MAIN STORAGE REQUIREMENTS:
//*        PDS requires 85K for program code and at least 8K
//*        working storage.  The code is reentrant and refreshable,
//*        so it may be placed in the link pack area or time sharing
//*        link pack area if desired.
//*
//*     INSTALLATION INSTRUCTIONS:
//*       (A) Modify the symbolic parameter WKUNIT on the PROC
//*           statement if you need to use a DASD unit name other
//*           than SYSDA.
//*
//*       (B) Modify the ALLOC step to set your preferences for:
//*
//*          1) Target load library (default is SYS2.LINKLIB).  This
//*             should be a link list library, or a library in the
//*             STEPLIB concatention in the TSO procedure.
//*
//*          2) Target library for help member (default is SYS1.HELP).
//*
//*          3) Unit and volume for source data set (unit default
//*             is SYSDA, volume default is ASPSUP).  Data set
//*             SYS2.PDS.R703.ASM will be created on the designated
//*             volume.
//*
//*       (C) Modify PDS configuration options in the PDSGEN70 member
//*           if desired.  Options you might want to modify include:
//*
//*              &DAUNIT  - Unit name used by PDS for DASD allocation
//*                         (default is SYSDA).
//*
//*              &TUNIT   - Unit name for DASD utility data sets in JCL
//*                         generated by MAP (default is SYSDA).
//*
//*           For proper assembly, &MVT must remain set to 1 and
//*           &MVSLEV to "MVS038".
//*
//*       (D) Run the job.
//*
//*       (E) Verify successful completion.  All steps should complete
//*           with return code zero except the LKED step, which
//*           should produce a return code of 4 and msgIEW0461 due to
//*           the absence of optional user exits VSUBCMD and VTSOCMD.
//*
/*JOBPARM LINES=9999,LINECT=0
//*MAIN LINES=100
//*
//PDSINST  PROC WKUNIT='SYSDA'            <-- change if necessary
//*
//*-----------------------------------------------------------------***
//*     Define target data sets.  Modify values below as            ***
//*     appropriate for your installation.                          ***
//*-----------------------------------------------------------------***
//ALLOC   EXEC PGM=IEFBR14
//LOADLIB  DD DISP=SHR,DSN=SYS2.LINKLIB   <-- target load library
//HELP     DD DISP=SHR,DSN=SYS1.HELP      <-- target help library
//ASM      DD DISP=OLD,
//            VOL=SER=ASPSUP,             <-- target source volume
//            UNIT=SYSDA                  <-- target source unit
//*
//*-----------------------------------------------------------------***
//*     Delete any existing PDS source data set.                    ***
//*-----------------------------------------------------------------***
//CLEANUP EXEC PGM=IEFBR14
//SYSUT2   DD DSN=SYS2.PDS.R703.ASM,
//            DISP=(MOD,DELETE),
//            UNIT=&WKUNIT,
//            SPACE=(TRK,(0))
//*
//*-----------------------------------------------------------------***
//*     Create data set with PDS source and macros.                 ***
//*-----------------------------------------------------------------***
//UPDASM  EXEC PGM=IEBUPDTE,PARM=NEW
//SYSUT2   DD DSN=SYS2.PDS.R703.ASM,
//            DISP=(NEW,CATLG),
//            DCB=(DSORG=PO,RECFM=FB,LRECL=80,BLKSIZE=3120),
//            VOL=REF=*.ALLOC.ASM,
//            SPACE=(3120,(640,,5))
//SYSPRINT DD SYSOUT=A
//*
//*-----------------------------------------------------------------***
//*     Assemble PDS.                                               ***
//*-----------------------------------------------------------------***
//ASMPDS   EXEC PGM=IFOX00,PARM='DECK,NOOBJ,RENT',REGION=1024K
//SYSLIB   DD  DISP=SHR,DSN=SYS2.PDS.R703.ASM,DCB=BLKSIZE=6160
//         DD  DISP=SHR,DSN=SYS1.MACLIB
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=&WKUNIT,SPACE=(CYL,(15,8))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=&WKUNIT,SPACE=(CYL,(15,8))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=&WKUNIT,SPACE=(CYL,(10,5))
//SYSPRINT DD  SYSOUT=A
//SYSGO    DD  DUMMY
//SYSLIN   DD  DUMMY
//SYSPUNCH DD  DSN=&&OBJSET(PDS7003),UNIT=&WKUNIT,
//             SPACE=(TRK,(30,5,2)),DISP=(MOD,PASS)
//SYSIN    DD  DISP=SHR,DSN=SYS2.PDS.R703.ASM(PDS7003)
//*
//*-----------------------------------------------------------------***
//*     Assemble STAR.                                              ***
//*-----------------------------------------------------------------***
//ASMSTAR  EXEC PGM=IFOX00,PARM='DECK,NOOBJ,RENT',REGION=1024K
//SYSLIB   DD  DISP=SHR,DSN=SYS2.PDS.R703.ASM,DCB=BLKSIZE=6160
//         DD  DISP=SHR,DSN=SYS1.MACLIB
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=&WKUNIT,SPACE=(CYL,(10,5))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=&WKUNIT,SPACE=(CYL,(10,5))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=&WKUNIT,SPACE=(CYL,(10,5))
//SYSPRINT DD  SYSOUT=A
//SYSGO    DD  DUMMY
//SYSLIN   DD  DUMMY
//SYSPUNCH DD  DSN=&&OBJSET(STARRTN),UNIT=&WKUNIT,
//             SPACE=(TRK,(30,5,2)),DISP=(MOD,PASS)
//SYSIN    DD  DISP=SHR,DSN=SYS2.PDS.R703.ASM(STARRTN)
//*
//*-----------------------------------------------------------------***
//*     Link PDS.                                                   ***
//*-----------------------------------------------------------------***
//LKED   EXEC  PGM=IEWL,PARM='MAP,RENT,REUS,REFR,LET,NCAL',
//             COND=(0,LT),REGION=256K
//SYSPRINT DD  SYSOUT=A
//SYSPUNCH DD  DSN=&&OBJSET,DISP=(OLD,DELETE)
//SYS2LINK DD  DISP=SHR,DSN=SYS2.LINKLIB
//SYSLMOD  DD  DISP=SHR,DSN=*.ALLOC.LOADLIB
//SYSUT1   DD  UNIT=&WKUNIT,SPACE=(TRK,(30,5))
//SYSLIN   DD  DISP=SHR,DSN=SYS2.PDS.R703.ASM(LNK7003)
//*
//*-----------------------------------------------------------------***
//*     Add help member.                                            ***
//*-----------------------------------------------------------------***
//UPDHELP EXEC PGM=IEBUPDTE,PARM=NEW,REGION=128K,COND=(4,LT)
//SYSUT2   DD  DISP=SHR,DSN=*.ALLOC.HELP
//SYSPRINT DD  SYSOUT=A
/*
//          PEND
//*
//PDSINST  EXEC PDSINST
//UPDASM.SYSIN  DD  DATA,DLM='??'
./ ADD NAME=ESTAE
         MACRO ,
&NAME    ESTAE &EXIT,&TYPE,&PARAM=I,&XCTL=NO,&MF=I,&PURGE=,&ASYNCH=,   +
               &TCB=,&ESTAR=,&TERM=,&RECORD=,&BRANCH=,&SVEAREA=,       +
               &RELATED=,&KEY=
.*/*******************************************************************/
.*/*                                                                 */
.*/* Description - Extended Specify Task Abnormal Exit               */
.*/*                                                                 */
.*/* Function    - Map MVS ESTAE parameters to corresponding         */
.*/*               MVT STAE parameters, and issue the appropriate    */
.*/*               STAE macro.                                       */
.*/*                                                                 */
.*/*               The STAE macro instruction permits control to     */
.*/*               be returned to a user exit routine when a task    */
.*/*               is scheduled for ABEND.                           */
.*/*                                                                 */
.*/*               Note the following differences between STAE       */
.*/*               and MVS ESTAE:                                    */
.*/*                                                                 */
.*/*               o  The TERM keyword is not supported.  With       */
.*/*                  ESTAE, TERM allows a recovery routine to       */
.*/*                  receive control, for cleanup only, in the      */
.*/*                  event of an x22 ABEND.                         */
.*/*                                                                 */
.*/*               o  When a STAE exit requests retry, the STAE      */
.*/*                  environment is deleted.  If continued          */
.*/*                  STAE protection is desired, the retry          */
.*/*                  routine must issue a new STAE macro.  This     */
.*/*                  is unlike MVS ESTAE, where the ESTAE           */
.*/*                  environment remains in force even across       */
.*/*                  retry until cancelled.                         */
.*/*                                                                 */
.*/*               o  The STAE retry routine interface is            */
.*/*                  limited.  At entry to the retry routine,       */
.*/*                  R1 points to the 104-byte SDWA and R15         */
.*/*                  points to the retry routine entry address.     */
.*/*                  It is the user's responsibility to free the    */
.*/*                  SDWA and restore registers as required after   */
.*/*                  the retry routine receives control.            */
.*/*                                                                 */
.*/*******************************************************************/
&NAME    STAE  &EXIT,&TYPE,PARAM=&PARAM,MF=&MF,XCTL=&XCTL,             +
               PURGE=&PURGE,ASYNCH=&ASYNCH,TCB=&TCB
         MEND  ,
./ ADD NAME=IHASDWA
         MACRO                                                          00800000
         IHASDWA &DSECT=YES,&VRAMAP=NO                                  00810002
.*A000000                                                        Y02704 00850002
*                                                                    */ 00900002
*%SDWABSL1 : ;                                                          01312002
* /*******************************************************************/ 01312402
* /*                                                                 */ 01312802
* /* THE SDWA (SYSTEM DIAGNOSTIC WORK AREA) IS USED BY BOTH (E)STA   */ 01313202
* /* EXIT ROUTINES AND FRR ROUTINES AS THE COMMUNICATION AREA        */ 01313602
* /* BETWEEN THE RTM AND THE (E)STA OR FRR WHEN ERRORS OCCUR.        */ 01313702
* /* IT IS ALSO REFERRED TO AS THE RTCA (RECOVERY TERMINATION        */ 01313802
* /* COMMUNICATION AREA). IT CONTAINS DATA CONCERNING THE ORIGINAL   */ 01313902
* /* ERROR AND ALSO CONCERNING ACTIONS OF PREVIOUSLY ENTERED         */ 01315302
* /* RECOVERY ROUTINES.                                              */ 01317302
* /*                                                                 */ 01317502
* /* METHOD OF ACCESS                                                */ 01317902
* /* BAL                                                             */ 01318002
* /*             IHASDWA DSECT =  YES                                */ 01318102
* /*                              NO                                 */ 01318202
* /* DSECT = YES IS THE DEFAULT AND WILL PRODUCE THE SDWA            */ 01318302
* /*            AS A DSECT.                                          */ 01318502
* /* DSECT = NO WILL PRODUCE THE SDWA AS A CONTINUATION OF           */ 01318902
* /*            DEFINED STORAGE. (NO DSECT CARD PRODUCED)            */ 01319002
* /* PLS                                                             */ 01319402
* /*   IF MACRO VARIABLE %SDWA9999 IS NOT EQUAL TO ','               */ 01319602
* /*   AND %SDWALVL IS NULL, THE SDWA WILL BE INCLUDED               */ 01319702
* /*   AS A LEVEL 1 STRUCTURE BASED ON SDWAPTR.                      */ 01319802
* /*                                                                 */ 01325902
* /*   IF %SDWALVL IS SPECIFIED AS A NUMBER FROM 1 TO 4              */ 01327902
* /*   THE SDWA WILL BE A NON-BASED STRUCTURE WITH THE               */ 01329902
* /*   TOP LEVEL EQUAL TO %SDWALVL.                                  */ 01331902
* /*                                                                 */ 01332302
* /*   IF SDWA9999 IS EQUAL TO ',' THE SDWA WILL                     */ 01332702
* /*   TERMINATE WITH A COMMA RATHER THAN A                          */ 01332802
* /*   SEMI-COLON.                                                   */ 01332902
* /*                                                                 */ 01340702
* /*                                                                 */ 01342702
* /* MACMEAN SDWA MEANS SYSTEM DIAGNOSTIC WORK AREA                  */ 01348602
* /* MACCOMP Y-1 SC1C5/PZD81                                         */ 01356402
* /* MACSTAT Y-1 72318/Y02703,Y02704                                 */ 01364202
* /* UPDATED 9/23/76 SU33                                    @G33SPHW*/ 01364443
* /*                                                                 */ 01364602
* /*******************************************************************/ 01366202
*%       GOTO SDWABSL;  /*                                              01372002
         AIF ('&DSECT' EQ 'YES').SDWA001                                01379802
SDWA     DS   0D -                                                      01387602
         AGO  .SDWA002                                                  01395402
.SDWA001 ANOP                                                           01403202
SDWA     DSECT , -     SDWAPTR                                          01411002
.SDWA002 SPACE 2                                                        01418802
SDWAPARM DS    A -     PARAMETER LIST ADDRESS IF (E)STA MACRO           01426602
*                      SPECIFIED PARAM OPTION OR 0. FOR FRRS THIS       01434402
*                      IS THE ADDRESS OF THE 6 WORD PARM AREA           01436402
*                      RETURNED BY THE SETFRR MACRO WHEN THE            01438402
*                      PARMAD KEYWORD IS SPECIFIED ON THE SETFRR        01440402
SDWAFIOB DS    0A -    ADDRESS OF PURGE I/O REQUEST LIST (PIRL)         01442202
*                      OR 0 IF HALT I/O IS REQUESTED ON ENTRY TO        01450002
*                      RETRY ROUTINE FOR (E)STA.                        01460002
SDWAABCC DS    0BL4 -  ABEND COMPLETION CODE ON ENTRY TO EXIT ROUTINE.  01500002
SDWACMPF DS    B -     FLAG BITS IN COMPLETION CODE.                    01550002
SDWAREQ  EQU   X'80' - ON, DUMP TO BE GIVEN. SET IF DUMP                01560002
*                      REQUESTED BY ABEND, CALLRTM OR SETRP MACRO.      01610002
SDWASTEP EQU   X'40' - ON, JOBSTEP TO BE TERMINATED.                    07200000
*                      SET IF STEP OPTION SPECIFIED                     07250002
*                      ON ABEND MACRO.                                  07300002
SDWASTCC EQU   X'10' - ON, DON'T STORE COMPLETION CODE.                 07600000
*                      NOT USED IN OS/VS2 R2.                           08000002
SDWACMPC DS    BL3 -   SYSTEM COMPLETION CODE (FIRST 12 BITS) AND       08400000
*                      USER COMPLETION CODE (SECOND 12 BITS).           08800000
SDWACTL1 DS    0CL8 -  BC MODE PSW AT TIME OF ERROR                     09200002
*                      NOT INITIALIZED FOR FRRS.                        09250002
SDWACMKA DS    B -     CHANNEL INTERRUPT MASKS.                         09600000
SDWAIOA  EQU   X'FE' - I/O INTERRUPTS (ALL ZEROS OR ALL ONES).          10000000
SDWAEXTA EQU   X'01' - EXTERNAL INTERRUPT.                              10400000
SDWAMWPA DS    B -     PSW KEY AND 'M-W-P'.                             10800000
SDWAKEYA EQU   X'F0' - PSW KEY.                                         11200000
SDWAMCKA EQU   X'04' - MACHINE CHECK INTERRUPT.                         11600000
SDWAWATA EQU   X'02' - WAIT STATE.                                      12000000
SDWASPVA EQU   X'01' - SUPERVISOR/PROBLEM-PROGRAM MODE.                 12400000
SDWAINTA DS    CL2 -   INTERRUPT CODE (LAST 2 BYTES OF INTERRUPT        12800000
*                      CODE IF I/O INTERRUPT).                          13200000
SDWAPMKA DS    B -     INSTRUCTION LENGTH CODE, CONDITION CODE,         13600000
*                      AND PROGRAM MASKS.                               14000000
SDWAILA  EQU   X'C0' - INSTRUCTION LENGTH CODE.                         14400000
SDWACCA  EQU   X'30' - LAST CONDITION CODE.                             14800000
SDWAFPA  EQU   X'08' - FIXED-POINT OVERFLOW.                            15200000
SDWADOA  EQU   X'04' - DECIMAL OVERFLOW.                                15600000
SDWAEUA  EQU   X'02' - EXPONENT UNDERFLOW.                              16000000
SDWASGA  EQU   X'01' - SIGNIFICANCE.                                    16400000
SDWANXTA DS    AL3 -   ADDRESS OF NEXT INSTRUCTION TO BE EXECUTED.      16800000
*                                                                       17200000
SDWACTL2 DS    0CL8 -  BC MODE PSW FROM LAST PRB ON RB CHAIN.           17600002
*                      ZERO FOR FRRS.                                   17650002
SDWACMKP DS    B -     CHANNEL INTERRUPT MASKS.                         18000000
SDWAIOP  EQU   X'FE' - I/O INTERRUPTS (ALL ZEROS OR ALL ONES).          18400000
SDWAEXTP EQU   X'01' - EXTERNAL INTERRUPT.                              18800000
SDWAMWPP DS    B -     PSW KEY AND 'M-W-P'.                             19200000
SDWAKEYP EQU   X'F0' - PSW KEY.                                         19600000
SDWAMCKP EQU   X'04' - MACHINE CHECK INTERRUPT.                         20000000
SDWAWATP EQU   X'02' - WAIT STATE.                                      20400000
SDWASPVP EQU   X'01' - SUPERVISOR/PROBLEM-PROGRAM MODE.                 20800000
SDWAINTP DS    CL2 -   INTERRUPT CODE (LAST 2 BYTES OF INTERRUPT        21200000
*                      CODE IF I/O INTERRUPT).                          21600000
SDWAPMKP DS    B -     INSTRUCTION LENGTH CODE, CONDITION CODE,         22000000
*                      AND PROGRAM MASKS.                               22400000
SDWAILP  EQU   X'C0' - INSTRUCTION LENGTH CODE.                         22800000
SDWACCP  EQU   X'30' - LAST CONDITION CODE.                             23200000
SDWAFPP  EQU   X'08' - FIXED-POINT OVERFLOW.                            23600000
SDWADOP  EQU   X'04' - DECIMAL OVERFLOW.                                24000000
SDWAEUP  EQU   X'02' - EXPONENT UNDERFLOW.                              24400000
SDWASGP  EQU   X'01' - SIGNIFICANCE.                                    24800000
SDWANXTP DS    AL3 -   ADDRESS OF NEXT INSTRUCTION TO BE EXECUTED.      25200000
*                                                                       25600000
SDWAGRSV DS    0CL64 - GENERAL PURPOSE REGISTERS AT TIME OF ERROR       26000002
SDWAGR00 DS    F -     GPR 0.                                           26400000
SDWAGR01 DS    F -     GPR 1.                                           26800000
SDWAGR02 DS    F -     GPR 2.                                           27200000
SDWAGR03 DS    F -     GPR 3.                                           27600000
SDWAGR04 DS    F -     GPR 4.                                           28000000
SDWAGR05 DS    F -     GPR 5.                                           28400000
SDWAGR06 DS    F -     GPR 6.                                           28800000
SDWAGR07 DS    F -     GPR 7.                                           29200000
SDWAGR08 DS    F -     GPR 8.                                           29600000
SDWAGR09 DS    F -     GPR 9.                                           30000000
SDWAGR10 DS    F -     GPR 10.                                          30400000
SDWAGR11 DS    F -     GPR 11.                                          30800000
SDWAGR12 DS    F -     GPR 12.                                          31200000
SDWAGR13 DS    F -     GPR 13.                                          31600000
SDWAGR14 DS    F -     GPR 14.                                          32000000
SDWAGR15 DS    F -     GPR 15.                                          32400000
*                                                                       32800000
SDWANAME DS    0CL8 -  IF PROBLEM PROGRAM MODE NAME                     33200002
*                      OF ABENDING PROGRAM, OR ZERO                     33600002
*                      IF NO NAME IS AVAILABLE.                         33650002
*                      ZERO IF NOT RUNNING UNDER AN RB                  33700002
SDWARBAD DS    A -     RB ADDRESS OF ABENDING PROGRAM (IF SUPERVISOR    34000000
*                      MODE PROGRAM RUNNING UNDER AN RB)                34400002
         DS    XL4 -   CONTAINS ZEROS IF SUPERVISOR MODE PROGRAM        34800002
*                      RUNNING UNDER AN RB OR IF PROGRAM NOT            34850002
*                      RUNNING UNDER AN RB                              34900002
SDWAEPA  DS    A -     ENTRY POINT ADDRESS OF ABENDING PROGRAM.         35600002
*                      ZERO IF NOT RUNNING UNDER AN RB                  35650002
SDWAIOBR DS    A -     POINTER TO SDWAFIOB FIELD,                       36000002
*                      OR 0 IF NO RETRY, OR 0 IF HALT I/O               36400002
*                      IS REQUESTED FOR (E)STA EXITS.                   36402002
*                      ZERO FOR FRRS                           ICB377   36404002
**** END OF MVT SDWA ****
SDWAEND  EQU  * -      END OF SDWA
SDWALEN  EQU  SDWAEND-SDWA -  LENGTH OF SDWA                            37575802
         MEND  ,
./ ADD NAME=IHADVCT
         MACRO
         IHADVCT   &DSECT=YES
.* /* START OF SPECIFICATIONS ****
.*
.*01  MODULE-NAME = IHADVCT
.*
.*01  COPYRIGHT = NONE
.*
.*01  STATUS = OS/VS2 RELEASE 2, LEVEL 0
.*
.*01  CHANGE-ACTIVITY = NONE
.*
.*01  DESCRIPTIVE-NAME = DEVICE CHARACTERISTICS TABLE MAPPING
.*
.*01  FUNCTION = THIS TABLE DESCRIBES PHYSICAL ATTRIBUTES OF EACH DASD
.*    DEVICE WHICH HAS BEEN SYSGENED
.*
.*01  NOTES = THE TABLE IS POINTED TO BY CVTZDTAB.
.*
.*01  MODULE-TYPE = MACRO
.*02    PROCESSOR = ASSEMBLER-370R
.*
.*02    MACRO-SIZE = 200 STATEMENTS
.*
.**** END OF SPECIFICATIONS ***/
* /* MACCOMP Y-2 SC1D0/SJD48                                    */
* /* MACSTAT Y-2 73226/021160                                   */
*/***************************************************************/
*/*             DEVICE CHARACTERISTICS TABLE                    */
*/***************************************************************/
*/*                                                             */
*/*     THIS TABLE MAY BE USED TO FIND THE CHARACTERISTICS      */
*/*     OF DIRECT ACCESS DEVICES.  THE APPLICABLE DEVICES ARE   */
*/*     THOSE CONTAINING UCBDACC IN UCBTBYT3 (SEE IEFUCBOB).    */
*/*                                                             */
*/*     THE TABLE IS COMPOSED OF AN INDEX FOLLOWED BY ONE       */
*/*     ENTRY FOR EACH DASD DEVICE WHICH HAS BEEN SYSGENED      */
*/*                                                             */
*/*     FOR ASSEMBLER USE, TWO SEPARATE DSECTS ARE PROVIDED.    */
*/*     A USING ON DVCTI GIVES ADDRESSIBILITY TO THE INDEX,     */
*/*     AND A USING ON DVCT GIVES ADDRESSIBILITY TO AN ENTRY.   */
*/*     SPECIFYING DSECT=NO SUPPRESSES THE INDEX AND PROVIDES   */
*/*     AN ENTRY DESCRIPTION WITHOUT A DSECT STATEMENT          */
*/*                                                             */
*/*     THE DEFAULT SETTINGS WILL PROVIDE ADDRESSIBILITY TO     */
*/*     ALL FIELDS, BUT DEPEND ON CVT AND UCB ADDRESSIBILITY.   */
*/*                                                             */
*/*               FORMAT OF EACH ENTRY                          */
*/*         _____________________________________________       */
*/*   0(00) |                     |                     |       */
*/*         |       DVCCYL        |       DVCTRK        |       */
*/*         |_____________________|_____________________|       */
*/*   4(04) |                     |       DVCOVHD       |       */
*/*         |       DVCTRKLN      | DVCOVNLB | DVCOVLB  |       */
*/*         |_____________________|__________|__________|       */
*/*   8(08) |          |          |                     |       */
*/*         | DVCOVNK  | DVCFLAGS |       DVCTOL        |       */
*/*         |__________|__________|_____________________|       */
*/*  12(0C) |                     |______________________       */
*/*         |       DVCALT        |                     |       */
*/*         |_____________________|       DVCOVR0       |  RPS  */
*/*         ______________________|_____________________|  ONLY */
*/*  16(10) |          |          |                             */
*/*         | DVCSECT  | DVCSECTD |                             */
*/*         |__________|__________|                             */
*/***************************************************************/
*%/*
DVCTI    DSECT ,              INDEX TO DVCT
*              THIS INDEX IS LOCATED FROM CVTZDTAB.
*              THE PROPER ENTRY IS FOUND BY ADDING THE LOW ORDER
*              4 BITS OF UCBTYP TO THE ADDRESS IN CVTZDTAB.
DVCTYPMK EQU   15                       TYPICAL USAGE:
*              LA    RWRK,DVCTYPMK      MASK FOR UNIT TYPE NUMBER
*              N     RWRK,UCBTYP        PICK UP UNIT TYPE NUMBER
*              IC    RWRK,DVCTIOFF(RWRK)  PICK UP OFFSET
DVCTIOFF DS    AL1                      OFFSET TO DVCT ENTRY
******************************************************************
         SPACE 3
DVCT     DSECT , -                      FORMAT OF DVCT ENTRY
*              THE ENTRY IS LOCATED BY ADDING DVCTIOFF TO CVTZDTAB
*
DVCCYL   DS    H -                      PHYS NO. CYL PER VOLUME
DVCTRK   DS    H -                      NO. TRACKS PER CYLINDER
DVCTRKLN DS    H -                      NO. OF BYTES PER TRACK
*
DVCOVHD  DS    0H -                     BLOCK OVERHEAD IF DVC2BOV=1
*              USE FOLLOWING TWO CONSTANTS IF DVC2BOV=0
DVCOVNLB DS    XL1 -                    OVERHEAD NOT LAST BLOCK
DVCOVLB  DS    XL1 -                    OVERHEAD LAST BLOCK
*
DVCOVNK  DS    XL1 -                    OVERHEAD DECREMENT
*                                       NOT KEYED
*
DVCFLAGS DS    BL1 -
DVC2BOV  EQU   X'08' -                  IF 1, USE DVCOVHD
*                                       IF 0, USE DVCOVNLB,DVCOVLB
DVCFTOL  EQU   X'01' -                  IF 1, APPLY TOLERANCE
*                                             FACTOR
*
DVCTOL   DS    H -                      TOLERANCE FACTOR
*              APPLY TOLERANCE FACTOR AS FOLLOWS:
*              1. ADD BLOCKSIZE AND KEYLENGTH
*              2. MULTIPLY BY DVCTOL
*              3. SHIFT RIGHT DVCTSHFT BITS
*              4. ADD APPROPRIATE OVERHEADS
DVCTSHFT EQU   9 -                      SHIFT TO DIVIDE BY 512
*
DVCALT   DS    H -                      NUMBER ALTERNATE TRACKS
*                                       PER VOLUME
*
DVCENTLG EQU   *-DVCT -                 BASIC SIZE OF DEVICE TABLE
*                                       ENTRY, NOT INCLUDING ADD'L
*                                       CHARACTERISTICS FOR RPS
******************************************************************
*              THE FOLLOWING SECTION OF THE TABLE IS             *
*              PRESENT ONLY FOR RPS DEVICES--TEST UCBTBYT2       *
*              FOR UCB2OPT3                                      *
******************************************************************
DVCRPS   DS    0CL4 -                   RPS SECTION
DVCOVR0  DS    H -                      OVERHEAD BYTES FOR
*                                       RECORD 0
DVCSECT  DS    XL1 -                    NUMBER SECTORS IN FULL
*                                       TRACK
DVCSECTD DS    XL1 -                    NUMBER DATA SECTORS
*
*              END OF DVCT
         MEND
./ ADD NAME=IKJEFFDF
         MACRO                                                          01200002
         IKJEFFDF &DFDSECT=NO,&DFDSEC2=NO                               01800000
.*A-000000-999999                                               Y02993  02400002
.*C-REL. 4 UPDATE CHANGES FOR LENGTH OF POSSIBLE VALUES        @Z40NQKQ 02450000
.*C-IDNUM AND ALTERNATE NAME FOR IDNUM                         @Z40NQKQ 02500000
.*C-TWO BUFFERS FOR EXTRACTING MESSAGES                        @Z40GQKU 02550000
.*C198000                                                     @ZA61225  02600000
         AGO .DFBAL01                  **SKIP PLS MACRO STATEMENT ** */ 03000002
*%DFPLS1: ;                            /* BAL/PLS HEADER                03600002
.DFBAL01 ANOP                                                        */ 04200002
*/********************************************************************/ 04800002
*/*                                                                  */ 05400002
*/* *** IKJEFFDF ***     LEVEL=06/19/75     OS/VS2 RELEASE 4.0       */ 06000000
*/*                                                          @Z40NQKJ*/ 06050000
*/* DESCRIPTION - BILINGUAL MAPPING MACRO FOR IKJEFF18 PARAMETER     */ 07200002
*/*               LIST (DYNAMIC ALLOCATION SVC99 FAILURES OR         */ 07800002
*/*               DAIR FAILURES)                                     */ 08400002
*/*                                                                  */ 09000002
*/* FUNCTION   - THE PARAMETER LIST IS THE INTERFACE                 */ 09600002
*/*              TO IKJEFF18 FROM CALLER WITH AN ERROR RETURN        */ 10200002
*/*              FROM SVC99 OR DAIR                                  */ 10800002
*/*                                                                  */ 11400002
*/*              REGISTER 1 CONTAINS THE ADDRESS OF DFPARMS          */ 12000002
*/*              REGISTER 15 WILL CONTAIN IKJEFF18'S RETURN CODE     */ 12600002
*/*                          TO THE CALLER (0 IF MESSAGE(S)          */ 13200002
*/*                          ISSUED SUCCESSFULLY)                    */ 13800002
*/*                                                                  */ 14400002
*/* METHOD OF ACCESS                                                 */ 15000002
*/*      PL/S   - %DFTYPE='BDY(WORD)'- - - IF DON'T WANT BASED       */ 15600002
*/*                                        (THIS IS THE DEFAULT)     */ 16200002
*/*               %DFTYPE2='BASED(DFBUFP)' IF WANT TO HAVE   @Z40GQKU*/ 16250000
*/*                                        BASED (THIS IS THE@Z40GQKU*/ 16300000
*/*                                        DEFAULT)          @Z40GQKU*/ 16350000
*/*               %INCLUDE SYSLIB(IKJEFFDF)                          */ 17400002
*/*                                                                  */ 18000002
*/*      BAL    - DFDSECT=YES  IF DON'T WANT TO GET CORE             */ 18600002
*/*                 THEN CODE      LA    REG,MYDFCORE  *CALLER AREA  */ 19200002
*/*                               USING DFDSECTD,REG         @ZA61225*/ 19800000
*/*               DFDSECT=NO   IS THE DEFAULT.                       */ 20400002
*/*               DFDSEC2=YES  IF DON'T WANT TO GET CORE     @Z40GQKU*/ 20450000
*/*                 THEN CODE      LA    REG,MYDFCORE        @Z40GQKU*/ 20500000
*/*                                           *CALLER AREA   @Z40GQKU*/ 20550000
*/*                                USING DFDSECT2,REG        @Z40GQKU*/ 20600000
*/*               DFDSEC2=NO   THIS IS THE DEFAULT           @Z40GQKU*/ 20650000
*/*                                                                  */ 21000002
*/*               IKJEFFDF                                           */ 21300002
*/*                                                                  */ 21600002
*/* NOTES       - IKJEFF18 WILL INDEX INTO THE S99RB FOR SVC 99      */ 22200002
*/*               ERRORS AND THE DAIR PARAMETER BLOCK FOR DAIR       */ 22800002
*/*               ERRORS TO OBTAIN DSNAME, DDNAME, VOLSER,ETC,       */ 23400002
*/*               INFORMATION WHICH MAY BE INSERTED INTO THE         */ 24000002
*/*               OUTPUT MESSAGE                                     */ 24600002
*/*                                                                  */ 25200002
*/* F.E.'S      - MICROFICHE LISTING    IKJEFFDF                     */ 25800002
*/*                                                                  */ 26400002
*/********************************************************************/ 27000002
*        %GOTO DFPLS2;                 /* BAL ONLY FOLLOWS              28200002
.*       SET UP DSECT CARD IF DFDSECT-YES ON MACRO                      28800002
         AIF   ('&DFDSECT' EQ 'NO').DFBAL1                              29400002
DFDSECTD DSECT                                                          30000002
.DFBAL1  ANOP                          **MACRO STATEMENT**              30600002
         DS    0F                                                       31200002
DFPARMS  EQU   *                                                        31800002
DFS99RBP DS    A                      *ADDRESS OF THE FAILING SVC 99    32400000
*                                      REQUEST BLOCK FOR SVC 99 ERRORS  33000002
DFDAPLP  EQU   DFS99RBP               *ADDRESS OF THE FAILING DAIR      33600000
*                                      PARAMETER LIST FOR DAIR ERRORS   34200002
DFRCP    DS    A                      *ADDRESS OF A FOUR BYTE STORAGE   34800000
*                                      AREA CONTAINING THE SVC 99 OR    35400002
*                                      THE DAIR REGISTER 15 RETURN CODE 36000002
DFJEFF02 DS    A                      *ADDRESS OF A FOUR BYTE AREA      36600000
*                                      WHICH CONTAINS EITHER THE ENTRY  37200002
*                                      POINT ADDRESS OF IKJEFF02        37800002
*                                      (MESSAGE WRITER FOR IKJEFF18) OR 38400002
*                                      ZEROES IF ENTRY ADDRESS IS       39000002
*                                      UNKNOWN                          39600002
DFIDP    DS    A                      *ADDRESS OF A TWO BYTE AREA       40200000
*                                      CONTAINING A CALLER IDENTIFIER   40800000
*                                      NUMBER DESCRIBED BELOW  @Z40GQKU 41400000
DFCPPLP  DS    A                      *ADDRESS OF THE CPPL - THIS IS    42000000
*                                      NEEDED ONLY WHEN IKJEFF18 IS     46200002
*                                      CALLED WITH AN SVC 99 ERROR      46800002
DFBUFP   DS    A                      *ADDRESS OF DFBUFS IF DFBUFSW OR  47400000
*                                      DFBUFS2 ON              @Z40GQKU 47450000
DFLEN    EQU   *-DFPARMS                                                48600002
**********************************************************************  49200002
* POSSIBLE VALUES FOR THE CALLER IDENTIFIER POINTED TO BY DFIDP         49800002
**********************************************************************  50400002
*                                                                       51000002
DFSVC99  EQU   50                      GENERAL CALLER WITH AN SVC 99    51600002
*                                      ERROR                            51900002
DFFREE   EQU   51                      FREE COMMAND WITH AN SVC 99      52200002
*                                      ERROR                            52500002
DFDAIR   EQU   1                       GENERAL CALLER WITH A DAIR ERROR 52800002
*                                                                       52880002
DFWTP    EQU   X'80'                   THE HIGH ORDER BIT ON IN THE     52960002
*                                      CALLER IDENTIFIER INDICATES      53040002
*                                      A WRITE TO PROGRAMMER IS         53120002
*                                      NEEDED INSTEAD OF THE DEFAULT    53200002
*                                      PUTLINE                          53280002
DFBUFSW  EQU   X'40'                   ON IF CALLER WANTS      @Z40GQKU 53284000
*                                      MESSAGE TEXT RETURNED IN@Z40GQKU 53288000
*                                      BUFFERS INSTEAD OF      @Z40GQKU 53292000
*                                      DEFAULT PUTLINE         @Z40GQKU 53296000
DFBUFS2  EQU   X'20'                   ON IF WANT DFBUFSW      @Z40GQKU 53300000
*                                      FUNCTION PLUS PUTLINE   @Z40GQKU 53304000
*                                      (OR WTP)                @Z40GQKU 53308000
*/***********************************************************@Z40GQKU*/ 53312000
*/* MAP OF CALLER-SUPPLIED BUFFERS POINTED TO BY DFBUFP      @Z40GQKU*/ 53316000
*/***********************************************************@Z40GQKU*/ 53320000
.*       SET UP DSECT CARD IF DFDSEC2-YES ON MACRO             @Z40GQKU 53324000
         AIF   ('&DFDSEC2' EQ 'NO').DFBAL2                     @Z40GQKU 53328000
DFDSECT2 DSECT                                                 @Z40GQKU 53332000
.DFBAL2  ANOP                          **MACRO STATEMENT**     @Z40GQKU 53336000
DFBUFS   DS    0F                      (NEED NOT INITIALIZE)   @Z40GQKU 53340000
DFBUF1   EQU   *                                               @Z40GQKU 53344000
DFBUFL1  DS    FL2                     LENGTH OF AREA USED IN  @Z40GQKU 53348000
*                                      DFBUF1 (INCLUDES DFBUFL1@Z40GQKU 53352000
*                                      AND DFBUFO2 FIELDS)     @Z40GQKU 53356000
DFBUFO1  DS    FL2                     OFFSET IS ZERO ON RETURN@Z40GQKU 53360000
DFBUFT1  DS    CL251                   TEXT OF FIRST LEVEL     @Z40GQKU 53364000
*                                      MESSAGE                 @Z40GQKU 53368000
DFBUF2   DS    0H                                              @Z40GQKU 53372000
DFBUFL2  DS    FL2                     LENGTH (INCLUDES LLOO   @Z40GQKU 53376000
*                                      FIELDS)                 @Z40GQKU 53380000
DFBUFO2  DS    FL2                     OFFSET                  @Z40GQKU 53384000
DFBUFT2  DS    CL251                   TEXT OF SECOND LEVEL    @Z40GQKU 53388000
*                                      MESSAGE                 @Z40GQKU 53392000
DFLEN2   EQU   *-DFBUFS                LENGTH OF BUFFER PARMS  @Z40GQKU 53396000
**********************************************************************  53400002
* END OF IKJEFFDF MAPPING MACRO                                         54000002
**********************************************************************  54600002
         MEND                                                      , */ 55200002
./ ADD NAME=IKJEFFMT
*        %GOTO MTPLS1;              /* BILINGUAL MAPPING
         MACRO
         IKJEFFMT &MTDSECT=NO,&MTNINST=4
         AGO .MTBAL01              ** SKIP PLS MACRO STATEMENT **   */
*%MTPLS1: ;                        /* BAL/PLS HEADER
.MTBAL01  ANOP                                                       */
*/********************************************************************/
*/*                                                                  */
*/* *** IKJEFFMT ***     MVS 3.8 macro reworked for MVT 21.8         */
*/*                                                                  */
*/* Description - Mapping macro for parameter list to IKJEFF02       */
*/*               (TSO message issuer service routine).              */
*/*                                                                  */
*/* Function    - The parameter list identifies a message, describes */
*/*               insert(s) for the message, and indicates whether   */
*/*               to issue the message as a PUTLINE, PUTGET, WTO,    */
*/*               or a write to programmer.                          */
*/*                                                                  */
*/*               The parameter list also points to a message        */
*/*               CSECT containing the message's text.  The          */
*/*               IKJTSMSG macro is used to generate the             */
*/*               necessary DCs for the text and the offsets         */
*/*               to inserts in the message.  The last entry in      */
*/*               the CSECT must be an IKJTSMSG macro with no        */
*/*               operands.                                          */
*/*                                                                  */
*/*               Register 1 -> MTPARML = MSGTABLE parmlist          */
*/*               Register 15 will contain IKJEFF02's return code    */
*/*                           to the caller (0 if successful,        */
*/*                           76 if parameter list error (message is */
*/*                           also issued), or error return code     */
*/*                           from PUTLINE or PUTGET)                */
*/*                                                                  */
*/********************************************************************/
*        %GOTO MTPLS2;              /* BAL ONLY FOLLOWS
.*       SET UP DSECT CARD IF MTDSECT=YES ON MACRO
         AIF   ('&MTDSECT' EQ 'NO').MTBAL1  **MACRO STATEMENT**
MTDSECTD DSECT
.MTBAL1  ANOP             **MACRO STATEMENT**
         DS    0F
MTPARML  EQU   * -        .<<PARAMETER LIST TO IKJEFF02>>
*                         .   UNUSED NON-INSERT FIELDS MUST BE ZEROED
LISTPTR  DS    0A -       .ALTERNATE NAME FOR MTPLPTR
MTPLPTR  DC    A(0) -     .LISTPTR = POINTER TO MESSAGE DESCRIPTION
*                         .   SECTION OF PARAMETER LIST
TMCTPTR  DS    0A -       .ALTERNATE NAME FOR MTCPPLP
MTCPPLP  DC    A(0) -     .TMCTPTR = POINTER TO TMP'S CPPL CONTROL
*                         .   BLOCK (REQUIRED FOR PUTLINE OR PUTGET)
ECBPTR   DS    0A -       .ALTERNATE NAME FOR MTECBP
MTECBP   DC    A(0) -     .ECBPTR = OPTIONAL PUTGET/PUTLINE ECB POINTER
***********************************************************************
*  IKJEFFMT - MESSAGE DESCRIPTION SECTION OF PARAMETER LIST           *
***********************************************************************
MTCSECTP DC    A(0) -     .MSGCSECT = POINTER TO CSECT WITH CALLER'S
*                         .   MESSAGE TEXTS, BUILT WITH IKJTSMSG MACRO
SW       DS    0B -       .ALTERNATE NAME FOR MTSW1
MTSW1    DC    B'0' -     .SW = BYTE OF SWITCHES
MTNOIDSW EQU   X'80' -    -- PRINTING DATA;
*                            THE MESSAGE IS AN INFORMATION MESSAGE.
*                            THERE IS NO MESSAGE IDENTIFIER.
MTPUTLSW EQU   X'40' -    -- ISSUE MESSAGE AS PUTLINE, NOT PUTGET;
*                            RELATED MESSAGES ARE TO BE PUT OUT IN
*                            REVERSE ORDER, STARTING WITH THE LAST
*                            ONE IN THE CHAIN.  NO REPLY IS CALLED
*                            FOR IN THIS CASE.
MTWTOSW  EQU   X'20' -    -- ISSUE MESSAGE AS A WTO;
*                            IN THIS CASE, THE TMCT POINTER SHOULD
*                            POINT TO THE CONSOLE ID.  SECONDARY
*                            LEVELS ARE NOT CHECKED FOR.
MTHEXSW  EQU   X'10' -    -- TRANSLATE NUMERIC INSERTS TO PRINTABLE HEX
*---------------------------------------------------------------------*
*        Following MTSW1 flags defined in MVS 3.8 are not             *
*        supported in MVT.                                            *
*---------------------------------------------------------------------*
MTKEY1SW EQU   X'08' -    -- DO MODESET TO KEY 0 BEFORE PUTLINE/PUTGET
MTJOBISW EQU   X'04'      -- COMPRESS BLANKS OUT OF XX(YY) INSERT
MTWTPSW  EQU   X'02'      -- ISSUE MESSAGE AS A WRITE TO PROGRAMMER
MTNHEXSW EQU   X'01'      -- TRANSLATE ALL NUMERIC INSERTS TO DECIMAL
*---------------------------------------------------------------------*
*        End of MTSW1 flags not supported in MVT.                     *
*---------------------------------------------------------------------*
RETMSG   DS    0AL3 -     .ALTERNATE NAME FOR MTREPLYP
MTREPLYP DC    AL3(0)     .RETMSG = POINTER TO REPLY FROM PUTGET,
*                         .   IN THE FORMAT LL-TEXT, WHERE LL IS
*                         .   A TWO-BYTE LENGTH FIELD WITH LENGTH OF
*                         .   THE REPLY (INCLUDING LENGTH OF LL FIELD).
*                         .   IKJEFF02 OBTAINS THIS BUFFER IN SUBPOOL 0
*                         .   AND IT MAY BE FREED BY THE CALLER.
*                         .   THE REPLY IS CONVERTED TO UPPER CASE.
MSGID    DS    0CL4 -     .ALTERNATE NAME FOR MTMSGID
MTMSGID  DC    C'XXXX'    .MSGID = ID USED TO SEARCH FOR MESSAGE
*                         .   TEXT IN THE MESSAGE CSECT
L1       DS    0AL1 -     .ALTERNATE NAME FOR MTLEN
MTLEN    DS    0AL1       .LENGTH OF AN INSERT FOR THE MESSAGE.
MTHIGHL  DS    BL1        .HIGH-ORDER BIT ON IF TRANSLATE
VAR1     DS    0AL3 -     .ALTERNATE NAME FOR MTADDR
MTADDR   DS    AL3        .ADDRESS OF AN INSERT FOR THE MESSAGE.
L2       DS    0AL1 -     .ALTERNATE NAME FOR MTLEN2
MTLEN2   DS    0AL1       .LENGTH OF AN INSERT FOR THE MESSAGE.
MTHIGHL2 DS    BL1        .HIGH-ORDER BIT ON IF TRANSLATE
VAR2     DS    0AL3 -     .ALTERNATE NAME FOR MTADDR2
MTADDR2  DS    AL3        .ADDRESS OF AN INSERT FOR THE MESSAGE.
L3       DS    0AL1 -     .ALTERNATE NAME FOR MTLEN3
MTLEN3   DS    0AL1       .LENGTH OF AN INSERT FOR THE MESSAGE.
MTHIGHL3 DS    BL1        .HIGH-ORDER BIT ON IF TRANSLATE
VAR3     DS    0AL3 -     .ALTERNATE NAME FOR MTADDR3
MTADDR3  DS    AL3        .ADDRESS OF AN INSERT FOR THE MESSAGE.
L4       DS    0AL1 -     .ALTERNATE NAME FOR MTLEN4
MTLEN4   DS    0AL1       .LENGTH OF AN INSERT FOR THE MESSAGE.
MTHIGHL4 DS    BL1        .HIGH-ORDER BIT ON IF TRANSLATE
VAR4     DS    0AL3 -     .ALTERNATE NAME FOR MTADDR4
MTADDR4  DS    AL3        .ADDRESS OF AN INSERT FOR THE MESSAGE.
         DS    A
         MEND                                                      , */
*%MTPLS2: ;
* /* MVT PRIVATE MACRO PL/S MAPPING FOR IKJEFFMT */
*        DCL  1  MSGTABLE BASED (MSGPTR),    /* MESSAGE TABLE    */     04000020
*                2 LISTPTR  PTR (31),        /*   TO LIST        */     08000020
*                2 TMCTPTR  PTR (31),        /*   TO TMCT        */     12000020
*                2 ECBPTR   PTR (31),        /*   TO COMM ECB    */     16000020
*                2 MSGCSECT PTR (31),        /* LIST - MSG CSECT */     20000020
*                2 SW       PTR  (8),        /*   SW             */     24000020
*                2 RETMSG   PTR (24),        /*   RETURN MSG     */     28000020
*                2 MSGID CHAR (4),           /*   MESSAGE ID     */     32000020
*                2 L1       PTR  (8),        /*   LEN            */     36000020
*                  3 HIGHL1 BIT (1),                                    40000020
*                2 VAR1     PTR (24),        /*     VARIABLE     */     44000020
*                2 L2       PTR  (8),        /*   LEN            */     48000020
*                  3 HIGHL2 BIT (1),                                    52000020
*                2 VAR2     PTR (24),        /*     VARIABLE     */     56000020
*                2 L3 PTR (8),                                          56011020
*                  3 HIGHL3 BIT (1),                                    56020020
*                2 VAR3 PTR (24),                                       56030020
*                2 L4 PTR (8),                                          56040020
*                  3 HIGHL4 BIT (1),                                    56050020
*                2 VAR4 PTR (24),                                       56060020
*                2 MSGRTN   PTR (31);        /* MSG RTN ADDR     */     60000020
*        DCL 1 RET BDY (WORD) BASED (RETMSG),  /* RETURN MESSAGE */     64000020
*                2 RETSIZE FIXED (15),         /*   SIZE         */     68000020
*                2 RETCHAR CHAR (18);          /*   RETURN TEXT  */     72000020
*        DCL MSGTMCT BASED (TMCTPTR);          /* TMCT FOR MSG RTN */   76000020
*        DCL MSGECB BASED (ECBPTR);            /* ECB FOR MSG RTN  */   80000020
./ ADD NAME=IKJTSMSG
         MACRO                                                          02000020
&MESS    IKJTSMSG  &PARTS,&ID,&SECID                                    04000020
         LCLA  &A                                                       06000020
         LCLA  &B                                                       08000020
         LCLA  &C                                                       10000020
         LCLC  &LP                                                      12000020
         LCLC  &LEN                                                     14000020
         SPACE 2                                                        16000020
&A       SETA  1                                                        18000020
&B       SETA  N'&PARTS                                                 20000020
&LEN     SETC  'A'.'&SYSNDX'                                            22000020
         AIF   (T'&ID NE 'O').PRID                                      24000020
         AIF   (T'&PARTS NE 'O').ID                                     26000020
         DC    CL4'    '           INDICATES END OF MSG CSECT           28000020
         AGO   .OUT                                                     30000020
.ID      ANOP                                                           32000020
         MNOTE 8,'SPECIFY MESSAGE ID'                                   34000020
.PRID    ANOP                                                           36000020
&MESS    DC    CL4'&ID'            ID                                   38000020
         AIF   (T'&SECID NE 'O').SECOND                                 40000020
         DC    CL4'    '           NO FOLLOWING MESSAGE                 42000020
         AGO   .NB                                                      44000020
.SECOND  ANOP                                                           46000020
         DC    CL4'&SECID'         ID OF FOLLOWING MSG                  48000020
.NB      ANOP                                                           50000020
         DC    AL2(&LEN-*+8)       TOTAL LENGTH                         52000020
         DC    AL1(&B)             NB OF PARTS TO MSG                   54000020
.LOOP    ANOP                                                           56000020
         AIF   (T'&PARTS(&A) NE 'O').SKP                                58000020
         DC    AL1(0)              A VARIABLE                           60000020
         AGO   .INC                                                     62000020
.SKP     ANOP                                                           64000020
&LP  SETC  '&LEN'.'&A'                                                  66000020
         DC    AL1(&LP-*-1)        LENGTH OF MSG PART                   68000020
         AIF   ('&PARTS(&A)'(1,1) EQ '''').QUO                          70000020
         MNOTE 12,'QUOTES MISSING ON OPERAND'                           72000020
.QUO     ANOP                                                           74000020
         DC    C&PARTS(&A)         MSG PART                             76000020
&LP      EQU   *                                                        78000020
.INC     ANOP                                                           80000020
&A       SETA  &A+1                                                     82000020
         AIF   (&A LE N'&PARTS).LOOP                                    84000020
&LEN     EQU   *                                                        86000020
.OUT     ANOP                                                           88000020
         SPACE 4                                                        90000020
         MEND                                                           92000020
./ ADD NAME=LNK7003
 INCLUDE SYSPUNCH(PDS7003)
 INCLUDE SYSPUNCH(STARRTN)
 ENTRY PDSMAIN
 ALIAS PDS
 NAME PDS7003(R)
./       ADD   NAME=PDSGEN70
         TITLE 'P D S  --  PDS PROGRAM GENERATION OPTIONS             ' 00010000
         SPACE 1                                                   @D01
***                                                                @D01
*** UPDATE (UU) NUMBER IN MESSAGE PDS100I                          @D01
***                                                                @D01
&VERS    SETC  '7.0.03 FOR MVT'                                    @D06
         SPACE 2                                                   @D01
***                                                                @D01
*** DATE OF LAST MAINTENANCE FOR PDS                               @D01
***                                                                @D01
&FIXDATE SETC  'AUGUST 18, 2021'                                   @D06
         SPACE 2                                                   @D01
***                                                                     00020000
*** SET THE LEVEL OF YOUR OPERATING SYSTEM WITH ANY OF THREE VALUES:    00030000
***                                                                     00040000
*&MVSLEV  SETC  'MVS13X'    ***  FOR MVS SP 1.3 OR LATER           @D01 00050000
*&MVSLEV  SETC  'MVS12X'   ***  FOR MVS SP 1.2, 1.1 OR ANY SE SYSTEM    00060000
&MVSLEV  SETC  'MVS038'   ***  FOR MVS 3.8 (also set for MVT)      @D01
&MVT     SETB  1          ***  For MVT                             @D01
         SPACE 2                                                        00080000
***                                                                @D01
*** Define unit name for default DASD allocation                   @D01
***                                                                @D01
&DAUNIT  SETC  'SYSDA'                                             @D06
         SPACE 2                                                   @D01
***                                                                     00090000
*** IF PDS IS TO RUN IN A XA-370 MIXED MODE AND YOU USE XA MACLIBS,     00100000
***    UNCOMMENT THE FOLLOWING STATEMENT:                               00110000
***                                                                     00120000
*        SPLEVEL SET=1                                         SS NOV84 00130000
         SPACE 2                                                        00140000
***                                                                     00150000
*** SET THE TYPE OF TERMINAL ACCESS METHOD:                             00160000
***                                                                     00170000
*&CONVTAM SETC  'VTAMONLY'  ***  FOR VTAM ONLY                     @D01 00180000
*&CONVTAM SETC  'TCAMONLY' ***  FOR TCAM ONLY                           00190000
&CONVTAM SETC  'VTAMTCAM' ***  FOR VTAM AND TCAM                   @D01 00200000
         SPACE 2                                                        00210000
***                                                                     00220000
*** SET THE OPTION FOR DISPLAY WITH A SINGLE PARAMETER:                 00230000
***                                                                     00240000
&CONDRNG SETC  'N'         ***  CONTINUE TO THE END OF THE DIRECTORY    00250000
*&CONDRNG SETC  'Y'        ***  TREAT  DISPLAY XX  LIKE  DISPLAY XX:XX  00260000
         SPACE 2                                                        00270000
***                                                                     00280000
*** SET THE DIALOG DISPLAY SIZE FOR ISPMODE:                   SS JUL84 00290000
***                                                                     00300000
&SPFSIZE SETC  '1000'   NUMBER OF LINES IN THE TABLE                    00310000
         SPACE 2                                                        00320000
***                                                                     00330000
*** SET THE DIALOG DISPLAY MAXIMUM SIZE FOR ANY ONE            SS JUL84 00340000
*** SUBCOMMAND FOR OPERATION UNDER THE ISPMODE SUBCOMMAND.              00350000
*** THIS IS FOR LARGE AMOUNTS OF OUTPUT FROM ONE SUBCOMMAND             00360000
*** WHICH MIGHT OTHERWISE OVERFLOW THE ABOVE DISPLAY SIZE:              00370000
***                                                                     00380000
&SPFMAX  SETC  '2000'   NUMBER OF LINES                                 00390000
         SPACE 2                                                        00400000
***                                                                     00410000
*** SET THE DIALOG CHECKPOINT DEFAULT SIZE FOR ISPMODE;        SS JUL84 00420000
*** THIS IS FOR LARGE AMOUNTS OF OUTPUT FROM ONE SUBCOMMAND.            00430000
*** IT ALLOWS THE USER TO CHECK THE OUTPUT AFTER XXX LINES              00440000
*** BEFORE ALL OUTPUT FROM THE SUBCOMMAND HAS BEEN PRODUCED             00450000
*** AND THE USER MAY CONTINUE OR STOP THE SUBCOMMAND.                   00460000
***                                                                     00470000
&SPFCKPT SETC  '250'    NUMBER OF LINES                                 00480000
         SPACE 2                                                        00490000
***                                                                     00500000
*** SET THE DEFAULT MESSAGE FOR THE DSNAME SUBCOMMAND AND               00510000
*** FOR DATA SET ALLOCATION:                                            00520000
***                                                                     00530000
&CONADEF SETC  'FDSNMSG'   ***  SEE PDS200I MESSAGE EXAMPLE BELOW       00540000
*&CONADEF SETC  'FDSNTSO'  ***  SEE PDS210I MESSAGE EXAMPLE BELOW       00550000
*&CONADEF SETC  'FDSNJCL'  ***  SEE PDS220I MESSAGE EXAMPLE BELOW       00560000
***                                                                     00570000
*PDS200I DISP UNIT  REC LRECL BLKSZ  ALLOCTRK FREETRK SECONDARY FREEDIR 00580000
*PDS200I SHR  3380  VB    255  9040  1X    15       7     0 CYL      18 00590000
*                                                                       00600000
*PDS210I ALLOC F(SYS00007) DA('HABL.LIB.CLIST') SHR UNIT(3380)          00610000
*PDS210I   RECFM(V B) LRECL(255) BLKSIZE(9040) VOLUME(TSO002)           00620000
*PDS210I   CYL SPACE(1) DIR(40)              /*FREE TRK=7,FREE DIR=18*/ 00630000
*                                                                       00640000
*PDS220I //SYS00007  DD  DSN=HABL.LIB.CLIST,DISP=SHR,UNIT=3380,         00650000
*PDS220I //  DCB=(RECFM=VB,LRECL=255,BLKSIZE=9040),VOL=SER=TSO002,      00660000
*PDS220I //  SPACE=(CYL,(1,,40))             /*FREE TRK=7,FREE DIR=18*/ 00670000
*                                                                       00680000
         SPACE 3                                                        00690000
***                                                                     00700000
*** SET THE OPTION TO CIRCUMVENT APAR OZ80528 (PERMANENT RESTRICTION -  00710000
*** SYMPTOM IS IGNORED EDIT OR BROWSE AFTER PF4 IN ISPF SUBCOMMAND).    00720000
***                                                                     00730000
*** THE CIRCUMVENTION TESTS FOR THE EXIT TYPE AND ISSUES DOUBLE EDIT    00740000
*** OR BROWSE SUBCOMMANDS SUBSEQUENTLY IF REQUIRED.                     00750000
***                                                                     00760000
&RETURNX SETC  'YES'       ***  REISSUE EDIT OR BROWSE AFTER RETURN     00770000
*&RETURNX SETC  'NO'       ***  DO NOT REISSUE SUBCOMMANDS AFTER RETURN 00780000
         SPACE 3                                                   @D03
****************************************************************** @D03
***                                                                @D03
*** SET THE UNIT NAME FOR //SYSUT4 DATA SET USED BY COPY           @D03
*** CAUTION: THIS UNIT NAME MUST NOT MAP TO A VIO DEVICE           @D03
***                                                                @D03
&TUNIT   SETC  'SYSDA'    ***  COPY TEMPORARY //SYSUT4 UNIT        @D06
*&TUNIT   SETC  'PUBDA'    ***  COPY TEMPORARY //SYSUT4 UNIT       @D03
         EJECT                                                          00790000
***                                                                     00800000
*** SET THE UNIT NAME STRING (1 TO 8 CHARACTERS -- A GENERIC NAME       00810000
*** MAY BE USED) ACCORDING TO TYPE OF DEVICE.  THESE NAMES WILL BE      00820000
*** USED BY THE DSNAME SUBCOMMAND.                                      00830000
***                                                                     00840000
&UN2311  SETC  '2311    '    ***  2311    DEVICE                   @D01
&UN2301  SETC  '2301    '    ***  2301    DEVICE                   @D01
&UN2303  SETC  '2303    '    ***  2303    DEVICE                   @D01
&UN2302  SETC  '2302    '    ***  2302    DEVICE                   @D01
&UN2321  SETC  '2321    '    ***  2321    DEVICE                   @D01
&UN23051 SETC  '2305-1  '    ***  2305-1  DEVICE                        00850000
&UN23052 SETC  '2305-2  '    ***  2305-2  DEVICE                        00860000
&UN2314  SETC  '2314    '    ***  2314    DEVICE                        00870000
&UN3330  SETC  '3330    '    ***  3330-1  DEVICE                        00880000
&UN3340  SETC  '3340    '    ***  3340    DEVICE                        00890000
&UN3350  SETC  '3350    '    ***  3350    DEVICE                        00900000
&UN3375  SETC  '3375    '    ***  3375    DEVICE                        00910000
&UN33301 SETC  '3330-1  '    ***  3330-11 DEVICE                        00920000
&UN3380  SETC  '3380    '    ***  3380    DEVICE                        00930000
&UN3390  SETC  '3390    '    ***  3390    DEVICE                   @D01
         SPACE 3                                                        00940000
***                                                                     00950000
*** SET THE INITIAL BUFFERING MODE FOR EACH DEVICE TYPE USING ONE       00960000
*** OF THE FOLLOWING VALUES:                                            00970000
***      SINGLE:   SINGLE BUFFERING                                     00980000
***      DOUBLE:   DOUBLE BUFFERING                                     00990000
***      MULTIPLE: MULTIPLE BUFFERING (READ MULTIPLE CCW)               01000000
***                                                                     01010000
&DB2311  SETC  'DOUBLE'   ***  2311    INITIAL BUFFERING           @D01
&DB2301  SETC  'DOUBLE'   ***  2301    INITIAL BUFFERING           @D01
&DB2303  SETC  'DOUBLE'   ***  2303    INITIAL BUFFERING           @D01
&DB2302  SETC  'DOUBLE'   ***  2302    INITIAL BUFFERING           @D01
&DB2321  SETC  'DOUBLE'   ***  2321    INITIAL BUFFERING           @D01
&DB23051 SETC  'DOUBLE'   ***  2305-1  INITIAL BUFFERING                01020000
&DB23052 SETC  'DOUBLE'   ***  2305-2  INITIAL BUFFERING                01030000
&DB2314  SETC  'DOUBLE'   ***  2314    INITIAL BUFFERING                01040000
&DB3340  SETC  'MULTIPLE' ***  3340    INITIAL BUFFERING                01050000
&DB3350  SETC  'MULTIPLE' ***  3350    INITIAL BUFFERING                01060000
&DB3375  SETC  'MULTIPLE' ***  3375    INITIAL BUFFERING                01070000
&DB3380  SETC  'MULTIPLE' ***  3380    INITIAL BUFFERING                01080000
&DB3330  SETC  'DOUBLE'   ***  3330-1  INITIAL BUFFERING                01090000
&DB33301 SETC  'DOUBLE'   ***  3330-11 INITIAL BUFFERING                01100000
&DB3390  SETC  'MULTIPLE' ***  3390    INITIAL BUFFERING           @D01
*                                                                       01110000
* NOTE: &DB3330 AND &DB33301 ARE SET TO DOUBLE SINCE READ MULTIPLE      01120000
*       MAY NOT WORK FOR 3330-1 AND 3330-11 DISK DEVICES.               01130000
*                                                                       01140000
*       READ MULTIPLE WILL PROBABLY NOT WORK ON A 3830-1 STORAGE        01150000
*       CONTROL UNIT.                                                   01160000
*                                                                       01170000
*       READ MULTIPLE SHOULD WORK ON A 3830-2 STORAGE CONTROL UNIT IF   01180000
*       ITS MICROCODE SUPPORTS 3340 AND 3350 DISK DEVICES.              01190000
*                                                                       01200000
*       IF YOU ARE CONFIDENT THAT READ MULTIPLE WILL WORK FOR YOUR      01210000
*       3330 DEVICES, CHANGE THE ABOVE DEFAULTS TO MULTIPLE.            01220000
*                                                                       01230000
*       OTHERWISE, GENERATE THE PROGRAM WITH THE DOUBLE DEFAULTS AND    01240000
*       TEST A DATA SET USING "CONTROL TESTREAD" ON EACH COMBINATION    01250000
*       OF DEVICE (3330-1 AND 3330-11) AND STORAGE CONTROL UNIT.  IF    01260000
*       READ MULTIPLE IS OPERATIONAL FOR ALL OF THESE SITUATIONS, THE   01270000
*       DEFAULTS FOR &DB3330 AND &DB33301 CAN BE SET TO 'MULTIPLE' AND  01280000
*       THE PROGRAM CAN BE REASSEMBLED (OR THE PROGRAM MAY BE ZAPPED).  01290000
*                                                                       01300000
         EJECT                                                          01310000
***                                                                     01320000
***                                                                     01330000
*** THE FOLLOWING STATEMENTS SET SUBCOMMAND NAMES.  NOTE THAT           01340000
*** THESE SUBCOMMAND NAMES ARE CURRENTLY LISTED IN THE ORDER OF THE     01350000
*** SUBCOMMANDS IN THE PDSTBL70 COPY MEMBER:                            01360000
***   A.  TO NULLIFY A SUBCOMMAND, CODE ITS SETC VALUE AS ''            01370000
***   B.  TO RENAME A SUBCOMMAND, CHANGE ITS SETC VALUE TO A            01380000
***       DIFFERENT VALUE (ONE TO EIGHT CHARACTERS).                    01390000
***         1.  NOTE THAT DUE TO THE SUBCOMMAND NAME SCAN USED,         01400000
***             ALIASES FOR OTHER SUBCOMMANDS MAY CHANGE.               01410000
***         2.  FOR EXAMPLE, IF DSPRINT WERE RENAMED TO EXTRA, THE      01420000
***             SUBCOMMAND "E " WOULD BECOME "EXTRA" INSTEAD OF         01430000
***             "EDIT" DUE TO THE RELATIVE POSITIONS OF "DSPRINT"       01440000
***             AND "EDIT" IN THE SUBCOMMAND SCAN TABLE -- THE FIRST    01450000
***             MATCH FOR THE NUMBER OF CHARACTERS ENTERED IS USED.     01460000
***         3.  TO AVOID THIS PROBLEM WHEN YOU RENAME ANY SUBCOMMANDS,  01470000
***             EDIT MEMBERS PDSTBL70 AND DIATBL70 AFTER THIS MEMBER    01480000
***             AND MOVE THE LINES REPRESENTING SUBCOMMANDS TO THEIR    01490000
***             DESIRED NEW POSITIONS.                                  01500000
***   C.  IF SUBCOMMANDS ARE NULLIFIED OR RENAMED, BE SURE TO MAKE      01510000
***       CORRESPONDING CHANGES IN THE HELP MEMBER AND THE ISPF PANELS. 01520000
***   D.  TO PREVENT THE USE OF ANY SUBCOMMAND ABBREVIATION, CODE       01530000
***       ONE OF THE &NABX STATEMENTS TO ANY SUBSTRING DESIRED.  FOR    01540000
***       EXAMPLE, TO PREVENT THE USE OF THE SUBCOMMANDS "E " OR "EN ", 01550000
***       YOU COULD CODE:  &NAB1  SETC  'EN'                            01560000
***   E.  SEVERAL ADDITIONAL ALIASES FOR THE PRINTOFF INTERFACE HAVE    01570000
***       BEEN ADDED FOR INSTALLATION DEPENDENT USES (&NXS1 - &NXS3)    01580000
***                                                                     01590000
&NAB1    SETC  ''                                                       01600000
&NAB2    SETC  ''                                                       01610000
&NAB3    SETC  ''                                                       01620000
&NATT    SETC  'ATTRIB'                                                 01630000
&NALI    SETC  'ALIAS'                                                  01640000
&NBRO    SETC  ''             'BROWSE'                             @D01
&NCHA    SETC  'CHANGE'                                                 01660000
&NCAR    SETC  'COMPARE'                                                01670000
&NCMX    SETC  'COMPRESS'                                               01680000
&NCON    SETC  'CONTROL'                                                01690000
&NDIS    SETC  'DISPLAY'                                                01700000
&NDIR    SETC  'DIRENTRY'                                               01710000
&NDEL    SETC  'DELETE'                                                 01720000
&NDSN    SETC  'DSNAME'    **DO NOT NULLIFY**                           01730000
&NDSP    SETC  ''             'DSPRINT'                            @D01
&NEDI    SETC  ''             'EDIT'                               @D01
&NEND    SETC  'END'       **DO NOT NULLIFY**                           01760000
&NEXE    SETC  'EXEC'                                                   01770000
&NFIN    SETC  'FIND'                                                   01780000
&NFIX    SETC  'FIXPDS'                                                 01790000
&NFSE    SETC  'FSE'                                                    01800000
&NKLE    SETC  'KLEAR'     **UNDOCUMENTED -- CLEAR SCREEN SUBCOMMAND    01810000
&NHEL    SETC  'HELP'                                                   01820000
&NHIS    SETC  'HISTORY'                                                01830000
&NIFX    SETC  'IF'                                                     01840000
&NISP    SETC  ''             'ISPF'                               @D01
&NISM    SETC  ''             'ISPMODE'                            @D01
&NLIS    SETC  'LIST'                                                   01870000
&NMAP    SETC  'MAP'                                                    01880000
&NMEM    SETC  'MEMBERS'                                                01890000
&NMML    SETC  ''             'MEMLIST'                            @D01
&NOPT    SETC  'OPTIONS'                                                01910000
&NOUT    SETC  'OUTCOPY'                                                01920000
&NPAT    SETC  'PATTERN'                                                01930000
&NPDS    SETC  'PDS70'     **UNDOCUMENTED -- ALIAS FOR CHANGE           01940000
&NPRI    SETC  ''             'PRINTOFF'                           @D01
&NREC    SETC  'RECALL'                                                 01960000
&NREN    SETC  'RENAME'                                                 01970000
&NRES    SETC  'RESTORE'                                                01980000
&NREV    SETC  'REVIEW'                                                 01990000
&NSPF    SETC  ''             'SPFEDIT'   **UNDOCUMENTED           @D01
&NSUB    SETC  'SUBMIT'                                                 02010000
&NSCR    SETC  'SCRATCH'   **ALIAS FOR DELETE (NULLIFY IF NOT USED)     02020000
&NTSO    SETC  'TSO'                                                    02030000
&NTSE    SETC  'TSOEDIT'                                                02040000
&NTSL    SETC  ''             'TSOLIST'                            @D01
&NUSA    SETC  'USAGE'                                                  02060000
&NUT1    SETC  ''             'UT1'   **UNDOCUMENTED -- UTILITIES  @D01
&NUT2    SETC  ''             'UT2'   **UNDOCUMENTED -- UTILITIES  @D01
&NVER    SETC  'VERIFY'                                                 02090000
&NXS1    SETC  ''                                                  @D01
**       SETC  'VPSPRINT'  ***INTERFACE FOR THE VPS DSPRINT REPLAC @D01
&NXS2    SETC  ''                                                  @D01
**       SETC  'PCLIST1'   **PDS TEST CLIST                        @D01
&NXS3    SETC  ''                                                       02120000
         SPACE 3                                                        02130000
***                                                                     02140000
***                                                                     02150000
*** THE FOLLOWING STATEMENTS SET THE NAMES OF ATTACHED TSO COMMANDS.    02160000
***  EACH OF THESE &N... SYMBOLS IS ASSOCIATED WITH AN &C... SYMBOL     02170000
***  WITH THE SAME LAST THREE CHARACTERS AS DEFINED ABOVE.              02180000
***                                                                     02190000
*** NOTE: TO NULLIFY A SUBCOMMAND, DO NOT USE THE &C... SYMBOL;         02200000
***       USE THE ASSOCIATED &N... SYMBOL.                              02210000
***                                                                     02220000
*** NOTE: TO USE A DIFFERENT TSO COMMAND NAME, CHANGE ITS SETC VALUE    02230000
***       TO A DIFFERENT VALUE (ONE TO EIGHT CHARACTERS) AND ALSO       02240000
***       MAKE CORRESPONDING CHANGES IN THE HELP MEMBER.                02250000
***                                                                     02260000
*** NOTE: COMPARE, DSPRINT, PRINTOFF, REVIEW, SUBMIT AND TSOLIST (AS    02270000
***       WELL AS &NX1, &NX2 AND &NX3) CAN INVOKE A CLIST INSTEAD OF    02280000
***       A TSO COMMAND BY CHANGING THE SETC VALUE TO A % FOLLOWED BY   02290000
***       ONE TO SEVEN CHARACTERS; BE SURE TO MAKE CORRESPONDING        02300000
***       CHANGES IN THE HELP MEMBER:                                   02310000
***         1. COMPARE CLIST INPUT -  DSNAME1(MEMBER1) DSNAME2(MEMBER2) 02320000
***            FOLLOWED BY ANY ADDITIONAL DATA TYPED BY THE USER.       02330000
***         2. OTHER CLIST INPUT -  DSNAME(MEMBER) FOLLOWED BY ANY      02340000
***            ADDITIONAL DATA TYPED BY THE USER.                       02350000
***                                                                     02360000
         SPACE  3                                                       02370000
*** NOTE: THE FOLLOWING OPTIONAL TSO COMMANDS ARE REFERENCED IN THE     02380000
***       REMAINDER OF THIS MEMBER:                                     02390000
***                                                                     02400000
***    COMMAND NAME        SOURCE                                       02410000
***    ------------        ------                                       02420000
***    COMPARE, COMPAREB   CBT MODS TAPE FILE 296; CBT FILE 300         02430000
***    SPFCOPY             IBM ISPF INSTALL; CBT FILE 300               02440000
***    PDSFAST             SOFTWARE ENGINEERING OF AMERICA              02450000
***    DSPRINT             IBM FDP                                      02460000
***    DPSPRINT            MEMOREX                                      02470000
***    VPSPRINT            LEVI, RAY AND SHOUP                          02480000
***    RELEASE             CBT FILE 300                                 02490000
***    FSE                 CBT FILE 207                                 02500000
***    FSE                 PALM BEACH ASSOCIATES FSE+                   02510000
***    HEL                 CBT FILE 296                                 02520000
***    PRINTOFF            CBT FILE 300; CBT FILE 205; CBT FILE 234,236 02530000
***    REVIEW              CBT FILE 296; CBT FILE 300                   02540000
***    LIST                CBT FILE 300; IBM COMMAND PACKAGE            02550000
***    LIST                PALM BEACH ASSOCIATES SUPERSET UTILITIES     02560000
***                                                                     02570000
       SPACE 3                                                          02580000
*==> &CCAR: THE COMPARE COMMAND CAN BE OBTAINED FROM THE CBT            02590000
***   THE CBT TAPE, FILE 296 (UPDATED IN 1984), OR FROM JIM             02600000
***   MARSHALL'S TSO MODIFICATIONS ON THE CBT TAPE, FILE 300;           02610000
***   NOTE THAT A RELATED PROGRAM (COMPAREB) FROM THE SAME FILE         02620000
***   MUST ALSO BE INSTALLED.                                           02630000
&CCAR    SETC   'COMPARE'                                               02640000
*&CCAR    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   02650000
         SPACE  2                                                       02660000
*==> &C296: IF THE COMPARE PROGRAM WAS OBTAINED FROM THE CBT TAPE,      02670000
***   FILE 296, IT CAN PASS DATA DIRECTLY TO THE PDS COMMAND AND        02680000
***   THE COMPARE OUTPUTS CAN BE MANAGED IN ISPMODE.  NOTE: THE         02690000
***   INTERFACE USED CAN BE CHANGED VIA ZAP AT LABEL COMPAZAP.          02700000
&C296    SETC   'YES'         *** IF COMPARE IS FROM CBT 296            02710000
*&C296    SETC   'NO'         *** IF COMPARE IS FROM ANOTHER SOURCE     02720000
         SPACE  2                                                       02730000
*==> &CCMX: ONE OF THE FOLLOWING MAY BE USED FOR A COMPRESS PROGRAM.    02740000
****** SPFCOPY IS THE SPF AUTHORIZATION FRONT END FOR IEBCOPY           02750000
***    WHICH IS AVAILABLE IN THE SPF INSTALLATION MATERIALS OR FROM     02760000
***    JIM MARSHALL'S TSO MODIFICATIONS ON THE CBT TAPE, FILE 300.      02770000
*&CCMX    SETC   'SPFCOPY'                                         @D01 02780000
****** PDSFAST IS THE IEBCOPY "REPLACEMENT" PROGRAM FROM SOFTWARE       02790000
***    ENGINEERING OF AMERICA (AN "EXTRA FEATURE", EF-002, MUST BE      02800000
***    INSTALLED IN PDSFAST TO ALLOW ITS USE BY A TSO COMMAND).         02810000
*&CCMX    SETC   'PDSFAST'                                              02820000
****** IEBCOPY IS IBM'S PDS COPY UTILITY; AUTHORIZATION CODE MUST BE    02830000
***    ENABLED IN PDS VIA ZAP NEAR LABEL COMPRZAP, HOWEVER.             02840000
***    Note authorization is not applicable in MVT.                @D01
&CCMX    SETC   'IEBCOPY'                                          @D01 02850000
         SPACE  2                                                       02860000
*==> &CDSP: DSPRINT IS THE DATA SET PRINT COMMAND FROM IBM; HOWEVER,    02870000
***   DSPRINT COULD ACTUALLY BE AN ALIAS FOR ONE OF THE OTHER VTAM      02880000
***   PRINTER PRODUCTS SUCH AS DPS OR VPS.                              02890000
&CDSP    SETC   'DSPRINT'                                               02900000
*&CDSP    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   02910000
         SPACE  2                                                       02920000
*==> &CEXE: THE EXEC COMMAND IS INVOKED FOR THE EXEC SUBCOMMAND         02930000
***   (EXPLICIT USE) AND SUBCOMMANDS BEGINNING WITH % (IMPLICIT USE).   02940000
&CEXE    SETC   'EXEC'                                                  02950000
         SPACE  2                                                       02960000
*==> &CFIX: FIXPDS INVOKES THE RELEASE COMMAND; RELEASE MAY BE OBTAINED 02970000
***   FROM JIM MARSHALL'S TSO MODIFICATIONS ON THE CBT TAPE, FILE 300.  02980000
***   NOTE:                                                             02990000
***     1.  FIXPDS RELEASE       INVOKES:  RELEASE 'DSNAME'             03000000
***     2.  FIXPDS RELEXTENT     INVOKES:  RELEASE 'DSNAME' EXT         03010000
***     3.  FIXPDS RELSAVE(123)  INVOKES:  RELEASE 'DSNAME' SAV(123)    03020000
&CFIX    SETC   'RELEASE'                                               03030000
         SPACE  2                                                       03040000
*==> &CFSE: FSE IS A FULL-SCREEN EDIT COMMAND.  USE FSE FROM THE CBT    03050000
***   TAPE, FILE 207 OR THE FSE+ PRODUCT FROM PALM BEACH ASSOCIATES.    03060000
&CFSE    SETC   'FSE'                                                   03070000
         SPACE  2                                                       03080000
*==> &CHEL: EITHER OF THE FOLLOWING MAY BE USED FOR A HELP COMMAND.     03090000
****** HEL IS A FULL-SCREEN HELP COMMAND FROM THE CBT TAPE, FILE 296.   03100000
*&CHEL   SETC   'HEL'                                              @D01 03110000
****** HELP IS THE STANDARD HELP COMMAND FROM IBM.                      03120000
&CHEL    SETC   'HELP'                                             @D01 03130000
         SPACE  2                                                       03140000
*==> &CISP: THE LEVEL OF SPF/ISPF IS SET WITH THIS VARIABLE.            03150000
****** IF YOU USE ISPF AND ISPF/PDF VERSION 1 AND OPTIONALLY VERSION 2: 03160000
*&CISP     SETC   'ISPF'    *** FOR 5665-268 AND 5668-960 OR ABOVE @D01 03170000
****** IF YOU USE ONLY ISPF AND ISPF/PDF VERSION 2:                     03180000
*&CISP    SETC   'ISPFV2'  *** FOR 5665-317 AND 5665-319                03190000
****** IF YOU USE SPF AND OPTIONALLY ANY ISPF VERSION:                  03200000
*&CISP    SETC   'SPF'     *** FOR 5668-009 OR ABOVE                    03210000
****** IF YOU WANT TO DISABLE BROWSE, EDIT, ISPF, ISPMODE OR MEMLIST:   03220000
&CISP    SETC   ''                                                 @D01 03230000
         SPACE  2                                                       03240000
*==> &CPRI: THE PRINTOFF COMMAND IS AVAILABLE FROM SEVERAL MOD TAPES    03250000
***   AND FROM ANY IBM IPO PACKAGE.                                     03260000
&CPRI    SETC   'PRINTOFF'                                              03270000
*&CPRI    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   03280000
         SPACE  2                                                       03290000
*==> &CREV: REVIEW IS A FULL-SCREEN BROWSE COMMAND WHICH IS AVAILABLE   03300000
***   FROM THE CBT TAPE, FILE 296 (UPDATED IN 1984), OR FROM            03310000
***   JIM MARSHALL'S TSO MODIFICATIONS ON THE CBT TAPE, FILE 300.       03320000
&CREV    SETC   'REVIEW'                                                03330000
*&CREV    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   03340000
         SPACE  2                                                       03350000
*==> &CSUB: THE SUBMIT COMMAND IS AVAILABLE ON MOST MVS SYSTEMS.        03360000
&CSUB    SETC   'SUBMIT'                                                03370000
*&CSUB    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   03380000
         SPACE  2                                                       03390000
*==> &CTSL: THE TSO LIST COMMAND MAY BE OBTAINED FROM JIM MARSHALL'S    03400000
***   TSO MODIFICATIONS ON THE CBT TAPE, FILE 300; A PRODUCT VERSION    03410000
***   IS IN IBM'S TSO UTILITIES PACKAGE; AND A FULL-SCREEN LIST COMMAND 03420000
***   IS AVAILABLE FROM PALM BEACH ASSOCIATES:                          03430000
&CTSL    SETC   'LIST'                                                  03440000
*&CTSL    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   03450000
         SPACE  2                                                       03460000
*==> &CTSO: IF YOUR INSTALLATION HAS TSO/E RELEASE 2, PDS CAN INVOKE    03470000
***   TSOEXEC INSTEAD OF THE THE TSO COMMAND; THUS, INSTEAD OF TYPING   03480000
***   TSO TSOEXEC AUTHPROG ..., YOU TYPE TSO AUTHPROG.                  03490000
&CTSO    SETC   ' NOTSO/E'    *** IF NO TSO/E RELEASE 2                 03500000
*&CTSO    SETC   'TSOEXEC'                                              03510000
         SPACE  2                                                       03520000
*==> &CTSE: THE TSO EDIT COMMAND IS AVAILABLE ON MOST MVS SYSTEMS.      03530000
&CTSE    SETC   'EDIT'                                                  03540000
         SPACE  2                                                       03550000
*==> &CUT1: THIS NAMES THE PANEL TO BE INVOKED BY THE UT1 SUBCOMMAND    03560000
***   FOR SELECT PANEL SUPPORT:                                SS NOV84 03570000
&CUT1    SETC   'PDS70UT1'                                     SS NOV84 03580000
         SPACE  2                                                       03590000
*==> &CUT2: THIS NAMES THE PANEL TO BE INVOKED BY THE UT2 SUBCOMMAND    03600000
***   FOR SELECT PANEL SUPPORT:                                SS NOV84 03610000
&CUT2    SETC   'PDS70UT2'                                     SS NOV84 03620000
         SPACE  2                                                       03630000
*==> &CXS1: THIS COMMAND IS FOR INSTALLATION DEPENDENT USE; IT IS AN    03640000
***   ALIAS FOR THE PRINTOFF INTERFACE:                                 03650000
&CXS1    SETC   'VPSPRINT'    *** REPLACEMENT FOR THE DSPRINT COMMAND   03660000
*&CXS1    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   03670000
         SPACE  2                                                       03680000
*==> &CXS2: THIS COMMAND IS FOR INSTALLATION DEPENDENT USE; IT IS AN    03690000
***   ALIAS FOR THE PRINTOFF INTERFACE:                                 03700000
&CXS2    SETC   '%PCLIST1'    *** AN INSTALLATION-DEFINED CLIST IS USED 03710000
*&CXS2    SETC   ' '          *** IF NOT USED                           03720000
         SPACE  2                                                       03730000
*==> &CXS2: THIS COMMAND IS FOR INSTALLATION DEPENDENT USE; IT IS AN    03740000
***   ALIAS FOR THE PRINTOFF INTERFACE:                                 03750000
&CXS3    SETC   ' '           *** NOT USED                              03760000
*&CXS3    SETC   '%NAME567'   *** IF A CLIST IS TO BE INVOKED INSTEAD   03770000
./       ADD   NAME=PDSTBL70
         PUSH  PRINT                                               @D01
         PRINT GEN                                                 @D01
*                                                                       00010000
*    ---  SUBCOMMAND NAME SCAN TABLE  ---                               00020000
*                                                                       00030000
*                                                                       00040000
*   NOTES:                                                              00050000
*                                                                       00060000
*     1.  ENTRIES WITH A BLANK SUBCOMMAND NAME ARE CONSIDERED DISABLED. 00070000
*                                                                       00080000
*     2.  THE SUBCOMMAND NAME ORDER IS SIGNIFICANT BECAUSE AMBIGUITIES  00090000
*         ARE RESOLVED BY TAKING THE FIRST NAME MATCH FOR THE NUMBER OF 00100000
*         LETTERS ENTERED BY THE USER.                                  00110000
*                                                                       00120000
*                                                                       00130000
$TBL DS 0F    +08         +0C         +0D      +10         +14   +1C    00140000
*LBL  SUBCOMM,OF,ROUTINE ,  FLAGS    ,  PCL   , POST-PARSE, CALL,OPTOFF 00150000
****  *******,**,********,***********,********,***********,*****,****** 00160000
$AB1 $T &NAB1,00,+INVABBR,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00170000
$AB2 $T &NAB2,00,+INVABBR,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00180000
$AB3 $T &NAB3,00,+INVABBR,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00190000
$ATT $T &NATT,00,++ATTRIB,00+@Q+@G+@B,+PCLATTR,$D,+ZATTRIB,*****,OATT   00200000
$ALI $T &NALI,00,+++ALIAS,00+00+@R+@B,PCLALIAS,00,00000000,*****,OALI   00210000
$BRO $T &NBRO,0B,++BROWSE,@S+@I+@G+@B,PCLBROWS,$D,00000000,&CBRO,OBRO   00220000
$CHA $T &NCHA,00,++CHANGE,@S+00+00+@C,+PCLMAIN,00,ZMAINPDL,*****,OCHA   00230000
$CAR $T &NCAR,08,+COMPARE,00+00+@R+@B,PCLCOMPA,00,ZCOMPARE,&CCAR,OCAR   00240000
$CMX $T &NCMX,00,COMPRESS,00+00+00+@C,PCLCOMPR,00,ZCOMPRES,&CCMX,OCMX   00250000
$CON $T &NCON,00,+CONTROL,@S+00+00+@C,+PCLCONT,00,ZCONTROL,*****,OCON   00260000
$DIS $T &NDIS,00,+DISPLAY,00+00+00+00,PCLDSPLY,$M,00000000,*****,ODIS   00270000
*DIR $T &NDIR,00,DIRENTRY,00+@Q+@G+@B,++PCLDIR,$D,00000000,*****,ODIR   00280000
$DIR $T &NDIR,00,DIRENTRY,00+@Q+@G+@B,++PCLDIR,$D,ZDIRENTR,*****,ODIR   00280000
$DEL $T &NDEL,00,++DELETE,00+@Q+@G+@B,PCLDELET,00,+ZDELETE,*****,ODEL   00290000
$DSN $T &NDSN,00,+DSNAMES,@S+00+00+00,+PCLDSNA,00,ZDSNAMES,*****,ODSN   00300000
$DSP $T &NDSP,00,PRINTOFF,@S+@Q+@G+@B,PCLPRINT,$D,ZPRINTOF,&CDSP,ODSP   00310000
$EDI $T &NEDI,00,++BROWSE,@S+@I+@G+@C,+PCLEDIT,$D,+++ZEDIT,&CEDI,OEDI   00320000
$END $T &NEND,00,++RETURN,@S+00+@N+00,00000000,00,00000000,*****,OEND   00330000
$EXE $T &NEXE,00,++++EXEC,@S+00+@N+00,00000000,00,00000000,&CEXE,OEXE   00340000
$FIN $T &NFIN,00,++++FIND,@S+@Q+@G+@B,+PCLFIND,00,00+ZFIND,*****,OFIN   00350000
$FIX $T &NFIX,00,++FIXPDS,@S+00+00+@C,0+PCLFIX,00,+ZFIXPDS,&CFIX,OFIX   00360000
$FSE $T &NFSE,00,+TSOEDIT,@S+@Q+@G+@C,+PCLEDIT,$D,00+ZEDIT,&CFSE,OFSE   00370000
$KLE $T &NKLE,00,+++KLEAR,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00380000
$HEL $T &NHEL,00,++++HELP,@S+00+@N+00,00000000,00,00000000,&CHEL,OHEL   00390000
$HIS $T &NHIS,00,+HISTORY,00+@Q+@G+@B,+PCLHIST,00,ZHISTORY,*****,OHIS   00400000
$IFX $T &NIFX,00,++++++IF,00+@Q+@G+@B,PCLIFTTR,00,0000+ZIF,*****,OIFX   00410000
$ISP $T &NISP,00,++BROWSE,@S+00+00+@C,+PCLISPF,00,00+ZISPF,&CISP,OISP   00420000
$ISM $T &NISM,00,++BROWSE,@S+00+00+00,+PCLISPM,00,00+ZISPM,*****,OISM   00430000
$LIS $T &NLIS,00,++++LIST,@S+00+@G+@B,+PCLLIST,00,00+ZLIST,*****,OLIS   00440000
$MAP $T &NMAP,00,+++++MAP,00+@Q+@G+@B,++PCLMAP,00,000+ZMAP,*****,OMAP   00450000
$MEM $T &NMEM,00,++NEWCMD,00+00+@G+@B,+PCLMEMB,00,00000000,*****,OMEM   00460000
$MML $T &NMML,00,++BROWSE,00+@Q+@G+@B,+PCLMEML,$D,ZMEMLIST,*****,OMML   00470000
$OPT $T &NOPT,00,+OPTIONS,@S+00+@N+00,00000000,00,00000000,*****,OOPT   00480000
$OUT $T &NOUT,09,+OUTCOPY,00+@Q+@G+@B,++PCLOUT,00,ZOUTCOPY,*****,OOUT   00490000
$PAT $T &NPAT,00,+PATTERN,00+00+00+00,PCLPATTR,$M,00000000,*****,OPAT   00500000
$PDS $T &NPDS,00,++CHANGE,@S+00+00+@C,+PCLMAIN,00,ZMAINPDL,*****,ONIX   00510000
$PRI $T &NPRI,01,PRINTOFF,@S+@Q+@G+@B,PCLPRINT,$D,ZPRINTOF,&CPRI,OPRI   00520000
$REC $T &NREC,00,00000000,@S+00+@N+00,00000000,00,00000000,*****,OREC   00530000
$REN $T &NREN,00,++RENAME,00+00+@R+@B,PCLRENAM,00,+ZRENAME,*****,OREN   00540000
$RES $T &NRES,00,+RESTORE,00+00+@R+@C,PCLRESTO,00,ZRESTORE,*****,ORES   00550000
$REV $T &NREV,02,PRINTOFF,@S+@Q+@G+@B,PCLPRINT,$D,ZPRINTOF,&CREV,OREV   00560000
$SPF $T &NSPF,00,++BROWSE,@S+@I+@G+@C,+PCLEDIT,$D,+++ZEDIT,&CEDI,ONIX   00570000
$SUB $T &NSUB,03,PRINTOFF,@S+00+@G+@B,PCLPRINT,00,ZPRINTOF,&CSUB,OSUB   00580000
$SCR $T &NSCR,00,++DELETE,00+@Q+@G+@B,PCLDELET,00,+ZDELETE,*****,ONIX   00590000
$TSO $T &NTSO,04,+++++TSO,@S+00+@N+@C,00000000,00,00000000,&CTSO,OTSO   00600000
$TSE $T &NTSE,00,+TSOEDIT,@S+00+@G+@C,PCLTSOED,00,ZTSOEDIT,&CTSE,OTSE   00610000
$TSL $T &NTSL,00,PRINTOFF,@S+00+@G+@B,PCLPRINT,00,ZPRINTOF,&CTSL,OTSL   00620000
$USA $T &NUSA,00,+++USAGE,@S+00+@N+00,00000000,00,00000000,*****,OUSA   00630000
$UT1 $T &NUT1,00,++BROWSE,@S+00+00+@C,+PCLISPF,$J,00+ZISPF,&CUT1,ONIX   00640000
$UT2 $T &NUT2,04,++BROWSE,@S+@Q+@G+@B,PCLPRINT,$P,ZPRINTOF,&CUT2,ONIX   00650000
$VER $T &NVER,00,++VERIFY,@S+@I+@G+@B,PCLVERIF,$D,+ZVERIFY,*****,OVER   00660000
$XS1 $T &NXS1,05,PRINTOFF,@S+@Q+@G+@B,PCLPRINT,$D,ZPRINTOF,&CXS1,ONIX   00670000
$XS2 $T &NXS2,06,PRINTOFF,@S+@Q+@G+@B,PCLPRINT,$D,ZPRINTOF,&CXS2,ONIX   00680000
$XS3 $T &NXS3,07,PRINTOFF,@S+@Q+@G+@B,PCLPRINT,$D,ZPRINTOF,&CXS3,ONIX   00690000
$NNN $T   NNN,00,CMDSCAN4,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00700000
     $T     W,00,++NEWCMD,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00710000
$XXX $T     X,04,+++++TSO,@S+00+@N+@C,00000000,00,00000000,&CTSO,ONIX   00720000
         PRINT GEN                                                      00730000
$TIM $T  TIME,00,++++TIME,@S+00+@N+00,00000000,00,00000000,*****,ONIX   00740000
         DC    X'FF'     TABLE TERMINATOR                               00750000
PTW      EQU   32        SUBCOMMAND TABLE WIDTH                         00760000
         EJECT                                                          00770000
*** FIELD DESCRIPTIONS FOR THE ABOVE TABLE:                             00780000
*OFFSET: +0   +08         +0C         +0D      +10         +14   +1C    00790000
*LBL  SUBCOMM,OF,ROUTINE ,  FLAGS    ,  PCL   , POST-PARSE, CALL,OPTOFF 00800000
*                                                                       00810000
*                                                                       00820000
*     NAME    | LABEL    | OFFSET  | DESCRIPTION                        00830000
*     --------+----------+---------+------------                        00840000
*     LBL     |          |         | OPTION TABLE ENTRY LABEL           00850000
*     SUBCOMM | ##SUBCOM | +0      | ACTUAL SUBCOMMAND NAME             00860000
*     OF      | ##ADRCM# | +8      | INDEX FOR SAVETEXT DATA            00870000
*     ROUTINE | ##ADRCMD | +9      | SUBCOMMAND ROUTINE ADDRESS         00880000
*     FLAGS   | ##ADRPC# | +C      | SUBCOMMAND FLAGS                   00890000
*     PCL     | ##ADRPCL | +D      | SUBCOMMAND PCL ADDRESS             00900000
*     POST    | ##ADRPA# | +10     | SUBCOMMAND FLAGS                   00910000
*     PARSE   | ##ADRPAR | +11     | POST-PARSE ROUTINE ADDRESS         00920000
*     CALL    | ##SUBCAL | +14     | EXTERNAL TSO ROUTINE OR PANEL      00930000
*     OPTOFF  | ##HELOFF | +1C     | OFFSET TO OPTIONS HELP ENTRY       00940000
     SPACE 3                                                            00950000
*** FLAG DESCRIPTIONS FOR ##ADRPC#:                                     00960000
*@Q      EQU   X'80'     QUIET MODE FOR SUBCOMMAND                      00970000
*@I      EQU   X'40'+@Q  BROWSE, EDIT, AND VERIFY CHECK FOR :           00980000
*@N      EQU   X'20'     OPERAND IS IGNORED IF PRESENT                  00990000
*@R      EQU   X'10'     OPERAND REQUIRED, PARSE IS ALWAYS CALLED       01000000
*@S      EQU   X'08'     SUBCOMMAND WORKS FOR NON-PARTITIONED DATA SETS 01010000
*@G      EQU   X'04'     MEMBER GROUP AND MEMBER DEFAULT ALLOWED        01020000
*@B      EQU   X'02'     BLDL REQUIRED TO VERIFY FIRST MEMBER EXISTS    01030000
*@C      EQU   X'01'     SUBCOMMAND INVALIDATES BLDL                    01040000
         SPACE 1                                                        01050000
*** FLAG DESCRIPTIONS FOR ##ADRPA#:                                     01060000
*$F      EQU   X'80'          FINDLIST -- CONVERTS TO LIST AFTER FIND   01070000
*$D      EQU   X'40'          DEFAULT MEMBER MESSAGE IS SUPPRESSED      01080000
*$Q      EQU   X'20'          QUIET MODE PROCESSING FLAG                01090000
*$M      EQU   X'10'          DISPLAY OR PATTERN SUBCOMMAND             01100000
*$A      EQU   X'08'          DO NOT ACCEPT ATTENTIONS                  01110000
*$P      EQU   X'02'          SPF PANEL NAME IN ##SUBCAL       SS NOV84 01120000
*$J      EQU   X'01'+$P       SPF PANEL PARSE WITH NO MEMBERS  SS NOV84 01130000
         POP   PRINT                                               @D01
./ ADD NAME=PDS7003
PDSMAIN  TITLE 'P D S  --  PDS COMMAND PROCESSOR       2010/05/04' @D04
***********************************************************************
*                                                                     *
*                                                                     *
* Module name  =  PDS70                                               *
*                                                                     *
*                                                                     *
* Descriptive name  =  TSO PDS command processor                      *
*                                                                     *
*                                                                     *
* Function  =  To provide the TSO user with the capability to         *
*              manipulate partitioned and sequential data sets.       *
*                                                                     *
*                                                                     *
* Notes  =  See below.                                                *
*                                                                     *
*   Dependencies  =  PDS uses System/370 instructions.  Assembly      *
*                    of PDS requires the OS/VS XF assembler IFOX00.   *
*                    The hardware or hardware emulator on which the   *
*                    host operating system is running must support    *
*                    System/370 instructions, or the host operating   *
*                    system must include software simulation of       *
*                    System/370 instructions.                         *
*                                                                     *
*   Patch space  =  Eighteen halfwords of X'00' at label "PATCH".     *
*                                                                     *
*   Discussion  =  Refitting of PDS to run under MVT required         *
*                  a number of changes to the MVS code.  Generally,   *
*                  the changes fell into the following categories:    *
*                                                                     *
*                  (1)  SVC 99 dynamic allocations were changed       *
*                       to use DAIR.                                  *
*                                                                     *
*                  (2)  Recovery procedures were modified to use      *
*                       STAE instead of ESTAE.                        *
*                                                                     *
*                  (3)  MVT does not provide the System Track         *
*                       Allocation Routine (STAR), which supports     *
*                       the TRKCALC macro.  STAR logic from MVS 3.8   *
*                       was rewritten as a local subroutine and       *
*                       included with PDS.  The MVS STAR subroutine   *
*                       to apply tolerance factors was modified to    *
*                       support all devices that require it (the      *
*                       MVS 3.8 version is hard-coded for 2314 only). *
*                       Because this requires more registers than     *
*                       are used by the MVS version, the MVT caller   *
*                       of TRKCALC must provide the address of a      *
*                       standard save area in R13, and specify        *
*                       REGSAVE=YES on the TRKCALC macro invocation.  *
*                       PDS usage of TRKCALC includes REGSAVE=YES.    *
*                                                                     *
*                  (4)  ISPF-related code was removed wherever        *
*                       possible to reduce the size of the PDS        *
*                       load module.                                  *
*                                                                     *
*                  (5)  PDS logic to determine whether to use set     *
*                       sector/read sector in a DASD channel program  *
*                       was changed to base the decision on the UCB   *
*                       RPS feature bit.  The MVS code uses RPS for   *
*                       all devices except 2314s.                     *
*                                                                     *
*                  (6)  Other MVS macros and services not available   *
*                       in MVT were changed to use MVT equivalents.   *
*                       For example, SVC 120 GETMAIN/FREEMAIN RU      *
*                       requests were changed to use SVC 10           *
*                       GETMAIN/FREEMAIN R.                           *
*                                                                     *
*                  (7)  Missing mapping macros were provided from     *
*                       MVT source, or were built based on MVS 3.8    *
*                       macros.                                       *
*                                                                     *
*                  (8)  The help member was updated to reflect        *
*                       the MVT environment.                          *
*                                                                     *
*                  Original block comments in the MVS PDS source      *
*                  below have not been modified for MVT, and should   *
*                  be understood from that perspective.               *
*                                                                     *
*                                                                     *
* Module type  =  CSECT                                               *
*                                                                     *
*   Processor =  OS/VS XF assembler IFOX00                            *
*                                                                     *
*   Module size  =  See assembly listing.                             *
*                                                                     *
*   Attributes  =  Reentrant, task mode, enabled, problem state,      *
*                  user key.                                          *
*                                                                     *
*                                                                     *
* Change activity      =                                              *
*                                                                     *
*   Flag  Date        By    Description                               *
*   ----  ----------  ----  ----------------------------------------  *
*   $D06  2021/08/18  KL    V 7.0.03: Change default unit from        *
*                                     SYSALLDA to SYSDA.              *
*   $D05  2017/08/01  KL    V 7.0.02: Support for translator          *
*                                     history.                        *
*   $D04  2010/05/04  KL    V 7.0.01: Support for extended DIRENTRY   *
*                                     display.                        *
*   $D03  2010/05/04  KL    V 7.0.01: Support for MAP JCL.            *
*   $D02  2010/05/04  KL    V 7.0.01: Support for AMODE64; errors     *
*                                     in PDS 7.0 AMODE code had       *
*                                     to be fixed as a prerequsite    *
*                                     for later changes.              *
*   $D01  2010/05/04  KL    V 7.0.01: Refit to support MVT.           *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*   DATA SET PDS AT LEVEL 7.0 ON   1/15/85  (SDS -- THIS VERSION)     * 00002000
*   DATA SET PDS AT LEVEL 6 AS OF  7/16/83  (ABL -- MVS/XA VERSION)   * 00003000
*   DATA SET PDS AT LEVEL 5 AS OF  7/08/82  (ABL -- MEMBER GROUPS)    * 00004000
*   DATA SET PDS AT LEVEL 4 AS OF  9/30/80  (ABL -- MVS ONLY VERSION) * 00005000
*   DATA SET PDS AT LEVEL 3 AS OF  1/28/80  (ABL -- MVS VERSION)      * 00006000
*   DATA SET PDS AT LEVEL 2 AS OF 11/14/77  (ABL -- MVT VERSION)      * 00007000
*   DATA SET PDS AT LEVEL 1 AS OF  6/12/75  (UCLA VERSION)            * 00008000
*   DATA SET PDS AT LEVEL 0 AS OF  3/20/72  (FIREMAN'S FUND VERSION)  * 00009000
*                                                                     * 00010000
***                                                                   * 00011000
*** BEFORE ASSEMBLING, THE COPY CODE IN PDSGEN70 SHOULD BE MODIFIED   * 00012000
*** TO REFLECT RESOURCES AVAILABLE AT YOUR INSTALLATION.              * 00013000
***                                                                   * 00014000
*** NOTE: PDS CAN BE LINKED INTO SYS1.LPALIB TO REDUCE EACH PDS       * 00015000
***       USER'S SWAP LOAD; HOWEVER, YOU SHOULD ALSO KEEP A COPY      * 00016000
***       OF PDS IN YOUR LINK LIST (WITH THE SAME OR A DIFFERENT      * 00017000
***       MEMBER NAME) AS A BACKUP IN CASE YOUR LPALIB IS REPLACED    * 00018000
***       IN A FUTURE SYSTEM.                                         * 00019000
***                                                                   * 00020000
         TITLE 'P D S  --  PDS SUPPORT REPRESENTATIVE          1/15/85' 00021000
*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 00022000
*                                                                     * 00023000
*                                                                     * 00024000
* PLEASE REPORT ANY PROBLEMS, ENHANCEMENTS, SUGGESTIONS OR COMMENTS   * 00025000
* CONCERNING THE PDS COMMAND TO BRUCE LELAND AT:                      * 00026000
*                                                                     * 00027000
*     HITACHI AMERICA, LTD.     OR         6084 CRIMSON DRIVE         * 00028000
*     2210 O'TOOLE AVENUE                  SAN JOSE, CALIF 95120      * 00029000
*     SAN JOSE, CALIF. 95131                                          * 00030000
*     (408) 435-2143                       (408) 997-2366             * 00031000
*                                                                     * 00032000
*                                                                     * 00033000
*                                                                     * 00034000
*  IF AN ERROR OR ABEND CONDITION PERSISTS IN PDS, TRY THE            * 00035000
*  FOLLOWING STEPS FOR PROBLEM RESOLUTION:                            * 00036000
*                                                                     * 00037000
*                                                                     * 00038000
*   1.  CONTACT THE IBM SUPPORT CENTER FOR KNOWN MVS PROBLEMS         * 00039000
*                                                                     * 00040000
*                                                                     * 00041000
*   2.  REPORT THE PROBLEM (WHETHER RESOLVED OR NOT) TO BRUCE LELAND. * 00042000
*       PLEASE INCLUDE APPROPRIATE DOCUMENTATION FOR UNRESOLVED       * 00043000
*       PROBLEMS AS FOLLOWS:                                          * 00044000
*                                                                     * 00045000
*       A.  PLEASE USE AN UNLABELLED, 1600 OR 6250 BPI TAPE WITH      * 00046000
*           AS MANY FILES AS REQUIRED FOR DOCUMENTATION.              * 00047000
*                                                                     * 00048000
*       B.  INDICATE IF YOU HAVE SPF, ISPF VERSION 1 OR 2 AND IF      * 00049000
*           THE PROBLEM INVOLVES THE SPF INTERFACE CODE IN PDS.       * 00050000
*                                                                     * 00051000
*       C.  IF POSSIBLE, DUPLICATE THE ERROR ON PAPER BY EXECUTING    * 00052000
*           PDS IN BACKGROUND MODE.                                   * 00053000
*                                                                     * 00054000
*       D.  NOTE YOUR MVS OPERATING SYSTEM LEVEL (FOR EXAMPLE,        * 00055000
*           SP 1.3.3 AT 8402).                                        * 00056000
*                                                                     * 00057000
*       E.  NOTE THE PDS LEVEL (OR BETTER YET, UNLOAD A COPY OF THE   * 00058000
*           PDS SOURCE CODE INSTALLED AT YOUR INSTALLATION).          * 00059000
*                                                                     * 00060000
*       F.  UNLOAD A COPY OF THE PDS LOAD MODULE USING IEBCOPY.       * 00061000
*                                                                     * 00062000
*       G.  UNLOAD THE DATA SET IN QUESTION WITH IEBCOPY OR AN        * 00063000
*           APPROPRIATE UTILITY.                                      * 00064000
*                                                                     * 00065000
*       H.  BE SURE TO INCLUDE YOUR NAME AND PHONE NUMBER SO THAT     * 00066000
*           ANY RESULTS OR QUESTIONS CAN BE REFERRED BACK TO YOU.     * 00067000
*                                                                     * 00068000
*                                                                     * 00069000
*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 00070000
         TITLE 'P D S  --  PDS COMMAND PURPOSE                 1/15/85' 00071000
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 00072000
* TITLE -      P D S     --    TSO PDS COMMAND PROCESSOR              * 00073000
*                                                                     * 00074000
* FUNCTION -   PROVIDE A TSO USER WITH THE CAPABILITY                 * 00075000
*              TO MANIPULATE A PARTITIONED DATA SET                   * 00076000
*                                                                     * 00077000
* OPERATION -  ACCEPT FROM THE TSO USER THE NAME OF A PARTITIONED     * 00078000
*              DATA SET AND PERFORM ANY OF THE SUBCOMMANDS:           * 00079000
*                                                                     * 00080000
*        ATTRIB   - DISPLAY (OR MODIFY) LOAD MODULE ATTRIBUTES        * 00081000
*        ALIAS    - ASSIGN AN ALIAS TO A MEMBER                       * 00082000
*        BROWSE   - BROWSE A MEMBER WITH SPF (SPF DIALOG)             * 00083000
*        CHANGE   - CHANGE TO A DIFFERENT DATA SET                    * 00084000
*        COMPARE  - COMPARE TWO MEMBERS                               * 00085000
*        COMPRESS - COMPRESS THE DATA SET                             * 00086000
*        CONTROL  - SET PROGRAM CONTROL VARIABLES                     * 00087000
*        DISPLAY  - DISPLAY ALL OR PART OF THE DIRECTORY              * 00088000
*        DIRENTRY - DUMP A MEMBER'S DIRECTORY ENTRY                   * 00089000
*        DELETE   - DELETE A MEMBER                                   * 00090000
*        DSNAME   - DISPLAY THE CURRENT DATA SET ALLOCATION           * 00091000
*        DSPRINT  - PRODUCE A HARDCOPY USING DSPRINT                  * 00092000
*        EDIT     - EDIT A MEMBER USING SPF                           * 00093000
*        END      - TERMINATE THE PDS COMMAND                         * 00094000
*        EXEC     - EXECUTE PDS SUBCOMMANDS FROM A CLIST SOURCE       * 00095000
*        FIND     - LIST LINES CONTAINING A SEARCH STRING             * 00096000
*        FIXPDS   - MODIFY THE ALLOCATED PARTITIONED DATA SET         * 00097000
*        FSE      - EDIT A MEMBER WITH THE FSE COMMAND                * 00098000
*        HELP     - DISPLAY SUBCOMMAND HELP FOR PDS                   * 00099000
*        HISTORY  - LIST HISTORY OF A LOAD MODULE                     * 00100000
*        IF       - TEST A MEMBER FOR GIVEN ATTRIBUTES                * 00101000
*        ISPF     - INVOKE ISPF PRIMARY OPTIONS PANEL WITH OPTIONS    * 00102000
*        ISPMODE  - INVOKE DIALOG SUPPORT FOR PDS                     * 00103000
*        LIST     - LIST CONTENTS OF A MEMBER                         * 00104000
*        MAP      - MAP A LOAD MODULE                                 * 00105000
*        MEMBERS  - DISPLAY MEMBERS IN A GROUP                        * 00106000
*        OPTIONS  - DISPLAY THE SUBCOMMAND MENU                       * 00107000
*        OUTCOPY  - OUTPUT IEBCOPY SELECT STATEMENTS                  * 00108000
*        PATTERN  - DISPLAY DIRECTORY BASED ON MEMBER NAME SEGMENTS   * 00109000
*        PRINTOFF - PRINT A MEMBER WITH THE TSO PRINTOFF COMMAND      * 00110000
*        RECALL   - DISPLAY OR REISSUE THE PREVIOUS SUBCOMMAND        * 00111000
*        RENAME   - RENAME A MEMBER                                   * 00112000
*        RESTORE  - RESURRECT A PREVIOUSLY DELETED MEMBER             * 00113000
*        REVIEW   - BROWSE DATA WITH THE REVIEW COMMAND               * 00114000
*        SUBMIT   - SUBMIT A JCL MEMBER                               * 00115000
*        TSO      - EXECUTE A TSO COMMAND                             * 00116000
*        TSOEDIT  - EDIT A MEMBER WITH TSO EDIT                       * 00117000
*        TSOLIST  - LIST A MEMBER WITH THE TSO LIST COMMAND           * 00118000
*        USAGE    - LIST DATA SET STATISTICS                          * 00119000
*        VERIFY   - CHECK THE DATA SET FOR VALIDITY ERRORS            * 00120000
*                                                                     * 00121000
* WRITTEN    - BY TOM SPRINGER AT FIREMAN'S FUND (NOW WITH IBM)       * 00122000
* MODIFIED   - BY WILLIAM FINKELSTEIN, WITH CITIBANK IN LOS ANGELES   * 00123000
* MODIFIED   - BY STEVEN SMITH, WITH SECURITY PACIFIC NATIONAL BANK   * 00124000
* MAINTAINED - BY BRUCE LELAND, WITH HITACHI AMERICA, LTD.            * 00125000
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 00126000
         TITLE 'P D S  --  PDS COMMAND CHANGE DOCUMENTATION    1/15/85' 00127000
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 00128000
*                                                                     * 00129000
*  CHANGE SECTION:                                                    * 00130000
*                                                                     * 00131000
****VER 2.0: ADDED FORMATTING OPTIONS FOR LIST;                    **** 00132000
*            ADDED EDIT, FIND AND SUBMIT SUBCOMMANDS.                 * 00133000
*                                                                     * 00134000
****VER 2.2: CORRECTED AN ERROR IN LIST AND FIND FOR DATA SETS     **** 00135000
*       WITH ASA OR MACHINE CARRIAGE CONTROLS.                        * 00136000
*                                                                     * 00137000
****VER 2.3: MADE SEVERAL IMPROVEMENTS AS SUGGESTED BY DINESH      **** 00138000
*       DATTANI FROM PRUDENTIAL INSURANCE CO. OF AMERICA, TORONTO     * 00139000
*       1.  OUTPUT THE PROGRAM OPTION LIST IN SORTED ORDER.           * 00140000
*       2.  ADDED SEVERAL EDIT DESCRIPTIVE QUALIFIERS.                * 00141000
*                                                                     * 00142000
****VER 3.0: UPDATED THE PDS COMMAND FOR MVS USE BASED ON A        **** 00143000
*       VERSION OF THE PDS COMMAND ON THE CBT MODS TAPE.              * 00144000
*       1.  ADDED EXEC (EXPLICIT AND IMPLIED) AND HELP SUBCOMMANDS.   * 00145000
*       2.  A SINGLE CHARACTER SUBCOMMAND NAME IS NOT AMBIGUOUS.      * 00146000
*       3.  SUPPORT WAS ADDED IN THE FOLLOWING AREAS:                 * 00147000
*           -- SSI INFORMATION DISPLAY                                * 00148000
*           -- APF DATA CAN BE LISTED AND MODIFIED                    * 00149000
*           -- HEXADECIMAL MEMBER NAMES ALLOWED AS INPUT              * 00150000
*           -- HEXADECIMAL OUTPUT ADDED - DISPLAY, PATTERN, MEMBERS   * 00151000
*           -- $PUTGET, $PUTLINE AND MESSAGE MACROS WERE ADDED        * 00152000
*           -- ATTRIB LISTS ALL ALIASES FOR A GIVEN MODULE            * 00153000
*       4.  SEVERAL SOURCES OF 0C7'S WERE CORRECTED FOR IDR DATA.     * 00154000
*       5.  THE MEMBER NAME VALIDITY CHECK ROUTINE HAD TWO BUGS:      * 00155000
*           --  THE MEMBER NAME LENGTH USED WAS THE INPUT NAME        * 00156000
*               LENGTH (INCORRECT FOR HEXADECIMAL NAMES)              * 00157000
*           --  PROMPTING FOR INVALID MEMBER NAMES WAS INCORRECT      * 00158000
*       6.  THE ATTRIB SUBCOMMAND SOMETIMES LISTED SSI INFORMATION    * 00159000
*           FOR NON-LOAD MODULES WHICH DID NOT HAVE ANY SSI DATA.     * 00160000
*                                                                     * 00161000
****VER 3.1: SEVERAL GENERAL CHANGES WERE MADE                     **** 00162000
*       1.  THE PATTERN SUBCOMMAND WAS ADDED.                         * 00163000
*       2.  DEFAULT MEMBER NAMES ARE ALLOWED FOR ATTRIB, BROWSE,      * 00164000
*           DELETE, DIRENTRY, DSPRINT, EDIT, FSE, FIND, HISTORY, IF,  * 00165000
*           LIST, MAP, MEMBERS, OUTCOPY, PRINTOFF, REVIEW, SPFEDIT,   * 00166000
*           SUBMIT AND TSOLIST SUBCOMMANDS.                           * 00167000
*       3.  PDS WAS ADDED AS AN ALIAS FOR THE CHANGE SUBCOMMAND.      * 00168000
*       4.  ALIAS SUBCOMMAND IS NOT PREVENTED FROM WORKING IF THE     * 00169000
*           APF DATA LENGTH IS INVALID (APF=0 IS USED).               * 00170000
*       5.  EDIT PREVIOUSLY USED THE PREVIOUS PDL FOR DEFAULT         * 00171000
*           MEMBERS; NOW THE EDIT WORK AREA IS SAVED BEFORE EACH      * 00172000
*           SUBCOMMAND SCAN.                                          * 00173000
*                                                                     * 00174000
****VER 4.0: MADE SEVERAL IMPROVEMENTS AS SUGGESTED BY SEYMOUR     **** 00175000
*        METZ FROM COMNET IN WASHINGTON, D.C.:                        * 00176000
*        1.  REPLACED IBM/360 INSTRUCTIONS WITH THEIR IBM/370         * 00177000
*            EQUIVALENTS (ICM, STCM, MVCL, ...)                       * 00178000
*        2.  REPLACED BCR INSTRUCTIONS WITH EQUIVALENT MNEMONICS.     * 00179000
*        3.  TSO SERVICE ROUTINE ADDRESSES ARE NOW OBTAINED FROM      * 00180000
*            THE CVT INSTEAD OF VIA LOAD/DELETE CODE.                 * 00181000
*                                                                     * 00182000
****VER 4.1: SEVERAL ADDITIONAL CHANGES WERE MADE TO TAKE          **** 00183000
*        ADVANTAGE OF MVS PROGRAM LOGIC AND SERVICE ROUTINES:         * 00184000
*        1.  USED THE DAIRFAIL MESSAGE ROUTINE INSTEAD OF INTERNALLY  * 00185000
*            GENERATING MESSAGES AS SUGGESTED BY SEYMOUR METZ.        * 00186000
*        2.  USED THE GENERAL FAIL MESSAGE ROUTINE FOR PARSE ERRORS.  * 00187000
*        3.  USED THE TSO DEFAULT ROUTINE TO FULLY QUALIFY DSNAMES.   * 00188000
*        4.  CHANGED THE ALLOCATION STRATEGY TO "PERMANENTLY"         * 00189000
*            ALLOCATE DATA SETS SO THAT EXTERNAL PDS SUBCOMMANDS      * 00190000
*            CAN USE AN UNCATALOGED DATA SET AFTER IT IS ALLOCATED    * 00191000
*            BY PDS.  THIS CHANGE WAS SUGGESTED BY JOE RAREY          * 00192000
*            WITH MARTIN-MARRIETA IN FLORIDA.                         * 00193000
*                                                                     * 00194000
****VER 4.2: AFTER THE DAIRFAIL CHANGES INDICATED ABOVE, THE       **** 00195000
*            VOLUME PARAMETER FOR UNCATALOGED DATA SETS DID NOT WORK. * 00196000
*                                                                     * 00197000
****VER 4.3: CORRECTED ONE SOURCE OF 0C4'S IN LISTING HISTORY      **** 00198000
*            DATA AS REPORTED BY ARNIE CASINGHINO FROM CBT.           * 00199000
*                                                                     * 00200000
****VER 4.4: ADDED THE RESTORE SUBCOMMAND TO RESURRECT DELETED     **** 00201000
*            PDS MEMBERS.  ALSO, CLEANED UP SOME PDS CODE AS          * 00202000
*            SUGGESTED BY SEYMOUR METZ FROM COMNET AND ADDED A        * 00203000
*            SYSPARM ASSEMBLY PARAMETER FOR GENERATING PDS.           * 00204000
*                                                                     * 00205000
****VER 4.5: ADDED THE FOLLOWING SUBCOMMANDS                       **** 00206000
*                                                                     * 00207000
*            TSOLIST: A SUBCOMMAND TO LINK TO THE TSO LIST COMMAND    * 00208000
*            AS SUGGESTED BY SEYMOUR METZ.                            * 00209000
*                                                                     * 00210000
*            PRINTOFF: A SUBCOMMAND TO LINK TO THE PRINTOFF COMMAND   * 00211000
*            AS SUGGESTED BY DAVID FILSINGER OF FACSO (SHARE CODE CB) * 00212000
*                                                                     * 00213000
*            DELETE:  NEW, PREFERRED ALIAS FOR THE SCRATCH SUBCOMMAND * 00214000
*                                                                     * 00215000
****VER 5.0: ADDED ANOTHER BASE REGISTER AND MADE SEVERAL          **** 00216000
*            SUBCOMMAND CHANGES:                                      * 00217000
*                                                                     * 00218000
*        ATTRIB, BROWSE, DELETE, DIRENTRY, DSPRINT, EDIT, FIND, FSE,  * 00219000
*        HISTORY, IF, LIST, MAP, MEMBERS, OUTCOPY, PRINTOFF, REVIEW,  * 00220000
*        SPFEDIT, SUBMIT AND TSOLIST:                                 * 00221000
*          1.  ADDED THE * NOTATION (MEANS USE PREVIOUS MEMBER NAME)  * 00222000
*          2.  ADDED MEMBER NAME GROUPS (RANGES AND PATTERNS)         * 00223000
*          3.  ENTER "HELP GROUP" FOR MORE INFORMATION                * 00224000
*                                                                     * 00225000
*        BROWSE AND SPFEDIT: ADDED SUBCOMMANDS WHICH MAKE PDS A SPF   * 00226000
*        DIALOG SO IT CAN USE BROWSE AND EDIT SERVICE FOR A MEMBER.   * 00227000
*        HELP ON FULL SCREEN, SPF AND ISPF INTERFACES WAS PROVIDED    * 00228000
*        BY MIKE LOOS WITH DELUXE CHECK PRINTERS IN MINNESOTA.        * 00229000
*                                                                     * 00230000
*        ATTRIB:                                                      * 00231000
*          1.  FORMAT AND DISPLAY ANY SPF STATISTICS IN SPF FORMAT.   * 00232000
*          2.  DISPLAY ENTRY POINT ADDRESS, MODULE SIZE AND THE LAST  * 00233000
*              LINKAGE-EDIT DATE FOR LOAD MODULES.                    * 00234000
*          3.  FIXED A STORAGE OVERLAY FOR MEMBERS WITH MANY ALIASES. * 00235000
*          4.  ADDED THE PAGE AND NOPAGE KEYWORDS.                    * 00236000
*                                                                     * 00237000
*        ALIAS:                                                       * 00238000
*          1.  NOW WORKS FOR SCATTER LOADED MEMBERS                   * 00239000
*          2.  IF A MODULE IS CREATED BY THE OS/VS LINKAGE EDITOR     * 00240000
*              AND HAS SSI INFORMATION, THE ALIAS WILL ALSO.          * 00241000
*          3.  AN ALIAS CAN NOW BE ASSIGNED TO AN ALIAS MEMBER.       * 00242000
*          4.  FIXED A BUG: AN ASSIGNED ENTRY POINT OF ZERO           * 00243000
*              SOMETIMES DID NOT GET THE ENTRY POINT ZERO FLAG SET.   * 00244000
*                                                                     * 00245000
*        EDIT: ALLOWS EDITING OF NEW MEMBERS.                         * 00246000
*                                                                     * 00247000
*        RESTORE: NOW OPERATES ON LOAD MODULES.                       * 00248000
*                                                                     * 00249000
*        ATTRIB AND MAP: IF NO MAIN MEMBER NAME CAN BE FOUND FOR AN   * 00250000
*        ALIAS IN A LOAD LIBRARY, THE NAME STORED IN THE DIRECTORY    * 00251000
*        ENTRY AS THE MAIN ENTRY IS DISPLAYED.                        * 00252000
*                                                                     * 00253000
*        FIND: ADDED FIRST/NOFIRST KEYWORDS AND HEXADECIMAL STRINGS.  * 00254000
*                                                                     * 00255000
*        FIND AND LIST:                                               * 00256000
*          1.  ADDED SUPPORT FOR RECORD FORMAT U DATA SETS.           * 00257000
*          2.  ADDED SUPPORT FOR NON-PARTITIONED DATA SETS.           * 00258000
*          3.  ADDED LBLOCK, LDUMP, BLOCK AND DUMP FORMATS.           * 00259000
*          4.  ADDED SKIPREC, MAXIN, MAXOUT, SKIPCOL AND MAXLEN.      * 00260000
*          5.  NUM FORMAT CHECKS FOR DATA SAVED BY SPF EDIT.          * 00261000
*          6.  NUM FORMAT CHECKS FOR NUMERIC LINE NUMBERS AND         * 00262000
*              SWITCHES TO NONUM MODE FOR THE REMAINDER OF A          * 00263000
*              MEMBER IF AN INVALID LINE NUMBER IS ENCOUNTERED.       * 00264000
*                                                                     * 00265000
*        PATTERN AND DISPLAY:  UNPRINTABLE LETTERS ARE DISPLAYED AS   * 00266000
*        PERIODS.  ALSO, HEXADECIMAL/CHARACTER DISPLAYS ARE FORCED    * 00267000
*        FOR ANY MEMBER NAME WHICH IS NOT VALID.  NOTE: VALID MEMBER  * 00268000
*        NAMES CONTAIN UPPER-CASE ALPHANUMERIC CHARACTERS (WHICH      * 00269000
*        INCLUDES #, $ AND @) AND THE FIRST CHARACTER OF A VALID      * 00270000
*        MEMBER NAME IS UPPER-CASE ALPHABETIC.                        * 00271000
*                                                                     * 00272000
*        CHANGE AND PDS:                                              * 00273000
*          1.  IF A DSNAME IS NOT ENTERED WITH THE SUBCOMMAND,        * 00274000
*              THE PREVIOUSLY USED DATA SET IS ASSUMED.               * 00275000
*          2.  ADDED THE SHR AND OLD DATA SET KEYWORDS.               * 00276000
*                                                                     * 00277000
*        DIRENTRY: SUBCOMMAND WAS ADDED TO DUMP A DIRECTORY ENTRY.    * 00278000
*                                                                     * 00279000
*        MEMBERS: SUBCOMMAND WAS ADDED TO DISPLAY A MEMBER GROUP.     * 00280000
*                                                                     * 00281000
*        RESTORE, LIST, MAP, HISTORY AND ALIAS: FIXED A BUG; THE      * 00282000
*        NEWEXTENT SUBROUTINE ALLOWED THE USE OF ONE TOO MANY EXTENTS.* 00283000
*                                                                     * 00284000
****VER 5.1:  MADE SOME CODE CLEANUP CHANGES;                      **** 00285000
*                                                                     * 00286000
*        DELETED THE READ OF THE JFCB FOR THE INPUT DATA SET.         * 00287000
*                                                                     * 00288000
*        EXCP'S ARE NOW ALL IN AN EXCP SUBROUTINE; SET AND READ       * 00289000
*        SECTORS ARE PERFORMED FOR ALL DISK DRIVES EXCEPT 2314'S.     * 00290000
*                                                                     * 00291000
*                                                                     * 00292000
*        AN OBTAIN IS ALWAYS PERFORMED ONCE FOR EACH INPUT DATA       * 00293000
*        SET (NOT WHEN NEEDED AS BEFORE IN RESTORE AND USAGE).        * 00294000
*                                                                     * 00295000
*        ALL PDS BLDL'S ARE PERFORMED BEFORE INVOKING THE PROCESSING  * 00296000
*        SUBROUTINE.  IN ADDITION, PDS MAINTAINS THE STATUS OF THE    * 00297000
*        CURRENT BLDL SO THAT UNNECESSARY BLDL'S CAN BE AVOIDED.      * 00298000
*                                                                     * 00299000
*        ADDED A RESTORE SUBCOMMAND TEST FACILITY:  AN EXISTING       * 00300000
*        MEMBER MAY BE "RESTORED" IF THE RESTORE MEMBER NAME BEGINS   * 00301000
*        WITH "TEMP".  USE THE DIRENTRY SUBCOMMAND TO COMPARE THEIR   * 00302000
*        DIRECTORY ENTRIES (REMEMBER TO DELETE THE TEMP MEMBER SINCE  * 00303000
*        YOU HAVE AN APPARENT ALIAS -- NEITHER HAS AN ALIAS BIT SET). * 00304000
*                                                                     * 00305000
****VER 5.2:  ADDED SUPPORT FOR TRACK OVERFLOW RECORDS AS WELL     **** 00306000
*        AS THE FOLLOWING OTHER CHANGES:                              * 00307000
*                                                                     * 00308000
*        CHANGE AND PDS: IF A VOLUME NAME IS SUPPLIED, SYSALLDA IS    * 00309000
*        USED AS THE UNIT NAME; OTHERWISE, THE UNIT NAME FROM THE     * 00310000
*        PSCB WOULD BE USED (WHICH MIGHT NOT COVER THE VOLUME TO BE   * 00311000
*        ALLOCATED).  REPORTED BY BILL COWAN WITH THE COCA-COLA       * 00312000
*        COMPANY IN ATLANTA, GEORGIA.                                 * 00313000
*                                                                     * 00314000
*        DELETE: ALLOWS MEMBER GROUPS AND DEFAULT MEMBER NAMES AS     * 00315000
*        REQUESTED BY ARNIE CASINGHINO FROM CBT.                      * 00316000
*                                                                     * 00317000
*        ATTENTION HANDLING IMPROVEMENTS -- TWO ATTENTIONS IN A ROW   * 00318000
*        ARE GENERALLY REQUIRED TO TERMINATE PDS; ALL SUBCOMMANDS     * 00319000
*        NOW RECOGNIZE ATTENTION INTERRUPTS TO SOME DEGREE:           * 00320000
*        A.  PDS ATTENTION HANDLING IS NOW DOCUMENTED IN PDS'S HELP   * 00321000
*            (ENTER "HELP ATTN" FOR MORE INFORMATION).                * 00322000
*        B.  FIXED A BUG: A NULL RESPONSE TO "ENTER OPTION" AFTER     * 00323000
*            AN ATTENTION DID NOT ALLOW THE SUBCOMMAND TO CONTINUE.   * 00324000
*        C.  THE INPUT ROUTINE NOW ALSO CHECKS FOR ATTENTION -- THIS  * 00325000
*            ELIMINATES WAITING UNTIL A MESSAGE IS OUTPUT AS BEFORE.  * 00326000
*                                                                     * 00327000
*        OPEN: FIXED ABEND 013-D0 FOR RECFM=FS OR FBS.  THIS PROBLEM  * 00328000
*        WAS REPORTED BY JAMES BERRY FROM WESTLAKE VILLAGE, CALIF.    * 00329000
*                                                                     * 00330000
*        ALIAS, RENAME AND RESTORE: CHANGE THE DEFAULT MEMBER NAME AS * 00331000
*        SUGGESTED BY JOHN SULLIVAN AT LOMA LINDA UNIVERSITY, CALIF.  * 00332000
*                                                                     * 00333000
****VER 5.3:  CHANGED THE CSECT STRUCTURE OF PDS AND MADE THE      **** 00334000
*        FOLLOWING OTHER CHANGES:                                     * 00335000
*                                                                     * 00336000
*        SPFEDIT AND BROWSE:                                          * 00337000
*        A.  THE INITIALIZATION ADDRESS FOR PDS PASSED TO ISPF IS     * 00338000
*            NOW CONVERTED TO DECIMAL BEFORE THE CALL AND CONVERTED   * 00339000
*            BACK TO BINARY ON THE RECURSIVE ENTRY IN PDS DUE TO THE  * 00340000
*            POTENTIAL PROBLEM OF A X'5D' (A RIGHT PARENTHESIS) IN    * 00341000
*            THE ADDRESS.  THIS WAS REPORTED BY SEYMOUR METZ, U.S.    * 00342000
*            DEPARTMENT OF STATE.                                     * 00343000
*        B.  A PARAMETER LIST PASSED TO INITIALIZE SPF OR ISPF MUST   * 00344000
*            NOT BE REUSED BY THE CALLING PROGRAM SINCE SPF USES IT   * 00345000
*            LATER IF IT SPLITS THE USER'S SCREEN.  THIS PROBLEM WAS  * 00346000
*            RESOLVED BY MIKE LOOS WITH DELUXE CHECK PRINTERS.        * 00347000
*        BROWSE: THE ALLOCATED FILE IS NOW FREED BEFORE EACH CALL     * 00348000
*        TO SPF SINCE THE DATA SET COULD BE UPDATED IN A SUBSEQUENT   * 00349000
*        SPLIT SCREEN.                                                * 00350000
*                                                                     * 00351000
*        EDIT AND SPFEDIT: ADDED NEW AND OLD KEYWORDS TO ALLOW BLDL   * 00352000
*        CHECKING OF MEMBER NAMES BEFORE ENTERING EITHER EDITOR.      * 00353000
*                                                                     * 00354000
*        END: THE RETURN CODE ASSIGNED BY THE PROGRAM IS NOW SAVED    * 00355000
*        TEMPORARILY IN THE PROGRAM'S STORAGE; IN VERSION 5.2 THE     * 00356000
*        RETURN CODE IS CHANGED DURING A CALL TO FREE THE FILE AND    * 00357000
*        A STACK DELETE IS INCORRECTLY ISSUED AT PDS TERMATION.       * 00358000
*                                                                     * 00359000
*        CHANGE AND PDS: THE DATA SET ALLOCATION STATUS IS DISPLAYED  * 00360000
*        AFTER EACH DATA SET IS ALLOCATED.                            * 00361000
*                                                                     * 00362000
*        ATTRIB:                                                      * 00363000
*          1.  ADDED ALIASINFO AND NOALIASINFO KEYWORDS               * 00364000
*          2.  ADDED LKEDDATE AND NOLKEDDATE KEYWORDS                 * 00365000
*          3.  A LIST OF ATTRIBUTES TO BE ASSIGNED TO A MODULE        * 00366000
*              CAN NO LONGER BE PLACED IN PARENTHESES.                * 00367000
*                                                                     * 00368000
*        UNDOCUMENTED SUBCOMMANDS:                                    * 00369000
*          1. COMPRESS OPERAND "SHR" -- EVALUATE THIS BEFORE USING    * 00370000
*          2. KLEAR (OR K -- CLEARS 3270 DISPLAY SCREENS)             * 00371000
*          3. W (DUMMY SUBCOMMAND FOR EXECUTING PDS UNDER TEST)       * 00372000
*                                                                     * 00373000
*                                                                     * 00374000
*                                                                     * 00375000
*        IF: ADDED SUBCOMMAND TO TEST MEMBERS FOR GIVEN ATTRIBUTES    * 00376000
*        AND PERFORM CONDITIONAL PROCESSING AS SUGGESTED BY JIM BERRY * 00377000
*        FROM WESTLAKE VILLAGE, CALIFORNIA:                           * 00378000
*                                                                     * 00379000
*        FIND: ADDED THEN AND ELSE CONDITIONAL PROCESSING             * 00380000
*        CAPABILITIES AS IMPLEMENTED IN THE IF SUBCOMMAND.            * 00381000
*                                                                     * 00382000
*        MAP: DELETED THE SMAP SUBCOMMAND AND MADE SEVERAL CHANGES -  * 00383000
*           1.  ADDED FULL, SHORT AND ENTRY KEYWORDS                  * 00384000
*           2.  ADDED MODULE NAME FILTERING                           * 00385000
*                                                                     * 00386000
*        HISTORY: ADDED TRANSLATOR IDENTIFICATION MESSAGES AND        * 00387000
*        MADE SEVERAL ADDITIONAL CHANGES -                            * 00388000
*           1.  ADDED MODULE NAME FILTERING                           * 00389000
*           2.  ADDED TRAN(PARTNAME)                                  * 00390000
*           3.  ADDED ZAP(PARTNAME)                                   * 00391000
*           4.  ADDED USER(PARTNAME)                                  * 00392000
*           5.  FIXED A BUG - IF A IDR USER RECORD HAD CONTINUED      * 00393000
*               HEADER DATA, ITS DATE WAS NOT INITIALIZED.            * 00394000
*                                                                     * 00395000
*        MEMBER PROTECTION: THE DELETE, EDIT, FIXPDS, FSE, SPF AND    * 00396000
*        RENAME SUBCOMMANDS ISSUE SPF-STYLE ENQUEUE CHECKS BEFORE     * 00397000
*        UPDATING THE ALLOCATED DATA SET.  THIS ENQUEUE CHECK CANNOT  * 00398000
*        DETECT A USER FROM ANOTHER CPU UPDATING THE MEMBER THROUGH   * 00399000
*        SHARED DASDI (THIS IS ALSO AN SPF PROBLEM).                  * 00400000
*                                                                     * 00401000
*                                                                     * 00402000
*                                                                     * 00403000
*        DATA SET PROTECTION: THE PDS GENERATION OPTIONS OF OLD, SHR, * 00404000
*        AND OPER HAVE BEEN REMOVED -- THE DATA SET'S INTEGRITY CAN   * 00405000
*        BE INSURED BY USING DISPOSITION "OLD" ON THE CHANGE OR PDS   * 00406000
*        SUBCOMMAND.  ALSO, SEE THE FOLLOWING NOTES ON SHR UPDATES    * 00407000
*        AND MEMBER PROTECTION.                                       * 00408000
*                                                                     * 00409000
*        SHR UPDATES: PDS NOW USES SPF RESERVE LOGIC TO PROTECT THE   * 00410000
*        INTEGRITY OF DATA SETS ALLOCATED AS SHR DURING ANY UPDATES.  * 00411000
*        THIS CHANGE AFFECTS THOSE PDS SUBCOMMANDS WHICH UPDATE THE   * 00412000
*        DATA SET BEING PROCESSED (ALIAS, ATTRIB WITH ATTRIBUTE       * 00413000
*        CHANGES, DELETE, FIXPDS, RENAME, RESTORE AND VERIFY          * 00414000
*        SUBCOMMANDS) AND WAS SUGGESTED BY ARNIE CASINGHINO WITH CBT. * 00415000
*        ENTER "HELP UPDATE" FOR MORE INFORMATION.                    * 00416000
*                                                                     * 00417000
*        ESTAE PROCESSING: PDS CAN NOW RECOVER FROM ABENDS (EXCEPT    * 00418000
*        IN THE SPFEDIT AND BROWSE SUBCOMMANDS).  ENTER "HELP ABEND"  * 00419000
*        FOR MORE INFORMATION.                                        * 00420000
*                                                                     * 00421000
*        RESTORE: ADDED CONTROL KEYWORDS AS SUGGESTED BY              * 00422000
*        GEORGE GOFFE WITH THE AMDAHL CORPORATION, SUNNYVALE, CALIF.  * 00423000
*                                                                     * 00424000
*        EXTERNAL SUBCOMMANDS: SUBCOMMANDS EXTERNAL TO PDS ARE NOW    * 00425000
*        ATTACHED INSTEAD OF LINKED TO.  THIS WAS SUGGESTED BY        * 00426000
*        SEYMOUR METZ WITH THE STATE DEPARTMENT.  THIS CHANGE MAKES   * 00427000
*        THE FOLLOWING IMPROVEMENTS POSSIBLE:                         * 00428000
*           1.  PDS CAN RECOVER FROM ABENDS IN THESE SUBCOMMANDS      * 00429000
*           2.  PDS CAN FREE ALLOCATED FILES AND MOST OTHER RESOURCES * 00430000
*               OBTAINED BY THESE SUBCOMMANDS                         * 00431000
*           3.  PDS CAN PERFORM ATTENTION PROCESSING IN BEHALF OF     * 00432000
*               THESE SUBCOMMANDS                                     * 00433000
*                                                                     * 00434000
*        ATTRIB: ANY APPARENT ALIASES FOR A MEMBER ARE DISPLAYED (AS  * 00435000
*        WELL AS ACTUAL ALIASES) DURING THE ALIAS SEARCH FOR A MEMBER.* 00436000
*                                                                     * 00437000
*        ATTRIB AND MAP: ALL CORRESPONDING MAIN MEMBERS FOR AN ALIAS  * 00438000
*        MEMBER ARE DISPLAYED (NOT JUST THE FIRST ONE AS BEFORE).     * 00439000
*                                                                     * 00440000
*        BACKGROUND USE OF PDS: A BLANK LINE IS OUTPUT BETWEEN EACH   * 00441000
*        SUBCOMMAND FOR READABILITY; ALSO, THE PROGRAM CIRCUMVENTS    * 00442000
*        PROMPTS FOR YES/NO DECISIONS BY SIMULATING YES RESPONSES.    * 00443000
*                                                                     * 00444000
*        TSSO SUPPORT:  A SINGLE SUBCOMMAND MAY NOW BE ENTERED ON THE * 00445000
*        PRIMARY COMMAND LINE; PDS WILL PROCESS THE SUBCOMMAND AND    * 00446000
*        TERMINATE.  THIS WAS SUGGESTED BY ARNIE CASINGHINO WITH CBT. * 00447000
*                                                                     * 00448000
*        FIXPDS:  ADDED SUBCOMMAND TO MODIFY THE ALLOCATED DATA SET.  * 00449000
*        THE EXPANDDIR OPTION WAS DERIVED FROM FILE 288 OF THE CBT    * 00450000
*        TAPE AS SUGGESTED BY ARNIE CASINGHINO WITH CBT.              * 00451000
*                                                                     * 00452000
*        NON-PARTITIONED DATA SETS:  PARSE DATA FOR THE MEMBER NAME   * 00453000
*        POSITITION IS NO LONGER ENTERED. ALSO, SUPPORT HAS BEEN      * 00454000
*        ADDED FOR NON-PARTITIONED DATA SETS FOR BROWSE, EDIT,        * 00455000
*        DSPRINT, FIND, FSE, LIST, PRINTOFF, SPFEDIT, SUBMIT,         * 00456000
*        REVIEW, TSOLIST AND VERIFY.                                  * 00457000
*                                                                     * 00458000
****VER 6.0:  MADE THE FOLLOWING CHANGES:                          **** 00459000
*                                                                     * 00460000
*        SPF AND ISPF USERS: PDS CAN BE INVOKED AS A SPF DIALOG USING * 00461000
*        THE PROVIDED SPF PANEL AND MESSAGE MEMBER.  THIS CHANGE      * 00462000
*        WAS SUGGESTED BY JAMES W. BERRY FROM WESTLAKE VILLAGE, CAL.  * 00463000
*                                                                     * 00464000
*        RENAME: IF A NON-ALIAS LOAD MODULE IS RENAMED, ADDITIONAL    * 00465000
*        CODE IN RENAME WILL UPDATE THE CHANGED NAME POINTERS IN      * 00466000
*        ANY ASSOCIATED ALIAS DIRECTORY ENTRIES.                      * 00467000
*                                                                     * 00468000
*        VERIFY: ADDED A SUBCOMMAND TO CHECK A DATA SET FOR           * 00469000
*        VALIDITY ERRORS.                                             * 00470000
*                                                                     * 00471000
*        IF: ADDED SEVERAL MEMBER VALIDITY CHECKS IN SUPPORT OF       * 00472000
*        THE NEW VERIFY SUBCOMMAND.                                   * 00473000
*                                                                     * 00474000
*        FROM ARNIE CASINGHINO (CBT):                                 * 00475000
*        A.  MODIFIED THE SCREEN CLEAR TPUT FOR KLEAR TO SUPPORT      * 00476000
*            3278-5 TERMINALS UNDER ACF/TCAM.                         * 00477000
*        B.  MODIFIED RESERVE LOGIC FOR BATCH EXECUTIONS OF PDS       * 00478000
*            TO HOLD RESERVES UNTIL A NEW DATA SET IS SELECTED.       * 00479000
*        C.  ADDED KEYWORDS TO THE RESTORE SUBCOMMAND TO ALLOW        * 00480000
*            MULTIPLE MEMBER RESTORATIONS WITH AND WITHOUT PROMPTING. * 00481000
*        D.  MODIFIED FIXPDS TO ADD AN PADDING DIRECTORY BLOCK IF     * 00482000
*            A TRACK WILL BE FILLED WITH DIRECTORY BLOCKS.  THIS      * 00483000
*            IS DONE TO ENSURE THAT THE END OF FILE MARK IS ON THE    * 00484000
*            FOLLOWING TRACK AND IT AVOIDS IEBCOPY ABENDS.            * 00485000
*        E.  MODIFIED RENAME TO WORK ON A RANGE OF MEMBERS.           * 00486000
*                                                                     * 00487000
*        FROM GEORGE GOFFE (AMDAHL CORPORATION):                      * 00488000
*        A.  ADDED A SWAP OPERAND TO THE RENAME SUBCOMMAND TO         * 00489000
*            ALLOW TWO MEMBERS TO EXCHANGE MEMBER NAMES.              * 00490000
*        B.  THE PATTERN SUBCOMMAND MAY BE ENTERED WITHOUT OPERANDS   * 00491000
*            AND THE PREVIOUS PATTERN OPERAND(S) WILL BE USED.        * 00492000
*        C.  ADDED THE RECALL SUBCOMMAND TO DISPLAY OR REISSUE        * 00493000
*            AND DISPLAY THE PREVIOUSLY ENTERED SUBCOMMAND.           * 00494000
*                                                                     * 00495000
*        FROM JOHN SULLIVAN (LOMA LINDA UNIVERSITY MEDICAL CENTER):   * 00496000
*        A.  ADDED A NONE OPERAND FOR THE ATTRIB SUBCOMMAND TO        * 00497000
*            CHANGE ALL ATTRIBUTES OF A MODULE TO DEFAULT VALUES.     * 00498000
*        B.  CHANGED ALL MODULE SIZE DISPLAYS TO OUTPUT THE NEXT      * 00499000
*            HIGHER 1K BOUNDARY RATHER THAN THE CLOSEST 1K BOUNDARY.  * 00500000
*        C.  MODIFIED ATTRIB TO ALLOW DC ATTRIBUTE CHANGES.           * 00501000
*                                                                     * 00502000
*        HISTORY:  CORRECTED TO LIST HISTORY DATA IN DESCENDING ORDER * 00503000
*        IN EACH GROUP BY LAST CHANGE DATE, ADDED LINKAGE-EDITOR NAME * 00504000
*        FILTERING AND CHANGED SUBCOMMAND DEFAULTS.                   * 00505000
*                                                                     * 00506000
*        USE OF PDS CLISTS OR STACKED INPUT: THE PROGRAM CIRCUMVENTS  * 00507000
*        PROMPTS FOR YES/NO DECISIONS BY ASSUMING YES RESPONSES.      * 00508000
*                                                                     * 00509000
*        IF, VERIFY, ATTRIB: MADE CHANGES TO CHECK FOR MUTUALLY       * 00510000
*        EXCLUSIVE LOAD MODULE ATTRIBUTES (FOR EXAMPLE, OVERLAY       * 00511000
*        ATTRIBUTE WITH THE REENTRANT ATTRIBUTE).                     * 00512000
*                                                                     * 00513000
*        MVS/XA SUPPORT - MADE CHANGES FOR THE FOLLOWING SUBCOMMANDS: * 00514000
*        A.  IF: ADDED SELECTION BY RMODE AND AMODE                   * 00515000
*        B.  ATTRIB: ADDED RMODE AND AMODE ATTRIBUTE SUPPORT:         * 00516000
*              1.  ADDED RMODE AND AMODE CHANGE CAPABILITY            * 00517000
*              2.  ADDED RMODE AND AMODE DISPLAY CAPABILITY FOR       * 00518000
*                  MODULES WHOSE RMODE AND AMODE ARE NOT BOTH 24      * 00519000
*              3.  IF RMODE OR AMODE IS CHANGED FOR A NON-ALIAS       * 00520000
*                  MODULE, ADDITIONAL CODE IN ATTRIB WILL UPDATE      * 00521000
*                  THE RMODE AND THE MAIN MODULE AMODE VALUE FOR      * 00522000
*                  ANY ASSOCIATED ALIAS DIRECTORY ENTRIES.            * 00523000
*        C.  RESTORE: ADDED CODE TO SET THE RMODE AND AMODE FOR       * 00524000
*            A MODULE BASED ON INFORMATION FROM ITS ESD ENTRIES       * 00525000
*        D.  ALIAS: ADDED CODE TO SET THE RMODE AND AMODE BASED ON    * 00526000
*            ESD INFORMATION AND THE ALIAS BASE ENTRY'S ATTRIBUTES    * 00527000
*        E.  MAP: ADDED CODE TO DISPLAY RMODE AND AMODE FOR CSECTS    * 00528000
*            WHOSE RMODE AND AMODE ARE NOT BOTH 24                    * 00529000
*                                                                     * 00530000
*        OUTCOPY: ADDED A NEW SUBCOMMAND TO PRODUCE IEBCOPY CONTROL   * 00531000
*        STATEMENTS WHICH CAN BE USED TO SELECTIVELY COPY PDS MEMBERS * 00532000
*                                                                     * 00533000
*        FROM WALT FARRELL WITH RAINER NATIONAL BANK IN SEATTLE:      * 00534000
*        A.  THE "ENTER OPTION" PROMPT MESSAGE HAS BEEN EXPANDED      * 00535000
*            TO INCLUDE THE DSNAME AND VOLUME SERIAL NAME.            * 00536000
*        B.  ATTRIB FOR NON-LOAD MEMBERS, BROWSE, DELETE, FIND, FSE,  * 00537000
*            HISTORY, IF, MAP, OUTCOPY, PRINTOFF, REVIEW AND SPF      * 00538000
*            SUBCOMMANDS:  THE MEMBER NAME IDENTIFICATION FOR MEMBER  * 00539000
*            GROUPS IS NORMALLY SUPPRESSED.  FOR THE DELETE, FIND,    * 00540000
*            HISTORY, IF AND MAP SUBCOMMANDS, HOWEVER, THE HEADER IS  * 00541000
*            WRITTEN IF ANY OUTPUT IS GENERATED FOR A MEMBER.         * 00542000
*                                                                     * 00543000
*        SPFEDIT AND BROWSE: A DIALOG ERROR NO LONGER TERMINATES THE  * 00544000
*        PDS COMMAND, HOWEVER, THE PDS COMMAND WILL NOT ATTEMPT TO    * 00545000
*        REUSE THE SPF INTERFACE AFTER A DIALOG ERROR.                * 00546000
*                                                                     * 00547000
*        ATTENTION PROCESSING: STAX PROCESSING HAS BEEN MODIFIED      * 00548000
*        AND TWO ATTENTIONS SHOULD NOW TERMINATE A PDS PROGRAM LOOP.  * 00549000
*                                                                     * 00550000
*        FIXPDS:  MODIFIED TO PREVENT A RESET OR EXPANDED DIRECTORY   * 00551000
*        FROM OVERFLOWING THE FIRST DISK EXTENT.                      * 00552000
*                                                                     * 00553000
*        FROM RICHARD MCCARTY WITH HITACHI AMERICA IN SAN JOSE:       * 00554000
*        IN FIXPDS EXPAND, IF THE LAST ALLOCATED DIRECTORY BLOCK WAS  * 00555000
*        COMPLETELY FULL, PDS COULD NOT ADD ANY DIRECTORY BLOCKS.     * 00556000
*                                                                     * 00557000
*        DELETE: ADDED THE ALIAS OPERAND                              * 00558000
*                                                                     * 00559000
*        ATTRIB FOR NON-LOAD MEMBERS, BROWSE, FSE, PRINTOFF, REVIEW   * 00560000
*        AND SPFEDIT SUBCOMMANDS: THE DEFAULT MEMBER NAME MESSAGE IS  * 00561000
*        SUPPRESSED TO REDUCE THE LEVEL OF REDUNDANT INFORMATION.     * 00562000
*                                                                     * 00563000
*        FROM BEN MOORE (FEDERAL EXPRESS):                            * 00564000
*        A.  IF, ATTRIB, VERIFY: CHECKS FOR THE DIRECTORY             * 00565000
*            RLD/CONTROL COUNT NOT MATCHING THE FIRST RLD ENTRY.      * 00566000
*        B.  IF: ADDED THE RLDZERO AND NORLDZERO KEYWORDS.            * 00567000
*                                                                     * 00568000
****VER 6.1:  MADE SEVERAL MODIFICATIONS:                          **** 00569000
*                                                                     * 00570000
*        FIND AND LIST:                                               * 00571000
*        A.  CHANGED LOGIC TO SUPPORT OUTPUT OF CSECT INFORMATION     * 00572000
*            AS SUGGESTED BY BEN MOORE WITH FEDERAL EXPRESS.          * 00573000
*        B.  ADDED A SECOND DISPLACEMENT FIELD FOR LBLOCK, LDUMP      * 00574000
*            BLOCK AND DUMP OUTPUT FORMATS.                           * 00575000
*        C.  CHANGED SPELLING OF MULTILINE TO LBLOCK.                 * 00576000
*        D.  CHANGED SPELLING OF LINEDUMP TO LDUMP.                   * 00577000
*        E.  DEFAULT OUTPUT FORMAT FOR LOAD MODULES IS LDUMP.         * 00578000
*        F.  ADDED MODULE AND OFFSET OPERANDS FOR LBLOCK AND LDUMP.   * 00579000
*                                                                     * 00580000
*        FROM JOHN SULLIVAN (LOMA LINDA MEDICAL CENTER):              * 00581000
*        A.  MODIFIED HISTORY TO LIST SPF STATISTICS (LIKE THE        * 00582000
*            ATTRIB SUBCOMMAND) FOR NON-LOAD MEMBERS.                 * 00583000
*        B.  ADDED THE CONTROL SUBCOMMAND.                            * 00584000
*        C.  ADDED THE LIKE KEYWORD ON THE RESTORE SUBCOMMAND.        * 00585000
*        D.  CHANGED RESTORE SCAN TO ALSO CHECK THE PROVIDED TTR      * 00586000
*            TO SEE IF IT IS A DELETED MEMBER.                        * 00587000
*                                                                     * 00588000
*        PROGRAM INPUT PROCESSING: DOUBLE BUFFERING HAS BEEN ADDED.   * 00589000
*                                                                     * 00590000
*        DELETE: REWRITTEN TO TAKE ADVANTAGE OF DOUBLE BUFFERING.     * 00591000
*                                                                     * 00592000
*        PDS DIALOG ENTRY: CODE FOR LOCATING THE TSO ECT HAS BEEN     * 00593000
*        ADDED AS PROVIDED BY MIKE LOOS WITH DELUXE CHECK PRINTERS.   * 00594000
*                                                                     * 00595000
*        TSO SERVICE ROUTINE ADDRESSES: SINCE SOME INSTALLATIONS      * 00596000
*        MAY MOVE ROUTINES LIKE IKJPARS OUT OF LPALIB, PDS HAS BEEN   * 00597000
*        MODIFIED TO TEST FOR AN ACTUAL ADDRESS IN THE CVT AND        * 00598000
*        TO LOAD AND DELETE ANY REQUIRED MODULES AS SUGGESTED BY      * 00599000
*        JERRY MORRIS WITH GTE DATA SERVICES IN TAMPA, FLORIDA.       * 00600000
*                                                                     * 00601000
*        FIXPDS: BLOCKSIZE VALUES FOR DATA KEYWORDS SUCH AS ASM,      * 00602000
*        CLIST, CNTL, LOAD OR OBJECT ARE BASED ON THE DEVICE TYPE.    * 00603000
*                                                                     * 00604000
*        TSO TIME SUBCOMMAND: IF TIME IS REQUESTED, PDS LINKS TO      * 00605000
*        IKJEFT25 INSTEAD OF TIME AS SUGGESTED BY MARK HUTCHINSON     * 00606000
*        WITH BURLINGTON INDUSTRIES IN GREENSBORO, NORTH CAROLINA.    * 00607000
*                                                                     * 00608000
*        REVIEW: SUBCOMMAND ADDED TO LINK TO THE REVIEW COMMAND       * 00609000
*        FROM THE CBT TAPE, FILE 300 (AIR FORCE TSO MODIFICATIONS).   * 00610000
*                                                                     * 00611000
*        EDIT, FSE, PRINTOFF, REVIEW, SUBMIT AND TSOLIST: PDS CHECKS  * 00612000
*        FOR VALID MEMBER NAMES BEFORE LINKING TO THE COMMAND.        * 00613000
*                                                                     * 00614000
*        IF: FIXED A MINOR PROBLEM WITH AUTHORIZED MODULE CHECKING;   * 00615000
*        ALSO, ADDED THE APFERR AND NOAPFERR KEYWORDS.                * 00616000
*                                                                     * 00617000
*        DISPLAY AND PATTERN: ADDED MEMBER GROUP SYNTAX AS AN         * 00618000
*        ALTERNATE WAY TO SPECIFY MEMBER NAMES.                       * 00619000
*                                                                     * 00620000
*        VERIFY: ADDED THE UPDATE AND NOUPDATE KEYWORDS.              * 00621000
*                                                                     * 00622000
*      ERRORS NOTED BY ARNOLD CASINGHINO AT CBT:                      * 00623000
*        HISTORY: ALWAYS DISPLAYED LINKAGE-EDITOR MOD LEVEL AS ZERO.  * 00624000
*        MAP: SOMETIMES DISPLAYED AMODE24 AND RMODE24 ATTRIBUTES.     * 00625000
*        EDIT, FSE, PRINTOFF, REVIEW, SUBMIT AND TSOLIST:             * 00626000
*        INTRODUCED A PROBLEM WITH SINGLE CHARACTER MEMBER NAMES.     * 00627000
*                                                                     * 00628000
****VER 6.2:  MADE SEVERAL MODIFICATIONS:                          **** 00629000
*                                                                     * 00630000
*        CONSOLIDATED ALL MESSAGES AND ADDED MESSAGE IDENTIFIERS      * 00631000
*        FOR USE BY THE TSO MESSAGE FORMATTING MODULE (IKJEFF18).     * 00632000
*                                                                     * 00633000
*        ADDED AN EXTENDED HELP (.?) FACILITY TO HELP EXPLAIN         * 00634000
*        ERRORS DETECTED DURING PDS PROCESSING.                       * 00635000
*                                                                     * 00636000
*        SUBCOMMANDS ADDED:                                           * 00637000
*        COMPARE: ATTACHES BILL GODFREY'S COMPARE PREPROCESSOR FROM   * 00638000
*                 JIM MARSHALL'S TSO UTILITIES.                       * 00639000
*        COMPRESS: FOR PDS COMPRESS FUNCTIONS.                        * 00640000
*        DSNAME: DISPLAYS THE CURRENT ALLOCATION AS SUGGESTED BY      * 00641000
*                DAVID FILSINGER AND JOHN SULLIVAN.                   * 00642000
*        DSPRINT: AS SUGGESTED BY WILLIAM SMITH IN PALO ALTO, CALIF.  * 00643000
*                                                                     * 00644000
*        OUTCOPY:                                                     * 00645000
*        A.  ECHO MODE IS NOW A DEFAULT.                              * 00646000
*        B.  ALIAS OPERAND WAS ADDED.                                 * 00647000
*                                                                     * 00648000
*        CONTROL: ADDED THE MSGS AND TESTREAD OPERANDS AND            * 00649000
*        DELETED THE UPDATEALIAS/NOUPDATEALIAS OPERANDS.              * 00650000
*                                                                     * 00651000
*        ALLOCATION/UNALLOCATION: REWRITTEN TO USE SVC 99 INSTEAD     * 00652000
*        OF DAIR.                                                     * 00653000
*                                                                     * 00654000
*      FROM STEVE SMITH WITH SECURITY PACIFIC BANK IN GLENDALE, CAL.  * 00655000
*        DISPLAY: THE SECOND OPERAND IS MADE OPTIONAL.                * 00656000
*        ISPF: ADDED SUBCOMMAND FOR DIRECT ENTRY INTO SPF.            * 00657000
*        INVALID SUBCOMMAND MESSAGE: ADDED FOR SUBCOMMAND RENAMES.    * 00658000
*        SUBCOMMAND TABLE: MOVED INTO THE COPY LIBRARY.               * 00659000
*                                                                     * 00660000
*      FROM MIKE LOOS WITH DELUXE CHECK PRINTERS:                     * 00661000
*        ALLOCATION: ADDED SUPPORT FOR ALIAS DATA SET NAMES.          * 00662000
*        IF: ADDED CREATED AND CHANGED KEYWORDS.                      * 00663000
*                                                                     * 00664000
*      FROM SAM LEPORE WITH WELLS FARGO BANK IN SAN FRANCISCO:        * 00665000
*        SPF HELP: ADDED A HELP SCREEN FOR THE PDS ENTRY PANEL.       * 00666000
*        RECALL: ADDED NULLS SO CHARACTER INSERT ON 3270'S WILL WORK. * 00667000
*        EXTENDED HELP: USED .? INSTEAD OF ! FOR THE KEY SYMBOL.      * 00668000
*        ALLOCATION: ADDED * NOTATION FOR THE DATA SET NAME POSITION. * 00669000
*                                                                     * 00670000
*      FROM GRAY MADDRY AT THE COOPER GROUP IN APEX, NORTH CAROLINA:  * 00671000
*        MEMBER IN USE MESSAGE: MODIFIED TO INCLUDE THE NAME OF THE   * 00672000
*        USER MODIFYING THE MEMBER.                                   * 00673000
*                                                                     * 00674000
*      FROM MARC SCHARE WITH BELL LABORATORIES IN PISCATAWAY, NJ:     * 00675000
*        ALLOCATION: ADDED SUPPORT FOR FILE(FILENAME).                * 00676000
*        ESTAE EXIT: FIXED AN S0C4 ABEND FOR MVS/XA 2.1.2.            * 00677000
*                                                                     * 00678000
*      FROM JOHN SULLIVAN WITH LOMA LINDA UNIVERSITY MEDICAL CENTER:  * 00679000
*        VERIFY: FIXED A BUG WHICH CAUSED S0C4 ABENDS WHEN PROCESSING * 00680000
*        DATA SETS WITH LARGE DIRECTORIES.                            * 00681000
*                                                                     * 00682000
*      FROM KAVIN MC CARTHY WITH CONTINENTAL BANK IN CHICAGO:         * 00683000
*        IMPLIED CLIST (%): FIXED A BUG WHICH REQUIRED CLISTS TO      * 00684000
*        HAVE A PROC STATEMENT.                                       * 00685000
*                                                                     * 00686000
*      FROM ARNOLD CASINGHINO WITH CBT:                               * 00687000
*        SUBCOMMANDS WITH DEFAULT MEMBERS: ADDED MEMBER LIST SUPPORT. * 00688000
*        SCREEN UTILIZATION: SUBCOMMANDS WHICH OUTPUT VARIABLE        * 00689000
*        AMOUNTS OF DATA ON AN OUTPUT LINE (SUCH AS THE DISPLAY       * 00690000
*        SUBCOMMAND) USE THE FULL TERMINAL LINE WIDTH.                * 00691000
*                                                                     * 00692000
*      FROM MICHAEL EMIGH FROM UNITED AIR LINES (LISTM COMMAND):      * 00693000
*        DATA SET OPEN: ADDED A DIRECTORY COUNTING CCW CHAIN.         * 00694000
*                                                                     * 00695000
*      FROM DAVID SAGER WITH JOHNS HOPKINS UNIVERSITY/APL:            * 00696000
*        COMMAND SECURITY: ADDED A SAMPLE RACF TSO VALIDATION EXIT.   * 00697000
*        VALIDATION: ADDED TSO COMMAND AND SUBCOMMAND AUTHORIZATION   * 00698000
*        EXITS SIMILAR TO TSO COMMAND EXITS FROM APL LABORATORIES.    * 00699000
*        PROGRAM GENERATION: ADDED INSTALLATION SUBCOMMAND CONTROLS.  * 00700000
*                                                                     * 00701000
*      FROM DICK HINTON WITH LOCKHEED AIRCRAFT, BURBANK, CALIF.       * 00702000
*        ESTAE EXIT: FIXED AN S0C6 ABEND FOR MVS/XA 2.1.2.            * 00703000
*                                                                     * 00704000
*        IF/FIND WITH THEN OR ELSE OPERANDS: MESSAGE SUPPRESSION      * 00705000
*        HAS BEEN ADDED FOR SUBCOMMANDS WHICH DISPLAY MEMBER NAMES.   * 00706000
*                                                                     * 00707000
*        PFK SUPPORT: INPUT CAN OPTIONALLY INCLUDE PF KEYS (THIS IS   * 00708000
*        NOT YET FULLY DOCUMENTED DUE TO A CURRENT IBM APAR).         * 00709000
*                                                                     * 00710000
*        INPUT BUFFERING:                                             * 00711000
*          SINGLE - NAME CHANGED FROM NODOUBLE; ONE BLOCK PER EXCP.   * 00712000
*          DOUBLE - CHANGED TO GET TWO BLOCKS PER EXCP.               * 00713000
*          MULTIPLE - ADDED TO GET A FULL TRACK PER EXCP.             * 00714000
*                                                                     * 00715000
*        OPTIONS: REVISED TO SUPPORT THE DELETION OF ANY SUBCOMMAND   * 00716000
*        DURING THE PROGRAM GENERATION PROCESS.                       * 00717000
*                                                                     * 00718000
*        USAGE: REWRITTEN TO ADD MORE DATA SET INFORMATION.           * 00719000
*                                                                     * 00720000
*        MEMBER BLDL: PERFORMED FOR EACH SUBCOMMAND WITH A SIMPLE     * 00721000
*        MEMBER NAME SO THAT PDS WILL BE AWARE OF CHANGES TO THE      * 00722000
*        DATA SET FROM OTHER ADDRESS SPACES.                          * 00723000
         EJECT                                                          00724000
****VER 6.3:  ADDED DIALOG DISPLAY MODE:                           **** 00725000
*                                                                     * 00726000
*      FROM STEVE SMITH WITH SECURITY PACIFIC BANK IN GLENDALE, CAL.  * 00727000
*                                                                     * 00728000
*                                                              SS JUL84 00729000
*        ADDED SUPPORT OF DIALOG DISPLAY MODE USING            SS JUL84 00730000
*        A DIALOG TABLE TO DISPLAY PDS OUTPUT                  SS JUL84 00731000
*                                                              SS JUL84 00732000
*                                                                     * 00733000
*        FROM BARB COUTURE WITH DELUXE CHECK PRINTERS IN MINNESOTA:   * 00734000
*        PROFILE NOPREFIX CAUSED A S0C4 FOR DSNAME ALLOCATION AND     * 00735000
*        FILE(FILENAME) ALLOCATION DID NOT WORK IF PROFILE NOPREFIX.  * 00736000
*                                                                     * 00737000
*        FROM JIM MELNYK WITH GREAT-WEST LIFE ASSURANCE CO. IN        * 00738000
*        WINNIPEG, CANADA:  PDS DATA.SET VOL(XXX) OLD DID NOT WORK    * 00739000
*                       BUT PDS DATA.SET OLD VOL(XXX) DID WORK.       * 00740000
*                                                                     * 00741000
*        FROM FRANK PAJERSKI WITH ATARI INCORPORATED IN SUNNYVALE:    * 00742000
*        CERTAIN FOCUS LOAD MODULES GOT S0C7 ABENDS USING HISTORY.    * 00743000
*                                                                     * 00744000
*        FROM ARNOLD CASINGHINO WITH CBT: WHEN PDS IS INVOKED AS A    * 00745000
*        SUBCOMMAND, IT USES THE PRIMARY COMMAND NAME (LIKE EDIT);    * 00746000
*        THIS PREVENTED SPFEDIT IN PDS UNDER EDIT FROM WORKING.       * 00747000
*                                                                     * 00748000
*        FOR THE STAX EXIT FROM RICHARD SCHAFER AT RICE UNIVERSITY:   * 00749000
*          1.  TCLEARQ SHOULD BE ISSUED TO SYNCRONIZE INPUTS.         * 00750000
*          2.  STATUS STOP SHOULD BE ISSUED FOR ANY SUBTASKS.         * 00751000
*          3.  STACK DELETE=ALL IS ISSUED TO FLUSH THE CURRENT STACK. * 00752000
*          4.  THE PUTGET IN THE ATTENTION ROUTINE SHOULD ACCEPT      * 00753000
*              TERMINAL INPUT ONLY.                                   * 00754000
*                                                                     * 00755000
*        FOR THE ESTAE EXIT FROM RICHARD SCHAFER AT RICE UNIVERSITY:  * 00756000
*          1.  STACK DELETE=ALL IS ISSUED TO FLUSH THE CURRENT STACK. * 00757000
*                                                                     * 00758000
*        FROM SAM LEPORE WITH WELLS FARGO BANK IN SAN FRANCISCO:      * 00759000
*        THE PDS200I MESSAGE WAS REDESIGNED TO MAKE IT MORE USEFUL.   * 00760000
*                                                                     * 00761000
*        FROM MARC SCHARE WITH BELL LABORATORIES IN PISCATAWAY, NJ:   * 00762000
*        IF AND HISTORY: ADDED A "SYSMOD" ALIAS FOR THE USER KEYWORD. * 00763000
*                                                                     * 00764000
*        FROM BEN MOORE (FEDERAL EXPRESS):                            * 00765000
*        FIND: ASIS AND CAPS KEYWORDS HAVE BEEN ADDED TO ALLOW        * 00766000
*        THE SPECIFICATION OF LOWER-CASE SEARCH STRINGS.              * 00767000
*                                                                     * 00768000
*        FROM BILL SMITH WITH SYNTEX: ADDED CONTROLS TO SPECIFY       * 00769000
*        THE NUMBER OF MEMBERS IN THE DATA SET TO AVOID SB37          * 00770000
*        ABENDS IN THE COMPRESS SUBCOMMAND.                           * 00771000
*                                                                     * 00772000
*        BACKGROUND USE OF PDS: CONTROL NORECOVER IS MADE A DEFAULT   * 00773000
*        TO PREVENT INADVERTENT RECOVERY AFTER AN ERROR.              * 00774000
*                                                                     * 00775000
*        FROM JIM MELNYK WITH GREAT-WEST LIFE ASSURANCE CO. IN        * 00776000
*        WINNIPEG, CANADA:  CHANGED THE RESERVE/DEQ MAJOR NAME FROM   * 00777000
*        SPFDSN TO SPFEDIT (AS IN PTF UZ65671).                       * 00778000
*                                                                     * 00779000
*        VERIFY: ADDED A MAXIMUM PHYSICAL BLKSIZE MESSAGE.            * 00780000
*                                                                     * 00781000
*        FROM SAM LEPORE WITH WELLS FARGO BANK IN SAN FRANCISCO -     * 00782000
*        COMPARE, DSPRINT, PRINTOFF, REVIEW, SUBMIT AND TSOLIST:      * 00783000
*        PERMIT CLIST INVOCATION INSTEAD OF A TSO COMMAND.            * 00784000
*                                                                     * 00785000
*        SPFEDIT, BROWSE, ISPF AND ISPMODE: AFTER A RETURN COMMAND    * 00786000
*        IN SPF, SUBSEQUENT SPF SUBCOMMANDS WERE TERMINATED WITHOUT   * 00787000
*        PROCESSING.  NOW, THEY ARE REINVOKED AFTER A RETURN KEY IF   * 00788000
*        &RETURNX IS YES.                                             * 00789000
*                                                                     * 00790000
*    SESSION MANAGER PROBLEMS:                                        * 00791000
*        FROM MARSHALL WERNICK WITH ARCO PETROLEUM PRODUCTS IN        * 00792000
*        LOS ANGELES: USING SESSION MANAGER, THE ENTRY TO PDS         * 00793000
*        VIA THE SPF PDS PANEL CAUSED AN S0C4 ABEND.                  * 00794000
*                                                                     * 00795000
*        FROM BILL SMITH WITH SYNTEX: USING SESSION MANAGER, PDS      * 00796000
*        LINE MODE OUTPUT FOLLOWING SPFEDIT OR BROWSE SUBCOMMANDS     * 00797000
*        WERE NOT CAPTURED BY SESSION MANAGER.                        * 00798000
*                                                                     * 00799000
*        FROM CHARLES HOFFMAN WITH GTE LABORATORIES IN                * 00800000
*        WALTHAM, MASS: USING SESSION MANAGER, RESTORE WITH PROMPT    * 00801000
*        DID DOUBLE PROMPTING AND INCORRECT "INVALID SUBCOMMAND"      * 00802000
*        MESSAGES OCCURED FOR FOLLOWING PDS SUBCOMMANDS.              * 00803000
*                                                                     * 00804000
*        FROM JAMES BERRY AT WESTLAKE VILLAGE, CALIF:  WITH           * 00805000
*        SESSION MANAGER, THE SCREEN CLEAR FUNCTION (SUBCOMMAND K)    * 00806000
*        CLEARS THE SESSION MANAGER CONTROL CHARACTERS; NOW IF THE    * 00807000
*        SESSION MANAGER TMP IS IN USE, ONLY A BLANK LINE IS OUTPUT.  * 00808000
*                                                                     * 00809000
*                                                                     * 00810000
****VER 7.0:  ADDED MEMLIST SUBCOMMAND:                            **** 00811000
*                                                                     * 00812000
*      FROM STEVE SMITH WITH SECURITY PACIFIC BANK IN GLENDALE, CAL.  * 00813000
*                                                                     * 00814000
*                                                              SS SEP84 00815000
*        ADDED SUPPORT OF MEMLIST WITH LINE MODE SUBCOMMANDS   SS SEP84 00816000
*                                                              SS SEP84 00817000
*                                                                     * 00818000
*        FROM SAM LEPORE WITH WELLS FARGO:                            * 00819000
*          1.  VERIFY APPLIES TO DATA SETS AND INDIVIDUAL MEMBERS.    * 00820000
*          2.  MEMLIST OR ISPMODE ON THE PRIMARY COMMAND LINE         * 00821000
*              DETERMINES THE INITIAL PROGRAM PROCESSING MODE.        * 00822000
*          3.  THE DEFAULT MEMBER GROUP IS FORMATTED ON THE           * 00823000
*              PDS300A MESSAGE (FIRST SPECIFICATION FOR A LIST).      * 00824000
*                                                                     * 00825000
*        PDS ENTRY PANEL: CHANGED TO ALLOW LINE/ISPMODE/MEMLIST       * 00826000
*        ENTRY MODES.                                                 * 00827000
*                                                                     * 00828000
*        DEFAULT MEMBER GROUP: NOT MODIFIED BY PDS LINE COMMANDS.     * 00829000
*                                                                     * 00830000
*        ISPMODE: THE ENTERED SUBCOMMAND IS ECHOED IN UPPER AND       * 00831000
*        LOWER CASE.                                                  * 00832000
*                                                                     * 00833000
*        IF AND FIND: ADDED THEN(VERIFY) AND ELSE(VERIFY)             * 00834000
*        IF AND FIND: ADDED THEN(MEMLIST) AND ELSE(MEMLIST)           * 00835000
*                                                                     * 00836000
*        CONTROL: OPERANDS CALLED CPULOOP, ABEND, OUTLOOP AND MSGS    * 00837000
*        ARE NOW TESTCPULOOP, TESTABEND, TESTOUTLOOP AND TESTMSGS.    * 00838000
*                                                                     * 00839000
*        ISPMODE: CHKMAX, CMDMAX AND TBLMAX DIALOG CONTROL OPERANDS   * 00840000
*        HAVE BEEN ADDED AS SUGGESTED BY STEVE SMITH WITH SPNB.       * 00841000
*                                                                     * 00842000
*        PDS200I MESSAGE: CHANGED TO ADD NUMBER OF EXTENTS.           * 00843000
*                                                                     * 00844000
*        COMPRESS: CHANGED TO ALLOCATE COMPRESS WORK SPACE BASED      * 00845000
*        ON THE NUMBER OF DIRECTORY BLOCKS IN USE AS SUGGESTED BY     * 00846000
*        JOHN SULLIVAN WITH THE LOMA LINDA MEDICAL CENTER.            * 00847000
*                                                                     * 00848000
*        TSO SUBCOMMAND:                                              * 00849000
*          1.  CHANGED TO INVOKE CLISTS AS SUGGESTED BY               * 00850000
*              SAM LEPORE AND JOHN SULLIVAN.                          * 00851000
*          2.  CHANGED TO OPTIONALLY INVOKE TSOEXEC FOR TSO/E REL 2   * 00852000
*              AS SUGGESTED BY MIKE LOOS WITH DELUXE CHECK PRINTERS.  * 00853000
*                                                                     * 00854000
*        CONTROL: ADDED OPERANDS TO PROVIDE A HARDCOPY OR DATA SET    * 00855000
*        LOG AS SUGGESTED BY BILL SMITH WITH SYNTEX.                  * 00856000
*                                                                     * 00857000
*        PFK SUPPORT: DROPPED DUE TO ITS INCLUSION IN SPF DIALOGS.    * 00858000
*                                                                     * 00859000
*        TIME SUBCOMMAND: ADDED AS SUGGESTED BY ARNOLD CASINGHINO.    * 00860000
*                                                                     * 00861000
*        COMPARE: MODIFIED THE TSO COMMAND TO RETURN OUTPUT LINES     * 00862000
*        TO THE PDS PUTLINE ROUTINE FOR SESSION DISPLAY AND LOGGING.  * 00863000
*                                                                     * 00864000
*        ATTRIB AND IF: ADDED SSI CHANGE AND TESTING CAPABILITY.      * 00865000
*                                                                     * 00866000
*        FIXPDS CHANGES:                                              * 00867000
*          1.  ALLOW FIXPDS USE FOR SEQUENTIAL DATA SETS.             * 00868000
*          2.  ADDED THE MAXSPACE OPERAND TO ALLOW RESTORING OF       * 00869000
*              MEMBERS AFTER A COMPRESS OF THE DATA SET AS SUGGESTED  * 00870000
*              BY JOHN SULLIVAN WITH THE LOMA LINDA MEDICAL CENTER.   * 00871000
*          3.  ADDED THE RELEASE, RELEXTENT AND RELSAVE OPERANDS.     * 00872000
*          4.  REDUCED THE DEFAULT BLOCKSIZES FOR 3350, 3375 AND      * 00873000
*              3380 DISKS.                                            * 00874000
*                                                                     * 00875000
*        SPFEDIT: ADDED THE MACRO KEYWORD FOR ISPF V2 AS SUGGESTED    * 00876000
*        BY MARC SCHARE WITH BELL LABORATORIES IN PISCATAWAY, NJ.     * 00877000
*                                                                     * 00878000
*        3278-5 TERMINALS: IF ISPMODE OR SESSION LOGGING IS ON, PDS   * 00879000
*        OUTPUT LINES ARE LIMITED TO 80 CHARACTERS AS SUGGESTED BY    * 00880000
*        ARNOLD CASINGHINO WITH CBT.                                  * 00881000
*                                                                     * 00882000
*        IF: FIXED A PROBLEM WITH CHANGED AND CREATED KEYWORDS FOR    * 00883000
*        LOAD MEMBER CHECKING AS REPORTED BY JOHN SULLIVAN AT LOMA    * 00884000
*        LINDA (CHECKING ACROSS A YEAR BOUNDARY WAS INCORRECT).       * 00885000
*                                                                     * 00886000
*        TSOEDIT AND EDIT: SUBCOMMAND EDIT WAS RENAMED AS TSOEDIT     * 00887000
*        AND SPFEDIT WAS RENAMED AS EDIT AS SUGGESTED BY STEVE SMITH. * 00888000
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 00889000
         TITLE 'P D S  --  PDS MACROS                          1/15/85' 00890000
         MACRO                                                          00891000
&NAME    ENTER &TYPE                                                    00892000
         LCLC  &LABEL                                                   00893000
&LABEL   SETC  'IHB'.'&SYSNDX'                                          00894000
         AIF   ('&TYPE' EQ 'VALCHECK').VALCK                            00895000
         AIF   ('&TYPE' EQ 'ATTNEXIT').ATTN                             00896000
         AIF   ('&TYPE' EQ '').MAIN                                     00897000
         MNOTE 8,'INVALID TYPE ''&TYPE'''                               00898000
         MEXIT                                                          00899000
.MAIN    ANOP                                                           00900000
&NAME    CSECT                                                          00901000
         SAVE  (14,12),,*                                               00902000
         LCLA  &R                                                       00903000
&R       SETA  0                                                        00904000
.EQU     ANOP                                                           00905000
R&R      EQU   &R                                                       00906000
&R       SETA  &R+1                                                     00907000
         AIF   (&R LT 16).EQU                                           00908000
         LR    R9,R15                                                   00909000
         USING &NAME,R9,R10,R11,R12                                     00910000
         LA    R12,2048                                                 00911000
         LA    R10,2048(R9,R12)                                         00912000
         LA    R11,2048(R10,R12)                                        00913000
         LA    R12,2048(R11,R12)                                        00914000
         MEXIT                                                          00915000
.VALCK   ANOP                                                           00916000
&NAME    CSECT                                                          00917000
         SAVE  (14,12)                                                  00918000
         LR    R8,R15             BASE REGISTER ADDRESS                 00919000
         USING &NAME,R8           BASE REGISTER NOTIFICATION            00920000
         L     R7,4(,R1)          WORK AREA ADDRESS                     00921000
         LM    R9,R12,BASES       RESTORE BASE REGISTERS                00922000
         L     R6,0(R1)           PDE ADDRESS                           00923000
         LA    R15,VALSAVE                                              00924000
         AGO   .CHAIN                                                   00925000
.ATTN    ANOP                                                           00926000
&NAME    SAVE  (14,12)                                                  00927000
         L     R7,8(,R1)                                                00928000
         LM    R9,R12,BASES                                             00929000
         LA    R15,ATTNSAVE                                             00930000
.CHAIN   ST    R13,4(,R15)                                              00931000
         ST    R15,8(,R13)                                              00932000
         LR    R13,R15                                                  00933000
         SPACE 1                                                        00934000
         MEND                                                           00935000
         SPACE 1                                                        00936000
         MACRO TSMSG   -   OUTPUT A STATUS OR ERROR MESSAGE WITH MSGID  00937000
&NAME    TSMSG &NUM                                                     00938000
         AIF   ('&NUM' EQ '(1)' OR '&NUM' EQ '(R1)').CALL               00939000
&NAME    LA    R1,&NUM                                                  00940000
         BAL   R14,TSMSGRT                                              00941000
         MEXIT                                                          00942000
.CALL    ANOP                                                           00943000
&NAME    BAL   R14,TSMSGRT                                              00944000
         MEND                                                           00945000
         SPACE 2                                                        00946000
         MACRO                                                          00947000
&L       $T    &Z,&PF,&RTN,&O,&PCL,&P,&PP,&CR,&HD                       00948000
         LCLC  &NAME                                                    00949000
         AIF   ('&Z' NE '').GEN1                                   @D01
         MNOTE *,'&L, &RTN DISABLED'                               @D01
         MEXIT ,                                                   @D01
.GEN1    ANOP  ,                                                   @D01
&NAME    SETC  '&Z'.' '                                                 00950000
&L       DC    0F'0',CL8'&NAME'                *** SUBCOMMAND NAME      00951000
         DC    X'&PF',AL3(&RTN)                *** OFF, SUBCOMMAND ADDR 00952000
         DC    AL1(&O),AL3(&PCL)               *** FLAGS, PCL ADDRESS   00953000
         DC    AL1(&P),AL3(&PP)                *** FLAGS, PP ADDRESS    00954000
         DC    CL8'&CR'                        *** ATTACHED TSO COMMAND 00955000
         DC    AL2(&HD-ONIX),XL2'FFFF'         *** HELP, AVAILABLE      00956000
.EXIT    MEND                                                           00957000
         SPACE 2                                                        00958000
         MACRO                                                          00959000
&L       $TL   &F,&F2,&TB,&P,&P2,&PMID                         SS NOV84 00960000
&L       DC    AL1(&F),AL1(&F2)                *** FLAGS 1 AND 2        00961000
         DC    AL2(&TB-$TBL)                   *** TABLE OFFSET         00962000
         DC    AL1(&P),AL1(&P2)                *** PROC1,PROC2 SS NOV84 00963000
         DC    AL2(&PMID)                      *** MSGID       SS NOV84 00964000
         MEND                                                           00965000
         SPACE 2                                                        00966000
         MACRO                                                          00967000
&L       $TX   &F,&F2,&TB,&P,&P2,&PMID                         SS NOV84 00968000
&L       DC    AL1(&F+#X),AL1(&F2)             *** FLAGS 1 AND 2        00969000
         DC    AL2(&TB-ISP$TX)                                 SS SEP84 00970000
         DC    AL1(&P),AL1(&P2)                *** PROC1,PROC2 SS NOV84 00971000
         DC    AL2(&PMID)                      *** MSGID       SS NOV84 00972000
         MEND                                                           00973000
         SPACE 2                                                        00974000
         MACRO                                                 SS NOV84 00975000
&L       $TC   &F,&F2,&TB,&P,&P2,&PMID                         SS NOV84 00976000
&L       DC    AL1(&F),AL1(&F2+#C)             *** FLAGS 1     SS NOV84 00977000
         DC    CL2&TB                                          SS NOV84 00978000
         DC    AL1(&P),AL1(&P2)                *** PROC1,PROC2 SS NOV84 00979000
         DC    AL2(&PMID)                      *** MSGID       SS NOV84 00980000
         MEND                                                           00981000
         SPACE 2                                                        00982000
         MACRO                                                          00983000
&NAME    EXIT  &LV=                                                     00984000
         AIF   ('&LV' EQ '').A0                                         00985000
&NAME    LR    R2,R13                         ADDR OF THIS SAVE AREA    00986000
         L     R13,4(,R13)                                              00987000
         AGO   .A1                                                      00988000
.A0      ANOP                                                           00989000
&NAME    L     R13,4(,R13)                                              00990000
.A1      STM   R15,R1,16(R13)                 RETURN REGS 15, 0, 1      00991000
         AIF   ('&LV' EQ '').A2 NOT DYNAMIC STORAGE                     00992000
         FREEMAIN R,LV=&LV,A=(R2)                                       00993000
.A2      ANOP                                                           00994000
         RETURN (14,12),T                                               00995000
         MEND                                                           00996000
         SPACE 2                                                        00997000
         MACRO                                                          00998000
&NAME    MSG   &TEXT                                                    00999000
         LCLA  &A                                                       01000000
&A       SETA  K'&TEXT-2+4                                              01001000
&NAME    DC    AL2(&A,0),C&TEXT              NORMAL MESSAGE             01002000
         MEND                                                           01003000
         SPACE 3                                                        01004000
         MACRO $PUTGET -  OUTPUT A DATA LINE AND GET RESPONSE           01005000
&NAME   $PUTGET  &LINE,&ATTN=                                           01006000
         AIF   ('&LINE' EQ '(1)' OR '&LINE' EQ '(R1)').CALL             01007000
         AIF   ('&LINE'(1,1) EQ '(').R                                  01008000
&NAME    LA    R1,&LINE                                                 01009000
         BAL   R14,$PUTGET                                              01010000
         AGO   .ATTN                                                    01011000
.R       ANOP                                                           01012000
&NAME    LR    R1,&LINE(1)                                              01013000
         BAL   R14,$PUTGET                                              01014000
         AGO   .ATTN                                                    01015000
.CALL    ANOP                                                           01016000
&NAME    BAL   R14,$PUTGET                                              01017000
.ATTN    ANOP                                                           01018000
         AIF   ('&ATTN' EQ '').NOATTN                                   01019000
         B     &ATTN                         EXIT IF ATTENTION OCCURRED 01020000
         AGO   .END                                                     01021000
.NOATTN  NOP   0                             IGNORE ATTENTIONS          01022000
.END     MEND                                                           01023000
         SPACE 2                                                        01024000
         MACRO $PUTLINE -  OUTPUT A DATA LINE                           01025000
&NAME   $PUTLINE &LINE,&ATTN=                                           01026000
         AIF   ('&LINE' EQ '(1)' OR '&LINE' EQ '(R1)').CALL             01027000
         AIF   ('&LINE'(1,1) EQ '(').R                                  01028000
&NAME    LA    R1,&LINE                      ADDRESS OF DATA LINE       01029000
         BAL   R14,$PUTLINE                  INVOKE PUTLINE INTERFACE   01030000
         AGO   .ATTN                                                    01031000
.R       ANOP                                                           01032000
&NAME    LR    R1,&LINE(1)                   ADDRESS OF DATA LINE       01033000
         BAL   R14,$PUTLINE                  INVOKE PUTLINE INTERFACE   01034000
         AGO   .ATTN                                                    01035000
.CALL    ANOP                                                           01036000
&NAME    BAL   R14,$PUTLINE                  INVOKE PUTLINE INTERFACE   01037000
.ATTN    ANOP                                                           01038000
         AIF   ('&ATTN' EQ '').NOATTN                                   01039000
         B     &ATTN                         EXIT IF ATTENTION OCCURRED 01040000
         AGO   .END                                                     01041000
.NOATTN  NOP   0                             IGNORE ATTENTIONS          01042000
.END     MEND                                                           01043000
         SPACE 2                                                        01044000
         MACRO MESSAGE - OUTPUT AN ERROR/STATUS MESSAGE                 01045000
&NAME    MESSAGE &MSG1,&MSG2                                            01046000
         AIF   ('&MSG1' EQ '(1)' OR '&MSG1' EQ '(R1)').MSGDS            01047000
         AIF   ('&MSG1'(1,1) EQ '(').RMSG1                              01048000
         AIF   ('&MSG1' EQ 'MSGTEXT1' AND '&MSG2' EQ '').NOR1           01049000
&NAME    LA    R1,&MSG1                                                 01050000
         AGO   .MSG2                                                    01051000
.NOR1    ANOP                                                           01052000
&NAME    BAL   R14,MESSTXT1                                             01053000
         MEXIT                                                          01054000
.RMSG1   ANOP                                                           01055000
&NAME    LR    R1,&MSG1(1)                                              01056000
         AGO   .MSG2                                                    01057000
.MSGDS   ANOP                                                           01058000
         AIF   ('&MSG2' NE '').SECOND                                   01059000
&NAME    BAL   R14,MESSAGE0                                             01060000
         MEXIT                                                          01061000
.SECOND  ANOP                                                           01062000
&NAME    DS    0H                                                       01063000
.MSG2    ANOP                                                           01064000
         AIF   ('&MSG2' EQ '').NOMSG2 NO SECONDARY MESSAGE              01065000
         AIF   ('&MSG2' EQ '(0)' OR '&MSG2' EQ '(R0)').CALL             01066000
         AIF   ('&MSG2'(1,1) EQ '(').RMSG2                              01067000
         LA    R0,&MSG2                                                 01068000
         AGO   .CALL                                                    01069000
.RMSG2   ANOP                                                           01070000
         LR    R0,&MSG2(1)                                              01071000
.CALL    ANOP                                                           01072000
         BAL   R14,MESSAGE                                              01073000
         AGO   .END                                                     01074000
.NOMSG2  ANOP                                                           01075000
         BAL   R14,MESSAGE0                                             01076000
.END     MEND                                                           01077000
         SPACE 3                                                        01078000
         MACRO                                                          01079000
&L       COND  &OPRAND,&OPRAT                                           01080000
         AIF   ('&L' EQ '').EXIT                                        01081000
         &OPRAND &OPRAT                                                 01082000
.EXIT    MEND                                                           01083000
         SPACE 2                                                        01084000
         MACRO                                                          01085000
&L       CONDIKJ &OPRAT                                                 01086000
         AIF   ('&L' EQ '').EXIT                                        01087000
         IKJNAME &OPRAT                                                 01088000
.EXIT    MEND                                                           01089000
         SPACE 3                                                        01090000
*----------------------------------------------------------------* @D01
*        The ACTR counter is set to a high value because of      * @D01
*        all the AIF/AGO conditional assembly logic added for    * @D01
*        the MVT version.                                        * @D01
*----------------------------------------------------------------* @D01
         ACTR  99999                                               @D01
         SPACE 1                                                   @D01
         GBLC  &VERS                                               @D01
         GBLC  &FIXDATE                                            @D01
         GBLC  &DAUNIT                                             @D01
         GBLC  &TUNIT                                              @D03
         SPACE 1                                                   @D01
         GBLC  &MVSLEV,&CONADEF,&CONVTAM,&CONGLBL,&CONDRNG,&RETURNX     01091000
         GBLB  &MVT                                                @D01
         SPACE 1                                                        01092000
         GBLC  &DB2311,&DB2301,&DB2303,&DB2302,&DB2321,&DB3390     @D01
         GBLC  &DB23051,&DB23052,&DB2314,&DB3330,&DB3340                01093000
         GBLC  &DB3350,&DB3375,&DB33301,&DB3380                         01094000
         SPACE 1                                                        01095000
         GBLC  &UN2311,&UN2301,&UN2303,&UN2302,&UN2321,&UN3390     @D01
         GBLC  &UN23051,&UN23052,&UN2314,&UN3330,&UN3340                01096000
         GBLC  &UN3350,&UN3375,&UN33301,&UN3380                         01097000
         SPACE 1                                                        01098000
         GBLC  &NAB1,&NAB2,&NAB3,&NXS1,&NXS2,&NXS3                      01099000
         GBLC  &NATT,&NALI,&NBRO,&NCHA,&NCAR,&NCMX                      01100000
         GBLC  &NCON,&NDIS,&NDIR,&NDEL,&NDSN,&NDSP,&NEDI                01101000
         GBLC  &NEND,&NEXE,&NFIN,&NFIX,&NFSE,&NKLE,&NHEL                01102000
         GBLC  &NHIS,&NIFX,&NISP,&NISM,&NLIS,&NMAP,&NMEM                01103000
         GBLC  &NMML,&NOPT,&NOUT,&NPAT,&NPDS,&NPRI,&NREC                01104000
         GBLC  &NREN,&NRES,&NREV,&NSPF,&NSUB,&NSCR                      01105000
         GBLC  &NTSO,&NTSE,&NTSL,&NUSA,&NVER                            01106000
         GBLC  &NUT1,&NUT2,&CUT1,&CUT2                         SS NOV84 01107000
         SPACE 1                                                        01108000
         GBLC  &CXS1,&CXS2,&CXS3,&C296                                  01109000
         GBLC  &CBRO,&CCAR,&CCMX,&CDSP,&CEDI,&CEXE                      01110000
         GBLC  &CFIX,&CFSE,&CHEL,&CISP,&CMEN,&CPRI                      01111000
         GBLC  &CREV,&CSUB,&CTSL,&CTSO,&CTSE                            01112000
*                                                              SS JUL84 01113000
*  SPF DIALOG MODE   CONDITIONAL ASSEMBLY VARS                 SS JUL84 01114000
*                                                              SS JUL84 01115000
         GBLC  &SPFSIZE,&SPFMAX,&SPFCKPT,&NMOD                 SS JUL84 01116000
         SPACE 3                                                        01117000
         COPY  PDSGEN70   ***  ESTABLISH THE PDS GLOBAL VALUES SS AUG84 01118000
         SPACE 2                                                        01119000
&CBRO    SETC  'BROWSE'   ***  SPF BROWSE SERVICE NAME                  01120000
&CEDI    SETC  'EDIT'     ***  SPF EDIT SERVICE NAME                    01121000
&CONGLBL SETC  'FSAVEOP'  ***  CONTROL NOSAVETEXT                       01122000
         SPACE 1                                                        01123000
         AIF   ('&MVSLEV' EQ 'MVS038').MVSOK                            01124000
         AIF   ('&MVSLEV' EQ 'MVS12X').MVSOK                            01125000
         AIF   ('&MVSLEV' EQ 'MVS13X').MVSOK                            01126000
         SPACE 3                                                        01127000
         MNOTE 12,'*** MVSLEV -- MVS LEVEL &MVSLEV IS INVALID ***'      01128000
         SPACE 2                                                        01129000
         AGO   .NOGEN                                                   01130000
.MVSOK   ANOP                                                           01131000
         AIF   ('&CISP' EQ '').NOSPF                                    01132000
         AIF   ('&CISP' EQ 'SPF').SMNOTE                                01133000
         AIF   ('&CISP' EQ 'ISPF').SMNOTE                               01134000
         AIF   ('&CISP' EQ 'ISPFV2').SMNOTE                             01135000
         SPACE 3                                                        01136000
         MNOTE 12,'*** CISP -- SPF CONTROL &CISP IS INVALID ***'        01137000
         SPACE 2                                                        01138000
         AGO   .NOGEN                                                   01139000
.NOSPF   ANOP                                                           01140000
&CISP    SETC  'NO SPF'                                                 01141000
&NBRO    SETC  ''          *** NULLIFY THE SPF SUBCOMMANDS -- NO SPF    01142000
&NEDI    SETC  ''          *** NULLIFY THE SPF SUBCOMMANDS -- NO SPF    01143000
&NISP    SETC  ''          *** NULLIFY THE SPF SUBCOMMANDS -- NO SPF    01144000
&NSPF    SETC  ''          *** NULLIFY THE SPF SUBCOMMANDS -- NO SPF    01145000
.SMNOTE  ANOP                                                           01146000
         SPACE 3                                                        01147000
         MNOTE *,'&CISP INTERFACE CODE WILL BE GENERATED'               01148000
         SPACE 2                                                        01149000
.NOERR   ANOP                                                           01150000
         SPACE 5                                                        01151000
*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 01152000
***                                                                 *** 01153000
***    HISTORICAL SECTION:                                          *** 01154000
***                                                                 *** 01155000
***                                                                 *** 01156000
***     VERSION   LAST MOD   SIZE   IN K   # SUBS   SOURCE   HELP   *** 01157000
***     =======   ========   ====   ====   ======   ======   ====   *** 01158000
***                                                                 *** 01159000
***      PDS30    1/28/80    47A0    18K     19      4851     512   *** 01160000
***                                                                 *** 01161000
***      PDS45    8/20/81    45A8    18K     22      5037     517   *** 01162000
***                                                                 *** 01163000
***      PDS52   11/08/82    6090    25K     25      6253    1123   *** 01164000
***                                                                 *** 01165000
***      PDS53    4/06/83    9610    38K     28      8978    1502   *** 01166000
***                                                                 *** 01167000
***      PDS60    9/30/83    CF28    52K     32     12068    1997   *** 01168000
***                                                                 *** 01169000
***      PDS61    2/06/84    E948    59K     34     13496    2270   *** 01170000
***                                                                 *** 01171000
***      PDS62    7/31/84   11F58    72K     39     16062    3676   *** 01172000
***                                                                 *** 01173000
***      PDS63   10/08/84   12DB0    76K     40     17122    3782   *** 01174000
***                                                                 *** 01175000
***      PDS70    1/20/85   16CD8    92K     41     18185    4112   *** 01176000
***                                                                 *** 01177000
***                                                                 *** 01178000
*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 01179000
         TITLE 'P D S  --  PDS PROGRAM ENTRY                   1/15/85' 01180000
PDSMAIN  ENTER                                                          01181000
         SPACE 1                                                        01182000
         LR    R6,R1                SAVE ADDR OF CPPL                   01183000
         USING WORKAREA,R7          WORK AREA DSECT                     01184000
         AIF ('&CISP' EQ 'NO SPF').MA00020                         @D01
         L     R1,0(,R1)            POINT TO PASSED PARAMETER LIST      01185000
         CLC   2(2,R1),=C'++'       SPF ADDRESS MARKER FROM PDS?        01186000
         BNE   GETMAIN              NO, NOT AN ENTRY FROM SPF           01187000
         CVB   R7,4(,R1)            WORK AREA POINTER                   01188000
         L     R0,PDSENTRY          NUMBER OF ENTRIES                   01189000
         A     R0,=F'1'                                                 01190000
         ST    R0,PDSENTRY                                              01191000
         C     R0,=F'1'             FIRST SPF ENTRY?                    01192000
         BH    RETURN2              NO, END STATEMENT                   01193000
         LA    R15,SPFMAIN          SPF REGISTER SAVE AREA              01194000
         ST    R15,8(,R13)                                              01195000
         ST    R13,4(,R15)          CHAIN TO SECONDARY SAVEAREA         01196000
         LR    R13,R15                                                  01197000
         MVI   ISPFTEXT+1,12        LENGTH OF COUNT AND "ISPF    "      01198000
         NI    FLAGSFF,FF-FSPFERR   SPF ERROR OFF                       01199000
         OI    FLAGSFF,FSPFCALL     SPF CALL ACTIVE                     01200000
         MVC   STAEPARM(4),STAELIST   RESET THE ESTAE EXIT              01201000
         ESTAE STAEEXIT,CT,PARAM=(R7),MF=(E,STAEPARM)                   01202000
         B     RESTART0             REALLOCATE THE DATA FILES           01203000
.MA00020 ANOP  ,                                                   @D01
         TITLE 'P D S  --  PDS WORK AREA INITIALIZATION        1/15/85' 01204000
GETMAIN  L     R5,WORKSIZE                                              01205000
         AIF   (&MVT).MA00040                                      @D01
         LA    R0,0(,R5)                CLEAR THE TOP BYTE              01206000
         GETMAIN RU,LV=(0),SP=1,BNDRY=PAGE                              01207000
         AGO   .NA00040                                            @D01
.MA00040 ANOP  ,                                                   @D01
         GETMAIN R,LV=(R5)              Get subpool 1 work area    @D01
.NA00040 ANOP  ,                                                   @D01
         LR    R7,R1                    WORK AREA ADDRESS               01208000
         LR    R4,R1                    CLEAR WORK AREA                 01209000
         SR    R1,R1                    NULL SOURCE                     01210000
         MVCL  R4,R0                    FILL WITH PAD 0 FROM R1(0:7)    01211000
         SPACE 1                                                        01212000
         L     R1,0(,R6)                POINT TO PASSED PARAMETER LIST  01213000
         AIF ('&CISP' EQ 'NO SPF').MA00060                         @D01
         CLI   2(R1),X'40'              INVOKED AS A SPF DIALOG?        01214000
         BNH   INITADDR                 NO, BRANCH                      01215000
*                                                                       01216000
***   PDS HAS BEEN INVOKED AS A SPF DIALOG  -- TO ALLOW THE USE OF      01217000
*     NORMAL TSO SERVICES, A CPPL MUST BE BUILT.                        01218000
*     A.  GETMAIN AN AREA FOR CREATED CONTROL BLOCKS IN SUBPOOL 78      01219000
*         (THE SUBPOOL TSO USES FOR ECT I/O SERVICE AND WORK AREAS)     01220000
*     B.  COPY IN THE SYSTEM UPT AND PSCB ADDRESSES                     01221000
*     C.  CREATE A TSO COMMAND BUFFER FROM THE INPUT PARAMETERS         01222000
*     D.  CREATE AN ECT AREA                                            01223000
*         1.  THE ECT POINTS TO AN I/O SERVICE AREA                     01224000
*         2.  THE I/O SERVICE AREA POINTS TO AN I/O WORK AREA WHICH     01225000
*             IS INITIALLY 32 BYTES LONG.                               01226000
*     E.  A METHOD OF LOCATING THE ACTUAL TSO ECT HAS BEEN DEVELOPED.   01227000
*         IN A FOLLOWING RELEASE OF PDS, THE CREATED ECT AREA WILL      01228000
*         BE DELETED; FOR NOW, THE LOCATED ECT IS ACTUALLY USED.        01229000
*     F.  AT PROGRAM END, CLEAN UP THE OBTAINED AREA                    01230000
*         1.  IF THE I/O WORK AREA WAS FREED AND EXPANDED, RELEASE      01231000
*             THE NEW I/O WORK AREA.                                    01232000
*         2.  RELEASE THE OBTAINED SUBPOOL 78 CONTROL BLOCK AREA.       01233000
         SPACE 1                                                        01234000
         OI    FLAGSFF,FSPFDIAL+FSPFOPT6  SET APPROPRIATE SPF FLAGS     01235000
         MVI   SUBPDIAL,78              GETMAIN SUBPOOL                 01236000
         LA    R0,16+96+64+16+32        GETMAIN AREA SIZE               01237000
         ICM   R0,B'1000',SUBPDIAL      GETMAIN SUBPOOL                 01238000
         GETMAIN R,LV=(0)                                               01239000
         XC    0(16+96+64+16+32,R1),0(R1)                               01240000
         STCM  R1,B'0111',SUBPDIAL+1    CREATED CPPL START              01241000
         LA    R2,16(,R1)               CREATED CBUF START              01242000
         LA    R3,96(,R2)               CREATED ECT START               01243000
         LA    R4,64(,R3)               CREATED I/O SERVICE AREA        01244000
         LA    R5,16(,R4)               CREATED I/O WORK AREA           01245000
         ST    R2,CPPLCBUF-CPPL(,R1)    START OF CBUF                   01246000
         ST    R3,CPPLECT-CPPL(,R1)     START OF ECT                    01247000
         MVI   0(R5),X'80'              MARK END OF THE LIST            01248000
         ST    R5,0(,R4)                FIRST I/O WORK ELEMENT          01249000
         ST    R5,4(,R4)                LAST USED I/O WORK ELEMENT      01250000
         MVC   8(2,R4),=H'32'           INITIAL I/O WORK AREA LENGTH    01251000
         L     R5,16                    --> CVT                         01252000
         L     R5,0(,R5)                --> TCB WORDS                   01253000
         L     R5,4(,R5)                --> TCB                         01254000
         L     R5,180(,R5)              --> JSCB                        01255000
         L     R5,264(,R5)              --> PSCB                        01256000
         ST    R5,CPPLPSCB-CPPL(,R1)                                    01257000
         L     R5,52(,R5)               --> UPT                         01258000
         ST    R5,CPPLUPT-CPPL(,R1)                                     01259000
         MVC   ECTPCMD-ECT(8,R3),BLANKS CLEAR THE PRIMARY COMMAND       01260000
         MVC   ECTSCMD-ECT(8,R3),BLANKS CLEAR THE SECONDARY COMMAND     01261000
         ST    R4,ECTIOWA-ECT(,R3)      START OF THE I/O SERVICE AREA   01262000
         L     R15,0(,R6)               START OF THE PARM AREA          01263000
         LR    R6,R1                    POINT TO THE CREATED CPPL       01264000
         LH    R5,0(,R15)               PARM LENGTH                     01265000
         LA    R1,4(,R5)                                                01266000
         STH   R1,0(,R2)                CBUF STRING LENGTH              01267000
         BCTR  R5,0                     MACHINE STRING LENGTH           01268000
         MVC   4(*-*,R2),2(R15)         <<EXECUTED>>                    01269000
         EX    R5,*-6                   MOVE IN THE PARM STRING         01270000
         LA    R15,4(,R2)               PREPARE FOR STRING SCAN         01271000
         LR    R14,R15                                                  01272000
         SPACE 1                                                        01273000
         LA    R15,1(,R15)              FIND                            01274000
         CLI   0(R15),X'40'                 FIRST                       01275000
         BNE   *-8                               NON-BLANK              01276000
         SPACE 1                                                        01277000
         LR    R5,R15                                                   01278000
         SR    R5,R14                   LENGTH OF PDS PROGRAM NAME      01279000
         BCTR  R5,0                     MACHINE LENGTH                  01280000
         MVC   ECTPCMD-ECT(*-*,R3),4(R2)  <<EXECUTED>>                  01281000
         EX    R5,*-6                   MOVE IN THE PDS PROGRAM NAME    01282000
         SPACE 1                                                        01283000
         LA    R15,1(,R15)              FIND                            01284000
         CLI   0(R15),X'40'                 NEXT                        01285000
         BE    *-8                              BLANK                   01286000
         SPACE 1                                                        01287000
         SR    R15,R14                                                  01288000
         STH   R15,2(,R2)               OFFSET TO OPERANDS              01289000
         MVI   ECTSWS2-ECT(R3),ECTDEFCS DEFAULT DELETE CHARACTERS USED  01290000
         LOAD  EP=ISPLINK               ADDRESS OF SPF INTERFACE MODULE 01291000
         ST    R0,ISPLINK               SAVE ADDRESS FOR LATER          01292000
*        BAL   R2,CLEAR1                TURN OFF FULL-SCREEN MODE       01293000
         SPACE 3                                                        01294000
         NOP   INITADDR                   ZAP FOR TESTING               01295000
*        L     R2,16                   ** CHECK FOR TSO/E RELEASE 2     01296000
*        ICM   R2,B'1111',X'9C'(R2)       --> LOGON WORK AREA?          01297000
*        BZ    FECTSTD                        NO, BRANCH                01298000
*        ICM   R2,B'1111',X'20'(R2)       --> ECT?                      01299000
*        BNZ   FECTUPD                        YES, BRANCH               01300000
         SPACE 1                                                        01301000
FECTSTD  L     R2,X'21C'               ** PRE-TSO/E RELEASE 2 SYSTEM    01302000
         L     R2,X'7C'(,R2)              --> FIRST JSTCB               01303000
         L     R2,X'88'(,R2)              --> DAUGHTER TCB              01304000
         L     R2,X'50'(,R2)              --> IKJEFT01 REGISTER 8       01305000
         L     R2,X'2C'(,R2)              --> ECT                       01306000
         SPACE 1                                                        01307000
FECTUPD  L     R1,SUBPDIAL             ** UPDATE THE ECT ADDRESS        01308000
         ST    R2,CPPLECT-CPPL(,R1)       NEW ECT POINTER               01309000
         MVC   ECTPCMD-ECT(8+8,R2),ECTPCMD-ECT(R3)                      01310000
.MA00060 ANOP  ,                                                   @D01
         SPACE 3                                                        01311000
INITADDR LM    R2,R4,CPPLUPT-CPPL(R6)   INITIALIZE ADDRUPT,             01312000
         L     R5,CPPLCBUF-CPPL(R6)       ADDRPSCB, ADDRECT,            01313000
         STM   R2,R6,ADDRUPT              ADDRCBUF AND ADDRCPPL         01314000
         MVC   PDSNAME,ECTPCMD-ECT(R4)  SAVE THE PDS COMMAND NAME       01315000
         CLI   ECTSCMD-ECT(R4),X'40'      IS PDS A SUBCOMMAND?          01316000
         BE    INITADD2                   NO, BRANCH                    01317000
         CLC   ECTSCMD-ECT(3,R4),=C'GO '  GO (UNDER TEST)?              01318000
         BE    INITADD2                   YES, BRANCH                   01319000
         CLC   ECTSCMD-ECT(4,R4),=C'END ' RUN (UNDER TEST)?             01320000
         BE    INITADD2                   YES, BRANCH                   01321000
         MVC   PDSNAME,ECTSCMD-ECT(R4)    SAVE THE PDS COMMAND NAME     01322000
         SPACE 1                                                        01323000
*----------------------------------------------------------------* @D01
*        Find length of PDS command name.                          @D01
*----------------------------------------------------------------* @D01
INITADD2 DS    0H                                                  @D01
         LA    R1,L'PDSNAME-1           Initialize loop count      @D01
INITAD2A LA    R15,PDSNAME(R1)          Point to last character    @D01
         CLI   0(R15),C' '              Is it a blank?             @D01
         BNE   INITAD2B                 No, end of string found    @D01
         BCT   R1,INITAD2A              Back to look at previous   @D01
INITAD2B LA    R1,1(,R1)                Adjust for actual length   @D01
         STC   R1,PDSNAML               Save name length           @D01
         SPACE 1                                                   @D01
*  SET DEFAULTS FOR CONTROL --                                     @D01 01324000
         OI    FLAGSGG,&CONGLBL         SET DEFAULT GLOBAL VARIABLES    01325000
         OI    FLAGSJJ,&CONADEF         SET DEFAULT ALLOCATION MSG      01326000
         AIF   (&MVT).MA00080                                      @D01
         TM    ECTSWS-ECT(R4),ECTBKGRD  BACKGROUND MODE?                01327000
         BNO   INITADD3                 NO, BRANCH                      01328000
         OI    FLAGSEE,FBKGRND          YES, SET A FLAG FOR LATER       01329000
         OI    FLAGSGG,FRECVCON         YES, NO RECOVERY IS A DEFAULT   01330000
.MA00080 ANOP  ,                                                   @D01
         SPACE 1                                                        01331000
INITADD3 STM   R9,R12,BASES             SAVE BASE REGISTERS             01332000
         MVC   BLDLLIST,BLDLPARM        BLDL NUMBER OF MEMBERS & LENGTH 01333000
         ST    R7,8(,R13)               CHAIN                           01334000
         ST    R13,4(,R7)                    SAVE                       01335000
         LR    R13,R7                            AREAS                  01336000
         SPACE 1                                                        01337000
         L     R5,WORKBUFF                                              01338000
         AIF   (&MVT).MA00100                                      @D01
         LA    R0,0(,R5)                CLEAR THE TOP BYTE              01339000
         GETMAIN RU,LV=(0),SP=1,BNDRY=PAGE                              01340000
         AGO   .NA00100                                            @D01
.MA00100 ANOP  ,                                                   @D01
         GETMAIN R,LV=(R5)                                         @D01
.NA00100 ANOP  ,                                                   @D01
         L     R0,=F'32768'             MAXIMUM BLOCKSIZE               01341000
         ST    R1,IOBUFF1               INPUT BUFFER 1                  01342000
         AR    R1,R0                                                    01343000
         ST    R1,IOBUFF2               INPUT BUFFER 2                  01344000
         AR    R1,R0                                                    01345000
         ST    R1,IODIR1                FIRST DIR IOAREA                01346000
         AR    R1,R0                                                    01347000
         ST    R1,IODIR2                SECOND DIR IOAREA               01348000
         SPACE 1                                                        01349000
         LA    R1,2048(,R7)                                             01350000
         LA    R1,2048(,R1)             POINT TO DMEMAREA (MEMBER LIST) 01351000
         ST    R1,PMEMMIN               FIRST ELEMENT OF THE LIST       01352000
         LA    R0,TSMSGWRK-WORKAREA-4096(R1)  POINT TO TSMSGWRK         01353000
         SH    R1,=H'20'                                                01354000
         ST    R1,PMEMMAX               LAST ELEMENT OF THE LIST -20    01355000
         AIF   (&MVT).MA00110                                      @D01
         ST    R0,MTEXTRCT              SAVE EXTRACT ADDRESS            01356000
         MVI   MTEXTRCT,124             MAXIMUM TEXT LENGTH             01357000
.MA00110 ANOP  ,                                                   @D01
         GTSIZE
         STM   R0,R1,PAGESIZE           LINES/SCREEN                    01359000
*        ST    R1,LINESIZE              CHARACTERS/LINE                 01360000
         SPACE 1                                                        01361000
         MVC   STAEPARM(4),STAELIST     SET A ESTAE EXIT                01362000
         ESTAE STAEEXIT,CT,PARAM=(R7),MF=(E,STAEPARM)                   01363000
         SPACE 1                                                        01364000
         LA    R14,MTCSECTP            START OF MESSAGE DESCRIPTOR      01365000
         L     R15,ADDRCPPL            START OF THE CPPL                01366000
         LA    R0,ATTNECB              ECB TO USE                       01367000
         STM   R14,R0,MTPLPTR          INITIALIZE IKJEFF02 FIELDS       01368000
         AIF   (&MVT).MA00120                                      @D01
         OI    MTHIGH,X'80'            STANDARD LINKAGE                 01369000
.MA00120 ANOP  ,                                                   @D01
         OI    MTSW1,MTPUTLSW+MTJOBISW MESSAGE -- PUTLINE AND COMPRESS  01370000
         MVI   MTMSGID,C'L'            MESSAGE IDENTIFIER (FIRST BYTE)  01371000
         LA    R1,INSERT#1             ADDRESS OF INSERT 1              01372000
         ST    R1,MTADDR-1             START OF INSERT INFORMATION      01373000
         MVI   MTHIGHL,8               LENGTH OF THE STANDARD INSERT    01374000
         LA    R1,INSERT#2             ADDRESS OF INSERT 2              01375000
         ST    R1,MTADDR+4-1           START OF INSERT INFORMATION      01376000
         MVI   MTHIGHL+4,8             LENGTH OF THE STANDARD INSERT    01377000
         TITLE 'P D S  --  PDS SERVICE ROUTINE ADDRESSES       1/15/85' 01378000
*                                                                       01379000
*    LOCATE THE TSO SERVICE ROUTINES AND THE DISK ADDRESS CONVERTERS    01380000
*                                                                       01381000
         LA    R2,ADDRPUTL              FIRST SERVICE ROUTINE ADDRESS   01382000
         LA    R3,MODULEN               FIRST LOAD ADDRESS              01383000
         SPACE 1                                                        01384000
SERVLOOP DS    0H                       Init service routines      @D01
         XR    R0,R0                    Clear offset register      @D01
         ICM   R0,B'0011',0(R3)         Get CVT offset for routine @D01
         BZ    SERVLOAD                 No offset, perform load    @D01
         L     R1,CVTPTR                Get base address of CVT    @D01
         AR    R1,R0                    Build CVT address of field @D01
         ICM   R0,B'1111',0(R1)         ANY PRELOADED ADDRESS?          01387000
         BNZ   SERVCVTA                 YES, BRANCH                     01388000
SERVLOAD DS    0H                       Load service routine       @D01
***      XC    PARMLIST(12),PARMLIST    CLEAR THE PARMLIST AREA         01389000
         LOAD  EPLOC=2(R3)  ***,SF=(E,PARMLIST)                         01390000
         MVI   0(R2),X'D6'              MARK TO DELETE LATER            01391000
         SPACE 1                                                        01392000
SERVCVTA STCM  R0,B'0111',1(R2)         UPDATE THE ADDRESS              01393000
         LA    R2,4(,R2)                NEXT SERVICE ADDRESS            01394000
         LA    R3,10(,R3)               NEXT MODULES ADDRESS            01395000
         CLI   0(R3),X'FF'              END OF MODULES?                 01396000
         BNE   SERVLOOP                 NO, BRANCH                      01397000
         SPACE 2                                                        01398000
         L     R2,ADDRPSCB              ADDRESS OF THE PSCB             01399000
         MVC   PARMLIST(4),ENQSTEP      SET OPTION BITS FOR ENQ         01400000
         ENQ   (SPFUSER,PSCBUSER-PSCB(R2),E,7,STEP),RET=TEST,          X01401000
               MF=(E,PARMLIST)          CHECK FOR SPF ENQ               01402000
         SPACE 1                                                        01403000
         LTR   R15,R15                  SPF ALREADY INITIALIZED?        01404000
         BZ    PRIM00                   NO, BRANCH                      01405000
         XI    FLAGSFF,FSPFOPT6         YES, INVERT THE OPTION 6 FLAG   01406000
         TM    FLAGSFF,FSPFDIAL         DIALOG ALREADY?                 01407000
         BO    *+8                      YES, BRANCH                     01408000
         BAL   R2,CLEAR1                NO, WAKE UP SESSION MANAGER     01409000
         TITLE 'P D S  --  PDS PRIMARY SUBCOMMAND CHECK        1/15/85' 01410000
*                                                                       01411000
*     GET THE DATA SET NAME AND ANY SUBCOMMAND FROM THE COMMAND LINE    01412000
*                                                                       01413000
         SPACE 1                                                        01414000
PRIM00   L     R2,ADDRCBUF         COMMAND BUFFER                       01415000
         LH    R3,0(,R2)           TOTAL COMMAND LENGTH                 01416000
         LR    R1,R3               TOTAL COMMAND LENGTH                 01417000
         BCTR  R1,0                MACHINE LENGTH                       01418000
         LA    R14,FIRST4K         BASE FOR RECALLST                    01419000
         MVC   RECALLST-FIRST4K(*-*,R14),0(R2) <<EXECUTED>>             01420000
         EX    R1,*-6              SAVE PREVIOUS SUBCOMMAND             01421000
         XC    RECALLST-FIRST4K(2,R14),=F'0'                            01422000
         SPACE 1                                                        01423000
         LH    R4,2(,R2)           OFFSET TO OPERANDS                   01424000
         LA    R4,4(,R4)           PLUS COUNT BYTES                     01425000
         LA    R2,0(R2,R4)         START OF OPERANDS                    01426000
         SR    R3,R4               BYTES LEFT TO SCAN - ANY?            01427000
         BNP   PRIM90              NO, BRANCH                           01428000
         SPACE 1                                                        01429000
PRIM10   OI    0(R2),X'40'         UPPER-CASE THE OPERANDS              01430000
         CLI   0(R2),X'40'         BLANK?                               01431000
         BE    PRIM20              YES, BRANCH                          01432000
         LA    R2,1(,R2)           NO, TRY THE NEXT ONE                 01433000
         BCT   R3,PRIM10                                                01434000
         B     PRIM90              NOT FOUND, BRANCH                    01435000
         SPACE 1                                                        01436000
PRIM20   OI    0(R2),X'40'         UPPER-CASE THE OPERANDS              01437000
         LA    R5,PRIMOPTN-2       PDS VALID KEYWORD TABLE START -2     01438000
         CLI   0(R2),X'40'         BLANK?                               01439000
         BNE   PRIM30              NO, BRANCH                           01440000
         LA    R2,1(,R2)           YES, TRY THE NEXT ONE                01441000
         BCT   R3,PRIM20                                                01442000
         B     PRIM90              NOT FOUND, BRANCH                    01443000
         SPACE 1                                                        01444000
PRIM30   LA    R5,2(,R5)           NEXT VALID KEYWORD ENTRY             01445000
         CLI   0(R5),X'FF'         END OF KEYWORD TABLE?                01446000
         BE    PRIM40              YES, FOUND A SUBCOMMAND              01447000
         CLC   0(1,R2),0(R5)       FIRST CHARACTER MATCH?               01448000
         BNE   PRIM30              NO, CONTINUE LOOPING                 01449000
         SPACE 1                                                        01450000
         C     R3,=F'1'            ANOTHER CHARACTER?                   01451000
         BNH   PRIM90              NO, NO SUBCOMMAND ADDED              01452000
         OI    1(R2),X'40'         UPPER-CASE THE NEXT CHARACTER        01453000
         CLC   1(1,R2),1(R5)       MATCH SECOND CHARACTER TOO?          01454000
         BE    PRIM10              YES, --NOT A SUBCOMMAND--            01455000
         CLI   1(R2),X'40'         SECOND CHARACTER A BLANK?            01456000
         BE    PRIM10              YES, --NOT A SUBCOMMAND--            01457000
         CLI   1(R2),C'('          PARENTHESIS FOLLOWING V (FOR VOL)?   01458000
         BE    PRIM10              YES, --NOT A SUBCOMMAND--            01459000
         EJECT                                                          01460000
PRIM40   LA    R0,256              COUNT OF SUBCOMMAND CHARACTERS       01461000
         ICM   R0,B'1000',=X'01'   SUBPOOL 1                            01462000
         GETMAIN R,LV=(0)                                               01463000
         MVI   0(R1),X'40'         BLANK THE                            01464000
         MVC   1(255,R1),0(R1)              SUBCOMMAND STORAGE          01465000
         XC    0(4,R1),0(R1)       CLEAR THE FIRST WORD                 01466000
         MVI   0(R1),1             LENGTH=1*256                         01467000
         ST    R1,SUBCMNDP         SAVE THE STORAGE POINTER             01468000
         SPACE 1                                                        01469000
PRIM42   OC    4(1,R1),0(R2)       MOVE AND UPPER-CASE THE CHARACTER    01470000
         MVI   0(R2),X'40'         BLANK THE COMMAND LINE CHARACTER     01471000
         LA    R1,1(,R1)                                                01472000
         LA    R2,1(,R2)                                                01473000
         BCT   R3,PRIM42                                                01474000
         SPACE 3                                                        01475000
PRIM90   ICM   R1,B'1111',SUBCMNDP ADDRESS OF SUBCOMMAND?               01476000
         AIF ('&CISP' EQ 'NO SPF').MA00140                         @D01
         BZ    PRIM92              NO - ZERO, BRANCH                    01477000
         CLC   4(4,R1),$ISM        ISPMODE?                             01478000
         BE    PRIM98              YES, BRANCH                          01479000
         CLC   4(4,R1),$MML        MEMLIST?                             01480000
         BE    PRIM98              YES, BRANCH                          01481000
PRIM92   TM    FLAGSFF,FSPFDIAL    DIALOG ALREADY?                      01482000
         BNO   PRIM96              NO, DO PROGRAM IDENTIFIER            01483000
         LA    R0,=CL8'CONTROL'    FIRST PARAMETER                      01484000
         LA    R1,=CL8'DISPLAY'    SECOND PARAMETER                     01485000
         LA    R2,=CL8'SM     '    THIRD PARAMETER                      01486000
         LA    R3,=F'1'            FOURTH PARAMETER                     01487000
         STM   R0,R3,MSGTEXT2      SAVE ADDRESSES                       01488000
         OI    MSGTEXT2+12,X'80'   LAST                                 01489000
         LA    R1,MSGTEXT2             PARAMETER                        01490000
         L     R15,ISPLINK                                              01491000
         BALR  R14,R15             LET ISPF KNOW                        01492000
.MA00140 ANOP  ,                                                   @D01
         SPACE 2                                                        01493000
PRIM96   MVC   INSERT#1(8),PDSNAME                                      01494000
         MVC   MTLEN,PDSNAML       Set insert length               @D01
         TSMSG L100$1                                                   01495000
         MVI   MTLEN,8             Restore standard length         @D01
         MESSAGE MSGBLANK          ONE BLANK LINE                       01496000
         SPACE 2                                                        01497000
PRIM98   MVC   ##SUBCOM(PTW),$CHA  PCL FOR DATA SET NAME                01498000
         L     R15,=A(PARSE)       PARSE ADDRESS                        01499000
         BALR  R14,R15             CALL PARSE                           01500000
         B     EXIT12N             ERROR EXIT                           01501000
         SPACE 2                                                        01502000
         ICM   R1,B'1111',SUBCMNDP    ADDRESS OF SUBCOMMAND?            01503000
         ST    R1,ADDRCBUF                                              01504000
         BZ    PRIM99                 NO - ZERO, BRANCH                 01505000
         OI    FLAGSBB,FCMD+FONESHOT  YES, INDICATE ONE SUBCOMMAND ONLY 01506000
         B     RESTART0                    AND SKIP THE PROGRAM MESSAGE 01507000
         SPACE 1                                                        01508000
PRIM99   L     R1,$DSN+8           ALLOCATION STATUS ROUTINE            01509000
         ST    R1,##ADRCMD         EXECUTED AFTER OPEN OF DATA SET      01510000
         MVI   ##ADRCM#,CONTINUE   FLAG TO CONTINUE                     01511000
         TITLE 'P D S  --  PDS DATA SET INITIALIZATION         1/15/85' 01512000
RESTART0 DS    0H                  ** ALLOCATE OR REALLOCATE DATA SET   01513000
         SPACE 1                                                        01514000
         MVC   DSPALLOC,DSPREQST   SET INITIAL DISPOSITION SHR/OLD      01515000
         SPACE 2                                                        01516000
         L     R15,=A(ALLOCATE)    ALLOCATION ROUTINE ADDRESS           01517000
         XC    RECOVER,RECOVER     CANNOT RECOVER - NOT INITIALIZED YET 01518000
         BALR  R14,R15             ALLOCATE THE DATA SET                01519000
         B     EXIT12N             ALLOCATION UNSUCCESSFUL              01520000
         SPACE 1                                                        01521000
RESTART2 MVC   INDCB(LEXCPDCB),EXCPDCB MOVE PATTERN DCB                 01522000
         MVC   STOWDCB(LSAMDCB),SAMDCB ALSO FOR STOW OPERATIONS         01523000
         MVC   DCBDDNAM-IHADCB+INDCB,DDNAME                             01524000
         MVC   DCBDDNAM-IHADCB+STOWDCB,DDNAME                           01525000
         MVC   DCBDSORG-IHADCB+STOWDCB(1),DSORG                         01526000
         TM    DSORG,DS1DSGPO                    DSORG=PO?              01527000
         BO    *+8                               YES, BRANCH            01528000
         MVI   DCBDSORG-IHADCB+STOWDCB,DS1DSGPS  NO, USE DSORG=PS       01529000
         SPACE 2                                                        01530000
RESTART4 MVI   OPENLIST,X'00'      ** REOPEN THE DATA SET          **   01531000
         MVI   OPENLIST+4,X'80'                                         01532000
         XC    RECOVER,RECOVER     CANNOT RECOVER - NOT INITIALIZED YET 01533000
         XC    BLKSI(2),BLKSI                                           01534000
         OPEN  (STOWDCB,INPUT,INDCB,INPUT),MF=(E,OPENLIST)              01535000
         SPACE 1                                                        01536000
         MVI   OPENLIST,X'80'                                           01537000
         CLOSE (STOWDCB),MF=(E,OPENLIST)       OPENED FOR DCB EXIT ONLY 01538000
         SPACE 1                                                        01539000
         TM    DCBOFLGS-IHADCB+INDCB,DCBOFOPN  DCB OPEN?                01540000
         BNO   EXIT12O                         NO, QUIT                 01541000
         SPACE 2                                                        01542000
         NI    FLAGSCC,FF-FBLDLOK              BLDL IS INVALID NOW      01543000
         EJECT                                                          01544000
         L     R1,DCBDEBAD-IHADCB+INDCB        DEB ADDRESS              01545000
         MVC   NUMEXT+1(1),DEBNMEXT(R1)        NUMBER OF D.A. EXTENTS   01546000
         L     R4,DEBUCBAD(,R1)                ADDRESS OF FIRST UCB     01547000
         ST    R4,UCBADDR                      ADDRESS OF FIRST UCB     01548000
         MVC   BYTEUCB+1(1),UCBTYP+3(R4)       SAVE THE UCB DEVICE TYPE 01549000
         CLI   VOLALLOC,X'40'                  ANY VOLUME DISCOVERED?   01550000
         BNE   RESTART5                        YES, OBTAIN IS DONE      01551000
         MVC   VOLALLOC,UCBVOLI(R4)            SAVE VOLUME NAME USED    01552000
         L     R14,OBTAIN                      OBTAIN FLAGS             01553000
         LA    R15,DSNAME                      ADDRESS OF DSNAME        01554000
         LA    R0,VOLALLOC                     VOLUME SERIAL            01555000
         LA    R1,DS1FMTID                     OUTPUT START ADDRESS     01556000
         STM   R14,R1,PARMLIST                 SAVE CAMLIST PARAMETERS  01557000
         OBTAIN PARMLIST                       GET THE FORMAT 1 DSCB    01558000
         LTR   R15,R15                         SUCESSFUL OBTAIN?        01559000
         BZ    RESTART5                        YES, BRANCH              01560000
         SPACE 1                                                        01561000
*     IF THE DSNAME IS AN ALIAS ENTRY IN A VSAM CATALOG, A LOCATE       01562000
*     WILL PUT THE TRUE NAME IN THE DSNAME FIELD -- ISSUE A LOCATE,     01563000
*     AND TRY THE OBTAIN AGAIN.                                         01564000
         MVC   WORKTBL(44),DSNAME              COPY DSNAME              01565000
         L     R14,LOCATE                                               01566000
         LA    R15,WORKTBL                     ACTUAL DSNAME            01567000
         SR    R0,R0                           NO CVOL VALUE            01568000
         LA    R1,MSGTEXT1                     LOCATE WORK AREA         01569000
         STM   R14,R1,PARMLIST                 SAVE CAMLIST PARAMETERS  01570000
         LOCATE PARMLIST                                                01571000
         LA    R1,L830                         NO DSCB FOUND MESSAGE    01572000
         LTR   15,15                           SUCCESSFUL LOCATE?       01573000
         BNZ   EXIT12M                         NO, ERROR                01574000
         SPACE 1                                                        01575000
         L     R14,OBTAIN                      OBTAIN FLAGS             01576000
         LA    R15,WORKTBL                     ACTUAL DSNAME            01577000
         LA    R0,VOLALLOC                     VOLUME SERIAL            01578000
         LA    R1,DS1FMTID                     OUTPUT START ADDRESS     01579000
         STM   R14,R1,PARMLIST                 SAVE CAMLIST PARAMETERS  01580000
         OBTAIN PARMLIST                       GET THE FORMAT 1 DSCB    01581000
         SPACE 1                                                        01582000
         LA    R1,L830                         NO DSCB FOUND MESSAGE    01583000
         LTR   R15,R15                         SUCCESSFUL?              01584000
         BNZ   EXIT12M                         NO, QUIT                 01585000
         SPACE 2                                                        01586000
RESTART5 STM   R14,R12,12(R13)                 SAVE REGISTERS           01587000
         ICM   R0,B'0111',DS1LSTAR             DS1LSTAR --> MBBCCHHR    01588000
         SLL   R0,8                            MOVE TO HIGH POSTION     01589000
         L     R1,DCBDEBAD-IHADCB+INDCB        DEB ADDRESS              01590000
         LA    R2,LSTARMBB                     RETURN ADDRESS           01591000
         L     R15,ADDRCNVT                    CONVERSION ROUTINE       01592000
         LR    R3,R13                          SAVE R13                 01593000
         BALR  R14,R15                                                  01594000
         LR    R13,R3                          RESTORE R13              01595000
         LM    R14,R12,12(R13)                 RESTORE REGISTERS        01596000
         SPACE 2                                                        01597000
         LA    R0,IOECB                        ECB ADDRESS              01598000
         ST    R0,IOBECB                       SET INTO IOB             01599000
         LA    R0,INDCB                        DCB ADDRESSS             01600000
         ST    R0,IOBDCB                       SET INTO DCB             01601000
         MVI   IOB,X'C2'                       SET IOB FLAGS            01602000
         SPACE 2                                                        01603000
         XC    TOTUSEDX(2+2),TOTUSEDX          CLEAR TOTUSEDX/TOTALLOX  01604000
         TM    DSORG,DS1DSGPO                  PARTITIONED DATA SET?    01605000
         BNO   RESTART6                        NO, BRANCH               01606000
         SPACE 1                                                        01607000
         L     R14,=X'01080100'                R=1, K=08, DD=256        01608000
         TRKCALC FUNCTN=TRKCAP,TYPE=BYTEUCB+1,RKDD=(14),              XX01609000
               REGSAVE=YES,MF=(E,PARMLIST)                              01610000
         ST    R0,DIRTRACK                     DIRECTORY BLOCKS/TRACK   01611000
         CLC   DS1LSTAR(3),ZERO                NULL DATA SET?           01612000
         BE    RESTART6                        YES, BRANCH              01613000
         SPACE 1                                                        01614000
         STM   R14,R12,12(R13)                 SAVE REGISTERS           01615000
         LA    R0,1*256                        TTR=000001               01616000
         L     R1,DCBDEBAD-IHADCB+INDCB        DEB ADDRESS              01617000
         LA    R2,IOBSEEK                      RETURN ADDRESS           01618000
         L     R15,ADDRCNVT                    CONVERSION ROUTINE       01619000
         LR    R3,R13                          SAVE R13                 01620000
         BALR  R14,R15                                                  01621000
         LR    R13,R3                          RESTORE R13              01622000
         LM    R14,R12,12(R13)                 RESTORE REGISTERS        01623000
         SPACE 1                                                        01624000
         LA    R1,CCW0                         START OF CHANNEL PROGRAM 01625000
         ST    R1,IOBCCW                                                01626000
         MVC   CCW0(7*8),CCWDIRR               CCW'S TO READ DIRECTORY  01627000
         MVC   WORKTBL(8),IOBSEEK              INITIALIZE BOTH CCHHR'S  01628000
         MVC   WORKTBL+8(8),WORKTBL            INITIALIZE BOTH CCHHR'S  01629000
         LA    R1,WORKTBL+3                    USED CCHHR               01630000
         STCM  R1,B'0111',CCW1+1                                        01631000
         LA    R1,CCW1                         TIC TARGET 1             01632000
         STCM  R1,B'0111',CCW3+1                                        01633000
         LA    R1,WORKTBL+8+3                  TOTAL CCHHR              01634000
         STCM  R1,B'0111',CCW4+1                                        01635000
         LA    R1,CCW4                         TIC TARGET 2             01636000
         STCM  R1,B'0111',CCW6+1                                        01637000
         SPACE 2                                                        01638000
         MVI   IOECB,0                                                  01639000
         EXCP  IOB                                                      01640000
         WAIT  ECB=IOECB                                                01641000
         MVI   IOB,X'C2'                       SET IOB FLAGS            01642000
         NI    DCBIFLG-IHADCB+INDCB,X'3B'      RESET DCB ERROR FLAG     01643000
         SPACE 1                                                        01644000
         STM   R2,R12,28(R13)                  CONVERT CCHHR TO TTR     01645000
         LA    R2,WORKTBL                                               01646000
         L     R1,INDCB+(DCBDEBAD-IHADCB)                               01647000
         L     R15,ADDRRLTV                                             01648000
         LR    R3,R13                                                   01649000
         BALR  R14,R15                                                  01650000
         LR    R13,R3                                                   01651000
         LM    R2,R12,28(R13)                                           01652000
         SRDL  R0,16                           00TT RXXX                01653000
         SRL   R1,24                           00TT 000R                01654000
         MH    R0,DIRTRACK+2                                            01655000
         AR    R0,R1                                                    01656000
         STH   R0,TOTUSEDX                     USED DIR. BLOCKS         01657000
         SPACE 1                                                        01658000
         STM   R2,R12,28(R13)                  CONVERT CCHHR TO TTR     01659000
         LA    R2,WORKTBL+8                                             01660000
         L     R1,INDCB+(DCBDEBAD-IHADCB)                               01661000
         L     R15,ADDRRLTV                                             01662000
         LR    R3,R13                                                   01663000
         BALR  R14,R15                                                  01664000
         LR    R13,R3                                                   01665000
         LM    R2,R12,28(R13)                                           01666000
         SRDL  R0,16                           00TT RXXX                01667000
         SRL   R1,24                           00TT 000R                01668000
         MH    R0,DIRTRACK+2                                            01669000
         AR    R0,R1                                                    01670000
         BCTR  R0,0                                                     01671000
         STH   R0,TOTALLOX                     ALLOCATED DIR. BLOCKS    01672000
         SPACE 2                                                        01673000
RESTART6 MVC   CCWS(LCCWINIT),CCWINIT          INITIALIZE CCWS          01674000
         SPACE 1                                                        01675000
         LA    R0,IOBSEEK+3                                             01676000
         LA    R1,CCW1A                                                 01677000
         STCM  R0,B'0111',CCW1A+1              ***                      01678000
         STCM  R1,B'0111',CCW2A+1              *** -- INIT. CCW'S       01679000
         STCM  R0,B'0111',CCW3A+1              ***                      01680000
         SPACE 1                                                        01681000
         LA    R1,SNO                                                   01682000
         LA    R2,CCW1                                                  01683000
         STCM  R1,B'0111',CCW0+1               ***                      01684000
         STCM  R0,B'0111',CCW1+1               ***                      01685000
         STCM  R2,B'0111',CCW2+1               ***  -- READ CCW'S       01686000
         STCM  R0,B'0111',CCW5+1               ***                      01687000
         STCM  R1,B'0111',CCW6+1               ***                      01688000
         SPACE 2                                                        01689000
         LA    R1,CCW0                         FIRST CCW (SET SECTOR)   01690000
         ST    R1,EXCPCCWI                     SAVE FOR EXCP ROUTINE    01691000
         LH    R15,BYTEUCB                     UCBBYTE                  01692000
         MH    R15,=H'9'                       INDEX INTO UNIT TABLE    01693000
         LA    R15,UNITTBL(R15)                DEVICE UNIT TYPE         01694000
         NI    FLAGSEE,FF-FDISKTRK-FFULLTRK-FDOUBCON                    01695000
         CLI   0(R15),C'M'                     READ MULTIPLE?           01696000
         BE    SETBUFF                         YES, BRANCH              01697000
         OI    FLAGSEE,FFULLTRK                                         01698000
         CLI   0(R15),C'D'                     DOUBLE?                  01699000
         BE    SETBUFF                         YES, BRANCH              01700000
         OI    FLAGSEE,FDOUBCON                NO, MUST BE SINGLE       01701000
         SPACE 1                                                        01702000
SETBUFF  DS    0H                                                  @D01
**       CLI   UCBTYP+3(R4),X'08'              2314 DISK?          @D01
**       BNE   NOT2314                         NO, BRANCH          @D01
         TM    UCBTYP+2(R4),X'10'              DEVICE SUPPORT RPS? @D01
         BO    NOT2314                         BRANCH IF SO        @D01
         ST    R2,EXCPCCWI                     YES, DO NOT READ SECTOR  01705000
         XI    CCW5+4,X'40'                    DO NOT CHAIN CCW5        01706000
         SPACE 1                                                        01707000
NOT2314  MVI   DSORG+1,0                       CLEAR SECOND DSORG BYTE  01708000
         TM    DSORG,DS1DSGIS+DS1DSGPS+DS1DSGDA+DS1DSGPO  DSORG KNOWN?  01709000
         BM    *+10                                       YES, BRANCH   01710000
         MVC   DSORG(2),DS1DSORG                          NO, USE LABEL 01711000
         SPACE 1                                                        01712000
         MVC   MSGENTDS,PDS300A                " ENTER OPTIONS -- DSN=. 01713000
         LA    R1,MSGENTDS+25+7                WHERE TO ADD DSNAME      01714000
         MVC   0(44,R1),DSNAME                 ADD DSNAME               01715000
         AH    R1,DSNLEN                       POINT TO DSNAME END      01716000
         MVC   0(9,R1),=C',VOL=SER='           ADD ",VOL=SER="          01717000
         MVC   9(6,R1),VOLALLOC                ADD VOLUME SERIAL        01718000
         TM    DSORG,DS1DSGPO                  PARTITIONED?             01719000
         BNO   *+10                            NO, BRANCH               01720000
         MVC   9+6+2(4,R1),=C'MEM='            DEFAULT GROUP NAME  @D01 01721000
         LA    R1,9+6+2+4(,R1)                 WHERE TO ADD MEM=.. @D01 01722000
         ST    R1,MSGENTPT                     WHERE TO ADD MEM=.. @D01 01723000
         BAL   R14,DEFGROUP                    ADD DEFAULT GROUP        01724000
         SPACE 1                                                        01725000
         MVC   LABLRECL(2),LRECL               SAVE THE DCB LRECL FIELD 01726000
         TM    FLAGSCC,RECFMF                  FIXED FORMAT?            01727000
         BNO   NEWSTAX                         NO, BRANCH               01728000
         TM    RECFM,DCBRECBR                  RECFM=FB?                01729000
         BO    NEWSTAX                         YES, BRANCH              01730000
         MVC   LRECL(2),BLKSI                  RECFM=F ONLY             01731000
         SPACE 1                                                        01732000
NEWSTAX  LA    R0,NEWCMD              ABEND RECOVERY ADDRESS            01733000
         ST    R0,RECOVER                                               01734000
         L     R14,ADDRECT                                              01735000
         MVC   ECTPCMD-ECT(8,R14),PDSNAME   RESET PDS COMMAND NAME      01736000
         SPACE 1                                                        01737000
         STAX  ATTNEXIT,USADDR=(R7),REPLACE=YES,IBUF=0,OBUF=0,         X01738000
               MF=(E,STAXPARM)                                          01739000
         SPACE 1                                                        01740000
         ICM   R8,B'1111',##ADRCMD    SUBCOMMAND TO BE CONTINUED?       01741000
         BNM   NEWCMD                 NO, BRANCH                        01742000
         NI    ##ADRCM#,FF-CONTINUE           TURN OFF CALL FLAG        01743000
         BALR  R2,R8                  YES, BRANCH                       01744000
         TITLE 'P D S  --  PDS NEW SUBCOMMAND PROCESSING       1/15/85' 01745000
*                                                                       01746000
*  GET THE NEXT SUBCOMMAND                                              01747000
*                                                                       01748000
         SPACE 1                                                        01749000
NEWCMD   SR    R0,R0                                                    01750000
         ICM   R0,B'1000',SUBPOOLT     ANY TEMPORARY STORAGE?           01751000
         MVI   SUBPOOLT,0              CLEAR THE SUBPOOL CHARACTER      01752000
         BZ    NEWCMD10                NO, LINK TO THE SUBCOMMAND       01753000
         FREEMAIN R,SP=(0)             YES, RELEASE IT                  01754000
         SPACE 1                                                        01755000
NEWCMD10 MVI   STARTTR+3,0             CLEAR THE READ ADDRESS           01756000
         BAL   R2,SHUTSTOW             CLOSE STOW; RELEASE ANY ENQUEUES 01757000
         MVI   MTHIGHL,8               LENGTH OF STANDARD INSERT 1      01758000
         MVI   MTHIGHL+4,8             LENGTH OF STANDARD INSERT 2      01759000
         TM    FLAGSAA,FMEM#MEM        MEMBER GROUP IN PROGRESS?        01760000
         BO    MEMSGET                 YES, BRANCH                      01761000
         SPACE 2                                                        01762000
         TM    FLAGSEE,FMEMLIST        LIST OF MEMBER NAMES?            01763000
         BNO   NEWCMD20                NO, BRANCH                       01764000
         TM    DSORG,DS1DSGPO          PARTITIONED?                     01765000
         BNO   NEWCMD20                NO, MEMBER NAME NOT NEEDED       01766000
         TM    ##ADRPC#,@G             MEMBER GROUP ALLOWED?            01767000
         BNO   NEWCMD20                NO, BRANCH                       01768000
         L     R1,PMEMCURR             CURRENT MEMBER LIST ELEMENT      01769000
         C     R1,PMEMMAX              IN THE LIST?                     01770000
         BH    NEWCMD20                NO, BRANCH                       01771000
         NI    FLAGSAA,FOPTIONS        PRESERVE THE OPTIONS FLAG        01772000
         OC    FLAGSAA,0(R1)           RESET CONTROL FLAGS              01773000
         MVC   LMEMBER1+1(19),1(R1)    RESET MEMBER NAMES AND LENGTH    01774000
         LA    R1,20(,R1)              NEXT LIST ELEMENT                01775000
         ST    R1,PMEMCURR             SAVE FOR NEXT LIST ITERATION     01776000
         MVC   ##SUBCOM(#LSUB),#SUBHOLD  RESET SUBCOMMAND CHANGED DATA  01777000
         TM    FLAGSAA,FMEM#MEM        MEMBER GROUP REQUESTED?          01778000
         BO    CMDVER                  YES, BRANCH                      01779000
         SPACE 1                                                        01780000
         TM    ##ADRPA#,$D              DEFAULT MESSAGE SUBCOMMAND?     01781000
         BO    CMDVER                   NO, BRANCH (NO DEFAULT MESSAGE) 01782000
         MESSAGE MSGBLANK                                               01783000
         MVC   INSERT#1(8),MEMBER1                                      01784000
         TSMSG L002$1            TELL THE USER WHO IS BEING PROCESSED   01785000
         B     CMDVER                                                   01786000
         SPACE 1                                                        01787000
NEWCMD20 MVI   FLAGSAA,0               CLEAR THE MAJOR CONTROL FLAGS    01788000
         MVI   FLAGSII,0               CLEAR ALL FLAGSII FLAGS          01789000
         MVC   PMEMCURR(4),PMEMMIN     RESET THE CURRENT POINTER        01790000
         SPACE 1                                                        01791000
         TM    FLAGSBB,FCMD            COMMAND BUFFER AVAILABLE?        01792000
         BO    HAVECMD                 YES, BRANCH                      01793000
         SPACE 1                                                        01794000
         TM    FLAGSBB,FONESHOT        ONE SUBCOMMAND ONLY?             01795000
         BO    RETURN                  YES, ALL DONE                    01796000
         SPACE 1                                                        01797000
         TM    FLAGSEE,FBKGRND         BACKGROUND MODE?                 01798000
         BNO   NEWCMD30                NO, BRANCH                       01799000
         MESSAGE MSGBLANK              YES, OUTPUT A SEPARATOR LINE     01800000
         SPACE 8                                                        01801000
NEWCMD30 MVI   ATTNECB,2+1             FLAG -- CAN BE ATTENTIONED       01802000
        $PUTGET MSGENTDS,ATTN=NEWCMD40 FIRST TRY FOR A COMMAND          01803000
         B     HAVECMD                 GOT A COMMAND                    01804000
         SPACE 2                                                        01805000
NEWCMD40 MVI   ATTNECB,2+1             FLAG -- CAN BE ATTENTIONED       01806000
        $PUTGET MSGENTDS,ATTN=EXIT8N   SECOND TRY FOR A COMMAND         01807000
         B     HAVECMD                 GOT A COMMAND                    01808000
         SPACE 2                                                        01809000
NEWCMD50 BAL   R2,FREEPDL              FREE THE PARSE PDL               01810000
         TITLE 'P D S  --  PDS SUBCOMMAND INVOKE SCAN          1/15/85' 01811000
*                                                                       01812000
*        SET UP FOR SUBCOMMAND SCAN                                     01813000
*                                                                       01814000
         SPACE 1                                                        01815000
HAVECMD  NI    FLAGSBB,FF-FCMD                                          01816000
         SPACE 2                                                        01817000
         LA    R15,PARMLIST                                             01818000
         USING CSPL,R15                                                 01819000
         SPACE 1                                                        01820000
         L     R1,ADDRUPT              ADDRESS OF THE UPT               01821000
         L     R2,ADDRECT              ADDRESS OF THE ECT               01822000
         L     R14,ECTIOWA-ECT(R2)     ADDRESS OF I/O WORK AREA    @D01
         L     R14,0(,R14)             STACK ADDRESS               @D01
         ST    R14,PARMSTAK            SAVE STACK ADDRESS FOR      @D01
         LA    R3,ATTNECB              ADDRESS OF THE ATTENTION ECB     01823000
         LA    R4,ZERO                 ADDRESS OF A ZERO FLAG AREA      01824000
         LA    R5,SCANANSR             ADDRESS OF THE RESULT AREA       01825000
         L     R6,ADDRCBUF             ADDRESS OF THE SUBCOMMAND        01826000
         STM   R1,R6,CSPLUPT           SETUP CSPLUPT, CSPLECT, CSPLECB, 01827000
         DROP  R15                           CSPLFLG, CSPLOA & CSPLCBUF 01828000
         SPACE 1                                                        01829000
         LA    R14,FIRST4K                                              01830000
         MVC   MSGTEXT1(256),RECALLST-FIRST4K(R14) SAVE SUBCOMMAND      01831000
         CLC   0(2,R6),=H'4'                    NULL INPUT?             01832000
         BE    HAVECMD8                         YES, IGNORE SUBCOMMAND  01833000
         MVC   RECALLST-FIRST4K(256,R14),0(R6)  NO, RESET SUBCOMMAND    01834000
         SPACE 2                                                        01835000
         CLI   4(R6),C'?'              QUESTION ?                       01836000
         BE    HAVECMD2                YES, BRANCH                      01837000
         CLI   4(R6),C'.'              PERIOD (FOR EXTENDED HELP)?      01838000
         BNE   HAVECMD6                NO, BRANCH                       01839000
         CLI   5(R6),C'?'              QUESTION (FOR EXTENDED HELP)?    01840000
         BNE   HAVECMD6                NO, BRANCH                       01841000
         SPACE 1                                                        01842000
HAVECMD2 LA    R1,L520                 ** EXTENDED HELP IS REQUESTED    01843000
         MVC   RECALLST-FIRST4K(256,R14),MSGTEXT1  RESET SUBCOMMAND     01844000
         OC    ERRORMSG(3*5),ERRORMSG  ANY ERRORS NOTED?                01845000
         BZ    MSGNEW                  NO, "NO INFORMATION AVAILABLE"   01846000
         MVC   0(12,R6),MSGHELP        'H MS MS(' AND 4 BYTE LENGTH     01847000
         LA    R2,ERRORMSG-3           START OF ERROR MESSAGES-3        01848000
         LA    R0,3*5/3                MAXIMUM NUMBER OF MESSAGES       01849000
         LH    R4,0(,R6)               CURRENT LENGTH                   01850000
         SPACE 1                                                        01851000
HAVECMD4 LA    R3,0(R4,R6)             POINT TO CURRENT BYTE            01852000
         LA    R2,3(,R2)               NEXT MESSAGE                     01853000
         MVC   0(3,R3),PDS300A+4       'PDSNNN,' (AFTER FORMATTING)     01854000
         MVC   3(3,R3),0(R2)           MESSAGE IDENTIFICATION           01855000
         MVI   6(R3),C','              SEPARATING COMMA                 01856000
         LA    R4,7(,R4)               ADD TO LENGTH                    01857000
         STH   R4,0(,R6)               UPDATE LENGTH                    01858000
         CLI   3(R2),X'00'             ANOTHER MESSAGE?                 01859000
         BE    *+8                     NO, BRANCH                       01860000
         BCT   R0,HAVECMD4             REPEAT FOR ALL MESSAGES          01861000
         MVI   6(R3),C')'              FINAL MATCHING PARENTHESIS       01862000
**       MESSAGE (R6)                  DELETE ** FOR TESTING            01863000
         SPACE 2                                                        01864000
HAVECMD6 XC    ERRORMSG(3*5),ERRORMSG  CLEAR PREVIOUS ERROR MESSAGES    01865000
         SPACE 1                                                        01866000
HAVECMD8 MVI   ATTNECB,0               CLEAR ECB                        01867000
         LA    R1,PARMLIST             PARAMETER LIST START             01868000
         L     R15,ADDRSCAN            IKJSCAN ADDRESS                  01869000
         BALR  R14,R15                 INVOKE COMMAND SCAN              01870000
         SPACE 1                                                        01871000
         LA    R15,SCANANSR            ADDR OF RESULTS                  01872000
         USING CSOA,R15                                                 01873000
         SPACE 1                                                        01874000
         TM    CSOAFLG,CSOANOC         EMPTY BUFFER?                    01875000
         BO    NEWCMD30                YES, STILL NEED COMMAND          01876000
         SPACE 1                                                        01877000
         AIF   (&MVT).MA00160                                      @D01
         TM    CSOAFLG,CSOAEXEC        IMPLICIT EXEC?                   01878000
         BO    EXECPER                 YES, BRANCH                      01879000
.MA00160 ANOP  ,                                                   @D01
         SPACE 2                                                        01880000
         TM    CSOAFLG,CSOAVWP+CSOAVNP VALID COMMAND?                   01881000
         BNZ   HAVECMD9                YES, BRANCH                      01882000
         LA    R1,L877                 INVALID COMMAND MESSAGE          01883000
         CLI   4(R6),X'6E'             RESHOW COMMAND?                  01884000
         BNE   MSGNEW                  NO, BRANCH                       01885000
         MVI   ATTNECB,2+1             FLAG -- CAN BE ATTENTIONED       01886000
        $PUTGET MSGBLANK,ATTN=NEWCMD40 FIRST TRY FOR A COMMAND          01887000
         B     HAVECMD                 GOT A COMMAND                    01888000
         SPACE 2                                                        01889000
HAVECMD9 TM    CSOAFLG,CSOAVWP         ANY OPERAND?                     01890000
         BNO   *+8                     NO, BRANCH                       01891000
         OI    FLAGSAA,FOPTIONS        YES, NOTE FOR LATER              01892000
         TITLE 'P D S  --  PDS SUBCOMMAND TABLE SCAN           1/15/85' 01893000
*                                                                       01894000
*   COMMAND SCAN - IN THE CASE OF A POTENTIALLY AMBIGUOUS ENTRY         01895000
*                  (E.G. 'A ') THE FIRST MATCH IN THE COMMAND TABLE     01896000
*                  (ATTR IN THIS CASE) IS USED.                         01897000
*                                                                       01898000
         L     R2,CSOACNM              ADDR OF COMMAND NAME             01899000
         LH    R3,CSOALNM              LENGTH OF NAME                   01900000
         BCTR  R3,0                    MACHINE LENGTH                   01901000
         SPACE 2                                                        01902000
         LA    R1,$TBL                 START OF COMMAND SCAN            01903000
         SPACE 2                                                        01904000
         CLC   0(*-*,R1),0(R2)         <<EXECUTED>>                     01905000
CMDSCAN  EX    R3,*-6                  THIS SUBCOMMAND?                 01906000
         BNE   CMDSCAN2                NO, BRANCH                       01907000
         SPACE 1                                                        01908000
         MVC   ##SUBCOM(PTW),0(R1)     INITIALIZE ##SUBCOM, ##ADRCMD,   01909000
*                                        ##ADRPCL AND ##ADRPAR          01910000
         TM    DSORG,DS1DSGPO          PARTITIONED?                     01911000
         BO    CMDFND                  YES, BRANCH                      01912000
         TM    ##ADRPC#,@S             SUPPORTED IF NOT PARTITIONED?    01913000
         BO    CMDFND2                 YES, BRANCH                      01914000
         SPACE 1                                                        01915000
CMDSCAN2 LA    R1,PTW(R1)              NEXT ENTRY IN TABLE              01916000
         CLI   0(R1),X'FF'             END OF TABLE?                    01917000
         BNE   CMDSCAN                 NO, CONTINUE                     01918000
         SPACE 1                                                        01919000
         SR    R2,R2                                                    01920000
         L     R8,$OPT+8               OPTIONS SUBCOMMAND START         01921000
         BR    R8                                                       01922000
         SPACE 1                                                        01923000
CMDSCAN4 LA    R15,SCANANSR            INVALID SUBCOMMAND MESSAGE       01924000
         LH    R3,CSOALNM              LENGTH OF NAME                   01925000
         BCTR  R3,0                    MACHINE LENGTH                   01926000
         SR    R2,R2                                                    01927000
         L     R8,$OPT+8               OPTIONS SUBCOMMAND START         01928000
         BR    R8                                                       01929000
         DROP  R15                                                      01930000
         TITLE 'P D S  --  PDS SUBCOMMAND INITIAL PROCESSING   1/15/85' 01931000
CMDFND   NI    ##ADRPC#,FF-@S          PARTITIONED, TURN OFF OTHER FLAG 01932000
         SPACE 2                                                        01933000
CMDFND2  MVC   ##ANSWER(LISUBS),ISUBS  INITIALIZE THE PDL SAVE AREA     01934000
         L     R14,ADDRECT                                              01935000
         MVC   ECTSCMD-ECT(8,R14),##SUBCOM  RESET PDS SUBCOMMAND NAME   01936000
         AIF   (&MVT).MA00180                                      @D01
         NI    ECTSWS2-ECT(R14),FF-X'04'    PROMPT HELP IS ENABLED      01937000
.MA00180 ANOP  ,                                                   @D01
         CLC   0(8,R1),$REC            RECALL SUBCOMMAND?               01938000
         BNE   CMDCHECK                NO, BRANCH                       01939000
         LA    R14,FIRST4K                                              01940000
         MVC   RECALLST-FIRST4K(256,R14),MSGTEXT1  YES, USE PREVIOUS    01941000
         LH    R1,RECALLST-FIRST4K(R14)  LENGTH OF OLD SUBCOMMAND       01942000
         BCTR  R1,0                    MACHINE LENGTH                   01943000
         XC    MSGTEXT1(256),MSGTEXT1  CLEAR THE MESSAGE AREA           01944000
         MVC   MSGTEXT1(*-*),RECALLST-FIRST4K(R14) <<EXECUTED>>         01945000
         EX    R1,*-6                  MOVE IN MESSAGE                  01946000
         CLI   MSGTEXT1+1,79+4         A FULL LINE (80 -1)?             01947000
         BH    *+8                     YES, BRANCH                      01948000
         MVI   MSGTEXT1+1,79+4         NO, CHANGE LENGTH TO 80          01949000
         LA    R1,MSGTEXT1+1(R1)       POINT TO POSITION AFTER TEXT     01950000
         MVI   0(R1),X'40'             ADD ONE TRAILING BLANK           01951000
         MESSAGE MSGTEXT1              DISPLAY THE OLD SUBCOMMAND       01952000
         LH    R1,2(,R6)               OFFSET TO OPERANDS               01953000
         LA    R1,4(R1,R6)             POINT TO OPERANDS                01954000
         TM    FLAGSAA,FOPTIONS        ANY OPERANDS?                    01955000
         BNO   NEWCMD                  NO, BRANCH                       01956000
         OI    0(R1),X'40'             UPPER CASE THE OPERAND           01957000
         CLI   0(R1),C'E'              ENTER OPERAND?                   01958000
         BNE   NEWCMD                  NO, BRANCH                       01959000
         NI    FLAGSAA,FF-FOPTIONS     TURN OFF THE OPERAND FLAG        01960000
         LA    R14,FIRST4K                                              01961000
         MVC   PUTGETBF(256),RECALLST-FIRST4K(R14)  CHANGE TO PREVIOUS  01962000
         B     HAVECMD                 SCAN AND PARSE THIS AGAIN        01963000
         SPACE 2                                                        01964000
CMDCHECK TM    ##ADRPC#,@N       IGNORE OPTIONS?                        01965000
         BO    CMDVER            YES, BRANCH                            01966000
         SPACE 2                                                        01967000
         CLC   ##SUBCOM(8),$PAT  PATTERN SUBCOMMAND?                    01968000
         BNE   CMDCHK2           NO, BRANCH                             01969000
         TM    FLAGSAA,FOPTIONS  ANY OPERAND SPECIFIED?                 01970000
         BO    CMDPARSE          YES, USE THE SPECIFIED DATA            01971000
         CLI   MEMBERP,X'00'     ANY DEFAULT PATTERN YET?               01972000
         BE    CMDPARSE          NO, FORCE A CALL TO PARSE              01973000
         SPACE 1                                                        01974000
         MVC   LMEMBER1(2+8+8+2),MEMBERP+1  RESET DEFAULT PATTERN       01975000
         NI    FLAGSAA,FF-FMEMBER1-FMEMBER2-FMEM#MEM-FMEMRANG           01976000
         OC    FLAGSAA,MEMBERP   RESTORE THE DEFAULT FLAGS              01977000
         B     CMDVER                                                   01978000
         SPACE 2                                                        01979000
CMDCHK2  TM    ##ADRPC#,@G       MEMBER NAME DEFAULT (AND GROUP)?       01980000
         BNO   CMDREQD           NO, CHECK IF OPERANDS REQUIRED         01981000
         TM    FLAGSAA,FOPTIONS  ANY OPERAND SPECIFIED?                 01982000
         BO    CMDPARSE          YES, USE THE SPECIFIED DATA            01983000
         SPACE 2                                                        01984000
         TM    ##ADRPC#,@S       NON-PARTITIONED DATA SET?              01985000
         BO    CMDVER            YES, BRANCH                            01986000
         CLI   MEMBERD,X'00'     ANY DEFAULT MEMBER NAME YET?           01987000
         BE    CMDPARSE          NO, FORCE A CALL TO PARSE              01988000
         SPACE 1                                                        01989000
         MVC   LMEMBER1(2+8+8+2),MEMBERD+1  RESET DEFAULT MEMBER NAMES  01990000
         NI    FLAGSAA,FF-FMEMBER1-FMEMBER2-FMEM#MEM-FMEMRANG           01991000
         OC    FLAGSAA,MEMBERD   RESTORE THE DEFAULT FLAGS              01992000
         MVC   PMEMCURR(4),PMEMMIN  RESET THE FIRST MEMBER POINTER      01993000
         TM    FLAGSAA,FMEM#MEM  MEMBER GROUP REQUESTED?                01994000
         BO    CMDVER            YES, BRANCH                            01995000
         SPACE 1                                                        01996000
         TM    ##ADRPA#,$D              DEFAULT MESSAGE SUBCOMMAND?     01997000
         BO    CMDVER                   NO, BRANCH (NO DEFAULT MESSAGE) 01998000
         SPACE 1                                                        01999000
         MVC   INSERT#1(8),MEMBER1                                      02000000
         TSMSG L002$1            TELL THE USER WHO IS BEING PROCESSED   02001000
         B     CMDVER            CALL THE COMMAND                       02002000
         SPACE 3                                                        02003000
CMDREQD  TM    ##ADRPC#,@R       OPERANDS REQUIRED?                     02004000
         BO    CMDPARSE          YES, BRANCH                            02005000
         TM    FLAGSAA,FOPTIONS  ANY OPERANDS SPECIFIED?                02006000
         BZ    CMDVER            NO, BRANCH                             02007000
         SPACE 2                                                        02008000
CMDPARSE OI    FLAGSAA,FOPTIONS  NOW THERE ARE OPERANDS                 02009000
         L     R1,ADDRCBUF       START OF SUBCOMMAND BUFFER             02010000
         MVC   ##HELOFF(2),2(R1) SAVE THE OFFSET                        02011000
         L     R15,=A(PARSE)     PARSE ADDRESS                          02012000
         BALR  R14,R15           GET THE COMMAND OPERANDS               02013000
         B     NEWCMD            INVALID PARSE, IGNORE                  02014000
         L     R1,ADDRCBUF       START OF SUBCOMMAND BUFFER             02015000
         MVC   2(2,R1),##HELOFF  RESET THE OFFSET                       02016000
         SPACE 3                                                        02017000
CMDVER   ICM   R15,B'1111',=V(VSUBCMD)  VERIFY THE SUBCOMMAND?          02018000
         BZ    CALLCMD                  NO, BRANCH                      02019000
         OI    FLAGSJJ,FSUBCMD          YES, SET A ESTAE FLAG           02020000
         L     R1,ADDRCBUF              COMMAND BUFFER ADDRESS          02021000
         ST    R1,ADDRTEXT              COMMAND ADDRESS                 02022000
         MVC   MSGTEXT1(16),ADDRTEXT    MOVE ARGUMENT LIST              02023000
         LA    R1,##SUBCOM              COMMAND NAME                    02024000
         CLC   ##SUBCOM(8),$ATT         ATTRIB SUBCOMMAND?              02025000
         BNE   CMDVER2                  NO, BRANCH                      02026000
         TM    #OPTOPT,X'F0'            ATTRIBUTE CHANGES?              02027000
         BNO   CMDVER2                  NO, BRANCH                      02028000
         LA    R1,=CL8'ATTRMOD'         YES, CHANGE THE COMMAND NAME    02029000
CMDVER2  CLC   ##SUBCOM(8),$VER         VERIFY SUBCOMMAND?              02030000
         BNE   CMDVER4                  NO, BRANCH                      02031000
         TM    #VERUPDT,2               NOUPDATE?                       02032000
         BO    CMDVER4                  YES, BRANCH                     02033000
         TM    DSORG,DS1DSGPO           PARTITIONED DATA SET?           02034000
         BNO   CMDVER4                  NO, BRANCH                      02035000
         TM    FLAGSAA,FMEMBER1+FMEMBER2  ALL MEMBERS?                  02036000
         BNZ   CMDVER4                    NO, BRANCH                    02037000
         TM    FLAGSAA,FMEM#MEM           MEMBER GROUP?                 02038000
         BO    CMDVER4                    YES, BRANCH                   02039000
         LA    R1,=CL8'VERMOD'            NO, CHANGE THE COMMAND NAME   02040000
         SPACE 1                                                        02041000
CMDVER4  ST    R1,MSGTEXT1+16           FOR VERIFICATION ROUTINE        02042000
         LA    R1,DSNAME                DSNAME                          02043000
         ST    R1,MSGTEXT1+20           FOR VERIFICATION ROUTINE        02044000
         OI    MSGTEXT1+20,X'80'        MARK END OF LIST                02045000
         LA    R1,MSGTEXT1              START OF ARGUMENT LIST          02046000
         BALR  R14,R15                  CALL VERIFICATION ROUTINE       02047000
         NI    FLAGSJJ,FF-FSUBCMD       RESET THE ESTAE FLAG            02048000
         MVC   INSERT#1(8),##SUBCOM     COMMAND NAME                    02049000
         LA    R1,L920$1                ASSUME NOT AUTHORIZED           02050000
         LTR   R15,R15                  CORRECT?                        02051000
         BNZ   MSGNEWXX                 YES, BRANCH                     02052000
         SPACE 2                                                        02053000
         CLC   ##SUBCOM(8),$FIN         FIND SUBCOMMAND?                02054000
         BE    CMDVER6                  YES, BRANCH                     02055000
         CLC   ##SUBCOM(8),$IFX         IF SUBCOMMAND?                  02056000
         BNE   CALLCMD                  NO, BRANCH                      02057000
         SPACE 1                                                        02058000
CMDVER6  L     R15,=V(VSUBCMD)          VERIFY THE SUBCOMMAND           02059000
         ICM   R1,B'1111',#ACTIONT      THEN ACTION?                    02060000
         BZ    CMDVER8                  NO, BRANCH                      02061000
         OI    FLAGSJJ,FSUBCMD          YES, SET A ESTAE FLAG           02062000
         ST    R1,MSGTEXT1+16           FOR VERIFICATION ROUTINE        02063000
         LA    R1,MSGTEXT1              START OF ARGUMENT LIST          02064000
         BALR  R14,R15                  CALL VERIFICATION ROUTINE       02065000
         NI    FLAGSJJ,FF-FSUBCMD       RESET THE ESTAE FLAG            02066000
         ICM   R1,B'1111',#ACTIONT      THEN ACTION                     02067000
         MVC   INSERT#1(8),0(R1)        COMMAND NAME                    02068000
         LA    R1,L920$1                ASSUME NOT AUTHORIZED           02069000
         LTR   R15,R15                  CORRECT?                        02070000
         BNZ   MSGNEWXX                 YES, BRANCH                     02071000
         SPACE 2                                                        02072000
CMDVER8  L     R15,=V(VSUBCMD)          VERIFY THE SUBCOMMAND           02073000
         ICM   R1,B'1111',#ACTIONE      ELSE ACTION?                    02074000
         BZ    CALLCMD                  NO, BRANCH                      02075000
         OI    FLAGSJJ,FSUBCMD          YES, SET A ESTAE FLAG           02076000
         ST    R1,MSGTEXT1+16           FOR VERIFICATION ROUTINE        02077000
         LA    R1,MSGTEXT1              START OF ARGUMENT LIST          02078000
         BALR  R14,R15                  CALL VERIFICATION ROUTINE       02079000
         NI    FLAGSJJ,FF-FSUBCMD       RESET THE ESTAE FLAG            02080000
         ICM   R1,B'1111',#ACTIONE      ELSE ACTION                     02081000
         MVC   INSERT#1(8),0(R1)        COMMAND NAME                    02082000
         LA    R1,L920$1                ASSUME NOT AUTHORIZED           02083000
         LTR   R15,R15                  CORRECT?                        02084000
         BNZ   MSGNEWXX                 YES, BRANCH                     02085000
         TITLE 'P D S  --  PDS SUBCOMMAND BLDL CHECKING        1/15/85' 02086000
CALLCMD  MVC   #SUBHOLD(#LSUB),##SUBCOM   SAVE SUBCOMAND CHANGED DATA   02087000
         TM    ##ADRPC#,@S         NON-PARTITIONED DATA SET?            02088000
         BO    CALLCMD9            YES, BRANCH                          02089000
         TM    FLAGSAA,FMEM#MEM    MEMBER GROUP DESIRED?                02090000
         BO    CALLCMD8            YES, BRANCH                          02091000
         TM    ##ADRPC#,@C         CHANGE DIRECTORY AND NO BLDL?        02092000
         BNO   CALLCMD2            NO, BRANCH                           02093000
         MVC   DIRNAME,MEMBER1     GET MEMBER NAME                      02094000
         NI    FLAGSCC,FF-FBLDLOK  DIRECTORY WILL BE CHANGED            02095000
         SPACE 2                                                        02096000
CALLCMD2 TM    ##ADRPC#,@B         BLDL REQUIRED?                       02097000
         BNO   CALLCMD8            NO, BRANCH                           02098000
***      TM    FLAGSCC,FBLDLOK     BLDL STILL VALID?                    02099000
***      BNO   CALLCMD4            NO, BRANCH                           02100000
***      TM    FLAGSAA,FOPTIONS    ANY MEMBER NAME SPECIFIED?           02101000
***      BO    CALLCMD4            YES, DO A BLDL THEN                  02102000
***      CLC   DIRNAME(8),MEMBER1  STILL THIS MEMBER NAME?              02103000
***      BE    CALLCMD8            YES, NO NEED TO BLDL                 02104000
         SPACE 2                                                        02105000
CALLCMD4 XC    DIRUSER,DIRUSER     CLEAR THE USER FIELDS                02106000
         MVC   DIRNAME,MEMBER1     ORIGINAL MEMBER NAME                 02107000
         NI    FLAGSCC,FF-FBLDLOK  ASSUME MEMBER NOT FOUND              02108000
         SPACE 2                                                        02109000
         BLDL  INDCB,BLDLLIST      LOCATE DIRECTORY ENTRY               02110000
         B     *+4(R15)            PROCESS RETURN CODE                  02111000
         B     CALLCMD6              00 - SUCCESSFUL                    02112000
         B     NOMEMBER              04 - MEMBER NOT FOUND              02113000
         B     IOERROR               08 - I/O ERROR                     02114000
         SPACE 2                                                        02115000
CALLCMD6 OI    FLAGSCC,FBLDLOK     MEMBER FOUND                         02116000
         MVC   DIRFLAG(DIREND-DIRFLAG),DIRFLAG+2 BLDL ADDS THINGS       02117000
         LA    R14,DIRNAME                CURRENT MEMBER NAME ADDRESS   02118000
         ST    R14,DIRPTRS                UPDATE IF NO GROUP            02119000
         SPACE 2                                                        02120000
CALLCMD8 TM    FLAGSAA,FMEM#MEM           MEMBER GROUP TO START?        02121000
         BNO   CALLCMDZ                   NO, BRANCH                    02122000
         NI    FLAGSCC,FF-FBLDLOK         YES, FORCE A BLDL NEXT TIME   02123000
         SPACE 1                                                        02124000
         TM    FLAGSAA,FMEMBER1+FMEMBER2  ANY MEMBER NAMES?             02125000
         BNZ   MEMSINIT                   YES, BRANCH                   02126000
         TM    ##ADRPC#,@I                BROWSE, EDIT OR VERIFY?       02127000
         BNO   MEMSINIT                   NO, BRANCH                    02128000
         SPACE 2                                                        02129000
CALLCMD9 NI    FLAGSAA,FF-FMEM#MEM        TURN OFF MEMBER GROUPS        02130000
         B     CALLCMDZ                   CALL THE SUBCOMMAND           02131000
         TITLE 'P D S  --  PDS SUBCOMMAND MEMBER GROUPS        1/15/85' 02132000
MEMSINIT MVC   #SUBHOLD(#LSUB),##SUBCOM SAVE SUBCOMMAND CHANGED DATA    02133000
         XC    DIRNAME(8),DIRNAME       CLEAR THE MEMBER NAME           02134000
         OI    FLAGSII,FDIRGRP          INPUT FOR MEMBER GROUP          02135000
         TM    FLAGSAA,FMEMRANG         MEMBER RANGE?                   02136000
         BO    DISPLAY                  YES, BRANCH                     02137000
         B     PATTERN                  NO, MEMBER PATTERN              02138000
         SPACE 1                                                        02139000
MEMSGET  MVC   DIRPTRS(12),DIRPTRS2     RESTORE THE DIRPTRS             02140000
         MVC   CURMBB(8),CURDIR         RESTORE THE DIRECTORY ADDRESS   02141000
         OI    FLAGSII,FDIRGRP          INPUT FOR MEMBER GROUP          02142000
         B     DISPLAY2                 GET NEXT MEMBER                 02143000
         SPACE 1                                                        02144000
MEMSNEXT NI    FLAGSII,FF-FDIRGRP       MEMBER GROUP INPUT IS COMPLETE  02145000
         OI    FLAGSBB,FRANPAT          MEMBERS EXIST IN THIS RANGE     02146000
         MVC   DIRPTRS2(12),DIRPTRS     SAVE THE DIRPTRS                02147000
         MVC   CURDIR(8),CURMBB         SAVE THE DIRECTORY ADDRESS      02148000
         MVC   ##SUBCOM(#LSUB),#SUBHOLD RESET CHANGED INFORMATION       02149000
         L     R14,DIRPTRS              START OF CURRENT MEMBER NAME    02150000
         CLC   DIRNAME(8),0(R14)        NAME PROCESSED BEFORE?          02151000
         BNL   MEMSGET                  YES, BRANCH AND IGNORE          02152000
         XC    DIRNAME(74),DIRNAME      CLEAR THE CURRENT ENTRY         02153000
         IC    R15,MEMFLAG              DIRECTORY FLAG BYTE             02154000
         N     R15,=XL4'0000001F'       NUMBER OF HALFWORDS             02155000
         LA    R15,11(R15,R15)          MACHINE LENGTH OF ENTRY         02156000
         MVC   DIRNAME(*-*),0(R14)      <<EXECUTED>>                    02157000
         EX    R15,*-6                  MOVE IN THE CURRENT ENTRY       02158000
         SPACE 1                                                        02159000
         MVC   MSGTEXT1,MSGMEMQ         SUBCOMMAND AND MEMBER MESSAGE   02160000
         MVC   MSGTEXT1+7(8),##SUBCOM                                   02161000
         MVC   MSGTEXT1+7+8+1(8),DIRNAME                                02162000
         TR    MSGTEXT1+7+8+1(8),TRLINE                                 02163000
         TM    ##ADRPC#,@Q              HEADER DELAYED SUBCOMMAND?      02164000
         BNO   MEMSMSG                  NO, BRANCH                      02165000
         SPACE 1                                                        02166000
MEMSKIP  MVC   FINDMEMQ(38),MSGTEXT1    SAVE FOR THEN/ELSE ACTION       02167000
         OI    FLAGSAA,FINDMSG          SUBCOMMAND IS AVAILABLE         02168000
         B     CALLCMDZ                 CALL THE SUBCOMMAND             02169000
         SPACE 2                                                        02170000
MEMSMSG  MESSAGE MSGBLANK                                               02171000
         MESSAGE MSGTEXT1                                               02172000
         SPACE 3                                                        02173000
CALLCMDZ L     R8,##ADRCMD              SUBCOMMAND ROUTINE START        02174000
         LA    R2,NEWCMD                SUBCOMMAND TERMINATION ADDRESS  02175000
         BR    R8                       LINK TO THE SUBCOMMAND          02176000
         TITLE 'P D S  --  PDS DISPLAY, MEMBERS, PATTERN       1/15/85' 02177000
*********************************************************************** 02178000
***      DISPLAY SUBCOMMAND                                         *** 02179000
***                                                                 *** 02180000
***      MEMBERS SUBCOMMAND    ADDED BY BRUCE LELAND -- JULY, 1982  *** 02181000
***                                                                 *** 02182000
***      PATTERN SUBCOMMAND    ADDED BY BRUCE LELAND -- JAN, 1980   *** 02183000
*********************************************************************** 02184000
*                                                                       02185000
         SPACE 1                                                        02186000
DISPLAY  OI    FLAGSAA,FMEMRANG          **  MEMBER RANGE SELECTION     02187000
         TM    FLAGSAA,FMEMBER1+FMEMBER2 DISPLAY RANGE?                 02188000
         BNO   DISPLAYA                  NO, NO RANGE CHECK             02189000
         LH    R14,LMEMBER1                                             02190000
         CH    R14,LMEMBER2              DETERMINE MIN NAME LENGTH      02191000
         BNH   *+8                                                      02192000
         LH    R14,LMEMBER2                                             02193000
         CLC   MEMBER1(*-*),MEMBER2      <<EXECUTED>>                   02194000
         EX    R14,*-6                   VALID DISPLAY RANGE?           02195000
         LA    R1,L700                   INVALID RANGE MESSAGE          02196000
         BH    MSGNEWXX                  YES, BRANCH                    02197000
         SPACE 1                                                        02198000
PATTERN  DS    0H                        **  MEMBER PATTERN SELECTION   02199000
         SPACE 1                                                        02200000
MEMBERS  DS    0H                        **  MEMBER GROUP DISPLAY       02201000
         SPACE 1                                                        02202000
DISPLAYA LA    R1,80                     ASSUME AN ACTIVE MODE          02203000
         AIF ('&CISP' EQ 'NO SPF').MA00200                         @D01
         TM    SPFLAG0,SPFDON            ISPMODE ACTIVE?                02204000
         BO    DISPLAY0                  YES, BRANCH                    02205000
.MA00200 ANOP  ,                                                   @D01
         TM    CONTOPTN,1                ANY LOG RECORDING?             02206000
         BO    DISPLAY0                  YES, BRANCH                    02207000
         GTSIZE
         CH    R1,=H'120'                120 OR LESS BYTES?             02209000
         BL    *+8                       YES, BRANCH                    02210000
         LH    R1,=H'120'                NO, USE 120 BYTES              02211000
DISPLAY0 ST    R1,LINESIZE               CHARACTERS/LINE                02212000
         CLC   $MEM(8),##SUBCOM          MEMBERS SUBCOMMAND?            02213000
         BNE   *+8                       NO, BRANCH                     02214000
         NI    FLAGSAA,FF-FMEM#MEM       YES, TURN OFF ANY MEMBER GROUP 02215000
         NI    FLAGSBB,FF-FEXIST-FLINESET-FRANPAT                       02216000
         MVI   STARTTR+2,X'01'          TTR=000001 (START OF DIRECTORY) 02217000
         SPACE 1                                                        02218000
DISPLAY1 L     R4,LINESIZE               GET TERMINAL LINE SIZE         02219000
         LA    R4,MSGTEXT1+3-11(R4)      END OF LINE ADDRESS            02220000
         LA    R5,MSGTEXT1+4             START OF LINE                  02221000
         MVC   MSGTEXT1(136),MSGBL132    CLEAR THE DATA LINE            02222000
         SPACE 1                                                        02223000
DISPLAY2 BAL   R14,READDIR               GET NEXT DIRECTORY ENTRY       02224000
         B     DISPLAY6                  LAST MEMBER IN DIRECTORY       02225000
         SPACE 1                                                        02226000
         OI    FLAGSBB,FEXIST            MEMBER EXISTS FLAG             02227000
         TM    FLAGSAA,FMEMRANG          MEMBER NAME RANGE?             02228000
         BNO   PATTERN1                  NO, BRANCH                     02229000
         TM    FLAGSAA,FMEMBER1          START ENTRY SPECIFIED?         02230000
         BZ    DISPLAY3                  NO, BRANCH                     02231000
         LH    R15,LMEMBER1              LENGTH-1 OF MEMBER NAME        02232000
         CLC   MEMBER1(*-*),MEMNAME      <<EXECUTED>>                   02233000
         EX    R15,*-6                                                  02234000
         BH    DISPLAY2                  NOT WANTED, GET NEXT           02235000
         XI    FLAGSAA,FMEMBER1                                         02236000
         SPACE 2                                                        02237000
         AIF   ('&CONDRNG' EQ 'N').NRNG                                 02238000
         TM    FLAGSAA,FMEMBER2          LAST ENTRY SPECIFIED?          02239000
         BO    DISPLAY3                  YES, BRANCH                    02240000
         CLC   $DIS(8),##SUBCOM          DISPLAY SUBCOMMAND? ***TEST    02241000
         BNE   DISPLAY3                  NO, BRANCH          ***TEST    02242000
         STH   R15,LMEMBER2              LENGTH-1 OF SECOND NAME        02243000
         MVC   MEMBER2(*-*),MEMBER1      <<EXECUTED>>                   02244000
         EX    R15,*-6                   DUPLICATE FIRST MEMBER NAME    02245000
         OI    FLAGSAA,FMEMBER2          SET SECOND ENTRY HERE          02246000
         SPACE 2                                                        02247000
.NRNG    ANOP                                                           02248000
DISPLAY3 TM    FLAGSAA,FMEMBER2          LAST ENTRY SPECIFIED?          02249000
         BZ    DISPLAY4                  NO, BRANCH                     02250000
         SPACE 1                                                        02251000
         LH    R15,LMEMBER2                                             02252000
         CLC   MEMBER2(*-*),MEMNAME      <<EXECUTED>>                   02253000
         EX    R15,*-6                   PAST END?                      02254000
         BL    DISPLAY6                  YES, END OF DISPLAY            02255000
         B     DISPLAY4                  NO, DISPLAY THIS MEMBER NAME   02256000
         SPACE 1                                                        02257000
PATTERN1 LH    R15,LMEMBER1              LENGTH-1 OF THE PATTERN        02258000
         LA    R1,8                      MAXIMUM PATTERN LENGTH         02259000
         SR    R1,R15                    NUMBER OF COMPARE LOOPS        02260000
         LA    R14,MEMNAME               START SCAN POSITION            02261000
         CLC   0(*-*,R14),MEMBER1        <<EXECUTED>>                   02262000
PATTERN2 EX    R15,*-6                   PATTERN IN THIS MEMBER NAME?   02263000
         BE    PATTERN3                  YES, CHECK FOR ANOTHER PATTERN 02264000
         LA    R14,1(,R14)               MAYBE, CHECK AT THE NEXT BYTE  02265000
         BCT   R1,PATTERN2               CHECK ALL POSSIBLE POSITIONS   02266000
         B     DISPLAY2                  NO, IGNORE THIS ENTRY          02267000
         SPACE 1                                                        02268000
PATTERN3 TM    FLAGSAA,FMEMBER2          A SECOND PATTERN SPECIFIED?    02269000
         BZ    DISPLAY4                  NO, DISPLAY THE MEMBER NAME    02270000
         LH    R15,LMEMBER2              LENGTH-1 OF THE PATTERN        02271000
         LA    R1,8                      MAXIMUM PATTERN LENGTH         02272000
         SR    R1,R15                    NUMBER OF COMPARE LOOPS        02273000
         LA    R14,MEMNAME               START SCAN POSITION            02274000
         CLC   0(*-*,R14),MEMBER2        <<EXECUTED>>                   02275000
PATTERN4 EX    R15,*-6                   PATTERN IN THIS MEMBER NAME?   02276000
         BE    DISPLAY4                  YES, DISPLAY THE MEMBER NAME   02277000
         LA    R14,1(,R14)               MAYBE, CHECK AT THE NEXT BYTE  02278000
         BCT   R1,PATTERN4               CHECK ALL POSSIBLE POSITIONS   02279000
         B     DISPLAY2                  NO, IGNORE THIS ENTRY          02280000
         SPACE 1                                                        02281000
DISPLAYT TRT   MEMNAME(*-*),TRTMEM       <<EXECUTED>>                   02282000
DISPLAY4 TM    FLAGSAA,FMEM#MEM          MEMBER NAME GROUP DESIRED?     02283000
         BO    MEMSNEXT                  YES, FOUND A MEMBER            02284000
         LA    R1,7                      MEMBER NAME MACHINE LENGTH     02285000
         LA    R14,MEMNAME+8             END OF MEMBER NAME +1          02286000
DISPLAYB BCTR  R14,0                     SCAN                           02287000
         CLI   0(R14),X'40'                  BACKWARDS                  02288000
         BNE   *+8                                    FOR A             02289000
         BCT   R1,DISPLAYB                                 NON-BLANK    02290000
         CLI   MEMNAME,C'0'              FIRST DIGIT NUMERIC?           02291000
         BNL   *+12                      YES, FORCE A HEX DISPLAY       02292000
         EX    R1,DISPLAYT               ANY INVALID OR UNPRINTABLE?    02293000
         BZ    DISPLAY8                  NO, BRANCH                     02294000
         TM    FLAGSBB,FLINESET          LINE IN PROGRESS?              02295000
         BZ    DISPLAY9                  NO, SKIP THE PUTLINE           02296000
         MESSAGE MSGTEXT1                                               02297000
         NI    FLAGSBB,FF-FLINESET                                      02298000
         SPACE 2                                                        02299000
DISPLAY9 MVC   MSGTEXT1(136),MSGBL132    CLEAR THE DATA LINE            02300000
         UNPK  MSGTEXT1+4(9),MEMNAME(5)  FIRST HALF OF NAME             02301000
         UNPK  MSGTEXT1+12(9),MEMNAME+4(5) SECOND HALF OF NAME          02302000
         TR    MSGTEXT1+4(16),TRTABLE    FINISH TRANSLATION             02303000
         MVC   MSGTEXT1+20(8),BLANKS     CLEAN UP GARBAGE               02304000
         TM    MEMFLAG,X'80'             ALIAS?                         02305000
         BZ    *+10                      NO, SKIP -A                    02306000
         MVC   MSGTEXT1+20(2),=C'-A'     YES, SET -A                    02307000
         MVI   MSGTEXT1+24,C'*'                                         02308000
         MVC   MSGTEXT1+25(8),MEMNAME    MEMBER NAME FROM DIRECTORY     02309000
         TR    MSGTEXT1+25(8),TRLINE     TRANSLATE TO PRINTABLE         02310000
         MVI   MSGTEXT1+33,C'*'                                         02311000
         OI    FLAGSBB,FLINESET+FRANPAT  OUTPUT AND MEMBERS EXIST NOW   02312000
         B     DISPLAY5                                                 02313000
         SPACE 1                                                        02314000
DISPLAY8 MVC   0(8,R5),MEMNAME                                          02315000
         TM    MEMFLAG,X'80'             ALIAS?                         02316000
         BZ    DISPLAY7                  NO, BRANCH                     02317000
         MVC   8(2,R5),=C'-A'                                           02318000
DISPLAY7 OI    FLAGSBB,FLINESET+FRANPAT                                 02319000
         LA    R5,10+2(R5)                                              02320000
         CR    R5,R4                     LINE FULL?                     02321000
         BL    DISPLAY2                  NO, CONTINUE                   02322000
         SPACE 1                                                        02323000
DISPLAY5 MESSAGE MSGTEXT1                                               02324000
         NI    FLAGSBB,FF-FLINESET                                      02325000
         B     DISPLAY1                  RETURN                         02326000
         SPACE 2                                                        02327000
DISPLAY6 TM    FLAGSBB,FLINESET          OUTPUT LINE IN PROGRESS?       02328000
         BNO   DISPLAYZ                  NO, BRANCH                     02329000
         LA    R1,MSGTEXT1                                              02330000
         TM    FLAGSAA,FMEM#MEM          MEMBER GROUP IN PROGRESS?      02331000
         BNO   MSGNEW                    NO, BRANCH                     02332000
         SPACE 2                                                        02333000
DISPLAYZ NI    FLAGSAA,FF-FMEM#MEM       TERMINATE ANY MEMBER GROUP     02334000
         TM    FLAGSBB,FRANPAT           MEMBER IN RANGE?               02335000
         BO    NEWCMD                    YES, BRANCH                    02336000
***      CLC   $MML(8),##SUBCOM          MEMLIST SUBCOMMAND?            02337000
***      BNE   *+8                       NO, BRANCH                     02338000
***      NI    FLAGSBB,FF-FONESHOT       YES, MARK TO CONTINUE          02339000
         TM    FLAGSBB,FEXIST            NO, BUT ANY IN DIRECTORY?      02340000
         LA    R1,L400                                                  02341000
         BZ    MSGNEW                    NO, ** EMPTY DIRECTORY **      02342000
         LA    R1,L401                   ASSUME NONE IN RANGE           02343000
         TM    FLAGSAA,FMEMRANG MEMBER   CORRECT?                       02344000
         BO    MSGNEW                    YES, BRANCH                    02345000
         LA    R1,L402                   NO, NONE MATCHING PATTERN      02346000
         B     MSGNEW                                                   02347000
         TITLE 'P D S  --  PDS EXEC                            1/15/85' 02348000
*********************************************************************** 02349000
***      EXEC SUBCOMMAND       ADDED BY BRUCE LELAND -- JAN, 1980   *** 02350000
*********************************************************************** 02351000
*                                                                       02352000
         SPACE 2                                                        02353000
EXECPER  L     R2,ADDRCBUF          EXEC (%NAME -- IMPLIED FORM)        02354000
         XC    2(2,R2),2(R2)        CLEAR OFFSET                        02355000
         L     R1,ADDRECT                  ECT ADDRESS                  02356000
         OI    ECTSWS-ECT(R1),ECTNOPD      ASSUME NO OPERAND            02357000
         TM    CSOAFLG-CSOA(R15),CSOAVWP   ANY OPERAND?                 02358000
         BNO   *+8                         NO, BRANCH                   02359000
         NI    ECTSWS-ECT(R1),FF-ECTNOPD   YES, ZAP THE NO OPERAND FLAG 02360000
         SPACE 1                                                        02361000
EXEC     L     R2,ADDRCBUF          EXEC (EXEC NAME -- EXPLICIT FORM)   02362000
         AIF ('&CISP' EQ 'NO SPF').MA00220                         @D01
         LA    R1,L732              ASSUME ISPMODE IS ACTIVE            02363000
         TM    SPFLAG0,SPFDON       CORRECT?                            02364000
         BO    MSGNEWXX             YES, ERROR                          02365000
.MA00220 ANOP  ,                                                   @D01
         L     R1,ADDRCPPL                                              02366000
         ST    R2,0(,R1)                                                02367000
         SPACE 1                                                        02368000
         LA    R3,$EXE+20           TSO EXEC CLIST PROCESSOR            02369000
         BAL   R2,ATTACH            GO ATTACH IT                        02370000
         B     NEWSTAX                                                  02371000
         TITLE 'P D S  --  PDS ALIAS                           1/15/85' 02372000
*********************************************************************** 02373000
***      ALIAS SUBCOMMAND                                           *** 02374000
*********************************************************************** 02375000
*                                                                       02376000
         SPACE 1                                                        02377000
ALIAS    CSECT                                                          02378000
         USING *,R8                                                     02379000
         AIF ('&CISP' EQ 'NO SPF').MA00240                         @D01
         TM    SPFLAG2,SPFPOST            LINE COMMAND?                 02380000
         BNO   ALIAS0                     NO, BRANCH                    02381000
         LA    R1,FIRST4K                 GET ADDRESSABILITY            02382000
         MVC   MEMLNMSV-FIRST4K(8,R1),MEMBER2                           02383000
         B     ALIAS1                     NO, BRANCH                    02384000
         SPACE 2                                                        02385000
.MA00240 ANOP  ,                                                   @D01
ALIAS0   MVC   MEMBERD+1(2),LMEMBER2      CHANGE DEFAULT MEMBER LENGTH  02386000
         MVC   MEMBERD+1+2(8),MEMBER2     CHANGE DEFAULT MEMBER NAME    02387000
         MVI   MEMBERD,FMEMBER1           ONLY ONE MEMBER NAME NOW      02388000
         NI    FLAGSEE,FF-FMEMLIST        NO MEMBER LIST                02389000
         BAL   R14,DEFGROUP                    ADD DEFAULT GROUP        02390000
         SPACE 2                                                        02391000
ALIAS1   MVC   DIRNAME,MEMBER2            SET ALIAS NAME                02392000
         MVI   ENTRYPT,C'?'               ENTRY POINT NOT KNOWN YET     02393000
         TM    DIRFLAG,X'80'              MODULE A CURRENT ALIAS?       02394000
         BZ    ALIAS2                     NO, BRANCH                    02395000
         TM    FLAGSCC,RECFMU             LOAD MODULE?                  02396000
         BO    ALIAS3                     YES, BRANCH                   02397000
         B     ALIAS4                     NO, BRANCH                    02398000
         SPACE 1                                                        02399000
ALIAS2   TM    FLAGSCC,RECFMU             LOAD MODULE?                  02400000
         BZ    ALIAS4                     NO, BRANCH                    02401000
         SPACE 1                                                        02402000
         TM    DIRATTR2,DIRAOSLE+DIRAPFLG VS LKED & APF DATA PRESENT?   02403000
         BZ    ALIAS2Y                    NO, BRANCH                    02404000
         SPACE 1                                                        02405000
         LA    R2,DIRAPF                  POINT TO APF INFORMATION      02406000
         TM    DIRATTR,ATTRSCTR           SCATTER LOADED?               02407000
         BZ    *+8                        NO, BRANCH                    02408000
         LA    R2,DIRAPF3                 YES, POINT TO APF DATA        02409000
         LA    R4,11(,R2)                 POINT TO ALIAS APF DATA       02410000
         TM    DIRATTR2,DIR2SSI           SSI PRESENT?                  02411000
         BZ    ALIAS2B                    NO, BRANCH                    02412000
         SPACE 1                                                        02413000
         LA    R2,1(,R2)                  ROUND TO HALFWORD             02414000
         N     R2,=F'-2'                  FFFFFFFE MASK                 02415000
         LA    R4,1(,R4)                  ROUND TO HALFWORD             02416000
         N     R4,=F'-2'                  FFFFFFFE MASK                 02417000
         MVC   0(4,R4),0(R2)              MOVE SSI INFORMATION          02418000
         LA    R4,4(,R4)                  MOVE PAST SSI INFORMATION     02419000
         LA    R2,4(,R2)                  POINT TO APF DATA             02420000
         SPACE 1                                                        02421000
ALIAS2B  CLI   0(R2),1                    IS APF LENGTH OK?             02422000
         BE    ALIAS2D                    YES, BRANCH                   02423000
         TSMSG L710                       BAD APF INFORMATION FORMAT    02424000
         LA    R2,ZERO                    SET APF=0                     02425000
         SPACE 1                                                        02426000
ALIAS2D  MVI   0(R4),1                    SET PROPER LENGTH             02427000
         MVC   1(1,R4),1(R2)              MOVE IN APF DATA              02428000
         SPACE 3                                                        02429000
ALIAS2Y  LA    R4,DIREP                   POINT TO START OF ALIAS INFO. 02430000
         LA    R5,(DIREND2-DIRUSER+1)/2   NUMBER OF HALFWORDS           02431000
         TM    DIRATTR,ATTRSCTR           SCATTER LOADED?               02432000
         BNO   ALIAS2Z                    NO, BRANCH                    02433000
         LA    R4,DIREPSC                 POINT TO START OF ALIAS INFO. 02434000
         LA    R5,(DIREND3-DIRUSER+1)/2   NUMBER OF HALFWORDS           02435000
         SPACE 2                                                        02436000
ALIAS2Z  MVC   0(3,R4),DIREPA             MOVE IN MAIN MODULE ENTRY     02437000
         MVC   3(8,R4),MEMBER1            ADD MAIN MODULE NAME          02438000
         TM    DIRATTR2,DIR2SSI           SSI INFORMATION?              02439000
         BNO   *+8                        NO, BRANCH                    02440000
         LA    R5,2(,R5)                  YES, TWO MORE HALFWORDS       02441000
         NI    DIRFLAG,X'E0'              TURN OFF HALFWORD COUNT       02442000
         OI    DIRFLAG,*-*                <<EXECUTED>>                  02443000
         EX    R5,*-4                     MOVE IN NUMBER OF HALFWORDS   02444000
         SPACE 1                                                        02445000
ALIAS3   TM    DIRFLAG,X'80'              ALIAS ENTRY?                  02446000
         BO    ALIAS3S                    YES, BRANCH                   02447000
         NI    DIRATTR3,FF-DIRAA64-DIRAA31                         @D02
         TM    DIRATTR3,DIRAM64           AMODE 64?                @D02
         BNO   *+8                        NO, BRANCH               @D02
         OI    DIRATTR3,DIRAA64           YES, SET THE DIRECTORY   @D02
         TM    DIRATTR3,DIRAM31           AMODE 31?                @D02
         BNO   *+8                        NO, BRANCH               @D02
         OI    DIRATTR3,DIRAA31           YES, SET THE DIRECTORY   @D02
         SPACE 1                                                        02455000
ALIAS3S  L     R15,=A(READESD)            SCAN ESD FOR MEMBER NAME      02456000
         BALR  R14,R15                    MEMBER NAME IN ESD ENTRIES?   02457000
         B     ALIAS4                     NO, PSEUDO ENTRY              02458000
         SPACE 1                                                        02459000
         OI    DIRATTR+1,ATTREP0          ASSUME ENTRY POINT ZERO       02460000
         LTR   R1,R1                      CORRECT?                      02461000
         BZ    *+8                        YES, BRANCH                   02462000
         XI    DIRATTR+1,ATTREP0          NO, INSURE ATTR FLAG OFF      02463000
         STCM  R1,B'0111',DIREPA          SAVE ENTRY ADDRESS            02464000
         TM    DIRATTR,ATTRSCTR           SCATTER LOADED?               02465000
         BNO   *+8                        NO, BRANCH                    02466000
         STCM  R15,B'0011',DIRSCEP        YES, SAVE ESDID OF ENTRY PT.  02467000
         STC   R0,#ALIAESD                SAVE MODE RMODE/AMODE INFO    02468000
         TM    DIRATTR,ATTROVLY           OVERLAY ATTRIBUTES            02469000
         BO    ALIAS4                     YES, BRANCH                   02470000
         NI    DIRATTR3,FF-DIRAA64-DIRAA31                         @D02
         TM    #ALIAESD,AMODE64           AMODE 64?                @D02
         BNO   *+8                        NO, BRANCH               @D02
         OI    DIRATTR3,DIRAA64           YES, SET THE DIRECTORY   @D02
         TM    #ALIAESD,AMODE31           AMODE 31?                @D02
         BNO   *+8                        NO, BRANCH               @D02
         OI    DIRATTR3,DIRAA31           YES, SET THE DIRECTORY   @D02
         SPACE 1                                                   @D02
         TM    DIRATTR3,DIRRMANY          RMODEANY?                @D02
         BNO   ALIAS4                     NO, BRANCH               @D02
         SPACE 1                                                   @D02
         NI    DIRATTR3,FF-DIRAA64                                 @D02
         OI    DIRATTR3,DIRAA31           RESET AS AMODE31         @D02
         SPACE 1                                                        02478000
ALIAS4   OI    DIRFLAG,X'80'              SET ALIAS FLAG                02479000
         BAL   R2,OPENSTOW                OPEN STOW DCB; ENQUEUES       02480000
         B     NEWCMD                     COULD NOT OPEN -- ERROR       02481000
         STOW  STOWDCB,DIRNAME,A          ADD ALIAS TO DIRECTORY        02482000
         SPACE 1                                                        02483000
         B     *+4(R15)                PROCESS RETURN CODE              02484000
         B     ALIAS5                     00 - SUCCESSFUL               02485000
         B     MEMEXIST                   04 - MEMBER ALREADY EXISTS    02486000
         EX    0,*                        08 - SHOULD NOT HAPPEN - ADD  02487000
         B     FULLDIR                    12 - DIRECTORY IS FULL        02488000
         B     IOERROR                    16 - I/O ERROR IN DIRECTORY   02489000
         SPACE 3                                                        02490000
ALIAS5   TSMSG L010                       MSG - ALIAS ASSIGNED          02491000
         TM    FLAGSCC,RECFMU             MUST WE GIVE ENTRY POINT?     02492000
         BZ    NEWCMD                     NO, BRANCH                    02493000
         UNPK  INSERT#1(7),DIREPA(4)                                    02494000
         TR    INSERT#1(6),TRTABLE                                      02495000
         MVC   INSERT#1+6(2),BLANKS                                     02496000
         MVC   INSERT#2(8),ENTRYPT    NAME OF THE ENTRY POINT           02497000
         TR    INSERT#2(8),TRLINE     MAKE PRINTABLE                    02498000
         LA    R1,L102$1              ASSUME NONE FOUND                 02499000
         CLI   ENTRYPT,C'?'           ANY FOUND?                        02500000
         BE    *+8                    NO, BRANCH                        02501000
         LA    R1,L103$2              YES, SHOW ENTRY SYMBOL            02502000
         TSMSG (R1)                                                     02503000
         B     NEWCMD                                                   02504000
         TITLE 'P D S  --  PDS ATTRIB                          1/15/85' 02505000
*********************************************************************** 02506000
***      ATTRIB SUBCOMMAND                                          *** 02507000
*********************************************************************** 02508000
*                                                                       02509000
         SPACE 1                                                        02510000
ATTRIB   CSECT                                                          02511000
         USING *,R8                                                     02512000
         LA    R1,L530             ASSUME A NON-PARTITIONED DATA SET    02513000
         TM    DSORG,DS1DSGPO      CORRECT?                             02514000
         BZ    MSGNEW              YES, BRANCH                          02515000
         SPACE 1                                                        02516000
         TM    FLAGSCC,RECFMU      LOAD MODULE LIBRARY?                 02517000
         BO    ATTR020             YES, BRANCH                          02518000
         SPACE 1                                                        02519000
         MVC   INSERT#1(72),SPFSTATH                                    02520000
         MVI   MTHIGHL,72                                               02521000
         TM    ##ADRCM#+#LSUB,FATTRHDR  HEADER WRITTEN YET?             02522000
         BO    ATTR000                  YES, BRANCH                     02523000
         TSMSG L230$1                                                   02524000
         OI    ##ADRCM#+#LSUB,FATTRHDR  MARK FOR NEXT CALL              02525000
         SPACE 1                                                        02526000
ATTR000  MVC   INSERT#1(72),MSGBL132+4                                  02527000
         CLI   #SSIOPT,0               ANY SSI CHANGE?                  02528000
         BE    ATTR006                 NO, BRANCH                       02529000
         CLI   #SSIOPT,1               SSI(HEXDATA)?                    02530000
         BE    ATTR002                 YES, BRANCH                      02531000
         NI    DIRFLAG,FF-X'1F'        TURN OFF SSI DATA                02532000
         XC    DIRSTART(4),DIRSTART    CLEAR THE SSI FIELD              02533000
         B     ATTR006                                                  02534000
         SPACE 1                                                        02535000
ATTR002  MVC   DIRSTART(4),#SSITEXT    ADD THE CURRENT SSI DATA         02536000
         NI    DIRFLAG,FF-X'1F'        TURNS OFF ANY HALFWORDS          02537000
         OI    DIRFLAG,X'02'           ADDS IN TWO HALFWORDS            02538000
         SPACE 1                                                        02539000
ATTR006  MVC   INSERT#1+1(8),DIRNAME                                    02540000
         TM    DIRFLAG,X'80'           ALIAS MEMBER?                    02541000
         BNO   *+10                    NO, BRANCH                       02542000
         MVC   INSERT#1+1+8(2),=C'-A'  YES, ADD A FLAG                  02543000
         LA    R2,DIRUSER          LOAD START OF USER AREA (FOR SSI)    02544000
         TM    DIRFLAG,X'0F'       SPF STATISTICS PRESENT?              02545000
         BNO   ATTR010             NO, BRANCH                           02546000
         OC    DIRSPFZ(3),DIRSPFZ  RESERVED AND 00 OF 00YYDDDF ZEROS?   02547000
         BNZ   ATTR010             NO, BRANCH                           02548000
         CLI   DIRSPFCD,0          00 OF OTHER 00YYDDDF ZERO?           02549000
         BNZ   ATTR010             NO, BRANCH                           02550000
         SPACE 1                                                        02551000
         LA    R2,INSERT#1-7                                            02552000
         SR    R1,R1                                                    02553000
         IC    R1,DIRSPFR          REVISION NUMBER FIRST                02554000
         CVD   R1,DOUBLE                                                02555000
         MVC   21(4,R2),=X'40212020'                                    02556000
         ED    21(4,R2),DOUBLE+6                                        02557000
         MVI   22(R2),C'.'                                              02558000
         IC    R1,DIRSPFV          VERSION NUMBER                       02559000
         CVD   R1,DOUBLE                                                02560000
         MVC   18(4,R2),=X'40212020'                                    02561000
         ED    18(4,R2),DOUBLE+6                                        02562000
         LA    R1,DIRSPFCR+1           POINT TO YYDDDF                  02563000
         LA    R15,FULLWORD+1                                           02564000
         BAL   R14,CONVDATE            CONVERT TO MMDDYY FORMAT         02565000
         MVC   FULLWORD(1),FULLWORD+3  CONVERT TO YYMMDD                02566000
         MVC   26(L'DATEMASK,R2),DATEMASK                               02567000
         ED    26(L'DATEMASK,R2),FULLWORD                               02568000
         LA    R1,DIRSPFCD+1           POINT TO YYDDDF                  02569000
         LA    R15,FULLWORD+1                                           02570000
         BAL   R14,CONVDATE            CONVERT TO MMDDYY FORMAT         02571000
         MVC   FULLWORD(1),FULLWORD+3  CONVERT TO YYMMDD                02572000
         MVC   36(L'DATEMASK,R2),DATEMASK                               02573000
         ED    36(L'DATEMASK,R2),FULLWORD                               02574000
         MVC   45(6,R2),=X'4021207A2020'                                02575000
         ED    45(6,R2),DIRSPFCT       TIME OF LAST CHANGE              02576000
         LH    R1,DIRSPFSI                                              02577000
         CVD   R1,DOUBLE                                                02578000
         MVC   51(6,R2),=X'402020202120'                                02579000
         ED    51(6,R2),DOUBLE+5                                        02580000
         SPACE 1                                                        02581000
         LH    R1,DIRSPFIN                                              02582000
         CVD   R1,DOUBLE                                                02583000
         MVC   57(6,R2),=X'402020202120'                                02584000
         ED    57(6,R2),DOUBLE+5                                        02585000
         LH    R1,DIRSPFMD                                              02586000
         CVD   R1,DOUBLE                                                02587000
         MVC   63(6,R2),=X'402020202120'                                02588000
         ED    63(6,R2),DOUBLE+5                                        02589000
         MVC   71(8,R2),DIRSPFID                                        02590000
         B     ATTR012                 NO SSI FOR SPF-SAVED MEMBERS     02591000
         SPACE 1                                                        02592000
ATTR010  CLC   ZERO,0(R2)              ZERO?                            02593000
         BE    ATTR012                 YES, NO SSI                      02594000
         CLC   =F'-1',0(R2)            FFFFFFFF?                        02595000
         BE    ATTR012                 YES, NO SSI                      02596000
         SPACE 1                                                        02597000
         MVC   INSERT#1+2+8+3(4),=C'SSI:'                               02598000
         UNPK  INSERT#1+2+8+3+5(9),0(5,R2)                              02599000
         TR    INSERT#1+2+8+3+5(8),TRTABLE                              02600000
         MVI   INSERT#1+2+8+3+5+8,X'40'                                 02601000
         SPACE 1                                                        02602000
ATTR012  TSMSG L230$1                  OUTPUT STATISTICS                02603000
         MVI   MTHIGHL,8               RESET THE INSERT LENGTH          02604000
         CLI   #OPTOPT,FF              ANY ILLEGAL CHANGES?             02605000
         BNE   ATTR014                 NO, BRANCH                       02606000
         TSMSG L701                    NOT A LOAD MODULE                02607000
ATTR014  CLI   #OPTOPT,X'F0'           ANY SSI CHANGE?                  02608000
         BE    ATTR240                 YES, BRANCH                      02609000
         B     ATTR600                 CHECK FOR ALIAS                  02610000
         SPACE 3                                                        02611000
ATTR020  TM    FLAGSAA,FHEAD           BLANK SEPARATOR WRITTEN YET?     02612000
         BNO   ATTR022                 NO, BRANCH                       02613000
         MESSAGE MSGBLANK              NOW SEPARATORS CAN BE WRITTEN    02614000
         SPACE 1                                                        02615000
ATTR022  OI    FLAGSAA,FHEAD                                            02616000
         MVI   RLDCOUNT,X'FF'          ASSUME NO RLD/CONTROL DATA       02617000
         MVI   LKEDDATE,X'FF'          ASSUME NO LKED DATE              02618000
         CLI   #RLDERR,X'01'           "RLDFIX" OPERAND?                02619000
         BE    ATTR024                 YES, BRANCH                      02620000
         CLI   #LKEDOPT,X'02'          "NOLKEDDATE"?                    02621000
         BE    ATTR030                 YES, BRANCH                      02622000
         CLI   #LKEDOPT,X'01'          "LKEDDATE" DESIRED?              02623000
         BE    ATTR024                 YES, BRANCH                      02624000
         TM    FLAGSGG,FLKEDCON        NO LKEDDATE DEFAULT?             02625000
         BO    ATTR030                 YES, BRANCH                      02626000
ATTR024  L     R15,=A(READIDR)         FIRST RLD COUNT, LKED DATA       02627000
         BALR  R14,R15                 IDR DATA AVAILABLE?              02628000
         MVI   LKEDDATE,X'FF'          NO, ERROR                        02629000
         SPACE 1                                                        02630000
ATTR030  TM    #OPTOPT,X'F0'           ANY CHANGED ATTRIBUTES?          02631000
         BNO   ATTR250                 NO, BRANCH                       02632000
         SPACE 1                                                        02633000
         CLI   #RLDERR,X'01'           "RLDFIX"?                        02634000
         BNE   ATTR038                 NO, BRANCH                       02635000
         TM    DIRATTR2,DIRAOSLE       OS/VS LINKAGE-EDITOR?            02636000
         BNO   ATTR034                 NO, BRANCH                       02637000
         CLI   RLDCOUNT,X'FF'          ANY RLD/CONTROL DATA FOUND?      02638000
         BE    ATTR034                 NO, BRANCH                       02639000
         MVC   DIRATTR4(1),RLDCOUNT    MODIFY THE DIRECTORY ENTRY       02640000
         B     ATTR038                                                  02641000
ATTR034  TSMSG L723                    NO CHANGE IS POSSIBLE            02642000
         SPACE 2                                                        02643000
ATTR038  CLI   #AUTHOPT,X'01'          CHANGE APF PROCESSING?           02644000
         BL    ATTR060                 NO, BRANCH                       02645000
         BE    ATTR040                 YES, BRANCH                      02646000
         TM    DIRATTR2,DIRAOSLE+DIRAPFLG  NEED CHANGE APF INFORMATION? 02647000
         BNO   ATTR060                     NO, BRANCH                   02648000
         SPACE 1                                                        02649000
ATTR040  TM    DIRATTR2,DIRAOSLE+DIRAPFLG  CAN CHANGE APF INFORMATION?  02650000
         BNO   ATTR050                     NO, BRANCH                   02651000
         LA    R2,DIRAPF                   YES, POINT TO APF DATA       02652000
         TM    DIRATTR,ATTRSCTR        SCATTER LOAD?                    02653000
         BNO   *+8                     NO, BRANCH                       02654000
         LA    R2,8(,R2)               SCATTER SIZE                     02655000
         TM    DIRFLAG,X'80'           ALIAS?                           02656000
         BO    ATTR044                 YES, BRANCH                      02657000
         CLI   8(R2),0                 CONVERTED ALIAS ENTRY?           02658000
         BE    *+8                     NO, BRANCH                       02659000
ATTR044  LA    R2,11(,R2)              ADD ALIAS LENGTH                 02660000
         TM    DIRATTR2,DIR2SSI        SSI?                             02661000
         BNO   *+12                    NO, BRANCH                       02662000
         LA    R2,5(,R2)               ADD 4 AND ROUND TO HALFWORD      02663000
         N     R2,=F'-2'                                                02664000
         CLI   0(R2),1                 LENGTH RIGHT?                    02665000
         BNE   ATTR050                 NO, BRANCH                       02666000
         MVI   1(R2),1                 ASSUME TURN AUTHORIZATION ON     02667000
         CLI   #AUTHOPT,X'01'          CORRECT?                         02668000
         BE    ATTR060                 YES, BRANCH                      02669000
         MVI   1(R2),0                 NO, TURN OFF                     02670000
         B     ATTR060                                                  02671000
         SPACE 3                                                        02672000
ATTR050  TSMSG L722                        INVALID APF DATA LENGTH      02673000
         SPACE 2                                                        02674000
ATTR060  CLI   #PAGEOPT,X'01'              CHANGE PAGE ALIGNMENT?       02675000
         BL    ATTR100                     NO, BRANCH                   02676000
         BE    ATTR070                     YES, BRANCH                  02677000
         TM    DIRATTR2,DIRAOSLE+DIRAPFLG  NEED CHANGE PAGE INFO?       02678000
         BNO   ATTR100                     NO, BRANCH                   02679000
         SPACE 1                                                        02680000
ATTR070  TM    DIRATTR2,DIRAOSLE+DIRAPFLG  CAN CHANGE PAGE INFORMATION? 02681000
         BNO   ATTR080                     NO, BRANCH                   02682000
         OI    DIRATTR2,DIR2PAGA           ASSUME TURN ON PAGE BOUNDARY 02683000
         CLI   #PAGEOPT,X'01'              CORRECT?                     02684000
         BE    ATTR100                     YES, BRANCH                  02685000
         NI    DIRATTR2,FF-DIR2PAGA        NO, TURN OFF PAGE BOUNDARY   02686000
         B     ATTR100                                                  02687000
         SPACE 1                                                        02688000
ATTR080  TSMSG L726                    PAGE ALIGNMENT CANNOT BE CHANGED 02689000
         SPACE 2                                                        02690000
ATTR100  CLI   #RMODE,1                    ANY RMODE CHANGE?            02691000
         BL    ATTR120                     NO, BRANCH                   02692000
         BH    ATTR110                     YES, BRANCH                  02693000
         TM    DIRATTR2,DIRAOSLE           CAN CHANGE RMODE?            02694000
         BNO   ATTR120                     NO, BRANCH                   02695000
         SPACE 1                                                        02696000
ATTR110  LA    R1,L724                     NOT MVS LKED MESSAGE         02697000
         TM    DIRATTR2,DIRAOSLE           CAN CHANGE RMODE?            02698000
         BNO   ATTR150                     NO, BRANCH                   02699000
         NI    DIRATTR3,FF-DIRRMANY        SET RMODE=24                 02700000
         CLI   #RMODE,1                    CORRECT?                     02701000
         BE    ATTR120                     YES, BRANCH                  02702000
         OI    DIRATTR3,DIRRMANY           NO, TURN ON RMODE ANY        02703000
         SPACE 2                                                        02704000
ATTR120  CLI   #AMODE,1                    ANY AMODE CHANGE?            02705000
         BL    ATTR160                     NO, BRANCH                   02706000
         BH    ATTR130                     YES, BRANCH                  02707000
         TM    DIRATTR2,DIRAOSLE           CAN CHANGE AMODE?            02708000
         BNO   ATTR160                     NO, BRANCH                   02709000
         SPACE 1                                                        02710000
ATTR130  LA    R1,L724                     NOT MVS LKED MESSAGE         02711000
         TM    DIRATTR2,DIRAOSLE           CAN CHANGE AMODE?            02712000
         BNO   ATTR150                     NO, BRANCH                   02713000
         TM    DIRFLAG,X'80'               ALIAS ENTRY?                 02714000
         BO    ATTR140                     YES, BRANCH                  02715000
         OI    DIRATTR3,DIRAM64+DIRAM31    MAIN ENTRY              @D02
*                                           -- AMODE=64+31         @D02
         XI    DIRATTR3,DIRAM31            SET AMODE=64            @D02
         CLI   #AMODE,4                    CORRECT?                @D02
         BE    ATTR160                     YES, BRANCH             @D02
         OI    DIRATTR3,DIRAM31            NO, SET AMODE=ANY       @D02
         CLI   #AMODE,3                    CORRECT?                @D02
         BE    ATTR160                     YES, BRANCH             @D02
         XI    DIRATTR3,DIRAM64            SET AMODE=31            @D02
         CLI   #AMODE,2                    CORRECT?                @D02
         BE    ATTR160                     YES, BRANCH             @D02
         NI    DIRATTR3,FF-DIRAM64-DIRAM31 SET AMODE=24            @D02
         B     ATTR160                                                  02724000
         SPACE 1                                                        02725000
ATTR140  OI    DIRATTR3,DIRAA64+DIRAA31    ALIAS ENTRY             @D02
*                                           -- AMODE=64+31         @D02
         XI    DIRATTR3,DIRAA31            SET AMODE=64            @D02
         CLI   #AMODE,4                    CORRECT?                @D02
         BE    ATTR160                     YES, BRANCH             @D02
         OI    DIRATTR3,DIRAA31            NO, SET AMODE=ANY       @D02
         CLI   #AMODE,3                    CORRECT?                @D02
         BE    ATTR160                     YES, BRANCH             @D02
         XI    DIRATTR3,DIRAA64            SET AMODE=31            @D02
         CLI   #AMODE,2                    CORRECT?                @D02
         BE    ATTR160                     YES, BRANCH             @D02
         NI    DIRATTR3,FF-DIRAA64-DIRAA31 SET AMODE=24            @D02
         B     ATTR160                                             @D02
         SPACE 1                                                        02735000
ATTR150  TSMSG (R1)                        AMODE/RMODE MESSAGE          02736000
         SPACE 2                                                        02737000
ATTR160  OC    DIRATTR,#ATTRYES        ADD POSITIVE ATTRIBUTES          02738000
         NC    DIRATTR,#ATTRNO         REMOVE NEGATIVE ATTRIBUTES       02739000
         SPACE 1                                                        02740000
*                                                                       02741000
*   RESTRICTION: BOTH RENT AND REUS MUST BE SPECIFIED FOR REENTRANT     02742000
         TM    DIRATTR,ATTRRENT        WAS REENTRABLE SPECIFIED?        02743000
         BNO   *+8                     NO, BRANCH                       02744000
         OI    DIRATTR,ATTRREUS        YES, ALSO FORCE REUSABLE         02745000
         SPACE 1                                                        02746000
ATTR180  CLI   #SSIOPT,0               SSI(HEXDATA) OR NOSSI?           02747000
         BE    ATTR240                 NO, BRANCH                       02748000
         SR    R1,R1                   SSI INDICATOR                    02749000
         LA    R2,DIRAPF               POINT TO APF INFORMATION         02750000
         TM    DIRATTR,ATTRSCTR        SCATTER FORMAT?                  02751000
         BNO   *+8                     NO, BRANCH                       02752000
         LA    R2,8(,R2)               YES, ADD SCATTER SIZE BYTES      02753000
         SPACE 1                                                        02754000
         TM    DIRFLAG,X'80'           ALIAS?                           02755000
         BO    ATTR182                 YES, BRANCH                      02756000
         CLI   8(R2),0                 CONVERTED ALIAS ENTRY?           02757000
         BE    *+8                     NO, BRANCH                       02758000
ATTR182  LA    R2,11(,R2)              ADD ALIAS LENGTH                 02759000
         SPACE 1                                                        02760000
         LR    R3,R2                   START OF DATA BEFORE ANY SSI     02761000
         LA    R2,1(,R2)               ROUND UP TO HALFWORD             02762000
         N     R2,=F'-2'                                                02763000
         TM    DIRATTR2,DIRAOSLE       VS LINKAGE EDITOR?               02764000
         BO    ATTR184                 YES, BRANCH                      02765000
         SPACE 1                                                        02766000
         CLC   ZERO,0(R2)              ZERO?                            02767000
         BE    ATTR188                 YES, NO SSI                      02768000
         CLC   =F'-1',0(R2)            FFFFFFFF?                        02769000
         BE    ATTR188                 YES, NO SSI                      02770000
         B     ATTR186                 NO, POINT TO SSI                 02771000
         SPACE 1                                                        02772000
ATTR184  TM    DIRATTR2,DIR2SSI        SSI PRESENT?                     02773000
         BNO   ATTR188                 NO, NO SSI                       02774000
         SPACE 1                                                        02775000
ATTR186  LR    R1,R2                   POINT TO SSI                     02776000
ATTR188  LR    R15,R2                  SSI POSITION                     02777000
         SR    R15,R3                  OFFSET FROM LAST DATA TO SSI     02778000
         LA    R15,2(,R15)             ADJUSTMENT AMOUNT                02779000
         CLI   #SSIOPT,1               SSI(HEXDATA)?                    02780000
         BE    ATTR200                 YES, BRANCH                      02781000
         SPACE 1                                                        02782000
*** NOSSI                                                               02783000
         LTR   R1,R1                   ANY SSI?                         02784000
         BZ    ATTR240                 NO, DONE                         02785000
         ICM   R0,B'0011',4(R2)        APF BYTES                        02786000
         XC    0(8,R3),0(R3)           CLEAR FOLLOWING BYTES            02787000
         STCM  R0,B'0011',0(R3)        MOVE APF BEFORE THE SSI          02788000
         TM    DIRATTR2,DIRAOSLE       VS LINKAGE EDITOR?               02789000
         BNO   *+8                     NO, BRANCH                       02790000
         NI    DIRATTR2,FF-DIR2SSI     NO SSI PRESENT                   02791000
         LA    R3,2+1(,R3)             2 FOR APF AND 1 FOR ROUNDING     02792000
         B     ATTR214                                                  02793000
         SPACE 2                                                        02794000
ATTR200  LTR   R1,R1                   SSI ALREADY?                     02795000
         BZ    ATTR210                 NO, BRANCH                       02796000
*** SSI(HEXTEXT) WITH EXISTING SSI INFORMATION                          02797000
         MVC   0(4,R2),#SSITEXT        UPDATE THE SSI DATA              02798000
         B     ATTR240                                                  02799000
         SPACE 2                                                        02800000
*** SSI(HEXTEXT) WITH NO PREVIOUS SSI INFORMATION                       02801000
ATTR210  ICM   R0,B'0011',0(R3)        APF BYTES                        02802000
         MVC   0(4,R2),#SSITEXT        MOVE IN ADDED SSI DATA           02803000
         STCM  R0,B'0011',4(R2)        RESET THE APF INFORMATION        02804000
         TM    DIRATTR2,DIRAOSLE       VS LINKAGE EDITOR?               02805000
         BNO   *+8                     NO, BRANCH                       02806000
         OI    DIRATTR2,DIR2SSI        SSI PRESENT                      02807000
         LA    R3,4+2(,R2)             4 FOR SSI AND 2 FOR APF          02808000
         SPACE 1                                                        02809000
ATTR214  LA    R0,DIRSTART             FIRST BYTE AFTER DIRFLAG         02810000
         SR    R3,R0                   LENGTH OF ADDED DATA             02811000
         SRL   R3,1                    IN HALFWORDS                     02812000
         NI    DIRFLAG,FF-X'1F'        REMOVE LENGTH BITS               02813000
         IC    R0,DIRFLAG              PICK UP ALIAS FLAG, TTR COUNT    02814000
         OR    R0,R3                   ADD IN NEW LENGTH IN HALFWORDS   02815000
         STC   R0,DIRFLAG              UPDATE DIRECTORY FLAG ENTRY      02816000
         SPACE 2                                                        02817000
ATTR240  BAL   R2,OPENSTOW             OPEN STOW DCB; ENQUEUES          02818000
         B     NEWCMD                  COULD NOT OPEN -- ERROR          02819000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR                        02820000
         STOW  STOWDCB,DIRNAME,R       REPLACE OPTION                   02821000
         LR    R5,R15                  SAVE RETURN CODE                 02822000
***      BAL   R2,SHUTSTOW             *** CLOSE STOW AFTER NEWCMD      02823000
         SPACE 1                                                        02824000
         B     *+4(R5)                 PROCESS RETURN CODE              02825000
         B     ATTR250                   00 - SUCCESSFUL                02826000
         EX    0,*                       04 - SHOULD NOT OCCUR          02827000
         EX    0,*                       08 - SHOULD NOT OCCUR          02828000
         B     FULLDIR                   12 - DIRECTORY FULL            02829000
         B     IOERROR                   16 - I/O ERROR                 02830000
         SPACE 3                                                        02831000
ATTR250  TM    FLAGSCC,RECFMU          LOAD LIBRARY?                    02832000
         BNO   ATTR600                 NO, CHECK FOR ALIASES            02833000
         MVC   INSERT#1(8),DIRNAME     MEMBER NAME                      02834000
         MVC   INSERT#2(132),MSGBL132+4                                 02835000
         LA    R1,INSERT#2-1           FIRST COMMA ADDRESS (HIDDEN)     02836000
         MVC   INSERT#2+1(4),=C'NONE'  IF NO SPECIAL ATTRIBUTES         02837000
         LA    R14,TBLATTR-12          ATTRIBUTES TABLE                 02838000
         LH    R2,DIRATTR              GET MODULE ATTRIBUTES            02839000
         SPACE 2                                                        02840000
ATTR300  LA    R14,12(R14)                                              02841000
         CLI   0(R14),X'FF'            END OF TABLE?                    02842000
         BE    ATTR310                 YES, BRANCH                      02843000
         SPACE 1                                                        02844000
         LH    R15,0(R14)              GET ATTRIBUTE FLAGS              02845000
         TM    2(R14),X'80'            POSITIVE OR NEGATIVE ATTRIBUTE?  02846000
         LA    R3,X'80'                MASK FOR POS (FOR BZ INST)       02847000
         BZ    *+8                                                      02848000
         LA    R3,X'70'                MASK FOR NEG (FOR BNZ) INST      02849000
         NR    R15,R2                  CHECK FOR ATTRIBUTE PRESENT      02850000
         NOP   ATTR300                 <<BZ OR BNZ>>                    02851000
         EX    R3,*-4                  BRANCH IF NO DISPLAY ATTRIBUTE   02852000
         SPACE 1                                                        02853000
         MVC   0(6,R1),=C',     '      COMMA AND FOLLOWING BLANKS       02854000
         IC    R15,2(R14)              LENGTH-1 OF ATTRIBUTE            02855000
         LA    R3,X'7F'                MASK FOR 7 BITS                  02856000
         NR    R15,R3                                                   02857000
         MVC   2(*-*,R1),3(R14)        <<EXECUTED>>                     02858000
         EX    R15,*-6                                                  02859000
         LA    R1,3(R15,R1)            JUMP POINTER                     02860000
         B     ATTR300                                                  02861000
         SPACE 2                                                        02862000
ATTR310  MVI   MTHIGHL+4,127                                            02863000
         TSMSG L020$2                  ATTRIBUTES MSG                   02864000
         MVI   MTHIGHL+4,8                                              02865000
         SPACE 2                                                        02866000
         LA    R2,DIRAPF               POINT TO APF INFORMATION         02867000
         SPACE 1                                                        02868000
         TM    DIRATTR,ATTRSCTR        SCATTER FORMAT?                  02869000
         BNO   *+8                     NO, BRANCH                       02870000
         LA    R2,8(,R2)               YES, ADD SCATTER SIZE BYTES      02871000
         SPACE 1                                                        02872000
         TM    DIRFLAG,X'80'           ALIAS?                           02873000
         BO    ATTR314                 YES, BRANCH                      02874000
         CLI   8(R2),0                 CONVERTED ALIAS ENTRY?           02875000
         BE    *+8                     NO, BRANCH                       02876000
ATTR314  LA    R2,11(,R2)              ADD ALIAS LENGTH                 02877000
         SPACE 1                                                        02878000
         TM    DIRATTR2,DIRAOSLE       VS LINKAGE EDITOR?               02879000
         BO    ATTR330                 YES, BRANCH                      02880000
         TSMSG L022                    NON-VS LINKAGE EDITOR MESSAGE    02881000
         B     ATTR340                                                  02882000
         SPACE 1                                                        02883000
ATTR330  TM    DIRATTR2,DIR2SSI        SSI PRESENT?                     02884000
         BNO   ATTR360                 NO, SKIP SSI PROCESSING          02885000
         SPACE 1                                                        02886000
ATTR340  LA    R2,1(,R2)               ROUND UP TO HALFWORD             02887000
         N     R2,=F'-2'                                                02888000
         SPACE 1                                                        02889000
         CLC   ZERO,0(R2)              ZERO?                            02890000
         BE    ATTR360                 YES, NO SSI                      02891000
         CLC   =F'-1',0(R2)            FFFFFFFF?                        02892000
         BE    ATTR360                 YES, NO SSI                      02893000
         SPACE 1                                                        02894000
         UNPK  INSERT#1(9),0(5,R2)                                      02895000
         TR    INSERT#1(8),TRTABLE                                      02896000
         TSMSG L025$1                                                   02897000
         LA    R2,4(,R2)               ADD SSI SIZE                     02898000
         SPACE 2                                                        02899000
ATTR360  TM    FLAGSCC,RECFMU          LOAD MODULE LIB?                 02900000
         BZ    ATTR600                 NO, BRANCH                       02901000
         SPACE 1                                                        02902000
         MVI   MODESAVE,0                                               02903000
         TM    DIRATTR2,DIRAOSLE           VS LINKAGE EDITOR?           02904000
         BZ    ATTR540                     NO, CANNOT BE AUTHORIZED     02905000
         SR    R1,R1                                                    02906000
         IC    R1,DIRATTR3                 AMODE BITS                   02907000
         TM    DIRFLAG,X'80'               ALIAS?                       02908000
         BNO   *+8                         NO, BRANCH                   02909000
         SRL   R1,2                        YES, SHIFT AMODE BITS        02910000
         STC   R1,MODESAVE                 SAVE CURRENT AMODE           02911000
         TM    DIRATTR3,DIRRMANY           RMODE ANY?                   02912000
         BNO   *+8                         NO, BRANCH                   02913000
         OI    MODESAVE,DIRRMANY           YES, SET RMODE AGAIN         02914000
         SPACE 1                                                        02915000
         TM    MODESAVE,DIRRMANY+DIRAM31+DIRAM64 UNUSUAL           @D02
*                                                RMODE/AMODE?      @D02
         BZ    ATTR400                     NO, BRANCH              @D02
         MVC   INSERT#1(8),BLANKS          RMODE FILLER            @D02
         MVC   INSERT#2(8),BLANKS          AMODE FILLER            @D02
         MVC   INSERT#1(3),=C'24 '         MOVE IN THE RMODE TEXT  @D02
         MVI   MTLEN,2                     Set RMODE insert length @D02
         TM    MODESAVE,DIRRMANY           RMODE ANY?              @D02
         BZ    ATTR363                     NO, BRANCH              @D02
         MVC   INSERT#1(3),=C'ANY'         MOVE IN THE RMODE TEXT  @D02
         MVI   MTLEN,3                     Set RMODE insert length @D02
ATTR363  DS    0H                                                  @D02
         MVC   INSERT#2(3),=C'24 '         Assume AMODE=24         @D02
         MVI   MTLEN+4,2                   Set AMODE insert length @D02
         TM    MODESAVE,DIRAM64+DIRAM31    AMODE anything other    @D02
*                                           than 24?               @D02
         BZ    ATTR365                     No, display AMODE=24    @D02
         MVC   INSERT#2(3),=C'ANY'         Assume AMODE=ANY        @D02
         MVI   MTLEN+4,3                   Set AMODE insert length @D02
         BO    ATTR365                     Yes, display AMODE=ANY  @D02
         MVC   INSERT#2(3),=C'64 '         Assume AMODE=64         @D02
         MVI   MTLEN+4,2                   Set AMODE insert length @D02
         TM    MODESAVE,DIRAM31            AMODE 31?               @D02
         BZ    ATTR365                     No, display amode=64    @D02
         MVC   INSERT#2(3),=C'31 '         Else AMODE must be 31   @D02
ATTR365  DS    0H                                                  @D02
         TSMSG L120$2                                                   02931000
         MVI   MTLEN+4,8                   Restore standard length @D02
         TM    MODESAVE,DIRRMANY           RMODE ANY?              @D02
         BZ    ATTR400                     NO, BRANCH              @D02
         LA    R1,=C'ANY'                  ASSUME AMODE IS ANY     @D02
         MVI   MTLEN,3                     Set insert length       @D02
         TM    MODESAVE,DIRAM64+DIRAM31    AMODE ANY?              @D02
         BO    ATTR370                     YES, INVALID            @D02
         TM    MODESAVE,DIRAM31            AMODE 31?               @D02
         BO    ATTR400                     YES, BRANCH             @D02
         TM    MODESAVE,DIRAM64            AMODE 64?               @D02
         BO    ATTR400                     YES, BRANCH             @D02
         LA    R1,=C'24 '                  AMODE IS 24             @D02
         MVI   MTLEN,2                     Set insert length       @D02
ATTR370  MVC   INSERT#1(8),BLANKS                                       02940000
         MVC   INSERT#1(3),0(R1)           MOVE IN THE AMODE TEXT       02941000
         TSMSG L880$1                      RMODE ANY/AMODE CONFLICT     02942000
         SPACE 2                                                        02943000
ATTR400  MVI   MTLEN,8                     Restore standard length @D02
         CLI   RLDCOUNT,X'FF'          ANY DATA TO CHECK?               02944000
         BE    ATTR500                 NO, BRANCH                       02945000
         CLC   RLDCOUNT(1),DIRATTR4    RLD/CONTROL AMOUNTS AGREE?       02946000
         BE    ATTR500                 YES, BRANCH                      02947000
         TSMSG L826                                                     02948000
         SPACE 2                                                        02949000
ATTR500  TM    DIRATTR2,DIR2PAGA       PAGE ALIGNMENT REQUIRED?         02950000
         BNO   ATTR510                 NO, BRANCH                       02951000
         TSMSG L024                    PAGE ALIGNMENT REQUIRED          02952000
         SPACE 2                                                        02953000
ATTR510  LA    R1,L720                 ASSUME NO APF DATA               02954000
         TM    DIRATTR2,DIRAPFLG       APF DATA PRESENT AND VALID?      02955000
         BNO   ATTR530                 NO, BRANCH                       02956000
         SPACE 1                                                        02957000
         LA    R1,L721                 ASSUME APF LENGTH INCORRECT      02958000
         CLI   0(R2),1                 APF DATA LENGTH OK?              02959000
         BNE   ATTR530                 NO, BRANCH                       02960000
         SPACE 3                                                        02961000
         LA    R1,L021                 ASSUME AUTHORIZED                02962000
         CLI   1(R2),1                 AUTHORIZED?                      02963000
         BE    ATTR530                 YES, BRANCH                      02964000
         BL    ATTR540                 NO, APF=0 (NO MESSAGE NEEDED)    02965000
         LA    R1,L023                 APF DATA IS TOO LARGE            02966000
         SPACE 1                                                        02967000
ATTR530  TSMSG (R1)                                                     02968000
         SPACE 2                                                        02969000
ATTR540  TM    DIRATTR,ATTROVLY                OVERLAY DEFINED?         02970000
         BNO   ATTR550                         NO, BRANCH               02971000
         MVC   INSERT#1(8),BLANKS              BLANK FILL               02972000
         MVC   INSERT#1(4),REUSTXT+3           OVERLAY AND REENTRANT    02973000
         TM    DIRATTR,ATTRRENT                CORRECT?                 02974000
         BNO   ATTR542                         NO, BRANCH               02975000
         TSMSG L884$1                          YES, ERROR               02976000
ATTR542  MVC   INSERT#1(4),REUSTXT+3           OVERLAY AND REUSABLE     02977000
         TM    DIRATTR,ATTRREUS                CORRECT?                 02978000
         BNO   ATTR543                         NO, BRANCH               02979000
         TSMSG L884$1                          YES, ERROR               02980000
ATTR543  MVC   INSERT#1(4),REFRTXT+3           OVERLAY AND REFRESHABLE  02981000
         TM    DIRATTR+1,ATTRREFR              CORRECT?                 02982000
         BNO   ATTR544                         NO, BRANCH               02983000
         TSMSG L884$1                          YES, ERROR               02984000
ATTR544  MVC   INSERT#1(4),SCTRTXT+3           OVERLAY AND SCATTER      02985000
         TM    DIRATTR,ATTRSCTR                CORRECT?                 02986000
         BNO   ATTR545                         NO, BRANCH               02987000
         TSMSG L884$1                          YES, ERROR               02988000
ATTR545  TM    DIRATTR2,DIRAOSLE               MVS LINKAGE-EDITOR?      02989000
         BNO   ATTR550                         NO, BRANCH               02990000
         MVC   INSERT#1(5),=C'RMODE'                                    02991000
         MVC   INSERT#1+6(3),=C'ANY'           RMODE ANY                02992000
         TM    MODESAVE,DIRRMANY               CORRECT?                 02993000
         BNO   ATTR546                         NO, BRANCH               02994000
         TSMSG L884$1                          YES, ERROR               02995000
ATTR546  MVI   INSERT#1,C'A'                   AMODE ANY                02996000
         TM    MODESAVE,DIRAM31+DIRAM64        AMODE ANY?          @D02
         BO    ATTR548                         YES, ERROR          @D02
         MVC   INSERT#1+6(3),=C'31 '           AMODE 31            @D02
         TM    MODESAVE,DIRAM31                AMODE 31?           @D02
         BO    ATTR548                         YES, ERROR          @D02
         MVC   INSERT#1+6(3),=C'64 '           AMODE 64            @D02
         TM    MODESAVE,DIRAM64                AMODE 64?           @D02
         BO    ATTR548                         YES, ERROR          @D02
         B     ATTR550                         NO, BRANCH          @D02
ATTR548  DS    0H                                                  @D02
         TSMSG L884$1                          YES, ERROR               03002000
         SPACE 1                                                        03003000
ATTR550  TM    DIRATTR+1,ATTRSYMS+ATTRNE       TEST AND NOT EDIT?       03004000
         BNO   ATTR560                         NO, BRANCH               03005000
         TSMSG L882                            YES, ERROR               03006000
         SPACE 1                                                        03007000
ATTR560  TM    DIRATTR,ATTRRENT                REENTRANT?               03008000
         BNO   ATTR570                         NO, BRANCH               03009000
         TM    DIRATTR,ATTRREUS                REUSABLE?                03010000
         BO    ATTR570                         YES, BRANCH              03011000
         TSMSG L881                            ERROR MESSAGE            03012000
         SPACE 1                                                        03013000
ATTR570  TM    DIRATTR,ATTRREUS+ATTRSCTR       REUSABLE AND SCATTER?    03014000
         BNO   ATTR590                         NO, BRANCH               03015000
         TSMSG L883                            YES, ERROR               03016000
         SPACE 2                                                        03017000
ATTR590  UNPK  INSERT#1(7),DIREPA(4)                                    03018000
         TR    INSERT#1(6),TRTABLE                                      03019000
         MVC   INSERT#1+6(2),BLANKS                                     03020000
         TSMSG L102$1                 NO ENTRY POINT MESSAGE            03021000
         SPACE 1                                                        03022000
         UNPK  INSERT#1(7),DIRSTORE(4)                                  03023000
         TR    INSERT#1(6),TRTABLE                                      03024000
         MVC   INSERT#1+6(2),BLANKS                                     03025000
         ICM   R1,B'0111',DIRSTORE    ACTUAL MODULE LENGTH              03026000
         LA    R1,1023(,R1)           NEXT HIGHER                       03027000
         SRL   R1,10                             1K VALUE               03028000
         CVD   R1,DOUBLE                                                03029000
         MVC   INSERT#2(8),=X'402020202120D2404040'                     03030000
         ED    INSERT#2(6),DOUBLE+5                                     03031000
         TSMSG L104$2                                                   03032000
         SPACE 2                                                        03033000
         CLI   LKEDDATE,X'FF'          ANY DATA TO OUTPUT?              03034000
         BE    ATTR600                 NO, BRANCH                       03035000
         CLI   #LKEDOPT,X'02'          "NOLKEDDATE" DESIRED?            03036000
         BE    ATTR600                 YES, BRANCH                      03037000
         CLI   #LKEDOPT,X'01'          "LKEDDATE" DESIRED?              03038000
         BE    *+12                    YES, BRANCH                      03039000
         TM    FLAGSGG,FLKEDCON        NO LKEDDATE DEFAULT?             03040000
         BO    ATTR600                 YES, BRANCH                      03041000
         SPACE 1                                                        03042000
         MVC   INSERT#1-1(9),DATEMASK                                   03043000
         ED    INSERT#1-1(9),LKEDDATE                                   03044000
         SPACE 1                                                   @D01
         MVI   MTLEN+4,18+14                      Insert length    @D01
         MVC   INSERT#2(10),LKEDNAME              LKED name        @D01
         MVC   INSERT#2+10(2),=CL2' V'            Constant "V"     @D01
         UNPK  INSERT#2+10+2(3),LKEDVVMM(2)       Version          @D01
         MVC   INSERT#2+10+2+2(2),=CL2' M'        Constant "M"     @D01
         UNPK  INSERT#2+10+2+2+2(3),LKEDVVMM+1(2) Level            @D01
         SPACE 1                                                   @D01
**       TSMSG L106$1                                              @D01 03045000
         TSMSG L064$2                                              @D01
         SPACE 3                                                        03046000
ATTR600  TM    DIRFLAG,X'80'           ALIAS?                           03047000
         BO    ATTR630                 YES, BRANCH                      03048000
         OC    #RMODE(2),#RMODE        ANY RMODE/AMODE CHANGE?          03049000
         BZ    ATTR630                 NO, BRANCH                       03050000
         TM    FLAGSCC,RECFMU          RECFM=U?                         03051000
         BNO   ATTR630                 NO, BRANCH                       03052000
         NI    MODESAVE,DIRRMANY+DIRAM31+DIRAM64                   @D02
         MVC   MSGTEXT2(DIREND-DIRNAME),DIRNAME  SAVE MAIN ENTRY        03054000
         MVI   STARTTR+2,X'01'         TTR=000001 (START OF DIRECTORY)  03055000
         SPACE 1                                                        03056000
ATTR610  MVC   DIRNAME(DIREND-DIRNAME),MSGTEXT2  RESTORE MAIN ENTRY     03057000
         BAL   R14,READDIR             GET NEXT DIRECTORY MEMBER        03058000
         B     ATTR630                 LAST MEMBER PROCESSED            03059000
         SPACE 2                                                        03060000
         CLC   DIRTTR,MEMTTR           TTR'S MATCH?                     03061000
         BNE   ATTR610                 NO, BRANCH                       03062000
         TM    MEMFLAG,X'80'           ALIAS ENTRY?                     03063000
         BNO   ATTR610                 NO, CONTINUE SEARCHING           03064000
         SPACE 2                                                        03065000
         L     R14,DIRPTRS             CURRENT DIRECTORY ENTRY          03066000
         MVC   DIRNAME(DIREND-DIRNAME),0(R14)                           03067000
         SPACE 1                                                        03068000
         MVC   DOUBLE(1),DIRATTR3                                       03069000
         NI    DOUBLE,DIRRMANY+DIRAM31+DIRAM64                     @D02
         CLC   MODESAVE(1),DOUBLE      RMODE/AMODE ENTRIES EQUAL?       03071000
         BE    ATTR610                 YES, BRANCH                      03072000
         NI    DIRATTR3,FF-DIRRMANY-DIRAM31-DIRAM64                @D02
         OC    DIRATTR3(1),MODESAVE    CHANGE THE RMODE/AMODE ENTRY     03074000
         SPACE 1                                                        03075000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   03076000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        03077000
         SPACE 1                                                        03078000
         LR    R5,R15                  SAVE RETURN CODE                 03079000
         MVC   INSERT#1(8),DIRNAME     MEMBER NAME                      03080000
         TSMSG L065$1                                                   03081000
         LTR   R15,R5                  SUCCESSFUL?                      03082000
         BNZ   IOERROR                 NO, I/O ERROR                    03083000
         B     ATTR610                 CONTINUE FOR ALL ALIASES         03084000
         SPACE 2                                                        03085000
ATTR630  NI    FLAGSBB,FF-FLINESET                                      03086000
         CLI   #ALIAOPT,X'01'          "ALIASINFO" DESIRED?             03087000
         BE    ATTR640                 YES, BRANCH                      03088000
         BH    NEWCMD                  "NOALIASINFO", DONE              03089000
         TM    FLAGSGG,FALINCON        NO ALIAS INFORMATION DEFAULT?    03090000
         BO    NEWCMD                  YES, BRANCH                      03091000
         TM    FLAGSCC,RECFMU          RECFM=U?                         03092000
         BO    ATTR640                 YES, BRANCH                      03093000
         TM    DIRFLAG,X'80'           MODULE AN ALIAS?                 03094000
         BNO   NEWCMD                  NO, DONE                         03095000
         SPACE 1                                                        03096000
ATTR640  MVI   STARTTR+2,X'01'         TTR=000001 (START OF DIRECTORY)  03097000
         TM    DIRFLAG,X'80'           MODULE AN ALIAS?                 03098000
         BNO   ATTR900                 NO, FIND ALL ALIASES             03099000
         XC    INSERT#1(8),INSERT#1    NO MAIN(S) FOUND                 03100000
         SPACE 2                                                        03101000
*  LIST ANY CORRESPONDING MAIN MODULE NAMES                             03102000
         SPACE 1                                                        03103000
ATTR800  BAL   R14,READDIR        GET NEXT DIRECTORY MEMBER             03104000
         B     ATTR810            LAST MEMBER PROCESSED                 03105000
         SPACE 1                                                        03106000
         TM    MEMFLAG,X'80'      THIS MODULE AN ALIAS?                 03107000
         BO    ATTR800            YES, IGNORE                           03108000
         CLC   DIRTTR,MEMTTR      TTR MATCH?                            03109000
         BNE   ATTR800            NO, BRANCH                            03110000
         MVC   INSERT#1(8),MEMNAME                                      03111000
         TSMSG L066$1                                                   03112000
         B     ATTR800                                                  03113000
         SPACE 1                                                        03114000
ATTR810  OC    INSERT#1(8),INSERT#1  ANY MAIN(S) FOUND?                 03115000
         BNZ   NEWCMD                YES, BRANCH                        03116000
         TSMSG L860                                                     03117000
         TM    FLAGSCC,RECFMU     LOAD MODULE?                          03118000
         BNO   NEWCMD             NO, BRANCH                            03119000
         MVC   INSERT#1(8),DIRREAL                                      03120000
         SPACE 1                                                        03121000
         TM    DIRATTR,ATTRSCTR   SCATTER LOADED?                       03122000
         BNO   *+10               NO, BRANCH                            03123000
         MVC   INSERT#1(8),DIRREALS                                     03124000
         LA    R1,L861$1                                                03125000
         B     MSGNEW                                                   03126000
         SPACE 2                                                        03127000
*  LIST ANY ALIASES FOR THE MODULE                                      03128000
         SPACE 1                                                        03129000
ATTR900  BAL   R14,READDIR          GET NEXT DIRECTORY MEMBER           03130000
         B     ATTR940              LAST MEMBER PROCESSED               03131000
         SPACE 1                                                        03132000
         CLC   DIRTTR,MEMTTR        TTR MATCH?                          03133000
         BNE   ATTR900              NO, BRANCH                          03134000
         TM    MEMFLAG,X'80'        AN ALIAS?                           03135000
         BO    ATTR910              YES, BRANCH                         03136000
         CLC   DIRNAME(8),MEMNAME   DID I FIND MYSELF?                  03137000
         BE    ATTR900              YES, BRANCH                         03138000
         MVC   INSERT#1(8),MEMNAME                                      03139000
         TSMSG L864$1               THIS IS AN APPARENT ALIAS MEMBER    03140000
         B     ATTR900                                                  03141000
         SPACE 1                                                        03142000
ATTR910  LA    R2,MEMNAME+7                                             03143000
         TM    FLAGSBB,FLINESET     LINE IN PROGRESS?                   03144000
         BO    ATTR920              YES, BRANCH                         03145000
         OI    FLAGSBB,FLINESET     LINE NOW IN PROGRESS                03146000
         LA    R1,80                ASSUME AN ACTIVE MODE               03147000
         AIF ('&CISP' EQ 'NO SPF').MA00260                         @D01
         TM    SPFLAG0,SPFDON       ISPMODE ACTIVE?                     03148000
         BO    ATTR912              YES, BRANCH                         03149000
.MA00260 ANOP  ,                                                   @D01
         TM    CONTOPTN,1           ANY LOG RECORDING?                  03150000
         BO    ATTR912              YES, BRANCH                         03151000
         GTSIZE
         CH    R1,=H'120'           120 OR LESS BYTES?                  03153000
         BL    *+8                  YES, BRANCH                         03154000
         LH    R1,=H'120'           NO, USE 120 BYTES                   03155000
ATTR912  SH    R1,=H'7'             LESS SEVEN FOR PREFIX               03156000
         ST    R1,LINESIZE          CHARACTERS/LINE                     03157000
         MVC   MSGLINE+4(L'MSGALIAS),MSGALIAS                           03158000
         LA    R5,MSGLINE+4+L'MSGALIAS                                  03159000
         MVC   FULLWORD(3),L160$1   MESSAGE IDENTIFIER                  03160000
         SPACE 1                                                        03161000
ATTR920  CLI   0(R2),X'40'          SCAN FOR                            03162000
         BNE   *+8                          LAST                        03163000
         BCT   R2,ATTR920                       NON-BLANK               03164000
         SPACE 1                                                        03165000
         LA    R0,MEMNAME                                               03166000
         SR    R2,R0                                                    03167000
         BNM   *+6                                                      03168000
         SR    R2,R2                                                    03169000
         LA    R15,2(R5,R2)                                             03170000
         LA    R1,MSGLINE                                               03171000
         SR    R15,R1                                                   03172000
         C     R15,LINESIZE                                             03173000
         BNH   ATTR930                                                  03174000
         LA    R1,MSGLINE+4                                             03175000
         SR    R5,R1                                                    03176000
         STC   R5,MTHIGHL                                               03177000
         MVC   INSERT#1(127),MSGLINE+4                                  03178000
         LA    R1,FULLWORD                                              03179000
         TSMSG (R1)                                                     03180000
         MVI   MTHIGHL,8                                                03181000
         MVI   FULLWORD+2,C'9'                                          03182000
         LA    R5,MSGLINE+3         INDENT FOR BLANKS                   03183000
         SPACE 1                                                        03184000
ATTR930  MVI   0(R5),X'40'                                              03185000
         MVC   1(8,R5),MEMNAME                                          03186000
         TR    1(8,R5),TRLINE                                           03187000
         LA    R1,2(R2,R5)                                              03188000
         MVI   0(R1),C','                                               03189000
         LA    R5,3(R2,R5)                                              03190000
         B     ATTR900                                                  03191000
         SPACE 2                                                        03192000
ATTR940  TM    FLAGSBB,FLINESET     LINE IN PROGRESS?                   03193000
         BZ    NEWCMD               NO, EXIT                            03194000
         LA    R1,MSGLINE+5                                             03195000
         SR    R5,R1                                                    03196000
         STC   R5,MTHIGHL                                               03197000
         MVC   INSERT#1(127),MSGLINE+4                                  03198000
         LA    R1,FULLWORD                                              03199000
         TSMSG (R1)                                                     03200000
         MVI   MTHIGHL,8                                                03201000
         B     NEWCMD                                                   03202000
         SPACE 2                                                        03203000
         AIF ('&CISP' EQ 'NO SPF').MA00280                         @D01
         TITLE 'P D S -- PDS BROWSE/EDIT/ISPF/ISPMODE/MEMLIST  1/15/85' 03204000
*********************************************************************** 03205000
***     BROWSE SUBCOMMAND      ADDED BY BRUCE LELAND -- JULY, 1982  *** 03206000
***                                                                 *** 03207000
***     EDIT SUBCOMMAND        ADDED BY BRUCE LELAND -- JULY, 1982  *** 03208000
***                                                                 *** 03209000
***     ISPF SUBCOMMAND        ADDED BY STEVE SMITH  -- MAY,  1984  *** 03210000
***                                                                 *** 03211000
***     ISPMODE SUBCOMMAND     ADDED BY STEVE SMITH  -- AUG., 1984  *** 03212000
***                                                                 *** 03213000
***     MEMLIST SUBCOMMAND     ADDED BY STEVE SMITH  -- SEPT, 1984  *** 03214000
*********************************************************************** 03215000
*                                                                       03216000
         SPACE 1                                                        03217000
BROWSE   CSECT                                                          03218000
         USING *,R8                                                     03219000
         LA    R1,L730                  ASSUME ALREADY UNDER SPF        03220000
         TM    FLAGSFF,FSPFOPT6         CORRECT?                        03221000
         BO    MSGNEWXX                 YES, BRANCH                     03222000
         OI    ##ADRPA#,$A+$D           SET TO CANCEL STAX EXIT         03223000
         LA    R1,L731                  ASSUME SPF DID NOT INITIALIZE   03224000
         TM    FLAGSFF,FSPFERR          CORRECT?                        03225000
         BO    MSGNEWXX                 YES, BRANCH                     03226000
         MVC   MSGTEXT1(8),##SUBCAL     SPF SERVICE REQUESTED           03227000
         CLI   #SPFOLD,X'01'            "NEW" SPECIFIED?                03228000
         BNE   SPFMEMOK                 NO, BRANCH                      03229000
         TM    DSORG,DS1DSGPO           NON-PARTITIONED DATA SET?       03230000
         BZ    SPFMEMOK                 YES, BRANCH                     03231000
         BLDL  INDCB,BLDLLIST           INSURE IT DOES NOT EXIST        03232000
         B     *+4(R15)                 PROCESS RETURN CODE             03233000
         B     MEMEXIST                   00 - MEMBER IS NOT NEW        03234000
         B     SPFMEMOK                   04 - MEMBER DOES NOT EXIST    03235000
         B     IOERROR                    08 - I/O ERROR IN DIRECTORY   03236000
         SPACE 1                                                        03237000
SPFMEMOK TM    ##ADRPC#,@I             BROWSE OR EDIT?                  03238000
         BNO   SPFINIT                 NO, ALLOW IT                     03239000
         LA    R1,DIRNAME-1            START OF MEMBER NAME             03240000
         LA    R0,8                    MAXIMUM MEMBER NAME              03241000
         SPACE 1                                                        03242000
SPFMEM2  LA    R1,1(,R1)               SCAN                             03243000
         CLI   0(R1),C'.'                  FOR                          03244000
         BE    BADMEMB                        FIRST                     03245000
         BCT   R0,SPFMEM2                          PERIOD               03246000
         CLI   DIRNAME,X'EF'           NUMERIC FIRST CHARACTER?         03247000
         BH    BADMEMB                 YES, INVALID                     03248000
         SPACE 1                                                        03249000
SPFMEM4  CLC   ##SUBCOM(8),$EDI        EDIT SUBCOMMAND?                 03250000
         BE    SPFMEM5                 YES, BRANCH                      03251000
         CLC   ##SUBCOM(8),$SPF        SPFEDIT SUBCOMMAND?              03252000
         BNE   SPFINIT                 NO, ALLOW IT                     03253000
SPFMEM5  MVC   DSNMEMQ(8),DIRNAME      MEMBER NAME TO TEST              03254000
         BAL   R2,ENQMTEST             MEMBER IN USE?                   03255000
         B     NEWCMD                  YES, ERROR                       03256000
         SPACE 1                                                        03257000
         LA    R1,L702                 ASSUME THIS IS A LOAD LIBRARY    03258000
         TM    FLAGSCC,RECFMU          CORRECT?                         03259000
         BO    MSGNEWXX                YES, BRANCH                      03260000
         SPACE 2                                                        03261000
SPFINIT  TM    FLAGSFF,FSPFCALL+FSPFDIAL  SPF ENVIRONMENT INITIALIZED?  03262000
         BM    SPFLINK                    YES, CALL SPF EDIT/BROWSE     03263000
         BAL   R2,SPFRECUR                NO, INVOKE PDS AS A DIALOG    03264000
         SPACE 3                                                        03265000
SPFLINK  ICM   R15,B'1111',ISPLINK      ISPLINK ADDRESS KNOWN?          03266000
         BNZ   SPFINTRF                 YES, BRANCH                     03267000
         OI    FLAGSFF,FSPFERR          SPF ERROR                       03268000
         MVI   ##ADRCM#,CONTINUE+EDITOR+FABEND                          03269000
         LOAD  EP=ISPLINK               ADDRESS OF SPF INTERFACE MODULE 03270000
         ST    R0,ISPLINK               SAVE ADDRESS FOR LATER          03271000
         XI    FLAGSFF,FSPFERR          NOT AN SPF ERROR NOW            03272000
         MVI   ##ADRCM#,0                                               03273000
SPFINTRF DS    0H                                              SS JUL84 03274000
         STFSMODE ON,INITIAL=YES       ENTER FULLSCREEN MODE            03275000
         CLC   ##SUBCOM(8),$ISM        ISPF DISPLAY MODE SUBCD SS JUL84 03276000
         BE    SPFSETM                 YES, ALLOW IT           SS JUL84 03277000
         CLC   ##SUBCOM(8),$MML        MEMLIST SUBCOMMAND?    ABL OCT84 03278000
         BE    MEMLIST                 YES, ALLOW IT          ABL OCT84 03279000
         BAL   R2,CLOSEIT                 CLOSE THE INPUT DATA SS JUL84 03280000
         SPACE 2                                                        03281000
         XC    RECOVER,RECOVER            NO ESTAE RECOVER ATTEMPTED    03282000
         LA    R0,=CL8'CONTROL'           FIRST PARAMETER               03283000
         LA    R1,=CL8'DISPLAY'           SECOND PARAMETER              03284000
         LA    R2,=CL8'REFRESH'           THIRD PARAMETER               03285000
         STM   R0,R2,MSGTEXT2             SAVE ADDRESSES                03286000
         OI    MSGTEXT2+8,X'80'           LAST                          03287000
         LA    R1,MSGTEXT2                    PARAMETER                 03288000
         L     R15,ISPLINK                                              03289000
         BALR  R14,R15                    LET SPF KNOW                  03290000
         SPACE 1                                                        03291000
         TM    ##ADRPA#,$P                SELECT PANEL SUPPORT SS NOV84 03292000
         BO    SPFP1                      GO PROCESS           SS NOV84 03293000
         BAL   R2,CLOSEIT                 CLOSE THE INPUT DATA SS NOV84 03294000
         CLC   ##SUBCOM(8),$ISP           ISPF SUBCOMMAND?              03295000
         BNE   SPFNOMEN                   NO, BRANCH                    03296000
         LA    R0,=CL8'SELECT'            FIRST PARAMETER               03297000
         LA    R1,29                      16 CHARACTERS                 03298000
         ST    R1,FULLWORD                                              03299000
         LA    R1,FULLWORD                SECOND PARAMETER              03300000
         LA    R2,MSGTEXT1                START OF STRING BYTES         03301000
         STM   R0,R2,MSGTEXT2             SAVE ADDRESSES                03302000
         OI    MSGTEXT2+8,X'80'           MARK END OF LIST (THIRD ITEM) 03303000
         MVC   0(33,R2),ISPPANEL          ADD PANEL(ISR@PRIM) ...       03304000
         OC    #COMMDSZ(2),#COMMDSZ       ANY PARM DATA?                03305000
         BZ    SPFCALL                    NO, BRANCH                    03306000
         MVC   33(80,R2),MSGLINE          ADD THE PARM DATA             03307000
         LA    R1,34                      LENGTH OF PARAMETER STRING    03308000
         AH    R1,#COMMDSZ                LENGTH OF PARAMETER STRING    03309000
         ST    R1,FULLWORD                UPDATE THE PARAMETER LENGTH   03310000
         AR    R2,R1                      POINT TO LAST BYTE +1         03311000
         BCTR  R2,0                       POINT TO LAST BYTE            03312000
         MVI   0(R2),C')'                 LAST PAREN                    03313000
         B     SPFCALL                                                  03314000
         SPACE 2                                                        03315000
SPFNOMEN MVI   MSGTEXT1+8,C''''           ADD A QUOTE                   03316000
         MVC   MSGTEXT1+8+1(44),DSNAME    ADD THE DATA SET NAME         03317000
         LH    R15,DSNLEN                 DSNAME ACTUAL LENGTH          03318000
         LA    R2,MSGTEXT1+8(R15)         POINT TO CURRENT BYTE         03319000
         TM    DSORG,DS1DSGPO             NON-PARTITIONED DATA SET?     03320000
         BZ    SPFALLM                    YES, BRANCH                   03321000
         TM    FLAGSAA,FMEMBER1+FMEMBER2  ALL MEMBERS DESIRED?          03322000
         BNZ   SPFMEMBR                   NO, BRANCH                    03323000
         TM    FLAGSAA,FMEM#MEM           MEMBER GROUP IN PROGRESS?     03324000
         BNO   SPFALLM                    NO, BRANCH                    03325000
         SPACE 1                                                        03326000
SPFMEMBR MVI   1(R2),C'('               MEMBER NAME PARENTHESIS         03327000
         MVC   2(8,R2),DIRNAME          ADD MEMBER NAME                 03328000
         MVI   10(R2),X'40'             INSURE SCAN STOPS               03329000
         LA    R2,1(,R2)                SCAN                            03330000
         CLI   0(R2),X'40'                  FOR FIRST                   03331000
         BNE   *-8                                   BLANK              03332000
         MVI   0(R2),C')'               ADD FINAL PARENTHESIS           03333000
         SPACE 2                                                        03334000
SPFALLM  MVI   1(R2),C''''              ADD FINAL QUOTE                 03335000
         MVI   2(R2),X'40'              ADD FINAL BLANK                 03336000
         LA    R0,MSGTEXT1              FIRST PARAMETER                 03337000
         LA    R1,MSGTEXT1+8            SECOND PARAMETER                03338000
         LA    R2,VOLUME                THIRD PARAMETER                 03339000
         LA    R3,PASSWORD              FOURTH PARAMETER                03340000
         STM   R0,R3,MSGTEXT2           SAVE PARAMETER ADDRESSES        03341000
         MVI   MSGTEXT2+12,X'80'        MARK END OF LIST (FOUR ITEMS)   03342000
         CLI   #SPFMACR,0               ANY MACRO NAME?                 03343000
         BE    SPFCALL                  NO, BRANCH                      03344000
         SR    R4,R4                    FIFTH PARAMETER                 03345000
         LA    R5,#SPFMACR              SIXTH PARAMETER                 03346000
         STM   R0,R5,MSGTEXT2           SAVE PARAMETER ADDRESSES        03347000
         MVI   MSGTEXT2+20,X'80'        MARK END OF LIST (SIX ITEMS)    03348000
         SPACE 1                                                        03349000
SPFCALL  LA    R1,MSGTEXT2              PARAMETER LIST                  03350000
         L     R15,ISPLINK                                              03351000
         BALR  R14,R15                  SPF INTERFACE ROUTINE           03352000
         AIF ('&RETURNX' EQ 'NO').RETURNX                               03353000
         CLI   FLAGSSS,0                ANY RETURN TRAP SET?            03354000
         BE    SPFRET30                 NO, BRANCH                      03355000
         CLC   ##SUBCOM(8),$ISP         ISPF SUBCOMMAND?                03356000
         BNE   SPFRET20                 NO, BRANCH                      03357000
         MVI   FLAGSSS,0                YES, TRAP IS RESET              03358000
         B     SPFRET30                                                 03359000
         SPACE 1                                                        03360000
SPFRET20 CLC   ##SUBCOM(1),FLAGSSS      THIS SERVICE AGAIN?             03361000
         MVI   FLAGSSS,0                                                03362000
         BNE   SPFCALL                  NO, CALL IT AGAIN               03363000
         SPACE 1                                                        03364000
SPFRET30 TM    SPFLAG0,SPFDON           ISPF DIALOG TABLES?             03365000
         BNO   SPFRET35                 NO, BRANCH                      03366000
         CLI   PDSENTRY+3,0             ENTRY TO PDS AS A DIALOG?       03367000
         BE    SPFRET60                 YES, DO NOT RE-INVOKE           03368000
SPFRET35 CLC   ##SUBCOM(8),$ISP         ISPF SUBCOMMAND?                03369000
         BNE   SPFRET40                 NO, BRANCH                      03370000
         CH    R15,=H'4'                YES, RETURN OR EXIT OPTION?     03371000
         BNE   SPFRET60                      NO, BRANCH                 03372000
         MVI   FLAGSSS,C'Z'                  YES, SET RE-INVOKE TRAP    03373000
         B     SPFRET80                                                 03374000
         SPACE 1                                                        03375000
SPFRET40 LA    R1,SPFVDEF               VDEF                            03376000
         LA    R2,SPFZVERB              ZVERB                           03377000
         LA    R3,MSGTEXT2+50           WHERE TO PLACE OUTPUT           03378000
         LA    R4,SPFCHAR               MOVE FUNCTION                   03379000
         L     R15,SPFL8                LENGTH 8                        03380000
         ST    R15,FULLWORD                                             03381000
         LA    R5,FULLWORD              USE AS PARM                     03382000
         STM   R1,R5,MSGTEXT2+20        PARAMETER LIST                  03383000
         OI    MSGTEXT2+20+16,X'80'     END OF LIST                     03384000
         LA    R1,MSGTEXT2+20           START OF PARAMETER LIST         03385000
         L     R15,ISPLINK                                              03386000
         BALR  R14,R15                                                  03387000
         LTR   R15,R15                  DOES ZVERB EXIST?               03388000
         BNZ   SPFRET50                 NO, BRANCH                      03389000
         SPACE 1                                                        03390000
         LA    R1,SPFVGET               VGET                            03391000
         LA    R2,SPFZVERB              ZVERB                           03392000
         LA    R3,SPFSHARE              SHARED                          03393000
         STM   R1,R3,MSGTEXT2+20        PARAMETER LIST                  03394000
         OI    MSGTEXT2+20+8,X'80'      END OF LIST                     03395000
         LA    R1,MSGTEXT2+20           START OF PARAMETER LIST         03396000
         L     R15,ISPLINK                                              03397000
         BALR  R14,R15                                                  03398000
         LTR   R15,R15                  DOES ZVERB EXIST?               03399000
         BNZ   SPFRET50                 NO, BRANCH                      03400000
         SPACE 1                                                        03401000
         CLC   MSGTEXT2+50(3),=C'RET'   RETURN KEY?                     03402000
         BNE   SPFRET50                 NO, BRANCH                      03403000
         MVC   FLAGSSS(1),##SUBCOM      SET THE TRAP CHARACTER          03404000
SPFRET50 LA    R2,SPFVDEL               VDELETE                         03405000
         LA    R3,SPFZVERB              ZVERB                           03406000
         STM   R2,R3,MSGTEXT2+20        PARAMETER LIST                  03407000
         OI    MSGTEXT2+20+4,X'80'      END OF LIST                     03408000
         LA    R1,MSGTEXT2+20           START OF PARAMETER LIST         03409000
         L     R15,ISPLINK                                              03410000
         BALR  R14,R15                                                  03411000
         B     SPFRET80                                                 03412000
SPFVDEF  DC    CL8'VDEFINE'                                             03413000
SPFVDEL  DC    CL8'VDELETE'                                             03414000
SPFZVERB DC    CL8'(ZVERB)'                                             03415000
SPFL8    DC    F'8'                                                     03416000
SPFCHAR  DC    CL8'CHAR'                                                03417000
SPFVGET  DC    CL8'VGET'                                                03418000
SPFSHARE DC    CL8'SHARED'                                              03419000
         SPACE 1                                                        03420000
SPFRET60 MVI   FLAGSSS,0                RESET THE TRAP CHARACTER        03421000
         SPACE 1                                                        03422000
SPFRET80 DS    0H                                                       03423000
.RETURNX ANOP                                                           03424000
         LA    R0,=CL8'CONTROL'           FIRST PARAMETER               03425000
         LA    R1,=CL8'DISPLAY'           SECOND PARAMETER              03426000
         LA    R2,=CL8'SM     '           THIRD PARAMETER               03427000
         LA    R3,=F'1'                   FOURTH PARAMETER              03428000
         STM   R0,R3,MSGTEXT2             SAVE ADDRESSES                03429000
         OI    MSGTEXT2+12,X'80'          LAST                          03430000
         LA    R1,MSGTEXT2                    PARAMETER                 03431000
         L     R15,ISPLINK                                              03432000
         BALR  R14,R15                    LET SPF KNOW                  03433000
*        BAL   R2,CLEAR                 TURN OFF FULL SCREEN MODE       03434000
         NI    ##ADRPA#,FF-$A-$D        DO NOT IGNORE ATTENTION NOW     03435000
         SPACE 1                                                        03436000
         ESTAE 0                        CANCEL THE ESTAE ADDRESS        03437000
         MVC   STAEPARM(4),STAELIST     RESET THE ESTAE ADDRESS         03438000
         ESTAE STAEEXIT,CT,PARAM=(R7),MF=(E,STAEPARM)                   03439000
         MVI   VOLALLOC,X'40'           READ THE DSCB AGAIN             03440000
         SPACE 1                                                        03441000
         MVI   ##ADRCM#,EDITOR          NO REPEATED WARNING MESSAGE     03442000
         L     R1,X'21C'                --> CURRENT TCB                 03443000
         L     R1,X'00C'(,R1)           --> TIOT                        03444000
         LA    R1,24(,R1)               TIOENTRY                        03445000
SPFNTIOT CLI   0(R1),0                  END OF TIOT?                    03446000
         BE    RESTART0                 YES, REALLOCATE AND OPEN AGAIN  03447000
         CLC   4(8,R1),DDNAME           THIS DDNAME?                    03448000
         BE    RESTART4                 YES, JUST OPEN AGAIN            03449000
         SR    R15,R15                                                  03450000
         IC    R15,0(,R1)                                               03451000
         LA    R1,0(R15,R1)                                             03452000
         B     SPFNTIOT                                                 03453000
SPFSETM  DS    0H                       DO FUNCTION            SS JUL84 03454000
         TM    SPFLAG0,SPFDON           ISPMODE ACTIVE?       ABL OCT84 03455000
         BO    SPFSETMM                 YES, BRANCH           ABL OCT84 03456000
         OI    SPFLAG0,SPFDON           ISPMODE ACTIVE NOW     SS JUL84 03457000
         NI    FLAGSBB,FF-FONESHOT      ALWAYS CONTINUE       ABL OCT84 03458000
         TM    SPFLAG0,SPFDSUSP         ISPMODE SUSPENDED?    ABL OCT84 03459000
         BO    SPFSETMM                 YES, BRANCH           ABL OCT84 03460000
         NI    SPFLAG0,255-SPFDSUSP     NO LONGER SUSPENDED   ABL OCT84 03461000
         OI    SPFLAG3,SPFCHN           FORCE MSG TO BE LOGGED SS SEP84 03462000
         MVC   INSERT#1(8),PDSNAME                            ABL OCT84 03463000
         MVC   MTLEN,PDSNAML       Set insert length               @D01
         TSMSG L100$1                                         ABL OCT84 03464000
         MVI   MTLEN,8             Restore standard length         @D01
         MESSAGE MSGBLANK               ONE BLANK LINE        ABL OCT84 03465000
         L     R15,$DSN+8               DO A "DSN" SUBCOMMAND ABL OCT84 03466000
         BR    R15                                            ABL OCT84 03467000
         SPACE 3                                                        03468000
SPFSETMM NI    SPFLAG0,255-SPFDSUSP     SET SUSPEND MODE OFF   SS JUL84 03469000
         NI    SPFLAG3,255-SPFCLIST     END CLIST INTERCEPT    SS NOV84 03470000
         B     NEWCMD                                         ABL OCT84 03471000
         SPACE 3                                                        03472000
*                                                              SS NOV84 03473000
*    SELECT PANEL SUPPORT INTERFACE                            SS NOV84 03474000
*                                                              SS NOV84 03475000
SPFP1    DS    0H                                              SS NOV84 03476000
         ST    R6,SPFSAV6                                      SS NOV84 03477000
         LA    R6,FIRST4K                                      SS NOV84 03478000
         USING FIRST4K,R6                                      SS NOV84 03479000
         TM    ##ADRPA#,$J                MEMBERS PRESENT      SS NOV84 03480000
         BO    SPFP10                     PROCESS WITHOUT      SS NOV84 03481000
         TM    DSORG,DS1DSGPO             NON-PARTITIONED DATA SET?     03482000
         BZ    SPFP10                     YES, BRANCH                   03483000
         TM    FLAGSAA,FMEMBER1+FMEMBER2  ALL MEMBERS DESIRED?          03484000
         BNZ   SPFP5                      NO, BRANCH                    03485000
         TM    FLAGSAA,FMEM#MEM           MEMBER GROUP IN PROGRESS?     03486000
         BNO   SPFP10                     NO, BRANCH                    03487000
SPFP5    MVC   SPFMEMB,DIRNAME            SET CURRENT MEMBER   SS NOV84 03488000
         B     SPFP20                                          SS NOV84 03489000
SPFP10   MVI   SPFMEMB,C' '                                    SS NOV84 03490000
         MVC   SPFMEMB+1(7),SPFMEMB       BLANK                SS NOV84 03491000
SPFP20   DS    0H                                              SS NOV84 03492000
         LH    R1,#COMMDSZ                GET ADDED DATA LEN   SS NOV84 03493000
         STH   R1,SPFZLEN                 SAVE LEN (EVEN ZERO) SS NOV84 03494000
         LTR   R1,R1                      IS IT ZERO           SS NOV84 03495000
         BZ    SPFP22                     NO DATA              SS NOV84 03496000
         LA    R1,MSGLINE                 GET ADDR             SS NOV84 03497000
         ST    R1,SPFZDATA                SAVE ADDR ZCMD DATA  SS NOV84 03498000
SPFP22   DS    0H                                              SS NOV84 03499000
         MVC   SPFPSTK2,##SUBCAL          COPY PANEL ID        SS NOV84 03500000
         L     R6,SPFSAV6                                      SS NOV84 03501000
         DROP  R6                                              SS NOV84 03502000
         MVI   SPFLAG1,SPFPAND            CODE                 SS NOV84 03503000
         L     R15,=V(ISPDSPY)                                 SS NOV84 03504000
         BALR  R14,R15                                         SS NOV84 03505000
         NOP   0                                               SS NOV84 03506000
         CLC   0(4,R1),SPFP0END           END KEY              SS NOV84 03507000
         BE    SPFP30                     YES, BRANCH         ABL DEC84 03508000
         LR    R2,R1                      3RD PARAMETER        SS NOV84 03509000
         LA    R0,=CL8'SELECT'            FIRST PARAMETER      SS NOV84 03510000
         LA    R1,250                     BUFFER 250 CHARS     SS NOV84 03511000
         ST    R1,FULLWORD                                     SS NOV84 03512000
         LA    R1,FULLWORD                SECOND PARAMETER     SS NOV84 03513000
         STM   R0,R2,MSGTEXT2             SAVE ADDRESSES       SS NOV84 03514000
         OI    MSGTEXT2+8,X'80'           MARK END OF LIST     SS NOV84 03515000
SPFP30   BAL   R2,CLOSEIT                 CLOSE THE INPUT DATA SS NOV84 03516000
         B     SPFCALL                                         SS NOV84 03517000
SPFP0END DC    C'END '                                         SS NOV84 03518000
         SPACE 3                                               SS NOV84 03519000
         COPY  MEML70                   INCLUDE MEMLIST CODE   SS NOV84 03520000
.MA00280 ANOP  ,                                                   @D01
         AIF ('&NCAR' EQ  '').MA00300                              @D01
         TITLE 'P D S  --  PDS COMPARE                        1/15/85'  03521000
*********************************************************************** 03522000
***      COMPARE SUBCOMMAND    ADDED BY BRUCE LELAND --  MAY, 1984  *** 03523000
*********************************************************************** 03524000
*                                                                       03525000
         SPACE 1                                                        03526000
COMPARE  CSECT                                                          03527000
         USING *,R8                                                     03528000
         SPACE 1                                                        03529000
         AIF ('&CISP' EQ 'NO SPF').MA00320                         @D01
         TM    SPFLAG2,SPFPOST            LINE COMMAND?                 03530000
         BO    COMPA6                     YES, BRANCH                   03531000
         SPACE 1                                                        03532000
.MA00320 ANOP  ,                                                   @D01
         MVC   MEMBERD+1(2),LMEMBER2   CHANGE DEFAULT MEMBER LENGTH     03533000
         MVC   MEMBERD+1+2(8),MEMBER2  CHANGE DEFAULT MEMBER NAME       03534000
         MVI   MEMBERD,FMEMBER1        ONLY ONE MEMBER NAME NOW         03535000
         NI    FLAGSEE,FF-FMEMLIST     NO MEMBER LIST                   03536000
         BAL   R14,DEFGROUP                    ADD DEFAULT GROUP        03537000
         SPACE 1                                                        03538000
COMPA6   XC    DIRUSER,DIRUSER         CLEAR THE USER FIELDS            03539000
         MVC   DIRNAME,MEMBER2         SECOND MEMBER NAME               03540000
         SPACE 2                                                        03541000
         BLDL  INDCB,BLDLLIST          LOCATE DIRECTORY ENTRY           03542000
         B     *+4(R15)                PROCESS RETURN CODE              03543000
         B     COMPA10                   00 - SUCCESSFUL                03544000
         B     NOMEMBER                  04 - MEMBER NOT FOUND          03545000
         B     IOERROR                   08 - I/O ERROR                 03546000
         SPACE 2                                                        03547000
COMPA10  MVC   DIRNAME(8),MEMBER1      FIRST MEMBER NAME                03548000
         MVC   MSGTEXT1+4(8),##SUBCAL  PROCESSOR TO ATTACH              03549000
         MVI   MSGTEXT1+12,X'40'       ADD A BLANK                      03550000
         MVI   MSGTEXT1+13,C''''       ADD A QUOTE                      03551000
         MVC   MSGTEXT1+14(44),DSNAME  ADD THE DATA SET NAME            03552000
         LH    R15,DSNLEN              DSNAME ACTUAL LENGTH             03553000
         LA    R4,14(,R15)             LENGTH OF "COMPARE '"            03554000
         LA    R3,MSGTEXT1+13(R15)     POINT TO CURRENT BYTE -1         03555000
         SPACE 1                                                        03556000
         MVI   1(R3),C'('              MEMBER NAME PARENTHESIS          03557000
         MVC   2(8,R3),DIRNAME         MEMBER NAME                      03558000
         LA    R3,2+8(,R3)             END OF MEMBER +1                 03559000
         LA    R4,2+8(,R4)             LENGTH OF MEMBER +1              03560000
         LA    R2,8                    MAXIMUM MACHINE LENGTH+1         03561000
         SPACE 1                                                        03562000
COMPA20  BCTR  R3,0                    SCAN                             03563000
         BCTR  R4,0                        BACKWARDS                    03564000
         CLI   0(R3),X'40'                          FOR                 03565000
         BNE   *+8                                     FIRST            03566000
         BCT   R2,COMPA20                                   NON-BLANK   03567000
         SPACE 1                                                        03568000
         BCTR  R2,0                    MACHINE LENGTH                   03569000
         TRT   DIRNAME(*-*),TRTMEM     <<EXECUTED>>                     03570000
         EX    R2,*-6                  VALID MEMBER NAME?               03571000
         BNZ   BADMEMB                 NO, ERROR                        03572000
         CLI   DIRNAME,C'0'            VALID FIRST CHARACTER?           03573000
         BNL   BADMEMB                 NO, BRANCH                       03574000
         LA    R3,1(,R3)               POINT TO TERMINATOR              03575000
         MVI   0(R3),C')'              ADD A CLOSING PARENTHESIS        03576000
         SPACE 1                                                        03577000
         MVI   1(R3),C''''             ADD A QUOTE                      03578000
         MVI   2(R3),X'40'             ADD A BLANK                      03579000
         LA    R4,3(,R4)               ACCOUNT FOR ")' "                03580000
         LA    R3,3(,R3)               ACCOUNT FOR ")' "                03581000
         SPACE 2                                                        03582000
         MVC   DIRNAME(8),MEMBER2      SECOND MEMBER NAME               03583000
         MVI   0(R3),C''''             ADD A QUOTE                      03584000
         MVC   1(44,R3),DSNAME         ADD THE DATA SET NAME            03585000
         LH    R15,DSNLEN              DSNAME ACTUAL LENGTH             03586000
         LA    R4,01(R4,R15)           LENGTH SO FAR                    03587000
         LA    R3,MSGTEXT1-1(R4)       POINT TO CURRENT BYTE -1         03588000
         SPACE 1                                                        03589000
         MVI   1(R3),C'('              MEMBER NAME PARENTHESIS          03590000
         MVC   2(8,R3),DIRNAME         MEMBER NAME                      03591000
         LA    R3,2+8(,R3)             END OF MEMBER +1                 03592000
         LA    R4,2+8(,R4)             LENGTH OF MEMBER +1              03593000
         LA    R2,8                    MAXIMUM MACHINE LENGTH+1         03594000
         SPACE 1                                                        03595000
COMPA30  BCTR  R3,0                    SCAN                             03596000
         BCTR  R4,0                        BACKWARDS                    03597000
         CLI   0(R3),X'40'                          FOR                 03598000
         BNE   *+8                                     FIRST            03599000
         BCT   R2,COMPA30                                   NON-BLANK   03600000
         SPACE 1                                                        03601000
         BCTR  R2,0                    MACHINE LENGTH                   03602000
         TRT   DIRNAME(*-*),TRTMEM     <<EXECUTED>>                     03603000
         EX    R2,*-6                  VALID MEMBER NAME?               03604000
         BNZ   BADMEMB                 NO, ERROR                        03605000
         CLI   DIRNAME,C'0'            VALID FIRST CHARACTER?           03606000
         BNL   BADMEMB                 NO, BRANCH                       03607000
         LA    R3,1(,R3)               POINT TO TERMINATOR              03608000
         MVI   0(R3),C')'              ADD A CLOSING PARENTHESIS        03609000
         SPACE 1                                                        03610000
         MVI   1(R3),C''''             ADD A QUOTE                      03611000
         MVI   2(R3),X'40'             ADD A BLANK                      03612000
         LA    R4,3(,R4)               ACCOUNT FOR ")' "                03613000
         SPACE 1                                                        03614000
         TM    FLAGSGG,FSAVEOP         SAVE TEXT MODE?                  03615000
         BNZ   COMPA36                 NO, BRANCH                       03616000
         LA    R15,FIRST4K                                              03617000
         LA    R15,SAVECOMP-FIRST4K(,R15)  SAVE TEXT AREA               03618000
         CLI   #COMMDSZ+1,0            ANY OPERAND?                     03619000
         BE    COMPA34                 NO, BRANCH                       03620000
         MVC   0(40,R15),MSGLINE       YES, SAVE NEW DEFAULT TEXT       03621000
         B     COMPA36                                                  03622000
COMPA34  MVC   MSGLINE(40),0(R15)      USE THE DEFAULT OPERAND          03623000
         CLI   0(R15),0                ANY DEFAULT?                     03624000
         BE    COMPA36                 NO, BRANCH                       03625000
         MVI   #COMMDSZ+1,40           YES, USE A 40 CHARACTER LENGTH   03626000
         SPACE 1                                                        03627000
COMPA36  AH    R4,#COMMDSZ             ADD LENGTH OF KEYWORD DATA       03628000
         MVC   3(40,R3),MSGLINE        ADD ANY KEYWORD DATA             03629000
         SPACE 2                                                        03630000
         LA    R2,MSGTEXT1             START OF COMMAND TEXT            03631000
         SLL   R4,16                   CLEAR BOTTOM TWO BYTES           03632000
         STCM  R4,B'1111',0(R2)        SAVE STRING TOTAL LENGTH         03633000
*        MESSAGE (R2)                  DELETE * TO OUTPUT COMMAND       03634000
         ST    R2,ADDRTEXT             COMMAND ADDRESS                  03635000
         ST    R2,ADDRCBUF             COMMAND ADDRESS                  03636000
         LA    R1,ADDRTEXT             COMMAND ADDRESS                  03637000
         CLI   ##SUBCAL,C'%'           CLIST CALL?                      03638000
         BE    EXEC                    YES, IMPLIED CLIST               03639000
         MVI   3(R2),9                 OPERAND OFFSET                   03640000
         SPACE 1                                                        03641000
         LA    R3,##SUBCAL             PROCESSOR TO ATTACH              03642000
         AIF ('&C296' EQ 'YES').YES296                                  03643000
COMPAZAP NOP   COMPA39                 DO NOT LINK TO COMPARE           03644000
         AGO   .NOT296                                                  03645000
.YES296  ANOP                                                           03646000
COMPAZAP B     COMPA39                 LINK TO COMPARE                  03647000
.NOT296  ANOP                                                           03648000
***  THE FOLLOWING INTERFACE IS FOR COMPARE FROM THE CBT TAPE, FILE 300 03649000
         BAL   R2,ATTACH               ATTACH THIS COMMAND PROCESSOR    03650000
         B     NEWCMD                                                   03651000
         SPACE 1                                                        03652000
***  EITHER THE ABOVE OR THE FOLLOWING INTERFACE MAY BE                 03653000
***  USED BY THE COMPARE COMMAND FROM THE CBT TAPE, FILE 296            03654000
COMPA39  LA    R15,MSGLINE           ***  START OF PARAMETER LIST       03655000
         MVC   0(12,R15),COMPA40     ***  SAVE RE-ENTRY CODE            03656000
         LA    R0,COMPA50            ***  START OF WRITE SUBROUTINE     03657000
         ST    R0,12(,R15)           ***  OPERAND OFFSET                03658000
         ST    R7,16(,R15)           ***  SAVE GETMAIN ADDRESS          03659000
         MVC   4(4,R2),=C'****'      ***  SET COMPARE FLAGS             03660000
         ST    R15,8(,R2)            ***  SAVE REENTRY LIST ADDRESS     03661000
         LA    R0,NEWSTAX            ***  ABEND RECOVERY                03662000
         ST    R0,RECOVER            ***                                03663000
         SPACE 2                                                        03664000
         MVC   PARMLIST(COMPA66),COMPA60  *** INITIALIZE LINK LIST      03665000
         LINK  EPLOC=((3)),SF=(E,PARMLIST)                              03666000
         B     NEWCMD                                                   03667000
         SPACE 1                                                        03668000
COMPA40  ST    R1,20(,R15)           ***  SAVE PARAMETER ADDRESS        03669000
         L     R15,12(,R15)          ***  RE-ENTRY POINT                03670000
         BAL   R1,0(,R15)            ***  LINK TO SUBROUTINE            03671000
         SPACE 3                                                        03672000
COMPA50  SAVE  (14,12)               ***                                03673000
         LR    R8,R15                ***  BASE REGISTER ADDRESS         03674000
         USING COMPA50,R8            ***  BASE REGISTER NOTIFICATION    03675000
         L     R7,4(,R1)             ***  WORK AREA ADDRESS             03676000
         L     R1,8(,R1)             ***  OUTPUT MESSAGE START          03677000
         LM    R9,R12,BASES          ***  RESTORE BASE REGISTERS        03678000
         LA    R15,VALSAVE           ***  SAVE AREA FOR THIS ROUTINE    03679000
         ST    R13,4(,R15)           ***                                03680000
         ST    R15,8(,R13)           ***  CHAIN SAVE AREAS              03681000
         LR    R13,R15               ***                                03682000
         MVC   MSGTEXT2+4(80),1(R1)  ***                                03683000
         LA    R1,79+4               ***  LENGTH                        03684000
         SLL   R1,16                 ***  CLEAR OUT OTHER BYTES         03685000
         ST    R1,MSGTEXT2           ***  SET IN THE MESSAGE            03686000
         LA    R1,MSGTEXT2           ***  MESSAGE ADDRESS               03687000
        $PUTLINE (R1),ATTN=COMPA58   ***  OUTPUT THIS MESSAGE           03688000
         SR    R15,R15               ***  SUCCESSFUL OUTPUT             03689000
         B     COMPA59               ***  RETURN                        03690000
COMPA58  LA    R15,4                 ***  SET REGISTER R15              03691000
COMPA59  L     R13,4(,R13)           ***  UNCHAIN SAVE AREAS            03692000
         ST    R15,16(R13)           ***  SAVE RETURN CODE              03693000
         RETURN (14,12)              ***  RETURN                        03694000
         SPACE 3                                                        03695000
COMPA60  LINK  EPLOC=$CAR,SF=L                                          03696000
COMPA66  EQU   *-COMPA60                                                03697000
.MA00300 ANOP  ,                                                   @D01
         TITLE 'P D S  --  PDS COMPRESS                        1/15/85' 03698000
*********************************************************************** 03699000
***      COMPRESS SUBCOMMAND   ADDED BY BRUCE LELAND -- APR., 1984  *** 03700000
*********************************************************************** 03701000
*                                                                       03702000
         SPACE 1                                                        03703000
COMPRESS CSECT                                                          03704000
         USING *,R8                                                     03705000
         SPACE 1                                                        03706000
         MVI   VOLALLOC,X'40'             READ THE DSCB AGAIN           03707000
         CLI   DSPALLOC,ALLOOLD           EXCLUSIVE USE ALREADY?        03708000
         BE    CMXSYSDD                   YES, BRANCH                   03709000
*  ALLOCATE THE DATA SET TO COMPRESS AS "OLD"                           03710000
         BAL   R2,CLOSEIT                 CLOSE THE DATA SET            03711000
         BAL   R2,DEALLDCB                UNALLOCATE THE DATA SET       03712000
         LA    R0,RESTART0                ABEND RECOVERY                03713000
         ST    R0,RECOVER                               RESTART ADDRESS 03714000
         MVI   DSPALLOC,ALLOOLD           WANT EXCLUSIVE USE NOW        03715000
         L     R15,=A(ALLOCATE)           ALLOCATION ROUTINE ADDRESS    03716000
         BALR  R14,R15                    ALLOCATE THE DATA SET?        03717000
         B     RESTART0                   NO, ERROR                     03718000
         SPACE 1                                                        03719000
         L     R8,##ADRCMD                REESTABLISH THE BASE REGISTER 03720000
         CLI   DSPALLOC,ALLOOLD           OLD ALLOCATION NOW?           03721000
         BE    CMXSYSDD                   YES, BRANCH                   03722000
         CLI   #CMXSHR,1                  SHR COMPRESS DESIRED?         03723000
         BNE   RESTART2                   NO, QUIT                      03724000
         SPACE 2                                                        03725000
         AIF   (&MVT).MA00340                                      @D01
*  ALLOCATE COMPRESS SYSIN FILE                                         03726000
CMXSYSDD XC    M99RBPTR(40),M99RBPTR      CLEAR THE WORK AREA           03727000
         LA    R1,M99RBPTR                DYNAMIC ALLOCATION            03728000
         USING S99RBP,R1                                                03729000
         SPACE 1                                                        03730000
         LA    R4,M99RB                                                 03731000
         USING S99RB,R4                                                 03732000
         ST    R4,S99RBPTR                                              03733000
         OI    S99RBPTR,S99RBPND          MARK END OF LIST              03734000
         SPACE 1                                                        03735000
         LA    R5,M99TUPL                                               03736000
         USING S99TUPL,R5                                               03737000
         MVI   S99RBLN,20                 LENGTH 20                     03738000
         MVI   S99VERB,S99VRBAL           ALLOCATE                      03739000
         ST    R5,S99TXTPP                POINT TO TEXT POINTERS        03740000
         SPACE 1                                                        03741000
         MVC   #CMXSYSI(14),CMXDDNAM      REQUEST DDNAME FEEDBACK       03742000
         LA    R3,#CMXSYSI                FIRST TEXT POINTER            03743000
         USING S99TUNIT,R3                                              03744000
         ST    R3,S99TUPTR                POINT TO FIRST TEXT UNITS     03745000
         MVC   S99TUPTR+4(20),CMXSYSIN    ADD OTHER LIST ELEMENTS       03746000
         SPACE 1                                                        03747000
         DYNALLOC                                                       03748000
         MVC   #CMXSYSI(8),#CMXSYSI+6     MOVE DOWN THE DATA SET NAME   03749000
         SPACE 2                                                        03750000
         DROP  R1,R3,R4,R5                                              03751000
         LTR   R15,R15                    SUCCESSFUL?                   03752000
         BNZ   CMXERROR                   NO, BRANCH                    03753000
         SPACE 3                                                        03754000
*  ALLOCATE COMPRESS SYSPRINT DATA SET                                  03755000
         SPACE 1                                                        03756000
         XC    M99RBPTR(40),M99RBPTR      CLEAR THE WORK AREA           03757000
         LA    R1,M99RBPTR                DYNAMIC ALLOCATION            03758000
         USING S99RBP,R1                                                03759000
         SPACE 1                                                        03760000
         LA    R4,M99RB                                                 03761000
         USING S99RB,R4                                                 03762000
         ST    R4,S99RBPTR                                              03763000
         OI    S99RBPTR,S99RBPND          MARK END OF LIST              03764000
         SPACE 1                                                        03765000
         LA    R5,M99TUPL                                               03766000
         USING S99TUPL,R5                                               03767000
         MVI   S99RBLN,20                 LENGTH 20                     03768000
         MVI   S99VERB,S99VRBAL           ALLOCATE                      03769000
         ST    R5,S99TXTPP                POINT TO TEXT POINTERS        03770000
         SPACE 1                                                        03771000
         MVC   #CMXSYSP(14),CMXDDNAM      REQUEST DDNAME FEEDBACK       03772000
         LA    R3,#CMXSYSP                FIRST TEXT POINTER            03773000
         USING S99TUNIT,R3                                              03774000
         ST    R3,S99TUPTR                POINT TO FIRST TEXT UNITS     03775000
         MVC   S99TUPTR+4(4),CMXSYSIN     ASSUME DUMMY TEXT IS DESIRED  03776000
         CLI   #CMXFLAG,3                 NOLIST?                       03777000
         BNE   *+8                        NO, BRANCH                    03778000
         LA    R5,4(,R5)                  YES, USE THE DUMMY TEXT       03779000
         MVC   S99TUPTR+4(36),CMXSYSPR    ADD OTHER LIST ELEMENTS       03780000
         MVC   MSGTEXT2(9+9),CMXPRTFI     ADD PRIMARY, SECONDARY        03781000
         LA    R0,MSGTEXT2                START OF PRIMARY AMOUNT       03782000
         ST    R0,S99TUPTR+4              CHANGE ADDRESS POINTER        03783000
         LA    R0,MSGTEXT2+9              START OF SECONDARY AMOUNT     03784000
         ST    R0,S99TUPTR+4+4            CHANGE ADDRESS POINTER        03785000
         LH    R15,TOTUSEDX               NUMBER OF USED MEMBER BLOCKS  03786000
         MH    R15,=H'21'                 MAXIMUM MEMBERS               03787000
         AR    R15,R15                    MAXIMUM MEMBERS*2             03788000
         SR    R14,R14                                                  03789000
         D     R14,=F'50'                 50 MEMBERS/PAGE               03790000
         SRL   R15,4                      DIVIDED BY 16                 03791000
         LA    R15,2(,R15)                ADD 2                         03792000
         STCM  R15,B'0111',MSGTEXT2+6     UPDATE IN PRIMARY SPACE       03793000
         STCM  R15,B'0111',MSGTEXT2+9+6   UPDATE IN SECONDARY SPACE     03794000
         SPACE 1                                                        03795000
         DYNALLOC                                                       03796000
         SPACE 2                                                        03797000
         MVC   #CMXSYSP(8),#CMXSYSP+6     MOVE DOWN THE DDNAME          03798000
         DROP  R1,R3,R4,R5                                              03799000
         LTR   R15,R15                    SUCCESSFUL?                   03800000
         BNZ   CMXERROR                   NO, BRANCH                    03801000
         SPACE 2                                                        03802000
*  ALLOCATE COMPRESS SYSUT3 DATA SET                                    03803000
         SPACE 1                                                        03804000
         XC    M99RBPTR(40),M99RBPTR      CLEAR THE WORK AREA           03805000
         LA    R1,M99RBPTR                DYNAMIC ALLOCATION            03806000
         USING S99RBP,R1                                                03807000
         SPACE 1                                                        03808000
         LA    R4,M99RB                                                 03809000
         USING S99RB,R4                                                 03810000
         ST    R4,S99RBPTR                                              03811000
         OI    S99RBPTR,S99RBPND          MARK END OF LIST              03812000
         SPACE 1                                                        03813000
         LA    R5,M99TUPL                                               03814000
         USING S99TUPL,R5                                               03815000
         MVI   S99RBLN,20                 LENGTH 20                     03816000
         MVI   S99VERB,S99VRBAL           ALLOCATE                      03817000
         ST    R5,S99TXTPP                POINT TO TEXT POINTERS        03818000
         SPACE 1                                                        03819000
         MVC   #CMXSYS3(14),CMXDDNAM      REQUEST DDNAME FEEDBACK       03820000
         LA    R3,#CMXSYS3                FIRST TEXT POINTER            03821000
         USING S99TUNIT,R3                                              03822000
         ST    R3,S99TUPTR                POINT TO FIRST TEXT UNITS     03823000
         MVC   S99TUPTR+4(24),CMXSYSUT    ADD OTHER LIST ELEMENTS       03824000
         MVC   MSGTEXT2(9+9),CMXPRTFI     ADD PRIMARY, SECONDARY        03825000
         LA    R0,MSGTEXT2                START OF PRIMARY AMOUNT       03826000
         ST    R0,S99TUPTR+4              CHANGE ADDRESS POINTER        03827000
         LA    R0,MSGTEXT2+9              START OF SECONDARY AMOUNT     03828000
         ST    R0,S99TUPTR+4+4            CHANGE ADDRESS POINTER        03829000
         LH    R15,TOTUSEDX               NUMBER OF USED MEMBER BLOCKS  03830000
         MH    R15,=H'21'                 MAXIMUM MEMBERS               03831000
         MH    R15,=H'105'                                              03832000
         SR    R14,R14                                                  03833000
         D     R14,=F'100'                TOTAL SPACE IN BLOCKS         03834000
         SRL   R15,4                      DIVIDED BY 16                 03835000
         LA    R15,2(,R15)                ADD 2                         03836000
         STCM  R15,B'0111',MSGTEXT2+6     UPDATE IN PRIMARY SPACE       03837000
         STCM  R15,B'0111',MSGTEXT2+9+6   UPDATE IN SECONDARY SPACE     03838000
         SPACE 1                                                        03839000
         DYNALLOC                                                       03840000
         SPACE 2                                                        03841000
         MVC   #CMXSYS3(8),#CMXSYS3+6     MOVE DOWN THE DDNAME          03842000
         DROP  R1,R3,R4,R5                                              03843000
         LTR   R15,R15                    SUCCESSFUL?                   03844000
         BZ    CMXSTAX                    YES, BRANCH                   03845000
         SPACE 2                                                        03846000
CMXERROR ST    R15,DAIRRC                 SAVE RETURN CODE              03847000
         BAL   R2,CLOSEIT                 CLOSE THE DATA SET            03848000
         BAL   R2,DEALLDCB                UNALLOCATE THE DATA SET       03849000
         LA    R0,RESTART0                ABEND RECOVERY                03850000
         ST    R0,RECOVER                               RESTART ADDRESS 03851000
         LA    R14,M99RB                  POINTER TO SVC 99 BLOCK       03852000
         LA    R15,DAIRRC                 POINTER TO RETURN CODE        03853000
         LA    R0,ADDRFF02                POINTER TO A(IKJEFF02)        03854000
         LA    R1,=AL2(DFSVC99)           POINTER TO INVOCATION TYPE    03855000
         L     R2,ADDRCPPL                POINTER TO THE CPPL           03856000
         STM   R14,R2,DFDAPLP             INITIALIZE DFDAPLP, DFDRCP,   03857000
*                                           DFJEFF02, DFIDP AND DFCPPLP 03858000
         SPACE 1                                                        03859000
         AGO   .NA00340                                            @D01
.MA00340 ANOP  ,                                                   @D01
*----------------------------------------------------------------* @D01
*        Allocate compress SYSIN file using DAIR.                * @D01
*----------------------------------------------------------------* @D01
CMXSYSDD MVC   #CMXSYSI(8),BLANKS  Assume no SYSIN allocation      @D01
         LA    R1,PARMLIST         Point to DAPL                   @D01
         USING DAPL,R1             Addressability for DAPL         @D01
         XC    DAIR08,DAIR08       Zero DAIR X'08' parm block      @D01
         LA    R5,DAIR08           Point to parm block             @D01
         USING DAPB08,R5           Address parm block              @D01
         ST    R5,DAPLDAPB         Set parm block address in DAPL  @D01
         MVC   DA08CD,=XL2'0008'   Set entry code = allocate       @D01
         XC    DA08PDSN,DA08PDSN   No DSN                          @D01
         MVC   DA08PSWD,BLANKS     No password                     @D01
         MVC   DA08DDN,BLANKS      Return DD name                  @D01
         MVC   DA08SER,BLANKS      No volume                       @D01
         MVC   DA08MNM,BLANKS      No member name                  @D01
         MVC   DA08UNIT,BLANKS     No unit                         @D01
         MVI   DA08CTL,DA08DMMY    Set DUMMY flag                  @D01
         MVI   DA08DSP1,DA08NEW    DISP=(NEW,...,...)              @D01
         MVI   DA08DPS2,DA08DEL    DISP=(...,DELETE,...)           @D01
         MVI   DA08DPS3,DA08DELE   DISP=(...,...,DELETE)           @D01
         XC    ATTNECB,ATTNECB     Clear the ECB                   @D01
         L     R15,ADDRDAIR        Get address of DAIR             @D01
         BALR  R14,R15             Go to DAIR                      @D01
         DROP  R1                  End DAPL addressability         @D01
         LTR   R15,R15             Allocation successful?          @D01
         BNZ   CMXERROR            No, branch to error routine     @D01
         MVC   #CMXSYSI(8),DA08DDN Save returned SYSIN DD name     @D01
         DROP  R5                  End parm block addressability   @D01
         SPACE 1                                                   @D01
*----------------------------------------------------------------* @D01
*        Allocate compress SYSPRINT file using DAIR.             * @D01
*----------------------------------------------------------------* @D01
         MVC   #CMXSYSP(8),BLANKS  Assume no SYSPRINT allocation   @D01
         LA    R1,PARMLIST         Point to DAPL                   @D01
         USING DAPL,R1             Addressability for DAPL         @D01
         XC    DAIR08,DAIR08       Zero DAIR X'08' parm block      @D01
         LA    R5,DAIR08           Point to parm block             @D01
         USING DAPB08,R5           Address parm block              @D01
         ST    R5,DAPLDAPB         Set parm block address in DAPL  @D01
         MVC   DA08CD,=XL2'0008'   Set entry code = allocate       @D01
         XC    DA08PDSN,DA08PDSN   No DSN                          @D01
         MVC   DA08PSWD,BLANKS     No password                     @D01
         MVC   DA08DDN,BLANKS      Return DD name                  @D01
         MVC   DA08SER,BLANKS      No volume                       @D01
         MVC   DA08MNM,BLANKS      No member name                  @D01
         MVC   DA08UNIT,=CL8'&DAUNIT'    Unit                      @D01
         MVI   DA08CTL,DA08DMMY    Set DUMMY flag                  @D01
         MVI   DA08DSP1,DA08NEW    DISP=(NEW,...,...)              @D01
         MVI   DA08DPS2,DA08DEL    DISP=(...,DELETE,...)           @D01
         MVI   DA08DPS3,DA08DELE   DISP=(...,...,DELETE)           @D01
         CLI   #CMXFLAG,3          User specify NOLIST?            @D01
         BE    CMXSYSP2            Yes, done with SYSPRINT parms   @D01
         MVC   DAIRDSNT(7),=C'&&&&PRINT'  Set data set name        @D01
         MVC   DAIRDSNL,=AL2(7)           Set data set name length @D01
         LA    R15,DAIRDSN         Point to DSN key                @D01
         ST    R15,DA08PDSN        Set DSN pointer in parm block   @D01
         MVI   DA08CTL,DA08ABKL    Set BLOCKS indicator            @D01
         MVC   DA08BLK,=AL4(6171)  Set block size for allocation   @D01
         LH    R15,TOTUSEDX        Get count of used dir blocks    @D01
         MH    R15,=H'21'          Calculate maximum members       @D01
         AR    R15,R15             Maximum members * 2             @D01
         SR    R14,R14             Divide by                       @D01
         D     R14,=F'50'           50 members per page            @D01
         SRL   R15,4               Divided by 16 extents           @D01
         LA    R15,2(,R15)         Add 2                           @D01
         ST    R15,DA08PQTY        Set as primary quantity         @D01
         ST    R15,DA08SQTY        Set as secondary quantity       @D01
CMXSYSP2 XC    ATTNECB,ATTNECB     Clear the ECB                   @D01
         L     R15,ADDRDAIR        Get address of DAIR             @D01
         BALR  R14,R15             Go to DAIR                      @D01
         DROP  R1                  End DAPL addressability         @D01
         LTR   R15,R15             Allocation successful?          @D01
         BNZ   CMXERROR            No, branch to error routine     @D01
         MVC   #CMXSYSP(8),DA08DDN Save returned SYSPRINT DD name  @D01
         DROP  R5                  End parm block addressability   @D01
         SPACE 1                                                   @D01
*----------------------------------------------------------------* @D01
*        Allocate compress SYSUT3 file using DAIR.               * @D01
*----------------------------------------------------------------* @D01
         MVC   #CMXSYS3(8),BLANKS  Assume no SYSUT3 allocation     @D01
         LA    R1,PARMLIST         Point to DAPL                   @D01
         USING DAPL,R1             Addressability for DAPL         @D01
         XC    DAIR08,DAIR08       Zero DAIR X'08' parm block      @D01
         LA    R5,DAIR08           Point to parm block             @D01
         USING DAPB08,R5           Address parm block              @D01
         ST    R5,DAPLDAPB         Set parm block address in DAPL  @D01
         MVC   DA08CD,=XL2'0008'   Set entry code = allocate       @D01
         MVC   DA08PSWD,BLANKS     No password                     @D01
         MVC   DA08DDN,BLANKS      Return DD name                  @D01
         MVC   DA08SER,BLANKS      No volume                       @D01
         MVC   DA08MNM,BLANKS      No member name                  @D01
         MVC   DA08UNIT,=CL8'&DAUNIT'    Unit                      @D01
         MVI   DA08DSP1,DA08NEW    DISP=(NEW,...,...)              @D01
         MVI   DA08DPS2,DA08DEL    DISP=(...,DELETE,...)           @D01
         MVI   DA08DPS3,DA08DELE   DISP=(...,...,DELETE)           @D01
         MVC   DAIRDSNT(8),=C'&&&&SYSUT3' Set data set name        @D01
         MVC   DAIRDSNL,=AL2(8)           Set data set name length @D01
         LA    R15,DAIRDSN         Point to DSN key                @D01
         ST    R15,DA08PDSN        Set DSN pointer in parm block   @D01
         MVI   DA08CTL,DA08ABKL    Set BLOCKS indicator            @D01
         MVC   DA08BLK,=AL4(80)    Set block size for allocation   @D01
         LH    R15,TOTUSEDX        Get count of used dir blocks    @D01
         MH    R15,=H'21'          Calculate maximum members       @D01
         MH    R15,=H'105'         Times                           @D01
         SR    R14,R14              1.05                           @D01
         D     R14,=F'100'           per member                    @D01
         SRL   R15,4               Divided by 16 extents           @D01
         LA    R15,2(,R15)         Add 2                           @D01
         ST    R15,DA08PQTY        Set as primary quantity         @D01
         ST    R15,DA08SQTY        Set as secondary quantity       @D01
         XC    ATTNECB,ATTNECB     Clear the ECB                   @D01
         L     R15,ADDRDAIR        Get address of DAIR             @D01
         BALR  R14,R15             Go to DAIR                      @D01
         DROP  R1                  End DAPL addressability         @D01
         LTR   R15,R15             Allocation successful?          @D01
         BNZ   CMXERROR            No, branch to error routine     @D01
         MVC   #CMXSYS3(8),DA08DDN Save returned SYSUT3 DD name    @D01
         DROP  R5                  End parm block addressability   @D01
         B     CMXSTAX             Allocation successful, continue @D01
         SPACE 1                                                   @D01
*----------------------------------------------------------------* @D01
*        An allocation failed, call DAIRFAIL.                    * @D01
*----------------------------------------------------------------* @D01
CMXERROR ST    R15,DAIRRC          Save DAIR return code           @D01
         BAL   R2,CLOSEIT          Close data set                  @D01
         BAL   R2,DEALLDCB         Unallocate the data set         @D01
         LA    R0,RESTART0         Set restart adddress            @D01
         ST    R0,RECOVER           for abend recovery             @D01
         LA    R14,PARMLIST        Pointer to DAIR parm list       @D01
         LA    R15,DAIRRC          Pointer to RETURN CODE          @D01
         LA    R0,ADDRFF02         Pointer to A(IKJEFF02)          @D01
         LA    R1,=AL2(DFDAIR)     Pointer to invocation type      @D01
         L     R2,ADDRCPPL         Pointer to the CPPL             @D01
         STM   R14,R2,DFDAPLP      Initialize DFDAPLP, DFDRCP,     @D01
*                                             DFJEFF02, DFIDP      @D01
*                                             and DFCPPLP          @D01
.NA00340 ANOP  ,                                                   @D01
         LINK  EP=IKJEFF18,MF=(E,DFPARMS)                               03860000
         LTR   R15,R15                    PROBLEM WITH IKJEFF18?        03861000
         BZ    CMXRETRN                   NO, BRANCH                    03862000
         SPACE 1                                                        03863000
         CVD   R15,DOUBLE                                               03864000
         MVI   MTHIGHL,4                                                03865000
         MVC   INSERT#1(4),=X'40202120'                                 03866000
         ED    INSERT#1(4),DOUBLE+6                                     03867000
         MVI   INSERT#1,C'='                                            03868000
         TSMSG L835$1                                                   03869000
         B     CMXRETRN                                                 03870000
         SPACE 3                                                        03871000
CMXSTAX  TSMSG L480                       COMPRESS IN PROGRESS MESSAGE  03872000
         OI    ##ADRPA#,$A                DEFER ALL ATTENTIONS          03873000
         SPACE 1                                                        03874000
         XC    WORKTBL,WORKTBL            CLEAR THE TEMPORARY TABLE     03875000
         STAX  ATTNNULL,USADDR=(R7),REPLACE=NO,IBUF=0,                 X03876000
               OBUF=(PDS480W,PDS480WL),MF=(E,WORKTBL)                   03877000
         LA    R1,ZERO                    NO FIRST PARAMETER            03878000
         ST    R1,#CMXLIST                                              03879000
         LA    R1,#CMXDDNA                SECOND PARAMETER              03880000
         ST    R1,#CMXLIST+4                                            03881000
         OI    #CMXLIST+4,X'80'           MARK END OF LIST              03882000
         XC    #CMXDDNA(82),#CMXDDNA      SYSIN DDNAME                  03883000
         MVI   #CMXDDNA+1,80              LENGTH OF DDNAME LIST         03884000
         MVC   #CMXDDIN,#CMXSYSI          SYSIN DDNAME                  03885000
         MVC   #CMXDDPR,#CMXSYSP          SYSPRINT DDNAME               03886000
         MVC   #CMXDDT1,DDNAME            SYSUT1 DDNAME                 03887000
         MVC   #CMXDDT2,DDNAME            SYSUT2 DDNAME                 03888000
         MVC   #CMXDDT3,#CMXSYS3          SYSUT3 DDNAME                 03889000
         BAL   R6,RESERVE                 RESERVE DEVICE IF REQUIRED    03890000
         SPACE 1                                                        03891000
COMPRZAP LA    R0,3239  **TO BE ZAPPED    PASSWORD                      03892000
         SVC   247      **TO BE ZAPPED    GET AUTHORIZED                03893000
         ORG   *-2      -- NOTE --        OVERLAY THE SVC CALL          03894000
         NOPR  0        **TO BE ZAPPED    OVERLAY THE SVC CALL          03895000
         LA    R3,##SUBCAL                WHO TO ATTACH                 03896000
         LA    R1,#CMXLIST                PARAMETERS TO PASS            03897000
         BAL   R2,ATTACH                  SPFCOPY/IEBCOPY/$PDSFAST      03898000
         SR    R0,R0                      UNAUTHORIZATION CODE          03899000
         SVC   247      **TO BE ZAPPED    GET UNAUTHORIZED              03900000
         ORG   *-2      -- NOTE --        OVERLAY THE SVC CALL          03901000
         NOPR  0        **TO BE ZAPPED    OVERLAY THE SVC CALL          03902000
         SPACE 1                                                        03903000
         SPACE 3                                                        03904000
         BAL   R2,DEQ                     RELEASE ANY RESERVES          03905000
         BAL   R2,CLOSEIT                 CLOSE THE DATA SET            03906000
         BAL   R2,DEALLDCB                UNALLOCATE THE DATA SET       03907000
         LA    R0,RESTART0                ABEND RECOVERY                03908000
         ST    R0,RECOVER                               RESTART ADDRESS 03909000
         STAX  ,                                                        03910000
         NI    ##ADRPA#,FF-$A             ALLOW ATTENTIONS AGAIN        03911000
         MVI   ATTNECB,0                  CLEAR THE ATTENTION ECB       03912000
         CLI   SUBSECB+3,12               RETURN CODE > 12?             03913000
         BH    CMXNOPEN                   YES, BRANCH                   03914000
         CLI   #CMXFLAG,3                 NOLIST REQUESTED?             03915000
         BNE   CMXOPEN                    NO, BRANCH                    03916000
CMXNOPEN MVI   MTHIGHL,3                                                03917000
         SR    R15,R15                                                  03918000
         ICM   R15,B'0001',SUBSECB+3                                    03919000
         CVD   R15,DOUBLE                                               03920000
         MVC   INSERT#1-1(4),=X'40202120'                               03921000
         ED    INSERT#1-1(4),DOUBLE+6                                   03922000
         MVI   INSERT#1,C'='                                            03923000
         TSMSG L171$1                                                   03924000
         B     CMXRETRN                                                 03925000
         SPACE 3                                                        03926000
CMXOPEN  MVC   STOWDCB(CMXDL),CMXDCB      GET MODEL DCB                 03927000
         MVC   DCBDDNAM-IHADCB+STOWDCB(8),#CMXSYSP                      03928000
         MVI   OPENLIST,X'80'                                           03929000
         OPEN  (STOWDCB),MF=(E,OPENLIST)      OPEN SYSPRINT             03930000
         TM    DCBOFLGS-IHADCB+STOWDCB,X'10'  SUCCESSFUL OPEN?          03931000
         BO    CMXMSGIN                       YES, BRANCH               03932000
         TSMSG L865                           NO STATUS AVAILABLE       03933000
         B     CMXRETRN                       EXIT                      03934000
         SPACE 3                                                        03935000
*  PROCESS SYSPRINT RECORDS                                             03936000
         SPACE 1                                                        03937000
CMXMSGIN GET   STOWDCB                    GET LIST RECORD               03938000
         CLI   1(R1),X'40'                HEADER LINE?                  03939000
         BE    CMXMSGIN                   YES, IGNORE                   03940000
         CLI   #CMXFLAG,2                 FULL LIST REQUESTED?          03941000
         BE    CMXMSGON                   YES, OUTPUT                   03942000
         LA    R3,CMXEXCL-6               START OF EXCLUSION TABLE -6   03943000
CMXMSGCK LA    R3,6(,R3)                  NEXT MESSAGE ID               03944000
         CLC   1(6,R1),0(R3)              MESSAGE ID TO BE EXCLUDED?    03945000
         BE    CMXMSGIN                   YES, IGNORE                   03946000
         CLI   0(R3),FF                   END OF TABLE?                 03947000
         BNE   CMXMSGCK                   NO, LOOP                      03948000
         SPACE 3                                                        03949000
CMXMSGON MVC   MSGTEXT1(136),MSGBL132     BLANK THE MESSAGE LINE        03950000
         CLC   1(6,R1),CMXIEB14           UNUSED TRACKS MESSAGE?        03951000
         BNE   *+8                        NO, BRANCH                    03952000
         MVI   MSGTEXT1+1,64              YES, TRUNCATE THE MESSAGE     03953000
         MVC   MSGTEXT1+4(120),1(R1)      ADD THE IEBCOPY MESSAGE       03954000
         MESSAGE MSGTEXT1                 OUTPUT THE MESSAGE            03955000
         B     CMXMSGIN                                                 03956000
         SPACE 3                                                        03957000
CMXEXCL  DC    C'IEB152'           IEB152I MEMBERNAME COMPRESSED-WAS AL 03958000
         DC    C'IEB154'           IEB154I MEMBERNAME HAS BEEN SUCCESSF 03959000
         DC    C'IEB167'           IEB167I FOLLOWING MEMBER(S) COPIED F 03960000
         DC    C'IEB161'           IEB161I COMPRESS TO BE DONE USING IN 03961000
         DC    C'PDSFAS'           PDSFAST   ... HEADER LINE            03962000
         DC    C'PDF00 '           PDF00  START EXECUTION               03963000
         DC    C'PDF06 '           PDF06   INPUT DATASET:  ...          03964000
         DC    C'PDF09 '           PDF09  MEMBER ........ - MOVED ...   03965000
         DC    X'FF'                                                    03966000
         SPACE 2                                                        03967000
*** THE FOLLOWING MESSAGES ARE ALSO CANDIDATES FOR SUPPRESSION:         03968000
CMXIEB14 DC    C'IEB144'           IEB144I THERE ARE XXXXXXX UNUSED TRA 03969000
***      DC    C'IEB147'           IEB147I END OF JOB X WAS HIGHEST RET 03970000
***      DC    C'IEB149'           IEB149I THERE ARE XXXXXXX UNUSED DIR 03971000
***      DC    C'IEB153'           IEB153I ALL MEMBERS COMPRESSED-ALL W 03972000
         DC    X'FF'                                                    03973000
         SPACE 2                                                        03974000
CMXMDONE DS    0H                                                       03975000
         MVI   OPENLIST,X'80'                                           03976000
         CLOSE (STOWDCB),MF=(E,OPENLIST)  CLOSE THE SYSPRINT FILE.      03977000
         SPACE 2                                                        03978000
CMXRETRN MESSAGE MSGBLANK                                               03979000
         AIF   (&MVT).MA00360                                      @D01
         CLI   #CMXSYSI,X'41'             ANY SYSIN DDNAME?             03980000
         BL    CMXFREEP                   NO, BRANCH                    03981000
         SPACE 1                                                        03982000
         XC    M99RBPTR(40),M99RBPTR      CLEAR THE WORK AREA           03983000
         LA    R1,M99RBPTR                DYNAMIC ALLOCATION            03984000
         USING S99RBP,R1                                                03985000
         SPACE 1                                                        03986000
         LA    R4,M99RB                                                 03987000
         USING S99RB,R4                                                 03988000
         ST    R4,S99RBPTR                                              03989000
         OI    S99RBPTR,S99RBPND          MARK END OF LIST              03990000
         SPACE 1                                                        03991000
         LA    R5,M99TUPL                                               03992000
         USING S99TUPL,R5                                               03993000
         MVI   S99RBLN,20                 LENGTH 20                     03994000
         MVI   S99VERB,S99VRBUN           UNALLOCATE                    03995000
         ST    R5,S99TXTPP                POINT TO TEXT POINTER         03996000
         SPACE 1                                                        03997000
         LA    R3,#CMXSYSI-6              TEXT POINTER                  03998000
         USING S99TUNIT,R3                                              03999000
         MVC   S99TUKEY(6),CMXDDNAM       ADD TEXT KEYS                 04000000
         ST    R3,S99TUPTR                POINT TO TEXT UNIT            04001000
         OI    S99TUPTR,X'80'             MARK END OF THE TEXT LIST     04002000
         MVI   S99TUKEY+1,1               CONVERT DDNAME REQUEST        04003000
         SPACE 1                                                        04004000
         DYNALLOC                                                       04005000
         SPACE 1                                                        04006000
         DROP  R1,R3,R4,R5                                              04007000
         SPACE 2                                                        04008000
CMXFREEP CLI   #CMXSYSP,X'41'             ANY SYSPRINT ALLOCATED?       04009000
         BL    CMXFREE3                   NO, BRANCH                    04010000
         SPACE 1                                                        04011000
         XC    M99RBPTR(40),M99RBPTR      CLEAR THE WORK AREA           04012000
         LA    R1,M99RBPTR                DYNAMIC ALLOCATION            04013000
         USING S99RBP,R1                                                04014000
         SPACE 1                                                        04015000
         LA    R4,M99RB                                                 04016000
         USING S99RB,R4                                                 04017000
         ST    R4,S99RBPTR                                              04018000
         OI    S99RBPTR,S99RBPND          MARK END OF LIST              04019000
         SPACE 1                                                        04020000
         LA    R5,M99TUPL                                               04021000
         USING S99TUPL,R5                                               04022000
         MVI   S99RBLN,20                 LENGTH 20                     04023000
         MVI   S99VERB,S99VRBUN           UNALLOCATE                    04024000
         ST    R5,S99TXTPP                POINT TO TEXT POINTER         04025000
         SPACE 1                                                        04026000
         LA    R3,#CMXSYSP-6              TEXT POINTER                  04027000
         USING S99TUNIT,R3                                              04028000
         MVC   S99TUKEY(6),CMXDDNAM       ADD TEXT KEYS                 04029000
         ST    R3,S99TUPTR                POINT TO TEXT UNIT            04030000
         OI    S99TUPTR,X'80'             MARK END OF THE TEXT LIST     04031000
         MVI   S99TUKEY+1,1               CONVERT DDNAME REQUEST        04032000
         SPACE 1                                                        04033000
         DYNALLOC                                                       04034000
         SPACE 1                                                        04035000
         DROP  R1,R3,R4,R5                                              04036000
         SPACE 2                                                        04037000
CMXFREE3 CLI   #CMXSYSP,X'41'             ANY SYSUT3 ALLOCATED?         04038000
         BL    RESTART0                   NO, BRANCH                    04039000
         SPACE 1                                                        04040000
         XC    M99RBPTR(40),M99RBPTR      CLEAR THE WORK AREA           04041000
         LA    R1,M99RBPTR                DYNAMIC ALLOCATION            04042000
         USING S99RBP,R1                                                04043000
         SPACE 1                                                        04044000
         LA    R4,M99RB                                                 04045000
         USING S99RB,R4                                                 04046000
         ST    R4,S99RBPTR                                              04047000
         OI    S99RBPTR,S99RBPND          MARK END OF LIST              04048000
         SPACE 1                                                        04049000
         LA    R5,M99TUPL                                               04050000
         USING S99TUPL,R5                                               04051000
         MVI   S99RBLN,20                 LENGTH 20                     04052000
         MVI   S99VERB,S99VRBUN           UNALLOCATE                    04053000
         ST    R5,S99TXTPP                POINT TO TEXT POINTER         04054000
         SPACE 1                                                        04055000
         LA    R3,#CMXSYS3-6              TEXT POINTER                  04056000
         USING S99TUNIT,R3                                              04057000
         MVC   S99TUKEY(6),CMXDDNAM       ADD TEXT KEYS                 04058000
         ST    R3,S99TUPTR                POINT TO TEXT UNIT            04059000
         OI    S99TUPTR,X'80'             MARK END OF THE TEXT LIST     04060000
         MVI   S99TUKEY+1,1               CONVERT DDNAME REQUEST        04061000
         SPACE 1                                                        04062000
         DYNALLOC                                                       04063000
         SPACE 1                                                        04064000
         DROP  R1,R3,R4,R5                                              04065000
         AGO   .NA00360
.MA00360 ANOP  ,                                                   @D01
         SPACE 1                                                   @D01
*----------------------------------------------------------------* @D01
*        Unallocate SYSIN using DAIR.                            * @D01
*----------------------------------------------------------------* @D01
         CLI   #CMXSYSI,X'41'      Was SYSIN allocated?            @D01
         BL    CMXFREEP            No, skip unallocate             @D01
         XC    DAIR18,DAIR18       Clear parm block to zeroes      @D01
         LA    R5,DAIR18           Point to unallocate parm block  @D01
         USING DAPB18,R5           Address unallocate parm block   @D01
         MVI   DA18CD+1,X'18'      Entry code = unallocate         @D01
         MVC   DA18DDN,#CMXSYSI    Set SYSIN DD name               @D01
         LA    R14,PARMLIST        Point to DAPL                   @D01
         USING DAPL,R14            Addressability for DAPL         @D01
         L     R1,ADDRUPT          Get UPT address                 @D01
         L     R2,ADDRECT          Get ECT address                 @D01
         LA    R3,ATTNECB          Get address of ECB              @D01
         L     R4,ADDRPSCB         Get PSCB address                @D01
***      LA    R5,DAIR18           Get DAIR parm block address     @D01
         STM   R1,R5,DAPLUPT       Set DAPLUPT, DAPLECT, DAPLECB,  @D01
*                                      DAPLPSCB and DAPLDAPB       @D01
         DROP  R5                  End parm block addressability   @D01
         LR    R1,R14              Set DAPL address for DAIR       @D01
         DROP  R14                 End DAPL addressability         @D01
         L     R15,ADDRDAIR        Get DAIR address                @D01
         BALR  R14,R15             Link to DAIR to free the file   @D01
         SPACE 1                                                   @D01
*----------------------------------------------------------------* @D01
*        Unallocate SYSPRINT using DAIR.                         * @D01
*----------------------------------------------------------------* @D01
CMXFREEP CLI   #CMXSYSP,X'41'      Was SYSPRINT allocated?         @D01
         BL    CMXFREE3            No, skip unallocate             @D01
         XC    DAIR18,DAIR18       Clear parm block to zeroes      @D01
         LA    R5,DAIR18           Point to unallocate parm block  @D01
         USING DAPB18,R5           Address unallocate parm block   @D01
         MVI   DA18CD+1,X'18'      Entry code = unallocate         @D01
         MVC   DA18DDN,#CMXSYSP    Set SYSPRINT DD name            @D01
         LA    R14,PARMLIST        Point to DAPL                   @D01
         USING DAPL,R14            Addressability for DAPL         @D01
         L     R1,ADDRUPT          Get UPT address                 @D01
         L     R2,ADDRECT          Get ECT address                 @D01
         LA    R3,ATTNECB          Get address of ECB              @D01
         L     R4,ADDRPSCB         Get PSCB address                @D01
***      LA    R5,DAIR18           Get DAIR parm block address     @D01
         STM   R1,R5,DAPLUPT       Set DAPLUPT, DAPLECT, DAPLECB,  @D01
*                                      DAPLPSCB and DAPLDAPB       @D01
         DROP  R5                  End parm block addressability   @D01
         LR    R1,R14              Set DAPL address for DAIR       @D01
         DROP  R14                 End DAPL addressability         @D01
         L     R15,ADDRDAIR        Get DAIR address                @D01
         BALR  R14,R15             Link to DAIR to free the file   @D01
         SPACE 1                                                   @D01
*----------------------------------------------------------------* @D01
*        Unallocate SYSUT3 using DAIR.                           * @D01
*----------------------------------------------------------------* @D01
CMXFREE3 CLI   #CMXSYS3,X'41'      Was SYSUT3 allocated?           @D01
         BL    RESTART0            No, skip unallocate             @D01
         XC    DAIR18,DAIR18       Clear parm block to zeroes      @D01
         LA    R5,DAIR18           Point to unallocate parm block  @D01
         USING DAPB18,R5           Address unallocate parm block   @D01
         MVI   DA18CD+1,X'18'      Entry code = unallocate         @D01
         MVC   DA18DDN,#CMXSYS3    Set SYSUT3 DD name              @D01
         LA    R14,PARMLIST        Point to DAPL                   @D01
         USING DAPL,R14            Addressability for DAPL         @D01
         L     R1,ADDRUPT          Get UPT address                 @D01
         L     R2,ADDRECT          Get ECT address                 @D01
         LA    R3,ATTNECB          Get address of ECB              @D01
         L     R4,ADDRPSCB         Get PSCB address                @D01
***      LA    R5,DAIR18           Get DAIR parm block address     @D01
         STM   R1,R5,DAPLUPT       Set DAPLUPT, DAPLECT, DAPLECB,  @D01
*                                      DAPLPSCB and DAPLDAPB       @D01
         DROP  R5                  End parm block addressability   @D01
         LR    R1,R14              Set DAPL address for DAIR       @D01
         DROP  R14                 End DAPL addressability         @D01
         L     R15,ADDRDAIR        Get DAIR address                @D01
         BALR  R14,R15             Link to DAIR to free the file   @D01
.NA00360 ANOP  ,                                                   @D01
         B     RESTART0                                                 04066000
         SPACE 3                                                        04067000
*  COMPRESS CONSTANTS                                                   04068000
         PRINT NOGEN                                                    04069000
CMXDCB   DCB   DSORG=PS,DDNAME=CMX,MACRF=GL,EODAD=CMXMDONE              04070000
CMXDL    EQU   *-CMXDCB                                                 04071000
         AIF   (&MVT).MA00380                                      @D01
         PRINT GEN                                                      04072000
         SPACE 2                                                        04073000
CMXDDNAM DC    X'0055000100084040404040404040'                          04074000
CMXDUMMY DC    X'00240000'                       DUMMY DATA SET         04075000
CMXBLKSI DC    X'0030000100020050'               DCB=BLKSIZE=80         04076000
CMXNEW   DC    X'00040001000104'                 DISP=(NEW)             04077000
CMXDEL   DC    X'00050001000104'                 DISP=(,DELETE)         04078000
CMXCDEL  DC    X'00060001000104'                 DISP=(,,DELETE)        04079000
         SPACE 2                                                        04080000
         SPACE 2                                                        04081000
CMXPRTFI DC    X'000A00010003',AL3(*-*)          SPACE=(,NNN)           04082000
CMXPRTSE DC    X'000B00010003',AL3(*-*)          SPACE=(,(,NNN))        04083000
CMXPRTIN DC    X'00090001000300181B'             SPACE=(6171)           04084000
CMXUT3IN DC    X'000900010003000050'             SPACE=(80)             04085000
         SPACE 1                                                        04086000
CMXPRTRE DC    X'004900010001',XL1'94'           DCB=RECFM=FBA          04087000
CMXPRTLR DC    X'004200010002',AL2(121)          DCB=LRECL=121          04088000
CMXPRTBL DC    X'003000010002',AL2(6171)         DCB=BLKSIZE=6171       04089000
         SPACE 2                                                        04090000
CMXSYSIN DC    A(CMXDUMMY,CMXBLKSI,CMXNEW,CMXDEL),X'80',AL3(CMXCDEL)    04091000
CMXSYSUT DC    A(CMXPRTFI,CMXPRTSE,CMXUT3IN)                            04092000
         DC    A(CMXNEW,CMXDEL),X'80',AL3(CMXCDEL)                      04093000
CMXSYSPR DC    A(CMXPRTFI,CMXPRTSE,CMXPRTIN)                            04094000
         DC    A(CMXPRTRE,CMXPRTLR,CMXPRTBL)                            04095000
         DC    A(CMXNEW,CMXDEL),X'80',AL3(CMXCDEL)                      04096000
.MA00380 ANOP  ,                                                   @D01
         TITLE 'P D S  --  PDS CONTROL                         1/15/85' 04097000
*********************************************************************** 04098000
***      CONTROL SUBCOMMAND    ADDED BY BRUCE LELAND -- OCT., 1983  *** 04099000
*********************************************************************** 04100000
*                                                                       04101000
         SPACE 1                                                        04102000
CONTROL  CSECT                                                          04103000
         USING *,R8                                                     04104000
         AIF ('&CISP' EQ 'NO SPF').NSPF200                              04105000
         TM    FLAGSEE,FBKGRND               BACKGROUND MODE?           04106000
         BO    CONT004                       YES, BRANCH                04107000
         TM    FLAGSFF,FSPFOPT6+FSPFERR+FSPFCALL+FSPFDIAL  CHANGE SPF?  04108000
         BNZ   CONT004                                     NO, BRANCH   04109000
         TM    #OUT+10,X'01'                 SYSOUT/DSNAME?             04110000
         BNO   CONT004                       NO, BRANCH                 04111000
         BAL   R2,SPFRECUR                   INVOKE PDS AS A DIALOG     04112000
         SPACE 1                                                        04113000
.NSPF200 ANOP                                                           04114000
         SPACE 2                                                        04115000
CONT004  CLI   #OUT+10,0                     SYSOUT/NOSYSOUT/DSN/NODSN? 04116000
         BE    CONT010                       NO, BRANCH                 04117000
         TM    DCBOFLGS-IHADCB+LOGDCB,X'10'  OPEN?                      04118000
         BZ    CONT010                       NO, BRANCH                 04119000
*** CLOSE THE SYSOUT/DSNAME DATA SET                                    04120000
         NI    FLAGSFF,FF-FLOGWRT         TURN OFF RECORD FLAG          04121000
         MVI   OPENLIST,X'80'                                           04122000
         CLOSE (LOGDCB),MF=(E,OPENLIST)                                 04123000
         AIF   (NOT &MVT).MA00400                                  @D01
*----------------------------------------------------------------* @D01
*        Free the old log file using DAIR.                       * @D01
*----------------------------------------------------------------* @D01
         XC    DAIR18,DAIR18       Clear parm block to zeroes      @D01
         LA    R5,DAIR18           Point to unallocate parm block  @D01
         USING DAPB18,R5           Address unallocate parm block   @D01
         MVI   DA18CD+1,X'18'      Entry code = unallocate         @D01
         MVC   DA18DDN,LOGDDN      Set DD name to free             @D01
         DROP  R5                  End parm block addresability    @D01
         LA    R14,PARMLIST        Point to DAPL                   @D01
         USING DAPL,R14            Addressability for DAPL         @D01
         L     R1,ADDRUPT          Get UPT address                 @D01
         L     R2,ADDRECT          Get ECT address                 @D01
         LA    R3,ATTNECB          Get address of ECB              @D01
         L     R4,ADDRPSCB         Get PSCB address                @D01
***      LA    R5,DAIR18           Get DAIR parm block address     @D01
         STM   R1,R5,DAPLUPT       Set DAPLUPT, DAPLECT, DAPLECB,  @D01
*                                      DAPLPSCB and DAPLDAPB       @D01
         LR    R1,R14              Set DAPL address for DAIR       @D01
         DROP  R14                 End DAPL addressability         @D01
         L     R15,ADDRDAIR        Get DAIR address                @D01
         BALR  R14,R15             Link to DAIR to free the file   @D01
.MA00400 ANOP  ,                                                   @D01
         TSMSG L081                                                     04124000
         SPACE 2                                                        04125000
         CLI   CONTOPTN,X'03'             DISK LOG OPEN?                04126000
         BNE   CONT010                    NO, BRANCH                    04127000
         LH    R1,DSNLEN                  DSNAME LENGTH                 04128000
         BCTR  R1,0                       MACHINE LENGTH                04129000
         LA    R15,FIRST4K                                              04130000
         CLC   DSNAME(*-*),CONTDSN-FIRST4K(R15)                         04131000
         EX    R1,*-6                     THIS DATA SET?                04132000
         BNE   CONT010                    NO, BRANCH                    04133000
         SPACE 1                                                        04134000
         MVI   ##ADRCM#,CONTINUE          FLAG TO CONTINUE              04135000
         MVI   VOLALLOC,X'40'             READ THE DSCB AGAIN           04136000
         BAL   R2,CLOSEIT                 CLOSE THE DCB                 04137000
         B     RESTART4                   OPEN THE DATA SET AGAIN       04138000
         SPACE 2                                                        04139000
CONT010  MESSAGE MSGBLANK          ONE BLANK LINE                       04140000
         MVC   INSERT#1(8),PDSNAME                                      04141000
         MVC   MTLEN,PDSNAML       Set insert length               @D01
         TSMSG L100$1                                                   04142000
         MVI   MTLEN,8             Restore standard length         @D01
         MESSAGE MSGBLANK          ONE BLANK LINE                       04143000
         SPACE 1                                                        04144000
         CLI   #OUT+0,1            ANY CONTROL OPERAND?                 04145000
         BL    CONT020             NO, BRANCH                           04146000
         BH    CONT012             YES, THE NO FORM                     04147000
         NI    FLAGSGG,FF-FALINCON YES FORM                             04148000
         B     CONT020                                                  04149000
CONT012  OI    FLAGSGG,FALINCON    NO FORM                              04150000
         SPACE 1                                                        04151000
CONT020  CLI   #OUT+1,1            ANY CONTROL OPERAND?                 04152000
         BL    CONT030             NO, BRANCH                           04153000
         BH    CONT022             YES, THE NO FORM                     04154000
**       NI    FLAGSGG,FF-FSAVEOP  YES FORM                        @D05 04155000
         NI    FLAGSGG,FF-FTRANCON YES FORM                        @D05
         B     CONT030                                                  04156000
**CONT022  OI    FLAGSGG,FSAVEOP     NO FORM                       @D05 04157000
CONT022  OI    FLAGSGG,FTRANCON    NO FORM                         @D05
         SPACE 1                                                        04158000
CONT030  CLI   #OUT+2,1            ANY CONTROL OPERAND?                 04159000
         BL    CONT040             NO, BRANCH                           04160000
         BH    CONT032             YES, THE NO FORM                     04161000
         NI    FLAGSGG,FF-FLKEDCON YES FORM                             04162000
         B     CONT040                                                  04163000
CONT032  OI    FLAGSGG,FLKEDCON    NO FORM                              04164000
         SPACE 1                                                        04165000
CONT040  CLI   #OUT+3,1            ANY CONTROL OPERAND?                 04166000
         BL    CONT050             NO, BRANCH                           04167000
         BH    CONT042             YES, THE NO FORM                     04168000
         NI    FLAGSGG,FF-FPROMCON YES FORM                             04169000
         B     CONT050                                                  04170000
CONT042  OI    FLAGSGG,FPROMCON    NO FORM                              04171000
         SPACE 1                                                        04172000
CONT050  CLI   #OUT+4,1            ANY CONTROL OPERAND?                 04173000
         BL    CONT060             NO, BRANCH                           04174000
         BH    CONT052             YES, THE NO FORM                     04175000
         NI    FLAGSGG,FF-FRECVCON YES FORM                             04176000
         B     CONT060                                                  04177000
CONT052  OI    FLAGSGG,FRECVCON    NO FORM                              04178000
         SPACE 1                                                        04179000
CONT060  CLI   #OUT+5,1            ANY CONTROL OPERAND?                 04180000
         BL    CONT100             NO, BRANCH                           04181000
         CLI   #OUT+5,2            ANY CONTROL OPERAND?                 04182000
         BE    CONT062             YES, THE NO FORM                     04183000
         NI    FLAGSEE,FF-FDOUBCON-FFULLTRK  YES FORM                   04184000
         XI    FLAGSEE,FDOUBCON    DOUBLE BUFFER FORM                   04185000
         CLI   #OUT+5,1            CONTROL DOUBLE?                      04186000
         BE    CONT100             YES, BRANCH                          04187000
         XI    FLAGSEE,FDOUBCON    NO, FULLTRACK REQUEST                04188000
         B     CONT100                                                  04189000
CONT062  OI    FLAGSEE,FDOUBCON+FFULLTRK     NO FORM                    04190000
         SPACE 2                                                        04191000
CONT100  MVI   MTHIGHL,100                                              04192000
         MVC   INSERT#1(132),MSGBL132+4                                 04193000
         LA    R1,INSERT#1-2       START OF GLOBAL TEXT                 04194000
         SPACE 1                                                        04195000
         TM    FLAGSGG,FALINCON    CONTROL NO FORM?                     04196000
         BNO   *+14                NO, BRANCH                           04197000
         MVC   2(L'CALINCON,R1),CALINCON                                04198000
         LA    R1,L'CALINCON(R1)                                        04199000
         SPACE 1                                                        04200000
         TM    FLAGSGG,FLKEDCON    CONTROL NO FORM?                     04201000
         BNO   *+14                NO, BRANCH                           04202000
         MVC   2(L'CLKEDCON,R1),CLKEDCON                                04203000
         LA    R1,L'CLKEDCON(R1)                                        04204000
         SPACE 1                                                        04205000
         TM    FLAGSGG,FPROMCON    CONTROL NO FORM?                     04206000
         BNO   *+14                NO, BRANCH                           04207000
         MVC   2(L'CPROMCON,R1),CPROMCON                                04208000
         LA    R1,L'CPROMCON(R1)                                        04209000
         SPACE 1                                                        04210000
         TM    FLAGSGG,FRECVCON    CONTROL NO FORM?                     04211000
         BNO   *+14                NO, BRANCH                           04212000
         MVC   2(L'CRECVCON,R1),CRECVCON                                04213000
         LA    R1,L'CRECVCON(R1)                                        04214000
         SPACE 1                                                   @D05
         TM    FLAGSGG,FTRANCON    CONTROL NO FORM?                @D05
         BNO   *+14                NO, BRANCH                      @D05
         MVC   2(L'CTRANCON,R1),CTRANCON                           @D05
         LA    R1,L'CTRANCON(R1)                                   @D05
         SPACE 1                                                        04215000
***TEST  TM    FLAGSGG,FSAVEOP     CONTROL NO FORM?                     04216000
***TEST  BNO   *+14                NO, BRANCH                           04217000
***TEST  MVC   2(L'CSAVECON,R1),CSAVECON                                04218000
***TEST  LA    R1,L'CSAVECON(R1)                                        04219000
         SPACE 2                                                        04220000
         TM    FLAGSGG,FALINCON    CONTROL YES FORM?                    04221000
         BNZ   *+14                NO, BRANCH                           04222000
         MVC   2(L'CALINCON-2,R1),CALINCON+2                            04223000
         LA    R1,L'CALINCON-2(R1)                                      04224000
         SPACE 1                                                        04225000
         TM    FLAGSGG,FLKEDCON    CONTROL YES FORM?                    04226000
         BNZ   *+14                NO, BRANCH                           04227000
         MVC   2(L'CLKEDCON-2,R1),CLKEDCON+2                            04228000
         LA    R1,L'CLKEDCON-2(R1)                                      04229000
         SPACE 1                                                        04230000
         TM    FLAGSGG,FPROMCON    CONTROL YES FORM?                    04231000
         BNZ   *+14                NO, BRANCH                           04232000
         MVC   2(L'CPROMCON-2,R1),CPROMCON+2                            04233000
         LA    R1,L'CPROMCON-2(R1)                                      04234000
         SPACE 1                                                        04235000
         TM    FLAGSGG,FRECVCON    CONTROL YES FORM?                    04236000
         BNZ   *+14                NO, BRANCH                           04237000
         MVC   2(L'CRECVCON-2,R1),CRECVCON+2                            04238000
         LA    R1,L'CRECVCON-2(R1)                                      04239000
         SPACE 1                                                   @D05
         TM    FLAGSGG,FTRANCON    CONTROL YES FORM?               @D05
         BNZ   *+14                NO, BRANCH                      @D05
         MVC   2(L'CTRANCON-2,R1),CTRANCON+2                       @D05
         LA    R1,L'CTRANCON-2(R1)                                 @D05
         SPACE 1                                                        04240000
**       TM    FLAGSGG,FSAVEOP     CONTROL YES FORM?               @D05 04241000
**       BNZ   *+14                NO, BRANCH                      @D05 04242000
**       MVC   2(L'CSAVECON-2,R1),CSAVECON+2                       @D05 04243000
**       LA    R1,L'CSAVECON-2(R1)                                 @D05 04244000
         SPACE 1                                                        04245000
         MVC   0(8,R1),BLANKS      DELETE THE LAST COMMA                04246000
         TSMSG L030$1                                                   04247000
         SPACE 2                                                        04248000
         MVC   INSERT#1(120),MSGBL132+4                                 04249000
         AIF   (&MVT).MA00420                                      @D01
         CLI   #OUT+13,X'02'              NODEST?                       04250000
         BE    *+12                       YES, BRANCH                   04251000
         CLI   #OUT+15,0                  ANY DEST?                     04252000
         BE    CONT112                    NO, BRANCH                    04253000
         MVC   CONTDEST(2),#OUT+14        DEST LENGTH                   04254000
         MVC   CONTDEST+2(8),#OUT+30      DEST                          04255000
         SPACE 1                                                        04256000
CONT112  CLI   #OUT+12,X'02'              NOFORM?                       04257000
         BE    *+12                       YES, BRANCH                   04258000
         CLI   #OUT+17,0                  ANY FORM?                     04259000
         BE    CONT114                    NO, BRANCH                    04260000
         MVC   CONTFORM(2),#OUT+16        DEST LENGTH                   04261000
         MVC   CONTFORM+2(4),#OUT+38      DEST                          04262000
         SPACE 1                                                        04263000
.MA00420 ANOP  ,                                                   @D01
CONT114  CLI   #OUT+10,0                  ANY SWITCHED LOG?             04264000
         BE    CONT116                    NO, BRANCH                    04265000
         MVC   CONTOPTN(1),#OUT+10        CURRENT OPTION                04266000
         AIF   (&MVT).MA00440                                      @D01
         CLI   CONTOPTN,X'02'             NOSYSOUT?                     04267000
         BNE   *+8                        NO, BRANCH                    04268000
         MVI   CONTOPTN,0                 YES, CONVERT TO NULL          04269000
.MA00440 ANOP  ,                                                   @D01
         CLI   CONTOPTN,X'04'             NODSNAME?                     04270000
         BNE   *+8                        NO, BRANCH                    04271000
         MVI   CONTOPTN,0                 YES, CONVERT TO NULL          04272000
         SPACE 2                                                        04273000
CONT116  CLI   CONTOPTN,X'03'             DSNAME?                       04274000
         BNE   CONT124                    NO, BRANCH                    04275000
         LA    R14,FIRST4K                BASE REGISTER                 04276000
         LA    R14,CONTDSN-FIRST4K(,R14)  POINT TO THE CONTDSN          04277000
         CLI   #OUT+19,0                  ANY DSNAME?                   04278000
         BE    CONT120                    NO, USE PREVIOUS              04279000
         MVC   0(60,R14),MSGBL132+4       BLANK CONTDSN                 04280000
         MVC   0(44,R14),#OUT+44          DSNAME                        04281000
         LH    R1,#OUT+18                 DSNAME LENGTH                 04282000
         LA    R15,0(R1,R14)              POINT TO START OF MEMBER      04283000
         CLI   #OUT+21,0                  ANY MEMBER?                   04284000
         BE    CONT118                    NO, BRANCH                    04285000
         MVI   0(R15),C'('                BEGINNING (                   04286000
         MVC   1(8,R15),#OUT+88           MEMBER NAME                   04287000
         AH    R15,#OUT+20                MEMBER LENGTH                 04288000
         MVI   1(R15),C')'                ENDING )                      04289000
         LA    R15,2(,R15)                CURRENT LENGTH OF NAME        04290000
         SPACE 1                                                        04291000
CONT118  MVI   0(R15),C')'                TO MATCH DSN( ...             04292000
         MVC   2(3,R15),CLOGSHR           SHR                           04293000
         CLI   #OUT+11,X'02'              CORRECT?                      04294000
         BE    CONT120                    YES, BRANCH                   04295000
         MVC   2(3,R15),CLOGMOD           MOD                           04296000
         CLI   #OUT+11,X'03'              CORRECT?                      04297000
         BE    CONT120                    YES, BRANCH                   04298000
         MVC   2(3,R15),CLOGNEW           NEW                           04299000
         CLI   #OUT+11,X'04'              CORRECT?                      04300000
         BE    CONT120                    YES, BRANCH                   04301000
         MVC   2(3,R15),CLOGOLD           OLD                           04302000
         SPACE 1                                                        04303000
CONT120  MVC   INSERT#1(7),CLOGDSN        DSNAME KEYWORD                04304000
         MVC   INSERT#1+7(60),0(R14)                                    04305000
         B     CONT129                                                  04306000
         SPACE 2                                                        04307000
CONT124  LA    R15,INSERT#1                                             04308000
         CLI   CONTOPTN,0                 ANY CURRENT OPTIONS?          04309000
         BH    CONT126                    YES, BRANCH                   04310000
         AIF   (&MVT).MA00480                                      @D01
         MVC   0(9,R15),CLOGNDSN          ADD NODSNAME,                 04311000
         LA    R15,10(,R15)                                             04312000
         MVC   0(9,R15),CLOGNSYS          ADD NOSYSOUT,                 04313000
         LA    R15,10(,R15)                                             04314000
         B     CONT127                                                  04315000
         AGO   .NA00480                                            @D01
.MA00480 ANOP  ,                                                   @D01
         MVC   0(8,R15),CLOGNDSN          ADD NODSNAME,            @D01
         LA    R15,8(,R15)                                         @D01
.NA00480 ANOP  ,                                                   @D01
         SPACE 1                                                        04316000
CONT126  DS    0H                                                  @D01
         AIF   (&MVT).MA00500                                      @D01
         MVC   0(7,R15),CLOGSYS           ADD SYSOUT(              @D01 04317000
         MVC   7(1,R15),CONTSYS           ADD SYSOUT CLASS              04318000
         MVC   8(2,R15),CLOGCOMM          ADD ),                        04319000
         LA    R15,11(,R15)                                             04320000
         SPACE 1                                                        04321000
CONT127  DS    0H                                                  @D01
         MVC   0(7,R15),CLOGNFOR          ADD NOFORM,              @D01 04322000
         CLI   CONTFORM+1,0               ANY FORM?                     04323000
         BNE   *+12                       YES, BRANCH                   04324000
         LA    R15,8(,R15)                                              04325000
         B     CONT128                                                  04326000
         MVC   0(5,R15),CLOGFOR           ADD FORM(                     04327000
         MVC   5(4,R15),CONTFORM+2        ADD FORM NAME                 04328000
         LH    R1,CONTFORM                LENGTH                        04329000
         LA    R15,5(R1,R15)                                            04330000
         MVC   0(2,R15),CLOGCOMM          ADD ),                        04331000
         LA    R15,3(R15)                                               04332000
         SPACE 1                                                        04333000
CONT128  MVC   0(6,R15),CLOGNDES          ADD NODEST,                   04334000
         CLI   CONTDEST+1,0               ANY DEST?                     04335000
         BE    CONT129                    NO, BRANCH                    04336000
         MVC   0(5,R15),CLOGDES           ADD DEST(                     04337000
         MVC   5(8,R15),CONTDEST+2        ADD DEST NAME                 04338000
         LH    R1,CONTDEST                LENGTH                        04339000
         LA    R15,5(R1,R15)                                            04340000
         MVI   0(R15),C')'                ADD )                         04341000
.MA00500 ANOP  ,                                                   @D01
         SPACE 2                                                        04342000
CONT129  DS    0H                                                       04343000
         TSMSG L030$1                                                   04344000
         MVC   INSERT#1(120),MSGBL132+4                                 04345000
         MVC   INSERT#1(8),CSINGCON       ASSUME SINGLE BUFFERING       04346000
         TM    FLAGSEE,FDOUBCON+FFULLTRK  CONTROL SINGLE?               04347000
         BO    CONT130                    YES, BRANCH                   04348000
         MVC   INSERT#1(8),CDOUBCON       ASSUME DOUBLE BUFFERING       04349000
         TM    FLAGSEE,FDOUBCON+FFULLTRK  CONTROL DOUBLE?               04350000
         BM    CONT130                    YES, BRANCH                   04351000
         MVC   INSERT#1(8),CMULTCON       READ MULTIPLE                 04352000
         SPACE 2                                                        04353000
CONT130  MVI   MTHIGHL,8                                                04354000
         TSMSG L031$1                                                   04355000
         MESSAGE MSGBLANK                 ONE BLANK LINE                04356000
         SPACE 2                                                        04357000
CONT134  TM    CONTOPTN,1                    ANY LOG RECORDING?         04358000
         BNO   CONT200                       NO, BRANCH                 04359000
         TM    DCBOFLGS-IHADCB+LOGDCB,X'10'  OPEN ALREADY               04360000
         BO    CONT200                       YES, BRANCH                04361000
***  ALLOCATE THE SYSOUT/DATA SET                                       04362000
         NI    FLAGSFF,FF-FLOGWRT            TURN OFF RECORD FLAG       04363000
         SPACE 1                                                        04364000
         AIF   (&MVT).MA00520                                      @D01
         XC    M99RBPTR(40),M99RBPTR    CLEAR THE WORK AREA             04365000
         LA    R1,M99RBPTR              DYNAMIC ALLOCATION              04366000
         USING S99RBP,R1                                                04367000
         SPACE 1                                                        04368000
         LA    R4,M99RB                                                 04369000
         USING S99RB,R4                                                 04370000
         ST    R4,S99RBPTR                                              04371000
         OI    S99RBPTR,S99RBPND        MARK END OF LIST                04372000
         SPACE 1                                                        04373000
         LA    R5,M99TUPL                                               04374000
         USING S99TUPL,R5                                               04375000
         MVI   S99RBLN,20               LENGTH 20                       04376000
         MVI   S99VERB,S99VRBAL         ALLOCATE                        04377000
         ST    R5,S99TXTPP              POINT TO TEXT POINTERS          04378000
         LA    R3,WORKTBL                        START OF TEXT          04379000
         SPACE 1                                                        04380000
         MVC   0(L'CONDDNAM,R3),CONDDNAM         SPECIFY DDNAME TEXT    04381000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04382000
         LA    R3,L'CONDDNAM(,R3)                START OF NEXT TEXT     04383000
         SPACE 1                                                        04384000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04385000
         MVC   0(L'CONDSORG,R3),CONDSORG         SPECIFY DSORG TEXT     04386000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04387000
         LA    R3,L'CONDSORG(,R3)                START OF NEXT TEXT     04388000
         SPACE 1                                                        04389000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04390000
         MVC   0(L'CONFREE,R3),CONFREE           SPECIFY FREE TEXT      04391000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04392000
         LA    R3,L'CONFREE(,R3)                 START OF NEXT TEXT     04393000
         SPACE 1                                                        04394000
CONT140  CLI   CONTOPTN,X'03'                    DSNAME ALLOCATION?     04395000
         BNE   CONT150                           NO, BRANCH             04396000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04397000
         MVC   0(L'CONDSNAM,R3),CONDSNAM         SPECIFY DSNAME TEXT    04398000
         MVC   6(44,R3),#OUT+44                  SPECIFY DSNAME         04399000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04400000
         LA    R3,L'CONDSNAM+44(,R3)             START OF NEXT TEXT     04401000
         SPACE 1                                                        04402000
         CLI   #OUT+88,X'41'                     ANY MEMBER?            04403000
         BL    CONT141                           NO, BRANCH             04404000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04405000
         MVC   0(L'CONMEMBR,R3),CONMEMBR         SPECIFY MEMBER TEXT    04406000
         MVC   6(8,R3),#OUT+88                   SPECIFY MEMBER         04407000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04408000
         LA    R3,L'CONMEMBR(,R3)                START OF NEXT TEXT     04409000
         SPACE 1                                                        04410000
CONT141  CLI   #OUT+96,X'41'                     ANY PASSWORD?          04411000
         BL    CONT142                           NO, BRANCH             04412000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04413000
         MVC   0(L'CONPASSW,R3),CONPASSW         SPECIFY PASSWORD TEXT  04414000
         MVC   6(8,R3),#OUT+96                   SPECIFY PASSWORD       04415000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04416000
         LA    R3,L'CONPASSW(,R3)                START OF NEXT TEXT     04417000
         SPACE 1                                                        04418000
CONT142  LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04419000
         MVC   0(L'CONALLOC,R3),CONALLOC         SPECIFY DISP TEXT      04420000
         CLI   #OUT+11,2                         SHR?                   04421000
         BNE   *+8                               NO, BRANCH             04422000
         MVI   6(R3),CONOSHR                     SPECIFY DISPOSITION    04423000
         CLI   #OUT+11,3                         MOD?                   04424000
         BNE   *+8                               NO, BRANCH             04425000
         MVI   6(R3),CONOMOD                     SPECIFY DISPOSITION    04426000
         CLI   #OUT+11,4                         NEW?                   04427000
         BNE   *+8                               NO, BRANCH             04428000
         MVI   6(R3),CONONEW                     SPECIFY DISPOSITION    04429000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04430000
         LA    R3,L'CONALLOC(,R3)                START OF NEXT TEXT     04431000
         SPACE 1                                                        04432000
         CLI   #OUT+11,3                         MOD OR NEW?            04433000
         BL    CONT149                           NO, BRANCH             04434000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04435000
         MVC   0(L'CONFIRST,R3),CONFIRST         SPECIFY PRIMARY        04436000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04437000
         LA    R3,L'CONFIRST(,R3)                START OF NEXT TEXT     04438000
         SPACE 1                                                        04439000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04440000
         MVC   0(L'CONSECON,R3),CONSECON         SPECIFY SECONDARY      04441000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04442000
         LA    R3,L'CONSECON(,R3)                START OF NEXT TEXT     04443000
         SPACE 1                                                        04444000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04445000
         MVC   0(L'CONTRK,R3),CONTRK             SPECIFY TRACK ALLOC    04446000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04447000
         LA    R3,L'CONTRK(,R3)                  START OF NEXT TEXT     04448000
         SPACE 1                                                        04449000
         CLI   #OUT+88,X'41'                     ANY MEMBER NAME?       04450000
         BL    CONT149                           NO, BRANCH             04451000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04452000
         MVC   0(L'CONDIR,R3),CONDIR             SPECIFY DIRECTORY BLKS 04453000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04454000
         LA    R3,L'CONDIR(,R3)                  START OF NEXT TEXT     04455000
         SPACE 1                                                        04456000
CONT149  LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04457000
         MVC   0(L'CONNORM,R3),CONNORM           SPECIFY DISP=(,CATLG)  04458000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04459000
         LA    R3,L'CONNORM(,R3)                 START OF NEXT TEXT     04460000
         SPACE 1                                                        04461000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04462000
         MVC   0(L'CONANORM,R3),CONANORM         SPECIFY DISP=(,,KEEP)  04463000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04464000
         B     CONT159                                                  04465000
         SPACE 1                                                        04466000
CONT150  CLI   CONTFORM+1,0                      ANY FORM?              04467000
         BZ    CONT152                           NO, BRANCH             04468000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04469000
         MVC   0(L'CONFORMS,R3),CONFORMS         SPECIFY FORMS TEXT     04470000
         MVC   6(4,R3),CONTFORM+2                SPECIFY FORM NAME      04471000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04472000
         LA    R3,L'CONFORMS(,R3)                START OF NEXT TEXT     04473000
         SPACE 1                                                        04474000
CONT152  CLI   CONTDEST+1,0                      ANY DEST?              04475000
         BZ    CONT154                           NO, BRANCH             04476000
         LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04477000
         MVC   0(L'CONDESTS,R3),CONDESTS         SPECIFY DEST TEXT      04478000
         MVC   6(8,R3),CONTDEST+2                SPECIFY DESTINATION    04479000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04480000
         LA    R3,L'CONDESTS(,R3)                START OF NEXT TEXT     04481000
         SPACE 1                                                        04482000
CONT154  LA    R5,4(,R5)                         NEXT POINTER ELEMENT   04483000
         MVC   0(L'CONSYSOU,R3),CONSYSOU         SPECIFY SYSOUT TEXT    04484000
         MVC   6(1,R3),CONTSYS                   SPECIFY SYSOUT CLASS   04485000
         ST    R3,S99TUPTR                       POINT TO TEXT UNIT     04486000
         SPACE 1                                                        04487000
CONT159  OI    S99TUPTR,X'80'                    MARK END OF LIST       04488000
         DYNALLOC                                                       04489000
         SPACE 2                                                        04490000
         DROP  R1,R4,R5                                                 04491000
         MVC   DDNAMEH,WORKTBL+6        SAVE DDNAME                     04492000
         LTR   R15,R15                  SUCCESSFUL?                     04493000
         BZ    CONT164                  YES, BRANCH                     04494000
         SPACE 2                                                        04495000
         LA    R14,M99RB                POINTER TO SVC 99 BLOCK         04496000
         ST    R15,DAIRRC               RETURN CODE                     04497000
         LA    R15,DAIRRC               POINTER TO RETURN CODE          04498000
         LA    R0,ADDRFF02              POINTER TO A(IKJEFF02)          04499000
         LA    R1,=AL2(DFSVC99)         POINTER TO INVOCATION TYPE      04500000
         L     R2,ADDRCPPL              POINTER TO THE CPPL             04501000
         STM   R14,R2,DFDAPLP           INITIALIZE DFDAPLP, DFDRCP,     04502000
*                                         DFJEFF02, DFIDP AND DFCPPLP   04503000
         AGO   .NA00520                                            @D01
.MA00520 ANOP  ,                                                   @D01
*----------------------------------------------------------------* @D01
*        Allocate the log file using DAIR.  The log file must    * @D01
*        be a disk data set; logging to SYSOUT is not supported  * @D01
*        in MVT.                                                 * @D01
*----------------------------------------------------------------* @D01
         XC    DAIR08,DAIR08       Zero DAIR X'08' parm block      @D01
         LA    R5,DAIR08           Point to parm block             @D01
         USING DAPB08,R5           Addressability for parm block   @D01
         MVC   DA08CD,=XL2'0008'   Set entry code = allocate       @D01
         MVC   DA08DDN,BLANKS      Blank DD name                   @D01
         MVC   DA08MNM,BLANKS      Assume no member name           @D01
         MVC   DA08PSWD,BLANKS     Assume no password              @D01
         MVC   DA08UNIT,BLANKS     Assume no unit                  @D01
         MVC   DA08SER,BLANKS      Assume no volser                @D01
         MVC   DAIRDSNT,#OUT+44    Copy data set name              @D01
         MVC   DAIRDSNL,=AL2(44)   Set data set name length        @D01
         LA    R3,DAIRDSN          Point to DSN key                @D01
         ST    R3,DA08PDSN         Set DSN pointer in parm block   @D01
         CLI   #OUT+88,X'41'       Any member name?                @D01
         BL    CONT141             Branch if no member             @D01
         MVC   DA08MNM,#OUT+88     Else put member in parm block   @D01
CONT141  CLI   #OUT+96,X'41'       Was password provided?          @D01
         BL    CONT142             Branch if no password           @D01
         MVC   DA08PSWD,#OUT+96    Else set password               @D01
CONT142  MVI   DA08DSP1,DA08OLD    Assume DISP=OLD                 @D01
         MVI   DA08DPS2,DA08KEEP   Assume normal disp KEEP         @D01
         MVI   DA08DPS3,DA08KEP    Assume conditional disp KEEP    @D01
         CLI   #OUT+11,2           DISP=SHR?                       @D01
         BNE   CONT143             Branch if not SHR               @D01
         MVI   DA08DSP1,DA08SHR    Else set DISP=SHR               @D01
         B     CONT146             Continue                        @D01
CONT143  CLI   #OUT+11,3           DISP=MOD?                       @D01
         BNE   CONT144             Branch if not MOD               @D01
         MVI   DA08DSP1,DA08MOD    Else set DISP=MOD               @D01
         MVI   DA08DPS2,DA08CAT    Set normal disp CATLG           @D01
         B     CONT146             Continue                        @D01
CONT144  CLI   #OUT+11,4           DISP=NEW?                       @D01
         BNE   CONT146             Branch if not NEW               @D01
         MVI   DA08DSP1,DA08NEW    Else set DISP=NEW               @D01
         MVI   DA08DPS2,DA08CAT    Set normal disp CATLG           @D01
CONT146  CLI   #OUT+11,3           Is disposition NEW or MOD?      @D01
         BL    CONT149             No, branch                      @D01
         LA    R3,DAIRDSN          Point to DSN key                @D01
         OI    DA08CTL,DA08TRKS    Show to allocate in tracks      @D01
         MVC   DA08PQTY,=AL4(1)    Primary allocation 1 track      @D01
         MVC   DA08SQTY,=AL4(4)    Secondary allocation 4 tracks   @D01
         CLI   #OUT+88,X'41'       Was member name provided?       @D01
         BL    CONT149             No, continue                    @D01
         MVC   DA08DQTY,=AL4(5)    Else specify 5 directory blocks @D01
CONT149  DS    0H                                                  @D01
         B     CONT159             Continue                        @D01
CONT159  DS    0H                                                  @D01
         LA    R1,PARMLIST         Point to DAIR parameter list    @D01
         USING DAPL,R1             Address of DAIR parameter list  @D01
         MVC   DAPLUPT,ADDRUPT     Set UPT address in parm list    @D01
         MVC   DAPLECT,ADDRECT     Set ECT address in parm list    @D01
         MVC   DAPLECB,ATTNECB     Set ECB address in parm list    @D01
         MVC   DAPLPSCB,ADDRPSCB   Set PSCB address in parm list   @D01
         XC    ATTNECB,ATTNECB     Clear ECB                       @D01
         ST    R5,DAPLDAPB         Set parm block address in plist @D01
         L     R15,ADDRDAIR        Get address of DAIR             @D01
         BALR  R14,R15             Go to DAIR                      @D01
         DROP  R1                  End parm list addressability    @D01
         MVC   DDNAMEH,DA08DDN     Save DD name                    @D01
         MVC   LOGDDN,DA08DDN      Save DD name for unallocated    @D01
         MVC   WORKTBL+14+6(1),DA08DSO  Save returned DSORG        @D01
         LTR   R15,R15             Was DAIR successful?            @D01
         BZ    CONT164             Branch if successful            @D01
         XC    DFPARM,DFPARM       Else zero DAIRFAIL parm list    @D01
         ST    R15,DAIRRC          Save DAIR return code           @D01
         LA    R15,PARMLIST        Point to DAIR parameter list    @D01
         ST    R15,DFDAPLP         Set DAPL address for DAIRFAIL   @D01
         LA    R15,DAIRRC          Point to address of return code @D01
         ST    R15,DFRCP           Set RC address for DAIRFAIL     @D01
         LA    R15,ADDRFF02        Point to address of IKJEFF02    @D01
         ST    R15,DFJEFF02        Put in DAIRFAIL parm list       @D01
         LA    R15,=AL2(DFDAIR)    Point to DAIRFAIL caller ID     @D01
         ST    R15,DFIDP           Set ID pointer for DAIRFAIL     @D01
         L     R15,ADDRCPPL        Get address of CPPL             @D01
         ST    R15,DFCPPLP         Set CPPL address for DAIRFAIL   @D01
         DROP  R5                  End parm block addressability   @D01
.NA00520 ANOP  ,                                                   @D01
         SPACE 1                                                        04504000
         LINK  EP=IKJEFF18,MF=(E,DFPARMS)                               04505000
         LTR   R15,R15                  PROBLEM WITH IKJEFF18?          04506000
         BZ    CONT162                  NO, BRANCH                      04507000
         SPACE 2                                                        04508000
         CVD   R15,DOUBLE                                               04509000
         MVI   MTHIGHL,4                                                04510000
         MVC   INSERT#1(4),=X'40202120'                                 04511000
         ED    INSERT#1(4),DOUBLE+6                                     04512000
         MVI   INSERT#1,C'='                                            04513000
         TSMSG L835$1                                                   04514000
         SPACE 1                                                        04515000
CONT162  MVI   CONTOPTN,0               TURN OFF LOGGING                04516000
         NI    FLAGSFF,FF-FLOGWRT       TURN OFF LOGGING                04517000
         B     CONT200                                                  04518000
         SPACE 2                                                        04519000
CONT164  CLI   CONTOPTN,X'03'           DSNAME ALLOCATION?              04520000
         BNE   CONT180                  NO, BRANCH                      04521000
         LA    R1,L781$1                ASSUME A LOGICAL ERROR          04522000
         CLI   WORKTBL+14+6,DS1DSGPO    PARTITIONED?                    04523000
         BNE   CONT166                  NO, BRANCH                      04524000
         CLI   #OUT+88,X'41'            ANY MEMBER NAME?                04525000
         BL    CONT190                  NO, ERROR                       04526000
         B     CONT180                                                  04527000
         SPACE 1                                                        04528000
CONT166  CLI   WORKTBL+14+6,DS1DSGPS    SEQUENTIAL?                     04529000
         BNE   CONT190                  NO, ERROR                       04530000
         CLI   #OUT+88,X'40'            ANY MEMBER NAME?                04531000
         BH    CONT190                  YES, ERROR                      04532000
         SPACE 2                                                        04533000
*** OPEN THE SYSOUT/DATA SET                                            04534000
CONT180  MVC   LOGDCB(LLOGDCB),LOGSDCB       CONSTRUCT A DCB            04535000
         MVC   DCBDDNAM-IHADCB+LOGDCB(8),DDNAMEH                        04536000
         MVI   OPENLIST,X'80'                                           04537000
         OPEN  (LOGDCB,(OUTPUT)),MF=(E,OPENLIST)                        04538000
         LA    R1,L780$1                                                04539000
         TM    DCBOFLGS-IHADCB+LOGDCB,X'10'  OPEN ALREADY               04540000
         BNO   CONT190                       NO, ERROR                  04541000
         TM    FLAGSFF,FLOGWRT               OPEN WITH GOOD VALUES?     04542000
         BO    CONT200                       YES, BRANCH                04543000
         MVI   OPENLIST,X'80'                                           04544000
         CLOSE (LOGDCB),MF=(E,OPENLIST)                                 04545000
         LA    R1,L781$1                     ERROR MESSAGE              04546000
CONT190  MVI   CONTOPTN,0                    TURN OFF ANY LOGGING       04547000
         MVC   INSERT#1(8),CTEXTLOG          LOGCOPY                    04548000
         B     MSGNEW                                                   04549000
         SPACE 2                                                        04550000
CONT200  CLI   #OUT+7,1            CPULOOP?                             04551000
         BNE   CONT300             NO, BRANCH                           04552000
         TSMSG L032                YES, LOOP MESSAGE                    04553000
         B     *                   LOOP                                 04554000
         SPACE 1                                                        04555000
CONT300  CLI   #OUT+7,2            ABEND?                               04556000
         BNE   CONT400             NO, BRANCH                           04557000
         TSMSG L033                YES, ABEND MESSAGE                   04558000
         DC    H'0'                LOOP                                 04559000
         SPACE 1                                                        04560000
CONT400  CLI   #OUT+7,3            OUTLOOP?                             04561000
         BNE   CONT500             NO, BRANCH                           04562000
         TSMSG L034                YES, LOOP MESSAGE                    04563000
         B     CONT400             LOOP                                 04564000
         SPACE 1                                                        04565000
CONT500  CLI   #OUT+7,4            MESSAGES?                            04566000
         BNE   CONT600             NO, BRANCH                           04567000
         MVC   INSERT#1(8),CTEXTP1                                      04568000
         MVC   INSERT#2(8),CTEXTP2                                      04569000
         LA    R4,L000             FIRST INFORMATIONAL MESSAGE          04570000
CONT510  LR    R1,R4               POINT TO IT                          04571000
         TSMSG (R1)                OUTPUT IT                            04572000
         LA    R4,3(,R4)           NEXT MESSAGE                         04573000
         CLI   0(R4),C'3'          DONE?                                04574000
         BNH   CONT510             NO, BRANCH                           04575000
         LA    R5,CONLIST          FIRST ACTION MESSAGE                 04576000
CONT520  L     R1,0(,R5)           POINT TO IT                          04577000
         MESSAGE (R1)              OUTPUT IT                            04578000
         LA    R5,4(,R5)           NEXT MESSAGE                         04579000
         CLI   0(R5),X'FF'         DONE?                                04580000
         BNE   CONT520             NO, BRANCH                           04581000
CONT530  LR    R1,R4               NEXT WARNING/ERROR MESSAGE           04582000
         TSMSG (R1)                OUTPUT IT                            04583000
         LA    R4,3(,R4)           NEXT MESSAGE                         04584000
         CLI   0(R4),C'9'          DONE?                                04585000
         BNH   CONT530             NO, BRANCH                           04586000
         SPACE 1                                                        04587000
CONT600  CLI   #OUT+7,5            IOSTATS DESIRED?                     04588000
         BNE   CONT700             NO, BRANCH                           04589000
         LH    R1,IODONE           ** INPUT ROUTINE ENTRIES             04590000
         LA    R14,MSGCOA1                                              04591000
         BAL   R2,CONT900                                               04592000
         LH    R1,IODONEW          ** NUMBER OF TTR CHANGES             04593000
         LA    R14,MSGCOA2                                              04594000
         BAL   R2,CONT900                                               04595000
         LH    R1,IOLOGUSE         ** LOGICAL INPUTS PERFORMED          04596000
         LA    R14,MSGCOA3                                              04597000
         BAL   R2,CONT900                                               04598000
         LH    R1,IOPHYTRK         ** PHYSICAL TRACKS READ              04599000
         LA    R14,MSGCOA4                                              04600000
         BAL   R2,CONT900                                               04601000
         XC    IODONE(8),IODONE                                         04602000
         SPACE 1                                                        04603000
CONT700  CLI   #OUT+7,6            TESTREAD?                            04604000
         BNE   NEWCMD              NO, BRANCH                           04605000
         MVC   #OUT+20(1),FLAGSEE         SAVE THE INPUT FLAGS          04606000
         MESSAGE MSGBLANK                 ONE BLANK LINE                04607000
         MVC   INSERT#1(8),CSINGCON       SINGLE BUFFERING              04608000
         TSMSG L031$1                                                   04609000
         OI    FLAGSEE,FDOUBCON+FFULLTRK  CONTROL SINGLE                04610000
         BAL   R2,CONT710                 READ THE FIRST RECORD         04611000
         SPACE 1                                                        04612000
         MVC   INSERT#1(8),CDOUBCON       DOUBLE BUFFERING              04613000
         TSMSG L031$1                                                   04614000
         XI    FLAGSEE,FDOUBCON           CONTROL DOUBLE                04615000
         BAL   R2,CONT710                 READ THE FIRST RECORD         04616000
         SPACE 1                                                        04617000
         MVC   INSERT#1(8),CMULTCON       DOUBLE BUFFERING              04618000
         TSMSG L031$1                                                   04619000
         NI    FLAGSEE,FF-FDISKTRK-FFULLTRK-FDOUBCON                    04620000
         BAL   R2,CONT710                 READ THE FIRST RECORD         04621000
         MVC   FLAGSEE(1),#OUT+20         RESET THE INPUT FLAGS         04622000
         B     NEWCMD                                                   04623000
         SPACE 2                                                        04624000
CONT710  MVI   STARTTR+2,1                SET TTR TO 1                  04625000
         L     R15,=A(EXCP)               INPUT IT                      04626000
         BALR  R14,R15                                                  04627000
         CVD   R15,DOUBLE                 CONVERT RETURN CODE           04628000
         MVC   INSERT#1(8),BLANKS                                       04629000
         MVC   INSERT#1-2(4),=X'40212020' EDIT CHARACTERS               04630000
         ED    INSERT#1-2(4),DOUBLE+6     CONVERT TO DISPLAY            04631000
         STM   R2,R12,28(R13)             CONVERT CCHHR TO TTR          04632000
         LA    R2,IOBSEEK                 NEXT MBBCCHHR                 04633000
         L     R1,INDCB+(DCBDEBAD-IHADCB)                               04634000
         L     R15,ADDRRLTV                                             04635000
         LR    R3,R13                                                   04636000
         BALR  R14,R15                                                  04637000
         LR    R13,R3                                                   04638000
         LM    R2,R12,28(R13)                                           04639000
         ST    R0,FULLWORD                TTR OF CURRENT DIRECTORY EOF  04640000
         UNPK  INSERT#2(7),FULLWORD(4)                                  04641000
         TR    INSERT#2(6),TRTABLE                                      04642000
         MVC   INSERT#2+6(2),BLANKS                                     04643000
         TSMSG L035$2                                                   04644000
         MESSAGE MSGBLANK                 ONE BLANK LINE                04645000
         BR    R2                                                       04646000
         SPACE 2                                                        04647000
CONT900  MVC   MSGTEXT1,0(R14)                                          04648000
         MVC   MSGTEXT1+4(7),MSGCOAM                                    04649000
         LTR   R1,R1                                                    04650000
         BZR   R2                                                       04651000
         CVD   R1,DOUBLE                                                04652000
         ED    MSGTEXT1+4(7),DOUBLE+5                                   04653000
         MESSAGE MSGTEXT1                                               04654000
         BR    R2                                                       04655000
         SPACE 4                                                        04656000
         USING IHADCB,R1                                                04657000
*** DCB OPEN EXIT                                                       04658000
CONT980  CLC   DCBDSORG(2),ZERO              ANY DSORG?                 04659000
         BNE   *+8                           YES, BRANCH                04660000
         OI    DCBDSORG,DS1DSGPS             NO, USE DSORG=PS           04661000
         TM    DCBDSORG,DS1DSGPS             DSORG=PS?                  04662000
         BNOR  R14                           NO, ERROR                  04663000
         CLI   DCBRECFM,0                    ANY RECFM?                 04664000
         BNE   *+8                           YES, BRANCH                04665000
         MVI   DCBRECFM,DCBRECF+DCBRECBR     NO, USE RECFM=FB           04666000
         TM    DCBRECFM,DCBRECF+DCBRECV      RECFM=F. OR RECFM=V.?      04667000
         BNMR  R14                           NO, ERROR                  04668000
         LA    R0,80                         DEFAULT LRECL              04669000
         TM    DCBRECFM,DCBRECV              RECFM=V.?                  04670000
         BNO   *+8                           NO, BRANCH                 04671000
         LA    R0,255                        DEFAULT LRECL FOR VARIABLE 04672000
         CLC   DCBLRECL(2),ZERO              ANY LRECL?                 04673000
         BNE   *+8                           YES, BRANCH                04674000
         STH   R0,DCBLRECL                   NO, USE LRECL=80           04675000
         TM    DCBRECFM,DCBRECV              RECFM=V.?                  04676000
         BO    CONT988                       YES, BRANCH                04677000
         CH    R0,DCBLRECL                   LRECL=80?                  04678000
         BNER  R14                           NO, ERROR                  04679000
CONT988  LA    R0,3120                       DEFAULT BLKSIZE            04680000
         CLC   DCBBLKSI(2),ZERO              ANY BLKSIZE?               04681000
         BNE   *+8                           YES, BRANCH                04682000
         STH   R0,DCBBLKSI                   NO, USE BLKSIZE=3120       04683000
         OI    FLAGSFF,FLOGWRT               ALL ATTRIBUTES ARE CORRECT 04684000
         BR    R14                                                      04685000
         DROP  R1                                                       04686000
         SPACE 2                                                        04687000
         PRINT NOGEN                                                    04688000
LOGSDCB  DCB   DSORG=PS,DDNAME=PDSLOG,MACRF=(PM),EXLST=CONT990          04689000
LLOGDCB  EQU   *-LOGSDCB                                                04690000
         PRINT GEN                                                      04691000
         SPACE 2                                                        04692000
CONT990  DC    0F'0',X'85',AL3(CONT980)      OPEN EXIT ONLY             04693000
         PRINT NOGEN                                                    04694000
MSGCOA1  MSG   ' 12,345 INPUT ROUTINE ENTRIES'                          04695000
         ORG   MSGCOA1+4                                                04696000
MSGCOAM  DC    X'4020206B202120'                                        04697000
         ORG   ,                                                        04698000
MSGCOA2  MSG   ' 12,345 TTR CHANGES'                                    04699000
MSGCOA3  MSG   ' 12,345 LOGICAL INPUTS PERFORMED'                       04700000
MSGCOA4  MSG   ' 12,345 PHYSICAL TRACKS READ'                           04701000
         PRINT GEN                                                      04702000
CALINCON DC    C'NOALIASINFO, '                                         04703000
CLKEDCON DC    C'NOLKEDDATE, '                                          04704000
CPROMCON DC    C'NOPROMPT, '                                            04705000
CRECVCON DC    C'NORECOVER, '                                           04706000
CTRANCON DC    C'NOTRANSLATOR, '                                   @D05
CSAVECON DC    C'NOSAVETEXT, '                                          04707000
CSINGCON DC    CL8'SINGLE'                                              04708000
CDOUBCON DC    CL8'DOUBLE'                                              04709000
CMULTCON DC    CL8'MULTIPLE'                                            04710000
CTEXTP1  DC    CL8'<PARM#1>'                                            04711000
CTEXTP2  DC    CL8'<PARM#2>'                                            04712000
CTEXTLOG DC    CL8'LOGCOPY'                                             04713000
CLOGOLD  DC    CL3'OLD'                                                 04714000
CLOGMOD  DC    CL3'MOD'                                                 04715000
CLOGSHR  DC    CL3'SHR'                                                 04716000
CLOGNEW  DC    CL3'NEW'                                                 04717000
CLOGDSN  DC    CL7'DSNAME('                                             04718000
CLOGNDSN DC    CL9'NODSNAME,'                                           04719000
CLOGSYS  DC    CL7'SYSOUT('                                             04720000
CLOGNSYS DC    CL9'NOSYSOUT,'                                           04721000
CLOGFOR  DC    CL5'FORM('                                               04722000
CLOGNFOR DC    CL7'NOFORM,'                                             04723000
CLOGDES  DC    CL5'DEST('                                               04724000
CLOGNDES DC    CL6'NODEST'                                              04725000
CLOGCOMM DC    CL2'),'                                                  04726000
CONLIST  DC    A(PDS300A)                                               04727000
         DC    A(PDS380A,PDS381A,PDS382A,PDS383A,PDS384A,PDS385A)       04728000
         DC    A(PDS390A,PDS391A,PDS392A,PDS393A,PDS394A),X'FF'         04729000
         SPACE 2                                                        04730000
         AIF   (&MVT).MA00540                                      @D01
CONDDNAM DC    X'0055000100084040404040404040'     RETURN DDNAME        04731000
CONDSORG DC    X'0057000100024040'                 RETURN DSORG         04732000
CONFREE  DC    X'001C0000'                         FREE=CLOSE           04733000
CONMEMBR DC    X'0003000100084040404040404040'     DSNAME               04734000
CONPASSW DC    X'0050000100084040404040404040'     PASSWORD             04735000
CONDSNAM DC    X'00020001002C'                     DSNAME               04736000
CONALLOC DC    X'00040001000101'                   DISP=(_)             04737000
CONNORM  DC    X'00050001000102'                   DISP=(,CATLG)        04738000
CONANORM DC    X'00060001000108'                   DISP=(,,KEEP)        04739000
CONTRK   DC    X'00070000'                         SPACE=(TRK,          04740000
CONFIRST DC    X'000A00010003000001'               SPACE=(,1            04741000
CONSECON DC    X'000B00010003000004'               SPACE=(,,4           04742000
CONDIR   DC    X'000C00010003000005'               SPACE=(,,,5)         04743000
.MA00540 ANOP  ,                                                   @D01
CONOOLD  EQU   X'01'                                                    04744000
CONOMOD  EQU   X'02'                                                    04745000
CONONEW  EQU   X'04'                                                    04746000
CONOSHR  EQU   X'08'                                                    04747000
         AIF   (&MVT).MA00560                                      @D01
CONSYSOU DC    X'001800010001C1'                   SYSOUT=A             04748000
CONFORMS DC    X'001A00010004C4F1F0F1'             SYSOUT=(,,D101)      04749000
CONDESTS DC    X'005800010008D5F1F3F040404040'     DEST=R130            04750000
.MA00560 ANOP  ,                                                   @D01
         TITLE 'P D S  --  PDS DELETE                          1/15/85' 04751000
*********************************************************************** 04752000
***    DELETE SUBCOMMAND    MODIFIED BY BRUCE LELAND -- OCT., 1983  *** 04753000
*********************************************************************** 04754000
*                                                                       04755000
         SPACE 1                                                        04756000
DELETE   CSECT                                                          04757000
         USING *,R8                                                     04758000
         LA    R1,L530             ASSUME A NON-PARTITIONED DATA SET    04759000
         TM    DSORG,DS1DSGPO            CORRECT?                       04760000
         BZ    MSGNEW                    YES, BRANCH                    04761000
         SPACE 2                                                        04762000
         NI    FLAGSCC,FF-FBLDLOK        BLDL IS INVALIDATED            04763000
         TM    FLAGSII,FSINGLE           IF OR FIND THEN(DELETE)?       04764000
         BNO   DELE010                   NO, BRANCH                     04765000
         MVC   IODIR1+4+12+00(8),CURDIR  RESET READ ADDRESS             04766000
         MVI   IODIR1+4+12+08,X'08'      RESET KEY LENGTH               04767000
         MVC   IODIR1+4+12+09(2),=H'256' RESET DATA LENGTH              04768000
         MVI   IODIR1+4+12+11,0          RESET SECTOR ADDRESS TO ZERO   04769000
         MVI   IOECB,X'7F'               LAST READ WAS OK               04770000
         B     DELE100                   PROMPT BY DEFAULT              04771000
         SPACE 1                                                        04772000
DELE010  TM    FLAGSAA,FMEM#MEM      MEMBER GROUP?                      04773000
         BO    DELE200               YES, BRANCH                        04774000
         MVC   MEMNAME(12),DIRNAME   ENSURE MEMBER NAME IS PRESENT      04775000
         OI    #DELFLAG,#DELONE      ONLY A SINGLE MEMBER               04776000
         TM    #DELFLAG,#DELASS2     DELETE ASSOCIATES TOO?             04777000
         BO    DELE200               YES, BRANCH                        04778000
         SPACE 1                                                        04779000
         TM    FLAGSAA,FMEMSTAR      ASTERISK NOTATION?                 04780000
         BO    DELE110               YES, NO PROMPTING                  04781000
         TM    FLAGSAA,FOPTIONS      ANY MEMBER NAME?                   04782000
         BO    DELE110               YES, NO PROMPTING                  04783000
         SPACE 2                                                        04784000
DELE100  LA    R1,PDS393A            DELETE SINGLE MEMBER               04785000
         BAL   R2,YESNO              PROMPT FOR YES OR NO               04786000
         B     NEWCMD                NO -- DONE                         04787000
         SPACE 1                                                        04788000
DELE110  LA    R4,DIRNAME            DUMMY ARRAY ENTRY                  04789000
         ST    R4,#MEMPTR                                               04790000
         LA    R4,16(,R4)            POSITION FOR ONE ENTRY             04791000
         MVC   DSNMEMQ(8),DIRNAME    MEMBER NAME                        04792000
         BAL   R2,ENQMTEST           MEMBER IN USE?                     04793000
         B     NEWCMD                YES, IGNORE THE COMMAND            04794000
         B     DELE900               NO, DELETE IT                      04795000
         SPACE 3                                                        04796000
DELE200  OI    FLAGSII,FDIRGRP       SIMULATE MEMBER GROUP INPUT        04797000
         NI    FLAGSAA,FF-FMEM#MEM   TURN OFF MEMBER GROUPS NOW         04798000
         OI    FLAGSBB,FLINESET      LINE NOW IN PROGRESS               04799000
         LA    R1,80                 ASSUME AN ACTIVE MODE              04800000
         AIF ('&CISP' EQ 'NO SPF').MA00580                         @D01
         TM    SPFLAG0,SPFDON        ISPMODE ACTIVE?                    04801000
         BO    DELE202               YES, BRANCH                        04802000
.MA00580 ANOP  ,                                                   @D01
         TM    CONTOPTN,1            ANY LOG RECORDING?                 04803000
         BO    DELE202               YES, BRANCH                        04804000
         GTSIZE
         CH    R1,=H'120'            120 OR LESS BYTES?                 04806000
         BL    *+8                   YES, BRANCH                        04807000
         LH    R1,=H'120'            NO, USE 120 BYTES                  04808000
DELE202  SH    R1,=H'7'              LESS SEVEN FOR PREFIX              04809000
         ST    R1,LINESIZE           CHARACTERS/LINE                    04810000
         MVC   MSGLINE+4(L'MSGDELET),MSGDELET                           04811000
         LA    R6,MSGLINE+4+L'MSGDELET                                  04812000
         MVC   FULLWORD(3),L162$1    MEMBERS TO BE DELETED              04813000
         NI    FLAGSBB,FF-FLINESET   NO LINE IN PROGRESS                04814000
         MVI   SUBPOOLT,21           SUBPOOL 21 DATA                    04815000
         LA    R5,256/2              256 MEMBERS INITIALLY              04816000
         SPACE 1                                                        04817000
DELE210  SLL   R5,1                  MEMBERS*2 FOR EACH LOOP            04818000
         LR    R3,R5                                                    04819000
         LR    R0,R5                                                    04820000
         SLL   R0,4                  TABLE SIZE=MEMBERS*16              04821000
         ICM   R0,B'1000',SUBPOOLT                                      04822000
         GETMAIN R,LV=(0)                                               04823000
         LR    R4,R1                 NEW TABLE ADDRESS                  04824000
         ICM   R0,B'1111',#MEMPTR    ANY PREVIOUS MEMBERS?              04825000
         BNZ   DELE220               YES, BRANCH                        04826000
         ST    R4,#MEMPTR            INITIALIZE MEMBER BASE             04827000
         B     DELE500                                                  04828000
         SPACE 1                                                        04829000
DELE220  SRL   R3,1                  SECOND HALF OF TABLE (# MEMBERS)   04830000
         LR    R14,R4                NEW TABLE START ADDRESS            04831000
         LR    R15,R5                                                   04832000
         SLL   R15,3                 OLD TABLE SIZE=MEMBERS*8           04833000
         LR    R2,R15                START OF NEW PART                  04834000
         LR    R1,R15                                                   04835000
         MVCL  R14,R0                PRESERVE THE OLD TABLE             04836000
         L     R1,#MEMPTR                                               04837000
         LR    R0,R2                 LENGTH TO FREE                     04838000
         ICM   R0,B'1000',SUBPOOLT   SUBPOOL TO FREE                    04839000
         FREEMAIN R,LV=(0),A=(1)                                        04840000
         ST    R4,#MEMPTR            START OF NEW TABLE                 04841000
         AR    R4,R2                 WHERE TO ADD MEMBERS               04842000
         SPACE 3                                                        04843000
DELE300  BAL   R14,READDIR           GET NEXT DIRECTORY ENTRY           04844000
         B     DELE600               END OF MEMBERS -- BRANCH           04845000
         SPACE 1                                                        04846000
         TM    #DELFLAG,#DELASSP     ASSOCIATES PHASE?                  04847000
         BO    DELE400               YES, BRANCH                        04848000
         SPACE 1                                                        04849000
         TM    FLAGSAA,FMEMRANG      MEMBER NAME RANGE?                 04850000
         BNO   DELE340               NO, BRANCH                         04851000
         TM    FLAGSAA,FMEMBER1      START ENTRY SPECIFIED?             04852000
         BNO   DELE330               NO, BRANCH                         04853000
         SPACE 1                                                        04854000
         LH    R15,LMEMBER1          MACHINE LENGTH OF THE MEMBER NAME  04855000
         CLC   MEMBER1(*-*),MEMNAME  <<EXECUTED>>                       04856000
         EX    R15,*-6               ABOVE THIS VALUE?                  04857000
         BH    DELE300               YES, BRANCH                        04858000
         XI    FLAGSAA,FMEMBER1      FIRST NAME IS SATISFIED            04859000
         SPACE 2                                                        04860000
DELE330  TM    FLAGSAA,FMEMBER2      END ENTRY SPECIFIED?               04861000
         BNO   DELE500               NO, BRANCH                         04862000
         SPACE 1                                                        04863000
         LH    R15,LMEMBER2          MACHINE LENGTH OF THE MEMBER NAME  04864000
         CLC   MEMBER2(*-*),MEMNAME  <<EXECUTED>>                       04865000
         EX    R15,*-6               BELOW THIS VALUE?                  04866000
         BL    DELE600               YES, BRANCH                        04867000
         B     DELE500                                                  04868000
         SPACE 3                                                        04869000
DELE340  LH    R15,LMEMBER1          MACHINE LENGTH OF THIS PATTERN     04870000
         LA    R1,8                  MAXIMUM PATTERN LENGTH             04871000
         SR    R1,R15                COMPARE LENGTH                     04872000
         LA    R14,MEMNAME           POSITION IN MEMBER NAME            04873000
         CLC   0(*-*,R14),MEMBER1    <<EXECUTED>>                       04874000
DELE350  EX    R15,*-6               IN THIS MEMBER NAME?               04875000
         BE    DELE360               YES, BRANCH                        04876000
         LA    R14,1(,R14)                                              04877000
         BCT   R1,DELE350            MAYBE, CHECK ALL OTHER POSITIONS   04878000
         B     DELE300               NO, IGNORE THIS ENTRY              04879000
         SPACE 2                                                        04880000
DELE360  TM    FLAGSAA,FMEMBER2      A SECOND PATTERN TOO?              04881000
         BNO   DELE500               NO, USE THIS ENTRY                 04882000
         LH    R15,LMEMBER2          MACHINE LENGTH OF THIS PATTERN     04883000
         LA    R1,8                  MAXIMUM PATTERN LENGTH             04884000
         SR    R1,R15                COMPARE LENGTH                     04885000
         LA    R14,MEMNAME           POSITION IN MEMBER NAME            04886000
         CLC   0(*-*,R14),MEMBER2    <<EXECUTED>>                       04887000
DELE370  EX    R15,*-6               IN THIS MEMBER NAME?               04888000
         BE    DELE500               YES, BRANCH                        04889000
         LA    R14,1(,R14)                                              04890000
         BCT   R1,DELE370            MAYBE, CHECK ALL OTHER POSITIONS   04891000
         B     DELE300               NO, IGNORE THIS ENTRY              04892000
         SPACE 3                                                        04893000
DELE400  L     R1,#MEMPTR            START OF MEMBER LIST               04894000
         B     DELE410+4             SKIP FIRST ADD                     04895000
DELE410  LA    R1,16(,R1)            NEXT TABLE ENTRY                   04896000
         CR    R1,R4                 END OF TABLE?                      04897000
         BNL   DELE300               YES, IGNORE THIS ENTRY             04898000
         CLC   8(3,R1),MEMTTR        MATCHING TTR?                      04899000
         BNE   DELE410               NO, BRANCH                         04900000
         SPACE 3                                                        04901000
         L     R1,#MEMPTR            START OF MEMBER LIST               04902000
         B     DELE430+4             SKIP FIRST ADD                     04903000
DELE430  LA    R1,16(,R1)            NEXT TABLE ENTRY                   04904000
         CR    R1,R4                 END OF TABLE?                      04905000
         BNL   DELE500               YES, ADD THIS ENTRY                04906000
         CLC   0(8,R1),MEMNAME       FIND MYSELF?                       04907000
         BE    DELE300               YES, IGNORE THIS ENTRY             04908000
         B     DELE430               NO, CONTINUE SEARCHING             04909000
         SPACE 3                                                        04910000
DELE500  MVC   DSNMEMQ(8),MEMNAME                                       04911000
         BAL   R2,ENQMTEST           MEMBER IN USE?                     04912000
         OI    #DELFLAG,#DELENQ      YES, MARK TO EXIT LATER            04913000
         SPACE 1                                                        04914000
         LA    R2,MEMNAME+7                                             04915000
         TM    FLAGSBB,FLINESET      LINE IN PROGRESS?                  04916000
         BO    DELE510               YES, BRANCH                        04917000
         OI    FLAGSBB,FLINESET      LINE NOW IN PROGRESS               04918000
DELE510  CLI   0(R2),X'40'           SCAN                               04919000
         BNE   *+8                       FOR LAST                       04920000
         BCT   R2,DELE510                        NON-BLANK              04921000
         LA    R0,MEMNAME                                               04922000
         SR    R2,R0                                                    04923000
         BNM   *+6                                                      04924000
         SR    R2,R2                                                    04925000
         LA    R15,2(R6,R2)                                             04926000
         LA    R1,MSGLINE                                               04927000
         SR    R15,R1                                                   04928000
         C     R15,LINESIZE          FIT ON THIS OUTPUT LINE?           04929000
         BNH   DELE520               YES, BRANCH                        04930000
         LA    R1,MSGLINE+4                                             04931000
         SR    R6,R1                                                    04932000
         STC   R6,MTHIGHL                                               04933000
         MVC   INSERT#1(127),MSGLINE+4                                  04934000
         LA    R1,FULLWORD                                              04935000
         TSMSG (R1)                                                     04936000
         MVI   MTHIGHL,8                                                04937000
         MVI   FULLWORD+2,C'9'                                          04938000
         LA    R6,MSGLINE+3          INDENT FOR BLANKS                  04939000
         SPACE 1                                                        04940000
DELE520  MVI   0(R6),X'40'                                              04941000
         MVC   1(8,R6),MEMNAME                                          04942000
         TR    1(8,R6),TRLINE        MAKE PRINTABLE                     04943000
         LA    R1,2(R2,R6)                                              04944000
         MVI   0(R1),C','            ADD A COMMA                        04945000
         LA    R6,3(R2,R6)                                              04946000
         MVC   0(16,R4),MEMNAME      ADD TO THE TABLE                   04947000
         LA    R4,16(,R4)            NEXT MEMBER POSITION               04948000
         S     R3,=F'1'              ANY MORE FIT?                      04949000
         BNP   DELE210               NO, BRANCH                         04950000
         TM    #DELFLAG,#DELONE      A SINGLE MEMBER?                   04951000
         BNO   DELE300               NO, BRANCH                         04952000
         SPACE 3                                                        04953000
DELE600  TM    FLAGSBB,FLINESET      ANY MEMBERS FOUND?                 04954000
         BNO   DELE610               NO, BRANCH                         04955000
         LA    R1,MSGLINE+5                                             04956000
         SR    R6,R1                                                    04957000
         STC   R6,MTHIGHL                                               04958000
         MVC   INSERT#1(127),MSGLINE+4                                  04959000
         LA    R1,FULLWORD                                              04960000
         TSMSG (R1)                                                     04961000
         MVI   MTHIGHL,8                                                04962000
         MESSAGE MSGBLANK                                               04963000
         SPACE 1                                                        04964000
DELE610  TM    #DELFLAG,#DELASSP     ASSOCIATES PHASE STARTED?          04965000
         BO    DELE700               YES, BRANCH                        04966000
         TM    #DELFLAG,#DELASS2     DELETE ASSOCIATE MEMBERS TOO?      04967000
         BNO   DELE700               NO, BRANCH                         04968000
         OI    #DELFLAG,#DELASSP     YES, ASSOCIATES PHASE STARTED      04969000
         NI    #DELFLAG,FF-#DELONE   WANT ALL ASSOCIATED MEMBERS        04970000
         NI    FLAGSII,FF-FDIRGRP    NORMAL INPUT NOW                   04971000
         NI    FLAGSBB,FF-FLINESET   NEW OUTPUT LINE                    04972000
         MVC   MSGLINE+4(L'MSGDELAS),MSGDELAS                           04973000
         LA    R6,MSGLINE+4+L'MSGDELAS                                  04974000
         MVC   FULLWORD(3),L163$1    MEMBERS TO BE DELETED              04975000
         MVI   STARTTR+2,X'01'       TTR=000001 (START OF DIRECTORY)    04976000
         B     DELE300               DO ANY ASSOCIATED MEMBERS          04977000
         SPACE 3                                                        04978000
DELE700  NI    FLAGSII,FF-FDIRGRP    NORMAL INPUT NOW                   04979000
         TM    #DELFLAG,#DELENQ      ANY MEMBERS IN USE?                04980000
         BO    NEWCMD                YES, BRANCH                        04981000
         SPACE 1                                                        04982000
         LA    R1,PDS394A            DELETE PROMPT MESSAGE              04983000
         BAL   R2,YESNO              PROMPT FOR YES OR NO               04984000
         B     NEWCMD                NO, QUIT                           04985000
         SPACE 2                                                        04986000
DELE900  BAL   R2,OPENSTOW           OPEN STOW DCB; ENQUEUE             04987000
         B     NEWCMD                NO OPEN -- QUIT                    04988000
         SPACE 1                                                        04989000
         L     R3,#MEMPTR            START OF MEMBER LIST               04990000
         B     DELE910+4             SKIP FIRST ADD                     04991000
DELE910  LA    R3,16(,R3)                                               04992000
         CR    R3,R4                                                    04993000
         BNL   DELE980                                                  04994000
         STOW  STOWDCB,0(R3),D       ISSUE STOW WITH DELETE OPTION      04995000
         SPACE 1                                                        04996000
         B     *+4(R15)              PROCESS RETURN CODE                04997000
         B     DELE940                 00 - SUCCESSFUL                  04998000
         EX    0,*                     04 - SHOULD NOT OCCUR            04999000
         B     DELE960                 08 - MEMBER NOT FOUND            05000000
         B     IOERROR                 12 - I/O ERROR IN DIRECTORY      05001000
         SPACE 1                                                        05002000
DELE940  MVC   INSERT#1(8),0(R3)                                        05003000
         TSMSG L040$1                                                   05004000
         B     DELE910                                                  05005000
         SPACE 1                                                        05006000
DELE960  MVC   INSERT#1(8),0(R3)                                        05007000
         TSMSG L853$1                                                   05008000
         B     DELE910                                                  05009000
         SPACE 1                                                        05010000
DELE980  BAL   R2,SHUTSTOW            CLOSE FOR: IF * THEN(DELETE)      05011000
         B     NEWCMD                                                   05012000
         SPACE 2                                                        05013000
#DELASSP EQU     X'80'            DELETE: ASSOCIATES PHASE OF DELETE    05014000
#DELONE  EQU     X'10'            DELETE: DELETE A SINGLE MEMBER        05015000
#DELENQ  EQU     X'08'            DELETE: A DELETE MEMBER IS "IN USE"   05016000
#DELASS2 EQU     X'01'            DELETE: DELETE ASSOCIATES TOO         05017000
         TITLE 'P D S  --  PDS DSNAME                          1/15/85' 05018000
*********************************************************************** 05019000
***      DSNAME  SUBCOMMAND                                         *** 05020000
*********************************************************************** 05021000
*                                                                       05022000
         SPACE 1                                                        05023000
DSNAMES  CSECT                                                          05024000
         BALR  R6,0                                                     05025000
         USING *,R6                                                     05026000
         MVC   INSERT#1(80),MSGBL132+4  BLANK THE FIRST LINE            05027000
         MVI   MTHIGHL,80               80 CHARACTER MESSAGE            05028000
         TM    FLAGSJJ,FDSNMSG          MSG ALLOCATION?                 05029000
         BO    DSNMSG                   YES, BRANCH                     05030000
         TM    FLAGSJJ,FDSNTSO          TSO ALLOCATION?                 05031000
         BO    DSNTSO                   YES, BRANCH                     05032000
         SPACE 1                                                        05033000
DSNJCL   MVC   INSERT#1(20),DSNJDSN     ADD "//12345678  DD  DSN="      05034000
         MVC   INSERT#1+2(8),DDNAME     MOVE IN THE DDNAME              05035000
         LA    R1,INSERT#1+20           DSNAME START POSITION           05036000
         MVC   0(44,R1),DSNAME          MOVE IN THE DSNAME              05037000
         AH    R1,DSNLEN                LENGTH OF THE DSNAME            05038000
         MVC   0(15,R1),DSNJDSND        ADD ",DISP=SHR,UNIT="           05039000
         CLI   DSPALLOC,ALLOSHR         DISP=SHR?                       05040000
         BE    *+10                     YES, BRANCH                     05041000
         MVC   6(3,R1),=C'OLD'          NO, DISP=OLD                    05042000
         LH    R15,BYTEUCB              UCBBYTE                         05043000
         MH    R15,=H'9'                INDEX INTO THE UNIT TABLE       05044000
         LA    R15,UNITTBL(R15)         DEVICE UNIT TYPE                05045000
         LA    R1,15(,R1)               START OF UNIT DATA              05046000
         MVC   0(8,R1),1(R15)           ADD TO THE MESSAGE              05047000
         MVI   8(R1),X'40'              ADD A TERMINATOR                05048000
         LA    R1,1(,R1)                SCAN                            05049000
         CLI   0(R1),X'40'                  FOR FIRST                   05050000
         BNE   *-8                                   BLANK              05051000
         MVI   0(R1),C','               ADD A TERMINATOR AND CONTINUE   05052000
         TSMSG L220$1                                                   05053000
         MVC   INSERT#1(80),MSGBL132+4  BLANK THE SECOND LINE           05054000
         MVC   INSERT#1(20),DSNJDCT     "// DCB=(RECFM=, ..."           05055000
         IC    R5,FLAGSCC               RECFM BITS                      05056000
         SLL   R5,29                    DROP TOP BITS                   05057000
         SRL   R5,29                    REPOSITION                      05058000
         IC    R5,RECFMTYP(R5)          RECORD FORMAT                   05059000
         STC   R5,INSERT#1+15           MOVE INTO MESSAGE               05060000
         LA    R1,INSERT#1+16                                           05061000
         TM    RECFM,DCBRECBR           RECFM=.B?                       05062000
         BNO   *+12                     NO, BRANCH                      05063000
         MVI   0(R1),C'B'                                               05064000
         LA    R1,1(R1)                                                 05065000
         TM    RECFM,DCBRECSB           RECFM=.S?                       05066000
         BNO   *+12                     NO, BRANCH                      05067000
         MVI   0(R1),C'S'                                               05068000
         LA    R1,1(R1)                                                 05069000
         TM    RECFM,DCBRECTO           RECFM=.T?                       05070000
         BNO   *+12                     NO, BRANCH                      05071000
         MVI   0(R1),C'T'                                               05072000
         LA    R1,1(R1)                                                 05073000
         TM    RECFM,DCBRECCA           RECFM=.A?                       05074000
         BNO   *+12                     NO, BRANCH                      05075000
         MVI   0(R1),C'A'                                               05076000
         LA    R1,1(R1)                                                 05077000
         TM    RECFM,DCBRECCM           RECFM=.M?                       05078000
         BNO   *+12                     NO, BRANCH                      05079000
         MVI   0(R1),C'M'                                               05080000
         LA    R1,1(R1)                                                 05081000
         TM    FLAGSCC,RECFMU           RECFM=U?                        05082000
         BO    DSN010                   YES, NO LRECL                   05083000
         MVC   0(7,R1),DSNJDCTL         MOVE IN LRECL TEXT              05084000
         LA    R1,7(R1)                                                 05085000
         LH    R4,LABLRECL                                              05086000
         BAL   R14,DSNCONV                                              05087000
         SPACE 1                                                        05088000
DSN010   MVC   0(9,R1),DSNJDCTB                                         05089000
         LA    R1,9(R1)                                                 05090000
         LH    R4,BLKSI                                                 05091000
         BAL   R14,DSNCONV                                              05092000
         SPACE 1                                                        05093000
         SR    R4,R4                                                    05094000
         ICM   R4,B'0001',DS1KEYL       ANY KEY LENGTH?                 05095000
         BZ    DSN020                   NO, BRANCH                      05096000
         MVC   0(8,R1),DSNJDCTK         ADD ,KEYLEN=                    05097000
         LA    R1,8(R1)                                                 05098000
         BAL   R14,DSNCONV                                              05099000
         SPACE 1                                                        05100000
         MVC   0(5,R1),DSNJDCTR         ADD ,RKP=                       05101000
         LA    R1,5(R1)                                                 05102000
         SR    R4,R4                                                    05103000
         ICM   R4,B'0011',DS1RKP        RELATIVE KEY POSITION           05104000
         BAL   R14,DSNCONV                                              05105000
         SPACE 1                                                        05106000
DSN020   TM    DSORG,DS1DSGPO           PARTITIONED?                    05107000
         BO    DSN030                   NO, BRANCH                      05108000
         MVC   0(7,R1),DSNJDCTD         ADD ,DSORG=                     05109000
         IC    R5,DSORG                 DSORG BITS                      05110000
         SLL   R5,24                    DROP TOP BITS                   05111000
         SRL   R5,28                    REPOSITION BITS *2              05112000
         LA    R5,DSORGTYP(R5)          DSORG                           05113000
         MVC   7(2,R1),0(R5)            MOVE INTO MESSAGE               05114000
         TM    DSORG+1,DS1ACBM          VSAM DATA SET?                  05115000
         BNO   *+10                     YES, BRANCH                     05116000
         MVC   7(2,R1),=C'VS'                                           05117000
         LA    R1,9(,R1)                SKIP OVER DSORG TEXT            05118000
         TM    DS1DSORG,DS1DSGU         UNMOVEABLE?                     05119000
         BNO   DSN030                   NO, BRANCH                      05120000
         MVI   0(R1),C'U'               ADD U                           05121000
         LA    R1,1(,R1)                SKIP OVER U                     05122000
         SPACE 1                                                        05123000
DSN030   MVC   0(10,R1),DSNJDCTV        ADD ),VOL=SER=                  05124000
         MVC   10(6,R1),VOLALLOC        ADD THE SERIAL NUMBER           05125000
         MVI   10+6(R1),C','                                            05126000
         TSMSG L220$1                                                   05127000
         SPACE 1                                                        05128000
         MVC   INSERT#1(80),DSNJSPA     //  SPACE= ...                  05129000
         L     R1,DCBDEBAD-IHADCB+INDCB GET DEB ADDRESS                 05130000
         LH    R14,NUMEXT               NUMBER OF EXTENTS               05131000
         SR    R0,R0                                                    05132000
         AH    R0,32+14(,R1)            ADD NUMBER OF TRACKS IN EXTENT  05133000
         LA    R1,16(,R1)               NEXT EXTENT                     05134000
         BCT   R14,*-8                  BRANCH FOR ALL EXTENTS          05135000
         STH   R0,DSNTOTAL              SAVE TOTAL D.S. SIZE IN TRACKS  05136000
         LH    R1,DS1LSTAR              GET TT OF LAST TRACK            05137000
         CLC   DS1LSTAR(3),ZERO         ANY ALLOCATION?                 05138000
         BE    *+8                      NO, BRANCH                      05139000
         LA    R1,1(,R1)                JUMP FOR COMPUTATION            05140000
         SR    R0,R1                                                    05141000
         STH   R0,DSNEMPTY              TOTAL FREE SPACE                05142000
         SPACE 1                                                        05143000
         LA    R1,INSERT#1+DSNJSPAP     PRIMARY SPACE                   05144000
         LH    R4,DSNTOTAL              TOTAL FREE SPACE                05145000
         TM    DS1SCALO,X'C0'           CYLINDER ALLOCATION?            05146000
         BNO   DSN050                   NO, BRANCH                      05147000
         MVC   INSERT#1+11(3),=C'CYL'   YES, MARK AS CYLINDER ALLOC.    05148000
         LH    R0,DEVTTRKS              TRACKS/CYLINDER                 05149000
         LR    R5,R0                                                    05150000
         BCTR  R5,0                     TRACKS/CYLINDER -1              05151000
         AR    R5,R4                    TOTAL+TRK/CYL -1                05152000
         SR    R4,R4                                                    05153000
         DR    R4,R0                    CEIL(TOTAL+TRK/CYL-1) / TRK/CYL 05154000
         LR    R4,R5                    RESULTING QUOTIENT              05155000
DSN050   BAL   R14,DSNCONV                                              05156000
         SPACE 1                                                        05157000
         SR    R4,R4                                                    05158000
         ICM   R4,B'0111',DS1SCALO+1    SECONDARY ALLOCATION?           05159000
         BZ    DSN070                   NO, BRANCH                      05160000
         TM    DS1SCALO,X'80'           TRACK OR CYLINDER ALLOCATION?   05161000
         BO    DSN060                   YES, BRANCH                     05162000
         TM    DS1SCALO,X'40'           AVERAGE BLOCK ALLOCATION?       05163000
         BNO   DSN060                   NO, BRANCH                      05164000
         LH    R14,BLKSI                BLOCKSIZE                       05165000
         ICM   R14,B'1000',=X'01'       R=1, K=0, DD=BLKSIZE            05166000
         TRKCALC FUNCTN=TRKCAP,TYPE=BYTEUCB+1,RKDD=(14),               X05167000
               REGSAVE=YES,MF=(E,PARMLIST)                              05168000
         LR    R5,R0                                                    05169000
         BCTR  R5,0                                                     05170000
         AR    R5,R4                                                    05171000
         SR    R4,R4                                                    05172000
         DR    R4,R0                    CEIL((BUFFERS+#/TRK-1)/(#/TRK)) 05173000
         LR    R4,R5                    RESULTING QUOTIENT              05174000
DSN060   MVI   0(R1),C','               SEPARATOR                       05175000
         LA    R1,1(,R1)                                                05176000
         BAL   R14,DSNCONV                                              05177000
         SPACE 1                                                        05178000
DSN070   TM    DSORG,DS1DSGPO           PARTITIONED DATA SET?           05179000
         BNO   DSN080                   NO, BRANCH                      05180000
         MVI   0(R1),C','               SEPARATOR                       05181000
         CLC   DS1SCALO+1(3),ZERO       SECONDARY ALLOCATION?           05182000
         BNE   *+8                      YES, BRANCH                     05183000
         LA    R1,1(,R1)                NO, ADD ANOTHER COMMA           05184000
         MVI   0(R1),C','               SEPARATOR                       05185000
         LA    R1,1(,R1)                                                05186000
         LH    R4,TOTALLOX              TOTAL DIRECTORY BLOCKS          05187000
         BAL   R14,DSNCONV                                              05188000
         SPACE 2                                                        05189000
DSN080   MVI   0(R1),C')'               PAIRED PARENTHESIS 1            05190000
         MVI   1(R1),C')'               PAIRED PARENTHESIS 2            05191000
         TM    DS1SCALO,X'01'           CYLINDER ROUNDING?              05192000
         BNO   *+10                     NO, BRANCH                      05193000
         MVC   1(8,R1),=C',,ROUND)'     YES, MARK IT                    05194000
         SPACE 1                                                        05195000
         LA    R1,INSERT#1+DSNJSPAT     WHERE TO STORE NUMBER FREE      05196000
         LH    R4,DSNEMPTY              TOTAL FREE TRACKS               05197000
         BAL   R14,DSNCONV                                              05198000
         SPACE 1                                                        05199000
         TM    DSORG,DS1DSGPO           PARTITIONED?                    05200000
         BNO   DSN090                   NO, BRANCH                      05201000
         MVC   0(10,R1),=C',FREE DIR='  FREE DIRECTORY BLOCKS           05202000
         LA    R1,10(,R1)               WHERE TO STORE NUMBER FREE      05203000
         LH    R4,TOTALLOX              TOTAL DIRECTORY BLOCKS          05204000
         SH    R4,TOTUSEDX              FREE DIRECTORY BLOCKS           05205000
         BAL   R14,DSNCONV                                              05206000
DSN090   MVI   0(R1),C'*'               TERMINATOR                      05207000
         MVI   1(R1),C'/'                         CHARACTERS            05208000
         TSMSG L220$1                                                   05209000
         MVI   MTHIGHL,8                RESET THE INSERT LENGTH         05210000
         MESSAGE MSGBLANK               ONE BLANK LINE                  05211000
         BR    R2                                                       05212000
         SPACE 3                                                        05213000
DSNTSO   MVC   INSERT#1(22),DSNTDSN     ADD "ALLOC F(1234567)  DA('"    05214000
         MVC   INSERT#1+8(8),DDNAME     MOVE IN THE DDNAME              05215000
         LA    R1,INSERT#1+8            DDNAME START POSITION           05216000
         LA    R1,1(,R1)                SCAN                            05217000
         CLI   0(R1),X'40'                  FOR FIRST                   05218000
         BNE   *-8                                   BLANK              05219000
         MVI   0(R1),C')'               ADD TERMINATOR                  05220000
         LA    R1,INSERT#1+22           DSNAME START POSITION           05221000
         MVC   0(44,R1),DSNAME          MOVE IN THE DSNAME              05222000
         AH    R1,DSNLEN                LENGTH OF THE DSNAME            05223000
         MVC   0(12,R1),DSNTDSND        ADD "') SHR UNIT("              05224000
         CLI   DSPALLOC,ALLOSHR         DISP=SHR?                       05225000
         BE    *+10                     YES, BRANCH                     05226000
         MVC   3(3,R1),=C'OLD'          NO, DISP=OLD                    05227000
         LH    R15,BYTEUCB              UCBBYTE                         05228000
         MH    R15,=H'9'                INDEX INTO THE UNIT TABLE       05229000
         LA    R15,UNITTBL(R15)         DEVICE UNIT TYPE                05230000
         LA    R1,12(,R1)               START OF UNIT DATA              05231000
         MVC   0(8,R1),1(R15)           ADD TO THE MESSAGE              05232000
         MVI   8(R1),X'40'              ADD A TERMINATOR                05233000
         LA    R1,1(,R1)                SCAN                            05234000
         CLI   0(R1),X'40'                  FOR FIRST                   05235000
         BNE   *-8                                   BLANK              05236000
         MVC   0(3,R1),=C') -'          ADD A TERMINATOR AND CONTINUE   05237000
         TSMSG L210$1                                                   05238000
         MVC   INSERT#1(80),MSGBL132+4  BLANK THE SECOND LINE           05239000
         MVC   INSERT#1(08),DSNTDCT     "  RECFM("                      05240000
         IC    R5,FLAGSCC               RECFM BITS                      05241000
         SLL   R5,29                    DROP TOP BITS                   05242000
         SRL   R5,29                    REPOSITION                      05243000
         IC    R5,RECFMTYP(R5)          RECORD FORMAT                   05244000
         STC   R5,INSERT#1+8            MOVE INTO MESSAGE               05245000
         LA    R1,INSERT#1+9                                            05246000
         TM    RECFM,DCBRECBR           RECFM=.B?                       05247000
         BNO   *+12                     NO, BRANCH                      05248000
         MVI   1(R1),C'B'                                               05249000
         LA    R1,2(R1)                                                 05250000
         TM    RECFM,DCBRECSB           RECFM=.S?                       05251000
         BNO   *+12                     NO, BRANCH                      05252000
         MVI   1(R1),C'S'                                               05253000
         LA    R1,2(R1)                                                 05254000
         TM    RECFM,DCBRECTO           RECFM=.T?                       05255000
         BNO   *+12                     NO, BRANCH                      05256000
         MVI   1(R1),C'T'                                               05257000
         LA    R1,2(R1)                                                 05258000
         TM    RECFM,DCBRECCA           RECFM=.A?                       05259000
         BNO   *+12                     NO, BRANCH                      05260000
         MVI   1(R1),C'A'                                               05261000
         LA    R1,2(R1)                                                 05262000
         TM    RECFM,DCBRECCM           RECFM=.M?                       05263000
         BNO   *+12                     NO, BRANCH                      05264000
         MVI   1(R1),C'M'                                               05265000
         LA    R1,2(R1)                                                 05266000
         TM    FLAGSCC,RECFMU           RECFM=U?                        05267000
         BO    DSN310                   YES, NO LRECL                   05268000
         MVC   0(8,R1),DSNTDCTL         MOVE IN LRECL TEXT              05269000
         LA    R1,8(R1)                                                 05270000
         LH    R4,LABLRECL                                              05271000
         BAL   R14,DSNCONV                                              05272000
         SPACE 1                                                        05273000
DSN310   MVC   0(10,R1),DSNTDCTB                                        05274000
         LA    R1,10(R1)                                                05275000
         LH    R4,BLKSI                                                 05276000
         BAL   R14,DSNCONV                                              05277000
         SPACE 1                                                        05278000
         SR    R4,R4                                                    05279000
         ICM   R4,B'0001',DS1KEYL       ANY KEY LENGTH?                 05280000
         BZ    DSN320                   NO, BRANCH                      05281000
         MVC   0(9,R1),DSNTDCTK         ADD ,KEYLEN=                    05282000
         LA    R1,9(R1)                                                 05283000
         BAL   R14,DSNCONV                                              05284000
         SPACE 1                                                        05285000
         MVC   0(6,R1),DSNTDCTR         ADD ,RKP=                       05286000
         LA    R1,6(R1)                                                 05287000
         SR    R4,R4                                                    05288000
         ICM   R4,B'0011',DS1RKP        RELATIVE KEY POSITION           05289000
         BAL   R14,DSNCONV                                              05290000
         SPACE 1                                                        05291000
DSN320   TM    DSORG,DS1DSGPO           PARTITIONED?                    05292000
         BO    DSN330                   NO, BRANCH                      05293000
         MVC   0(8,R1),DSNTDCTD         ADD ) DSORG(                    05294000
         IC    R5,DSORG                 DSORG BITS                      05295000
         SLL   R5,24                    DROP TOP BITS                   05296000
         SRL   R5,28                    REPOSITION BITS *2              05297000
         LA    R5,DSORGTYP(R5)          DSORG                           05298000
         MVC   8(2,R1),0(R5)            MOVE INTO MESSAGE               05299000
         TM    DSORG+1,DS1ACBM          VSAM DATA SET?                  05300000
         BNO   *+10                     YES, BRANCH                     05301000
         MVC   8(2,R1),=C'VS'                                           05302000
         LA    R1,10(,R1)               SKIP OVER DSORG TEXT            05303000
         TM    DS1DSORG,DS1DSGU         UNMOVEABLE?                     05304000
         BNO   DSN330                   NO, BRANCH                      05305000
         MVI   0(R1),C'U'               ADD U                           05306000
         LA    R1,1(,R1)                SKIP OVER U                     05307000
         SPACE 1                                                        05308000
DSN330   MVC   0(9,R1),DSNTDCTV         ADD ) VOLUME(                   05309000
         LA    R1,9(,R1)                START OF UNIT DATA              05310000
         MVC   0(6,R1),VOLALLOC         ADD THE SERIAL NUMBER           05311000
         MVI   6(R1),X'40'              ADD A TERMINATOR                05312000
         LA    R1,1(,R1)                SCAN                            05313000
         CLI   0(R1),X'40'                  FOR FIRST                   05314000
         BNE   *-8                                   BLANK              05315000
         MVC   0(3,R1),=C') -'          ADD A TERMINATOR AND CONTINUE   05316000
         TSMSG L210$1                                                   05317000
         SPACE 1                                                        05318000
         MVC   INSERT#1(80),DSNTSPA     "  TRK SPACE(N ..."             05319000
         L     R1,DCBDEBAD-IHADCB+INDCB GET DEB ADDRESS                 05320000
         LH    R14,NUMEXT               NUMBER OF EXTENTS               05321000
         SR    R0,R0                                                    05322000
         AH    R0,32+14(,R1)            ADD NUMBER OF TRACKS IN EXTENT  05323000
         LA    R1,16(,R1)               NEXT EXTENT                     05324000
         BCT   R14,*-8                  BRANCH FOR ALL EXTENTS          05325000
         STH   R0,DSNTOTAL              SAVE TOTAL D.S. SIZE IN TRACKS  05326000
         LH    R1,DS1LSTAR              GET TT OF LAST TRACK            05327000
         CLC   DS1LSTAR(3),ZERO         ANY ALLOCATION?                 05328000
         BE    *+8                      NO, BRANCH                      05329000
         LA    R1,1(,R1)                JUMP FOR COMPUTATION            05330000
         SR    R0,R1                                                    05331000
         STH   R0,DSNEMPTY              TOTAL FREE SPACE                05332000
         SPACE 1                                                        05333000
         LA    R1,INSERT#1+DSNTSPAP     PRIMARY SPACE                   05334000
         LH    R4,DSNTOTAL              TOTAL FREE SPACE                05335000
         TM    DS1SCALO,X'C0'           CYLINDER ALLOCATION?            05336000
         BNO   DSN350                   NO, BRANCH                      05337000
         MVC   INSERT#1+2(3),=C'CYL'    YES, MARK AS CYLINDER ALLOC.    05338000
         LH    R0,DEVTTRKS              TRACKS/CYLINDER                 05339000
         LR    R5,R0                                                    05340000
         BCTR  R5,0                     TRACKS/CYLINDER -1              05341000
         AR    R5,R4                    TOTAL+TRK/CYL -1                05342000
         SR    R4,R4                                                    05343000
         DR    R4,R0                    CEIL(TOTAL+TRK/CYL-1) / TRK/CYL 05344000
         LR    R4,R5                    RESULTING QUOTIENT              05345000
DSN350   BAL   R14,DSNCONV                                              05346000
         SPACE 1                                                        05347000
         SR    R4,R4                                                    05348000
         ICM   R4,B'0111',DS1SCALO+1    SECONDARY ALLOCATION?           05349000
         BZ    DSN370                   NO, BRANCH                      05350000
         TM    DS1SCALO,X'80'           TRACK OR CYLINDER ALLOCATION?   05351000
         BO    DSN360                   YES, BRANCH                     05352000
         TM    DS1SCALO,X'40'           AVERAGE BLOCK ALLOCATION?       05353000
         BNO   DSN360                   NO, BRANCH                      05354000
         LH    R14,BLKSI                BLOCKSIZE                       05355000
         ICM   R14,B'1000',=X'01'       R=1, K=0, DD=BLKSIZE            05356000
         TRKCALC FUNCTN=TRKCAP,TYPE=BYTEUCB+1,RKDD=(14),               X05357000
               REGSAVE=YES,MF=(E,PARMLIST)                              05358000
         LR    R5,R0                                                    05359000
         BCTR  R5,0                                                     05360000
         AR    R5,R4                                                    05361000
         SR    R4,R4                                                    05362000
         DR    R4,R0                    CEIL((BUFFERS+#/TRK-1)/(#/TRK)) 05363000
         LR    R4,R5                    RESULTING QUOTIENT              05364000
DSN360   MVI   0(R1),C','               SEPARATOR                       05365000
         LA    R1,1(,R1)                                                05366000
         BAL   R14,DSNCONV                                              05367000
         SPACE 1                                                        05368000
DSN370   MVI   0(R1),C')'               PAIRED PARENTHESIS 1            05369000
         LA    R1,1(,R1)                                                05370000
         TM    DSORG,DS1DSGPO           PARTITIONED DATA SET?           05371000
         BNO   DSN380                   NO, BRANCH                      05372000
         MVC   1(4,R1),=C'DIR('         SEPARATOR                       05373000
         LA    R1,5(,R1)                                                05374000
         LH    R4,TOTALLOX              TOTAL DIRECTORY BLOCKS          05375000
         BAL   R14,DSNCONV                                              05376000
         MVI   0(R1),C')'               FINAL PARENTHESIS               05377000
         SPACE 2                                                        05378000
DSN380   LA    R1,INSERT#1+DSNTSPAT     WHERE TO STORE NUMBER FREE      05379000
         LH    R4,DSNEMPTY              TOTAL FREE TRACKS               05380000
         BAL   R14,DSNCONV                                              05381000
         SPACE 1                                                        05382000
         TM    DSORG,DS1DSGPO           PARTITIONED?                    05383000
         BNO   DSN390                   NO, BRANCH                      05384000
         MVC   0(10,R1),=C',FREE DIR='  FREE DIRECTORY BLOCKS           05385000
         LA    R1,10(,R1)               WHERE TO STORE NUMBER FREE      05386000
         LH    R4,TOTALLOX              TOTAL DIRECTORY BLOCKS          05387000
         SH    R4,TOTUSEDX              FREE DIRECTORY BLOCKS           05388000
         BAL   R14,DSNCONV                                              05389000
DSN390   MVI   0(R1),C'*'               TERMINATOR                      05390000
         MVI   1(R1),C'/'                         CHARACTERS            05391000
         TSMSG L210$1                                                   05392000
         MVI   MTHIGHL,8                RESET THE INSERT LENGTH         05393000
         MESSAGE MSGBLANK               ONE BLANK LINE                  05394000
         BR    R2                                                       05395000
         SPACE 3                                                        05396000
DSNMSG   MVC   INSERT#1(80),DSNM200H       ADD HEADER                   05397000
         TM    DSORG,DS1DSGPO              PARTITIONED?                 05398000
         BO    *+10                        YES, BRANCH                  05399000
         MVC   INSERT#1+63(7),=CL7'DSORG'  NO, CHANGE THE HEADER        05400000
         TSMSG L200$1                                                   05401000
         MVC   INSERT#1(80),DSNM200E    ADD DATA LINE                   05402000
         CLI   DSPALLOC,ALLOSHR         DISP=SHR?                       05403000
         BE    *+10                     YES, BRANCH                     05404000
         MVC   INSERT#1+0(3),=C'OLD'    NO, DISP=OLD                    05405000
         LH    R15,BYTEUCB              UCBBYTE                         05406000
         MH    R15,=H'9'                INDEX INTO THE UNIT TABLE       05407000
         LA    R15,UNITTBL(R15)         DEVICE UNIT TYPE                05408000
         MVC   INSERT#1+05(8),1(R15)    DEVICE TYPE TEXT                05409000
         IC    R5,FLAGSCC               RECFM BITS                      05410000
         SLL   R5,29                    DROP TOP BITS                   05411000
         SRL   R5,29                    REPOSITION                      05412000
         IC    R5,RECFMTYP(R5)          RECORD FORMAT                   05413000
         STC   R5,INSERT#1+14           MOVE INTO MESSAGE               05414000
         LA    R1,INSERT#1+15                                           05415000
         TM    RECFM,DCBRECBR           RECFM=.B?                       05416000
         BNO   *+12                     NO, BRANCH                      05417000
         MVI   0(R1),C'B'                                               05418000
         LA    R1,1(R1)                                                 05419000
         TM    RECFM,DCBRECSB           RECFM=.S?                       05420000
         BNO   *+12                     NO, BRANCH                      05421000
         MVI   0(R1),C'S'                                               05422000
         LA    R1,1(R1)                                                 05423000
         TM    RECFM,DCBRECTO           RECFM=.T?                       05424000
         BNO   *+12                     NO, BRANCH                      05425000
         MVI   0(R1),C'T'                                               05426000
         LA    R1,1(R1)                                                 05427000
         TM    RECFM,DCBRECCA           RECFM=.A?                       05428000
         BNO   *+12                     NO, BRANCH                      05429000
         MVI   0(R1),C'A'                                               05430000
         LA    R1,1(R1)                                                 05431000
         TM    RECFM,DCBRECCM           RECFM=.M?                       05432000
         BNO   *+12                     NO, BRANCH                      05433000
         MVI   0(R1),C'M'                                               05434000
         LA    R1,1(R1)                                                 05435000
         LH    R4,LABLRECL                                              05436000
         TM    FLAGSCC,RECFMU           RECFM=U?                        05437000
         BNO   *+6                      NO, BRANCH                      05438000
         SR    R4,R4                    YES, LRECL IS ZERO              05439000
         CVD   R4,DOUBLE                CONVERT TO DECIMAL              05440000
         ED    INSERT#1+19(6),DOUBLE+5  CONVERT TO DISPLAY              05441000
         LH    R4,BLKSI                                                 05442000
         CVD   R4,DOUBLE                CONVERT TO DECIMAL              05443000
         ED    INSERT#1+27(6),DOUBLE+5  CONVERT TO DISPLAY              05444000
         SPACE 1                                                        05445000
         LH    R14,NUMEXT               NUMBER OF EXTENTS               05446000
         CVD   R14,DOUBLE                                               05447000
         ED    INSERT#1+33(4),DOUBLE+6  CONVERT TO DISPLAY              05448000
         L     R1,DCBDEBAD-IHADCB+INDCB GET DEB ADDRESS                 05449000
         SR    R0,R0                                                    05450000
         AH    R0,32+14(,R1)            ADD NUMBER OF TRACKS IN EXTENT  05451000
         LA    R1,16(,R1)               NEXT EXTENT                     05452000
         BCT   R14,*-8                  BRANCH FOR ALL EXTENTS          05453000
         STH   R0,DSNTOTAL              SAVE TOTAL D.S. SIZE IN TRACKS  05454000
         CVD   R0,DOUBLE                                                05455000
         ED    INSERT#1+38(6),DOUBLE+5  CONVERT TO DISPLAY              05456000
         LH    R1,DS1LSTAR              GET TT OF LAST TRACK            05457000
         CLC   DS1LSTAR(3),ZERO         ANY ALLOCATION?                 05458000
         BE    *+8                      NO, BRANCH                      05459000
         LA    R1,1(,R1)                JUMP FOR COMPUTATION            05460000
         SR    R0,R1                                                    05461000
         STH   R0,DSNEMPTY              TOTAL FREE SPACE                05462000
         SPACE 1                                                        05463000
         CVD   R0,DOUBLE                                                05464000
         ED    INSERT#1+46(6),DOUBLE+5  CONVERT TO DISPLAY              05465000
         SPACE 1                                                        05466000
         SR    R4,R4                                                    05467000
         ICM   R4,B'0111',DS1SCALO+1    SECONDARY ALLOCATION?           05468000
         BZ    DSN660                   NO, BRANCH                      05469000
         TM    DS1SCALO,X'80'           TRACK OR CYLINDER ALLOCATION?   05470000
         BO    DSN660                   YES, BRANCH                     05471000
         TM    DS1SCALO,X'40'           AVERAGE BLOCK ALLOCATION?       05472000
         BNO   DSN660                   NO, BRANCH                      05473000
         LH    R14,BLKSI                BLOCKSIZE                       05474000
         ICM   R14,B'1000',=X'01'       R=1, K=0, DD=BLKSIZE            05475000
         TRKCALC FUNCTN=TRKCAP,TYPE=BYTEUCB+1,RKDD=(14),               X05476000
               REGSAVE=YES,MF=(E,PARMLIST)                              05477000
         LR    R5,R0                                                    05478000
         BCTR  R5,0                                                     05479000
         AR    R5,R4                                                    05480000
         SR    R4,R4                                                    05481000
         DR    R4,R0                    CEIL((BUFFERS+#/TRK-1)/(#/TRK)) 05482000
         LR    R4,R5                    RESULTING QUOTIENT              05483000
DSN660   CVD   R4,DOUBLE                                                05484000
         ED    INSERT#1+52(6),DOUBLE+5  CONVERT TO DISPLAY              05485000
         SPACE 1                                                        05486000
         TM    DS1SCALO,X'C0'           CYLINDER ALLOCATION?            05487000
         BNO   *+10                     NO, BRANCH                      05488000
         MVC   INSERT#1+59(3),=C'CYL'   YES, MARK AS CYLINDER ALLOC.    05489000
         SPACE 1                                                        05490000
         TM    DSORG,DS1DSGPO           PARTITIONED?                    05491000
         BO    DSN680                   NO, BRANCH                      05492000
         LA    R1,INSERT#1+63           WHERE TO ADD DSORG DATA         05493000
         MVC   0(8,R1),BLANKS           BLANK THE EDIT DATA             05494000
         IC    R5,DSORG                 DSORG BITS                      05495000
         SLL   R5,24                    DROP TOP BITS                   05496000
         SRL   R5,28                    REPOSITION BITS *2              05497000
         LA    R5,DSORGTYP(R5)          DSORG                           05498000
         MVC   0(2,R1),0(R5)            MOVE INTO MESSAGE               05499000
         TM    DSORG+1,DS1ACBM          VSAM DATA SET?                  05500000
         BNO   *+10                     YES, BRANCH                     05501000
         MVC   0(2,R1),=C'VS'                                           05502000
         TM    DS1DSORG,DS1DSGU         UNMOVEABLE?                     05503000
         BNO   DSN690                   NO, BRANCH                      05504000
         MVI   2(R1),C'U'               ADD U                           05505000
         B     DSN690                                                   05506000
         SPACE 1                                                        05507000
DSN680   LH    R4,TOTALLOX              TOTAL DIRECTORY BLOCKS          05508000
         SH    R4,TOTUSEDX              FREE DIRECTORY BLOCKS           05509000
         CVD   R4,DOUBLE                                                05510000
         ED    INSERT#1+64(6),DOUBLE+5  CONVERT TO DISPLAY              05511000
         SPACE 1                                                        05512000
DSN690   TSMSG L200$1                                                   05513000
         MVI   MTHIGHL,8                RESET THE INSERT LENGTH         05514000
         MESSAGE MSGBLANK               ONE BLANK LINE                  05515000
         BR    R2                                                       05516000
         SPACE 3                                                        05517000
DSNCONV  CVD   R4,DOUBLE                                                05518000
         UNPK  DOUBLE(5),DOUBLE+5(3)                                    05519000
         LA    R4,DOUBLE-1                                              05520000
         LA    R4,1(R4)                                                 05521000
         CLI   0(R4),C'0'                                               05522000
         BE    *-8                                                      05523000
         OI    DOUBLE+4,X'F0'                                           05524000
DSNMOVE  MVC   0(1,R1),0(R4)                                            05525000
         LA    R1,1(R1)                                                 05526000
         TM    1(R4),X'F0'                                              05527000
         LA    R4,1(R4)                                                 05528000
         BO    DSNMOVE                                                  05529000
         BR    R14                                                      05530000
         SPACE 1                                                        05531000
DSNTDSN  DC    C'ALLOC F(1234567)  DA('''') SHR UNIT('                  05532000
DSNTDSND EQU   DSNTDSN+22,12                                            05533000
         SPACE 1                                                        05534000
DSNTDCT  DC    C'  RECFM() LRECL() BLKSIZE() DSORG(**) KEYLEN() RKP() VX05535000
               OLUME('                                                  05536000
DSNTDCTL EQU   DSNTDCT+8,8                                              05537000
DSNTDCTB EQU   DSNTDCT+8+8,10                                           05538000
DSNTDCTD EQU   DSNTDCT+8+8+10,10                                        05539000
DSNTDCTK EQU   DSNTDCT+8+8+10+10,9                                      05540000
DSNTDCTR EQU   DSNTDCT+8+8+10+10+9,6                                    05541000
DSNTDCTV EQU   DSNTDCT+8+8+10+10+9+6,9                                  05542000
         SPACE 1                                                        05543000
DSNTSPA  DC    CL80'  TRK SPACE(N                            /*FREE TRKX05544000
               =N'                                                      05545000
DSNTSPAP EQU   12,4                                                     05546000
DSNTSPAT EQU   52,7                                                     05547000
         SPACE 2                                                        05548000
DSNJDSN  DC    C'//12345678  DD  DSN=,DISP=SHR,UNIT='                   05549000
DSNJDSND EQU   DSNJDSN+20,15                                            05550000
         SPACE 1                                                        05551000
DSNJDCT  DC    C'//  DCB=(RECFM=,LRECL=,BLKSIZE=,DSORG=**,KEYLEN=,RKP=)X05552000
               ,VOL=SER='                                               05553000
DSNJDCTL EQU   DSNJDCT+15,7                                             05554000
DSNJDCTB EQU   DSNJDCT+15+7,9                                           05555000
DSNJDCTD EQU   DSNJDCT+15+7+9,9                                         05556000
DSNJDCTK EQU   DSNJDCT+15+7+9+9,8                                       05557000
DSNJDCTR EQU   DSNJDCT+15+7+9+9+8,5                                     05558000
DSNJDCTV EQU   DSNJDCT+15+7+9+9+8+5,10                                  05559000
         SPACE 1                                                        05560000
DSNJSPA  DC    CL80'//  SPACE=(TRK,(N                        /*FREE TRKX05561000
               =N'                                                      05562000
DSNJSPAP EQU   16,4                                                     05563000
DSNJSPAT EQU   52,7                                                     05564000
         SPACE 2                                                        05565000
DSNM200H DC    CL80'DISP UNIT     RECFM LRECL BLKSIZE   ALLOCTRK FREETRX05566000
               K SECONDARY FREEDIR'                   123X 12345        05567000
DSNM200E DC    CL80'SHR                                  X             X05568000
                       TRK        '                                     05569000
         ORG   DSNM200E+19                                              05570000
         DC    X'402020202120'                                          05571000
         ORG   DSNM200E+27                                              05572000
         DC    X'402020202120'                                          05573000
         ORG   DSNM200E+33                                              05574000
         DC    X'40202120'                                              05575000
         ORG   DSNM200E+38                                              05576000
         DC    X'402020202120'                                          05577000
         ORG   DSNM200E+46                                              05578000
         DC    X'402020202120'                                          05579000
         ORG   DSNM200E+52                                              05580000
         DC    X'402020202120'                                          05581000
         ORG   DSNM200E+64                                              05582000
         DC    X'402020202120'                                          05583000
         ORG   ,                                                        05584000
         DROP  R6                                                       05585000
         TITLE 'P D S  --  PDS FIXPDS                          1/15/85' 05586000
*********************************************************************** 05587000
***      FIXPDS SUBCOMMAND     ADDED BY BRUCE LELAND -- NOV., 1982  *** 05588000
*********************************************************************** 05589000
*                                                                       05590000
         SPACE 1                                                        05591000
FIXPDS   CSECT                                                          05592000
         USING *,R8                                                     05593000
         SPACE 1                                                        05594000
         ICM   R1,B'1111',#RECFM       NEW DCB=RECFM SPECIFIED?         05595000
         BP    *+10                    YES, BRANCH                      05596000
         MVC   #RECFM+3(1),RECFM       NO, USE PREVIOUS RECFM           05597000
         ICM   R2,B'1111',#LRECL       NEW DCB=LRECL SPECIFIED?         05598000
         BP    *+10                    YES, BRANCH                      05599000
         MVC   #LRECL+2(2),LABLRECL    NO, USE THE LRECL FROM THE DCB   05600000
         TM    #RECFM+3,X'C0'          RECFM=U..?                       05601000
         BNO   *+10                    NO, BRANCH                       05602000
         XC    #LRECL,#LRECL           YES, USE LRECL=0                 05603000
         ICM   R3,B'1111',#BLKSI       NEW DCB=BLKSIZE SPECIFIED?       05604000
         BP    *+10                    YES, BRANCH                      05605000
         MVC   #BLKSI+2(2),BLKSI       NO, USE PREVIOUS BLOCKSIZE       05606000
         SPACE 2                                                        05607000
         TM    #RECFM+3,DCBRECF        RECFM=F OR RECFM=U?              05608000
         BNO   FIXPDS10                NO, BRANCH                       05609000
         TM    #RECFM+3,DCBRECV        RECFM=U?                         05610000
         BO    FIXPDS10                YES, BRANCH                      05611000
         SPACE 1                                                        05612000
         L     R15,#BLKSI              REQUESTED BLOCKSIZE              05613000
         SR    R14,R14                                                  05614000
         ICM   R4,B'1111',#LRECL       ANY LRECL?                       05615000
         BZ    FIXPDS10                NO, AVOID DIVIDE ERROR           05616000
         DR    R14,R4                  CHECK LRECL'S PER BLOCK          05617000
         LTR   R14,R14                 INTEGRAL NUMBER?                 05618000
         BZ    FIXPDS10                YES, BRANCH                      05619000
         TSMSG L482                    NO, DIVIDE ERROR MESSAGE         05620000
         SPACE 2                                                        05621000
FIXPDS10 TM    DSORG,DS1DSGPO          PARTITIONED?                     05622000
         BNO   FIXPDS50                NO, BRANCH                       05623000
         CLI   #FIXOPT,X'02'           DCB?                             05624000
         BL    FIXPDS50                YES, BRANCH                      05625000
         SPACE 1                                                        05626000
         MVC   ##SUBCOM(8),$USA        TEMPORARY SUBCOMMAND IDENTIFIER  05627000
         MVI   STARTTR+2,X'01'         TTR=000001 (START OF DIRECTORY)  05628000
         BAL   R14,READDIR             NUMBER OF DIRECTORY BLOCKS       05629000
         MVC   ##SUBCOM(8),$FIX        RESET THE SUBCOMMAND NAME        05630000
         SPACE 1                                                        05631000
         ICM   R3,B'1111',TOTMEMR      REAL (2 BYTES) AND ALIASES (2)   05632000
         LH    R6,TOTBLOCK             NUMBER OF DIRECTORY BLOCKS       05633000
         LTR   R6,R6                   ANY CURRENT DIRECTORY BLOCKS?    05634000
         BP    FIXPDS20                YES, BRANCH                      05635000
         LA    R1,L752                 ASSUME RESET OR EXPAND & NOCOUNT 05636000
         CLC   #NEWDIR,ZERO            CORRECT?                         05637000
         BE    MSGNEW                  YES, ERROR EXIT                  05638000
         SPACE 1                                                        05639000
FIXPDS20 CLI   #FIXOPT,X'02'           EXPANDDIR?                       05640000
         BE    FIXPDS30                YES, BRANCH                      05641000
         ICM   R1,B'1111',#NEWDIR      ANY DIRECTORY BLOCKS SPECIFIED?  05642000
         BP    *+8                     YES, BRANCH                      05643000
         ST    R6,#NEWDIR              NO, USE CURRENT NUMBER           05644000
         SR    R6,R6                   CLEAR CURRENT DIRECTORY NUMBER   05645000
         LTR   R3,R3                   ANY MAIN OR ALIAS MEMBERS?       05646000
         BZ    FIXPDS30                NO, A WARNING IS NOT NEEDED      05647000
         TSMSG L451                    YES, ALL MEMBERS WILL BE LOST    05648000
         SPACE 1                                                        05649000
FIXPDS30 STM   R2,R12,28(R13)          CONVERT CCHHR TO TTR             05650000
         LA    R2,CURMBB                                                05651000
         L     R1,INDCB+(DCBDEBAD-IHADCB)                               05652000
         L     R15,ADDRRLTV                                             05653000
         LR    R3,R13                                                   05654000
         BALR  R14,R15                                                  05655000
         LR    R13,R3                                                   05656000
         LM    R2,R12,28(R13)                                           05657000
         ST    R0,#EOF1TTR             TTR OF CURRENT DIRECTORY EOF     05658000
         SPACE 1                                                        05659000
         ICM   R4,B'1111',#NEWDIR      ANY DIRECTORY BLOCKS SPECIFIED?  05660000
         BP    *+8                     YES, BRANCH                      05661000
         LA    R4,50                   NO, ADD 50 TO THE CURRENT NUMBER 05662000
         AR    R4,R6                   DESIRED + CURRENT DIR. BLOCKS    05663000
         ST    R4,#NEWDIR              UPDATE (NOW TOTAL # OF BLOCKS)   05664000
         LTR   R3,R3                   ANY MAIN OR ALIAS MEMBERS?       05665000
         BNZ   *+6                     YES, BRANCH                      05666000
         SR    R6,R6                   NO, CLEAR DIRECTORY COUNT        05667000
         SPACE 1                                                        05668000
         LR    R1,R4                                                    05669000
         SR    R1,R6                   NUMBER OF BLOCKS TO ADD          05670000
         ST    R1,#NEWDIR              UPDATE (NOW NUMBER TO ADD)       05671000
         SPACE 1                                                        05672000
         L     R14,=X'01080100'        R=1, K=08, DD=256 BYTES          05673000
         TRKCALC FUNCTN=TRKCAP,TYPE=BYTEUCB+1,RKDD=(14),              XX05674000
               REGSAVE=YES,MF=(E,PARMLIST)                              05675000
         ST    R0,#DIRBTRK             SAVE DIRECTORY BLOCKS PER TRACK  05676000
         SRDA  R4,32                   TOTAL BLOCKS                     05677000
         DR    R4,R0                   TOTAL / ENTRIES PER TRACK        05678000
         STH   R5,#EOF2TT              TRACK OF NEW DIRECTORY EOF       05679000
         L     R2,DCBDEBAD-IHADCB+INDCB  DEB ADDRESS                    05680000
         LA    R1,L870                 ASSUME MULTI-EXTENT DIRECTORY    05681000
         CLC   32+14(2,R2),ZERO        NULL DATA SET?                   05682000
         BE    FIXPDS31                YES, ALLOW THE ALLOCATION        05683000
         CH    R5,32+14(,R2)           CORRECT?                         05684000
         BNL   MSGNEW                  YES, ERROR                       05685000
         SPACE 1                                                        05686000
FIXPDS31 LTR   R4,R4                   PARTIAL TRACK USED?              05687000
         BP    FIXPDS32                YES, BRANCH                      05688000
         TSMSG L450                    NO, WARNING MESSAGE              05689000
         L     R1,#NEWDIR              ONE ADDITIONAL                   05690000
         A     R1,=F'1'                       DIRECTORY                 05691000
         ST    R1,#NEWDIR                           BLOCK USED          05692000
         SPACE 2                                                        05693000
FIXPDS32 LA    R3,#MEMPTR              BASE FOR THE MEMBER LIST         05694000
         USING DIRLINK,R3              NO, BRANCH                       05695000
         MVI   STARTTR+2,X'01'         TTR=000001 (START OF DIRECTORY)  05696000
FIXPDS40 BAL   R14,READDIR             GET THE NEXT MEMBER              05697000
         B     FIXPDS50                LAST MEMBER, BRANCH              05698000
         SPACE 1                                                        05699000
         CLI   #FIXOPT,X'03'           RESET DIRECTORY?                 05700000
         BE    FIXPDS42                YES, BRANCH                      05701000
         CLC   #EOF2TT(2),MEMTTR       IN THE NEW DIRECTORY AREA?       05702000
         BL    FIXPDS40                NO, BRANCH                       05703000
         MVI   SUBPOOLT,21             MARK TEMPORARY SUBPOOL IN USE    05704000
         LA    R0,DIREND-DIRLINK       GET ANOTHER DIRECTORY ENTRY      05705000
         ICM   R0,B'1000',SUBPOOLT                                      05706000
         GETMAIN R,LV=(0)                                               05707000
         XC    0(DIREND-DIRLINK,R1),0(R1)                               05708000
         ST    R1,DIRLINK              CHAIN TO THE                     05709000
         LR    R3,R1                               NEXT ENTRY           05710000
         L     R14,DIRPTRS             ACTUAL DIRECTORY ENTRY           05711000
         MVC   DIRNAME(74),0(R14)      ADD THE DIRECTORY INFORMATION    05712000
         MVC   INSERT#1(8),DIRNAME                                      05713000
         TSMSG L050$1                                                   05714000
         SPACE 2                                                        05715000
FIXPDS42 MVC   DSNMEMQ(8),MEMNAME      MEMBER NAME TO CHECK             05716000
         BAL   R2,ENQMTEST             MEMBER IN USE?                   05717000
         B     FIXPDS40                YES, OUTPUT WARNING MESSAGE ONLY 05718000
         B     FIXPDS40                REPEAT FOR ALL MEMBERS           05719000
         SPACE 2                                                        05720000
FIXPDS50 MESSAGE MSGBLANK              ONE SPACING LINE                 05721000
         L     R15,$DSN+8                                               05722000
         BALR  R2,R15                  DISPLAY ALLOCATION STATUS        05723000
         LA    R1,PDS392A              CORRECT DATA SET                 05724000
         BAL   R2,YESNO                RESPONSE "YES" OR "NO"?          05725000
         B     NEWCMD                  "NO", QUIT                       05726000
         SPACE 1                                                        05727000
         TM    DSORG,DS1DSGPO          PARTITIONED?                     05728000
         BNO   FIXDCB                  NO, BRANCH                       05729000
         MVI   #DIRFIX,X'F9'           HIGH IN COLLATING SEQUENCE       05730000
         MVC   #DIRFIX+1(7),=C'FIXPDS' TEMPORARY STOW AND DELETE NAME   05731000
         BAL   R6,RESERVE              RESERVE/ENQUE AS REQUIRED        05732000
         L     R4,#NEWDIR              DIRECTORY BLOCKS DESIRED         05733000
         CLI   #FIXOPT,X'02'           WHICH PROCESSING MODE?           05734000
         BL    FIXDCB                    DCB       -- CHANGE DCB ONLY   05735000
***      BE    EXPAND                    EXPANDDIR -- ADD TO DIRECTORY  05736000
         BH    FIXRES                    RESETDIR  -- REWRITE DIRECTORY 05737000
         SPACE 3                                                        05738000
EXPAND   ICM   R1,B'1111',TOTMEMR      ANY MAIN OR ALIAS MEMBERS?       05739000
         BZ    FIXRES                  NO, USE RESETDIR INSTEAD         05740000
         SPACE 1                                                        05741000
         MVI   SUBPOOLT,21             MARK TEMPORARY STORAGE OBTAINED  05742000
         LA    R0,1024*3               STORAGE FOR THREE NOTELISTS      05743000
         ICM   R0,B'1000',SUBPOOLT     SUBPOOL                          05744000
         GETMAIN R,LV=(0)                                               05745000
         ST    R1,#NOTEPTR             POINTER TO NOTELIST WORK AREA    05746000
         BAL   R2,OPENSTOW             OPEN OUTPUT DCB; RESERVE IS DONE 05747000
         B     NEWCMD                  COULD NOT OPEN -- ERROR          05748000
         CLC   #MEMPTR(4),ZERO         ANY MEMBERS TO MOVE?             05749000
         BE    EXPAND80                NO, BRANCH                       05750000
         LA    R0,80                   FIRST RECORD IS 80 BYTES LONG    05751000
         SPACE 2                                                        05752000
*  ONE OR MORE MEMBERS MUST BE MOVED                                    05753000
*    WRITE GARBAGE RECORDS TO OCCUPY SPACE UP TO THE NEW DIRECTORY EOF  05754000
EXPAND02 STH   R0,STOWDCB+DCBBLKSI-IHADCB  UPDATE IN THE DCB            05755000
         L     R2,IOBUFF1              START OF DATA                    05756000
         WRITE FIXPDSD,SF,STOWDCB,(2),'S',MF=E                          05757000
         CHECK FIXPDSD                                                  05758000
         NOTE  STOWDCB                 OUTPUT TTR                       05759000
         LH    R0,BLKSI                MAXIMUM OUTPUT RECORD LENGTH     05760000
         CLM   R1,B'1100',#EOF2TT      PAST THE NEW DIRECTORY EOF?      05761000
         BNH   EXPAND02                NO, BRANCH                       05762000
         ST    R1,#FIXTTRO             HIGHEST OUTPUT TTR               05763000
         LA    R3,#MEMPTR                                               05764000
         SPACE 1                                                        05765000
EXPAND12 ICM   R3,B'0111',DIRLINK+1    NEXT MEMBER ENTRY                05766000
         BZ    EXPAND20                END OF LIST, BRANCH              05767000
         MVI   DIRLINK,X'80'           ASSUME THE MEMBER IS TO BE MOVED 05768000
         TM    DIRFLAG,DIRALIAS        ALIAS ENTRY?                     05769000
         BNO   EXPAND18                NO, BRANCH                       05770000
         LA    R2,#MEMPTR                                               05771000
         SPACE 1                                                        05772000
EXPAND14 ICM   R2,B'0111',1(R2)              MORE IN THE LIST?          05773000
         BZ    EXPAND18                      NO, THIS ITEM WILL MOVE    05774000
         CR    R2,R3                         SAME ITEM?                 05775000
         BE    EXPAND14                      YES, TRY AGAIN             05776000
         CLC   DIRTTR(3),DIRTTR-DIRLINK(R2)  SAME TTR?                  05777000
         BNE   EXPAND14                      NO, BRANCH                 05778000
         TM    DIRLINK-DIRLINK(R2),X'80'     OTHER ITEM TO BE MOVED?    05779000
         BO    EXPAND16                      YES, TRUE ALIAS            05780000
         TM    DIRFLAG-DIRLINK(R2),DIRALIAS  OTHER ITEM AN ALIAS?       05781000
         BO    EXPAND14                      YES, BRANCH                05782000
         SPACE 1                                                        05783000
EXPAND16 MVI   DIRLINK,0                     DO NOT MOVE THIS ENTRY     05784000
EXPAND18 TM    DIRFLAG,DIR1TTR+DIR2TTR       ANY USER TTR'S?            05785000
         BZ    EXPAND12                      NO, BRANCH                 05786000
         SPACE 1                                                        05787000
         OI    DIRLINK,X'01'                 AT LEAST ONE TTR           05788000
         TM    DIRFLAG,DIR2TTR               TWO OR MORE TTR'S?         05789000
         BNO   *+8                           NO, BRANCH                 05790000
         OI    DIRLINK,X'02'                 AT LEAST TWO TTR'S         05791000
         TM    DIRFLAG,DIR1TTR+DIR2TTR       THREE TTR'S?               05792000
         BNO   *+8                           NO, BRANCH                 05793000
         OI    DIRLINK,X'04'                 THREE TTR'S                05794000
         B     EXPAND12                                                 05795000
         SPACE 3                                                        05796000
EXPAND20 LA    R3,#MEMPTR                                               05797000
EXPAND22 ICM   R3,B'0111',DIRLINK+1    ANY MORE MEMBERS IN THE LIST?    05798000
         BZ    EXPAND80                NO, BRANCH                       05799000
         MVC   INSERT#1(8),DIRNAME     MEMBER NAME                      05800000
         TSMSG L051$1                                                   05801000
         TM    DIRLINK,X'80'           MEMBER TO BE MOVED?              05802000
         BNO   EXPAND22                NO, BRANCH                       05803000
         LA    R2,DIRSTART             FIRST USER TTR                   05804000
         L     R4,#NOTEPTR             START OF NOTELIST STORAGE        05805000
         LA    R5,X'10'+X'01'          MASK BITS FOR TESTING            05806000
         LA    R6,3                    LOOP CONTROL                     05807000
         SPACE 1                                                        05808000
*  INPUT THE OVERLAY NOTELIST TABLE                                     05809000
         TM    DIRLINK,*-*             <<EXECUTED>>                     05810000
EXPAND24 EX    R5,*-4                  ANOTHER TTR?                     05811000
         BZ    EXPAND30                NO, BRANCH                       05812000
         CLI   3(R2),0                 NOTELIST COUNT?                  05813000
         BZ    EXPAND26                NO, BRANCH                       05814000
         OI    DIRLINK,*-*             <<EXECUTED>>                     05815000
         EX    R5,*-4                  MARK FOR NOTELIST PROCESSING     05816000
         MVC   STARTTR(3),0(R2)        NOTELIST TTR ADDRESS             05817000
         L     R15,=A(EXCP)            INPUT IT                         05818000
         BALR  R14,R15                                                  05819000
         LA    R1,L751                 ASSUME AN INPUT PROBLEM          05820000
         LTR   R15,R15                 CORRECT?                         05821000
         BP    MSGNEW                  YES, BRANCH                      05822000
         LR    R14,R0                  INPUT ADDRESS                    05823000
         SR    R15,R15                                                  05824000
         IC    R15,3(,R2)              NUMBER OF NOTELIST ENTRIES       05825000
         SLL   R15,2                   SIZE OF NOTELIST AREA            05826000
         LR    R0,R4                   START OF THIS NOTELIST AREA      05827000
         LR    R1,R15                  SAVE AREA MOVE LENGTH            05828000
         MVCL  R0,R14                  SAVE THE NOTELIST DATA           05829000
         SPACE 1                                                        05830000
EXPAND26 LA    R2,4(,R2)               NEXT POTENTIAL USER TTR          05831000
         LA    R4,1024(,R4)            NEXT POTENTIAL NOTELIST AREA     05832000
         SLL   R5,1                    NEXT MASK BITS                   05833000
         BCT   R6,EXPAND24                                              05834000
         SPACE 3                                                        05835000
*  READ EACH RECORD OF THE MEMBER                                       05836000
EXPAND30 MVC   STARTTR(3),DIRTTR       FIRST TTR OF THE MEMBER          05837000
         MVC   #FINDTTR(3),DIRTTR      SAVE THE FIRST TTR FOR LATER     05838000
         SPACE 2                                                        05839000
EXPAND32 L     R15,=A(EXCP)                                             05840000
         BALR  R14,R15                                                  05841000
         B     *+4(R15)                PROCESS RETURN CODE              05842000
         B     EXPAND34                  00 - GOOD READ                 05843000
         B     EXPAND60                  04 - END OF MEMBER             05844000
         B     EXPAND60                  08 - END OF DATA SET           05845000
         B     NEWCMD                    12 - I/O ERROR                 05846000
         SPACE 1                                                        05847000
EXPAND34 STM   R2,R12,28(R13)          CONVERT CCHHR TO TTR             05848000
         LA    R2,CURMBB                                                05849000
         L     R1,INDCB+(DCBDEBAD-IHADCB)                               05850000
         L     R15,ADDRRLTV                                             05851000
         LR    R3,R13                                                   05852000
         BALR  R14,R15                                                  05853000
         LR    R13,R3                                                   05854000
         LM    R2,R12,28(R13)                                           05855000
         ST    R0,#FIXTTRI             SAVE CURRENT INPUT TTR           05856000
         TM    DIRLINK,X'77'           ANY PENDING TTR UPDATES?         05857000
         BZ    EXPAND50                NO, BRANCH                       05858000
         LA    R2,DIRSTART             FIRST USER TTR                   05859000
         L     R4,#NOTEPTR             START OF NOTELIST STORAGE        05860000
         LA    R5,X'10'                MASK                             05861000
         LA    R6,3                    LOOP CONTROL                     05862000
         SPACE 1                                                        05863000
         TM    DIRLINK,*-*             <<EXECUTED>>                     05864000
EXPAND36 EX    R5,*-4                  ANY NOTELIST FOR THIS ENTRY?     05865000
         BZ    EXPAND38                NO, BRANCH                       05866000
         CLM   R0,B'1110',0(R2)        IS THIS THE NOTELIST ENTRY?      05867000
         BE    EXPAND40                YES, BRANCH                      05868000
EXPAND38 LA    R2,4(,R2)               NEXT USER TTR                    05869000
         LA    R4,1024(,R4)            NEXT NOTELIST ENTRY              05870000
         SLL   R5,1                    NEXT MASK                        05871000
         BCT   R6,EXPAND36                                              05872000
         B     EXPAND50                NOT THIS RECORD, BRANCH          05873000
         SPACE 2                                                        05874000
EXPAND40 SR    R0,R0                                                    05875000
         IC    R0,3(R2)                NUMBER OF NOTELIST ENTRIES       05876000
         LA    R1,L750                 ERROR MESSAGE FOR A PROBLEM      05877000
         XI    DIRLINK,*-*             <<EXECUTED>>                     05878000
         EX    R5,*-4                  TURN OFF THIS NOTELIST ENTRY     05879000
         L     R5,EXCPBUFF             OUTPUT START ADDRESS             05880000
EXPAND42 TM    3(R4),X'80'             NOTELIST TTR PREVIOUSLY UPDATED? 05881000
         BNO   MSGNEW                  NO, ERROR                        05882000
         MVC   0(3,R5),0(R4)           REPLACE THE BUFFER TTR           05883000
         LA    R4,4(,R4)               NEXT STORAGE ADDRESS             05884000
         LA    R5,4(,R5)               NEXT BUFFER ADDRESS              05885000
         BCT   R0,EXPAND42             MOVE AND CHECK ALL ENTRIES       05886000
         SPACE 3                                                        05887000
*  OUTPUT EACH RECORD AND CHANGE TTR POINTERS AS NECESSARY              05888000
EXPAND50 L     R0,LS                   RECORD LENGTH                    05889000
         STH   R0,STOWDCB+DCBBLKSI-IHADCB  UPDATE IN THE DCB            05890000
         L     R2,EXCPBUFF             START OF DATA                    05891000
         WRITE FIXPDSD,SF,STOWDCB,(2),'S',MF=E                          05892000
         CHECK FIXPDSD                                                  05893000
         NOTE  STOWDCB                 OUTPUT TTR                       05894000
         ST    R1,#FIXTTRO                                              05895000
         SPACE 1                                                        05896000
         CLC   DIRTTR(3),#FINDTTR      FIRST MEMBER RECORD?             05897000
         BNE   *+10                    NO, BRANCH                       05898000
         MVC   DIRTTR(3),#FIXTTRO      YES, UPDATE THE TTR              05899000
         SPACE 1                                                        05900000
         TM    DIRLINK,X'77'           ANY PENDING TTR UPDATES?         05901000
         BZ    EXPAND32                NO, BRANCH                       05902000
         LA    R2,DIRSTART             FIRST USER TTR                   05903000
         L     R4,#NOTEPTR             START OF NOTELIST                05904000
         LA    R5,X'10'                NOTELIST MASK                    05905000
         LA    R6,3                    LOOP CONTROL                     05906000
         LA    R14,X'01'               TTR MASK                         05907000
         SPACE 1                                                        05908000
         TM    DIRLINK,*-*             <<EXECUTED>>                     05909000
EXPAND52 EX    R14,*-4                 TTR IN THIS POSITION?            05910000
         BNO   EXPAND54                NO, BRANCH                       05911000
         CLC   #FIXTTRI(3),0(R2)       THIS INPUT TTR?                  05912000
         BNE   EXPAND54                NO, BRANCH                       05913000
         STCM  R1,B'1110',0(R2)        YES, UPDATE THE TTR              05914000
         XI    DIRLINK,*-*             <<EXECUTED>>                     05915000
         EX    R14,*-4                 TURN OFF THE TTR INDICATOR       05916000
         SPACE 1                                                        05917000
         TM    DIRLINK,*-*             <<EXECUTED>>                     05918000
EXPAND54 EX    R5,*-4                  NOTELIST FOR THIS ENTRY?         05919000
         BNO   EXPAND58                NO, BRANCH                       05920000
         LR    R15,R4                  START OF NOTELIST                05921000
         SR    R0,R0                                                    05922000
         IC    R0,3(R2)                NUMBER OF NOTELIST ENTRIES       05923000
EXPAND56 CLC   0(3,R15),#FIXTTRI       THIS TTR?                        05924000
         BNE   *+12                    NO, BRANCH                       05925000
         STCM  R1,B'1110',0(R15)       YES, UPDATE THE TTR              05926000
         OI    3(R15),X'80'                 AND MARK AS UPDATED         05927000
         LA    R15,4(,R15)             NEXT NOTELIST ENTRY              05928000
         BCT   R0,EXPAND56                                              05929000
EXPAND58 LA    R2,4(,R2)               NEXT USER TTR                    05930000
         LA    R4,1024(,R4)            NEXT NOTELIST STORAGE            05931000
         SLL   R5,1                    NEXT NOTELIST BIT MASK           05932000
         SLL   R14,1                   NEXT TTR BIT MASK                05933000
         BCT   R6,EXPAND52                                              05934000
         B     EXPAND32               MOVE ALL MEMBERS                  05935000
         SPACE 3                                                        05936000
*  VERIFY THAT THE MEMBER WAS CORRECTLY PROCESSED                       05937000
EXPAND60 LA    R1,L871                 ASSUME A TTR WAS NOT UPDATED     05938000
         TM    DIRLINK,X'77'           CORRECT?                         05939000
         BNZ   MSGNEW                  YES, BRANCH                      05940000
         SPACE 1                                                        05941000
         CLC   DIRTTR(3),#FINDTTR      A NULL MEMBER?                   05942000
         BNE   EXPAND62                NO, BRANCH                       05943000
         SPACE 1                                                        05944000
* UPDATE TTR BY TWO AND STOW AGAIN FOR NULL MEMBERS                     05945000
         STOW  STOWDCB,DIRNAME,D                                        05946000
         LA    R1,L833                                                  05947000
         LTR   R15,R15                                                  05948000
         BP    EXIT8M                                                   05949000
         SPACE 1                                                        05950000
         ICM   R1,B'0111',#FIXTTRO                 HIGHEST OUTPUT TTR   05951000
         LA    R1,2(,R1)                                                05952000
         STCM  R1,B'0111',DCBRELAD-IHADCB+STOWDCB  HIGHEST OUTPUT TTR+2 05953000
         STOW  STOWDCB,DIRNAME,A                                        05954000
         LA    R1,L832                                                  05955000
         LTR   R15,R15                                                  05956000
         BP    EXIT8M                                                   05957000
         SPACE 1                                                        05958000
         SR    R1,R1                               YES, CHANGE THE TTR  05959000
         ICM   R1,B'0111',DCBRELAD-IHADCB+STOWDCB  TTR OF LAST EOF      05960000
         S     R1,=F'1'                            TTR OF NULL DATA     05961000
         STCM  R1,B'0111',DIRTTR                   TTR OF NULL DATA     05962000
         STCM  R1,B'0111',#FIXTTRO                 HIGHEST OUTPUT TTR   05963000
         SPACE 2                                                        05964000
EXPAND62 TM    DIRFLAG,DIRALIAS        ALIAS (WITH NO MAIN)?            05965000
         BNO   EXPAND70                NO, BRANCH                       05966000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   05967000
         XI    DIRFLAG,DIRALIAS        TEMPORARILY TURN OFF ALIAS BIT   05968000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        05969000
         OI    DIRFLAG,DIRALIAS        RESET THE ALIAS BIT              05970000
         SPACE 1                                                        05971000
         B     *+4(R15)                PROCESS RETURN CODE              05972000
         B     EXPAND70                  00 - REPLACED                  05973000
         EX    0,*                       04 - SHOULD NOT OCCUR          05974000
         EX    0,*                       08 - SHOULD NOT OCCUR          05975000
         B     FULLDIR                   12 - DIRECTORY FULL            05976000
         B     IOERROR                   16 - I/O ERROR                 05977000
         SPACE 3                                                        05978000
*  UPDATE THIS MEMBER AND ALL OF ITS ALIASES                            05979000
EXPAND70 LA    R2,#MEMPTR                                               05980000
         LR    R4,R3                                                    05981000
         SPACE 1                                                        05982000
EXPAND72 MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR-DIRLINK(R4)  TTR       05983000
         STOW  STOWDCB,4(R4),R         REPLACE THIS MEMBER ENTRY        05984000
         SPACE 1                                                        05985000
         B     *+4(R15)                PROCESS RETURN CODE              05986000
         B     EXPAND74                  00 - REPLACED                  05987000
         EX    0,*                       04 - SHOULD NOT OCCUR          05988000
         EX    0,*                       08 - SHOULD NOT OCCUR          05989000
         B     FULLDIR                   12 - DIRECTORY FULL            05990000
         B     IOERROR                   16 - I/O ERROR                 05991000
         SPACE 1                                                        05992000
EXPAND74 ICM   R2,B'0111',1(R2)               NEXT MEMBER ENTRY         05993000
         BZ    EXPAND22                       END OF LIST, BRANCH       05994000
         CLC   #FINDTTR(3),DIRTTR-DIRLINK(R2) THIS TTR TOO?             05995000
         BNE   EXPAND74                       NO, BRANCH                05996000
         CR    R2,R3                          SAME ENTRY?               05997000
         BE    EXPAND74                       YES, BRANCH               05998000
         LR    R4,R2                                                    05999000
         NI    DIRLINK-DIRLINK(R2),FF-X'80'   DO NOT MOVE THIS MEMBER   06000000
         MVC   DIRTTR-DIRLINK(3,R2),DIRTTR    NEW PRIMARY TTR           06001000
         LA    R14,DIRSTART-DIRLINK(,R2)      FIRST ALIAS USER TTR      06002000
         LA    R15,DIRSTART                   FIRST MOVED USER TTR      06003000
         LA    R5,X'01'                       MASK BIT                  06004000
         LA    R6,3                           LOOP CONTROL              06005000
         SPACE 1                                                        06006000
         TM    DIRLINK-DIRLINK(R2),*-*        <<EXECUTED>>              06007000
EXPAND76 EX    R5,*-4                         A TTR AT THIS ENTRY?      06008000
         BNO   EXPAND72                       NO, BRANCH                06009000
         MVC   0(3,R14),0(R15)                YES, UPDATE THE TTR ENTRY 06010000
         LA    R14,4(,R14)                    NEXT ALIAS TTR            06011000
         LA    R15,4(,R15)                    NEXT MOVED TTR            06012000
         SLL   R5,1                           NEXT MASK BIT             06013000
         BCT   R6,EXPAND76                                              06014000
         B     EXPAND72                                                 06015000
         DROP  R3                                                       06016000
         SPACE 3                                                        06017000
*  WRITE THE ADDED DIRECTORY RECORDS                                    06018000
EXPAND80 L     R6,#NEWDIR                     DIRECTORY BLOCKS TO ADD   06019000
         LA    R0,CCW1                        FIRST CCW                 06020000
         ST    R0,IOBCCW                               TO USE           06021000
         MVI   CCW3,X'1D'                     COMMAND FOR WRITE C,K,D   06022000
         LA    R0,MSGTEXT1+3                  STORAGE FOR               06023000
         STCM  R0,B'0111',CCW3+1                         WRITE ADDRESS  06024000
         NI    CCW3+4,FF-X'40'                LAST CCW IN CHAIN         06025000
         MVC   CCW3+6(2),=H'8'                DATA LENGTH IS EIGHT      06026000
         XC    MSGTEXT1(20),MSGTEXT1          CLEAR THE WRITE ADDRESS   06027000
         MVI   MSGTEXT1+8,8                   KEY IS EIGHT BYTES        06028000
         MVI   MSGTEXT1+9,1                   DATA IS 1*256 BYTES       06029000
         MVI   OPENLIST,X'80'                                           06030000
         CLOSE (INDCB),MF=(E,OPENLIST)                                  06031000
         OPEN  (INDCB,UPDAT),MF=(E,OPENLIST)                            06032000
         SPACE 2                                                        06033000
EXPAND82 L     R0,#EOF1TTR                    POINT TO LAST RECORD      06034000
         STM   R15,R12,12+4(R13)              CONVERT TTR TO MBBCCHHR   06035000
         L     R1,INDCB+(DCBDEBAD-IHADCB)     DEB ADDRESS               06036000
         LA    R2,MSGTEXT1                    RETURN CCHHR              06037000
         L     R15,ADDRCNVT                   TTR TO MBBCCHHR CONVERT   06038000
         LR    R3,R13                         SAVE AREA ADDRESS         06039000
         BALR  R14,R15                                                  06040000
         LR    R13,R3                         SAVE AREA ADDRESS         06041000
         LM    R15,R12,12+4(R13)              RESTORE REGISTERS         06042000
         MVC   IOBSEEK(8),MSGTEXT1                                      06043000
         SR    R1,R1                                                    06044000
         IC    R1,IOBSEEK+7                                             06045000
         S     R1,=F'1'                       REDUCE INITIAL TTR        06046000
         STC   R1,IOBSEEK+7                                             06047000
         MVI   IOECB,0                                                  06048000
         EXCP  IOB                            WRITE THIS RECORD         06049000
         WAIT  ECB=IOECB                      WAIT FOR I/O COMPLETION   06050000
         LA    R1,L836                        I/O ERROR IN DIRECTORY    06051000
         CLI   IOECB,X'7F'                    SUCCESSFUL WRITE?         06052000
         BNE   EXIT8M                         NO, ERROR                 06053000
         SR    R1,R1                                                    06054000
         IC    R1,#EOF1TTR+2                  INCREMENT                 06055000
         A     R1,=F'1'                                R OF             06056000
         STC   R1,#EOF1TTR+2                               TTR          06057000
         C     R1,#DIRBTRK                    FIT ON THIS TRACK?        06058000
         BNH   EXPAND84                       YES, BRANCH               06059000
         LH    R1,#EOF1TTR                    INCREMENT                 06060000
         A     R1,=F'1'                                TT OF            06061000
         STH   R1,#EOF1TTR                                  TTR         06062000
         MVI   #EOF1TTR+2,1                   RESET R OF TTR            06063000
         SPACE 1                                                        06064000
EXPAND84 S     R6,=F'1'                       MORE BLOCKS?              06065000
         BP    EXPAND82                       YES, BRANCH               06066000
         SPACE 2                                                        06067000
*  WRITE THE DATA SET END-OF-FILE MARKER                                06068000
         OC    MSGTEXT1+8(3),MSGTEXT1+8       END-OF-FILE WRITTEN?      06069000
         BZ    FIXDCB                         YES, BRANCH               06070000
         XC    MSGTEXT1+8(3),MSGTEXT1+8       SET KEY, DATA LENGTH TO 0 06071000
         B     EXPAND82                       ONE MORE LOOP             06072000
         SPACE 3                                                        06073000
FIXRES   BAL   R2,CLOSEIT                        CLOSE INPUT DATA SET   06074000
         LA    R0,CHANGE2                        ABEND RECOVERY ADDRESS 06075000
         ST    R0,RECOVER                                               06076000
         MVC   BAMDCB(LDIRDCB),DIRDCB            COPY PROTTYPE DCB      06077000
         MVC   DCBDDNAM-IHADCB+BAMDCB,DDNAME     CURRENT DDNAME         06078000
         MVI   OPENLIST,X'80'                    END OF LIST MARKER     06079000
         OPEN  (BAMDCB,(OUTPUT)),MF=(E,OPENLIST)                        06080000
         TM    DCBOFLGS-IHADCB+BAMDCB,X'10'  DIRECTORY OPEN?            06081000
         BNO   EXIT12O                       NO, QUIT                   06082000
         MVC   MSGTEXT1(18),KEYDATA          MOVE IN THE KEY AND DATA   06083000
         XC    MSGTEXT1+18(256),MSGTEXT1+18  FOLLOWED BY ZEROES         06084000
         SPACE 1                                                        06085000
FIXRES30 WRITE FIXPDSD,SF,BAMDCB,MSGTEXT1,'S',MF=E                      06086000
         CHECK FIXPDSD                 CHECK THIS OUTPUT OPERATION      06087000
         XC    MSGTEXT1(18),MSGTEXT1   ZERO THE KEY AND DATA PORTION    06088000
         S     R4,=F'1'                SUFFICIENT BLOCKS WRITTEN?       06089000
         BP    FIXRES30                NO, BRANCH                       06090000
         CLOSE (BAMDCB),MF=(E,OPENLIST)                                 06091000
         SPACE 3                                                        06092000
         MVI   OPENLIST,X'80'          END OF LIST MARKER               06093000
         MVC   STOWDCB(LSAMDCB),SAMDCB                                  06094000
         MVC   DCBDDNAM-IHADCB+STOWDCB,DDNAME                           06095000
         MVI   ##ADRCM#,FIXOPEN        MARK FOR DCB OPEN EXIT USE       06096000
         SPACE 2                                                        06097000
         OPEN  (STOWDCB,(OUTPUT)),MF=(E,OPENLIST)                       06098000
         TM    DCBOFLGS-IHADCB+STOWDCB,X'10'  OUT OPEN?                 06099000
         BNO   EXIT12O                        NO, QUIT                  06100000
         SPACE 1                                                        06101000
         STOW  STOWDCB,#DIRFIX,A       ADD A NULL MEMBER                06102000
         LA    R1,L832                 NOT ADDED MESSAGE                06103000
         LTR   R15,R15                 ADDED?                           06104000
         BP    EXIT8M                  NO, QUIT                         06105000
         STOW  STOWDCB,#DIRFIX,D       DELETE THE DUMMY MEMBER          06106000
         LA    R1,L833                 NOT DELETED MESSAGE              06107000
         LTR   R15,R15                 DELETED?                         06108000
         BP    EXIT8M                  NO, QUIT                         06109000
         B     FIXDCB20                YES, CLOSE AND END               06110000
         SPACE 3                                                        06111000
FIXDCB   BAL   R2,CLOSEIT              CLOSE THE INPUT DCB              06112000
         TM    DSORG,DS1DSGPO          PARTITIONED DATA SET?            06113000
         BO    FIXDCB10                YES, BRANCH                      06114000
         LA    R0,RESTART0             ABEND RECOVERY ADDRESS           06115000
         ST    R0,RECOVER                                               06116000
         BAL   R2,DEALLDCB             FREE THE DATA SET                06117000
         MVI   DSPALLOC,CONOMOD        ASSUME MOD -- NO CHANGE          06118000
         CLI   #FIXOPT,X'03'           CORRECT?                         06119000
         BNE   *+8                     NO, BRANCH                       06120000
         MVI   DSPALLOC,CONOOLD        YES, OPEN FOR RESET PROCESSING   06121000
         MVI   ##ADRCM#,EDITOR         NO REPEATED WARNING MESSAGE      06122000
         L     R15,=A(ALLOCATE)        ALLOCATION ROUTINE               06123000
         BALR  R14,R15                 GOOD ALLOCATION?                 06124000
         B     RESTART0                NO, ERROR                        06125000
         SPACE 1                                                        06126000
         L     R8,##ADRCMD             REESTABLISH THE BASE REGISTER    06127000
         CLI   DSPALLOC,CONOSHR        REQUESTED ALLOCATION?            06128000
         BE    RESTART2                NO, OLD ALLOCATION FAILED        06129000
         SPACE 1                                                        06130000
         LA    R0,CHANGE2              ABEND RECOVERY ADDRESS           06131000
         ST    R0,RECOVER                                               06132000
         MVI   OPENLIST,X'80'          END OF LIST MARKER               06133000
         MVC   STOWDCB(LSAMDCB),SAMDCB                                  06134000
         MVI   DCBDSORG-IHADCB+STOWDCB,DS1DSGPS  SET FOR SEQUENTIAL     06135000
         MVC   DCBDDNAM-IHADCB+STOWDCB,DDNAME                           06136000
         MVI   ##ADRCM#,FIXOPEN                  MARK FOR DCB OPEN EXIT 06137000
         SPACE 1                                                        06138000
         OPEN  (STOWDCB,(OUTPUT)),MF=(E,OPENLIST)                       06139000
         TM    DCBOFLGS-IHADCB+STOWDCB,X'10'  OUT OPEN?                 06140000
         BNO   EXIT12O                        NO, QUIT                  06141000
         B     FIXDCB20                                                 06142000
         SPACE 1                                                        06143000
FIXDCB10 LA    R0,CHANGE2              ABEND RECOVERY ADDRESS           06144000
         ST    R0,RECOVER                                               06145000
         MVI   OPENLIST,X'80'          END OF LIST MARKER               06146000
         MVC   STOWDCB(LSAMDCB),SAMDCB                                  06147000
         MVC   DCBDDNAM-IHADCB+STOWDCB,DDNAME                           06148000
         MVI   ##ADRCM#,FIXOPEN                  MARK FOR DCB OPEN EXIT 06149000
         SPACE 1                                                        06150000
         OPEN  (STOWDCB,(OUTPUT)),MF=(E,OPENLIST)                       06151000
         BAL   R6,RESERVE                                               06152000
         TM    DCBOFLGS-IHADCB+STOWDCB,X'10'  OUT OPEN?                 06153000
         BNO   EXIT12O                        NO, QUIT                  06154000
         SPACE 2                                                        06155000
FIXDCB20 CLI   #FIXOPT2,4                      MAXSPACE?                06156000
         BNE   FIXDCB30                        NO, BRANCH               06157000
         L     R1,DCBDEBAD-IHADCB+STOWDCB      GET DEB ADDRESS          06158000
         LH    R14,NUMEXT                      NUMBER OF EXTENTS        06159000
         SR    R0,R0                                                    06160000
         AH    R0,32+14(,R1)                   ADD TRACKS IN EXTENT     06161000
         LA    R1,16(,R1)                      NEXT EXTENT              06162000
         BCT   R14,*-8                         BRANCH FOR ALL EXTENTS   06163000
         S     R0,=F'1'                        MAX 00TT OF TTR VALID?   06164000
         BM    FIXDCB30                        NO, BRANCH               06165000
         SLL   R0,8                            0TTX                     06166000
         A     R0,=F'1'                        0TT1 (R OF TTR IS 1)     06167000
         SLL   R0,8                            TT10 -- NEW DS1LSTAR     06168000
         STM   R14,R12,12(R13)                 SAVE REGISTERS           06169000
         L     R1,DCBDEBAD-IHADCB+STOWDCB      DEB ADDRESS              06170000
         LA    R2,DCBFDAD-IHADCB+STOWDCB       RETURN ADDRESS           06171000
         L     R15,ADDRCNVT                    CONVERSION ROUTINE       06172000
         LR    R3,R13                          SAVE R13                 06173000
         BALR  R14,R15                                                  06174000
         LR    R13,R3                          RESTORE R13              06175000
         LM    R14,R12,12(R13)                 RESTORE REGISTERS        06176000
         XC    DCBTRBAL-IHADCB+STOWDCB(2),DCBTRBAL-IHADCB+STOWDCB       06177000
         SPACE 2                                                        06178000
FIXDCB30 CLOSE (STOWDCB),MF=(E,OPENLIST)                                06179000
         MESSAGE MSGBLANK              ONE SPACING LINE                 06180000
         L     R1,$DSN+8               ALLOCATION STATUS ROUTINE        06181000
         ST    R1,##ADRCMD             EXECUTED AFTER OPEN OF DATA SET  06182000
         MVI   ##ADRCM#,CONTINUE+EDITOR  CONTINUE AND NO WARNING        06183000
         CLI   #FIXOPT2,0              RELEASE/RELSAVE/RELEXT/MAXSPACE? 06184000
         BE    FIXDCB90                NO, BRANCH                       06185000
         CLI   #FIXOPT2,4              MAXSPACE?                        06186000
         BE    FIXDCB90                YES, BRANCH                      06187000
         MVC   MSGTEXT1+4(8),##SUBCAL  RELEASE COMMAND NAME             06188000
         MVI   MSGTEXT1+12,X'40'       ADD A BLANK                      06189000
         MVI   MSGTEXT1+13,C''''       ADD A QUOTE                      06190000
         MVC   MSGTEXT1+14(44),DSNAME  ADD THE DSNAME                   06191000
         LH    R15,DSNLEN              LENGTH OF DSNAME                 06192000
         LA    R3,MSGTEXT1+14(R15)     WHERE ADDITIONAL TEXT STARTS     06193000
         MVC   0(12,R3),MSGBL132+4     BLANK IT FIRST                   06194000
         MVI   0(R3),C''''             ADD A FINAL QUOTE                06195000
         LA    R4,14+12(,R15)          LENGTH OF COMMAND BUFFER         06196000
         SLL   R4,16                                                    06197000
         ST    R4,MSGTEXT1             UPDATE LENGTH FIELD              06198000
         SPACE 1                                                        06199000
         CLI   #FIXOPT2,1              RELEASE ALL?                     06200000
         BE    FIXDCB80                YES, BRANCH                      06201000
         MVC   2(3,R3),=C'EXT'         ADD EXT FOR EXTENTS              06202000
         CLI   #FIXOPT2,3              RELEASE EXTENTS ONLY?            06203000
         BE    FIXDCB80                YES, BRANCH                      06204000
         MVC   2(4,R3),=C'SPA('        ADD SPA( FOR SPACE(              06205000
         L     R1,#FIXRES              TRACKS TO RESERVE                06206000
         CVD   R1,DOUBLE                                                06207000
         OI    DOUBLE+7,X'0F'          CONVERT SIGN                     06208000
         UNPK  2+4(5,R3),DOUBLE+5(3)   CONVERT TO PRINTABLE             06209000
         MVI   2+4+5(R3),C')'          ENDING )                         06210000
         SPACE 1                                                        06211000
FIXDCB80 LA    R1,MSGTEXT1             START OF COMMAND BUFFER          06212000
         ST    R1,ADDRTEXT             COMMAND ADDRESS                  06213000
         MVI   3(R1),9                 OFFSET TO OPERANDS               06214000
         LA    R1,ADDRTEXT             COMMAND ADDRESS                  06215000
         LA    R3,##SUBCAL             RELEASE COMMAND PROCESSOR        06216000
         BAL   R2,ATTACH               CALL THE COMMAND                 06217000
         SPACE 2                                                        06218000
FIXDCB90 BAL   R2,DEALLDCB             FREE THE DATA SET                06219000
         B     RESTART0                REALLOCATE AND START OVER        06220000
         TITLE 'P D S  --  PDS HELP                            1/15/85' 06221000
*********************************************************************** 06222000
***      HELP  SUBCOMMAND      ADDED BY BRUCE LELAND -- JAN, 1980   *** 06223000
*********************************************************************** 06224000
*                                                                       06225000
         SPACE 2                                                        06226000
HELP     CSECT                                                          06227000
         USING *,R8                                                     06228000
         MVC   DDNAMEH,DDNAME        SAVE ACTUAL DDNAME                 06229000
         MVC   DDNAME,SYSHELP        DDNAME TO FREE                     06230000
         BAL   R2,DEALLOCZ           FORCE A FREE OF SYSHELP            06231000
         MVC   DDNAME,DDNAMEH        RESTORE ACTUAL DDNAME              06232000
         L     R14,ADDRECT                                              06233000
         MVC   ECTSCMD-ECT(8,R14),=CL8'HELP' SET PDS SUBCOMMAND NAME    06234000
         AIF ('&CISP' EQ 'NO SPF').MA00600                         @D01
         TM    SPFLAG0,SPFDON           ISPMODE ACTIVE?                 06235000
         BNO   *+8                      NO, BRANCH                      06236000
         MVI   ECTSCMD-ECT+4(R14),C'X'  YES, HELPX (FOR NO LINE MODE)   06237000
.MA00600 ANOP  ,                                                   @D01
         L     R2,ADDRCBUF           INPUT BUFFER ADDRESS               06238000
         L     R1,ADDRCPPL                                              06239000
         USING CPPL,R1               ACTUAL ADDRESS                     06240000
         ST    R2,CPPLCBUF           SET COMMAND ADDRESS                06241000
         DROP  R1                                                       06242000
         LA    R3,##SUBCAL           TSO HELP COMMAND                   06243000
         BAL   R2,ATTACH             GO ATTACH IT                       06244000
         B     NEWSTAX               NEXT COMMAND                       06245000
         SPACE 2                                                        06246000
*  NOTE: THE SYSHELP FILE IS FREED BEFORE THE HELP                      06247000
*        CALL IN CASE A PCF EXIT ALREADY REQUESTED HELP.                06248000
         TITLE 'P D S  --  PDS HISTORY                         1/15/85' 06249000
*********************************************************************** 06250000
***      HISTORY SUBCOMMAND                                         *** 06251000
*********************************************************************** 06252000
*                                                                       06253000
         SPACE 1                                                        06254000
HISTORY  CSECT                                                          06255000
         USING *,R8                                                     06256000
         LA    R1,L530             ASSUME A NON-PARTITIONED DATA SET    06257000
         TM    DSORG,DS1DSGPO      CORRECT?                             06258000
         BZ    MSGNEW              YES, BRANCH                          06259000
         SPACE 1                                                        06260000
         TM    FLAGSCC,RECFMU      LOAD MODULE LIBRARY?                 06261000
         BO    HIST020             YES, BRANCH                          06262000
         SPACE 1                                                        06263000
         MVC   INSERT#1(72),SPFSTATH                                    06264000
         MVI   MTHIGHL,72                                               06265000
         TM    FLAGSAA,FHEAD       HEADER WRITTEN YET?                  06266000
         BO    HIST000             YES, BRANCH                          06267000
         TSMSG L230$1                                                   06268000
         OI    FLAGSAA,FHEAD       NOW IT HAS BEEN WRITTEN              06269000
         SPACE 1                                                        06270000
HIST000  MVC   INSERT#1(72),MSGBL132+4                                  06271000
         MVC   INSERT#1+1(8),DIRNAME                                    06272000
         TM    DIRFLAG,X'80'           ALIAS MEMBER?                    06273000
         BNO   *+10                    NO, BRANCH                       06274000
         MVC   INSERT#1+1+8(2),=C'-A'  YES, ADD A FLAG                  06275000
         LA    R2,DIRUSER          LOAD START OF USER AREA (FOR SSI)    06276000
         TM    DIRFLAG,X'0F'       SPF STATISTICS PRESENT?              06277000
         BNO   HIST010             NO, BRANCH                           06278000
         OC    DIRSPFZ(3),DIRSPFZ  RESERVED AND 00 OF 00YYDDDF ZEROS?   06279000
         BNZ   HIST010             NO, BRANCH                           06280000
         CLI   DIRSPFCD,0          00 OF OTHER 00YYDDDF ZERO?           06281000
         BNZ   HIST010             NO, BRANCH                           06282000
         SPACE 1                                                        06283000
         LA    R2,INSERT#1-7                                            06284000
         SR    R1,R1                                                    06285000
         IC    R1,DIRSPFR          REVISION NUMBER FIRST                06286000
         CVD   R1,DOUBLE                                                06287000
         MVC   21(4,R2),=X'40212020'                                    06288000
         ED    21(4,R2),DOUBLE+6                                        06289000
         MVI   22(R2),C'.'                                              06290000
         IC    R1,DIRSPFV          VERSION NUMBER                       06291000
         CVD   R1,DOUBLE                                                06292000
         MVC   18(4,R2),=X'40212020'                                    06293000
         ED    18(4,R2),DOUBLE+6                                        06294000
         LA    R1,DIRSPFCR+1           POINT TO YYDDDF                  06295000
         LA    R15,FULLWORD+1                                           06296000
         BAL   R14,CONVDATE            CONVERT TO MMDDYY FORMAT         06297000
         MVC   FULLWORD(1),FULLWORD+3  CONVERT TO YYMMDD                06298000
         MVC   26(L'DATEMASK,R2),DATEMASK                               06299000
         ED    26(L'DATEMASK,R2),FULLWORD                               06300000
         LA    R1,DIRSPFCD+1           POINT TO YYDDDF                  06301000
         LA    R15,FULLWORD+1                                           06302000
         BAL   R14,CONVDATE            CONVERT TO MMDDYY FORMAT         06303000
         MVC   FULLWORD(1),FULLWORD+3  CONVERT TO YYMMDD                06304000
         MVC   36(L'DATEMASK,R2),DATEMASK                               06305000
         ED    36(L'DATEMASK,R2),FULLWORD                               06306000
         MVC   45(6,R2),=X'4021207A2020'                                06307000
         ED    45(6,R2),DIRSPFCT       TIME OF LAST CHANGE              06308000
         LH    R1,DIRSPFSI                                              06309000
         CVD   R1,DOUBLE                                                06310000
         MVC   51(6,R2),=X'402020202120'                                06311000
         ED    51(6,R2),DOUBLE+5                                        06312000
         SPACE 1                                                        06313000
         LH    R1,DIRSPFIN                                              06314000
         CVD   R1,DOUBLE                                                06315000
         MVC   57(6,R2),=X'402020202120'                                06316000
         ED    57(6,R2),DOUBLE+5                                        06317000
         LH    R1,DIRSPFMD                                              06318000
         CVD   R1,DOUBLE                                                06319000
         MVC   63(6,R2),=X'402020202120'                                06320000
         ED    63(6,R2),DOUBLE+5                                        06321000
         MVC   71(8,R2),DIRSPFID                                        06322000
         LA    R1,L230$1                                                06323000
         B     MSGNEW                  NO SSI FOR SPF-SAVED MEMBERS     06324000
         SPACE 1                                                        06325000
HIST010  LA    R1,L230$1                                                06326000
         CLC   ZERO,0(R2)              ZERO?                            06327000
         BE    MSGNEW                  YES, NO SSI                      06328000
         CLC   =F'-1',0(R2)            FFFFFFFF?                        06329000
         BE    MSGNEW                  YES, NO SSI                      06330000
         SPACE 1                                                        06331000
         MVC   INSERT#1+2+8+3(4),=C'SSI:'                               06332000
         UNPK  INSERT#1+2+8+3+5(9),0(5,R2)                              06333000
         TR    INSERT#1+2+8+3+5(8),TRTABLE                              06334000
         MVI   INSERT#1+2+8+3+5+8,X'40'                                 06335000
         B     MSGNEW                                                   06336000
         SPACE 3                                                        06337000
HIST020  OC    #ZAPOPT(4),#ZAPOPT      ANY ZAP, USER, TRAN OR LKED?     06338000
         BNZ   *+10                    YES, BRANCH                      06339000
         OC    #ZAPOPT(4),=X'01010101' NO, DEFAULT TO DO THEM ALL       06340000
         TM    FLAGSGG,FTRANCON          TRANSLATOR DATA OFF?      @D05
         BZ    HIST021                   NO, BRANCH                @D05
         MVI   #TRANOPT,X'02'            YES, NO TRANSLATOR DATA   @D05
         SPACE 1                                                        06341000
HIST021  DS    0H                                                  @D05
         L     R15,=A(READESD)     FORMAT THE ESD DATA                  06342000
         BALR  R14,R15             ANY ESD DATA?                        06343000
         NOP   0                   NO, CONTINUE ANYWAY                  06344000
         SPACE 2                                                        06345000
         L     R15,=A(READIDR)     FORMAT THE IDR DATA                  06346000
         BALR  R14,R15             IS IDR DATA AVAILABLE?               06347000
         B     NOHIST              NO, MESSAGE AND QUIT                 06348000
         B     HISTTRN$            YES, CONTINUE                        06349000
         SPACE 1                                                        06350000
NOHIST   SR    R6,R6                                                    06351000
         BAL   R4,HISTHDR                                               06352000
         LA    R1,L460             NO HISTORY AVAILABLE                 06353000
         B     MSGNEW                                                   06354000
         SPACE 3                                                        06355000
HISTHDR  TM    FLAGSAA,FINDMSG     NEED A GROUP HEADER?                 06356000
         BNO   HISTHDR2            NO, BRANCH                           06357000
         NI    FLAGSAA,FF-FINDMSG                                       06358000
         MESSAGE MSGBLANK                                               06359000
         MESSAGE FINDMEMQ                                               06360000
HISTHDR2 TM    FLAGSCC,F1IDR       FIRST IDR RECORD?                    06361000
         BZR   R4                  NO, RETURN                           06362000
         NI    FLAGSCC,FF-F1IDR                                         06363000
         LTR   R1,R6               ANY SECOND HEADER?                   06364000
         BZR   R4                  NO, RETURN                           06365000
         TSMSG (R1)                INDIVIDUAL HISTORY TITLE             06366000
         BR    R4                                                       06367000
         EJECT                                                          06368000
*                                                                       06369000
*        FORMAT TRANSLATOR IDR DATA ENTRIES                             06370000
*                                                                       06371000
HISTTRN$ LA    R3,#IDRPTR          SCAN IDR CHAIN                       06372000
         USING IDRENTRY,R3                                              06373000
         OI    FLAGSCC,F1IDR                                            06374000
         CLI   #TRANOPT,X'02'      NO TRANSLATOR DATA?             @D05
         BE    HISTZAP$            YES, BRANCH                     @D05
         SPACE 2                                                        06375000
HISTTRN  ICM   R3,B'1111',IDRLINK  END OF ESD CHAIN?                    06376000
         BZ    HISTZAP$            YES, BRANCH                          06377000
         CLI   IDRTYPE,IDRTRAN     TRANSLATOR ENTRY?                    06378000
         BNE   HISTTRN             NO, BRANCH                           06379000
         SPACE 2                                                        06380000
         LA    R2,#ESDPTR          START OF ESD CHAIN                   06381000
         USING ESDENTRY,R2                                              06382000
HISTTRN1 ICM   R2,B'1111',ESDLINK  END OF ESD CHAIN?                    06383000
         BZ    HISTTRN             YES, BRANCH                          06384000
         CLI   ESDTYPE,CODESD      CSECT ENTRY?                         06385000
         BNE   HISTTRN1            NO, SKIP THIS                        06386000
         CLC   ESDID,IDRESDID      REQUESTED IDR RECORD?                06387000
         BNE   HISTTRN1            NO, BRANCH                           06388000
         SPACE 1                                                        06389000
         LA    R6,L060                                                  06390000
         BAL   R4,HISTHDR                                               06391000
         MVC   MSGTEXT1(136),MSGBL132                                   06392000
         SPACE 1                                                        06393000
         MVC   MSGTEXT1+4(8),ESDNAME                                    06394000
         MVC   MSGTEXT1+12(9),DATEMASK                                  06395000
         ED    MSGTEXT1+12(9),IDRDATE                                   06396000
         MVC   MSGTEXT1+24(10),IDRTDATA   TRANSLATOR 1                  06397000
         UNPK  DOUBLE(5),IDRTDATA+10(3)   VVMM PACKED                   06398000
         MVI   MSGTEXT1+36,C'V'                                         06399000
         MVC   MSGTEXT1+36+1(2),DOUBLE    VV                            06400000
         MVI   MSGTEXT1+40,C'M'                                         06401000
         MVC   MSGTEXT1+40+1(2),DOUBLE+2  MM                            06402000
         CLI   IDRLDATA,15                TWO TRANSLATORS?              06403000
         BL    HISTTRN3                   NO, BRANCH                    06404000
         SPACE 1                                                        06405000
         OI    IDRTDATA+27+2,X'0F'        FIX THE SIGN FIELD            06406000
         LA    R15,FULLWORD               OUTPUT LOCATION               06407000
         LA    R1,IDRTDATA+27             SECOND YYDDD                  06408000
         BAL   R14,CONVDATE               CONVERT TO MMDDYY FORMAT      06409000
         MVC   MSGTEXT1+48(9),DATEMASK                                  06410000
         ED    MSGTEXT1+48(9),FULLWORD                                  06411000
         MVC   MSGTEXT1+60(10),IDRTDATA+15  TRANSLATOR 2                06412000
         UNPK  DOUBLE(5),IDRTDATA+25(3)     VVMM PACKED                 06413000
         MVI   MSGTEXT1+72,C'V'                                         06414000
         MVC   MSGTEXT1+72+1(2),DOUBLE      VV                          06415000
         MVI   MSGTEXT1+76,C'M'                                         06416000
         MVC   MSGTEXT1+76+1(2),DOUBLE+2    MM                          06417000
         SPACE 1                                                        06418000
HISTTRN3 MESSAGE MSGTEXT1                                               06419000
         B     HISTTRN1            NEXT IDR DATA RECORD THIS ESD ENTRY  06420000
         SPACE 3                                                        06421000
*                                                                       06422000
*        FORMAT AMASPZAP IDR DATA ENTRIES                               06423000
*                                                                       06424000
HISTZAP$ LA    R3,#IDRPTR          SCAN IDR CHAIN                       06425000
         USING IDRENTRY,R3                                              06426000
         OI    FLAGSCC,F1IDR                                            06427000
         SPACE 1                                                        06428000
HISTZAP  ICM   R3,B'1111',IDRLINK  END OF ESD CHAIN?                    06429000
         BZ    HISTUSR$            YES, BRANCH                          06430000
         CLI   IDRTYPE,IDRZAP      AMASPZAP ENTRY?                      06431000
         BNE   HISTZAP             NO, BRANCH                           06432000
         SPACE 1                                                        06433000
         LA    R2,#ESDPTR          START OF ESD CHAIN                   06434000
         USING ESDENTRY,R2                                              06435000
         SPACE 1                                                        06436000
HISTZAP1 ICM   R2,B'1111',ESDLINK  END OF ESD CHAIN?                    06437000
         BZ    HISTZAP             YES, BRANCH                          06438000
         SPACE 1                                                        06439000
         CLI   ESDTYPE,CODESD      CSECT ENTRY?                         06440000
         BNE   HISTZAP1            NO, SKIP THIS                        06441000
         SPACE 1                                                        06442000
         CLC   ESDID,IDRESDID      REQUESTED IDR RECORD?                06443000
         BNE   HISTZAP1            NO, BRANCH                           06444000
         SPACE 1                                                        06445000
         LA    R6,L061                                                  06446000
         BAL   R4,HISTHDR                                               06447000
         MVC   MSGTEXT1(136),MSGBL132                                   06448000
         SPACE 1                                                        06449000
         MVC   MSGTEXT1+4(L'ESDNAME),ESDNAME                            06450000
         MVC   MSGTEXT1+8+L'ESDNAME(L'DATEMASK),DATEMASK                06451000
         ED    MSGTEXT1+8+L'ESDNAME(L'DATEMASK),IDRDATE                 06452000
         MVC   MSGTEXT1+12+L'ESDNAME+L'DATEMASK(L'IDRZDATA),IDRZDATA    06453000
         MESSAGE MSGTEXT1                                               06454000
         B     HISTZAP1            NEXT IDR DATA RECORD THIS ESD ENTRY  06455000
         EJECT                                                          06456000
*                                                                       06457000
*        FORMAT THE USER-SUPPLIED IDR DATA RECORDS                      06458000
*                                                                       06459000
         SPACE 1                                                        06460000
HISTUSR$ LA    R3,#IDRPTR                                               06461000
         OI    FLAGSCC,F1IDR                                            06462000
         SPACE 1                                                        06463000
HISTUSR  ICM   R3,B'1111',IDRLINK  END OF IDR CHAIN?                    06464000
         BZ    HISTLKD$            YES, BRANCH                          06465000
         CLI   IDRTYPE,IDRUSER     USER IDR DATA RECORD?                06466000
         BNE   HISTUSR             NO, BRANCH                           06467000
         SPACE 1                                                        06468000
         LA    R2,#ESDPTR          ADDRESS OF ESD CHAIN                 06469000
         SPACE 1                                                        06470000
HISTUSR1 ICM   R2,B'1111',ESDLINK  END OF ESD CHAIN?                    06471000
         BZ    HISTUSR             YES, BRANCH                          06472000
         SPACE 1                                                        06473000
         CLI   ESDTYPE,CODESD      CSECT ENTRY?                         06474000
         BNE   HISTUSR1            NO, BRANCH                           06475000
         CLC   ESDID,IDRESDID      WANTED ESD RECORD?                   06476000
         BNE   HISTUSR1            NO, BRANCH                           06477000
         SPACE 1                                                        06478000
         LA    R6,L062                                                  06479000
         BAL   R4,HISTHDR                                               06480000
         MVC   MSGTEXT1(136),MSGBL132                                   06481000
         MVC   MSGTEXT1+4(L'ESDNAME),ESDNAME                            06482000
         MVC   MSGTEXT1+8+L'ESDNAME(L'DATEMASK),DATEMASK                06483000
         ED    MSGTEXT1+8+L'ESDNAME(L'DATEMASK),IDRDATE                 06484000
         SR    R1,R1                                                    06485000
         ICM   R1,B'0001',IDRLDATA ZERO BYTES?                          06486000
         BZ    HISTUSRS            YES, SKIP THE MOVE (LENGTH ZERO)     06487000
         SPACE 1                                                        06488000
         MVC   MSGTEXT1+12+L'ESDNAME+L'DATEMASK(*-*),IDRDATA  <<EXEC>>  06489000
         EX    R1,*-6                                                   06490000
         SPACE 1                                                        06491000
HISTUSRS MESSAGE MSGTEXT1                                               06492000
         B     HISTUSR1                                                 06493000
         DROP  R2,R3                                                    06494000
         EJECT                                                          06495000
*                                                                       06496000
*        FORMAT THE LINKAGE-EDITOR IDR DATA RECORD                      06497000
*                                                                       06498000
HISTLKD$ CLI   #LKEDOPT,X'01'           "LKED" REQUESTED?               06499000
         BNE   NEWCMD                   NO, BRANCH                      06500000
         SR    R1,R1                                                    06501000
         ICM   R1,B'0001',#LKEDLEN      ANY LKED NAME CHECK?            06502000
         BZ    HISTLKDG                 NO, BRANCH                      06503000
         BCTR  R1,0                     MACHINE LENGTH                  06504000
         CLC   #LKEDTXT(*-*),LKEDNAME   <<EXECUTED>>                    06505000
         EX    R1,*-6                   THIS LINKAGE EDITOR?            06506000
         BNE   NEWCMD                   NO, BRANCH                      06507000
HISTLKDG SR    R6,R6                                                    06508000
         BAL   R4,HISTHDR                                               06509000
         MVC   INSERT#1-1(9),DATEMASK                                   06510000
         ED    INSERT#1-1(9),LKEDDATE                                   06511000
         MVI   MTHIGHL+4,18                   LENGTH OF THIS INSERT     06512000
         MVC   INSERT#2(10),LKEDNAME                                    06513000
         MVC   INSERT#2+10(2),=C' V'                                    06514000
         UNPK  INSERT#2+10+2(3),LKEDVVMM(2)                             06515000
         MVC   INSERT#2+10+2+2(2),=C' M'                                06516000
         UNPK  INSERT#2+10+2+2+2(3),LKEDVVMM+1(2)                       06517000
         SPACE 1                                                        06518000
         TSMSG L064$2                         LINKAGE EDIT MESSAGE      06519000
         MVI   MTHIGHL+4,8                    LENGTH OF STANDARD INSERT 06520000
         B     NEWCMD                                                   06521000
         TITLE 'P D S  --  PDS HISTORY IDR SCAN SUBROUTINE     1/15/85' 06522000
*                                                                       06523000
*        IDR SCAN SUBROUTINE                                            06524000
*                                                                       06525000
         SPACE 3                                                        06526000
READIDR  STM   R14,R12,ESDIDRSV    SAVE REGISTERS                       06527000
         LR    R8,R15              BASE FOR THIS SUBROUTINE             06528000
         USING READIDR,R8                                               06529000
         NI    FLAGSCC,255-FIDR    IDR DATA DOES NOT EXIST YET          06530000
         LA    R6,IDRNORML         BRANCH ADDRESS IF NOT CONTINUED      06531000
         LA    R2,#IDRPTR          BASE FOR IDR LIST                    06532000
         USING IDRENTRY,R2                                              06533000
         MVC   STARTTR(3),DIRTTR   FIRST TTR                            06534000
         SPACE 2                                                        06535000
IDREXCP  L     R15,=A(EXCP)                                             06536000
         BALR  R14,R15                                                  06537000
         B     *+4(R15)            PROCESS RETURN CODE                  06538000
         B     IDREXCP1              00 - GOOD READ                     06539000
         B     LASTIDR               04 - END OF MEMBER                 06540000
         B     LASTIDR               08 - END OF DATA SET               06541000
         B     NEWCMD                12 - I/O ERROR                     06542000
         SPACE 1                                                        06543000
IDREXCP1 LR    R15,R0              START OF RECORD                      06544000
         TM    0(R15),X'50'        TEST SYM OR SCATTER RECORD?          06545000
         BM    IDREXCP             YES, SKIP IT                         06546000
         SPACE 1                                                        06547000
         CLI   0(R15),X'20'        CESD RECORD?                         06548000
         BE    IDREXCP             YES, SKIP                            06549000
         SPACE 1                                                        06550000
         CLI   0(R15),X'80'        IDR RECORD?                          06551000
         BNE   LASTIDR             NO, BRANCH                           06552000
         SPACE 1                                                        06553000
         LA    R3,3(,R15)          START OF IDR DATA                    06554000
         SR    R5,R5                                                    06555000
         IC    R5,1(,R15)          BYTE COUNT THIS RECORD               06556000
         LA    R5,0(R5,R15)        END OF BUFFER ADDRESS                06557000
         BR    R6                  BRANCH TO IDRNORML OR AS CONTINUED   06558000
         SPACE 2                                                        06559000
IDRNORML TM    2(R15),IDRLKED      LINKAGE EDITOR IDR RECORD?           06560000
         BO    LKEDIDR             YES, BRANCH                          06561000
         TM    2(R15),IDRTRAN      TRANSLATOR IDR RECORD?               06562000
         BO    TRANIDR             YES, BRANCH                          06563000
         TM    2(R15),IDRZAP       AMASPZAP IDR RECORD?                 06564000
         BO    ZAPIDR              YES, BRANCH                          06565000
         TM    2(R15),IDRUSER      USER-SUPPLIED IDR RECORD?            06566000
         BNO   NEXTIDR             NO, NEXT RECORD                      06567000
         EJECT                                                          06568000
*  USER-SUPPLIED IDR RECORDS:                                           06569000
* --  -- --+ --  --  --  -- -+ --  --  --  -- + --  --  --  --  -- ---* 06570000
*   0 - 1  |  2 - 4          |  5             |  6 - 6+COUNT          * 06571000
*   ESDID  |  IDENTIFY DATE  |  COUNT (0-40)  |  IDRDATA              * 06572000
* --  -- --+ --  --  --  -- -+ --  --  --  -- + --  --  --  --  -- ---* 06573000
         SPACE 1                                                        06574000
USERIDR  CLI   #USEROPT,0          "USER"?                              06575000
         BE    NEXTIDR             NO, BRANCH                           06576000
         BAL   R14,GETIDR          GET A NEW IDR RECORD                 06577000
         ST    R1,IDRLINK                                               06578000
         LR    R2,R1               ADDRESS OF NEW RECORD                06579000
         SPACE 2                                                        06580000
         LR    R4,R5                                                    06581000
         SR    R4,R3               MACHINE LENGTH MOVED                 06582000
         CH    R4,=H'5'            CONTINUED USER HEADER?               06583000
         BNL   USER20              NO, BRANCH                           06584000
         MVC   IDRUPREF(*-*),0(R3) <<EXECUTED>>                         06585000
         EX    R4,*-6              MOVE IN DATA                         06586000
         BAL   R6,IDRCONT          GET THE CONTINUED RECORD AND RETURN  06587000
         SPACE 1                                                        06588000
         LA    R14,IDRUPREF+1(R4)  TARGET OF MOVE                       06589000
         LA    R15,5-1(,R3)        LENGTH BYTE ADDRESS-1 IF NOT SPLIT   06590000
         SR    R15,R4              AMOUNT WE ALREADY HAVE               06591000
         SR    R1,R1                                                    06592000
         IC    R1,0(,R15)          LENGTH BYTE                          06593000
         LA    R15,6-2(,R1)        MACHINE LENGTH OF RECORD -1          06594000
         SR    R15,R4              MACHINE LENGTH TO MOVE               06595000
         MVC   0(*-*,R14),0(R3)    <<EXECUTED>>                         06596000
         EX    R15,*-6             MOVE IT INTO THE RECORD              06597000
         B     USER30                                                   06598000
         SPACE 2                                                        06599000
USER20   SR    R15,R15                                                  06600000
         IC    R15,5(,R3)          LENGTH OF USER DATA AREA             06601000
         LA    R15,5(,R15)         MACHINE LENGTH FOR MOVE              06602000
         MVC   IDRUPREF(*-*),0(R3) <<EXECUTED>>                         06603000
         EX    R15,*-6             MOVE IT INTO THE RECORD              06604000
         SPACE 1                                                        06605000
USER30   LA    R4,1(,R15)          ACTUAL RECORD LENGTH                 06606000
         MVI   IDRTYPE,IDRUSER     USER IDR DATA IDENTIFIER             06607000
         MVC   IDRESDID,IDRUPREF   ADD THE CSECT ID                     06608000
         LA    R1,IDRUPREF+2       YYDDD IDR RECORD CREATED             06609000
         LA    R15,IDRDATE                                              06610000
         BAL   R14,CONVDATE        CONVERT TO MMDDYY FORMAT             06611000
         SR    R15,R15                                                  06612000
         IC    R15,IDRUPREF+5      LENGTH OF USER DATA AREA             06613000
         BCTR  R15,0                                                    06614000
         STC   R15,IDRLDATA                                             06615000
         SPACE 2                                                        06616000
USER40   BXLE  R3,R4,USERIDR                                            06617000
         EJECT                                                          06618000
         SR    R3,R5                                                    06619000
         BCTR  R3,0                ACTUAL REMAINING LENGTH              06620000
         LTR   R4,R3               CONTINUED DATA PORTION?              06621000
         BNP   NEXTIDR             NO, BRANCH                           06622000
         BAL   R6,IDRCONT          GET THE CONTINUED RECORD AND RETURN  06623000
         SPACE 1                                                        06624000
         SR    R14,R14                                                  06625000
         IC    R14,IDRLDATA        ORIGINAL LENGTH -1                   06626000
         LA    R14,IDRDATA+1(R14)  END OF DATA                          06627000
         SR    R14,R4              START POSTION FOR MOVE               06628000
         BCTR  R4,0                MACHINE LENGTH FOR MOVE              06629000
         MVC   0(*-*,R14),0(R3)    <<EXECUTED>>                         06630000
         EX    R4,*-6              MOVE IN THE REMAINDER                06631000
         LA    R4,1(,R4)           ACTUAL LENGTH OF LAST PORTION        06632000
         B     USER40                                                   06633000
         SPACE 4                                                        06634000
*  AMASPZAP IDR RECORDS:                                                06635000
* --  -- -+ --  --  -- + --  --  --  --  --  --  --  --  --  --  -- --* 06636000
*  0 - 1  |  2 - 4     |  5 - 12                                      * 06637000
*  ESDID  |  ZAP DATE  |  IDRDATA OR USER IDENTIFICATION              * 06638000
* --  -- -+ --  --  -- + --  --  --  --  --  --  --  --  --  --  -- --* 06639000
         SPACE 1                                                        06640000
ZAPIDR   CLI   #ZAPOPT,X'01'       "ZAP"?                               06641000
         BNE   NEXTIDR             NO, BRANCH                           06642000
         SR    R4,R4                                                    06643000
         NI    0(R3),X'3F'                                              06644000
         IC    R4,0(R3)            GET COUNT OF AMASPZAP ENTRIES        06645000
         LA    R3,1(R3)                                                 06646000
         LA    R4,1(R4)            JUMP COUNT FOR LOOP                  06647000
         B     ZAPIDR1                                                  06648000
         SPACE 2                                                        06649000
ZAPIDR2  BAL   R14,GETIDR                                               06650000
         ST    R1,IDRLINK                                               06651000
         LR    R2,R1                                                    06652000
         MVC   IDRESDID,0(R3)      MOVE ESDID TO IDR RECORD             06653000
         LA    R1,2(R3)            ADDRESS OF DATE OF RECORD            06654000
         LA    R15,IDRDATE                                              06655000
         BAL   R14,CONVDATE        CONVERT TO MMDDYY FORMAT             06656000
         SPACE 1                                                        06657000
         MVC   IDRDATA,5(R3)       MOVE DATA TO IDR RECORD              06658000
         MVI   IDRLDATA,8          SET LENGTH FOR COMPATIBILITY         06659000
         MVI   IDRTYPE,IDRZAP      INDICATE AMASPZAP ENTRY              06660000
         LA    R3,13(R3)           JUMP DATA ADDRESS                    06661000
         SPACE 1                                                        06662000
ZAPIDR1  BCT   R4,ZAPIDR2          IF ANOTHER ENTRY THIS RECORD         06663000
         B     NEXTIDR             READ NEXT IDR RECORD                 06664000
         EJECT                                                          06665000
*  TRANSLATOR IDR RECORDS:                                              06666000
* --  -- + --  -- + --  --  --  -- ---+ --  --  --  --  --  --  -- +--- 06667000
*  0 - 1 |  2 - 3 |  N - N+1          |  0    (0 IS 1 TRANSLATOR)  |    06668000
*  ESDID |  ...   |  X'80'+LAST ESDID |  FLAG (1 IS 2 TRANSLATORS) |    06669000
* --  -- + --  -- + --  --  --  -- ---+ --  --  --  --  --  --  -- +--- 06670000
*                                                                       06671000
*   --  --  -- --+ --  -- ---+ --  --  -- -+ --  --  --  --  --  -- --* 06672000
*    1 - 10      |  11 - 12  |  13 -15     |  16 - 30                 * 06673000
*    TRANSLATOR  |  VVMM     |  TRANS DATE |  OPTIONAL, SAME AS 1-15  * 06674000
*   --  --  -- --+ --  -- ---+ --  --  -- -+ --  --  --  --  --  -- --* 06675000
         SPACE 1                                                        06676000
TRANIDR  CLI   #TRANOPT,X'01'      "TRAN"?                              06677000
         BNE   NEXTIDR             NO, BRANCH                           06678000
         LR    R4,R5                                                    06679000
         SR    R4,R3               MACHINE LENGTH OK?                   06680000
         BM    NEXTIDR             NO, DONE WITH THIS RECORD            06681000
         BAL   R14,GETIDR                                               06682000
         ST    R1,IDRLINK          CHAIN ON A                           06683000
         LR    R2,R1                         NEW IDR RECORD             06684000
         SPACE 1                                                        06685000
         MVI   IDRTYPE,IDRTRAN     TRANSLATOR TYPE RECORD               06686000
         LTR   R4,R4               MACHINE LENGTH OK?                   06687000
         BP    TRAN20              YES, NOT SPLIT                       06688000
         MVC   IDRESDID(1),0(R3)   NO, ONLY ONE ESDID BYTE              06689000
         BAL   R6,IDRCONT          GET THE CONTINUED RECORD AND RETURN  06690000
         SPACE 1                                                        06691000
         MVC   IDRESDID+1(1),0(R3) SECOND BYTE OF ESDID                 06692000
         BCTR  R3,0                BACK UP THE INPUT POINTER BY ONE     06693000
         B     TRAN30                                                   06694000
         SPACE 2                                                        06695000
TRAN20   MVC   IDRESDID(2),0(R3)   ESDID FIELD                          06696000
         SPACE 1                                                        06697000
TRAN30   MVC   IDRUPREF(2),IDRESDID  ORIGINAL ESDID                     06698000
         NI    IDRESDID,FF-X'80'   TURN OFF THE HIGH-ORDER BIT          06699000
         TM    IDRUPREF,X'80'      LAST ESDID?                          06700000
         BO    TRAN50              YES, BRANCH                          06701000
         LA    R4,2                ESDID WIDTH                          06702000
         BXLE  R3,R4,TRANIDR       CONTINUE FOR ALL ESDID'S             06703000
         B     NEXTIDR             GET THE NEXT RECORD                  06704000
         SPACE 1                                                        06705000
TRAN50   LA    R3,2(,R3)                                                06706000
         LR    R4,R5                                                    06707000
         SR    R4,R3               FLAG BYTE INPUT?                     06708000
         BNM   TRAN60              YES, BRANCH                          06709000
         BAL   R6,IDRCONT          GET THE CONTINUED RECORD AND RETURN  06710000
         SPACE 1                                                        06711000
TRAN60   LA    R1,14               ASSUME ONE TRANSLATOR                06712000
         CLI   0(R3),0             CORRECT?                             06713000
         BE    *+8                 YES, BRANCH                          06714000
         LA    R1,29               NO, TWO TRANSLATORS                  06715000
         MVC   IDRTDATA(30),1(R3)  MOVE IN THE MAXIMUM LENGTH           06716000
         STC   R1,IDRLDATA         MACHINE LENGTH                       06717000
         LA    R4,2(,R1)           ACTUAL SEGMENT LENGTH                06718000
TRAN70   BXLE  R3,R4,TRAN80                                             06719000
         EJECT                                                          06720000
         LR    R4,R3                                                    06721000
         SR    R4,R5               BYTES LEFT +1                        06722000
         S     R4,=F'1'            ANY ACTUAL REMAINING BYTES?          06723000
         BNP   TRAN80              NO, BRANCH                           06724000
         BAL   R6,IDRCONT          GET THE CONTINUED RECORD AND RETURN  06725000
         SPACE 1                                                        06726000
         SR    R14,R14                                                  06727000
         IC    R14,IDRLDATA        ORIGINAL LENGTH -1                   06728000
         LA    R14,IDRTDATA+1(R14) END OF DATA                          06729000
         SR    R14,R4              START POSTION FOR MOVE               06730000
         BCTR  R4,0                MACHINE LENGTH FOR MOVE              06731000
         MVC   0(*-*,R14),0(R3)    <<EXECUTED>>                         06732000
         EX    R4,*-6              MOVE IN THE REMAINDER                06733000
         LA    R3,1(R3,R4)         POSITION FOR THE NEXT SEGMENT        06734000
         SPACE 2                                                        06735000
TRAN80   LA    R1,IDRTDATA+12      ADDRESS OF CREATION YYDDD            06736000
         LA    R15,IDRDATE                                              06737000
         BAL   R14,CONVDATE        CONVERT TO MMDDYY FORMAT             06738000
         LA    R1,#IDRPTR          SCAN IDR CHAIN                       06739000
         SPACE 1                                                        06740000
TRAN90   ICM   R1,B'1111',IDRLINK-IDRENTRY(R1)                          06741000
         BZ    TRANIDR                        DONE, BRANCH              06742000
         CLI   IDRTYPE-IDRENTRY(R1),IDRTRAN   TRANSLATOR TYPE?          06743000
         BNE   TRAN90                         NO, BRANCH                06744000
         CLI   IDRDATE-IDRENTRY(R1),0         ANY DATE YET?             06745000
         BNE   TRAN90                         YES, BRANCH               06746000
         MVC   IDRDATE-IDRENTRY(3+6+1+30,R1),IDRDATE                    06747000
         B     TRAN90                                                   06748000
         DROP  R2                                                       06749000
         SPACE 3                                                        06750000
*  LINKAGE EDITOR IDR RECORDS:                                          06751000
* --  --  --  --  -- ---+ --  -- ---+ --  --  --  --  --  --  --  -- -* 06752000
*  0 - 9                |  10 - 11  |  12 - 14                        * 06753000
*  LINKAGE EDITOR NAME  |  VVMM     |  LINKAGE EDIT DATE              * 06754000
* --  --  --  --  -- ---+ --  -- ---+ --  --  --  --  --  --  --  -- -* 06755000
         SPACE 1                                                        06756000
LKEDIDR  OI    FLAGSCC,FIDR                                             06757000
         LA    R1,12(R3)           ADDRESS OF DATE                      06758000
         LA    R15,LKEDDATE                                             06759000
         BAL   R14,CONVDATE        CONVERT TO MMDDYY FORMAT             06760000
         MVC   LKEDNAME(10),0(R3)  LINKAGE EDITOR NAME                  06761000
         MVC   LKEDVVMM(2),10(R3)  VV.MM IN HEX                         06762000
         SPACE 2                                                        06763000
NEXTIDR  LA    R6,IDRNORML         NOT A CONTINUED RECORD               06764000
         SPACE 1                                                        06765000
IDRCONT  B     IDREXCP             CONTINUED RECORD                     06766000
         EJECT                                                          06767000
LASTIDR  MVC   RLDCOUNT(1),3(R15)    SAVE THE FIRST RLD/CONTROL AMOUNT  06768000
         OC    #ZAPLEN(3),#ZAPLEN    ANY IDR FILTERING?                 06769000
         BZ    LASTIDRZ              NO, BRANCH                         06770000
         SPACE 2                                                        06771000
         USING IDRENTRY,R3                                              06772000
         SR    R4,R4                                                    06773000
         LA    R3,#IDRPTR            SCAN IDR CHAIN                     06774000
IDRFIL10 LR    R2,R3                 PREVIOUS ENTRY                     06775000
         ICM   R3,B'0111',IDRLINK+1  CURRENT ENTRY?                     06776000
         BZ    LASTIDRZ              NO, BRANCH                         06777000
         ICM   R4,B'0111',IDRLINK+1  NEXT ENTRY                         06778000
         SPACE 2                                                        06779000
         SR    R15,R15               COMPARE STRING LENGTH              06780000
         CLI   IDRTYPE,IDRTRAN       IDR TYPE:                          06781000
         BH    IDRFIL40                USER, BRANCH                     06782000
         BL    IDRFIL30                ZAP, BRANCH                      06783000
         LA    R1,#TRANTXT             TRANSLATOR                       06784000
         SPACE 1                                                        06785000
         ICM   R15,B'0001',#TRANLEN  ANY TRANSLATOR FILTERING?          06786000
         BZ    IDRFIL10              NO, BRANCH                         06787000
         CLI   IDRLDATA,15           ONE TRANSLATOR ONLY?               06788000
         BL    IDRFIL60              YES, BRANCH                        06789000
         BCTR  R15,0                 COMPARE MACHINE LENGTH             06790000
         CLC   IDRTDATA+15(*-*),#TRANTXT  <<EXECUTED>>                  06791000
         EX    R15,*-6                    THIS PL/S TRANSLATOR?         06792000
         BE    IDRFIL10                   YES, BRANCH                   06793000
         IC    R15,#TRANLEN          COMPARE STRING LENGTH (AGAIN)      06794000
         B     IDRFIL60              CHECK THE FIRST TRANSLATOR TOO     06795000
         SPACE 2                                                        06796000
IDRFIL30 IC    R15,#ZAPLEN           ZAP IDR RECORD                     06797000
         LA    R1,#ZAPTXT                                               06798000
         B     IDRFIL60                                                 06799000
         SPACE 2                                                        06800000
IDRFIL40 IC    R15,#USERLEN          USER IDR RECORD                    06801000
         LA    R1,#USERTXT                                              06802000
         SPACE 2                                                        06803000
IDRFIL60 S     R15,=F'1'             VALID MACHINE LENGTH?              06804000
         BM    IDRFIL10              NO, BRANCH                         06805000
         SPACE 1                                                        06806000
         CLC   IDRDATA(*-*),0(R1)    <<EXECUTED>>                       06807000
         EX    R15,*-6               PARTIAL NAME MATCH?                06808000
         BE    IDRFIL10              YES, BRANCH                        06809000
         SPACE 1                                                        06810000
         LR    R3,R2                 NO, UNCHAIN THE                    06811000
         ST    R4,IDRLINK                           CURRENT ENTRY       06812000
         B     IDRFIL10                                                 06813000
         EJECT                                                          06814000
LASTIDRZ LA    R3,#IDRPTR          PERFORM AN IDR RECORD SORT           06815000
         SPACE 2                                                        06816000
SORTIDR  ICM   R3,B'1111',IDRLINK                                       06817000
         BZ    SORTIDRZ                                                 06818000
         LR    R1,R3                                                    06819000
         SPACE 1                                                        06820000
SORTIDR2 ICM   R1,B'1111',IDRLINK-IDRENTRY(R1)    GET THE NEXT ENTRY    06821000
         BZ    SORTIDR                                                  06822000
         SPACE 1                                                        06823000
         ICM   R0,B'1110',IDRDATE   ==> SORT BY DATE (DESCENDING ORDER) 06824000
         CLM   R0,B'0010',IDRDATE-IDRENTRY+2(R1)  THIRD BYTE:THIRD BYTE 06825000
         BH    SORTIDR2                           HIGH - NO SWITCH      06826000
         BL    SORTIDR3                           LOW  - NO SWITCH      06827000
         CLM   R0,B'1000',IDRDATE-IDRENTRY+0(R1)  FIRST BYTE:FIRST BYTE 06828000
         BH    SORTIDR2                           HIGH - NO SWITCH      06829000
         BL    SORTIDR3                           LOW  - NO SWITCH      06830000
         CLM   R0,B'0100',IDRDATE-IDRENTRY+1(R1)  SECONDBYTE:SECONDBYTE 06831000
         BNL   SORTIDR2                           HIGH/EQUAL - BRANCH   06832000
         SPACE 1                                                        06833000
SORTIDR3 XC    IDRSTART(LENIDR1),IDRSTART-IDRENTRY(R1)                  06834000
         XC    IDRSTART-IDRENTRY(LENIDR1,R1),IDRSTART                   06835000
         XC    IDRSTART(LENIDR1),IDRSTART-IDRENTRY(R1)                  06836000
         B     SORTIDR2                                                 06837000
         SPACE 1                                                        06838000
SORTIDRZ LM    R14,R12,ESDIDRSV    RESTORE REGISTERS                    06839000
         TM    FLAGSCC,FIDR        ANY IDR RECORDS?                     06840000
         BZR   R14                 NO, RETURN AT +0                     06841000
         B     4(,R14)             YES, RETURN AT +4                    06842000
         DROP  R3                                                       06843000
         SPACE 2                                                        06844000
GETIDR   CLC   ##SUBCOM(8),$ATT      ATTRIB SUBCOMMAND?                 06845000
         BE    NEXTIDR               YES, IGNORE THE RECORD             06846000
         MVI   SUBPOOLT,21                                              06847000
         LA    R0,LENIDR                                                06848000
         ICM   R0,B'1000',SUBPOOLT   SUBPOOL 21                         06849000
         GETMAIN R,LV=(0)                                               06850000
         XC    0(LENIDR,R1),0(R1)                                       06851000
         OI    FLAGSCC,FIDR          IDR DATA EXISTS                    06852000
         BR    R14                                                      06853000
         TITLE 'P D S  --  PDS IF                        1/15/85'       06854000
*********************************************************************** 06855000
***      IF SUBCOMMAND         ADDED BY BRUCE LELAND -- JAN., 1983  *** 06856000
*********************************************************************** 06857000
*                                                                       06858000
         SPACE 1                                                        06859000
IF       CSECT                                                          06860000
         USING *,R8                                                     06861000
         OC    #ACTIONT(8),#ACTIONT   ANY THEN OR ELSE?                 06862000
         BNZ   *+10                   YES, BRANCH                       06863000
         MVC   #ACTIONT(4),THENTBL+4  DEFAULT THEN ACTION IS ATTRIB     06864000
         SPACE 1                                                        06865000
         TM    #OPTOPT,X'80'        PARSE INVOKED?                      06866000
         BNO   IF996                NO, DONE                            06867000
         CLC   #ATTRLO(3),DIRTTR    IN TTR LOWER BOUND?                 06868000
         BH    IF997                NO, DO ANY ELSE                     06869000
         CLC   #ATTRHI(3),DIRTTR    IN TTR UPPER BOUND?                 06870000
         BL    IF997                NO, DO ANY ELSE                     06871000
         SPACE 1                                                        06872000
         TM    FLAGSCC,RECFMU       A LOAD LIBRARY?                     06873000
         BO    IF006                YES, BRANCH                         06874000
         LA    R1,L701              ASSUME LINKEDIT ATTRIBUTES          06875000
         TM    #OPTOPT,X'01'        CORRECT?                            06876000
         BO    MSGNEWXX             YES, ERROR                          06877000
         B     IF016                                                    06878000
         SPACE 2                                                        06879000
IF006    MVC   MODESAVE(1),DIRATTR3 RMODE/AMODE BYTE                    06880000
         TM    DIRATTR2,DIRAOSLE    VS LINKAGE EDITOR?                  06881000
         BO    *+8                  YES, BRANCH                         06882000
         MVI   MODESAVE,0           NO, NO MVS/XA BITS                  06883000
         SR    R15,R15                                                  06884000
         IC    R15,MODESAVE                                             06885000
         SRA   R15,2                AMODE FOR ALIAS                     06886000
         TM    DIRFLAG,X'80'        ALIAS?                              06887000
         BNO   *+8                  NO, BRANCH                          06888000
         STC   R15,MODESAVE         YES, USE ALIAS AMODE BITS           06889000
         NI    MODESAVE,DIRAM64+DIRAM31 TURN OFF OTHER BITS        @D02
         SPACE 3                                                        06891000
IF016    CLI   #RMODE,X'01'         ANY RMODE SELECTION?                06892000
         BL    IF036                NO, BRANCH                          06893000
         MVC   DOUBLE(1),DIRATTR3   RMODE/AMODE BYTE                    06894000
         NI    DOUBLE,DIRRMANY      TURN OFF OTHER BITS                 06895000
         TM    DIRATTR2,DIRAOSLE    VS LINKAGE EDITOR?                  06896000
         BO    *+8                  YES, BRANCH                         06897000
         MVI   DOUBLE,0             NO, NO MVS/XA BITS                  06898000
         SR    R15,R15                                                  06899000
         IC    R15,#RMODE                                               06900000
         SLA   R15,2                #RMODE*4                            06901000
         B     *(R15)               CHECK FOR:                          06902000
         B     IF020                  RMODE=24                          06903000
         B     IF030                  RMODE=ANY                         06904000
         B     IF030                  NO RMODE=24                       06905000
         B     IF020                  NO RMODE=ANY                      06906000
IF020    CLI   DOUBLE,0             RMODE=24?                           06907000
         BNE   IF997                NO, DO ANY ELSE                     06908000
         B     IF036                YES, BRANCH                         06909000
IF030    CLI   DOUBLE,0             RMODE=24?                           06910000
         BE    IF997                YES, DO ANY ELSE                    06911000
         SPACE 3                                                        06912000
IF036    CLI   #AMODE,X'01'         ANY AMODE SELECTION?                06913000
         BL    IF102                NO, BRANCH                          06914000
         SR    R15,R15                                                  06915000
         IC    R15,#AMODE                                               06916000
         SLA   R15,2                #AMODE*4                            06917000
         B     *(R15)               CHECK FOR:                          06918000
         B     IF040                  AMODE=24                          06919000
         B     IF050                  AMODE=31                          06920000
         B     IF060                  AMODE=ANY                         06921000
         B     IF070                  NO AMODE=24                       06922000
         B     IF080                  NO AMODE=31                       06923000
         B     IF090                  NO AMODE=ANY                      06924000
IF040    CLI   MODESAVE,DIRAM24     AMODE=24?                           06925000
         BH    IF997                NO, DO ANY ELSE                     06926000
         B     IF102                YES, BRANCH                         06927000
IF050    CLI   MODESAVE,DIRAM31     AMODE=31?                           06928000
         BNE   IF997                NO, DO ANY ELSE                     06929000
         B     IF102                YES, BRANCH                         06930000
IF055    CLI   MODESAVE,DIRAM64     AMODE=64?                      @D02
         BNE   IF997                NO, DO ANY ELSE                @D02
         B     IF102                YES, BRANCH                    @D02
IF060    CLI   MODESAVE,DIRAM64+DIRAM31  AMODE=ANY?                @D02
         BNE   IF997                     NO, DO ANY ELSE                06932000
         B     IF102                     YES, BRANCH                    06933000
IF070    CLI   MODESAVE,DIRAM24     AMODE=24?                           06934000
         BNH   IF997                YES, DO ANY ELSE                    06935000
         B     IF102                NO, BRANCH                          06936000
IF080    CLI   MODESAVE,DIRAM31     AMODE=31?                           06937000
         BE    IF997                YES, DO ANY ELSE                    06938000
         B     IF102                NO, BRANCH                          06939000
IF085    CLI   MODESAVE,DIRAM64     AMODE=64?                      @D02
         BE    IF997                YES, DO ANY ELSE               @D02
         B     IF102                NO, BRANCH                     @D02
IF090    CLI   MODESAVE,DIRAM64+DIRAM31  AMODE=ANY?                @D02
         BE    IF997                     YES, DO ANY ELSE               06941000
         SPACE 3                                                        06942000
IF102    CLI   #ALIAOPT,X'01'       "ALIAS" OR "NOALIAS"?               06943000
         BL    IF106                NEITHER, BRANCH                     06944000
         BH    IF104                "NOALIAS", BRANCH                   06945000
         TM    DIRFLAG,X'80'        "ALIAS" -- CORRECT?                 06946000
         BO    IF106                YES, BRANCH                         06947000
         B     IF997                NO, DO ANY ELSE                     06948000
IF104    TM    DIRFLAG,X'80'        ALIAS?                              06949000
         BO    IF997                YES, DO ANY ELSE                    06950000
         SPACE 3                                                        06951000
IF106    CLI   #VSLKED,X'01'        "VSLKED" OR "NOVSLKED"?             06952000
         BL    IF110                NEITHER, BRANCH                     06953000
         BH    IF108                "NOVSLKED", BRANCH                  06954000
         TM    DIRATTR2,DIRAOSLE    "VSLKED" -- CORRECT?                06955000
         BO    IF110                YES, BRANCH                         06956000
         B     IF997                NO, DO ANY ELSE                     06957000
IF108    TM    DIRATTR2,DIRAOSLE    VSLKED?                             06958000
         BO    IF997                YES, DO ANY ELSE                    06959000
         SPACE 3                                                        06960000
IF110    CLI   #AUTHOPT,X'01'       "AUTH" OR "NOAUTH"?                 06961000
         BL    IF113                NEITHER, BRANCH                     06962000
         LA    R2,ZERO              ASSUME NOT AUTHORIZED               06963000
         TM    DIRATTR2,DIRAOSLE+DIRAPFLG  APF INFORMATION AVAILABLE?   06964000
         BNO   IF111                       NO, NOT AUTHORIZED           06965000
         LA    R2,DIRAPF            BASIC APF DATA START                06966000
         TM    DIRATTR,ATTRSCTR     SCATTER LOADED?                     06967000
         BNO   *+8                  NO, BRANCH                          06968000
         LA    R2,8(,R2)            YES, EIGHT MORE BYTES               06969000
         TM    DIRFLAG,X'80'        ALIAS?                              06970000
         BO    *+12                 YES, BRANCH                         06971000
         CLI   8(R2),0              CONVERTED ALIAS ENTRY?              06972000
         BE    *+8                  NO, BRANCH                          06973000
         LA    R2,11(,R2)           ADD ALIAS LENGTH                    06974000
         TM    DIRATTR2,DIR2SSI     SSI INFORMATION?                    06975000
         BNO   IF111                NO, BRANCH                          06976000
         LA    R2,5(,R2)            YES, FOUR MORE BYTES                06977000
         N     R2,=F'-2'                                ROUNDED         06978000
IF111    CLI   #AUTHOPT,X'01'       "AUTH" OR "NOAUTH"                  06979000
         BH    IF112                "NOAUTH", BRANCH                    06980000
         CLI   0(R2),X'01'          CORRECT APF LENGTH?                 06981000
         BNE   IF997                NO, CANNOT BE AUTHORIZED            06982000
         CLI   1(R2),0              "AUTH" -- CORRECT?                  06983000
         BH    IF113                YES, BRANCH                         06984000
         B     IF997                NO, DO ANY ELSE                     06985000
IF112    CLI   0(R2),X'01'          CORRECT APF LENGTH?                 06986000
         BNE   IF113                NO, CANNOT BE AUTHORIZED            06987000
         CLI   1(R2),0              AUTHORIZED?                         06988000
         BH    IF997                YES, DO ANY ELSE                    06989000
         SPACE 3                                                        06990000
IF113    CLI   #APFERR,X'01'        "APFERR" OR "NOAPFERR"?             06991000
         BL    IF116                NEITHER, BRANCH                     06992000
         LA    R2,=X'01010101'      ASSUME NO APF ERROR                 06993000
         TM    DIRATTR2,DIRAOSLE+DIRAPFLG  APF INFORMATION AVAILABLE?   06994000
         BNO   IF114                       NO, NO APF ERROR             06995000
         LA    R2,DIRAPF            BASIC APF DATA START                06996000
         TM    DIRATTR,ATTRSCTR     SCATTER LOADED?                     06997000
         BNO   *+8                  NO, BRANCH                          06998000
         LA    R2,8(,R2)            YES, EIGHT MORE BYTES               06999000
         TM    DIRFLAG,X'80'        ALIAS?                              07000000
         BO    *+12                 YES, BRANCH                         07001000
         CLI   8(R2),0              CONVERTED ALIAS ENTRY?              07002000
         BE    *+8                  NO, BRANCH                          07003000
         LA    R2,11(,R2)           ADD ALIAS LENGTH                    07004000
         TM    DIRATTR2,DIR2SSI     SSI INFORMATION?                    07005000
         BNO   IF114                NO, BRANCH                          07006000
         LA    R2,5(,R2)            YES, FOUR MORE BYTES                07007000
         N     R2,=F'-2'                                ROUNDED         07008000
IF114    CLI   #APFERR,X'01'        "APFERR" OR "NOAPFERR"              07009000
         BH    IF115                "NOAPFERR", BRANCH                  07010000
         CLI   0(R2),X'01'          CORRECT APF LENGTH?                 07011000
         BE    IF997                YES, DO ANY ELSE                    07012000
         B     IF116                NO, BRANCH                          07013000
IF115    CLI   0(R2),X'01'          CORRECT APF LENGTH?                 07014000
         BNE   IF997                NO, DO ANY ELSE                     07015000
         SPACE 3                                                        07016000
IF116    CLI   #PAGEOPT,X'01'       "PAGE" OR "NOPAGE"?                 07017000
         BL    IF120                NEITHER, BRANCH                     07018000
         BH    IF118                "NOPAGE", BRANCH                    07019000
         TM    DIRATTR2,DIR2PAGA    "PAGE" -- CORRECT?                  07020000
         BO    IF120                YES, BRANCH                         07021000
         B     IF997                NO, DO ANY ELSE                     07022000
IF118    TM    DIRATTR2,DIR2PAGA    PAGE?                               07023000
         BO    IF997                YES, DO ANY ELSE                    07024000
         SPACE 3                                                        07025000
IF120    CLI   #SSIOPT,X'01'        "SSI" OR "NOSSI"?                   07026000
         BL    IF130                NEITHER, BRANCH                     07027000
         TM    FLAGSCC,RECFMU       RECFM=U?                            07028000
         BO    IF122                YES, BRANCH                         07029000
         LA    R2,ZERO              ASSUME NO SSI                       07030000
         TM    DIRFLAG,X'0F'        SPF STATISTICS?                     07031000
         BO    IF124                YES, NO SSI INFORMATION             07032000
         LA    R2,DIRUSER           POINT TO SSI INFORMATION            07033000
         B     IF124                CHECK FOR ANY SSI                   07034000
IF122    LA    R2,DIRAPF            BASIC APF DATA START                07035000
         TM    DIRATTR,ATTRSCTR     SCATTER LOADED?                     07036000
         BNO   *+8                  NO, BRANCH                          07037000
         LA    R2,8(,R2)            YES, EIGHT MORE BYTES               07038000
         TM    DIRFLAG,X'80'        ALIAS?                              07039000
         BO    *+12                 YES, BRANCH                         07040000
         CLI   8(R2),0              CONVERTED ALIAS ENTRY?              07041000
         BE    *+8                  NO, BRANCH                          07042000
         LA    R2,11(,R2)           ADD ALIAS LENGTH                    07043000
         TM    DIRATTR2,DIRAOSLE    VS LINKAGE EDITOR?                  07044000
         BNO   IF124                NO, BRANCH                          07045000
         TM    DIRATTR2,DIR2SSI     SSI INFORMATION?                    07046000
         BNO   IF128                NO, BRANCH                          07047000
IF124    LA    R2,1(,R2)            ROUND TO START                      07048000
         N     R2,=F'-2'                          OF NEXT HALFWORD      07049000
         CLC   ZERO,0(R2)           ZERO?                               07050000
         BE    IF128                YES, NO SSI                         07051000
         CLC   =F'-1',0(R2)         ALL ONES?                           07052000
         BE    IF128                YES, NO SSI                         07053000
IF126    CLI   #SSIOPT,X'01'        SEARCH FOR "SSI"?                   07054000
         BNE   IF997                NO, BRANCH                          07055000
         OC    #SSITEXT(4),#SSITEXT ANY SSI SEARCH?                     07056000
         BZ    IF130                NO, BRANCH                          07057000
         CLC   0(4,R2),#SSITEXT     THIS SSI?                           07058000
         BE    IF130                YES, BRANCH                         07059000
         B     IF997                NO, DO ANY ELSE                     07060000
IF128    CLI   #SSIOPT,X'01'        SEARCH FOR "SSI"?                   07061000
         BE    IF997                YES, DO ANY ELSE                    07062000
         SPACE 3                                                        07063000
IF130    TM    FLAGSCC,RECFMU       RECFM=U?                            07064000
         BNO   IF140                NO, BRANCH                          07065000
         SR    R1,R1                                                    07066000
         ICM   R1,B'0001',#ATTRYES  ANY YES+0 ATTRIBUTES?               07067000
         BZ    IF132                NO, BRANCH                          07068000
         TM    DIRATTR,*-*          <<EXECUTED>>                        07069000
         EX    R1,*-4               ALL ATTRIBUTES MATCH?               07070000
         BNO   IF997                NO, DO ANY ELSE                     07071000
         SPACE 1                                                        07072000
IF132    ICM   R1,B'0001',#ATTRYES+1 ANY YES+1 ATTRIBUTES?              07073000
         BZ    IF134                NO, BRANCH                          07074000
         TM    DIRATTR+1,*-*        <<EXECUTED>>                        07075000
         EX    R1,*-4               ALL ATTRIBUTES MATCH?               07076000
         BNO   IF997                NO, DO ANY ELSE                     07077000
         SPACE 1                                                        07078000
IF134    ICM   R1,B'0001',#ATTRNO   NO+0 ATTRIBUTES                     07079000
         TM    DIRATTR,*-*          <<EXECUTED>>                        07080000
         EX    R1,*-4               ANY ATTRIBUTES MATCH?               07081000
         BNZ   IF997                YES, DO ANY ELSE                    07082000
         SPACE 1                                                        07083000
         ICM   R1,B'0001',#ATTRNO+1 NO+1 ATTRIBUTES                     07084000
         TM    DIRATTR+1,*-*        <<EXECUTED>>                        07085000
         EX    R1,*-4               ANY ATTRIBUTES MATCH?               07086000
         BNZ   IF997                YES, DO ANY ELSE                    07087000
         SPACE 3                                                        07088000
IF140    CLI   #USERIDO,X'01'       USERID, NOUSERID OR NOTUSERID?      07089000
         BL    IF144                NO, BRANCH                          07090000
         LA    R1,L702              ASSUME DATA SET IS A LOAD MODULE    07091000
         TM    FLAGSCC,RECFMU       CORRECT?                            07092000
         BO    MSGNEWXX             YES, ERROR                          07093000
         TM    DIRFLAG,X'0F'        SPF STATISTICS?                     07094000
         BNO   IF143                NO, BRANCH                          07095000
         CLI   #USERIDO,X'02'       "NOUSERID" DESIRED?                 07096000
         BE    IF997                YES, DO ANY ELSE                    07097000
         SR    R1,R1                                                    07098000
         ICM   R1,B'0001',#USERIDL  ANY USERID FILTERING?               07099000
         BP    IF141                YES, BRANCH                         07100000
         CLI   #USERIDO,X'01'       "USERID" DESIRED?                   07101000
         BE    IF144                YES, BRANCH                         07102000
         B     IF997                NO, DO ANY ELSE                     07103000
         SPACE 1                                                        07104000
IF141    BCTR  R1,0                 MACHINE LENGTH                      07105000
         CLI   #USERIDO,X'01'       "USERID" DESIRED?                   07106000
         BNE   IF142                NO, BRANCH                          07107000
         EX    R1,IF142             PARTIAL USERID MATCH?               07108000
         BNE   IF997                NO, DO ANY ELSE                     07109000
         B     IF144                YES, BRANCH                         07110000
         SPACE 1                                                        07111000
IF142    CLC   #USERTXT(*-*),DIRSPFID <<EXECUTED>>                      07112000
         EX    R1,*-6               PARTIAL USERID MATCH?               07113000
         BE    IF997                YES, DO ANY ELSE                    07114000
         B     IF144                NO, BRANCH                          07115000
         SPACE 1                                                        07116000
IF143    CLI   #USERIDO,X'01'       "USERID" DESIRED?                   07117000
         BE    IF997                YES, DO ANY ELSE                    07118000
         SPACE 3                                                        07119000
IF144    TM    #OPTOPT,X'02'        NEED ANY MAP OR HISTORY DATA?       07120000
         BNO   IF156                NO, BRANCH                          07121000
         MVI   RLDCOUNT,X'FF'       ASSUME NO RLD/CONTROL DATA FOUND    07122000
         SPACE 1                                                        07123000
         L     R15,=A(READESD)                                          07124000
         BALR  R14,R15              ANY ESD DATA?                       07125000
         NOP   0                    NO, IGNORE                          07126000
         SPACE 1                                                        07127000
         ICM   R2,B'1110',#ZAPOPT       SAVE ZAP/USER/TRAN              07128000
         MVC   #ZAPOPT(3),=X'01010101'  CHECK ZAP/USER/TRAN             07129000
         MVC   LKEDDATE+2,X'FF'         NO LINKAGE-EDIT DATE FOUND      07130000
         L     R15,=A(READIDR)                                          07131000
         BALR  R14,R15              ANY IDR DATA?                       07132000
         B     IF145                NO, BRANCH                          07133000
         SPACE 2                                                        07134000
         MVI   #LKEDOPT,0           ASSUME LINKAGE-EDITOR FOUND         07135000
         SR    R1,R1                                                    07136000
         ICM   R1,B'0001',#LKEDLEN  ANY LKED NAME CHECK?                07137000
         BZ    IF145                NO, BRANCH                          07138000
         BCTR  R1,0                 MACHINE COMPARE LENGTH              07139000
         CLC   LKEDNAME(*-*),#LKEDTXT  <<EXECUTED>>                     07140000
         EX    R1,*-6               THIS PARTIAL LKED NAME?             07141000
         BE    IF145                YES, BRANCH                         07142000
         MVI   #LKEDOPT,1           NO, LINKAGE-EDITOR NOT FOUND        07143000
         SPACE 1                                                        07144000
IF145    OC    #IFCREIF(6),#IFCREIF        ANY CREATION DATE RANGE?     07145000
         BZ    IF146                       NO, CONTINUE                 07146000
         ICM   R1,B'0100',LKEDDATE+2       YY OF MMDDYY                 07147000
         ICM   R1,B'0011',LKEDDATE         MMDD OF MMDDYY               07148000
         CLM   R1,B'0111',#IFCREIF         DATA VALUE < FIRST YYMMDD?   07149000
         BL    IF997                       YES, DO ANY ELSE             07150000
         CLM   R1,B'0111',#IFCREIF+3       DATA VALUE > SECOND YYMMDD?  07151000
         BH    IF997                       YES, DO ANY ELSE             07152000
         SPACE 2                                                        07153000
IF146    STCM  R2,B'1110',#ZAPOPT   RESTORE ZAP/USER/TRAN               07154000
         USING ESDENTRY,R2                                              07155000
         LA    R2,#ESDPTR           SCAN ESD CHAIN                      07156000
         SPACE 1                                                        07157000
IF148    ICM   R2,B'1111',ESDLINK   ANY MORE ESD ENTRIES?               07158000
         BZ    IF154                NO, BRANCH                          07159000
         CLI   ESDTYPE,CODESD       CSECT ESD ENTRY?                    07160000
         BNE   IF148                NO, BRANCH                          07161000
         SPACE 1                                                        07162000
         USING IDRENTRY,R3                                              07163000
         LA    R3,#IDRPTR           SCAN IDR CHAIN                      07164000
         SPACE 1                                                        07165000
IF150    ICM   R3,B'1111',IDRLINK   ANY MORE IDR ENTRIES?               07166000
         BZ    IF148                NO, BRANCH                          07167000
         CLC   ESDID,IDRESDID       THIS CSECT IDENTIFIER?              07168000
         BNE   IF150                NO, BRANCH                          07169000
         SPACE 1                                                        07170000
         MVI   #MODOPT,0            YES, MODULE FOUND                   07171000
         CLI   IDRTYPE,IDRTRAN      ZAP RECORD?                         07172000
         BNL   IF152                NO, BRANCH                          07173000
         MVI   #ZAPOPT,0            YES, ZAP RECORDS MATCH              07174000
         OC    #IFMODIF(6),#IFMODIF       ANY MODIFICATION CHECK?       07175000
         BE    IF152                      NO, BRANCH                    07176000
         ICM   R1,B'0100',IDRDATE+2       YY OF MMDDYY                  07177000
         ICM   R1,B'0011',IDRDATE         MMDD OF MMDDYY                07178000
         CLM   R1,B'0111',#IFMODIF        DATA VALUE < FIRST YYMMDD?    07179000
         BL    IF152                      YES, NO MATCH                 07180000
         CLM   R1,B'0111',#IFMODIF+3      DATA VALUE > SECOND YYMMDD?   07181000
         BH    IF152                      YES, NO MATCH                 07182000
         XC    #IFMODIF(6),#IFMODIF       A MODIFICATION RECORD MATCHES 07183000
         SPACE 1                                                        07184000
IF152    CLI   IDRTYPE,IDRTRAN      IDR RECORD TYPE:                    07185000
         BNH   *+8                                                      07186000
         MVI   #USEROPT,0              **USER                           07187000
         BNE   *+8                                                      07188000
         MVI   #TRANOPT,0              **TRANSLATOR                     07189000
         B     IF150                                                    07190000
         DROP  R2,R3                                                    07191000
IF154    OC    #IFMODIF(6),#IFMODIF ANY CHANGES MATCH?                  07192000
         BNZ   IF997                NO, DO ANY ELSE CONDITIONS          07193000
         SPACE 1                                                        07194000
IF156    OC    #ZAPOPT(5),#ZAPOPT   ZAP/USER/TRAN/LKED/MODULE FOUND?    07195000
         BNZ   IF997                NO, DO ANY ELSE                     07196000
         SPACE 3                                                        07197000
         TM    DIRATTR2,DIRAOSLE    OS/VS LINKAGE EDITOR?               07198000
         BO    *+10                 YES, BRANCH                         07199000
         MVC   RLDCOUNT(1),DIRATTR4 NO, WANT MATCHING RLD/CONTROL       07200000
         CLI   #RLDERR,X'01'        "RLDERR" OR "NORLDERR"              07201000
         BL    IF160                NEITHER, BRANCH                     07202000
         BH    IF158                "NORLDERR", BRANCH                  07203000
         CLC   DIRATTR4(1),RLDCOUNT "RLDERR" -- CORRECT?                07204000
         BNE   IF160                YES, BRANCH                         07205000
         B     IF997                NO, DO ANY ELSE                     07206000
IF158    CLC   DIRATTR4(1),RLDCOUNT "NORLDERR" -- CORRECT?              07207000
         BNE   IF997                YES, DO ANY ELSE                    07208000
         SPACE 3                                                        07209000
IF160    NI    #IFABOVE,FF-X'01'    ASSUME SIZE IS NOT AVAILABLE        07210000
         TM    #IFABOVE,X'80'       ANY ABOVE CODED?                    07211000
         BO    IF164                YES, BRANCH                         07212000
         TM    #IFBELOW,X'80'       ANY BELOW CODED?                    07213000
         BZ    IF170                NO, BRANCH                          07214000
         SPACE 1                                                        07215000
IF164    SR    R1,R1                                                    07216000
         ICM   R1,B'0111',DIRSTORE  MODULE SIZE                         07217000
         TM    FLAGSCC,RECFMU       RECFM=U?                            07218000
         BO    IF168                YES, BRANCH                         07219000
         TM    DIRFLAG,X'0F'        SPF STATISTICS PRESENT?             07220000
         BNO   IF180                NO, BRANCH                          07221000
         OC    DIRSPFZ(3),DIRSPFZ   RESERVED AND 00 OF 00YYDDDF ZEROS?  07222000
         BNZ   IF180                NO, BRANCH                          07223000
         CLI   DIRSPFCD,0           00 OF OTHER 00YYDDDF ZERO?          07224000
         BNZ   IF180                NO, BRANCH                          07225000
         LH    R1,DIRSPFSI                                              07226000
         SPACE 1                                                        07227000
IF168    OI    #IFABOVE,X'01'       SIZE IS AVAILABLE                   07228000
         ST    R1,#IFLEN            LENGTH OF THE MEMBER                07229000
         SPACE 1                                                        07230000
IF170    TM    #OPTOPT,X'04'        NEED TO READ THE MEMBER?            07231000
         BNO   IF300                NO, BRANCH                          07232000
         SPACE 1                                                        07233000
IF180    SR    R6,R6                COUNT OF INPUT LOGICAL RECORDS      07234000
         CLC   DIRTTR(3),DS1LSTAR   BEYOND END OF DATA MARKER?          07235000
         BNL   IF242                YES, DONE                           07236000
         OI    ##ADRPA#,$Q          QUIET MODE READ IS REQUIRED         07237000
         MVC   STARTTR(3),DIRTTR    FIRST DISK ADDRESS TO READ          07238000
         SPACE 3                                                        07239000
IF204    L     R15,=A(EXCP)                                             07240000
         BALR  R14,R15                                                  07241000
         B     *+4(R15)             PROCESS RETURN CODE                 07242000
         B     IF208                  00 - SUCCESSFUL READ              07243000
         B     IF240                  04 - END OF MEMBER                07244000
         B     IF240                  08 - END OF DATA SET              07245000
         B     IF242                  12 - I/O ERROR                    07246000
         SPACE 2                                                        07247000
IF208    LR    R3,R0                BUFFER START                        07248000
         L     R5,LS                BLOCK LENGTH                        07249000
         CH    R5,BLKSI             BLKSIZE VALID?                      07250000
         BNH   IF220                YES, BRANCH                         07251000
         OI    #OPTOPT,X'20'        NO, INDICATE A BLOCKSIZE ERROR      07252000
         SPACE 1                                                        07253000
IF220    TM    FLAGSCC,RECFMF       FIXED FORMAT?                       07254000
         BNO   IF222                NO, BRANCH                          07255000
         LH    R14,LRECL            CURRENT LRECL                       07256000
         LR    R0,R5                BLOCK LENGTH                        07257000
         SRDA  R0,32                                                    07258000
         DR    R0,R14               BLKSIZE/LRECL                       07259000
         LTR   R0,R0                ANY REMAINDER?                      07260000
         BZ    IF222                YES, BRANCH                         07261000
         OI    #OPTOPT,X'10'        NOTE: LRECL ERROR (BLKSIZE/LRECL)   07262000
         SPACE 1                                                        07263000
IF222    LR    R1,R5                                                    07264000
         AR    R5,R3                END OF BUFFER                       07265000
         BCTR  R5,0                 END OF BUFFER -1                    07266000
         TM    FLAGSCC,RECFMF       RECFM=F?                            07267000
         LH    R4,LRECL                                                 07268000
         BO    IF228                YES, BRANCH                         07269000
         TM    FLAGSCC,RECFMU       RECFM=U?                            07270000
         LR    R4,R1                                                    07271000
         BO    IF228                YES, BRANCH                         07272000
         TM    FLAGSCC,RECFMV       RECFM=V?                            07273000
         BNO   IF228                NO, ASSUME RECFM=U                  07274000
         AH    R3,=H'4'             SKIP BLOCK LENGTH WORD              07275000
         B     IF226                                                    07276000
         SPACE 3                                                        07277000
IF224    BXLE  R3,R4,IF226          GET THE NEXT LOGICAL RECORD         07278000
         B     IF204                END OF BLOCK, BRANCH                07279000
         SPACE 2                                                        07280000
IF226    TM    FLAGSCC,RECFMV       RECFM=V?                            07281000
         BNO   IF228                NO, BRANCH                          07282000
         SR    R4,R4                                                    07283000
         ICM   R4,B'0011',0(R3)     RECORD LENGTH +4                    07284000
         LR    R14,R4               RECORD LENGTH +4                    07285000
         AH    R3,=H'4'             SKIP RECORD LENGTH WORD             07286000
         SH    R4,=H'4'             RECORD LENGTH VALID?                07287000
         BNM   IF228                YES, BRANCH                         07288000
         SR    R4,R4                NO, USE LENGTH 0                    07289000
         OI    #OPTOPT,X'10'        NOTE: LRECL ERROR (SHORT RECORD)    07290000
         B     IF224                SKIP THE RECORD                     07291000
         SPACE 2                                                        07292000
IF228    LA    R6,1(,R6)            ANOTHER OUTPUT RECORD               07293000
         CH    R14,LRECL            VALID LRECL VALUE?                  07294000
         BNH   IF224                YES, BRANCH                         07295000
         OI    #OPTOPT,X'10'        NOTE: LRECL ERROR (LONG RECORD)     07296000
         B     IF224                                                    07297000
         SPACE 2                                                        07298000
IF240    TM    DIRFLAG,DIR2TTR+DIR1TTR    ANY USER TTR?                 07299000
         BZ    IF244                      NO, BRANCH                    07300000
         STM   R14,R12,12(R13)            CONVERT CCHHR TO TTR          07301000
         LA    R2,CURMBB                  CCHHR TO CONVERT              07302000
         L     R1,INDCB+(DCBDEBAD-IHADCB) DEB ADDRESS                   07303000
         L     R15,ADDRRLTV               ADDRESS OF CCHHR->TTR CONVERT 07304000
         LR    R3,R13                     ADDRESS OF SAVE AREA          07305000
         BALR  R14,R15                    CALL CONVERT ROUTINE          07306000
         LR    R13,R3                     RESTORE SAVE AREA ADDRESS     07307000
         ST    R0,12+4+4(R13)             RESULT TTR RETURNED IN R0     07308000
         LM    R14,R12,12(R13)            RESTORE REGISTERS             07309000
         CLM   R0,B'1110',DIRSTART        TTR ACTUALLY INPUT?           07310000
         BNH   IF242                      NO, I/O ERROR                 07311000
         TM    DIRFLAG,DIR2TTR            A SECOND TTR TOO?             07312000
         BZ    IF244                      NO, BRANCH                    07313000
         CLM   R0,B'1110',DIRNOTE         TTR ACTUALLY INPUT?           07314000
         BH    IF244                      YES, BRANCH                   07315000
         SPACE 1                                                        07316000
IF242    OI    #OPTOPT,X'40'        PERMANENT I/O ERROR                 07317000
         SPACE 2                                                        07318000
IF244    LTR   R6,R6                ANY RECORDS?                        07319000
         BNZ   IF246                YES, BRANCH                         07320000
         OI    #OPTOPT,X'08'        NO, MARK AS NULL                    07321000
         SPACE 3                                                        07322000
IF246    NI    ##ADRPA#,FF-$Q       END OF QUIET MODE READ              07323000
         CLI   #IOERROR,X'01'       "IOERROR" OR "NOIOERROR"?           07324000
         BL    IF260                NEITHER, BRANCH                     07325000
         BH    IF248                "NOIOERROR", BRANCH                 07326000
         TM    #OPTOPT,X'40'        "IOERROR" -- CORRECT?               07327000
         BO    IF260                YES, BRANCH                         07328000
         B     IF997                NO, DO ANY ELSE                     07329000
IF248    TM    #OPTOPT,X'40'        IOERROR?                            07330000
         BO    IF997                YES, DO ANY ELSE                    07331000
         SPACE 3                                                        07332000
IF260    CLI   #BLOCKER,X'01'       "BLOCKERR" OR "NOBLOCKERR"?         07333000
         BL    IF266                NEITHER, BRANCH                     07334000
         BH    IF262                "NOBLOCKERR", BRANCH                07335000
         TM    #OPTOPT,X'20'        "BLOCKERR" -- CORRECT?              07336000
         BO    IF266                YES, BRANCH                         07337000
         B     IF997                NO, DO ANY ELSE                     07338000
IF262    TM    #OPTOPT,X'20'        BLOCKERR?                           07339000
         BO    IF997                YES, DO ANY ELSE                    07340000
         SPACE 3                                                        07341000
IF266    CLI   #LRECLER,X'01'       "LRECLERR" OR "NOLRECLERR"?         07342000
         BL    IF280                NEITHER, BRANCH                     07343000
         BH    IF268                "NOLRECLERR", BRANCH                07344000
         TM    #OPTOPT,X'10'        "LRECLERR" -- CORRECT?              07345000
         BO    IF280                YES, BRANCH                         07346000
         B     IF997                NO, DO ANY ELSE                     07347000
IF268    TM    #OPTOPT,X'10'        LRECLERR?                           07348000
         BO    IF997                YES, DO ANY ELSE                    07349000
         SPACE 3                                                        07350000
IF280    CLI   #NULL,X'01'          "NULL" OR "NONULL"?                 07351000
         BL    IF300                NEITHER, BRANCH                     07352000
         BH    IF282                "NONULL", BRANCH                    07353000
         TM    #OPTOPT,X'08'        "NULL" -- CORRECT?                  07354000
         BO    IF300                YES, BRANCH                         07355000
         B     IF997                NO, DO ANY ELSE                     07356000
IF282    TM    #OPTOPT,X'08'        NULL?                               07357000
         BO    IF997                YES, DO ANY ELSE                    07358000
         SPACE 3                                                        07359000
IF300    TM    #IFABOVE,X'01'         SIZE AVAILABLE?                   07360000
         BNO   *+8                    NO, BRANCH                        07361000
         L     R6,#IFLEN              YES, USE THAT LENGTH              07362000
         SPACE 1                                                        07363000
         TM    #IFABOVE,X'80'         ABOVE CHECK?                      07364000
         BNO   IF320                  NO, BRANCH                        07365000
         CLM   R6,B'0111',#IFABOVE+1  ABOVE THE MINIMUM VALUE?          07366000
         BNH   IF997                  NO, DO ANY ELSE                   07367000
         SPACE 1                                                        07368000
IF320    TM    #IFBELOW,X'80'         BELOW CHECK?                      07369000
         BNO   IF360                  NO, BRANCH                        07370000
         CLM   R6,B'0111',#IFBELOW+1  BELOW THE MAXIMUM VALUE?          07371000
         BNL   IF997                  NO, DO ANY ELSE                   07372000
         SPACE 3                                                        07373000
IF360    CLI   #NAMEERR,X'01'       "NAMEERR" OR "NONAMEERR"?           07374000
         BL    IF390                NO, BRANCH                          07375000
         SPACE 1                                                        07376000
         SR    R3,R3                RESULT REGISTER                     07377000
         LA    R1,7                                                     07378000
         LA    R14,DOUBLE+8                                             07379000
         MVC   DOUBLE(8),DIRNAME                                        07380000
         SPACE 1                                                        07381000
IF382    BCTR  R14,0               SCAN                                 07382000
         CLI   0(R14),X'40'            BACKWARDS                        07383000
         BNE   *+8                              FOR FIRST               07384000
         BCT   R1,IF382                                  NON-BLANK      07385000
         SPACE 1                                                        07386000
         CLI   DIRNAME,C'0'        NUMERIC FIRST CHARACTER?             07387000
         BL    *+8                 NO, BRANCH                           07388000
         LA    R3,1                YES, NON-STANDARD NAME               07389000
         SPACE 1                                                        07390000
         TRT   DOUBLE(*-*),TRTMEM  <<EXECUTED>>                         07391000
         EX    R1,*-6              STANDARD MEMBER NAME?                07392000
         BZ    *+8                 YES, BRANCH                          07393000
         LA    R3,1                NO, NON-STANDARD NAME                07394000
         SPACE 1                                                        07395000
         CLI   #NAMEERR,X'01'       "NAMEERR" OR "NONAMEERR"?           07396000
         BL    IF390                NEITHER, BRANCH                     07397000
         BH    IF384                "NONAMEERR", BRANCH                 07398000
         LTR   R3,R3                "NAMEERR" -- CORRECT?               07399000
         BP    IF390                YES, BRANCH                         07400000
         B     IF997                NO, DO ANY ELSE                     07401000
IF384    LTR   R3,R3                NAMEERR?                            07402000
         BP    IF997                YES, DO ANY ELSE                    07403000
         SPACE 3                                                        07404000
* CHECK EACH MODULE FOR LINKAGE EDIT ATTRIBUTE CONFLICTS IF REQUIRED    07405000
IF390    CLI   #LKEDERR,X'01'              CONFLICT CHECK REQUESTED?    07406000
         BL    IF400                       NO, BRANCH                   07407000
         SPACE 1                                                        07408000
         TM    DIRATTR,ATTRRENT            REENTRANT?                   07409000
         BNO   IF392                       NO, BRANCH                   07410000
         TM    DIRATTR,ATTRREUS            REUSABLE?                    07411000
         BNO   IF399                       NO, CONFLICT FOUND           07412000
         SPACE 1                                                        07413000
IF392    TM    DIRATTR+1,ATTRSYMS+ATTRNE   TEST AND NOT EDIT            07414000
         BO    IF399                       YES, CONFLICT FOUND          07415000
         SPACE 1                                                        07416000
         TM    DIRATTR,ATTRREUS+ATTRSCTR   REUSABLE AND SCATTER         07417000
         BO    IF399                       YES, CONFLICT FOUND          07418000
         SPACE 1                                                        07419000
         TM    DIRATTR,ATTROVLY            OVERLAY ATTRIBUTE?           07420000
         BNO   IF394                       NO, BRANCH                   07421000
         TM    DIRATTR,ATTRRENT++ATTRREUS+ATTRSCTR  RENT/REUS/SCTR?     07422000
         BNZ   IF399                                YES, CONFLICT       07423000
         TM    DIRATTR+1,ATTRREFR          REFRESHABLE?                 07424000
         BO    IF399                       YES, CONFLICT FOUND          07425000
         TM    DIRATTR2,DIRAOSLE           MVS LINKAGE-EDITOR?          07426000
         BNO   IF394                       NO, BRANCH                   07427000
         TM    DIRATTR3,DIRRMANY           RMODE ANY?                   07428000
         BO    IF399                       YES, CONFLICT FOUND          07429000
         TM    MODESAVE,DIRAM31            AMODE 24?                    07430000
         BNZ   IF399                       NO, CONFLICT FOUND           07431000
         SPACE 1                                                        07432000
IF394    TM    DIRATTR2,DIRAOSLE           MVS LINKAGE-EDITOR?          07433000
         BNO   IF397                       NO, BRANCH                   07434000
         TM    DIRATTR3,DIRRMANY           RMODE ANY?                   07435000
         BNO   IF397                       NO, BRANCH                   07436000
         TM    MODESAVE,DIRAM64+DIRAM31    AMODE ANY?              @D02
         BO    IF399                       YES, CONFLICT FOUND     @D02
         TM    MODESAVE,DIRAM31            AMODE 31?               @D02
         BNO   IF399                       NO, CONFLICT FOUND      @D02
         TM    MODESAVE,DIRAM64            AMODE 64?               @D02
         BNO   IF399                       NO, CONFLICT FOUND      @D02
         SPACE 1                                                        07441000
IF397    CLI   #LKEDERR,1                  CONFLICT DESIRED?            07442000
         BE    IF997                       YES, DO ANY ELSE             07443000
         B     IF400                       NO, NONE FOUND               07444000
         SPACE 1                                                        07445000
IF399    CLI   #LKEDERR,1                  CONFLICT DESIRED?            07446000
         BNE   IF997                       NO, DO ANY ELSE              07447000
         SPACE 3                                                        07448000
* LOAD EACH MODULE IF REQUIRED                                          07449000
IF400    CLI   #LOADERR,X'01'      LOAD CHECK REQUESTED?                07450000
         BL    IF420               NO, BRANCH                           07451000
         SPACE 1                                                        07452000
         OI    ##ADRPA#,$Q         QUIET MODE LOAD IS REQUIRED          07453000
         L     R2,RECOVER          PREVIOUS RECOVERY ADDRESS            07454000
         LA    R1,IF402            RESUME ADDRESS                       07455000
         ST    R1,RECOVER          IN-LINE RECOVERY                     07456000
         STM   R2,R8,MSGTEXT2      SAVE REGISTERS                       07457000
         MVI   RECOVER,C'L'        LOAD RECOVERY FLAG                   07458000
         LOAD   EPLOC=DIRNAME,DCB=INDCB                                 07459000
         DELETE EPLOC=DIRNAME                                           07460000
         ST    R2,RECOVER          RESET RECOVERY ADDRESS               07461000
         MVI   RECOVER,0           LOAD WORKED                          07462000
         B     IF404                                                    07463000
         SPACE 1                                                        07464000
IF402    LM    R2,R8,MSGTEXT2      SAVE REGISTERS                       07465000
         ST    R2,RECOVER          RESTORE RECOVERY ADDRESS             07466000
         MVI   RECOVER,1           LOAD DID NOT WORK                    07467000
         SPACE 1                                                        07468000
IF404    NI    ##ADRPA#,FF-$Q       END OF QUIET MODE LOAD              07469000
         CLI   #LOADERR,X'01'       "LOADERR" OR "NOLOADERR"?           07470000
         BL    IF420                NEITHER, BRANCH                     07471000
         BH    IF406                "NOLOADERR", BRANCH                 07472000
         CLI   RECOVER,1            "LOADERR" -- CORRECT?               07473000
         BE    IF420                YES, BRANCH                         07474000
         B     IF997                NO, DO ANY ELSE                     07475000
IF406    CLI   RECOVER,1            LOAD ERROR?                         07476000
         BE    IF997                YES, DO ANY ELSE                    07477000
         SPACE 3                                                        07478000
* CHECK IF THIS MEMBER IS IN USE BY AN SPF EDIT SESSION                 07479000
IF420    CLI   #SPFEDIT,X'01'      INUSE CHECK REQUESTED?               07480000
         BL    IF440               NO, BRANCH                           07481000
         SPACE 1                                                        07482000
         OI    ##ADRPA#,$Q         QUIET MODE SPF USE CHECK             07483000
         SR    R3,R3               ASSUME NOT IN USE                    07484000
         MVC   DSNMEMQ(8),MEMNAME  MEMBER NAME TO CHECK                 07485000
         BAL   R2,ENQMTEST         MEMBER IN USE?                       07486000
         LA    R3,1                YES, MARK AS SUCH                    07487000
         NI    ##ADRPA#,FF-$Q      END OF QUIET MODE                    07488000
         SPACE 1                                                        07489000
         CLI   #SPFEDIT,X'01'       "SPFEDIT" OR "NOSPFEDIT"?           07490000
         BL    IF440                NEITHER, BRANCH                     07491000
         BH    IF422                "NOSPFEDIT", BRANCH                 07492000
         LTR   R3,R3                "SPFEDIT" -- CORRECT?               07493000
         BP    IF440                YES, BRANCH                         07494000
         B     IF997                NO, DO ANY ELSE                     07495000
IF422    LTR   R3,R3                SPFEDIT?                            07496000
         BP    IF997                YES, DO ANY ELSE                    07497000
         SPACE 3                                                        07498000
IF440    CLI   #AALIAS,X'01'        APPARENT ALIAS MEMBER CHECK?        07499000
         BL    IF460                NO, BRANCH                          07500000
         SR    R3,R3                ASSUME NOT AN APPARENT ALIAS        07501000
         TM    DIRFLAG,X'80'        MEMBER AN ALIAS?                    07502000
         BO    IF444                YES, CANNOT BE AN APPARENT ALIAS    07503000
         MVI   STARTTR+2,X'01'      TTR=000001 (START OF DIRECTORY)     07504000
         SPACE 1                                                        07505000
IF442    BAL   R14,READDIR          GET NEXT DIRECTORY MEMBER           07506000
         B     IF444                LAST MEMBER PROCESSED               07507000
         SPACE 1                                                        07508000
         TM    MEMFLAG,X'80'        IS THIS AN ALIAS?                   07509000
         BO    IF442                YES, IGNORE                         07510000
         CLC   DIRTTR,MEMTTR        TTR MATCH?                          07511000
         BNE   IF442                NO, BRANCH                          07512000
         CLC   DIRNAME,MEMNAME      SAME MEMBER?                        07513000
         BE    IF442                YES, BRANCH                         07514000
         LA    R3,1                 AN APPARENT ALIAS MEMBER            07515000
         SPACE 1                                                        07516000
IF444    CLI   #AALIAS,X'01'        "APPARENTALIAS" OR "NOAPPAREN.."?   07517000
         BL    IF460                NEITHER, BRANCH                     07518000
         BH    IF446                "NOAPPARENTALIAS", BRANCH           07519000
         LTR   R3,R3                "APPARENTALIAS" -- CORRECT?         07520000
         BP    IF460                YES, BRANCH                         07521000
         B     IF997                NO, DO ANY ELSE                     07522000
IF446    LTR   R3,R3                APPARENT ALIAS?                     07523000
         BP    IF997                YES, DO ANY ELSE                    07524000
         SPACE 3                                                        07525000
IF460    CLI   #ORPHAN,X'01'        ORPHAN MEMBER CHECK?                07526000
         BL    IF470                NO, BRANCH                          07527000
         TM    DIRFLAG,X'80'        MEMBER AN ALIAS?                    07528000
         BNO   IF463                NO, CANNOT BE AN ORPHAN             07529000
         MVI   STARTTR+2,X'01'      TTR=000001 (START OF DIRECTORY)     07530000
         LA    R3,1                 ASSUME IT IS AN ORPHAN              07531000
         SPACE 1                                                        07532000
IF462    BAL   R14,READDIR          GET NEXT DIRECTORY MEMBER           07533000
         B     IF464                LAST MEMBER PROCESSED               07534000
         SPACE 1                                                        07535000
         TM    MEMFLAG,X'80'        IS THIS AN ALIAS?                   07536000
         BO    IF462                YES, IGNORE                         07537000
         CLC   DIRTTR,MEMTTR        TTR MATCH?                          07538000
         BNE   IF462                NO, BRANCH                          07539000
IF463    SR    R3,R3                NOT AN ORPHAN                       07540000
         SPACE 1                                                        07541000
IF464    CLI   #ORPHAN,X'01'        "ORPHAN" OR "NOORPHAN"?             07542000
         BL    IF470                NEITHER, BRANCH                     07543000
         BH    IF466                "NOORPHAN", BRANCH                  07544000
         LTR   R3,R3                "ORPHAN" -- CORRECT?                07545000
         BP    IF470                YES, BRANCH                         07546000
         B     IF997                NO, DO ANY ELSE                     07547000
IF466    LTR   R3,R3                ORPHAN?                             07548000
         BP    IF997                YES, DO ANY ELSE                    07549000
         SPACE 3                                                        07550000
IF470    CLI   #RLD0,X'01'          "RLDZERO" OR "NORLDZERO"            07551000
         BL    IF476                NEITHER, BRANCH                     07552000
         BH    IF472                "NORLDZERO", BRANCH                 07553000
         CLI   DIRATTR4,0           "RLDZERO" -- CORRECT?               07554000
         BE    IF476                YES, BRANCH                         07555000
         B     IF997                NO, DO ANY ELSE                     07556000
IF472    CLI   DIRATTR4,0           "NORLDZERO" -- CORRECT?             07557000
         BE    IF997                YES, DO ANY ELSE                    07558000
         SPACE 1                                                        07559000
IF476    TM    FLAGSCC,RECFMU            LOAD MODULE?                   07560000
         BO    IF490                     YES, BRANCH                    07561000
         CLI   #IFCREIF+2,0              ANY CREATION DATE?             07562000
         BE    IF480                     NO, CHECK FOR MODIFICATION     07563000
         TM    DIRFLAG,X'0F'             SPF STATISTICS?                07564000
         BNO   IF997                     NO, DO ANY ELSE                07565000
         CLC   #IFCREIF(3),DIRSPFCR+1    HIGHER THAN DIRECTORY?         07566000
         BH    IF997                     YES, DO ANY ELSE               07567000
         CLC   #IFCREIF+3(3),DIRSPFCR+1  LOWER THAN DIRECTORY?          07568000
         BL    IF997                     YES, DO ANY ELSE               07569000
         SPACE 1                                                        07570000
IF480    CLI   #IFMODIF+2,0              ANY MODIFICATION DATE?         07571000
         BE    IF490                     NO, CONTINUE                   07572000
         TM    DIRFLAG,X'0F'             SPF STATISTICS?                07573000
         BNO   IF997                     NO, DO ANY ELSE                07574000
         CLC   #IFMODIF(3),DIRSPFCD+1    HIGHER THAN DIRECTORY?         07575000
         BH    IF997                     YES, DO ANY ELSE               07576000
         CLC   #IFMODIF+3(3),DIRSPFCD+1  LOWER THAN DIRECTORY?          07577000
         BL    IF997                     YES, DO ANY ELSE               07578000
         SPACE 3                                                        07579000
IF490    DS    0H                                                       07580000
         SPACE 1                                                        07581000
IF996    MVC   FINDMEMQ+25(4),=C'THEN'                                  07582000
         L     R2,#ACTIONT          THEN ACTION                         07583000
         B     IF998                                                    07584000
         SPACE 1                                                        07585000
IF997    MVC   FINDMEMQ+25(4),=C'ELSE'                                  07586000
         L     R2,#ACTIONE          ELSE ACTION                         07587000
         SPACE 1                                                        07588000
IF998    LTR   R2,R2                ANY ASSOCIATED ACTION?              07589000
         BNP   NEWCMD               NO, BRANCH                          07590000
         TM    ##ADRPA#-##SUBCOM(R2),$D  DEFAULT MESSAGE SUBCOMMAND?    07591000
         BNZ   IF999                     NO, BRANCH                     07592000
         SPACE 1                                                        07593000
         MESSAGE MSGBLANK                                               07594000
         TM    FLAGSAA,FINDMSG      ANY HEADER MESSAGE?                 07595000
         BNO   IF999                NO, BRANCH                          07596000
         XI    FLAGSAA,FINDMSG      NO MORE MESSAGE                     07597000
         MVC   FINDMEMQ+30(8),0(R2) SUBCOMMAND NAME                     07598000
         MESSAGE FINDMEMQ           OUTPUT THE HEADER MESSAGE           07599000
         SPACE 1                                                        07600000
IF999    MVC   ##ANSWER(LISUBS),ISUBS INITIALIZE THE PDL SAVE AREA      07601000
         MVC   ##SUBCOM(PTW),0(R2)    CHANGE THE SUBCOMMAND             07602000
         B     CALLCMDZ               CALL THE SECONDARY SUBCOMMAND     07603000
         TITLE 'P D S  --  PDS LIST, DIRENTRY, FIND            1/15/85' 07604000
*********************************************************************** 07605000
***      LIST SUBCOMMAND    MODIFIED BY BRUCE LELAND -- JUNE, 1982  *** 07606000
***                                                                 *** 07607000
***      DIRENTRY SUBCOMMAND   ADDED BY BRUCE LELAND -- JUNE, 1982  *** 07608000
***                                                                 *** 07609000
***      FIND SUBCOMMAND    MODIFIED BY BRUCE LELAND -- JUNE, 1982  *** 07610000
*********************************************************************** 07611000
*                                                                       07612000
LIST     CSECT                                                          07613000
         USING *,R8                                                     07614000
         MVC   ##HELOFF(4),=C'LIST'                                     07615000
         B     LIST010                                                  07616000
*                                                                       07617000
         SPACE 1                                                        07618000
DIRENTRY L     R8,$LIS+8           BASE REGISTER FOR LIST               07619000
         LA    R1,L530             ASSUME A NON-PARTITIONED DATA SET    07620000
         TM    DSORG,DS1DSGPO      CORRECT?                             07621000
         BZ    MSGNEW              YES, ERROR                           07622000
         SPACE 1                                                        07623000
         MVC   ##HELOFF(4),=C'DIRE'                                     07624000
         IC    R1,DIRFLAG                                               07625000
         N     R1,=XL4'0000001F'   NUMBER OF HALFWORDS                  07626000
         LA    R5,12(R1,R1)        LENGTH IN BYTES                      07627000
         LA    R6,DIRNAME          START OF DIRECTORY ENTRY             07628000
         LA    R4,16               DUMP FORMAT, WIDTH=16                07629000
         MVI   MTHIGHL+4,2                                              07630000
         MVC   MSGTEXT1(3),L143$2  DIRECTORY DUMP HEADER                07631000
         MVC   INSERT#1(8),DIRNAME                                      07632000
         CVD   R5,DOUBLE                                                07633000
         MVC   INSERT#2-2(4),=X'40202120'                               07634000
         ED    INSERT#2-2(4),DOUBLE+6                                   07635000
         AR    R5,R6                                                    07636000
         BCTR  R5,0                                                     07637000
         LA    R3,LIST610          PROCESSING ROUTINE                   07638000
         BR    R3                                                       07639000
         SPACE 2                                                        07640000
*                                                                       07641000
FIND     L     R8,$LIS+8           BASE REGISTER FOR LIST               07642000
         CLI   FINDLTH+1,0         STRING EVER CODED?                   07643000
         LA    R1,L770                                                  07644000
         BZ    MSGNEWXX            NO, TERMINATE THIS GROUP             07645000
         MVC   ##HELOFF(4),=C'FIND'                                     07646000
         XC    WORKTBL,WORKTBL     RESET THE TRT TABLE                  07647000
         SR    R15,R15                                                  07648000
         IC    R15,FINDSTR         FIRST CHARACTER OF NEW STRING        07649000
         LA    R1,WORKTBL(R15)     ADDRESS OF NEW TRT BYTE              07650000
         MVI   0(R1),X'77'         SET TRT BYTE TO NON-ZERO             07651000
         SPACE 2                                                        07652000
LIST010  MVC   FLAGSDD(1),HFLAGSDD INITIALIZE FLAGSDD                   07653000
         OC    #MAXIN,#MAXIN       ANY INPUT DESIRED?                   07654000
         BZ    LIST910             NO, BRANCH                           07655000
         SPACE 2                                                        07656000
         TM    DSORG,DS1DSGPO        DSORG=PO?                          07657000
         BNO   LIST090               NO, BRANCH                         07658000
         TM    FLAGSCC,RECFMU        LOAD MODULE?                       07659000
         BNO   LIST090               NO, BRANCH                         07660000
         TM    FLAGSDD,LBLOCK+LDUMP+BLOCK+DUMP  ANY LOAD FORMAT?        07661000
         BM    LIST020                          YES, BRANCH             07662000
         MVI   FLAGSDD,LDUMP                    NO, USE LDUMP           07663000
LIST020  TM    FLAGSDD,LBLOCK+LDUMP  LBLOCK OR LDUMP FORMAT?            07664000
         BZ    LIST090               NO, BRANCH                         07665000
         SPACE 1                                                        07666000
         LA    R2,#ESDPTR          START OF ESD LIST                    07667000
         L     R15,=A(READESD)     ESD SYMBOL ROUTINE                   07668000
         BALR  R14,R15             ANY SYMBOLS?                         07669000
         B     *+8                 NO, "NO EXTERNAL SYMBOLS"            07670000
         B     LIST030             YES, BRANCH                          07671000
         SPACE 2                                                        07672000
         MVC   INSERT#1(8),DIRNAME MEMBER NAME IN ERROR                 07673000
         TSMSG L704$1              OUTPUT AN ERROR MESSAGE              07674000
         B     LIST090             CONTINUE, BUT NO CSECT IDENTIFIERS   07675000
         SPACE 2                                                        07676000
         USING ESDENTRY,R2                                              07677000
*  LOOPS TO SET MAXIMUM LENGTH FIELDS FOR LABEL REFERENCE ENTRIES       07678000
*  AND TO ASSOCIATE ENTRY RECORDS WITH THE APPROPRIATE CSECT NAMES      07679000
LIST030  OI    #LISTFLG,X'01'      CSECT OPERATION FLAG                 07680000
         ICM   R2,B'1111',ESDLINK  ANY MORE ENTRIES?                    07681000
         BZ    LIST060             NO, BRANCH                           07682000
         MVI   ESDSEG#,0           CLEAR THE SEGMENT NUMBER             07683000
         CLI   ESDTYPE,CODESD      CSECT ENTRY?                         07684000
         BNE   LIST030             NO, BRANCH                           07685000
         LR    R1,R2                                                    07686000
         SPACE 1                                                        07687000
LIST040  ICM   R1,B'1111',ESDLINK-ESDENTRY(R1)                          07688000
         BZ    LIST060                                                  07689000
         CLI   ESDTYPE-ESDENTRY(R1),CODELR  ASSOCIATED EXTERNAL LABEL?  07690000
         BNE   LIST030                      NO, BRANCH                  07691000
         MVI   ESDSEG#-ESDENTRY(R1),0       CLEAR THE SEGMENT NUMBER    07692000
         ST    R2,ESDCSECT-ESDENTRY(R1)     SAVE POINTER TO NAME        07693000
         SR    R14,R14                                                  07694000
         LH    R0,ESDID                     RELATIVE ESDID OF CSECT     07695000
         STH   R0,ESDID-ESDENTRY(R1)        SAVE FOR ENTRY              07696000
         L     R0,ESDADDR-1                 BASE START ADDRESS          07697000
         ST    R0,ESDMAIN-ESDENTRY(R1)      SAVE MAIN OFFSET            07698000
         A     R0,ESDLEN-1                  BASE MAXIMUM REFERENCE      07699000
         ICM   R14,B'0111',ESDADDR-ESDENTRY(R1)                         07700000
         SR    R0,R14                                                   07701000
         ST    R0,ESDLEN-ESDENTRY-1(R1)     MAXIMUM SYMBOL LENGTH       07702000
         B     LIST040                                                  07703000
         SPACE 2                                                        07704000
*  LOOP TO FILTER THE SYMBOL NAMES                                      07705000
LIST060  LA    R2,#ESDPTR          START OF ESD LIST                    07706000
         SR    R3,R3                                                    07707000
         ICM   R3,B'0001',#MODLEN  ANY FILTERING?                       07708000
         BZ    LIST090             NO, BRANCH                           07709000
         BCTR  R3,0                MACHINE LENGTH                       07710000
         SPACE 1                                                        07711000
LIST070  LR    R1,R2                                                    07712000
         ICM   R2,B'1111',ESDLINK  END OF LIST?                         07713000
         BZ    LIST090             YES, BRANCH                          07714000
         CLC   ESDNAME(*-*),#MODTXT  <<EXECUTED>>                       07715000
         EX    R3,*-6              MATCH THE PARTIAL NAME?              07716000
         BE    LIST070             YES, BRANCH                          07717000
         MVC   ESDLINK-ESDENTRY(4,R1),ESDLINK                           07718000
         LR    R2,R1                    DROP THIS SYMBOL                07719000
         B     LIST070                                                  07720000
         SPACE 1                                                        07721000
LIST090  MVC   STARTTR(3),DIRTTR   FIRST TTR                            07722000
         SPACE 2                                                        07723000
LIST100  L     R15,=A(EXCP)                                             07724000
         BALR  R14,R15                                                  07725000
         B     *+4(R15)                 PROCESS RETURN CODE             07726000
         B     LIST120                    00 - GOOD READ                07727000
         B     LIST110                    04 - END OF MEMBER            07728000
         B     LIST900                    08 - END OF DATA SET          07729000
         B     LIST910                    12 - I/O ERROR                07730000
         SPACE 1                                                        07731000
LIST110  TM    DSORG,DS1DSGIS           ISAM DATA SET?                  07732000
         BNO   LIST900                  NO, BRANCH                      07733000
         TSMSG L005                     YES, OUTPUT A MESSAGE           07734000
         B     LIST100                  CONTINUE                        07735000
         SPACE 1                                                        07736000
LIST120  NI    #LISTFLG,FF-X'20'        TURN OFF THE CSECT DATA FLAG    07737000
         L     R5,LS                    CURRENT LENGTH                  07738000
         LR    R6,R0                    START OF BUFFER                 07739000
         LR    R1,R5                    SAVE BLOCKSIZE FOR LATER        07740000
         LM    R14,R15,#LISTN0          SAVE IF NOT PHYSICAL BLOCKS     07741000
         L     R0,#LISTN0               PREVIOUS MEMBER DISPLACEMENT    07742000
         ST    R0,#LISTN1               UPDATE MEMBER DISPLACEMENT      07743000
         AR    R0,R5                    ADD CURRENT LENGTH FOR NEXT     07744000
         ST    R0,#LISTN0               UPDATE FOR NEXT ENTRY           07745000
         TM    FLAGSDD,BLOCK            BLOCK OUTPUT DESIRED?           07746000
         BO    LIST400                  YES, BRANCH                     07747000
         TM    FLAGSDD,DUMP             DUMP OUTPUT DESIRED?            07748000
         BO    LIST420                  YES, BRANCH                     07749000
         STM   R14,R15,#LISTN0          NOT PHYSICAL BLOCKS             07750000
         AR    R5,R6                    ADDRESS OF END OF BUFFER        07751000
         BCTR  R5,0                     END OF BUFFER ADDRESS           07752000
         LA    R3,LIST200               ASSUME FIXED OR UNDEFINED       07753000
         TM    FLAGSCC,RECFMF           RECFM=F?                        07754000
         LH    R4,LRECL                 GET RECORD LENGTH               07755000
         BOR   R3                       YES, BRANCH                     07756000
         SPACE 1                                                        07757000
         TM    FLAGSCC,RECFMU           RECFM=U?                        07758000
         LR    R4,R1                    BLOCK LENGTH                    07759000
         BOR   R3                       YES, BRANCH                     07760000
         TM    FLAGSCC,RECFMV           RECFM=V?                        07761000
         BNOR  R3                       NO, PROCESS LIKE RECFM=U        07762000
         SPACE 1                        SET END OF BUFFER ADDRESS       07763000
         AH    R6,=H'4'                 RECFM=V; START OF LRECL'S       07764000
         LA    R3,LIST150               VARIABLE LEN RECORD PROCESSOR   07765000
         SPACE 2                                                        07766000
LIST150  SR    R4,R4                                                    07767000
         ICM   R4,B'0011',0(R6)         RECORD LENGTH +4                07768000
         AH    R6,=H'4'                 SKIP OVER HEADER                07769000
         SH    R4,=H'4'                 SUBTRACT HEADER LENGTH          07770000
         BP    LIST200                  BRANCH IF RECORD EXISTS         07771000
         SR    R4,R4                    NO, RESET LENGTH TO ZERO        07772000
         SPACE 1                                                        07773000
LIST160  LR    R0,R4                    PREVIOUS RECORD LENGTH          07774000
         A     R0,#LISTN1               OFFSET IN CURRENT RECORD        07775000
         ST    R0,#LISTN1               UPDATE                          07776000
         BXLE  R6,R4,0(R3)              SKIP TO NEXT RECORD             07777000
         L     R2,=A(DIR000)            DIRENTRY ELEMENT LIST      @D04
         CLI   ##HELOFF,C'D'            DIRENTRY SUBCOMMAND?            07778000
**       BE    NEWCMD                   YES, BRANCH                @D04 07779000
         BER   R2                       YES, BRANCH                @D04
         TM    FLAGSDD,LBLOCK+LDUMP     LBLOCK OR LDUMP?                07780000
         BZ    LIST100                  NO, GET A NEW BLOCK             07781000
         LM    R3,R6,#LFSAVE4           RESTORE R3-R6                   07782000
         BXLE  R6,R4,0(R3)              SKIP TO NEXT RECORD             07783000
         B     LIST100                  REAL END OF BLOCK               07784000
         SPACE 3                                                        07785000
LIST200  L     R0,#LISTN0               PREVIOUS MEMBER DISPLACEMENT    07786000
         ST    R0,#LISTN1               UPDATE MEMBER DISPLACEMENT      07787000
         AR    R0,R4                    ADD CURRENT LENGTH FOR NEXT     07788000
         ST    R0,#LISTN0               UPDATE FOR NEXT ENTRY           07789000
         L     R0,#BLKCNT                                               07790000
         A     R0,=F'1'                                                 07791000
         ST    R0,#BLKCNT                                               07792000
         STM   R3,R6,#LFSAVE4             SAVE FOR LBLOCK/LDUMP         07793000
         L     R0,#SKIPREC                                              07794000
         S     R0,=F'1'                   SKIP THIS RECORD?             07795000
         ST    R0,#SKIPREC                                              07796000
         BNM   LIST160                    YES, BRANCH                   07797000
         L     R0,#MAXIN                                                07798000
         S     R0,=F'1'                   SUFFICIENT INPUT RECORDS?     07799000
         ST    R0,#MAXIN                                                07800000
         BM    LIST910                    YES, BRANCH                   07801000
LIST210  LR    R1,R4                      LENGTH OF DATA AREA           07802000
         TM    FLAGSDD,LBLOCK             LBLOCK?                       07803000
         BO    LIST400                    YES, BRANCH                   07804000
         TM    FLAGSDD,LDUMP              LDUMP?                        07805000
         BO    LIST420                    YES, BRANCH                   07806000
         LA    R0,8                       WIDTH OF LINE NUMBER FIELD    07807000
         LR    R15,R6                     MOVE START POSITION           07808000
         LR    R14,R15                    LINE NUMBER FOR RECFM=V OR U  07809000
         A     R15,#SKIPCOL               ADJUST START FOR START COLUMN 07810000
         S     R1,#SKIPCOL                ADJUST LEN FOR START COLUMN   07811000
         TM    FLAGSDD,NONUM+DONONUM      NONUM FORMAT?                 07812000
         BNZ   LIST330                    YES, BRANCH                   07813000
         AR    R15,R0                     ADJUST START FOR RECFM=V OR U 07814000
         SR    R1,R0                      ADJUST LENGTH, RECFM=V U OR F 07815000
         TM    FLAGSCC,RECFMF             RECFM=F?                      07816000
         BNO   LIST230                    NO, BRANCH                    07817000
         SR    R15,R0                     CORRECT DATA START POINTER    07818000
         LA    R14,0(R4,R6)               END OF LINE                   07819000
         SR    R14,R0                     START OF LINE NUMBER          07820000
LIST230  TM    FLAGSDD,SNUM               SNUM FORMAT?                  07821000
         BO    LIST330                    YES, BRANCH                   07822000
         MVC   MSGLINE+4(8),0(R14)        NUM FORMAT -- GET LINE NUMBER 07823000
         NC    MSGLINE+4(8),=C'00000000'  DROP NUMERIC PART             07824000
         CLC   MSGLINE+4(8),=C'00000000'  ZONE DIGITS FOR ALL BYTES?    07825000
         BE    LIST240                    YES, BRANCH                   07826000
         OI    FLAGSDD,DONONUM            CONTINUE WITH NONUM FORMAT    07827000
         B     LIST210                                                  07828000
         SPACE 1                                                        07829000
LIST240  MVC   MSGLINE+4(6),0(R14)        SPF LINE NUMBER FIELD         07830000
         TM    DIRFLAG,X'0F'              SPF ATTRIBUTES STORED?        07831000
         BO    LIST320                    YES, BRANCH                   07832000
         LA    R0,5                       MAXIMUM OF 5 DIGITS TO BLANK  07833000
         LA    R2,MSGLINE+3               START OF FIELD TO BLANK       07834000
         MVC   MSGLINE+4(6),2(R14)        LINE NUMBER FIELD             07835000
LIST310  LA    R2,1(,R2)                                                07836000
         CLI   0(R2),C'0'                 BLANK LEADING ZEROES IN THE   07837000
         BNE   LIST320                       LINE NUMBER FIELD          07838000
         MVI   0(R2),X'40'                                              07839000
         BCT   R0,LIST310                 DO UP TO 5 DIGITS             07840000
LIST320  LA    R0,249                     MAXIMUM ALLOWED DATA LENGTH   07841000
         MVI   MSGLINE+10,X'40'           BLANK AFTER LINE NUMBER       07842000
         LA    R14,MSGLINE+11             WHERE TO MOVE DATA            07843000
         B     LIST340                                                  07844000
         SPACE 2                                                        07845000
LIST330  LA    R0,256                   MAXIMUM LRECL TO DISPLAY        07846000
         LA    R14,MSGLINE+4            WHERE TO MOVE OUTPUT DATA       07847000
         SPACE 1                                                        07848000
LIST340  CR    R1,R0                    LENGTH>MAXIMUM ALLOWED?         07849000
         BL    *+6                      NO, BRANCH                      07850000
         LR    R1,R0                    YES, USE MAXIMUM                07851000
         S     R1,=F'1'                 MACHINE LENGTH VALID?           07852000
         BM    LIST360                  NO, BRANCH                      07853000
         MVC   0(*-*,R14),0(R15)        <<EXECUTED>>                    07854000
         EX    R1,*-6                   MOVE DATA INTO LINE             07855000
         SPACE 1                                                        07856000
LIST360  LR    R2,R1                    MACHINE LENGTH                  07857000
         LA    R1,MSGLINE+4             START OF DATA                   07858000
         CR    R14,R1                   NUM MODE?                       07859000
         BE    *+8                      NO, BRANCH                      07860000
         AH    R2,=H'7'                 YES, ACCOUNT FOR LINE NO, BLANK 07861000
         A     R2,=F'1'                 ACTUAL DATA LENGTH              07862000
         C     R2,#MAXLEN               LENGTH>#MAXLEN?                 07863000
         BL    *+8                      NO, BRANCH                      07864000
         L     R2,#MAXLEN               YES, USE #MAXLEN INSTEAD        07865000
         S     R2,=F'1'                 MACHINE LENGTH VALID?           07866000
         BM    LIST160                  LENGTH=0, BRANCH                07867000
         LA    R0,5(,R2)                ACTUAL LINE LENGTH + HALFWORDS  07868000
         SLL   R0,16                                                    07869000
         ST    R0,MSGLINE               CREATE OUTPUT LINE HEADER       07870000
         CLI   ##HELOFF,C'F'            FIND OPERATION?                 07871000
         BNE   LIST730                  NO, LIST -- BRANCH              07872000
         SPACE 1                                                        07873000
         LA    R14,1(R1,R2)             END OF DATA                     07874000
         LH    R15,FINDLTH              STRING LENGTH                   07875000
         BCTR  R15,0                    MACHINE LENGTH                  07876000
LIST370  EX    R2,LIST380               FIRST CHARACTER FOUND?          07877000
         BZ    LIST160                  NO, NOT IN STRING, QUIT         07878000
         LR    R2,R14                                                   07879000
         SR    R2,R1                    MACHINE LENGTH LEFT             07880000
         CR    R15,R2                   POSSIBLY IN STRING?             07881000
         BNL   LIST160                  NO, QUIT                        07882000
         EX    R15,LIST390              ENTIRE STRING FOUND?            07883000
         BE    LIST730                  YES, OUTPUT THE LINE            07884000
         LA    R1,1(,R1)                NO, TRY NEXT CHARACTER          07885000
         LR    R2,R14                                                   07886000
         SR    R2,R1                    MACHINE LENGTH LEFT NEGATIVE?   07887000
         BM    LIST160                  YES, NOT IN STRING, QUIT        07888000
         B     LIST370                  CONTINUE SEARCHING              07889000
         SPACE 2                                                        07890000
LIST380  TRT   0(*-*,R1),WORKTBL        <<EXECUTED>> -- FIRST BYTE      07891000
LIST390  CLC   0(*-*,R1),FINDSTR        <<EXECUTED>> -- COMPLETE STRING 07892000
         SPACE 3                                                        07893000
LIST400  LA    R4,64                    BLOCK FORMAT, WIDTH=64          07894000
         LA    R3,LIST600               PROCESSING ROUTINE              07895000
         B     LIST430                  FORMAT HEADER                   07896000
         SPACE 1                                                        07897000
LIST420  LA    R4,16                    DUMP FORMAT, WIDTH=16           07898000
         LA    R3,LIST610               PROCESSING ROUTINE              07899000
         SPACE 1                                                        07900000
LIST430  L     R0,#SKIPCOL              CHARACTERS TO SKIP              07901000
         ST    R0,#LISTN2               UPDATE BLOCK OFFSET             07902000
         A     R0,#LISTN1               CURRENT DATA                    07903000
         ST    R0,#LISTN1                           DISPLACEMENT        07904000
         MVI   MTHIGHL,5                                                07905000
         MVI   MTHIGHL+4,L'MSGDUMP-1                                    07906000
         MVC   MSGTEXT1(3),L140$2                                       07907000
         MVC   INSERT#1(5),=C'BLOCK'                                    07908000
         MVC   INSERT#2-1(40),MSGDUMP   HEADER FOR BLOCK OR DUMP        07909000
         NI    FLAGSDD,FF-OVERLAP       TURN OFF THE OVERLAP INDICATOR  07910000
         LR    R5,R1                    DATA LENGTH                     07911000
         C     R5,#MAXLEN               RESTRICT DATA LENGTH?           07912000
         BL    *+8                      NO, BRANCH                      07913000
         L     R5,#MAXLEN               YES, USE MAX LENGTH             07914000
         AR    R5,R6                    COMPUTE NEW END-OF-BLOCK        07915000
         BCTR  R5,0                     COMPUTE NEW END-OF-BLOCK -1     07916000
         A     R6,#SKIPCOL              ADJUST FOR START COLUMN         07917000
         TM    FLAGSDD,LBLOCK+LDUMP     LBLOCK OR LDUMP?                07918000
         BM    LIST450                  YES, BRANCH                     07919000
         L     R0,#BLKCNT                                               07920000
         A     R0,=F'1'                                                 07921000
         ST    R0,#BLKCNT                                               07922000
         CVD   R0,DOUBLE                                                07923000
         ED    INSERT#2-1(10),DOUBLE+4                                  07924000
         L     R0,#SKIPREC                                              07925000
         S     R0,=F'1'                 SKIP THIS RECORD?               07926000
         ST    R0,#SKIPREC                                              07927000
         BNM   LIST100                  YES, BRANCH                     07928000
         L     R0,#MAXIN                                                07929000
         S     R0,=F'1'                 SUFFICIENT INPUT RECORDS?       07930000
         ST    R0,#MAXIN                                                07931000
         BM    LIST910                  YES, BRANCH                     07932000
         CVD   R1,DOUBLE                  RECORD LENGTH                 07933000
         ED    INSERT#2+MSGDUMPL-MSGDUMP-1(7),DOUBLE+5                  07934000
         STM   R14,R12,12(R13)            CONVERT CCHHR TO TTR          07935000
         LA    R2,CURMBB                  CCHHR TO CONVERT              07936000
         L     R1,INDCB+(DCBDEBAD-IHADCB) DEB ADDRESS                   07937000
         L     R15,ADDRRLTV               ADDRESS OF CCHHR->TTR CONVERT 07938000
         LR    R3,R13                     ADDRESS OF SAVE AREA          07939000
         BALR  R14,R15                    CALL CONVERT ROUTINE          07940000
         LR    R13,R3                     RESTORE SAVE AREA ADDRESS     07941000
         ST    R0,12+4+4(R13)             RESULT TTR RETURNED IN R0     07942000
         LM    R14,R12,12(R13)            RESTORE REGISTERS             07943000
         ST    R0,DOUBLE                SAVE RESULTING TTR              07944000
         UNPK  INSERT#2+MSGDUMPT-MSGDUMP-1(7),DOUBLE(4)                 07945000
         TR    INSERT#2+MSGDUMPT-MSGDUMP-1(6),TRTABLE                   07946000
         MVI   INSERT#2+MSGDUMPT-MSGDUMP+6-1,X'40'                      07947000
         TM    FLAGSDD,DUMP                                             07948000
         BNOR  R3                                                       07949000
         MVC   INSERT#1(5),=C'DUMP '                                    07950000
         BR    R3                                                       07951000
         SPACE 2                                                        07952000
LIST450  TM    #LISTFLG,X'01'           CSECT FORMATTING?               07953000
         BNOR  R3                       NO, BRANCH                      07954000
         OI    #LISTFLG,X'08'           NEED A HEADER CHANGE            07955000
         ST    R4,#LISTWD               WIDTH OF EACH LINE              07956000
         L     R6,EXCPBUFF              BUFFER START                    07957000
         L     R5,LS                    BUFFER LENGTH                   07958000
         AR    R5,R6                    END OF BUFFER                   07959000
         BCTR  R5,0                     END OF BUFFER -1                07960000
         TM    #LISTFLG,X'40'           ANY CSECT ADDRESS YET?          07961000
         BO    LIST460                  YES, BRANCH                     07962000
         TM    0(R6),X'F0'              TEST, SCATTER, CESD OR IDR?     07963000
         BM    LIST100                  YES, BRANCH                     07964000
LIST460  TM    #LISTFLG,X'C0'           ANY CURRENT ESD RECORD?         07965000
         BO    LIST470                  YES, THIS IS A DATA RECORD      07966000
         CLI   8(R6),X'06'              AN ESD RECORD?                  07967000
         BNE   LIST100                  NO, BRANCH                      07968000
         OI    #LISTFLG,X'C0'           FLAGS FOR ESD RECORD INPUT      07969000
         MVC   #LISTVIR+1(3),9(R6)      SAVE THE OFFSET ADDRESS         07970000
         LH    R15,6(R6)                OFFSET TO ESDID                 07971000
         LA    R5,16(R15,R6)            FIRST ESDID FOR THIS BLOCK      07972000
         LH    R6,4(R6)                 ESDID ENTRIES *4                07973000
         SRL   R6,2                     ESDID ENTRIES                   07974000
         LA    R2,#ESDPTR               START OF ESD ADDRESSES          07975000
         SPACE 2                                                        07976000
*  LOOP TO MARK ENTRIES FOR THE NEXT PHYSICAL BLOCK                     07977000
LIST464  ICM   R2,B'1111',ESDLINK       NEXT ENTRY?                     07978000
         BZ    LIST100                  NO, DONE                        07979000
         MVI   ESDIDIN,0                TURN OFF FIRST                  07980000
         LR    R14,R5                   START OF ESDID LIST             07981000
         LR    R15,R6                   NUMBER OF ESDID ENTRIES         07982000
         SPACE 1                                                        07983000
LIST468  CLC   0(2,R14),ESDID           THIS ENTRY?                     07984000
         BNE   *+8                      NO, BRANCH                      07985000
         MVI   ESDIDIN,1                YES, MARK IT                    07986000
         LA    R14,4(,R14)              NEXT ESDID ENTRY                07987000
         BCT   R15,LIST468              MARK ALL ENTRIES THAT MATCH     07988000
         B     LIST464                  CHECK ALL ESD ENTRIES           07989000
         SPACE 3                                                        07990000
LIST470  XI    #LISTFLG,X'A0'           OFF CURRENT ESD; ON CSECT DATA  07991000
         L     R0,#LISTVIR              BLOCK OFFSET                    07992000
         L     R14,#LISTOFF             OFFSET                          07993000
         ST    R14,#LISTN2              BLOCK OFFSET                    07994000
         A     R14,#LISTN1              DATA                            07995000
         ST    R14,#LISTN1                  DISPLACEMENT                07996000
         ICM   R14,B'1111',#LISTOFF     ANY OFFSET?                     07997000
         BP    *+6                      YES, BRANCH                     07998000
         LR    R14,R0                   NO, USE THE BLOCK OFFSET        07999000
         SR    R6,R0                                                    08000000
         ST    R6,#LISTVIR              VIRTUAL BUFFER START ADDRESS    08001000
         LA    R2,#ESDPTR               START OF ESD ADDRESSES          08002000
         AR    R6,R14                   OFFSET --> ACTUAL ADDRESS       08003000
         SPACE 2                                                        08004000
*  LOOP TO FIND A START ENTRY                                           08005000
LIST480  ICM   R2,B'1111',ESDLINK       NEXT ENTRY?                     08006000
         BZ    LIST100                  NO, DONE                        08007000
         SR    R14,R14                                                  08008000
         ICM   R14,B'0111',ESDADDR      START ADDRESS OF SYMBOL         08009000
         LR    R15,R14                  CSECT START OFFSET              08010000
         A     R14,#LISTVIR             OFFSET --> ADDR OF CSECT START  08011000
         A     R15,ESDLEN-1             CSECT END OFFSET                08012000
         A     R15,#LISTVIR             OFFSET --> ADDRESS OF CSECT END 08013000
         CR    R6,R15                   CURRENT:CSECT END               08014000
         BNL   LIST480                    HIGH OR EQUAL, LOOP FOR NEXT  08015000
         CR    R5,R14                   END:CSECT START                 08016000
         BL    LIST480                    LOW, LOOP FOR NEXT            08017000
         CLI   ESDIDIN,1                THIS CSECT ACTIVE?              08018000
         BNE   LIST480                  NO, LOOP FOR NEXT               08019000
         MVC   #LISTID(2),ESDID         YES, MARK THE CURRENT ESDID     08020000
         ST    R2,#LISTENT              SAVE THIS ENTRY START           08021000
         LR    R1,R2                                                    08022000
         SPACE 1                                                        08023000
LIST490  ICM   R1,B'1111',ESDLINK-ESDENTRY(R1)  NEXT ENTRY?             08024000
         BZR   R3                               NO, DONE                08025000
         CLC   #LISTID(2),ESDID-ESDENTRY(R1)    SAME ESDID ON NEXT ONE? 08026000
         BNER  R3                               NO, DONE                08027000
         ICM   R15,B'0111',ESDADDR-ESDENTRY(R1) NEXT ENTRY START        08028000
         A     R15,#LISTVIR                     OFFSET --> NEXT START   08029000
         CR    R14,R15                          CSECT START:NEXT ENTRY  08030000
         BE    LIST490                            SAME, IGNORE ENTRY    08031000
         CR    R15,R6                           NEXT START:CURRENT      08032000
         BNH   LIST480                            NOT ABOVE, USE NEXT   08033000
         BR    R3                                                       08034000
         SPACE 3                                                        08035000
LIST600  BAL   R14,LIST800              PERFORM ANY CSECT POSITIONING   08036000
         LR    R2,R4                    DATA LENGTH                     08037000
         LR    R14,R5                                                   08038000
         SR    R14,R6                   MACHINE LENGTH VALID?           08039000
         BM    LIST160                  NO, BRANCH                      08040000
         CR    R2,R14                                                   08041000
         BNH   *+8                                                      08042000
         LA    R2,1(,R14)               DATA LENGTH FOR THIS SEGMENT    08043000
         BCTR  R2,0                     MACHINE LENGTH FOR THE SEGMENT  08044000
         MVI   MSGLINE+17,C'*'          BEGINNING *                     08045000
         MVC   MSGLINE+18(*-*),0(R6)    <<EXECUTED>>                    08046000
         EX    R2,*-6                   MOVE IN TEXT                    08047000
         LA    R1,MSGLINE+18+1(R2)      POSITION OF FINAL ASTERISK      08048000
         MVI   0(R1),C'*'               FINAL *                         08049000
         UNPK  MSGLINE+4(7),#LISTN1+1(4)    UNPACK ADDRESS              08050000
         TR    MSGLINE+4(6),TRTABLE         CONVERT TO HEXADECIMAL      08051000
         MVI   MSGLINE+10,X'40'             BLANK THE FOLLOWING BYTE    08052000
         UNPK  DOUBLE(7),#LISTN2+1(4)       UNPACK ADDRESS              08053000
         TR    DOUBLE(7),TRTABLE            CONVERT TO HEXADECIMAL      08054000
         MVC   MSGLINE+11(4),DOUBLE+2       MOVE IN ADDRESS             08055000
         MVI   MSGLINE+15,X'40'             BLANK THE FOLLOWING BYTE    08056000
         CLI   DOUBLE+1,C'0'                LESS THAN 64K?              08057000
         BE    *+10                         YES, BRANCH                 08058000
         MVC   MSGLINE+11(5),DOUBLE+1       MOVE IN ADDRESS             08059000
         MVI   MSGLINE+16,X'40'             BLANK ANOTHER BYTE          08060000
         L     R1,#LISTN2                   CSECT                       08061000
         LA    R1,1(R1,R2)                       BYTE                   08062000
         ST    R1,#LISTN2                            DISPLACEMENT       08063000
         LA    R1,20(,R2)               OUTPUT LENGTH                   08064000
         B     LIST640                  FINISH FIND PROCESSING          08065000
         SPACE 2                                                        08066000
LIST610  BAL   R14,LIST800              PERFORM ANY CSECT POSITIONING   08067000
         MVC   MSGLINE(136),MSGBL132    CLEAR THE DATA LINE             08068000
         LR    R2,R4                    DATA LENGTH                     08069000
         LR    R14,R5                                                   08070000
         SR    R14,R6                   MACHINE LENGTH VALID?           08071000
         BM    LIST160                  NO, BRANCH                      08072000
         CR    R2,R14                                                   08073000
         BNH   *+8                                                      08074000
         LA    R2,1(,R14)               DATA LENGTH FOR THIS RECORD     08075000
         BCTR  R2,0                     MACHINE LENGTH FOR THE RECORD   08076000
         LA    R15,MSGLINE+11           PRINT AREA ADDR                 08077000
         MVI   46(R15),C'*'             BEGINNING *                     08078000
         MVC   47(*-*,R15),0(R6)        <<EXECUTED>>                    08079000
         EX    R2,*-6                   MOVE IN TEXT                    08080000
         LA    R1,47+1(R15,R2)                                          08081000
         MVI   0(R1),C'*'               FINAL *                         08082000
         UNPK  MSGLINE+06(7),#LISTN1+1(4)   UNPACK ADDRESS              08083000
         TR    MSGLINE+06(6),TRTABLE        CONVERT TO HEXADECIMAL      08084000
         MVI   MSGLINE+12,X'40'             BLANK THE FOLLOWING BYTE    08085000
         CLI   ##HELOFF,C'D'                DIRENTRY SUBCOMMAND?        08086000
         BNE   *+10                         NO, BRANCH                  08087000
         MVC   MSGLINE+06(6),BLANKS         BLANK THE COUNT FIELD       08088000
         UNPK  DOUBLE(7),#LISTN2+1(4)       UNPACK ADDRESS              08089000
         TR    DOUBLE(7),TRTABLE            CONVERT TO HEXADECIMAL      08090000
         MVC   MSGLINE+13(4),DOUBLE+2       MOVE IN ADDRESS             08091000
         CLI   DOUBLE+1,C'0'                LESS THAN 64K?              08092000
         BE    *+10                         YES, BRANCH                 08093000
         MVC   MSGLINE+13(5),DOUBLE+1       MOVE IN ADDRESS             08094000
         L     R1,#LISTN2                   CSECT                       08095000
         LA    R1,1(R1,R2)                       BYTE                   08096000
         ST    R1,#LISTN2                            DISPLACEMENT       08097000
         LR    R1,R6                    CURRENT DATA POINTER            08098000
         LA    R14,1(,R2)               NUMBER OF BYTES TO FORMAT       08099000
         SR    R0,R0                    CURRENT FORMATTED CHARACTER     08100000
         SPACE 2                                                        08101000
LIST620  MVC   DOUBLE(1),0(R1)          AVOID 0C5 FOR LAST BUFFER BYTE  08102000
         UNPK  8(3,R15),DOUBLE(2)       UNPACK DATA                     08103000
         TR    8(2,R15),TRTABLE         CONVERT TO HEXADECIMAL          08104000
         MVI   10(R15),X'40'            CLEAR FOLLOWING BYTE            08105000
         LA    R15,2(,R15)              INCR INTO PRINT AREA            08106000
         A     R1,=F'1'                 INCREMENT INTO DATA             08107000
         A     R0,=F'1'                 NEXT FORMATTED CHARACTER        08108000
         ST    R0,DOUBLE                                                08109000
         TM    DOUBLE+3,X'03'           4, 8, 12, 16, ...?              08110000
         BNZ   LIST630                  NO, BRANCH                      08111000
         LA    R15,1(,R15)              YES, INCREMENT ONE              08112000
         TM    DOUBLE+3,X'07'           8, 16, 24, 32, ...?             08113000
         BNZ   LIST630                  NO, BRANCH                      08114000
         LA    R15,1(,R15)              YES, INCREMENT ONE              08115000
LIST630  BCT   R14,LIST620              GO FORMAT                       08116000
         LA    R1,62(,R2)               OUTPUT LENGTH                   08117000
         SPACE 1                                                        08118000
LIST640  SLL   R1,16                    CREATE OUTPUT LINE HEADER       08119000
         ST    R1,MSGLINE                                               08120000
         MVC   DOUBLE,DOUBLE                                            08121000
         CLI   ##HELOFF,C'F'            FIND OPERATION?                 08122000
         BNE   LIST700                  NO, LIST -- BRANCH              08123000
         XC    DOUBLE,DOUBLE                                            08124000
         LR    R1,R6                    START OF DATA                   08125000
         LA    R14,0(R6,R2)             END OF DATA -1                  08126000
         LH    R15,FINDLTH              STRING LENGTH                   08127000
         ST    R14,DOUBLE               END OF DISPLAYED PART           08128000
         AR    R14,R15                  MAXIMUM ACCESS                  08129000
         BCTR  R15,0                    MACHINE LENGTH OF STRING        08130000
         CR    R14,R5                   BEYOND RECORD END?              08131000
         BL    LIST660                  NO, BRANCH                      08132000
         LR    R14,R5                   YES, USE END OF RECORD -1       08133000
         SPACE 1                                                        08134000
LIST660  EX    R2,LIST380               FIRST CHARACTER FOUND?          08135000
         BZ    LIST670                  NO, NOT IN STRING               08136000
         LR    R2,R14                                                   08137000
         SR    R2,R1                    MACHINE LENGTH LEFT             08138000
         CR    R15,R2                   POSSIBLY IN STRING?             08139000
         BH    LIST670                  NOT IN STRING                   08140000
         EX    R15,LIST390              ENTIRE STRING FOUND?            08141000
         BNE   *+8                      NO, BRANCH                      08142000
         ST    R1,DOUBLE+4              YES, SAVE THE LAST ADDRESS      08143000
         LA    R1,1(,R1)                NO, TRY NEXT CHARACTER          08144000
         L     R2,DOUBLE                LAST ACCESS BYTE                08145000
         SR    R2,R1                    MACHINE LENGTH LEFT NEGATIVE?   08146000
         BNM   LIST660                  NO, CONTINUE SEARCHING          08147000
         SPACE 2                                                        08148000
LIST670  ICM   R1,B'1111',DOUBLE+4      ANY STRING FOUND?               08149000
         BZ    LIST680                  NO, BRANCH                      08150000
         NI    FLAGSDD,FF-OVERLAP       CLEAR THE OVERLAP FLAG          08151000
         SR    R1,R6                    DISPLACEMENT INTO DISPLAY       08152000
         AH    R1,FINDLTH               LENGTH AT END OF COMPARE        08153000
         CR    R1,R4                    BEYOND DISPLAYED LENGTH?        08154000
         BNH   LIST700                  NO, BRANCH                      08155000
         OI    FLAGSDD,OVERLAP          YES, MARK AS AN OVERLAP         08156000
         B     LIST700                                                  08157000
LIST680  TM    FLAGSDD,OVERLAP          NO STRING FOUND -- OVERLAP SET? 08158000
         BNO   LIST160                  NO, BRANCH                      08159000
         XI    FLAGSDD,OVERLAP          YES, TURN OF THE OVERLAP FLAG   08160000
         SPACE 3                                                        08161000
LIST700  CLI   INSERT#1,X'FF'           ANY HEADER?                     08162000
         BE    LIST760                  NO, BRANCH                      08163000
         CLI   ##HELOFF,C'D'            DIRENTRY SUBCOMMAND?            08164000
         BE    LIST720                  YES, BRANCH                     08165000
         ICM   R0,B'1111',#MAXOUT       ANY MORE OUTPUT?                08166000
         BNP   LIST910                  NO, ALL DONE                    08167000
         CLI   ##HELOFF+3,C'Y'          ANY OUTPUT YET?                 08168000
         BNE   LIST710                  NO, BRANCH                      08169000
         LA    R15,MSGBLANK                                             08170000
         BAL   R14,LIST770              OUTPUT A BLANK LINE             08171000
LIST710  TM    #LISTFLG,X'01'           CSECT OUTPUT?                   08172000
         BO    LIST720                  YES, BRANCH                     08173000
         TM    FLAGSDD,LBLOCK+LDUMP     LBLOCK OR LDUMP?                08174000
         BM    LIST730                  YES, BRANCH                     08175000
LIST720  LA    R15,MSGTEXT1             OUTPUT THE HEADER LINE          08176000
         BAL   R14,LIST770                                              08177000
LIST730  MVI   INSERT#1,X'FF'           TURN OFF THE HEADER             08178000
         L     R0,#MAXOUT               DECREMENT                       08179000
         S     R0,=F'1'                          THE #MAXOUT            08180000
         ST    R0,#MAXOUT                                   COUNTER     08181000
         BM    LIST910                  NEGATIVE, ALL DONE              08182000
LIST760  TR    MSGLINE+4(256),TRLINE    UNPRINTABLES --> PERIODS        08183000
         LA    R15,MSGLINE              OUTPUT THE NEXT LINE            08184000
         BAL   R14,LIST770              OUTPUT THE NEXT LINE            08185000
         TM    ##ADRPA#,$F              FINDLIST MODIFICATION?          08186000
         BNO   *+8                      NO, BRANCH                      08187000
         MVI   ##HELOFF,C'1'            YES, NOW LIST THE REST          08188000
         B     LIST160                  YES, CONTINUE                   08189000
         SPACE 1                                                        08190000
LIST770  STM   R14,R15,#LFSAVE2         SAVE REGISTERS 14 AND 15        08191000
         CLI   ##HELOFF+3,C'D'          FIND AND NO OUTPUT YET?         08192000
         BNE   LIST780                  NO, BRANCH                      08193000
         SPACE 1                                                        08194000
         LA    R1,=C'THEN'                                              08195000
         ICM   R2,B'1111',#ACTIONT      ANY THEN ACTION?                08196000
         BP    LIST980                  YES, BRANCH                     08197000
         SPACE 1                                                        08198000
         ICM   R0,B'1111',#ACTIONE      ANY ELSE ACTION?                08199000
         BP    NEWCMD                   YES, IGNORE THIS MEMBER         08200000
         SPACE 1                                                        08201000
         TM    FLAGSAA,FINDMSG          ANY HEADER MESSAGE?             08202000
         BNO   LIST780                  NO, BRANCH                      08203000
         MESSAGE MSGBLANK               OUTPUT A BLANK LINE             08204000
         MESSAGE FINDMEMQ               OUTPUT THE HEADER LINE          08205000
         NI    FLAGSAA,FF-FINDMSG       TURN OFF THE HEADER LINE        08206000
         SPACE 1                                                        08207000
LIST780  L     R1,#LFSAVE2+4            POINT TO MESSAGE                08208000
         MVI   ##HELOFF+3,C'Y'          OUTPUT WAS GENERATED            08209000
         TSMSG (R1)                     OUTPUT THE MESSAGE              08210000
         L     R14,#LFSAVE2             RESTORE REGISTER 14             08211000
         BR    R14                                                      08212000
         SPACE 3                                                        08213000
LIST800  TM    #LISTFLG,X'60'           CSECT DATA?                     08214000
         BNOR  R14                      NO, RETURN                      08215000
         TM    #LISTFLG,X'08'           NEED ADJUSTMENT?                08216000
         BNO   LIST830                  NO, BRANCH                      08217000
         XI    #LISTFLG,X'08'           RESET THE ADJUSTMENT FLAG       08218000
LIST804  L     R4,#LISTWD               DISPLAY CHARACTER WIDTH         08219000
         ICM   R2,B'1111',#LISTENT      END OF CSECT ENTRIES?           08220000
         BZ    LIST100                  YES, BRANCH                     08221000
         CLI   ESDIDIN,1                THIS CSECT ACTIVE?              08222000
         BNE   LIST100                  NO, GET THE NEXT INPUT BLOCK    08223000
         SPACE 1                                                        08224000
*  ADJUST TO BEGINNING BOUNDARY                                         08225000
         SR    R0,R0                                                    08226000
         ICM   R0,B'0111',ESDADDR       CURRENT OFFSET                  08227000
         A     R0,#LISTVIR              OFFSET --> ACTUAL ADDRESS       08228000
         CR    R0,R6                    VALID ADJUSTMENT?               08229000
         BNH   *+6                      NO, BRANCH                      08230000
         LR    R6,R0                    YES, POSITION TO SYMBOL START   08231000
         LR    R1,R6                                                    08232000
         BCTR  R1,0                                                     08233000
         CR    R1,R5                    IN THIS DATA RECORD?            08234000
         BNL   LIST100                  NO, IGNORE THIS RECORD          08235000
         XC    #LISTOFF(4),#LISTOFF     MODULE OFFSET WAS HONORED       08236000
         MVC   #LISTID(2),ESDID         SAVE THE CURRENT ESD ID         08237000
         MVI   MTHIGHL,38                                               08238000
         MVC   MSGTEXT1(3),L141$1                                       08239000
         MVC   INSERT#1(38),MSGLDUMP    "AT 123456  CSECT 12345678 .."  08240000
         UNPK  INSERT#1(7),ESDADDR(4)                                   08241000
         TR    INSERT#1(6),TRTABLE      OFFSET OF CSECT OR ENTRY        08242000
         MVI   INSERT#1+6,X'40'                                         08243000
         MVC   INSERT#1+14(8),ESDNAME   PRIVATE, COMMON OR CSECT NAME   08244000
         UNPK  INSERT#1+31(7),ESDLEN(4)                                 08245000
         TR    INSERT#1+31(6),TRTABLE   LENGTH OF CSECT                 08246000
         MVI   INSERT#1+31+6,X'40'                                      08247000
         LR    R0,R6                                                    08248000
         S     R0,#LISTVIR              ACTUAL ADDRESS --> OFFSET       08249000
         ST    R0,#LISTN1               OFFSET IN LOAD MODULE           08250000
         SR    R1,R1                                                    08251000
         ICM   R1,B'0111',ESDADDR       ENTRY ADDRESS                   08252000
         SR    R0,R1                                                    08253000
         ST    R0,#LISTN2               OFFSET IN CSECT                 08254000
         CLI   ESDTYPE,CODESD           CSECT ENTRY?                    08255000
         BE    LIST810                  YES, BRANCH                     08256000
         TM    ESDTYPE,CODEPC           PRIVATE CODE OR OVERLAY?        08257000
         BO    LIST810                  YES, BRANCH                     08258000
         L     R15,ESDCSECT             ADDRESS OF MAIN ENTRY           08259000
         MVC   INSERT#1+14(8),4(R15)    CSECT NAME                      08260000
         MVC   INSERT#1+24(6),=C' ENTRY' ENTRY WITHIN A CSECT           08261000
         MVC   INSERT#1+31(8),ESDNAME                                   08262000
         AR    R0,R1                                                    08263000
         ICM   R1,B'0111',ESDMAIN+1     CSECT START ADDRESS             08264000
         SR    R0,R1                                                    08265000
         ST    R0,#LISTN2               OFFSET IN CSECT                 08266000
         SPACE 2                                                        08267000
LIST810  ICM   R0,B'0111',ESDADDR       ENTRY ADDRESS                   08268000
         LR    R15,R0                   SAVE THE ENTRY ADDRESS          08269000
         A     R0,ESDLEN-1              LAST ADDRESS TO BE ACCESSED     08270000
LIST814  LTR   R2,R2                    AT END OF LIST?                 08271000
         BZ    LIST820                  YES, BRANCH                     08272000
         ICM   R2,B'1111',ESDLINK       ANOTHER ESD ENTRY?              08273000
         ST    R2,#LISTENT                                              08274000
         BZ    LIST820                  NO, BRANCH                      08275000
         CLC   #LISTID(2),ESDID         ENTRY FOR THIS CSECT?           08276000
         BNE   LIST820                  NO, USE THE CURRENT ENTRY       08277000
         CLM   R15,B'0111',ESDADDR      START:NEXT START                08278000
         BNL   LIST814                    HIGH OR EQUAL, DISCARD IT     08279000
         CLM   R0,B'0111',ESDADDR       END:NEXT START                  08280000
         BNH   LIST820                    LOW OR EQUAL, USE THIS LIMIT  08281000
         ICM   R0,B'0111',ESDADDR         HIGH, USE THE LOWER LIMIT     08282000
         SPACE 1                                                        08283000
LIST820  LR    R1,R0                    CSECT OR ENTRY END              08284000
         SR    R1,R15                   CSECT OR ENTRY LENGTH           08285000
         C     R1,#MAXLEN               ABOVE MAXIMUM CSECT LENGTH?     08286000
         BL    *+8                      NO, BRANCH                      08287000
         L     R1,#MAXLEN               YES, USE THE REQUESTED MAXIMUM  08288000
         AR    R1,R15                   END OF CSECT OR ENTRY           08289000
         A     R1,#LISTVIR              OFFSET --> ACTUAL ADDRESS       08290000
         ST    R1,#LISTE1               SAVE END ADDRESS                08291000
         SPACE 2                                                        08292000
*  CHECK FOR END OF CSECT OR EXTERNAL LABEL                             08293000
LIST830  LR    R1,R4                    DATA LENGTH                     08294000
         LR    R15,R5                                                   08295000
         SR    R15,R6                   MACHINE LENGTH VALID?           08296000
         BM    LIST100                  NO, IGNORE THIS RECORD          08297000
         CR    R1,R15                                                   08298000
         BNH   *+8                                                      08299000
         LA    R1,1(,R15)               R1=MIN(16 OR 64,LENGTH LEFT)    08300000
         AR    R1,R6                    END OF THIS LINE                08301000
         C     R1,#LISTE1               END ON THIS LINE?               08302000
         BLR   R14                      NO, RETURN                      08303000
         OI    #LISTFLG,X'08'           NEW HEADER IS NEEDED            08304000
         L     R4,#LISTE1               MAXIMUM ADDRESS OF CSECT        08305000
         SR    R4,R6                    DISPLAY LENGTH VALID?           08306000
         BPR   R14                      YES, BRANCH                     08307000
         LTR   R2,R2                    AT END OF LIST?                 08308000
         BZ    LIST100                  YES, IGNORE THIS MEMBER         08309000
         B     LIST804                  NO, TRY THE NEXT CSECT          08310000
         SPACE 3                                                        08311000
LIST900  MVI   ##HELOFF+2,X'FF'         END OF FILE ENCOUNTERED         08312000
LIST910  CLI   ##HELOFF+3,C'D'          FIND AND NO OUTPUT?             08313000
         BNE   LIST920                  NO, BRANCH                      08314000
         LA    R1,=C'ELSE'                                              08315000
         ICM   R2,B'1111',#ACTIONE      ANY ELSE ACTION?                08316000
         BP    LIST980                  YES, BRANCH                     08317000
         TM    FLAGSAA,FMEM#MEM         MEMBER GROUP IN PROGRESS?       08318000
         BO    NEWCMD                   YES, DONE                       08319000
         B     LIST940                  NO, BRANCH                      08320000
         SPACE 1                                                        08321000
LIST920  TM    FLAGSDD,LBLOCK+LDUMP+BLOCK+DUMP SEGMENT FORMAT?          08322000
         BZ    LIST940                         NO, BRANCH               08323000
         MESSAGE MSGBLANK               OUTPUT A BLANK LINE             08324000
         SPACE 1                                                        08325000
LIST940  CLI   ##HELOFF+2,X'FF'         END OF FILE ENCOUNTERED?        08326000
         BNE   NEWCMD                   NO, DONE                        08327000
         MVI   MTHIGHL,L'MSGBLK-1                                       08328000
         LA    R1,L142$1                                                08329000
         MVC   INSERT#1-1(34),MSGBLK                                    08330000
         L     R0,#BLKCNT                                               08331000
         CVD   R0,DOUBLE                                                08332000
         ED    INSERT#1-1(10),DOUBLE+4                                  08333000
         TM    #LISTFLG,X'01'           CSECT FORMATTING?               08334000
         BO    LIST960                  YES, BRANCH                     08335000
         TM    FLAGSDD,DUMP+BLOCK                                       08336000
         BNZ   LIST960                                                  08337000
         MVC   INSERT#1+MSGBLKL-MSGBLK-1(6),=C' LINES'                  08338000
LIST960  TM    DSORG,DS1DSGPO                                           08339000
         BO    MSGNEW                                                   08340000
         MVC   INSERT#1+MSGBLKS-MSGBLK-1(8),=C'DATA SET'                08341000
         B     MSGNEW                                                   08342000
         SPACE 2                                                        08343000
LIST980  MVC   FINDMEMQ+25(4),0(R1)     ADD "THEN" OR "ELSE"            08344000
         TM    ##ADRPA#-##SUBCOM(R2),$D DEFAULT MESSAGE SUBCOMMAND?     08345000
         BNZ   LIST990                  NO, BRANCH                      08346000
         SPACE 1                                                        08347000
         MESSAGE MSGBLANK               OUTPUT A BLANK LINE             08348000
         TM    FLAGSAA,FINDMSG          ANY MESSAGE TO OUTPUT?          08349000
         BNO   LIST990                  NO, BRANCH                      08350000
         XI    FLAGSAA,FINDMSG          NO MORE MESSAGE                 08351000
         MVC   FINDMEMQ+30(8),0(R2)     SUBCOMMAND TO EXECUTE           08352000
         MESSAGE FINDMEMQ               IDENTIFICATION LINE             08353000
         SPACE 1                                                        08354000
LIST990  MVC   ##ANSWER(LISUBS),ISUBS   INITIALIZE THE PDL SAVE AREA    08355000
         MVC   ##SUBCOM(PTW),0(R2)      CHANGE THE SUBCOMMAND           08356000
         MVI   MTHIGHL,8                                                08357000
         MVI   MTHIGHL+4,8                                              08358000
         B     CALLCMDZ                 CALL THE SECONDARY SUBCOMMAND   08359000
         SPACE 3                                                        08360000
MSGDUMP  DC    C' 1,234,567   LENGTH 12,345   TTR 123456 '              08361000
         ORG   MSGDUMP                                                  08362000
         DC    X'40206B2020206B202120'   EDIT PATTERN                   08363000
         ORG   MSGDUMP+19                                               08364000
MSGDUMPL DC    X'4020206B202120'         EDIT PATTERN                   08365000
MSGDUMPT EQU   MSGDUMP+33,6              TTR OUTPUT                     08366000
         ORG   ,                                                        08367000
MSGLDUMP DC    C'123456  CSECT 12345678  LENGTH 123456  '               08368000
*                C'1234567890123456789012345678901234567890             08369000
MSGBLK   DC    C' 1,234,567 BLOCKS IN THIS MEMBER  '                    08370000
         ORG   MSGBLK                                                   08371000
         DC    X'40206B2020206B202120'   EDIT PATTERN                   08372000
MSGBLKL  EQU   MSGBLK+11,6               " LINES"                       08373000
MSGBLKS  EQU   MSGBLK+26,7               "DATA SET"                     08374000
         ORG   ,                                                        08375000
         DROP  R2                                                  @D04
         SPACE 2                                                   @D04
*   Build and write additional information for DIRENTRY            @D04
DIR000   BALR  R8,0                     OUTPUT ADDITIONAL DIR DATA @D04
         USING *,R8                                                @D04
         MESSAGE MSGBLANK               OUTPUT ADDITIONAL DIR DATA @D04
         CLC   ##SUBCOM+#LSUB(8),$DIR   IF OR THEN FORM?           @D04
         BNE   NEWCMD                   YES, NO ADDITIONAL OUTPUT  @D04
         CLI   #DIRSHOR,1               SHORT FORM?                @D04
         BE    NEWCMD                   YES, BRANCH                @D04
         MVI   MTLEN,70                 LENGTH OF MESSAGE INSERT   @D04
         MVC   INSERT#1(100),BLANK128   CLEAR THE HEADER LINE      @D04
         MVC   INSERT#1(40),MSG262H     HEADER INFORMATION         @D04
         TSMSG L262$1                                              @D04
         MVC   INSERT#1(40),MSG262U     UNDERLINE INFORMATION      @D04
         SPACE 2                                                   @D04
         SR    R2,R2                    OFFSET IN THE DIRECTORY    @D04
         LA    R3,DIRHDR                START OF HEADER NAMES      @D04
         BAL   R4,DIRFMT10              OUTPUT FIRST MESSAGE       @D04
         SPACE 1                                                   @D04
         MVC   INSERT#1+13(8),DIRNAME   ADD THE MEMBER NAME        @D04
         BAL   R4,DIRFMT                (00)                       @D04
         LA    R2,8(,R2)                POSITION PAST MEMBER NAME  @D04
         SPACE 1                                                   @D04
         LA    R0,3                     3 INPUT BYTES              @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (08)                       @D04
         LA    R2,3(,R2)                POSITION PAST TTR          @D04
         SPACE 1                                                   @D04
         LA    R0,1                     1 INPUT BYTE               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         IC    R14,DIRFLAG                                         @D04
         SLL   R14,25                   DROP ALIAS BIT             @D04
         SRDL  R14,30                   SAVE HALFWORD COUNT        @D04
         LA    R14,X'F0'(,R14)          CONVERT TO DISPLAY         @D04
         STC   R14,INSERT#1+30          SAVE TTR COUNT IN MESSAGE  @D04
         SPACE 1                                                   @D04
         SRL   R15,32-5                 HALFWORD COUNT             @D04
         CVD   R15,DOUBLE                                          @D04
         MVC   FULLWORD(4),DIR4020      EDIT PATTERN               @D04
         ED    FULLWORD(4),DOUBLE+6                                @D04
         MVC   INSERT#1+45(2),FULLWORD+2  ADD COUNT                @D04
         SPACE 1                                                   @D04
         TM    DIRFLAG,X'80'            ALIAS?                     @D04
         BO    DIR040                   YES, BRANCH                @D04
         MVC   INSERT#1+23+44(12),BLANK128                         @D04
         MVC   INSERT#1+23(44),INSERT#1+30  DROP "ALIAS;"          @D04
         SPACE 1                                                   @D04
DIR040   BAL   R4,DIRFMT                (0B)                       @D04
         LA    R2,1(,R2)                POSITION PAST INDC         @D04
         SPACE 2                                                   @D04
         TM    FLAGSCC,RECFMU           RECFM=U?                   @D04
         BNO   DIR800                   YES, BRANCH                @D04
         LA    R0,4                     TTR +1 BYTE                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         MVC   INSERT#1+21(1),INSERT#1+20                          @D04
         MVC   INSERT#1+20(1),INSERT#1+19                          @D04
         MVI   INSERT#1+19,C','                                    @D04
         BAL   R4,DIRFMT                (0C)                       @D04
         LA    R2,4(,R2)                POSITION PAST TTRT         @D04
         SPACE 1                                                   @D04
         TM    DIRATTR,X'24'            OVERLAY OR SCATTER?        @D04
         BZ    *+8                      NO, BRANCH                 @D04
         BAL   R4,DIRFMT20              YES, GET NEXT DOC.         @D04
         TM    DIRATTR,X'20'            OVERLAY?                   @D04
         BO    DIR110                   YES, BRANCH                @D04
         LA    R0,4                     TTR +1 BYTE                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         MVC   INSERT#1+21(1),INSERT#1+20                          @D04
         MVC   INSERT#1+20(1),INSERT#1+19                          @D04
         MVI   INSERT#1+19,C','                                    @D04
         BAL   R4,DIRFMT                (10)                       @D04
         LA    R2,4(,R2)                POSITION PAST TTRN         @D04
         B     DIR120                                              @D04
         SPACE 1                                                   @D04
DIR110   BAL   R4,DIRFMT20              GET NEXT DOC.              @D04
         LA    R0,3                     TTR                        @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (10)                       @D04
         LA    R2,3(,R2)                POSITION PAST TTRN         @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         IC    R0,DIRNOTE#              NUMBER OF NOTELIST ELEMENTS@D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (13)                       @D04
         LA    R2,1(,R2)                POSITION PAST NL           @D04
         SPACE 1                                                   @D04
DIR120   LA    R3,DIRHDR14              REPOSITION THE HEADER INFO @D04
         BAL   R4,DIRFMT20                                         @D04
         LA    R0,1                     1 INPUT BYTE               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         LA    R14,X'80'*2              TEST MASK                  @D04
         LA    R5,DIRBITP1-2            TEXT OFFSETS               @D04
         BAL   R4,DIRBITS                                          @D04
         BAL   R4,DIRFMT                (14)                       @D04
         SPACE 1                                                   @D04
         LA    R14,X'08'*2              TEST MASK                  @D04
         LA    R5,DIRBITP2-2            TEXT OFFSETS               @D04
         BAL   R4,DIRBITS                                          @D04
         BAL   R4,DIRFMT10              (14)                       @D04
         LA    R2,1(,R2)                SKIP ATR1                  @D04
         SPACE 1                                                   @D04
         LA    R0,1                     1 INPUT BYTE               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         LA    R14,X'80'*2              TEST MASK                  @D04
         LA    R5,DIRBITP3-2            TEXT OFFSETS               @D04
         BAL   R4,DIRBITS                                          @D04
         BAL   R4,DIRFMT                (15)                       @D04
         SPACE 1                                                   @D04
         LA    R14,X'08'*2              TEST MASK                  @D04
         LA    R5,DIRBITP4-2            TEXT OFFSETS               @D04
         BAL   R4,DIRBITS                                          @D04
         BAL   R4,DIRFMT10              (15)                       @D04
         LA    R2,1(,R2)                SKIP ATR2                  @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         ICM   R0,B'0111',DIRSTORE      3 INPUT BYTES              @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (16)                       @D04
         LA    R2,3(,R2)                SKIP STOR                  @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         ICM   R0,B'0011',DIRTEXTL      2 INPUT BYTES              @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (19)                       @D04
         LA    R2,2(,R2)                SKIP FTBL                  @D04
         SPACE 1                                                   @D04
         LA    R0,3                     3 INPUT BYTES              @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (1B)                       @D04
         LA    R2,3(,R2)                SKIP EPA                   @D04
         SPACE 1                                                   @D04
         TM    DIRATTR2,X'80'           VS LINKAGE EDITOR?         @D04
         BO    DIR210                   YES, BRANCH                @D04
         MVC   INSERT#1+04(08),DIRHDROS NEW OPERAND NAME           @D04
         MVC   INSERT#1+23(44),DIRHDROS+8  NEW DESCRIPTION         @D04
         LA    R0,3                     3 INPUT BYTES              @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (1E)                       @D04
         LA    R2,3(,R2)                SKIP FTB0, FTB1, FTB2      @D04
         B     DIR300                                              @D04
         SPACE 1                                                   @D04
DIR210   LA    R0,1                     1 INPUT BYTE               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (1E)                       @D04
         LA    R2,1(,R2)                SKIP FTB0                  @D04
         SPACE 1                                                   @D04
         LA    R4,DIR220                NEXT RETURN POINT          @D04
         TM    DIRATTR2,X'20'           PAGE ALIGNED?              @D04
         BO    DIRFMT10                 YES, BRANCH                @D04
         BAL   R4,DIRFMT20              NO, GET NEXT DOC.          @D04
         SPACE 1                                                   @D04
DIR220   LA    R4,DIR230                NEXT RETURN POINT          @D04
         TM    DIRATTR2,X'10'           SSI PRESENT?               @D04
         BO    DIRFMT10                 YES, BRANCH                @D04
         BAL   R4,DIRFMT20              NO, GET NEXT DOC.          @D04
         SPACE 1                                                   @D04
DIR230   LA    R4,DIR230A               NEXT RETURN POINT          @D04
         TM    DIRATTR2,X'08'           APF INFORMATION VALID?     @D04
         BO    DIRFMT10                 YES, BRANCH                @D04
         BAL   R4,DIRFMT20              NO, GET NEXT DOC.          @D04
         SPACE 1                                                   @D04
DIR230A  LA    R4,DIR230B               NEXT RETURN POINT          @D04
         TM    DIRATTR2,DIR2LFMT        PROGRAM OBJECT FORMAT?     @D04
         BO    DIRFMT10                 YES, BRANCH                @D04
         BAL   R4,DIRFMT20              NO, GET NEXT DOC.          @D04
         SPACE 1                                                   @D04
DIR230B  LA    R4,DIR240                NEXT RETURN POINT          @D04
         TM    DIRATTR2,DIR2BIG         16M OR MORE?               @D04
         BO    DIRFMT10                 YES, BRANCH                @D04
         BAL   R4,DIRFMT20              NO, GET NEXT DOC.          @D04
         SPACE 1                                                   @D04
DIR240   LA    R0,1                     1 INPUT BYTE               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         TM    DIRATTR3,DIRRMANY        RMODE=ANY?                 @D04
         BO    *+10                     YES, BRANCH                @D04
         MVC   INSERT#1+29(4),DIR24     NO, RMODE 24               @D04
         SPACE 1                                                   @D04
         TM    DIRATTR3,DIRAA31+DIRAA64 ALIAS AMODE=ANY?           @D04
         BO    DIR250                   YES, BRANCH                @D04
         MVC   INSERT#1+46(4),=C'  ; '  NO, "  ; "                 @D04
         TM    DIRATTR3,DIRAA31         ALIAS AMODE=31?            @D04
         BNO   *+4+6+4                  NO, BRANCH                 @D04
         MVC   INSERT#1+46(2),DIR31     YES, "31"                  @D04
         B     DIR250                                              @D04
         TM    DIRATTR3,DIRAA64         ALIAS AMODE=64?            @D04
         BNO   *+4+6+4                  NO, BRANCH                 @D04
         MVC   INSERT#1+46(2),DIR64     YES, "64"                  @D04
         B     DIR250                                              @D04
         MVC   INSERT#1+46(2),DIR24     "24"                       @D04
         SPACE 1                                                   @D04
DIR250   TM    DIRATTR3,DIRAM31+DIRAM64 MAIN AMODE=ANY?            @D04
         BO    DIR260                   YES, BRANCH                @D04
         MVC   INSERT#1+62(4),=C'    '  NO, "    "                 @D04
         TM    DIRATTR3,DIRAM31         MAIN AMODE=31?             @D04
         BNO   *+4+6+4                  NO, BRANCH                 @D04
         MVC   INSERT#1+62(2),DIR31     YES, "31"                  @D04
         B     DIR260                                              @D04
         TM    DIRATTR3,DIRAM64         MAIN AMODE=64?             @D04
         BNO   *+4+6+4                  NO, BRANCH                 @D04
         MVC   INSERT#1+62(2),DIR64     YES, "64"                  @D04
         B     DIR260                                              @D04
         MVC   INSERT#1+62(2),DIR24     "24"                       @D04
         SPACE 1                                                   @D04
DIR260   BAL   R4,DIRFMT                (1F)                       @D04
         LA    R2,1(,R2)                SKIP FTB1                  @D04
         SPACE 2                                                   @D04
         LA    R0,1                     1 INPUT BYTE               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (20)                       @D04
         LA    R2,1(,R2)                SKIP FTB2                  @D04
         SPACE 1                                                   @D04
DIR300   LA    R3,DIRHDR21              REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         TM    DIRATTR,X'04'            SCATTER LOAD?              @D04
         BNO   DIR400                   NO, BRANCH                 @D04
         SR    R0,R0                                               @D04
         ICM   R0,B'0011',DIRSCLL       COUNT                      @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (21)                       @D04
         LA    R2,2(,R2)                SKIP SLSZ                  @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         ICM   R0,B'0011',DIRSCTL       COUNT                      @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (23)                       @D04
         LA    R2,2(,R2)                SKIP TTSZ                  @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         ICM   R0,B'0011',DIRSCET       COUNT                      @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (25)                       @D04
         LA    R2,2(,R2)                SKIP ESDT                  @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         ICM   R0,B'0011',DIRSCEP       COUNT                      @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (27)                       @D04
         LA    R2,2(,R2)                SKIP ESDC                  @D04
         SPACE 1                                                   @D04
DIR400   LA    R3,DIRHDR29              REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         TM    DIRFLAG,DIRALIAS         ALIAS?                     @D04
         BNO   DIR500                   NO, BRANCH                 @D04
         LA    R0,3                     3 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (29)                       @D04
         LA    R2,3(,R2)                SKIP EPM                   @D04
         SPACE 1                                                   @D04
         LA    R1,DIRNAME(R2)           START OF MAIN MEMBER NAME  @D04
         MVC   INSERT#1+13(8),0(R1)     MOVE INTO MESSAGE AREA     @D04
         BAL   R4,DIRFMT                (2C)                       @D04
         LA    R2,8(,R2)                SKIP MNM                   @D04
         SPACE 1                                                   @D04
DIR500   LA    R3,DIRHDR34              REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         TM    DIRATTR2,X'80'           VS LINKAGE EDITOR?         @D04
         BO    DIR550                   YES, BRANCH                @D04
         LA    R2,1(,R2)                                           @D04
         N     R2,=F'-2'                ROUND TO HALFWORD BOUNDARY @D04
         CLC   ZERO,0(R2)               ZERO?                      @D04
         BE    DIR990                   YES, NO SSI                @D04
         CLC   =F'-1',0(R2)             FFFFFFFF?                  @D04
         BE    DIR990                   YES, NO SSI                @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (34)                       @D04
         LA    R2,4(,R2)                SKIP SSI                   @D04
         B     DIR990                                              @D04
         SPACE 1                                                   @D04
DIR550   TM    DIRATTR2,DIR2SSI         ANY SSI INFORMATION?       @D04
         BNO   DIR600                   NO, BRANCH                 @D04
         LA    R2,1(,R2)                                           @D04
         N     R2,=F'-2'                ROUND TO HALFWORD BOUNDARY @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (34)                       @D04
         LA    R2,4(,R2)                SKIP SSI                   @D04
         SPACE 1                                                   @D04
DIR600   LA    R3,DIRHDR38              REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         TM    DIRATTR2,DIRAPFLG        VALID APF INFORMATION?     @D04
         BNO   DIR650                   NO, BRANCH                 @D04
         LA    R0,1                     1 HEX BYTE                 @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (38)                       @D04
         LA    R2,1(,R2)                SKIP APFCT                 @D04
         SPACE 1                                                   @D04
         LA    R0,1                     1 HEX BYTE                 @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (39)                       @D04
         LA    R2,1(,R2)                SKIP APFAC                 @D04
         B     DIR660                                              @D04
         SPACE 1                                                   @D04
DIR650   L     R3,=A(DIRHDRLP)          REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
DIR660   DS    0H                                                  @D04
         SPACE 2                                                   @D04
DIR700   DS    0H                                                  @D04
         L     R3,=A(DIRHDRPM)          REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         LA    R2,1(,R2)                                           @D04
         N     R2,=F'-2'                ROUND TO HALFWORD          @D04
         LA    R1,DIRNAME(R2)           POINT INTO DIRECTORY       @D04
***PDSMAN CHANGES: DIRENTER FOR LISTING PDSMAN ATTRIBUTES          @D04
         TM    3(R1),X'0F'              PDSMAN DATE? 0CYYDDDF      @D04
         BNO   DIR990                   NO, BRANCH                 @D04
         TM    0(R1),X'FE'              PDSMAN DATE? 0CYYDDDF      @D04
         BNZ   DIR990                   NO, BRANCH                 @D04
         TM    8(R1),X'0F'              PDSMAN DATE?   YYDDDF      @D04
         BNO   DIR990                   NO, BRANCH                 @D04
         TM    21(R1),X'0F'             PDSMAN DATE?   YYDDDF      @D04
         BNO   DIR990                   NO, BRANCH                 @D04
         SPACE 1                                                   @D04
         LA    R0,4                     4 HEX DIGITS               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,4(,R2)                SKIP MANMODD               @D04
         SPACE 1                                                   @D04
         LA    R0,2                     2 HEX DIGITS               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,2(,R2)                SKIP MANMODT               @D04
         SPACE 1                                                   @D04
         LA    R0,3                     3 HEX DIGITS               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,3(,R2)                SKIP MANEXPR               @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         IC    R0,DIRNAME(R2)           LEVEL NUMBER               @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,1(,R2)                SKIP MANMODN               @D04
         SPACE 1                                                   @D04
         LA    R1,DIRNAME(R2)           POINT TO LAST USER         @D04
         MVC   INSERT#1+13(8),0(R1)     LAST USER                  @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,8(,R2)                SKIP MANUSER               @D04
         SPACE 1                                                   @D04
         LA    R0,1                     1 HEX DIGIT                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,1(,R2)                SKIP MANPROD               @D04
         SPACE 1                                                   @D04
         LA    R0,3                     3 HEX DIGITS               @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                                           @D04
         LA    R2,3(,R2)                SKIP MANREAD               @D04
         B     DIR990                                              @D04
         SPACE 3                                                   @D04
DIR800   TM    DIRFLAG,X'0F'            SPF STATISTICS?            @D04
         BO    DIR900                   YES, BRANCH                @D04
         TM    DIRFLAG,X'14'            SPF STATISTICS EXT?        @D04
         BO    DIR900                   YES, BRANCH                @D04
         MVC   DOUBLE(1),DIRFLAG        COPY THE ATTRIBUTE BYTE    @D04
         NI    DOUBLE,X'FF'-X'80'       RESET THE ALIAS FLAG       @D04
         CLI   DOUBLE,X'02'             SSI INFORMATION?           @D04
         BL    DIR990                   NO, BRANCH                 @D04
         LA    R3,DIRHDR34              REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (34)                       @D04
         LA    R2,4(,R2)                SKIP SSI                   @D04
         B     DIR990                                              @D04
         SPACE 1                                                   @D04
DIR900   L     R3,=A(DIRHDRSP)          REPOSITION HEADER          @D04
         BAL   R4,DIRFMT20                                         @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         IC    R0,DIRNAME(R2)                                      @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (SPF-0C)                   @D04
         LA    R2,1(,R2)                SKIP SPFV                  @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         IC    R0,DIRNAME(R2)                                      @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (SPF-0D)                   @D04
         LA    R2,1(,R2)                SKIP SPFR                  @D04
         SPACE 1                                                   @D04
*        LH    R0,DIRNAME(R2)                                      @D04
*        BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         LA    R0,1                     1 HEX BYTE                 @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-0E)                   @D04
         LA    R2,1(,R2)                SKIP SPFSC                 @D04
         SPACE 1                                                   @D04
         LA    R0,1                     1 HEX BYTE                 @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-0F)                   @D04
         LA    R2,1(,R2)                SKIP SPFCS                 @D04
         SPACE 1                                                   @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-10)                   @D04
         LA    R2,4(,R2)                SKIP SPFCR                 @D04
         SPACE 1                                                   @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-14)                   @D04
         LA    R2,4(,R2)                SKIP SPFCD                 @D04
         SPACE 1                                                   @D04
         LA    R0,2                     2 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-18)                   @D04
         LA    R2,2(,R2)                SKIP SPFCT                 @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         LA    R1,DIRNAME(R2)                                      @D04
         ICM   R0,B'0011',0(R1)                                    @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (SPF-1A)                   @D04
         LA    R2,2(,R2)                SKIP SPFSI                 @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         LA    R1,DIRNAME(R2)                                      @D04
         ICM   R0,B'0011',0(R1)                                    @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (SPF-1C)                   @D04
         LA    R2,2(,R2)                SKIP SPFIN                 @D04
         SPACE 1                                                   @D04
         SR    R0,R0                                               @D04
         LA    R1,DIRNAME(R2)                                      @D04
         ICM   R0,B'0011',0(R1)                                    @D04
         BAL   R4,DIRDEC                CONVERT TO DECIMAL         @D04
         BAL   R4,DIRFMT                (SPF-1E)                   @D04
         LA    R2,2(,R2)                SKIP SPFMD                 @D04
         SPACE 1                                                   @D04
         LA    R1,DIRNAME(R2)           START OF MAIN MEMBER       @D04
         MVC   INSERT#1+13(8),0(R1)     MOVE INTO MESSAGE AREA     @D04
         BAL   R4,DIRFMT                (SPF-20)                   @D04
         LA    R2,8(,R2)                SKIP SPFID                 @D04
         SPACE 1                                                   @D04
         TM    DIRSPFFL,DIRSPFXS        EXTENDED STATS?            @D04
         BNO   DIR990                   NO                         @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-28)                   @D04
         LA    R2,4(,R2)                SKIP SPFSI-X               @D04
         SPACE 1                                                   @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-2C)                   @D04
         LA    R2,4(,R2)                SKIP SPFIN-X               @D04
         SPACE 1                                                   @D04
         LA    R0,4                     4 HEX BYTES                @D04
         BAL   R4,DIRHEX                CONVERT TO HEX             @D04
         BAL   R4,DIRFMT                (SPF-30)                   @D04
         LA    R2,4(,R2)                SKIP SPFMD-X               @D04
         SPACE 1                                                   @D04
DIR990   MESSAGE MSGBLANK                                          @D04
         B     NEWCMD                                              @D04
DIRDEC   C     R0,DIRDEC99                                         @D04
         BH    DIRDEC10                                            @D04
         CVD   R0,DOUBLE                                           @D04
         MVC   INSERT#1+100+8(8),BLANK128                          @D04
         MVC   INSERT#1+100(8),DIR2020                             @D04
         ED    INSERT#1+100(7),DOUBLE+5                            @D04
         LA    R1,INSERT#1+100-1                                   @D04
         LA    R1,1(,R1)                                           @D04
         CLI   0(R1),X'40'                                         @D04
         BE    *-8                                                 @D04
         MVC   INSERT#1+13(8),0(R1)                                @D04
         BR    R4                                                  @D04
DIRDEC10 LR    R1,R0                                               @D04
         LA    R1,1023(,R1)                                        @D04
         SRL   R1,10                    THE NEXT HIGHER K VALUE    @D04
         CVD   R1,DOUBLE                                           @D04
         MVC   INSERT#1+100+8(8),BLANK128                          @D04
         MVC   INSERT#1+100(7),DIR2020                             @D04
         MVI   INSERT#1+100+7,C'K'                                 @D04
         ED    INSERT#1+100(7),DOUBLE+5                            @D04
         LA    R1,INSERT#1+100-1                                   @D04
         LA    R1,1(,R1)                                           @D04
         CLI   0(R1),X'40'                                         @D04
         BE    *-8                                                 @D04
         MVC   INSERT#1+13(8),0(R1)                                @D04
         BR    R4                                                  @D04
DIRDEC99 DC    F'99999'                                            @D04
         SPACE 3                                                   @D04
DIRHEX   LA    R1,DIRNAME(R2)           POINT TO DATA              @D04
         LA    R15,INSERT#1+13          START OF OUTPUT DATA       @D04
         SPACE 1                                                   @D04
DIRHEX10 UNPK  0(3,R15),0(2,R1)         UNPACK TO HEXADECIMAL      @D04
         TR    0(2,R15),TRTABLE         CONVERT TO PRINTABLE       @D04
         MVI   2(R15),X'40'             BLANK GARBAGE BYTE         @D04
         LA    R15,2(,R15)              NEXT OUTPUT DIGIT          @D04
         LA    R1,1(,R1)                NEXT INPUT DIGIT           @D04
         BCT   R0,DIRHEX10              FORMAT ALL INPUT DIGITS    @D04
         BR    R4                                                  @D04
         SPACE 3                                                   @D04
DIRFMT   STC   R2,DOUBLE                SAVE OFFSET IN STORAGE     @D04
         UNPK  INSERT#1(3),DOUBLE(2)    UNPACK TO HEXADECIMAL      @D04
         TR    INSERT#1(2),TRTABLE      CONVERT TO PRINTABLE OFFSET@D04
         MVI   INSERT#1+2,X'40'         CLEAR GARBAGE BYTE         @D04
         SPACE 1                                                   @D04
DIRFMT10 TR    INSERT#1(70),TRLINE      CONVERT TO PRINTABLE       @D04
         TSMSG L262$1                   OUTPUT                     @D04
         SPACE 1                                                   @D04
DIRFMT20 MVC   INSERT#1(100),BLANK128   BLANK THE OUTPUT AREA      @D04
         MVC   INSERT#1+04(08),0(R3)    ADD THE PDS... NAME        @D04
         MVC   INSERT#1+23(44),8(R3)    ADD THE DESCRIPTION        @D04
         LR    R6,R3                    THIS TEXT                  @D04
         LA    R3,52(,R3)               NEXT TEXT                  @D04
         BR    R4                                                  @D04
         SPACE 3                                                   @D04
DIRBITS  ST    R14,DOUBLE+4             SAVE TEST MASK             @D04
         LA    R15,INSERT#1+23          OUTPUT START               @D04
         MVC   0(44,R15),BLANK128                                  @D04
         LA    R0,4                     BITS PER LINE              @D04
         LR    R1,R6                    INPUT TEXT                 @D04
         SPACE 1                                                   @D04
DIRBIT10 LA    R5,2(,R5)                NEXT OFFSET                @D04
         LH    R6,0(,R5)                                           @D04
         LPR   R6,R6                                               @D04
         ST    R6,FULLWORD              OFFSET OF TEXT             @D04
         AR    R6,R1                                               @D04
         ST    R6,DOUBLE                START OF TEXT              @D04
         LH    R6,2(,R5)                                           @D04
         LPR   R6,R6                                               @D04
         S     R6,FULLWORD                                         @D04
         ST    R6,FULLWORD              LENGTH OF TEXT             @D04
         L     R14,DOUBLE+4             SHIFT                      @D04
         SRL   R14,1                         FOR NEXT              @D04
         ST    R14,DOUBLE+4                          BIT TEST      @D04
         LA    R6,DIRNAME(R2)           POINT TO TARGET DATA       @D04
         TM    0(R5),X'80'              NEGATIVE FORM?             @D04
         BO    DIRBIT20                 YES, BRANCH                @D04
         TM    0(R6),*-*                <<EXECUTED>>               @D04
         EX    R14,*-4                  ADD "NOT "?                @D04
         BO    DIRBIT40                 NO, BRANCH                 @D04
         B     DIRBIT30                 YES, BRANCH                @D04
         SPACE 1                                                   @D04
DIRBIT20 TM    0(R6),*-*                <<EXECUTED>>               @D04
         EX    R14,*-4                  ADD "NOT "?                @D04
         BNO   DIRBIT40                 NO, BRANCH                 @D04
         SPACE 1                                                   @D04
DIRBIT30 MVC   0(4,R15),DIRNOT          ADD "NOT "                 @D04
         LA    R15,4(,R15)              UPDATE LENGTH              @D04
         SPACE 1                                                   @D04
DIRBIT40 L     R14,FULLWORD             ACTUAL LENGTH              @D04
         BCTR  R14,0                    MACHINE LENGTH             @D04
         L     R6,DOUBLE                START OF STRING            @D04
         MVC   0(*-*,R15),0(R6)         <<EXECUTED>>               @D04
         EX    R14,*-6                  MOVE IN STRING             @D04
         LA    R15,1(R14,R15)           NEXT OUTPUT LOCATION       @D04
         BCT   R0,DIRBIT10              DO ALL 4 BITS              @D04
         BR    R4                                                  @D04
         SPACE 3                                                   @D04
DIRBITP1 DC    0H'0',AL2(+08,+19,+25,+34,+38)                      @D04
DIRBITP2 DC    0H'0',AL2(+08,+19,+28,+34,+40)                      @D04
DIRBITP3 DC    0H'0',AL2(-08,+12,+24,-30,+38)                      @D04
DIRBITP4 DC    0H'0',AL2(-08,+14,+20,+28,+39)                      @D04
         SPACE 1                                                   @D04
DIRNOT   DC    C'NOT '                                             @D04
DIR24    DC    C'24; '                                             @D04
DIR31    DC    C'31'                                               @D04
DIR64    DC    C'64'                                               @D04
DIR2020  DC    X'4020206B2021204B'      EDIT MASK                  @D04
DIR4020  DC    X'40202120'              EDIT MASK                  @D04
MSG262H  DC    CL40'LOC NAME     VALUE     DESCRIPTION'            @D04
MSG262U  DC    CL40'--- ----     -----     -----------'            @D04
*IRHDR    DC CL52'1234567890123456789012345678901234567890123456789012'
DIRHDR    DC CL52'PDS2NAMEMEMBER NAME                                 '
          DC CL52'PDS2TTRPTTR OF FIRST BLOCK OF DATA                  '
          DC CL52'PDS2INDCALIAS; N TTRS FOLLOW; NN HALFWORDS OF DATA  '
          DC CL52'PDS2TTRTTTR OF FIRST TEXT BLOCK                     '
          DC CL52'PDS2TTRN(NOT USED FOR THIS MEMBER)                  '
          DC CL52'PDS2TTRNTTR OF SCATTER TRANSLATION TABLE            '
          DC CL52'PDS2TTRNTTR OF OVERLAY NOTE LIST                    '
          DC CL52'PDS2NL  NUMBER OF ENTRIES IN NOTE LIST              '
*                           1    1    2    2    3    3    4    4
*                           0    5    0    5    0    5    0    5
DIRHDR14  DC CL52'PDS2ATR1REENTRANT; REUS; OVERLAY; TEST          '
          DC CL52'        ONLY LOAD; SCATTER; EXEC; 1 TEXT            '
          DC CL52'PDS2ATR2DC; TEXT ORG=0; EP=0; HAS RLDS              '
          DC CL52'        EDIT; TEST; LKED F; REFRESHABLE             '
          DC CL52'PDS2STORTOTAL CONTIGUOUS MAIN STORAGE REQUIRED      '
          DC CL52'PDS2FTBLLENGTH OF FIRST BLOCK OF TEXT               '
          DC CL52'PDS2EPA ENTRY POINT ADDRESS                         '
          DC CL52'PDS2FTB1PROCESSED BY OS/VS LINKAGE EDITOR           '
          DC CL52'        PAGE ALIGNMENT REQUIRED                     '
          DC CL52'        SSI INFORMATION IS PRESENT                  '
          DC CL52'        APF INFORMATION IS VALID                    '
          DC CL52'        PROGRAM OBJECT FORMAT                       '
          DC CL52'        REQUIRES 16M OR MORE OF VIRTUAL STORAGE     '
          DC CL52'PDS2FTB2RMODE ANY; ALIAS AMODE ANY; MAIN AMODE ANY  '
          DC CL52'PDS2FTB3RLD/CONTROL RECORDS AFTER FIRST TEXT BLOCK  '
DIRHDROS  DC CL52'PDS2FTB0ORIGIN OF FIRST BLOCK OF TEXT (FOR O.S. USE)'
DIRHDR21  DC CL52'PDS2SLSZNUMBER OF BYTES IN SCATTER LIST             '
          DC CL52'PDS2TTSZNUMBER OF BYTES IN TRANSLATION TABLE        '
          DC CL52'PDS2ESDTESD CSECT IDENTIFIER OF FIRST TEXT BLOCK    '
          DC CL52'PDS2ESDCESD CSECT IDENTIFIER OF ENTRY POINT BLOCK   '
DIRHDR29  DC CL52'PDS2EPM ENTRY POINT OF MAIN MEMBER                  '
          DC CL52'PDS2MNM MEMBER NAME OF MAIN MEMBER                  '
DIRHDR34  DC CL52'PDSSSIWDSSI INFORMATION                             '
DIRHDR38  DC CL52'PDSAPFCTLENGTH OF PROGRAM AUTHORIZATION CODE        '
          DC CL52'PDSAPFACPROGRAM AUTHORIZATION CODE                  '
DIRHDRLP  DC CL52'PDS2LPOLLENGTH OF LARGE PROGRAM OBJECT SECTION      '
          DC CL52'PDS2VSTRVIRTUAL STORAGE REQUIREMENT FOR THIS MODULE '
          DC CL52'PDS2MEPAMAIN ENTRY POINT OFFSET                     '
          DC CL52'PDS2AEPAALIAS ENTRY POINT OFFSET                    '
DIRHDRPM  DC CL52'MANMODD DATE LAST MODIFIED   -- FORMAT: 0CYYDDDF    '
          DC CL52'MANMODT TIME                 -- FORMAT: HHMM        '
          DC CL52'MANEXPIREXPIRATION BASE DATE -- FORMAT: YYDDDF      '
          DC CL52'MANMODN MEMBER MODIFICATION LEVEL                   '
          DC CL52'MANUSER UPDATING JOBNAME OR TSO USER                '
          DC CL52'MANPROD PRODUCTIONS STATUS INDICATOR -- X''80''     '
          DC CL52'MANREAD DATE LAST READ       -- FORMAT: YYDDDF      '
DIRHDRSP  DC CL52'DIRSPFV MEMBER VERSION NUMBER                       '
          DC CL52'DIRSPFR MEMBER REVISION NUMBER                      '
          DC CL52'DIRSPFFLEXTENDED STATS -- X''20''  SCLM -- X''80''  '
          DC CL52'DIRSPFCSLAST CHANGE TIME -- FORMAT: SS              '
          DC CL52'DIRSPFCRCREATION DATE    -- FORMAT: 0CYYDDDF        '
          DC CL52'DIRSPFCDLAST CHANGE DATE -- FORMAT: 0CYYDDDF        '
          DC CL52'DIRSPFCTLAST CHANGE TIME -- FORMAT: HHMM            '
          DC CL52'DIRSPFSINUMBER OF LINES CURRENTLY                   '
          DC CL52'DIRSPFINNUMBER OF LINES INITIALLY                   '
          DC CL52'DIRSPFMDNUMBER OF MODIFIED LINES                    '
          DC CL52'DIRSPFIDUSERID OF LAST PERSON TO UPDATE             '
          DC CL52'DIRSPXSINUMBER OF LINES CURRENTLY - EXTENDED STATS  '
          DC CL52'DIRSPXINNUMBER OF LINES INITIALLY - EXTENDED STATS  '
          DC CL52'DIRSPXMDNUMBER OF MODIFIED LINES  - EXTENDED STATS  '
**** END OF LINES ADDED BY --------------------------------------- @D04
         TITLE 'P D S  --  PDS MAP                             1/15/85' 08376000
*********************************************************************** 08377000
***      MAP SUBCOMMAND                                             *** 08378000
*********************************************************************** 08379000
*                                                                       08380000
         SPACE 1                                                        08381000
MAP      CSECT                                                          08382000
         USING *,R8                                                     08383000
         LA    R1,L530          ASSUME A NON-PARTITIONED DATA SET       08384000
         TM    DSORG,DS1DSGPO   CORRECT?                                08385000
         BZ    MSGNEW           YES, BRANCH                             08386000
         SPACE 1                                                        08387000
         LA    R1,L701          ASSUME NOT A LOAD LIBRARY               08388000
         TM    FLAGSCC,RECFMU   CORRECT?                                08389000
         BZ    MSGNEW           YES, BRANCH                             08390000
         MVI   ENTRYPT,C'?'     NO ENTRY POINT YET                      08391000
         SPACE 1                                                        08392000
         L     R15,=A(READESD)  FORMAT THE ESD DATA                     08393000
         BALR  R14,R15          ANY ESD DATA?                           08394000
         B     *+8              NO, BRANCH                              08395000
         B     MAP04            YES, BRANCH                             08396000
MAPNOESD TM    FLAGSAA,FMEM#MEM+FINDMSG  GROUP HEADER TO BE WRITTEN?    08397000
         BNO   MAP02                     NO, BRANCH                     08398000
         CLI   #MODLEN,0                 ANY FILTERING?                 08399000
         BH    NEWCMD                    NO, BRANCH                     08400000
         MESSAGE MSGBLANK                                               08401000
         MESSAGE FINDMEMQ                                               08402000
         SPACE 1                                                        08403000
MAP02    LA    R1,MSGTEXT1               MESSAGE IDENTIFIER             08404000
         TSMSG (R1)                                                     08405000
         B     MAPNOMSG                                                 08406000
         SPACE 1                                                        08407000
MAP04    LA    R4,#ESDPTR       ESD TABLE CHAIN POINTER                 08408000
         USING ESDENTRY,R4      BASE FOR TABLE                          08409000
         TM    FLAGSAA,FINDMSG  ANY GROUP HEADER?                       08410000
         BNO   MAPESD           NO, BRANCH                              08411000
         MESSAGE MSGBLANK                                               08412000
         MESSAGE FINDMEMQ                                               08413000
         NI    FLAGSAA,FF-FINDMSG                                       08414000
         SPACE 2                                                        08415000
MAPESD   MVC   MSGTEXT1(136),MSGBL132                                   08416000
         ICM   R4,B'1111',ESDLINK    END OF CHAIN?                      08417000
         BZ    MAPLAST               YES, BRANCH                        08418000
         SPACE 1                                                        08419000
         CLI   #MAPOPT,X'04'         RELINK FORMAT?                @D01
         BE    MAP600                YES, BRANCH                   @D01
         CLI   #MAPOPT,X'05'         RELINK FORMAT?                @D01
         BE    MAP600                YES, BRANCH                   @D01
         CLI   ESDTYPE,CODELR        EXTERNAL REFERENCE?                08420000
         BE    MAPLR                 YES                                08421000
         CLI   ESDTYPE,CODEER        $UNRESOLVED EXTERNAL REF?     @D01
         BE    MAPER                 YES, BRANCH                   @D01
         CLI   ESDTYPE,CODEWK        $UNRESOLVED WEAK EXTERN REF?  @D01
         BE    MAPWK                 YES, BRANCH                   @D01
         SPACE 2                                                        08422000
         CLC   ESDADDR(3),DIREPA     ENTRY POINT?                       08423000
         BNE   *+10                  NO, BRANCH                         08424000
         MVC   ENTRYPT,ESDNAME       SAVE THE ENTRY POINT NAME          08425000
         MVC   MSGTEXT1+4(8),ESDNAME                                    08426000
         UNPK  MSGTEXT1+14(7),ESDADDR(4)                                08427000
         TR    MSGTEXT1+14(6),TRTABLE                                   08428000
         MVI   MSGTEXT1+20,X'40'     CLEAR GARBAGE BYTE                 08429000
         UNPK  MSGTEXT1+22(7),ESDLEN(4)                                 08430000
         TR    MSGTEXT1+22(6),TRTABLE                                   08431000
         MVI   MSGTEXT1+28,X'40'     CLEAR GARBAGE BYTE                 08432000
         SPACE 1                                                        08433000
         TM    DIRATTR,ATTROVLY      OVERLAY PROGRAM?                   08434000
         BZ    MAPNOVLY              NO, BRANCH                         08435000
         SR    R0,R0                                                    08436000
         IC    R0,ESDSEG#                                               08437000
         CVD   R0,DOUBLE                                                08438000
         OI    DOUBLE+7,X'0F'                                           08439000
         UNPK  MSGTEXT1+30(2),DOUBLE+6(2)                               08440000
         B     MAPPRINT                                                 08441000
         SPACE 1                                                        08442000
MAPNOVLY CLI   ESDXAFLG,AMODE24          RMODE 24 AND AMODE 24?         08443000
         BNH   MAPPRINT                  NO, BRANCH                     08444000
         MVC   MSGTEXT1+30(5),=C'RMODE'                                 08445000
         MVC   MSGTEXT1+36(3),=C'ANY'                                   08446000
         TM    ESDXAFLG,RMODEANY         RMODE ANY?                     08447000
         BO    *+10                      YES, BRANCH                    08448000
         MVC   MSGTEXT1+36(3),=C'24 '    RMODE 24                       08449000
         MVC   MSGTEXT1+40(5),=C'AMODE'                                 08450000
         MVC   MSGTEXT1+46(3),=C'24 '                                   08451000
         TM    ESDXAFLG,AMODE31          AMODE 31?                      08452000
         BNO   *+10                      NO, BRANCH                     08453000
         MVC   MSGTEXT1+46(3),=C'31 '    AMODE 31                       08454000
         TM    ESDXAFLG,AMODE64          AMODE 64?                 @D02
         BNO   *+10                      NO, BRANCH                @D02
         MVC   MSGTEXT1+46(3),=C'64 '    AMODE 64                  @D02
         TM    ESDXAFLG,AMODE64+AMODE31  AMODE ANY?                @D02
         BNO   *+10                      NO, BRANCH                     08456000
         MVC   MSGTEXT1+46(3),=C'ANY'    AMODE ANY                      08457000
         B     MAPPRINT                                                 08458000
         SPACE 2                                                   @D01
MAPWK    MVC   INSERT#1(8),ESDNAME       Set name as insert        @D01
         TSMSG L441$1                    Say "(WEAK)"              @D01
         B     MAPESD                    Do next external symbol   @D01
         SPACE 2                                                   @D01
MAPER    MVC   INSERT#1(8),ESDNAME       Set name as insert        @D01
         TSMSG L442$1                    Say "(MISSING)"           @D01
         B     MAPESD                    Do next external symbol   @D01
         SPACE 2                                                        08459000
MAPLR    CLC   ESDADDR(3),DIREPA     ENTRY POINT?                       08460000
         BNE   *+10                  NO, BRANCH                         08461000
         MVC   ENTRYPT,ESDNAME       SAVE THE ENTRY POINT NAME          08462000
         MVC   MSGTEXT1+56(8),ESDNAME                                   08463000
         UNPK  MSGTEXT1+66(7),ESDADDR(4)                                08464000
         TR    MSGTEXT1+66(6),TRTABLE                                   08465000
         MVI   MSGTEXT1+66+6,X'40'   CLEAR GARBAGE BYTE                 08466000
         SPACE 1                                                        08467000
MAPPRINT MESSAGE MSGTEXT1                                               08468000
         B     MAPESD                                                   08469000
         SPACE 2                                                        08470000
MAPLAST  MESSAGE MSGBLANK                                               08471000
MAPNOMSG UNPK  INSERT#1(7),DIREPA(4)                                    08472000
         TR    INSERT#1(6),TRTABLE                                      08473000
         MVC   INSERT#1+6(2),BLANKS                                     08474000
         MVC   INSERT#2(8),ENTRYPT NAME OF THE ENTRY POINT              08475000
         TR    INSERT#2(8),TRLINE     MAKE PRINTABLE                    08476000
         LA    R1,L102$1              ASSUME NONE FOUND                 08477000
         CLI   ENTRYPT,C'?'           ANY FOUND?                        08478000
         BE    *+8                    NO, BRANCH                        08479000
         LA    R1,L103$2              YES, SHOW ENTRY SYMBOL            08480000
         TSMSG (R1)                                                     08481000
         SPACE 1                                                        08482000
         UNPK  INSERT#1(7),DIRSTORE(4)                                  08483000
         TR    INSERT#1(6),TRTABLE                                      08484000
         MVC   INSERT#1+6(2),BLANKS                                     08485000
         ICM   R1,B'0111',DIRSTORE    ACTUAL MODULE LENGTH              08486000
         LA    R1,1023(,R1)           NEXT HIGHER                       08487000
         SRL   R1,10                             1K VALUE               08488000
         CVD   R1,DOUBLE                                                08489000
         MVC   INSERT#2(8),=X'402020202120D2404040'                     08490000
         ED    INSERT#2(6),DOUBLE+5                                     08491000
         TSMSG L104$2                                                   08492000
         SPACE 1                                                        08493000
         TM    DIRFLAG,X'80'      IS MODULE AN ALIAS?                   08494000
         BZ    NEWCMD             NO, NO ALIAS INFORMATION              08495000
         CLI   #MAPOPT,X'01'      SHORT OR ENTRY POINT MAP?             08496000
         BH    NEWCMD             YES, DONE                             08497000
         TM    FLAGSGG,FALINCON   NO ALIAS INFORMATION DEFAULT?         08498000
         BO    NEWCMD             YES, DONE                             08499000
         EJECT                                                          08500000
*        FIND THE CORRESPONDING MAIN MODULE                             08501000
         MVI   STARTTR+2,X'01'    TTR=000001 (START OF DIRECTORY)       08502000
         XC    INSERT#1(8),INSERT#1  NO MAIN(S) FOUND                   08503000
         SPACE 1                                                        08504000
MAPAREAL BAL   R14,READDIR        GET NEXT DIRECTORY MEMBER             08505000
         B     MAPNREAL           LAST MEMBER PROCESSED                 08506000
         SPACE 1                                                        08507000
         TM    MEMFLAG,X'80'      THIS MODULE AN ALIAS?                 08508000
         BO    MAPAREAL           YES, IGNORE                           08509000
         CLC   DIRTTR,MEMTTR      TTR MATCH?                            08510000
         BNE   MAPAREAL           NO, BRANCH                            08511000
         SPACE 1                                                        08512000
         MVC   INSERT#1(8),MEMNAME                                      08513000
         TSMSG L066$1                                                   08514000
         B     MAPAREAL                                                 08515000
         SPACE 2                                                        08516000
MAPNREAL OC    INSERT#1(8),INSERT#1  ANY MAIN(S) FOUND?                 08517000
         BNZ   NEWCMD                YES, QUIT                          08518000
         TSMSG L860                                                     08519000
         TM    FLAGSCC,RECFMU     LOAD MODULE?                          08520000
         BNO   NEWCMD             NO, BRANCH                            08521000
         MVC   INSERT#1(8),DIRREAL                                      08522000
         SPACE 1                                                        08523000
         TM    DIRATTR,ATTRSCTR   SCATTER LOADED?                       08524000
         BNO   *+10               NO, BRANCH                            08525000
         MVC   INSERT#1(8),DIRREALS                                     08526000
         LA    R1,L861$1                                                08527000
         B     MSGNEW                                                   08528000
         SPACE 1                                                        08529000
* GENERATE JCL AND CONTROL CARDS TO LINKAGE EDIT A MODULE          @D03
MAP600   TM    DIRFLAG,X'80'                     ALIAS?            @D03
         BNO   MAP604                            NO, BRANCH        @D03
         MVI   STARTTR+2,X'01'                   READ DIRECTORY    @D03
         SPACE 1                                                   @D03
MAP602   BAL   R14,READDIR                       GET NEXT MEMBER   @D03
         B     MAP604                            END OF MEMBERS    @D03
         SPACE 1                                                   @D03
         CLC   DIRTTR(3),MEMTTR                  THIS TTR?         @D03
         BNE   MAP602                            NO, LOOP          @D03
         TM    MEMTTR+3,X'80'                    ALIAS?            @D03
         BO    MAP602                            YES, LOOP         @D03
         L     R14,DIRPTRS                       START OF ENTRY    @D03
         MVC   DIRNAME(DIREND-DIRNAME),0(R14)    REPLACE THE ENTRY @D03
         SPACE 2                                                   @D03
MAP604   MVC   MSGTEXT1+4(L'MAPLLKED),MAPLLKED   //LKED  EXEC PGM= @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 2                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLPARM),MAPLPARM   //      PARM='... @D03
         LA    R1,MSGTEXT1+4+L'MAPLPARM                            @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTRRENT                  REENTRANT?        @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(5,R1),MAPLATTR+00               YES, ADD ,RENT    @D03
         LA    R1,5(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTRREUS                  REUSABLE?         @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(5,R1),MAPLATTR+05               YES, ADD ,REUS    @D03
         LA    R1,5(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR+1,ATTRREFR                REFRESHABLE?      @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(5,R1),MAPLATTR+10               YES, ADD ,REFR    @D03
         LA    R1,5(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTROVLY                  OVERLAY?          @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(5,R1),MAPLATTR+15               YES, ADD ,OVLY    @D03
         LA    R1,5(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTRTEST                  TEST SYMBOLS?     @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(5,R1),MAPLATTR+20               YES, ADD ,TEST    @D03
         LA    R1,5(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTRSCTR                  SCATTER LOADED?   @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(5,R1),MAPLATTR+25               YES, ADD ,SCTR    @D03
         LA    R1,5(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTRLOAD                  ONLY LOADABLE?    @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(3,R1),MAPLATTR+30               YES, ADD ,OL      @D03
         LA    R1,3(,R1)                                           @D03
         SPACE 1                                                   @D03
         TM    DIRATTR+1,ATTRNE                  NOT EDITABLE?     @D03
         BNO   *+14                              NO, BRANCH        @D03
         MVC   0(3,R1),MAPLATTR+33               YES, ADD ,NE      @D03
         LA    R1,3(,R1)                                           @D03
         SPACE 1                                                   @D03
         MVI   0(R1),C''''                       ADD FINAL QUOTE   @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLSUT1),MAPLSUT1   //SYSUT1          @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLSPRT),MAPLSPRT   //SYSPRINT        @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLSLIB),MAPLSLIB   //SYSLIB          @D03
         MVC   MSGTEXT1+4+L'MAPLSLIB(44),DSNAME  ADD DSNAME        @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLSMOD),MAPLSMOD   //SYSLMOD         @D03
         MVC   MSGTEXT1+4+L'MAPLSMOD(44),DSNAME  ADD DSNAME        @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLSLIN),MAPLSLIN   //SYSLIN          @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4(L'MAPLINCL),MAPLINCL   ADD "INCLUDE SYSL @D03
         MVC   MSGTEXT1+4+L'MAPLINCL(8),DIRNAME  ADD MEMBER NAME   @D03
         LA    R1,MSGTEXT1+4+L'MAPLINCL+8                          @D03
         CLI   0(R1),X'40'                                         @D03
         BNE   *+8                                                 @D03
         BCT   R1,*-8                                              @D03
         MVI   1(R1),C')'                                          @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTROVLY                  OVERLAY MODULE?   @D03
         BO    MAP700                            YES, BRANCH       @D03
         SPACE 3                                                   @D03
         LA    R4,#ESDPTR                                          @D03
         SPACE 1                                                   @D03
MAP610   LA    R1,MSGTEXT1+4+8                   START OF CSECTS   @D03
         LA    R0,MSGTEXT1+4+60                  END OF CSECTS     @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         MVC   MSGTEXT1+4+1(5),MAPLORD           ADD " ORDER"      @D03
         SPACE 1                                                   @D03
MAP620   ICM   R4,B'1111',ESDLINK                NEXT ESD ELEMENT? @D03
         BZ    MAP670                            NO, BRANCH        @D03
         CLI   ESDTYPE,CODESD                    CSECT?            @D03
         BE    MAP630                            YES, BRANCH       @D03
         CLI   ESDTYPE,CODELR                    EXTRN?            @D03
         BE    MAP630                            YES, BRANCH       @D03
         CLC   ESDNAME(8),MAPL$BLK               BLANK COMMON?     @D03
         BE    MAP620                            YES, BRANCH       @D03
         CLI   ESDTYPE,CODECM                    COMMON?           @D03
         BNE   MAP620                            NO, BRANCH        @D03
         B     MAP640                            NO, BRANCH        @D03
         SPACE 1                                                   @D03
MAP630   CLC   ESDADDR(3),DIREPA                 ENTRY POINT?      @D03
         BNE   *+10                              NO, BRANCH        @D03
         MVC   ENTRYPT,ESDNAME                   YES, SAVE THE NAME@D03
         CLI   ESDTYPE,CODELR                    EXTRN?            @D03
         BE    MAP620                            YES, BRANCH       @D03
         SPACE 1                                                   @D03
MAP640   MVC   1(8,R1),ESDNAME                   ADD THE ESDNAME   @D03
         LA    R14,8(,R1)                                          @D03
         SPACE 1                                                   @D03
         CLI   0(R14),X'40'                      BLANK?            @D03
         BNE   *+8                               NO, BRANCH        @D03
         BCT   R14,*-8                                             @D03
         SPACE 1                                                   @D03
         TM    DIRATTR2,DIR2PAGA                 PAGE ALIGN?       @D03
         BNO   MAP660                            NO, BRANCH        @D03
         TM    ESDADDR+1,X'0F'                   POSSIBLE 4K MULT? @D03
         BNZ   MAP660                            NO, BRANCH        @D03
         TM    ESDADDR+2,X'FF'                   4K MULTIPLE?      @D03
         BNZ   MAP660                            NO, BRANCH        @D03
         MVC   1(3,R14),MAPLPAG                  YES, ADD "(P)"    @D03
         LA    R14,3(,R14)                                         @D03
         SPACE 1                                                   @D03
MAP660   MVI   1(R14),C','                       ADD A COMMA       @D03
         LA    R1,1(,R14)                                          @D03
         CR    R1,R0                             END OF CARD?      @D03
         BNH   MAP620                            NO, BRANCH        @D03
         SPACE 2                                                   @D03
         MVI   0(R1),X'40'                       CLEAR LAST COMMA  @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         B     MAP610                                              @D03
         SPACE 2                                                   @D03
MAP670   CLI   MSGTEXT1+4+9,X'40'                ANY TEXT?         @D03
         BE    MAP800                            NO, BRANCH        @D03
         MVI   0(R1),X'40'                       CLEAR LAST COMMA  @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         B     MAP800                                              @D03
         SPACE 2                                                   @D03
MAP700   MVC   STARTTR(3),DIRSTART               ADDRESS OF NOTELI @D03
         L     R15,=A(EXCP)                                        @D03
         BALR  R14,R15                                             @D03
         LA    R1,L751                           NOTELIST NOT FOUND@D03
         LTR   R15,R15                           ANY ERROR?        @D03
         BP    MSGNEW                            YES, BRANCH       @D03
         SPACE 1                                                   @D03
         LR    R2,R0                             START OF RECORD   @D03
         LR    R5,R0                             START OF RECORD   @D03
         LA    R14,24(,R2)                       FIRST SEGMENT     @D03
         LA    R0,4                              INCREMENT         @D03
         LR    R1,R2                                               @D03
         A     R1,LS                             LAST SEGMENT      @D03
         SR    R1,R0                             FOR BXLE          @D03
         SR    R15,R15                                             @D03
         SPACE 1                                                   @D03
MAP710   LA    R15,1(,R15)                       NEXT SEGMENT #    @D03
         STC   R15,3(,R14)                       STORE IN SEGTAB   @D03
         BXLE  R14,R0,MAP710                     DO ALL ENTRIES    @D03
         SPACE 2                                                   @D03
         MVI   0(R14),X'FF'                      MARK END OF TABLE @D03
         MVC   FULLWORD,=F'1'                    REGION = 1        @D03
         LA    R2,24(,R5)                        BEGIN SEGMENT 1   @D03
         LA    R6,8(,R5)                         BEGIN REGION 1    @D03
         SPACE 1                                                   @D03
MAP720   SR    R1,R1                                               @D03
         IC    R1,0(,R6)                         # OF LAST SEGMENT @D03
         LTR   R1,R1                             END OF STRUCTURE? @D03
         BZ    MAP800                            YES, BRANCH       @D03
         SLL   R1,2                              SEGMENT * 4       @D03
         LA    R3,20(R1,R5)                      LAST SEGMENT      @D03
         SPACE 2                                                   @D03
MAP724   LA    R4,#ESDPTR                        START OF ESD      @D03
         SPACE 1                                                   @D03
MAP730   LA    R1,MSGTEXT1+4+8                   START OF CSECTS   @D03
         LA    R0,MSGTEXT1+4+62                  END OF CSECTS     @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         MVC   MSGTEXT1+4+1(6),MAPLINS           ADD " INSERT"     @D03
         SPACE 1                                                   @D03
MAP732   ICM   R4,B'1111',ESDLINK                NEXT ESD ELEMENT? @D03
         BZ    MAP742                            NO, BRANCH        @D03
         CLC   ESDSEG#(1),3(R2)                  THIS SEGMENT?     @D03
         BNE   MAP732                            NO, BRANCH        @D03
         CLI   ESDTYPE,CODESD                    CSECT?            @D03
         BE    MAP734                            YES, BRANCH       @D03
         CLI   ESDTYPE,CODELR                    EXTRN?            @D03
         BE    MAP734                            YES, BRANCH       @D03
         CLC   ESDNAME(8),MAPL$BLK               BLANK COMMON?     @D03
         BE    MAP732                            YES, BRANCH       @D03
         CLI   ESDTYPE,CODECM                    COMMON?           @D03
         BNE   MAP732                            NO, BRANCH        @D03
         B     MAP740                                              @D03
         SPACE 1                                                   @D03
MAP734   CLC   ESDADDR(3),DIREPA                 ENTRY POINT?      @D03
         BNE   *+10                              NO, BRANCH        @D03
         MVC   ENTRYPT,ESDNAME                   YES, SAVE NAME    @D03
         CLI   ESDTYPE,CODELR                    EXTRN?            @D03
         BE    MAP732                            YES, BRANCH       @D03
         SPACE 1                                                   @D03
MAP740   MVC   1(8,R1),ESDNAME                   ADD THE ESDNAME   @D03
         LA    R14,8(,R1)                                          @D03
         SPACE 1                                                   @D03
         CLI   0(R14),X'40'                      BLANK?            @D03
         BNE   *+8                               NO, BRANCH        @D03
         BCT   R14,*-8                                             @D03
         SPACE 1                                                   @D03
         MVI   1(R14),C','                       ADD A COMMA       @D03
         LA    R1,1(,R14)                                          @D03
         CR    R1,R0                             END OF CARD?      @D03
         BNH   MAP732                            NO, BRANCH        @D03
         SPACE 2                                                   @D03
         MVI   0(R1),X'40'                       CLEAR LAST COMMA  @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         B     MAP730                                              @D03
         SPACE 1                                                   @D03
MAP742   CLI   MSGTEXT1+4+9,X'40'                ANY TEXT?         @D03
         BE    MAP750                            NO, BRANCH        @D03
         MVI   0(R1),X'40'                       CLEAR LAST COMMA  @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 2                                                   @D03
MAP750   CLI   4(R2),X'FF'                       END OF SEGTAB?    @D03
         BE    MAP800                            YES, BRANCH       @D03
         CR    R2,R3                             END OF REGION?    @D03
         BE    MAP764                            YES, BRANCH       @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+4+1(7),MAPLOVER          ADD " OVERLAY"    @D03
         MVC   MSGTEXT1+4+1+7+1(6),MAPLREG+1     ADD " REGION"     @D03
         MVC   MSGTEXT1+4+1+7+1+6(1),FULLWORD+3  ADD REGION NUMBER @D03
         OI    MSGTEXT1+4+1+7+1+6,X'F0'          MAKE PRINTABLE    @D03
         SPACE 1                                                   @D03
         SR    R1,R1                                               @D03
         ICM   R1,B'0001',4(R2)                  PREVIOUS SEGMENT? @D03
         BZ    MAP760                            NO, BRANCH        @D03
         MVC   MSGTEXT1+4+1+7+1(6),MAPLOVLY      ADD " OVLY"       @D03
         CVD   R1,DOUBLE                                           @D03
         OI    DOUBLE+7,X'0F'                                      @D03
         UNPK  MSGTEXT1+4+1+7+1+4(3),DOUBLE+6(2) ADD SEGMENT NUM   @D03
MAP760   TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 1                                                   @D03
MAP764   LA    R0,4                                                @D03
         LR    R1,R3                                               @D03
         BXLE  R2,R0,MAP724                      DO EACH SEGMENT   @D03
         SPACE 2                                                   @D03
         LA    R6,2(,R6)                                           @D03
         CLI   0(R6),X'00'                       ANY SEGMENTS?     @D03
         BE    MAP800                            NO, BRANCH        @D03
         L     R1,FULLWORD                                         @D03
         LA    R0,4                                                @D03
         CR    R1,R0                             4TH REGION DONE?  @D03
         BNL   MAP800                            YES, BRANCH       @D03
         LA    R1,1(,R1)                         NEXT REGION       @D03
         ST    R1,FULLWORD                                         @D03
         MVC   MSGTEXT1+4+1(7),MAPLOVER          ADD " OVERLAY"    @D03
         MVC   MSGTEXT1+4+1+7+1(6),MAPLREG+1     ADD "REGION"      @D03
         STC   R1,MSGTEXT1+4+1+7+1+6             ADD REGION NUMBER @D03
         OI    MSGTEXT1+4+1+7+1+6,X'F0'          MAKE PRINTABLE    @D03
         MVC   MSGTEXT1+4+1+7+1+6+1(8),MAPLREG   ADD "(REGION)"    @D03
         MVC   MSGTEXT1+4+1+7+1(6),MAPLREG+1     ADD "REGION"      @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         B     MAP720                                              @D03
         SPACE 2                                                   @D03
MAP800   LA    R2,DIRAPF               POINT TO APF INFORMATION    @D03
         SPACE 1                                                   @D03
         TM    DIRATTR,ATTRSCTR        SCATTER FORMAT?             @D03
         BNO   *+8                     NO, BRANCH                  @D03
         LA    R2,8(,R2)               YES, ADD SCATTER SIZE       @D03
         SPACE 1                                                   @D03
         TM    DIRFLAG,X'80'           ALIAS?                      @D03
         BO    MAP802                  YES, BRANCH                 @D03
         CLI   8(R2),0                 CONVERTED ALIAS ENTRY?      @D03
*        BE    *+8                     NO, BRANCH                  @D03
         B     *+8                     BRANCH                      @D03
MAP802   LA    R2,11(,R2)              ADD ALIAS LENGTH            @D03
MAP803   DS    0H                                                  @D03
         SPACE 1                                                   @D03
         TM    DIRATTR2,DIRAOSLE       VS LINKAGE EDITOR?          @D03
         BNO   MAP804                  NO, BRANCH                  @D03
         SPACE 1                                                   @D03
         TM    DIRATTR2,DIR2SSI        SSI PRESENT?                @D03
         BNO   MAP820                  NO, SKIP SSI PROCESSING     @D03
         SPACE 1                                                   @D03
MAP804   LA    R2,1(,R2)               ROUND UP TO HALFWORD        @D03
         N     R2,=F'-2'                                           @D03
         SPACE 1                                                   @D03
         CLC   ZERO,0(R2)              ZERO?                       @D03
         BE    MAP820                  YES, NO SSI                 @D03
         CLC   =F'-1',0(R2)            FFFFFFFF?                   @D03
         BE    MAP820                  YES, NO SSI                 @D03
         SPACE 1                                                   @D03
         MVC   MSGTEXT1+5(6),MAPLSET   ADD " SETSSI"               @D03
         UNPK  MSGTEXT1+5+6+2(9),0(5,R2)                           @D03
         TR    MSGTEXT1+5+6+2(8),TRTABLE                           @D03
         MVI   MSGTEXT1+5+6+2+8,X'40'                              @D03
         LA    R2,4(,R2)               ADD SSI SIZE                @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 2                                                   @D03
MAP820   TM    DIRATTR2,DIRAOSLE           VS LINKAGE EDITOR?      @D03
         BZ    MAP860                      NO, CAN'T BE AUTHORIZED @D03
         SR    R1,R1                                               @D03
         IC    R1,DIRATTR3                 AMODE BITS              @D03
         TM    DIRFLAG,X'80'               ALIAS?                  @D03
         BNO   *+8                         NO, BRANCH              @D03
         SRL   R1,2                        YES, SHIFT AMODE BITS   @D03
         STC   R1,MODESAVE                 SAVE CURRENT AMODE      @D03
         TM    DIRATTR3,DIRRMANY           RMODE ANY?              @D03
         BNO   *+8                         NO, BRANCH              @D03
         OI    MODESAVE,DIRRMANY           YES, SET RMODE AGAIN    @D03
         SPACE 1                                                   @D03
         TM    MODESAVE,DIRRMANY+DIRAM31+DIRAM64                   @D03
*                                          UNUSUAL RMODE/AMODE?    @D03
         BZ    MAP840                      NO, BRANCH              @D03
         MVC   DOUBLE(8),BLANKS            RMODE/AMODE FILLER      @D03
         MVC   DOUBLE(3),=C'24 '           MOVE IN THE RMODE TEXT  @D03
         TM    MODESAVE,DIRRMANY           RMODE ANY?              @D03
         BZ    *+10                        NO, BRANCH              @D03
         MVC   DOUBLE(3),=C'ANY'           MOVE IN THE RMODE TEXT  @D03
         MVC   DOUBLE+4(3),=C'24 '         MOVE IN THE AMODE TEXT  @D03
         TM    MODESAVE,DIRAM31            AMODE 31?               @D03
         BZ    *+10                        NO, BRANCH              @D03
         MVC   DOUBLE+4(3),=C'31 '         MOVE IN THE AMODE TEXT  @D03
         TM    MODESAVE,DIRAM64            AMODE 64?               @D03
         BNO   *+10                        NO, BRANCH              @D03
         MVC   DOUBLE+4(3),=C'64 '         MOVE IN THE AMODE TEXT  @D03
         TM    MODESAVE,DIRAM64+DIRAM31    AMODE ANY?              @D03
         BNO   *+10                        NO, BRANCH              @D03
         MVC   DOUBLE+4(3),=C'ANY'         MOVE IN THE AMODE TEXT  @D03
         MVC   MSGTEXT1+4(L'MAPLMODE),MAPLMODE                     @D03
         LA    R1,MSGTEXT1+4+L'MAPLMODE                            @D03
         MVC   0(3,R1),DOUBLE              ADD 24/ANY              @D03
         CLI   2(R1),X'40'                 ANY DATA?               @D03
         BE    *+8                         NO, BRANCH              @D03
         LA    R1,1(,R1)                   YES, ADD 1              @D03
         MVC   2(L'MAPLAMO,R1),MAPLAMO     ADD "),AMODE("          @D03
         LA    R1,2+L'MAPLAMO(,R1)                                 @D03
         MVC   0(3,R1),DOUBLE+4            ADD 24/31/64 OR ANY     @D03
         CLI   2(R1),X'40'                 ANY DATA?               @D03
         BE    *+8                         NO, BRANCH              @D03
         LA    R1,1(,R1)                   YES, ADD 1              @D03
         MVI   2(R1),C')'                  ADD FINAL PARENTHESIS   @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 2                                                   @D03
MAP840   TM    DIRATTR2,DIRAPFLG       APF DATA PRESENT AND VALID? @D03
         BNO   MAP860                  NO, BRANCH                  @D03
         SPACE 1                                                   @D03
         LA    R1,L721                 ASSUME APF LENGTH INCORRECT @D03
         CLI   0(R2),1                 APF DATA LENGTH OK?         @D03
         BNE   MAP860                  NO, BRANCH                  @D03
         SPACE 3                                                   @D03
         LA    R1,L021                 ASSUME AUTHORIZED           @D03
         CLI   1(R2),1                 AUTHORIZED?                 @D03
         BL    MAP860                  NO, BRANCH                  @D03
         MVC   MSGTEXT1+4(L'MAPLAUTH),MAPLAUTH                     @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 2                                                   @D03
MAP860   MVC   MSGTEXT1+4(L'MAPLENTR),MAPLENTR                     @D03
         CLI   ENTRYPT,C'?'           ANY ENTRY POINT?             @D03
         BE    *+10                   NO, BRANCH                   @D03
         MVC   MSGTEXT1+4+L'MAPLENTR-8(8),ENTRYPT                  @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         SPACE 2                                                   @D03
         MVC   ENTRYPT(8),DIRNAME      DEFAULT MODULE NAME         @D03
         MVI   STARTTR+2,X'01'         TTR=000001 DIRECTORY START  @D03
         SPACE 2                                                   @D03
MAP880   LA    R2,MSGTEXT1+4+8                   START OF CSECTS   @D03
         LA    R3,MSGTEXT1+4+62                  END OF CSECTS     @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         MVC   MSGTEXT1+4+1(5),MAPLALIA          ADD " ALIAS"      @D03
         SPACE 1                                                   @D03
MAP890   BAL   R14,READDIR        GET NEXT DIRECTORY MEMBER        @D03
         B     MAP910             LAST MEMBER PROCESSED            @D03
         SPACE 1                                                   @D03
         CLC   DIRTTR,MEMTTR      TTR MATCH?                       @D03
         BNE   MAP890             NO, BRANCH                       @D03
         TM    MEMFLAG,X'80'      ALIAS ENTRY FOUND?               @D03
         BO    MAP900             YES, BRANCH                      @D03
         TM    DIRFLAG,X'80'      ALIAS ORIGINALLY?                @D03
         BNO   MAP890             NO, BRANCH                       @D03
         MVC   ENTRYPT(8),MEMNAME SAVE REAL MEMBER NAME            @D03
         B     MAP890                                              @D03
         SPACE 1                                                   @D03
MAP900   MVC   1(8,R2),MEMNAME                   ADD ALIAS NAME    @D03
         LA    R14,8(,R2)                                          @D03
         SPACE 1                                                   @D03
         CLI   0(R14),X'40'                      BLANK?            @D03
         BNE   *+8                               NO, BRANCH        @D03
         BCT   R14,*-8                                             @D03
         SPACE 1                                                   @D03
         MVI   1(R14),C','                       ADD A COMMA       @D03
         LA    R2,1(,R14)                                          @D03
         CR    R2,R3                             END OF CARD?      @D03
         BNH   MAP890                            NO, BRANCH        @D03
         SPACE 2                                                   @D03
         MVI   0(R2),X'40'                       CLEAR LAST COMMA  @D03
         TSMSG MSGTEXT1                                            @D03
         MVC   MSGTEXT1(136),MSGBL132                              @D03
         B     MAP880                                              @D03
         SPACE 2                                                   @D03
MAP910   CLI   MSGTEXT1+4+9,X'40'                ANY TEXT?         @D03
         BE    MAP920                            NO, BRANCH        @D03
         MVI   0(R2),X'40'                       CLEAR LAST COMMA  @D03
         TSMSG MSGTEXT1                                            @D03
         SPACE 1                                                   @D03
MAP920   MVC   MSGTEXT1(136),MSGBL132                              @D03
         MVC   MSGTEXT1+5(L'MAPLNAME),MAPLNAME                     @D03
         MVC   MSGTEXT1+5+8(8),ENTRYPT                             @D03
         LA    R1,MSGTEXT1+5+8+8                                   @D03
         SPACE 1                                                   @D03
         CLI   0(R1),X'40'                       BLANK?            @D03
         BNE   *+8                               NO, BRANCH        @D03
         BCT   R1,*-8                                              @D03
         SPACE 1                                                   @D03
         MVC   1(3,R1),MAPLREP                                     @D03
         SPACE 1                                                   @D03
         TSMSG MSGTEXT1                                            @D03
         B     NEWCMD                                              @D03
MAPLLKED DC    C'//LKED   EXEC  PGM=IEWL,'                         @D03
MAPLPARM DC    C'//       PARM=''NCAL,MAP,LIST,LET'                @D03
MAPLATTR DC    C',RENT,REUS,REFR,OVLY,TEST,SCTR,OL,NE'             @D03
*MAPLSUT1 DC    C'//SYSUT1   DD  UNIT=SYSDA,SPACE=(1024,(200,20))' @D03
MAPLSUT1 DC    C'//SYSUT1   DD  UNIT=&TUNIT,SPACE=(1024,(200,20))' @D03
MAPLSPRT DC    C'//SYSPRINT DD  SYSOUT=A'                          @D03
MAPLSLIB DC    C'//SYSLIB   DD  DISP=SHR,DSN='                     @D03
MAPLSMOD DC    C'//SYSLMOD  DD  DISP=SHR,DSN='                     @D03
MAPLSLIN DC    C'//SYSLIN   DD  *'                                 @D03
MAPLINCL DC    C' INCLUDE SYSLIB('                                 @D03
MAPLAUTH DC    C' SETCODE AC(1)'                                   @D03
MAPLENTR DC    C' ENTRY   ????????'                                @D03
MAPLMODE DC    C' MODE    RMODE('                                  @D03
MAPLAMO  DC    C'),AMODE('                                         @D03
MAPLNAME DC    C'NAME'                                             @D03
MAPLSET  DC    C'SETSSI'                                           @D03
MAPLALIA DC    C'ALIAS'                                            @D03
MAPLORD  DC    C'ORDER'                                            @D03
MAPLPAG  DC    C'(P)'                                              @D03
MAPLREP  DC    C'(R)'                                              @D03
MAPLREG  DC    C'(REGION)'                                         @D03
MAPLOVER DC    C'OVERLAY'                                          @D03
MAPLOVLY DC    C'OVLY'                                             @D03
MAPLINS  DC    C'INSERT'                                           @D03
         DROP  R4                                                  @D03
         SPACE 3                                                   @D03
         TITLE 'P D S  --  PDS MAP ESD SCAN SUBROUTINE         1/15/85' 08531000
*                                                                       08532000
*        ESD SCAN SUBROUTINE                                            08533000
*                                                                       08534000
         SPACE 2                                                        08535000
READESD  STM   R14,R12,ESDIDRSV   SAVE REGISTERS FOR RETURN             08536000
         LR    R8,R15             ENTRY POINT ADDRESS                   08537000
         USING READESD,R8         SUBROUTINE BASE REGISTER              08538000
         LA    R2,#ESDPTR         ROOT OF ESD CHAIN                     08539000
         MVC   STARTTR(3),DIRTTR  FIRST TTR                             08540000
         SPACE 1                                                        08541000
ESDEXCP  L     R15,=A(EXCP)                                             08542000
         BALR  R14,R15                                                  08543000
         B     *+4(R15)           PROCESS RETURN CODE                   08544000
         B     ESDEXCP1             00 - GOOD READ                      08545000
         B     ESDLAST              04 - END OF MEMBER                  08546000
         B     ESDLAST              08 - END OF DATA SET                08547000
         B     NEWCMD               12 - I/O ERROR                      08548000
         SPACE 1                                                        08549000
ESDEXCP1 LR    R3,R0              START OF RECORD                       08550000
         CLI   0(R3),X'40'        TEST SYM RECORD?                      08551000
         BE    ESDEXCP            YES, SKIP RECORD                      08552000
         CLI   0(R3),X'20'        CESD RECORD?                          08553000
         BNE   ESDLAST            NO, BRANCH                            08554000
         SPACE 1                                                        08555000
         LH    R6,4(,R3)          RELATIVE # OF 1ST ESD ID              08556000
         LH    R5,6(,R3)          LENGTH OF DATA IN BUFFER              08557000
         LA    R3,8(,R3)          START OF ESD DATA                     08558000
         AR    R5,R3                                                    08559000
         LA    R4,16              LENGTH OF ONE ENTRY                   08560000
         SR    R5,R4                                                    08561000
         SPACE 2                                                        08562000
         USING ESDNAME,R3                                               08563000
ESDSCAN  IC    R0,ESDTYPE                                               08564000
         LA    R1,CODESEG         CHECK FOR SEGTAB/ENTAB                08565000
         TM    DIRATTR,ATTROVLY   OVERLAY MODULE?                       08566000
         BO    *+8                YES, BRANCH                           08567000
         NI    ESDXAFLG,RMODEANY+AMODE24+AMODE31                        08568000
         NI    ESDTYPE,X'0F'                                            08569000
         NR    R0,R1                                                    08570000
         CLI   #MAPOPT,X'03'      ENTRY POINT ONLY?                     08571000
         BE    ESDSCAN2           YES, BRANCH                           08572000
         CLC   ##SUBCOM(8),$ALI   ALIAS SEARCH REQUEST?                 08573000
         BNE   ESDMAP             NO, BRANCH                            08574000
ESDSCAN2 CLI   ESDTYPE,CODESD     VALID EXTERNAL SYMBOL?                08575000
         BE    ESDCHK             YES, BRANCH                           08576000
         CLI   ESDTYPE,CODELR     ANOTHER VALID ENTRY                   08577000
         BNE   NEXTESD            NO, GET THE NEXT ESD                  08578000
         SPACE 1                                                        08579000
ESDCHK   TM    DIRATTR,ATTROVLY   OVERLAY ATTRIBUTE?                    08580000
         BNO   ESDCHK1            NO, BRANCH                            08581000
         CLI   ESDSEG#,1          SYMBOL IN ROOT SEGMENT?               08582000
         BNE   NEXTESD            NO, IGNORE                            08583000
ESDCHK1  CLC   ESDADDR(3),DIREPA  THIS ENTRY POINT ADDRESS?             08584000
         BNE   ESDCHK2            NO, BRANCH                            08585000
         MVC   ENTRYPT,ESDNAME    YES, ENTRY POINT NAME IF NO ESD MATCH 08586000
         CLI   #MAPOPT,X'03'      ENTRY POINT MAP ONLY?                 08587000
         BE    ESDUSE3            YES, BRANCH                           08588000
ESDCHK2  CLC   ESDNAME,DIRNAME    THIS NAME?                            08589000
         BNE   NEXTESD            NO, BRANCH                            08590000
         IC    R0,ESDXAFLG        GET MVS/XA ESD FLAGS                  08591000
         SR    R1,R1                                                    08592000
         ICM   R1,B'0111',ESDADDR GET SYMBOL OFFSET                     08593000
         ST    R6,ESDIDRSV+4      RETURN ESDID IN REG 15                08594000
         STM   R0,R1,ESDIDRSV+4+4 RETURN ESD FLAGS, OFFSET IN REGS 0,1  08595000
         MVC   ENTRYPT,ESDNAME    USE THIS ESDNAME FOR THE ENTRY POINT  08596000
         B     ESDOUT             FOUND THE SYMBOL                      08597000
         SPACE 1                                                        08598000
ESDMAP   CR    R0,R1              THIS SEGTAB/ENTAB ENTRY?              08599000
         BE    ESDUSE1            YES, BRANCH                           08600000
         CLI   ESDTYPE,CODESD     SD ENTRY?                             08601000
         BE    ESDUSE2            YES, BRANCH                           08602000
         CLI   ESDTYPE,CODECM     COMMON BLOCK CODE?                    08603000
         BE    ESDUSE2            YES, BRANCH                           08604000
         CLC   ##SUBCOM(8),$MAP   MAP SUBCOMMAND?                  @D01
         BNE   ESDMAP4            NO, BRANCH                       @D01
         CLI   ESDTYPE,CODEER     $UNRESOLVED EXTERNAL REFERENCE?  @D01
         BE    ESDUSE2            YES, BRANCH                      @D01
         CLI   #MAPOPT,X'02'      SHORT MAP?                       @D01
         BE    ESDMAP4            YES, BRANCH                      @D01
         CLI   ESDTYPE,CODEWK     $UNRESOLVED WEAK EXTRN?          @D01
         BE    ESDUSE2            YES, BRANCH                      @D01
ESDMAP4  CLI   ESDTYPE,CODELR     LR ENTRY?                        @D01 08605000
         BNE   ESDMAPPC           NO, BRANCH                            08606000
         CLI   #MAPOPT,X'02'      SHORT MAP?                            08607000
         BL    ESDUSE2            NO, BRANCH                            08608000
         CLC   ESDADDR(3),DIREPA  THIS ENTRY POINT?                     08609000
         BE    ESDUSE2            NO, BRANCH                            08610000
ESDMAPPC CLI   ESDTYPE,CODEPC     PC ENTRY?                             08611000
         BNE   NEXTESD            NO, BRANCH                            08612000
         MVC   ESDNAME,=CL8'$PRIVATE'  PRIVATE CODE                     08613000
         B     ESDUSE2                                                  08614000
         SPACE 1                                                        08615000
ESDUSE1  STC   R0,ESDTYPE                          RESTORE OVERLAY TYPE 08616000
         MVC   ESDNAME(8),=CL8'$SEGTAB'            ASSUME SEGMENT TABLE 08617000
         OC    ESDADDR(3),ESDADDR                  CORRECT?             08618000
         BZ    ESDUSE2                             YES, BRANCH          08619000
         MVC   ESDNAME(8),=CL8'$ENTAB'             NO, ENTRY TABLE      08620000
ESDUSE2  SR    R1,R1                                                    08621000
         CLC   ##SUBCOM(8),$LIS                    LIST SUBCOMMAND?     08622000
         BE    ESDUSE3                             YES, BRANCH          08623000
         ICM   R1,B'0001',#MODLEN                  ANY MODULE FILTER?   08624000
         BZ    ESDUSE3                             NO, BRANCH           08625000
         BCTR  R1,0                                MACHINE LENGTH       08626000
         CLC   ESDNAME(*-*),#MODTXT                <<EXECUTED>>         08627000
         EX    R1,*-6                              THIS PARTIAL NAME?   08628000
         BNE   NEXTESD                             NO, BRANCH           08629000
ESDUSE3  BAL   R14,GETESD                                               08630000
         ST    R1,ESDLINK-ESDENTRY(R2)             SAVE LINK POINTER    08631000
         STH   R6,ESDID-ESDENTRY(R1)               SAVE ESD ID          08632000
         MVC   ESDNAME-ESDENTRY(LENESD1,R1),0(R3)  SAVE ESD ENTRY       08633000
         LR    R2,R1                               CHAIN TO NEXT ONE    08634000
NEXTESD  LA    R6,1(R6)                                                 08635000
         BXLE  R3,R4,ESDSCAN                                            08636000
         B     ESDEXCP            GET NEXT ESD RECORD                   08637000
         DROP  R3                                                       08638000
         EJECT                                                          08639000
         USING ESDENTRY,R2                                              08640000
ESDLAST  MVC   MSGTEXT1(3),L740                                         08641000
         L     R14,ESDIDRSV                                             08642000
         LA    R2,#ESDPTR                                               08643000
         OC    #ESDPTR,#ESDPTR    ANY ESD DATA AVAILABLE?               08644000
         BNZ   ESDSORT            YES, BRANCH                           08645000
         CLI   #MODLEN,0          ANY ESD FILTERING?                    08646000
         BH    ESDEXIT            YES, BRANCH                           08647000
         MVC   MSGTEXT1(3),L703                                         08648000
         B     ESDEXIT                                                  08649000
         SPACE 1                                                        08650000
ESDSORT  L     R2,ESDLINK                                               08651000
         ICM   R1,B'1111',ESDLINK END OF ESD ENTRIES?                   08652000
         BZ    ESDOUT             YES, BRANCH                           08653000
         SPACE 1                                                        08654000
ESDSORT2 TM    DIRATTR,ATTROVLY             OVERLAY ATTRIBUTE?          08655000
         BNO   ESDNOSEG                                                 08656000
         CLC   ESDSEG#,ESDSEG#-ESDENTRY(R1) CHECK ENTRY SEGMENT         08657000
         BL    ESDSORT3                                                 08658000
         BH    ESDSWAP                                                  08659000
         SPACE 1                                                        08660000
ESDNOSEG CLC   ESDADDR,ESDADDR-ESDENTRY(R1)                             08661000
         BL    ESDSORT3                                                 08662000
         BH    ESDSWAP                                                  08663000
         CLC   ESDTYPE,ESDTYPE-ESDENTRY(R1)                             08664000
         BL    ESDSORT3                                                 08665000
         BH    ESDSWAP                                                  08666000
         CLC   ESDNAME,ESDNAME-ESDENTRY(R1)                             08667000
         BNH   ESDSORT3                                                 08668000
         SPACE 1                                                        08669000
ESDSWAP  XC    ESDNAME(LENESD2),ESDNAME-ESDENTRY(R1)                    08670000
         XC    ESDNAME-ESDENTRY(LENESD2,R1),ESDNAME                     08671000
         XC    ESDNAME(LENESD2),ESDNAME-ESDENTRY(R1)                    08672000
         SPACE 1                                                        08673000
ESDSORT3 ICM   R1,B'1111',ESDLINK-ESDENTRY(R1)                          08674000
         BNZ   ESDSORT2                                                 08675000
         B     ESDSORT                                                  08676000
         DROP  R2                                                       08677000
         SPACE 2                                                        08678000
GETESD   MVI   SUBPOOLT,21                                              08679000
         LA    R0,LENESD                                                08680000
         ICM   R0,B'1000',SUBPOOLT   SUBPOOL 21                         08681000
         GETMAIN R,LV=(0)                                               08682000
         XC    0(LENESD,R1),0(R1)                                       08683000
         BR    R14                                                      08684000
         SPACE 1                                                        08685000
ESDOUT   L     R14,ESDIDRSV                                             08686000
         LA    R14,4(,R14)         ADJUST EXIT ADDRESS                  08687000
ESDEXIT  LM    R15,R12,ESDIDRSV+4                                       08688000
         BR    R14                 EXIT                                 08689000
MAPL$BLK DC    CL8'$BLKCOM'                                        @D01
         TITLE 'P D S  --  PDS OPTIONS                         1/15/85' 08690000
*********************************************************************** 08691000
***      OPTIONS SUBCOMMAND                                         *** 08692000
*********************************************************************** 08693000
*                                                                       08694000
         SPACE 2                                                        08695000
OPTIONS  CSECT                                                          08696000
         USING *,R8                                                     08697000
ONIX     LTR   R2,R2                  RETURN=0?                         08698000
         BZ    OPT200                 YES, BRANCH                       08699000
         TSMSG L071                                                     08700000
         SPACE 1                                                        08701000
         LA    R3,$TBL-PTW            POINT TO FIRST TABLE ENTRY -WIDTH 08702000
         LA    R4,ONIX                START OF THIS CSECT               08703000
         SPACE 1                                                        08704000
OPT120   LA    R3,PTW(,R3)            NEXT TABLE ENTRY                  08705000
         CLI   0(R3),X'FF'            END OF TABLE?                     08706000
         BE    OPT300                 YES, EXIT                         08707000
         CLI   0(R3),X'40'            DISABLED ENTRY?                   08708000
         BE    OPT120                 YES, BRANCH                       08709000
         SR    R1,R1                                                    08710000
         ICM   R1,B'0011',28(R3)      ANY OPTION ENTRY?                 08711000
         BZ    OPT120                 NO, BRANCH                        08712000
         TM    12(R3),@S              DEFINED FOR SEQUENTIAL DATA SET?  08713000
         BO    OPT140                 YES, BRANCH                       08714000
         TM    DSORG,DS1DSGPO         DSORG=PO?                         08715000
         BNO   OPT120                 NO, BRANCH                        08716000
         SPACE 1                                                        08717000
OPT140   AR    R1,R4                  ADDRESS OF OPTION DATA            08718000
         MVC   MSGTEXT1(80),0(R1)     OPTION LINE                       08719000
         MVC   MSGTEXT1+4(8),0(R3)    CHANGE TO SUBCOMMAND NAME USED    08720000
         MESSAGE MSGTEXT1             OUTPUT THIS MESSAGE               08721000
         B     OPT120                                                   08722000
         SPACE 3                                                        08723000
OPT200   L     R2,0(,R15)             START OF SUBCOMMAND               08724000
         MVC   INSERT#1(8),0(R2)      NO, BRANCH                        08725000
         LA    R3,1(,R3)              ACTUAL LENGTH OF SUBCOMMAND       08726000
         STC   R3,MTHIGHL             SAVE LENGTH                       08727000
         TSMSG L771$1                 INVALID COMMAND                   08728000
         TM    FLAGSEE,FBKGRND        BACKGROUND EXECUTION?             08729000
         BO    *+8                    YES, BRANCH                       08730000
         NI    FLAGSBB,FF-FONESHOT    NO, ERROR -- DO NOT TERMINATE     08731000
         LA    R1,80                  ASSUME AN ACTIVE MODE             08732000
         AIF ('&CISP' EQ 'NO SPF').MA00620                         @D01
         TM    SPFLAG0,SPFDON         ISPMODE ACTIVE?                   08733000
         BO    OPT202                 YES, BRANCH                       08734000
.MA00620 ANOP  ,                                                   @D01
         TM    CONTOPTN,1             ANY LOG RECORDING?                08735000
         BO    OPT202                 YES, BRANCH                       08736000
         GTSIZE
         CH    R1,=H'120'             120 OR LESS BYTES?                08738000
         BL    *+8                    YES, BRANCH                       08739000
         LH    R1,=H'120'             NO, USE 120 BYTES                 08740000
OPT202   MVC   MSGTEXT1(136),MSGBL132                                   08741000
         MVC   MSGTEXT1+4(12),=C'SUBCOMMANDS:'                          08742000
         LA    R3,$TBL-PTW            POINT TO FIRST TABLE ENTRY -WIDTH 08743000
         LA    R4,MSGTEXT1+4(R1)      END OF LINE ADDRESS               08744000
         LA    R5,MSGTEXT1+4+13       START OF LINE                     08745000
         SPACE 1                                                        08746000
OPT220   LA    R3,PTW(,R3)            NEXT TABLE ENTRY                  08747000
         CLI   0(R3),X'FF'            END OF TABLE?                     08748000
         BE    OPT280                 YES, EXIT                         08749000
         CLI   0(R3),X'40'            DISABLED ENTRY?                   08750000
         BE    OPT220                 YES, BRANCH                       08751000
         CLC   28(2,R3),ZERO          ANY OPTION ENTRY?                 08752000
         BZ    OPT220                 NO, BRANCH                        08753000
         TM    12(R3),@S              DEFINED FOR SEQUENTIAL DATA SET?  08754000
         BO    OPT240                 YES, BRANCH                       08755000
         TM    DSORG,DS1DSGPO         DSORG=PO?                         08756000
         BNO   OPT220                 NO, BRANCH                        08757000
         SPACE 1                                                        08758000
OPT240   LA    R1,9(,R5)              POTENTIAL ENTRY POSITION          08759000
         CR    R1,R4                  LINE FULL?                        08760000
         BL    OPT260                 NO, CONTINUE                      08761000
         MESSAGE MSGTEXT1             OUTPUT THIS PART OF THE MESSAGE   08762000
         LA    R5,MSGTEXT1+4+13       START OF LINE                     08763000
         MVC   MSGTEXT1(136),MSGBL132                                   08764000
         SPACE 1                                                        08765000
OPT260   MVC   0(8,R5),0(R3)          ADD THE SUBCOMMAND NAME           08766000
         LA    R5,9(,R5)              POSITION FOR NEXT ENTRY           08767000
         B     OPT220                                                   08768000
         SPACE 1                                                        08769000
OPT280   MESSAGE MSGTEXT1                                               08770000
         SPACE 2                                                        08771000
OPT300   MESSAGE MSGBLANK                                               08772000
         B     NEWCMD                                                   08773000
         TITLE 'P D S  --  PDS OPTIONS OUTPUT MESSAGES         1/15/85' 08774000
         PRINT NOGEN                                                    08775000
OATT     MSG   'ATTRIB   - LIST ATTRIBUTES OF A MEMBER'                 08776000
OALI     MSG   'ALIAS    - ASSIGN AN ALIAS TO A MEMBER'                 08777000
OBRO     MSG   'BROWSE   - BROWSE USING SPF'                            08778000
OCHA     MSG   'CHANGE   - SELECT A NEW DATA SET'                       08779000
OCAR     MSG   'COMPARE  - COMPARE TWO MEMBERS FROM THE DATA SET'       08780000
OCMX     MSG   'COMPRESS - COMPRESS IN PLACE OF THE DATA SET'           08781000
OCON     MSG   'CONTROL  - SET PROGRAM CONTROLS'                        08782000
ODIS     MSG   'DISPLAY  - DISPLAY DIRECTORY MEMBER NAMES'              08783000
ODIR     MSG   'DIRENTRY - DUMP A DIRECTORY ENTRY'                      08784000
ODEL     MSG   'DELETE   - DELETE A MEMBER'                             08785000
ODSN     MSG   'DSNAME   - DISPLAY THE CURRENT ALLOCATION'              08786000
ODSP     MSG   'DSPRINT  - PRINT A HARDCOPY WITH DSPRINT'               08787000
OEDI     MSG   'EDIT     - EDIT USING SPF'                              08788000
OEND     MSG   'END      - STOP THE PROGRAM'                            08789000
OEXE     MSG   'EXEC     - EXECUTE PDS SUBCOMMANDS FROM A CLIST'        08790000
OFIN     MSG   'FIND     - LIST LINES CONTAINING A STRING'              08791000
OFIX     MSG   'FIXPDS   - MODIFY DATA SET ATTRIBUTES'                  08792000
OFSE     MSG   'FSE      - EDIT USING FSE'                              08793000
OHEL     MSG   'HELP     - DISPLAY PDS SUBCOMMAND HELP'                 08794000
OHIS     MSG   'HISTORY  - LIST HISTORY OF A LOAD MODULE'               08795000
OIFX     MSG   'IF       - CONDITIONALLY EXECUTE A PDS SUBCOMMAND'      08796000
OISP     MSG   'ISPF     - INVOKE ISPF PRIMARY PANEL'                   08797000
OISM     MSG   'ISPMODE  - SET ISPF DIALOG DISPLAY MODE'       SS JUL84 08798000
OLIS     MSG   'LIST     - DISPLAY A MEMBER'                            08799000
OMAP     MSG   'MAP      - MAP A LOAD MODULE'                           08800000
OMEM     MSG   'MEMBERS  - DISPLAY A MEMBER GROUP'                      08801000
OMML     MSG   'MEMLIST  - DISPLAY A MEMBER GROUP IN ISP TABLE'         08802000
OOPT     MSG   'OPTIONS  - DISPLAY THIS LIST OF SUBCOMMANDS'            08803000
OOUT     MSG   'OUTCOPY  - OUTPUT IEBCOPY MEMBER SELECT STATEMENTS'     08804000
OPAT     MSG   'PATTERN  - DISPLAY DIRECTORY NAMES MATCHING A PATTERN'  08805000
OPRI     MSG   'PRINTOFF - PRINT A HARDCOPY'                            08806000
OREC     MSG   'RECALL   - DISPLAY THE PREVIOUS SUBCOMMAND'             08807000
OREN     MSG   'RENAME   - RENAME A MEMBER'                             08808000
ORES     MSG   'RESTORE  - RESURRECT A PREVIOUSLY DELETED MEMBER'       08809000
OREV     MSG   'REVIEW   - BROWSE DATA'                                 08810000
OSUB     MSG   'SUBMIT   - SUBMIT JCL'                                  08811000
OTSO     MSG   'TSO      - INVOKE A TSO COMMAND'                        08812000
OTSE     MSG   'TSOEDIT  - EDIT USING TSO EDIT'                         08813000
OTSL     MSG   'TSOLIST  - LIST DATA WITH TSO LIST'                     08814000
OUSA     MSG   'USAGE    - LIST DATA SET STATISTICS'                    08815000
*OUT1    MSG   'UT1      - UTILITY PANEL #1 (NON-MEMBER)'      SS NOV84 08816000
*OUT2    MSG   'UT2      - UTILITY PANEL #2 (WITH MEMBERS)'    SS NOV84 08817000
OVER     MSG   'VERIFY   - VALIDITY CHECK THE DATA SET'                 08818000
         DC    X'FF'                                                    08819000
         PRINT GEN                                                      08820000
         TITLE 'P D S  --  PDS OUTCOPY                         1/15/85' 08821000
*********************************************************************** 08822000
***      OUT SUBCOMMAND        ADDED BY BRUCE LELAND -- JULY, 1983  *** 08823000
*********************************************************************** 08824000
*                                                                       08825000
         SPACE 1                                                        08826000
OUTCOPY  CSECT                                                          08827000
         USING *,R8                                                     08828000
         LA    R1,L530                       ASSUME NON-PARTITIONED     08829000
         TM    DSORG,DS1DSGPO                CORRECT?                   08830000
         BZ    MSGNEW                        YES, BRANCH                08831000
         TM    #OUT,1                        CLOSE FORCED?              08832000
         BO    OUT84                         YES, BRANCH                08833000
         TM    DCBOFLGS-IHADCB+QAMDCB,X'10'  OUTPUT ALREADY OPEN?       08834000
         BO    OUT10                         YES, BRANCH                08835000
         AIF ('&CISP' EQ 'NO SPF').NSPF250                              08836000
         TM    FLAGSEE,FBKGRND               BACKGROUND MODE?           08837000
         BO    OUT04                         YES, BRANCH                08838000
         TM    FLAGSFF,FSPFOPT6+FSPFERR+FSPFCALL+FSPFDIAL  CHANGE SPF?  08839000
         BNZ   OUT04                                       NO, BRANCH   08840000
         BAL   R2,SPFRECUR                   INVOKE PDS AS A DIALOG     08841000
         SPACE 1                                                        08842000
.NSPF250 ANOP                                                           08843000
OUT04    MVC   QAMDCB(LQSAMDCB),QSAMDCB      CONSTRUCT A DCB            08844000
         MVI   OPENLIST,X'80'                END OF LIST                08845000
         OPEN  (QAMDCB,(OUTPUT)),MF=(E,OPENLIST)                        08846000
         MVC   INSERT#1(8),OTEXTOUT          OUTCOPY                    08847000
         LA    R1,L780$1                     ASSUME OPEN ERROR          08848000
         TM    DCBOFLGS-IHADCB+QAMDCB,X'10'  OUTPUT OPEN?               08849000
         BNO   MSGNEWXX                      NO, ERROR                  08850000
         CLI   #OUT,1                        CORRECT DCB ATTRIBUTES?    08851000
         BNE   OUT84                         NO, BRANCH                 08852000
         SPACE 2                                                        08853000
OUT10    MVI   #OUT,X'40'                                               08854000
***TEST  TM    FLAGSGG,FSAVEOP               SAVE TEXT?                 08855000
***TEST  BNZ   OUT12                         NO, BRANCH                 08856000
         LA    R15,FIRST4K                                              08857000
         LA    R15,SAVEOUT-FIRST4K(,R15)     SAVE TEXT AREA             08858000
         CLI   #OUTOPTN,1                    ANY TEXT?                  08859000
         BNE   *+10                          NO, BRANCH                 08860000
         MVC   0(40,R15),MSGLINE             YES, SAVE THE DEFAULT TEXT 08861000
         CLI   #OUTOPTN,2                    NOTEXT?                    08862000
         BNE   *+8                           NO, BRANCH                 08863000
         MVI   0(R15),0                      YES, RESET DEFAULT TEXT    08864000
         MVC   MSGLINE(40),0(R15)            SET THE TEXT OPERAND       08865000
         B     OUT14                                                    08866000
         SPACE 1                                                        08867000
OUT12    CLI   #OUTOPTN,1                    ANY TEXT?                  08868000
         BE    OUT14                         YES, BRANCH                08869000
         MVI   MSGLINE,0                     NO, RESET THE TEXT         08870000
         SPACE 1                                                        08871000
OUT14    TM    FLAGSEE,FOUTASS               ALIASES ALSO DESIRED?      08872000
         BNO   *+8                           NO, BRANCH                 08873000
         MVI   STARTTR+2,X'01'               YES, SET THE START TTR     08874000
         L     R2,RECOVER                    PREVIOUS RECOVERY ADDRESS  08875000
         LA    R1,OUT80                      RESUME ADDRESS             08876000
         ST    R1,RECOVER                    IN-LINE RECOVERY           08877000
         STM   R2,R8,#OUTREGS                SAVE REGISTERS             08878000
         TM    FLAGSFF,FCHANGE               CHANGED DATA SET?          08879000
         BNZ   OUT50                         NO, BRANCH                 08880000
         OI    FLAGSFF,FCHANGE               YES, GOT A COPY STATEMENT  08881000
         MVC   #OUT,OUTCOPYS                 " COPY OUTPUT=OUTDD,IN..." 08882000
         SR    R1,R1                         MACHINE LENGTH             08883000
         LA    R3,DSNAME-2                                              08884000
         AH    R3,DSNLEN                                                08885000
         LA    R0,8                          MAX LOOPS +1               08886000
         CH    R0,DSNLEN                     MIN (8, NAME LENGTH)       08887000
         BH    *+8                                                      08888000
         LH    R0,DSNLEN                                                08889000
OUT30    S     R0,=F'1'                      ONE CHARACTER?             08890000
         BZ    OUT40                         YES, BRANCH                08891000
         CLI   0(R3),C'.'                    PERIOD?                    08892000
         BE    OUT40                         YES, BRANCH                08893000
         LA    R1,1(,R1)                     MACHINE LENGTH             08894000
         BCT   R3,OUT30                      BACK UP ONE BYTE           08895000
         SPACE 1                                                        08896000
OUT40    MVC   #OUT+33(*-*),1(R3)            <<EXECUTED>>               08897000
         EX    R1,*-6                        MOVE LOW-LEVEL QUALIFIER   08898000
         PUT   QAMDCB,#OUT                   OUTPUT THIS LINE           08899000
         LA    R3,OUTMEMBS                   START OF DUPLICATE LIST    08900000
         TM    FLAGSFF,FNOECHO               OUTPUT TO THE TERMINAL?    08901000
         BNZ   OUT42                         NO, BRANCH                 08902000
         MVC   MSGTEXT1+4(80),#OUT           OUTPUT LINE                08903000
         LA    R0,84                                                    08904000
         SLL   R0,16                                                    08905000
         ST    R0,MSGTEXT1                                              08906000
         MESSAGE MSGTEXT1                                               08907000
         SPACE 1                                                        08908000
OUT42    ICM   R3,B'0111',1(R3)              NEXT DUPLICATE STRUCTURE   08909000
         BZ    OUT50                         END, BRANCH                08910000
         MVI   6(R3),0                       CLEAR THE                  08911000
         MVI   7(R3),1                                CURRENT COUNT     08912000
         B     OUT42                         LOOP FOR ALL STRUCTURES    08913000
         SPACE 1                                                        08914000
OUT50    LA    R4,OUTMEMBS                   ROOT OF DUP STRUCTURES     08915000
OUT54    LR    R3,R4                                                    08916000
         ICM   R4,B'0111',1(R4)              NEXT LIST ENTRY?           08917000
         BNZ   OUT60                         YES, BRANCH                08918000
         LA    R5,256                        256 -1 MEMBERS             08919000
         LR    R0,R5                                                    08920000
         SLL   R0,3                          ELEMENT WIDTH IS 8         08921000
         MVI   OUTMEMBS,22                   SUBPOOL IS 22              08922000
         ICM   R0,B'1000',OUTMEMBS           GET THE SUBPOOL            08923000
         GETMAIN R,LV=(0)                                               08924000
         LR    R4,R1                                                    08925000
         STCM  R4,B'0111',1(R3)              CHAIN TO LAST STUCTURE     08926000
         XC    0(8,R4),0(R4)                 NULL LINK POINTERS         08927000
         STH   R5,4(,R4)                     MAXIMUM ELEMENTS/STRUCTURE 08928000
         MVI   7(R4),1                       ONE ITEM CURRENTLY         08929000
         B     OUT70                                                    08930000
         SPACE 2                                                        08931000
OUT60    LH    R5,6(R4)                      NUMBER OF ELEMENTS         08932000
         LR    R1,R4                                                    08933000
OUT64    S     R5,=F'1'                      ANY MORE ITEMS?            08934000
         BZ    OUT70                         NO, BRANCH                 08935000
         LA    R1,8(,R1)                     NEXT ELEMENT               08936000
         CLC   0(8,R1),DIRNAME               THIS ELEMENT?              08937000
         BNE   OUT64                         NO, BRANCH                 08938000
         B     OUT74                         YES, IGNORE DUPLICATE      08939000
         SPACE 1                                                        08940000
OUT70    CLC   6(2,R4),4(R4)                 CURRENT:MAXIMUM            08941000
         BE    OUT54                         EQUAL - GET NEXT STRUCTURE 08942000
         MVC   8(8,R1),DIRNAME               ADD THIS ITEM              08943000
         LH    R5,6(R4)                      ADD                        08944000
         LA    R5,1(,R5)                        1 TO                    08945000
         STH   R5,6(R4)                             NUMBER OF ELEMENTS  08946000
         MVC   #OUT,OUTSEL                   "          S M=12345678  " 08947000
         MVC   #OUT+14(8),DIRNAME            MEMBER NAME                08948000
         LA    R1,#OUT+14                    POINT TO EQUALS            08949000
         SPACE 1                                                        08950000
         LA    R1,1(,R1)                     FIND                       08951000
         CLI   0(R1),X'40'                       NEXT                   08952000
         BNE   *-8                                   BLANK              08953000
         SPACE 1                                                        08954000
         CLI   MSGLINE,0                     ANY TEXT?                  08955000
         BE    OUT72                         NO, BRANCH                 08956000
         MVC   #OUT+24(40),MSGLINE           YES, ADD THE TEXT          08957000
         B     OUT73                                                    08958000
         SPACE 1                                                        08959000
OUT72    MVI   1(R1),C','                    ADD BLANK AND COMMA        08960000
         MVC   2(8,R1),DIRNAME               MEMBER NAME AGAIN          08961000
         SPACE 1                                                        08962000
         LA    R1,1(,R1)                     FIND                       08963000
         CLI   0(R1),X'40'                       NEXT                   08964000
         BNE   *-8                                   BLANK              08965000
         SPACE 1                                                        08966000
         MVI   0(R1),C')'                    ADD ONE PARENTHESIS        08967000
         MVI   1(R1),C')'                    ADD SECOND PARENTHESIS     08968000
OUT73    PUT   QAMDCB,#OUT                   OUTPUT THIS LINE           08969000
         TM    FLAGSFF,FNOECHO               OUTPUT TO THE TERMINAL?    08970000
         BNZ   OUT74                         NO, BRANCH                 08971000
         MVC   MSGTEXT1+4(80),#OUT           OUTPUT LINE                08972000
         LA    R0,84                                                    08973000
         SLL   R0,16                                                    08974000
         ST    R0,MSGTEXT1                                              08975000
         MESSAGE MSGTEXT1                                               08976000
         SPACE 1                                                        08977000
OUT74    TM    FLAGSEE,FOUTASS               ASSOCIATE MEMBERS DESIRED? 08978000
         BNO   OUT76                         NO, BRANCH                 08979000
         BAL   R14,READDIR                   GET NEXT DIRECTORY MEMBER  08980000
         B     OUT76                         LAST MEMBER PROCESSED      08981000
         SPACE 1                                                        08982000
         CLC   DIRTTR,MEMTTR                 TTR MATCH?                 08983000
         BNE   OUT74                         NO, BRANCH                 08984000
         MVC   DIRNAME(8),MEMNAME            SUBSTITUTE THE MEMBER NAME 08985000
         B     OUT50                         ADD ALIAS TO THE OUTPUT    08986000
         SPACE 2                                                        08987000
OUT76    ST    R2,RECOVER                    RESET THE RECOVERY ADDRESS 08988000
         B     NEWCMD                        TERMINATE                  08989000
         SPACE 3                                                        08990000
OUT80    LM    R2,R8,#OUTREGS                RESET REGISTERS            08991000
         ST    R2,RECOVER                    RESTORE RECOVERY ADDRESS   08992000
         SPACE 1                                                        08993000
OUT84    MVI   OPENLIST,X'80'                END OF LIST                08994000
         CLOSE (QAMDCB),MF=(E,OPENLIST)      CLOSE OUT DATA SET         08995000
         NI    FLAGSFF,FF-FCHANGE            NEED A COPY STATEMENT      08996000
         LA    R1,L781$1                     OUT DCB IS NOT FB, 80      08997000
         MVC   INSERT#1(8),OTEXTOUT          OUTCOPY                    08998000
         CLI   #OUT,0                        ERROR CLOSE?               08999000
         BE    MSGNEWXX                      YES, OUTPUT A MESSAGE      09000000
         LA    R1,L080                       DATA SET IS NOW CLOSED     09001000
         B     MSGNEWXX                      NOW CLOSED                 09002000
         SPACE 4                                                        09003000
         USING IHADCB,R1                                                09004000
OUT90    CLC   DCBDSORG(2),ZERO              ANY DSORG?                 09005000
         BNE   *+8                           YES, BRANCH                09006000
         OI    DCBDSORG,DS1DSGPS             NO, USE DSORG=PS           09007000
         TM    DCBDSORG,DS1DSGPS             DSORG=PS?                  09008000
         BNOR  R14                           NO, ERROR                  09009000
         CLI   DCBRECFM,0                    ANY RECFM?                 09010000
         BNE   *+8                           YES, BRANCH                09011000
         MVI   DCBRECFM,DCBRECF+DCBRECBR     NO, USE RECFM=FB           09012000
         TM    DCBRECFM,DCBRECF              RECFM=F.?                  09013000
         BNOR  R14                           NO, ERROR                  09014000
         LA    R0,80                         DEFAULT LRECL              09015000
         CLC   DCBLRECL(2),ZERO              ANY LRECL?                 09016000
         BNE   *+8                           YES, BRANCH                09017000
         STH   R0,DCBLRECL                   NO, USE LRECL=80           09018000
         CH    R0,DCBLRECL                   LRECL=80?                  09019000
         BNER  R14                           NO, ERROR                  09020000
         LA    R0,3120                       DEFAULT BLKSIZE            09021000
         CLC   DCBBLKSI(2),ZERO              ANY BLKSIZE?               09022000
         BNE   *+8                           YES, BRANCH                09023000
         STH   R0,DCBBLKSI                   NO, USE BLKSIZE=3120       09024000
         MVI   #OUT,1                        ALL ATTRIBUTES ARE CORRECT 09025000
         BR    R14                                                      09026000
         DROP  R1                                                       09027000
         SPACE 2                                                        09028000
         PRINT NOGEN                                                    09029000
QSAMDCB  DCB   DSORG=PS,DDNAME=PDSOUT,MACRF=(PM),EXLST=OUT99            09030000
LQSAMDCB EQU   *-QSAMDCB                                                09031000
         PRINT GEN                                                      09032000
         SPACE 2                                                        09033000
OUT99    DC    0F'0',X'85',AL3(OUT90)        OPEN EXIT ONLY             09034000
OUTCOPYS DC    CL80'          COPY OUTDD=OUTPUT,INDD=1'                 09035000
OUTSEL   DC    CL80'          S M=12345678            '                 09036000
OTEXTOUT DC    CL8'OUTCOPY'                                             09037000
         TITLE 'P D S  --  PDS PRINTOFF AND ITS ALIASES        1/15/85' 09038000
*********************************************************************** 09039000
***    PRINTOFF SUBCOMMAND (AND ITS ALIASES)                        *** 09040000
*********************************************************************** 09041000
*                                                                       09042000
         SPACE 1                                                        09043000
PRINTOFF CSECT                                                          09044000
         USING *,R8                                                     09045000
         MVC   MSGTEXT1+4(8),##SUBCAL   PROCESSOR TO ATTACH             09046000
         MVI   MSGTEXT1+12,X'40'        ADD A BLANK                     09047000
         MVI   MSGTEXT1+13,C''''        ADD A QUOTE                     09048000
         MVC   MSGTEXT1+14(44),DSNAME   ADD THE DATA SET NAME           09049000
         LH    R15,DSNLEN               DSNAME ACTUAL LENGTH            09050000
         LA    R4,14(,R15)              LENGTH OF "PRINTOFF'"           09051000
         LA    R3,MSGTEXT1+13(R15)      POINT TO CURRENT BYTE -1        09052000
         TM    DSORG,DS1DSGPO           NON-PARTITIONED DATA SET?       09053000
         BZ    PRINT6                   YES, BRANCH                     09054000
         SPACE 1                                                        09055000
         MVI   1(R3),C'('               MEMBER NAME PARENTHESIS         09056000
         MVC   2(8,R3),DIRNAME          MEMBER NAME                     09057000
         LA    R3,2+8(,R3)              END OF MEMBER +1                09058000
         LA    R4,2+8(,R4)              LENGTH OF MEMBER +1             09059000
         LA    R2,8                     MAXIMUM MACHINE LENGTH+1        09060000
PRINT3   BCTR  R3,0                     SCAN                            09061000
         BCTR  R4,0                         BACKWARDS                   09062000
         CLI   0(R3),X'40'                           FOR                09063000
         BNE   *+8                                       FIRST          09064000
         BCT   R2,PRINT3                                      NON-BLANK 09065000
         SPACE 1                                                        09066000
         BCTR  R2,0                     MACHINE LENGTH                  09067000
         TRT   DIRNAME(*-*),TRTMEM      <<EXECUTED>>                    09068000
         EX    R2,*-6                   VALID MEMBER NAME?              09069000
         BNZ   BADMEMB                  NO, ERROR                       09070000
         CLI   DIRNAME,C'0'             VALID FIRST CHARACTER?          09071000
         BNL   BADMEMB                  NO, BRANCH                      09072000
         LA    R3,1(,R3)                POINT TO TERMINATOR             09073000
         MVI   0(R3),C')'               ADD A CLOSING PARENTHESIS       09074000
         SPACE 1                                                        09075000
PRINT6   MVI   1(R3),C''''              ADD A QUOTE                     09076000
         MVI   2(R3),X'40'              ADD A BLANK                     09077000
         LA    R4,3(,R4)                ACCOUNT FOR ")' "               09078000
         LA    R2,MSGLINE               START OF ANY ADDED TEXT         09079000
         SR    R2,R4                    WHERE TO START MESSAGE          09080000
         LR    R14,R4                   CURRENT MESSAGE LENGTH          09081000
         BCTR  R14,0                    MESSAGE MACHINE LENGTH          09082000
         MVC   0(*-*,R2),MSGTEXT1       <<EXECUTED>>                    09083000
         EX    R14,*-6                  MOVE IN MESSAGE TEXT            09084000
         SPACE 1                                                        09085000
         TM    FLAGSGG,FSAVEOP         SAVE TEXT MODE?                  09086000
         BNZ   PRINT9                  NO, BRANCH                       09087000
         IC    R1,##ADRCM#             INDEX TO SAVE TEXT               09088000
         N     R1,=F'15'               MASK OFF HIGH BITS               09089000
         MH    R1,=H'40'               OFFSET OF SAVE TEXT              09090000
         LA    R15,FIRST4K                                              09091000
         LA    R15,SAVETEXT-FIRST4K(R1,R15)  SAVE TEXT AREA             09092000
         CLI   #COMMDSZ+1,0            ANY OPERAND?                     09093000
         BE    PRINT8                  NO, BRANCH                       09094000
         MVC   0(40,R15),MSGLINE       YES, SAVE NEW DEFAULT TEXT       09095000
         B     PRINT9                                                   09096000
PRINT8   MVC   MSGLINE(40),0(R15)      USE THE DEFAULT OPERAND          09097000
         CLI   0(R15),0                ANY DEFAULT?                     09098000
         BE    PRINT9                  NO, BRANCH                       09099000
         MVI   #COMMDSZ+1,40           YES, USE A 40 CHARACTER LENGTH   09100000
         SPACE 1                                                        09101000
PRINT9   AH    R4,#COMMDSZ              ADD REMAINING LENGTH            09102000
         SLL   R4,16                    CLEAR BOTTOM TWO BYTES          09103000
         STCM  R4,B'1111',0(R2)         SAVE STRING TOTAL LENGTH        09104000
         SPACE 1                                                        09105000
         LA    R3,##SUBCAL              PROCESSOR TO ATTACH             09106000
*        MESSAGE (R2)                   DELETE * TO OUTPUT COMMAND      09107000
         ST    R2,ADDRTEXT              COMMAND ADDRESS                 09108000
         ST    R2,ADDRCBUF              COMMAND ADDRESS                 09109000
         CLI   ##SUBCAL,C'%'            IMPLIED CLIST?                  09110000
         BE    EXEC                     YES, BRANCH                     09111000
         MVI   3(R2),9                  POINT TO OPERAND OFFSET         09112000
         L     R14,ADDRECT                                              09113000
         MVC   ECTPCMD-ECT(8,R14),##SUBCAL  PROCESSOR COMMAND NAME      09114000
         LA    R1,ADDRTEXT              ADDRESS OF THE CPPL             09115000
         LA    R3,##SUBCAL              PROCESSOR TO ATTACH             09116000
         BAL   R2,ATTACH                CLEAR THE ATTENTION ECB         09117000
         B     NEWSTAX                  DO THE NEXT COMMAND             09118000
         TITLE 'P D S  --  PDS RENAME                          1/15/85' 09119000
*********************************************************************** 09120000
***      RENAME SUBCOMMAND                                          *** 09121000
*********************************************************************** 09122000
*                                                                       09123000
         SPACE 1                                                        09124000
RENAME   CSECT                                                          09125000
         USING *,R8                                                     09126000
         CLI   #RENRANG,1              RENAME GROUP?                    09127000
         BE    RENAME30                YES, BRANCH                      09128000
         AIF ('&CISP' EQ 'NO SPF').MA00640                         @D01
         SPACE 1                                                        09129000
         TM    SPFLAG2,SPFPOST            LINE COMMAND?                 09130000
         BNO   RENAME3                    NO, BRANCH                    09131000
         LA    R1,FIRST4K                 GET ADDRESSABILITY            09132000
         MVC   MEMLNMSV-FIRST4K(8,R1),MEMBER2                           09133000
         B     RENAME6                    NO, BRANCH                    09134000
.MA00640 ANOP  ,                                                   @D01
         SPACE 1                                                        09135000
RENAME3  MVC   MEMBERD+1(2),LMEMBER2   CHANGE DEFAULT MEMBER LENGTH     09136000
         MVC   MEMBERD+1+2(8),MEMBER2  CHANGE DEFAULT MEMBER NAME       09137000
         MVI   MEMBERD,FMEMBER1        ONLY ONE MEMBER NAME NOW         09138000
         NI    FLAGSEE,FF-FMEMLIST     NO MEMBER LIST                   09139000
         BAL   R14,DEFGROUP                    ADD DEFAULT GROUP        09140000
         SPACE 1                                                        09141000
RENAME6  MVC   DSNMEMQ(8),MEMBER1      MEMBER NAME TO TEST              09142000
         BAL   R2,ENQMTEST             MEMBER IN USE?                   09143000
         B     NEWCMD                  YES, ERROR                       09144000
         SPACE 1                                                        09145000
         BAL   R2,OPENSTOW             OPEN STOW DCB; ENQUEUES          09146000
         B     NEWCMD                  COULD NOT OPEN -- ERROR          09147000
         LA    R6,NEWCMD               ASSUME NOT A SWAP REQUEST        09148000
         SPACE 1                                                        09149000
         CLC   MEMBER1(8),MEMBER2      UPDATE ALIASES ONLY?             09150000
         BE    RENAME90                YES, BRANCH                      09151000
         SPACE 2                                                        09152000
         TM    #RENSWAP,X'01'          SWAP MEMBER NAMES?               09153000
         BNO   RENAME20                NO, BRANCH                       09154000
         SPACE 1                                                        09155000
*** RENAME WITH SWAP OPERAND *** *** *** *** *** *** *** *** *** *** ** 09156000
         MVC   MSGTEXT1(DIREND-DIRNAME),DIRNAME  SAVE THE FIRST MEMBER  09157000
         XC    DIRUSER,DIRUSER         CLEAR THE USER FIELDS            09158000
         MVC   DIRNAME,MEMBER2         SECOND MEMBER NAME               09159000
         SPACE 2                                                        09160000
         BLDL  INDCB,BLDLLIST          LOCATE DIRECTORY ENTRY           09161000
         B     *+4(R15)                PROCESS RETURN CODE              09162000
         B     RENAME10                  00 - SUCCESSFUL                09163000
         B     NOMEMBER                  04 - MEMBER NOT FOUND          09164000
         B     IOERROR                   08 - I/O ERROR                 09165000
         SPACE 2                                                        09166000
RENAME10 MVC   DIRFLAG(DIREND-DIRFLAG),DIRFLAG+2 BLDL ADDS THINGS       09167000
         MVC   DIRNAME,MEMBER1         FIRST MEMBER NAME                09168000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   09169000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        09170000
         SPACE 1                                                        09171000
         LTR   R15,R15                 SUCCESSFUL?                      09172000
         BNZ   IOERROR                 NO, I/O ERROR                    09173000
         MVC   MSGTEXT2(DIREND-DIRNAME),DIRNAME  SAVE THE SECOND MEMBER 09174000
         SPACE 2                                                        09175000
         MVC   DIRNAME(DIREND-DIRNAME),MSGTEXT1  FIRST MEMBER           09176000
         MVC   DIRNAME,MEMBER2         SECOND MEMBER NAME               09177000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   09178000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        09179000
         SPACE 1                                                        09180000
         LTR   R15,R15                 SUCCESSFUL?                      09181000
         BNZ   IOERROR                 NO, I/O ERROR                    09182000
         BAL   R6,RENAME90             UPDATE ANY ALIAS MEMBERS         09183000
         MVC   DIRNAME(DIREND-DIRNAME),MSGTEXT2  SECOND MEMBER          09184000
         MVC   MEMBER1(8),MEMBER2      SWAP THE                         09185000
         MVC   MEMBER2(8),DIRNAME              MEMBER NAMES             09186000
         BAL   R6,RENAME90             UPDATE ANY ALIAS MEMBERS         09187000
         B     NEWCMD                                                   09188000
         SPACE 3                                                        09189000
*** RENAME WITH NO OPERANDS  *** *** *** *** *** *** *** *** *** *** ** 09190000
RENAME20 MVC   DIRNAME(8),MEMBER2      MEMBER NAME FOR AN ERROR MESSAGE 09191000
         STOW  STOWDCB,MEMBER1,C       ISSUE STOW WITH CHANGE OPTION    09192000
         SPACE 1                                                        09193000
         B     *+4(R15)                PROCESS RETURN CODE              09194000
         B     RENAME90                  00 - SUCCESSFUL                09195000
         B     MEMEXIST                  04 - THIS NAME ALREADY EXISTS  09196000
         B     NOMEMBER                  08 - MEMBER NAME NOT FOUND     09197000
         EX    0,*                       12 - INVALID RETURN CODE       09198000
         B     IOERROR                   16 - DIRECTORY I/O ERROR       09199000
         SPACE 3                                                        09200000
*** RENAME WITH GROUP OPERAND ** *** *** *** *** *** *** *** *** *** ** 09201000
RENAME30 NI    FLAGSBB,FF-FLINESET     NO OUTPUT IN PROGRESS YET        09202000
         MVI   SUBPOOLT,21             TEMPORARY STORAGE IN USE         09203000
         MVI   STARTTR+2,X'01'         READ THE DIRECTORY               09204000
         LA    R5,256/2                256 MEMBERS INITIALLY            09205000
         SPACE 1                                                        09206000
RENAME40 SLL   R5,1                    MEMBERS*2 FOR EACH LOOP          09207000
         SR    R2,R2                                                    09208000
         LR    R3,R5                                                    09209000
         LR    R0,R5                                                    09210000
         SLL   R0,4                    MEMBERS*16 IS TABLE SIZE         09211000
         ICM   R0,B'1000',SUBPOOLT                                      09212000
         GETMAIN R,LV=(0)              ALLOCATE A NEW MEMBER TABLE      09213000
         LR    R4,R1                   NEW TABLE ADDRESS                09214000
         ICM   R0,B'1111',#MEMPTR      ANY PREVIOUS MEMBERS?            09215000
         BZ    RENAME42                NO, BRANCH                       09216000
         SRL   R3,1                    YES, USE SECOND HALF OF TABLE    09217000
         LR    R14,R4                  NEW TABLE START ADDRESS          09218000
         LR    R15,R5                                                   09219000
         SLL   R15,3                   MEMBERS*8 IS OLD TABLE SIZE      09220000
         LR    R2,R15                  DISPLACEMENT TO NEW PART         09221000
         LR    R1,R15                                                   09222000
         MVCL  R14,R0                  PRESERVE THE PREVIOUS TABLE      09223000
         L     R1,#MEMPTR                                               09224000
         LR    R0,R2                   LENGTH TO FREE                   09225000
         ICM   R0,B'1000',SUBPOOLT     SUBPOOL TO FREE                  09226000
         FREEMAIN R,LV=(0),A=(1)                                        09227000
         SPACE 1                                                        09228000
RENAME42 ST    R4,#MEMPTR              MEMBER TABLE BASE                09229000
         AR    R4,R2                   WHERE TO ADD MEMBERS             09230000
         SPACE 3                                                        09231000
RENAME44 BAL   R14,READDIR             GET THE NEXT MEMBER              09232000
         B     RENAME52                END OF MEMBERS, BRANCH           09233000
         SPACE 1                                                        09234000
         LH    R1,LMEMBER1             MEMBER NAME LENGTH               09235000
         CLC   MEMNAME(*-*),MEMBER1    <<EXECUTED>>                     09236000
         EX    R1,*-6                  MEMBER:GROUP                     09237000
         BL    RENAME44                  LOW, LOOP                      09238000
         BH    RENAME52                  HIGH, DONE WITH FIRST PHASE    09239000
         MVC   DSNMEMQ(8),MEMNAME        EQUAL, CHECK FOR ENQUEUED      09240000
         BAL   R2,ENQMTEST                                              09241000
         NOP   0                       OUTPUT AN ERROR MESSAGE ONLY     09242000
         SPACE 2                                                        09243000
         LA    R2,MEMNAME+7                                             09244000
         TM    FLAGSBB,FLINESET        LINE IN PROGRESS?                09245000
         BO    RENAME46                YES, BRANCH                      09246000
         OI    FLAGSBB,FLINESET        LINE NOW IN PROGRESS             09247000
         LA    R1,80                   ASSUME AN ACTIVE MODE            09248000
         AIF ('&CISP' EQ 'NO SPF').MA00660                         @D01
         TM    SPFLAG0,SPFDON          ISPMODE ACTIVE?                  09249000
         BO    RENAME45                YES, BRANCH                      09250000
.MA00660 ANOP  ,                                                   @D01
         TM    CONTOPTN,1              ANY LOG RECORDING?               09251000
         BO    RENAME45                YES, BRANCH                      09252000
         GTSIZE
         CH    R1,=H'120'              120 OR LESS BYTES?               09254000
         BL    *+8                     YES, BRANCH                      09255000
         LH    R1,=H'120'              NO, USE 120 BYTES                09256000
RENAME45 SH    R1,=H'7'                LESS SEVEN FOR PREFIX            09257000
         ST    R1,LINESIZE             CHARACTERS/LINE                  09258000
         MVC   MSGLINE+4(L'MSGRENAM),MSGRENAM                           09259000
         LA    R6,MSGLINE+4+L'MSGRENAM                                  09260000
         MVC   FULLWORD(3),L161$1                                       09261000
         SPACE 1                                                        09262000
RENAME46 CLI   0(R2),X'40'             SCAN FOR                         09263000
         BNE   *+8                             LAST                     09264000
         BCT   R2,RENAME46                         NON-BLANK            09265000
         SPACE 1                                                        09266000
         LA    R0,MEMNAME                                               09267000
         SR    R2,R0                                                    09268000
         BNM   *+6                                                      09269000
         SR    R2,R2                                                    09270000
         LA    R15,2(R6,R2)                                             09271000
         LA    R1,MSGLINE                                               09272000
         SR    R15,R1                                                   09273000
         C     R15,LINESIZE                                             09274000
         BNH   RENAME50                                                 09275000
         LA    R1,MSGLINE+4                                             09276000
         SR    R6,R1                                                    09277000
         STC   R6,MTHIGHL                                               09278000
         MVC   INSERT#1(127),MSGLINE+4                                  09279000
         LA    R1,FULLWORD                                              09280000
         TSMSG (R1)                                                     09281000
         MVI   MTHIGHL,8                                                09282000
         MVI   FULLWORD+2,C'9'                                          09283000
         LA    R6,MSGLINE+3            INDENT FOR BLANKS                09284000
         SPACE 1                                                        09285000
RENAME50 MVI   0(R6),X'40'                                              09286000
         MVC   1(8,R6),MEMNAME                                          09287000
         TR    1(8,R6),TRLINE                                           09288000
         LA    R1,2(R2,R6)                                              09289000
         MVI   0(R1),C','                                               09290000
         LA    R6,3(R2,R6)                                              09291000
         MVC   0(16,R4),MEMNAME        CURRENT MEMBER NAME              09292000
         LA    R4,16(,R4)              NEXT MEMBER NAME                 09293000
         S     R3,=F'1'                ANY HOLD POSITIONS LEFT?         09294000
         BP    RENAME44                YES, BRANCH                      09295000
         B     RENAME40                NO, REALLOCATE                   09296000
         SPACE 2                                                        09297000
RENAME52 LA    R1,L401                 ASSUME NO MEMBERS FOUND          09298000
         TM    FLAGSBB,FLINESET        LINE IN PROGRESS?                09299000
         BZ    MSGNEW                  NO, EXIT                         09300000
         LA    R1,MSGLINE+5                                             09301000
         SR    R6,R1                                                    09302000
         STC   R6,MTHIGHL                                               09303000
         MVC   INSERT#1(127),MSGLINE+4                                  09304000
         LA    R1,FULLWORD                                              09305000
         TSMSG (R1)                                                     09306000
         MVI   MTHIGHL,8                                                09307000
         MESSAGE MSGBLANK                                               09308000
         SPACE 1                                                        09309000
         LA    R1,PDS391A              VERIFY THAT YOU WISH TO RENAME.. 09310000
         BAL   R2,YESNO                PROMPT FOR YES OR NO             09311000
         B     NEWCMD                  NO, BRANCH                       09312000
         SPACE 2                                                        09313000
         BAL   R2,OPENSTOW             OPEN STOW DCB; ENQUEUE           09314000
         B     NEWCMD                  OPEN FAILED -- ERROR             09315000
         SPACE 3                                                        09316000
         L     R3,#MEMPTR              FIRST MEMBER POINTER             09317000
         LA    R6,RENAME60             WHERE TO GO                      09318000
         MVI   #RENDEFT,FMEMBER1+FMEMBER2+FMEMRANG+FMEM#MEM             09319000
         MVC   #RENDEFT+1(2+8+8+2),LMEMBER1  LENGTH1, MEMBER1, M2, L2   09320000
         SPACE 1                                                        09321000
RENAME60 MVC   MEMBERD(1+2+8+8+2),#RENDEFT    FLAG, LEN1, MEM1, M2, L2  09322000
         MVC   MEMBERD+1(2),#RENDEFT+1+2+8+8  REPEAT LEN2 FOR LEN1      09323000
         MVC   MEMBERD+1+2(8),#RENDEFT+1+2+8  REPEAT MEM2 FOR MEM1      09324000
         NI    FLAGSEE,FF-FMEMLIST            NO MEMBER LIST            09325000
         CR    R3,R4                   DONE?                            09326000
         BE    NEWCMD                  YES, BRANCH                      09327000
         MVC   DIRNAME(16),0(R3)       CURRENT MEMBER NAME              09328000
         LA    R3,16(,R3)              NEXT MEMBER NAME                 09329000
         MVC   MEMBER1(8),DIRNAME                                       09330000
         MVC   MEMBER2(8),DIRNAME                                       09331000
         LH    R1,LMEMBER2                                              09332000
         MVC   MEMBER2(*-*),#RENDEFT+1+2+8  <<EXECUTED>>                09333000
         EX    R1,*-6                       MOVE IN FIRST FEW BYTES     09334000
         SPACE 1                                                        09335000
         CLC   MEMBER1(8),MEMBER2      UPDATE ALIASES ONLY?             09336000
         BE    RENAME90                YES, BRANCH                      09337000
         SPACE 2                                                        09338000
         TM    #RENSWAP,X'01'          SWAP MEMBER NAMES?               09339000
         BO    RENAME70                YES, BRANCH                      09340000
         SPACE 1                                                        09341000
         MVC   DIRNAME(8),MEMBER2      MEMBER NAME FOR AN ERROR MESSAGE 09342000
         STOW  STOWDCB,MEMBER1,C       ISSUE STOW WITH CHANGE OPTION    09343000
         SPACE 1                                                        09344000
         B     *+4(R15)                PROCESS RETURN CODE              09345000
         B     RENAME90                  00 - SUCCESSFUL                09346000
         B     MEMEXIST                  04 - THIS NAME ALREADY EXISTS  09347000
         EX    0,*                       08 - MEMBER NAME NOT FOUND     09348000
         EX    0,*                       12 - INVALID RETURN CODE       09349000
         B     IOERROR                   16 - DIRECTORY I/O ERROR       09350000
         SPACE 3                                                        09351000
*** RENAME WITH GROUP AND SWAP OPERAND   *** *** *** *** *** *** *** ** 09352000
RENAME70 XC    DIRUSER,DIRUSER         CLEAR THE USER FIELDS            09353000
         MVC   DIRNAME,MEMBER1         FIRST MEMBER NAME                09354000
         SPACE 1                                                        09355000
         BLDL  INDCB,BLDLLIST          LOCATE DIRECTORY ENTRY           09356000
         LTR   R15,R15                 ANY PROBLEM?                     09357000
         BNZ   IOERROR                 YES, ERROR                       09358000
         SPACE 1                                                        09359000
         MVC   DIRFLAG(DIREND-DIRFLAG),DIRFLAG+2 BLDL ADDS THINGS       09360000
         MVC   MSGTEXT1(DIREND-DIRNAME),DIRNAME  SAVE THE FIRST MEMBER  09361000
         XC    DIRUSER,DIRUSER         CLEAR THE USER FIELDS            09362000
         MVC   DIRNAME,MEMBER2         SECOND MEMBER NAME               09363000
         SPACE 2                                                        09364000
         BLDL  INDCB,BLDLLIST          LOCATE DIRECTORY ENTRY           09365000
         B     *+4(R15)                PROCESS RETURN CODE              09366000
         B     RENAME80                  00 - SUCCESSFUL                09367000
         B     NOMEMBER                  04 - MEMBER NOT FOUND          09368000
         B     IOERROR                   08 - I/O ERROR                 09369000
         SPACE 3                                                        09370000
RENAME80 MVC   DIRFLAG(DIREND-DIRFLAG),DIRFLAG+2 BLDL ADDS THINGS       09371000
         MVC   DIRNAME,MEMBER1         FIRST MEMBER NAME                09372000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   09373000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        09374000
         SPACE 1                                                        09375000
         LTR   R15,R15                 SUCCESSFUL?                      09376000
         BNZ   IOERROR                 NO, I/O ERROR                    09377000
         MVC   MSGTEXT2(DIREND-DIRNAME),DIRNAME  SAVE THE SECOND MEMBER 09378000
         SPACE 2                                                        09379000
         MVC   DIRNAME(DIREND-DIRNAME),MSGTEXT1  FIRST MEMBER           09380000
         MVC   DIRNAME,MEMBER2         SECOND MEMBER NAME               09381000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   09382000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        09383000
         SPACE 1                                                        09384000
         LTR   R15,R15                 SUCCESSFUL?                      09385000
         BNZ   IOERROR                 NO, I/O ERROR                    09386000
         BAL   R6,RENAME90             UPDATE ANY ALIAS MEMBERS         09387000
         MVC   DIRNAME(DIREND-DIRNAME),MSGTEXT2  SECOND MEMBER          09388000
         MVC   MEMBER1(8),MEMBER2      SWAP THE                         09389000
         MVC   MEMBER2(8),DIRNAME              MEMBER NAMES             09390000
         BAL   R6,RENAME90             UPDATE ANY ALIAS MEMBERS         09391000
         B     RENAME60                PROCESS OTHER MEMBERS IN GROUP   09392000
         SPACE 2                                                        09393000
** UPDATE ANY ALIAS ENTRIES FOR LOAD MODULES                            09394000
RENAME90 MVC   INSERT#1(8),MEMBER1                                      09395000
         MVC   INSERT#2(8),MEMBER2        NEW MEMBER NAME          @D01
         TSMSG L090$2                                              @D01 09396000
         SPACE 1                                                        09397000
         TM    FLAGSCC,RECFMU          LOAD MODULE?                     09398000
         BNOR  R6                      NO, BRANCH                       09399000
         TM    DIRFLAG,DIRALIAS        AN ALIAS?                        09400000
         BOR   R6                      YES, BRANCH                      09401000
         SPACE 2                                                        09402000
         MVI   STARTTR+2,X'01'         TTR=000001 (START OF DIRECTORY)  09403000
         SPACE 1                                                        09404000
RENAME95 BAL   R14,READDIR             GET NEXT DIRECTORY MEMBER        09405000
         B     0(R6)                   LAST MEMBER PROCESSED            09406000
         SPACE 1                                                        09407000
         CLC   DIRTTR,MEMTTR           TTR'S MATCH?                     09408000
         BNE   RENAME95                NO, BRANCH                       09409000
         TM    MEMFLAG,X'80'           ALIAS ENTRY?                     09410000
         BNO   RENAME95                NO, CONTINUE SEARCHING           09411000
         SPACE 2                                                        09412000
         L     R14,DIRPTRS             CURRENT DIRECTORY ENTRY          09413000
         MVC   DIRNAME(DIREND-DIRNAME),0(R14)                           09414000
         SPACE 1                                                        09415000
         LA    R14,DIRREAL             CORRESPONDING MAIN ENTRY NAME    09416000
         TM    DIRATTR,ATTRSCTR        SCATTER LOADED?                  09417000
         BNO   *+8                     NO, BRANCH                       09418000
         LA    R14,DIRREALS            YES, USE THIS NAME               09419000
         CLC   0(8,R14),MEMBER2        ALIAS NAME POINTER=MEMBER NAME?  09420000
         BE    RENAME95                YES, BRANCH                      09421000
         SPACE 1                                                        09422000
         MVC   0(8,R14),MEMBER2        CHANGE THE MEMBER POINTER        09423000
         MVC   DCBRELAD-IHADCB+STOWDCB(3),DIRTTR  TTR                   09424000
         STOW  STOWDCB,DIRNAME,R       REPLACE THIS MEMBER ENTRY        09425000
         SPACE 1                                                        09426000
         LR    R5,R15                  SAVE RETURN CODE                 09427000
         MVC   INSERT#1(8),DIRNAME     MEMBER NAME                      09428000
         TSMSG L065$1                                                   09429000
         LTR   R15,R5                  SUCCESSFUL?                      09430000
         BNZ   IOERROR                 NO, I/O ERROR                    09431000
         B     RENAME95                CONTINUE FOR ALL ALIASES         09432000
         TITLE 'P D S  --  PDS RESTORE                         1/15/85' 09433000
*********************************************************************** 09434000
***   RESTORE SUBCOMMAND    MODIFIED BY BRUCE LELAND -- JUNE, 1982  *** 09435000
*********************************************************************** 09436000
*                                                                       09437000
         SPACE 1                                                        09438000
RESTORE  CSECT                                                          09439000
         USING *,R8                                                     09440000
         ICM   R1,B'1111',MEMBER2       TTR TO BE USED                  09441000
         CLI   LMEMBER2+1,1             COMPARE LENGTH:1                09442000
         BH    REST010                    HIGH (DO NOT ADJUST)          09443000
         SRL   R1,8                                                     09444000
         BE    REST010                    EQUAL (ADJUSTED ONE TIME)     09445000
         SRL   R1,8                       LOW (ADJUSTED TWICE)          09446000
         SPACE 1                                                        09447000
REST010  STCM  R1,B'1111',MEMBER2       SAVE THE UPDATED ADDRESS        09448000
         STCM  R1,B'1111',DIRTTR        SAVE THE UPDATED ADDRESS        09449000
         TM    FLAGSCC,RECFMU           LOAD MODULE?                    09450000
         BNO   REST020                  NO, BRANCH                      09451000
         MVI   #RESTDIR,X'20'+12        1 TEXT TTR, 12 HALFWORDS        09452000
         MVI   #RESTDIR+9,ATTREXEC      EXECUTABLE                      09453000
         MVI   #RESTDIR+10,ATTRNODC+ATTRZORG+ATTREP0+ATTRFLEV           09454000
*                                       NOT DC, ZERO ORG, EP=0, F-LEVEL 09455000
         MVI   #RESTDIR+19,DIRAOSLE+DIRAPFLG  VS EDITOR, APF DATA IS OK 09456000
         SPACE 1                                                        09457000
REST020  CLI   #RESTLIK,0               ANY LIKE OPERAND?               09458000
         BE    REST080                  NO, BRANCH                      09459000
         XC    DIRNAME(74),DIRNAME                                      09460000
         MVC   DIRNAME,#RESTLIK         LIKE NAME                       09461000
         BLDL  INDCB,BLDLLIST           GET MEMBER DIRECTORY            09462000
         SPACE 1                                                        09463000
         B     *+4(R15)                 PROCESS RETURN CODE             09464000
         B     REST030                    00 - FOUND                    09465000
         B     NOMEMBER                   04 - NOT FOUND                09466000
         B     IOERROR                    08 - I/O ERROR IN DIRECTORY   09467000
         SPACE 1                                                        09468000
REST030  MVC   DIRFLAG(DIREND-DIRFLAG),DIRFLAG+2  BLDL ADDS THINGS      09469000
         MVC   #RESTDIR,DIRFLAG         SAVE USER DATA                  09470000
         NI    #RESTDIR,FF-X'80'        TURN OFF ANY ALIAS BIT          09471000
         TM    FLAGSCC,RECFMU           LOAD MODULE?                    09472000
         BNO   REST080                  NO, BRANCH                      09473000
         XC    #RESTDIR,#RESTDIR        CLEAR THE USER DATA             09474000
         LA    R2,DIRAPF                POINT TO APF DATA               09475000
         TM    DIRATTR,ATTRSCTR         SCATTER LOAD?                   09476000
         BNO   *+8                      NO, BRANCH                      09477000
         LA    R2,8(,R2)                YES, POSITION OVER FIELDS       09478000
         TM    DIRFLAG,X'80'            ALIAS?                          09479000
         BO    *+12                     YES, BRANCH                     09480000
         CLI   8(R2),0                  CONVERTED ALIAS ENTRY?          09481000
         BE    *+8                      NO, BRANCH                      09482000
         LA    R2,11(,R2)               ADD ALIAS LENGTH                09483000
         TM    DIRATTR2,DIRAOSLE        O/S MVS LINKAGE EDITOR?         09484000
         BNO   REST040                  NO, BRANCH                      09485000
         TM    DIRATTR2,DIR2SSI         ANY SSI FIELD?                  09486000
         BNO   REST050                  NO, BRANCH                      09487000
REST040  LA    R1,1(,R2)                ADD FOR ROUNDING TO HALFWORD    09488000
         N     R1,=F'-2'                ROUND TO HALFWORD               09489000
         CLC   ZERO,0(R1)               ZERO?                           09490000
         BE    REST050                  YES, BRANCH                     09491000
         CLC   =F'-1',0(R1)             HIGH VALUES?                    09492000
         BE    REST050                  YES, BRANCH                     09493000
         MVC   #RESTSSI,0(R1)           SAVE THE SSI VALUE              09494000
         LA    R2,4(,R1)                POSITION AFTER SSI              09495000
         SPACE 1                                                        09496000
REST050  TM    DIRATTR2,DIRAOSLE+DIRAPFLG  VS LKED AND APF DATA GOOD?   09497000
         BO    REST060                     YES, BRANCH                  09498000
         XC    DIRATTR2(3),DIRATTR2        NO, CLEAR NEW FLAGS          09499000
         B     REST070                                                  09500000
         SPACE 1                                                        09501000
REST060  CLI   0(R2),X'01'              VALID APF LENGTH?               09502000
         BNE   REST070                  NO, BRANCH                      09503000
         MVC   #RESTAPF,1(R2)           YES, SAVE APF DATA              09504000
         SPACE 1                                                        09505000
REST070  MVI   #RESTDIR,X'20'+12        1 TEXT TTR, 12 HALFWORDS        09506000
         NI    DIRATTR,X'CA'            RENT, REUS, ONLY LOAD, EXEC.    09507000
         NI    DIRATTR+1,X'09'          NOT EDIT, REFR                  09508000
         MVC   #RESTDIR+9(2),DIRATTR    COPY INTO THE HOLD AREA         09509000
         OI    #RESTDIR+10,ATTRNODC+ATTRZORG+ATTREP0+ATTRFLEV           09510000
*                                       NOT DC, ZERO ORG, EP=0, F-LEVEL 09511000
         NI    DIRATTR2,DIR2PAGA        PAGE BOUNDARY FLAG              09512000
         NI    DIRATTR2+1,X'1F'         RMODE, AMODE FLAGS              09513000
         MVC   #RESTDIR+19(2),DIRATTR2  COPY INTO THE HOLD AREA         09514000
         OI    #RESTDIR+19,DIRAOSLE+DIRAPFLG  VS EDITOR, APF DATA IS OK 09515000
         SPACE 1                                                        09516000
REST080  MVC   DIRNAME,MEMBER1          MEMBER NAME TO BE RESTORED      09517000
         MVC   DIRTTR(3),MEMBER2        TTR OF MEMBER TO BE RESTORED    09518000
         SPACE 1                                                        09519000
         LA    R1,L873                                                  09520000
         CLC   DIRTTR(3),DS1LSTAR       IN DATA SET BOUNDS?             09521000
         BNL   MSGNEW                   NO, ERROR                       09522000
         SPACE 1                                                        09523000
         TM    #RESFLAG,#RESFREP+#RESFDIS  REPEAT, DISPLAY OR PROMPT?   09524000
         BZ    RESTOR03                    NO, BRANCH                   09525000
         SPACE 1                                                        09526000
         OI    FLAGSII,FNOTDOUB         FORCE SINGLE OR MULTIPLE BUFFER 09527000
         ICM   R1,B'1110',DIRTTR        T T R X  ZERO?                  09528000
         BZ    RESTSC08                 YES, BRANCH                     09529000
         SRL   R1,8                     0 T T R                         09530000
         S     R1,=F'1'                 0 T T R - 1 = 0?                09531000
         BZ    RESTSC08                 YES, BRANCH                     09532000
         SLL   R1,8                     T T R 0 (WHERE R IS REDUCED)    09533000
         STCM  R1,B'1110',DIRTTR        T T R                           09534000
         CLI   MEMBER2+2,X'01'          R OF TTR 1 OR LESS?             09535000
         BH    RESTSC08                 YES, BRANCH                     09536000
         SRL   R1,16                    0 0 T T                         09537000
         BCTR  R1,0                     0 0 T T - 1                     09538000
         SLL   R1,16                    T T 0 0 (WHERE TT IS REDUCED)   09539000
         STCM  R1,B'1100',DIRTTR        T T  UPDATED                    09540000
         MVI   DIRTTR+2,X'01'           RESET R TO 1 OF PREVIOUS TRACK  09541000
         SPACE 1                                                        09542000
RESTSC08 TM    #RESFLAG,#RESFREP        REPEAT?                         09543000
         BZ    RESTSC09                 NO, BRANCH                      09544000
         SPACE 2                                                        09545000
         LA    R1,7                     MACHINE LENGTH                  09546000
         LA    R2,DIRNAME+7             LAST CHARACTER                  09547000
         SPACE 1                                                        09548000
         CLI   0(R2),X'40'              BLANK?                          09549000
         BNE   *+10                     NO, BRANCH                      09550000
         BCTR  R2,0                     PREVIOUS CHARACTER              09551000
         BCT   R1,*-10                  TRY ALL BYTES                   09552000
         SPACE 1                                                        09553000
         ST    R1,#RESTLEN                          NAME LENGTH         09554000
         SPACE 3                                                        09555000
RESTSC09 MVI   SUBPOOLT,21              MARK TEMPORARY STORAGE IN USE   09556000
         LA    R5,1024                  1024 MEMBERS INITIALLY          09557000
         SPACE 1                                                        09558000
RESTSC10 LR    R0,R5                                                    09559000
         SLL   R0,2                     MEMBER