//SGIEE00V JOB 1,'REPLACE SGIEE00V',CLASS=A,MSGLEVEL=(1,1)
//*
//*  Job to replace stage 2 macro SGIEE00V in SYS1.MODGEN
//*  with an unmodified copy from the IBM OS 21.8 distribution.
//*
//*  Some MVT distributions contain a copy of SGIEE00V, the
//*  stage 2 macro that generates IEEVIPL, that has been
//*  modified with an attempt to allow it to bypass checking
//*  for the year 2000.  The statements modified by the
//*  bypass attempt, and the statements on either side of
//*  them, look like this (spaces have been removed to get
//*  the statements to fit in 80 characters):
//*
//* CONVERT  EQU   *                                           20071 04602020
//*          L     R7,TIMEAREA  LOAD HIGH ORDER WORD OF TOD    20071 04603020
//* *                           CLOCK-VALID TO 1.048576 MIC SEC20071 04604020
//*          CL    R7,YR2000    IS TOD GT JAN 1,2000           M5381 04604420
//* * Y2K Kraehe Wed Feb 28 17:43:51 CET 2001
//* *        BNL   TODWTOR1     YES,ERROR. TOD INVALID         M5381 04604820
//* *
//*          BL    NOY2K1
//*          WTO   'Y2K101I SGIEE00V Y2K DETECTED AND IGNORED'
//* *
//* NOY2K1   EQU   *
//* *
//* *                           This was the first point to patch.
//* *                           STCK has to accept the Y2K.
//* *                           I just ignore the Y2K here !
//* *
//*          M     R6,D16384    TOD VALUE MULT BY DEC 16384    20071 04605020
//*          D     R6,D15625    DIVIDE BY DECIMAL 15625 FOR    20071 04606020
//* *                           NUMBER OF SECONDS IN TOD CLOCK 20071 04607020
//* * Y2K Kraehe VM Wed Mar 14 20:08:47 CET 2001
//* *        S     R7,YR1960
//* *
//*          XR    R6,R6        CLEAR REMAINDER REG            20071 04610020
//*          D     R6,D86400    DIV BY SEC PER DAY TO GET DAYS 20071 04611020
//*          LR    R4,R6        SAVE CONTENTS-REM=HH.MM.SS     20071 04612020
//*          C     R7,D366      IS NO. DAYS LESS THAN 366      20071 04613020
//*          BL    LOWYEAR      YES. YEAR IS 1960              20071 04614020
//*
//*  The statements added by the bypass were coded without
//*  sequence numbers, so the modified SGIEE00V macro cannot
//*  be updated using IEBUPDTE.  If you tried to install
//*  TMVT805 on top of the defective SGIEE00V, you will
//*  have received errors like this:
//*
//*     CL    R7,YR2000       IS TOD GT JAN 1,2000       M5381  *    REPLACED*
//*     CL    R7,TODMAX -     Is TOD GE 2060-01-01?   @TMVT805  * REPLACEMENT*
//* * Y2K Kraehe Wed Feb 28 17:43:51 CET 2001
//* IEB807I INVALID OPERATION.
//* IEB808I TERMINATED THIS MEMBER. IEBUPDTE WILL TRY NEXT MEMBER.
//* IEB818I HIGHEST CONDITION CODE WAS 00000004
//*
//*  Before the TMVT805 four-digit year update can be applied,
//*  you must first replace SGIEE00V in SYS1.MODGEN with the
//*  unmodified IBM version of the macro.  This job does that.
//*  The first step of this job renames your existing SGIEE00V
//*  to #GIEE00V.  The second step adds a copy of the unmodified
//*  SGIEE00V to SYS1.MODGEN.
//*
//*  Before running the job, you must first change the string
//*  "dlibvol" to the volume serial of the volume containing
//*  SYS1.MODGEN.
//*
//*
//*-----------------------------------------------------------------***
//*     Step 1:  Rename the existing copy of SGIEE00V in            ***
//*              SYS1.MODGEN to #GIEE00V to save it as              ***
//*              backup.  Before running this step, change          ***
//*              all occurrences of "dlibvol" to the volume         ***
//*              serial of your DLIB volume.  Note that the         ***
//*              continuation character in the "RENAME"             ***
//*              statement must be in column 72.                    ***
//*-----------------------------------------------------------------***
//RENAME EXEC PGM=IEHPROGM,REGION=256K
//SYSPRINT DD SYSOUT=A
//dlibvol  DD DISP=OLD,UNIT=SYSDA,VOL=SER=dlibvol
//SYSIN    DD *
 RENAME DSNAME=SYS1.MODGEN,VOL=3330=dlibvol,                           X
               MEMBER=SGIEE00V,NEWNAME=#GIEE00V
/*
//*
//*-----------------------------------------------------------------***
//*     Step 2:  Add the unmodified IBM-supplied copy of            ***
//*              SGIEE00V to SYS1.MODGEN.                           ***
//*-----------------------------------------------------------------***
//UPDTE   EXEC PGM=IEBUPDTE,REGION=256K,PARM=NEW
//SYSUT2    DD DISP=SHR,DSN=SYS1.MODGEN
//SYSPRINT  DD SYSOUT=A
//SYSIN     DD *
./ ADD NAME=SGIEE00V
         MACRO                                                          00020000
         SGIEE00V &CCA1,&CCN1,&CCV1,&CCA2,&CCN2,&CCV2,&CCA3,           C00040000
               &JUCB,&PUCB,&LCLS,&LCTR,&SMF,&TSO,&BCLMT           20030 00060020
.*                                                                      00080000
.*      THIS IS A MASTER SCHEDULER GROUP 0 SYSGEN MODULE WHICH          00100000
.*       GENERATES THE SYMBOLIC STATEMENTS OF THE MASTER SCHEDULER      00120000
.*       INITIALIZATION MODULE-IEEVIPL. IN ADDITION,VIA MACRO PARAMETRS 00140000
.*            1. THE SYSTEM INITIAL COMMANDS CAN BE GENERATED           00160000
.*            2. THE UNITNAMES OF THE VOLUMES FOR THE PROCEDURE LIBRARY 00180000
.*               AND THE JOB QUEUE CAN BE SPECIFIED                     00200000
.*            3. THE CLASSNAME-TO WHICH THE LOG DATA SET WILL BE        00220000
.*               AUTOMATICALLY WRITTEN WHEN THE DATA SET IS FULL-CAN BE 00240000
.*                GIVEN                                                 00260000
.*            4. THE NUMBER OF BUFFER AREAS TO BE USED BY THE LOG       00280000
.*               WRITER CAN BE INDICATED                                00300000
.*                                                                      00320000
.*       THE MACRO PARAMETERS AS LISTED IN THE ABOVE PROTOTYPE STATEMNT 00340000
.*        INDICATE AS FOLLOWS-                                          00360000
.*            &CCA1 -THE UNITNAME FOR THE START READER COMMAND          00380000
.*            &CCN1 -A DSNAME PARAMETER FOR THE START READER COMMAND    00400000
.*            &CCV1 -A VOLUME SERIAL FOR THE START READER COMMAND       00420000
.*            &CCA2 -THE UNITNAME FOR THE START WRITER COMMAND          00440000
.*            &CCN2 -A DSNAME PARAMETER FOR THE START WRITER COMMAND    00460000
.*            &CCV2 -A VOLUME SERIAL FOR THE START WRITER COMMAND       00480000
.*            &CCA3 -SPECIFIES 'INIT' IF A START INIT COMMAND IS TO BE  00500000
.*                   CREATED                                            00520000
.*            &JUCB -UNITNAME FOR THE VOLUME ON WHICH THE JOB QUEUE IS  00540000
.*                   TO RESIDE                                          00560000
.*            &PUCB -UNITNAME FOR THE VOLUME WHICH CONTAINS THE         00580000
.*                   PROCEDURE LIBRARY                                  00600000
.*            &LCLS -CLASSNAME FOR THE LOG DATA SET                     00620000
.*            &LCTR -THE MAXIMUM NUMBER OF RESIDENT BUFFER AREAS TO BE  00640000
.*                   USED BY THE LOG WRITER                             00660000
.*             &SMF  -SMF SYSGEN OPTION PARAMETER                       00670018
.*             &TSO  -TSO SYSGEN OPTION PARAMETER                       00672020
.*            &BCLMT -MAXIMUM NO. OF BROADCAST RECORDS            20030 00674020
.*                   FOR TSO SEND CP/ OR ZERO IF TSO              20030 00676020
.*                   IS NOT IN THE SYSTEM                         20030 00678020
.*                                                                      00680000
.*       GIVEN ALL OF THE ABOVE PARAMETERS,THE COMMANDS-                00700000
.*            S WTR,&CCA2,DSNAME=&CCN2,VOLUME=SER=&CCV2 *               00720000
.*            S RDR,&CCA1,DSNAME=&CCN1,VOLUME=SER=&CCV1 *               00740000
.*            S INIT *                                                  00760000
.*            WILL BE GENERATED WITHIN THE CODE OF THE INITIALIZATION   00780000
.*            MODULE- THE LOG CLASSNAME WILL BE SET TO &LCLS AND THE    00800000
.*            BUFFER COUNT SET TO &LCTR                                 00820000
.*                  &VALU REPLACED IN THE ABOVE BY THE INCOMING PARAM   00840000
.*                                                                      00860000
*                                                                       00880000
         TITLE ' IPL WITH MS/1 CONSOLE'                                 00900000
IEEVIPL  CSECT                                                          00920000
* D 068000, 079324-079360                                       SA72193 00920121
* A 064820-064980                                               SA72193 00920221
* A 046194-046284,046344,095169                                  A52614 00920421
* C 062600,093100,093300                                          M1874 00922021
* A 030820-030900,093100-093300                                  A40047 00922221
* A 088100                                                       A42562 00924821
*                                                                 M5510 00927021
*                                                                A31300 00929221
*                                                                A31761 00931421
* 000600,093400,093601,100610                                     20030 00933621
*AABA OCIP #9,REL #16                                                   00935821
* 048600-048800                                                  A24430 00938021
*1735024600-024800,028000-028200,048000,051200,051800,052250,      OC43 00940221
*1735053000,054400,075400,079600,091600                            OC43 00942421
* 069200,076400                                                    I270 00944621
* 112430-112550                                                   M0035 00946821
* 045300,049100                                                   20071 00949021
* 095120                                                          M3230 00951221
* 046000,046630-046640,046830-046860,047090,047120                M1866 00953421
* 046080-046090,095132                                            M5381 00955621
*********************************************************************** 00957821
*                                                                       00960000
*  MODULE NAME-IEEVIPL                                                  00980000
*                                                                       01000000
*  FUNCTION   -THIS IS THE FIRST MODULE OF MASTER SCHEDULER. IT IS      01020000
*              RESPONSIBLE FOR SCHEDULER INITIALIZATION.                01040000
*  PROGRAM                                                              01060000
*        FLOW -LINKS TO THE CONSOLE INITIALIZATION MODULE-IEECVCTI AND  01080000
*              POSTS THE COMMUNICATIONS TASK                            01100000
*             -DETERMINES THE VOLUMES ON WHICH THE JOB QUEUE AND THE    01120000
*              PROCEDURE LIBRARY WILL RESIDE.                           01220016
*             -WRITES TO THE OPERATOR THE SYSTEM 'READY' MESSAGE        01440000
*             -WRITES-TO-OPERATOR THE INITIAL COMMANDS AVAILABLE        01480000
*             -IN SYSTEMS WITH THE TOD CLOCK, WRITES TO THE OP-   20071 01484020
*              ERATOR THE CURRENT TIME OF DAY, OR ASKS HIM FOR    20071 01488020
*              SET PARAMETERS SO THAT AN INTERNAL SET COMMAND CAN 20071 01492020
*              BE ISSUED.                                         20071 01496020
*             -WAITS ON POSTING FROM THE SET DATE COMMAND               01500000
*             -OR, WAITS FOR RETURN FROM SVC 34 AFTER THE VALID   20071 01505020
*              SET COMMAND HAS BEEN PROCESSED, AND THE TOD CLOCK  20071 01510020
*              HAS BEEN SET.                                      20071 01515020
*             -MOVES THE MASTER TIOT-ASSEMBLED WITHIN THE IEEVIPL       01520000
*              MODULE INTO SUPERVISOR CORE-SUBPOOL 255                  01540000
* DETERMINES WHERE THE SYS1.SYSJOBQE AND SYS1.PROCLIB DATA SETS    AABA 01550016
* RESIDE. THE UNIT AND VOLUME ARE CHOSEN IN THE FOLLOWING HIERARCHYAABA 01560016
* 1. THE UNIT SPECIFIED IN THE SET COMMAND                         AABA 01570016
* 2. THE CATALOG-THE UNIT CONTAINING THE INDICATED VOLUME          AABA 01580016
* 3. THE UNIT SPECIFIED AT SYSGEN TIME                             AABA 01590016
* 4. THE IPL VOLUME                                                AABA 01600016
*             -CATALOGS SYS1.PROCLIB                                    01645014
*             -SETS INTO THE TIOT THE UCB POINTERS FOR QUEUE AND PROCLB 01660000
*             -ATTACHES THE JOB QUEUE INITIALIZATION TASK -IEFQINTZ     01680000
*             -WAITS ON TASK COMPLETION                                 01700000
*             -DETACHES THE QUEUE INITIALIZATION TASK                   01720000
*             -WRITES-TO-OPERATOR COMMANDS SELECTED THROUGH THE SET     01740000
*              DATE COMMAND AND SCHEDULES THEIR EXECUTION               01760000
*             -PASSES CONTROL TO THE MASTER SCHEDULER WAIT MODULE       01780000
*               IEEVWAIT                                                01800000
*              -PASSES CONTROL TO LOG INITIALIZATION VIA XCTL IF LOG    01806018
*               IS IN SYSTEM                                            01812018
*              -PASSES CONTROL TO SYS1.BRODCAST INITIALIZATION VIA LINK 01814020
*               IF TSO IS IN SYSTEM                                     01816020
*                                                                       01820000
*  ENTRY      -LINK FROM NIP -NUCLEUS INITIALIZATION                    01840000
*                                                                       01860000
*  EXTERNAL   -IEECVCTI-CONSOLE INITIALIZATION                          01880000
*   REFERENCES-IEEVLIN-LOG INITIALIZATION                               01900000
*             -IEE0503D-WTO MESSAGE MODULE- ERROR EXIT                  01920000
*             -IEEVWAIT-NORMAL EXIT                                     01940000
*             -IEEVSIPL-SYS1.BRODCAST INITIALIZATION              20030 01950020
*                                                                       01960000
*  ATTRIBUTES -NONREENTRANT                                             01980000
*             -CHARACTER DEPENDENCE-TYPE C                              02000000
*                                                                       02020000
*  MACROS AND -CVT -COMMUNICATIONS VECTOR TABLE MAPPING                 02040000
*    MAPPINGS -IEFVTIOT-MASTER TIOT                                     02060000
*             -IEEBASEA-MAPPING OF MASTER RESIDENT CORE                 02080000
*             -IEEXSA-MAPPING OF EXTENDED SAVE AREA                     02100000
*             -IEFUCBOB-MAPPING OF THE UNIT CONTROL BLOCK               02120000
*             -LINK                     -ATTACH                         02140000
*             -GETMAIN                  -FREEMAIN                       02160000
*             -WRITE-TO-OPERATOR        -DETACH                         02180000
*             -POST                     -MGCR                           02200000
*********************************************************************** 02220000
*                                                                       02240000
*SYMBOL        VALUE     RTN USED(BY LABEL)       FOR PURPOSE           02260000
*                                                                       02280000
R0       EQU   0                                                        02300000
R1       EQU   1                                                        02320000
R2       EQU   2         IP500,                             WORK        02340000
R3       EQU   3         IP700                                          02360000
R4       EQU   4                                                        02380000
R5       EQU   5         IP100,IP300,IP400,IP500,IP700      WORK        02400000
R6       EQU   6         IP400,IP700,                       WORK        02420000
R7       EQU   7         IP400                              WORK        02440000
R8       EQU   8         ALL                      PROGRAM BASE     OC43 02460017
R9       EQU   9         IP300,IP400,IP600,IP700  RETURN REG       OC43 02480017
R10      EQU   10        ALL                      VTIOT BASE            02500000
R11      EQU   11        ALL                      RESIDENT CORE BASE    02520000
R12      EQU   12        ALL                      CVT BASE              02540000
R13      EQU   13        ALL                      REGISTER SAVE POINTER 02560000
R14      EQU   14                                                       02580000
R15      EQU   15                                                       02600000
TWO      EQU   2                                                 A31761 02603020
THREE    EQU   3                                                 A31761 02606020
FOUR     EQU   4                                                 A31761 02609020
CODEDISP EQU   44       IP516                                    A31761 02612020
FOXZERO  EQU   240                                               A31761 02615020
*                                                                       02620000
*                                                                       02640000
*********************************************************************** 02640620
*********************************************************************** 02641220
*                                                                     * 02641820
*                               CONSTANTS USED BY TOD CLOCK       20071 02642420
*                               ROUTINE FOR OFFSETS,LENGTHS,ETC.  20071 02643020
K0       EQU   0                               **                 20071 02643620
K1       EQU   1                               **                 20071 02644220
K2       EQU   2                               **                 20071 02644820
K3       EQU   3                               **                 20071 02645420
K4       EQU   4                               **                 20071 02646020
K5       EQU   5                               **                 20071 02646620
K6       EQU   6                               **                 20071 02647220
K7       EQU   7                               **                 20071 02647820
K8       EQU   8                               **                 20071 02648420
K12      EQU   12                              **                 20071 02649020
K13      EQU   13                              **                 20071 02649620
K15      EQU   15                              **                 20071 02650220
K26      EQU   26                              **                 20071 02650820
K119     EQU   119                             **                 20071 02651420
BITS32   EQU   32                              **                 20071 02652020
SIXTY    EQU   60                  FIRST YEAR OF TOD CLOCK        20071 02652620
HEX00    EQU   X'00'               MASK FOR COND CODE 0           20071 02653220
HEX03    EQU   X'03'               MASK FOR COND CODE 2           20071 02653820
HEXDD    EQU   X'DD'               MASK FOR NO SET, INTRN SET BITS20071 02654420
BLANK    EQU   C' '                BLANK CHARACTER                20071 02655020
DOT      EQU   C'.'                'DOT' CHARACTER                20071 02655620
QUOTE    EQU   C''''               'QUOTE' CHARACTER              20071 02656220
*********************************************************************** 02656820
TCBTIO   EQU   12                                                       02660000
CAT      EQU   100                 CATALOG INDICATOR                    02670014
STATUS   EQU   76                      SVC 76                     20070 02675020
*                                                                       02680000
*                                                                       02700000
*********************************************************************** 02720000
*              INITIALIZE SYSTEM TO SYSTEM RESIDENCE                    02740000
*                UCB POINTERS LOCATED VIA CVT                           02760000
*********************************************************************** 02780000
         BALR  R8,0                    SET BASE REG                OC43 02790017
         USING *,R8                                                OC43 02800017
         ST    R9,PARMSAVE             SAVE PARMLIB UCB POINTER    OC43 02810017
         B     IP001                                                    02840000
         DC    X'EEEE'                                                  02860000
         DC    CL8'IEEVIPL'         MODULE IDENTIFICATION               02880000
         DC    X'02171969'                                              02900018
         DC    X'EEEE'                                                  02920000
         SPACE                                                          02940000
**********************************************************************  02960000
         SPACE                                                          02980000
IP001    DS    0H                                                       03000000
         L     R12,CVTPTR                                               03020000
         USING CVT,R12                                                  03040000
         L     R11,CVTMSER                                              03060000
         USING BASE,R11                                                 03080000
*                                                                A40047 03082021
* THE FOLLOWING GETMAIN IS FOR 8 BYTES OUT OF SUBPOOL 250 AND    A40047 03084021
* THE SOLE PURPOSE OF IT IS TO SET UP THE MASTER'S REGION.       A40047 03086021
* THE MASTER'S REGION, IN ORDER TO ENSURE DESIGN POINTS BEING    A40047 03088021
* MET, MUST HAVE ITS SUBPOOL 250 (0) CORE IN THE HIGHEST         A40047 03088421
* 2K SLOT OF THE MASTER'S REGION. THESE 8 BYTES WILL NEVER       A40047 03088521
* BE FREED TO KEEP THIS CONFIGURATION.                           A40047 03088621
       GETMAIN  R,SP=250,LV=8                                    A40047 03090021
         SPACE                                                          03092021
       GETMAIN  R,SP=255,LV=72                                          03100000
         LR    R5,R1                                                    03120000
         LR    R13,R1                   STANDARD SAVE PTR               03140000
*                                 CONSOLE INITIALIZATION                03160000
       LINK  EP=IEECVCTI                                                03180000
*                                                                       03200000
         SR    R0,R0                                                    03300000
         LA    R1,BAIPL                 ECB ADDRESS                     03320000
*                                                                       03340000
       POST  (1),(0)                    POST THE COMMUNICATIONS TASK    03360000
         LR    R1,R5                                                    03366021
*                                                                       03368021
     FREEMAIN  R,SP=255,LV=72,A=(1)                                     03370021
*                                                                       03372021
*                                                                       03380000
**********************************************************************  03400000
*                            CONTINUE HERE AFTER INITIALIZATION.        03420000
IP100    EQU   *                                                        03440000
         SPACE                                                          03460000
         LA    R13,IPREGSV                                              03480000
         L     R12,CVTPTR              CVT BASE                         03500000
*                                IEFJOB APPENDAGE PTR.                  03520000
        L     R1,CVTJOB                                                 03540000
         MVC   80(4,R1),CVTXAPG                                         03560000
*                                      DATE SIGN-CODE.                  03580000
         LA    R1,15                   'F' FOR SIGN.                    03600000
         ST    R1,CVTDATE                                               03620000
*                                                                       03640000
         L     R11,CVTMSER             MASTER RESIDENT CORE BASE        03660000
         XC    BAIPL,BAIPL             CLEARED FOR SET COMMAND.         03680000
         NI    BASFL,255-BAIN          AND CLEAR IPL SWITCH             03700000
         XC    BAQ(8),BAQ     JOBQE AND PROCLIB UCB POINTERS ZERO  AABA 03900016
*********************************************************************** 04120000
*                                                                       04140000
*              WRITES READY MESSAGE TO OPERATOR, BRANCHES TO            04160000
*              COMMAND WRITE SUBROUTINE (IP700) WHICH RETURNS CONTROL   04180000
*              TO AWAIT POSTING FROM SET COMMAND                        04200000
*              OR, IN SYSTEMS WITH TOD CLOCK SUPPORT, WRITES A    20071 04202020
*              MESSAGE TO THE OPERATOR TO WHICH HE MUST REPLY     20071 04204020
*              WITH SET PARAMETERS OR 'U', ISSUES AN INTERNAL SET 20071 04206020
*              COMMAND, AND WAITS FOR RETURN FROM SVC 34.         20071 04208020
*              ON RETURN FROM SVC 34, IF THE SET COMMAND IS IN-   20071 04210020
*              VALID, REISSUES THE WTOR ASKING FOR SET PARAMETERS.20071 04212020
*              NOTES.STOP AREA IS PRESET FOR NO STOPS=ALL N'S AND       04220000
*                    FLAG SET TO WTO ONLY ON ENTERING COMMAND WRITE     04240000
*                    SUBROUTINE                                         04260000
*                   .STOP AREA MADE AVAILABLE TO STOP COMMAND BEFORE    04280000
*                    AWAITING SET COMMAND                               04300000
*                                                                       04320000
*********************************************************************** 04340000
*                                                                       04360000
IP300    EQU   *                                                        04380000
         LA    R1,RDYMSG               ISSUE 'READY' MESSAGE       XMCS 04390018
         WTO   MF=(E,(1))                                          XMCS 04400018
*                                                                       04420000
*********************************************************************** 04440000
*             ROUTINE CREATES TIOT BY GETMAIN FROM CORE SUBPOOL 255     04460000
*               AND MOVING THE MASTER TIOT ASSEMBLED WITHIN THE         04480000
*              IPL MODULE BY MACRO IEFVTIOT INTO THE GOTTEN CORE        04500000
*              TIOT IS REQUIRED FOR LOG INITIALIZATION                  04520000
*********************************************************************** 04521020
         LA    R5,CB8                  PT TO STOP INDICATOR      A24430 04522020
         ST    R5,BACV                 AREA BEFORE WAIT          A24430 04523020
         L     R0,CX108                108 BYTES OF SUBPOOL 255  LMCS   04524020
         AIF   ('&LCTR' EQ '0').SKIPLOG  IS LOG SPECIFIED - ZERO BUFS   04525020
*                                      OR NOLOG EXCLUDES LOG            04526020
         AL    R0,LOGTIOT              IF LOG ADD TIOT SPACE     LMCS   04527020
         MVC   BALOG+2(2),IPLCS        SAVE OPTIONS FOR LOG INITIAL LM  04528020
.SKIPLOG ANOP                                                           04529020
         AIF   ('&SMF' EQ '0').S0      IS SMF PRESENT                   04530020
         AL    R0,SMFTIOT              ADD SMF TIOT SIZE            SMF 04531020
.S0      ANOP                                                           04532020
         AIF   ('&TSO' EQ '0').NOTSO    IS TSO PRESENT            20030 04532200
         AL    R0,SENDTIOT        ADD TIOT FOR SYS1.BROADCAST     20030 04532400
.NOTSO   ANOP                                                           04532600
         GETMAIN R,LV=(0)                                               04533020
         LA    R10,VTIOT                                                04534020
         MVC   0(108,R1),0(R10)        MOVE TIOT INTO GOTTEN CORE LMCS  04535020
         LR    R10,R1                  SETUP TIOT BASE                  04536020
         USING VTIOT,R10                                                04537020
         L     R2,CVTTCBP              LOCATE TCB                       04538020
         L     R2,4(R2)                                                 04539020
         ST    R10,TCBTIO(R2)          STORE TIOT PTR IN TCB            04540020
         MVI   CB1,X'00'               FLAG-00=WTO ONLY-NO MGCR         04541020
         LA    R9,IP308                SET WRITE COMMAND RETURN    OC43 04542020
         B     IP700                   GO WRITE COMMANDS                04543020
*                                                                       04544020
IP308    EQU   *                                                 A24430 04545020
*********************************************************************** 04546020
*                                                                     * 04547020
*       THIS ROUTINE HANDLES TOD CLOCK SUPPORT                    20071 04548020
*                                                                     * 04549020
* 1. STCK IS ISSUED TO DETERMINE THE STATE OF THE TOD CLOCK-      20071 04550020
*         CONDITION CODE 0 = CLOCK SET                            20071 04551020
*         CONDITION CODE 1 = CLOCK NOT SET                        20071 04552020
*         CONDITION CODE 2 = CLOCK IN ERROR STATE                 20071 04553020
* 2. IF CC=0, THE TOD VALUE IS CONVERTED TO DECIMAL AND MESSAGE   20071 04554020
*    IEE114A IS ISSUED.  THE OPERATOR CAN REPLY WITH ANY VALID    20071 04555020
*    SET PARAMETERS OR 'U'.                                       20071 04556020
* 3. IF CC=1 OR 2,MESSAGE IEE116A IS ISSUED. THE OPERATOR CAN     20071 04557020
*    REPLY WITH ANY VALID SET PARAMETERS,BUT HE MUST INCLUDE AT   20071 04558020
*    LEAST DATE.                                                  20071 04559020
* 4. AN INTERNAL SET COMMAND IS BUILT USING THE OPERATOR'S PARAM- 20071 04560020
*    ETERS AND/OR TOD VALUES, AND SVC 34 IS ISSUED.(MGCR)         20071 04561020
* 5. ON RETURN FROM SVC 34, IF THE SET COMMAND IS INVALID, THE    20071 04562020
*    ORIGINAL MESSAGE WILL BE REPEATED UNTIL A VALID COMMAND IS   20071 04563020
*    RECEIVED.                                                    20071 04564020
* 6. THE ' NO IPL ' BIT IS TURNED OFF.                            20071 04565020
*********************************************************************** 04566020
         NI    BASFL,HEXDD         TURN OFF NO SET, INTRN SET BITS20071 04567020
         TM    CVTOPTB,CVTTOD      IS TOD SUPPORTED               20071 04568020
         BZ    NOTOD               NO, BRANCH AROUND TOD CODE     20071 04569020
         STCK  TIMEAREA            READ THE TOD VALUE             20071 04570020
         BZ    CCZERO              IF CC IS 0, GO TO CONVERT RTN  20071 04571020
         BC    K4,CCONE            IF CC IS 1, SET BITS TO X'01'  20071 04572020
         OI    CCBITS,HEX03        CC IS 2, SET BITS TO X'11'     20071 04573020
         B     TODWTOR1            GO SET UP FOR WTOR             20071 04574020
CCONE    EQU   *                                                  20071 04575020
         OI    CCBITS,BA7          SET BIT TO 1 FOR CC=1          20071 04576020
TODWTOR1 EQU   *                                                  20071 04577020
         TM    CCBITS,HEX03        WAS CC=0 (CLOCK IS SET WITH    M1866 04577220
*                                  YEAR 2000 OR MORE)             M1866 04577420
         BZ    CCONE               CHANGE CCBITS TO CC=1          M1866 04577620
         LA    R1,TODMSG1          PUT MSG ADDR IN REG1 FOR WTOR  20071 04578020
         B     SETWTOR             GO SET UP FOR WTOR,TOD INVALID 20071 04579020
CCZERO   EQU   *                                                  20071 04580020
         NI    CCBITS,HEX00        INDICATE CC=0 (BITS=00)        20071 04581020
*********************************************************************** 04582020
*                                                                     * 04583020
*                 TOD CLOCK CONVERSION ROUTINE                    20071 04584020
*                                                                     * 04585020
*********************************************************************** 04586020
* NOTES-                                                          20071 04587020
*                                                                     * 04588020
*    THE TOD CLOCK IS A DOUBLE WORD WHOSE HIGH-ORDER WORD IS      20071 04589020
*    VALID TO 1.048576 MICRO SECONDS.  TO CALCULATE THE EXACT     20071 04590020
*    NUMBER OF SECONDS, THE NUMBER OF MICRO SECONDS IN THE HIGH   20071 04591020
*    ORDER WORD IS MULTIPLIED BY 16384 AND DIVIDED BY 15625. THIS 20071 04592020
*    IS THE SAME AS MULIIPLYING BY 1.048576, BUT ELIMINATES THE   20071 04593020
*    DECIMAL POINT.                                               20071 04594020
*    THE CONSTANTS, 16384 AND 15625 ARE ALSO USED BY IEE6503D,    20071 04595020
*    AND THERE WILL BE A TIME DISCREPANCY IF THEY ARE UPDATED IN  20071 04596020
*    ONE MODULE AND NOT THE OTHER.                                20071 04597020
*    THE TOD CLOCK STARTS AT JAN 1,1960 AND RUNS FOR 142 YEARS.   20071 04598020
*    HOWEVER, THIS ROUTINE DOES NOT RECOGNIZE ANY YEAR OVER 1999  20071 04599020
*    AS VALID. ANY YEAR GREATER THAN 1999 WILL BE TREATED AS IF   M1866 04599620
*    THE CONDITION CODE FROM THE STORE CLOCK(STCK) HAD BEEN = 1.  M1866 04600220
*********************************************************************** 04601020
CONVERT  EQU   *                                                  20071 04602020
         L     R7,TIMEAREA         LOAD HIGH ORDER WORD OF TOD    20071 04603020
*                                  CLOCK-VALID TO 1.048576 MIC SEC20071 04604020
         CL    R7,YR2000           IS TOD GT JAN 1,2000           M5381 04604420
         BNL   TODWTOR1            YES,ERROR. TOD INVALID         M5381 04604820
         M     R6,D16384           TOD VALUE MULT BY DEC 16384    20071 04605020
         D     R6,D15625           DIVIDE BY DECIMAL 15625 FOR    20071 04606020
*                                  NUMBER OF SECONDS IN TOD CLOCK 20071 04607020
         XR    R6,R6               CLEAR REMAINDER REG            20071 04610020
         D     R6,D86400           DIV BY SEC PER DAY TO GET DAYS 20071 04611020
         LR    R4,R6               SAVE CONTENTS-REM=HH.MM.SS     20071 04612020
         C     R7,D366             IS NO. DAYS LESS THAN 366      20071 04613020
         BL    LOWYEAR             YES. YEAR IS 1960              20071 04614020
         S     R7,D366             SUBTRACT 366 FROM NO. DAYS     20071 04615020
         XR    R6,R6               ZERO REMAINDER REG             20071 04616020
         D     R6,D1461            DIV NO.DAYS LEFT BY NO.DAYS    20071 04617020
*                                  IN 4 YEARS- COUNTS LEAP YEAR   20071 04618020
         LR    R5,R7               SAVE NO. 4 YEAR BLOCKS         20071 04619020
         C     R6,D1460            CK FOR LAST DAY OF LEAP YEAR  A52614 04619421
         BNE   NOTLAST             BRANCH IF NO                  A52614 04619821
         LA    R7,N3               SET QUOTIENT TO 3 YEARS       A52614 04619921
         L     R6,D365             SET REMAINDER TO 365 DAYS     A52614 04622421
         B     LASTDAY             GO TO FIGURE LAST DAY OF LEAP A52614 04624421
N3       EQU   3                                                 A52614 04626421
NOTLAST  EQU   *                                                 A52614 04628421
         SRDL  R6,BITS32           MOVE EVEN REG TO ODD REG       20071 04630021
         D     R6,D365             GET NO. YRS SINCE LEAP YEAR    20071 04632521
LASTDAY EQU   *                                                  A52614 04634421
         LA    R7,SIXTY(R7)        ADD NO. YEARS SINCE LEAP YEAR  20071 04635021
*                                  TO 1960(FIRST YEAR OF CLOCK)   20071 04637521
         SLL   R5,K2               NO. OF YEARS = NO. OF FOUR     20071 04640021
*                                  YEAR BLOCKS TIMES FOUR         20071 04642521
         AR    R7,R5               ADD NO. OF 4 YEAR BLKS TO (60+ 20071 04645021
*                                  NO. OF YEARS SINCE LEAP YEAR   20071 04647521
*   NOTE- IT IS NECESSARY TO ADD 1,BECAUSE THE CLOCK STARTS AT 0  20071 04650021
*         ON JAN 1,1960, BUT WE REFER TO THAT DAY AS DAY 1.       20071 04652521
         LA    R7,K1(R7)           ADD ONE. TOTAL= CURRENT YEAR   20071 04655021
         LA    R6,K1(R6)           ADD ONE. TOTAL= CURRENT DAY    20071 04657521
         MH    R7,TEN              SET UP YEAR FOR CVD            20071 04660021
         CVD   R7,DOUBLE           MAKE YEAR PACKED DECIMAL       20071 04662521
         UNPK  YDATE(K3),DOUBLE+K6(K2)  UNPACK YEAR (YY)          20071 04665021
         MH    R6,TEN              SET UP FOR CVD                 20071 04667521
         CVD   R6,DOUBLE           MAKE DAY PACKED DECIMAL        20071 04670021
         B     SETDAY              GO PUT DDD IN BUFFER           20071 04672521
LOWYEAR  EQU   *                                                  20071 04675021
         MVC   YDATE(K2),D60       YEAR IS 1960                   20071 04677521
         LA    R7,K1(R7)           ADD ONE DAY FOR LEAP YEAR      20071 04680021
         MH    R7,TEN              SET UP DAY FOR CVD             20071 04682521
         CVD   R7,DOUBLE           MAKE DAY PACKED DECIMAL        20071 04685021
SETDAY   EQU   *                                                  20071 04687521
         UNPK  DDATE(K4),DOUBLE+K5(K3)  UNPACK DAY (DDD)          20071 04690021
         MVI   YDATE+K2,DOT         SET UP FOR COMMAND (YY.DDD)   20071 04692521
         LR    R7,R4                GET HOURS, MIN, SEC           20071 04695021
         XR    R6,R6                ZERO REMAINDER REG            20071 04697521
         D     R6,D3600             DIVIDE BY NO.SEC PER HOUR     20071 04700021
         MH    R7,TEN               SET UP HOURS FOR CVD          20071 04702521
         CVD   R7,DOUBLE            MAKE HOURS PACKED DECIMAL     20071 04705021
         UNPK  HTIME(K3),DOUBLE+K6(K2)  UNPACK HOURS (HH)         20071 04707521
         MVI   HTIME+K2,DOT         SET UP FOR COMMAND (HH.MM.SS) 20071 04710021
         SRDL  R6,BITS32            MOVE MIN AND SEC INTO ODD REG 20071 04712521
         XR    R6,R6                ZERO REMAINDER REG            20071 04715021
         D     R6,F60               DIVIDE BY NO. SEC PER MINUTE  20071 04717521
         MH    R7,TEN               SET UP MINUTES FOR CVD        20071 04720021
         CVD   R7,DOUBLE            MAKE MINUTES PACKED DECIMAL   20071 04722521
         UNPK  MTIME(K3),DOUBLE+K6(K2) UNPACK MINUTES (MM)        20071 04725021
         MVI   MTIME+K2,DOT         SET UP FOR COMMAND (HH.MM.SS) 20071 04727521
         MH    R6,TEN               SET UP SECONDS FOR CVD        20071 04730021
         CVD   R6,DOUBLE            MAKE SECONDS PACKED DECIMAL   20071 04732521
         UNPK  STIME(K3),DOUBLE+K6(K2)  UNPACK SECONDS (SS)       20071 04735021
TODWTOR2 EQU   *                                                  20071 04737521
         LA    R1,TODMSG2          GET ADDR OF WTOR MSG           20071 04740021
         MVC   MSGCHNG+K13(K6),YDATE PUT CURRENT TOD DATE IN MSG  20071 04742521
         MVC   MSGCHNG+K26(K8),HTIME PUT CURRENT TOD TIME IN MSG  20071 04745021
SETWTOR  EQU   *                                                  20071 04747521
         MVI   TODREPLY,BLANK      PUT BLANK IN FIRST BYTE        20071 04750021
         MVC   TODREPLY+K1(K119),TODREPLY  CLEAR REPLY AREA       20071 04752521
         MVI   TODECB,HEX00        CLEAR ECB FOR TOD MSG WTOR     20071 04755021
         WTOR  ,TODREPLY,120,TODECB,MF=(E,(1))   ISSUE WTOR       20071 04757521
         WAIT  ECB=TODECB          WAIT FOR OPERATOR'S REPLY      20071 04760021
         LA    R5,TODREPLY         GET ADDR OF REPLY              20071 04762521
         CLC   K0(K2,R5),U         YES. WAS REPLY 'U'             20071 04765021
         BNE   DATECHK             NO. SEE IF DATE WAS SPECIFIED  20071 04767521
         TM    CCBITS,HEX03        WAS YHE CC=0                   20071 04770021
         BNZ   SETUP               NO, GO ISSUE SET COMMAND       20071 04772521
         MVC   TODREPLY(K5),DATE   MOVE 'DATE=' INTO BUFFER       20071 04775021
         MVC   TODREPLY+K5(K6),YDATE  MOVE YY.DDD INTO BUFFER     20071 04777521
         B     NOSET               GO SET NO SET BIT              20071 04780021
DATECHK  EQU   *                                                  20071 04782521
         CLC   K0(K5,R5),DATE      WAS 'DATE=' SPECIFIED          20071 04785021
         BE    TIMECHK             YES. CHECK FOR 'CLOCK='        20071 04787521
         CLC   K0(K5,R5),LOWCASE1  WAS IT LOWER CASE 'DATE='      M1866 04790021
         BE    TIMECHK             YES. CHECK FOR 'CLOCK='        M1866 04792521
         LA    R5,K1(R5)           NO. POINT TO NEXT CHAR         20071 04795021
         CLI   K0(R5),BLANK        IS CHAR BLANK(END OF COMMAND)  20071 04797521
         BNE   DATECHK             NO. CHECK FOR 'DATE=' AGAIN    20071 04800021
         TM    CCBITS,HEX03        IS CC=0                        20071 04802521
         BNZ   SETUP               NO. ERROR. PASS CMND AS IS     20071 04805021
         MVC   K0(K6,R5),COMDATE   YES. ADD 'DATE=' TO PARAMS     20071 04807521
         MVC   K6(K6,R5),YDATE     DATE=TOD DATE FOR SET COMMAND  20071 04810021
         LA    R5,K1(R5)           ADD 1 SO REG POINTS TO 'DATE=' 20071 04812521
TIMECHK  EQU   *                                                  20071 04815021
         LR    R6,R5               SAVE POINTER TO 'DATE='        20071 04817521
         LA    R5,TODREPLY         POINT TO START OF REPLY        20071 04820021
TIMECHK2 EQU   *                                                  20071 04822521
         CLC   K0(K6,R5),CLOCK     WAS 'CLOCK=' SPECIFIED         20071 04825021
         BE    SETUP               'DATE=', 'CLOCK=' SPECIFIED    20071 04827521
         CLC   K0(K6,R5),LOWCASE2  WAS IT LOWER CASE 'CLOCK='     M1866 04830021
         BE    SETUP               YES. GO ISSUE COMMAND          M1866 04832521
         LA    R5,K1(R5)           POINT TO NEXT CHAR             20071 04835021
         CLI   K0(R5),BLANK        IS CHARACTER BLANK(END OF CMND)20071 04837521
         BNE   TIMECHK2            NO. CHECK FOR 'CLOCK='         20071 04840021
         LR    R1,R5               TEMP SAVE PTR TO COMMAND END   20071 04842521
         TM    CCBITS,HEX03        WHAT IS COND CODE FROM STCK    20071 04845021
         BZ    DATECHK2            CC=0. SEE IF TOD DATE=REPLY    20071 04847521
*                                  DATE. IF YES,TOD WONT BE SET   20071 04850021
         MVC   K0(K15,R5),COMCLOCK CC NOT 0- CLOCK=00.00.00       M1866 04852521
         B     SETUP               GO ISSUE SET COMMAND           20071 04855021
DATECHK2 EQU   *                                                  20071 04857521
         CLC   K5(K6,R6),YDATE     IS REPLY DATE=TOD DATE         20071 04860021
         BNE   SETUP               NO. GO ISSUE SET COMMAND       20071 04862521
NOSET    EQU   *                                                  20071 04865021
         OI    BASFL,BANOSET       TURN ON NO SET BIT             20071 04867521
SETUP    EQU   *                                                  20071 04870021
         XR    R0,R0               ZERO REG0- INDICATE SYSTEM     20071 04872521
*                                  COMMAND FOR SVC 34             20071 04875021
         OI    BASFL,BAINTSET      TURN ON INTERNAL SET BIT       20071 04877521
         XC    BAIPL,BAIPL         CLEAR RETURN CODE ECB          20071 04880021
         MGCR  TODBUF                                             20071 04882521
         CLI   BAIPL+K3,K8         WAS SET COMMAND OK (IF NOT,    20071 04885021
*                                  RET CODE PASSED IN ECB)        20071 04887521
         BE    IP308               NO.  CLOCK COULD NOT BE SET. GO20071 04890021
*                                  BACK AND REISSUE TOD MESSAGE   20071 04892521
         B     ENDIPL              SET COMMAND OK. IPL OVER       20071 04895021
NOTOD    EQU   *                                                  20071 04897521
         WAIT  ECB=BAIPL                                                04900000
ENDIPL   EQU   *                                                  20071 04905020
         OI    BASFL,BAIN          TURN ON 'NO IPL' BIT           20071 04910020
         EJECT                                                     AABA 04915016
*******************************************************************AABA 04920016
*                                                                  AABA 04925016
*  THE FOLLOWING DETERMINES THE LOCATION OF SYS1.SYSJOBQE AND      AABA 04930016
*  SYS1.PROCLIB AND VERIFIES THAT THE DATA SET EXISTS ON THE INDICAAABA 04935016
*  UNIT.                                                           AABA 04940016
*                                                                  AABA 04945016
*  THE FOLLOWING POSSIBILITIES EXIST:                              AABA 04950016
*                                                                  AABA 04955016
*      1) THE UNIT WAS SPECIFIED IN THE SET COMMAND                AABA 04960016
*            A)LOCATIONS BAQ AND/OR BAPRC WILL NOT BE ZERO         AABA 04965016
*      2) THE DATA SET IS CATALOGUED                               AABA 04970016
*      3) SYSGEN VALUES ARE USED                                   AABA 04975016
*      4) THE IPL VOLUME CONTAINS THE DATA SET                     AABA 04980016
*                                                                  AABA 04985016
*  THE FOLLOWING ERRORS ARE POSSIBLE:                              AABA 04990016
*                                                                  AABA 04995016
*      1) THE VOLUME INDICATED BY THE CATALOGUE IS NOT MOUNTED     AABA 05000016
*      2) THE SELECTED VOLUME DOES NOT CONTAIN THE DATA SET        AABA 05005016
*                                                                  AABA 05010016
*  WHEN THE LOCATION OF SYS1.PROCLIB IS ASCERTAINED,THE DATA SET WIAABA 05015016
*  BE RECATALOGUED                                                 AABA 05020016
*                                                                  AABA 05025016
*********************************************************************** 05030016
IP325    DS    0H                                                  AABA 05035016
* GETMAIN AND SET UP WORKAREA FOR LOCATE AND OBTAIN MACROS         AABA 05040016
         GETMAIN R,LV=IPWKEND,SP=255                               AABA 05045016
         LR    R4,R1               WORKAREA ADDRESS TO R4          AABA 05050016
         USING IPWKST,R4           ADDRESSABILTY                   AABA 05055016
         MVI   DSNAREA,X'40'       BLANK DATA SET NAME AREA        AABA 05060016
         MVC   DSNAREA+1(43),DSNAREA                               AABA 05065016
* SET UP PARAMETER LIST                                            AABA 05070016
         ST    R4,PARM4            ADDRESS OF WORKAREA             AABA 05075016
         LA    R1,DSNAREA          ADDRESS OF DATA SET NAME AREA   AABA 05080016
         ST    R1,PARM2                                            AABA 05085016
* SET UP TO VERIFY THE LOCATION OF SYS1.SYSJOBQE                   AABA 05090016
         MVC   IP400WKR(6),BLNKS   BLANK WORK AREA                 AABA 05095016
         MVC   DSNAREA(14),JOBQDSN JOBQ DATA SET NAME TO PARAMETR  AABA 05100016
         TM    BAQ,X'FF'           UNIT NAME SPECIFIED ON SET COMMAAABA 05105016
*                                  FOR SYS1.SYSJOBQE               AABA 05110016
         BC    7,IP340             BRANCH IF Q UNITNAME SPECIFIED  AABA 05115016
         BAL   R9,IP350      IF NOT SPECIFIED IN SET COMMAND,      OC43 05120017
*                                  GO TO SEARCH CATALOG FOR DATA SEAABA 05125016
* UPON RETURN, UCB ADDRESS OF THE UNIT CONTAINING JOBQ IS CONTAINEDAABA 05130016
* IN R1                                                            AABA 05135016
IP327    DS    0H                                                  AABA 05140016
         USING UCBOB,R6                                           *AABA 05141016
         OI    SRTESTAT,SRTEPRES   SET VOLUME PERM. RES.          *AABA 05142016
         ST    R6,BAQ              SAVE JOBQ UCB ADDRESS           AABA 05145016
* DETERMINE AND VERIFY THE LOCATION OF SYS1.PROCLIB                AABA 05150016
         MVC   IP400WKR(6),BLNKS   BLANK WORK AREA                 AABA 05155016
IP330    DS    0H                                                  AABA 05160016
         MVC   DSNAREA(14),PROCDSN PROC3IB DATA SET NAME TO PARM ARAABA 05165016
         TM    BAPRC,X'FF'         PROCLIB UNIT NAME SPECIFIED     AABA 05170016
         BC    7,IP345             BRANCH IF UNIT NAME SPECIFIED   AABA 05175016
         BAL   R9,IP350      IF NOT SPECIFIED,BRANCH TO LOCATE     OC43 05180017
* UPON RETURN, UCB ADDRESS OF THE UNIT CONTAINING THE PROCEDURE    AABA 05185016
* LIBRARY IS CONTAINED IN R1                                       AABA 05190016
IP333    DS    0H                                                  AABA 05195016
         OI    SRTESTAT,SRTEPRES   SET VOLUME PERM. RES.          *AABA 05196016
         DROP  R6                                                 *AABA 05197016
         ST    R6,BAPRC            SAVE PROC UCB ADDRESS           AABA 05200016
         B     IP500               BRANCH TO NEXT PHASE            AABA 05205016
* Q UNIT NAME SPECIFIED IN SET COMMAND                             AABA 05210016
IP340    DS    0H                  ALIGNMENT                       AABA 05215016
         MVC   IP400WKR(3),BAQ     UNIT NAME TO WORKAREA           AABA 05220016
         LA    R9,IP327            RETURN ADDRESS                  OC43 05225017
IP343    MVI   IP400SW,BIT0        INDICATE SEARCH ON UNIT NAME    AABA 05230016
         BAL   R3,IP400            GO TO UCB SEARCH ROUTINE        AABA 05235016
         B     IP413               UCBNAME NOT VERIFIED            AABA 05240016
         B     IP360               BRANCH TO OBTAIN ROUTINE        AABA 05245016
* PROC UNIT NAME SPECIFIED IN SET COMMAND                          AABA 05250016
IP345    DS    0H                                                  AABA 05255016
         MVC   IP400WKR(3),BAPRC   UNIT NAME TO WORK AREA          AABA 05260016
         CLI   BAPRC+3,C' '        IS 2321 INDICATED               AABA 05265016
         BE    IP346               NO,BRANCH                       AABA 05270016
         MVI   IP400WKR+3,C'/'     SLASH TO WORKAREA               AABA 05275016
         MVC   IP400WKR+4(1),BAPRC+3 BIN NUMBER TO WORK AREA       AABA 05280016
         CLI   IP400WKR+4,X'F0'    IS BIN NUMBER VALID             AABA 05285016
         BL    IP413               NO,ERROR                        AABA 05290016
IP346    DS    0H                                                  AABA 05295016
         LA    R9,IP333            RETURN ADDRESS                  OC43 05300017
         B     IP343               BRANCH                          AANA 05305016
* ISSUE LOCATE FOR REQUIRED DATA SET                               AABA 05310016
IP350    DS    0H                  ALIGNMENT                       AABA 05315016
         MVC   PARM1(4),LOCCNTRL   LOCATE CONTROL BYTE             AABA 05320016
         XC    PARM3(4),PARM3      ZERO PARM3 FOR LOCATE           AABA 05325016
         LA    R1,PARM1            INDICATE PARAMETER AREA         AABA 05330016
*                                                                  AABA 05335016
         LOCATE (1)                                                AABA 05340016
*                                                                  AABA 05345016
         LTR   R15,R15             WAS LOCATE SUCCESSFUL           AABA 05350016
         BC    7,IP370             NO,BRANCH DATA SET NOT CATALOGEDAABA 05355016
         MVC   VOLSRAR(6),VCBVOLSN MOVE VOLUME SERIAL TO WORK AREA AABA 05360016
         MVI   IP400SW,BIT1        INDICATE SEARCH FOR VOL SERIAL  AABA 05365016
         BAL   R3,IP400            DETERMINE IF VOLUME MOUNTED     AABA 05370016
         B     IP380               VOLUME NOT MOUNTED,BRANCH       AABA 05375016
* VOLUME HAS BEEN SELECTED,DETERMINE IF DATA SET EXISTS ON VOLUME  AABA 05380016
IP360    DS    0H                  NORMAL RETURN FROM ABOVE AND    AABA 05385016
*                                  ENTRY TO OBTAIN ROUTINE         AABA 05390016
         LA    R1,VOLSRAR          ADDRESS OF VOLUME SERIAL FOR    AABA 05395016
         ST    R1,PARM3            OBTAIN TO WORK AREA             AABA 05400016
         MVC   PARM1(4),OBTCNTRL   OBTAIN CONTROL BYTE             AABA 05405016
         LA    R1,PARM1            INDICATE PARAMETERS             AABA 05410016
*                                                                  AABA 05415016
         OBTAIN (1)                                                AABA 05420016
*                                                                  AABA 05425016
         LTR   R15,R15             WAS OBTAIN SUCCESSFUL           AABA 05430016
         BC    7,IP390             OBTAIN FAILED, BRANCH           AABA 05435016
         BR    R9                  RETURN                          OC43 05440017
* LOCATE FAILED  DETERMINE VOLUME BY LOOKING AT SYSGEN VALUE FOR   AABA 05445016
* DATA SET OR IPL VOLUME IF NO SYSGEN VALUE WAS SPECIFIED          AABA 05450016
IP370    DS    0H                                                  AABA 05455016
         CLC   DSNAREA(7),JOBQDSN  IS SEARCH FOR JOBQ DEVICE       AABA 05460016
         BE    IP372               YES,BRANCH                      AABA 05465016
         CLI   IPSGPL,C' '         SYSGEN VALUE FOR PROCLIB        AABA 05470016
         BE    IP375               NO,SEARCH FOR IPL VOLUME        AABA 05475016
         MVC   IP400WKR(5),IPSGPL  PROCLIB UNITNAME FOR UCB SRCH   AABA 05480016
IP371    DS    0H                                                  AABA 05485016
         MVI   IP400SW,BIT0        INDICATE SEARCH ON UNIT NAME    AABA 05490016
IP371A   BAL   R3,IP400            BRANCH TO UCB SEARCH            AABA 05495016
         USING UCBOB,R6                                            AABA 05500016
         B     IP413               ERROR,NOT VERIFIED              AABA 05505016
IP371B   DS    0H                                                  AABA 05510016
         MVC   VOLSRAR(6),SRTEVOLI VOLUME SERIAL TO WORKAREA       AABA 05515016
         B     IP360               BRANCH TO OBTAIN ROUTINE        AABA 05520016
IP372    DS    0H                  SEARCH IS FOR JOBQ DEVICE       AABA 05525016
         CLI   IPSGJQ,C' '         SYSGEN VALUE FOR JOBQ DEVICE    AABA 05530016
         BE    IP375               NO,SEARCH FOR IPL VOLUME        AABA 05535016
         MVC   IP400WKR(3),IPSGJQ  PROCLIB UNIT ADDRESS FOR UCB SEARCH  05540016
         B     IP371               GO TO SEARCH ROUTINE            AABA 05545016
* SYSGEN VALUES NOT SPECIFIED,SEARCH FOR IPL VOLUME                AABA 05550016
IP375    DS    0H                                                  AABA 05555016
         L     R6,CVTSYSAD         LOAD UCB ADDRESS OF IPL VOLUME  AABA 05560016
         LR    R5,R6               R5,ADDRESS OF IPL VOLUME UCB    AABA 05565016
         MVC   IP394(3),UCBNAME    UCB NAME TO MESSAGE AREA        AABA 05570016
         B     IP371B              CONTINUE                        AABA 05575016
* THE VOLUME INDICATED BY THE CATALOGUE IS NOT MOUNTED             AABA 05580016
IP380    DS    0H                                                  AABA 05585016
         LA    R1,IP381            ADDRESS OF MESSAGE              AABA 05590016
         MVC   IP383(14),DSNAREA   DATA SET NAME TO MESSAGE        AABA 05595016
         MVC   IP382(6),VOLSRAR    VOLUME SERIAL TO MESSAGE        AABA 05600016
         B     IP380390            BRANCH TO WRITE                 AABA 05605016
* REQUIRED DATA SET NOT FOUND ON SELECTED VOLUME                   AABA 05610016
IP390    DS    0H                                                  AABA 05615016
         LA    R1,IP391            ADDRESS OF MESSAGE              AABA 05620016
         MVC   IP392(14),DSNAREA   DATA SET NAME TO                AABA 05625016
         MVC   IP393(6),VOLSRAR    VOLUME SERIAL TO MESSAGE        AABA 05630016
IP380390 DS    0H                                                  AABA 05635016
         WTO   MF=(E,(1))          *                               AABA 05640016
         B     IP450               FREE CORE                       AABA 05645016
**********************************************************************  05650016
*                                                                  AABA 05655016
* UCB SEARCH:                                                      AABA 05660016
*                                                                  AABA 05665016
*        IP400SW INDICATES THE TYPE OF SEARCH TO MAKE              AABA 05670016
*              BIT0=UNITNAME                                       AABA 05675016
*              BIT1=VOLUME SERIAL NUMBER                           AABA 05680016
*              BIT2=IPL VOLUME                                     AABA 05685016
*        IP400WKR CONTAINS 3 OR 5 BYTE UCB NAME                    AABA 05690016
*        VOLSRAR CONTAINS THE VOLUME SERIAL NUMBER                 AABA 05695016
*                                                                  AABA 05700016
*        NORMAL EXIT                                               AABA 05705016
*              R6 CONTAINS UCB ADDRESS                             AABA 05710016
*              BRANCH R3                                           AABA 05715016
*                                                                  AABA 05720016
**********************************************************************  05725016
IP400    DS    0H                                                  AABA 05730016
         L     R7,CVTILK2          SRT TABLE ADDRESS               AABA 05735016
IP401    LH    R6,0(R7)            UCB ADDRESS                     AABA 05740016
         LTR   R6,R6               HOLE IN TABLE                   AABA 05745016
         BZ    IP403               YES,BRANCH TO GET NEXT ADDRESS  AABA 05750016
         N     R6,CF0F             ZERO HIGH ORDER BITS            AABA 05755016
         CL    R6,CF0F             END OF UCB LIST                 AABA 05760016
         BNE   IP404               BRANCH TO CHECK UCB             AABA 05765016
IP402    BR    R3                  END OF UCB LIST ZND NOT FOUND   AABA 05770016
*                                  ERROR RETURN                    AABA 05775016
IP403    LA    R7,2(R7)            INCREMENT TO NEXT ENTRY         AABA 05780016
         B     IP401               CHECK ENTRY                     AABA 05785016
IP404    MVC   IP394(3),UCBNAME    SAVE UNIT NAME                  AABA 05790016
         USING UCBOB,R6                                            AABA 05795016
         TM    IP400SW,BIT0        SEARCH ON UCB NAME              AABA 05800016
         BO    IP407               YES,BRANCH                      AABA 05805016
IP405    DS    0H                  SEARCH ON VOLUME SERIAL         AABA 05810016
         LR    R5,R6               MAIN UCB ADDRESS TO R5          AABA 05815016
         CLC   SRTEVOLI(6),VOLSRAR VOLUME SERIALS MATCH            AABA 05820016
         BE    4(R3)               YES,RETURN                      AABA 05825016
         CLC   UCBTYP+2(2),TYPE2321 IS DEVICE A 2321               AABA 05830016
         BNE   IP403               NO GET NEXT UCB                 AABA 05835016
         LA    R1,10(0,0)          LOOP CONTROL                    AABA 05840016
         LA    R6,DATACELL-UCBOB(0,R6) INCREMENT TO SUB UCBS       AABA 05845016
IP406    DS    0H                                                  AABA 05850016
         USING DATACELL,R6                                         AABA 05855016
         CLC   DCELVOLI(6),VOLSRAR VOLUME SERIALS MATCH            AABA 05860016
         BE    4(R3)               YES,RETURN                      AABA 05865016
         LA    R6,16(R6,0)         INCREMENT TO NEXT SUB UCB       AABA 05870016
         BCT   R1,IP406                                            AABA 05875016
         B     IP403               CESSED;GET NEXT UCB             AABA 05880016
IP407    DS    0H                  SEARCH ON UNITNAME              AABA 05885016
         USING UCBOB,R5                                            AABA 05890016
         LR    R5,R6               ADDRESS OF MAIN UCB TO R5       AABA 05895016
         CLC   UCBNAME(3),IP400WKR UCB NAMES MATCH                 AABA 05900016
         BNE   IP403               NO,GET NEXT UCB                 AABA 05905016
         CLI   IP400WKR+3,C'/'     IS 2321 SPECIFIED               AABA 05910016
         BE    IP408               YES,BRANCH                      AABA 05915016
         CLC   UCBTYP+2(2),TYPE2321 IS IT 2321                     AABA 05920016
         BE    IP413               YES,ERROR                       AABA 05925016
         OC    SRTEVOLI,SRTEVOLI   VOLUME READY                    AABA 05930016
         BZ    IP413               NO,BRANCH                       AABA 05935016
         MVC   VOLSRAR(6),SRTEVOLI VOLUME SERIAL TO WORKAREA       AABA 05940016
         B     4(R3)               RETURN                          AABA 05945016
IP408    DS    0H                                                  AABA 05950016
         CLC   UCBTYP+2(2),TYPE2321 IS IT 2321                     AABA 05955016
         BNE   0(R3)               NO,ERROR                        AABA 05960016
IP409    DS    0H                                                  AABA 05965016
         IC    R6,IP400WKR+4       BIN NUMBER                      AABA 05970016
         N     R6,CF00F            ZERO ZONE AND THREE HIGH BYTES  AABA 05975016
         SLL   R6,4                TIMES 16                        AABA 05980016
         LA    R6,DATACELL-UCBOB(R5,R6) INCREMENT TO SUB UCB       AABA 05985016
         OC    DCELVOLI,DCELVOLI   DEVICE READY                    AABA 05990016
         BZ    IP413               NO,BRANCH                       AABA 05995016
         MVC   VOLSRAR(6),DCELVOLI VOLUME SERIAL TO WORKAREA       AABA 06000016
         B     4(R3)               NORMAL RETURN                   AABA 06005016
*                                                                  AABA 06010016
IP413    EQU   *                                                        06040000
         DROP  R10                                                      06060000
         USING XSA,R2                                                   06080000
         LA    R2,IPXSA                      SETUP MSG TO PRINT         06100000
         MVI   XAV,X'40'                     BLANK VERB AREA            06120000
         MVC   XAV+1(7),XAV                                             06140000
         MVI   XAR,X'0D'                     INSERT MSG NO              06160000
         MVC   XAV(5),IP400WKR     INSERT INVALID UNIT REF         AABA 06170016
         MVC   XAJ(TWO),HALFZERO   CLEAR OUT TJID FIELD           M5510 06180020
IP455    EQU   *                                                        06195013
         LA    R14,IP449           RETURN POINT                    AABA 06203016
         ST    R4,MAINSVE          SAVE ADDRESS OF GOTTEN AREA     AABA 06211016
         LINK  EP=IEE0503D                   GO PRINT MSG -RETURN TO    06220000
IP449    L     R4,MAINSVE          RESTORE GOTTEN CORE POINTER     AABA 06230016
IP450    NI    BASFL,255-BAIN               ZERO IPL FLAG               06240000
         LR    R1,R4               ADDRESS OF AREA TO FREE         AABA 06246016
         FREEMAIN R,SP=255,LV=IPWKEND,A=(1)                        AABA 06252016
         B     IP540                                              M1874 06260021
         DROP  R6                                                  AABA 06266016
         USING UCBOB,R5                                            AABA 06272016
         DROP  R2                                                       06280000
*********************************************************************** 06300000
*             CATALOG SYS1.PROCLIB                                      06310014
*             FILL IN TIOT WITH THE UCB ADDRESSES FOR JOB QUEUE AND     06320000
*              PROCLIB BEFORE GOING TO IEFQINTZ TO INITIALIZE           06340000
*              JOB QUEUE                                                06360000
*********************************************************************** 06380000
*                                                                       06400000
IP500    EQU   *                                                        06420000
         LR    R1,R4               ADDRESS OF AREA TO FREE         AABA 06420316
         FREEMAIN R,SP=255,LV=IPWKEND,A=(1)                        AABA 06420616
         MVC   IPDEVTYP(4),UCBTYP  DEVICE TYPE                          06421014
         NI    IPDEVTYP+1,X'FE'                                  S21167 06421121
         DROP  R5                                                 *AABA 06421316
         USING UCBOB,R6                                           *AABA 06421616
         CLI   UCBID,X'FF'         IS THIS MAIN UCB                     06422014
         BNE   IP510               YES                                  06423014
         MVC   IPVOLSER(6),SRTEVOLI VOLUME SER NO                       06424014
         B     IP515                                                    06425014
IP510    EQU   *                                                        06426014
         MVC   IPVOLSER(6),DCELVOLI-DATACELL(R6) VOLUME SERIAL     AABA 06427016
         DROP  R6                                                 *AABA 06428016
IP515    EQU   *                                                        06429014
         CATALOG IPCAT             CATALOG DATA SET                     06430014
         C     R15,CB08            IS RETURN CODE 8                     06431014
         BNE   IP517               NO. CONTINUE                         06432014
         CLI   IPCAT,CAT           IS THIS SECOND FAILURE               06432314
         BE    IP516              YES-ERROR EXIT                 A31761 06432620
         MVI   IPCAT,CAT           INDICATE CATALOG                     06433014
         B     IP515               TRY CATALOG                          06434014
IP516    CVD   R15,WORK1          PREPARE TO PRINT RETURN CODE   A31761 06434120
         UNPK  WORK2(4),WORK1+FOUR(4) FROM CATALOG IN ERROR MSG  A31761 06434220
         OI    WORK2+THREE,FOXZERO   MAKE PRINTABLE LAST DIGIT   A31761 06434320
         MVC   NOIPLMSG+CODEDISP(2),WORK2+TWO  PUT RETURN CODE   A31761 06434420
*                                 INTO THE MESSAGE               A31761 06434520
NOIPLMSG WTO  'IEE139I INITIALIZATION FAILED  CODE=  ',ROUTCDE=2,DESC=4 06434620
         B     IP540                                             A31761 06434720
WORK1    DS    D        WORKAREA--USED TO PREPARE CATALOG RETURN A31761 06434820
WORK2    DS    F        CODE FOR ERROR MESSAGE                   A31761 06434920
IP517    EQU   *                                                        06435014
         LTR   R15,R15             TEST RETURN CODE                     06436014
         BNZ   IP516              ERROR EXIT                            06438020
         USING VTIOT,R10                                                06440000
         MVC   VJUCBPT+1(3),BAQ+1       INITIALIZE JQ TIOT UCB PTR      06460000
         MVC   VPUCBPT+1(3),BAPRC+1           PROC LB TIOT UCB PTR      06480000
*************************************************************** SA72193 06482021
*              INTERFACE WITH POWER WARNING                     SA72193 06484021
*************************************************************** SA72193 06486021
         DROP  R10                                              SA72193 06488021
         XC    IPQPAM(16),IPQPAM       ZERO PARM LIST           SA72193 06490021
         ST    R10,IPQPAM              PASS TIOT PTR            SA72193 06492021
         LA    R1,IPQPAM               SETUP PARM PTR           SA72193 06494021
         L     R15,VCONBIE0                                     SA72193 06496021
         BALR  R14,R15                                          SA72193 06498021
*                                                                       06500000
*********************************************************************** 06520000
*              QUEUE MANAGER TO INITIALIZE THE JOB QUEUE--              06540000
*              INTERFACE- R1 - POINTS TO 4 WORD PARAMETER LIST ON ENTRY 06560000
*                              .WORD 1 CONTAINS UCB ADDRESS FOR JOB Q   06580000
*                         R2 -CONTAINS THE ECB ADDRESS-BAIPL- FOR       06600000
*                            POSTING WAIT FROM IEFQINTZ AND THE         06620000
*                            RETURN CODE FROM THE QUEUE INITIALIZATION  06640000
*                              .ZERO -INITIALIZATION COMPLETE           06660000
*                              .NOTZERO=ERROR=NOT COMPLETE              06680000
*              ERROR DETECTION-FREES TIOT CORE,ZERO TIOT PTR IN TCB     06700000
*                              AND RETURNS TO MODULE BEGINNING TO TRY   06720000
*                              AGAIN                                    06740000
*                             -SUPPRESS AUTO STARTS IF QCR ERROR A31300 06746020
*                              OCCURRED DURING WARM START        A31300 06752020
*********************************************************************** 06760000
*                                                                       06780000
IP520    MVC   IPQPAM(4),BAQ            INIT JOB Q                      06820000
         MVC   IPQPAM(1),BACV        PICK UP Q FORMAT IND..             06840000
         AIF   ('&SMF' EQ '0').S1      IS SMF PRESENT                   06842018
         TM    BACV,X'80'              WARM START INDICATED         SMF 06844018
         BC    7,IP527                 NO                           SMF 06846018
         OI    SMFOPT+3,X'01'          YES, INDICATE IT             SMF 06848018
IP527    EQU   *                                                    SMF 06850018
.S1      ANOP                                                           06852018
IP530    LA    R1,IPQPAM                SETUP QM                        06860000
         XC    BAIPL,BAIPL            CLEAR ECB FOR ATTACH              06880000
         LA    R2,BAIPL            SETUP ECB ADDRESSIN R2               06900000
         ATTACH EP=IEFQINTZ,ECB=(2),MF=(E,(1)),SM=PROB,            I270X06910019
               JSTCB=YES,KEY=ZERO,SVAREA=NO,SZERO=NO,GIVEJPQ=NO    I270 06920019
         ST    R1,CB10          TEMP SAVE TCB OF SUBTASK                06940000
         WAIT  ECB=BAIPL          WAIT TO BE POSTED                     06960000
         LA    R1,CB10        RESET SUBTASK TCB TO DETACH               06980000
         DETACH  (1)                                                    07000000
         CLC   BAIPL+2(2),CF0F      TEST FOR ERROR-IS ECB ZERO          07020000
         BNE   IP540                   ERROR - FREE TIOT AND GO  A31300 07025020
*                                           TO BEGINNING AGAIN   A31300 07030020
         TM    IPQPAM,X'40'            QCR ERR DURING WARM START A31300 07035020
         BZ    IP560                   NO - CONTINUE             A31300 07040020
         MVI   CB8+1,C'Y'              YES - SUPPRESS AUTO START A31300 07045020
         MVC   CB8+2(6),CB8+1               COMMANDS             A31300 07050020
         B     IP560                   CONTINUE WITH NORMAL PATH A31300 07055020
IP540    EQU   *                                                        07060000
         L     R2,CVTTCBP                    LOCATE START ADDR TO FREE  07080000
         L     R2,4(R2)                   ADDR IN TCBTIO OF TCB         07100000
         L     R1,TCBTIO(R2)                                            07120000
         XR    R0,R0                         ZERO TCBTIO                07140000
         ST    R0,TCBTIO(R2)                                            07160000
         L     R0,CX108                                            LMCS 07165018
         AIF   ('&LCTR' EQ '0').SKIPLFR      IS LOG PRESENT        LMCS 07170018
         AL    R0,LOGTIOT              ADD LOG TIOT LENGTH         LMCS 07175018
.SKIPLFR ANOP                                                           07180018
         AIF   ('&SMF' EQ '0').S5      IS SMF PRESENT                   07185018
         AL    R0,SMFTIOT              ADD SMF TIOT SIZE            SMF 07190018
.S5      ANOP                                                           07195018
         AIF   ('&TSO' EQ '0').FREE    IS TSO PRESENT             20030 07196020
         AL    R0,SENDTIOT            ADD TIOT FOR SYS1.BRODCAST  20030 07197020
.FREE    ANOP                                                     20030 07198020
         FREEMAIN R,LV=(0),A=(1)                                        07200000
         B     IP100                                                    07220000
*                                                                       07240000
*             IEFPRES - TO INITIALIZE VOLUME ATTRIBUTES FOR ALL TAPE    07260000
*              AND DIRECT ACCESS DEVICES                                07280000
*             .INTERFACE - R1 - POINTS TO 4 WORD PARAMETER LIST ON      07300000
*                               ENTRY -WORD 1 CONTAINS THE UCB ADDRESS  07320000
*                               FOR SYS1.PROCLIB                        07340000
*                          R2 - CONTAINS THE ECB ADDRESS-BAIPL- FOR     07360000
*                               POSTING FROM ATTACHED TASK AND RETURN   07380000
*                               CODE                                    07400000
*                          R5 - CONTAINS TCB ADDR OF SUBTASK FOR DETACH 07420000
*                               PURPOSES                                07440000
*                                                                       07460000
*                                                                       07480000
IP560    EQU   *                                                        07500000
         XC    IPQPAM(16),IPQPAM   ZERO PARAM AREA                      07520000
         L     R2,PARMSAVE         GET PARMLIB UCB POINTER         OC43 07528017
         LTR   R2,R2               IS PARMLIB PRESENT              OC43 07536017
         BZ    IP600         NO, BYPASS VOLUME INITIALIZATION      OC43 07544017
         ST    R2,IPQPAM           SET UCB POINTER FOR PARMLIB     OC43 07552017
         LA    R1,IPQPAM           PASS ON PARAM LIST                   07560000
         XC    BAIPL(4),BAIPL      ZERO ECB                             07580000
         LA    R2,BAIPL            SETUP ECB ADDR                       07600000
*                                                                       07620000
         ATTACH EP=IEEPPRES,ECB=(2),MF=(E,(1)),SM=PROB,            I270X07630019
               JSTCB=YES,KEY=ZERO,SVAREA=NO,SZERO=NO,GIVEJPQ=NO    I270 07640019
         ST    R1,CB10        SAVE TCB ADDR OF ATTACHED TASK            07660000
         WAIT  ECB=BAIPL        WAIT TO BE POSTED                       07680000
         LA    R1,CB10        SET TO DETACH                             07700000
         DETACH (1)                                                     07720000
         CLC   BAIPL+2(2),CF0F  RETURN CODE ZERO                        07740000
         BE    IP600          BCH ON ZERO                               07760000
         B     IP540          ERROR- FREE TIOT AND REINITIALIZE         07780000
*********************************************************************** 07800000
*                                                                       07802020
*              ISSUE SVC 76 TO WRITE IPL RECORD TO SYS1.LOGREC.   20070 07804020
*              IF RELIABILITY DATA EXTRACTOR (RDE) IS NOT         20070 07806020
*              SYSGENED, NO RECORD IS WRITTEN AND RETURN          20070 07808020
*              IS MADE TO THIS ROUTINE.                           20070 07810020
*                                                                       07812020
*              SETUP TO WRITE AND EXECUTE CANNED COMMANDS PROVIDING     07820000
*              NO STOPS WERE GIVEN                                      07840000
*              .FLAG=FF MGCR IF NECESSARY                               07860000
*********************************************************************** 07880000
*                                                                       07900000
IP600    EQU   *                                                        07920000
         L     R0,CB08                 INDICATE IPL ENTRY         20070 07926020
         SVC   STATUS                  GO WRITE IPL RECORD        20070 07932020
         MVI   CB1,X'FF'               FLAG-FF=EXECUTE MGCR             07940000
         LA    R9,IP800                                            OC43 07960017
*********************************************************************** 08000000
*              WRITE AND/OR EXECUTE COMMANDS FOR READER,WRITER,AND      08020000
*              INITIATOR                                                08040000
*              .FIRST TEST FOR COMMAND TO OPERATE ON - CCURNT TO CCNBR  08060000
*              .TEST PARTICULAR STOP GIVEN             CB8+1 FOR C'Y'   08080000
*              .MOVE COMMAND TO BUFFER                                  08100000
*              .BACKSCAN TO CALCULATE LENGTH                            08120000
*              .TEST WTO ONLY                    CB1 - 00               08140000
*              .TEST ANY STOP AT ALL GIVEN (TO BYPASS WTO PART) CB8-01  08160000
*              .WTO                                                     08180000
*              .TEST FLAG FOR WTO ONLY -NO MGCR (EXECUTE)   CB1 FOR 00  08200000
*              .MGCR                                                    08220000
*              .INITIALIZE FOR NEXT COMMAND AND RETURN                  08240000
*              USES REGISTERS R5 - CURRENT COMMAND CT                   08260000
*                             R7 - COMMAND START ADDRESS                08280000
*                             R6 - ADDRESS OF STOP FLAG AREA            08300000
*                             R8 - RETURN REG                           08320000
*                            R2,R3 -TO BACK SCAN FOR COMMAND LENGTH     08340000
*********************************************************************** 08360000
IP700    EQU   *                                                        08380000
         XR    R5,R5                                                    08400000
         L     R5,CCURNT               CURRENT BYTE COUNT OF COMMANDS   08420000
         LA    R7,CCBGN                        TO FLIP DOWN COMMANDS    08440000
         XR    R6,R6                                                    08460000
         LA    R6,CB8+1                    SET UP FOR STOP CHECK        08480000
IP710    EQU   *                                                        08500000
         CL    R5,CCNBR                IS THERE A COMMAND TO WRITE      08520000
         BNL   IP799                   NO MORE -GO EXIT                 08540000
         CLI   0(R6),C'Y'              YES PARAMETER CHECK              08560000
         BE    IP780                   YES. SKIP WTO/MGCR               08580000
         MVC   IPCC(80),0(R7)          MOVE COMMAND TO BUFFER           08600000
         LA    R2,80                   SETUP TO BACKSCAN FOR LENGTH     08620000
IP766    EQU   *                                                        08640000
         BCT   R2,IP770                DECREMENT COUNT REG              08660000
         B     IP780                   NO COMMAND -BCH CT REG ZERO      08680000
IP770    EQU   *                                                        08700000
         LA    R3,IPCC(R2)             SETUP AREA POINTER REG           08720000
         CLI   0(R3),C' '              TEST FOR BLANK                   08740000
         BE    IP766                   BCH STILL BLANK                  08760000
         LA    R2,1(R2)           NONBLANK-ADJUST LENGTH                08770018
* LENGTH DOES NOT INCLUDE ROUT AND DESC CODES FIELDS                    08780018
         STH   R2,IPWTO                 SAVE TOTAL LENGTH               08800000
         MVC   IPWTO+K2(K2),HALFZERO    ZERO OUT THE RT. CODE    A42562 08810021
         LA    R1,IPWTO                                                 08820000
         CLI   CB1,X'00'               TEST WTO ONLY                    08840000
         BE    IP773                   YES-GO STRAIGHT TO WTO           08860000
         TM    CB8,X'01'          ANY N'S IN AUTO PARM OF SET COMMAND   08880018
         BZ    IP775              NO-SKIP WTO                           08900018
IP773    EQU   *                                                        08920000
         WTO   MF=(E,(1))                                               08940000
IP775    EQU   *                                                        08960000
         CLI   CB1,X'00'               TEST FLAG FOR WTO ONLY           08980000
         BE    IP780                   BCH YES TO UPDATE FOR NEXT COMMD 09000000
         XR    R0,R0    TO SPECIFY SYSTEM COMMAND TO SVC 34        XMCS 09006018
         MVC   IPCC(72),8(R7)          MOVE SYSTEM COMMAND TO CIB  XMCS 09012018
         S     R2,CB08                 ADJUST START COMMAND LENGTH      09014018
         STH   R2,IPWTO                SAVE LENGTH                      09016018
         MGCR  IPWTO                                                    09020000
IP780    EQU   *                                                        09040000
         LA    R6,1(R6)                 INCREMENT INDEX REG             09060000
         LA    R5,80(R5)                                                09080000
         LA    R7,80(R7)                     FLIP TO NEXT COMMAND       09100000
         B     IP710                                                    09120000
*                                                                       09140000
IP799    BR    R9                      RETURN                      OC43 09160017
*                                                                       09180000
*********************************************************************** 09200000
         AIF   ('&LCTR' EQ '0').L2                                      09202018
*              EXIT TO LOG INITIALIZATION MODULE                        09204018
         AGO   .S7                                                      09206018
.L2      ANOP                                                           09208018
         AIF   ('&SMF' EQ '0').S6                                       09210018
*              EXIT TO SMF INITIALIZATION MODULE                        09212018
         AGO   .S7                                                      09214018
.S6      ANOP                                                           09216018
*              EXIT TO WAIT MODULE                                      09220000
.S7      ANOP                                                           09240018
*                   .CLEAR PTR TO STOP INDICATOR AREA                   09260000
*********************************************************************** 09280000
IP800    EQU   *                                                        09300000
         AIF   ('&LCTR' EQ '0').NOLGLOD      IS LOG PRESENT       M1874 09310021
         LOAD  EP=IEEVLIN                    LOAD LOG INIT       A40047 09320021
.NOLGLOD ANOP                                                     M1874 09330021
         XC    BACV(4),BACV                ZERO STOP IND ADDRESS        09340000
*                                      IS NO LONGER IPL           20030 09344020
         MVC   BABCMAX(L'BCLMT),BCLMT  MOVE LIMIT TO BASEA        20030 09348020
         AIF   ('&LCTR' EQ '0' AND '&SMF' EQ '0' AND '&TSO' EQ '0').S2  09352020
.* IF NEITHER LOG NOR SMF NOR TSO ARE PRESENT GOTO MASTER WAIT    20030 09356020
         L     R3,PARMSAVE             PASS PARMLIB UCB PTR       M0419 09360218
         L     R12,CVTPTR                                         M0419 09360318
         L     R10,SMFOPT              GET SMF OPTION FIELDS      M0419 09360418
         SLL   R10,24             ISOLATE SMFOPT+3 IN HI-ORDER    M0419 09360518
         ST    R10,CVTSMCA             BYTE OF CVTSMCA SLOT       M0419 09360618
         AIF   ('&TSO' EQ '0').SKIPTSO   IS TSO SPECIFIED         20030 09360720
         LINK  EP=IEEVSIPL            LINK TO SYS1.BRODCAST INIT  20030 09360820
.SKIPTSO ANOP                                                     20030 09360920
         AIF   ('&LCTR' EQ '0').SKIPLIN  IS LOG PRESENT            LMCS 09361018
         XCTL  EP=IEEVLIN              GO TO LOG INITIALIZATION    LMCS 09362018
*                                                                       09363018
*        LOG CONSTANTS                                             LMCS 09364018
LOGTIOT  DC    F'40'                   LENGTH OF LOG TIOT ENTRIES  LMCS 09365018
         AGO   .CONSTNT                                            LMCS 09366018
.SKIPLIN ANOP                                                           09367018
         AIF   ('&SMF' EQ '0').S2      IS SMF PRESENT                   09368018
         XCTL  EP=IEESMFIT             GO TO SMF INITIALIZATION     SMF 09374018
         AGO   .CONSTNT                                                 09375018
.S2      ANOP                                                           09376018
         XCTL  EP=IEEVWAIT             GO TO MASTER WAIT           LMCS 09377018
.CONSTNT ANOP                                                           09378018
*********************************************************************** 09400000
*                                                                       09420000
*              MODULE CONSTANTS                                         09440000
*                                                                       09460000
*********************************************************************** 09480000
*                                                                       09500000
*********************************************************************** 09500420
*                                                                     * 09500820
*               TOD CLOCK CONSTANTS                                   * 09501220
*                                                                     * 09501620
*********************************************************************** 09502020
         DS    0D                                                 20071 09502420
DOUBLE   DC    CL8'0'              UNPACKING DOUBLE WORD          20071 09502820
TIMEAREA DC    F'0'                DOUBLE WORD FOR                20071 09503220
         DC    F'0'                TOD CLOCK VALUE                20071 09503620
TODMSG1  WTOR  'IEE116A TOD CLOCK INVALID- REPLY WITH SET PARAMETERS', X09504020
               MF=L,ROUTCDE=(1),DESC=(2)                          20071 09504420
TODMSG2  WTOR  'IEE114A DATE=00.000,CLOCK=00.00.00 - REPLY WITH SET PARX09504820
               AMETERS OR U',MF=L,ROUTCDE=(1),DESC=(2)            20071 09505220
MSGCHNG  EQU   TODMSG2+K12         SET UP EQUATE TO DYNAMICALLY   20071 09505620
*                                  CHANGE MESSAGE                 20071 09506020
TODECB   DC    F'0'                TOD WTOR ECB                   20071 09506420
TODBUF   DC    X'0078'             START OF REPLY BUFFER          20071 09506820
         DC    X'0000'                      **                    20071 09507220
TODSET   DC    CL4'SET'            ALREADY IN REPLY BUFFER FOR    20071 09507620
*                                  LATER INTERNAL SET COMMAND     20071 09508020
TODREPLY DC    CL122' '            REPLY AREA FOR TOD WTORS       20071 09508420
YDATE    DC    CL3'0'              *             KEEP THIS        20071 09508820
DDATE    DC    CL3'0'              *          AREA TOGETHER       20071 09509220
HTIME    DC    CL3'0'              *           FOR INTERNAL       20071 09509620
MTIME    DC    CL3'0'              *            SET-UP OF         20071 09510020
STIME    DC    CL3'0'              *           DATE AND TIME      20071 09510420
COMDATE  DC    C','                COMMA MUST PRECEDE 'DATE='     20071 09510820
DATE     DC    C'DATE='            DATE PARAM FOR SET COMMAND     20071 09511220
LOWCASE1 DC    X'8481A3857E'       'DATE=' IN LOWER CASE          M1866 09511420
COMCLOCK DC    C','                COMMA MUST PRECEDE 'CLOCK='    20071 09511620
CLOCK    DC    C'CLOCK=00.00.00'   CLOCK PARAM FOR SET COMMAND    M3230 09512020
LOWCASE2 DC    X'83939683927E'     'CLOCK=' IN LOWER CASE         M1866 09512220
CCBITS   DC    X'00'               SAVE COND CODE FROM STCK       20071 09512420
TEN      DC    H'10'               USED IN CONVERTING TO DECIMAL  20071 09512820
YR2000   DC    F'1203826904'       MIC SEC IN TOD ON JAN 1,2000   M5381 09513220
D16384   DC    F'16384'            SECOND CONVERSION CONSTANT     20071 09513620
D15625   DC    F'15625'                        **                 20071 09514020
D86400   DC    F'86400'            NO. SECONDS PER DAY            20071 09514420
D365     DC    F'365'              NO. DAYS IN REGULAR YEAR       20071 09514820
D366     DC    F'366'              NO. DAYS IN LEAP YEAR          20071 09515220
U        DC    CL2'U'              CHARACTER 'U' FOR REPLY        20071 09515620
D60      DC    C'60'               CHAR 60 FOR FIRST YEAR OF TOD  20071 09516020
F60      DC    F'60'               NO. SECONDS PER MINUTE         20071 09516420
D3600    DC    F'3600'             NO. SECONDS PER HOUR           20071 09516820
D1460    DC    F'1460'             NO. DAYS PER FOUR YEARS-1     A52614 09516921
D1461    DC    F'1461'             NO. DAYS PER FOUR YEARS        20071 09517220
*********************************************************************** 09517620
         DS    0F                                                       09520000
CB8      DC    X'00'                    KEEP        8 BYTE AREA         09540000
         DC    C'NNNNNNN'                 TOGETHER      FOR STOP FLAGS  09560000
CB1      DC    X'00'                                                    09580000
         DS    0H                                                 M5510 09590020
HALFZERO DC    H'0'                TJID ZEROES OVERLAY            M5510 09592020
*                                                                       09600000
         DS    0F                                                       09620000
IPCAT    CAMLST RECAT,IPDSN,,IPVOLS  PARAMETER LIST FOR CATALOG         09622014
IPDSN    DC    C'SYS1.PROCLIB '    PROCLIB NAME                         09624014
IPVOLS   DC    H'1'                RESIDES ON 1 VOLUME                  09626014
IPDEVTYP DS    4C                  DEVICE TYPE                          09628014
IPVOLSER DS    6C                  VOL SER NO                           09630014
         DC    H'0'                ZERO SEQUENCE NUMBER                 09632014
CB08     DC    F'8'                                                     09634014
CB10     DS    1F                                                       09640000
CF04     DC    F'4'                                                     09660000
CX108    DC    X'FF00006C'             GET CORE CONSTANT FOR 108 IN S   09680018
CF0F     DC    X'0000FFFF'                                              09700000
IPSGJQ   DC    CL4'&JUCB. '             SYSGEN JOB QUEUE UNIT.          09720000
IPSGPL   DC    CL5'&PUCB. '                                             09740013
IPLCS    DC    CL1'&LCLS'                                               09760000
IPLCT    DC    AL1(&LCTR)               LOG QUEUE LIMIT.                09780000
BCLMT    DC    AL2(&BCLMT)             LIMIT OF BROADCAST MSG RECORDS   09781020
*                                      FOR TSO SEND CP            20030 09782020
TYPE2321 DC    X'2005'                  2321 ID                         09785013
BINTABLE DC    C'012345678'             BIN ID'S                        09790013
BINLAST  DC    C'9'                     LAST ENTRY IN TABLE             09795013
MAINSVE  DS    F                                                   AABA 09797016
         DS    0F                                                       09800000
IP400SW  DC    X'00'                                               AABA 09800716
IP400WKR DS    D                                                   AABA 09801416
JOBQDSN  DC    CL14'SYS1.SYSJOBQE '                                AABA 09802116
PROCDSN  DC    CL14'SYS1.PROCLIB  '                                AABA 09802816
LOCCNTRL DC    X'44000000'   LOCATE CONTROL BYTE                   AABA 09803516
OBTCNTRL DC    X'C1000000'   OBTAIN CONTROL BYTE                   AABA 09804216
CF00F    DC    X'0000000F'                                         AABA 09804916
BLNKS    DC    X'40404040'                                         AABA 09805616
         DS    0F                                                  AABA 09806316
IP381    DC    AL2(IP384-*)        **MESSAGE LENGTH                AABA 09807016
         DC    AL2(0)              **                              AABA 09807716
         DC    C'IEE343E  '       **MESSAGE NUMBER                 WMCS 09808418
IP382    DC    C'      , '         **VOLUME SERIAL NUMBER          AABA 09809116
IP383    DC    CL14'              ' *DATA SET NAME                 AABA 09809816
         DC    C', NOT MOUNTED'    **                              AABA 09810516
IP384    EQU   *                                                        09810818
         DC    X'2000'            DESCRIPTOR CODES                 WMCS 09811118
         DC    X'9000'            ROUTING CODES                    WMCS 09811418
         DS    0F                                                  AABA 09811916
IP391    DC    AL2(IP395-*)        **MESSAGE LENGTH                AABA 09812616
         DC    AL2(0)              **                              AABA 09813316
         DC    C'IEE344E  '       **MESSAGE NUMBER                 WMCS 09814018
IP392    DC    CL14'              ' *DATA SET NAME                 AABA 09814716
         DC    C', NOT FOUND ON '  **                              AABA 09815416
IP393    DC    C'      , '         **VOLUME SERIAL                 AABA 09816116
IP394    DC    C'     '            **UNIT NAME                     AABA 09816816
IP395    EQU   *                                                        09817418
         DC    X'2000'            DESCRIPTOR CODES                 WMCS 09818018
         DC    X'9000'            ROUTING CODES                    WMCS 09818618
RDYMSG   WTO   'IEE101A READY',MF=L,ROUTCDE=(1),DESC=(3)           WMCS 09819218
*                                                                       09820000
*                                                                       09840000
         IEFVTIOT                                                       09860000
*                                                                       09880000
PARMSAVE DC    F'0'                     PARMLIB UCB POINTER SAVE   OC43 09890017
IPQPAM   DS    4F                       QUEUE MANAGER PARAMETER LIST    09900000
*                                                                       09920000
IPXSA    DS    10F                           ERROR MESSAGE AREA         09940000
*                                                                       09960000
IPREGSV  DS    18F                      REGISTER SAVE                   09980000
*                                                                       10000000
IPWTO    DC    X'0050'                                                  10020000
         DC    X'0000'                                                  10040000
IPCC     DC    4CL20' '                                                 10060000
         AIF   ('&TSO' EQ '0').SKIPDC                             20030 10060220
SENDTIOT DC    F'20'     LENGTH OF SYS1.BRODCAST TIOT ENTRY       20030 10060420
.SKIPDC  ANOP                                                     20030 10060620
         AIF  ('&SMF' EQ '0' AND '&LCTR' EQ '0' AND '&TSO' EQ '0').S4   10061320
SMFTIOT  DC    F'60'                   LENGTH OF SMF TIOT ENTRIES   SMF 10062018
SMFOPT   DC    F'&SMF'                 SMF SYSGEN OPTIONS           SMF 10063018
*                                                                   SMF 10064018
* BIT REPRESENTATIONS FOR SMFOPT+3                                  SMF 10065018
*                                                                   SMF 10066018
*        BIT0 - SMF REQUESTED                                       SMF 10067018
*        BIT1 -                                                     SMF 10068018
*        BIT2 -                                                     SMF 10069018
*        BIT3 -                                                     SMF 10070018
*        BIT4 -                                                     SMF 10071018
*        BIT5 -                                                     SMF 10072018
*        BIT6 -                                                     SMF 10073018
*        BIT7 - WARM START                                          SMF 10074018
*                                                                   SMF 10075018
.S4      ANOP                                                           10076018
         DS    0F                                                       10080000
*                                                                       10100000
*********************************************************************** 10120000
.*             COMMANDS ARE ORDERED--S WTR                              10140000
.*                                   S RDR                              10160000
.*                                   S INIT                             10180000
.*             &CCA2 = START WRITER UNIT                                10200000
.*             &CCN2 = DSNAME OF WRITER                                 10220000
.*             &CCV2 = VOLUME SERIAL OF WRITER                          10240000
.*             &CCA1 = START RDR UNIT                                   10260000
.*             &CCN1 = DSNAME OF READER                                 10280000
.*             &CCV1 = VOLUME SERIAL OF READER                          10300000
.*             &CCA3 = START INITIATOR INDICATOR                        10320000
CCBGN    EQU   *                                                        10340000
.A1      AIF   ('&CCA2' EQ '').B1      TEST FOR WTR                     10360000
WTRCAN   DC    4CL20' '                COMMAND AREA                     10380000
         ORG   WTRCAN                                                   10400000
         DC    C'IEE103I S WTR,&CCA2'  CREATE S WTR UNIT           XMCS 10410018
         AIF   ('&CCV2' EQ '' AND '&CCN2' EQ '').A3                     10430017
         DC    C','                    ADD COMMA                        10440017
         AIF   ('&CCV2' EQ '').A2      TEST VOLSER OF WTR               10450017
         DC    C'&CCV2'                ADD WTR VOLSER                   10460017
.A2      AIF   ('&CCN2' EQ '').A3      TEST DSNAME FOR WTR              10470017
         DC    C',DSNAME=&CCN2'        ADD   DSNAME=NAME                10480017
.A3      DC    C' *'                   AUTOMATIC INDICATOR              10520000
         DC    X'1000'            DESCRIPTOR CODES                 WMCS 10526018
         DC    X'8000'            ROUTING CODES                    WMCS 10532018
.B1      AIF   ('&CCA1' EQ '').C1      TEST FOR RDR                     10540000
         ORG                                                            10560000
RDRCAN   DC    4CL20' '                COMMAND AREA                     10580000
         ORG   RDRCAN                                                   10600000
         DC    C'IEE103I S RDR,&CCA1'   CREATE S RDR UNIT          XMCS 10610018
         AIF   ('&CCV1' EQ '' AND '&CCN1' EQ '').B3                     10630017
         DC    C','                    ADD COMMA                        10640017
         AIF   ('&CCV1' EQ '').B2      TEST VOLSER FOR RDR              10650017
         DC    C'&CCV1'                ADD VOLSER FOR RDR               10660017
.B2      AIF    ('&CCN1' EQ '').B3     TEST DSNAME FOR RDR              10670017
         DC    C',DSNAME=&CCN1'        ADD   DSNAME=NAME                10680017
.B3      DC    C' *'                   AUTOMATIC INDICATOR              10720000
         DC    X'1000'            DESCRIPTOR CODES                 WMCS 10726018
         DC    X'8000'            ROUTING CODES                    WMCS 10732018
.C1      AIF   ('&CCA3' EQ '').D1                                       10740000
         ORG                                                            10760000
INITC    DC    4CL20' '                                                 10780000
         ORG   INITC                                                    10800000
         DC    C'IEE103I S &CCA3'      CREATE S UNIT               XMCS 10820018
         DC    C' *'                                                    10840000
         DC    X'1000'            DESCRIPTOR CODES                 WMCS 10846018
         DC    X'8000'            ROUTING CODES                    WMCS 10852018
.D1      ANOP                                                           10860000
         ORG                                                            10880000
CCEND    EQU   *                                                        10900000
CCNBR    DC    A(CCEND-CCBGN)           TOTAL NO. BYTES                 10920000
CCURNT   DC    F'0'                                                     10940000
VCONBIE0 DC    V(ICFBIE00)                                              10950021
         DS    0F                                                       10960000
*                                                                       10980000
*********************************************************************** 11000000
*                                                                       11020000
         IEEBASEA                                                       11040000
*********************************************************************** 11060000
*                                                                       11080000
SXSA     DSECT                                                          11100000
         DS    0F                                                       11120000
         IEEXSA                                                         11140000
*                                                                       11160000
*********************************************************************** 11180000
*                                                                       11200000
         EJECT                                                     AABA 11200616
***                                                                AABA 11201216
* THE FOLLOWING DSECT MAPS THE WORK AREA IN GOTTEN CORE THAT IS USED  * 11201816
* BY THE OBTAIN AND LOCATE ROUTINES                                AABA 11202416
***                                                                AABA 11203016
IPWKAREA DSECT                                                     AABA 11203616
         DS    0D                                                  AABA 11204216
IPWKST   EQU   *                                                   AABA 11204816
VCBCOUNT DS    CL2  *COUNT OF VOLUMES IN VCB      *****            AABA 11205416
VCBDEVTP DS    CL4  *DEVICE TYPE FOR VOLUME           *            AABA 11206016
VCBVOLSN DS    CL6  *VOLUME SERIAL NUMBER             *            AABA 11206616
VCBDSSQN DS    CL2  *DATA SET SEQ NUMBER              *            AABA 11207216
         DS    CL228                                  ***LOCATE    AABA 11207816
VCBSPARE DS    CL10 *                                 *            AABA 11208416
VCBNXTCB DS    CL4  *TTR OF NEXT VCB                  *            AABA 11209016
VCBINDXA DS    CL3 *TTR OF THIS INDEX BLOCK                        AABA 11209616
VCBCVOLM DS    CL6  *CNTRL VOL ID FIELD           *****            AABA 11210216
*                                                     ***OBTAIN    AABA 11210816
OBTWK    DS    CL85 *TO MAKE WORK AREA FOR OBTAIN *****            AABA 11211416
*PARAMETER LIST FOR LOCATE AND OBTAIN ROUTINES                     AABA 11212016
         DS    0F                                                  AABA 11212616
PARM1    DS    F    LOCATE/OBTAIN CONTROL BYTE                     AABA 11213216
PARM2    DS    A   ADDRESS OF DATA SET NAME                        AABA 11213816
PARM3    DS    F    ZERO FOR LOCATE                                AABA 11214416
*                  ADDRESS OF VOLUME SERIAL FOR OBTAIN             AABA 11215016
PARM4    DS    A    ADDRESS OF WORKAREA                            AABA 11215616
*DATA AREAS                                                        AABA 11216216
DSNAREA  DS    CL44 DATA SET NAME AREA                             AABA 11216816
VOLSRAR  DS    CL6  VOLUME SERIAL AREA                             AABA 11217416
IPWKEND  EQU   *-IPWKST                                            AABA 11218016
CVT      DSECT                                                          11220000
         CVT                                                            11240000
*                                                                       11260000
*********************************************************************** 11280000
*                                                                       11300000
         DS    0F                                                       11320000
UCB      DSECT                                                          11340000
         IEFUCBOB                                                       11360000
         MEND                                                           11380000
./ ENDUP
/*
//
