//TMVT805  JOB 1,TMVT805,CLASS=A,MSGLEVEL=(1,1),COND=(0,NE)
/*JOBPARM LINES=9999
//*MAIN LINES=100
//*
//*  PROBLEM DESCRIPTION(S):
//*    TMVT805 -
//*      MVT support for four-digit years greater than 1999.
//*      The elements affected are:
//*
//*        IKJEFLPA TSO logon/logoff messages
//*        SGIEE00V IEEVIPL master scheduler initialization
//*        IEE6503D SET command TOD clock handler
//*        IEE3503D DISPLAY command router
//*        IEE0603D SET command part 1
//*
//*      Note that this is intended only for MVT generated
//*      to run on a System/370.  It will not work on MFT or
//*      on MVT generated for System/360.
//*
//*   COMPONENT:  360S-CI505-QBB2218
//*               360S-CI535-QBB2218
//*               360S-CI555-QBB2218
//*
//*   SPECIAL CONDITIONS:
//*     ACTION:  If your system has a defective SGIEE00V macro
//*       from an earlier attempt to bypass Y2K checking, you
//*       must first replace the defective SGIEE00V with an
//*       unmodified copy of SGIEE00V from the IBM OS 21.8
//*       distribution.  A job to do that is at:
//*
//*         http://www.j76.org/mvt/replace-sgiee00v.zip
//*
//*     ACTION:  You must modify the assembly source in this usermod
//*       for IEEVIPL, which expands SGIEE00V, from your stage 2
//*       system generation deck.
//*
//*     DOCUMENTATION:  Text of system message IEE114A modified.
//*
//*       Publication:  OS/360 Messages and Codes
//*       Form Number:  GC28-6631
//*
//*       Message IEE114A is modified as follows:
//*
//*         IEE114A DATE=yyyy.ddd,CLOCK=hh,mm.ss
//*                 REPLY WITH SET PARAMETERS OR U
//*
//*           Explanation:  The time-of-day clock is operative,
//*             and the current date and time are displayed to the
//*             operator for verification.  In the message text, yyyy
//*             specifies the year (1960-2099), ddd specifies the day
//*             (001-366), hh specifies the hour (00-23), mm specifies
//*             the minute (00-59), and ss specifies the second
//*             (00-59).
//*
//*           System Action:  The system waits until the operator
//*             enters a reply.
//*
//*           Operator Response:  If the date and time indicated in the
//*             message text are correct, and if you do not want to use
//*             any SET parameters, enter REPLY xx,'U'.
//*
//*             If the date and time indicated in the message text
//*             are correct and you want to use one or more of the SET
//*             command parameters, enter REPLY xx,parm, where parm may
//*             be Q, AUTO or PROC or any combination of the three.  Do
//*             not depress the TOD clock enable switch.
//*
//*             If the date and/or time indicated in the message is
//*             incorrect, enter REPLY xx,parm, where parm may be
//*             CLOCK=hh.mm.ss and/or DATE=yyyy.ddd (use the date and
//*             time format indicated in the explanation above).  If
//*             you with to use any other SET command parameters, they
//*             may be included in the reply as shown above.  After you
//*             have typed the appropriate response, depress the TOD
//*             enable switch and hold it down while you signal
//*             end-of-block.
//*
//*             The value of DATE= may be specified as DATE=yy.ddd,
//*             with a two-digit year.  In that case, the omitted first
//*             two digits are assume to be 19.  That is, the date is
//*             treated as if it had been specified at DATE=19yy.ddd.
//*
//*             (Note:  The TOD clock settings are entirely dependent
//*             on the way the operator responds to this message.  If
//*             both the TIME= and DATE= parameters are specified,
//*             the clock will be updated in accordance with both
//*             parameters.  If only one parameter is specified, the
//*             clock will be updated in accordance with that parameter
//*             and the value not specified will be assumed to be
//*             correct.)
//*
//*     DOCUMENTATION:  Text of system message IEE136I modified.
//*
//*       Publication:  OS/360 Messages and Codes
//*       Form Number:  GC28-6631
//*
//*       Message IEE136I is modified as follows:
//*
//*         IEE136I    TIME=hh.mm.ss   DATE=yyyy.ddd
//*
//*           Explanation:  In response to a DISPLAY T command, this
//*             message indicates the time of day and the date.  In
//*             the message text, hh specifies the hour (00-23), mm
//*             specifies the minute (00-59), ss specifies the second
//*             (00-59), yyyy specifies the year (1960-2099), and ddd
//*             specifies the day (001-366).
//*
//*           Operator Response:  None
//*
//*     DOCUMENTATION:  Explanation of "DISPLAY T" response modified.
//*
//*       Publication:  OS/360 Operator Reference
//*       Form Number:  GC28-6691
//*
//*       T
//*         the time of day and the date are to be displayed in the
//*         following format:
//*
//*              hh.mm.ss                  yyyy.ddd
//*              |  |  |                   |    |
//*              |  |  +--Second (00-59)   |    |
//*              |  +-----Minutes (00-59)  |    +--Day of year (000-366)
//*              +--------Hours (00-23)    +-------Year (1960-2099)
//*
//*     DOCUMENTATION:  Explanation of "SET DATE" command modified.
//*
//*       Publication:  OS/360 Operator Reference
//*       Form Number:  GC28-6691
//*
//*       { SET | T } DATE=yyyy.ddd[,CLOCK=hh.mm.ss]
//*                   [,Q=[(unitaddr][,F])][,PROC=unitaddr]
//*                   [,AUTO=characters]
//*                   [,CMD=cc]
//*
//*       DATE=yyyy.ddd
//*         the date in the following format:
//*
//*           yyyy.ddd
//*           |    +--Day of year (000-366)
//*           +-------Year (1960-2099)
//*
//*         Note:  The date may be specified with two digits of
//*         years.  If yy.ddd is specified, it is assumed to be
//*         19yy.ddd.
//*
//*   COMMENTS:
//*     LAST CHANGE: 2023/03/16
//*
//*     REWORK HISTORY:
//*      2023/03/16: Changed to make 2099 the maximum allowable year
//*                  instead of 2059.
//*      2018/06/28: Created.
//*
//*     CROSS REFERENCE-MODULE/MACRO NAMES TO USERMODS
//*      IEE0603D  TMVT805
//*      IEE3503D  TMVT805
//*      IEE6503D  TMVT805
//*      IKJEFLPA  TMVT805
//*      SGIEE00V  TMVT805
//*
//*     CROSS REFERENCE-USERMODS TO MODULE/MACRO NAMES
//*      TMVT805   IEE0603D IEE3503D IEE6503D IKJEFLPA SGIEE00V
//*
//*     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:
//*
//*     MODULES
//*      IEE0603D
//*      IEE3503D
//*      IEE6503D
//*      IKJEFLPA
//*
//*     MACROS
//*      SGIEE00V
//*
//*     LISTEND
//*
//*-----------------------------------------------------------------***
//*     Step 1:  Create a temporary PDS containing the modified     ***
//*              source for IEE0603D, IEE3503D, IEE6503D and        ***
//*              IKJEFLPA.                                          ***
//*-----------------------------------------------------------------***
//SOURCE EXEC PGM=IEBUPDTE,PARM=NEW,
//            REGION=256K
//SYSUT2   DD DSN=&&SOURCE,UNIT=SYSDA,SPACE=(TRK,(90,90,5),RLSE),
//            DISP=(NEW,PASS),DCB=(RECFM=FB,LRECL=80,BLKSIZE=3120)
//SYSPRINT DD SYSOUT=A
//SYSIN    DD *
./ ADD NAME=IEE0603D
 TITLE 'IMMEDIATE COMMANDS ROUTINE - SET - PART I'                21774 00020021
IEE0603D CSECT                                                          00040000
*                                                                 21774 00042021
* A 009300,054700-054720,106900                                   M0777 00044021
* 036600-037000,073200-073400                                     M2081 00050020
*********************************************************************** 00060000
*                                                                 21774 00070021
* THE PROLOGUE COMMENTS BELOW, HAVING AN ID FIELD OF 21 AND       21774 00074021
* NOT FLAGGED, ARE THE CHANGES FOR THE 21774 PROJECT.             21774 00076021
*                                                                 21774 00080021
*TITLE:  IEE0603D   IMMEDIATE COMMANDS ROUTINE - SET - PART I         * 00100021
*                                                                     * 00120000
*FUNCTION: ACCEPTS THE PARAMETERS OF THE SET COMMAND: CLOCK AND DATE  * 00150021
*          AND PROCEEDS AS FOLLOWS: IF AT IPL TIME, DATE, OR DATE AND * 00152021
*          TIME ARE SPECIFIED, PASSES THEM TO THE NEXT MODULE,        * 00154021
*          IEE8603D.  DATA IS ALSO PASSED IF TIME AND/OR DATE IS(ARE) * 00156021
*          SPECIFIED AT NON-IPL TIME.  OTHERWISE, AN ERROR EXIT TO THE* 00158021
*          MESSAGE MODULE, IEE0503D, IS TAKEN.  IN ADDITION, POSITIVE * 00160021
*          SYNTAX CHECKING IS PERFORMED ON KEYWORDS AND PARAMETERS.   * 00240021
*                                                                     * 00260000
*ENTRY POINT: IEE0603D  FROM COMMAND ROUTER MODULE, IEE0403D.         * 00280000
*                                                                     * 00300000
*ATTRIBUTES: REENTRANT, TRANSIENT, READ ONLY AND SELF-RELOCATABLE.    * 00320000
*                                                                     * 00340000
*APPLICABILITY: VARIABLE MEMORY SYSTEM.                               * 00360000
*                                                                     * 00380000
*EXTERNAL REFERENCES: MASTER RESIDENT CORE, USING MACRO IEEBASEA      * 00400021
*                     EXTENDED SAVE AREA(XSA), USING MACRO IEEXSA     * 00420021
*                     COMMUNICATIONS VECTOR TABLE, USING MACRO CVT    * 00440021
*                                                                     * 00460000
*MACROS: XCTL, IEEXSA, CVT, AND IEEBASEA.                             * 00480021
*                                                                     * 00500000
*INPUT: REGISTER 2 POINTING TO THE EXTENDED SAVE AREA WHICH MUST      * 00520000
*        CONTAIN:                                                     * 00530021
*            IN XAR, A POINTER TO THE COMMAND BUFFER                  * 00540021
*            IN XAL, A POINTER TO THE PARAMETER LIST (FIRST KEYWORD)  * 00560000
*       REGISTER 10 POINTING TO MASTER RESIDENT CORE(IEEBASEA)    M2081 00570021
*                                                                     * 00580000
*OUTPUT: FOR A NORMAL EXIT (TO IEE8603D, THE SECOND MODULE OF THE     * 00590021
*         IMMEDIATE COMMANDS ROUTINE), THE CLOCK AND/OR DATE IS(ARE)  * 00690021
*         SET IN THE EXTENDED SAVE AREA (XSA) AT THE XAS AND XAV      * 00692021
*         LOCATION RESPECTIVELY.  ZEROES ARE PUT IN THESE AREAS IF    * 00696021
*         UNSPECIFIED.  CLOCK AND/OR DATE MASK BIT SETTINGS IS(ARE)   * 00696421
*         SAVED IN THE XSA AT THE XAE LOCATION.  THE COUNTER USED FOR * 00698421
*         INDICATING NUMBER OF KEYWORDS PROCESSED ARE SAVED IN THE XSA* 00698821
*         AT THE XAU+4 LOCATION.  THE INPUT CONTENTS AS SPECIFIED     * 00703021
*         ABOVE ARE ALSO USED AS OUTPUT.                              * 00711621
*        FOR AN ERROR EXIT (TO IEE0503D, THE MESSAGE ASSEMBLER),      * 00715821
*          REG 2 POINTS TO THE EXTENDED SAVE AREA (XSA) WHICH         * 00720021
*          CONTAINS:                                                  * 00730021
*           IN XAE, THE MESSAGE CODE (SEE ERROR MESSAGES BELOW)       * 00740000
*           IN XAV, THE VERB IN EBCDIC, LEFT ADJUSTED WITH BLANKS     * 00760000
         EJECT                                                          00780021
*EXITS: NORMAL      TO IEE8603D                                       * 00800021
*       ERROR       TO THE MESSAGE ASSEMBLY MODULE (IEE0503D)         * 00820000
*                                                                     * 00840000
*ERROR MESSAGES: THE FOLLOWING CONDITIONS GENERATE THE INDICATED      * 00880000
*   MESSAGES                                                          * 00900000
*      1.NON-NUMERIC OR EXCESSIVE CHARACTERS IN TIME OR DATE          * 00920000
*        OR, DATE SPECIFIED WITH DDD = 000                        M0777 00930021
*        'IEE306I SET  INVALID NUMERICS.'           (CODE=6)          * 00940021
*      2.MISPLACED PERIODS IN CLOCK OR DATE PARAMETER, OR MISSING     * 00960021
*        RIGHT PARENTHESIS                                            * 00970021
*        'IEE307I SET  DELIMITER ERROR.'            (CODE=7)          * 00980021
*      3.FAILURE TO FIND BLANK, COMMA OR END OF BUFFER AFTER PARAMETER* 01000000
*        'IEE308I SET  TERM LENGTH ERROR.'          (CODE=8)          * 01020021
*      4.NO KEYWORD OR NO DATE SPECIFIED AT IPL TIME, OR AT NON-IPL   * 01080021
*        TIME, NO DATE AND/OR CLOCK KEYWORD SPECIFIED                 * 01090021
*        'IEE310I SET  KEYWORD MISSING.'            (CODE=10)         * 01100021
*      5.BLANK AFTER KEYWORD                                          * 01120021
*        'IEE311I SET  PARAMETER MISSING.'          (CODE=11)         * 01140021
*      6.REPEATED KEYWORD                                             * 01160021
*        'IEE312I SET  PARAMETERS CONFLICT.'        (CODE=12)         * 01180021
*                                                                     * 01256021
* NOTE- IF AN ERROR OCCURS IN A SYSTEM WITH THE TOD CLOCK, A CODE 20071 01256421
*       OF EIGHT IS PLACED IN BAIPL(IPL ECB) TO INDICATE TO IPL   20071 01256821
*       THAT AN ERROR OCCURRED ON THE SET COMMAND.                20071 01257221
*                                                                     * 01258021
*OPERATION:                                                           * 01260021
*   EACH INCOMING COMMAND HAS ITS LEADING KEYWORD COMPARED WITH A     * 01300000
*   TABLE(KEYTAB) CONTAINING EACH OF THE TWO POSSIBLE KEYWORDS, CLOCK * 01320021
*   AND DATE.  SUCCESSFUL COMPARISON RESULTS IN TRANSFER BEING MADE,  * 01340021
*   USING KEYTAB, TO THE APPROPRIATE KEYWORD SUBROUTINE.  SUCCESSFUL  * 01360021
*   RECOGNITION OF A KEYWORD CAUSES THE SETTING OF AN ID MASK FOR THAT* 01380021
*   KEYWORD IN THE XSA.  CHECKS FOR VALID NUMERICS THAT DO NOT EXCEED * 01420021
*   THE PRE-DETERMINED MAXIMUMS ARE MADE.  THEN THE VALID TIME AND/OR * 01440021
*   DATE, IF SPECIFIED, IS(ARE) PACKED AND HELD IN THE XSA.  THE      * 01490021
*   PROCESSED KEYWORD COUNTER IS INCREMENTED BY ONE.  RETURNING FROM  * 01492021
*   THE SUBROUTINES, A CHECK IS MADE FOR SUCCESSIVE KEYWORDS.  IF     * 01500021
*   THERE ARE MORE, THE KEYTAB SCAN IS REPEATED.  IF THE KEYWORD CAN  * 01520021
*   NOT BE FOUND IN THE KEYWORD TABLE, THE BUFFER IS SCANNED FOR THE  * 01530021
*   NEXT VALID KEYWORD.  WHEN THE BUFFER HAS BEEN SCANNED, A XCTL IS  * 01532021
*   MADE TO THE SECOND MODULE, IEE8603D, FOR FURTHER PROCESSING.      * 01540021
         EJECT                                                          01820000
*TABLES/WORK AREAS: THE EXTENDED SAVE AREA AS USED INTERNALLY IN      * 01840000
*   IEE0603D IS MAPPED AS FOLLOWS:                                    * 01860000
*                                                                     * 01880021
*  ****************************************************************   * 01900021
*  *XAP                            *XAD                           *   * 01920021
*  *SAVE AREA FOR POINTER TO       *                              *   * 01940021
*  *END OF COMMAND BUFFER          *                              *   * 01960021
*  ****************************************************************   * 01980021
*  *XAX                                                           *   * 02000021
*  *                                                              *   * 02020021
*  *                                                              *   * 02040021
*  ****************************************************************   * 02050021
*  *XAE    *XAR                    *XAL                           *   * 02080021
*  *K.W. ID*POINTER TO THE         *SAVE AREA FOR CURRENT         *   * 02100021
*  *MASK   *COMMAND BUFFER         *PARAMETER POINTER             *   * 02120021
*  ****************************************************************   * 02150021
*  *XAV                            *XAV+4                         *   * 02160021
*  *                               *DATE IN PACKED                *   * 02180021
*  *                               *DECIMAL                       *   * 02200021
*  ****************************************************************   * 02230021
*  *XAS                            *XAS+4                         *   * 02240021
*  *                               *TIME IN PACKED                *   * 02260021
*  *                               *DECIMAL                       *   * 02280021
*  ****************************************************************   * 02310021
*  *XAU                            *XAU+4  *                      *   * 02330021
*  *                               *KEYWORD*                      *   * 02332021
*  *                               *COUNT  *                      *   * 02334021
*  ****************************************************************   * 02336021
*                                                                     * 02338021
*   A KEYWORD TABLE(KEYTAB), WHICH CONTROLS KEYWORD SCANNING AND      * 02340000
*   KEYWORD SUBROUTINE BRANCHING.                                     * 02360000
*                                                                     * 02380000
*CHARACTER SET: THE OPERATION OF THIS MODULE DEPENDS UPON AN INTERNAL * 02480021
*   REPRESENTATION OF THE EXTERNAL CHARACTER SET WHICH IS EQUIVALENT  * 02500000
*   TO THE ONE USED AT ASSEMBLY TIME. THE CODING HAS BEEN ARRANGED SO * 02520000
*   THAT REDEFINITION OF 'CHARACTER' CONSTANTS, BY REASSEMBLY, WILL   * 02540000
*   RESULT IN A CORRECT MODULE FOR THE NEW DEFINITIONS.               * 02560000
*                                                                     * 02580000
*                                                                       02581000
* Change activity      =                                                02582000
*                                                                       02583000
*   Flag  Date        By    Description                                 02584000
*   ----  ----------  ----  --------------------------------------      02585000
*   $D03  2023/03/16  KL    Changed to make 2099 the maximum       @D03 02585910
*                           allowable year instead of 2059.        @D03 02585930
*   $L02  2017/09/15  KL    TMVT805 Four-digit year support.       @L02 02586000
*   $D01  2017/09/15  KL    Verify day 366 is only specified       @D01 02587000
*                           for leap year.                         @D01 02588000
*                                                                       02589000
*********************************************************************** 02600000
         EJECT                                                          02620000
*      REGISTER ASSIGNMENTS        FUNCTION(S)                          02640000
R1       EQU   1                   BASE REGISTER FOR CVT          21774 02660021
R2       EQU   2                       BASE FOR XSA                     02680000
R3       EQU   3                       CURRENT PARAM PTR AND LINK REG   02700000
R4       EQU   4                       KEYTAB PTR AND WORK REGISTER     02720000
R5       EQU   5                       ERROR LINKER AND WORK REGISTER   02740000
R6       EQU   6                   WORK REGISTER                  21774 02760021
R7       EQU   7                   WORK REGISTER                  21774 02780021
R8       EQU   8                       WORK REGISTER                    02800000
R9       EQU   9                       PARAMETER POINTER AND WORK REG   02820000
R10      EQU   10                      BASE FOR MASTER RESIDENT CORE    02840000
R11      EQU   11                      WORK REGISTER                    02860000
SBASE    EQU   12                      BASE FOR PROGRAM                 02880000
R13      EQU   13                                                 20071 02890020
R14      EQU   14                            BRANCH REG           20071 02895020
R15      EQU   15                      XCTL                             02900000
*                                                                     * 02920000
* DISPLACEMENTS OF INFORMATION WITHIN KEYWORD TABLE ELEMENTS:     21774 02940021
*  KEYTBL - KEYWORD TABLE LENGTH (DEFINED AFTER THE TABLE BELOW)  21774 02972021
KEYELN   EQU   14                  KEYWORD TABLE ELEMENT LENGTH   21774 02980021
KEYLNG   EQU   0                   DISPLACEMENT OF KEYWORD LENGTH 21774 03000021
KEYDIS   EQU   1                   DISPLACEMENT OF DELIMITER      21774 03020021
KEYWRD   EQU   2                   DISPLACEMENT OF KEYWORD        21774 03040021
KEYBRN   EQU   8                   DISPLACEMENT OF BRANCH         21774 03060021
KEYIDM   EQU   12                  DISPLACEMENT OF ID MASK        21774 03080021
* ERROR CODES FOR MESSAGE MODULE                                        03100000
ERR6     EQU   6                                                        03120000
ERR7     EQU   7                                                        03140000
ERR8     EQU   8                                                        03160000
ERR10    EQU   10                                                       03200000
ERR11    EQU   11                                                       03220000
ERR12    EQU   12                                                       03240000
* PERIOD DISPLACEMENTS FOR DATE AND CLOCK                             * 03280000
PERD1    EQU   2                             DISPLACEMENT OF PERIOD     03300000
PERD2    EQU   5                             DISPLACEMENT OF PERIOD     03320000
D0       EQU   0                                                  21774 03320121
D1       EQU   1                                                  21774 03320421
D2       EQU   2                                                  20071 03322020
D3       EQU   3                                                  20071 03324020
D4       EQU   4                                                  21774 03326421
D8       EQU   8                                                  20071 03328020
* UPPER AND LOWER COMPARANDS FOR SCHECK                               * 03340000
SNUMHI   EQU   C'9'                          HIGH NUMERIC               03360000
SNAWT    EQU   C'0'                          CHARACTER ZERO             03380000
SEINS    EQU   X'01'                         BINARY ONE                 03400000
SNUMLO   EQU   SNAWT-SEINS                   LOW NUMERIC COMPARAND      03420000
ZERO     EQU   X'00'                                              21774 03430021
TWO      EQU   X'02'                                              21774 03432021
THREE    EQU   X'03'                                              21774 03434021
COMMA    EQU   C','                                               21774 03436021
LEFT     EQU   C'('                                               21774 03438021
RIGHT    EQU   C')'                                               21774 03438421
         EJECT                                                          03440000
* MAIN ROUTINE - ESTABLISHES ADDRESSABILITY FOR PROGRAM, XSA, AND     * 03460000
*    MASTER RESIDENT CORE. USES XSA POINTERS TO COMMAND BUFFER AND    * 03480000
*    LEADING KEYWORD TO IDENTIFY THE KEYWORD.  KEYWORD            21774 03500021
*    RECOGNITION LEADS TO BRANCHING TO THE KEYWORD'S SUBROUTINE.  21774 03540021
*    ALSO SETS UP THE BASIC XCTL NAME.                            21774 03550021
*                                                                     * 03580000
         BALR  SBASE,0                       ESTABLISH PROGRAM          03600000
         USING *,SBASE                       ADDRESSABILITY             03620000
         USING XSA,R2                        BASE FOR EXTENDED SAVE A   03640000
         USING BASE,R10                      TO ESTABLISH ADDRESSABLTY  03720000
         MVC   XAX(D8),XL8603D     SET UP BASIC XCTL              21774 03730021
         L     R9,XAL                        USE REGISTER 9 AS POINTER  03740000
         LA    R9,0(R9)                      TO PARAMETER KEYWORD       03760000
         LTR   R9,R9                         IS PARAMETER PTR 0   20071 03780020
         BZ    SERR10                        YES. KEYWORDS MISSING20071 03800020
         L     R7,XAR                        LOAD PTR TO BUFFER         03840000
         LA    R7,0(R7)                      CONTAINING COMMAND         03860000
         LH    R6,0(R7)                      LOAD BUFFER LENGTH         03880000
         N     R6,SFFFF-2                    CLEAR POSSIBLE GARBAGE     03900000
         AR    R7,R6                         COMPUTE END OF BUFFER      03920000
         ST    R7,XAP                        SAVE IN FIRST WORD OF XSA  03940000
         NI    XAE,ZERO            CLEAR ID MASK AREA             21774 03960021
         SR    R8,R8               CLEAR PROCESSED KEYWORD        21774 03970021
*                                       COUNTER                   21774 03972021
         SPACE                                                          03980000
SNEWKY   EQU   *                             EXAMINE KEYWORD            04000000
         LA    R6,KEYELN                     LOAD KEYTAB ELEMENT LENGTH 04020000
*                                            FOR INCREMENT IN BXLE      04040000
         LA    R4,KEYTAB                     ADCON OF KEYWORD TABLE     04060000
         LA    R7,KEYTBL(R4)                 LOAD KEYWORD TABLE LENGTH  04080000
*                                            FOR COMPARAND IN BXLE      04100000
         SR    R5,R5                         LOAD LENGTH OF A           04120000
SLOOP    EQU   *                                                  21774 04130021
         IC    R5,KEYLNG(R4)                 PARTICULAR KEYWORD         04140000
         EX    R5,SETCLC                     IS THIS THE KEYWORD        04160000
         BE    SBRANCH             YES, NOW GO CHECK PARAMETER    21774 04180021
         BXLE  R4,R6,SLOOP         RECHECK IF NOT END OF TABLE    21774 04200021
         B     SCOMMA              END OF TABLE, SCAN FOR NEXT    21774 04220021
*                                       KEYWORD                   21774 04230021
SBRANCH  EQU   *                                                  21774 04240021
         LA    R9,1(R9,R5)                   POINT REG TO PARAM         04260000
         CLI   0(R9),C' '                    IS PARAMETER BLANK         04280000
         BE    SERR11                        YES. ERROR                 04300000
         SPACE                                                          04320000
         SR    R3,R3                         POINT A REG TO THE END OF  04340000
         IC    R3,KEYDIS(R4)                 PARAMETER                  04360000
         LA    R3,0(R3,R9)                                              04380000
         C     R3,XAP                        IS BUFFER EXCEEDED         04400000
         BH    SERR08                        YES. ERROR                 04420000
         SPACE                                                          04440000
         SR    R5,R5                         NO. PREPARE TO             04460000
         IC    R5,KEYIDM(R4)                 LOAD KEYWORD'S ID MASK     04480000
         EX    R5,SETTMP                     IS THIS KEYWORD A REPEAT   04500000
         BO    SERR12                        YES. ERROR                 04520000
         SPACE                                                          04540000
         OC    XAE(D1),KEYIDM(R4)  SAVE KEYWORD'S ID IN XSA       21774 04560021
         EX    0,KEYBRN(R4)                  GO TO APPROPRIATE SUBRTN   04600000
         SPACE                                                          04610021
* THIS SUBROUTINE IS ENTERED WHEN A VALID KEYWORD IS NOT FOUND IN 21774 04610421
* THE TABLE.  IT CHECKS FOR THE NEXT COMMA, OUTSIDE THE           21774 04610821
* PARENTHESES, IF ANY.  IF FOUND, THE NEW KEYWORD IS FOUND AFTER  21774 04611221
* THE COMMA.                                                      21774 04611621
SCOMMA   EQU   *                                                  21774 04612021
         LA    R9,D1(R9)           INCREMENT TO NEXT BUFFER       21774 04614021
*                                       ELEMENT                   21774 04614421
         C     R9,XAP              IS IT END OF BUFFER?           21774 04616021
         BH    SETOUT              YES, BRANCH                    21774 04618021
         CLI   D0(R9),LEFT         NO, IS IT A LEFT PARENTHESIS?  21774 04618421
         BE    SRIGHT              YES, BRANCH                    21774 04618821
         CLI   D0(R9),COMMA        NO, IS IT A COMMA?             21774 04619221
         BNE   SCOMMA              NO, CHECK NEXT BUFFER ELEMENT  21774 04619621
         LA    R9,D1(R9)           YES, INCREMENT TO THE NEXT     21774 04619721
*                                       BUFFER ELEMENT            21774 04619821
         B     SNEWKY              BRANCH AND PROCESS THE NEW     21774 04619921
*                                       KEYWORD                   21774 04622221
         SPACE                                                          04625521
* THIS SUBROUTINE IS ENTERED WHEN A LEFT PARENTHESIS IS           21774 04627821
* ENCOUNTERED IN THE SUBROUTINE ABOVE.  IT LOOKS FOR A RIGHT      21774 04630121
* PARENTHESIS, AND THEN BRANCHES BACK TO THE SCOMMA SUBROUTINE.   21774 04632421
SRIGHT   EQU   *                                                  21774 04634721
         LA    R9,D1(R9)           INCREMENT TO NEXT BUFFER       21774 04637021
*                                       ELEMENT                   21774 04639321
         C     R9,XAP              IS IT END OF BUFFER?           21774 04641621
         BH    SERR07              YES, TAKE ERROR EXIT           21774 04643921
         CLI   D0(R9),RIGHT        NO, IS IT A RIGHT PARENTHESIS? 21774 04646221
         BNE   SRIGHT              NO, CHECK NEXT BUFFER ELEMENT  21774 04650821
         B     SCOMMA              YES, BRANCH BACK TO SCOMMA     21774 04653121
         EJECT                                                          04655421
* KEYWORD=CLOCK SUBROUTINE - SYNTAX CHECKS THE CLOCK PARAMETER FOR    * 04657721
*    PROPER POSITIONING OF PERIODS, NUMERIC CHARACTERS, AND THE EX-   * 04660000
*    CEEDING OF PROPER LIMITS FOR HOUR, MINUTE OR SECOND. A VALID     * 04680000
*    PARAMETER IS PACKED IN THE XSA TEMPORARILY, IN XAS.              * 04700000
*                                                                     * 04720000
SCLOCK   EQU   *                                                        04740000
         LA    R8,D1(R8)           INCREMENT PROCESSED KEYWORD    21774 04750021
*                                       COUNTER BY ONE            21774 04752021
         CLI   PERD1(R9),C'.'      CHECK FOR PROPER PLACEMENT     21774 04760021
         BNE   SERR07                        INCORRECT                  04780000
         CLI   PERD2(R9),C'.'                OF PERIODS                 04800000
         BNE   SERR07                        INCORRECT                  04820000
         MVC   XAS(2),0(R9)                  PLACE TIME IN EXTENDED     04840000
         MVC   XAS+2(2),3(R9)                SAVE AREA                  04860000
         MVC   XAS+4(2),6(R9)                SANS PERIODS.              04880000
         LA    R11,6                         LOAD LOOP CONTROL REGISTER 04900000
         LA    R9,XAS                        SET PTR TO TIME            04920000
         BAL R13,SCHECK                      VERIFY TIME DIGITS   20071 04950020
         CLC   XAS(2),SETCHR                 DOES HOUR EXCEED 23        04980000
         BH    SERR06                        YES. ERROR                 05000000
         CLC   XAS+2(2),SETCMS               DOES MINUTE EXCEED 59      05020000
         BH    SERR06                        YES. ERROR                 05040000
         CLC   XAS+4(2),SETCMS               DOES SECOND EXCEED 59      05060000
         BH    SERR06                        YES. ERROR                 05080000
         PACK  XAS+4(4),XAS(6)               PACK TIME FOR CONVERSION   05100000
         B     SETNXT                        GO CHECK NEXT KEYWORD      05120000
         EJECT                                                          05140000
* KEYWORD=DATE SUBROUTINE - SYNTAX CHECKS THE DATE PARAMETER FOR      * 05160000
*    PROPER POSITIONING OF PERIODS, NUMERIC CHARACTERS, AND THE EX-   * 05180000
*    CEEDING OF PROPER LIMITS FOR THE DAY. A VALID PARAMETER IS       * 05200000
*    PACKED IN THE XSA TEMPORARILY, IN XAV.                           * 05220000
*                                                                     * 05240000
SDATE    EQU   *                                                        05260000
         LA    R8,D1(R8)           INCREMENT PROCESSED KEYWORD    21774 05270021
*                                       COUNTER BY ONE            21774 05272021
         CLI   PERD1(R9),C'.'                IS PERIOD POSITIONED       05280000
         BNE   FOURD            No: is it 4-digit year?            @L02 05290000
         MVC   XAV(2),0(R9)                  CONSOLIDATE DATE WITHOUT   05320000
         MVC   XAV+2(3),3(R9)                PERIODS                    05340000
         LA    R11,5                         SET LOOP CONTROLLER TO 5   05360000
         LA    R9,XAV                        SET PTR TO DATE            05380000
         BAL   R13,SCHECK                    VERIFY DATE DIGITS   20071 05390020
         L     R1,CVTPTR                    GET PTR TO CVT        20071 05392020
         USING SETCVT,R1                    ESTAB CVT BASE        20071 05394020
         TM    CVTOPTB,CVTTOD               IS TOD SUPPORTED      20071 05396020
         BNO   CONTINU3                NO, DONT CHECK FOR 60      20071 05398020
         CLC   XAV(D2),SETCMS                IS YEAR LESS THAN 1960     05400020
         BNH   SERR06                        YES. INVALID NUMERIC 20071 05410020
CONTINU3 EQU   *                                                        05430020
         LA    R13,SETNXT          SET BRANCH TO NEXT KEYWORD      @D01 05431020
         CLC   XAV+2(3),SETDDY               DOES DAY EXCEED LIMIT      05440000
         BH    SERR06                        YES. ERROR                 05460000
         BL    SYEAR               BRANCH IF LESS THAN 366 DAYS    @D01 05461000
         LA    R13,LEAPYEAR        SET BRANCH TO YEAR VALIDITY     @D01 05462000
SYEAR    DS    0H                                                  @D01 05463000
         CLC   XAV+D2(D3),SET000             IS DAY 000 (ERROR)   M0777 05470021
         BE    SERR06                        YES.INVALID NUMERICS M0777 05472021
         PACK  XAV+4(4),XAV(5)               PACK DATE FOR CONVERSION   05480000
         BR    R13                                                 @D01 05480100
         EJECT                                                          05480200
PERD3    EQU   4                   DISPLACEMENT OF PERIOD          @L02 05480300
         SPACE 1                                                   @L02 05480400
*----------------------------------------------------------------* @L02 05480500
*        Date is not a valid two-digit year.  Adjust             * @L02 05480600
*        the end-of-parameter pointer (calculated from           * @L02 05480700
*        the parameter table entry for DATE) to add the          * @L02 05480800
*        two digits added by the four-digit year.  If            * @L02 05480900
*        that would exceed the buffer length, go to              * @L02 05481000
*        issue IEE308I TERM LENGTH ERROR message.                * @L02 05481100
*----------------------------------------------------------------* @L02 05481200
FOURD    LA    R3,2(,R3)           Adjust end pointer              @L02 05481300
         C     R3,XAP              Does it exceed buffer?          @L02 05481400
         BH    SERR08              Yes: error                      @L02 05481500
         SPACE 1                                                   @L02 05481600
*----------------------------------------------------------------* @L02 05481700
*        Test if date could be a four-digit year.  If not,       * @L02 05481800
*        go to issue IEE307I DELIMITER ERROR,                    * @L02 05481900
*----------------------------------------------------------------* @L02 05482000
         CLI   PERD3(R9),C'.'      Is is 4-digit year?             @L02 05482100
         BNE   SERR07              No: error                       @L02 05482200
         SPACE 1                                                   @L02 05482300
*----------------------------------------------------------------* @L02 05482400
*        Date is potentially a valid four-digit year.            * @L02 05482500
*        Remove the period delimiter between year and            * @L02 05482600
*        day to make date "YYYYDDD".                             * @L02 05482700
*----------------------------------------------------------------* @L02 05482800
         MVC   XAV(4),0(R9)        Consolidate date                @L02 05482900
         MVC   XAV+4(3),5(R9)       without periods                @L02 05483000
         SPACE 1                                                   @L02 05483100
*----------------------------------------------------------------* @L02 05483200
*        Call SCHECK subroutine to verify that the date          * @L02 05483300
*        string contains valid zoned decimal numerics.  R11      * @L02 05483400
*        is set to the length of the string to be validated      * @L02 05483500
*        by SCHECK, and R9 is pointed at the string to be        * @L02 05483600
*        validated.                                              * @L02 05483700
*----------------------------------------------------------------* @L02 05483800
         LA    R11,7               Set date length                 @L02 05483900
         LA    R9,XAV              Set date address                @L02 05484000
         BAL   R13,SCHECK          Verify date digits              @L02 05484100
         SPACE 1                                                   @L02 05484200
*----------------------------------------------------------------* @L02 05484300
*        The date string is all valid numerics.  Test for        * @L02 05484400
*        the maximum year we'll allow, 2099.  If the             * @D03 05484500
*        specified year is greater than 2099, go to              * @D03 05484600
*        issue IEE306I INVALID NUMERICS error message.           * @L02 05484700
*----------------------------------------------------------------* @L02 05484800
         CLC   XAV(D4),MAXYR       Year GT 2099?                   @D03 05484900
         BH    SERR06              Yes: invalid numerics           @L02 05485000
         SPACE 1                                                   @L02 05485100
*----------------------------------------------------------------* @L02 05485200
*        Ensure that the specified year is at least 1960.        * @L02 05485300
*        Branch to issue IEE306I INVALID NUMERICS error          * @L02 05485400
*        message if not.                                         * @L02 05485500
*----------------------------------------------------------------* @L02 05485600
CONT     CLC   XAV(D4),MINYR       Year GE 1960?                   @L02 05485700
         BL    SERR06              No: invalid numerics            @L02 05485800
         SPACE 1                                                   @L02 05485900
*----------------------------------------------------------------* @L02 05486000
*        Ensure that the specified day is not 000.               * @L02 05486100
*        Branch to INVALID NUMERICS error if day                 * @L02 05486200
*        specified as 000.  If day is 000, go to                 * @L02 05486300
*        issue IEE306I INVALID NUMERICS error message.           * @L02 05486400
*----------------------------------------------------------------* @L02 05486500
         CLC   XAV+D4(D3),SET000   Is DDD=000?                     @L02 05486600
         BE    SERR06              Yes: invalid numerics           @L02 05486700
         SPACE 1                                                   @L02 05486800
*----------------------------------------------------------------* @L02 05486900
*        Assume the specified year is not a leap year,           * @L02 05487000
*        and initialize the SDATE subroutine exit address        * @L02 05487100
*        accordingly to branch to SETNXT.                        * @L02 05487200
*----------------------------------------------------------------* @L02 05487300
         LA    R13,SETNXT          Assume not leap year            @L02 05487400
         SPACE 1                                                   @L02 05487500
*----------------------------------------------------------------* @L02 05487600
*        Test for day specified as 366.  If specified            * @L02 05487700
*        day is greater than 366, it's an error.  In             * @L02 05487800
*        that case, go to issue IEE306I INVALID NUMERICS         * @L02 05487900
*        error message.  If the day is less than 366, we         * @L02 05488000
*        don't need to know if this is a leap year and           * @L02 05488100
*        will exit to SETNXT.                                    * @L02 05488200
*----------------------------------------------------------------* @L02 05488300
         CLC   XAV+4(3),SETDDY     Day GT 366?                     @L02 05488400
         BH    SERR06              Yes: error                      @L02 05488500
         BL    SYEAR1              No: skip leap year validation   @L02 05488600
         SPACE 1                                                   @L02 05488700
*----------------------------------------------------------------* @L02 05488800
*        Specified day is 366.  Change the SDATE exit            * @L02 05488900
*        address to branch to "LEAPYEAR" leap year               * @L02 05489000
*        validity check.                                         * @L02 05489100
*----------------------------------------------------------------* @L02 05489200
         LA    R13,LEAPYEAR        Set leap year validity check    @L02 05489300
         SPACE 1                                                   @L02 05489400
*----------------------------------------------------------------* @L02 05489500
*        Convert the specified date from zoned decimal           * @L02 05489600
*        to packed, and subtract 1900 from the year to           * @L02 05489700
*        leave the date in the form returned by SVC 11.          * @L02 05489800
*----------------------------------------------------------------* @L02 05489900
SYEAR1   PACK  XAV+4(4),XAV(7)     Make date packed                @L02 05490000
         XR    R4,R4               Clear first word                @L02 05490100
         ST    R4,XAV               for CVB                        @L02 05490200
         CVB   R5,XAV              Convert yyyydddF to binary      @L02 05490300
         S     R5,ADJ1900          Less 1900 years                 @L02 05490400
         CVD   R5,XAV              Back to packed ccyydddC         @L02 05490500
         OI    XAV+7,X'0F'         Force unsigned ccyydddF         @L02 05490600
         SPACE 1                                                   @L02 05490700
*----------------------------------------------------------------* @L02 05490800
*        Exit from SDATE to the next routine, whose              * @L02 05490900
*        address has already been placed in R13.                 * @L02 05491000
*----------------------------------------------------------------* @L02 05491100
         BR    R13                 To next routine                 @L02 05491200
         SPACE 1                                                   @L02 05491300
*----------------------------------------------------------------* @L02 05491400
*        Constants for date check.                               * @L02 05491500
*----------------------------------------------------------------* @L02 05491600
ADJ1900  DC    A(1900*1000)        For year adjustment             @L02 05491700
MAXYR    DC    CL4'2099'           Last last valid year            @D03 05491800
MINYR    DC    CL4'1960'           First valid year                @L02 05491900
         EJECT ,                                                   @L02 05492000
****************************************************************** @D01 05492100
*                                                                * @D01 05492200
* THIS ROUTINE, ENTERED ONLY AFTER A DATE WITH 366 DAYS          * @D01 05492300
* IS ENCOUNTERED, CHECKS FOR THE VALIDITY OF THE 366 DAYS IN     * @D01 05492400
* THE YEAR.  THE YEAR IN QUESTION IS DIVIDED BY 4, AND IF A      * @D01 05492500
* REMAINDER IS PRESENT, THE ROUTINE LEADS TO AN ERROR MESSAGE    * @D01 05492600
* ISSUED.  NORMAL PROCESSING IS CONTINUED FOR A VALID LEAP       * @D01 05492700
* YEAR.                                                          * @D01 05492800
*                                                                * @D01 05492900
****************************************************************** @D01 05493000
*/*LEAPYEAR:2J2 P OBTAIN THE YEAR */                               @D01 05493100
LEAPYEAR DS    0H                                                  @D01 05493200
         SR    R4,R4               CLEAR REGISTER                  @D01 05493300
         ST    R4,XAV              CLEAR FIRST WORD FOR 'CVB'      @D01 05493400
         CVB   R5,XAV              CONVERT TO BINARY               @D01 05493500
         D     R4,D1000            SHIFT OFF DDD                   @D01 05493600
*/*2J4 D (NO,SERR06,YES,SETNXT) IS IT PERFECTLY DIVISIBLE BY 4? */ @D01 05493700
         SLL   R5,D30              SHIFT OFF ALL BUT BITS 30-31    @D01 05493800
         LTR   R5,R5               EITHER 0NE ON?                  @D01 05493900
         BNZ   SERR06              YES, ERROR.  NOT A LEAP YEAR    @D01 05494000
         B     SETNXT              GO CHECK NEXT KEYWORD           @D01 05494100
         SPACE 1                                                   @D01 05494200
D30      EQU   30                                                  @D01 05494300
D1000    DC    F'1000'             CONSTANT FOR SHIFTING OFF DDD   @D01 05494400
*                                   OF YYDDD CONVERTED TO BINARY   @D01 05494500
         EJECT ,                                                   @D01 05494600
* THE FOLLOWING CLOSED SUBROUTINE IS USED BY SCLOCK AND SDATE TO      * 05540000
*    CHECK THAT ALL PARAMETER CHARACTERS ARE NUMERIC. R11 IS LOOP     * 05560000
*    COUNTER, R13 IS RETURN REGISTER, R9 POINTS TO THE PARAMETER. 21774 05580021
*                                                                     * 05600000
SCHECK   EQU   *                                                        05620000
         SR    R4,R4                         SET INCREMENT REGS TO ZERO 05640000
         SR    R6,R6                                                    05660000
         LA    R5,SNUMLO                     SET LOWER LIMIT OF DIGIT   05680000
         LA    R7,SNUMHI                     SET UPPER LIMIT OF DIGIT   05700000
SDGTLP   EQU   *                                                  21774 05710021
         SR    R15,R15             CLEAR FOR LOADING              21774 05720021
         IC    R15,D0(R9)          TAKE ONE CHARACTER             21774 05740021
         BXLE  R15,R4,SERR06       TEST FOR LOW                   21774 05760021
         BXH   R15,R6,SERR06       TEST FOR HIGH                  21774 05780021
         LA    R9,1(R9)                      INCREMENT CHARACTER PTR    05800000
         BCT   R11,SDGTLP                    IS LOOP DONE               05820000
         BR    R13                           YES. RETURN          20071 05840020
         EJECT                                                          05860000
* RETURNED TO FROM A KEYWORD SUBROUTINE, THIS PORTION OF THE MAIN 21774 05870021
*    ROUTINE CHECKS IF THE SET COMMAND IS COMPLETE OR IF THERE    21774 07620021
*    ARE MORE KEYWORDS. A COMMA AS DELIMITER RESULTS IN THE       21774 07640021
*    RETURN TO THE KEYWORD TABLE SCAN FOR THE NEW KEYWORD.        21774 07660021
*    SUCCESSFUL COMPLETION LEADS TO 'SETOUT'.                     21774 07680021
*                                                                     * 07700000
SETNXT   EQU   *                                                        07720000
         C     R3,XAP                        IS IT VALID END OF BUFFER  07740000
         BE    SETOUT                        YES. END OF SET COMMAND    07760000
         CLI   0(R3),C' '                    IS NEXT CHARACTER A BLANK  07780000
         BE    SETOUT                        YES. END OF SET COMMAND    07800000
         CLI   0(R3),C','                    IS NEXT CHARACTER A COMMA  07820000
         BNE   SERR08                        NO. MUST BE ERROR          07840000
         LA    R9,1(R3)                      YES. BUMP CURRENT PARAM    07860000
         CLI   0(R9),C' '                    IS NEXT CHAR BLANK         07880000
         BE    SERR07                        YES. DELIMITER ERROR.      07900000
         B     SNEWKY                        GO CHECK NEXT KEYWORD.     07920000
         EJECT                                                          07940000
* AFTER THE COMMAND'S CONTENTS HAVE BEEN COMPLETELY VERIFIED, THIS    * 07960000
*    SECTION PERFORMS THE FOLLOWING FUNCTIONS: IF IT IS IPL TIME AND  * 07980000
*    THE DATE HAS BEEN SPECIFIED, CONTROL IS PASSED TO IEE8603D.  21774 08000021
*    IF NOT IPL TIME, ANY SPECIFIED TIME OR DATE IS SAVED IN THE  21774 08040021
*    XSA AND CONTROL IS ALSO GIVEN TO IEE8603D.                   21774 08060021
*                                                                     * 08080000
SETOUT   EQU   *                                                        08100000
         STC   R8,XAU+D4           SAVE PROCESSED KEYWORD COUNTER 21774 08110021
         TM    BASFL,BAIN                    IS IT IPL TIME             08120000
         BO    SNOIPL              NO                             21774 08140021
         TM    XAE,TWO             YES, IS DATE SET FOR IPL?      21774 08160021
         BZ    SERR10              NO, ERROR                      21774 08180021
SXCTL    EQU   *                                                  21774 08424021
         SR    R15,R15             SET DCB POINTER TO ZERO        21774 08460021
         ST    R15,XAD                                                  08480000
         LA    R15,XAX                       PUT PTR TO NAME IN LIST    08500000
         ST    R15,XAP                                                  08520000
         LR    R15,R2                        PUT PTR TO LIST IN REG 15  08540000
         XCTL  SF=(E,(15))                   PASS CONTROL               08560000
SNOIPL   EQU   *                                                  21774 08790021
         TM    XAE,THREE           IS DATE OR CLOCK SPECIFIED?    21774 08792021
         BNZ   SXCTL               YES, GO TO XCTL                21774 08794021
         B     SERR10              NO, ERROR EXIT                 21774 08796021
         EJECT                                                          08800000
* THE FOLLOWING INSTRUCTIONS PASS A DESIGNATED ERROR CODE TO THE      * 08820000
*    SET COMMAND ERROR SUBROUTINE, 'SETERR', IN REGISTER 5.           * 08840000
*                                                                     * 08860000
SERR06   BAL   R5,SETERR                     ERROR CODE = 6             08880000
         DC    AL1(ERR6)                                                08900000
*                                                                     * 08920000
SERR07   BAL   R5,SETERR                     ERROR CODE = 7             08940000
         DC    AL1(ERR7)                                                08960000
*                                                                     * 08980000
SERR08   BAL   R5,SETERR                     ERROR CODE = 8             09000000
         DC    AL1(ERR8)                                                09020000
*                                                                     * 09040000
SERR10   BAL   R5,SETERR                     ERROR CODE =10             09120000
         DC    AL1(ERR10)                                               09140000
*                                                                     * 09160000
SERR11   BAL   R5,SETERR                     ERROR CODE =11             09180000
         DC    AL1(ERR11)                                               09200000
*                                                                     * 09220000
SERR12   BAL   R5,SETERR                     ERROR CODE =12             09240000
         DC    AL1(ERR12)                                               09260000
         EJECT                                                          09340000
* ERROR SUBROUTINE - RECEIVES IN REGISTER 5 AN ERROR MESSAGE CODE     * 09360000
*    WHICH IS PLACED IN THE XSA (IN XAE). CONTROL GOES TO THE MESSAGE * 09380000
*    ASSEMBLY MODULE, IEE0503D, BY XCTL.                              * 09400000
SETERR   DS    0H                                                       09420000
         MVC   XAV(8),SETSET                 MOVE VERB NAME TO XSA      09440000
         MVC   XAE(1),0(R5)                  INSERT ERROR CODE          09460000
         MVC   XAX+D3(2),C05       GO TO IEE0503D                 21774 09480421
         L     R1,CVTPTR               GET PTR TO CVT             M2081 09481020
         USING SETCVT,R1               ESTAB ADDRESSABILITY       M2081 09482020
         TM    CVTOPTB,CVTTOD          IS TOD SUPPORTED           M2081 09483020
         BZ    SXCTL                   NO. NO ERROR CODE          M2081 09484020
         LA    R15,D8                  SET UP BAD SET RETURN CODE 20071 09486020
         ST    R15,BAIPL               PUT RET CODE IN IPL ECB    20071 09492020
         B     SXCTL                         GO TO XCTL EXIT            09500000
         EJECT                                                          09520000
* THE FOLLOWING TABLE CONTROLS THE SCAN OF INCOMING KEYWORDS AND THE  * 09540000
*   BRANCHING TO SPECIFIC KEYWORD SUBROUTINES.                        * 09560000
*                                                                     * 09580000
         DS    0H                                                       09600000
KEYTAB   EQU   *                                                        09620000
         DC    X'5'                          KEYWORD LENGTH MINUS ONE   09640000
         DC    X'8'                          PARAMETER DELIMITER        09660000
         DC    C'CLOCK='                     KEYWORD                    09680000
         B     SCLOCK                        SPECIFIC CODING            09700000
         DC    X'01'                         KEYWORD ID MASK PATTERN    09720000
         DS    C                             FILLER                     09740000
*                                                                     * 09760000
         DC    X'4'                          KEYWORD LENGTH MINUS ONE   09780000
         DC    X'6'                          PARAMETER DELIMITER        09800000
         DC    C'DATE='                      KEYWORD                    09820000
         DC    C' '                          FILLER                     09840000
         B     SDATE                         SPECIFIC CODING            09860000
         DC    X'02'                         KEYWORD ID MASK PATTERN    09880000
ENDTAB   DS    C                   FILLER                         21774 09900021
KEYTBL   EQU   (ENDTAB-KEYTAB)     LENGTH OF TABLE                21774 10390021
         EJECT                                                          10400000
* CONSTANTS USED BY THE IMMEDIATE COMMANDS ROUTINE                    * 10420000
*                                                                     * 10440000
         DS    0F                                                       10500000
         DC    X'0000'                                                  10520000
SFFFF    DC    X'FFFF'                                                  10540000
*                                                                     * 10560000
XL8603D  DC    C'IGC8603D'         NAME OF IEE8603D MODULE        21774 10600021
C05      DC    C'05'               OVERLAY FOR ERROR MODULE       21774 10610021
*                                       XCTL'ING                  21774 10612021
*                                                                     * 10620000
SETCHR   DC    C'23'                         MAXIMUM HOUR               10640000
SETCMS   DC    C'59'                         MAXIMUM MINUTE OR SECOND   10660000
SETDDY   DC    C'366'                        MAXIMUM DAY                10680000
SET000   DC    C'000'              DAY 000 IS IN ERROR            M0777 10690021
*                                                                     * 10700000
SETSET   DC    C'SET     '         VERB FOR MESSAGE MODULE        21774 10702021
*                                                                 21774 10710021
SETCLC   CLC   0(1,R9),KEYWRD(R4)            COMPARE NEW KW WITH TAB KW 10780000
SETTMP   TM    XAE,ZERO            TEST ID MASK PATTERN           21774 10800021
         EJECT                                                          10920000
SETXSA   DSECT                                                          10940000
         IEEXSA                                                         10960000
         EJECT                                                          10980000
SETCVT   DSECT                                                          11000000
         CVT                                                            11020000
         EJECT                                                          11040000
         IEEBASEA                                                       11060000
         END                                                            11080000
./ ADD NAME=IEE3503D
         TITLE 'IEE3503D - DISPLAY ROUTER'                              00100019
*********************************************************************** 00400019
*                                                                     * 00600019
*  ROUTINE NAME - IEE3503D - ROUTER FOR DISPLAY COMMANDS              * 00800019
*                                                                     * 01000019
*  FUNCTION -  THIS MODULE DETERMINES THE DISPLAY COMMAND OPERAND:    * 01200019
*              JOBNAMES,JOBNAMES,T,SPACE,DSNAME,STATUS,CONSOLES(FOR   * 01400019
*              CONSOLES (FOR MCS ONLY); T; A; D; R; M; U; TP; Q;  21002 01450021
*              N; C; K; SQA                                     A40792* 01500021
*              FOR R, NO CSCB IS BUILT. 3503D XCTLS TO 2903D     21002* 01550021
*              WITH REGISTER 2 POINTING TO THE XSA               21002* 01560021
*              FOR D U, THE VERB CODE IN XAN IS CHANGED TO X'50' 21002* 01570021
*              (VERB CODE WILL GO IN CSCB. WHERE IT WILL BE      21002* 01580021
*              CHECKED BY IEEVWAIT TO DETERMINE WHICH TO ATTATCH 21002* 01590021
*              IEEUNIT1 FOR D U)                                 21002* 01592021
*              FOR D U; C,K; A; N; A; CONSOLES; AND M A BIT IS   21002* 01594021
*              SET IN THE XSA (TO BE USED BY 803D) TO INDICATE A 21002* 01596021
*              STATUS DISPLAY                                    21002* 01598021
*              FOR TP=, IEE3503D XCTL'S TO IGC1303D               20002 02950020
*              FOR DISPLAY CLOCK, THE FOLLOWING MESSAGE IS WRITTEN    * 03200019
*              TO THE OPERATOR.                                       * 03400019
*              IEE136I    TIME=xx.xx.xx   DATE=xxxx.xxx            @L01 03600019
*              FOR SQA, IEE3503D XCTLS TO IEE8503D              A40792* 03650021
*                                                                     * 03800019
*  ENTRY POINT - IEE3503D FROM IEE0403D (IEE3503D CONTAINED IN        * 04000019
*                LOAD MODULE IGC3503D                                 * 04200019
*                                                                     * 04400019
*  ATTRIBUTES - REENTRANT,SVC TRANSIENT                               * 04600019
*                                                                     * 04800019
*  EXTERNAL REFERENCES -                                              * 05000019
*              - IEE0503D AND IEE2103D  (MESSAGES)                    * 05200019
*              - IEE2903D  (DISPLAY R)                                * 05400019
*              - IEE0803D  (CSCB CREATION)                            * 05600019
*              -  IEE7503D (ROUTING LOCATION)                    21002* 05800021
*              - IED1303D  (DISPLAY TP,)                          20002 05900020
*              - IEE8503D  (DISPLAY SQA)                        A40792* 05950021
*              -  IEEBASEA  (MACRO)                                   * 06000019
*              -  IEEXSA  (MACRO)                                     * 06200019
*              - CVT  (MACRO)                                         * 06400019
*              -  IEECUCM  (MACRO)                                    * 06600019
*                                                                     * 07000019
*  INPUT - PTR TO XSA IN REGISTER 2                                   * 07200019
*          XAL POINTS TO 1ST CHARACTER OF PARAMETERS.             M4316 07300019
*          XAU HAS 1-BYTE UCMI (0 FOR INTERNAL CM).               M4316 07400019
*          XAX HAS THIS MODULE'S LOAD NAME--IGC3503D (THE '35'    M4316 07500019
*          WILL BE CHANGED FOR XCTL TO NEXT LOAD.)                M4316 07600019
*                                                                     * 07800019
*  OUTPUT - BITS SET IN MASTER RESIDENT CORE                          * 08000019
*           BITS SET IN UCME                                          * 08200019
*           ERROR CODES FOR MESSAGES ISSUED IN IEE0503D AND 2103D     * 08400019
*           MESSAGE FOR TIME                                          * 08600019
*                                                                     * 08800019
*  EXIT  -  VIA BR 14                                                 * 09000019
*        -  XCTL TO 2903D FOR D R                                     * 09200019
*        -  XCTL TO 0803D FOR CSCB CREATION                           * 09600019
*        -  XCTL TO 7503D FOR ROUTING LOCATION                   21002* 09660021
*        -  XCTL TO 1303D FOR DISPLAY TP,                         20002 09690020
*        -  XCTL TO 0503D OR 2103D FOR MESSAGES                         09720019
*        -  XCTL TO 8503D FOR DISPLAY SQA                       A40792* 09770021
*                                                                     * 09800019
*  TABLES  -   A TABLE IS USED TO  DETERMINE THE OPERAND OF THE       * 10000019
*              DISPLAY COMMAND. THE FORMAT OF EACH ENTRY IS THE SAME. * 10200019
*                                                                     * 10400019
*              DLEN   DC   AL1(L'XXX-1) - LENGTH OF SPECIFIC OPERAND  * 10600019
*              XXX    DC   C'YYYYY' - CHARACTER REP. OF OPERAND       * 10800019
*                                                                     * 11000019
*              DLEN AND 'XXX' ARE USED IN AN EX OF A CLC. IF THE      * 11200019
*              OPERANDS MATCH, A BRANCH IS TAKEN TO ADDRESS SEVERAL   * 11400019
*              CONTROL BLOCKS AND THEN BRANCH TO THE PROPER PROCESSOR.* 11600019
*              OTHERWISE, THE REGISTER USED TO ADDRESS THE TABLE IS   * 11800019
*              INCREMENTED BY TWO + THE VALUE OF DLEN TO REACH THE    * 12000019
*              NEXT TABLE ENTRY.                                      * 12200019
*                                                                     * 12400019
*              A BRANCH TABLE IS USED IN CONNECTION WITH THE COMPARE  * 12600019
*              TABLE. IT CONSISTS OF BRANCHES TO THE PROPER OPERAND   * 12800019
*              PROCESSORS. AN INDEX REGISTER IS MAINTAINED THROUGHOUT * 13000019
*              THE SCAN OF THE COMPARE TABLE. THIS IS USED AT DBRANCH * 13200019
*              TO GIVE CONTROL TO THE INDICATED PROCESSOR VIA         * 13400019
*              THE BRANCH TABLE.                                      * 13600019
*                                                                     * 13800019
* Change activity      =                                              * 13810019
*                                                                     * 13820019
*   Flag  Date        By    Description                               * 13830019
*   ----  ----------  ----  --------------------------------------    * 13840019
*   $L01  2017/09/15  KL    TMVT805 Four-digit year support.       @L01 13850019
*                                                                     * 13860019
*********************************************************************** 14000019
         EJECT                                                          14200019
         IEEBASEA                                                       14400019
         EJECT                                                          14600019
IEEXSA   DSECT                                                          14800019
         IEEXSA                                                         15000019
* THE XAS IS USED AS A TEMPORARY WORK AREA BETWEEN IEE0803D,      21002 15050021
* IEE3503D, IEE5503D, IEE6703D, IEE7103D                          21002 15100021
         ORG   XAS                                                21002 15150021
XASCID   DS    C                       CONSOLE ID                 21002 15160021
XASDID   DS    C                       DISPLAY AREA ID            21002 15170021
XASSDS   DS    C                       SDS SWITCHES               21002 15180021
XASSDS1  EQU   X'80'                   INDICATE STATUS DISPLAY    21002 15190021
XASSDS3  EQU   X'20'                   INDICATE RETION BUSY       21002 15192021
         EJECT                                                          15200019
DDCVT    DSECT                                                          15400019
         CVT                                                            15600019
         EJECT                                                          15800019
UCMDSECT DSECT                                                          16000019
         IEECUCM                                                        16200019
         EJECT                                                    20030 16230020
         IKJTSCVT                                                 M4828 16260020
         EJECT                                                    20030 16290020
         IKJTJB                                                   M4828 16320020
         EJECT                                                          16350020
         EJECT                                                          16400019
IEE3503D CSECT                                                          16600019
* C 015000                                                       A40792 16600421
* A 036500,059500,097700,328500-328960,657700,695100             A40792 16600821
* A 751620-751640                                                A40792 16601221
*                                                                A34263 16602020
* 016000-029000,030800-031200,058000,096600,234500-235000,246000, 21002 16602121
* 260200,275200-275800,285400-287800,303000-304000,312000,325000, 21002 16604021
* 337000-375000,382000-383000,384000-531000,614400-614600,645000, 21002 16604421
* 678000-683000,713000-738000                                     21002 16604821
* C 357900                                                        M2079 16605020
* 677000                                                          M0467 16610020
* 016000                                                          20002 16620020
* 030400,284000-288000,339000,349000,360000,370000,386000,680000, 20030 16640020
* 716000-718000,724000-726000                                     20030 16660020
* 252000-254000,265000-269000,270000,311000,354000,365000,395000  M4316 16700019
* 616000,750000-750800                                            M3123 16750019
* 405000,410300                                                   M2517 16760020
*                                                                A35705 16770020
*********************************************************************** 16800019
*                                                                     * 17000019
*                         REGISTER    EQUATES                         * 17200019
*                                                                     * 17400019
*********************************************************************** 17600019
R0       EQU   0                  WORK REGISTER                         17800019
R1       EQU   1                  WORK REGISTER                         18000019
R2       EQU   2                  PTR TO XSA                            18200019
R3       EQU   3                  MODULE BASE REGISTER                  18400019
R4       EQU   4                  USED FOR BASEA AND WORK REGISTER      18600019
R5       EQU   5                  PTR TO LIST                           18800019
R6       EQU   6                  USED TO ADDRESS TABLE ENTRIES         19000019
R7       EQU   7                  BASE FOR CVT                          19200019
R8       EQU   8                  STAE                                  19400019
R9       EQU   9                  WORK REGISTER                         19600019
R10      EQU   10                 UCM BASE REGISTER                     19800019
R11      EQU   11                 ADDRESSES END OF TABLE                20000019
R12      EQU   12                 UCMPRFX BASE                          20200019
R13      EQU   13                 UNUSED                                20400019
R14      EQU   14                 RETURN ADDRESS                        20600019
R15      EQU   15                 USED FOR BAL                          20800019
*********************************************************************** 21000019
*                                                                     * 21200019
*                      DISPLACEMENTS AND LENGTHS                      * 21400019
*                                                                     * 21600019
*********************************************************************** 21800019
D0       EQU   0                                                        22000019
D1       EQU   1                                                        22200019
D2       EQU   2                                                        22400019
D3       EQU   3                                                        22600019
D4       EQU   4                                                        22800019
D5       EQU   5                                                        23000019
D6       EQU   6                                                        23200019
D7       EQU   7                                                        23400019
D24      EQU   24                                                 20030 23550020
L1       EQU   1                                                        23600019
L2       EQU   2                                                        23800019
L3       EQU   3                                                        24000019
L4       EQU   4                                                        24200019
L8       EQU   8                                                        24400019
ZERO     EQU   0                                                        24800019
ONE      EQU   1                                                        25000019
FLAG     EQU   X'80'              FLAG - DENOTES TPUT RETRY       20030 25100020
MFT      EQU   X'20'               MFTII BIT IN CVT               M4316 25200019
X50      EQU   80                 VERB CODE FOR DISPLAY UNITS      O111 25500019
DD11     EQU   11                 MASK FOR CODE-PARAMETER MISSING       25600019
DD37     EQU   37                 MASK FOR TASK BUSY MESSAGE            25800019
DD39     EQU   39                 CODE = NOT IN MCS SYSTEM              26000019
DUVBCD   EQU   164                VERB CODE FOR D USER CMD        20030 26040020
MONITOR  EQU   100                MONITOR VERB COCE               20030 26060020
         EJECT                                                          26100019
         BALR  R3,0               ESTABLISH PROGRAM ADDRESSABILITY      26200019
         USING *,R3                                                     26300019
         USING IEEXSA,R2          ADDRESS EXTENDED SAVE AREA            26400019
         L     R7,CVTPTR               ADDRESS OF CVT             21002 26410021
         USING DDCVT,R7                ESTABLISH ADDRESS. FOR CVT 21002 26450021
         L     R4,CVTMSER   ADDRESS OF MASTER RES. CORE           21002 26500021
         USING BASE,R4       ADDRESS. FOR MASTER RESID CORE       21002 26550021
         XC    XAS(L4),XAS             CLEAR TEMP WORK AREA       21002 26560021
         TM    BASFL,BADSP             IS REGION BUSY BIT ON      21002 26600021
         BNO   PARMCK                  NO, CHECK FOR PARM         21002 26650021
         OI    XASSDS,XASSDS3          INDICATE BUSY BIT SET      21002 26660021
PARMCK   EQU   *                                                  21002 26670021
         L     R5,XAL             GET PTR TO PARAMETERS                 26700019
         LA    R5,D0(R5)          CLEAR HIGH ORDER BYTE                 27100019
         LTR   R5,R5              ARE THERE ANY PARAMETERS              27200019
         BZ    DERR1              NO,ERROR/ PARAMETER MISSING           27300019
         SR    R9,R9              CLEAR REGISTER FOR INSERT             27400019
         SR    R15,R15            USED TO INDEX BRANCH TABLE            27500019
         LA    R11,DENTAB         CALCULATE TABLE END ADDRESS           27600019
         LA    R6,DTAB            CALCULATE TABLE BEGIN ADDRESS         27700019
         USING DTAB,R6            EST. ADDRESSABILITY TO TABLE          27800019
DLOOP    IC    R9,DLEN            GET LENGTH-1 OF PARAMETER             27900019
         EX    R9,DCOMPARE        CHECK FOR MATCH                       28000019
         BE    DBRANCH            IF MATCH,PROCESS ACCORDINGLY          28100019
         LA    R6,D2(R9,R6)       NO MATCH, INCRE TO NEXT TABLE ENTRY   28200019
         LA    R15,D4(R15)        INCRE INDEX FOR BRANCH TABLE          28300019
         CR    R6,R11    HAS END OF COMPARE TABLE BEEN REACHED    M0467 28340020
         BL    DLOOP              NO, GO BACK AND CHECK NEXT      20030 28380020
*                                 TABLE PARAMETER                 20030 28460020
         B     D803D                   MUST BE DISPLAY NAME OF JOB21002 28540021
DBRANCH  EQU   *                                                        28900019
         L     R10,CVTCUCB        ADDRESS OF UCM                        29300019
         LH    R9,XAJ             TJID                            20030 29450020
         B     BRTABLE(R15)       BRANCH TO PROPER PROCESSOR            29500019
*********************************************************************** 29600019
*                                                                     * 29700019
*                            DISPLAY UNITS                      *  O111 29800019
*                                                                     * 29900019
*********************************************************************** 30000019
DDUNT    EQU   *                                                   O111 30100019
MREGION  EQU   XAS+D4                  SIGNIFIES COMMAND TO BE    M6209 30150020
*                                      PROCESSED IN MASTER REGIONA34263 30160020
         MVI   XAN,X50            MOVE VERB CODE FOR D U TO XSA    O111 30200019
*********************************************************************** 30300021
*                                                                     * 30350021
*                            DISPLAY C,K                         21002  30400021
*                            DISPLAY N                           21002  30450021
*                            DISPLAY Q                           21002  30460021
*                                                                     * 30470021
*********************************************************************** 30480021
DSDS     EQU   *                                                  21002 30490021
         MVC   XAX+D3(L2),X75          IGC7503D                   21002 30492021
         B     DEXIT                   XCTL TO IEE7503D           21002 30494021
*********************************************************************** 30500019
*                                                                     * 30600019
*                           DISPLAY  ACTIVE                           * 30700019
*                                                                     * 30800019
*********************************************************************** 30900019
DDACT    EQU   *                                                        31000019
         TM    CVTDCB,MFT              IS THIS MFT                21002 31050021
         BO    DSDS                    YES, DON'T CK BUSY BIT     21002 31100021
         TM    BASFL,BADSP        IS REGION BUSY BIT ON                 31300019
         BO    DMSG               YES,PREPARE TO WRITE BUSY MSG         31400019
         OI    BASFL,BADSP        SET BUSY INDICATOR                    31500019
         ST    R2,MREGION              SAVE IN THE EVENT GETMAIN A34263 31550020
         LTR   R9,R9              CMD BACKGROUND OR FOREGROUND    21002 31550121
*                                      FOR CSCB IN IEE0803D FAILSA34263 31560020
         BZ    DSDS                    FOREGROUND, XCTL TO 7503D  21002 31560121
         B     D803D              XCTL TO CREATE CSCB                   31600019
*********************************************************************** 31700019
*                                                                     * 31800019
*                         DISPLAY CONSOLES                            * 31900019
*                                                                     * 32000019
*********************************************************************** 32100019
DDCON    EQU   *                                                        32200019
         USING UCMXECB,R10        ADDRESSABILITY TO UCM                 32300019
         TM    UCMMODE,UCMMCS     IN MCS SYSTEM                         32400019
         BO    DSDS                    YES, XCTL TO 7503D         21002 32500021
         MVI   XAE,DD39           MESSAGE CODE NOT IN MCS SYSTEM        32600019
         MVC   XAX+D2(L3),X21     COMPLETE LOAD MOD NAME IGG2103D       32700019
         B     DEXIT              BRANCH FOR XCTL                       32800019
*********************************************************************** 32850021
*                                                                     * 32860021
*                      DISPLAY SYSTEM QUEUE AREA                      * 32870021
*                                                                     * 32880021
*********************************************************************** 32890021
DDSQA    EQU   *                                                 A40792 32892021
         MVC   XAX+D3(L2),X85      SET MODULE NAME TO IEE8503D   A40792 32894021
         B     DEXIT               BRANCH FOR XCTL TO IEE8503D   A40792 32896021
*********************************************************************** 32900019
*                                                                     * 33000019
*                           DISPLAY REQUESTS                          * 33100019
*                                                                     * 33200019
*********************************************************************** 33300019
DDREP    EQU   *                                                        33400019
         MVC   XAX+D3(L2),X29     COMPLETE LOAD MOD NAME IGC2103D       33500019
         B     DEXIT              BRANCH FOR XCTL                       33600019
**********************************************************************  33610020
*                                                                    *  33620020
*                              DISPLAY USER                       20030 33630020
*                                                                     * 33640020
*********************************************************************** 33650020
DDUSER   EQU   *                                                  20030 33660020
         MVI   XAN,DUVBCD          MOVE VERB CODE TO XSA          20030 33670020
         MVC   XAX+D3(L2),X58      SET MODULE NAME TO IGC5803D    20030 33680020
         B     DEXIT                GO TO XCTL RTN                20030 33690020
***************************************************************   19055 37600019
*                                                             *   19055 37700019
*                DISPLAY CONFIGURATION MATRIX                 *   19055 37800019
*                                                             *   19055 37900019
***************************************************************   19055 38000019
DDMTRX   DS    0H                  ENTRY FOR DISPLAY MATRIX       19055 38100019
         CLI   CVTDCB,X'14'  IS THIS MP SYS.                     A35705 38130020
         BC    7,NOTMP      NO INVALID COMMAND                   A35705 38160020
         TM    CVTDCB,MFT              IS THIS MFT                21002 38200021
         BO    DERR2                   YES, CMD IS INVALID        21002 38250021
         B     DSDS                    YES, XCTL TO 7503D         21002 38300021
NOTMP    MVI   XAE,X'05'    MESSAGE CODE INVALID CMD.            A35705 38330020
         B     D503D                                             A35705 38360020
*********************************************************************** 38400021
*                                                                     * 38450021
*                            DISPLAY PFK                         21002* 38500021
*                                                                     * 38550021
*********************************************************************** 38600021
DPFK     EQU   *                                                  21002 38650021
         B     D803D                   CREATE A CSCB              21002 38700021
*********************************************************************** 54400019
*                                                                     * 54600019
*                           DISPLAY  TIME                             * 54800019
*                                                                     * 55000019
*********************************************************************** 55200019
DDTIM    EQU   *                                                        55400019
XTM      EQU   XAT                                                      55600019
XDATE    EQU   XAS+D4                                                   55800019
         SR    R4,R4              CLEAR FOR IC                          56000019
         IC    R4,XAU             SAVE UCMI FOR WTO                     56200019
         LH    R5,XAJ              SAVE TJID                      20030 56300020
         TIME  DEC                Get date and time                @L01 56310020
         XC    XAV,XAV            Clear work area                  @L01 56320020
         ST    R1,XAV+4           Save date ccyydddF in work area  @L01 56330020
         CVB   R1,XAV             Convert ccyydddF to binary       @L01 56340020
         A     R1,ADJ1900         Adjust for century               @L01 56350020
         CVD   R1,XAV             Back to packed yyyydddC          @L01 56360020
         L     R1,XAV+4           Load date yyyydddC in R1         @L01 56370020
         MVC   XSA(DDLN),DDMSG    MOVE IN INCOMPLETE WTO MSG            56400019
         ST    R0,XTM             STORE TIME IN XSA AFTER 'TIME='       56800019
         UNPK  XTM(L8),XTM(L4)    UNPACK TIME                           57000019
         MVC   XTM(L2),XTM+D1     LEFT ADJUST HOURS                     57200019
         MVI   XTM+D2,C'.'        INSERT PERIOD                         57400019
         MVC   XTM+D7(L1),XTM+D6  RIGHT ADJUST  ....                    57600019
         MVC   XTM+D6(L1),XTM+D5  ....SECONDS                           57800019
         MVI   XTM+D5,C'.'        INSERT PERIOD                         58000019
         ST    R1,XDATE           PUT DATE IN XSA AFTER 'DATE= '        58200019
         UNPK  XDATE(L8),XDATE(L4)   UNPACK DATE                        58400019
         OI    XDATE+D7,BA0+BA1+BA2+BA3  SET LOW ORDER BYTE  EBCDIC     58600019
         MVC   XDATE(L4),XDATE+D1 Left adjust year                 @L01 58700019
         MVI   XDATE+D4,C'.'      Insert period                    @L01 58800019
**       MVC   XDATE+D3(L3),XDATE+D5  LEFT ADJUST DAY              @L01 58900019
**       MVC   XDATE+D6(L2),DDBLNK BLANK OUT ANY LEFT-OVERS        @L01 59000019
         LTR   R5,R5               TERMINAL REQUEST               20030 59460020
         BNZ   XTPUT               YES, GO TO PUT TIME MSG TO TERM20030 59520020
         LR    R0,R4              PUT UCMI INTO REG 0                   59600019
         WTO   MF=(E,(R2))        WRITE TO OPERATOR - TIME AND DATE     59800019
         BR    R14                RETURN TO SYSTEM                      60000019
XTPUT    EQU   *                                                  20030 60010020
         LH    R0,XAH              TEXT BY FOUR FOR TPUT (MSFLAGS)20030 60020020
         SH    R0,FOUR                                            20030 60030020
         LA    R1,XAI              ADDR OF MSG TEXT               20030 60040020
         TPUT  (1),(0),TJID=(5)   PUT MSG TO TERMINAL             20030 60050020
         CH    R15,ERRCODE        CHECK TPUT RETURN CODE          20030 60060020
         BCR   D7,R14             RETURN TO SYSTEM                20030 60070020
         TM    XAT+D24,FLAG       HAS A RETRY BEEN ATTEMPTED      20030 60080020
         BCR   D1,R14             YES. RETURN TO SYSTEM           20030 60090020
         OI    XAT+D24,FLAG       SET FLAG TO DENOTE RETRY        20030 60100020
         B     XTPUT              RETRY TPUT                      20030 60110020
*********************************************************************** 60120020
*                                                                 20002 60130020
*                            DISPLAY TP,                          20002 60140020
*                                                                 20002 60150020
*********************************************************************** 60160020
DDTPCOM  EQU   *                                                  20002 60170020
         MVC   XAX+D3(L2),X13     COMPLETE FOR XCTL TO IGC1303D   20002 60180020
         B     DEXIT              GO TO SET UP XSA FOR XCTL       20002 60190020
DERR1    EQU   *                                                        60200019
         MVI   XAE,DD11           ERROR CODE=11 FOR PARAMETER MISSING   60400019
         B     D503D                                              20030 60450020
DERR2    EQU   *                                                  20030 60500020
         MVI   XAE,D5             ERROR CODE=5 FOR COMMAND INVALID20030 60550020
D503D    EQU   *                                                        60600019
         MVC   XAX+D3(L2),X05     COMPLETE LOAD MOD NAME IGC0503D       60800019
         B     DEXIT              BRANCH FOR XCTL                       61000019
DMSG     EQU   *                                                        61200019
         MVI   XAE,DD37           CODE =37 FOR TASK BUSY                61400019
         B     D2103D                                                   61420020
D2103D   EQU   *                                                  20030 61480020
         MVC   XAX+D2(L3),X21     PREPARE FOR XCTL TO IGG2103D    M3123 61500019
         B     DEXIT              BRANCH FOR XCTL                 M3123 61600019
D803D    EQU   *                                                        61800019
         MVC   XAX+D3(L2),X08     COMPLETE LOAD MOD NAME IGC0803D       62000019
DEXIT    EQU   *                                                        62200019
         SR    R4,R4              ZERO DCB PTR IN XSA                   62400019
         ST    R4,XAD                                                   62600019
         LA    R4,XAX             GET PTR TO XCTL NAME                  62800019
         ST    R4,XAP             STORE PTR IN XSA                      63000019
         XCTL  SF=(E,(R2))        XCTL TO NEXT MODULE                   63200019
*********************************************************************** 63400019
*                                                                     * 63600019
*                              CONSTANTS                              * 63800019
*                                                                     * 64000019
*********************************************************************** 64200019
ADJ1900  DC    A(1900*1000)        For year adjustment             @L01 64210019
ERRCODE  DC    X'0014'            TPUT RETURN CODE - MSG DID NOT  20030 64260020
*                                 GO DUE TO AN OUTSTANDING TPUT   20030 64320020
DDBLNK   DC    C'        '        USED FOR PADDING                      64400019
X75      DC    C'75'                   IGC7503D                   21002 64500021
FOUR     DC    H'4'               USED IN SH INSTRUCTION                64600019
X05      DC    C'05'              TO CREATE LOAD MOD NAME IGC0503D      64800019
X08      DC    C'08'              TO CREATE LOAD MOD NAME IGC0803D      65000019
X21      DC    C'G21'             TO CREATE LOAD MOD NAME IGG2103D      65200019
X29      DC    C'29'              TO CREATE LOAD MOD NAME IGC2903D      65400019
X61      DC    C'61'               TO SET LOAD MOD NAM IGC6103D   19055 65600019
X13      DC    C'13'              TO CREATE LOAD MOD - IGC1303D   20002 65660020
X58      DC    C'58'               TO CREATE LOAD MOD - IGC5803D  20030 65720020
X85      DC    C'85'               TO CREATE LOAD MOD - IGC8503D A40792 65770021
DDMSG    WTO   'IEE136I    TIME=           DATE=        ',MF=L,        X65800019
               DESC=(5),MCSFLAG=(REG0,RESP)                             66000019
DDLN     EQU   *-DDMSG                                                  66200019
DCOMPARE CLC   ONE(D0,R6),ZERO(R5) LOOK FOR MATCH IN TABLE              66400019
*********************************************************************** 66600019
*                                                                     * 66800019
*                           BRANCH  TABLE                             * 67000019
*                                                                     * 67200019
*   THIS TABLE MUST BE IN A ONE-TO-ONE CORRESPONDENCE WITH              67260020
*        THE 'COMPARE TABLE'           ******                           67320020
*********************************************************************** 67400019
BRTABLE  EQU   *                                                        67600019
         B     DDCON              BRANCH TO PROCESS D CONSOLES    20030 68330020
         B     DDCON                   PROCESS DISPLAY CONSOLES   21002 68340021
         B     DDTIM              BRANCH TO PROCESS D TIME        20030 68360020
         B     DDREP              BRANCH TO PROCESS D R                 68400019
         B     DDACT              BRANCH TO PROCESS D ACTIVE            68500019
         B     DDACT                   PROCESS DISPLAY ACTIVE     21002 68510021
         B     DDUSER             BRANCH TO PROCESS D USER        20030 68530020
         B     DDUSER             BRANCH TO PROCESS D USER        20030 68560020
         B     DDUNT              BRANCH TO PROCESS D UNITS        O111 68600019
         B     DDUNT              BRANCH TO PROCESS D UNITS        O111 68700019
         B     DDMTRX             BRANCH TO XCTL FOR D MATRIX     19055 69000019
         B     DDMTRX             BRANCH TO XCTL FOR D MATRIX     M3123 69300019
         B     DDMTRX                  PROCESS DISPLAY MATRIX     21002 69350021
         B     DDTPCOM            GO TO XCTL FOR DISPLAY TP,      20002 69500020
         B     DDSQA              BRANCH TO XCTL FOR D SQA       A40792 69510021
         B     DSDS                    PROCESS DISPLAY C,K        21002 69550021
         B     DSDS                    PROCESS DISPLAY C,K        21002 69600021
         B     DSDS                    PROCESS D Q                21002 69650021
         B     DSDS                    PROCESS DISPLAY Q          21002 69700021
         B     DSDS                    PROCESS DISPLAY Q          21002 69750021
         B     DSDS                    PROCESS DISPLAY N          21002 69760021
         B     DSDS                    PROCESS D N                21002 69770021
         B     DSDS                    PROCESS DISPLAY N          21002 69780021
         B     DPFK                    BRANCH TO PROCESS D PFK    21002 69790021
*********************************************************************** 69800019
*                                                                     * 70000019
*                          COMPARE TABLE                              * 70200019
*                                                                     * 70400019
*   THIS TABLE MUST BE IN A ONE-TO-ONE CORRESPONDENCE                   70460020
*        WITH THE BRANCH TABLE         *******                          70520020
*********************************************************************** 70600019
DTAB     EQU   *                                                        70800019
DLEN     EQU   *                                                        71000019
DENPER   EQU   *                                                  20030 73830020
         DC    AL1(L'DCONSOLE-1)        *                         20030 73860020
DCONSOLE DC    C'CONSOLES '             *                         20030 73890020
         DC    AL1(L'DCONSOLA-1)                                  21002 73900021
DCONSOLA DC    C'CONSOLES,'                                       21002 73910021
         DC    AL1(L'DTIME-1)           *                         20030 73920020
DTIME    DC    C'T '                    *                         20030 73950020
         DC    AL1(L'DREPLY-1)          *                               74000019
DREPLY   DC    C'R '                    *                               74200019
         DC    AL1(L'DACTIVE-1)         *                               74400019
DACTIVE  DC    C'A '                                                    74600019
         DC    AL1(L'DACTIVEA-1)                                  21002 74602021
DACTIVEA DC    C'A,'                                              21002 74604021
         DC    AL1(L'DUSER-1)           *                         20030 74610020
DUSER    DC    C'USER '                 *                         20030 74620020
         DC    AL1(L'DUSERNO-1)         *                         20030 74630020
DUSERNO  DC    C'USER=NMBR '            *                         20030 74640020
         DC    AL1(L'DUNITA-1)          *                          O111 74680019
DUNITA   DC    C'U '                    *                          O111 74760019
         DC    AL1(L'DUNITB-1)          *                          O111 74840019
DUNITB   DC    C'U,'                    *                          O111 74920019
         DC    AL1(L'DMATRXA-1)         *                         M3123 74970019
DMATRXA  DC    C'M '                    *                         M3123 75020019
         DC    AL1(L'DMATRXB-1)         *                         M3123 75070019
DMATRXB  DC    C'M='                    *                         M3123 75120019
         DC    AL1(L'DMATRIXC-1)                                  21002 75130021
DMATRIXC DC    C'M,'                                              21002 75132021
         DC    AL1(L'DTPCOM-1)          *                         20002 75140020
DTPCOM   DC    C'TP,'                   *                         20002 75160020
         DC    AL1(L'DSQA-1)            *                        A40792 75162021
DSQA     DC    C'SQA '                  *                        A40792 75164021
         DC    AL1(L'DCK-1)                                       21002 75170021
DCK      DC    C'C,K '                                            21002 75180021
         DC    AL1(L'DCKA-1)                                      21002 75190021
DCKA     DC    C'C,K,'                                            21002 75192021
         DC    AL1(L'DQUEUE-1)                                    21002 75194021
DQUEUE   DC    C'Q '                                              21002 75196021
         DC    AL1(L'DQUEUEA-1)                                   21002 75198021
DQUEUEA  DC    C'Q,'                                              21002 75198421
         DC    AL1(L'DQUEUEB-1)                                   21002 75198821
DQUEUEB  DC    C'Q='                                              21002 75199221
         DC    AL1(L'DNAME-1)                                     21002 75199621
DNAME    DC    C'N '                                              21002 75199721
         DC    AL1(L'DNAMEA-1)                                    21002 75199821
DNAMEA   DC    C'N,'                                              21002 75199921
         DC    AL1(L'DNAMEB-1)                                    21002 75249921
DNAMEB   DC    C'N='                                              21002 75259921
         DC    AL1(L'DDPFK)                                       21002 75269921
DDPFK    DC    C'PFK '                                            21002 75279921
DENTAB   EQU   *                                                        75299921
         END                                                            75400019
./ ADD NAME=IEE6503D
IEE6503D CSECT                                                          00300020
* D 306100-306200, A 388000-389000                               A55623 00310021
* 605200-605500,618000                                            M2523 00320020
* 585000-585300,603000-604300,633000-636000                       M1812 00350020
* 657000-660000,675000                                            M0322 00400020
* C 006000,009000,408000                                          M0777 00450021
* D 015000-027000,120000,146000-183000,225000,247300-247600,      M0777 00500021
* D 485000-621000,654000-655800,659100,673400-676900,             M0777 00550021
* D 681000-727500,730000-731000,757000-761000,778000-783500       M0777 00552021
* A 024000-028699,045500-047500,222500,243000,306100-306200,      M0777 00560021
* A 420500                                                        M0777 00572021
         TITLE ' SET COMMAND HANDLER, TOD CLOCK - 1'                    00600021
* NAME-IEE6503D, SET COMMAND HANDLER - TOD CLOCK (PART 1)         M0777 00900021
*                                                                       01200020
* FUNCTION-CALCULATE DISCREPANCY BETWEEN EXISTING TIME AND NEW    M0777 02400021
*            TIME AND PASS TO IEE6603D FOR UPDATING TSO AND       M0777 02700021
*            SYSTEM TQE'S                                         M0777 02750021
*            1. IF THE DATE IS BEING CHANGED, USE YY.DDD FROM SET M0777 02760021
*               COMMAND. IF DATE IS NOT BEING CHANGED, USE DATE   M0777 02770021
*               FROM CVT.                                         M0777 02780021
*            2. CONVERT DATE TO 1.04 SECONDS                      M0777 02790021
*            3. IF THE CLOCK (HH.MM.SS) IS BEING CHANGED, USE     M0777 02792021
*               HH.MM.SS FROM SET COMMAND. OTHERWISE,USE HH.MM.SS M0777 02794021
*               FROM TOD CLOCK.                                   M0777 02796021
*            4. SAVE CLOCK VALUE IN SECONDS, THEN CONVERT IT TO   M0777 02798021
*               1.04 SECONDS.                                     M0777 02798421
*            5. ADD DATE AND CLOCK VALUES TO GET NEW TIME, AND    M0777 02798821
*               SAVE IT.                                          M0777 02799221
*            6. SAVE DISCREPANCY. (NEW TIME - OLD TIME)           M0777 02799621
*                                                                 M0777 02799721
*          CALCULATE TIME AT MIDNIGHT (NEW YY.DDD + 1 DAY)        M0777 02799821
*          CALCULATE TIME REMAINING UNTIL MIDNIGHT AND SAVE IT.   M0777 02816521
*                                                                 M0777 02833321
*          NOTE- AT IPL TIME, IF THE TOD CLOCK VALUE IS NOT TO BE M0777 02849921
*            CHANGED, A DISCREPANCY OF 0 AND THE TIME AT MIDNIGHT M0777 02859921
*            ARE SAVED.                                           M0777 02869921
* EXTERNAL REFERENCES-MASTER RESIDENT CORE,CVT,XSA                      03000020
*                                                                       03300020
* INPUT- REG 6-DATE IN PACKED DECIMAL FORMAT-00YYDDDF                   03600020
*        REG 7-TIME IN PACKED DECIMAL FORMAT-0HHMMSSF                   03900020
*        REG-2-POINTER TO EXTENDED SAVE AREA                            03950020
*        BIT SET IN RESIDENT CORE INDICATING WHETHER OR NOT CLOCK IS    04200020
*            TO BE SET.*                                                04500020
* OUTPUT- REG 10-DATE IN PACKED DECIMAL (TO BE PUT IN CVT)        M0777 04550021
*         REG  7-TIME DISCREPANCY                                 M0777 04600021
*         REG  6-CLOCK VALUE IN 1.04 SECONDS                      M0777 04610021
*         REG  2-XSA POINTER                                      M0777 04650021
*         XAV-CLOCK VALUE IN SECONDS                              M0777 04700021
*         XAV+4-TIME AT MIDNIGHT                                  M0777 04750021
*                                                                       04800020
* ATTRIBUTES- SUPV STATE,DISABLE,TRANSIENT,REENTRANT                    05100020
*                                                                       05101020
* Change activity      =                                                05102020
*                                                                       05103020
*   Flag  Date        By    Description                                 05104020
*   ----  ----------  ----  --------------------------------------      05105020
*   $L01  2017/09/21  KL    TMVT805 Four-digit year support.       @L01 05106020
*                                                                       05107020
*********************************************************************   05150020
R0       EQU   0                                                        05400020
R1       EQU   1                                                        05700020
R2       EQU   2                                                        06000020
R3       EQU   3                                                        06300020
R4       EQU   4                                                        06600020
R5       EQU   5                                                        06900020
R6       EQU   6                                                        07200020
R7       EQU   7                                                        07500020
R8       EQU   8                                                        07800020
R9       EQU   9                                                        08100020
R10      EQU   10                                                       08400020
R11      EQU   11                                                       08700020
R12      EQU   12                                                       09000020
R13      EQU   13                                                       09300020
R14      EQU   14                                                       09600020
R15      EQU   15                                                       09900020
D0       EQU   0                                                        10200020
D1       EQU   1                                                        10500020
D2       EQU   2                                                        10800020
D3       EQU   3                                                        11100020
D4       EQU   4                                                        11400020
D5       EQU   5                                                        11700020
D7       EQU   7                                                        12300020
D8       EQU   8                                                        12600020
*********************************************************************   18350020
         BALR  R12,R0                  ESTABLISH ADDR                   18600020
         USING *,R12                   USE 12 AS BASE REG               18900020
         L     R3,CVTPTR               ADDR OF CVT                      19200020
         USING CVTSECT,R3                                               19500020
         USING CMXSA,R2                                                 19800020
         L     R13,CVTMSER             ADDR OF MRC                      20100020
         USING BASE,R13                                                 20400020
         LR    R10,R6                  SAVE DATE                        20700020
         LR    R11,R7                  SAVE TIME                        21900020
         STCK  XAP                     READ IN CLOCK VALUE              22200020
******************************************************************M0777 22250021
* THE FOLLOWING CALCULATES THE DIFFERENCE IN TIME ENTERED AND TIME      22800020
* PRESENTLY BEING USED.                                                 23100020
******************************************************************M0777 24350021
         LTR   R6,R6                   WAS DATE SPECIFIED               24620020
         BZ    CVTUNPAK                NO. UNPACK DDD FROM CVT          24640020
         ST    R6,XAV                  PUT DATE IN XAV FOR UNPK         24660020
         UNPK  XAX(D7),XAV(D4)         UNPACK DATE                      24700020
         B     UNPACK                  GO PACK YEAR                     24800020
CVTUNPAK EQU   *                                                        24900020
         UNPK  XAX(D7),CVTDATE(D4)     UNPACK DATE FROM CVT             25000020
UNPACK   EQU   *                                                        25100020
         PACK  XAS(D8),XAX+D0(D4)      PACK YYYY                   @L01 25200020
         CVB   R5,XAS                  CONVERT YEARS TO BINARY          25500020
         PACK  XAS(D8),XAX+D4(D3)      PACK DDD                         25800020
         CVB   R6,XAS                  CONVERT DDD TO BINARY            26100020
         S     R5,SIXTY                GET NO. OF YRS SINCE 1960        26400020
         LR    R9,R5                   SAVE CONTENTS                    26700020
         SR    R4,R4                                                    27000020
         D     R4,FOUR                 DIVIDE NO. OF YRS BY FOUR        27300020
         LTR   R4,R4                   IS THERE A REMAINDER             27600020
         BZ    NOADD                   NO BRANCH                        27900020
         LA    R5,D1(R5)               YES ADD 1 DAY                    28200020
NOADD    EQU   *                                                        28500020
         M     R8,T365                 CONVERT YRS TO DAYS              28800020
         AR    R9,R5                   ADD IN NO. OF LEAP YR DAYS       29100020
         AR    R9,R6                   ADD IN DAYS ELAPSED THIS YR      29400020
         M     R8,F86400               CONVERT DAYS TO SECONDS          29700020
         M     R8,D15625               THESE TWO INSTRUCTIONS DIVEDE    30000020
         D     R8,D16384               NO OF SECS BY 1.04               30300020
         ST    R9,XAV+D4               SAVE DATA                        30600020
**********************************************************************  30630021
* THIS ROUTINE EXTRACTS THE CLOCK=VALUE FROM THE CLOCK IF THE CLOCK     30650020
* VALUE WAS NOT SPECIFIED IN THE SET COMMAND AND THE DATE IS BEING      30700020
* CHANGED.                                                              30750020
**********************************************************************  31550021
         LTR   R11,R11                 WAS TIME CHANGE SPECIFIED        31800020
         BNZ   CLOCKOK                 TIME INDICATED                   32100020
         L     R7,XAP                  GET TIME PRESENTLY USED          32400020
         SR    R6,R6                                                    32700020
         M     R6,D16384               THESE  TWO INSTRUCTIONS CHANGE   33600020
         D     R6,D15625               1.04   SECONDS TO SECONDS        33900020
         XR    R6,R6                   ZERO REMAINDER REG               33970020
         D     R6,F86400               DIVIDE BY NO. SEC PER DAY        34040020
         LR    R7,R6                   REMAINDER = HOURS,MIN,SEC        34110020
         B     STORE                   SAVE VALUE                       34200020
CLOCKOK  EQU   *                                                        34500020
*********************************************************************   34550020
* THIS BLOCK OF CODE CONVERTS THE TIME SPECIFIED IN THE CLOCK=VALUE     34600020
* INTO  SECONDS. THE FORMAT OF THE TIME IS 0HHMMSSF.                    34610020
********************************************************************    34620020
         ST    R11,XAS                 PREPARE FOR UNPACKING            34800020
         UNPK  XAX(D7),XAS(D4)         UNPACK 0HHMMSSF                  35100020
         PACK  XAS(D8),XAX+D1(D2)      PACK HH                          35400020
         CVB   R5,XAS                  CONVERT HH TO BINARY             35700020
         M     R4,F3600                CONVERT HH TO SECONDS            36000020
         PACK  XAS(D8),XAX+D3(D2)      PACK MM                          36300020
         CVB   R7,XAS                  CONVERT MM TO BINARY             36600020
         M     R6,SIXTY                CONVERT MM TO SECONDS            36900020
         PACK  XAS(D8),XAX+D5(D2)      PACK SS                          37200020
         CVB   R4,XAS                  CONVERT SS TO BINARY             37500020
         AR    R7,R5                   ADD HHSECONDS TO MMSECONDS       37800020
         AR    R7,R4                   ADD IN SS SECONDS                38100020
STORE    EQU   *                                                        38400020
         ST    R7,XAV                  SAVE CONTENTS IN XSA             38700020
         TM    BASFL,BANOSET           IS THE CLOCK TO BE SET    A55623 38800021
         BO    DISCREP0                NO.. SET DISCREP = 0      A55623 38900021
         M     R6,D15625               THESE TWO INSTRUCTIONS DIVIDE    39000020
         D     R6,D16384               THE NO. OF SEC BY 1.04           39300020
NOCHANGE EQU   *                                                        39600020
         AR    R7,R9                   ADD YYDDD AND HHMMSS             39900020
         L     R15,XAP                 GET TIME PRESENTLY BIENG USED    40200020
         S     R7,D24HR104             ADJUST  DDD                      40500020
         LR    R6,R7                   SAVE NEW TOD VALUE         M0777 40800021
         SR    R7,R15                  GET TIME DISCREPANCY             42000020
         B     SET66                   XCTL TO IEE6603D           M0777 42050021
DISCREP0 EQU   *                                                  M0777 62150021
         XR    R7,R7                   INDICATE 0 DISCREPANCY     M0777 62200021
SET66    EQU   *                                                        65610020
         MVC   XAX(D8),SIXSIX          SET UP XCTL TO IEE6603D    M0322 65710020
XCTLRTN  EQU   *                                                  M0322 65810020
         XC    XAD(D4),XAD             SET DCB PTR TO ZERO              66300020
         LA    R15,XAX                 ADDR OF MODULE NAME              66600020
         ST    R15,XAP                 PUT PTR TO NAME IN LIST          66900020
         LR    R15,R2                  PUT PTR TO LIST IN R15           67200020
         XCTL  SF=(E,(15))             PASS CONTROL               M0322 67270020
*        DEFINED CONSTANTS                                              67800020
         DS    0F                                                       72800020
SIXSIX   DC    CL8'IGC6603D'           IEE6603D                         72900020
SIXTY    DC    F'60'                   BEGINNING DATE FOR TOD CLOCK     73200020
FOUR     DC    F'4'                    NO. OF YRS BERORE LEAP YEAR      73500020
T365     DC    F'365'                  NO. OF DAYS IN 1 YEAR            73800020
D38400   DC    F'38400'                SEC TO TU CONSTANT               74400020
F3600    DC    F'3600'                 NO. OF SEC IN 1 HR               74700020
D15625   DC    F'15625'                CONVERSION CONSTANT USED TO      75000020
D16384   DC    F'16384'                DIVIDE AND MULT BY 1.04          75300020
F86400   DC    F'86400'                24HRS IN SECONDS                 76800020
D24HR104 DC    F'82397'                NO. OF 1.04 SECONDS/DAY          77100020
CVTSECT  DSECT                                                          78900020
         CVT                                                            79200020
         IEEBASEA                                                       79500020
CMXSA    DSECT                                                          79800020
         IEEXSA                                                         80100020
         END                                                            80400020
./ ADD NAME=IKJEFLPA
FLPA     TITLE 'IKJEFLPA -- TOD && DATE TEXT PREPARATION'               71000120
*         GENERATE;                                                     71000220
         TITLE 'IKJEFLPA -- TOD && TEXT PREPARATION -- MODULE PROLOGUE *71000320
               && SPECIFICATIONS'                                       71000420
         LCLA  &T,&SPN,&LDAY(12),&I,&LNDESCR                            71000520
         LCLC  &LUPDAT                                                  71000620
&SPN     SETA  1  OBTAIN DYNAMIC AREA FROM SUBPOOL 1                    71000720
&LUPDAT  SETC  '70166' DATE OF LAST MODULE UPDATE                       71000820
IKJEFLPA  START 0  FORCE ASSIGNMENT OF ADDRESSES TO IKJEFLPA FIRST      71000920
* /*******************************************************************/ 71001020
* /*                                                                 */ 71001120
* /* STATUS --                                                       */ 71001220
* /*    RELEASE 20, MODIFICATION LEVEL 01                            */ 71001320
* /*    A 0-999999                                            S20032 */ 71001420
* /*    C                                                      21974 */ 71001520
* /*                                                                 */ 71001620
* /* FUNCTION --                                                     */ 71001720
* /*    THIS MODULE ACCEPTS TWO BUFFERS AS INPUT AND FORMATS THE TWO */ 71001820
* /*    INTO THE FORM OF TEXT INSERTION BUFFERS CONTAINING THE TIME  */ 71001920
* /*    OF DAY IN THE FORMAT 'HH:MM:SS' AND THE DATE IN THE FORMAT   */ 71002020
* /*    'MONTH DAY, YEAR'                                            */ 71002120
* /*                                                                 */ 71002220
* /* ENTRY POINTS --                                                 */ 71002320
* /*         IKJEFLPA                                                */ 71002420
* /*                                                                 */ 71002520
* /* INPUT --                                                        */ 71002620
* /*    R1 = THE ADDRESS OF A TYPE I PARAMETER LIST CONSISTING OF TWO*/ 71002720
* /*         POINTERS, THE FIRST OF WHICH MUST CONTAIN THE ADDRESS OF*/ 71002820
* /*         A WRITABLE BUFFER AT LEAST 22 BYTES IN LENGTH; THIS     */ 71002920
* /*         BUFFER IS KNOWN AS THE TIME-OF-DAY OR TOD BUFFER WITHIN */ 71003020
* /*         THIS MODULE.  THE SECOND POINTER MUST CONTAIN THE       */ 71003120
* /*         ADDRESS OF A WRITABLE BUFFER AT LEAST 22 BYTES IN       */ 71003220
* /*         LENGTH; THIS BUFFER IS KNOWN AS THE DATE BUFFER WITHIN  */ 71003320
* /*         THIS MODULE.                                            */ 71003420
* /*    R13 = THE ADDRESS OF A 72-BYTE SAVE AREA                     */ 71003520
* /*    R14 = THE ADDRESS TO WHICH CONTROL SHOULD BE RETURNED        */ 71003620
* /*    R15 = THE ADDRESS OF THE ENTRY POINT OF IKJEFLPA             */ 71003720
* /*                                                                 */ 71003820
* /* OUTPUT --                                                       */ 71003920
* /*    R1 = ADDRESS OF INPUT PARAMETER LIST. THE TOD BUFFER HAS BEEN*/ 71004020
* /*         PROVIDED WITH A LENGTH FIELD AND TEXT DESCRIBING THE    */ 71004120
* /*         TIME OF DAY, AND THE DATE BUFFER HAS BEEN PROVIDED WITH */ 71004220
* /*         A LENGTH FIELD AND TEXT DESCRIBING THE DATE.            */ 71004320
* /*    R13 = THE SAME VALUE AS ON INPUT                             */ 71004420
* /*    R14 = THE SAME VALUE AS ON INPUT                             */ 71004520
* /*    R15 = THE SAME VALUE AS ON INPUT                             */ 71004620
* /*                                                                 */ 71004720
* /* EXTERNAL REFERENCES --                                          */ 71004820
* /*         NONE                                                    */ 71004920
* /*                                                                 */ 71005020
* /* EXITS, NORMAL --                                                */ 71005120
* /*         INVOKER                                                 */ 71005220
* /*                                                                 */ 71005320
* /* EXITS, ERROR --                                                 */ 71005420
* /*         NONE                                                    */ 71005520
* /*                                                                 */ 71005620
* /* TABLE/WORK AREAS --                                             */ 71005720
* /*         NONE                                                    */ 71005820
* /*                                                                 */ 71005920
* /* ATTRIBUTES --                                                   */ 71006020
* /*         REENTRANT, REFRESHABLE                                  */ 71006120
* /*                                                                 */ 71006220
* /*                                                                 */ 71006230
* /* Change activity      =                                          */ 71006240
* /*                                                                 */ 71006250
* /*   Flag  Date        By    Description                           */ 71006260
* /*   ----  ----------  ----  ------------------------------------  */ 71006270
* /*   $L01  2017/09/21  KL    TMVT805 Four-digit year support.  @L01*/ 71006280
* /*                                                                 */ 71006290
* /* NOTES --                                                        */ 71006320
* /*    SEE THE FOLLOWING SPECIFICATIONS FOR A MORE DETAILED         */ 71006420
* /*    DESCRIPTION OF THE MODULE.  THIS MODULE IS CHARACTER CODE    */ 71006520
* /*    DEPENDENT ON THE INTERNAL CONFIGURATION OF THE EBCDIC        */ 71006620
* /*    CHARACTERS.  REASSEMBLY IS NECESSARY IF A DIFFERENT          */ 71006720
* /*    CHARACTER SET IS TO BE USED DURING EXECUTION.                */ 71006820
* /*                                                                 */ 71006920
* /*******************************************************************/ 71007020
* /* START OF SPECIFICATIONS ****                                       71007120
*1MODULE-NAME = IKJEFLPA                                                71007220
*  2PROCESSOR = BSL                                                     71007320
** THE RELEASE FOR WHICH THIS MODULE WAS MOST RECENTLY UPDATED          71007420
*1STATUS = 20 MODIFICATION LEVEL 00                                     71007520
*1DESCRIPTIVE-NAME = TOD & TEXT PREPARATION                             71007620
*1DESCRIPTION = THIS MODULE ACCEPTS TWO BUFFERS AS INPUT AND FORMATS -  71007720
*THE TWO INTO THE FORM OF TEXT INSERTION BUFFERS CONTAINING THE TIME -  71007820
*OF DAY IN THE FORMAT 'HH:MM:SS' AND THE DATE IN THE FORMAT 'MONTH   -  71007920
*DAY, YEAR'                                                             71008020
*1ASSUMPTIONS = OS/360 OPERATING ENVIRONMENT                            71008120
*1FUNCTION = SEE DESCRIPTION                                            71008220
*1MODULE-TYPE = PROCEDURE                                               71008320
*1MODULE-SIZE = 1024 BYTES                                              71008420
*1CODE-ATTRIBUTES = REENTERABLE                                         71008520
*1LOAD-ATTRIBUTES = SCATTER, REFRESHABLE                                71008620
*1ENTRY-POINT = IKJEFLPA                                                71008720
*  2LINKAGE = LINK                                                      71008820
*  * THE FOLLOWING DESCRIBES THE REQUIRED INPUT TO THIS MODULE.         71008920
*  * DATA MADE AVAILABLE THROUGH THE STANDARD INVOCATION SEQUENCE       71009020
*  * BUT NOT USED IN ANY WAY IS NOT NECESSARILY MENTIONED HERE.         71009120
*  2PARAMETER-RECEIVED = POINTER-TO-PARAMETER-LIST                      71009220
*  2HOW-PASSED = REGISTER 1                                             71009320
*  2LENGTH-OF-LIST = 8 BYTES                                            71009420
*    *****************************************************************/ 71009520
*    /***************************************************************** 71009620
*    3FIELD = PARAM1                                                    71009720
*      4REFERENCE-TYPE = READ                                           71009820
*      4DISPLACEMENT = 0 BYTES                                          71009920
*      4TYPE = ADDRESS                                                  71010020
*      4ADDRESS-LENGTH = 32 BITS                                        71010120
*      4ADDRESS-OF = TOD                                                71010220
*        5REFERENCE-TYPE = WRITE                                        71010320
*        5TYPE-ADDRESSED = TABLE                                        71010420
*        5PURPOSE = PROVIDE ADDRESSIBILITY TO A BUFFER TO BE         -  71010520
*        FORMATTED INTO A TEXT INSERTION BUFFER CONTAINING THE TIME  -  71010620
*        OF DAY                                                         71010720
*        5SCOPE = INTERNAL                                              71010820
*        5TABLE-SIZE = 12 BYTES                                         71010920
*        *************************************************************/ 71011020
*        /************************************************************* 71011120
*        5FIELD = TODLEN                                                71011220
*          6REFERENCE-TYPE = WRITE                                      71011320
*          6DISPLACEMENT = 0 BYTES                                      71011420
*          6TYPE = ARITHMETIC                                           71011520
*          6MODE = BINARY                                               71011620
*          6LENGTH = 15 BITS                                            71011720
*          6SIGN = SIGNED                                               71011820
*          6VALUE = IGNORED ON INPUT.                                   71011920
*        *************************************************************/ 71012020
*        /************************************************************* 71012120
*        5FIELD = TODOFF                                                71012220
*          6DISPLACEMENT = 2 BYTES                                      71012320
*          6TYPE = ARITHMETIC                                           71012420
*          6MODE = BINARY                                               71012520
*          6LENGTH = 15 BITS                                            71012620
*          6SIGN = SIGNED                                               71012720
*          6VALUE = IGNORED ON INPUT.                                   71012820
*        *************************************************************/ 71012920
*        /************************************************************* 71013020
*        5FIELD = TODTXT                                                71013120
*          6REFERENCE-TYPE = WRITE                                      71013220
*          6DISPLACEMENT = 4 BYTES                                      71013320
*          6TYPE = CHARACTER STRING                                     71013420
*          6LENGTH+MODE = 8 CHARACTERS                                  71013520
*          6VALUE = IGNORED ON INPUT.                                   71013620
*    *****************************************************************/ 71013720
*    /***************************************************************** 71013820
*    3FIELD = PARAM2                                                    71013920
*      4REFERENCE-TYPE = READ                                           71014020
*      4DISPLACEMENT = 4 BYTES                                          71014120
*      4TYPE = ADDRESS                                                  71014220
*      4ADDRESS-LENGTH = 32 BITS                                        71014320
*      4ADDRESS-OF = DATE                                               71014420
*        5REFERENCE-TYPE = WRITE                                        71014520
*        5TYPE-ADDRESSED = TABLE                                        71014620
*        5PURPOSE = PROVIDE ADDRESSIBILITY TO A BUFFER TO BE         -  71014720
*        FORMATTED INTO A TEXT INSERTION BUFFER CONTAINING THE DATE     71014820
*        5SCOPE = INTERNAL                                              71014920
*        5TABLE-SIZE = 22 BYTES                                         71015020
*        *************************************************************/ 71015120
*        /************************************************************* 71015220
*        5FIELD = DATELEN                                               71015320
*          6REFERENCE-TYPE = WRITE                                      71015420
*          6DISPLACEMENT = 0 BYTES                                      71015520
*          6TYPE = ARITHMETIC                                           71015620
*          6MODE = BINARY                                               71015720
*          6LENGTH = 15 BITS                                            71015820
*          6SIGN = SIGNED                                               71015920
*          6VALUE = IGNORED ON INPUT.                                   71016020
*        *************************************************************/ 71016120
*        /************************************************************* 71016220
*        5FIELD = DATEOFF                                               71016320
*          6DISPLACEMENT = 2 BYTES                                      71016420
*          6TYPE = ARITHMETIC                                           71016520
*          6MODE = BINARY                                               71016620
*          6LENGTH = 15 BITS                                            71016720
*          6SIGN = SIGNED                                               71016820
*          6VALUE = IGNORED ON INPUT.                                   71016920
*        *************************************************************/ 71017020
*        /************************************************************* 71017120
*        5FIELD = DATETXT                                               71017220
*          6REFERENCE-TYPE = WRITE                                      71017320
*          6DISPLACEMENT = 4 BYTES                                      71017420
*          6TYPE = CHARACTER STRING                                     71017520
*          6LENGTH+MODE = 18 CHARACTERS                                 71017620
*          6VALUE = IGNORED ON INPUT.                                   71017720
**********************************************************************/ 71017820
* /******************************************************************** 71017920
*1EXIT = INVOKER                                                        71018020
*  2CONDITIONS-WHEN-TAKEN = ALWAYS                                      71018120
*  2LINKAGE = RETURN                                                    71018220
*  * THE FOLLOWING DESCRIBES THE OUTPUT OF THIS MODULE.                 71018320
*  * DATA MADE AVAILABLE TO THE FOLLOWING MODULE AS A                   71018420
*  * RESULT OF THE CURRENT IMPLEMENTATION BUT NOT GUARANTEED            71018520
*  * TO THAT MODULE IS NOT ENUMERATED.                                  71018620
*  2PARAMETER-RETURNED = POINTER-TO-PARAMETER-LIST                      71018720
*  2HOW-PASSED = REGISTER 1                                             71018820
*  2LENGTH-OF-LIST = 8 BYTES                                            71018920
*    *****************************************************************/ 71019020
*    /***************************************************************** 71019120
*    3FIELD = PARAM1                                                    71019220
*      4REFERENCE-TYPE = READ                                           71019320
*      4DISPLACEMENT = 0 BYTES                                          71019420
*      4TYPE = ADDRESS                                                  71019520
*      4ADDRESS-LENGTH = 32 BITS                                        71019620
*      4ADDRESS-OF = TOD                                                71019720
*        5REFERENCE-TYPE = WRITE                                        71019820
*        5TYPE-ADDRESSED = TABLE                                        71019920
*        5PURPOSE = DESCRIBE THE TIME OF DAY IN THE FORM 'HH:MM:SS'.    71020020
*        5REMARKS-ON-USE = THIS BUFFER IS IN SUITABLE CONDITION TO   -  71020120
*        BE USED AS A TEXT-INSERTION BUFFER EXCEPT FOR THE TODOFF    -  71020220
*        FIELD WHICH MAY BE SUPPLIED BY THE INVOKER EITHER BEFORE    -  71020320
*        OR AFTER INVOKING IKJEFLPA.                                    71020420
*        5SCOPE = INTERNAL                                              71020520
*        5TABLE-SIZE = 12 BYTES                                         71020620
*        *************************************************************/ 71020720
*        /************************************************************* 71020820
*        5FIELD = TODLEN                                                71020920
*          6REFERENCE-TYPE = WRITE                                      71021020
*          6DISPLACEMENT = 0 BYTES                                      71021120
*          6TYPE = ARITHMETIC                                           71021220
*          6MODE = BINARY                                               71021320
*          6LENGTH = 15 BITS                                            71021420
*          6SIGN = SIGNED                                               71021520
*          6VALUE = 12                                                  71021620
*        *************************************************************/ 71021720
*        /************************************************************* 71021820
*        5FIELD = TODOFF                                                71021920
*          6DISPLACEMENT = 2 BYTES                                      71022020
*          6TYPE = ARITHMETIC                                           71022120
*          6MODE = BINARY                                               71022220
*          6LENGTH = 15 BITS                                            71022320
*          6SIGN = SIGNED                                               71022420
*          6VALUE = SAME AS ON INPUT.                                   71022520
*        *************************************************************/ 71022620
*        /************************************************************* 71022720
*        5FIELD = TODTXT                                                71022820
*          6REFERENCE-TYPE = WRITE                                      71022920
*          6DISPLACEMENT = 4 BYTES                                      71023020
*          6TYPE = CHARACTER STRING                                     71023120
*          6LENGTH+MODE = 8 CHARACTERS                                  71023220
*          6VALUE = TIME OF DAY IN THE FORM 'HH:MM:SS'.                 71023320
*    *****************************************************************/ 71023420
*    /***************************************************************** 71023520
*    3FIELD = PARAM2                                                    71023620
*      4REFERENCE-TYPE = READ                                           71023720
*      4DISPLACEMENT = 4 BYTES                                          71023820
*      4TYPE = ADDRESS                                                  71023920
*      4ADDRESS-LENGTH = 32 BITS                                        71024020
*      4ADDRESS-OF = DATE                                               71024120
*        5REFERENCE-TYPE = WRITE                                        71024220
*        5TYPE-ADDRESSED = TABLE                                        71024320
*        5PURPOSE = DESCRIBE THE DATE IN THE FORM 'MONTH DAY, YEAR'.    71024420
*        5REMARKS-ON-USE = THIS BUFFER IS IN SUITABLE CONDITION TO   -  71024520
*        BE USED AS A TEXT-INSERTION BUFFER EXCEPT FOR THE DATEOFF   -  71024620
*        FIELD WHICH MAY BE SUPPLIED BY THE INVOKER EITHER BEFORE    -  71024720
*        OR AFTER INVOKING IKJEFLPA.                                    71024820
*        5SCOPE = INTERNAL                                              71024920
*        5TABLE-SIZE = 22 BYTES                                         71025020
*        *************************************************************/ 71025120
*        /************************************************************* 71025220
*        5FIELD = DATELEN                                               71025320
*          6REFERENCE-TYPE = WRITE                                      71025420
*          6DISPLACEMENT = 0 BYTES                                      71025520
*          6TYPE = ARITHMETIC                                           71025620
*          6MODE = BINARY                                               71025720
*          6LENGTH = 15 BITS                                            71025820
*          6SIGN = SIGNED                                               71025920
*          6VALUE = LENGTH OF TEXT-INSERTION BUFFER CONTENTS.        -  71026020
*          15-22 BYTES                                                  71026120
*        *************************************************************/ 71026220
*        /************************************************************* 71026320
*        5FIELD = DATEOFF                                               71026420
*          6DISPLACEMENT = 2 BYTES                                      71026520
*          6TYPE = ARITHMETIC                                           71026620
*          6MODE = BINARY                                               71026720
*          6LENGTH = 15 BITS                                            71026820
*          6SIGN = SIGNED                                               71026920
*          6VALUE = SAME AS ON INPUT.                                   71027020
*        *************************************************************/ 71027120
*        /************************************************************* 71027220
*        5FIELD = DATETXT                                               71027320
*          6REFERENCE-TYPE = WRITE                                      71027420
*          6DISPLACEMENT = 4 BYTES                                      71027520
*          6TYPE = CHARACTER STRING                                     71027620
*          6LENGTH+MODE = 18 CHARACTERS                                 71027720
*          6VALUE = DATE IN THE FORM 'MONTH DAY, YEAR'                  71027820
**********************************************************************/ 71027920
* /******************************************************************** 71028020
*1EXTERNAL-MACRO = IEFDCL1                                              71028120
*  2PURPOSE = PROVIDE PRE-PROCESSOR VARIABLE DECLARATIONS               71028220
*  2PARAMETER-PASSED = NONE                                             71028320
**********************************************************************/ 71028420
* /******************************************************************** 71028520
*1EXTERNAL-MACRO = IEFDCL2                                              71028620
*  2PURPOSE = PROVIDE DECLARATIONS OF REGISTERS, A SAVEAREA, AND A   -  71028720
*  TYPE 1 PARAMETER LIST                                                71028820
*  *******************************************************************/ 71028920
*  /******************************************************************* 71029020
*  2PARAMETER-PASSED = REGISTER                                         71029120
*  2HOW-PASSED = KEYWORD                                                71029220
*  2TYPE = ARITHMETIC                                                   71029320
*  2MODE = BINARY                                                       71029420
*  2LENGTH = 31 BITS                                                    71029520
*  2SIGN = SIGNED                                                       71029620
*  2VALUE = 1. THIS CAUSES IEFDCL2 TO PROVIDE A MAPPING OF THE       -  71029720
*  GENERAL PURPOSE REGISTERS.                                           71029820
*  *******************************************************************/ 71029920
*  /******************************************************************* 71030020
*  2PARAMETER-PASSED = R0STAT                                           71030120
*  2HOW-PASSED = KEYWORD                                                71030220
*  2TYPE = CHARACTER STRING                                             71030320
*  2LENGTH+MODE = 32767 BYTES                                           71030420
*  2VALUE = 'RESTRICTED'                                                71030520
*  *******************************************************************/ 71030620
*  /******************************************************************* 71030720
*  2PARAMETER-PASSED = R1STAT                                           71030820
*  2HOW-PASSED = KEYWORD                                                71030920
*  2TYPE = CHARACTER STRING                                             71031020
*  2LENGTH+MODE = 32767 BYTES                                           71031120
*  2VALUE = 'RESTRICTED'                                                71031220
*  *******************************************************************/ 71031320
*  /******************************************************************* 71031420
*  2PARAMETER-PASSED = R4TYPE                                           71031520
*  2HOW-PASSED = KEYWORD                                                71031620
*  2TYPE = CHARACTER STRING                                             71031720
*  2LENGTH+MODE = 32767 BYTES                                           71031820
*  2VALUE = 'FIXED(15)'                                                 71031920
*  *******************************************************************/ 71032020
*  /******************************************************************* 71032120
*  2PARAMETER-PASSED = R5TYPE                                           71032220
*  2HOW-PASSED = KEYWORD                                                71032320
*  2TYPE = CHARACTER STRING                                             71032420
*  2LENGTH+MODE = 32767 BYTES                                           71032520
*  2VALUE = 'FIXED(15)'                                                 71032620
*  *******************************************************************/ 71032720
*  /******************************************************************* 71032820
*  2PARAMETER-PASSED = SAVEAREA                                         71032920
*  2HOW-PASSED = KEYWORD                                                71033020
*  2TYPE = ARITHMETIC                                                   71033120
*  2MODE = BINARY                                                       71033220
*  2LENGTH = 31 BITS                                                    71033320
*  2SIGN = SIGNED                                                       71033420
*  2VALUE = 1. THIS CAUSES IEFDCL2 TO PROVIDE A MAPPING OF A SAVEAREA.  71033520
*  *******************************************************************/ 71033620
*  /******************************************************************* 71033720
*  2PARAMETER-PASSED = PARAM                                            71033820
*  2HOW-PASSED = KEYWORD                                                71033920
*  2TYPE = ARITHMETIC                                                   71034020
*  2MODE = BINARY                                                       71034120
*  2LENGTH = 31 BITS                                                    71034220
*  2SIGN = SIGNED                                                       71034320
*  2VALUE = 1. THIS CAUSES IEFDCL2 TO PROVIDE A MAPPING OF A TYPE I  -  71034420
*  PARAMETER LIST.                                                      71034520
**********************************************************************/ 71034620
* /******************************************************************** 71034720
*1SYSTEM-MACROS = TIME, GETMAIN, FREEMAIN                               71034820
*1INTERNAL-PROCEDURES = NONE                                            71034920
*                                                                       71035020
**** END OF SPECIFICATIONS ***/                                         71035120
*/*IKJEFLPA: CHART (DTYPE,AMODE,IBM68,NSAVE,NSEQ)                    */ 71035220
*/*       HEADER                                                        71035320
*/*IKJEFLPA -- TOD & DATE TEXT INSERTION BUFFER PREPARATION          */ 71035420
*/*IKJEFLPA: E  BUFFER PREPARATION FUNCTION                          */ 71035520
*         GENERATE;                                                     71035620
IKJEFLPA CSECT                                                          71035720
PA000100 B     PA000300-PA000100(0,R15)   BRANCH AROUND IDENTIFIER      71035820
** /*                                                                   71035920
         DC    AL1(L'PA000200)            LENGTH OF IDENTIFIER          71036020
** */                                                                   71036120
PA000200 DC    C'IKJEFLPA&LUPDAT' IDENTIFIER                            71036220
PA000300 DS    0H                         BRANCH TARGET                 71036320
         AGO   .@001                                                    71036420
*IKJEFLPA:PROCEDURE/*(TOD, DATE)*/ OPTIONS(REENTRANT);                  71036520
         LCLA  &T,&SPN                                            0003  71036620
.@001    ANOP                                                     0003  71036720
IKJEFLPA CSECT ,                                                  0003  71036820
         STM   @E,@C,12(@D)                                       0003  71036920
         BALR  @B,0                                               0003  71037020
@PSTART  DS    0H                                                 0003  71037120
         USING @PSTART+00000,@B                                   0003  71037220
         L     @0,@SIZ001                                         0003  71037320
         GETMAIN  R,LV=(0)                                        0003  71037420
         LR    @C,@1                                              0003  71037520
         USING @DATD+00000,@C                                     0003  71037620
         LM    @0,@1,20(@D)                                       0003  71037720
         XC    @TEMPS(@L),@TEMPS                                  0003  71037820
         ST    @D,@SAV001+4                                       0003  71037920
         LA    @F,@SAV001                                         0003  71038020
         ST    @F,8(0,@D)                                         0003  71038120
         LR    @D,@F                                              0003  71038220
*         GENERATE;                                                     71038320
         TITLE     'IKJEFLPA -- TOD && DATE TEXT PREPARATION -- DEFINE *71038420
               VARIABLES'                                               71038520
         DS    0H                                                       71038620
*                                                                       71038720
*                                                                       71038820
* /*******************************************************************/ 71038920
* /*      DEFINE THE GENERAL PURPOSE REGISTERS                       */ 71039020
* /*******************************************************************/ 71039120
* DECLARE                                                               71039220
*         R0 POINTER(31) REGISTER(0) RESTRICTED,                        71039320
*         /***********************************************************/ 71039420
*         /*    STANDARD LINKAGE CONVENTION PARAMETER LIST POINTER   */ 71039520
*         /***********************************************************/ 71039620
*         R1 POINTER(31) REGISTER(1) RESTRICTED,                        71039720
*         R2 POINTER(31) REGISTER(2) UNRESTRICTED,                      71039820
*         R3 POINTER(31) REGISTER(3) UNRESTRICTED,                      71039920
*         R4 FIXED(15) REGISTER(4) UNRESTRICTED,                        71040020
*         R5 FIXED(15) REGISTER(5) UNRESTRICTED,                        71040120
*         R6 POINTER(31) REGISTER(6) UNRESTRICTED,                      71040220
*         R7 POINTER(31) REGISTER(7) UNRESTRICTED,                      71040320
*         R8 POINTER(31) REGISTER(8) UNRESTRICTED,                      71040420
*         R9 POINTER(31) REGISTER(9) UNRESTRICTED,                      71040520
*         R10 POINTER(31) REGISTER(10) UNRESTRICTED,                    71040620
*         R11 POINTER(31) REGISTER(11) UNRESTRICTED,                    71040720
*         R12 POINTER(31) REGISTER(12) UNRESTRICTED,                    71040820
*         /***********************************************************/ 71040920
*         /*   STANDARD LINKAGE CONVENTION SAVE AREA POINTER         */ 71041020
*         /***********************************************************/ 71041120
*         R13 POINTER(31) REGISTER(13) UNRESTRICTED,                    71041220
*         /***********************************************************/ 71041320
*         /*   STANDARD LINKAGE CONVENTION RETURN POINTER            */ 71041420
*         /***********************************************************/ 71041520
*         R14 POINTER(31) REGISTER(14) UNRESTRICTED,                    71041620
*         /***********************************************************/ 71041720
*         /*   STANDARD LINKAGE CONVENTION SUBROUTINE ENTRY POINTER  */ 71041820
*         /***********************************************************/ 71041920
*         R15 POINTER(31) REGISTER(15) UNRESTRICTED;                    71042020
*                                                                       71042120
* /*******************************************************************/ 71042220
* /*      DEFINE A SAVE AREA                                         */ 71042320
* /*******************************************************************/ 71042420
* DECLARE                                                               71042520
* 1       SAVEAREA  BASED( R13) BOUNDARY( WORD),                        71042620
*         /***********************************************************/ 71042720
*         /*    PL/I USES THIS WORD TO INDICATE THE LENGTH OF THE    */ 71042820
*         /*    DYNAMIC STORAGE AREA REPRESENTED BY THIS SAVE AREA   */ 71042920
*         /***********************************************************/ 71043020
*         2     SAVEWRD1 POINTER(32),                                   71043120
*               3  SAVEPFLG POINTER(8),                                 71043220
*               3  SAVEPLGH POINTER(24),                                71043320
*         /***********************************************************/ 71043420
*         /*    POINTER TO THE PREVIOUS SAVE AREA, THE SAVE AREA OF  */ 71043520
*         /*    THE INVOKER UNLESS THIS SUBROUTINE PROVIDES NO SAVE  */ 71043620
*         /*    AREA OF ITS OWN                                      */ 71043720
*         /***********************************************************/ 71043820
*         2     SAVELAST POINTER(32),                                   71043920
*         /***********************************************************/ 71044020
*         /*    POINTER TO THE NEXT SAVE AREA FOR ALL BUT THE LOWEST */ 71044120
*         /*    LEVEL SUBROUTINE ON THE STACK                        */ 71044220
*         /***********************************************************/ 71044320
*         2     SAVENEXT POINTER(32),                                   71044420
*         /***********************************************************/ 71044520
*         /*    SAVE AREA WORD FOR INPUT REGISTER 14, THE ADDRESS TO */ 71044620
*         /*    WHICH CONTROL IS NORMALLY TO BE RETURNED AFTER A     */ 71044720
*         /*    SUBROUTINE HAS CONCLUDED PROCESSING.  THE HIGH-ORDER */ 71044820
*         /*    BYTE OF THIS POINTER SHOULD BE SET TO 'FF'X IF THIS  */ 71044920
*         /*    ROUTINE HAS CONTROL AFTER A RETURN HAS BEEN MADE FROM*/ 71045020
*         /*    A SUBROUTINE.                                        */ 71045120
*         /***********************************************************/ 71045220
*         2     SAVER14 POINTER(32),                                    71045320
*               3  SAVERETF POINTER(8),                                 71045420
*         /***********************************************************/ 71045520
*         /*    SAVE AREA FOR INPUT REGISTERS 15 THROUGH 12          */ 71045620
*         /***********************************************************/ 71045720
*         2     SAVER15 POINTER(32),                                    71045820
*         2     SAVER0 POINTER(32),                                     71045920
*         2     SAVER1 POINTER(32),                                     71046020
*         2     SAVER2 POINTER(32),                                     71046120
*         2     SAVER3 POINTER(32),                                     71046220
*         2     SAVER4 POINTER(32),                                     71046320
*         2     SAVER5 POINTER(32),                                     71046420
*         2     SAVER6 POINTER(32),                                     71046520
*         2     SAVER7 POINTER(32),                                     71046620
*         2     SAVER8 POINTER(32),                                     71046720
*         2     SAVER9 POINTER(32),                                     71046820
*         2     SAVER10 POINTER(32),                                    71046920
*         2     SAVER11 POINTER(32),                                    71047020
*         2     SAVER12 POINTER(32),                                    71047120
*         /***********************************************************/ 71047220
*         /*   AREA USED BY PL/I AND BSL FOR TEMPORARY AND AUTOMATIC */ 71047320
*         /*   STORAGE AREAS                                         */ 71047420
*         /***********************************************************/ 71047520
*         2     SAVEXTNT CHARACTER( 8);                                 71047620
*                                                                       71047720
* /*******************************************************************/ 71047820
* /*      DEFINE A TYPE I PARAMETER LIST                             */ 71047920
* /*******************************************************************/ 71048020
* DECLARE                                                               71048120
* 1       PARAM BASED( R1) BOUNDARY( WORD),                             71048220
*         2     PARAM1 POINTER(32),                                     71048320
*         2     PARAM2 POINTER(32),                                     71048420
*         2     PARAM3 POINTER(32),                                     71048520
*         2     PARAM4 POINTER(32),                                     71048620
*         2     PARAM5 POINTER(32),                                     71048720
*         2     PARAM6 POINTER(32),                                     71048820
*         2     PARAM7 POINTER(32),                                     71048920
*         2     PARAM8 POINTER(32),                                     71049020
*         2     PARAM9 POINTER(32),                                     71049120
*         2     PARAM10 POINTER(32),                                    71049220
*         2     PARAM11 POINTER(32),                                    71049320
*         2     PARAM12 POINTER(32),                                    71049420
*         2     PARAM13 POINTER(32),                                    71049520
*         2     PARAM14 POINTER(32),                                    71049620
*         2     PARAM15 POINTER(32),                                    71049720
*         2     PARAM16 POINTER(32),                                    71049820
*         2     PARAM17 POINTER(32),                                    71049920
*         2     PARAM18 POINTER(32),                                    71050020
*         2     PARAM19 POINTER(32),                                    71050120
*         2     PARAM20 POINTER(32),                                    71050220
*         2     PARAM21 POINTER(32),                                    71050320
*         2     PARAM22 POINTER(32),                                    71050420
*         2     PARAM23 POINTER(32),                                    71050520
*         2     PARAM24 POINTER(32),                                    71050620
*         2     PARAM25 POINTER(32),                                    71050720
*         2     PARAM26 POINTER(32),                                    71050820
*         2     PARAM27 POINTER(32),                                    71050920
*         2     PARAM28 POINTER(32),                                    71051020
*         2     PARAM29 POINTER(32),                                    71051120
*         2     PARAM30 POINTER(32);                                    71051220
*                                                                       71051320
*         DECLARE                                                       71051420
*         /***********************************************************/ 71051520
*         /*    INTERNAL AUTOMATIC VARIABLES                         */ 71051620
*         /***********************************************************/ 71051720
*                                                                       71051820
*         CNVRT1 CHARACTER(8) AUTOMATIC BOUNDARY(DWORD), /*CONVERSION   71051920
*                                       BUFFER FOR CONVERSION FROM      71052020
*                                       DECIMAL TO BINARY, FROM DECIMAL 71052120
*                                       TO EBCDIC, & FROM BINARY TO     71052220
*                                       DECIMAL                      */ 71052320
*         CNVRT2 CHARACTER(4) AUTOMATIC BOUNDARY(WORD),  /*CONVERSION   71052420
*                                       BUFFER FOR CONVERSION FROM      71052520
*                                       DECIMAL TO EBCDIC            */ 71052620
*         /***********************************************************/ 71052720
*         /*    INTERNAL BASED VARIABLES, GENERATED CSECT VARIABLES, */ 71052820
*         /*    & ARGUMENTS PASSED INTO IKJEFLPA                     */ 71052920
*         /***********************************************************/ 71053020
*         1     TOD BASED BOUNDARY(BYTE),                               71053120
*               2  TODLEN FIXED(15) BOUNDARY(BYTE),                     71053220
*               2  TODOFF FIXED(15) BOUNDARY(BYTE),                     71053320
*               2  TODTXT CHARACTER(8) BOUNDARY(BYTE),                  71053420
*         DATEBUF CHARACTER(18) BASED BOUNDARY(BYTE),                   71053520
*         1     DATE BASED BOUNDARY(BYTE),                              71053620
*               2  DATELEN FIXED(15) BOUNDARY(BYTE),                    71053720
*               2  DATEOFF FIXED(15) BOUNDARY(BYTE),                    71053820
*               2  DATETXT CHARACTER(18) BOUNDARY(BYTE),                71053920
*         IKJEFLPB LABEL EXTERNAL,                                      71054020
*         PBORIGIN LABEL GENERATED,                                     71054120
*         PBCNTURY GENERATED CHARACTER(1) BOUNDARY(BYTE),               71054220
*         PBCOLON GENERATED CHARACTER(1) BOUNDARY(BYTE),                71054320
*         PBCOMBL GENERATED CHARACTER(2) BOUNDARY(BYTE),                71054420
*         PBCOMMA GENERATED CHARACTER(1) BOUNDARY(BYTE),                71054520
*         PBBLANK GENERATED CHARACTER(1) BOUNDARY(BYTE),                71054620
*         1     PBMDESCR(12) GENERATED BOUNDARY(HWORD),                 71054720
*               2  PBMLDAY FIXED(15) BOUNDARY(HWORD),                   71054820
*               2  PBMLEN FIXED(15) BOUNDARY(HWORD),                    71054920
*               2  PBMOFF FIXED(15) BOUNDARY(HWORD),                    71055020
*         PBMONTH CHARACTER(9) BASED BOUNDARY(BYTE);                    71055120
*/*       L     GET TIME OF DAY AND DATE FROM THE SYSTEM */             71055220
*         GENERATE;                                                     71055320
         TITLE 'IKJEFLPA -- TOD && TEXT PREPARATION -- IKJEFLPB EBCDIC *71055420
               CHARACTERS FOR TOD && DATE'                              71055520
* /******************************************************************/  71055620
* /*     DEFINE ALL CHARACTER-SET AND LANGUAGE-DEPENDENT DATA       */  71055720
* /*     REQUIRED FOR IKJEFLPA OPERATION                            */  71055820
* /******************************************************************/  71055920
IKJEFLPB CSECT                                                          71056020
PBORIGIN EQU   IKJEFLPB SYNONYM FOR IKJEFLPB                            71056120
PBCNTURY DC    X'19'    PACKED DECIMAL DIGITS FOR THE CURRENT CENTURY   71056220
PBCOLON  DC    C':'     IMAGE OF AN EBCDIC COLON                        71056320
PBCOMBL  DS    C', '    IMAGE OF COMMA AND BLANK                        71056420
         ORG   PBCOMBL                                                  71056520
PBCOMMA  DC    C','     IMAGE OF AN EBCDIC COMMA                        71056620
PBBLANK  DC    C' '     IMAGE OF AN EBCDIC BLANK                        71056720
&LNDESCR SETA  6        LENGTH OF PBMDESCR ARRAY ELEMENT                71056820
         SPACE                                                          71056920
* /******************************************************************/  71057020
* /*     ALLOW AT LEAST ENOUGH SPACE IN IKJEFLPB FOR 2 ARRAY        */  71057120
* /*     ELEMENTS BEFORE GENERATING THE PBMDESCR ARRAY              */  71057220
* /******************************************************************/  71057320
         ORG   IKJEFLPB RESET THE LOCATION COUNTER TO IKJEFLPB          71057420
         DS    CL(2*&LNDESCR) FORCE THE LOCATION COUNTER TO 2 TIMES    *71057520
                        THE LENGTH OF ONE PBDESCR ARRAY ELEMENT         71057620
         ORG   ,        SET THE LOCATION COUNTER TO THE HIGHEST VALUE  *71057720
                        IT HAS YET ASSUMED                              71057820
         DS    0H       ALIGN PBMDESCR ARRAY ON HALFWORD                71057920
PBMDESCR DS    CL&LNDESCR ARRAY ELEMENT                                 71058020
         ORG   PBMDESCR GENERATE INITIALIZED ARRAY OF                  *71058120
                        MONTH-DESCRIPTORS                               71058220
&LDAY(1) SETA  31             LAST DAY OF JANUARY                       71058320
&LDAY(2) SETA  &LDAY(1)+28    LAST DAY OF FEBRUARY                      71058420
&LDAY(3) SETA  &LDAY(2)+31    LAST DAY OF MARCH                         71058520
&LDAY(4) SETA  &LDAY(3)+30    LAST DAY OF APRIL                         71058620
&LDAY(5) SETA  &LDAY(4)+31    LAST DAY OF MAY                           71058720
&LDAY(6) SETA  &LDAY(5)+30    LAST DAY OF JUNE                          71058820
&LDAY(7) SETA  &LDAY(6)+31    LAST DAY OF JULY                          71058920
&LDAY(8) SETA  &LDAY(7)+31    LAST DAY OF AUGUST                        71059020
&LDAY(9) SETA  &LDAY(8)+30    LAST DAY OF SEPTEMBER                     71059120
&LDAY(10) SETA &LDAY(9)+31    LAST DAY OF OCTOBER                       71059220
&LDAY(11) SETA &LDAY(10)+30   LAST DAY OF NOVEMBER                      71059320
&LDAY(12) SETA &LDAY(11)+31   LAST DAY OF DECEMBER                      71059420
** /*                                                                   71059520
&I       SETA  0                                                        71059620
.PB00100 ANOP                                                           71059720
&I       SETA  &I+1                                                     71059820
         DC    H'&LDAY(&I)' LAST DAY OF MONTH                           71059920
         DC    AL2(L'PB&I) LENGTH OF THE NAME OF THE MONTH              71060020
         DC    AL2(PB&I-IKJEFLPB) OFFSET OF THE NAME OF THE MONTH       71060120
         AIF   (&I LT 12).PB00100                                       71060220
PB1      DC    C'JANUARY'     ENGLISH NAME FOR 1ST MONTH IN EBCDIC      71060320
PB2      DC    C'FEBRUARY'    ENGLISH NAME FOR 2ND MONTH IN EBCDIC      71060420
PB3      DC    C'MARCH'       ENGLISH NAME FOR 3RD MONTH IN EBCDIC      71060520
PB4      DC    C'APRIL'       ENGLISH NAME FOR 4TH MONTH IN EBCDIC      71060620
PB5      DC    C'MAY'         ENGLISH NAME FOR 5TH MONTH IN EBCDIC      71060720
PB6      DC    C'JUNE'        ENGLISH NAME FOR 6TH MONTH IN EBCDIC      71060820
PB7      DC    C'JULY'        ENGLISH NAME FOR 7TH MONTH IN EBCDIC      71060920
PB8      DC    C'AUGUST'      ENGLISH NAME FOR 8TH MONTH IN EBCDIC      71061020
PB9      DC    C'SEPTEMBER'   ENGLISH NAME FOR 9TH MONTH IN EBCDIC      71061120
PB10     DC    C'OCTOBER'     ENGLISH NAME FOR 10TH MONTH IN EBCDIC     71061220
PB11     DC    C'NOVEMBER'    ENGLISH NAME FOR 11TH MONTH IN EBCDIC     71061320
PB12     DC    C'DECEMBER'    ENGLISH NAME FOR 12TH MONTH IN EBCDIC     71061420
         TITLE    'IKJEFLPA -- TOD && DATE TEXT PREPARATION -- PREPARE *71061520
               TOD BUFFER'                                              71061620
IKJEFLPA CSECT                                                          71061720
** */                                                                   71061820
*        /***********************************************************/  71061920
*        /*     R0 = 'HHMMSSTQ' WHERE HH IS THE HOUR, MM IS THE     */  71062020
*        /*        MINUTE, SS IS THE SECOND, T IS THE TENTH OF A    */  71062120
*        /*        SECOND, AND Q IS THE HUNDREDTH                   */  71062220
*        /*     R1 = '00YYDDDZ' WHERE YY IS THE YEAR DDD IS THE DAY */  71062320
*        /*        AND Z IS A ZONE WHICH INDICATES A POSITIVE       */  71062420
*        /*        DECIMAL NUMBER                                   */  71062520
*        /***********************************************************/  71062620
         TIME  DEC      OBTAIN TIME IN R0, DATE IN R1                   71062720
         DS    0H                                                       71062820
*         CNVRT2 = R0;                /*CNVRT2 = '00HHMMSS' WHERE HH    71062920
*                                       IS THE HOUR, MM IS THE  MINUTE, 71063020
*                                       AND SS IS THE SECOND         */ 71063120
         ST    @0,CNVRT2                                          0010  71063220
*         RESPECIFY( R0) UNRESTRICTED; /*ALLOW IMPLICIT REFERENCES TO   71063320
*                                       R0                           */ 71063420
*         RESPECIFY( R2, R3) RESTRICTED; /*RESERVE VARIABLES FOR        71063520
*                                       EXPLICIT REFERENCES          */ 71063620
*         /***********************************************************/ 71063720
*         /*    ESTABLISH A POINTER TO THE TIME-OF-DAY (TOD) TEXT    */ 71063820
*         /*    INSERTION BUFFER                                     */ 71063920
*         /***********************************************************/ 71064020
*         R2 = SAVELAST -> SAVER1 -> PARAM1;                            71064120
         L     @8,4(0,@D)                                         0013  71064220
         L     @8,24(0,@8)         SAVEAREA                       0013  71064320
         L     @2,0(0,@8)                                         0013  71064420
*         RESPECIFY( TOD) BASED(R2);                                    71064520
*         R3 = ADDR(IKJEFLPB);         /*ESTABLISH A POINTER TO         71064620
*                                        IKJEFLPB                    */ 71064720
         L     @9,@V1              ADDRESS OF IKJEFLPB            0015  71064820
         LR    @3,@9                                              0015  71064920
*/*       P     PLACE TOD IN BYTES 7-12 OF BUFFER                    */ 71065020
*         GENERATE;                                                     71065120
         USING IKJEFLPB,R3          TELL THE ASSEMBLER HOW TO FIND     *71065220
                                    IKJEFLPB                            71065320
         SPACE                                                          71065420
*        /************************************************************  71065520
*             PLACE TOD IN BYTES 7-12 OF BUFFER                         71065620
*        ************************************************************/  71065720
         MVO  CNVRT1(4),CNVRT2(3)   SHIFT OUT TENTHS OF SECONDS DIGIT   71065820
         UNPK TODTXT+2-TOD(6,R2),CNVRT1(4)   CONVERT TIME OF DAY TO    *71065920
                                    CHARACTER FORMAT                    71066020
         MVZ  TODTXT+7-TOD(1,R2),TODTXT+2-TOD(R2)  INSERT PROPER ZONE  *71066120
                                    FIELD INTO THE FINAL SECONDS DIGIT  71066220
         DS    0H                                                       71066320
*         /***********************************************************/ 71066420
*/*       P     SET LENGTH OF TOD BUFFER                             */ 71066520
*         /***********************************************************/ 71066620
*         TODLEN = 12;                                                  71066720
         MVC   0(2,@2),@D1                                        0017  71066820
*                                                                       71066920
*         /***********************************************************/ 71067020
*/*       P     MOVE DIGITS OF HOUR TO BYTES 5-6 OF BUFFER           */ 71067120
*         /***********************************************************/ 71067220
*         TODTXT( 1: 2) = TODTXT( 3: 4);                                71067320
         MVC   4(2,@2),6(@2)                                      0018  71067420
*                                                                       71067520
*         /***********************************************************/ 71067620
*/*       P     MOVE COLON TO BYTE 7 OF BUFFER                       */ 71067720
*         /***********************************************************/ 71067820
*         TODTXT( 3) = PBCOLON;                                         71067920
         MVC   6(1,@2),PBCOLON                                    0019  71068020
*                                                                       71068120
*         /***********************************************************/ 71068220
*/*       P     MOVE DIGITS OF MINUTE TO BYTES 8-9 OF BUFFER         */ 71068320
*         /***********************************************************/ 71068420
*         TODTXT( 4: 5) = TODTXT( 5: 6);                                71068520
         MVC   7(2,@2),8(@2)                                      0020  71068620
*                                                                       71068720
*         /***********************************************************/ 71068820
*/*       P     MOVE COLON TO BYTE 10 OF BUFFER                      */ 71068920
*         /***********************************************************/ 71069020
*         TODTXT( 6) = PBCOLON;                                         71069120
         MVC   9(1,@2),PBCOLON                                    0021  71069220
*         GENERATE;                                                     71069320
         TITLE    'IKJEFLPA -- TOD && DATE TEXT PREPARATION -- PREPARE *71069420
               DATE BUFFER'                                             71069520
         DS    0H                                                       71069620
*                                                                       71069720
*         /***********************************************************/ 71069820
*         /*     DATE PROCESSING                                     */ 71069920
*         /***********************************************************/ 71070020
*         CNVRT2 = R1;                /*SET CNVRT2 TO THE DATE IN       71070120
*                                       DECIMAL                      */ 71070220
         ST    @1,CNVRT2                                          0023  71070320
*         RESPECIFY( R1) UNRESTRICTED; /*ALLOW IMPLICIT REFERENCES      71070420
*                                       TO R1                        */ 71070520
*                                                                       71070620
*         /***********************************************************/ 71070720
*         /*    ESTABLISH POINTER TO DATE TEXT INSERTION BUFFER      */ 71070820
*         /***********************************************************/ 71070920
*         R2 = SAVELAST -> SAVER1 -> PARAM2;                            71071020
         L     @2,4(0,@8)                                         0025  71071120
*         RESPECIFY( DATE) BASED(R2);                                   71071220
*                                                                       71071320
*         /***********************************************************/ 71071420
*         /*    CNVRT1 = '000000000000DDDZ'X                         */ 71071520
*         /***********************************************************/ 71071620
*         CNVRT1( 1: 6) = CNVRT1( 1: 6) && CNVRT1( 1: 6);               71071720
         XC    CNVRT1(6),CNVRT1                                   0027  71071820
*         CNVRT1( 7: 8) = CNVRT2( 3: 4);                                71071920
         MVC   CNVRT1+6(2),CNVRT2+2                               0028  71072020
*         RESPECIFY( R4, R5) RESTRICTED; /*RESERVE VARIABLES FOR        71072120
*                                       EXPLICIT REFERENCES          */ 71072220
*                                                                       71072320
*         /***********************************************************/ 71072420
*         /*    R4 = DAY OF YEAR IN BINARY                           */ 71072520
*         /*    R5 = YEAR IN BINARY                                  */ 71072620
*         /***********************************************************/ 71072720
*         GENERATE;                                                     71072820
         CVB   R4,CNVRT1               R4 = DAY OF YEAR IN BINARY       71072920
         MVO   CNVRT1+5(3),CNVRT2+0(2) CNVRT1 = year yy in packed  @L01 71073020
         CVB   R5,CNVRT1               R5 = YEAR IN BINARY              71073120
         XC    CNVRT1(8),CNVRT1        Convert year                @L01 71073130
         MVC   CNVRT1+4(4),CNVRT2       ccyydddF                   @L01 71073140
         CVB   R15,CNVRT1                to binary                 @L01 71073150
         A     R15,F1900               Add 1900 to year            @L01 71073160
         CVD   R15,CNVRT1               convert back to packed     @L01 71073170
         MVC   CNVRT2(4),CNVRT1+4        save yyyydddC in CNVRT2   @L01 71073180
         OI    CNVRT2+3,X'0F'             and force positive sign  @L01 71073190
         DS    0H                                                       71073220
*                                                                       71073320
*         RESPECIFY( R7) RESTRICTED;  /*RESERVE VARIABLE FOR            71073420
*                                       EXPLICIT REFERENCES          */ 71073520
*                                                                       71073620
*         /***********************************************************/ 71073720
*/*       P     SET INDEX OF MONTH TO JANUARY                        */ 71073820
*         /***********************************************************/ 71073920
*         R7 = 1;                                                       71074020
         LA    @7,1                                               0032  71074120
*                                                                       71074220
*         /***********************************************************/ 71074320
*/*       D     (YES,PA000620,NO,)                                      71074420
*/*             MONTH = JANUARY                                      */ 71074520
*         /*    IF THE DAY IS WITHIN JANUARY, CONSTRUCT THE DATE TEXT*/ 71074620
*         /*    INSERTION BUFFER                                     */ 71074720
*         /***********************************************************/ 71074820
*         IF R4 <= PBMLDAY(1)                                           71074920
*         THEN                                                          71075020
         CH    @4,PBMDESCR                                        0033  71075120
*               GO TO PA000620;                                         71075220
         BC    12,PA000620                                        0034  71075320
*                                                                       71075420
*         /***********************************************************/ 71075520
*/*       D     (YES,,NO,PA000400)                                      71075620
*/*             LEAP YEAR?                                           */ 71075720
*         /*    IF THE DAY IS NOT WITHIN JANUARY AND THE YEAR IS     */ 71075820
*         /*    DIVISIBLE BY FOUR, TREAT THE YEAR AS A LEAP YEAR     */ 71075920
*         /***********************************************************/ 71076020
*         R5 = R5 // 4;                                                 71076120
         LR    @E,@5                                              0035  71076220
         SRDA  @E,32                                              0035  71076320
         LA    @0,4                                               0035  71076420
         DR    @E,@0                                              0035  71076520
         LR    @5,@E                                              0035  71076620
*         IF R5 = 0                                                     71076720
*         THEN                                                          71076820
         LTR   @5,@5                                              0036  71076920
         BC    07,@9FF                                            0036  71077020
*               /*****************************************************/ 71077120
*/*             P  DECREMENT DAY OF YEAR TO COMPENSATE FOR LONG         71077220
*/*                FEBRUARY                                          */ 71077320
*               /*****************************************************/ 71077420
*               R4 = R4 - 1;                                            71077520
         BCTR  @4,0                                               0037  71077620
*                                                                       71077720
*PA000400:/***********************************************************/ 71077820
*/*PA000400: P  INCREMENT INDEX OF MONTH                             */ 71077920
*         /***********************************************************/ 71078020
*         R7 = R7 + 1;                                                  71078120
@9FF     EQU   *                                                  0038  71078220
PA000400 AH    @7,@D2                                             0038  71078320
*                                                                       71078420
*         /***********************************************************/ 71078520
*/*       D     (YES,PA000600,NO,)                                      71078620
*/*             INDEX OF MONTH > 11                                  */ 71078720
*         /***********************************************************/ 71078820
*         IF R7 > 11                                                    71078920
*         THEN                                                          71079020
         CH    @7,@D3                                             0039  71079120
*               GO TO PA000600;                                         71079220
         BC    02,PA000600                                        0040  71079320
*                                                                       71079420
*         /***********************************************************/ 71079520
*/*       D     (YES,PA000400,NO,)                                      71079620
*/*             DAY OF YEAR > LAST DAY OF INDEXED MONTH              */ 71079720
*         /***********************************************************/ 71079820
*         IF R4 > PBMLDAY( R7)                                          71079920
*         THEN                                                          71080020
         LR    @1,@7                                              0041  71080120
         MH    @1,@D4                                             0041  71080220
         CH    @4,PBMDESCR-6(@1)                                  0041  71080320
*               GO TO PA000400;                                         71080420
         BC    02,PA000400                                        0042  71080520
*                                                                       71080620
*         /***********************************************************/ 71080720
*/*       D     (YES,,NO,PA000600)                                      71080820
*/*             MONTH = FEBRUARY & LEAP YEAR                         */ 71080920
*         /***********************************************************/ 71081020
*         IF R7 = 2 & R5 = 0                                            71081120
*         THEN                                                          71081220
         CH    @7,@D5                                             0043  71081320
         BC    07,@9FE                                            0043  71081420
         LTR   @5,@5                                              0043  71081520
         BC    07,@9FD                                            0043  71081620
*               /*****************************************************/ 71081720
*/*             P  INCREMENT DAY OF YEAR TO ALLOW FEBRUARY 29 DAYS   */ 71081820
*               /*****************************************************/ 71081920
*               R4 = R4 + 1;                                            71082020
         AH    @4,@D2                                             0044  71082120
*         RESPECIFY( R5) UNRESTRICTED; /*ALLOW IMPLICIT REFERENCES      71082220
*                                        TO R5                       */ 71082320
@9FD     EQU   *                                                  0045  71082420
@9FE     EQU   *                                                  0045  71082520
*                                                                       71082620
*PA000600:/***********************************************************/ 71082720
*/*PA000600: P  DAY OF MONTH = DAY OF YEAR - LAST DAY OF                71082820
*/*             PREVIOUS MONTH                                       */ 71082920
*         /***********************************************************/ 71083020
*         R4 = R4 - PBMLDAY( R7 - 1);                                   71083120
PA000600 LR    @1,@7                                              0046  71083220
         MH    @1,@D4                                             0046  71083320
         LH    @F,PBMDESCR-12(@1)                                 0046  71083420
         LCR   @F,@F                                              0046  71083520
         AR    @4,@F                                              0046  71083620
*         RESPECIFY( R5, R6) RESTRICTED; /*RESERVE VARIABLES FOR        71083720
*                                       EXPLICIT REFERENCES          */ 71083820
*PA000620:/***********************************************************/ 71083920
*/*PA000620: P  MOVE NAME OF THE MONTH TO DATE BUFFER                */ 71084020
*         /***********************************************************/ 71084120
*         R5 = PBMLEN( R7);           /*R5 = LENGTH OF THE NAME OF      71084220
*                                       THE MONTH                    */ 71084320
PA000620 LR    @1,@7                                              0048  71084420
         MH    @1,@D4                                             0048  71084520
         LH    @5,PBMDESCR-4(@1)                                  0048  71084620
*         R6 = ADDR( PBORIGIN) + PBMOFF( R7);/*R6 = ADDRESS OF THE NAME 71084720
*                                       OF THE MONTH                 */ 71084820
         LH    @F,PBMDESCR-2(@1)                                  0049  71084920
         LA    @0,PBORIGIN                                        0049  71085020
         AR    @F,@0                                              0049  71085120
         LR    @6,@F                                              0049  71085220
*         RESPECIFY( R7) UNRESTRICTED;/*ALLOW IMPLICIT REFERENCES TO A  71085320
*                                       VARIABLE                     */ 71085420
*                                                                       71085520
*         /***********************************************************/ 71085620
*         /*    MOVE NAME OF THE MONTH TO DATE BUFFER                */ 71085720
*         /***********************************************************/ 71085820
*         DATETXT( 1: R5) = R6 -> PBMONTH( 1: R5);                      71085920
         LR    @E,@6                                              0051  71086020
         LR    @7,@5                                              0051  71086120
         BCTR  @7,0                                               0051  71086220
         LA    @A,4(0,@2)                                         0051  71086320
         EX    @7,@MVC                                            0051  71086420
*         R6 = ADDR( DATETXT( R5 + 1)); /*R6 = ADDRESS OF FIRST UNUSED  71086520
*                                       CHARACTER OF DATE BUFFER     */ 71086620
         LA    @7,1                                               0052  71086720
         AR    @7,@5                                              0052  71086820
         LA    @6,3(@7,@2)                                        0052  71086920
*                                                                       71087020
*         /***********************************************************/ 71087120
*/*       P     MOVE BLANK AFTER THE NAME OF THE MONTH               */ 71087220
*         /***********************************************************/ 71087320
*         R6 -> DATEBUF( 1) = PBBLANK;                                  71087420
         MVC   0(1,@6),PBBLANK                                    0053  71087520
*                                                                       71087620
*         /***********************************************************/ 71087720
*         /*    CNVRT1 = '0000000000000DDZ'X WHERE DD IS THE DAY     */ 71087820
*         /*    WITHIN THE MONTH AND Z IS A POSITIVE ZONE FIELD      */ 71087920
*         /***********************************************************/ 71088020
*         GENERATE(CVD   R4,CNVRT1);                                    71088120
         CVD   R4,CNVRT1                                                71088220
         DS    0H                                                       71088320
*         RESPECIFY( R4) UNRESTRICTED; /*ALLOW IMPLICIT REFERENCES      71088420
*                                       TO R4                        */ 71088520
*         /***********************************************************/ 71088620
*         /*    CNVRT1 = '0000000DDZ000DDZ'X                         */ 71088720
*         /***********************************************************/ 71088820
*         CNVRT1( 4: 5) = CNVRT1( 7: 8);                                71088920
         MVC   CNVRT1+3(2),CNVRT1+6                               0056  71089020
*         GENERATE;                                                     71089120
         SPACE                                                          71089220
*        /***********************************************************/  71089320
*        /*    CNVRT1 = '0000000DDZ000YYZ'X                         */  71089420
*        /***********************************************************/  71089520
         MVO   CNVRT1+6(2),CNVRT2+1(1)                                  71089620
         SPACE                                                          71089720
*        /***********************************************************/  71089820
*        /*    CNVRT1 = '0000000DDZ0CCYYZ'X WHERE DD IS THE DAY OF  */  71089920
*        /*    THE MONTH, Z IS A POSITIVE ZONE, CC IS THE CENTURY,  */  71090020
*        /*    AND YY IS THE YEAR                                   */  71090120
*        /***********************************************************/  71090220
         MVO   CNVRT1+5(2),CNVRT2+0(1) Set first two digits        @L01 71090320
         DS    0H                                                       71090420
*                                                                       71090520
*         /***********************************************************/ 71090620
*/*       D     (YES,PA000700,NO,PA000800)                              71090720
*/*             DAY OF MONTH < 10                                    */ 71090820
*         /***********************************************************/ 71090920
*         IF CNVRT1( 4) = '00'X                                         71091020
*         THEN                                                          71091120
         CLI   CNVRT1+3,X'00'                                     0058  71091220
         BC    07,@9FC                                            0058  71091320
*/*PA000700:    P  MOVE DIGITS OF DATE TO BUFFER. ONE DIGIT FOR DAY  */ 71091420
*                                                                       71091520
*PA000700:               DO;                                            71091620
*               /*****************************************************/ 71091720
*               /* DATE = '????MONTH D??CCY'  'ZY'X WHERE D IS THE */ 71091820
*               /* FINAL DIGIT OF THE DAY OF THE MONTH, CC IS THE    */ 71091920
*               /* CENTURY, Y IS THE FIRST DIGIT OF THE YEAR, Z IS A */ 71092020
*               /* POSITIVE ZONE DIGIT, AND Y IS THE SECOND DIGIT OF */ 71092120
*               /* THE YEAR                                          */ 71092220
*               /*****************************************************/ 71092320
*               GENERATE(UNPK  DATEBUF+1-DATEBUF(7,R6),CNVRT1+4(4));    71092420
PA000700 UNPK  DATEBUF+1-DATEBUF(7,R6),CNVRT1+4(4)                      71092520
         DS    0H                                                       71092620
*               /*****************************************************/ 71092720
*/*             P  (,%A000900)                                          71092820
*/*                SET DATE BUFFER LENGTH FIELD                      */ 71092920
*               /*****************************************************/ 71093020
*               DATELEN = R5 + 12;                                      71093120
         LA    @F,12                                              0061  71093220
         AR    @F,@5                                              0061  71093320
         ST    @F,@TEMP4                                          0061  71093420
         MVC   0(2,@2),@TEMP4+2                                   0061  71093520
*               /*****************************************************/ 71093620
*               /* R6 = ADDRESS OF THE LAST CHARACTER OF THE NAME OF */ 71093720
*               /* THE MONTH WITHIN THE DATE BUFFER                  */ 71093820
*               /*****************************************************/ 71093920
*               R6 = R6 - 1;                                            71094020
         BCTR  @6,0                                               0062  71094120
         BC    15,@9FB                                            0064  71094220
*               END PA000700;                                           71094320
*                                                                       71094420
*         /***********************************************************/ 71094520
*         /*  IF THE FIRST DIGIT OF THE DAY OF THE MONTH IS NONZERO, */ 71094620
*         /*  PLACE A TWO-DIGIT DAY OF THE MONTH IN THE DATE BUFFER  */ 71094720
*         /***********************************************************/ 71094820
*         ELSE                                                          71094920
*/*PA000800:    P  MOVE DIGITS OF DATE TO BUFFER. TWO DIGITS FOR DAY */ 71095020
*                                                                       71095120
*PA000800:               DO;                                            71095220
@9FC     EQU   *                                                  0064  71095320
*               /*****************************************************/ 71095420
*               /* DATE = '????MONTH DD??CCY'  'ZY'X WHERE DD IS   */ 71095520
*               /* THE DAY OF THE MONTH, CC IS THE CENTURY, Y IS     */ 71095620
*               /* THE FIRST DIGIT OF THE YEAR, Z IS A POSITIVE ZONE */ 71095720
*               /* DIGIT, AND Y IS THE SECOND DIGIT OF THE YEAR      */ 71095820
*               /*****************************************************/ 71095920
*                                                                       71096020
*               GENERATE(UNPK  DATEBUF+1-DATEBUF(8,R6),CNVRT1+3(5));    71096120
PA000800 UNPK  DATEBUF+1-DATEBUF(8,R6),CNVRT1+3(5)                      71096220
         DS    0H                                                       71096320
*                                                                       71096420
*               /*****************************************************/ 71096520
*/*             P  (,%A000900)                                          71096620
*/*                SET DATE BUFFER LENGTH FIELD                      */ 71096720
*               /*****************************************************/ 71096820
*               DATELEN = R5 + 13;                                      71096920
         LA    @F,13                                              0066  71097020
         AR    @F,@5                                              0066  71097120
         ST    @F,@TEMP4                                          0066  71097220
         MVC   0(2,@2),@TEMP4+2                                   0066  71097320
*               END PA000800;                                           71097420
*                                                                       71097520
*         /***********************************************************/ 71097620
*/*%A000900: P  MOVE COMMA AND BLANK AFTER DIGIT(S) OF MONTH         */ 71097720
*         /***********************************************************/ 71097820
*         R6 -> DATEBUF( 4: 5) = PBCOMBL;                               71097920
@9FB     MVC   3(2,@6),PBCOMBL                                    0068  71098020
*         GENERATE;                                                     71098120
         SPACE                                                          71098220
*        /***********************************************************/  71098320
*        /*    PROVIDE PROPER ZONE FIELD FOR FINAL DIGIT OF THE YEAR*/  71098420
*        /***********************************************************/  71098520
         MVZ   DATEBUF+8-DATEBUF(1,R6),DATEBUF+2-DATEBUF(R6)            71098620
         TITLE 'IKJEFLPA -- TOD && DATE TEXT PREPARATION -- EPILOGUE'   71098720
         DS    0H                                                       71098820
*         /***********************************************************/ 71098920
*/*       R     RETURN TO INVOKER                                    */ 71099020
*/*IKJEFLPA: END                                                     */ 71099120
*         /***********************************************************/ 71099220
*         RETURN;                                                       71099320
*         END IKJEFLPA                                                  71099420
*/* THE FOLLOWING INCLUDE STATEMENTS WERE FOUND IN THIS PROGRAM.      * 71099520
*/*%INCLUDE SYSLIB  (IEFDCL1 )                                        * 71099620
*/*%INCLUDE SYSLIB  (IEFDCL2 )                                        * 71099720
*;                                                                      71099820
@EL01    L     @D,4(0,@D)                                         0071  71099920
         LR    @1,@C                                              0071  71100020
         L     @0,@SIZ001                                         0071  71100120
         FREEMAIN R,LV=(0),A=(1)                                  0071  71100220
         LM    @E,@C,12(@D)                                       0071  71100320
         BCR   15,@E                                              0071  71100420
@DATA1   EQU   *                                                        71100520
@0       EQU   00                  EQUATES FOR REGISTERS 0-15           71100620
@1       EQU   01                                                       71100720
@2       EQU   02                                                       71100820
@3       EQU   03                                                       71100920
@4       EQU   04                                                       71101020
@5       EQU   05                                                       71101120
@6       EQU   06                                                       71101220
@7       EQU   07                                                       71101320
@8       EQU   08                                                       71101420
@9       EQU   09                                                       71101520
@A       EQU   10                                                       71101620
@B       EQU   11                                                       71101720
@C       EQU   12                                                       71101820
@D       EQU   13                                                       71101920
@E       EQU   14                                                       71102020
@F       EQU   15                                                       71102120
@D1      DC    H'12'                                                    71102220
@D2      DC    H'1'                                                     71102320
@D3      DC    H'11'                                                    71102420
@D4      DC    H'6'                                                     71102520
@D5      DC    H'2'                                                     71102620
@MVC     MVC   0(1,@A),0(@E)                                            71102720
@V1      DC    V(IKJEFLPB)                                              71102820
F1900    DC    A(1900*1000)            Four-digit year adjustment  @L01 71102870
         DS    0F                                                       71102920
@SIZ001  DC    AL1(&SPN)                                                71103020
         DC    AL3(@DATEND-@DATD)                                       71103120
         DS    0F                                                       71103220
         DS    0D                                                       71103320
@DATA    EQU   *                                                        71103420
R0       EQU   00000000            FULLWORD POINTER REGISTER            71103520
R1       EQU   00000001            FULLWORD POINTER REGISTER            71103620
R2       EQU   00000002            FULLWORD POINTER REGISTER            71103720
R3       EQU   00000003            FULLWORD POINTER REGISTER            71103820
R4       EQU   00000004            FULLWORD INTEGER REGISTER            71103920
R5       EQU   00000005            FULLWORD INTEGER REGISTER            71104020
R6       EQU   00000006            FULLWORD POINTER REGISTER            71104120
R7       EQU   00000007            FULLWORD POINTER REGISTER            71104220
R8       EQU   00000008            FULLWORD POINTER REGISTER            71104320
R9       EQU   00000009            FULLWORD POINTER REGISTER            71104420
R10      EQU   00000010            FULLWORD POINTER REGISTER            71104520
R11      EQU   00000011            FULLWORD POINTER REGISTER            71104620
R12      EQU   00000012            FULLWORD POINTER REGISTER            71104720
R13      EQU   00000013            FULLWORD POINTER REGISTER            71104820
R14      EQU   00000014            FULLWORD POINTER REGISTER            71104920
R15      EQU   00000015            FULLWORD POINTER REGISTER            71105020
SAVEAREA EQU   00000000            80 BYTE(S) ON WORD                   71105120
SAVEWRD1 EQU   SAVEAREA+00000000   FULLWORD POINTER                     71105220
SAVEPFLG EQU   SAVEAREA+00000000   1  BYTE  POINTER                     71105320
SAVEPLGH EQU   SAVEAREA+00000001   3  BYTE  POINTER ON WORD+1           71105420
SAVELAST EQU   SAVEAREA+00000004   FULLWORD POINTER                     71105520
SAVENEXT EQU   SAVEAREA+00000008   FULLWORD POINTER                     71105620
SAVER14  EQU   SAVEAREA+00000012   FULLWORD POINTER                     71105720
SAVERETF EQU   SAVEAREA+00000012   1  BYTE  POINTER                     71105820
SAVER15  EQU   SAVEAREA+00000016   FULLWORD POINTER                     71105920
SAVER0   EQU   SAVEAREA+00000020   FULLWORD POINTER                     71106020
SAVER1   EQU   SAVEAREA+00000024   FULLWORD POINTER                     71106120
SAVER2   EQU   SAVEAREA+00000028   FULLWORD POINTER                     71106220
SAVER3   EQU   SAVEAREA+00000032   FULLWORD POINTER                     71106320
SAVER4   EQU   SAVEAREA+00000036   FULLWORD POINTER                     71106420
SAVER5   EQU   SAVEAREA+00000040   FULLWORD POINTER                     71106520
SAVER6   EQU   SAVEAREA+00000044   FULLWORD POINTER                     71106620
SAVER7   EQU   SAVEAREA+00000048   FULLWORD POINTER                     71106720
SAVER8   EQU   SAVEAREA+00000052   FULLWORD POINTER                     71106820
SAVER9   EQU   SAVEAREA+00000056   FULLWORD POINTER                     71106920
SAVER10  EQU   SAVEAREA+00000060   FULLWORD POINTER                     71107020
SAVER11  EQU   SAVEAREA+00000064   FULLWORD POINTER                     71107120
SAVER12  EQU   SAVEAREA+00000068   FULLWORD POINTER                     71107220
SAVEXTNT EQU   SAVEAREA+00000072   8 BYTE(S)                            71107320
PARAM    EQU   00000000            120 BYTE(S) ON WORD                  71107420
PARAM1   EQU   PARAM+00000000      FULLWORD POINTER                     71107520
PARAM2   EQU   PARAM+00000004      FULLWORD POINTER                     71107620
PARAM3   EQU   PARAM+00000008      FULLWORD POINTER                     71107720
PARAM4   EQU   PARAM+00000012      FULLWORD POINTER                     71107820
PARAM5   EQU   PARAM+00000016      FULLWORD POINTER                     71107920
PARAM6   EQU   PARAM+00000020      FULLWORD POINTER                     71108020
PARAM7   EQU   PARAM+00000024      FULLWORD POINTER                     71108120
PARAM8   EQU   PARAM+00000028      FULLWORD POINTER                     71108220
PARAM9   EQU   PARAM+00000032      FULLWORD POINTER                     71108320
PARAM10  EQU   PARAM+00000036      FULLWORD POINTER                     71108420
PARAM11  EQU   PARAM+00000040      FULLWORD POINTER                     71108520
PARAM12  EQU   PARAM+00000044      FULLWORD POINTER                     71108620
PARAM13  EQU   PARAM+00000048      FULLWORD POINTER                     71108720
PARAM14  EQU   PARAM+00000052      FULLWORD POINTER                     71108820
PARAM15  EQU   PARAM+00000056      FULLWORD POINTER                     71108920
PARAM16  EQU   PARAM+00000060      FULLWORD POINTER                     71109020
PARAM17  EQU   PARAM+00000064      FULLWORD POINTER                     71109120
PARAM18  EQU   PARAM+00000068      FULLWORD POINTER                     71109220
PARAM19  EQU   PARAM+00000072      FULLWORD POINTER                     71109320
PARAM20  EQU   PARAM+00000076      FULLWORD POINTER                     71109420
PARAM21  EQU   PARAM+00000080      FULLWORD POINTER                     71109520
PARAM22  EQU   PARAM+00000084      FULLWORD POINTER                     71109620
PARAM23  EQU   PARAM+00000088      FULLWORD POINTER                     71109720
PARAM24  EQU   PARAM+00000092      FULLWORD POINTER                     71109820
PARAM25  EQU   PARAM+00000096      FULLWORD POINTER                     71109920
PARAM26  EQU   PARAM+00000100      FULLWORD POINTER                     71110020
PARAM27  EQU   PARAM+00000104      FULLWORD POINTER                     71110120
PARAM28  EQU   PARAM+00000108      FULLWORD POINTER                     71110220
PARAM29  EQU   PARAM+00000112      FULLWORD POINTER                     71110320
PARAM30  EQU   PARAM+00000116      FULLWORD POINTER                     71110420
TOD      EQU   00000000            12 BYTE(S)                           71110520
TODLEN   EQU   TOD+00000000        2  BYTE  INTEGER                     71110620
TODOFF   EQU   TOD+00000002        2  BYTE  INTEGER                     71110720
TODTXT   EQU   TOD+00000004        8 BYTE(S)                            71110820
DATEBUF  EQU   00000000            18 BYTE(S)                           71110920
DATE     EQU   00000000            22 BYTE(S)                           71111020
DATELEN  EQU   DATE+00000000       2  BYTE  INTEGER                     71111120
DATEOFF  EQU   DATE+00000002       2  BYTE  INTEGER                     71111220
DATETXT  EQU   DATE+00000004       18 BYTE(S)                           71111320
PBMLDAY  EQU   PBMDESCR+00000000   HALFWORD INTEGER                     71111420
PBMLEN   EQU   PBMDESCR+00000002   HALFWORD INTEGER                     71111520
PBMOFF   EQU   PBMDESCR+00000004   HALFWORD INTEGER                     71111620
PBMONTH  EQU   00000000            9 BYTE(S)                            71111720
         DS    00000000C                                                71111820
@L       EQU   1                                                        71111920
@DATD    DSECT                                                          71112020
@SAV001  EQU   @DATD+00000000      72 BYTE(S) ON WORD                   71112120
CNVRT1   EQU   @DATD+00000072      8 BYTE(S) ON DWORD                   71112220
CNVRT2   EQU   @DATD+00000080      4 BYTE(S) ON WORD                    71112320
         DS    00000084C                                                71112420
@TEMPS   DS    0F                                                       71112520
@TEMP4   DC    F'0'                                                     71112620
@DATEND  EQU   *                                                        71112720
IKJEFLPA CSECT ,                                                        71112820
         END   IKJEFLPA                                                 71112920
./ ENDUP
/*
//*
//*-----------------------------------------------------------------***
//*     Step 2:  Update SGIEE00V in SYS1.MODGEN.                    ***
//*-----------------------------------------------------------------***
//IEE00V EXEC PGM=IEBUPDTE,
//*IEE00V EXEC PGM=IEFBR14,
//            PARM=MOD,
//            REGION=256K
//SYSUT1   DD DISP=SHR,DSN=SYS1.MODGEN
//SYSUT2   DD DISP=SHR,DSN=SYS1.MODGEN
//SYSPRINT DD SYSOUT=A
//SYSIN    DD *
./ CHANGE NAME=SGIEE00V,LIST=ALL   >>>> 2018/05/18
K28      EQU   28 -                            **              @TMVT805 02651000
*                                  YEAR 2060 OR MORE)          @TMVT805 04577420
*    HOWEVER, THIS ROUTINE DOES NOT RECOGNIZE ANY YEAR OVER    @TMVT805 04599020
*    2099 AS VALID. ANY YEAR GREATER THAN 2099 WILL BE TREATED @TMVT805 04599620
*    AS IF THE CONDITION CODE FROM THE STORE CLOCK(STCK) HAD   @TMVT805 04600220
*    BEEN = 1.                                                 @TMVT805 04600400
         CL    R7,TODMAX -         Is TOD GE 2060-01-01?       @TMVT805 04604420
         AH    R7,H1900 -          Adjust for four-digit year  @TMVT805 04658000
         UNPK  YDATE(K5),DOUBLE+K4(K4) - Unpack year (yyyy)    @TMVT805 04665021
         MVC   YDATE(K4),D1960 -   Year is 1960                @TMVT805 04677521
         MVI   YDATE+K4,DOT -       Set up command (yyyy.ddd)  @TMVT805 04692521
         MVC   MSGCHNG+K13(K8),YDATE - Put current date in WTO @TMVT805 04742521
         MVC   MSGCHNG+K28(K8),HTIME - Put current time in WTO @TMVT805 04745021
         MVC   TODREPLY+K5(K8),YDATE - Move yyyy.ddd to buffer @TMVT805 04777521
         MVC   K6(K8,R5),YDATE -     DATE=tod for SET command  @TMVT805 04810021
TODMSG2  WTOR  'IEE114A DATE=0000.000,CLOCK=00.00.00 - REPLY WITH SET P+09504820
               ARAMETERS OR U',MF=L,ROUTCDE=(1),DESC=(2) -     @TMVT805 09505220
YDATE    DC    CL5'0'              *             KEEP THIS     @TMVT805 09508820
H1900    DC    H'1900' -           To adjust four-digit year   @TMVT805 09513220
TODMAX   DC    0F'0',X'B3625A1C' - Maximum TOD 2060-01-01      @TMVT805 09513400
D1960    DS    0CL4 -              Four-digit character 1960   @TMVT805 09515700
         DC    C'19' -             First two digits of "1960"  @TMVT805 09515800
./ ENDUP
/*
//*
//*-----------------------------------------------------------------***
//*     Step 3:  Assemble IEE0603D.                                 ***
//*-----------------------------------------------------------------***
//ASM0603D EXEC PGM=IEUASM,PARM=(DECK,NOLOAD,RENT)
//SYSLIB   DD  DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=19040
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSPRINT DD  SYSOUT=A
//SYSPUNCH DD  DSN=&&OBJSET(IEE0603D),UNIT=SYSDA,
//             SPACE=(TRK,(15,15,5)),DISP=(MOD,PASS)
//SYSIN    DD  DISP=(OLD,PASS),DSN=&&SOURCE(IEE0603D)
//*
//*-----------------------------------------------------------------***
//*     Step 4:  Assemble IEE3503D.                                 ***
//*-----------------------------------------------------------------***
//ASM3503D EXEC PGM=IEUASM,PARM=(DECK,NOLOAD,RENT)
//SYSLIB   DD  DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=19040
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSGO    DD  DUMMY
//SYSPRINT DD  SYSOUT=A
//SYSPUNCH DD  DSN=&&OBJSET(IEE3503D),UNIT=SYSDA,
//             SPACE=(TRK,(15,15,5)),DISP=(MOD,PASS)
//SYSIN    DD  DISP=(OLD,PASS),DSN=&&SOURCE(IEE3503D)
//*
//*-----------------------------------------------------------------***
//*     Step 5:  Assemble IEE6503D.                                 ***
//*-----------------------------------------------------------------***
//ASM6503D EXEC PGM=IEUASM,PARM=(DECK,NOLOAD,RENT)
//SYSLIB   DD  DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=19040
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSGO    DD  DUMMY
//SYSPRINT DD  SYSOUT=A
//SYSPUNCH DD  DSN=&&OBJSET(IEE6503D),UNIT=SYSDA,
//             SPACE=(TRK,(15,15,5)),DISP=(MOD,PASS)
//SYSIN    DD  DISP=(OLD,PASS),DSN=&&SOURCE(IEE6503D)
//*
//*-----------------------------------------------------------------***
//*     Step 6:  Assemble IKJEFLPA.                                 ***
//*-----------------------------------------------------------------***
//ASMEFLPA EXEC PGM=IEUASM,PARM=(DECK,NOLOAD,RENT)
//SYSLIB   DD  DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=19040
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSGO    DD  DUMMY
//SYSPRINT DD  SYSOUT=A
//SYSPUNCH DD  DSN=&&OBJSET(IKJEFLPA),UNIT=SYSDA,
//             SPACE=(TRK,(15,15,5)),DISP=(MOD,PASS)
//SYSIN    DD  DISP=(OLD,PASS),DSN=&&SOURCE(IKJEFLPA)
//*
//*-----------------------------------------------------------------***
//*     Step 7:  Assemble IEEVIPL.                                  ***
//*                                                                 ***
//*                    **** NOTE NOTE ***                           ***
//*                                                                 ***
//*              Replace the source in this step                    ***
//*              with the source for IEEVIPL                        ***
//*              from your stage 2 job stream.                      ***
//*                                                                 ***
//*                    **** NOTE NOTE ***                           ***
//*                                                                 ***
//*-----------------------------------------------------------------***
//ASMVIPL  EXEC PGM=IEUASM,PARM=(DECK,NOLOAD)
//SYSLIB   DD  DISP=(OLD,PASS),DSN=&&SOURCE,DCB=BLKSIZE=19040
//         DD  DISP=SHR,DSN=SYS1.MACLIB
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD  DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT2   DD  DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSUT3   DD  DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(CYL,(10,5))
//SYSGO    DD  DUMMY
//SYSPRINT DD  SYSOUT=A
//SYSPUNCH DD  DSN=&&OBJSET(IEEVIPL),UNIT=SYSDA,
//             SPACE=(TRK,(15,15,5)),DISP=(MOD,PASS)
//SYSIN    DD  *
 SGIEE00V ,,,,,,,,,L,10,1,1,100
 END
/*
//*
//*-----------------------------------------------------------------***
//*     Step 8:  Link IGC0603D, IGC3503D and IGC6503D.              ***
//*-----------------------------------------------------------------***
//LKEDSVC  EXEC PGM=IEWL,REGION=128K,
//             PARM='NCAL,LIST,XREF,LET,RENT'
//SYSUT1   DD  UNIT=SYSDA,SPACE=(TRK,(90,90))
//SYSPRINT DD  SYSOUT=A
//SYSLMOD  DD  DISP=SHR,DSN=SYS1.SVCLIB
//SYSPUNCH DD  DISP=(OLD,PASS),DSN=&&OBJSET
//SYSLIN   DD  *
   INCLUDE SYSPUNCH(IEE0603D)
   IDENTIFY IEE0603D('TMVT805')
 NAME IGC0603D(R)
   INCLUDE SYSPUNCH(IEE3503D)
   IDENTIFY IEE3503D('TMVT805')
 NAME IGC3503D(R)
   INCLUDE SYSPUNCH(IEE6503D)
   IDENTIFY IEE6503D('TMVT805')
 NAME IGC6503D(R)
/*
//*
//*-----------------------------------------------------------------***
//*     Step 9:  Link IKJEFLPA.                                     ***
//*-----------------------------------------------------------------***
//LKEDFLPA EXEC PGM=IEWL,REGION=128K,
//             PARM='NCAL,MAP,LIST,LET,REFR,DC'
//SYSUT1   DD  UNIT=SYSDA,SPACE=(TRK,(90,90))
//SYSPRINT DD  SYSOUT=A
//SYSLMOD  DD  DISP=SHR,DSN=SYS1.LINKLIB
//SYSPUNCH DD  DISP=(OLD,PASS),DSN=&&OBJSET
//SYSLIN   DD  *
    INCLUDE SYSPUNCH(IKJEFLPA)
    IDENTIFY IKJEFLPA('TMVT805')
    ENTRY   IKJEFLPA
  NAME    IKJEFLPA(R)
/*
//*
//*-----------------------------------------------------------------***
//*     Step 10:  Link IEEVIPL.                                     ***
//*-----------------------------------------------------------------***
//LKEDVIPL EXEC PGM=IEWL,REGION=128K,
//             PARM='NCAL,LIST,XREF,LET'
//SYSUT1   DD  UNIT=SYSDA,SPACE=(TRK,(90,90))
//SYSPRINT DD  SYSOUT=A
//SYSLMOD  DD  DISP=SHR,DSN=SYS1.LINKLIB
//SYSPUNCH DD  DISP=(OLD,PASS),DSN=&&OBJSET
//SYSLIN   DD  *
    INCLUDE SYSPUNCH(IEEVIPL)
    IDENTIFY IEEVIPL('TMVT805')
    INCLUDE SYSLMOD(IEEVIPL)
    ENTRY IEEVIPL
  NAME IEEVIPL(R)
/*
//
