//TMVT807  JOB 1,'TMVT807',CLASS=A,MSGCLASS=A
//*
//*++ USERMOD(TMVT807)     /* REWORK(20210503) */             .
//*++ VER (S218)
//*   FMID(QBB2218)
//* /*
//* C:\Hercules\mvt\00Misc\sysout\zapcode7.pl Mon May  3 18:23:45 2021
//*
//*   PROBLEM DESCRIPTION(S):
//*     TMVT807 -
//*       Support "SYSOUT=*" as in MVS.
//*
//*       Note that TMVT807 logically replaces usermod TMVT812.
//*       TMVS812 did not produce the expected results in a HASP
//*       environment.  TMVT807 alone will cause "SYSOUT=*" to
//*       generate the correct result in a vanilla (non-HASP)
//*       environment.  TMVT807 with HASP usermod THAS812 is
//*       necessary to get "SYSOUT=*" support with HASP.
//*
//*   COMPONENT:  360S-CI505-QBB2218
//*
//*   APARS FIXED: TMVT807
//*
//*   SPECIAL CONDITIONS:
//*     DEPENDENCY:
//*       The OS/VS linkage editor HEWLF064 must be available to
//*       permit IEFVFA and IEFVDA to be expanded with a patch
//*       area.
//*
//*     DOCUMENTATION:  Description of "SYSOUT=" parameter
//*       modified.
//*
//*       Publication:  OS/360 JCL Reference
//*       Form Number:  GC28-6704
//*
//*       The "Rules for Coding" section in the description of the
//*       SYSOUT parameter in the "DD" section of the manual is
//*       replaced by the following:
//*
//*         Rules for Coding
//*
//*           1.  The classname can be any alphameric character
//*               (A-Z, 0-9) or *.  If the classname is
//*               specified as *, the actual classname used for
//*               the SYSOUT parameter is the value of the
//*               MSGCLASS parameter specified on the JOB card
//*               or taken from system defaults.
//*
//*           2.  The form number is one to four alphameric and
//*               national (@,$, #) characters.
//*
//*           3.  If a program name and form nunmber are omitted,
//*               you need not enclose the classname in
//*               parentheses.
//*
//*           4.  The UNIT, SPACE, OUTLIM, UCS, FCB, and DCB
//*               parameters can be coded with the SYSOUT
//*               parameter.  Besides the mutually exclusive
//*               parameters listed below, other parameters
//*               coded with the SYSOUT parameter are ignored.
//*
//*           5.  The DISP, DDNAME, AFF, SEP, VOLUME, LABEL, SPLIT,
//*               and SUBALLOC parameters and the SYSOUT parameter
//*               are mutually exclusive parameters; therefore, if
//*               any of these parameters are coded, do not code
//*               the SYSOUT parameter.
//*
//*       Point 2 in the "Advantages to Coding the SYSOUT
//*       Parameter" section in the description of the SYSOUT
//*       parameter in the "DD" section of the manual is replaced
//*       by the following:
//*
//*           2.  The output data set and system messages from the
//*               job can be assigned to the same spooled output
//*               file.  This is accomplished by specifying
//*               the same classname in the SYSOUT and
//*               MSGCLASS parameters.  Alternatively, it
//*               may be done by specifying the SYSOUT classname
//*               for the output data set as *.  (The MSGCLASS
//*               parameter is coded on the JOB statement.  If
//*               no MSGCLASS value is coded on the JOB statement,
//*               a system default is used.)
//*
//*   COMMENTS:
//*     LAST CHANGE:  2021/05/03
//*
//*     REWORK HISTORY:
//*       2021/05/03: Original source.  
//*
//*     CROSS REFERENCE-MODULE/MACRO NAMES TO USERMODS
//*       IEFVFA    TMVT807
//*       IEFVDA    TMVT807
//*
//*     CROSS REFERENCE-USERMODS TO MODULE/MACRO NAMES
//*       TMVT807   IEFVFA   IEFVDA
//*
//*     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USRMOD:
//*
//*     MODULES
//*       IEFVFA
//*       IEFVDA
//*
//*     LISTEND
//*
//LKED   EXEC PGM=HEWLF064,
//            PARM=(XREF,LET,LIST,NCAL,REFR,MAP),
//            REGION=128K
//SYSLMOD  DD DISP=SHR,DSN=SYS1.LINKLIB,
//            UNIT=SYSDA,VOL=SER=VRESA0
//CI505    DD DISP=SHR,DSN=SYS1.CI505,
//            UNIT=SYSDA,VOL=SER=VDLIB0
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1024,(50,20))
//SYSPRINT DD SYSOUT=A
//SYSLIN   DD *
  INCLUDE CI505(IEFVFA)
  INCLUDE CI505(IEFVDA)
  INCLUDE SYSLMOD(IEFVHA)
  ALIAS IEFVHCB
  ALIAS IEFVHREP
  ALIAS IEFVHF
  ENTRY IEFVHA
  EXPAND IEFVFA(14)             /* IEFVFA PATCH AREA */
  EXPAND IEFVDA(30)             /* IEFVDA PATCH AREA */
  NAME IEFVHA(R)
/*
//ZAP    EXEC PGM=IMASPZAP,COND=(0,NE)
//SYSLIB   DD DISP=SHR,DSN=*.LKED.SYSLMOD,VOL=REF=*.LKED.SYSLMOD
//SYSPRINT DD SYSOUT=A
//SYSIN DD *
NAME IEFVHA IEFVFA
IDRDATA TMVT807
VER 000000 05B0                      BALR  RB,0             VERIFY MODULE
VER 000002 47F0,B014        VFA01    B     FA1              VERIFY MODULE
VER 00000C 11111111                  DC    X'11111111'      VERIFY MODULE
VER 000010 C6C1                      DC    C'FA'            VERIFY MODULE
VER 000012 D34BF0F4                  DC    C'L.04'          VERIFY MODULE
VER 000ADC 45E0,A12A        ASR      BAL   RE,ORRTN         GO SEE IF THIS KEY I
VER 000AE0 956E,5000                 CLI   0(R5),DDK        IS THIS DD* STATEMEN
VER 000AE4 4780,B750                 BE    FB3              YES - RET TO TRANSLA
VER 000AE8 95AA,5000                 CLI   0(R5),RESTARJK   IS IT RESTART=
VER 000AEC 4780,B750        REP1     BE    FB3              YES- RETURN TO TRANS
VER 0016D8 0000000000000000          DC    (PATCHLEN)X'00'  Verify patch area
VER 0016E0 000000000000
REP 000AEC 45E0,A6D6                 BAL   RE,PATCH1        To patch area
REP 0016D8 4780,B750        PATCH1   BE    FB3              Clobbered instructio
REP 0016DC 954B,5000                 CLI   0(R5),SYSOUTK    Is key SYSOUT=?
REP 0016E0 4780,B750                 BE    FB3              Yes, return to trans
REP 0016E4 07FE                      BR    RE               Else return to mainl
NAME IEFVHA IEFVDA
IDRDATA TMVT807
VER 000000 05B0                      BALR  RB,DD0           ESTABLISH ADDRESSABL
VER 000002 5870,B00A                 L     R7,DVDA1         BASE
VER 000010 11111111                  DC    X'11111111'
VER 000014 C4C1                      DC    C'DA'
VER 000016 D34BF0F5                  DC    C'L.05'          LEVEL NUMBER
VER 000E10 9180,A0B4        REP1     TM    DSDUMSWZ,DSDUMSW Test for DD DUMMY
VER 000E14 4710,BE1C        RET1     BC    O,SYSOUTP1       Branch if DUMMY
VER 000E1E 05E9             SYSOUTP1 BALR  RE,R9            GO TO GET KEY
VER 000E20 47F0,BE0E        REP2     B     SYSOUTP          LOOP BACK
VER 001E02 0000000000000000          DC    (PATCHLEN)X'00'  VERIFY PATCH AREA
VER 001E0A 0000000000000000
VER 001E12 0000000000000000
VER 001E1A 000000000000
REP 000E10 47F0,7E00                 B     PATCH1           To patch area
REP 000E20 47F0,7E16                 B     SYSOUTP3         Loop back
REP 001E02 9501,3000        PATCH1   CLI   0(R3),X'01'      Is there a class?
REP 001E06 4770,7E16                 BNE   SYSOUTP3         Branch if not
REP 001E0A 955C,3001                 CLI   1(R3),C'*'       Is it SYSOUT=*?
REP 001E0E 4770,7E16                 BNE   SYSOUTP3         Branch if not
REP 001E12 D200,3001,C2D6            MVC   1(1,R3),JCT+JCTJMGPO-INJMJCT   Copy m
REP 001E18 9180,A0B4        SYSOUTP3 TM    DSDUMSWZ,DSDUMSW Clobbered instructio
REP 001E1C 47F0,BE12                 B     RET1             Back to mainline
/*
//
