//TX67308  JOB  (1),TX67308,
//             COND=(0,NE),
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1)
//*
//* 2021/07/14 @KL TX67308 $D03
//*                Install IEFACTRT
//*
//RECEIVE EXEC SMP4
//SMPPTFIN DD DATA,DLM='??'
++ USERMOD(TX67308)     /* REWORK(20210716) */             .
++ VER (X067)
   FMID(EBA1101)
 /*
   PROBLEM DESCRIPTION(S):
     TX67308 -
       Install IEFACTRT SMF exit.

   COMPONENT:  5741-SC1B4-EBA1101

   APARS FIXED: TX67308

   SPECIAL CONDITIONS:
     DEPENDENCY:  This usermod can only be installed on a VS1
       system generated with SMF support.  For that to be the
       case, "SMF=FULL" (recommended) or "SMF=BASIC" must have
       been specified on the SCHEDULR stage 1 macro (the default
       for SMF is NOTSUPPLIED).

   COMMENTS:
     LAST CHANGE:  2021/07/16

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MODULES
       IEFACTRT
 */.
++ SRC      (IEFACTRT) DISTLIB(ASAMPLIB) SYSLIB(SAMPLIB ).
         MACRO ,
&LABEL   DEBUGWTO &TEXT,&ROUTCDE=15
         MEXIT ,
&LABEL   WTO   &TEXT,ROUTCDE=&ROUTCDE
         MEND ,
IEFACTRT TITLE '    SMF step/job termination exit'
***********************************************************************
*                                                                     *
*                                                                     *
* Module name          =  IEFACTRT                                    *
*                                                                     *
*                                                                     *
* Descriptive name     =  SMF termination exit for step and job       *
*                         end processing.                             *
*                                                                     *
*                                                                     *
* Function             =  To write statistical information about      *
*                         terminating step or job to the system       *
*                         messages data set; to issue WTO at step     *
*                         end describing step completion status.      *
*                                                                     *
*                                                                     *
* Notes                =  See below.                                  *
*                                                                     *
*   Dependencies       =  R12 at entry to IEFACTRT points to the      *
*                         Linkage Control Table (LCT).  If R12        *
*                         is used by the exit, the original contents  *
*                         of R12 must be restored before the system   *
*                         message output routine IEFYS is called.     *
*                                                                     *
*                         LCT fields LCTJCTAD (address of Job         *
*                         Control Table) and LCTSCTAD (address of     *
*                         Step Control Table) are assumed to be       *
*                         storage addresses and not tokens or SVAs.   *
*                                                                     *
*   Registers          =  See entry point documentation.              *
*                                                                     *
*   Patch space        =  None.                                       *
*                                                                     *
*                                                                     *
* Module type          =  CSECT                                       *
*                                                                     *
*   Processor          =  VS1 System Assembler                        *
*                                                                     *
*   Module size        =  See assembly listing.                       *
*                                                                     *
*   Attributes         =  Reentrant, task mode, enabled,              *
*                         supervisor state, key 0.                    *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
* Entry point          =  IEFACTRT                                    *
*                                                                     *
*   Purpose            =  To write statistical information about      *
*                         the terminating step or job to the system   *
*                         messages data set; to issue WTO at step     *
*                         end describing step completion status.      *
*                                                                     *
*   Linkage            =  From step unallocation SMF exit             *
*                         interface IEFTB721.                         *
*                                                                     *
*   Input data         =  R0  = Entry reason code, as follows:        *
*                           12     - Job step termination; record     *
*                                    passed is a type 4 or 34.        *
*                           16     - Job termination; record passed   *
*                                    is type 5 or 35.                 *
*                      =  R1  = Address of 10-word parameter list:    *
*                  0        Word 1:  Address of CEPA                  *
*                  4        Word 2:  Address of job step name         *
*                  8        Word 3:  Address of programmer name       *
*                 12        Word 4:  Address of 3-byte job TCB time   *
*                 16        Word 5:  Address of job accounting data   *
*                 20        Word 6:  Address of 3-byte step TCB time  *
*                 24        Word 7:  Address of step accounting data  *
*                 28        Word 8:  Address of indicator bytes       *
*                 32        Word 9:  Address of termination status    *
*                 36        Word 10: Address of SMF record            *
*                         R12 = Address of Linkage Control Table      *
*                         R13 = Address of standard save area         *
*                         R14 = Return address                        *
*                         R15 = Entry point                           *
*                                                                     *
*   Registers saved    =  R0 - R15                                    *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
*   Register usage     =  R0  = Work                                  *
*                         R1  = Work                                  *
*                         R2  = Work                                  *
*                         R3  = Unused                                *
*                         R4  = Work                                  *
*                         R5  = Address of JCT                        *
*                         R6  = Address of SCT                        *
*                         R7  = Subroutine linkage                    *
*                         R8  = Unused                                *
*                         R9  = Address of SMF record                 *
*                         R10 = Exit routine parameter list           *
*                         R11 = Program base register                 *
*                         R12 = Address of LCT                        *
*                         R13 = Address of standard save area         *
*                         R14 = Work                                  *
*                         R15 = Work                                  *
*                                                                     *
*   Registers restored =  R0, R2 - R14                                *
*                         R1  = SMF record indicator                  *
*                                 0: Write SMF record                 *
*                                 4: Do not write SMF record          *
*                         R15 = Return code                           *
*                                 0: Allow job to continue            *
*                                 4: Cancel job                       *
*                                                                     *
*                                                                     *
* Exit (normal)        =  Return to caller via BR R14.                *
*   Conditions         =  Step/job end processing completed.          *
*   Output             =  Step/job end statistics, STEPEND WTO        *
*                         and msgIEF421I warmstart status and         *
*                         disposition messages as appropriate.        *
*   Return code        =  0                                           *
*                                                                     *
*                                                                     *
* Exit (error)         =  Return to caller via BR R14.                *
*   Conditions         =  Not used in this implementation.            *
*   Output             =  The remaining job steps are to be           *
*                         cancelled.                                  *
*   Return code        =  4                                           *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
* External references  =  See below.                                  *
*                                                                     *
*   Routines           =  IEFYS (interface to write output to         *
*                         system messages data set).                  *
*                                                                     *
*   Control blocks     =  See table below:                            *
*                                                                     *
*    Name      Macro     Description                          Usage   *
*    ----      --------  -----------------------------------  -----   *
*    CEPA      IEFJMR    SMF Common Exit Parameter Area        R      *
*    CVT       CVT       OS Communications Vector Table        R      *
*    JCT       IEFAJCTB  OS Job Control Table                  R      *
*    LCT       IEFALLCT  OS Linkage Control Table              W      *
*    SCT       IEFASCTB  OS Step Control Table                 R      *
*    SMFRCD    IFASMFR   SMF Type 4 and Type 5 Records         R      *
*    WPL       IEZWPL    OS WTO Parameter List                 C      *
*                                                                     *
*   Key = R-Read, W-Write, C-Create, D-Delete                         *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
* Messages             =  The following messages are issued by        *
*                         this module:                                *
*                                                                     *
*                                                                     *
*    STEP: jjj sss ppp  ET=<elapsed-time> <completion-status>         *
*                                                                     *
*      elapsed-time       is the elapsed time for which the           *
*                         step was in execution.                      *
*                                                                     *
*      completion-status  is one of the following:                    *
*                                                                     *
*                            RC=<rc>       The step condition code    *
*                                          if step did not ABEND.     *
*                                                                     *
*                            ABEND=S<cde>  If step terminated due     *
*                                          to system ABEND.           *
*                                                                     *
*                            ABEND=U<cde>  If step terminated due     *
*                                          to user ABEND.             *
*                                                                     *
*                                                                     *
*    STEP: jjj sss ppp *********** FLUSHED                            *
*                                                                     *
*      if execution of the step was bypassed.                         *
*                                                                     *
*                                                                     *
* Macros               =  FREEMAIN, GETMAIN, RETURN,                  *
*                         SAVE, TIME, WTO.                            *
*                                                                     *
*                                                                     *
* Change activity      =                                              *
*                                                                     *
*   Flag  Date        By    Description                               *
*   ----  ----------  ----  ----------------------------------------  *
*   $D02  2002/06/22  @KL   Supply missing high-order byte for        *
*                           dates derived from SMF4STID and           *
*                           SMF5JID fields.                           *
*   $D00  2004/12/12  @KL   Refit for OS/VS1 7.0.                     *
*                                                                     *
*                                                                     *
***********************************************************************
         TITLE '    Register equates'
******************************************************************
*                                                                *
*        Define register equates.                                *
*                                                                *
******************************************************************
         SPACE 1
IEFACTRT CSECT ,                   Begin control section
         SPACE 1
*----------------------------------------------------------------*
*        Register equates.                                       *
*----------------------------------------------------------------*
R0       EQU   0                   Work and parameter
R1       EQU   1                   Work and parameter
R2       EQU   2                   Work
R3       EQU   3                   Unused
R4       EQU   4                   Unused
R5       EQU   5                   Address of JCT
R6       EQU   6                   Address of SCT
R7       EQU   7                   Unused
R8       EQU   8                   Unused
R9       EQU   9                   SMF record base register
R10      EQU   10                  Exit routine parameter list
R11      EQU   11                  Program base register
R12      EQU   12                  Address of LCT
R13      EQU   13                  Address of standard save area
R14      EQU   14                  Work
R15      EQU   15                  Work and parameter
         TITLE '    Program initialization'
******************************************************************
*                                                                *
*        INIT:                                                   *
*                                                                *
*        Perform program initialization.  Verify that the        *
*        SMF record type we have been called for is one          *
*        that we process.  If these conditions are not met,      *
*        return immediately to caller.                           *
*                                                                *
*        R9  = Address of SMF record - set by this section.      *
*        R10 = Exit routine parm list - set by this section.     *
*        R11 = Program base register.                            *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
******************************************************************
         SPACE 1
         PRINT NOGEN               Set assembler print options
INIT     DS    0H                  Program initialization
         SAVE  (14,12),,           Save caller's registers             +
               IEFACTRT-&SYSDATE-&SYSTIME-$D00
         LR    R11,R15             Set program base register
         USING IEFACTRT,R11        Addressability for program
         LR    R10,R1              Save pointer to exit parm list
         SPACE 1
*----------------------------------------------------------------*
*        If the current job is a maintenance job, return         *
*        immediately to caller.                                  *
*----------------------------------------------------------------*
         L     R15,0(,R1)          Get CEPA address
         USING JMR,R15             Addressability for CEPA
         CLC   =C'SY0',JMRJOB   ** testing **  Process this job?
         BE    RETURN           ** testing **  Return if not
         DROP  R15                 End CEPA addressability
         SPACE 1
*----------------------------------------------------------------*
*        Establish addressability to SMF record.                 *
*----------------------------------------------------------------*
         L     R9,36(,R1)          Point to SMF record
         USING SMFRCD,R9           Addressability for record
         EJECT ,
*----------------------------------------------------------------*
*        Test to ensure that the SMF record is one that we       *
*        process and return immediately if it's anything else.   *
*----------------------------------------------------------------*
         LA    R15,12              Get compare value
         CR    R0,R15              Is entry for type 4 record?
         BE    GETWORK             Continue if so
         LA    R15,16              Get compare value
         CR    R0,R15              Is entry for type 5 record?
         BNE   RETURN              If not, return to caller
         TITLE '    Obtain work area'
******************************************************************
*                                                                *
*        GETWORK:                                                *
*                                                                *
*        Get work area storage and initialize it to zeroes.      *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parm list - set by this section.     *
*        R12 = Address of LCT - not referenced.                  *
*        R13 = Getmained work area - obtained in this routine.   *
*                                                                *
*        Workregs: R0, R1, R14, R15.                             *
*                                                                *
******************************************************************
         SPACE 1
GETWORK  DS    0H                  Obtain and zero work storage
         GETMAIN R,LV=LWORKA,      Get storage                         +
               SP=1    # 230        for work area
         LR    R2,R1               Save address of getmained area
         LR    R0,R1               Set address for MVCL
         LA    R1,LWORKA           Set length for MVCL
         XR    R15,R15             Set pad to zeroes
         MVCL  R0,R14              Zero work area
         LR    R15,R13             Save old save area address
         LR    R13,R2              Point to our save area
         USING WORKA,R13           Addressability for work area
         ST    R15,SAVEA+4         Chain
         ST    R13,8(,R15)          save areas
         LM    R0,R1,20(R15)       Restore R0-R1 at entry
         EJECT ,
******************************************************************
*                                                                *
*        BLDCOM:                                                 *
*                                                                *
*        Build common heading line for the statistics            *
*        boxes.  This line contains OS/VS1 release and           *
*        SMF system ID.  It will be written for both             *
*        step and job termination.                               *
*                                                                *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs: R0, R15.                                      *
*                                                                *
******************************************************************
         SPACE 1
BLDCOM   DS    0H                  Build common heading
         SPACE 1
*----------------------------------------------------------------*
*        Initialize heading line.                                *
*----------------------------------------------------------------*
         L     R15,ASTARS          Point to line of "****"
         MVC   HDR,0(R15)          Initialize line to "****"
         L     R15,AMHDATA         Point to model heading data
         MVC   HDATA,0(R15)        Copy model heading data
         SPACE 1
*----------------------------------------------------------------*
*        Move SMF system ID to line.                             *
*----------------------------------------------------------------*
         MVC   HSID,SMF4SID        Move in SMF system ID
         SPACE 1
*----------------------------------------------------------------*
*        Build OS/VS1 release and level.                         *
*----------------------------------------------------------------*
         L     R15,CVTPTR          Get CVT pointer
         LA    R0,CVTMAP-CVTFIX    Back up to start
         SR    R15,R0               of CVT prefix
         USING CVTFIX,R15          Addressability for CVT prefix
         MVC   HOSREL,CVTNUMB      Set OS/VS1 release
         MVC   HOSMOD,CVTLEVL      Set OS/VS1 level
         DROP  R15                 End CVT addressability
         EJECT ,
******************************************************************
*                                                                *
*        CKRTYPE:                                                *
*                                                                *
*        Test whether record is type 4 (step termination)        *
*        or type 5 (job termination), and branch to the          *
*        appropriate processing logic.                           *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs: R0, R15.                                      *
*                                                                *
******************************************************************
         SPACE 1
CKRTYPE  DS    0H                  Step end or job end?
         L     R15,SAVEA+4         Restore R0
         L     R0,20(,R15)          at entry
         LA    R15,16              Get compare value
         CR    R0,R15              Is entry for type 5 record?
         BE    JOBEND              Branch if job end record
         TITLE '    Step end processing'
******************************************************************
*                                                                *
*        STEPEND:                                                *
*                                                                *
*        End-of-step processing.                                 *
*                                                                *
******************************************************************
         SPACE 1
STEPEND  DS    0H                  Begin step end processing
         EJECT ,
******************************************************************
*                                                                *
*        SMODEL:                                                 *
*                                                                *
*        Copy model step-end lines to work area.                 *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs: R15.                                          *
*                                                                *
******************************************************************
         SPACE 1
SMODEL   DS    0H                  Move in model step-end lines
         L     R15,ASTEPLN1        Point to model step line 1
         MVC   STEPLN1,0(R15)      Copy model step line 1
         L     R15,ASTEPLN2        Point to model step line 2
         MVC   STEPLN2,0(R15)      Copy model step line 2
         L     R15,ASTEPLN3        Point to model step line 3
         MVC   STEPLN3,0(R15)      Copy model step line 3
         L     R15,ASTEPLN4        Point to model step line 4
         MVC   STEPLN4,0(R15)      Copy model step line 4
         L     R15,ASTEPXCL        Point to model EXCP column hdrs
         MVC   SXCOL,0(R15)        Copy model EXCP column headers
         EJECT ,
******************************************************************
*                                                                *
*        SINITWTO:                                               *
*                                                                *
*        Initialize "STEP:" WTO message text.                    *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs:                                               *
*                                                                *
******************************************************************
         SPACE 1
SINITWTO DS    0H                  Initialize "STEP:" WTO text
         L     R15,ABLANKS         Point to blanks
         MVC   SWTEXT,0(R15)       Blank WTO text area
         MVC   SWHDR,=CL5'STEP:'   Set header in WTO
         EJECT ,
******************************************************************
*                                                                *
*        SBLDNM:                                                 *
*                                                                *
*        Build stepname and procstep name for later use.         *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT.                                   *
*                                                                *
*        Workregs: R0, R1, R15.                                  *
*                                                                *
******************************************************************
         SPACE 1
SBLDNM   DS    0H                  Build step and procstep names
         MVC   XPSTEPNM,=CL8' '    Assume no procstep name
         USING LCT,R12             Addressability for LCT
         L     R15,LCTJCTAD        Point to JCT
         USING JCT,R15             Addressability for JCT
         MVC   XJOBNM,JCTJNAME     Copy job name from JCL
         DROP  R15                 End JCT addressability
         L     R15,LCTSCTAD        Point to SCT
         USING SCT,R15             Addressability for SCT
         CLI   SCTSCLPC,C' '       Is step from a procedure?
         BNE   BLDPSNAM            Branch if so
         MVC   XSTEPNM,SCTSNAME    Set step name
         B     SBLDNM2             Continue
         SPACE 1
BLDPSNAM DS    0H
         MVC   XSTEPNM,SCTSCLPC    Set procstep name
         MVC   XPSTEPNM,SCTSNAME   Set step name
         B     SBLDNM2             Continue
         DROP  R15                 End SCT addressability
         SPACE 1
SBLDNM2  DS    0H                  End of stepname logic
         EJECT ,
******************************************************************
*                                                                *
*        SBLDDATA:                                               *
*                                                                *
*        Format data from type 4 record base section.            *
*                                                                *
*        R7  = Subroutine linkage.                               *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list.                      *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs: R0, R1, R4, R14, R15.                         *
*                                                                *
******************************************************************
         SPACE 1
SBLDDATA DS    0H                  Build step data lines
         SPACE 1
*----------------------------------------------------------------*
*        Step number.                                            *
*----------------------------------------------------------------*
         SR    R15,R15             Zero register for IC
         L     R1,(8-1)*4(,R10)    Point to indicator/step number
         IC    R15,1(,R1)          Get step number
         CVD   R15,DWORK           Convert step number to decimal
         OI    DWORK+7,X'0F'       Force printable sign
         UNPK  STEPNO,DWORK        Make step number character
         SPACE 1
*----------------------------------------------------------------*
*        Step name.                                              *
*----------------------------------------------------------------*
         MVC   STEPNM,XSTEPNM      Move step name
         SPACE 1
*----------------------------------------------------------------*
*        Procstep name.                                          *
*----------------------------------------------------------------*
         MVC   SPSTEPNM,XPSTEPNM   Move procstep name
         SPACE 1
*----------------------------------------------------------------*
*        Step start time.                                        *
*----------------------------------------------------------------*
         ICM   R1,15,SMF4SIT       Get step start time from record
         LA    R15,SINITTM         Point to area for output
         BAL   R7,TIMEX            Format step start time
         SPACE 1
*----------------------------------------------------------------*
*        Step end time.                                          *
*----------------------------------------------------------------*
         TIME  BIN                 Get step end date/time
         STCM  R1,15,DATEND        Save step end date
         LR    R4,R0               Save step end time
         LR    R1,R4               Set time for convert routine
         LA    R15,SENDTM          Point to output field
         BAL   R7,TIMEX            Format step end time
         SPACE 1
*----------------------------------------------------------------* @D02
*        Step elapsed time.  Older versions of OS don't          * @D02
*        correctly provide four digit year information for       * @D02
*        start year, so adjust the century byte based on a       * @D02
*        sliding window (year > 60 is assumed to be 19yy,        * @D02
*        year <= 60 is treated as 20yy).                         * @D02
*----------------------------------------------------------------* @D02
         ICM   R0,15,SMF4SIT       Get step start time
         LR    R1,R4               Get step end time
         CLI   SMF4STID+1,X'60'    Start year > 60?                @D02
         BH    SBLDELAP            20th century if so              @D02
         MVI   SMF4STID,X'01'      Else show 21st century          @D02
SBLDELAP DS    0H                  Build step elapsed time         @D02
         MVC   DATE,SMF4STID       Get start date
         LA    R15,SELAPS          Point to output area
         BAL   R7,ELAPSED          Calculate elapsed time
         SPACE 1
*----------------------------------------------------------------*
*        Allocation start time.                                  *
*----------------------------------------------------------------*
         ICM   R1,15,SMF4AST       Get allocation start time
         LA    R15,S1ALCST         Point to area for output
         BAL   R7,TIMEX            Format allocation start time
         SPACE 1
*----------------------------------------------------------------*
*        Problem program start time.                             *
*----------------------------------------------------------------*
         ICM   R1,15,SMF4PPST      Get program start time
         LA    R15,S2PGMST         Point to area for output
         BAL   R7,TIMEX            Format program start time
         SPACE 1
*----------------------------------------------------------------*
*        Step dispatching priority.                              *
*----------------------------------------------------------------*
         XR    R15,R15             Clear a register
         IC    R15,SMF4PRTY        Get dispatching priority
         CVD   R15,DWORK           Convert to packed
         BAL   R14,EDMKRTN         Convert to zoned
         MVC   S3DPRTY,EDPRTY      Set DPRTY in output line
         SPACE 1
*----------------------------------------------------------------*
*        Program name.                                           *
*----------------------------------------------------------------*
         MVC   SPGMNM,SMF4PGMN    Set program name from record
         SPACE 1
*----------------------------------------------------------------*
*        Test if storage type was virtual or real.               *
*----------------------------------------------------------------*
         TM    SMF4RIN,SMF4VQR     Was storage virtual?
         BZ    SBLDVIRT            Branch if virtual
         MVC   SADDRSPC,=C'REAL'   Else show storage was real
         B     SBLDREG             Go set region size in line
         SPACE 1
*----------------------------------------------------------------*
*        Storage was virtual.                                    *
*----------------------------------------------------------------*
SBLDVIRT DS    0H                  Storage was virtual
         MVC   SADDRSPC,=C'VIRT'   Show storage was virtual
         SPACE 1
*----------------------------------------------------------------*
*        Region size.                                            *
*----------------------------------------------------------------*
SBLDREG  DS    0H                  Set region size
         XR    R15,R15             Clear register
         ICM   R15,3,SMF4RSH0      Get region size
         CVD   R15,DWORK           Make value packed
         BAL   R14,EDMKRTN         Convert to zoned
         MVC   SREGION,EREGION     Set region requested
         SPACE 1
*----------------------------------------------------------------*
*        User storage high water mark.                           *
*----------------------------------------------------------------*
         XR    R15,R15             Clear register
         ICM   R15,3,SMF4H0ST      Get user storage HWM
         CVD   R15,DWORK           Make value packed
         BAL   R14,EDMKRTN         Convert to zoned
         MVC   SURB,EURB           Set user storage
         SPACE 1
*----------------------------------------------------------------*
*        Step TCB time.                                          *
*----------------------------------------------------------------*
         L     R15,20(,R10)        Point to step TCB time
         ICM   R1,7,0(R15)         Get step TCB time
         LA    R15,S4CPUTM         Point to output field
         BAL   R7,TIMEX            Format step TCB time
         SPACE 1
*----------------------------------------------------------------*
*        Protect key.                                            *
*----------------------------------------------------------------*
         XR    R15,R15             Clear a register
         IC    R15,SMF4SPK         Get protect key
         SRL   R15,4                in low-order 4 bits
         CVD   R15,DWORK           Make value packed
         BAL   R14,EDMKRTN         Convert to zoned
         MVC   S4PKEY,EPKEY        Set protect key in output line
         EJECT ,
******************************************************************
*                                                                *
*        SRELOCAT:                                               *
*                                                                *
*        Format data from type 4 record relocate section.        *
*                                                                *
*        R3  = Address of SMF record relocate section.           *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs:                                               *
*                                                                *
******************************************************************
SRELOCAT DS    0H
         LH    R3,SMF4RLCT                 Point to
         LA    R3,SMF4FLG-SMF4LEN(R3,R9)    relocate section
         PUSH  USING               Save using status
         DROP  R9                  End SMF record base addressability
         USING SMF4PGIN,R3         Addressability for relocate section
         SPACE 1
*----------------------------------------------------------------*
*        Pageins.                                                *
*----------------------------------------------------------------*
         ICM   R15,15,SMF4PGIN     Get number of pageins
         CVD   R15,DWORK           Make value packed
         BAL   R14,EDMKRTN         Convert to zoned
         MVC   SPAGEIN,EPAGEIN     Set nonswap nonVIO pageins
         SPACE 1
*----------------------------------------------------------------*
*        Pageouts.                                               *
*----------------------------------------------------------------*
         ICM   R15,15,SMF4PGOT     Get number of pageouts
         CVD   R15,DWORK           Make value packed
         BAL   R14,EDMKRTN         Convert to zoned
         MVC   SPAGEOUT,EPAGEOUT   Set nonswap nonVIO pageouts
         SPACE 1
         POP   USING               Restore using status
         EJECT ,
******************************************************************
*                                                                *
*        Build condition code or completion code.                *
*                                                                *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list.                      *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs:                                               *
*                                                                *
******************************************************************
         SPACE 1
SBLDCOMP DS    0H                  Build condition/abend code
         SPACE 1
*----------------------------------------------------------------*
*        Test for warmstart.                                     *
*----------------------------------------------------------------*
CONCKWRM DS    0H                  Test for warmstart
         SPACE 1
*----------------------------------------------------------------*
*        Test for step flushed.                                  *
*----------------------------------------------------------------*
CONCKFLU DS    0H                  Test for step flushed
         TM    SMF4STI,SMF4FLH     Was step flushed?
         BZ    CONSETCD            Branch if not
         SPACE 1
*----------------------------------------------------------------*
*        Step was flushed.                                       *
*----------------------------------------------------------------*
CONFLUSH DS    0H                  Step was flushed
         MVC   STEPCCH,HDFLUSH     Set "FLUSHED" header
         B     PRTCOND             Go to write the line
         SPACE 1
*----------------------------------------------------------------*
*        Not warmstart or step flushed.  Save condition code/    *
*        completion code in work area.                           *
*----------------------------------------------------------------*
CONSETCD DS    0H                  Save code in work area
         MVC   DWORK(2),SMF4SCC    Move code to work area
         MVC   STEPCCHD,HDCOND     Assume condition code
         SPACE 1
*----------------------------------------------------------------*
*        Test whether condition code or abend code.              *
*----------------------------------------------------------------*
CONCKABN DS    0H                  Test for abend
         TM    SMF4STI,SMF4ABD     Did step abend?
         BZ    CONRC               No: this is a condition code
         SPACE 1
*----------------------------------------------------------------*
*        Determine abend type.                                   *
*----------------------------------------------------------------*
CONCKTYP DS    0H                  Determine type of abend
         TM    SMF4SCC,X'80'       Is it a user abend?
         BO    CONABNDU            Branch if user abend
         EJECT ,
*----------------------------------------------------------------*
*        Format system abend code.                               *
*----------------------------------------------------------------*
CONABNDS DS    0H                  Format system abend code
         MVC   STEPCCHD,HDABNDS    Set system abend header
         MVI   DWORK+2,X'0F'       Set dummy sign for unpack
         UNPK  DWORK+3(5),DWORK(3) Unpack cc
         MVC   STEPCOND(3),DWORK+4 Move cc to print line
         TR    STEPCOND(3),HEXTRAN-240   Translate hex to character
         B     PRTCOND             Go write the line
         SPACE 1
*----------------------------------------------------------------*
*        Prepare to build user abend code.                       *
*----------------------------------------------------------------*
CONABNDU DS    0H                  Abend is a user abend
         MVC   STEPCCHD,HDABNDU    Set user abend header
         NI    DWORK,X'7F'         Lift high-order bit of code
         SPACE 1
*----------------------------------------------------------------*
*        Common logic to build condition code or user            *
*        abend code.                                             *
*----------------------------------------------------------------*
CONRC    DS    0H                  Build rc or user cc
         LH    R15,DWORK           Get rc/user cc
         CVD   R15,DWORK           Convert it to decimal
         UNPK  STEPCOND,DWORK      Unpack into print line
         OI    STEPCOND+3,X'F0'    Force sign printable
         SPACE 1
PRTCOND  DS    0H
         EJECT ,
******************************************************************
*                                                                *
*        SPUTCEND:                                               *
*                                                                *
*        We have completed processing type 4 records for         *
*        this step.  Write a line of asterisks to terminate      *
*        the step statistics box.  Then write a blank line.      *
*                                                                *
*        Workregs:                                               *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Write step lines to sysmsg
         LA    R0,132              Set length of line
         L     R1,ABLANKS          Point to blanks
         BAL   R7,PUTLINE          Write blank line
         LA    R0,132              Set length of line
         LA    R1,HDR              Point to header line
         BAL   R7,PUTLINE          Write box heading line
         LA    R0,132              Set length of line
         L     R1,ASTEPHDR         Point to "STEP END" line
         BAL   R7,PUTLINE          Write "STEP END" line
         LA    R0,132              Set length of line
         LA    R1,STEPLN1          Point to step end line 1
         BAL   R7,PUTLINE          Write step end line 1
         LA    R0,132              Set length of line
         LA    R1,STEPLN2          Point to step end line 2
         BAL   R7,PUTLINE          Write step end line 2
         LA    R0,132              Set length of line
         LA    R1,STEPLN3          Point to step end line 3
         BAL   R7,PUTLINE          Write step end line 3
         LA    R0,132              Set length of line
         LA    R1,STEPLN4          Point to step end line 4
         BAL   R7,PUTLINE          Write step end line 4
         EJECT ,
******************************************************************
*                                                                *
*        SBLDEXCP:                                               *
*                                                                *
*        Build and write EXCP counts from SMF record.            *
*                                                                *
*        This logic loops through the EXCP sections in the       *
*        SMF record, formatting them into the print line.        *
*        Sections representing DD DUMMY entries or subsystem     *
*        data sets are skipped, because they contain no EXCP     *
*        counts.  Each print line can contain up to five         *
*        EXCP count entries.  When the line is full, or when     *
*        all EXCP sections in the record have been processed,    *
*        the print line containing the formatted EXCP counts     *
*        will be written.  If a header line and column           *
*        headings for the EXCP box have not yet been             *
*        written, they will be written first.  If there is       *
*        only one line of EXCP counts and it contains fewer      *
*        than five entries, the column headings will be          *
*        adjusted accordingly.                                   *
*                                                                *
*        R3  = Address of current EXCP section in SMF record.    *
*        R4  = Count of EXCP sections.                           *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
******************************************************************
         SPACE 1
SBLDEXCP DS    0H                  Build and write EXCP counts
         XR    R4,R4               Get length
         ICM   R4,3,SMF4LENN        of EXCP portion of record
         SH    R4,=Y(SMF4DEVC-SMF4LENN) and adjust for length field
         BNP   SEXEXIT             Done if no EXCP counts
         SRL   R4,3                Else get number of EXCP sections
         LA    R3,SMF4LENN+(SMF4DEVC-SMF4LENN) and point to first
         USING SMF4DEVC,R3         Addressability for EXCP section
         LA    R15,SMF30ELN        Bump EXCP section pointer back
         SR    R3,R15               for initial increment
         SPACE 1
******************************************************************
*                                                                *
*        SEXLOOPI:                                               *
*                                                                *
*        Loop through EXCP sections of record, invoking          *
*        formatting subroutine to format EXCP counts into        *
*        print line.  Whenever print line is full, allow it      *
*        to be printed, then return here to loop some more.      *
*                                                                *
*        R3  = Address of current EXCP section in SMF record.    *
*        R4  = Count of EXCP sections.                           *
*        R5  = Count of EXCP segments in print line.             *
*        R6  = Address of current EXCP segment in print line.    *
*        R7  = Subroutine linkage.                               *
*        R9  = Start of type 4 record - not referenced.          *
*        R10 = Exit routine parameter list.                      *
*        R12 = OS Linkage Control Table - not referenced.        *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Prepare to loop through EXCP sections.                  *
*----------------------------------------------------------------*
SEXLOOPI DS    0H                  Set up for EXCP section loop
         L     R15,ABASEL          Initialize print line
         MVC   PRTLINE,0(R15)       from model '*   *' line
         LA    R5,SXCOLNUM         Set maximum count on this line
         LA    R6,PRTLINE+4        Point to slot for first count
         SPACE 1
*----------------------------------------------------------------*
*        Loop through EXCP sections in SMF record.               *
*----------------------------------------------------------------*
SEXLOOP  DS    0H                  Fill one print line
         LA    R15,SMF30ELN        Get EXCP section length
SMF30ELN EQU   8
         AR    R3,R15              Adjust to next EXCP section
         LTR   R4,R4               Any more EXCP sections?
         BNP   SEXTRUNC            Branch if no more in record
         BCTR  R4,0                Decrement EXCP section count
         CLC   =XL4'00',SMF4DEVC   Dummy or jes data set?
         BE    SEXLOOP             Skip it if so
         BAL   R7,EXCP             Else format into print line
         LA    R6,L'SXSEG(,R6)     Point to next slot in line
         BCT   R5,SEXLOOP          Look at next EXCP section
         B     SEXFULL             Line is full, go print it
         EJECT ,
******************************************************************
*                                                                *
*        SEXFULL:                                                *
*                                                                *
*        EXCP print line is full.  Test to see if EXCP box       *
*        header lines have been written.                         *
*                                                                *
*        R3  = Address of current EXCP section - not             *
*              referenced.                                       *
*        R4  = Count of EXCP sections - not referenced.          *
*        R5  = Count of EXCP segments in print line - not        *
*              referenced.                                       *
*        R6  = Current EXCP segment in print line - not          *
*              referenced.                                       *
*        R7  = Subroutine linkage - not used.                    *
*        R9  = Start of type 4 record - not referenced.          *
*        R10 = Exit routine parameter list.                      *
*        R12 = OS Linkage Control Table - not referenced.        *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Print line is full.                                     *
*----------------------------------------------------------------*
SEXFULL  DS    0H                  EXCP print line is full
         TM    FLAG1,F1EXCPHD      Have we written headers yet?
         BO    SEXWLINE            Yes, go write line
         EJECT ,
******************************************************************
*                                                                *
*        SEXWHDR:                                                *
*                                                                *
*        Write EXCP box heading and column heading lines.        *
*        If fewer than four EXCP counts are going to be          *
*        written, blank out the column headings over columns     *
*        which will be unused.                                   *
*                                                                *
*        R3  = Address of current EXCP section in SMF record.    *
*        R4  = Count of EXCP sections.                           *
*        R5  = Count of EXCP segments in print line.             *
*        R6  = Address of current EXCP segment in print line.    *
*        R7  = Subroutine linkage.                               *
*        R9  = Start of type 4 record - not referenced.          *
*        R10 = Exit routine parameter list.                      *
*        R12 = OS Linkage Control Table.                         *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Set up to write EXCP header and column headings.        *
*----------------------------------------------------------------*
SEXWHDR  DS    0H                  Prepare to write EXCP headings
         LTR   R5,R5               All columns used?
         BNP   SEXWHDRW            Continue if so
         SPACE 1
*----------------------------------------------------------------*
*        Find number of EXCP entries on the line.                *
*----------------------------------------------------------------*
         LA    R14,SXCOLNUM        Calculate number
         SR    R14,R5               of EXCP entries in line
         SPACE 1
*----------------------------------------------------------------*
*        Find start of header area to be blanked.                *
*----------------------------------------------------------------*
         LA    R15,SXCOLFST        Point to first column heading
         MH    R14,=Y(SXCOLLEN)    Calculate address
         AR    R15,R14              of area to blank
         SPACE 1
*----------------------------------------------------------------*
*        Calculate length of header area to blank.               *
*----------------------------------------------------------------*
         LR    R1,R5               Calculate length
         MH    R1,=Y(SXCOLLEN)      of area to be blanked
         SH    R1,=Y(2)            Adjust length
         SPACE 1
*----------------------------------------------------------------*
*        Blank column headings over empty columns.               *
*----------------------------------------------------------------*
         MVI   0(R15),C' '         Blank heading
         EX    R1,SEXBLMVC          over columns not used
         B     SEXWHDRW            Go to write EXCP headers
         SPACE 1
SEXBLMVC MVC   1(*-*,R15),0(R15)   ** Executed to blank headers **
         SPACE 1
*----------------------------------------------------------------*
*        Write EXCP header and column headings.                  *
*----------------------------------------------------------------*
SEXWHDRW DS    0H                  Write the headers
         LA    R0,132              Set length of line
         L     R1,ADOTS            Point to "...." line
         BAL   R7,PUTLINE          Write "...." line
         LA    R0,132              Set length of line
         L     R1,AEXCPHDR         Point to EXCP header line
         BAL   R7,PUTLINE          Write header line
         LA    R0,132              Set length of line
         LA    R1,SXCOL            Point to column headings
         BAL   R7,PUTLINE          Write column headings
         OI    FLAG1,F1EXCPHD      Show EXCP headers were done
         EJECT
******************************************************************
*                                                                *
*        SEXWLINE:                                               *
*                                                                *
*        Headings are finished or had already been written,      *
*        so write the completed EXCP count print line.           *
*                                                                *
*        R3  = Address of current EXCP section in SMF record.    *
*        R4  = Count of EXCP sections.                           *
*        R5  = Count of EXCP segments in print line.             *
*        R6  = Address of current EXCP segment in print line.    *
*        R7  = Subroutine linkage.                               *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Write EXCP print line.                                  *
*----------------------------------------------------------------*
SEXWLINE DS    0H                  Write EXCP print line
         LA    R0,132              Set length of line
         LA    R1,PRTLINE          Point to print line
         BAL   R7,PUTLINE          Write EXCP counts print line
         LTR   R4,R4               Was this the last line?
         BP    SEXLOOPI            No: go do some more EXCPs
         B     SEXEXIT             Else done with EXCPs
         EJECT ,
******************************************************************
*                                                                *
*        SEXTRUNC:                                               *
*                                                                *
*        Last EXCP section in this record has been processed.    *
*        Determine if the final print line has anything in it,   *
*        and, if it does, go to write it.                        *
*                                                                *
*        R3  = Address of current EXCP section in SMF record.    *
*        R4  = Count of EXCP sections.                           *
*        R5  = Count of EXCP segments in print line.             *
*        R6  = Address of current EXCP segment in print line.    *
*        R7  = Subroutine linkage.                               *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Truncate print line when no more EXCP sections.         *
*----------------------------------------------------------------*
SEXTRUNC DS    0H                  Out of EXCPS
         C     R5,=A(SXCOLNUM)     Anything on final print line?
         BL    SEXFULL             Yes: then go print it
         B     SEXEXIT             Else done
         EJECT ,
******************************************************************
*                                                                *
*        SEXEXIT:                                                *
*                                                                *
*        Done with EXCP processing for this SMF record.          *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
******************************************************************
         SPACE 1
SEXEXIT  DS    0H                  End of EXCP processing
         DROP  R3                  End EXCP section addressability
         EJECT ,
******************************************************************
*                                                                *
*        SPUTCEND:                                               *
*                                                                *
*        We have completed processing type 4 records for         *
*        this step.  Write a line of asterisks to terminate      *
*        the step statistics box.  Then write a blank line.      *
*                                                                *
*        R7  = Subroutine linkage.                               *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs: R0, R1.                                       *
*                                                                *
******************************************************************
         SPACE 1
SPUTCEND DS    0H                  Write step lines to sysmsg
         LA    R0,132              Set length of line
         L     R1,ASTARS           Point to line of "****"
         BAL   R7,PUTLINE          Write "****" line
         LA    R0,132              Set length of line
         L     R1,ABLANKS          Point to blanks
         BAL   R7,PUTLINE          Write blank line
         EJECT ,
******************************************************************
*                                                                *
*        SBLDWTO:                                                *
*                                                                *
*        Build and write "STEP:" step-end WTO message.           *
*                                                                *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list.                      *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs = R0, R1, R15.                                 *
*                                                                *
******************************************************************
         SPACE 1
SBLDWTO  DS    0H                  Build and write step-end WTO
         SPACE 1
*----------------------------------------------------------------*
*        Set job name, step name and procstep name in message.   *
*----------------------------------------------------------------*
         MVC   SWJOBN,XJOBNM       Set jobname in WTO
         MVC   SWSTEPN,XSTEPNM     Put step name in WTO
         MVC   SWPSTEPN,XPSTEPNM   Set procstepname in WTO
         EJECT ,
*----------------------------------------------------------------*
*        Test for step abend.                                    *
*----------------------------------------------------------------*
SBLDWTO1 DS    0H                  See if step abended
         TM    SMF4STI,SMF4ABD     Did step abend?
         BO    SBLDWTO7            Branch if abend
         SPACE 1
*----------------------------------------------------------------*
*        Check to see if step was flushed.                       *
*----------------------------------------------------------------*
SBLDWTO3 DS    0H                  Test for step flushed
         TM    SMF4STI,SMF4FLH     Was step flushed?
         BZ    SBLDWTO6            Branch if step not flushed
         L     R15,ASTARS          Point to line of "****"
         MVC   SWSTARS,0(R15)      Fill elapsed time slot
         B     SBLDWTO5            Step actually flushed if not
         SPACE 1
*----------------------------------------------------------------*
*        Step was flushed.                                       *
*----------------------------------------------------------------*
SBLDWTO5 DS    0H                  Step was flushed
         LA    R1,SWTOLEN2         Set length for "FLUSHED" message
         MVC   SWFLUSH,KFLUSHED    Set "FLUSHED" keyword
         B     SBLDWTOI            Go to issue message
         SPACE 1
*----------------------------------------------------------------*
*        Neither abend nor step flushed, so build return code.   *
*----------------------------------------------------------------*
SBLDWTO6 DS    0H                  Build return code in message
         LA    R1,SWTOLEN1         Set length for "RC=" message
         MVC   SWRCH,KRC           Set "RC=" keyword
         MVC   SWRC,STEPCOND       Move in step return code
         B     SBLDWTO8            Go build elapsed time
         SPACE 1
*----------------------------------------------------------------*
*        Step abended.  Build completion code for                *
*        abending step.                                          *
*----------------------------------------------------------------*
SBLDWTO7 DS    0H                  Step abended
         MVC   SWABNDH,KABEND      Set "ABEND" keyword in message
         MVC   SWABND,STEPCOND-1   Move in abend code
         LA    R1,SWTOLEN3-1       Set length for "ABEND=S" message
         CLI   SWABND,C'S'         Was it a system abend?
         BE    SBLDWTO8            Branch if system abend
         LA    R1,SWTOLEN3         Else et length for "ABEND=U"
         SPACE 1
*----------------------------------------------------------------*
*        Copy step elapsed time to message.                      *
*----------------------------------------------------------------*
SBLDWTO8 DS    0H                  Build elapsed time in WTO
         MVC   SWELAPH,KET         Set "ELAPSED" keyword
         CLI   SELAPS-1,C' '       Elapsed hours in 3 digits?
         BNE   SBLDWTO9            Handle specially if so
         MVC   SWELAP,SELAPS       Move in step elapsed ttime
         B     SBLDWTOA            Go translate delimiters
         SPACE 1
*----------------------------------------------------------------*
*        Handle elapsed time with 3 digits of hours.             *
*----------------------------------------------------------------*
SBLDWTO9 DS    0H                  Build 3-digit elapsed time
         MVC   SWELAP(6),SELAPS-1  Move in HHH.MM
         SPACE 1
*----------------------------------------------------------------*
*        Translate all ":" in elapsed time to "."                *
*----------------------------------------------------------------*
SBLDWTOA DS    0H                  Translate ":" to "."
         L     R15,ATRCOLON        Translate all ":"
         TR    SWELAP,0(R15)        in elapsed time to "."
         SPACE 1
*----------------------------------------------------------------*
*        Issue message via WTO.                                  *
*----------------------------------------------------------------*
SBLDWTOI DS    0H                  Issue step-end message
         STH   R1,SWLEN            Set length in WPL
         LA    R1,SWTO(R1)         Point past text
         MVC   0(4,R1),ROUT2       Set routcde
         XC    SWMCSFLG,SWMCSFLG   Zero mcsflags field
         OI    SWMCSFLG,SWMCSA     Show rout/desc codes exist
         LA    R1,SWTO             Point to message
         WTO   MF=(E,(1))          Write step-end WTO
         B     FREEWORK            Go to clean up and exit
         TITLE '    Job end processing'
******************************************************************
*                                                                *
*        JOBEND:                                                 *
*                                                                *
*        End-of-job processing.                                  *
*                                                                *
******************************************************************
         SPACE 1
JOBEND   DS    0H                  Begin end-of-job processing
         EJECT ,
******************************************************************
*                                                                *
*        JMODEL:                                                 *
*                                                                *
*        Set model job-end lines in work area.                   *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs = R15.                                         *
*                                                                *
******************************************************************
         SPACE 1
JMODEL   DS    0H                  Build job-end lines from models
         L     R15,AJOBLN1         Point to model job line 1
         MVC   JOBLN1,0(R15)       Copy model job line 1
         L     R15,AJOBLN2         Point to model job line 2
         MVC   JOBLN2,0(R15)       Copy model job line 2
         L     R15,AJOBLN3         Point to model job line 3
         MVC   JOBLN3,0(R15)       Copy model job line 3
         EJECT ,
******************************************************************
*                                                                *
*        JBLDDATA:                                               *
*                                                                *
*        Format data from type 5 record base section.            *
*                                                                *
*        R7  = Subroutine linkage.                               *
*        R9  = Address of SMF record.                            *
*        R10 = Exit routine parameter list.                      *
*        R12 = Address of LCT - not referenced.                  *
*                                                                *
*        Workregs = R0, R1, R4, R14, R15.                        *
*                                                                *
******************************************************************
         SPACE 1
JBLDDATA DS    0H                  Build job data lines
         SPACE 1
*----------------------------------------------------------------*
*        Job name.                                               *
*----------------------------------------------------------------*
         MVC   JNM,SMF5JBN         Set job name in print line
         SPACE 1
*----------------------------------------------------------------*
*        Reader start time.                                      *
*----------------------------------------------------------------*
         ICM   R1,15,SMF5RST       Get reader start time
         LA    R15,JRDTM           Locate print position
         BAL   R7,TIMEX            Go convert time to HH:MM:SS:TH
         SPACE 1
*----------------------------------------------------------------*
*        Reader start date.                                      *
*----------------------------------------------------------------*
         ICM   R1,15,SMF5RSD       Get reader start date
         LA    R15,RTDOW           Find day-of-week
         BALR  R14,R15              of reader start date
         MVC   JRDDAY,0(R15)         and set in output line
         LA    R0,JRDDT            Format reader date
         LA    R15,RTJDATE          as Julian date
         BALR  R14,R15               into output line
         LA    R0,JRDDTC           Convert reader date
         LA    R15,RTTOGREG         to Gregorian date
         BALR  R14,R15               and format into output line
         SPACE 1
*----------------------------------------------------------------*
*        Job class.                                              *
*----------------------------------------------------------------*
         MVC   JCLASS,SMF5JICL     Get job class
         SPACE 1
*----------------------------------------------------------------*
*        Job initiation time.                                    *
*----------------------------------------------------------------*
         ICM   R1,15,SMF5JIT       Get time job was initiated
         LA    R15,JINITTM         Locate its print position
         BAL   R7,TIMEX            Go convert time to HH:MM:SS:TH
         SPACE 1
*----------------------------------------------------------------* @D02
*        Job initiation date.  Older versions of the             * @D02
*        operating system prior to modern versions of MVS        * @D02
*        don't correctly provide four digit year information,    * @D02
*        so adjust the century byte based on a sliding window    * @D02
*        (year > 60 is assumed to be 19yy, year <= 60 is         * @D02
*        treated as 20yy).                                       * @D02
*----------------------------------------------------------------* @D02
         CLI   SMF5JID+1,X'60'     Start year > 60?                @D02
         BH    JBLDSTRT            20th century if so              @D02
         MVI   SMF5JID,X'01'       Else show 21st century          @D02
JBLDSTRT DS    0H                                                  @D02
         TIME  BIN                 Date with "0c" in R1
         ICM   R1,15,SMF5JID       Get job initiation date
         LA    R15,RTDOW           Find day-of-week
         BALR  R14,R15              of start date
         MVC   JINITDAY,0(R15)       and set in output line
         LA    R0,JINITDT          Format start date
         LA    R15,RTJDATE          as Julian date
         BALR  R14,R15               into output line
         LA    R0,JINITDTC         Convert start date
         LA    R15,RTTOGREG         to Gregorian date
         BALR  R14,R15               and format into output line
         SPACE 1
*----------------------------------------------------------------*
*        Job end time.                                           *
*----------------------------------------------------------------*
         TIME  BIN                 Get job end date/time
         STCM  R1,15,DATEND        Save job end date
         LR    R4,R0               Save job end time
         LR    R1,R4               Save time for convert routine
         LA    R15,JENDTM          Point to output area
         BAL   R7,TIMEX            Go convert time to HH:MM:SS:TH
         SPACE 1
*----------------------------------------------------------------*
*        Job end date.                                           *
*----------------------------------------------------------------*
         ICM   R1,15,DATEND        Get job end date
         LA    R15,RTDOW           Find day-of-week
         BALR  R14,R15              of end date
         MVC   JENDDAY,0(R15)        and set in output line
         LA    R0,JENDDT           Format end date
         LA    R15,RTJDATE          as Julian date
         BALR  R14,R15               into output line
         LA    R0,JENDDTC          Convert end date
         LA    R15,RTTOGREG         to Gregorian date
         BALR  R14,R15               and format into output line
         SPACE 1
*----------------------------------------------------------------*
*        Job elapsed time                                        *
*----------------------------------------------------------------*
         MVC   DATE,SMF5JID        Get job start date
         LR    R1,R4               Get job end time
         ICM   R0,15,SMF5JIT       Get time job was initiated
         LA    R15,JELAPSTM        Point to output area
         BAL   R7,ELAPSED          Format job elapsed time
         SPACE 1
*----------------------------------------------------------------*
*        Job CPU time under TCBs.                                *
*----------------------------------------------------------------*
         XR    R1,R1               Clear time register
         ICM   R1,7,SMF5JCPU       Get job TCB time
         LA    R15,JCPUTM          Point to slot for output
         BAL   R7,TIMEX            Go convert time to HH:MM:SS:TH
         SPACE 1
*----------------------------------------------------------------*
*        First accounting field from JOB card.                   *
*----------------------------------------------------------------*
         MVC   J3ACCT,=CL8' '      Blank account number field
         XR    R15,R15             Zero number of account fields
         L     R1,12(,R10)         Point to num of acct fields
         ICM   R15,1,3(R1)         Get number of acct fields
         BNP   JMISC               Skip this if no fields
         L     R1,16(,R10)         Point to accounting fields
         ICM   R15,1,0(R1)         Get length of 1st field
         BNP   JMISC               Quit if no first field
         C     R15,=F'8'           1st field too big for us?
         BH    JMISC               Skip accounting field if so
         BCTR  R15,0               Decrement for executed move
         EX    R15,MOVEACCT        Move in account number
         SPACE 1
*----------------------------------------------------------------*
*        Job priority.                                           *
*----------------------------------------------------------------*
         XR    R15,R15             Clear a register
         IC    R15,SMF5JPTY        Get job priority
         CVD   R15,DWORK           Convert to packed
         BAL   R14,EDMKRTN         Format as zoned
         MVC   J3PRTY,EPRTY        Set priority in output line
         B     JMISC               Continue
         SPACE 1
MOVEACCT MVC   J3ACCT(*-*),1(R1)   ** Executed **
         EJECT ,
******************************************************************
*                                                                *
*        JMISC:                                                  *
*                                                                *
*        Build miscellaneous non-SMF record job fields.          *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT.                                   *
*                                                                *
*        Workregs = R0, R1, R4, R14, R15.                        *
*                                                                *
******************************************************************
         SPACE 1
JMISC    DS    0H                  Build non-record fields
         SPACE 1
         TITLE '    Job end processing - Write job end statistics box t+
               o system messages data set'
******************************************************************
*                                                                *
*        JPUTCHDR:                                               *
*                                                                *
*        Write job end statistics box to system messages         *
*        data set.                                               *
*                                                                *
*        R7  = Subroutine linkage to PUTLINE subroutine.         *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT.                                   *
*                                                                *
*        Workregs = R0, R1, R14, R15.                            *
*                                                                *
******************************************************************
         SPACE 1
JPUTCHDR DS    0H                  Write job end box headings
         LA    R0,132              Set length of line
         L     R1,ABLANKS          Point to blanks
         BAL   R7,PUTLINE          Write blank line
         LA    R0,132              Set length of line
         LA    R1,HDR              Point to header line
         BAL   R7,PUTLINE          Write box heading line
         LA    R0,132              Set length of line
         L     R1,AJOBHDR          Point to "JOB END" line
         BAL   R7,PUTLINE          Write "JOB END" line
         LA    R0,132              Set length of line
         LA    R1,JOBLN1           Point to job end line 1
         BAL   R7,PUTLINE          Write job end line 1
         LA    R0,132              Set length of line
         LA    R1,JOBLN2           Point to job end line 2
         BAL   R7,PUTLINE          Write job end line 2
         LA    R0,132              Set length of line
         LA    R1,JOBLN3           Point to job end line 3
         BAL   R7,PUTLINE          Write job end line 3
         LA    R0,132              Set length of line
         L     R1,ASTARS           Point to line of stars
         BAL   R7,PUTLINE          Write "****" line
         LA    R0,132              Set length of line
         L     R1,ABLANKS          Point to blanks
         BAL   R7,PUTLINE          Write blank line
         B     FREEWORK            Done, go clean up and exit
         TITLE '    Common exit logic - free work area'
******************************************************************
*                                                                *
*        FREEWORK:                                               *
*                                                                *
*        Free dynamic work area.                                 *
*                                                                *
*        R9  = Address of SMF record - not referenced.           *
*        R10 = Exit routine parameter list - not referenced.     *
*        R12 = Address of LCT.                                   *
*        R13 = GETMAINed work area - freed in this routine.      *
*                                                                *
*        Workregs = R0, R1, R15.                                 *
*                                                                *
******************************************************************
         SPACE 1
FREEWORK DS    0H                  Free the work area
         LR    R1,R13              Set work area address for freemain
         LA    R0,LWORKA           Set work area length for freemain
         LA    R15,1               Set subpool
         SLL   R15,24               in high-order byte
         LR    R0,R15                of length register
         L     R13,SAVEA+4         Restore caller's save area address
         DROP  R13                 End work area addressability
         FREEMAIN R,LV=(0),A=(1)   Free dynamic work storage
         TITLE '    Common exit logic - return to caller'
******************************************************************
*                                                                *
*        RETURN:                                                 *
*                                                                *
*        Return to caller.  The return code in R15 is set        *
*        to 0 to allow the current job to continue, and the      *
*        "write SMF record" indicator in R1 is set to 0 to       *
*        permit the SMF record to be written.                    *
*                                                                *
******************************************************************
         SPACE 1
RETURN   DS    0H                  Common return logic
         L     R14,12(,R13)        Restore return address
         XR    R1,R1               Allow SMF record to be written
         RETURN (2,12),RC=0        Return to caller
         EJECT
******************************************************************
*                                                                *
*        EXCP:                                                   *
*                                                                *
*        Subroutine to convert and place device number and       *
*        EXCP counts in print line.                              *
*                                                                *
*        R3  = Address of current EXCP section in SMF record.    *
*        R6  = Address of current EXCP segment in print line.    *
*        R7  = Subroutine return address.                        *
*        R10 = Exit routine parameter list.                      *
*                                                                *
******************************************************************
         SPACE 1
         USING WORKA,R13           Restore work area addressability
EXCP     DS    0H                  Format EXCP entry
         USING SX,R6               Addressability for EXCP line
         USING SMF4DEVC,R3         Address EXCP section of record
         SPACE 1
EXCP02   DS    0H                  Do non-VIO device number
         MVC   DWORK(2),SMF4CUAD   Get device number
         NI    DWORK,X'7F'         Mask in case mass storage
         MVI   DWORK+2,X'0F'       Set sign for unpack
         UNPK  DWORK+3(5),DWORK(3) Unpack device number
         MVC   SUNIT,DWORK+3       Move to print line
         TR    SUNIT,HEXTRAN-240   Translate hex to character
         SPACE 1
EXCP03   DS    0H                  Process EXCPS for device
         ICM   R15,15,SMF4EXCP     Load EXCP count
         CVD   R15,DWORK           Convert EXCPs to decimal
         MVC   SCOUNT,MSKEXCP      Move edit pattern to line
         LA    R1,SCOUNT+L'SCOUNT-1  Default significance pointer
         EDMK  SCOUNT,DWORK+2      Edit EXCPs into line
         BCTR  R1,0                Decrement significance pointer
         MVI   0(R1),C' '          Set blank before first digit
         BR    R7                  Return to caller
         SPACE 1
MSKEXCP  DC    3C'-',9X'20',X'2120'  EXCP edit mask
         SPACE 1
         DROP  R3                  End EXCP record addressability
         DROP  R6                  End EXCP output addressability
         DROP  R13                 End work area addressability
         EJECT
         TITLE '    Julian date formatting subroutine'
***********************************************************************
*                                                                     *
*                                                                     *
* Subroutine           =  RTJDATE                                     *
*                                                                     *
*   Purpose            =  To format an OS Julian date (year and       *
*                         day of year) as "yyyy.ddd" into a           *
*                         caller-supplied buffer.                     *
*                                                                     *
*   Linkage            =  Via BALR R14,R15                            *
*                                                                     *
*   Comments           =  None.                                       *
*                                                                     *
*   Input data         =                                              *
*       R0     = Address of 8-byte area to contain formatted date     *
*       R1     = Date in OS TIME DEC format 0cyydddF                  *
*       R2-10  = Not applicable                                       *
*       R11    = Main program base register                           *
*       R12    = Not applicable                                       *
*       R13    = Standard 18-word OS save area                        *
*       R14    = Return address                                       *
*       R15    = Entry address                                        *
*                                                                     *
*   Registers saved    =  R0 - R15                                    *
*                                                                     *
*   Register usage     =                                              *
*       R0-2   = Not modified                                         *
*       R3     = Address of output area (from R0 at entry)            *
*       R4-13  = Not modified                                         *
*       R14    = Work register                                        *
*       R15    = Not modified                                         *
*                                                                     *
*   Registers restored =  R0 - R15                                    *
*                                                                     *
*   Output data        =                                              *
*       8-byte area pointed to by R0 at entry contains                *
*       Julian date formatted as "yyyy.ddd".                          *
*                                                                     *
*   Exit (normal)      =  Return to caller.                           *
*     Output           =  Formatted Julian date.                      *
*     Return code      =  Not applicable                              *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*        RTJDATE: Subroutine to format Julian date.                   *
*                                                                     *
***********************************************************************
         SPACE 1
RTJDATE  DS    0H                  Format Julian date
         USING WORKA,R13           Addressability for work area
         STM   R14,R12,12(R13)     Save caller's registers
         ST    R1,TIME             Set date 0cyydddF in work area
         LR    R3,R0               Save pointer to output area
         USING DJULDT,R3           Addressability for output area
         MVC   DJEDIT,EMJDATE      Initialize edit mask for date
         ED    DJEDIT,TIME+1       Edit date into output
         MVC   DJCC,=C'  '         Clear century digit positions
         IC    R14,TIME            Get the century index
         N     R14,=A(X'00000007') Ensure a number in range 0-7
         SLL   R14,1               Get index
         LA    R14,ERCENTBL(R14)    into century table
         MVC   DJCC,0(R14)         Set century in date
         LM    R14,R12,12(R13)     Restore caller's registers
         BR    R14                 Return to caller
         DROP  R3                  End output area addressability
         DROP  R13                 End work area addressability
         SPACE 1
EMJDATE  DC    X'F021204B202020'   Edit mask for Julian date
         SPACE 1
*---------------------------------------------------------------------*
*        Table for building century from century index.               *
*---------------------------------------------------------------------*
ERCENTBL DS    0CL2                Century table
         DC    CL2'19'             +00 - century=00 - 20th century
         DC    CL2'20'             +02 - century=01 - 21st century
         DC    CL2'21'             +04 - century=02 - 22st century
         DC    CL2'22'             +06 - century=03 - 23rd century
         DC    CL2'23'             +08 - century=04 - 24th century
         DC    CL2'24'             +0a - century=05 - 25th century
         DC    CL2'25'             +0c - century=06 - 26th century
         DC    CL2'26'             +10 - century=07 - 27th century
         EJECT ,
*---------------------------------------------------------------------*
*        Mapping of area to contain formatted Julian date.            *
*---------------------------------------------------------------------*
DJULDT   DSECT ,                   Map formatted Julian date
DJYEAR   DS    0CL4                -- Four-digit year
DJCC     DS    CL2                 ---- Century
DJYY     DS    CL2                 ---- Year
         DS    C'.'                -- Separator "."
DJDAY    DS    CL3                 -- Day of year
         SPACE 1
DJEDIT   EQU   DJYEAR+1,7,C'C'     Alias for edit
         SPACE 1
IEFACTRT CSECT ,                   Resume main CSECT
         EJECT
         TITLE '    Julian-to-Gregorian date conversion subroutine'
***********************************************************************
*                                                                     *
*                                                                     *
* Subroutine           =  RTTOGREG                                    *
*                                                                     *
*   Purpose            =  To convert OS Julian date (year and day     *
*                         of year) in TIME DEC format to Gregorian    *
*                         month and day, and format the result into   *
*                         a caller-supplied buffer.                   *
*                                                                     *
*   Linkage            =  Via BALR R14,R15                            *
*                                                                     *
*   Comments           =                                              *
*                                                                     *
*       The algorithm used in this routine was adapted from           *
*       an algorithm called "Tableless Date Conversion" in            *
*       Communications of the ACM, Volume 13, Number 10,              *
*       October 1970.  The basic algorithm is:                        *
*                                                                     *
*         if (year is a leap year)                                    *
*           t = 1;                                                    *
*         else                                                        *
*           t = 0;                                                    *
*         endif                                                       *
*         if (dayofyear > (59 + t))                                   *
*           dayofmonth = dayofyear + 2 - t;                           *
*         else                                                        *
*           dayofmonth = dayofyear;                                   *
*         endif                                                       *
*         month = int(((dayofmonth + 91) * 100) / 3055);              *
*         dayofmonth = (dayofmonth + 91) - int((month * 3055) / 100); *
*         month = month - 2;                                          *
*         return(month, dayofmonth);                                  *
*                                                                     *
*       Note that the current implementation of this algorithm        *
*       doesn't include logic to handle centesimal years that         *
*       aren't leap years.  While it will work for years between      *
*       1901 and 2099 inclusive, it will break in 2100.               *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
*   Input data         =                                              *
*       R0     = Address of 10-byte area for formated Gregorian date  *
*       R1     = Date in OS TIME DEC format 0cyydddF                  *
*       R2-10  = Not applicable                                       *
*       R11    = Main program base register                           *
*       R12    = Not applicable                                       *
*       R13    = Standard 18-word OS save area                        *
*       R14    = Return address                                       *
*       R15    = Entry address                                        *
*                                                                     *
*   Registers saved    =  R0 - R15                                    *
*                                                                     *
*   Register usage     =                                              *
*       R0     = Work register                                        *
*       R1     = Work register                                        *
*       R2     = Work register                                        *
*       R3     = Pointer to area for formatted Gregorian date         *
*       R4-14  = Not modified                                         *
*       R15    = Work register                                        *
*                                                                     *
*   Registers restored =  R0 - R15                                    *
*                                                                     *
*   Output data        =                                              *
*       The 10-byte area pointed to by R0 at entry contains           *
*       the Gregorian date formatted as "yyyy/mm/dd".                 *
*                                                                     *
*   Exit (normal)      =  Return to caller via PR.                    *
*     Output           =  Formatted Gregorian date.                   *
*     Return code      =  Not applicable                              *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*        RTTOGREG:                                                    *
*                                                                     *
*        Subroutine to find Gregorian month and day from              *
*        Julian date and format the result.                           *
*                                                                     *
***********************************************************************
         SPACE 1
RTTOGREG DS    0H                  Find Gregorian month and day
         USING WORKA,R13           Addressability for work area
         STM   R14,R12,12(R13)     Save caller's registers
         LR    R3,R0               Save pointer to output area
         USING DGREGDT,R3          Addressability for output area
         LR    R2,R1               Save date 0cyydddF in R2
         SLL   R2,16               Packed days
         SRL   R2,16                0000dddF in R2
         XR    R0,R0               Isolate
         SLDL  R0,8                 century
         SRL   R1,8+16               in R0
         AH    R0,=H'19'              and adjust
         MH    R0,=H'100'              for 20th century base
         SLL   R1,4                Packed year 00000yy0 in R1
         O     R1,=A(X'0000000F')  Packed year 00000yyF in R1
         XC    DWORK,DWORK         Clear CVB work area
         STCM  R1,15,DWORK+4       Set decimal year in work area
         CVB   R1,DWORK            Convert year to binary
         AR    R1,R0               Add century to year
         CVD   R1,DWORK            Convert 4-digit year to packed
         UNPK  DGYEAR,DWORK        Unpack year into output
         OI    DGYEAR+3,X'F0'       and force printable sign
         XC    DWORK,DWORK         Clear CVB work area
         STCM  R2,15,DWORK+4       Set decimal day in work area
         CVB   R0,DWORK            Convert day to binary
         LR    R2,R0               d = j = day of year in R2
         XR    R15,R15             Assume it's not a leap year
         N     R1,=F'3'            Make simple leap year test
         BNZ   RTTOGRA             t=0 if not a leap year
         LA    R15,1                otherwise t=1
RTTOGRA  LA    R1,59(,R15)         (59+t) in R1
         CR    R2,R1               Is j>(59+t)?
         BNH   RTTOGRB             Branch if not
         A     R2,=F'2'            Otherwise
         SR    R2,R15               d=j+2-t in R2
RTTOGRB  A     R2,=F'91'           d+91 in R2
         LR    R1,R2                and in R1
         M     R0,=F'100'          (d+91)*100 in R0-R1
         D     R0,=F'3055'         m=int(((d+91)*100)/3055)
         LR    R15,R1               in R1 and R15
         M     R14,=F'3055'        int((m*3055)/100)
         D     R14,=F'100'          in R15
         SR    R2,R15              d=(d+91)-int((m*3055)/100)          +
                                    in R2
         BCTR  R1,0                Adjust month
         BCTR  R1,0                 to m=m-2
         CVD   R1,DWORK            Convert month to packed
         UNPK  DGMONTH,DWORK       Unpack month into output
         OI    DGMONTH+1,X'F0'      and force printable sign
         CVD   R2,DWORK            Convert day to packed
         UNPK  DGDAY,DWORK         Unpack day into output
         OI    DGDAY+1,X'F0'        and force printable sign
         MVI   DGSEP1,C'/'         Insert separator
         MVI   DGSEP2,C'/'         Insert separator
         LM    R14,R12,12(R13)     Restore caller's registers
         BR    R14                 Return to caller
         SPACE 1
         DROP  R3                  End output area addressability
         DROP  R13                 End work area addressability
         SPACE 1
*---------------------------------------------------------------------*
*        Mapping of area to contain formatted Gregorian date.         *
*---------------------------------------------------------------------*
DGREGDT  DSECT ,                   Map formatted Gregorian date
DGYEAR   DS    CL4                 -- Four-digit year
DGSEP1   DS    C'/'                -- Separator "/"
DGMONTH  DS    CL2                 -- Month
DGSEP2   DS    C'/'                -- Separator "/"
DGDAY    DS    CL2                 -- Day of month
         SPACE 1
IEFACTRT CSECT ,                   Resume main CSECT
         TITLE '    Weekday calculation subroutine'
***********************************************************************
*                                                                     *
*                                                                     *
* Subroutine           =  RTDOW                                       *
*                                                                     *
*   Purpose            =  To find the day of the week given an        *
*                         OS Julian date (year and day of year)       *
*                         in TIME DEC format.                         *
*                                                                     *
*   Linkage            =  Via BALR R14,R15                            *
*                                                                     *
*   Comments           =                                              *
*                                                                     *
*       The algorithm used in this routine was adapted from           *
*       "Elementary Number Theory and Its Applications" by            *
*       Kenneth H. Rosen, Second Edition, pp 152-157:                 *
*                                                                     *
*         if (year is a leap year)                                    *
*           f = j - 61 + 140;                                         *
*         else                                                        *
*           f = j - 60 + 140;                                         *
*         endif;                                                      *
*         weekday = (3 + f - (2*c) + y + int(c/4) + int(y/4)) mod 7;  *
*         return(weekday);                                            *
*                                                                     *
*       where                                                         *
*                                                                     *
*       o  J is the day of the year                                   *
*                                                                     *
*       o  C is the high-order two digits of the year                 *
*                                                                     *
*       o  Y is the low-order two digits of the year                  *
*                                                                     *
*       o  F is the offset from March 1 to the day of the year J,     *
*          adjusted by 140 to prevent the operand of the modulus      *
*          operation from becoming negative (140 is an even           *
*          multiple of the modulus that's large enough                *
*          to offset the largest anticipated negative value)          *
*                                                                     *
*       The return value is an index of the weekday, with             *
*       0 = Sunday, 1 = Monday, and so on.                            *
*                                                                     *
*       Note that the current implementation of this algorithm        *
*       doesn't include logic to handle centesimal years that         *
*       aren't leap years.  While it will work for years between      *
*       1901 and 2099 inclusive, it will break in 2100.               *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
*   Input data         =                                              *
*       R0     = Not applicable                                       *
*       R1     = Date in OS TIME DEC format 0cyydddF                  *
*       R2-10  = Not applicable                                       *
*       R11    = Main program base register                           *
*       R12    = Not applicable                                       *
*       R13    = Standard 18-word OS save area                        *
*       R14    = Return address                                       *
*       R15    = Entry address                                        *
*                                                                     *
*   Registers saved    =  R0 - R15 by stack linkage                   *
*                                                                     *
*   Register usage     =                                              *
*       R0     = Work register                                        *
*       R1     = Work register                                        *
*       R2-13  = Not modified                                         *
*       R14    = Work register                                        *
*       R15    = Work register                                        *
*                                                                     *
*   Registers restored =  R0 - R14                                    *
*                                                                     *
*   Output data        =                                              *
*       R0-14  = Same values as at entry                              *
*       R15    = Pointer to 9-byte area containing day of week.       *
*                                                                     *
*   Exit (normal)      =  Return to caller.                           *
*     Output           =  Index of day of week in R15.                *
*     Return code      =  Not applicable                              *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*        RTDOW: Subroutine to find the day of the week.               *
*                                                                     *
***********************************************************************
         SPACE 1
RTDOW    DS    0H                  Subroutine to find weekday
         USING WORKA,R13           Addressability for work area
         STM   R14,R12,12(R13)     Save caller's registers
         XR    R0,R0               Extract century index
         SLDL  R0,8                 and convert
         A     R0,=F'19'             to actual value c in R0
         SRL   R1,20               Isolate
         O     R1,=A(X'0000000F')   year YY
         XC    DWORK,DWORK           and
         ST    R1,DWORK+4             convert
         CVB   R1,DWORK                to binary y in R1
         LR    R15,R1                   and in R15
         LR    R14,R0              c in R14
         SLL   R14,1               (2*c) in R14
         LCR   R14,R14             -(2*c) in R14
         SRL   R0,2                int(c/4) in R0
         A     R14,=F'3'           3-(2*c) in R14
         AR    R14,R1              3-(2*c)+y in R14
         SRL   R1,2                int(y/4) in R1
         AR    R14,R0              3-(2*c)+y+int(c/4) in R14
         AR    R14,R1              3-(2*c)+y+int(c/4)+int(y/4) in R14
         L     R1,24(,R13)         Isolate
         N     R1,=A(X'0000FFFF')   day of year
         ST    R1,DWORK+4            and convert
         CVB   R1,DWORK               to binary d in R1
         A     R1,=F'80'           f=j-60+140 in R1
         N     R15,=F'3'           Cheesy leap year test
         BNZ   RTDOWX              Branch if not leap year
         BCTR  R1,0                Else f=j-61+140 in R1
RTDOWX   AR    R14,R1              3+f-(2*c)+y+int(c/4)+int(y/4)       +
                                    in R14
         SRDL  R14,32              3+f-(2*c)+y+int(c/4)+int(y/4)       +
                                    in R14-R15
         D     R14,=F'7'           (3+f-(2*c)+y+int(c/4)+int(y/4))     +
                                    mod 7 in R14
         SLL   R14,4               Point R15 to
         LA    R15,DAYTBL(R14)      character weekday
         L     R14,12(,R13)        Restore
         LM    R0,R12,20(R13)       caller's registers
         BR    R14                 Return to caller
         DROP  R13                 End work area addressability
         EJECT ,
*---------------------------------------------------------------------*
*        Day of the week table.                                       *
*---------------------------------------------------------------------*
DAYTBL   DS    0F
         DC    CL16'SUNDAY'
         DC    CL16'MONDAY'
         DC    CL16'TUESDAY'
         DC    CL16'WEDNESDAY'
         DC    CL16'THURSDAY'
         DC    CL16'FRIDAY'
         DC    CL16'SATURDAY'
         TITLE '    Subroutines'
***********************************************************************
*                                                                     *
*  THIS ROUTINE CALCULATES THE ELAPSED TIME WHICH IS THE DIFFERENCE   *
*                     BETWEEN TWO BINARY TIME                         *
*                                                                     *
*        R0  = (AT ENTRY) START TIME IN BINARY 1/100 SECONDS.         *
*        R1  = (AT ENTRY) END TIME IN BINARY 1/100 SECONDS.           *
*              (AT EXIT)  ELAPSED TIME IN BINARY 1/100 SECONDS.       *
*        R7  = Return address.                                        *
*                                                                     *
*        Workregs = R1.                                               *
*                                                                     *
***********************************************************************
         SPACE 2
ELAPSED  DS    0H
         USING WORKA,R13           Addressability for work area
         SPACE 1                                                   @D03
*----------------------------------------------------------------* @D03
*        If the start and end dates both have the same year,     * @D03
*        the elapsed time calculation is trivial.  Otherwise,    * @D03
*        call "ELAPSPAN" subroutine to adjust start and end      * @D03
*        dates so the trival calculation works correctly.        * @D03
*----------------------------------------------------------------* @D03
         CLC   DATE(2),DATEND      Are start/end date same year?   @D03
         BE    ELAP00              Go do trivial calculation if so @D03
         BAL   R14,ELAPSPAN        Else adjust for yearend span    @D03
         SPACE 1                                                   @D03
*----------------------------------------------------------------* @D03
*        Loop adding one day's worth of hours to end time        * @D03
*        for each day of difference between start date and       * @D03
*        end date.                                               * @D03
*----------------------------------------------------------------* @D03
ELAP00   DS    0H                                                  @D03
         CP    DATE+2(2),DATEND+2(2)  Same day?
         BNL   ELAP01              Yes, go around add on
         AP    DATE+2(2),=P'1'     Add on 1 day
         A     R1,ONEDAY           And 24 hours to time
         B     ELAPSED             Try for match again
         SPACE 1
ELAP01   DS    0H
         SR    R1,R0               Get difference
         B     TIMEX               Fall into time conversion
         EJECT
***********************************************************************
*                                                                     *
*        TIMEX                                                        *
*                                                                     *
*        This routine translates binary time in 1/100 seconds         *
*        to character "HH:MM:SS.TH" format.                           *
*                                                                     *
*        R1  = (at entry) binary time in 1/100 seconds.               *
*        R7  = Return address.                                        *
*        R15 = Address of field for character output.                 *
*                                                                     *
*        Workregs = R0, R1, R14.                                      *
*                                                                     *
***********************************************************************
         SPACE 1
TIMEX    DS    0H
         MVI   2(R15),COLON        Initialize
         MVI   5(R15),COLON         separators
         MVI   8(R15),DOT            in output field
         LA    R14,100             Get divisor
         XR    R0,R0               Clear high order
         DR    R0,R14              R1 now in seconds
         CVD   R0,DWORK            Convert 100ths
         UNPK  9(2,R15),DWORK       of seconds
         OI    10(R15),F0            to character
         SPACE 1
         XR    R0,R0               Clear
         LA    R14,60              60 secs/min
         DR    R0,R14              R0 has secs, R1 has balance
         CVD   R0,DWORK            Convert
         UNPK  6(2,R15),DWORK       seconds
         OI    7(R15),F0             to character
         SPACE 1
         XR    R0,R0               Clear again
         DR    R0,R14              R0 has minutes, R1 has hours
         CVD   R0,DWORK            Convert
         UNPK  3(2,R15),DWORK       minutes
         OI    4(R15),F0             to character
         SPACE 1
         CVD   R1,DWORK            Convert hours
         OI    DWORK+7,X'0F'       Force printable sign
         LA    R1,1                Assume 2 digits of hours
         TM    DWORK+6,X'F0'       More than 99 hours?
         BZ    TIMEX01             Branch if not
         BCTR  R15,0               Else bump back output pointer
         LA    R1,2                Set machine length for move
         SPACE 1
TIMEX01  DS    0H                  Put hours in output field
         SLL   R1,4                Set length of output field
         EX    R1,SETHOURS         Unpack hours into output
         BR    R7                  Return
         SPACE 1
SETHOURS UNPK  0(*-*,R15),DWORK    ** Executed **
         DROP  R13                 End work area addressability
         EJECT ,
***********************************************************************
*                                                                     *
*        TIMEY:                                                       *
*                                                                     *
*        Subroutine to convert binary time in 1024-microsecond        *
*        units into binary hundredths of seconds which may then be    *
*        converted to printable time using "TIMEX".                   *
*                                                                     *
*        R1  = (at entry) Binary time in 1024-usec units.             *
*              (at exit)  Binary time in 1/100 seconds.               *
*        R7  = Return address.                                        *
*                                                                     *
*        Workregs = R0, R1.                                           *
*                                                                     *
***********************************************************************
         SPACE 1
TIMEY    DS    0H                  Convert 1024-usec to hundredths
         XR    R0,R0               Clear register
         SLDA  R0,10               Multiply by 1024 to get usec
         D     R0,=F'10000'        Divide to get 1/100 of seconds
         S     R0,=F'5000'         Do we need to round up?
         BM    NOROUND             No
         A     R1,=F'1'            Else add one to hundredths
         SPACE 1
NOROUND  DS    0H
         BR    R7                  Back to caller
         TITLE '    Subroutine to adjust elapsed time calculation for d+
               ate range spanning year end'                        @D03
***********************************************************************
*                                                                     *
*                                                                     *
* Subroutine           =  ELAPSPAN                                    *
*                                                                     *
*   Purpose            =  To handle the special case of elapsed       *
*                         time calculations when the start and        *
*                         end dates span yearend.                     *
*                                                                     *
*   Linkage            =  Via BAS R14                                 *
*                                                                     *
*   Comments           =                                              *
*                                                                     *
*       This subroutine is called by the "ELAPSED" subroutine         *
*       to adjust elapsed time calculations for a start date/         *
*       end date range that spans the end of a year.  It reduces      *
*       the end year until it's the same as the start year, and       *
*       adds an equivalent number of days to the end day.             *
*                                                                     *
*       Registers R0 through R12 and R14 are saved in the             *
*       ELAPSAV save area (in the main program's work area            *
*       pointed to by R13).                                           *
*                                                                     *
*       Note that the cheesy leap year test in this routine           *
*       doesn't include logic to handle centesimal years that         *
*       aren't leap years.  While it will work for years between      *
*       1901 and 2099 inclusive, it will break in 2100.               *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,                                                   @D03
***********************************************************************
*                                                                     *
*                                                                     *
*   Input data         =                                              *
*       R0-10  = Not applicable                                       *
*       R11    = Main program base register                           *
*       R12    = Not applicable                                       *
*       R13    = Main program dynamic work area                       *
*       R14    = Return address                                       *
*       R15    = Not applicable                                       *
*                                                                     *
*   Registers saved    =  R0 - R15 in ELAPSAV save area               *
*                                                                     *
*   Register usage     =                                              *
*       R0     = Work register                                        *
*       R1     = Work register                                        *
*       R2-14  = Not modified                                         *
*       R15    = Work register                                        *
*                                                                     *
*   Registers restored =  R0 - R12, R14                               *
*                                                                     *
*   Output data        =                                              *
*       "DATEND" end date adjusted so that the end year has           *
*       been decreased to be equal to the start year, and an          *
*       equivalent number of days have been added to the end day.     *
*                                                                     *
*   Exit (normal)      =  Return to caller via BR 14.                 *
*     Output           =  Modified end date in "DATEND" field.        *
*     Return code      =  Not applicable                              *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,                                                   @D03
****************************************************************** @D03
*                                                                * @D03
*        ELAPSPAN:  Subroutine to handle elapsed time range that * @D03
*                   spans the end of the year.                   * @D03
*                                                                * @D03
****************************************************************** @D03
         SPACE 1                                                   @D03
ELAPSPAN DS    0H                  Handle yearend span             @D03
         USING WORKA,R13           Addressability for work area    @D03
         STM   R14,R12,ELAPSAV     Save caller's registers         @D03
         SPACE 1                                                   @D03
         XC    DWORK,DWORK         Clear CVB work area             @D03
         XR    R0,R0               Clear start year register       @D03
         ICM   R0,12,DATE          Get packed start year           @D03
         SRL   R0,12               Start year 0000cyy0 in R0       @D03
         X     R0,=A(X'0000000F')  Start year 0000cyyF in R0       @D03
         STCM  R0,15,DWORK+4       Set packed year in work area    @D03
         CVB   R0,DWORK            Binary start year in R0         @D03
         SPACE 1                                                   @D03
         XR    R1,R1               Clear end year register         @D03
         ICM   R1,12,DATEND        Get packed end year             @D03
         SRL   R1,12               End year 0000cyy0 in R1         @D03
         X     R1,=A(X'0000000F')  End year 0000cyyF in R1         @D03
         STCM  R1,15,DWORK+4       Set packed year in work area    @D03
         CVB   R1,DWORK            Binary end year in R1           @D03
         SPACE 1                                                   @D03
ELSPAN01 DS    0H                  Loop adjusting end date         @D03
         CR    R0,R1               If start year = end year        @D03
         BE    ELSPAN02             then we're done                @D03
         AP    DATEND+2(2),=P'365' Else add one year of days       @D03
         BCTR  R1,0                 and subtract one year of years @D03
         LR    R15,R1              Test if this year               @D03
         N     R15,=F'3'            is a leap year                 @D03
         BNZ   ELSPAN01              and continue loop if not      @D03
         AP    DATEND+2(2),=P'1'   Else add day for leap year      @D03
         B     ELSPAN01             and then continue loop         @D03
         SPACE 1                                                   @D03
ELSPAN02 DS    0H                  Save modified end year value    @D03
         CVD   R1,DWORK            Convert end year to packed      @D03
         ICM   R1,15,DWORK+4       Packed year 0000cyyC in R1      @D03
         SRL   R1,4                Packed year 00000cyy in R1      @D03
         STCM  R1,3,DATEND         Update end year                 @D03
         LM    R14,R12,ELAPSAV     Restore caller's registers      @D03
         BR    R14                 Return to caller                @D03
         DROP  R13                 End work area addressability    @D03
         TITLE '    Subroutines'
         EJECT ,
******************************************************************
*                                                                *
*        EDMKRTN:                                                *
*                                                                *
*        Subroutine to perform "EDIT AND MARK" operation to      *
*        format packed decimal values into zoned output with     *
*        "-" as front padding.                                   *
*                                                                *
*        Input:                                                  *
*          Doubleword field "DWORK" contains the packed          *
*          decimal number to be formatted.                       *
*                                                                *
*        Output:                                                 *
*          20-byte field "OUTWORK" contains the value            *
*          formatted in zoned decimal with leading hyphens       *
*          supplied as padding on the front.  There is one       *
*          blank between the hyphens and the first digit of      *
*          the number.  for example:                             *
*                                                                *
*                          000000000245583C                      *
*                                                                *
*          is formatted as:                                      *
*                                                                *
*                         ------------- 245583                   *
*                                                                *
*        R14 = Subroutine return address.                        *
*                                                                *
*        Workregs:  R1.                                          *
*                                                                *
******************************************************************
         SPACE 1
EDMKRTN  DS    0H                  Numeric value edit subroutine
         USING WORKA,R13           Addressability for work area
         LA    R1,EDMKWORK+L'EDMKWORK-1  Assume no leading zeroes
         MVC   EDMKWORK,EDMKMASK   Build edit mask in work area
         EDMK  EDMKWORK,DWORK      Edit value to zoned
         BCTR  R1,0                Blank "-" just before
         MVI   0(R1),C' '           the first significant digit
         BR    R14                 Return to caller
         DROP  R13                 End work area addressability
         TITLE '    Subroutine to write to the system messages data set+
               '
******************************************************************
*                                                                *
*        PUTLINE:                                                *
*                                                                *
*        Subroutine to write a message to the system messages    *
*        data set.                                               *
*                                                                *
*        R0  = (at entry) Length of line to be printed.          *
*        R1  = (at entry) Address of line to be printed.         *
*        R12 = OS Linkage Control Table.                         *
*        R7  = Subroutine return address.                        *
*                                                                *
*        Workregs = R0, R1, R14, R15.                            *
*                                                                *
******************************************************************
         SPACE 1
PUTLINE  DS    0H                  Call IEFYS to write line
         ST    R1,36(,R12)         Set print line address in LCT
         STH   R0,42(,R12)         Place length in LCT
         L     R15,VIEFYS          Get IEFYS addr
         BALR  R14,R15             Go put line
**       LINK  EP=IEFYS            Go put line
         BR    R7                  Return to caller
         EJECT
         TITLE '    Constants, literals and equates'
******************************************************************
*                                                                *
*        Constants, literals and equates.                        *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Pointers to constant data not directly supported        *
*        by the program base register.                           *
*----------------------------------------------------------------*
ABLANKS  DC    A(BLANKS)           Address of blank line
ASTARS   DC    A(STARS)            Address of "*" line
ADOTS    DC    A(DOTS)             Address of "...." line
ABASEL   DC    A(BASELINE)         ADDRESS OF '*   *' LINE
ATRCOLON DC    A(TRCOLON)          Address of ":" to "." table
ATRTBLNK DC    A(TRTBLNK)          Address of table to find blank
AMHDATA  DC    A(MHDATA)           Address of model heading line
ASTEPHDR DC    A(STEPHDR)          Address of step header line
AJOBHDR  DC    A(JOBHDR)           Address of job header line
AEXCPHDR DC    A(EXCPHDR)          ADDRESS OF EXCP HEADER LINE
ASTEPLN1 DC    A(MSTEPLN1)         Address of model step line 1
ASTEPLN2 DC    A(MSTEPLN2)         Address of model step line 2
ASTEPLN3 DC    A(MSTEPLN3)         Address of model step line 3
ASTEPLN4 DC    A(MSTEPLN4)         Address of model step line 4
ASTEPXCL DC    A(STEPXCOL)         Address of EXCP column headers
AJOBLN1  DC    A(MJOBLN1)          Address of model job line 1
AJOBLN2  DC    A(MJOBLN2)          Address of model job line 2
AJOBLN3  DC    A(MJOBLN3)          Address of model job line 3
         SPACE 1
VIEFYS   DC    V(IEFYS)            Address of message writer routine
ONEDAY   DC    A(24*60*60*100)     One day in hundredths of seconds
         SPACE 1
*----------------------------------------------------------------*
*        Substitution text for step end WTO.                     *
*----------------------------------------------------------------*
KET      DC    C'ET='              "ELAPSED" text
KABEND   DC    C'ABEND='           "ABEND" text
KRC      DC    C'RC='              "RC=" text
KFLUSHED DC    C'FLUSHED'          "FLUSHED" text
         SPACE 1
ROUT2    DC    XL4'04004000'       DESC=6,ROUTCDE=2
ROUTX    DC    AL1(WPLDESCF,0,WPLROUTB,0)
HEXTRAN  DC    C'0123456789ABCDEF' Hex-to-character translate tbl
EDITMSKA DC    X'40202020202020202120'
HDCOND   DC    CL17'  CONDITION CODE '       Step hdr for rc
HDABNDS  DC    CL17'COMPLETION CODE S'       Step hdr for system cc
HDABNDU  DC    CL17'COMPLETION CODE U'       Step hdr for user cc
HDFLUSH  DC    CL21'     STEP WAS FLUSHED'   Step hdr for flushed
         SPACE 1
*----------------------------------------------------------------*
*        Edit mask for EDMKRTN subroutine.                       *
*----------------------------------------------------------------*
EDMKMASK DS    0XL20               Edit mask for EDMKRTN
         DC    CL5'-----'          Pad character and constants
         DC    13X'20'             Nonsignificant digits
         DC    XL2'2120'           Force last digit significant
         SPACE 1
*----------------------------------------------------------------*
*        Some useful equates.                                    *
*----------------------------------------------------------------*
COLON    EQU   C':'
F0       EQU   X'F0'
DOT      EQU   C'.'
         EJECT ,
*----------------------------------------------------------------*
*        Literal pool.                                           *
*----------------------------------------------------------------*
         LTORG ,                   Literal pool
         EJECT ,
******************************************************************
*                                                                *
*        Constants unsupported by the base registers.            *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        A line of blanks.                                       *
*----------------------------------------------------------------*
BLANKS   DC    CL132' '            A line of blanks
         SPACE 1
*----------------------------------------------------------------*
*        "****" line for statistics box.                         *
*----------------------------------------------------------------*
STARS    DS    0CL132              Line of asterisks
         DC    132C'*'
         SPACE 1
*----------------------------------------------------------------*
*        "*..*" line for statistics box.                         *
*----------------------------------------------------------------*
DOTS     DS    0CL132              Line of periods
         DC    CL1'*'
         DC    130C'.'
         DC    CL1'*'
         SPACE 1
*----------------------------------------------------------------*
*        "*  *" line for statistics box.                         *
*----------------------------------------------------------------*
BASELINE DS    0CL132              Base '*   *' line
         DC    CL1'*'
         DC    130C' '
         DC    CL1'*'
         SPACE 1
*----------------------------------------------------------------*
*        Translate table for finding end of jobname/stepname.    *
*----------------------------------------------------------------*
TRTBLNK  DS    0XL256
         DC    XL(C' ')'00'
         DC    C' '
         DC    XL(L'TRTBLNK-(*-TRTBLNK))'00'
         SPACE 1
*----------------------------------------------------------------*
*        Translate table to convert all ":" in STEPEND WTO       *
*        elapsed time to ".".                                    *
*----------------------------------------------------------------*
         DS    0F
TRCOLON  DS    0XL256
         DC    (C':')AL1(*-TRCOLON)
         DC    C'.'
         DC    (L'TRCOLON-(*-TRCOLON))AL1(*-TRCOLON)
         EJECT ,
******************************************************************
*                                                                *
*        Model common heading line data.                         *
*                                                                *
******************************************************************
         SPACE 1
MHDATAX  DS    0C                  Data for heading line
         DC    CL1' '
         DC    C'OS/VS1 RELEASE '
MHOSREL  DS    CL2                 OS/VS1 release
         DC    CL1'.'
MHOSMOD  DS    CL2                 OS/VS1 modification
         DC    C'    SYSTEM '
MHSID    DS    CL4                 SMF system ID
         DC    CL1' '
MHDATA   EQU   MHDATAX,*-MHDATAX   Alias with length
         EJECT ,
******************************************************************
*                                                                *
*        Step end and job end statistics header lines.           *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        "STEP END STATISTICS" header line.                      *
*----------------------------------------------------------------*
STEPHDR  DS    0CL132              Step statistics header line
         DC    CL1'*'
         DC    CL52' '
         DC    CL25'<==STEP END STATISTICS==>'
         DC    CL53' '
         DC    CL1'*'
         SPACE 1
*----------------------------------------------------------------*
*        "STEP EXCP STATISTICS" header line.                     *
*----------------------------------------------------------------*
EXCPHDR  DS    0CL132              EXCP statistics header line
         DC    CL1'*'
         DC    CL52' '
         DC    CL26'<==STEP EXCP STATISTICS==>'
         DC    CL52' '
         DC    CL1'*'
         SPACE 1
*----------------------------------------------------------------*
*        "JOB END STATISTICS" header line.                       *
*----------------------------------------------------------------*
JOBHDR   DS    0CL132              Job statistics header line
         DC    CL1'*'
         DC    CL53' '
         DC    CL24'<==JOB END STATISTICS==>'
         DC    CL53' '
         DC    CL1'*'
         EJECT ,
******************************************************************
*                                                                *
*        Model for step-end line 1.                              *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MSTEPLN1 DS    0CL132
         DC    CL1'*'
         DC    CL3' '
         DC    CL10'STEP NUM  '
MSTEPNO  DC    CL3' '             Step number
         DC    CL8' '
         DC    CL15'STEP INIT TIME '
MSINITTM DC    CL11'***********'   Step start time
         DC    CL3' '
         DC    CL15'ALLOC START    '
MS1ALCST DC    CL11' '             Allocation start time
         DC    CL3' '
MSADDRSP DC    CL4'TYPE'           ADDRSPC ("VIRT" or "REAL")
         DC    CL1' '
MKREGION DC    CL7'REGION '
MSREGION DC    CL9' '              Region
         DC    CL1'K'
         DC    CL26' '
         DC    CL1'*'
         DC    0S(L'MSTEPLN1-(*-MSTEPLN1))
MS1LEN   EQU   *-MSTEPLN1          Symbolic length of step line 1
         EJECT ,
******************************************************************
*                                                                *
*        Model for step-end line 2.                              *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MSTEPLN2 DS    0CL132
         DC    CL1'*'
         DC    CL3' '
         DC    CL10'STEP NAME '
MSTEPNM  DC    CL8'********'       Step name
         DC    CL3' '
         DC    CL15'STEP END TIME  '
MSENDTM  DC    CL11'***********'   Step end time
         DC    CL3'  '
         DC    CL15'PGM START TIME '
MS2PGMST DC    CL11' '             Problem program start time
         DC    CL3'  '
MKURB    DC    CL13'USER STORAGE '
MSURB    DC    CL8' '              User storage
         DC    CL1'K'
         DC    CL2' '
MSTEPCCH DC    CL17' '             Completion code header
MSTEPCON DC    CL4' '              Condition code/completion code
         DC    CL3' '
         DC    CL1'*'
         DC    0S(L'MSTEPLN2-(*-MSTEPLN2))
MS2LEN   EQU   *-MSTEPLN2          Symbolic length of step line 2
         EJECT ,
******************************************************************
*                                                                *
*        Model for step-end line 3.                              *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MSTEPLN3 DS    0CL132
         DC    CL1'*'
         DC    CL3' '
         DC    CL10'PSTP NAME '
MSPSTEPN DC    CL8'********'       Procstep name
         DC    CL3' '
         DC    CL15'ELAPSED TIME   '
MSELAPS  DC    CL11'***********'   Step elapsed time
         DC    CL3' '
         DC    CL11'STEP DPRTY '
MS3DPRTY DC    CL15' '             Step dispatching priority
         DC    CL3' '
MKPAGEIN DC    C'PAGE INS '
MSPAGEIN DC    C'-------------'
         DC    CL26' '
         DC    CL1'*'
         DC    0S(L'MSTEPLN3-(*-MSTEPLN3))
MS3LEN   EQU   *-MSTEPLN3          Symbolic length of step line 3
         EJECT ,
******************************************************************
*                                                                *
*        Model for step-end line 4.                              *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MSTEPLN4 DS    0CL132
         DC    CL1'*'
         DC    CL3' '
         DC    CL10'PGM NAME  '
MSPGMNM  DC    CL8'********'       Program name
         DC    CL3' '
         DC    CL15'STEP CPU TIME  '
MS4CPUTM DC    CL11'***********'   Step CPU time under TCBs
         DC    CL3' '
         DC    CL12'PROTECT KEY '
MS4PKEY  DC    CL14' '             Protect key
         DC    CL3' '
MKPAGEOU DC    C'PAGE OUTS '
MSPAGEOU DC    C'------------'
         DC    CL26' '
         DC    CL1'*'
         DC    0S(L'MSTEPLN4-(*-MSTEPLN4))
MS4LEN   EQU   *-MSTEPLN4          Symbolic length of step line 4
         EJECT ,
******************************************************************
*                                                                *
*        Model for step-end EXCP column header line.             *
*                                                                *
******************************************************************
         SPACE 1
STEPXCOL DS    0CL132              Step-end EXCP column headers
         DC    C'*'
MSXCOLFS EQU   *                   First EXCP column header
         DC    C'   UNIT     EXCP COUNT    '
SXCOLLEN EQU   *-MSXCOLFS          Symbolic length of each column
         DC    C'   UNIT     EXCP COUNT    '
         DC    C'   UNIT     EXCP COUNT    '
         DC    C'   UNIT     EXCP COUNT    '
         DC    C'   UNIT     EXCP COUNT    '
SXCOLNUM EQU   (*-MSXCOLFS)/SXCOLLEN   Number of EXCP columns
         DC    C'*'
         DC    0S(L'STEPXCOL-(*-STEPXCOL))
         EJECT ,
******************************************************************
*                                                                *
*        Model for job-end line 1.                               *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MJOBLN1  DS    0CL132              Model for job line 1
         DC    CL4'*   '
         DC    CL8'JOB NAME'
         DC    CL2' '
MJ1JNAME DC    CL8'********'       Job name
         DC    CL3' '
         DC    CL13'JOB READ TIME'
         DC    CL1' '
MJ1RDTM  DC    CL11'***********'   Time job entered system
         DC    CL3' '
         DC    CL13'JOB READ DATE'
         DC    CL1' '
MJ1RDDTJ DC    C'********'         Job read date in Julian
         DC    CL1' '
MJ1RDDTG DC    C'**********'       Job read date in Gregorian
         DC    CL1' '
MJ1RDDAY DC    CL9'*********'      Job read date in day of week
         DC    CL3' '
         DC    CL12'JOB CPU TIME'
         DC    CL6' '
MJ1TMTCB DC    CL11'***********'   Job CPU time under TCBs
         DC    CL4'   *'
         DC    0S(L'MJOBLN1-(*-MJOBLN1))
MJ1LEN   EQU   *-MJOBLN1           Symbolic length of job line 1
         EJECT
******************************************************************
*                                                                *
*        Model for job-end line 2.                               *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MJOBLN2  DS    0CL132              Model for job line 2
         DC    CL4'*   '
         DC    C'JOB CLASS'
         DC    CL1' '
MJ2CLS   DC    CL1' '              Job selection class
         DC    CL10' '
         DC    C'JOB INIT TIME'
         DC    CL1' '
MJ2INTM  DC    CL11'***********'   Time job was initiated
         DC    CL3' '
         DC    C'JOB INIT DATE'
         DC    CL1' '
MJ2INDTJ DC    C'********'         Job start date in Julian
         DC    CL1' '
MJ2INDTG DC    C'**********'       Job start date in Gregorian
         DC    CL1' '
MJ2INDAY DC    C'*********'        Job start date in day of week
         DC    CL3' '
         DC    C'JOB ELAPSED TIME'
         DC    CL2' '
MJ2TMELP DC    CL11'***********'   Total elapsed time of job
         DC    CL4'   *'
         DC    0S(L'MJOBLN2-(*-MJOBLN2))
MJ2LEN   EQU   *-MJOBLN2           Symbolic length of job line 2
         EJECT
******************************************************************
*                                                                *
*        Model for job-end line 3.                               *
*                                                                *
******************************************************************
         SPACE 1
         DS    0H                  Force halfword alignment
MJOBLN3  DS    0CL132              Model for job line 3
         DC    CL4'*   '
         DC    C'ACCOUNT'
         DC    CL3' '
MJ3ACCT  DC    C'********'         Job account number field 1
         DC    CL3' '
         DC    C'JOB END TIME'
         DC    CL2' '
MJ3ENTM  DC    C'***********'      Time job ended
         DC    CL3' '
         DC    C'JOB END DATE'
         DC    CL2' '
MJ3ENDTJ DC    C'********'         Job end date in Julian
         DC    CL1' '
MJ3ENDTG DC    C'**********'       Job end date in Gregorian
         DC    CL1' '
MJ3ENDAY DC    C'*********'        Job end date in day of week
         DC    CL3' '
**       DC    C'JOB PRIORITY'
**       DC    CL6' '
**3PRTY  DC    CL11' '             Job priority
         DC    CL13'JOB PRIORITY '
*                   1234567890123
MJ3PRTY  DC    CL16' '             Job priority
         DC    CL4'   *'
         DC    0S(L'MJOBLN3-(*-MJOBLN3))
MJ3LEN   EQU   *-MJOBLN3           Symbolic length of job line 3
         TITLE '    OS Communications Vector Table (CVT)'
******************************************************************
*                                                                *
*        OS Communications Vector Table (CVT).                   *
*                                                                *
******************************************************************
         SPACE 1
         CVT   DSECT=YES,PREFIX=YES,SYS=AOS1
         TITLE '    OS Linkage Control Table (LCT)'
******************************************************************
*                                                                *
*        OS Linkage Control Table (LCT).                         *
*                                                                *
******************************************************************
         SPACE 1
LCT      DSECT ,
         IEFALLCT ,
         TITLE '    OS Job Control Table (JCT)'
******************************************************************
*                                                                *
*        OS Job Control Table (JCT).                             *
*                                                                *
******************************************************************
         SPACE 1
JCT      DSECT ,
         IEFAJCTB ,
         TITLE '    OS Step Control Table (SCT)'
******************************************************************
*                                                                *
*        OS Step Control Table (SCT).                            *
*                                                                *
******************************************************************
         SPACE 1
SCT      DSECT ,
         IEFASCTB ,
         TITLE '    SMF Common Exit Parameter Area (CEPA, JMR)'
******************************************************************
*                                                                *
*        SMF Common Exit Parameter Area (CEPA, JMR).             *
*                                                                *
******************************************************************
         SPACE 1
         IEFJMR ,
         TITLE '    OS WTO Parameter List (WPL)'
******************************************************************
*                                                                *
*        OS WTO Parameter List (WPL).                            *
*                                                                *
******************************************************************
         SPACE 1
         IEZWPL DSECT=YES
         TITLE '    SMF Type 4 and Type 5 Records'
******************************************************************
*                                                                *
*        SMF record mappings.                                    *
*                                                                *
******************************************************************
         SPACE 1
         PUSH  PRINT
         PRINT GEN
SMFRCD   DSECT ,
         IFASMFR 4                 Map SMF type 4 record
         SPACE 1
*----------------------------------------------------------------*
*        Equates for bits defined in first byte of SMF4RIN.      *
*----------------------------------------------------------------*
SMF4VQR  EQU   X'01'               -- V=R step
         SPACE 1
*----------------------------------------------------------------*
*        Equates for bits defined in SMF4STI.                    *
*----------------------------------------------------------------*
SMF4SAB  EQU   X'80'               -- Reserved
SMF4UJV  EQU   X'40'               -- Cancelled at exit IEFUJV
SMF4UJI  EQU   X'20'               -- Cancelled at exit IEFUJI
SMF4USI  EQU   X'10'               -- Cancelled at exit IEFUSI
SMF4TRT  EQU   X'08'               -- Cancelled at exit IEFACTRT
SMF4SRS  EQU   X'04'               -- Step is to be restarted
SMF4ABD  EQU   X'02'               -- Step abended
SMF4FLH  EQU   X'01'               -- Step was flushed
         EJECT ,
         ORG   SMFRCD              Reset location counter
         IFASMFR 5                 Map SMF type 5 record
         ORG   ,                   Restore highest location counter
         POP   PRINT
         TITLE '    DSECTs'
******************************************************************
*                                                                *
*        Getmained work area.                                    *
*                                                                *
******************************************************************
         SPACE 1
WORKA    DSECT ,                   Start of dynamic work area
SAVEA    DS    18F                 Program save area
ELAPSAV  DS    18F                 ELAPSPAN subroutine save area   @D03
DWORK    DS    D                   Doubleword work area
XJOBNM   DS    CL8                 Job name
XSTEPNM  DS    CL8                 Step name
XPSTEPNM DS    CL8                 Procedure step name
TIME     DS    F                   Time work area
TIMEND   DS    F                   Time work area
DATE     DS    F                   Date work area
DATEND   DS    F                   Date work area
         SPACE 1
FLAG1    DS    XL1                 Miscellaneous flags
F1EXCPHD EQU   X'80'               -- EXCP header has been done
         EJECT ,
******************************************************************
*                                                                *
*        Work area for EDMKRTN subroutine.  The equates are      *
*        defined with the offsets and lengths necessary to       *
*        move edited fields to their appropriate place in        *
*        an output line.                                         *
*                                                                *
******************************************************************
         SPACE 1
EDMKWORK DS    CL20                Work area for EDMKRTN editing
         SPACE 1
EPAGEIN  EQU   EDMKWORK+7,13       Nonswap nonVIO pageins
EPAGEOUT EQU   EDMKWORK+8,12       Nonswap nonVIO pageouts
EREGION  EQU   EDMKWORK+11,9       Region requested
EURB     EQU   EDMKWORK+12,8       User storage used
EPRTY    EQU   EDMKWORK+4,16       Job selection priority
EDPRTY   EQU   EDMKWORK+5,15       Step dispatching priority
EPKEY    EQU   EDMKWORK+6,14       Protect key
         EJECT ,
******************************************************************
*                                                                *
*        Area for step-end WTO.                                  *
*                                                                *
******************************************************************
* STEP: JJJJJJJJ PPPPPPPP SSSSSSSS ET=00.00.28 ABEND=U4095
         SPACE 1
SWTO     DS    0F                  Area for step-end WTO
SWLEN    DS    AL2(SWTOLEN)        Length of WTO
SWMCSFLG DS    0AL2                Mcsflags
SWMCSF1  DS    AL1                 Mcsflags byte 1
SWMCSA   EQU   X'80'               ...Routing/desc codes exist
SWMCSF2  DS    AL1                 Mcsflags byte 2
SWTEXT   DS    0CL56               Text of message
SWHDR    DS    CL5'STEP:'          "STEP:"
         DS    CL1
SWJOBN   DS    CL8                 Jobname
         DS    CL1
SWSTEPN  DS    CL8                 Procstep name
         DS    CL1
SWPSTEPN DS    CL8                 Stepname
         DS    CL1
SWELAPH  DS    CL3'ET='            Elapsed time keyword
SWELAP   DS    CL8                 Step elapsed time HH.MM.SS
SWSTARS  EQU   SWELAPH,*-SWELAPH   "*****" if step was flushed
         DS    CL1
SWABNDH  DS    CL6'ABEND='         "ABEND=" header
SWABND   DS    CL5                 Completion code
SWTOLEN3 EQU   *-SWTO              Symbolic length with "ABEND="
         ORG   SWABNDH
SWFLUSH  DS    CL7'FLUSHED'        "FLUSHED"
SWTOLEN2 EQU   *-SWTO              Symbolic length with "FLUSHED"
         ORG   SWABNDH
SWRCH    DS    CL3'RC='            "RC=" header
SWRC     DS    CL4                 Condition code
SWTOLEN1 EQU   *-SWTO              Symbolic length with "RC="
         ORG   ,
SWTOLEN  EQU   *-SWTO              Symbolic length for WTO
SWRTDESC DS    CL4                 Area for rout/desc codes
         ORG   ,
         EJECT ,
******************************************************************
*                                                                *
*        Mapping of common heading line.  This line is           *
*        printed at the start of both stepend and jobend         *
*        statistics information boxes.                           *
*                                                                *
******************************************************************
         SPACE 1
HDR      DS    CL132
HDATA    EQU   HDR+((L'HDR-L'MHDATA)/2),L'MHDATA,C'C'
HOSREL   EQU   HDATA+MHOSREL-MHDATA,L'MHOSREL,C'C'                     +
                                   OS/VS1 release
HOSMOD   EQU   HDATA+MHOSMOD-MHDATA,L'MHOSMOD,C'C'                     +
                                   OS/VS1 modification
HSID     EQU   HDATA+MHSID-MHDATA,L'MHSID,C'C'                         +
                                   SMF system ID
         EJECT ,
******************************************************************
*                                                                *
*        Mapping of step-end line 1.                             *
*                                                                *
******************************************************************
         SPACE 1
STEPLN1  DS    CL132               Mapping of step-end line 1
STEPNO   EQU   STEPLN1+MSTEPNO-MSTEPLN1,L'MSTEPNO,C'C'                 +
                                   Step number
SINITTM  EQU   STEPLN1+MSINITTM-MSTEPLN1,L'MSINITTM,C'C'               +
                                   Step start time
S1ALCST  EQU   STEPLN1+MS1ALCST-MSTEPLN1,L'MS1ALCST,C'C'               +
                                   Allocation start time
SADDRSPC EQU   STEPLN1+MSADDRSP-MSTEPLN1,L'MSADDRSP,C'C'               +
                                   Addrspc ("VIRT" or "REAL")
SREGION  EQU   STEPLN1+MSREGION-MSTEPLN1,L'MSREGION,C'C'               +
                                   Region requested
         EJECT
******************************************************************
*                                                                *
*        Mapping of step-end line 2.                             *
*                                                                *
******************************************************************
         SPACE 1
STEPLN2  DS    CL132               Mapping of step-end line 2
STEPNM   EQU   STEPLN2+MSTEPNM-MSTEPLN2,L'MSTEPNM,C'C'                 +
                                   Step name
SENDTM   EQU   STEPLN2+MSENDTM-MSTEPLN2,L'MSENDTM,C'C'                 +
                                   Step end time
S2PGMST  EQU   STEPLN2+MS2PGMST-MSTEPLN2,L'MS2PGMST,C'C'               +
                                   Problem program start time
SURB     EQU   STEPLN2+MSURB-MSTEPLN2,L'MSURB,C'C'                     +
                                   User storage
STEPCCH  EQU   STEPLN2+MSTEPCCH-MSTEPLN2,21,C'C'                       +
                                   Completion code information
STEPCCHD EQU   STEPLN2+MSTEPCCH-MSTEPLN2,L'MSTEPCCH,C'C'               +
                                   Completion code header
STEPCOND EQU   STEPLN2+MSTEPCON-MSTEPLN2,L'MSTEPCON,C'C'               +
                                   Condition code/completion code
         EJECT
******************************************************************
*                                                                *
*        Mapping of step-end line 3.                             *
*                                                                *
******************************************************************
         SPACE 1
STEPLN3  DS    CL132               Mapping of step-end line 3
SPSTEPNM EQU   STEPLN3+MSPSTEPN-MSTEPLN3,L'MSPSTEPN,C'C'               +
                                   Procstep name
SELAPS   EQU   STEPLN3+MSELAPS-MSTEPLN3,L'MSELAPS,C'C'                 +
                                   Step elapsed time
S3DPRTY  EQU   STEPLN3+MS3DPRTY-MSTEPLN3,L'MS3DPRTY,C'C'               +
                                   Step dispatching priority
SPAGEIN  EQU   STEPLN3+MSPAGEIN-MSTEPLN3,L'MSPAGEIN,C'C'               +
                                   Nonswap nonVIO pageins
         EJECT
******************************************************************
*                                                                *
*        Mapping of step-end line 4.                             *
*                                                                *
******************************************************************
         SPACE 1
STEPLN4  DS    CL132               Mapping of step-end line 4
SPGMNM   EQU   STEPLN4+MSPGMNM-MSTEPLN4,L'MSPGMNM,C'C'                 +
                                   Program name
S4CPUTM  EQU   STEPLN4+MS4CPUTM-MSTEPLN4,L'MS4CPUTM,C'C'               +
                                   Step CPU time under TCBs
S4PKEY   EQU   STEPLN4+MS4PKEY-MSTEPLN4,L'MS4PKEY,C'C'                 +
                                   Protect key
SPAGEOUT EQU   STEPLN4+MSPAGEOU-MSTEPLN4,L'MSPAGEOU,C'C'               +
                                   Nonswap nonVIO pageouts
         EJECT ,
******************************************************************
*                                                                *
*        Mapping of step-end EXCP column headings.               *
*                                                                *
******************************************************************
         SPACE 1
SXCOL    DS    CL132               Step-end EXCP column headers
SXCOLFST EQU   SXCOL+(MSXCOLFS-STEPXCOL)  First column header
         EJECT
***********************************************************************
*                                                                     *
*        Mapping of job-end line 1.                                   *
*                                                                     *
***********************************************************************
         SPACE 1
JOBLN1   DS    CL132               Job end line 1
JNM      EQU   JOBLN1+MJ1JNAME-MJOBLN1,L'MJ1JNAME,C'C'                 +
                                   Job name
JRDTM    EQU   JOBLN1+MJ1RDTM-MJOBLN1,L'MJ1RDTM,C'C'                   +
                                   Job time on reader HH:MM:SS.TH
JRDDT    EQU   JOBLN1+MJ1RDDTJ-MJOBLN1,L'MJ1RDDTJ,C'C'                 +
                                   Job date on reader Julian
JRDDTC   EQU   JOBLN1+MJ1RDDTG-MJOBLN1,L'MJ1RDDTG,C'C'                 +
                                   Job date on reader Gregorian
JRDDAY   EQU   JOBLN1+MJ1RDDAY-MJOBLN1,L'MJ1RDDAY,C'C'                 +
                                   Job date on reader day of week
JCPUTM   EQU   JOBLN1+MJ1TMTCB-MJOBLN1,L'MJ1TMTCB,C'C'                 +
                                   Job CPU time under TCBs
         EJECT ,
***********************************************************************
*                                                                     *
*        Mapping of job-end line 2.                                   *
*                                                                     *
***********************************************************************
         SPACE 1
JOBLN2   DS    CL132               Job end line 2
JCLASS   EQU   JOBLN2+MJ2CLS-MJOBLN2,L'MJ2CLS,C'C'                     +
                                   Job class
JINITTM  EQU   JOBLN2+MJ2INTM-MJOBLN2,L'MJ2INTM,C'C'                   +
                                   Job initiation time HH:MM:SS.TH
JINITDT  EQU   JOBLN2+MJ2INDTJ-MJOBLN2,L'MJ2INDTJ,C'C'                 +
                                   Job initiation date in Julian
JINITDTC EQU   JOBLN2+MJ2INDTG-MJOBLN2,L'MJ2INDTG,C'C'                 +
                                   Job initiation date in Gregorian
JINITDAY EQU   JOBLN2+MJ2INDAY-MJOBLN2,L'MJ2INDAY,C'C'                 +
                                   Job start date day of week
JELAPSTM EQU   JOBLN2+MJ2TMELP-MJOBLN2,L'MJ2TMELP,C'C'                 +
                                   Job elapsed time HH:MM:SS.TH
         EJECT ,
***********************************************************************
*                                                                     *
*        Mapping of job-end line 3.                                   *
*                                                                     *
***********************************************************************
         SPACE 1
JOBLN3   DS    CL132               Job end line 3
J3ACCT   EQU   JOBLN3+MJ3ACCT-MJOBLN3,L'MJ3ACCT,C'C'                   +
                                   Job account number field 1
JENDTM   EQU   JOBLN3+MJ3ENTM-MJOBLN3,L'MJ3ENTM,C'C'                   +
                                   Job end time HH:MM:SS.TH
JENDDT   EQU   JOBLN3+MJ3ENDTJ-MJOBLN3,L'MJ3ENDTJ,C'C'                 +
                                   Job end date in Julian
JENDDTC  EQU   JOBLN3+MJ3ENDTG-MJOBLN3,L'MJ3ENDTG,C'C'                 +
                                   Job end date in Gregorian
JENDDAY  EQU   JOBLN3+MJ3ENDAY-MJOBLN3,L'MJ3ENDAY,C'C'                 +
                                   Job end day of week
J3PRTY   EQU   JOBLN3+MJ3PRTY-MJOBLN3,L'MJ3PRTY,C'C'                   +
                                   Job priority
         EJECT ,
PRTLINE  DS    CL132
         EJECT
         DS    0D                  Force doubleword alignment
LWORKA   EQU   *-WORKA             Symbolic length of work area
         EJECT ,
***********************************************************************
*                                                                     *
*        Mapping of step-end EXCP counts line.                        *
*                                                                     *
***********************************************************************
         SPACE 1
SX       DSECT ,                   Mapping of EXCP count column
SXSEG    DS    0CL26               One EXCP count column
SUNIT    DS    CL4                 -- Device number
         DS    CL1                 -- Filler
SCOUNT   DS    CL14                -- Number of EXCPs to device
         DS    CL7                 -- Filler
         END   ,
??
//SMPCNTL  DD  *
 RECEIVE S(TX67308).
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67308) CHECK BYPASS(ID).
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67308) .
//

//*---- use the following steps for REJECT or RESTORE ------------- ***
//REJECT  EXEC SMP4
//SMPCNTL  DD  *
 REJECT  S(TX67308).
//
//RESTORE EXEC SMP4
//SMPCNTL  DD  *
 RESTORE S(TX67308).
//
