//TX67311  JOB  (1),TX67311,
//             COND=(0,NE),
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1)
//*
//* 2021/07/14 @KL TX67311
//*                Install IEFUIV
//*
//RECEIVE EXEC SMP4
//SMPPTFIN DD DATA,DLM='??'
++ USERMOD(TX67311)     /* REWORK(20210716) */             .
++ VER (X067)
   FMID(EBA1101)
 /*
   PROBLEM DESCRIPTION(S):
     TX67311 -
       Install IEFUIV SMF exit.

   COMPONENT:  5741-SC1B4-EBA1101

   APARS FIXED: TX67311

   SPECIAL CONDITIONS:
     DEPENDENCY:  This usermod can only be installed on a VS1
       system generated with SMF support.  For that to be the
       case, "SMF=FULL" (recommended) or "SMF=BASIC" must have
       been specified on the SCHEDULR stage 1 macro (the default
       for SMF is NOTSUPPLIED).

     DOCUMENTATION:  System message IEF100I added.

       Publication:  OS/VS1 System Messages
       Form Number:  GC38-1001

       Message IEF100I is added:

         IEF100I jjj ON READER ddd
         IEF100I jjj ON INTRDR

           Explanation:  A JOB statement has been detected in the
             input stream for job jjj.

             The first form of the message is issued when the new
             job has been read on real device ddd.

             The second form of the message is issued when the new
             job is encounted in an input stream being processed by
             the incore reader.

           System Action:  When the new job has been completely read,
             VS1 will place it on the input queue.

           Operator Response:  None

   COMMENTS:
     LAST CHANGE:  2021/07/16

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MODULES
       IEFUIV

     LISTEND
 */.
++ SRC      (IEFUIV  ) DISTLIB(ASAMPLIB) SYSLIB(SAMPLIB ).
IEFUIV   TITLE '    SMF input validation exit'
***********************************************************************
*                                                                     *
*                                                                     *
* Module name          =  IEFUIV                                      *
*                                                                     *
*                                                                     *
* Descriptive name     =  SMF input validation exit.                  *
*                                                                     *
*                                                                     *
* Function             =  To write IEF100I "job on reader"            *
*                         signon message to console for job           *
*                         being read.                                 *
*                                                                     *
*                                                                     *
* Notes                =  See below.                                  *
*                                                                     *
*   Dependencies       =  None.                                       *
*                                                                     *
*   Registers          =  See entry point documentation.              *
*                                                                     *
*   Patch space        =  None.                                       *
*                                                                     *
*                                                                     *
* Module type          =  CSECT                                       *
*                                                                     *
*   Processor          =  VS1 System Assembler                        *
*                                                                     *
*   Module size        =  See assembly listing.                       *
*                                                                     *
*   Attributes         =  Reentrant, task mode, enabled,              *
*                         supervisor state, key 0.                    *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
* Entry point          =  IEFUIV                                      *
*                                                                     *
*   Purpose            =  To write IEF100I "job on device"            *
*                         signon message to console for job           *
*                         being read.                                 *
*                                                                     *
*   Linkage            =  From JES reader IEFVMB.                     *
*                                                                     *
*   Input data         =  R1  = Address of 2-word parameter list:     *
*                  0        Word 1:  Address of CEPA                  *
*                  4        Word 2:  Address of 80-byte JOB card      *
*                                    image.  Note that IEFUIV         *
*                                    is called once for each JOB      *
*                                    card record.  The record         *
*                                    number being processed can       *
*                                    be determined by looking at      *
*                                    field JMRNLRD in the CEPA.       *
*                         R13 = Address of standard save area         *
*                         R14 = Return address                        *
*                         R15 = Entry point                           *
*                                                                     *
*   Registers saved    =  R0 - R15                                    *
*                                                                     *
*   Register usage     =  R0  = Work                                  *
*                         R1  = Work                                  *
*                         R2  = Work                                  *
*                         R3  = Address of CEPA                       *
*                         R4  = Unused                                *
*                         R5  = Unused                                *
*                         R6  = Unused                                *
*                         R7  = Unused                                *
*                         R8  = Unused                                *
*                         R9  = Unused                                *
*                         R10 = Unused                                *
*                         R11 = Unused                                *
*                         R12 = Program base register                 *
*                         R13 = Address of standard save area         *
*                         R14 = Work                                  *
*                         R15 = Work                                  *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
*   Registers restored =  R0 - R14                                    *
*                         R15 = Return code                           *
*                                 0: Allow job to continue            *
*                                 4: Cancel job                       *
*                                                                     *
*                                                                     *
* Exit (normal)        =  Return to caller via BR R14.                *
*   Conditions         =  Always.                                     *
*   Output             =  Message IEF100I with name of job and        *
*                         (if appropriate) reader device number       *
*                         written via WTO when first card of job      *
*                         is encountered.                             *
*   Return code        =  0                                           *
*                                                                     *
*                                                                     *
* Exit (error)         =  Return to caller via BR R14.                *
*   Conditions         =  Not used in this implementation.            *
*   Output             =  The job is to be cancelled.  VS1 will       *
*                         write msgIEF543I ddd RDR FLUSHING           *
*                         JOBSTREAM AFTER JOB jjj.                    *
*   Return code        =  4                                           *
*                                                                     *
*                                                                     *
* External references  =  See below.                                  *
*                                                                     *
*   Routines           =  None.                                       *
*                                                                     *
*   Control blocks     =  See table below:                            *
*                                                                     *
*    Name      Macro     Description                          Usage   *
*    ----      --------  -----------------------------------  -----   *
*    CEPA      IEFJMR    SMF Common Exit Parameter Area        R      *
*    CVT       CVT       OS Communications Vector Table        R      *
*    TCB       IKJTCB    OS Task Control Block                 R      *
*    TIOT      IEFTIOT1  OS Task Input/Output Table            R      *
*    UCB       IEFUCBOB  OS Unit Control Block                 R      *
*    WPL       IEZWPL    OS WTO Parameter List                 CWD    *
*                                                                     *
*   Key = R-Read, W-Write, C-Create, D-Delete                         *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
* Messages             =  The following messages are issued by        *
*                         this module:                                *
*                                                                     *
*                                                                     *
*    IEF100I jjj ON READER ddd                                        *
*                                                                     *
*      if the job is being read from a real device.                   *
*                                                                     *
*    IEF100I jjj ON INTRDR                                            *
*                                                                     *
*      if the job is being read by the incore reader.                 *
*                                                                     *
*      jjj                is the name of the job being read.          *
*                                                                     *
*      ddd                is the device number of the reader          *
*                         device.                                     *
*                                                                     *
*                                                                     *
* Macros               =  FREEMAIN, GETMAIN, RETURN, SAVE, WTO.       *
*                                                                     *
*                                                                     *
* Change activity      =                                              *
*                                                                     *
*   Flag  Date        By    Description                               *
*   ----  ----------  ----  ----------------------------------------  *
*   $D00  2021/05/20  @KL   Written for OS/VS1.                       *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
******************************************************************
*                                                                *
*        Start CSECT and define register equates.                *
*                                                                *
******************************************************************
         SPACE 1
IEFUIV   CSECT ,                   Begin control section
         SPACE 1
R0       EQU    0                  Work
R1       EQU    1                  Work
R2       EQU    2                  Work
R3       EQU    3                  Address of CEPA
R4       EQU    4                  Unused
R5       EQU    5                  Unused
R6       EQU    6                  Unused
R7       EQU    7                  Unused
R8       EQU    8                  Unused
R9       EQU    9                  Unused
R10      EQU   10                  Unused
R11      EQU   11                  Unused
R12      EQU   12                  Program base register
R13      EQU   13                  Address of save/work area
R14      EQU   14                  Work
R15      EQU   15                  Work
         EJECT ,
******************************************************************
*                                                                *
*        PROGINIT:                                               *
*                                                                *
*        Perform program initialization.  Test for               *
*        availability of SMF Common Exit Parameter Area (a       *
*        copy of the JMR) and bypass further processing if       *
*        one was not provided.  Also skip processing for any     *
*        JOB card continuation record, and if the job being      *
*        read is one with a name that makes it a "maintenance    *
*        job".                                                   *
*                                                                *
*        R1  = (At entry) Address of IEFUIV parm list.           *
*        R3  = Address of JMR - set in this routine.             *
*        R12 = Program base register - set in this routine.      *
*                                                                *
*        Workregs: None.                                         *
*                                                                *
******************************************************************
         SPACE 1
PROGINIT DS    0H                  Program initialization
         SAVE  (14,12),,           Save caller's registers             +
               IEFUIV-&SYSDATE-&SYSTIME-$D00
         LR    R12,R15             Set base register
         USING IEFUIV,R12          Addressability for program
         USING JMRJOBP,R1          Addressability for parm list
         L     R3,JMRJOBP          Point to CEPA
         LA    R3,0(,R3)           Clear high-order byte
         LTR   R3,R3               Have we got a CEPA?
         BZ    BYPASS              Quit now if not
         DROP  R1                  End parm list addressability
         USING JMR,R3              Addressability for CEPA
         CLC   =F'1',JMRNLRD       Is this the first JOB card?
         BNE   BYPASS              Skip processing if not
         CLC   =C'SY1',JMRJOB      Maintenance job?
         BE    BYPASS              Skip processing if so
         EJECT ,
******************************************************************
*                                                                *
*        GETWORK:                                                *
*                                                                *
*        We will process this job.  Get work area storage        *
*        and initialize it to zeroes.                            *
*                                                                *
*        R3  = Address of JMR - not referenced.                  *
*        R12 = Program base register - set in this routine.      *
*        R13 = Getmained work area - obtained in this routine.   *
*                                                                *
*        Workregs: R0, R2, R1, R14, R15.                         *
*                                                                *
******************************************************************
         SPACE 1
GETWORK  DS    0H                  Obtain and zero work storage
         LA    R0,LWORKA           Set length for getmain
         GETMAIN R,LV=(0)          Get work area storage
         LR    R2,R1               Save address of getmained area
         LR    R0,R1               Set address for MVCL
         LA    R1,LWORKA           Set length for MVCL
         XR    R15,R15             Set pad to zeroes
         MVCL  R0,R14              Zero work area
         LR    R15,R13             Save old save area address
         LR    R13,R2              Point to our save area
         USING WORKA,R13           Addressability for work area
         ST    R15,SAVEA+4         Chain
         ST    R13,8(,R15)          save areas
         EJECT ,
******************************************************************
*                                                                *
*        TESTDEV:                                                *
*                                                                *
*        Test reader device type field in JMR.  If zeroes,       *
*        assume this is incore reader.                           *
*                                                                *
*        R3  = Address of JMR.                                   *
*        R12 = Program base register.                            *
*        R13 = Getmained work area - not referenced.             *
*                                                                *
*        Workregs: None.                                         *
*                                                                *
******************************************************************
         SPACE 1
TESTDEV  DS    0H                  Test reader device type
         CLC   =X'0000',JMRRDR     Job on incore reader?
         BNE   DEVREAL             No, process job on real device
         EJECT ,
******************************************************************
*                                                                *
*        DEVICR:                                                 *
*                                                                *
*        Job is on incore reader.  Initalize model WPL for       *
*        incore reader "jjj ON INTRDR" version of IEF100I        *
*        signon message, and go to build it.                     *
*                                                                *
*        R2  = Set to zero to indicate no reader device number.  *
*        R3  = Address of JMR - not referenced.                  *
*        R12 = Program base register.                            *
*        R13 = Getmained work area.                              *
*                                                                *
*        Workregs: None.                                         *
*                                                                *
******************************************************************
         SPACE 1
DEVICR   DS    0H                  Device is incore reader
         MVC   WMS100B,MWMS100B    Copy model WPL
         XR    R2,R2               Show no device number
         B     BLDMSG              Go to build message
         EJECT ,
******************************************************************
*                                                                *
*        DEVREAL:                                                *
*                                                                *
*        Reader is a real device.  Find TIOT for this task.      *
*        Return to caller if one can't be found.                 *
*                                                                *
*        R3  = Address of JMR - not referenced.                  *
*        R12 = Program base register.                            *
*        R13 = Getmained work area - not referenced.             *
*                                                                *
*        Workregs: R15.                                          *
*                                                                *
******************************************************************
         SPACE 1
DEVREAL  DS    0H                  Find TIOT
         L     R15,CVTPTR          Point to CVT
         USING CVTMAP,R15          Addressability for CVT
         L     R15,CVTTCBP         Point to TCB head
         DROP  R15                 End CVT addressability
         L     R15,4(,R15)         Point to TCBOLD
         USING TCB,R15             Addressability for TCB
         L     R15,TCBTIO          Point to TIOT
         LTR   R15,R15             Good TIOT pointer?
         BZ    RETURN              Exit if not
         USING TIOT1,R15           Addressability for TIOT
         LA    R15,TIOENTRY        Point to first DD entry
         USING TIOENTRY,R15        Addressability for DD entry
         SPACE 1
*-----------------------------------------------------------------*
*        TIOT has been found.  Loop through TIOT DD entries       *
*        searching for the entry for IEFRDER.                     *
*-----------------------------------------------------------------*
DEVRLOOP DS    0H                  Loop through TIOT DD entries
         CLI   TIOELNGH,X'00'      End of TIOT?
         BE    RETURN              Exit if so
         CLC   TIOEDDNM,KIEFRDER   Entry for IEFRDER DD?
         BE    DEVRFND             Branch if entry for IEFRDER
         XR    R0,R0               Point to
         IC    R0,TIOELNGH          next DD entry
         AR    R15,R0                in TIOT
         B     DEVRLOOP            Back to look at it
         EJECT ,
******************************************************************
*                                                                *
*        DEVRFND:                                                *
*                                                                *
*        We have located the TIOT entry for IEFRDER.             *
*        Copy the model WPL for the "jjj ON READER"              *
*        version of the IEF100I message.  Get the                *
*        associated UCB address from the TIOT entry,             *
*        then load the EBCDIC device number from the             *
*        UCB into the three low-order bytes of R2.               *
*                                                                *
*        R2  = EBCDIC device number of reader device in          *
*              low-order three bytes.                            *
*        R3  = Address of JMR - not referenced.                  *
*        R12 = Program base register.                            *
*        R13 = Getmained work area - not referenced.             *
*                                                                *
*        Workregs: R15.                                          *
*                                                                *
******************************************************************
         SPACE 1
DEVRFND  DS    0H                  Found IEFRDER DD entry
         MVC   WMS100A,MWMS100A    Copy model "jjj ON READER" WPL
         L     R15,TIOEFSRT-1      Point to UCB
         USING UCBD,R15            Addressability for UCB
         TM    UCBATI,UCBHPDV      Is this HASP pseudodevice?
         BO    RETURN              Skip message if so
         ICM   R2,7,UCBNAME        Get reader device number
         DROP  R15                 End UCB addressability
         EJECT ,
******************************************************************
*                                                                *
*        BLDMSG:                                                 *
*                                                                *
*        Build the IEF100I signon message, adding job            *
*        name and (if appropriate) reader device number.         *
*                                                                *
*        R2  = EBCDIC device number of reader device in          *
*              low-order three bytes, or binary zeroes           *
*              if this is incore reader and we don't have        *
*              a device number.                                  *
*        R3  = Address of JMR.                                   *
*        R12 = Program base register.                            *
*        R13 = Getmained work area.                              *
*                                                                *
*        Workregs: None.                                         *
*                                                                *
******************************************************************
         SPACE 1
BLDMSG   DS    0H                  Build signon message
         MVC   W100JBNM(8),JMRJOB  Set job name in message
         LTR   R2,R2               Is there a device number?
         BZ    ISSUEMSG            No, go issue the message
         STCM  R2,7,W100DVNM       Set device number in message
         EJECT ,
******************************************************************
*                                                                *
*        ISSUEMSG:                                               *
*                                                                *
*        IEF100I signon message has beem built.  Issue it        *
*        via WTO.                                                *
*                                                                *
*        R3  = Address of JMR - not referenced.                  *
*        R12 = Program base register.                            *
*        R13 = Getmained work area.                              *
*                                                                *
*        Workregs: R0, R1, R14, R15.                             *
*                                                                *
******************************************************************
         SPACE 1
ISSUEMSG DS    0H                  Issue signon message
         WTO   MF=(E,WMS100)       Issue message
         EJECT ,
******************************************************************
*                                                                *
*        RETURN:                                                 *
*                                                                *
*        Free work area storage, restore caller's registers      *
*        and return.                                             *
*                                                                *
*        R3  = Address of JMR - not referenced.                  *
*        R12 = Program base register.                            *
*        R13 = Getmained work area - freed in this routine.      *
*                                                                *
*        Workregs: R0, R1, R14, R15.                             *
*                                                                *
******************************************************************
         SPACE 1
RETURN   DS    0H                  Return to caller
         LR    R1,R13              Set work area address for freemain
         LA    R0,LWORKA           Set work area length for freemain
         L     R13,SAVEA+4         Restore caller's save area address
         DROP  R13                 End work area addressability
         FREEMAIN R,LV=(0),A=(1)   Free work area storage
         RETURN (14,12),RC=0       Restore registers and return
         EJECT ,
******************************************************************
*                                                                *
*        BYPASS:                                                 *
*                                                                *
*        IEFUIV processing is being bypassed.  Ensure zero       *
*        is returned in R1 (not sure if this is required),       *
*        and return to caller with return code zero.             *
*                                                                *
*        R12 = Program base register.                            *
*        R13 = Address of caller's save area.                    *
*                                                                *
*        Workregs:  None.                                        *
*                                                                *
******************************************************************
         SPACE 1
BYPASS   DS    0H                  Bypass IEFUIV processing
         XR    R15,R15             Get a zero
         ST    R15,24(,R13)        Set caller's R1 to zero
         RETURN (14,12),RC=0       Restore registers and return
         EJECT ,
******************************************************************
*                                                                *
*        Constants and literals.                                 *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        Model WPL for "jjj ON READER ddd" version of            *
*        IEF100I signon message.                                 *
*----------------------------------------------------------------*
MWMS100A WTO   'IEF100I          ON READER    ',ROUTCDE=2,MF=L
LWMS100A EQU   *-MWMS100A          Symbolic length of WPL
         SPACE 1
*----------------------------------------------------------------*
*        Model WPL for "jjj ON INTRDR" version of IEF100I        *
*        signon message.                                         *
*----------------------------------------------------------------*
MWMS100B WTO   'IEF100I          ON INTRDR',ROUTCDE=2,MF=L
LWMS100B EQU   *-MWMS100B          Symbolic length of WPL
         SPACE 1
*----------------------------------------------------------------*
*        Compare for IEFRDER DD name.                            *
*----------------------------------------------------------------*
KIEFRDER DC    CL8'IEFRDER'        Compare for IEFRDER DD name
         SPACE 1
*----------------------------------------------------------------*
*        Generate literal pool.                                  *
*----------------------------------------------------------------*
         LTORG ,                   Literal pool
         EJECT ,
******************************************************************
*                                                                *
*        Getmained work area.                                    *
*                                                                *
******************************************************************
         SPACE 1
WORKA    DSECT ,                   Getmained work area
SAVEA    DS    18F                 Program save area
         SPACE 1
*----------------------------------------------------------------*
*        Area for "jjj ON READER ddd" version of IEF100I WPL.    *
*----------------------------------------------------------------*
         DS    0F
WMS100A  DS    CL(LWMS100A)        Area for IEF100I WPL
         SPACE 1
*----------------------------------------------------------------*
*        Remap message area for "jjj ON INTRDR" version          *
*        of IEF100I WPL.                                         *
*----------------------------------------------------------------*
         ORG   WMS100A             Remap WPL area
WMS100B  DS    CL(LWMS100B)        Area for incore reader WPL
         ORG   ,                   Restore location counter
         SPACE 1
*----------------------------------------------------------------*
*        Alias for entire IEF100I WPL area with fields           *
*        for insertion of variable information.                  *
*----------------------------------------------------------------*
WMS100   EQU   WMS100A,*-WMS100A   Alias for entire message area
W100JBNM EQU   WMS100+4+8          Job name in message IEF100I
W100DVNM EQU   WMS100+4+27         Device number in message IEF100I
         SPACE 1
         DS    0D                  Force doubleword alignment
LWORKA   EQU   *-WORKA             Symbolic length of work area
         EJECT ,
******************************************************************
*                                                                *
*        OS Communications Vector Table (CVT).                   *
*                                                                *
******************************************************************
         SPACE 1
CVTPTR   EQU   16 -          ABSOLUTE ADDRESS OF POINTER TO CVT
CVT      DSECT ,                   Map selected CVT fields
CVTMAP   EQU   * -           CVTPTR CONTENT POINTS HERE
CVTTCBP  EQU   CVT+0,4,C'F'  Address of TCB words
CVTLINK  EQU   CVT+8,4,C'F'  ADDRESS OF DCB FOR SYS1.LINKLIB DATA SET
         EJECT ,
******************************************************************
*                                                                *
*        OS Job Management Record (JMR).                         *
*                                                                *
******************************************************************
         SPACE 1
*        IEFJMR ,
JMR      DSECT ,
JMRJOB   DS    8C            JOB NAME   EBCDIC
JMRENTRY DS    F             JOB ENTRY TIME IN 1/100 SEC
JMREDATE DS    F             ENTRY DATE 00YYDDDF
JMRCPUID DS    4C            CPU-ID AND MDL FROM SMCA
JMRUSEID DS    8C            USER ID
JMRSTEP  DS    C             STEP NUMBER
JMRLGEND EQU   *
JMRLOGSZ EQU   JMRLGEND-JMRJOB  SIZE OF JOB LOG COPIED TO DSB
*
JMROPT   DS    X             OPTION SWITCHES
JMRJOBSW EQU   X'80'         JOB FCTN REQUESTED
JMRSTPSW EQU   X'40'         STEP FCTN REQUESTED
JMREXITS EQU   X'20'         USER EXITS REQUESTED
JMRXONLY EQU   X'10'         EXITS ONLY SPECIFIED
*
         DS    2C            RESERVED
JMRUCOM  DS    F             USER COMMUNICATION INITIALIZED 0(NOT
*                            USED BY THE SYSTEM)
JMRTNRDR DS    F             REAL TIME IN THE ISC
JMRNLRD  DS    F             NUMBER OF LINES READ
JMRJPR   DS    CL2           JOB PRIORIYTY
JMRJOBC  DS    CL2           JOB CLASSES
JMRTNPR  DS    F             REAL TIME FOR PRINT PROCESS
JMRLPR   DS    F             NUMBER OF LINES PRINTED
JMRTNPU  DS    F             REAL TIME FOR PUNCH PROCESS
JMRLNPU  DS    F             NUMBER OF LINES PUNCHED
JMRTNT   DS    F             REAL TIME FOR TAPE PROCESS
JMRLWT   DS    F             NUMBER OF LINES WRITTEN TO TAPE
JMRUJVP  DS    F             ADDRESS OF IEFUJV/PTR TO SYS1.MAN RECORD
JMRSIZE  EQU   *-JMRJOB      SIZE OF JMR IN PQA(72 BYTES)
*
*
JMRDRSTP DS    2F            ISC STOP TIME AND DATE
JMRJOBIN DS    F             JOB SYSIN COUNT
JMRRDR   DS    2C            ISC DEVICE TYPE AND CLASS
         DS    2C            RESERVED
JMRSYSOC DS    5C            SYSOUT CLASSES
*
*   THE FOLLOWING INFORMATION WILL BE PASSED TO IEFUJV IN R/I
*
JMRJCLCD DS    C             JCL VERB CODE
         DS    2C             RESERVED
JMRJOBP  DS    F             PTR TO JOB LOG
JMRJCLP  DS    F             PTR TO JCL CARD
JMRJCLCP DS    F             PTR TO JCL CODE
JMRPTRS  EQU   JMRJOBP
JMRPTOFS DS    F             PTR TO OPERAND OFFSET
JMRRESID DS    CL7                     RES USER ID
JMRRESRV DS    CL1                     RES RESERVED
         EJECT ,
******************************************************************
*                                                                *
*        Map selected UCB fields.                                *
*                                                                *
******************************************************************
         SPACE 1
UCBD     DSECT ,                   Map the UCB
*        IEFUCBOB ,
         DS    XL13                    Filler
UCBNAME  DS    CL3 -                   UNIT NAME (EBCDIC)
         ORG   UCBD+11
UCBATI   DS    FL1 -                   INDEX TO THE ATTENTION TABLE
UCBHPDV  EQU   X'01' -                 OPTIONAL JOB ENTRY SUBSYSTEM
*                                      (JES) PSEUDO-DEVICE
         EJECT ,
******************************************************************
*                                                                *
*        Map the TIOT.                                           *
*                                                                *
******************************************************************
         SPACE 1
TIOT     DSECT ,                   Map the TIOT
*        IEFTIOT1 ,
         DS    0F
TIOT1    EQU   * -            TIOTPTR
TIOCNJOB DS    CL8  -         JOB NAME
TIOCSTEP DS    CL16 -         FOR A JOB STEP THAT IS NOT A PROCEDURE
*                             STEP, 8-BYTE JOB STEP NAME AND 8 RESERVED
*                             BYTES.  FOR A JOB STEP THAT IS A
*                             PROCEDURE STEP, 8-BYTE PROCEDURE STEP
*                             NAME AND 8-BYTE JOB STEP NAME OF THE JOB
*                             STEP THAT CALLED THE PROCEDURE.
         SPACE 1
TIOENTRY EQU   * -            TIODDPTR
TIOELNGH DS    FL1 -          LENGTH, IN BYTES, OF THIS ENTRY
*                             (INCLUDING ALL DEVICE ENTRIES)
TIOESTTA DS    B -            STATUS BYTE A
TIOSLTYP EQU   X'80' -        NONSTANDARD LABEL (TAPE)
TIOSPLTP EQU   X'40' -        DURING ALLOCATION, SPLIT CYLINDER
*                             PRIMARY.  (THIS IS THE FIRST DD ENTRY FOR
*                             A SPLIT CYLINDER.)
*                             DURING STEP TERMINATION, NO UNALLOCATION
*                             NECESSARY.
TIOSPLTS EQU   X'20' -        DURING ALLOCATION, SPLIT CYLINDER
*                             SECONDARY.  (THIS IS NOT THE FIRST DD
*                             ENTRY FOR A SPLIT CYLINDER.)
*                             DURING STEP TERMINATION, REWIND BUT NO
*                             UNLOADING.
TIOSJBLB EQU   X'10' -        JOBLIB INDICATOR
TIOSDADS EQU   X'08' -        DADSM ALLOCATION NECESSRY
TIOSLABL EQU   X'04' -        LABELED TAPE.  IF BIT 0 IS OFF, SL OR
*                             SUL.  IF BIT 0 IS ALSO ON, AL OR AUL.
TIOSDSP1 EQU   X'02' -        REWIND/UNLOAD THE TAPE VOLUME (TAPE)
*                             PRIVATE VOLUME (DIRECT ACCESS)     MDC001
TIOSDSP2 EQU   X'01' -        REWIND THE TAPE VOLUME (TAPE)
*                             PUBLIC VOLUME (DIRECT ACCESS)      MDC002
TIOERLOC DS    0CL2 -         - -                              @X70PEBA
TIOEWTCT DS    CL1 -          DURING ALLOCATION, NUMBER OF DEVICES
*                             REQUESTED FOR THIS DATA SET
TIOSFSNA EQU   X'80'          FAST-START NOT ALLOCATED         @X70PEBA
TIOSFSNU EQU   X'40'          FAST-START NO UCB ADR.           @X70PEBA
*                                                              @X70PEBA
TIOELINK DS    CL1 -          DURING ALLOCATION, LINK TO THE
*                             APPROPRIATE PRIME SPLIT, UNIT AFFINITY,
*                             VOLUME AFFINITY OR SUBALLOCATE TIOT
*                             ENTRY.  AFTER ALLOCATION, FLAG BYTE.
TIOSYOUT EQU   X'80' -        THIS IS A SYSOUT DATA SET THAT CONTAINS
*                             DATA (AFTER CLOSE)
TIOTSSDS EQU   X'40' -        SUBSYSTEM DATA SET (OS/VS1)
*                             (MDC300)                         @M06SP9A
TIOTTERM EQU   X'20' -        DEVICE IS A TERMINAL
TIOEDYNM EQU   X'10' -        DYNAM CODED ON DD STATEMENT
TIOEQNAM EQU   X'08' -        QNAME CODED ON DD STATEMENT
TIOESYIN EQU   X'04' -        ENTRY FOR SPOOLED SYSIN DATA SET
*                             (OS/VS1)                           MDC003
TIOESYOT EQU   X'02' -        ENTRY FOR SPOOLED SYSOUT DATA SET
*                             (OS/VS1)                           MDC004
TIOESSDS EQU   X'02' -        ENTRY FOR A SUBSYSTEM DATA SET
*                             (OS/VS2)                           MDC005
TIOTREM  EQU   X'01' -        ENTRY FOR A REMOTE DEVICE          ICB340
TIOEDDNM DS    CL8 -          DD NAME
TIOEJFCB DS    CL3 -          RELATIVE TRACK ADDRESS (TTR) OF THE JFCB.
*                             (DURING ALLOCATION, TTR OF THE SIOT IF
*                             SUBALLOCATE WAS REQUESTED.)
TIOESTTC DS    B -            STATUS BYTE C.  USED DURING ALLOCATION
*                             ONLY.  SET TO ZEROS AT END OF ALLOCATION.
TIOSDKCR EQU   X'80' -        MAIN STORAGE OR DASD ADDRESS
TIOSDEFR EQU   X'40' -        DEFERRED MOUNT
TIOSAFFP EQU   X'20' -        PRIMARY UNIT AFFINITY
TIOSAFFS EQU   X'10' -        SECONDARY UNIT AFFINITY
TIOSVOLP EQU   X'08' -        PRIMARY VOLUME AFFINITY
TIOSVOLS EQU   X'04' -        SECONDARY VOLUME AFFINITY
TIOSBALP EQU   X'02' -        PRIMARY SUBALLOCATE
TIOSBALS EQU   X'01' -        SECONDARY SUBALLOCATE
         SPACE 1
***********************************************************************
*                                                                     *
*   DEVICE ENTRIES                                                    *
*                                                                     *
*      1. DURING ALLOCATION -                                         *
*                ONE DEVICE ENTRY FOR EACH DEVICE REQUIRED, OR FOR    *
*                EACH PUBLIC DEVICE ELIGIBLE.                         *
*                                                                     *
*      2. DURING PROBLEM PROGRAM -                                    *
*                ONE DEVICE ENTRY FOR EACH ALLOCATED DEVICE.          *
*                                                                     *
***********************************************************************
         SPACE 1
TIOESTTB DS    B -            STATUS BYTE B - DURING ALLOCATION AND
*                             DURING PROBLEM PROGRAM
TIOSUSED EQU   X'80' -        DATA SET IS ON DEVICE
TIOSREQD EQU   X'40' -        DATA SET WILL USE DEVICE
TIOSPVIO EQU   X'20' -        DEVICE VIOLATES SEPARATION
TIOSVLSR EQU   X'10' -        VOLUME SERIAL PRESENT
TIOSSETU EQU   X'08' -        SETUP MESSAGE REQUIRED
TIOSMNTD EQU   X'04' -        IF 0, DELETE UNLOADED VOLUME IF UNLOAD
*                             REQUIRED.  IF 1, RETAIN UNLOADED VOLUME
*                             IF UNLOAD REQUIRED.
TIOSUNLD EQU   X'02' -        UNLOAD REQUIRED
TIOSVERF EQU   X'01' -        VERIFICATION REQUIRED
TIOEFSRT DS    AL3 -          DURING PROBLEM PROGRAM, ADDRESS OF UCB.
*                             DURING ALLOCATION, BITS 0-11 CONTAIN
*                             OFFSET, IN THE UCB LOOK-UP TABLE, TO AN
*                             ADDRESS FOR A DEVICE REQUIRED OR ELIGIBLE
*                             FOR THIS DATA SET.  THE UCB LOOK-UP TABLE
*                             HAS ADDRESSES OF UCB'S.  BITS 12-23
*                             CONTAIN OFFSET, IN THE STEP VOLUME TABLE
*                             (VOLT), TO THE VOLUME SERIAL NUMBER FOR
*                             THE VOLUME REQUIRED OR ELIGIBLE FOR THIS
*                             DATA SET.
         SPACE 2
TIOTFEND DS    CL4 -          FINAL END OF THE TIOT - BINARY ZEROS
         EJECT ,
******************************************************************
*                                                                *
*        Map selected TCB fields.                                *
*                                                                *
******************************************************************
         SPACE 1
*        IKJTCB ,
TCBFIX   DSECT , -     TCBPTR-32
*
TCBFRS   DS    0CL32 - FLOATING POINT REGISTER SAVE AREA
TCBFRS0  DS    D -     SAVE AREA FOR FLOATING POINT REGISTER 0
TCBFRS2  DS    D -     SAVE AREA FOR FLOATING POINT REGISTER 2
TCBFRS4  DS    D -     SAVE AREA FOR FLOATING POINT REGISTER 4
TCBFRS6  DS    D -     SAVE AREA FOR FLOATING POINT REGISTER 6
TCBPXLEN EQU   *-TCBFIX LENGTH OF PREFIX SECTION
*
*              TCB PROPER
*
         DS    0D
TCB      EQU   * -     TCBPTR
*
TCBRBP   DS    A -     ADDRESS OF THE RB FOR EXECUTING PROGRAM
TCBPIE   DS    0A -    ADDRESS OF SPIE CONTROL AREA.  THE FIRST WORD OF
*                      THIS AREA CONTAINS THE PROGRAM INTERRUPT ELEMENT
*                      (PIE) ADDRESS.                            MDC024
TCBPMASK DS    B -     SPIE BITS
TCBPM    EQU   X'0F' - PROGRAM MASK AT TIME OF SPIE INITIATION.  MASK
*                      RESTORED AT TIME OF SPIE NULLIFICATION.
TCBPIEA  DS    AL3 -   ADDRESS OF SPIE CONTROL AREA.  THE FIRST WORD OF
*                      THIS AREA CONTAINS THE PROGRAM INTERRUPT ELEMENT
*                      (PIE) ADDRESS.                            MDC024
TCBDEB   DS    A -     ADDRESS OF THE DEB QUEUE
TCBTIO   DS    A -     ADDRESS OF THE TASK I/O TABLE (TIOT)
         END   ,
??
//SMPCNTL  DD  *
 RECEIVE S(TX67311).
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67311) CHECK BYPASS(ID).
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67311) .
//

//*---- use the following steps for REJECT or RESTORE ------------- ***
//REJECT  EXEC SMP4
//SMPCNTL  DD  *
 REJECT  S(TX67311).
//
//RESTORE EXEC SMP4
//SMPCNTL  DD  *
 RESTORE S(TX67311).
//

