//TX67805   JOB  (1),TX67805,
//             COND=(0,NE),
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1)
//*
//* 2022/12/01 @KL TX67805
//*                Year > 1999 toleration
//*
//RECEIVE EXEC SMP4
//* Mon May 17 17:28:22 2021 */
//SMPPTFIN DD DATA,DLM='??'
++ USERMOD(TX67805)     /* REWORK(20210517) */             .
++ VER (X067)
   FMID(EBA1101)                                           .
++ IF FMID(EPM1101) THEN REQ (UX15738)
 /*
   PROBLEM DESCRIPTION(S):
     TX60805 -
       VS1 toleration for years greater than 1999.

       Note that this support only provides tolerance of a
       TOD clock that is already set to a year greater than 1999.
       It does not modify VS1 commands to allow the year to be
       set to a value greater than 1999 under VS1.  Operator
       commands have not been modified to allow four-digit
       years, so the hardware clock must already have been
       set to the correct value before VS1 is IPLed.

       Because of sloppy IBM coding in VS1, the largest year
       that VS1 can handle is 2034.  If the TOD clock year
       is greater than 2034, VS1 IPL will fail with a wait013.

   COMPONENT:  5741-SC1B8-EBA1101

   APARS FIXED:  TX67805

   SPECIAL CONDITIONS:
     DEPENDENCY:  This usermod can only be installed on a VS1
       system generated with extended timer support.  For that
       to be the case, "CTIMERS=INCLUDE" must have been specified
       on the CENPROCS stage 1 macro (the default for CTIMERS is
       EXCLUDE).

     DOCUMENTATION:  Text of system message IEE054I modified.

       Publication:  OS/VS Message Library:
                     VS1 System Messages
       Form Number:  GC38-1001

       Message IEE054I is modified as follows:

         IEE054I DATE=yyyy.ddd,CLOCK=hh.mm.ss
         IEE054I DATE=yyyy.ddd,CLOCK=hh.mm.ss,GMT

           Explanation:  The first message displays the current
             date and time in the local time zone.  The second
             message displays the current UTC date and time for
             operator reference and verification.  In each message,
             yyyy specifies the year (1900-2041), ddd specifies the
             day (001-366), hh specifies the hour (00-23), mm
             specifies the minute (00-59), and ss specifies the
             second (00-59).

           System Action:  None:

           Operator Response:  None

     DOCUMENTATION:  Text of system message IEE136I modified.

       Publication:  OS/VS Message Library:
                     VS1 System Messages
       Form Number:  GC38-1001

       Message IEE136I is modified as follows:

         IEE136I    TIME=hh.mm.ss   DATE=yyyy.ddd

           Explanation:  In response to a DISPLAY T command, this
             message indicates the time of day and the date.  In
             the message text, hh specifies the hour (00-23), mm
             specifies the minute (00-59), ss specifies the second
             (00-59), yyyy specifies the year (1900-2041), and ddd
             specifies the day (001-366).

           Operator Response:  None

   COMMENTS:
     LAST CHANGE:  2021/05/17

    THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

    MODULES
      IEE3503D (load module IGC3503D)
      IEE0903D (load module IGC6503D, alias IGX00010)
      IEE6603D (load module IGX00009)

    LISTEND
 */.
++ ZAP      (IEE3503D) DISTLIB(AOSB3   ).
NAME IGC3503D IEE3503D
IDRDATA TX67805
VER 000000 0530                      BALR  R3,0            PROGRAM ADDRESSABILIT
VER 000002 47F0,3016                 B     DROUTER         BRANCH AROUND EYE-CAT
VER 000006 CCCC                      DC    X'CCCC'         FILLER
VER 000008 C9C5C5F3F5F0F3C4          DC    C'IEE3503D'     CSECT NAME
VER 000010 F0F2F1F6F7F2              DC    C'021672'       DATE ASSEMBLED
VER 000016 CCCC                      DC    X'CCCC'         FILLER
VER 00014A 1B44                      SR    R4,R4           CLEAR FOR IC
VER 00014C 4340,2028                 IC    R4,XAU          SAVE UCMI FOR WTO
VER 000150 4850,202C                 LH    R5,XAQ          SAVE XAQ (QID)
VER 000154 D233,2000,331A   REP1     MVC   XSA(DDLN),DDMSG MOVE IN INCOMPLETE WT
VER 00015A 4110,0002                 LA    1,2(0,0)        +LOAD 1 TO SPECIFY UN
VER 00015E 0A0B                      SVC   11              +ISSUE TIME SVC
VER 000160 5000,2014                 ST    R0,XTM          STORE TIME IN XSA AFT
VER 000192 D201,2024,2027   REP2     MVC   XDATE(L2),XDATE+D3    LEFT ADJUST YEA
VER 000198 924B,2026                 MVI   XDATE+D2,C'.'         INSERT PERIOD
VER 00019C D202,2027,2029            MVC   XDATE+D3(L3),XDATE+D5 LEFT ADJUST DAY
VER 0001A2 D201,202A,32C1            MVC   XDATE+D6(L2),DDBLNK   BLANK OUT ANY L
VER 0002C3 4040404040404040 DDBLNK   DC    C'        '     USED FOR PADDING
VER 000448 FFFFFFFFFFFFFFFF ZAPAREA  DC    20F'-1'         SUPERZAP AREA
VER 000450 FFFFFFFFFFFFFFFF
VER 000458 FFFFFFFFFFFFFFFF
VER 000460 FFFFFFFFFFFFFFFF
VER 000468 FFFFFFFFFFFFFFFF
VER 000470 FFFFFFFFFFFFFFFF
VER 000478 FFFFFFFFFFFFFFFF
VER 000480 FFFFFFFFFFFFFFFF
VER 000488 FFFFFFFFFFFFFFFF
VER 000490 FFFFFFFFFFFFFFFF
REP 000154 4110,0002                 LA    1,2(0,0)        +LOAD 1 TO SPECIFY UN
REP 000158 0A0B                      SVC   11              +ISSUE TIME SVC
REP 00015A 0700                      NOPR  0               NOP
REP 00015C 47F0,344A                 B     PATCH1          To patch area
REP 000192 D203,2024,2025            MVC   XDATE(L4),XDATE+D1 Left adjust year
REP 000198 924B,2028                 MVI   XDATE+D4,C'.'      Insert period
REP 00019C 4700,0000                 NOP   0                  NOP
REP 0001A0 0700                      NOPR  0                  NOP
REP 0001A2 4700,0000                 NOP   0                  NOP
REP 0001A6 0700                      NOPR  0                  NOP
REP 000448 001CFDE0         ADJ1900  DC    A(1900*1000)    For year adjustment
REP 00044C D707,2018,2018   PATCH1   XC    XAV,XAV         Clear work area
REP 000452 5010,201C                 ST    R1,XAV+4        Save date ccyydddF
REP 000456 4F10,2018                 CVB   R1,XAV          Convert ccyydddF to b
REP 00045A 5A10,3446                 A     R1,ADJ1900      Adjust for century
REP 00045E 4E10,2018                 CVD   R1,XAV          Back to packed yyyydd
REP 000462 5810,201C                 L     R1,XAV+4        Load date yyyydddC in
REP 000466 D233,2000,331A            MVC   XSA(DDLN),DDMSG Copy model IEE136I WP
REP 00046C 47F0,315E                 B     RET1            Back to mainline
++ ZAP      (IEE0903D) DISTLIB(AOSB3   ).
NAME IGC6503D IEE0903D
IDRDATA TX67805
VER 000000 05C0                      BALR  R12,R0                ESTABLISH ADDR
VER 000002 47F0,C012                 B     TODCODE               BRANCH AROUND
VER 000006 C9C5C5F0F9F0F3C4          DC    C'IEE0903D'           CSECT NAME
VER 00000E F1F0F1F6F7F2              DC    C'101672'             RELEASE DATE
VER 0001DC F321,2008,2026   REP1     UNPK  XAX(D3),XAS+D6(D2)    UNPACK YEAR
VER 000202 D201,2008,C638   REP2     MVC   XAX(D2),YY00          MAKE YEAR 1900
VER 000210 F332,200A,2025   REP3     UNPK  XAX+D2(D4),XAS+D5(D3) UNPACK DAY
VER 000216 F234,3038,2008            PACK  CVTDATE(D4),XAX(D5)   SET LOCAL DATE
VER 000644 FFFFFFFFFFFFFFFF ZAPAREA  DC    10F'-1'               SUPERZAP AREA
VER 00064C FFFFFFFFFFFFFFFF
VER 000654 FFFFFFFFFFFFFFFF
VER 00065C FFFFFFFFFFFFFFFF
VER 000664 FFFFFFFFFFFFFFFF
REP 0001DC F342,2008,2025            UNPK  XAX(D5),XAS+D5(D3)    Unpack year
REP 000202 D203,2008,C642            MVC   XAX(D4),YY1900        Make year 1900
REP 000210 F332,200C,2025            UNPK  XAX+D4(D4),XAS+D5(D3) Unpack day
REP 000216 F236,3038,2008            PACK  CVTDATE(D4),XAX(D7)   Set local date
REP 000644 F1F9F0F0         YY1900   DC    C'1900'               Year 1900
++ ZAP      (IEE6603D) DISTLIB(AOSB3   ).
NAME IGX00009 TODRTNES
 EXPAND TODRTNES(8)
IDRDATA TX67805
VER 000000 05C0                      BALR  R12,R0
VER 000002 47F0,C014                 B     TODCODE                 BRANCH AROUND
VER 000006 CCCC                      DC    X'CCCC'                 FILLER
VER 000008 C9C5C5F6F6F0F3C4          DC    C'IEE6603D'             CSECT NAME
VER 000010 F0F3F1F3F7F2              DC    C'031372'               AOS/1 INTEGRA
VER 00008A 5570,C22A                 CL    R7,YR2000               IS TOD GRTR T
VER 00008E 47B0,C058                 BNL   TODWTO                  YES,GO ISSUE'
VER 0000EE F321,2010,2006            UNPK  TODYEAR(D3),CNVTFLD+D6(D2) UNPK YEAR
VER 000114 D201,2010,C210   YR1900   MVC   TODYEAR(D2),YY00        MAKE YEAR 190
VER 000122 F332,2013,2005            UNPK  TODDAY(D4),CNVTFLD+D5(D3)  UNPK DAY I
VER 000128 924B,2012                 MVI   TODYEAR+D2,CPERIOD      SET FORMAT FO
VER 000176 D201,2000,2010            MVC   CNVTFLD(2),TODYEAR      MOVE NUMBER O
VER 00017C D202,2002,2013            MVC   CNVTFLD+2(3),TODDAY     MOVE NUMBER O
VER 000182 F234,300C,2000            PACK  SETDATFD(4),CNVTFLD(5)  PACK DATE FOR
VER 0001AE D225,4028,C26F            MVC   D40(L'TODMSG3,R4),TODMSG3 MOVE GMT MS
VER 0001B4 D205,4035,2010            MVC   D53(D6,R4),TODYEAR      MOVE DATE INT
VER 0001BA D207,4042,2016            MVC   D66(D8,R4),TODHRS       MOVE GMT TIME
VER 0001D0 5570,C22A                 CL    R7,YR2000               IS YEAR >= 20
VER 0001D4 47B0,C058                 BNL   TODWTO                  YES, ERROR CO
VER 0001E0 D221,4000,C24D            MVC   D0(L'TODMSG2,R4),TODMSG2 MOVE LOCAL M
VER 0001E6 D205,400D,2010            MVC   D13(D6,R4),TODYEAR      MOVE LOCAL DA
VER 0001EC D207,401A,2016            MVC   D26(D8,R4),TODHRS       MOVE LOCAL TI
VER 0001F2 D205,4022,C22E            MVC   D34(D6,R4),BLANCS       SEPARATE MESS
VER 00022C B3639BFA         YR2000   DC    X'B3639BFA'             TOD (SECONDS)
VER 000230 404040404040     BLANCS   DC    CL6' '                  MESSAGE DIVID
VER 00024F C9C5C5F0F5F4C940 TODMSG2  DC    C'IEE054I DATE=00.000,CLOCK=00.00.00'
VER 000257 C4C1E3C57EF0F04B
VER 00025F F0F0F06BC3D3D6C3
VER 000267 D27EF0F04BF0F04B
VER 00026F F0F0
VER 000271 C9C5C5F0F5F4C940 TODMSG3  DC    C'IEE054I DATE=00.000,CLOCK=00.00.00,
VER 000279 C4C1E3C57EF0F04B
VER 000281 F0F0F06BC3D3D6C3
VER 000289 D27EF0F04BF0F04B
VER 000291 F0F06BC7D4E3
VER 000298 FFFFFFFFFFFFFFFF ZAPAREA  DC    20F'-1'                 SUPERZAP AREA
VER 0002A0 FFFFFFFFFFFFFFFF
VER 0002A8 FFFFFFFFFFFFFFFF
VER 0002B0 FFFFFFFFFFFFFFFF
VER 0002B8 FFFFFFFFFFFFFFFF
VER 0002C0 FFFFFFFFFFFFFFFF
VER 0002C8 FFFFFFFFFFFFFFFF
VER 0002D0 FFFFFFFFFFFFFFFF
VER 0002D8 FFFFFFFFFFFFFFFF
VER 0002E0 FFFFFFFFFFFFFFFF
VER 0002E8 0000000000000000 ZAPAREA2 DC    2F'0'                   Patch area ex
REP 00008A 4700,0000                 NOP   0                       No operation
REP 00008E 4700,0000                 NOP   0                       No operation
REP 0000EE F342,2020,2005            UNPK  TODYEAR4(D5),CNVTFLD+D5(D3)  Unpk yea
REP 000114 D203,2020,C296            MVC   TODYEAR4(D4),YY1900     Make year 190
REP 000122 F332,2025,2005            UNPK  TODDAY4(D4),CNVTFLD+D5(D3)  Unpack da
REP 000128 924B,2024                 MVI   TODYEAR4+D4,CPERIOD     Set format fo
REP 000176 D203,2000,2020            MVC   CNVTFLD(4),TODYEAR4     Move years in
REP 00017C D202,2004,2025            MVC   CNVTFLD+4(3),TODDAY4    Move days int
REP 000182 45E0,C29A                 BAL   R14,PATCH1              To patch area
REP 000186 0700                      NOPR  0                       No operation
REP 0001AE D227,4028,C24D            MVC   D40(TODMSGL3,R4),TODMSGX Move GMT msg
REP 0001B4 D207,4035,2020            MVC   D53(D8,R4),TODYEAR4     Move date int
REP 0001BA D207,4044,2016            MVC   D68(D8,R4),TODHRS       Move time int
REP 0001D0 4700,0000                 NOP   0                       No operation
REP 0001D4 4700,0000                 NOP   0                       No operation
REP 0001E0 D223,4000,C24D            MVC   D0(TODMSGL2,R4),TODMSGX Move local ms
REP 0001E6 D203,2000,2020            MVC   CNVTFLD(4),TODYEAR4     Move years in
REP 0001EC D202,2004,2025            MVC   CNVTFLD+4(3),TODDAY4    Move days int
REP 0001F2 45E0,C2BA                 BAL   R14,PATCH2              To patch area
REP 0001F6 0700                      NOPR  0                       No operation
REP 00022C 1900000C         P1900000 DC    P'1900000'              For adjusting
REP 00024F C9C5C5F0F5F4C940 TODMSGX  DC    C'IEE054I DATE=0000.000,CLOCK=00.00.0
REP 000257 C4C1E3C57EF0F0F0
REP 00025F F04BF0F0F06BC3D3
REP 000267 D6C3D27EF0F04BF0
REP 00026F F04BF0F0
REP 000273 6BC7D4E3                  DC    C',GMT'
REP 000298 F0F0F0F0         YY1900   DC    C'0000'                 To create yea
REP 00029C F236,300C,2000   PATCH1   PACK  SETDATFD(4),CNVTFLD(7)  Pack date for
REP 0002A2 F833,2000,300C            ZAP   CNVTFLD(4),SETDATFD     Adjust year
REP 0002A8 FA33,2000,C22A            AP    CNVTFLD(4),P1900000      to add back
REP 0002AE F342,2003,2000            UNPK  CNVTFLD+3(5),CNVTFLD(3)   and set
REP 0002B4 D203,2020,2003            MVC   TODYEAR4(4),CNVTFLD+3      as charact
REP 0002BA 07FE                      BR    R14
REP 0002BC F236,2008,2000   PATCH2   PACK  FWORK(4),CNVTFLD(7)     Pack date for
REP 0002C2 F833,2000,2008            ZAP   CNVTFLD(4),FWORK(4)     Adjust year
REP 0002C8 FA33,2000,C22A            AP    CNVTFLD(4),P1900000      to add back
REP 0002CE F342,2003,2000            UNPK  CNVTFLD+3(5),CNVTFLD(3)   and set
REP 0002D4 D203,2020,2003            MVC   TODYEAR4(4),CNVTFLD+3      as charact
REP 0002DA D207,400D,2020            MVC   D13(D8,R4),TODYEAR4     Move local da
REP 0002E0 D207,401C,2016            MVC   D28(D8,R4),TODHRS       Move local ti
REP 0002E6 D203,4024,C22E            MVC   D36(D4,R4),BLANCS       Separate mess
REP 0002EC 07FE                      BR    R14
??
//SMPCNTL  DD  *
 RECEIVE S(TX67805).
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67805) CHECK BYPASS(ID).
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67805).
//

//REJECT  EXEC SMP4
//SMPCNTL  DD  *
 REJECT  S(TX67805).
//

//RESTORE EXEC SMP4
//SMPCNTL  DD  *
 RESTORE S(TX67805).
//
