//TX67807  JOB  (1),TX67807,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),COND=(0,NE)
//*
//*  2021/05/26 @kl TX67807 zap for VS1 6.7
//*                 support for SYSOUT=*
//*
//* C:\Hercules\vs1-6.7\usermods\zapcode7.pl Sat Apr 10 12:05:34 2021 */
//RECEIVE EXEC SMP4
//SMPPTFIN    DD DATA,DLM='??'
++ USERMOD(TX67807)     /* REWORK(20210410) */             .
++ VER (X067)
   FMID(EBA1101)
   PRE  (UX12742,UX12713)
 /*
   PROBLEM DESCRIPTION(S):
     TX67807 -
       Support "SYSOUT=*" as in MVS.

   COMPONENT:  5741-SC1B9-EBA1101

   APARS FIXED:  TX67807

   SPECIAL CONDITIONS:
     DOCUMENTATION:  Description of "SYSOUT=" parameter modified.

       Publication:  OS/VS1 JCL Reference
       Form Number:  GC24-5099

       The "Rules for Coding" section in the description of the SYSOUT
       parameter in the "DD" section of the manual is replaced by the
       following:

         Rules for Coding

           1.  The classname can be any alphameric character
               (A-Z, 0-9) or *.

           2.  The form number is one to four alphameric and national
               (@,$, #) characters.

           3.  The OUTLIM, UCS, FCB, COPIES, BURST, FLASH, CHARS,
               MODIFY, COMPACT, DEST, HOLD, DSID and DCB parameters
               can be coded with the SYSOUT parameter.  Besides the
               mutually exclusive parameters listed below, other
               parameters coded with the SYSOUT parameter are ignored.

           4.  The DISP, DDNAME, AFF, SEP. VOLUME, LABEL, SPLIT, MSVGP,
               and SUBALLOC parameters and the SYSOUT parameter are
               mutually exclusive parameters; therefore, if any of
               these parameters are coded, do not code the SYSOUT
               parameter.

           5.  When PROFILE='profile string' is coded, it overrides the
               SYSOUT classname.

           6.  If PROFILE= is the only SYSOUT subparameter coded,
               it does not have to be enclosed in parentheses.
               However, if the sysout profile string continues from
               one line to another, each line must being and end with
               an apostrophe and the entire group must be enclosed
               in parentheses.

           7.  To print the output data set and the messages from your
               job on the same output listing, specify the same output
               class in the SYSOUT parameter as you specified for
               messages in the MSGCLASS parameter.  Or, specify
               SYSOUT=* for all data sets you want to default to
               the MSGCLASS output class.

     DOCUMENTATION:  Description of "SYSOUT=" parameter modified.

       Publication:  OS/VS1 JCL Services
       Form Number:  GC24-5100

       The section "Assigning Output Data Sets to Output Classes"
       in chapter 2, "Description of JCL Services" under "Defining
       and Describing Data Sets" subsection "Obtaining Output",
       is replaced as follows:

         Assigning Output Data Sets to Output Classes

           The purpose of output classes is to group output with
           similar characteristics that will be written to the
           same device.  The 36 possible output classes are each
           designated by a letter from A through Z or a number
           from 0 through 9.  The letter and number names have
           no inherent meaning.  Each installation defines its
           own output classes when the system is generated.  For
           example, output class W might contain output to be
           written to a printer and requiring a special form;
           class J might be reserved for high-volume output.

           To assign an output data set to an output class, code
           the SYSOUT parameter on the DD statement defining the
           data set:

           //DATASET DD SYSOUT=W

           If the system programmer has generated the ISSP
           (installation specified selection parameters) tables,
           you can assign an output data set to an output class
           by using the PROFILE keyword parameter instead of the
           CLASSNAME positional parameter on the SYSOUT DD
           statement.

           If you want the output data set and the messages from
           your job to be printed on the same output listing,
           specify the same output class in the SYSOUT parameter
           as you specified for messages in the MSGCLASS param-
           eter.  If the output classes are selected through ISSP,
           describe the output using the same profile string with
           both the PROFILE (on the DD statement) and MPROFILE (on
           the job statement) keywords.

           Alternatively, you may specify the SYSOUT class as *:

           //DATASET DD SYSOUT=*

           to cause an output data set to be printed on the same
           output listing as the messages from your job.

           Additional information and an example showing the use
           of ISSP to assign output classes is shown in this
           section under "Assigning Output Classes Using ISSP."
           If you omitted the MSGCLASS and MPROFILE parameters,
           code the default output class for messages in the SYSOUT
           parameter.  (For details on coding the MSGCLASS
           parameter, see the section "Controlling the Output
           Listing of JCL Statements, Messages, and Dumps.")

   COMMENTS:
     LAST CHANGE:  2021/04/10

    THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

    MODULES
      IEFVFA
      IEFVDA

    LISTEND
 */.
++ ZAP      (IEFVFA  ) DISTLIB(AOSB3   ).
NAME IEFIRC IEFVFA
IDRDATA TX67807
VER 000000 05B0                      BALR  RB,0             BASE FOR SCAN CODE.
VER 000002 47F0,B014        VFA01    B     FA1              TRANSFER.
VER 00000C 11111111                  DC    X'11111111'
VER 000010 C6C1                      DC    C'FA'
VER 000012 D34BF0F4                  DC    C'L.04'
VER 000B48 45E0,A25C        ASR      BAL   RE,ORRTN         GO SEE IF THIS KEY I
VER 000B4C 956E,5000                 CLI   0(R5),DDK        IS THIS DD* STATEMEN
VER 000B50 4780,B78A        REP1     BE    FB3              YES - RET TO TRANSLA
VER 000B54 95AA,5000                 CLI   0(R5),RESTARJK   IS IT RESTART=
VER 000B58 4770,BB66                 BNE   ASR2             NO,CONTINUE
VER 000B5C 9500,6000                 CLI   ZRO(R6),ZRO      IS IT FIRST OPERAND?
VER 000B60 4780,B78A                 BE    FB3              YES,RETURN TO TRANSL
VER 000B64 4770,BBA2                 BNE   ASR1             NO,ERROR
VER 00199D FFFFFFFFFFFFFFFF ZAPAREA  DC    100X'FF'
VER 0019A5 FFFFFFFFFFFFFFFF
VER 0019AD FFFFFFFFFFFFFFFF
VER 0019B5 FFFFFFFFFFFFFFFF
VER 0019BD FFFFFFFFFFFFFFFF
VER 0019C5 FFFFFFFFFFFFFFFF
VER 0019CD FFFFFFFFFFFFFFFF
VER 0019D5 FFFFFFFFFFFFFFFF
VER 0019DD FFFFFFFFFFFFFFFF
VER 0019E5 FFFFFFFFFFFFFFFF
VER 0019ED FFFFFFFFFFFFFFFF
VER 0019F5 FFFFFFFFFFFFFFFF
VER 0019FD FFFFFFFF
REP 000B50 45E0,A99C                 BAL   RE,PATCH1        To patch area
REP 00199E 4780,B78A        PATCH1   BE    FB3              Clobbered instructio
REP 0019A2 954B,5000                 CLI   0(R5),SYSOUTK    Is key SYSOUT=?
REP 0019A6 4780,B78A                 BE    FB3              Yes, return to trans
REP 0019AA 07FE                      BR    RE               Else return to mainl
++ ZAP      (IEFVDA  ) DISTLIB(AOSB3   ).
NAME IEFIRC IEFVDA
IDRDATA TX67807
VER 000000 05B0                      BALR  RB,DD0           ESTABLISH ADDRESSABL
VER 000002 5870,B00A        VDA1     L     R7,DVDA1         BASE
VER 000006 47F0,B032                 B     DAHEADER         TRANSFER TO DA HEADE
VER 00125C D207,A070,723A   SYSOUTP  MVC   TWORK(L'TWORK),BLANKS  BLANK TEMP WOR
VER 001262 9500,3000        REP1     CLI   DD0(R3),DD0      IS LEN BYTE=0?
VER 001266 4770,7284                 BNE   SYSOUTP3         OK, CLASSNAME WAS SP
VER 001F24 FFFFFFFFFFFFFFFF ZAPAREA  DC    50F'-1'
VER 001F2C FFFFFFFFFFFFFFFF
VER 001F34 FFFFFFFFFFFFFFFF
VER 001F3C FFFFFFFFFFFFFFFF
VER 001F44 FFFFFFFFFFFFFFFF
VER 001F4C FFFFFFFFFFFFFFFF
VER 001F54 FFFFFFFFFFFFFFFF
VER 001F5C FFFFFFFFFFFFFFFF
VER 001F64 FFFFFFFFFFFFFFFF
VER 001F6C FFFFFFFFFFFFFFFF
VER 001F74 FFFFFFFFFFFFFFFF
VER 001F7C FFFFFFFFFFFFFFFF
VER 001F84 FFFFFFFFFFFFFFFF
VER 001F8C FFFFFFFFFFFFFFFF
VER 001F94 FFFFFFFFFFFFFFFF
VER 001F9C FFFFFFFFFFFFFFFF
VER 001FA4 FFFFFFFFFFFFFFFF
VER 001FAC FFFFFFFFFFFFFFFF
VER 001FB4 FFFFFFFFFFFFFFFF
VER 001FBC FFFFFFFFFFFFFFFF
VER 001FC4 FFFFFFFFFFFFFFFF
VER 001FCC FFFFFFFFFFFFFFFF
VER 001FD4 FFFFFFFFFFFFFFFF
VER 001FDC FFFFFFFFFFFFFFFF
VER 001FE4 FFFFFFFFFFFFFFFF
VER 001FEC 47F0,7F22                 B     ZAPAREA
REP 001262 45E0,7F22                 BAL   RE,PATCH1        To patch area
REP 001F24 9501,3000        PATCH1   CLI   0(R3),X'01'      Is there a class?
REP 001F28 4770,7F3C                 BNE   PATCH1A          Branch if not
REP 001F2C 955C,3001                 CLI   1(R3),C'*'       Is it SYSOUT=*?
REP 001F30 4770,7284                 BNE   SYSOUTP3         Branch if not
REP 001F34 D200,3001,C2D6            MVC   1(1,R3),JCT+JCTJMGPO-INJMJCT   Copy m
REP 001F3A 47F0,7284                 B     SYSOUTP3         Continue
REP 001F3E 9500,3000        PATCH1A  CLI   DD0(R3),DD0      Clobbered instructio
REP 001F42 07FE                      BR    RE               Back to mainline
??
//SMPCNTL  DD  *
  RECEIVE S(TX67807)
        .
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
  APPLY S(TX67807)
        CHECK
        BYPASS(ID)
        .
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
  APPLY S(TX67807)
        .
//

//REJECT  EXEC SMP4
//SMPCNTL  DD  *
  REJECT S(TX67807).
//

//RESTORE EXEC SMP4
//SMPCNTL  DD  *
  RESTORE S(TX67807).
//
