//TX67809  JOB  (1),TX67809,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),COND=(0,NE)
//*
//* 2021/05/26 @kl TX67809 changes to sysgen JOBCARD macro
//*
//RECEIVE EXEC SMP4
//SMPPTFIN   DD DATA,DLM='??'
++ USERMOD(TX67809)     /* REWORK(20210520) */             .
++ VER (X067)
   FMID(EBA1101)
 /*
   PROBLEM DESCRIPTION(S):
     TX67809 -
       Change JOBCARD system generation macro:

         (1) to generate "*** JOBCARD ***" comment at the start
             of each job;
         (2) to set custom job name;
         (3) to add "TYPRUN=HOLD";
         (4) to add JOBCAT statement (maybe).

       VS1 system generation does not permit the use of alternate
       qualifiers in DLIB data set names (that is, all DLIB names
       must be of the form "SYS1.xxxx").  It also requires DLIBs
       to be cataloged.  This can cause a problem when the system
       being used to run a VS1 sysgen stage 2 job stream has its
       own DLIBs already cataloged.  The problem can be circumvented
       provided the generating system supports VSAM by creating a
       VSAM user catalog in which the VS1 DLIB data sets have been
       cataloged using DEFINE NONVSAM statements.  The DLIB catalog
       can then be specified for use by VS1 stage 2 jobs using a
       JOBCAT DD statement generated by the JOBCARD macro for each
       job.  To generate the JOBCAT for stage 2 jobs, modify card
       12000000 in the JOBCARD macro below as follows:

         (1) Specify the DLIB user catalog name in the DSN=
             parameter (the sample below has "SYS1.FDLB67.CATALOG");
         (2) Remove the assembler comment (".*") from the start
             of the card.

   COMPONENT:  5741-SC1S1-EBA1101

   APARS FIXED: TX67809

   SPECIAL CONDITIONS:
     IOGEN:  An I/O generation is required for implementation
       of the functionality added by this usermod.
       GENTYPE = IO

   COMMENTS:
     LAST CHANGE:  2021/05/20

     REWORK HISTORY:
       2021/05/20: Created.

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MACROS
       JOBCARD

     LISTEND
 */.
++ MACUPD   (JOBCARD ) DISTLIB(AGENLIB ).
./ CHANGE NAME=JOBCARD
*** JOBCARD  *** START OF JOB                             *** NOID  *** 03050000
 PUNCH '//G09GEN&SGCTRLA(3) JOB 1,''SYSTEM GENERATION'',CLASS=&SGCTRLC(+05000000
               42),MSGCLASS=&SGCTRLC(41),TYPRUN=HOLD'          @TX67809 06000000
 PUNCH '//G09GEN&SGCTRLA(3) JOB 1,''SYSTEM GENERATION'',CLASS=&SGCTRLC(+09000000
               42),MSGCLASS=&SGCTRLC(41),TYPRUN=HOLD'          @TX67809 10000000
.MEND    ANOP                                                  @TX67809 11000000
.* PUNCH '//JOBCAT   DD  DISP=SHR,DSN=SYS1.FDLB67.CATALOG'     @TX67809 12000000
         MEND                                                  @TX67809 13000000
??
//SMPCNTL  DD  *
  RECEIVE S(TX67809)
        .
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
  APPLY S(TX67809)
        CHECK
        BYPASS(ID)
        .
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
  APPLY S(TX67809)
        .
//



//REJECT  EXEC SMP4
//SMPCNTL  DD  *
  REJECT S(TX67809).
//

//RESTORE EXEC SMP4
//SMPCNTL  DD  *
  RESTORE S(TX67809).
//
