//TX67816  JOB  (1),TX67816,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),COND=(0,NE)
//*
//* 2021/05/26 @KL TX67816
//*                Make console action message high intensity
//*                (modified ZP60004)
//*
//RECEIVE EXEC SMP4
//* C:\Hercules\vs1a\usermods\zapcode7.pl Fri Feb 19 22:01:01 2021 */
//SMPPTFIN DD DATA,DLM='??'
++ USERMOD(TX67816)     /* REWORK(20210219) */             .
++ VER (X067)
   FMID(EBA1101)
 /*
  PROBLEM DESCRIPTION(S):
    TX67816 -
      3270 high intensity is not used for immediate action messages.
      All console messages displayed using the shipped 3277
      console support are shown in low intensity, whereas the
      expected behaviour for 3270 OS consoles is that 3270
      dual intensity is exploited so that immediate messages
      including WTORs are displayed in high intensity until
      processed by DOM.

      This usermod updates the 3277 console write module to
      update the 3270 field attribute byte for each in-line
      message line according to the action message status of
      the message shown on that line before the screen is
      written.

      Changed 2007/04/16 to handle the case of a highlighted
      message being overwritten by an out-of-line display.

  COMPONENT:  5751-SC1C4-EBA1101

  APARS FIXED: TX67816

  SPECIAL CONDITIONS:
    NONE:

  COMMENTS:
    LAST CHANGE:  2021/02/19

    REWORK HISTORY:
     2021/02/19: Created.

    PRYCROFT SIX P/L PUBLIC DOMAIN USERMOD FOR MVS 3.8 NO. 4.

    THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

    CROSS REFERENCE-MODULE/MACRO NAMES TO USERMODS
     IEECVETV  TX67816

    CROSS REFERENCE-USERMODS TO MODULE/MACRO NAMES
     TX67816   IEECVETV

    MODULES
      IEECVETV

    NOTE:  This usermod must be reinstalled following an I/O
       generation.
 */.
++ ZAP      (IEECVETV) DISTLIB(AOSC5   ).
NAME IEECVETV
 EXPAND IEECVETV(52)             /* ADD SPACE FOR PATCH AREA */
IDRDATA TX67816
VER 000000 05B0             START    BALR  RBBASE,N0          SET UP
VER 0000A0 9110,A121        FULLWRT  TM    DCMIOCM1,DCMWRMSG  WRITE FULL MESSAGE
VER 0000A4 47E0,B0CE        PAT1RET  BNO   PARTWRT            NO, TEST NEXT FUNC
VER 0003CC 0006             H6       DC    H'6'
VER 00031C 45E0,B398                 BAL   RERTRN,BUILDCCW    BUILD CCW TO WRITE
VER 00054A 0000000000000000 PATCHLOC DC    (PATCHLEN)X'00'    PATCH AREA
VER 000552 0000000000000000
VER 00055A 0000000000000000
VER 000562 0000000000000000
VER 00056A 0000000000000000
VER 000572 0000000000000000
VER 00057A 00000000
REP 0000A0 47F0,B548        FULLWRT# B     PATCH1             TO PATCH AREA
REP 00031C 45E0,B574                 BAL   RERTRN,PATCH2      TO PATCH AREA
REP 00054A 5850,A030        PATCH1   L     R5KEEP,DCMASCRN    POINT TO START OF
REP 00054E 4B50,B3CA                 SH    R5KEEP,H6          BACK UP TO CONTROL
REP 000552 92E4,5004        LINELOOP MVI   N4(R5KEEP),LO      DEFAULT LOW INTENS
REP 000556 915C,5009                 TM    N9(R5KEEP),ASTER   * OR @?
REP 00055A 47E0,B560                 BNO   NEXTLINE           NO, KEEP LOW INTEN
REP 00055E 92E8,5004                 MVI   N4(R5KEEP),HI      ELSE HIGH INTENSIT
REP 000562 4A50,A104        NEXTLINE AH    R5KEEP,DCMCORLN    BUMP TO NEXT LINE
REP 000566 5950,A04C                 C     R5KEEP,DCMPFKLN    ALL LINES DONE?
REP 00056A 4740,B550                 BL    LINELOOP           NO, LOOP
REP 00056E 9110,A121                 TM    DCMIOCM1,DCMWRMSG  CLOBBERED INSTRUCT
REP 000572 47F0,B0A2                 B     PAT1RET            BACK TO MAINLINE
REP 000576 92E4,4004        PATCH2   MVI   N4(R4WORK),LO      LOW INTENSITY
REP 00057A 47F0,B398                 B     BUILDCCW           BUILD CCW TO WRITE
??
//SMPCNTL  DD  *
 RECEIVE S(TX67816).
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67816) CHECK BYPASS(ID).
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
 APPLY S(TX67816).
//

//REJECT  EXEC SMP4
//SMPCNTL  DD  *
 REJECT  S(TX67816).
//

//RESTORE EXEC SMP4
//SMPCNTL  DD  *
 RESTORE S(TX67816).
//
