//TX67851  JOB  (1),TX67851,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),COND=(0,NE)
//*
//* 2022/08/12 @kl TX67851
//*                VS1/Hercules integration
//*
//RECEIVE EXEC SMP4
//SMPPTFIN   DD DATA,DLM='??'
++ USERMOD(TX67851)     /* REWORK(20220812) */             .
++ VER (X067)
   FMID(EBA1101)
   PRE  (UX12589)
 /*
   PROBLEM DESCRIPTION(S):
     TX67851 -
       VS1/Hercules integration.

       Generally speaking, this usermod causes VS1 to treat
       Hercules as though it was VM/370.  This permits VS1 to
       run in non-paging mode and use up to 16320K of real storage.

       One diagnose X'10' in IEAPGTS, used to release pages, is
       bypassed.  Hercules doesn't support diagnose X'10'.

       The mod determines if it is running under Hercules by
       checking the CPU version ID and the hypervisor name returned
       by diagnose X'00', store extended identification code.
       VM/370 returns X'FF' as the CPU version ID and "VM/370"
       as hypervisor identification.  This mod checks for CPU
       version ID of X'FD' and hypervisor identification code
       "HERCULES" to determine that it's running under Hercules.
       To disable VS1/Hercules integration, make sure that either
       the version ID or hypervisor ID returned by Hercules is
       changed.  For example, modify the Hercules configuration
       file either to set:

         CPUVERID FE

       or:

         LPARNAME name

       where "name" is anything other than "HERCULES".

   COMPONENT:  5741-SC1C8-EBA1101
               5741-SC1CN-EBA1101

   APARS FIXED: TX67851

   SPECIAL CONDITIONS:
     DOCUMENTATION:  Text of system message IEA788I modified.

       Publication:  OS/VS1 System Messages
       Form Number:  GC38-1001

       Message IEA788I is modified as follows:

         IEA788I NON-PAGING MODE OF VS1 UNDER { VM/370   }
                                              { HERCULES }

           Explanation:  OS/VS1 is running with the real storage
             size equal to the virtual storage size, as the result
             of running under the indicated hypervisor, either
             VM/370 or HERCULES.

           System Action:  Virtual storage is mapped one-to-one to
             the real storage.

           Operator Response:  None

   COMMENTS:
     LAST CHANGE:  2022/08/12

     REWORK HISTORY:
       2022/08/12: Fixed sequence numbers in CVT macro modification.
       2021/04/24: Created.

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MACROS
       CVT
       IEAANIP
       IEANIPDC
       IEAPGTS

     LISTEND
 */.
++ MACUPD   (IEAANIP ) DISTLIB(AMODGEN ).
./ CHANGE NAME=IEAANIP
CVTHERCE EQU   X'10'                   Hercules environment    @TX67851 01794906
         CLI   CPUID,XFF               Q.RUNNING UNDER VM/370  @TX67851 05710406
         BE    VM370X01                Yes, running under VM   @TX67851 05710526
         CLI   CPUID,X'FD'             Running under Hercules? @TX67851 05710546
         BNE   VM370000                No, not VM or Hercules  @TX67851 05710606
VM370X01 LA    R9,Q24                  LENGTH OF HYPERVISOR ID @TX67851 05710806
         BE    VM370X02                Yes                     @TX67851 05711606
         CLC   HERCULES,HYPERNAM       Confirm under Hercules  @TX67851 05711616
         BNE   VM370000                No, not VM or Hercules  @TX67851 05711626
         L     R5,CVTPTR               Yes, get CVT address    @TX67851 05711636
         L     R5,CVTEXT2(,R5)         Get extension pointer   @TX67851 05711646
         OI    CVTFLGBT(R5),CVTHERCE   Set CVT Hercules flag   @TX67851 05711656
         OI    NIPFLAG1,VM370HRC       Set NIP Hercules flag   @TX67851 05711666
VM370X02 MVC   IEANPMSH,HYPERNAM       Set hypername in msg    @TX67851 05711706
         TM    NIPFLAG1,VM370HRC       Running under Hercules? @TX67851 05712706
         BO    VM370000                Yes, skip BTAM test     @TX67851 05712726
VM370    DC    C'VM'                   VM hypervisor value     @TX67851 07070604
HERCULES DC    CL8'HERCULES'           Hercules hypervisor     @TX67851 07070654
IEANPMG1 DC    AL1(IEANPMSL)                                   @TX67851 10403004
IEANPMG2 DC    C'IEA788I NON-PAGING MODE OF VS1 UNDER '        @TX67851 10403204
IEANPMSH DC    CL8'VM'                                         @TX67851 10403404
IEANPMSL EQU   *-IEANPMG2                                      @TX67851 10403604
++ MACUPD   (IEANIPDC) DISTLIB(AMODGEN ).
./ CHANGE NAME=IEANIPDC
VM370HRC EQU   X'02'                   Hercules environment    @TX67851 02430504
++ MACUPD   (CVT     ) DISTLIB(AMODGEN ).
./ CHANGE NAME=CVT
CVTHERCE EQU   X'10' -       Indicates system is operating in  @TX67851 36624005
*                            Hercules environment (CVTVME will @TX67851 36624201
*                            also be on; if CVTVME and         @TX67851 36624401
*                            CVTHERCE are on, VS1 is running   @TX67851 36624501
*                            under Hercules, if CVTVME is on   @TX67851 36624601
*                            but CVTHERCE is not, VS1 is       @TX67851 36624701
*                            running under VM) (OS/VS1)        @TX67851 36624801
++ MACUPD   (IEAPGTS ) DISTLIB(AMODGEN ).
./ CHANGE NAME=IEAPGTS
         L     RW7,CVTPTR              GET CVT ADDRESS         @TX67851 42880004
         L     RW7,328(,RW7)           POINT TO VS1/VS2 EXTEN  @TX67851 42885004
         TM    5(RW7),X'10'            RUNNING UNDER HERCULES? @TX67851 42890004
         BO    PGSTSV50                YES, PROCESS AS USUAL   @TX67851 42895004
??
//SMPCNTL  DD  *
  RECEIVE S(TX67851)
        .
//*
//APPLYCK EXEC SMP4
//SMPCNTL  DD  *
  APPLY S(TX67851)
        CHECK
        BYPASS(ID)
        .
//*
//APPLY   EXEC SMP4
//SMPCNTL  DD  *
  APPLY S(TX67851)
        .
//


//REJECT  EXEC SMP4
//SMPCNTL  DD  *
  REJECT S(TX67851).
//

//RESTORE EXEC SMP4
//SMPCNTL  DD  *
  RESTORE S(TX67851).
//
