//SY20ZR00 JOB  (SYSGEN),TIAT015,
//*            RESTART=APPLYCK.SMP,
//*            RESTART=APPLY.SMP,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),REGION=8192K
//*
//* 2006/05/28 @kl TIAT015 JES3 initialization statement
//*                        scan exit.
//*
//RECEIVE  EXEC SMPREC,WORK='SYSALLDA'
//SMPPTFIN   DD DATA,DLM='??'
++ USERMOD(TIAT015)     /* REWORK(20060528) */             .
++ VER (Z038)
   FMID(EJS1102)
   PRE  (UZ66802)
 /*
   PROBLEM DESCRIPTION(S):
     TIAT015 -
       Install JES3 exit IATUX15.

   COMPONENT:  5752-SC1BA-EJS1102

   APARS FIXED: TIAT015

   SPECIAL CONDITIONS:
     ACTION:  An IPL with JES3 warm start is required after
       installation of this user modification.

   COMMENTS:
     LAST CHANGE:  2006/05/28

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MODULES
       IATUX15
 */.
++ SRC      (IATUX15 ) DISTLIB(AJES3SRC) SYSLIB(SAMPLIB ).
ATUX15  TITLE '    JES3 initialization card scan user exit'
***********************************************************************
*                                                                     *
* Module Name:                                                        *
*              IATUX15                                                *
*                                                                     *
* Copyright:                                                          *
*              None                                                   *
*                                                                     *
* Level:                                                              *
*              JES3 SU26 (VS2 - 3.8)                                  *
*                                                                     *
* Patch Label:                                                        *
*              No patch provided                                      *
*                                                                     *
* Function:                                                           *
*              IATUX15 is given control by JES3 during                *
*              initialization card reading immediately after          *
*              the GET has occurred.  JES3 does not                   *
*              examine a statement in any way until the exit          *
*              has returned with a code indicating that the           *
*              statement is to be used.  If the return code           *
*              indicates that the statement is to be rejected,        *
*              it is discarded without further action.                *
*                                                                     *
*              This IATUX15 exit checks for specification of          *
*              the FORMAT parameter via the P= keyword in             *
*              response to message IAT3012.  If FORMAT was            *
*              specified, any TRACK statement encountered in          *
*              the initialization deck is converted to a              *
*              FORMAT statement.                                      *
*                                                                     *
* Dependencies:                                                       *
*              None                                                   *
*                                                                     *
* Restrictions:                                                       *
*              None                                                   *
*                                                                     *
* Processor:                                                          *
*              VS Assembler                                           *
*                                                                     *
* Attributes:                                                         *
*              None                                                   *
*                                                                     *
* Register Conventions:                                               *
*              R0  - Operator supplied parameter                      *
*                 Byte  0   Length of parameter                       *
*                 Bytes 1-3 Address of parameter                      *
*                 If R0 = 0, no parameter was supplied                *
*              R1  - Address of input card                            *
*                 Bit   0   If on, entry is from IATINGL              *
*                 Bit   0   If off, entry is from IATINRN             *
*              R2-R12 - May be used as desired without being saved    *
*              R13 - Points to an available 18-word save area         *
*              R14 - Return address                                   *
*              R15 - Entry address of IATUX15, and temporary base     *
*                                                                     *
* Entry Points:                                                       *
*              IATUX15                                                *
*                                                                     *
* Entry Purpose:                                                      *
*              Provide capability to scan every initialization card   *
*                                                                     *
* Entry Linkage:                                                      *
*              Entry is via a  BAL  R14,R15.                          *
*              Entry may be from IATINGL, in which case byte 0        *
*                 of R1 will be X'80'.                                *
*              When entry is from IATINRN, byte 0 of R1 is 0.         *
*                                                                     *
* Input:                                                              *
*              R0 - Length/location of parameter                      *
*              R1 - Address of card.  See also entry linkage.         *
*                                                                     *
* Exit-Normal:                                                        *
*              BR   R14                                               *
*                                                                     *
* Exit-Error:                                                         *
*              None                                                   *
*                                                                     *
* Exit-User:                                                          *
*              None                                                   *
*                                                                     *
* Output:                                                             *
*              R15 = 0  to accept card                                *
*              R15 = 4  to delete card                                *
*                                                                     *
* External Routines:                                                  *
*              None                                                   *
*                                                                     *
* Control Blocks:                                                     *
*              None                                                   *
*                                                                     *
* Executable Macros:                                                  *
*              FREEMAIN, GETMAIN, RETURN.                             *
*                                                                     *
* Enqueue Resources:                                                  *
*              None                                                   *
*                                                                     *
* MP Locks Used:                                                      *
*              None                                                   *
*                                                                     *
* Messages:                                                           *
*              None                                                   *
*                                                                     *
* Abend Codes:                                                        *
*              None                                                   *
*                                                                     *
***********************************************************************
         EJECT ,
*----------------------------------------------------------------*
*        Mapping of initialization card as "TRACK," card.        *
*----------------------------------------------------------------*
CTDSECT  DSECT ,                   Map "TRACK," card
CTSTMT   DS    0CL72               Entire initialization card
CTNAME   DS    C'TRACK'            "TRACK" statement name
CTOP     DS    CL(L'CTSTMT-(*-CTSTMT)-2)                               +
                                   Operand of "TRACK" statement
         DS    CL1                 Byte lost in shift right
CTCONT   DS    CL1                 Continuation character
CTEND    EQU   *-CTSTMT            Symbolic length of fields
         DS    0S(CTEND-L'CTSTMT)  Ensure all bytes
         DS    0S(L'CTSTMT-CTEND)   are accounted for
         SPACE 2
*----------------------------------------------------------------*
*        Mapping of initialization card as "FORMAT," card.       *
*----------------------------------------------------------------*
CFDSECT  DSECT ,                   Map "FORMAT," card
CFSTMT   DS    0CL72               Entire initialization card
CFNAME   DS    C'FORMAT'           "FORMAT" statement name
CFOP     DS    CL(L'CFSTMT-(*-CFSTMT)-1)                               +
                                   Operand of "FORMAT" statement
CFCONT   DS    CL1                 Continuation character
CFEND    EQU   *-CFSTMT            Symbolic length of fields
         DS    0S(CFEND-L'CFSTMT)  Ensure all bytes
         DS    0S(L'CFSTMT-CFEND)   are accounted for
         EJECT ,
IATUX15  CSECT ,                   Begin CSECT
         IATYEQU ,                 General equates
         IATYREG ,                 Register equates
         EJECT ,
******************************************************************
*                                                                *
*        INIT:                                                   *
*                                                                *
*        Perform program initialization.                         *
*                                                                *
*        R0  = (at entry) Address of "P=" parameter.             *
*        R1  = (at entry) Address of initialization deck card.   *
*        R3  = Address of "P=" parameter (from R0 at entry).     *
*        R4  = Address of initialization deck card (from         *
*              R1 at entry).                                     *
*        R12 = Program base register.                            *
*        R13 = Address of caller's save area.                    *
*        R15 = (at entry) Entry point address.                   *
*                                                                *
*        Workregs = None.                                        *
*                                                                *
******************************************************************
         SPACE 1
INIT     DS    0H                  Program initialization
         USING IATUX15,R15         Temporary addressability
         IATYMOD ,                 Generate eyecatcher
         STM   R14,R12,12(R13)     Save caller's registers
         LR    R12,R15             Set program base register
         USING IATUX15,R12         Addressability for program
         DROP  R15                 End temporary addressability
         LR    R3,R0               Save pointer to parameter
         LR    R4,R1               Save pointer to card
         EJECT ,
******************************************************************
*                                                                *
*        CKFORMAT:                                               *
*                                                                *
*        Test if the initialization card we're currently         *
*        processing is a "TRACK" statement and skip further      *
*        exit processing if not.  If we're looking at a          *
*        "TRACK" card, test if operator specified "P=FORMAT"     *
*        in response to IAT3013 message and skip further         *
*        processing if not.                                      *
*                                                                *
*        R3  = Address of "P=" parameter.                        *
*        R4  = Address of initialization deck card.              *
*        R12 = Program base register.                            *
*        R13 = Address of caller's save area - not referenced.   *
*                                                                *
*        Workregs = R0, R15.                                     *
*                                                                *
******************************************************************
         SPACE 1
CKFORMAT DS    0H                  Test for P=FORMAT and TRACK card
         CLC   KTRACK,0(R4)        Is this card "TRACK"?
         BNE   RETURN              No change to statement if not
         LTR   R3,R3               Was "P=" parm specified?
         BZ    RETURN              Skip change to statement if not
         LR    R15,R3              Isolate length
         SRL   R15,24               of "P=" parm
         LA    R0,L'KFORMAT        Get "FORMAT" length
         CR    R0,R15              Could parm be "FORMAT"?
         BNE   RETURN              Skip change if not
         CLC   KFORMAT,0(R3)       Is parm "FORMAT"?
         BNE   RETURN              Skip change if not
         EJECT ,
******************************************************************
*                                                                *
*        STFORMAT:                                               *
*                                                                *
*        The operator specified "P=FORMAT", and the              *
*        current card from the initialization deck is            *
*        a "TRACK" card.  Change the initialization              *
*        statement from "TRACK" to "FORMAT" to force             *
*        the spool volume identified by the statement            *
*        to be formatted.                                        *
*                                                                *
*        R3  = Address of "P=" parameter - not referenced.       *
*        R4  = Address of initialization deck card.              *
*        R12 = Program base register.                            *
*        R13 = Address of caller's save area - not referenced.   *
*                                                                *
*        Workregs = R0, R1, R15.                                 *
*                                                                *
******************************************************************
         SPACE 1
STFORMAT DS    0H                  Change TRACK card to FORMAT
         GETMAIN RU,LV=L'CTOP      Get storage to save operand
         USING CTDSECT,R4          Address TRACK card
         MVC   0(L'CTOP,R1),CTOP   Save operand from TRACK card
         DROP  R4                  End TRACK card addressability
         USING CFDSECT,R4          Address FORMAT card
         MVC   CFNAME,KFORMAT      Set "FORMAT" name in card
         MVC   CFOP,0(R1)          Shift operand right one byte
         DROP  R4                  End FORMAT card addressability
         FREEMAIN RU,LV=L'CTOP,    Free storage                        +
               A=(1)                used to save operand
         EJECT ,
******************************************************************
*                                                                *
*        RETURN:                                                 *
*                                                                *
*        Exit processing is complete.  Return to JES3            *
*        with return code zero, indicating that the              *
*        (possibly modified) initialization statement            *
*        should be processed.                                    *
*                                                                *
*        R12 = Program base register.                            *
*        R13 = Address of caller's save area.                    *
*                                                                *
*        Workregs = None.                                        *
*                                                                *
******************************************************************
         SPACE 1
RETURN   DS    0H                  Return to JES3
         RETURN (14,12),RC=0       Return with return code 0
         EJECT ,
******************************************************************
*                                                                *
*        Constants and literals.                                 *
*                                                                *
******************************************************************
         SPACE 1
KTRACK   DC    C'TRACK,'           Compare for "TRACK,"
KFORMAT  DC    C'FORMAT'           Compare for "FORMAT"
         LTORG ,                   Generate literal pool
         SPACE 1
         DC    0D'0'               Pad to double word
         END   ,
??
//SMPCNTL  DD  *
  RECEIVE S(TIAT015)
        .
//*
//APPLYCK  EXEC SMPAPP,WORK='SYSALLDA'
//SMPCNTL  DD  *
  APPLY S(TIAT015)
        CHECK
        BYPASS(ID)
        .
//*
//APPLY    EXEC SMPAPP,COND=(0,NE),WORK='SYSALLDA'
//SMPCNTL  DD  *
  APPLY S(TIAT015)
        DIS(WRITE)
        .
//
//REJECT   EXEC SMPREC,WORK='SYSALLDA'
//SMPCNTL  DD  *
  REJECT S(TIAT015).
//
//RESTORE  EXEC SMPAPP,COND=(0,NE),WORK='SYSALLDA'
//SMPCNTL  DD  *
  RESTORE S(TIAT015).
//
