//TMVS806  JOB  (SYSGEN),TMVS806,
//*            RESTART=APPLYCK.SMP,
//*            RESTART=APPLY.SMP,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),REGION=8192K
//*
//* 2023/03/27 @kl TMVS806 - Add symptom dump display routine
//*                          SYSVTSYM, and a hook to link to it
//*                          in RTM dump module IEAVTABD.
//*
//* C:\Hercules\mvs\usermods\zapcode7.pl Fri Oct 14 16:46:10 2022 */
//RECEIVE  EXEC SMPREC,WORK='SYSALLDA'
//SMPPTFIN   DD DATA,DLM='??'
++ USERMOD(TMVS806)     /* REWORK(20230327) */             .
++ VER (Z038)
   FMID(EBB1102)
   PRE  (UZ62593)
/*
   PROBLEM DESCRIPTION(S):
     TMVS806 -
       Add symptom dump display routine SYSVTSYM, and
       a hook to link to it in RTM dump module IEAVTABD.

       SYSVTSYM produces output that is generally compatible
       with that produced by the IBM routine IEAVTSYM in later
       MVS releases.  There are three differences between
       SYSVTSYM and the later IBM code:

       1)  The symptom dump routine tries to find the name of
           the load module containing the abend PSW address.
           IEAVTSYM searches the job pack queue and the active RB
           queue to find the module name.  SYSVTSYM searches the
           job pack queue, the active LPA queue and the pageable
           link pack directory.

       2)  The symptom dump routine attempts to display 12 bytes
           surrounding the abend PSW address.  IEAVTSYM accesses
           the storage to be displayed in the TCB protect key.
           SYSVTSYM accesses the storage in key zero.  This avoids
           any possible protection exception because of a protect
           key mismatch.

       3)  It is theoretically possible for the 12 bytes to be
           displayed to cross a page boundary, and for one of the
           two pages to be displayable while the other isn't,
           perhaps because there are no segment and page tables for
           it.  IEAVTSYM has elaborate and complex code to deal
           with this extremely rare case.  SYSVTSYM does not
           attempt to: if any of the 12 bytes cannot be accessed,
           the whole range is considered inaccessible and an
           error message is displayed instead.  This prevents a
           partial storage display in the exception case, but makes
           the code much simpler.

   COMPONENT:  5752-SC1CM-EBB1102

   APARS FIXED: TMVS806

   SPECIAL CONDITIONS:
     ACTION:  An IPL with CLPA is required after installation
       of this user modification.

     DOCUMENTATION:  Description of message IEA912I added.

       Publication:  OS/VS2 MVS System Messages
       Form Number:  GC38-1002

       Message IEA912I is added as follows:

         IEA912I RECOVERY/TERMINATION SYMPTOM DUMP FAILED
                 DUE TO reason

           Explanation:  During recover from an abend, a symptom
             dump was attempted but failed for one of the following
             reasons:

             If reason is "GETMAIN FAILURE":
               SYSVTSYM was unable to obtain work area storage.

             If reason is "ABEND IN SYSVTSYM":
               An abend occurred in SYSVTSYM during summary dump
               processing.

           System Action:  A symptom dump is not produced.

     DOCUMENTATION:  Description of message IEA995I added.

       Publication:  OS/VS2 MVS System Messages
       Form Number:  GC38-1002

       Message IEA995I is added as follows:

         IEA995I SYMPTOM DUMP OUTPUT
                 {SYSTEM|USER} COMPLETION CODE=cde [REASON CODE=rsn]
                  TIME=hh.nn.ss  SEQ=sssss  CPU=cccc  ASID=asid
                  PSW AT TIME OF ERROR xxxxxxxx xxxxxxxx  ILC x INTC xx
                  {ACTIVE LOAD MODULE=mmmm ADDRESS=aaaa OFFSET=nnnn |
                  NO ACTIVE MODULE FOUND}
                  {DATA AT PSW hhhhhhhh - dddddddd dddddddd dddddddd |
                  DATA AT PSW IS INACCESSIBLE}
                  GPR  0-3  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
                  GPR  4-7  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
                  GPR  8-11 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
                  GPR 12-15 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
                 END OF SYMPTOM DUMP

         The system issues this message whenever an abend
         completion code has the dump bit on.  In the message
         text:

           SYSTEM COMPLETION CODE=cde
              The system completion code from the abend macro.

           USER COMPLETION CODE=cde
              The user completion code from the abend macro.

           REASON CODE=reason-code
              The reason code if one can be determined.

           TIME=hh.mm.ss
              The time that the dump was written in hours (00
              through 23), in minutes (00 through 59), and in
              seconds (00 through 59).

           SEQ=sssss
              Sequence number for the dump.

           CPU=cccc
              The central processor identifier.  If cccc is 0000,
              the system did not determine on which processor the
              abend occurred.

           ASID=asid
              The address space identifier (ASID) of the failing
              task.

           PSW AT TIME OF ERROR xxxxxxxx xxxxxxxx
              The program status word (PSW) at the time of error.

           ILC x
              Instruction length code for the failing instruction.

           INTC xx
              Interrupt code for the failing instruction.

           ACTIVE LOAD MODULE=mmmm
              Load module name, if the PSW points to an active
              load module.

           ADDRESS=aaaa
              Address of the load module, if the PSW points to an
              active load module.

           OFFSET=nnnn
              Offset into the load module of the failing
              instruction, if the PSW points to an active
              load module.

           DATA AT PSW hhhhhhhh - dddddddd dddddddd dddddddd
              Address in the PSW minus six, followed by the
              contents of the three words beginning at the address
              in hhhhhhhh.

           DATA AT PSW IS INACCESSIBLE
              The 12 bytes of storage on either side of the abend
              PSW address could not be accessed.  This is probably
              due to the storage not being backed by page table
              entries.

           GPR n-n xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
              The content of the general purpose registers at the
              time of error.

   COMMENTS:
     LAST CHANGE:  2023/03/27

     REWORK HISTORY:
       2023/03/27: Write IEA995I message to system messages data set.
       2022/11/22: Fix missing SPACE statement.
       2022/10/14: Documentation.
       2022/10/01: Display the IEA995I message on the terminal if
                   the current job is a TSO user that has specified
                   PROFILE WTP.
       2002/04/19: Created.

     CROSS REFERENCE-MODULE/MACRO NAMES TO USERMODS
       IEAVTABD  TMVS806
       SYSVTSYM  TMVS806

     CROSS REFERENCE-USERMODS TO MODULE/MACRO NAMES
       TMVS806   IEAVTABD SYSVTSYM

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MODULES
       IEAVTABD
       SYSVTSYM

     LISTEND
 */.
++ JCLIN.
//LKED   EXEC PGM=IEWL,PARM=(RENT,REUS,REFR)
//SYSLMOD  DD DSN=SYS1.LPALIB
//AOSC5    DD DSN=SYS1.AOSC5
//SYSLIN   DD *
 INCLUDE AOSC5(SYSVTSYM)
 ENTRY SYSVTSYM
 NAME SYSVTSYM(R)
++ ZAP      (IEAVTABD) DISTLIB(AOSC5   ).
NAME IGC0001C IEAVTABD
IDRDATA TMVS806
VER 000005 C9C5C1E5E3C1C2C4          DC    C'IEAVTABD'      VERIFY MODULE NAME
VER 00000D 40F8F3F0F5F540            DC    C' 83055 '       VERIFY MODULE DATE
VER 000014 E4E9F6F2F5F9F3            DC    C'UZ62593'       VERIFY PTF LEVEL
VER 000192 9180,71C2        @RC00161 TM    RTM2NDMP,X'80'   SHOULD WE DUMP?
VER 000196 47E0,6182                 BNO   @RF00184         BRANCH IF SO
VER 0019D8 0000000000000000 PATCHLOC DC    ((@DATA-@PSTART)/20)X'00'
REP 000192 47F0,59C1                 B     PATCH            TO PATCH AREA
REP 0019E2 50D0,7324        PATCH    ST    R13,RTM2RMSA+4   SAVE CURRENT SA PTR
REP 0019E6 41D0,7320                 LA    R13,RTM2RMSA     POINT TO SA FOR LINK
REP 0019EA 41F0,D008                 LA    R15,8(,R13)      POINT TO LINK PLIST
REP 0019EE D70B,F000,F000            XC    0(12,R15),0(R15) ZERO PARM LIST AREA
REP 0019F4 4100,59F5                 LA    R0,EPNAME        GET PTR TO EP NAME
REP 0019F8 5000,F000                 ST    R0,0(0,R15)      STORE IN LINK PLIST
REP 0019FC 9680,F004                 OI    4(R15),X'80'     SET RETURN REQUESTED
REP 001A00 4100,59E9                 LA    R0,ERRET         PICK UP RETURN ADDR
REP 001A04 5000,F008                 ST    R0,8(0,R15)      STORE RETURN ADDRESS
REP 001A08 0A06                      SVC   6                LINK TO SYMDUMP
REP 001A0A 58D0,7324        ERRET    L     R13,RTM2RMSA+4   RESET R13 TO ABD SA
REP 001A0E 9180,71C2                 TM    RTM2NDMP,X'80'   CLOBBERED INSTRUCTIO
REP 001A12 47F0,6174                 B     @RC00161+4       RETURN TO MAINLINE
REP 001A16 E2E8E2E5E3E2E8D4 EPNAME   DC    CL8'SYSVTSYM'    SYMDUMP MODULE NAME
++ SRC      (SYSVTSYM) DISTLIB(ASAMPLIB) SYSLIB(SAMPLIB )
                       DISTMOD(AOSC5   ).
SYSVTSYM TITLE '    Symptom dump message formatter'                     00010000
*********************************************************************** 00020000
*                                                                     * 00030000
*                                                                     * 00040000
* Module name          =  SYSVTSYM                                    * 00050000
*                                                                     * 00060000
*                                                                     * 00070000
* Descriptive name     =  Symptom dump formatter routine for MVS 3.8. * 00080000
*                                                                     * 00090000
*                                                                     * 00100000
* Function             =  To build and display symptom dump           * 00110000
*                         WTO IEA995I containing completion           * 00120000
*                         code, errorid information, abend            * 00130000
*                         PSW, module name and offset, and            * 00140000
*                         registers at abend.                         * 00150000
*                                                                     * 00160000
*                                                                     * 00170000
* Notes                =  See below.                                  * 00180000
*                                                                     * 00190000
*   Dependencies       =  User modification TMVS806 must be           * 00200000
*                         installed to add a hook in IEAVTABD         * 00210000
*                         to call this routine during abend           * 00220000
*                         dump processing.                            * 00230000
*                                                                     * 00240000
*   Restrictions       =  Runs only on MVS 3.8.                       * 00250000
*                                                                     * 00260000
*   Registers          =  See entry point documentation.              * 00270000
*                                                                     * 00280000
*   Patch space        =  None.                                       * 00290000
*                                                                     * 00300000
*                                                                     * 00310000
* Module type          =  CSECT                                       * 00320000
*                                                                     * 00330000
*   Processor          =  Assembler XF                                * 00340000
*                                                                     * 00350000
*   Module size        =  See assembly listing.                       * 00360000
*                                                                     * 00370000
*   Attributes         =                                              * 00380000
*     Location         =  Link pack area                              * 00390000
*     State            =  Supervisor, enabled                         * 00400000
*     Key              =  0                                           * 00410000
*     Mode             =  Task                                        * 00420000
*     Serialization    =  None                                        * 00430000
*     Type             =  Reentrant                                   * 00440000
*                                                                     * 00450000
*                                                                     * 00460000
*********************************************************************** 00470000
         EJECT ,                                                        00480000
*********************************************************************** 00490000
*                                                                     * 00500000
*                                                                     * 00510000
* Operation            =                                              * 00520000
*                                                                     * 00530000
*     Get work area storage.  Issue error message and exit if         * 00540000
*     getmain fails.                                                  * 00550000
*                                                                     * 00560000
*     Create an ESTAE recovery routine.  In most cases, the           * 00570000
*     ESTAE will retry in the event of abend to skip further          * 00580000
*     symptom dump processing.  If an abend occurs while              * 00590000
*     SYSVTSYM is trying to copy the storage around the               * 00600000
*     original abend PSW address, though, the ESTAE retry             * 00610000
*     will modify the symptom dump message to indicate that           * 00620000
*     storage at the PSW address could not be accessed.               * 00630000
*                                                                     * 00640000
*     Initialize the WPL for the IEA995I symptom dump message         * 00650000
*     in our work area.                                               * 00660000
*                                                                     * 00670000
*     Format the completion code, error ID information,               * 00680000
*     instruction length code, interrupt code and abend PSW           * 00690000
*     into the IEA995I message.                                       * 00700000
*                                                                     * 00710000
*     Format the general registers at abend.                          * 00720000
*                                                                     * 00730000
*     Format 12 bytes of data around the abend PSW address,           * 00740000
*     six bytes on either side.  If the abend PSW address is          * 00750000
*     less than X'00006', zero is used as the lower bound             * 00760000
*     of the data being displayed.  If the range of data              * 00770000
*     being formatted would extend past X'FFFFFF' (the                * 00780000
*     maximum allowable 24-bit address), the range is                 * 00790000
*     adjusted down to make its high end X'FFFFFF'.  If any           * 00800000
*     part of the range is not accessible, an abend will              * 00810000
*     occur when SYSVTSYM is copying the data to our work             * 00820000
*     area.  In that case, our ESTAE retry routine will               * 00830000
*     modify the symptom dump message to indicate that data           * 00840000
*     at the PSW address could not be accessed.                       * 00850000
*                                                                     * 00860000
*     Next, try to identify the module in which the abend             * 00870000
*     occurred.  First search the job pack queue for a module         * 00880000
*     containing the abend PSW address.  If the address was           * 00890000
*     not found in a module on the job pack queue, search the         * 00900000
*     active LPA queue for a module containing the address.           * 00910000
*     If the address was not found in a module on the active          * 00920000
*     LPA queue, search the PLPA directory for a module               * 00930000
*     containing the address.  If a module containing the the         * 00940000
*     address is found, update the message with the module            * 00950000
*     name and offset from the start of the module, Otherwise,        * 00960000
*     update the message to indicate that no active module            * 00970000
*     could be found.                                                 * 00980000
*                                                                     * 00990000
*                                                                     * 01000000
*********************************************************************** 01010000
         EJECT ,                                                        01020000
*********************************************************************** 01030000
*                                                                     * 01040000
*                                                                     * 01050000
*     Format the reason code from R15 if there is one.  If the        * 01060000
*     "reason code" bit in the completion code word is on, as it      * 01070000
*     may be in a module assembled in MVS/XA or later, format the     * 01080000
*     reason code unconditionally.  If the "reason code" bit is       * 01090000
*     not on, and the abend is a program check, format the program    * 01100000
*     interrupt code as the reason code.  If the "reason code" bit    * 01110000
*     is not on and the abend is a system completion code, but not    * 01120000
*     a program check, search a table of completion codes known to    * 01130000
*     have reason codes.  If the code is found in the table,          * 01140000
*     format the reason code.                                         * 01150000
*                                                                     * 01160000
*     When the message has been built, issue the message via WTO      * 01170000
*     and write it to the system mesages data set.                    * 01180000
*                                                                     * 01190000
*     If the current job is a TSO user, and the user has requested    * 01200000
*     write-to-programmer messages at the terminal via the PROFILE    * 01210000
*     also write the message lines to the terminal using TPUT.        * 01220000
*                                                                     * 01230000
*     Then delete the recovery environment, free work storage and     * 01240000
*     return to RTM.                                                  * 01250000
*                                                                     * 01260000
*     Note the following differences between the processing of        * 01270000
*     SYSVTSYM and the processing performed by IBM's later symptom    * 01280000
*     dump routines:  (1) The IBM code tries to find the module       * 01290000
*     containing the abend PSW address by searching the job pack      * 01300000
*     queue and looking at active PRBs.  This code searches the job   * 01310000
*     pack queue, the active link pack area queue and finally the     * 01320000
*     pageable link pack directory to find the abend address.         * 01330000
*     (2) The IBM symptom dump code tries to access the storage       * 01340000
*     around the abend PSW address in the TCB protect key.  This      * 01350000
*     code accesses the storage in key zero.  (3) IBM symptom         * 01360000
*     dump routines contain extremely complex code that attempts      * 01370000
*     to handle the case in which the 12-byte area surrounding        * 01380000
*     the abend PSW address spans a page boundary, such that one      * 01390000
*     part of the area is accessible and the rest isn't.  This        * 01400000
*     allows handling an exception situation that almost never        * 01410000
*     occurs at the expense of extremely complicated code.  SYSVTSYM  * 01420000
*     tries to copy all 12 bytes for formatting.  If any byte         * 01430000
*     cannot be accessed, none of the bytes will be displayed.        * 01440000
*                                                                     * 01450000
*                                                                     * 01460000
*********************************************************************** 01470000
         EJECT ,                                                        01480000
*********************************************************************** 01490000
*                                                                     * 01500000
*                                                                     * 01510000
* Entry point          =  SYSVTSYM                                    * 01520000
*                                                                     * 01530000
*   Purpose            =  To build and display symptom dump           * 01540000
*                         WTO with abend information.                 * 01550000
*                                                                     * 01560000
*   Linkage            =  See entry point documentation.              * 01570000
*                                                                     * 01580000
*                                                                     * 01590000
* Entry point          =  ESTAERTN                                    * 01600000
*                                                                     * 01610000
*   Purpose            =  ESTAE routine                               * 01620000
*                                                                     * 01630000
*   Linkage            =  See entry point documentation.              * 01640000
*                                                                     * 01650000
*                                                                     * 01660000
* External references  =  See below.                                  * 01670000
*                                                                     * 01680000
*   Routines           =  None.                                       * 01690000
*                                                                     * 01700000
*   Data areas         =  See table below:                            * 01710000
*                                                                     * 01720000
*    Label               Description                                  * 01730000
*    ------------------  -----------------------------------          * 01740000
*    WORKA               Program dynamic work area                    * 01750000
*                                                                     * 01760000
*   Control blocks     =  See table below:                            * 01770000
*                                                                     * 01780000
*    Name      Macro     Description                          Usage   * 01790000
*    ----      --------  -----------------------------------  -----   * 01800000
*    CDE       IHACDE    OS Contents Directory Entry          R       * 01810000
*    CSCB      IEECHAIN  OS Command Scheduling Control Block  R       * 01820000
*    JSCB      IEZJSCB   OS Job Step Control Block            R       * 01830000
*    PSA       IHAPSA    Prefixed Low Storage Area            R       * 01840000
*    PSCB      IKJPSCB   TSO Protected Step Control Block     R       * 01850000
*    RB        IHARB     MVS Request Blocks                   R       * 01860000
*    RPL       IFGRPL    MVS Request Parameter List           RW      * 01870000
*    RTM2WA    IHARTM2A  RTM2 Work Area                       R       * 01880000
*    SDWA      IHASDWA   System Diagnostic Work Area          RW      * 01890000
*    TCB       IKJTCB    Task Control Block                   R       * 01900000
*    UPT       IKJUPT    TSO User Profile Table               R       * 01910000
*    WPL       IEZWPL    OS WTO Parameter List                RWCD    * 01920000
*    XTLST     IHAXTLST  OS Contents Supervision Extent List  R       * 01930000
*                                                                     * 01940000
*   Key = R-Read, W-Write, C-Create, D-Delete                         * 01950000
*                                                                     * 01960000
*                                                                     * 01970000
*********************************************************************** 01980000
         EJECT ,                                                        01990000
*********************************************************************** 02000000
*                                                                     * 02010000
*                                                                     * 02020000
* Tables               =  See table below:                            * 02030000
*                                                                     * 02040000
*    Label               Description                                  * 02050000
*    ------------------  -----------------------------------          * 02060000
*    CCTBL               System completion codes that have            * 02070000
*                        reason codes in R15.                         * 02080000
*                                                                     * 02090000
*                                                                     * 02100000
* Macros               =  ESTAE, FREEMAIN, GETMAIN, RETURN, SAVE,     * 02110000
*                         SDUMP, SETRP, WTO.                          * 02120000
*                                                                     * 02130000
*                                                                     * 02140000
* Messages             =  The following messages are issued by        * 02150000
*                         this module:                                * 02160000
*                                                                     * 02170000
*    IEA995I SYMPTOM DUMP OUTPUT                                      * 02180000
*            {SYSTEM|USER} COMPLETION CODE=cde [REASON CODE=rsn]      * 02190000
*             TIME=hh.nn.ss  SEQ=sssss  CPU=cccc  ASID=asid           * 02200000
*             PSW AT TIME OF ERROR xxxxxxxx xxxxxxxx  ILC x INTC xx   * 02210000
*             {ACTIVE LOAD MODULE=mmmm ADDRESS=aaaa OFFSET=nnnn |     * 02220000
*             NO ACTIVE MODULE FOUND}                                 * 02230000
*             {DATA AT PSW hhhhhhhh - dddddddd dddddddd dddddddd |    * 02240000
*             DATA AT PSW IS INACCESSIBLE}                            * 02250000
*             GPR  0-3  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx           * 02260000
*             GPR  4-7  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx           * 02270000
*             GPR  8-11 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx           * 02280000
*             GPR 12-15 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx           * 02290000
*            END OF SYMPTOM DUMP                                      * 02300000
*                                                                     * 02310000
*    The system issues this message whenever an abend completion      * 02320000
*    code has the dump bit on.  In the message text:                  * 02330000
*                                                                     * 02340000
*      SYSTEM COMPLETION CODE=cde                                     * 02350000
*         The system completion code from the abend macro.            * 02360000
*                                                                     * 02370000
*      USER COMPLETION CODE=cde                                       * 02380000
*         The user completion code from the abend macro.              * 02390000
*                                                                     * 02400000
*      REASON CODE=reason-code                                        * 02410000
*         The reason code if one can be determined.                   * 02420000
*                                                                     * 02430000
*      TIME=hh.mm.ss                                                  * 02440000
*         The time that the dump was written in hours (00 through     * 02450000
*         23), in minutes (00 through 59), and in seconds (00         * 02460000
*         through 59).                                                * 02470000
*                                                                     * 02480000
*      SEQ=sssss                                                      * 02490000
*         Sequence number for the dump.                               * 02500000
*                                                                     * 02510000
*                                                                     * 02520000
*********************************************************************** 02530000
         EJECT ,                                                        02540000
*********************************************************************** 02550000
*                                                                     * 02560000
*                                                                     * 02570000
*      CPU=cccc                                                       * 02580000
*         The central processor identifier.  If cccc is 0000, the     * 02590000
*         system did not determine on which processor the abend       * 02600000
*         occurred.                                                   * 02610000
*                                                                     * 02620000
*      ASID=asid                                                      * 02630000
*         The address space identifier (ASID) of the failing task.    * 02640000
*                                                                     * 02650000
*      PSW AT TIME OF ERROR xxxxxxxx xxxxxxxx                         * 02660000
*         The program status word (PSW) at the time of error.         * 02670000
*                                                                     * 02680000
*      ILC x                                                          * 02690000
*         Instruction length code for the failing instruction.        * 02700000
*                                                                     * 02710000
*      INTC xx                                                        * 02720000
*         Interrupt code for the failing instruction.                 * 02730000
*                                                                     * 02740000
*      ACTIVE LOAD MODULE=mmmm                                        * 02750000
*         Load module name, if the PSW points to an active load       * 02760000
*         module.                                                     * 02770000
*                                                                     * 02780000
*      ADDRESS=aaaa                                                   * 02790000
*         Address of the load module, if the PSW points to an         * 02800000
*         active load module.                                         * 02810000
*                                                                     * 02820000
*      OFFSET=nnnn                                                    * 02830000
*         Offset into the load module of the failing instruction,     * 02840000
*         if the PSW points to an active load module.                 * 02850000
*                                                                     * 02860000
*      DATA AT PSW hhhhhhhh - dddddddd dddddddd dddddddd              * 02870000
*         Address in the PSW minus six, followed by the contents      * 02880000
*         of the three words beginning at the address in hhhhhhhh.    * 02890000
*                                                                     * 02900000
*      DATA AT PSW IS INACCESSIBLE                                    * 02910000
*         The 12 bytes of storage on either side of the abend PSW     * 02920000
*         address could not be accessed.  This is probably due to     * 02930000
*         the storage not being backed by page table entries.         * 02940000
*                                                                     * 02950000
*      GPR n-n xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx                    * 02960000
*         The content of the general purpose registers at the         * 02970000
*         time of error.                                              * 02980000
*                                                                     * 02990000
*                                                                     * 03000000
*********************************************************************** 03010000
         EJECT ,                                                        03020000
*********************************************************************** 03030000
*                                                                     * 03040000
*                                                                     * 03050000
*    IEA912I RECOVERY/TERMINATION SYMPTOM DUMP FAILED                 * 03060000
*            DUE TO reason                                            * 03070000
*                                                                     * 03080000
*      A symptom dump was attempted but failed for one of the         * 03090000
*      following reasons.                                             * 03100000
*                                                                     * 03110000
*      If reason is "GETMAIN FAILURE":                                * 03120000
*         SYSVTSYM was unable to obtain work area storage.            * 03130000
*                                                                     * 03140000
*      If reason is "ABEND IN SYSVTSYM":                              * 03150000
*         An abend occurred in SYSVTSYM during summary dump           * 03160000
*         processing.                                                 * 03170000
*                                                                     * 03180000
*                                                                     * 03190000
* Abend codes          =  None.                                       * 03200000
*                                                                     * 03210000
*                                                                     * 03220000
* Wait state codes     =  None.                                       * 03230000
*                                                                     * 03240000
*                                                                     * 03250000
* Comments             =  None                                        * 03260000
*                                                                     * 03270000
*                                                                     * 03280000
* Change activity      =                                              * 03290000
*                                                                     * 03300000
*   Flag  Date        By    Description                               * 03310000
*   ----  ----------  ----  ----------------------------------------  * 03320000
*   $D05  2023/03/20  @KL   Write IEA995I message to the system       * 03330000
*                           messages data set.                        * 03340000
*   $D04  2022/11/22  @KL   Fix missing SPACE statement in            * 03350000
*                           assembler source.                         * 03360000
*   $D03  2022/10/14  @KL   Package SYSVTSYM source as part of        * 03370000
*                           usermod TMVS806.                          * 03380000
*   $D02  2022/10/01  @KL   Display the IEA995I message on the        * 03390000
*                           terminal if the current job is a          * 03400000
*                           TSO user that has specified               * 03410000
*                           PROFILE WTP                               * 03420000
*   $D01  2020/04/23  @KL   Add missing load for RTM's R13 in         * 03430000
*                           ESTAE routine before SETRP.               * 03440000
*   $D00  2002/06/26  @KL   Symptom dump routine for OS/VS2 3.8.      * 03450000
*                                                                     * 03460000
*                                                                     * 03470000
*********************************************************************** 03480000
         EJECT ,                                                        03490000
*********************************************************************** 03500000
*                                                                     * 03510000
*                                                                     * 03520000
* Entry point          =  SYSVTSYM                                    * 03530000
*                                                                     * 03540000
*   Purpose            =  To build and issue symptom dump WTO.        * 03550000
*                                                                     * 03560000
*   Linkage            =  From IEAVTABD via LINK SVC added by         * 03570000
*                         user modification TMVS806.                  * 03580000
*                                                                     * 03590000
*   Recovery           =  Most of the code in this routine is         * 03600000
*                         protected by the ESTAE routine ESTAERTN.    * 03610000
*                                                                     * 03620000
*   Input data         =                                              * 03630000
*       R0-R11 = Not applicable.                                      * 03640000
*       R13    = RTM2RMSA save area in current RTM2 work area.        * 03650000
*       R14    = Return address.                                      * 03660000
*       R15    = Entry address.                                       * 03670000
*                                                                     * 03680000
*   Registers saved    =  R0 - R15                                    * 03690000
*                                                                     * 03700000
*   Register usage     =                                              * 03710000
*       R0     = Work register                                        * 03720000
*       R1     = Work register                                        * 03730000
*       R2     = Work register                                        * 03740000
*       R3     = Work register                                        * 03750000
*       R4     = Work register                                        * 03760000
*       R5     = Work register                                        * 03770000
*       R6     = RTM2 Work Area                                       * 03780000
*       R7     = Work register                                        * 03790000
*       R8-10  = Not used                                             * 03800000
*       R11    = Program base register 2                              * 03810000
*       R12    = Program base register 1                              * 03820000
*       R13    = Program work/save area                               * 03830000
*       R14    = Work register                                        * 03840000
*       R15    = Work register                                        * 03850000
*                                                                     * 03860000
*   Registers restored =  R0 - R14                                    * 03870000
*                                                                     * 03880000
*   Exit (normal)      =  Return to IEAVTABD via BR R14.              * 03890000
*     Conditions       =  Symptom dump WTO successfully displayed.    * 03900000
*     Output           =  Message IEA995I containing symptom data.    * 03910000
*     Return code      =  0                                           * 03920000
*                                                                     * 03930000
*   Exit (error)       =  Return to IEAVTABD via BR R14.              * 03940000
*     Conditions       =  GETMAIN failed for work storage.            * 03950000
*     Output           =  Error message.                              * 03960000
*     Return code      =  8                                           * 03970000
*                                                                     * 03980000
*                                                                     * 03990000
*********************************************************************** 04000000
         TITLE '    Symptom dump message formatter - Define environment+04010000
               '                                                        04020000
*********************************************************************** 04030000
*                                                                     * 04040000
*        Define preprocessor symbol with message ID prefix.           * 04050000
*                                                                     * 04060000
*********************************************************************** 04070000
         SPACE 1                                                        04080000
         LCLC  &P                                                       04090000
&P       SETC  'IEA'                                                    04100000
         EJECT ,                                                        04110000
*********************************************************************** 04120000
*                                                                     * 04130000
*        Begin control section and define register equates.           * 04140000
*                                                                     * 04150000
*********************************************************************** 04160000
         SPACE 1                                                        04170000
SYSVTSYM CSECT ,                   Begin main CSECT                     04180000
         SPACE 1                                                        04190000
*----------------------------------------------------------------*      04200000
*        Register equates.                                       *      04210000
*----------------------------------------------------------------*      04220000
R0       EQU    0                                                       04230000
R1       EQU    1                                                       04240000
R2       EQU    2                                                       04250000
R3       EQU    3                                                       04260000
R4       EQU    4                                                       04270000
R5       EQU    5                                                       04280000
R6       EQU    6                                                       04290000
R7       EQU    7                                                       04300000
R8       EQU    8                                                       04310000
R9       EQU    9                                                       04320000
R10      EQU   10                                                       04330000
R11      EQU   11                                                       04340000
R12      EQU   12                                                       04350000
R13      EQU   13                                                       04360000
R14      EQU   14                                                       04370000
R15      EQU   15                                                       04380000
         TITLE '    Symptom dump message formatter - Initialization'    04390000
******************************************************************      04400000
*                                                                *      04410000
*        INIT:                                                   *      04420000
*                                                                *      04430000
*        Perform program initialization.  Save caller's          *      04440000
*        registers, establish base register and set up           *      04450000
*        addressability to RTM2 Work Area.                       *      04460000
*                                                                *      04470000
*        R6  = RTM2 Work Area - set in this routine.             *      04480000
*        R12 = Program base register.                            *      04490000
*                                                                *      04500000
*        Workregs:  R0.                                          *      04510000
*                                                                *      04520000
******************************************************************      04530000
         SPACE 1                                                        04540000
INIT     DS    0H                  Program initialization               04550000
         SAVE  (14,12),,           Save caller's registers             +04560000
               SYSVTSYM-&SYSDATE-&SYSTIME-$D05                     @D05 04570000
         LR    R12,R15             Set base register                    04580000
         USING SYSVTSYM,R12        Addressability for program           04590000
         LR    R11,R12             ** Set                               04600000
         LA    R11,4094(,R11)      **  second                           04610000
         LA    R11,1(,R11)         **   base register                   04620000
         USING SYSVTSYM,R12,R11    **                                   04630000
         SPACE 1                                                        04640000
*----------------------------------------------------------------*      04650000
*        At entry, R13 contains the address of the Resource      *      04660000
*        Manager Save Area in the current RTM2 Work Area (we     *      04670000
*        know that because we put it there, in the hook we       *      04680000
*        added to IEAVTABD).  Back up to the start of the        *      04690000
*        RTM2WA and point R6 at it.                              *      04700000
*----------------------------------------------------------------*      04710000
         LR    R6,R13              Calculate                            04720000
         LA    R0,RTM2RMSA-RTM2WA   address of                          04730000
         SR    R6,R0                 RTM2 Work Area                     04740000
         USING RTM2WA,R6           Address RTM2 Work Area               04750000
         TITLE '    Symptom dump message formatter - Get work storage'  04760000
******************************************************************      04770000
*                                                                *      04780000
*        GETWORK:                                                *      04790000
*                                                                *      04800000
*        Get storage for work area.  Exit with error if          *      04810000
*        getmain fails.  If storage was successfully             *      04820000
*        obtained, initialize it to binary zeroes                *      04830000
*        and chain save areas.                                   *      04840000
*                                                                *      04850000
*        R13 = Program work/save area - obtained in this         *      04860000
*              routine.                                          *      04870000
*                                                                *      04880000
*        Workregs:  R0, R1, R2, R14, R15.                        *      04890000
*                                                                *      04900000
******************************************************************      04910000
         SPACE 1                                                        04920000
GETWORK  DS    0H                  Obtain work area storage             04930000
         GETMAIN RC,LV=LWORKA,     Get storage                         +04940000
               SP=WORKSP            for work area                       04950000
         LTR   R15,R15             Was getmain successful?              04960000
         BNZ   GMFAIL              Exit with error if not               04970000
         LR    R2,R1               Copy address of getmained storage    04980000
         LR    R0,R1               Set target address for MVCL          04990000
         LA    R1,LWORKA           Set target length for MVCL           05000000
         XR    R15,R15             Set pad byte to zero                 05010000
         MVCL  R0,R14              Zero getmained storage               05020000
         LR    R15,R13             Save caller's save area address      05030000
         LR    R13,R2              Point to our work/save area          05040000
         USING WORKA,R13           Addressability for work area         05050000
         ST    R15,4(,R13)         Chain                                05060000
         ST    R13,8(,R15)          save areas                          05070000
         TITLE '    Symptom dump message formatter - Create recovery en+05080000
               vironment'                                               05090000
******************************************************************      05100000
*                                                                *      05110000
*        ISSESTAE:                                               *      05120000
*                                                                *      05130000
*        Issue ESTAE to create recovery environment.  The        *      05140000
*        ESTAE "PARAM" parameter points to an area in the        *      05150000
*        main routine's R13-based work area immediately          *      05160000
*        following the main routine's save area.  The ESTAE      *      05170000
*        routine will load that address into its R13 as its      *      05180000
*        save area, and will thus be able to address the         *      05190000
*        main routine's work area via R13.                       *      05200000
*                                                                *      05210000
*        R6  = RTM2 Work Area.                                   *      05220000
*        R13 = Program work/save area.                           *      05230000
*                                                                *      05240000
*        Workregs:  R0, R1, R2, R3, R14, R15.                    *      05250000
*                                                                *      05260000
******************************************************************      05270000
         SPACE 1                                                        05280000
ISSESTAE DS    0H                  Create recovery environment          05290000
         LA    R15,DELESTAE        Set retry address                    05300000
         ST    R15,ERESTART         for return to RTM                   05310000
         L     R2,=A(ESTAERTN)     Get ESTAE routine address            05320000
         LA    R3,ERSAVEA          Point to ESTAE work area             05330000
         MVC   STAEPRM,MSTAEPRM    Copy model ESTAE parm list           05340000
         ESTAE (R2),CT,TERM=YES,   Create                              +05350000
               PARAM=(R3),          recovery                           +05360000
               MF=(E,STAEPRM)        environment                        05370000
         TITLE '    Symptom dump message formatter - Copy model WPL for+05380000
                symptom dump message to work area'                      05390000
******************************************************************      05400000
*                                                                *      05410000
*        COPYMWPL:                                               *      05420000
*                                                                *      05430000
*        Copy model WPL for IEA995I message to work area.        *      05440000
*                                                                *      05450000
*        R6  = RTM2 Work Area - not referenced.                  *      05460000
*        R13 = Program work/save area.                           *      05470000
*                                                                *      05480000
*        Workregs:  R0, R1, R14, R15.                            *      05490000
*                                                                *      05500000
******************************************************************      05510000
         SPACE 1                                                        05520000
COPYMWPL DS    0H                  Copy model IEA995I WPL               05530000
         LA    R0,MSG995           Point to area for WPL                05540000
         LA    R1,L'MSG995         Get WPL area length                  05550000
         L     R14,=A(MMSG995)     Point to model WPL                   05560000
         LR    R15,R1              Get model WPL length                 05570000
         MVCL  R0,R14              Copy model WPL for IEA995I msg       05580000
         TITLE '    Symptom dump message formatter - Format completion +05590000
               code'                                                    05600000
******************************************************************      05610000
*                                                                *      05620000
*        FMCC:                                                   *      05630000
*                                                                *      05640000
*        Format completion code into message.  If it is          *      05650000
*        a system abend, save the completion code for            *      05660000
*        later use by the reason code determination routine.     *      05670000
*                                                                *      05680000
*        R6  = RTM2 Work Area.                                   *      05690000
*        R12 = Program base register.                            *      05700000
*        R13 = Program work/save area.                           *      05710000
*                                                                *      05720000
*        Workregs:  R14, R15.                                    *      05730000
*                                                                *      05740000
******************************************************************      05750000
         SPACE 1                                                        05760000
FMCC     DS    0H                  Format completion code               05770000
         SPACE 1                                                        05780000
*----------------------------------------------------------------*      05790000
*        Determine if completion code is system or user.         *      05800000
*----------------------------------------------------------------*      05810000
         XC    SYSCC,SYSCC         Assume user completion code          05820000
         XR    R14,R14             Clear system code register           05830000
         XR    R15,R15             Clear user code register             05840000
         ICM   R15,7,RTM2CC        Get completion code                  05850000
         SLDL  R14,20              System code in R14, user in R15      05860000
         LTR   R14,R14             Is there a system code?              05870000
         BNZ   FMSYSCC             Branch if system code                05880000
         SPACE 1                                                        05890000
*----------------------------------------------------------------*      05900000
*        Format user completion code.                            *      05910000
*----------------------------------------------------------------*      05920000
         SRL   R15,20              Move user code to low order bits     05930000
         CVD   R15,DWORK           Convert user code to packed          05940000
         UNPK  DWORK(5),DWORK+5(3) Make user code zoned                 05950000
         OI    DWORK+4,X'F0'       Force printable sign                 05960000
         MVC   M5CC,DWORK+1        Set user code in message             05970000
         MVC   M5CCTYPE,KUSER      Show user code                       05980000
         B     COPYPSW             Continue                             05990000
         SPACE 1                                                        06000000
*----------------------------------------------------------------*      06010000
*        Format system completion code.                          *      06020000
*----------------------------------------------------------------*      06030000
FMSYSCC  DS    0H                  Format system completion code        06040000
         STCM  R14,3,SYSCC         Save system completion code          06050000
         SLL   R14,12              System code to high order bits       06060000
         STCM  R14,15,DWORK+4      Set in work area                     06070000
         UNPK  DWORK(5),DWORK+5(3) Unpack                               06080000
         TR    DWORK(4),HEXTBL     Translate to hex                     06090000
         MVC   M5CC,DWORK          Move into message                    06100000
         MVI   M5CC+3,C' '         Blank unused position                06110000
         MVC   M5CCTYPE,KSYSTEM    Show system code                     06120000
         B     COPYPSW             Continue                             06130000
         TITLE '    Symptom dump message formatter - '                  06140000
******************************************************************      06150000
*                                                                *      06160000
*        COPYPSW:                                                *      06170000
*                                                                *      06180000
*        Get PSW, next instruction address, general              *      06190000
*        registers at abend, interrupt code and instruction      *      06200000
*        length code.  Ordinarily, this information will         *      06210000
*        be in the RTM2 Work Area.  However, MVS 3.8             *      06220000
*        doesn't properly put that information in the            *      06230000
*        RTM2WA for a system x22 abend.  If this is a            *      06240000
*        system x22, get abend PSW, next instruction             *      06250000
*        address, registers, interrupt code and instruction      *      06260000
*        length code from the appropriate request blocks         *      06270000
*        and RB prefix.                                          *      06280000
*                                                                *      06290000
*        R6  = RTM2 Work Area.                                   *      06300000
*        R11 = Program base register 2.                          *      06310000
*        R12 = Program base register 1.                          *      06320000
*        R13 = Program work/save area.                           *      06330000
*                                                                *      06340000
*        Workregs:  R14, R15.                                    *      06350000
*                                                                *      06360000
******************************************************************      06370000
         SPACE 1                                                        06380000
COPYPSW  DS    0H                                                       06390000
         SPACE 1                                                        06400000
*----------------------------------------------------------------*      06410000
*        Determine if the abend is a system x22.                        06420000
*----------------------------------------------------------------*      06430000
         MVC   CCWORK,SYSCC        Copy abend code to work area         06440000
         NC    CCWORK,=XL2'0022'   Mask unwanted digits                 06450000
         CLC   CCWORK,=X'0022'     Was abend system x22?                06460000
         BNE   CP2WA               No, get information from RTM2WA      06470000
         SPACE 1                                                        06480000
*----------------------------------------------------------------*      06490000
*        This is a system x22 abend.  MVS 3.8 doesn't            *      06500000
*        properly initialize the RTM2WA for x22 abends,          *      06510000
*        so get the general purpose registers at abend           *      06520000
*        from RTM's request block, the PSW and next              *      06530000
*        instruction address from the abending program's         *      06540000
*        request block, and ILC and interrupt code from          *      06550000
*        the abending program's RB prefix.                       *      06560000
*----------------------------------------------------------------*      06570000
CPRB     DS    0H                  Get data from request blocks         06580000
         L     R15,RTM2VRBC        Point to RTM's SVRB                  06590000
         USING RBBASIC,R15         Addressability for RB                06600000
         MVC   REREG,RBGRSAVE      Get registers from RTM RB            06610000
         L     R15,RBLINK          Point to abending RB                 06620000
         MVC   REPSW,RBOPSW        Get PSW from abending RB             06630000
         L     R14,REPSW+4         Get next instruction address         06640000
         LA    R14,0(,R14)         Clear high-order bits                06650000
         ST    R14,RNXT1           Save next instruction address        06660000
         LA    R0,RBPRFXLN         Get RB prefix length                 06670000
         SR    R15,R0              Point to RB prefix                   06680000
         DROP  R15                 End RB addressability                06690000
         USING RBPREFIX,R15        Addressability for RB prefix         06700000
         MVC   INTCOD,RBINTCOD     Copy interrupt code                  06710000
         MVC   INLNTH,RBINLNTH     Copy ILC                             06720000
         DROP  R15                 End RB prefix addressability         06730000
         B     FMERRINF            Continue                             06740000
         EJECT ,                                                        06750000
******************************************************************      06760000
*                                                                *      06770000
*        COPYPSW (continued):                                    *      06780000
*                                                                *      06790000
******************************************************************      06800000
         SPACE 1                                                        06810000
*----------------------------------------------------------------*      06820000
*        Not x22 abend.  Get PSW, next instruction,              *      06830000
*        registers at abend, ILC and interrupt code              *      06840000
*        from RTM2 Work Area.                                    *      06850000
*----------------------------------------------------------------*      06860000
CP2WA    DS    0H                  Get data from RTM2WA                 06870000
         MVC   REREG,RTM2EREG      Get registers from RTM2WA            06880000
         MVC   REPSW,RTM2EPSW      Get PSW from RTM2WA                  06890000
         L     R14,REPSW+4         Get next instruction address         06900000
         LA    R14,0(,R14)         Clear high-order bits                06910000
         ST    R14,RNXT1           Save next instruction address        06920000
         MVC   INLNTH,RTM2ILC1     Copy ILC from RTM2WA                 06930000
         MVC   INTCOD,RTM2INC1     Copy interrupt code from RTM2WA      06940000
         B     FMERRINF            Continue                             06950000
         TITLE '    Symptom dump message formatter - Format sequence nu+06960000
               number, CPU ID and ASID'                                 06970000
******************************************************************      06980000
*                                                                *      06990000
*        FMERRINF:                                               *      07000000
*                                                                *      07010000
*        Format sequence number, CPU ID and ASID from            *      07020000
*        RTM2WA errorid.                                         *      07030000
*                                                                *      07040000
*        R6  = RTM2 Work Area.                                   *      07050000
*        R11 = Program base register 2.                          *      07060000
*        R12 = Program base register 1.                          *      07070000
*        R13 = Program work/save area.                           *      07080000
*        R14 = Subroutine linkage.                               *      07090000
*                                                                *      07100000
*        Workregs:  R1, R14.                                     *      07110000
*                                                                *      07120000
******************************************************************      07130000
         SPACE 1                                                        07140000
FMERRINF DS    0H                  Format information from errorid      07150000
         SPACE 1                                                        07160000
*----------------------------------------------------------------*      07170000
*        Format sequence number from errorid.                    *      07180000
*----------------------------------------------------------------*      07190000
         XR    R1,R1               Get sequence number                  07200000
         ICM   R1,3,RTM2SEQ#        from RTM2WA                         07210000
         CVD   R1,DWORK              convert it to packed               07220000
         OI    DWORK+7,X'0F'          force printable sign              07230000
         UNPK  M5SEQ,DWORK             and unpack into message          07240000
         SPACE 1                                                        07250000
*----------------------------------------------------------------*      07260000
*        Format CPU ID from errorid.                             *      07270000
*----------------------------------------------------------------*      07280000
         XR    R1,R1               Get CPU ID                           07290000
         ICM   R1,3,RTM2CPUI        from RTM2WA                         07300000
         BAL   R14,HEXTOPRT          convert to printable               07310000
         MVC   M5CPU,HEXWORK+4        and copy into message             07320000
         SPACE 1                                                        07330000
*----------------------------------------------------------------*      07340000
*        Format ASID from errorid.                               *      07350000
*----------------------------------------------------------------*      07360000
         XR    R1,R1               Get ASID                             07370000
         ICM   R1,3,RTM2ERAS        from RTM2WA                         07380000
         BAL   R14,HEXTOPRT          convert to printable               07390000
         MVC   M5ASID,HEXWORK+4       and copy into message             07400000
         TITLE '    Symptom dump message formatter - Format time of err+07410000
               or'                                                      07420000
******************************************************************      07430000
*                                                                *      07440000
*        FMERRTIM:                                               *      07450000
*                                                                *      07460000
*        Format time of error from RTM2WA errorid.  The          *      07470000
*        error time (referred to as "t" below) is in             *      07480000
*        tenths of seconds since midnight.                       *      07490000
*                                                                *      07500000
*        R6  = RTM2 Work Area.                                   *      07510000
*        R11 = Program base register 2.                          *      07520000
*        R12 = Program base register 1.                          *      07530000
*        R13 = Program work/save area.                           *      07540000
*                                                                *      07550000
*        Workregs:  R0, R1, R14, R15.                            *      07560000
*                                                                *      07570000
******************************************************************      07580000
         SPACE 1                                                        07590000
FMERRTIM DS    0H                  Format errorid timestamp             07600000
         SPACE 1                                                        07610000
*----------------------------------------------------------------*      07620000
*        Calculate seconds as INT(t/10)-(INT(INT(t/10)/60)*60).  *      07630000
*----------------------------------------------------------------*      07640000
         ICM   R15,15,RTM2ERTM     Get time in 1/10 seconds             07650000
         AH    R15,=H'5'           Round if appropriate                 07660000
         XR    R14,R14             Calculate                            07670000
         D     R14,=F'10'           residual                            07680000
         XR    R14,R14               seconds                            07690000
         D     R14,=F'60'             in R14                            07700000
         CVD   R14,DWORK           Convert seconds to packed            07710000
         OI    DWORK+7,X'0F'       Force printable sign                 07720000
         UNPK  M5SS,DWORK          Unpack seconds into message          07730000
         SPACE 1                                                        07740000
*----------------------------------------------------------------*      07750000
*        Calculate minutes as INT(t/600)-(INT(INT(t/600)/60)*60).*      07760000
*----------------------------------------------------------------*      07770000
         ICM   R15,15,RTM2ERTM     Get time in 1/10 seconds             07780000
         AH    R15,=H'5'           Round if appropriate                 07790000
         XR    R14,R14             Calculate                            07800000
         D     R14,=F'600'          residual                            07810000
         XR    R14,R14               minutes                            07820000
         D     R14,=F'60'             in R14                            07830000
         CVD   R14,DWORK           Convert minutes to packed            07840000
         OI    DWORK+7,X'0F'       Force printable sign                 07850000
         UNPK  M5MM,DWORK          Unpack minutes into message          07860000
         SPACE 1                                                        07870000
*----------------------------------------------------------------*      07880000
*        Calculate hours as INT(t/36000).                        *      07890000
*----------------------------------------------------------------*      07900000
         ICM   R15,15,RTM2ERTM     Get time in 1/10 seconds             07910000
         AH    R15,=H'5'           Round if appropriate                 07920000
         XR    R14,R14             Calcualate residual hours            07930000
         D     R14,=F'36000'        in R15                              07940000
         CVD   R15,DWORK           Convert hours to packed              07950000
         OI    DWORK+7,X'0F'       Force printable sign                 07960000
         UNPK  M5HH,DWORK          Unpack hours into message            07970000
         TITLE '    Symptom dump message formatter - Format instruction+07980000
                length code, interrupt code and PSW'                    07990000
******************************************************************      08000000
*                                                                *      08010000
*        FMIIP:                                                  *      08020000
*                                                                *      08030000
*        Format instruction length code, interrupt code and      *      08040000
*        abend PSW.                                              *      08050000
*                                                                *      08060000
*        R6  = RTM2 Work Area - not referenced.                  *      08070000
*        R11 = Program base register 2.                          *      08080000
*        R12 = Program base register 1.                          *      08090000
*        R13 = Program work/save area.                           *      08100000
*        R14 = Subroutine linkage.                               *      08110000
*                                                                *      08120000
*        Workregs:  R1, R15.                                     *      08130000
*                                                                *      08140000
******************************************************************      08150000
         SPACE 1                                                        08160000
FMIIP    DS    0H                  Format ILC, IC and PSW               08170000
         SPACE 1                                                        08180000
*----------------------------------------------------------------*      08190000
*        Format instruction length code.                         *      08200000
*----------------------------------------------------------------*      08210000
         XR    R15,R15             Clear work register                  08220000
         IC    R15,INLNTH          Get ILC                              08230000
         CVD   R15,DWORK           Convert ILC to packed                08240000
         UNPK  HEXWORK,DWORK+4(4)  Unpack                               08250000
         OI    HEXWORK+8,X'F0'     Force printable sign                 08260000
         MVC   M5ILC,HEXWORK+8     Copy ILC to message                  08270000
         SPACE 1                                                        08280000
*----------------------------------------------------------------*      08290000
*        Format interrupt code.                                  *      08300000
*----------------------------------------------------------------*      08310000
         LH    R1,INTCOD           Get interrupt code                   08320000
         BAL   R14,HEXTOPRT        Translate interrupt code             08330000
         MVC   M5IC,HEXWORK+6      Copy IC to message                   08340000
         SPACE 1                                                        08350000
*----------------------------------------------------------------*      08360000
*        Format abend PSW.                                       *      08370000
*----------------------------------------------------------------*      08380000
         ICM   R1,15,REPSW+0       Get first word of PSW                08390000
         BAL   R14,HEXTOPRT        Convert to printable                 08400000
         MVC   M5PSW1,HEXWORK      Set in message                       08410000
         ICM   R1,15,REPSW+4       Get second word of PSW               08420000
         LA    R15,0(,R1)          Clean up for address reference       08430000
         BAL   R14,HEXTOPRT        Convert to printable                 08440000
         MVC   M5PSW2,HEXWORK      Set PSW in message                   08450000
         TITLE '    Symptom dump message formatter - Format registers'  08460000
******************************************************************      08470000
*                                                                *      08480000
*        FMGPREGS:                                               *      08490000
*                                                                *      08500000
*        Format general purpose registers at abend.              *      08510000
*                                                                *      08520000
*        R6  = RTM2 Work Area.                                   *      08530000
*        R11 = Program base register 2.                          *      08540000
*        R12 = Program base register 1.                          *      08550000
*        R13 = Program work/save area.                           *      08560000
*        R14 = Subroutine linkage.                               *      08570000
*                                                                *      08580000
*        Workregs = R1.                                          *      08590000
*                                                                *      08600000
******************************************************************      08610000
         SPACE 1                                                        08620000
FMGPREGS DS    0H                  Format registers                     08630000
         SPACE 1                                                        08640000
*----------------------------------------------------------------*      08650000
*        Format registers 0 through 3.                           *      08660000
*----------------------------------------------------------------*      08670000
         L     R1,REREG+(4*0)      Get R0 at abend                      08680000
         BAL   R14,HEXTOPRT         translate to printable              08690000
         MVC   M5REG0,HEXWORK        and set in message                 08700000
         L     R1,REREG+(4*1)      Get R1 at abend                      08710000
         BAL   R14,HEXTOPRT         translate to printable              08720000
         MVC   M5REG1,HEXWORK        and set in message                 08730000
         L     R1,REREG+(4*2)      Get R2 at abend                      08740000
         BAL   R14,HEXTOPRT         translate to printable              08750000
         MVC   M5REG2,HEXWORK        and set in message                 08760000
         L     R1,REREG+(4*3)      Get R3 at abend                      08770000
         BAL   R14,HEXTOPRT         translate to printable              08780000
         MVC   M5REG3,HEXWORK        and set in message                 08790000
         SPACE 1                                                        08800000
*----------------------------------------------------------------*      08810000
*        Format registers 4 through 7.                           *      08820000
*----------------------------------------------------------------*      08830000
         L     R1,REREG+(4*4)      Get R4 at abend                      08840000
         BAL   R14,HEXTOPRT         translate to printable              08850000
         MVC   M5REG4,HEXWORK        and set in message                 08860000
         L     R1,REREG+(4*5)      Get R5 at abend                      08870000
         BAL   R14,HEXTOPRT         translate to printable              08880000
         MVC   M5REG5,HEXWORK        and set in message                 08890000
         L     R1,REREG+(4*6)      Get R6 at abend                      08900000
         BAL   R14,HEXTOPRT         translate to printable              08910000
         MVC   M5REG6,HEXWORK        and set in message                 08920000
         L     R1,REREG+(4*7)      Get R7 at abend                      08930000
         BAL   R14,HEXTOPRT         translate to printable              08940000
         MVC   M5REG7,HEXWORK        and set in message                 08950000
         EJECT ,                                                        08960000
******************************************************************      08970000
*                                                                *      08980000
*        FMGPREGS (continued):                                   *      08990000
*                                                                *      09000000
******************************************************************      09010000
         SPACE 1                                                        09020000
*----------------------------------------------------------------*      09030000
*        Format registers 8 through 11.                          *      09040000
*----------------------------------------------------------------*      09050000
         L     R1,REREG+(4*8)      Get R8 at abend                      09060000
         BAL   R14,HEXTOPRT         translate to printable              09070000
         MVC   M5REG8,HEXWORK        and set in message                 09080000
         L     R1,REREG+(4*9)      Get R9 at abend                      09090000
         BAL   R14,HEXTOPRT         translate to printable              09100000
         MVC   M5REG9,HEXWORK        and set in message                 09110000
         L     R1,REREG+(4*10)     Get R10 at abend                     09120000
         BAL   R14,HEXTOPRT         translate to printable              09130000
         MVC   M5REG10,HEXWORK       and set in message                 09140000
         L     R1,REREG+(4*11)     Get R11 at abend                     09150000
         BAL   R14,HEXTOPRT         translate to printable              09160000
         MVC   M5REG11,HEXWORK       and set in message                 09170000
         SPACE 1                                                        09180000
*----------------------------------------------------------------*      09190000
*        Format registers 12 through 15.                         *      09200000
*----------------------------------------------------------------*      09210000
         L     R1,REREG+(4*12)     Get R12 at abend                     09220000
         BAL   R14,HEXTOPRT         translate to printable              09230000
         MVC   M5REG12,HEXWORK       and set in message                 09240000
         L     R1,REREG+(4*13)     Get R13 at abend                     09250000
         BAL   R14,HEXTOPRT         translate to printable              09260000
         MVC   M5REG13,HEXWORK       and set in message                 09270000
         L     R1,REREG+(4*14)     Get R14 at abend                     09280000
         BAL   R14,HEXTOPRT         translate to printable              09290000
         MVC   M5REG14,HEXWORK       and set in message                 09300000
         L     R1,REREG+(4*15)     Get R15 at abend                     09310000
         BAL   R14,HEXTOPRT         translate to printable              09320000
         MVC   M5REG15,HEXWORK       and set in message                 09330000
         TITLE '    Symptom dump message formatter - Format the 12 byte+09340000
               s of data around the abend PSW address'                  09350000
*        address'                                                       09360000
******************************************************************      09370000
*                                                                *      09380000
*        PSDFORM:                                                *      09390000
*                                                                *      09400000
*        Format the 12 bytes of data around the abend PSW        *      09410000
*        address, six bytes on each side.                        *      09420000
*                                                                *      09430000
*        R6  = RTM2 Work Area.                                   *      09440000
*        R11 = Program base register 2.                          *      09450000
*        R12 = Program base register 1.                          *      09460000
*        R13 = Program work/save area.                           *      09470000
*        R14 = Subroutine linkage.                               *      09480000
*                                                                *      09490000
*        Workregs =  R14, R15.                                   *      09500000
*                                                                *      09510000
******************************************************************      09520000
         SPACE 1                                                        09530000
PSDFORM  DS    0H                 Format data around abend PSW          09540000
         SPACE 1                                                        09550000
*----------------------------------------------------------------*      09560000
*        Compute starting address for the 12-byte range of       *      09570000
*        data surrounding the PSW address.  Ordinarily, the      *      09580000
*        starting address will be (pswaddress - 6).  If the      *      09590000
*        PSW address is less than 6, force the start address     *      09600000
*        to be zero.                                             *      09610000
*----------------------------------------------------------------*      09620000
PSDSTART DS    0H                                                       09630000
         XC    STRTPDAT,STRTPDAT   Assume start address of zero         09640000
         L     R15,RNXT1           Get PSW address                      09650000
         C     R15,=F'6'           Ensure address is at least 6         09660000
         BNH   PSDEND              Branch if so                         09670000
         S     R15,=F'6'           Else low end = PSW address - 6       09680000
         ST    R15,STRTPDAT        Save start address                   09690000
         SPACE 1                                                        09700000
*----------------------------------------------------------------*      09710000
*        Compute ending address for the 12-byte range            *      09720000
*        of data surrounding the PSW address as                  *      09730000
*        (startaddress + 11).  If that results in a              *      09740000
*        value greater than X'FFFFFF', set the end               *      09750000
*        address to X'FFFFFF' and the start address              *      09760000
*        to (X'FFFFFF' - 11).                                    *      09770000
*----------------------------------------------------------------*      09780000
PSDEND   DS    0H                  Here to set ending address           09790000
         L     R15,STRTPDAT        Get start address                    09800000
         A     R15,=F'11'           + 11                                09810000
         ST    R15,ENDPDAT           and save as end of range           09820000
         L     R0,=A(X'00FFFFFF')  Get 16M - 1 for compare              09830000
         CR    R15,R0              Is end address GT 16M?               09840000
         BNH   PSDEND1             No, use what we have                 09850000
         ST    R0,ENDPDAT          Save 16M - 1 as end of range         09860000
         LR    R15,R0              Recalculate start address            09870000
         S     R15,=F'11'           as (endaddress - 11)                09880000
         ST    R15,STRTPDAT          and save it                        09890000
PSDEND1  DS    0H                                                       09900000
         EJECT ,                                                        09910000
******************************************************************      09920000
*                                                                *      09930000
*        PSDFORM (continued):                                    *      09940000
*                                                                *      09950000
******************************************************************      09960000
         SPACE 1                                                        09970000
*----------------------------------------------------------------*      09980000
*        Copy the PSW data to our work area.  If access to       *      09990000
*        the PSW data area via the MVC fails, our ESTAE          *      10000000
*        routine will get control and retry to the label         *      10010000
*        COPYERR.                                                *      10020000
*----------------------------------------------------------------*      10030000
         LA    R15,COPYERR         Update retry address                 10040000
         ST    R15,ERESTART         for storage copy                    10050000
         L     R15,STRTPDAT        Get starting source address          10060000
         OI    FLAG1,ESTORCP       Show storage being copied            10070000
         MVC   PSWWAREA(12),0(R15) Copy PSW data to work area           10080000
         NI    FLAG1,255-ESTORCP   Turn off storage copy flag           10090000
         LA    R15,DELESTAE        Update retry address                 10100000
         ST    R15,ERESTART         to show storage copy done           10110000
         SPACE 1                                                        10120000
*----------------------------------------------------------------*      10130000
*        Unpack the PSW area data and translate it               *      10140000
*        to printable characters.                                *      10150000
*----------------------------------------------------------------*      10160000
PSDTRANS DS    0H                  Translate PSW data to printable      10170000
         UNPK  PSWPAREA(15),PSWWAREA(8)                                 10180000
         UNPK  PSWPAREA+14(11),PSWWAREA+7(6)                            10190000
         TR    PSWPAREA(24),HEXTBL                                      10200000
         SPACE 1                                                        10210000
*----------------------------------------------------------------*      10220000
*        Copy translated PSW data to message.                    *      10230000
*----------------------------------------------------------------*      10240000
         MVC   M5DATP1,PSWSTOR1    Put data word 1 in message           10250000
         MVC   M5DATP2,PSWSTOR2    Put data word 2 in message           10260000
         MVC   M5DATP3,PSWSTOR3    Put data word 3 in message           10270000
         SPACE 1                                                        10280000
*----------------------------------------------------------------*      10290000
*        Set starting address of PSW data in message.            *      10300000
*        Then go to continue building the symptom dump           *      10310000
*        error message.                                          *      10320000
*----------------------------------------------------------------*      10330000
PDFSTART DS    0H                  Format start address in message      10340000
         L     R1,STRTPDAT         Get starting address of range        10350000
         BAL   R14,HEXTOPRT        Translate to printable               10360000
         MVC   M5DATADR,HEXWORK    Set starting address in message      10370000
         B     JPQSRCH             Continue                             10380000
         EJECT ,                                                        10390000
******************************************************************      10400000
*                                                                *      10410000
*        PSDFORM (continued):                                    *      10420000
*                                                                *      10430000
******************************************************************      10440000
         SPACE 1                                                        10450000
*----------------------------------------------------------------*      10460000
*        Retry here if abend occurs during the attempt to        *      10470000
*        copy PSW data area storage.  First ensure that          *      10480000
*        the abend did in fact occur while we were copying       *      10490000
*        storage (it might have happened after the copy flag     *      10500000
*        was turned off but before the retry address got         *      10510000
*        changed to point to DELESTAE).  If we were not copying  *      10520000
*        storage at the time of the abend, skip further          *      10530000
*        symptom dump processing.  Otherwise, modify the         *      10540000
*        symptom dump message to indicate that data at the       *      10550000
*        PSW address cannot be accessed.                         *      10560000
*----------------------------------------------------------------*      10570000
COPYERR  DS    0H                  Error occurred copying storage       10580000
         LA    R15,DELESTAE        Update retry address                 10590000
         ST    R15,ERESTART         to show storage copy done           10600000
         TM    FLAG1,ESTORERR      Ensure error actually occurred       10610000
         MVI   FLAG1,X'00'         Prevent spurious future check        10620000
         BZ    DELESTAE            No, not actual copy error            10630000
         MVC   M5DATP,BLANKS       Blank PSW data area in message       10640000
         MVC   M5NACCES,KNACCES    Set "IS INACCESSIBLE" text           10650000
         B     JPQSRCH             Continue                             10660000
         TITLE '    Symptom dump message formatter - Search job pack qu+10670000
               eue for module containing abend PSW address'             10680000
******************************************************************      10690000
*                                                                *      10700000
*        JPQSRCH:                                                *      10710000
*                                                                *      10720000
*        Search job pack queue for a module containing           *      10730000
*        the abend PSW address.                                  *      10740000
*                                                                *      10750000
*        R4  = Current CDE on job pack queue.                    *      10760000
*        R6  = RTM2 Work Area.                                   *      10770000
*        R11 = Program base register 2.                          *      10780000
*        R12 = Program base register 1.                          *      10790000
*        R13 = Program work/save area.                           *      10800000
*        R14 = Subroutine linkage.                               *      10810000
*                                                                *      10820000
*        Workregs = R0, R1, R14, R15.                            *      10830000
*                                                                *      10840000
******************************************************************      10850000
         SPACE 1                                                        10860000
JPQSRCH  DS    0H                  Search JPAQ                          10870000
         SPACE 1                                                        10880000
*----------------------------------------------------------------*      10890000
*        Before continuing with job pack queue search,           *      10900000
*        ensure that MVS still thinks the task is active.        *      10910000
*----------------------------------------------------------------*      10920000
         L     R15,RTM2TCBC        Get address of current TCB           10930000
         USING TCB,R15             Addressability for TCB               10940000
         TM    TCBFLGS5,TCBFC      Has task terminated?                 10950000
         BO    JPQNONE             Skip JPAQ search if so               10960000
         SPACE 1                                                        10970000
*----------------------------------------------------------------*      10980000
*        Initialize for job pack queue search by pointing        *      10990000
*        to first CDE on JPAQ.                                   *      11000000
*----------------------------------------------------------------*      11010000
         L     R15,TCBJSTCB        Chain to job step TCB                11020000
         XR    R4,R4               Point to first CDE                   11030000
         ICM   R4,7,TCBJPQB         on job pack queue                   11040000
         USING CDENTRY,R4          Addressability for CDE               11050000
         DROP  R15                 End TCB addressability               11060000
         EJECT ,                                                        11070000
******************************************************************      11080000
*                                                                *      11090000
*        JPQSRCH (continued):                                    *      11100000
*                                                                *      11110000
******************************************************************      11120000
         SPACE 1                                                        11130000
*----------------------------------------------------------------*      11140000
*        Top of loop through CDEs on job pack queue.             *      11150000
*----------------------------------------------------------------*      11160000
JPQLOOP  DS    0H                  Loop through CDEs on JPAQ            11170000
         LTR   R4,R4               Last CDE on JPAQ?                    11180000
         BZ    JPQNONE             If so, module not found on JPAQ      11190000
         TM    CDATTR,CDMIN        Is this a minor CDE?                 11200000
         BO    JPQLBOT             Skip CDE if it's a minor             11210000
         ICM   R15,15,CDXLMJP      Get address of extent list           11220000
         BZ    JPQLBOT             Skip this CDE if no extent list      11230000
         USING XTLST,R15           Addressability for XTLST             11240000
         L     R14,XTLNRFAC        Get number of extents                11250000
         C     R14,=F'1'           Ensure module was block loaded       11260000
         BNE   JPQLBOT             Skip this CDE if not block loaded    11270000
         XR    R0,R0               Get module start address             11280000
         ICM   R0,7,XTLMSBAD        from extent list                    11290000
         XR    R1,R1               Get length                           11300000
         ICM   R1,7,XTLMSBLN        of module                           11310000
         AR    R1,R0                 and find module end address        11320000
         DROP  R15                 End XTLST addressability             11330000
         L     R14,RNXT1           Get PSW address                      11340000
         CR    R14,R0              Is PSW address before this module?   11350000
         BL    JPQLBOT             If so, it's not the module we want   11360000
         CR    R14,R1              Is PSW address after this module?    11370000
         BNH   JPQFOUND            If not, it's the one we want         11380000
         SPACE 1                                                        11390000
*----------------------------------------------------------------*      11400000
*        Bottom of job pack queue loop.  The current CDE         *      11410000
*        is not a major CDE, or the module it describes          *      11420000
*        doesn't contain the abend PSW address.  Point to        *      11430000
*        the next CDE on the job pack queue and loop back        *      11440000
*        to look at it.                                          *      11450000
*----------------------------------------------------------------*      11460000
JPQLBOT  DS    0H                  Bottom of JPAQ search loop           11470000
         ICM   R4,15,CDCHAIN       Point to next CDE on JPAQ            11480000
         B     JPQLOOP             Back to look at it                   11490000
         EJECT ,                                                        11500000
*----------------------------------------------------------------*      11510000
*        We have found a CDE for a module that contains the      *      11520000
*        abend PSW address.  Set module name, module start       *      11530000
*        address and offset to abend address in message,         *      11540000
*        then continue with reason code processing.              *      11550000
*----------------------------------------------------------------*      11560000
JPQFOUND DS    0H                  Found CDE containing address         11570000
         MVC   M5MODNM,CDNAME      Set module name in message           11580000
         LR    R1,R0               Set module start address             11590000
         BAL   R14,HEXTOPRT        Translate start address              11600000
         MVC   M5MODADR,HEXWORK    Set module address in message        11610000
         L     R1,RNXT1            Calculate offset                     11620000
         SR    R1,R0                into module                         11630000
         BAL   R14,HEXTOPRT        Translate offset                     11640000
         MVC   M5MODOFF,HEXWORK    Set offset in message                11650000
         B     FMREASON            Branch to check for reason code      11660000
         SPACE 1                                                        11670000
         DROP  R4                  End CDE addressability               11680000
         SPACE 1                                                        11690000
*----------------------------------------------------------------*      11700000
*        We did not find a CDE on the job pack queue             *      11710000
*        that contains the abend PSW address.  Fall through      *      11720000
*        to active LPA queue search.                             *      11730000
*----------------------------------------------------------------*      11740000
JPQNONE  DS    0H                                                       11750000
         TITLE '    Symptom dump message formatter - Search active LPA +11760000
               queue for module containing abend PSW address'           11770000
******************************************************************      11780000
*                                                                *      11790000
*        ALPQSRCH:                                               *      11800000
*                                                                *      11810000
*        Abend PSW address was not found in a module on          *      11820000
*        the job pack queue.  Search active link pack            *      11830000
*        queue for a module containing the abend PSW             *      11840000
*        address.                                                *      11850000
*                                                                *      11860000
*        R4  = Current CDE on active LPA queue.                  *      11870000
*        R6  = RTM2 Work Area.                                   *      11880000
*        R11 = Program base register 2.                          *      11890000
*        R12 = Program base register 1.                          *      11900000
*        R13 = Program work/save area.                           *      11910000
*        R14 = Subroutine linkage.                               *      11920000
*                                                                *      11930000
*        Workregs = R0, R1, R14, R15.                            *      11940000
*                                                                *      11950000
******************************************************************      11960000
         SPACE 1                                                        11970000
ALPQSRCH DS    0H                  Search active LPAQ                   11980000
         SPACE 1                                                        11990000
*----------------------------------------------------------------*      12000000
*        Initialize for active link pack queue search            *      12010000
*        by pointing to first CDE on ALPQA.                      *      12020000
*----------------------------------------------------------------*      12030000
         L     R15,CVTPTR          Point to CVT                         12040000
         USING CVT,R15             Addressability for CVT               12050000
         L     R4,CVTQLPAQ         Get pointer to LPAQ                  12060000
         L     R4,0(,R4)           Point to first CDE                   12070000
         USING CDENTRY,R4          Addressability for CDE               12080000
         DROP  R15                 End CVT addressability               12090000
         SPACE 1                                                        12100000
*----------------------------------------------------------------*      12110000
*        Top of loop through CDEs on active link pack queue.     *      12120000
*----------------------------------------------------------------*      12130000
ALPQLOOP DS    0H                  Loop through CDEs on ALPAQ           12140000
         LTR   R4,R4               Last CDE on ALPAQ?                   12150000
         BZ    ALPQNONE            If so, module not found on ALPAQ     12160000
         TM    CDATTR,CDMIN        Is this a minor CDE?                 12170000
         BO    ALPQLBOT            Skip CDE if it's a minor             12180000
         ICM   R15,15,CDXLMJP      Get address of extent list           12190000
         BZ    ALPQLBOT            Skip this CDE if no extent list      12200000
         USING XTLST,R15           Addressability for XTLST             12210000
         XR    R0,R0               Get module start address             12220000
         ICM   R0,7,XTLMSBAD        from extent list                    12230000
         XR    R1,R1               Get length                           12240000
         ICM   R1,7,XTLMSBLN        of module                           12250000
         AR    R1,R0                 and find module end address        12260000
         DROP  R15                 End XTLST addressability             12270000
         L     R14,RNXT1           Get PSW address                      12280000
         CR    R14,R0              Is PSW address before this module?   12290000
         BL    ALPQLBOT            If so, it's not the module we want   12300000
         CR    R14,R1              Is PSW address after this module?    12310000
         BNH   ALPQFND             If not, it's the one we want         12320000
         EJECT ,                                                        12330000
******************************************************************      12340000
*                                                                *      12350000
*        ALPQSRCH (continued):                                   *      12360000
*                                                                *      12370000
******************************************************************      12380000
         SPACE 1                                                        12390000
*----------------------------------------------------------------*      12400000
*        Bottom of active link pack queue loop.  The current     *      12410000
*        CDE is not a major CDE, or the module it describes      *      12420000
*        doesn't contain the abend PSW address.  Point to        *      12430000
*        the next CDE on the active link pack queue and          *      12440000
*        loop back to look at it.                                *      12450000
*----------------------------------------------------------------*      12460000
ALPQLBOT DS    0H                  Bottom of ALPAQ search loop          12470000
         ICM   R4,15,CDCHAIN       Point to next CDE on ALPAQ           12480000
         B     ALPQLOOP            Back to look at it                   12490000
         EJECT ,                                                        12500000
*----------------------------------------------------------------*      12510000
*        We have found a CDE for a module that contains the      *      12520000
*        abend PSW address.  Set module name, module start       *      12530000
*        address and offset to abend address in message,         *      12540000
*        then continue with reason code processing.              *      12550000
*----------------------------------------------------------------*      12560000
ALPQFND  DS    0H                  Found CDE containing address         12570000
         MVC   M5MODNM,CDNAME      Set module name in message           12580000
         LR    R1,R0               Set module start address             12590000
         BAL   R14,HEXTOPRT        Translate start address              12600000
         MVC   M5MODADR,HEXWORK    Set module address in message        12610000
         L     R1,RNXT1            Calculate offset                     12620000
         SR    R1,R0                into module                         12630000
         BAL   R14,HEXTOPRT        Translate offset                     12640000
         MVC   M5MODOFF,HEXWORK    Set offset in message                12650000
         B     FMREASON            Branch to check for reason code      12660000
         SPACE 1                                                        12670000
         DROP  R4                  End CDE addressability               12680000
         SPACE 1                                                        12690000
*----------------------------------------------------------------*      12700000
*        We did not find a CDE on the active LPA queue           *      12710000
*        that contains the abend PSW address.  Fall              *      12720000
*        through to search PLPA directory.                       *      12730000
*----------------------------------------------------------------*      12740000
ALPQNONE DS    0H                                                       12750000
         TITLE '    Symptom dump message formatter - Search PLPA direct+12760000
               ory for module containing abend PSW address'             12770000
******************************************************************      12780000
*                                                                *      12790000
*        PLPDSRCH:                                               *      12800000
*                                                                *      12810000
*        Abend PSW address was not found in a module on          *      12820000
*        the job pack queue or the active LPA queue.             *      12830000
*        Search PLPA directory for a module containing           *      12840000
*        the abend PSW address.                                  *      12850000
*                                                                *      12860000
*        R4  = Current LPDE in PLPA directory.                   *      12870000
*        R6  = RTM2 Work Area.                                   *      12880000
*        R11 = Program base register 2.                          *      12890000
*        R12 = Program base register 1.                          *      12900000
*        R13 = Program work/save area.                           *      12910000
*        R14 = Subroutine linkage.                               *      12920000
*                                                                *      12930000
*        Workregs = R0, R1, R14, R15.                            *      12940000
*                                                                *      12950000
******************************************************************      12960000
         SPACE 1                                                        12970000
PLPDSRCH DS    0H                  Search PLPA directory                12980000
         SPACE 1                                                        12990000
*----------------------------------------------------------------*      13000000
*        Initialize for PLPA directory search by pointing        *      13010000
*        to first LPDE.                                          *      13020000
*----------------------------------------------------------------*      13030000
         L     R15,CVTPTR          Point to CVT                         13040000
         USING CVT,R15             Addressability for CVT               13050000
         L     R4,CVTLPDIA         Point to first LPDE                  13060000
         USING LPDE,R4             Addressability for LPDE              13070000
         DROP  R15                 End CVT addressability               13080000
         SPACE 1                                                        13090000
*----------------------------------------------------------------*      13100000
*        Top of loop through LPDEs.                              *      13110000
*----------------------------------------------------------------*      13120000
PLPDLOOP DS    0H                  Loop through LPDEs                   13130000
         CLC   XFF,LPDENAME        End of LPDEs?                        13140000
         BE    PLPDNONE            If so, module not found in PLPA      13150000
         TM    LPDEATTR,LPDEMIN    Is this a minor LPDE?                13160000
         BO    PLPDLBOT            Skip LPDE if it's a minor            13170000
         TM    LPDEATT2,LPDEXLE    Ensure valid extent information      13180000
         BZ    PLPDLBOT            Skip this LPDE if no extent info     13190000
         SPACE 1                                                        13200000
*----------------------------------------------------------------*      13210000
*        This is a major LPDE.  Get the module start             *      13220000
*        address and length from LPDE, and calculate module      *      13230000
*        end address.                                            *      13240000
*----------------------------------------------------------------*      13250000
         XR    R0,R0               Get module start address             13260000
         ICM   R0,15,LPDEXTAD       from extent information             13270000
         XR    R1,R1               Get length                           13280000
         ICM   R1,7,LPDEXTLN+1      of module                           13290000
         AR    R1,R0                 and find module end address        13300000
         EJECT ,                                                        13310000
******************************************************************      13320000
*                                                                *      13330000
*        PLPDSRCH (continued):                                   *      13340000
*                                                                *      13350000
******************************************************************      13360000
         SPACE 1                                                        13370000
*----------------------------------------------------------------*      13380000
*        Compare the abend PSW address to the module start       *      13390000
*        and end addresses to determine if it's the one we       *      13400000
*        want.                                                   *      13410000
*----------------------------------------------------------------*      13420000
         L     R14,RNXT1           Get PSW address                      13430000
         CR    R14,R0              Is PSW address before module?        13440000
         BL    PLPDLBOT            If so, not the module we want        13450000
         CR    R14,R1              Is PSW address after module?         13460000
         BNH   PLPDFND             If not, it's the one we want         13470000
         SPACE 1                                                        13480000
*----------------------------------------------------------------*      13490000
*        Bottom of LPDE search loop.  The current LPDE           *      13500000
*        is not a major LPDE, or the module it describes         *      13510000
*        doesn't contain the abend PSW address.  Point to        *      13520000
*        the next LPDE and loop back to look at it.              *      13530000
*----------------------------------------------------------------*      13540000
PLPDLBOT DS    0H                  Bottom of LPDE search loop           13550000
         LA    R4,LPDELEN(,R4)     Point to next LPDE                   13560000
         B     PLPDLOOP            Back to look at it                   13570000
         EJECT ,                                                        13580000
******************************************************************      13590000
*                                                                *      13600000
*        PLPDSRCH (continued):                                   *      13610000
*                                                                *      13620000
******************************************************************      13630000
         SPACE 1                                                        13640000
*----------------------------------------------------------------*      13650000
*        We have found an LPDE for a module that contains the    *      13660000
*        abend PSW address.  Set module name, module start       *      13670000
*        address and offset to abend address in message,         *      13680000
*        then continue with reason code processing.              *      13690000
*----------------------------------------------------------------*      13700000
PLPDFND  DS    0H                  Found LPDE containing address        13710000
         MVC   M5MODNM,LPDENAME    Set module name in message           13720000
         LR    R1,R0               Set module start address             13730000
         BAL   R14,HEXTOPRT        Translate start address              13740000
         MVC   M5MODADR,HEXWORK    Set module address in message        13750000
         L     R1,RNXT1            Calculate offset                     13760000
         SR    R1,R0                into module                         13770000
         BAL   R14,HEXTOPRT        Translate offset                     13780000
         MVC   M5MODOFF,HEXWORK    Set offset in message                13790000
         B     FMREASON            Branch to check for reason code      13800000
         SPACE 1                                                        13810000
         DROP  R4                  End LPDE addressability              13820000
         SPACE 1                                                        13830000
*----------------------------------------------------------------*      13840000
*        We did not find an LPDE that contains the abend         *      13850000
*        PSW address.  Go set no-module-found in message.        *      13860000
*----------------------------------------------------------------*      13870000
PLPDNONE DS   0H                   Not found in PLPA                    13880000
         B    NOMODACT             Continue                             13890000
         TITLE '    Symptom dump message formatter - No active module f+13900000
               ound'                                                    13910000
******************************************************************      13920000
*                                                                *      13930000
*        NOMODACT:                                               *      13940000
*                                                                *      13950000
*        We have searched the job pack queue, the active         *      13960000
*        LPA queue, and the PLPA directory without finding       *      13970000
*        a module containing the abend PSW address.  Blank       *      13980000
*        module line in IEA995I message and insert "NO ACTIVE    *      13990000
*        MODULE FOUND" text in its place, then continue with     *      14000000
*        reason code processing.                                 *      14010000
*                                                                *      14020000
*        R6  = RTM2 Work Area - not referenced.                  *      14030000
*        R11 = Program base register 2.                          *      14040000
*        R12 = Program base register 1.                          *      14050000
*        R13 = Program work/save area.                           *      14060000
*                                                                *      14070000
*        Workregs:  R1, R15.                                     *      14080000
*                                                                *      14090000
******************************************************************      14100000
         SPACE 1                                                        14110000
NOMODACT DS    0H                  No active module found               14120000
         MVC   M5LN5,BLANKS        Blank module message line            14130000
         MVC   M5NOMOD,NOMODMSG     and say "NO ACTIVE MODULE"          14140000
         TITLE '    Symptom dump message formatter - Find and format re+14150000
                ason code'                                              14160000
******************************************************************      14170000
*                                                                *      14180000
*        FMREASON:                                               *      14190000
*                                                                *      14200000
*        Find reason code associated with this abend, if         *      14210000
*        there is one, and format it into the message.           *      14220000
*                                                                *      14230000
*        R6  = RTM2 Work Area.                                   *      14240000
*        R11 = Program base register 2.                          *      14250000
*        R12 = Program base register 1.                          *      14260000
*        R13 = Program work/save area.                           *      14270000
*                                                                *      14280000
*        Workregs:  R1, R15.                                     *      14290000
*                                                                *      14300000
******************************************************************      14310000
         SPACE 1                                                        14320000
FMREASON DS    0H                  Find reason code                     14330000
         SPACE 1                                                        14340000
*----------------------------------------------------------------*      14350000
*        OS versions prior to MVS/XA don't officially            *      14360000
*        recognize a reason code, but the reason code bit        *      14370000
*        may have been manually set, or the program being        *      14380000
*        executed might have been assembled with a modern        *      14390000
*        version of the ABEND macro that recognizes REASON.      *      14400000
*        Test if the reason bit was set in the completion        *      14410000
*        code flags field, and branch to format R15 as the       *      14420000
*        reason code if it's on.                                 *      14430000
*----------------------------------------------------------------*      14440000
         TM    RTM2CCF,RTM2REAF    Reason code provided in R15?         14450000
         BNZ   FMRMATCH            Branch if so                         14460000
         SPACE 1                                                        14470000
*----------------------------------------------------------------*      14480000
*        Even in OS versions prior to MVS/XA, some system        *      14490000
*        abends have documented reason codes.  If this           *      14500000
*        wasn't a system abend, though, there's nothing          *      14510000
*        more we can do to determine a reason code.              *      14520000
*----------------------------------------------------------------*      14530000
         XR    R15,R15             Clear a register                     14540000
         ICM   R15,3,SYSCC         Get system abend code                14550000
         BZ    ISSUEWTO            No reason if not system abend   @D02 14560000
         SPACE 1                                                        14570000
*----------------------------------------------------------------*      14580000
*        The abend is a system abend.  Test for program          *      14590000
*        check abend (0Cx).  For program checks, the reason      *      14600000
*        code is the interrupt code.                             *      14610000
*----------------------------------------------------------------*      14620000
         MVC   CCWORK,SYSCC        Copy abend code to work area         14630000
         NC    CCWORK,=XL2'0FF0'   Lose low order digit                 14640000
         CLC   CCWORK,=X'00C0'     Was abend a program check?           14650000
         BNE   FMRLOOPI            Branch if not                        14660000
         LH    R1,RTM2INC1         Get interrupt code                   14670000
         ST    R1,RC               Save as reason code                  14680000
         B     FMTREAS             Go format reason code                14690000
         EJECT ,                                                        14700000
******************************************************************      14710000
*                                                                *      14720000
*        FMREASON (continued):                                   *      14730000
*                                                                *      14740000
******************************************************************      14750000
         SPACE 1                                                        14760000
*----------------------------------------------------------------*      14770000
*        Not a program check abend.  Compare the completion      *      14780000
*        code against a table of abends that we know provide     *      14790000
*        a reason code in R15.                                   *      14800000
*----------------------------------------------------------------*      14810000
FMRLOOPI DS    0H                  Initialize table search loop         14820000
         LA    R1,CCTBL            Point to code/reason table           14830000
         SPACE 1                                                        14840000
*----------------------------------------------------------------*      14850000
*        Top of reason code table compare loop.                  *      14860000
*----------------------------------------------------------------*      14870000
FMRLOOP  DS    0H                  Loop through table                   14880000
         CLC   =X'FFFF',0(R1)      End of table?                        14890000
         BE    ISSUEWTO            If so, no reason code           @D02 14900000
         MVC   CCWORK,SYSCC        Copy abend code                      14910000
         NC    CCWORK,2(R1)         and apply table entry mask          14920000
         CLC   CCWORK,0(R1)        Match?                               14930000
         BE    FMRMATCH            Branch if match                      14940000
         LA    R1,4(,R1)           Else point to next table entry       14950000
         B     FMRLOOP             Back to look at it                   14960000
         SPACE 1                                                        14970000
*----------------------------------------------------------------*      14980000
*        Matched abend code against table.                       *      14990000
*----------------------------------------------------------------*      15000000
FMRMATCH DS    0H                  Found match in table                 15010000
         L     R1,REREG+(4*15)     Get R15 at abend                     15020000
         ST    R1,RC               Save as reason code                  15030000
         B     FMTREAS             Go format reason code                15040000
         SPACE 1                                                        15050000
*----------------------------------------------------------------*      15060000
*        We have identified a reason code.  Format it            *      15070000
*        into the message.                                       *      15080000
*----------------------------------------------------------------*      15090000
FMTREAS  DS    0H                  Format reason code                   15100000
         MVC   M5REATXT,KREATXT    Add "REASON CODE" text to msg        15110000
         L     R1,RC               Get reason code                      15120000
         BAL   R14,HEXTOPRT        Translate to printable               15130000
         MVC   M5REASON,HEXWORK    Set reason code in message           15140000
         TITLE '    Symptom dump message formatter - Issue IEA995I mess+15150000
               age via WTO'                                        @D02 15160000
******************************************************************      15170000
*                                                                *      15180000
*        ISSUEWTO:                                               * @D02 15190000
*                                                                *      15200000
*        IEA995I message is complete.  Issue it via WTO.         *      15210000
*                                                                *      15220000
*        R6  = RTM2 Work Area - not referenced.                  * @D02 15230000
*        R11 = Program base register 2.                          *      15240000
*        R12 = Program base register 1.                          *      15250000
*        R13 = Program work/save area.                           *      15260000
*                                                                *      15270000
*        Workregs = R0, R1, R15.                                 *      15280000
*                                                                *      15290000
******************************************************************      15300000
         SPACE 1                                                        15310000
ISSUEWTO DS    0H                  Issue IEA995I message via WTO   @D02 15320000
         XR    R0,R0               Clear connect ID                     15330000
         WTO   MF=(E,MSG995)       Issue MSGIEA995I                     15340000
         TITLE '    Symptom dump message formatter - Write IEA995I mess+15350000
               age to terminal if TSO user'                        @D02 15360000
****************************************************************** @D02 15370000
*                                                                * @D02 15380000
*        ISSUETSO:                                               * @D02 15390000
*                                                                * @D02 15400000
*        If this is a TSO user, determine if the user has        * @D05 15410000
*        WTPMSG set in his profile.  If not, skip TSO            * @D05 15420000
*        processing.  If so, write the lines of the completed    * @D05 15430000
*        IEA995I message to the terminal using TPUT.  Modern     * @D05 15440000
*        versions of MVS can do this by having ROUTCDE=11        * @D05 15450000
*        specified in the WPL, but MVS 3.8 doesn't support       * @D05 15460000
*        ROUTCDE=11 for a MLWTO, so we have to write to the      * @D05 15470000
*        terminal the hard way.                                  * @D05 15480000
*                                                                * @D02 15490000
*        R2  = Loop counter for writing minor lines.             * @D02 15500000
*        R3  = Address of various IEA995I WPL segments.          * @D02 15510000
*        R6  = RTM2 Work Area - not referenced.                  * @D02 15520000
*        R11 = Program base register 2.                          * @D02 15530000
*        R12 = Program base register 1.                          * @D02 15540000
*        R13 = Program work/save area.                           * @D02 15550000
*                                                                * @D02 15560000
*        Workregs:  R0, R1, R14, R15.                            * @D02 15570000
*                                                                * @D02 15580000
****************************************************************** @D02 15590000
         SPACE 1                                                   @D02 15600000
ISSUETSO DS    0H                  Write message to TSO user       @D02 15610000
         SPACE 1                                                   @D02 15620000
*----------------------------------------------------------------* @D02 15630000
*        Determine if this is a TSO user who has set             * @D02 15640000
*        "WTPMSG" in his profile.  If not, we don't need         * @D02 15650000
*        to write the message with TPUTs.                        * @D02 15660000
*----------------------------------------------------------------* @D02 15670000
         USING PSA,0               Address low storage             @D02 15680000
         L     R15,PSATOLD         Point to our TCB                @D02 15690000
         USING TCB,R15             Addressability for TCB          @D02 15700000
         L     R15,TCBJSTCB        Chain to job step TCB           @D02 15710000
         L     R15,TCBJSCB         Point to JSCB                   @D02 15720000
         USING IEZJSCB,R15         Addressability for JSCB         @D02 15730000
         L     R14,JSCBCSCB        Get CSCB address                @D02 15740000
         USING CSCB,R14            Addressability for CSCB         @D02 15750000
         CLI   CHTRKID,CHTSID      Is this a TSO user?             @D02 15760000
         BNE   ISSUESYS            No, skip TPUTs                  @D05 15770000
         DROP  R14                 End CSCB addressbility          @D02 15780000
         L     R15,JSCBPSCB        Get PSCB address                @D02 15790000
         USING PSCB,R15            Addressability for PSCB         @D02 15800000
         L     R15,PSCBUPT         Point to UPT                    @D02 15810000
         USING UPT,R15             Addressability for UPT          @D02 15820000
         TM    UPTSWS,UPTWTP       User want WTP messages?         @D02 15830000
         BZ    ISSUESYS            No, skip writing to terminal    @D05 15840000
         DROP  R15                 End UPT addressbility           @D02 15850000
         EJECT ,                                                   @D02 15860000
****************************************************************** @D02 15870000
*                                                                * @D02 15880000
*        ISSUETSO (continued):                                   * @D02 15890000
*                                                                * @D02 15900000
****************************************************************** @D02 15910000
         SPACE 1                                                   @D02 15920000
*----------------------------------------------------------------* @D02 15930000
*        TSO user wants WTP messages, so write the IEA995I       * @D02 15940000
*        message to the terminal.  First, initialize pointer     * @D02 15950000
*        to IEA995I WPL.                                         * @D02 15960000
*----------------------------------------------------------------* @D02 15970000
         LA    R3,MSG995           Point to message                @D02 15980000
         USING WPL,R3              Addressability for WPL          @D02 15990000
         SPACE 1                                                   @D02 16000000
*----------------------------------------------------------------* @D02 16010000
*        Write first line to terminal with TPUT.                 * @D02 16020000
*----------------------------------------------------------------* @D02 16030000
         LH    R0,WPLLGH           Get first line length           @D02 16040000
         SH    R0,=Y(WPLTXT-WPL)   Decrement for length field      @D02 16050000
         LA    R1,WPLTXT           Point to text                   @D02 16060000
         TPUT  (1),(0)             Write first line to terminal    @D02 16070000
         SPACE 1                                                   @D02 16080000
*----------------------------------------------------------------* @D02 16090000
*        Point past the first line and the routing/descriptor    * @D02 16100000
*        codes section to the MLWTO extension.  Get the number   * @D02 16110000
*        of minor lines by extracting the total number of lines  * @D02 16120000
*        from the MLWTO extension and subtracting one for the    * @D02 16130000
*        first line.                                             * @D02 16140000
*----------------------------------------------------------------* @D02 16150000
         LH    R0,WPLLGH           Point past                      @D02 16160000
         AR    R3,R0                first line                     @D02 16170000
         USING WPLFLGS,R3          Address routing/descriptor codes@D02 16180000
         LA    R3,WPLMSGTY-WPLFLGS(,R3)  Point past codes          @D02 16190000
         USING WPLLTF,R3           Address MLWTO extension         @D02 16200000
         XR    R2,R2               Calculate                       @D02 16210000
         IC    R2,WPLLINES          number                         @D02 16220000
         BCTR  R2,0                  of minor lines                @D02 16230000
         SPACE 1                                                   @D02 16240000
*----------------------------------------------------------------* @D02 16250000
*        Point past the MLWTO extension.                         * @D02 16260000
*----------------------------------------------------------------* @D02 16270000
         LA    R3,WPLLINES-WPLLTF+L'WPLLINES(,R3)                  @D02 16280000
         EJECT ,                                                   @D02 16290000
****************************************************************** @D02 16300000
*                                                                * @D02 16310000
*        ISSUETSO (continued):                                   * @D02 16320000
*                                                                * @D02 16330000
****************************************************************** @D02 16340000
         SPACE 1                                                   @D02 16350000
*----------------------------------------------------------------* @D02 16360000
*        Loop writing minor lines to terminal with TPUT.         * @D02 16370000
*----------------------------------------------------------------* @D02 16380000
ITLOOP   DS    0H                  Top of TPUT loop                @D02 16390000
         USING WPLML,R3            Addressability for minor line   @D02 16400000
         LH    R0,WPLML0           Get minor line length           @D02 16410000
         SH    R0,=Y(WPLMLTXT-WPLML)  Decrement for length field   @D02 16420000
         LA    R1,WPLMLTXT         Point to text                   @D02 16430000
         TPUT  (1),(0)             Write message to terminal       @D02 16440000
         LH    R0,WPLML0           Increment pointer               @D02 16450000
         AR    R3,R0                to next minor line             @D02 16460000
         BCT   R2,ITLOOP             and loop back to write it     @D02 16470000
         DROP  R3                  End minor line addressability   @D02 16480000
         TITLE '    Symptom dump message formatter - Write IEA995I mess+16490000
               age to system messages data set'                    @D05 16500000
****************************************************************** @D05 16510000
*                                                                * @D05 16520000
*        ISSUESYS:                                               * @D05 16530000
*                                                                * @D05 16540000
*        Finally, write the lines of the completed IEA995I       * @D05 16550000
*        message to the system messages data set.  Modern        * @D05 16560000
*        versions of MVS can do this by having ROUTCDE=11        * @D05 16570000
*        specified in the WPL, but MVS 3.8 doesn't support       * @D05 16580000
*        ROUTCDE=11 for a MLWTO, so we have to write to the      * @D05 16590000
*        system messages data set the hard way.  We will use     * @D05 16600000
*        the RPL pointed to by the JSCB and issue a PUT RPL      * @D05 16610000
*        for each line.                                          * @D05 16620000
*                                                                * @D05 16630000
*        R2  = Loop counter for writing minor lines.             * @D05 16640000
*        R3  = Address of various IEA995I WPL segments.          * @D05 16650000
*        R6  = RTM2 Work Area - not referenced.                  * @D05 16660000
*        R7  = Address of system messages data set RPL.          * @D05 16670000
*        R11 = Program base register 2.                          * @D05 16680000
*        R12 = Program base register 1.                          * @D05 16690000
*        R13 = Program work/save area.                           * @D05 16700000
*                                                                * @D05 16710000
*        Workregs:  R0, R1, R14, R15.                            * @D05 16720000
*                                                                * @D05 16730000
****************************************************************** @D05 16740000
         SPACE 1                                                   @D05 16750000
ISSUESYS DS    0H                  Write to system messages        @D05 16760000
         SPACE 1                                                   @D05 16770000
*----------------------------------------------------------------* @D05 16780000
*        Get pointer to system messages data set RPL from        * @D05 16790000
*        the JSCB.                                               * @D05 16800000
*----------------------------------------------------------------* @D05 16810000
         USING PSA,0               Address low storage             @D05 16820000
         L     R15,PSATOLD         Point to our TCB                @D05 16830000
         USING TCB,R15             Addressability for TCB          @D05 16840000
         L     R15,TCBJSTCB        Chain to job step TCB           @D05 16850000
         L     R15,TCBJSCB         Point to JSCB                   @D05 16860000
         USING IEZJSCB,R15         Addressability for JSCB         @D05 16870000
         ICM   R7,15,JSCBSMLR      Point to sysmsg RPL             @D05 16880000
         BZ    DELESTAE            If zero, skip sysmsg writes     @D05 16890000
         DROP  R15                 End JSCB addressability         @D05 16900000
         USING IFGRPL,R7           Addressability for RPL          @D05 16910000
         SPACE 1                                                   @D05 16920000
*----------------------------------------------------------------* @D05 16930000
*        Initialize the RPL for sequential write.                * @D05 16940000
*----------------------------------------------------------------* @D05 16950000
         OI    RPLREQ,RPLPUT       Set PUT flag in RPL             @D05 16960000
         OI    RPLOPTCD,RPLSEQ     Set RPL sequential access flag  @D05 16970000
         SPACE 1                                                   @D05 16980000
*----------------------------------------------------------------* @D05 16990000
*        Initialize pointer to the IEA995I WPL.                  * @D05 17000000
*----------------------------------------------------------------* @D05 17010000
         LA    R3,MSG995           Point to message                @D05 17020000
         USING WPL,R3              Addressability for WPL          @D05 17030000
         EJECT ,                                                   @D05 17040000
****************************************************************** @D05 17050000
*                                                                * @D05 17060000
*        ISSUESYS (continued):                                   * @D05 17070000
*                                                                * @D05 17080000
****************************************************************** @D05 17090000
         SPACE 1                                                   @D05 17100000
*----------------------------------------------------------------* @D05 17110000
*        Write first line of message to system messages.         * @D05 17120000
*----------------------------------------------------------------* @D05 17130000
         LH    R0,WPLLGH           Get first line length           @D05 17140000
         SH    R0,=Y(WPLTXT-WPL)   Decrement for length field      @D05 17150000
         LA    R1,WPLTXT           Point to text                   @D05 17160000
         ST    R1,RPLAREA          Set text address in RPL         @D05 17170000
         ST    R0,RPLRLEN          Set text length in RPL          @D05 17180000
         PUT   RPL=(R7)            Write first line                @D05 17190000
         SPACE 1                                                   @D05 17200000
*----------------------------------------------------------------* @D05 17210000
*        Point past the first line and the routing/descriptor    * @D05 17220000
*        codes section to the MLWTO extension.  Get the number   * @D05 17230000
*        of minor lines by extracting the total number of lines  * @D05 17240000
*        from the MLWTO extension and subtracting one for the    * @D05 17250000
*        first line.                                             * @D05 17260000
*----------------------------------------------------------------* @D05 17270000
         LH    R0,WPLLGH           Point past                      @D05 17280000
         AR    R3,R0                first line                     @D05 17290000
         USING WPLFLGS,R3          Address routing/descriptor codes@D05 17300000
         LA    R3,WPLMSGTY-WPLFLGS(,R3)  Point past codes          @D05 17310000
         USING WPLLTF,R3           Address MLWTO extension         @D05 17320000
         XR    R2,R2               Calculate                       @D05 17330000
         IC    R2,WPLLINES          number                         @D05 17340000
         BCTR  R2,0                  of minor lines                @D05 17350000
         SPACE 1                                                   @D05 17360000
*----------------------------------------------------------------* @D05 17370000
*        Point past the MLWTO extension.                         * @D05 17380000
*----------------------------------------------------------------* @D05 17390000
         LA    R3,WPLLINES-WPLLTF+L'WPLLINES(,R3)                  @D05 17400000
         EJECT ,                                                   @D05 17410000
****************************************************************** @D05 17420000
*                                                                * @D05 17430000
*        ISSUESYS (continued):                                   * @D05 17440000
*                                                                * @D05 17450000
****************************************************************** @D05 17460000
         SPACE 1                                                   @D05 17470000
*----------------------------------------------------------------* @D05 17480000
*        Loop writing minor lines to system messages             * @D05 17490000
*        data set.                                               * @D05 17500000
*----------------------------------------------------------------* @D05 17510000
IMLOOP   DS    0H                  Top of sysmsg loop              @D05 17520000
         USING WPLML,R3            Addressability for minor line   @D05 17530000
         LH    R0,WPLML0           Get minor line length           @D05 17540000
         SH    R0,=Y(WPLMLTXT-WPLML)  Decrement for length field   @D05 17550000
         ST    R0,RPLRLEN          Set text length in RPL          @D05 17560000
         LA    R1,WPLMLTXT         Point to text                   @D05 17570000
         ST    R1,RPLAREA          Set text address in RPL         @D05 17580000
         PUT   RPL=(R7)            Write to sysmsg data set        @D05 17590000
         LH    R0,WPLML0           Increment pointer               @D05 17600000
         AR    R3,R0                to next minor line             @D05 17610000
         BCT   R2,IMLOOP             and loop back to write it     @D05 17620000
         SPACE 1                                                   @D05 17630000
         DROP  R7                  End RPL addressability          @D05 17640000
         DROP  R3                  End minor line addressability   @D05 17650000
         TITLE '    Symptom dump message formatter - Delete recovery en+17660000
               vironment'                                               17670000
******************************************************************      17680000
*                                                                *      17690000
*        DELESTAE:                                               *      17700000
*                                                                *      17710000
*        Delete the recovery environment.                        *      17720000
*                                                                *      17730000
*        R6  = RTM2 Work Area - not referenced.                  *      17740000
*        R11 = Program base register 2.                          *      17750000
*        R12 = Program base register 1.                          *      17760000
*        R13 = Program work/save area - not referenced.          *      17770000
*                                                                *      17780000
*        Workregs:  R0, R1, R2, R3, R14, R15.                    *      17790000
*                                                                *      17800000
******************************************************************      17810000
         SPACE 1                                                        17820000
DELESTAE DS    0H                  Delete recovery environment          17830000
         ESTAE 0                   Cancel the ESTAE                     17840000
         TITLE '    Symptom dump message formatter - Free work storage' 17850000
******************************************************************      17860000
*                                                                *      17870000
*        FREEWORK:                                               *      17880000
*                                                                *      17890000
*        Unchain save areas and free getmained work storage.     *      17900000
*                                                                *      17910000
*        R11 = Program base register 2.                          *      17920000
*        R12 = Program base register 1.                          *      17930000
*        R13 = Program work/save area - freed in this routine.   *      17940000
*                                                                *      17950000
*        Workregs = R0, R1, R15.                                 *      17960000
*                                                                *      17970000
******************************************************************      17980000
         SPACE 1                                                        17990000
FREEWORK DS    0H                  Free work area storage               18000000
         LR    R1,R13              Set address for freemain             18010000
         L     R13,4(,R13)         Restore caller's save area address   18020000
         FREEMAIN RU,              Free                                +18030000
               LV=LWORKA,A=(1),     work area                          +18040000
               SP=WORKSP             storage                            18050000
         TITLE '    Symptom dump message formatter - Restore registers +18060000
               and return'                                              18070000
******************************************************************      18080000
*                                                                *      18090000
*        RETURN0/RETURN8/RETURN:                                 *      18100000
*                                                                *      18110000
*        Restore registers and return to caller with             *      18120000
*        return code in R15.                                     *      18130000
*                                                                *      18140000
*        R11 = Program base register 2.                          *      18150000
*        R12 = Program base register 1.                          *      18160000
*                                                                *      18170000
*        Workregs = R15.                                         *      18180000
*                                                                *      18190000
******************************************************************      18200000
         SPACE 1                                                        18210000
RETURN8  DS    0H                  Exit from SYSVTSYM with RC=8         18220000
         LA    R15,8               Set return code 8                    18230000
         B     RETURN              To common exit logic                 18240000
         SPACE 1                                                        18250000
RETURN0  DS    0H                  Exit from SYSVTSYM with RC=0         18260000
         XR    R15,R15             Set return code 0                    18270000
         SPACE 1                                                        18280000
RETURN   DS    0H                  Common exit logic                    18290000
         RETURN (14,12),RC=(15)    Restore registers and return         18300000
         TITLE '    Symptom dump message formatter - Issue error messag+18310000
               e if getmain failed'                                     18320000
******************************************************************      18330000
*                                                                *      18340000
*        GMFAIL:                                                 *      18350000
*                                                                *      18360000
*        Our getmain for work storage failed.  Issue             *      18370000
*        message to that effect and go to exit with error.       *      18380000
*                                                                *      18390000
*        R11 = Program base register 2.                          *      18400000
*        R12 = Program base register 1.                          *      18410000
*        R13 = Program work/save area.                           *      18420000
*                                                                *      18430000
*        Workregs = R0, R1, R15.                                 *      18440000
*                                                                *      18450000
******************************************************************      18460000
         SPACE 1                                                        18470000
GMFAIL   DS    0H                  Getmain for work storage failed      18480000
         WTO   MF=(E,SNAPMSG)      Say "SYMPTOM DUMP FAILED"            18490000
         B     RETURN8             Go to exit with error                18500000
         SPACE 1                                                        18510000
SNAPMSG  WTO   '&P.912I RECOVERY/TERMINATION SYMPTOM DUMP FAILED DUE TO+18520000
                GETMAIN FAILURE',MF=L,ROUTCDE=(2)                       18530000
         TITLE '    Symptom dump message formatter - Contants and liter+18540000
               als'                                                     18550000
******************************************************************      18560000
*                                                                *      18570000
*        Constants and literals.                                 *      18580000
*                                                                *      18590000
******************************************************************      18600000
         SPACE 1                                                        18610000
*----------------------------------------------------------------*      18620000
*        Table to translate unpacked hex to character.           *      18630000
*----------------------------------------------------------------*      18640000
HEXTBL   DS    0XL256                                                   18650000
         DC    (C'0')X'00'                                              18660000
         DC    C'0123456789ABCDEF'                                      18670000
         DC    (L'HEXTBL-(*-HEXTBL))X'00'                               18680000
         SPACE 1                                                        18690000
*----------------------------------------------------------------*      18700000
*        Text inserts for IEA995I message.                       *      18710000
*----------------------------------------------------------------*      18720000
KUSER    DC    C'  USER'           INSERT FOR USER COMPLETION CODE      18730000
KSYSTEM  DC    C'SYSTEM'           INSERT FOR SYSTEM COMPLETION CODE    18740000
KREATXT  DC    C'REASON CODE='     INSERT FOR REASON CODE               18750000
NOMODMSG DC    CL22'NO ACTIVE MODULE FOUND'                             18760000
KNACCES  DC    C'IS INACCESSIBLE'                                       18770000
         SPACE 1                                                        18780000
*----------------------------------------------------------------*      18790000
*        Some utility blanks.                                    *      18800000
*----------------------------------------------------------------*      18810000
BLANKS   DC    CL70' '             Utility blanks                       18820000
         SPACE 1                                                        18830000
*----------------------------------------------------------------*      18840000
*        Compare value to test for end of PLPA directory.        *      18850000
*----------------------------------------------------------------*      18860000
XFF      DC    A(X'FFFFFFFF')      A word of high-values                18870000
         SPACE 1                                                        18880000
*----------------------------------------------------------------*      18890000
*        Model ESTAE CT parameter list.                          *      18900000
*----------------------------------------------------------------*      18910000
MSTAEPR# ESTAE ,CT,MF=L            Model ESTAE parameter list           18920000
MSTAEPRM EQU   MSTAEPR#,*-MSTAEPR# Alias with length                    18930000
         EJECT ,                                                        18940000
*----------------------------------------------------------------*      18950000
*        Table of system completion codes that have reason       *      18960000
*        codes in R15.  The first two bytes of each entry        *      18970000
*        contain a completion code, the last two bytes a mask    *      18980000
*        that is ANDed against the completion code from RTM      *      18990000
*        before comparing it against the table entry.  The       *      19000000
*        end of the table is indicated by an entry that is       *      19010000
*        all X'FF'.                                              *      19020000
*----------------------------------------------------------------*      19030000
CCTBL    DS    0H                  Abend codes that have reasons        19040000
*              --code-mask--                                            19050000
         DC    X'0002,0FFF'        002                                  19060000
         DC    X'0013,00FF'        x13                                  19070000
         DC    X'0014,00FF'        x14                                  19080000
         DC    X'0037,00FF'        x37                                  19090000
         DC    X'0106,0FFF'        106                                  19100000
         DC    X'0305,0FFF'        305                                  19110000
         DC    X'0306,0FFF'        306                                  19120000
         DC    X'030A,0FFF'        30A                                  19130000
         DC    X'0378,0FFF'        378                                  19140000
         DC    X'0604,0FFF'        604                                  19150000
         DC    X'0804,0FFF'        804                                  19160000
         DC    X'0806,0FFF'        806                                  19170000
         DC    X'080A,0FFF'        80A                                  19180000
         DC    X'0878,0FFF'        878                                  19190000
         DC    X'0A05,0FFF'        A05                                  19200000
         DC    X'0A78,0FFF'        A78                                  19210000
         DC    X'0A0A,0FFF'        A0A                                  19220000
         DC    X'FFFF,FFFF'        End of table                         19230000
         EJECT ,                                                        19240000
*----------------------------------------------------------------*      19250000
*        Model WPL for IEA995I message.                          *      19260000
*----------------------------------------------------------------*      19270000
MMSG995# WTO   ('&P.995I SYMPTOM DUMP OUTPUT',C),                      +19280000
               ('SYSTEM COMPLETION CODE=                               +19290000
                               ',D),                                   +19300000
               (' TIME=XX.XX.XX  SEQ=XXXXX  CPU=XXXX  ASID=XXXX        +19310000
                               ',D),                                   +19320000
               (' PSW AT TIME OF ERROR  XXXXXXXX   XXXXXXXX  ILC X  INT+19330000
               C XX            ',D),                                   +19340000
               ('   ACTIVE LOAD MODULE=XXXXXXXX  ADDRESS=XXXXXXXX  OFFS+19350000
               ET=XXXXXXXX     ',D),                                   +19360000
               ('   DATA AT PSW  XXXXXXXX - XXXXXXXX  XXXXXXXX  XXXXXXX+19370000
               X               ',D),                                   +19380000
               ('   GPR  0-3  XXXXXXXX  XXXXXXXX  XXXXXXXX  XXXXXXXX   +19390000
                               ',D),                                   +19400000
               ('   GPR  4-7  XXXXXXXX  XXXXXXXX  XXXXXXXX  XXXXXXXX   +19410000
                               ',D),                                   +19420000
               ('   GPR  8-11 XXXXXXXX  XXXXXXXX  XXXXXXXX  XXXXXXXX   +19430000
                               ',D),                                   +19440000
               ('   GPR 12-15 XXXXXXXX  XXXXXXXX  XXXXXXXX  XXXXXXXX   +19450000
                               ',D),                                   +19460000
               (' END OF SYMPTOM DUMP                                  +19470000
                               ',DE),ROUTCDE=2,DESC=(6,9),MF=L          19480000
MMSG995  EQU    MMSG995#,*-MMSG995#  Alias with length                  19490000
         SPACE 1                                                        19500000
*----------------------------------------------------------------*      19510000
*        Generate main program literal pool.                     *      19520000
*----------------------------------------------------------------*      19530000
         LTORG ,                   Generate literal pool                19540000
         TITLE '    Symptom dump message formatter - Hex-to-printable c+19550000
               onversion subroutine'                                    19560000
*********************************************************************** 19570000
*                                                                     * 19580000
*                                                                     * 19590000
* Subroutine           =  HEXTOPRT                                    * 19600000
*                                                                     * 19610000
*   Purpose            =  To convert the four-byte (eight-digit)      * 19620000
*                         hex value in R1 to printable equivalent.    * 19630000
*                                                                     * 19640000
*   Linkage            =  From mainline code via BAL R14.             * 19650000
*                                                                     * 19660000
*   Recovery           =  Caller's ESTAE.                             * 19670000
*                                                                     * 19680000
*   Input data         =                                              * 19690000
*       R0     = Not applicable.                                      * 19700000
*       R1     = Eight-digit hex number to be formatted.              * 19710000
*       R2-R11 = Not applicable.                                      * 19720000
*       R12    = Main program base register.                          * 19730000
*       R13    = Main program work/save area.                         * 19740000
*       R14    = Return address.                                      * 19750000
*       R15    = Not applicable.                                      * 19760000
*                                                                     * 19770000
*   Registers saved    =  None                                        * 19780000
*                                                                     * 19790000
*   Register usage     =                                              * 19800000
*       R0-15  = Not modified                                         * 19810000
*                                                                     * 19820000
*   Registers restored =  None                                        * 19830000
*                                                                     * 19840000
*   Output data        =                                              * 19850000
*       The first eight bytes of the HEXWORK field contain the        * 19860000
*       hex data passed to this subroutine in R1 converted to         * 19870000
*       printable format.                                             * 19880000
*                                                                     * 19890000
*   Exit (normal)      =  Return to caller via BR R14.                * 19900000
*     Conditions       =  Always.                                     * 19910000
*     Output           =  Printable hex data in HEXWORK.              * 19920000
*     Return code      =  Not applicable                              * 19930000
*                                                                     * 19940000
*                                                                     * 19950000
*********************************************************************** 19960000
         EJECT ,                                                        19970000
******************************************************************      19980000
*                                                                *      19990000
*        HEXTOPRT:                                               *      20000000
*                                                                *      20010000
*        Subroutine to convert the four-byte hex value           *      20020000
*        in R1 to printable equivalent.                          *      20030000
*                                                                *      20040000
*        R1  = (at entry) Hex value to be translated.            *      20050000
*        R13 = Program work/save area.                           *      20060000
*        R14 = Subroutine return address.                        *      20070000
*                                                                *      20080000
******************************************************************      20090000
         SPACE 1                                                        20100000
HEXTOPRT DS    0H                  Hex conversion subroutine            20110000
         STCM  R1,15,HEXWORK       Set value in unpack work area        20120000
         UNPK  HEXWORK9,HEXWORK5   Unpack value                         20130000
         TR    HEXWORK8,HEXTBL     Translate to printable               20140000
         BR    R14                 Return to caller                     20150000
         TITLE '    Symptom dump message formatter - Dynamic work area' 20160000
******************************************************************      20170000
*                                                                *      20180000
*        Map SYSVTSYM dynamic work area.                         *      20190000
*                                                                *      20200000
******************************************************************      20210000
         SPACE 1                                                        20220000
WORKSP   EQU   230                 SUBPOOL FOR WORK AREA                20230000
*ORKSP   EQU   0                   SUBPOOL FOR WORK AREA                20240000
WORKA    DSECT ,                   Dynamic work area                    20250000
         SPACE 1                                                        20260000
*----------------------------------------------------------------*      20270000
*        Main routine save area.                                 *      20280000
*----------------------------------------------------------------*      20290000
SAVEA    DS    18F                 PROGRAM SAVE AREA                    20300000
         SPACE 1                                                        20310000
*----------------------------------------------------------------*      20320000
*        A save area for use by the ESTAE routine.               *      20330000
*----------------------------------------------------------------*      20340000
ERSAVEA  DS    18F                 ESTAE routine save area              20350000
         SPACE 1                                                        20360000
*----------------------------------------------------------------*      20370000
*        Doubleword work area.                                   *      20380000
*----------------------------------------------------------------*      20390000
DWORK    DS    D                   Doubleword work area                 20400000
         SPACE 1                                                        20410000
*----------------------------------------------------------------*      20420000
*        Abend registers, PSW, next instruction address,         *      20430000
*        interrupt code, instruction length code, all            *      20440000
*        saved for formatting into the symptom dump message.     *      20450000
*----------------------------------------------------------------*      20460000
REPSW    DS    D                   PSW at abend                         20470000
REREG    DS    XL(16*4)            Registers at abend                   20480000
RNXT1    DS    A                   Next instruction address from PSW    20490000
RC       DS    F                   Binary reason code for abend         20500000
INTCOD   DS    CL2                 Interrupt code                       20510000
INLNTH   DS    CL1                 Instruction length code              20520000
         SPACE 1                                                        20530000
*----------------------------------------------------------------*      20540000
*        Start and end address of the 12-byte range of           *      20550000
*        data on either side of the abend PSW address            *      20560000
*        that we will format in the symptop dump message.        *      20570000
*----------------------------------------------------------------*      20580000
STRTPDAT DS    A                   Start address for data range         20590000
ENDPDAT  DS    A                   End address for data range           20600000
         EJECT ,                                                        20610000
*----------------------------------------------------------------*      20620000
*        The address to which our ESTAE routine should           *      20630000
*        retry is saved here.  For most of symptom dump          *      20640000
*        processing, the retry address points to DELESTAE,       *      20650000
*        which effectively causes further symptom dump           *      20660000
*        processing to be skipped.  While we are copying         *      20670000
*        the abend PSW data area to our work area, the           *      20680000
*        retry address points to COPYERR, which handles          *      20690000
*        the case in which the copy fails by inserting           *      20700000
*        "DATA AT PSW IS INACCESSIBLE" text in the message.      *      20710000
*----------------------------------------------------------------*      20720000
ERESTART DS    A                   Retry address for ESTAE              20730000
         SPACE 1                                                        20740000
*----------------------------------------------------------------*      20750000
*        Work areas used in completion code and reason code      *      20760000
*        processing.                                             *      20770000
*----------------------------------------------------------------*      20780000
SYSCC    DS    H                   Save system abend code here          20790000
CCWORK   DS    H                   Work area for building reason        20800000
         SPACE 1                                                        20810000
*----------------------------------------------------------------*      20820000
*        Area for ESTAE CT parameter list.                       *      20830000
*----------------------------------------------------------------*      20840000
         DS    0F                  Force fullword alignment             20850000
STAEPRM  DS    CL(L'MSTAEPRM)      Area for ESTAE parm list             20860000
         SPACE 1                                                        20870000
*----------------------------------------------------------------*      20880000
*        Data from the 12-byte area on either side of            *      20890000
*        the abend PSW is copied here to be available            *      20900000
*        for formatting into the symptom dump message.           *      20910000
*----------------------------------------------------------------*      20920000
PSWWAREA DS    CL13                PSW data work area                   20930000
         SPACE 1                                                        20940000
*----------------------------------------------------------------*      20950000
*        Area used for translating the 12 bytes of data          *      20960000
*        around the abend PSW address to printable.              *      20970000
*----------------------------------------------------------------*      20980000
PSWPAREA DS    0CL25               PSW data in printable                20990000
PSWSTOR1 DS    CL8                 -- Unpacked PSW data word 1          21000000
PSWSTOR2 DS    CL8                 -- Unpacked PSW data word 2          21010000
PSWSTOR3 DS    CL8                 -- Unpacked PSW data word 3          21020000
         DS    CL1                 -- Filler for sign                   21030000
         SPACE 1                                                        21040000
*----------------------------------------------------------------*      21050000
*        A work area for using in converting hex                 *      21060000
*        to printable.                                           *      21070000
*----------------------------------------------------------------*      21080000
HEXWORK  DS    CL9                 Hex conversion work area             21090000
HEXWORK9 EQU   HEXWORK,9,C'C'      -- First 9 bytes of work area        21100000
HEXWORK8 EQU   HEXWORK,8,C'C'      -- First 8 bytes of work area        21110000
HEXWORK5 EQU   HEXWORK,5,C'C'      -- First 5 bytes of work area        21120000
         EJECT ,                                                        21130000
*----------------------------------------------------------------*      21140000
*        Address validity flags.  The flags are used             *      21150000
*        during the copying of the 12-byte area on either        *      21160000
*        side of the abend PSW address to our work area.         *      21170000
*        Flag ESTORCP is set immediately before we do the        *      21180000
*        copy, and is turned off immediately after the copy.     *      21190000
*        ESTORERR is set by the ESTAE routine if it was          *      21200000
*        entered and found that ESTORCP is on.  All other        *      21210000
*        bits in the byte should be zero, because we             *      21220000
*        modify the byte using MVI to ensure that flags          *      21230000
*        are set atomically.                                     *      21240000
*----------------------------------------------------------------*      21250000
FLAG1    DS    XL1                 Address validity flags               21260000
ESTORCP  EQU   X'80'               -- Storage copy in progress          21270000
ESTORERR EQU   X'40'               -- Abend occurred copying storage    21280000
*              X'3F'               -- Reserved, must not be used        21290000
         TITLE '    Symptom dump message formatter - Map IEA995I messag+21300000
               e area'                                                  21310000
******************************************************************      21320000
*                                                                *      21330000
*        Reserve area for building IEA995I message and           *      21340000
*        map individual lines and fields within the message.     *      21350000
*                                                                *      21360000
******************************************************************      21370000
         SPACE 1                                                        21380000
*----------------------------------------------------------------*      21390000
*        Define area for building IEA995I message.               *      21400000
*----------------------------------------------------------------*      21410000
         DS    0H                        Force halfword alignment       21420000
MSG995   DS    CL(L'MMSG995)             Area for IEA995I message       21430000
         SPACE 1                                                        21440000
*----------------------------------------------------------------*      21450000
*        Map message lines.                                      *      21460000
*----------------------------------------------------------------*      21470000
M5LN1    EQU   MSG995+04,27,C'C'         Message line 1 text            21480000
M5LN2    EQU   MSG995+43,70,C'C'         Message line 2 text            21490000
M5LN3    EQU   M5LN2+L'M5LN2+4,70,C'C'   Message line 3 text            21500000
M5LN4    EQU   M5LN3+L'M5LN3+4,70,C'C'   Message line 4 text            21510000
M5LN5    EQU   M5LN4+L'M5LN4+4,70,C'C'   Message line 5 text            21520000
M5LN6    EQU   M5LN5+L'M5LN5+4,70,C'C'   Message line 6 text            21530000
M5LN7    EQU   M5LN6+L'M5LN6+4,70,C'C'   Message line 7 text            21540000
M5LN8    EQU   M5LN7+L'M5LN7+4,70,C'C'   Message line 8 text            21550000
M5LN9    EQU   M5LN8+L'M5LN8+4,70,C'C'   Message line 9 text            21560000
M5LN10   EQU   M5LN9+L'M5LN9+4,70,C'C'   Message line 10 text           21570000
M5LN11   EQU   M5LN10+L'M5LN10+4,70,C'C' Message line 11 text           21580000
         SPACE 1                                                        21590000
*----------------------------------------------------------------*      21600000
*        Map fields in line 2:                                   *      21610000
*        xxxxxx COMPLETION CODE=xxxx                             *      21620000
*----------------------------------------------------------------*      21630000
M5CCTYPE EQU   M5LN2+00,6,C'C'           Completion code type           21640000
M5CC     EQU   M5LN2+23,4,C'C'           Completion code                21650000
M5REATXT EQU   M5LN2+28,12,C'C'          "REASON CODE"                  21660000
M5REASON EQU   M5LN2+40,8,C'C'           Reason code                    21670000
         SPACE 1                                                        21680000
*----------------------------------------------------------------*      21690000
*        Map fields in line 3:                                   *      21700000
*        TIME=hh.mm.ss SEQ=nnnnn CPU=nnnn ASID=nnnn              *      21710000
*----------------------------------------------------------------*      21720000
M5TIME   EQU   M5LN3+06,8,C'C'           Time of abend                  21730000
M5HH     EQU   M5TIME+00,2,C'C'          -- Hour                        21740000
M5MM     EQU   M5TIME+03,2,C'C'          -- Minutes                     21750000
M5SS     EQU   M5TIME+06,2,C'C'          -- Seconds                     21760000
M5SEQ    EQU   M5LN3+20,5,C'C'           Sequence number                21770000
M5CPU    EQU   M5LN3+31,4,C'C'           CPU number                     21780000
M5ASID   EQU   M5LN3+42,4,C'C'           ASID                           21790000
         EJECT ,                                                        21800000
******************************************************************      21810000
*                                                                *      21820000
*        IEA995I message area (continued).                       *      21830000
*                                                                *      21840000
******************************************************************      21850000
         SPACE 1                                                        21860000
*----------------------------------------------------------------*      21870000
*        Map fields in line 4:                                   *      21880000
*        PSW AT TIME OF ERROR xxxxxxxx xxxxxxxx ILC n INTC nn    *      21890000
*----------------------------------------------------------------*      21900000
M5PSW1   EQU   M5LN4+23,8,C'C'           PSW word 1                     21910000
M5PSW2   EQU   M5LN4+34,8,C'C'           PSW word 2                     21920000
M5ILC    EQU   M5LN4+48,1,C'C'           Instruction length code        21930000
M5IC     EQU   M5LN4+56,2,C'C'           Interrupt code                 21940000
         SPACE 1                                                        21950000
*----------------------------------------------------------------*      21960000
*        Map fields in line 5:                                   *      21970000
*        ACTIVE LOAD MODULE=cccccccc ADDRESS=xxxx OFFSET=xxxx    *      21980000
*----------------------------------------------------------------*      21990000
M5MODNM  EQU   M5LN5+22,8,C'C'           Module name                    22000000
M5MODADR EQU   M5LN5+40,8,C'C'           Module address                 22010000
M5MODOFF EQU   M5LN5+57,8,C'C'           Module offset                  22020000
M5NOMOD  EQU   M5LN5+03,L'NOMODMSG,C'C'  "NO ACTIVE MODULE FOUND"       22030000
         SPACE 1                                                        22040000
*----------------------------------------------------------------*      22050000
*        Map fields in line 6:                                   *      22060000
*        DATA AT PSW xxxxxxxx - xxxxxxxx xxxxxxxx xxxxxxxx       *      22070000
*----------------------------------------------------------------*      22080000
M5DATP   EQU   M5LN6+16,39,C'C'          PSW data area                  22090000
M5DATADR EQU   M5LN6+16,8,C'C'           Data address                   22100000
M5DATP1  EQU   M5LN6+27,8,C'C'           Data word 1                    22110000
M5DATP2  EQU   M5LN6+37,8,C'C'           Data word 2                    22120000
M5DATP3  EQU   M5LN6+47,8,C'C'           Data word 3                    22130000
M5NACCES EQU   M5LN6+15,L'KNACCES,C'C'   "IS INACCESSIBLE"              22140000
         SPACE 1                                                        22150000
*----------------------------------------------------------------*      22160000
*        Map fields in line 7:                                   *      22170000
*        GPR  0-3  xxxxxxxx  xxxxxxxx  xxxxxxxx  xxxxxxxx        *      22180000
*----------------------------------------------------------------*      22190000
M5REG0   EQU   M5LN7+13,8,C'C'           Register 0 contents            22200000
M5REG1   EQU   M5LN7+23,8,C'C'           Register 1 contents            22210000
M5REG2   EQU   M5LN7+33,8,C'C'           Register 2 contents            22220000
M5REG3   EQU   M5LN7+43,8,C'C'           Register 3 contents            22230000
         SPACE 1                                                        22240000
*----------------------------------------------------------------*      22250000
*        Map fields in line 8:                                   *      22260000
*        GPR  4-7  xxxxxxxx  xxxxxxxx  xxxxxxxx  xxxxxxxx        *      22270000
*----------------------------------------------------------------*      22280000
M5REG4   EQU   M5LN8+13,8,C'C'           Register 4 contents            22290000
M5REG5   EQU   M5LN8+23,8,C'C'           Register 5 contents            22300000
M5REG6   EQU   M5LN8+33,8,C'C'           Register 6 contents            22310000
M5REG7   EQU   M5LN8+43,8,C'C'           Register 7 contents            22320000
         EJECT ,                                                        22330000
******************************************************************      22340000
*                                                                *      22350000
*        IEA995I message area (continued).                       *      22360000
*                                                                *      22370000
******************************************************************      22380000
         SPACE 1                                                        22390000
*----------------------------------------------------------------*      22400000
*        Map fields in line 9:                                   *      22410000
*        GPR  8-11 xxxxxxxx  xxxxxxxx  xxxxxxxx  xxxxxxxx        *      22420000
*----------------------------------------------------------------*      22430000
M5REG8   EQU   M5LN9+13,8,C'C'           Register 8 contents            22440000
M5REG9   EQU   M5LN9+23,8,C'C'           Register 9 contents            22450000
M5REG10  EQU   M5LN9+33,8,C'C'           Register 10 contents           22460000
M5REG11  EQU   M5LN9+43,8,C'C'           Register 11 contents           22470000
         SPACE 1                                                        22480000
*----------------------------------------------------------------*      22490000
*        Map fields in line 10:                                  *      22500000
*        GPR 12-15 xxxxxxxx  xxxxxxxx  xxxxxxxx  xxxxxxxx        *      22510000
*----------------------------------------------------------------*      22520000
M5REG12  EQU   M5LN10+13,8,C'C'          Register 12 contents    *      22530000
M5REG13  EQU   M5LN10+23,8,C'C'          Register 13 contents    *      22540000
M5REG14  EQU   M5LN10+33,8,C'C'          Register 14 contents    *      22550000
M5REG15  EQU   M5LN10+43,8,C'C'          Register 15 contents    *      22560000
         TITLE '    Symptom dump message formatter - Dynamic work area' 22570000
*----------------------------------------------------------------*      22580000
*        End of dynamic work area.                                      22590000
*----------------------------------------------------------------*      22600000
         DS    0D                  Force doubleword alignment           22610000
LWORKA   EQU   *-WORKA             Symbolic length of work area         22620000
         TITLE '    Symptom dump message formatter - System control blo+22630000
               cks'                                                     22640000
******************************************************************      22650000
*                                                                *      22660000
*        Map system control blocks.                              *      22670000
*                                                                *      22680000
******************************************************************      22690000
         SPACE 1                                                        22700000
         PUSH PRINT                Save PRINT status                    22710000
**       PRINT NOGEN               Don't print macro expansions         22720000
         SPACE 1                                                        22730000
*----------------------------------------------------------------*      22740000
*        OS Task Control Block (TCB).                            *      22750000
*----------------------------------------------------------------*      22760000
         IKJTCB ,                  Task Control Block                   22770000
         SPACE 1                                                        22780000
*----------------------------------------------------------------*      22790000
*        OS Communications Vector Table (CVT).                   *      22800000
*----------------------------------------------------------------*      22810000
         CVT   LIST=NO,DSECT=YES   Communications Vector Table          22820000
         SPACE 1                                                        22830000
*----------------------------------------------------------------*      22840000
*        MVS Link Pack Directory Entry (LPDE).                   *      22850000
*----------------------------------------------------------------*      22860000
         IHALPDE                                                        22870000
LPDELEN  EQU   *-LPDE              Symbolic length of LPDE              22880000
         SPACE 1                                                        22890000
*----------------------------------------------------------------*      22900000
*        OS Contents Directory Entry (CDE).                      *      22910000
*----------------------------------------------------------------*      22920000
         IHACDE ,                  Contents Directory Entry             22930000
         SPACE 1                                                        22940000
*----------------------------------------------------------------*      22950000
*        OS Contents Supervision Extent List (XTLST).            *      22960000
*----------------------------------------------------------------*      22970000
         IHAXTLST ,                Extent List                          22980000
         SPACE 1                                                        22990000
*----------------------------------------------------------------*      23000000
*        OS Request Blocks (RBs).                                *      23010000
*----------------------------------------------------------------*      23020000
         IHARB ,                   Request Blocks                       23030000
         SPACE 1                                                        23040000
*----------------------------------------------------------------*      23050000
*        System Diagnostic Work Area (SDWA).                     *      23060000
*----------------------------------------------------------------*      23070000
**       POP   PRINT               Restore PRINT status                 23080000
         IHASDWA ,                 System Diagnostic Work Area          23090000
         SPACE 1                                                   @D02 23100000
*----------------------------------------------------------------* @D02 23110000
*        OS WTO Parameter List (WPL).                            * @D02 23120000
*----------------------------------------------------------------* @D02 23130000
         IEZWPL ,                  WTO Parameter List              @D02 23140000
         SPACE 1                                                   @D02 23150000
*----------------------------------------------------------------* @D02 23160000
*        TSO Protected Step Control Block (PSCB).                * @D02 23170000
*----------------------------------------------------------------* @D02 23180000
         IKJPSCB ,                 Map PSCB                        @D02 23190000
         SPACE 1                                                   @D02 23200000
*----------------------------------------------------------------* @D02 23210000
*        TSO User Profile Table (UPT).                           * @D02 23220000
*----------------------------------------------------------------* @D02 23230000
         IKJUPT ,                  User Profile Table              @D02 23240000
         SPACE 1                                                   @D02 23250000
*----------------------------------------------------------------* @D02 23260000
*        OS Job Step Control Block (JSCB).                       * @D02 23270000
*----------------------------------------------------------------* @D02 23280000
         IEZJSCB ,                 Job Step Control Block          @D02 23290000
         SPACE 1                                                   @D02 23300000
*----------------------------------------------------------------* @D02 23310000
*        OS Command Scheduling Control Block (CSCB).             * @D02 23320000
*----------------------------------------------------------------* @D02 23330000
CSCB     DSECT ,                   CSCB DSECT                      @D02 23340000
         IEECHAIN .                Map CSCB                        @D02 23350000
         SPACE 1                                                   @D02 23360000
*----------------------------------------------------------------* @D02 23370000
*        Prefixed Low Storage Area (PSA).                        * @D02 23380000
*----------------------------------------------------------------* @D02 23390000
         IHAPSA ,                  Map low storage                 @D02 23400000
         SPACE 1                                                   @D05 23410000
*----------------------------------------------------------------* @D05 23420000
*        Request Parameter List (RPL).                           * @D05 23430000
*----------------------------------------------------------------* @D05 23440000
         IFGRPL DSECT=YES          Map RPL                         @D05 23450000
         SPACE 1                                                        23460000
         POP   PRINT               Restore PRINT status                 23470000
         EJECT ,                                                        23480000
         TITLE '    Symptom dump message formatter - RTM2 Work Area'    23490000
******************************************************************      23500000
*                                                                *      23510000
*        Map selected RTM2 Work Area fields.                     *      23520000
*                                                                *      23530000
******************************************************************      23540000
         SPACE 1                                                        23550000
*        IHARTM2A ,                RTM2 Work Area                       23560000
RTM2WA   DSECT ,                   Map selected RTM2WA fields           23570000
RTM2ID   EQU   RTM2WA+00,4,C'C'    "RTM2" control block ID              23580000
RTM2ADDR EQU   RTM2WA+04,4,C'A'    Address of this RTM2WA               23590000
RTM2RT2D EQU   RTM2WA+08,4,C'C'    Subpool and length of RTM2WA         23600000
RTM2SPID EQU   RTM2WA+08,1,C'X'    -- Subpool of this RTM2WA            23610000
RTM2LGTH EQU   RTM2WA+09,3,C'X'    -- Length of this RTM2WA             23620000
RTM2CVT  EQU   RTM2WA+12,4,C'A'    Address of the CVT                   23630000
RTM2TCBC EQU   RTM2WA+16,4,C'A'    Address of the current TCB           23640000
RTM2VRBC EQU   RTM2WA+20,4,C'A'    Address of the current SVRB          23650000
RTM2ASC  EQU   RTM2WA+24,4,C'A'    Address of current ASCB              23660000
RTM2CODE EQU   RTM2WA+28,4,C'X'    Completion code and flags            23670000
RTM2CCF  EQU   RTM2CODE,1,C'X'     Completion code flags                23680000
RTM2DREQ EQU   X'80'               -- Dump requested                    23690000
RTM2STEP EQU   X'40'               -- Step requested                    23700000
RTM2R0DP EQU   X'20'               -- R0 contains parameters            23710000
RTM2EOM  EQU   X'10'               -- Memory termination requested      23720000
RTM2EOT  EQU   X'08'               -- Task termination requested        23730000
RTM2REAF EQU   X'04'               -- Reason code exists               +23740000
                                      (not set by MVS 3.8)              23750000
RTM2CC   EQU   RTM2CODE+1,3,C'X'   Completion code                      23760000
RTM2TCBT EQU   RTM2WA+48,4,C'A'    Address of top TCB in failing tree   23770000
RTM2VRBT EQU   RTM2WA+52,4,C'A'    RTM2 SVRB queued from top TCB       +23780000
                                   in failing tree                      23790000
RTM2CT   EQU   RTM2WA+56,4,C'A'    Address of RTCT                      23800000
RTM2EREG EQU   RTM2WA+60,64,C'X'   General purpose registers at abend   23810000
RTM2EPSW EQU   RTM2WA+124,8,C'X'   Extended control PSW at abend        23820000
RTM2NXT1 EQU   RTM2WA+132,4,C'A'   Address of next instruction          23830000
RTM2ILC1 EQU   RTM2WA+133,1,C'X'   Instruction length code              23840000
RTM2INC1 EQU   RTM2WA+134,2,C'X'   Interrupt code                       23850000
RTM2RMSA EQU   RTM2WA+800,72,C'F'  Resource manager save area           23860000
RTM2ERID EQU   RTM2WA+872,10,C'X'  Errorid                              23870000
RTM2SEQ# EQU   RTM2WA+872,2,C'X'   -- Sequence number                   23880000
RTM2CPUI EQU   RTM2WA+874,2,C'X'   -- Logical CPU ID                    23890000
RTM2ERAS EQU   RTM2WA+876,2,C'X'   -- ASID for error memory             23900000
RTM2ERTM EQU   RTM2WA+878,4,C'X'   -- Time stamp                        23910000
         TITLE '    Symptom dump message formatter - ESTAE routine'     23920000
*********************************************************************** 23930000
*                                                                     * 23940000
*                                                                     * 23950000
* Entry point          =  ESTAERTN                                    * 23960000
*                                                                     * 23970000
*   Purpose            =  ESTAE routine                               * 23980000
*                                                                     * 23990000
*   Linkage            =  From RTM via SYNCH                          * 24000000
*                                                                     * 24010000
*   Recovery           =                                              * 24020000
*                                                                     * 24030000
*   Input data         =                                              * 24040000
*       R0     = A code indicating ESTAE entry status:                * 24050000
*                  12       No storage was available for an SDWA      * 24060000
*                  not 12   R1 points to an SDWA                      * 24070000
*       R1     = Address of SDWA unless R0 is 12                      * 24080000
*       R14    = Return address.                                      * 24090000
*       R15    = Entry address.                                       * 24100000
*                                                                     * 24110000
*   Registers saved    =  R0 - R15                                    * 24120000
*                                                                     * 24130000
*   Register usage     =                                              * 24140000
*       R5     = Address of SDWA                                        24150000
*       R12    = ESTAE routine base register                          * 24160000
*       R13    = ESTAE routine work area (equivalent to the main      * 24170000
*                routine's work area after the main routine save      * 24180000
*                area                                                 * 24190000
*       R7-11  = Not used                                             * 24200000
*                                                                     * 24210000
*   Registers restored =  R0 - R14                                    * 24220000
*                                                                     * 24230000
*                                                                     * 24240000
*********************************************************************** 24250000
         EJECT ,                                                        24260000
*********************************************************************** 24270000
*                                                                     * 24280000
*                                                                     * 24290000
*   Exit (normal)      =  Return to RTM via BR R14.                   * 24300000
*     Conditions       =  No SDWA was provided by RTM.                * 24310000
*     Output           =  None; abend is allowed to percolate.        * 24320000
*     Return code      =  0                                           * 24330000
*                                                                     * 24340000
*   Exit (normal)      =  Return to RTM via SETRP.                    * 24350000
*     Conditions       =  ESTAE entered for cleanup only              * 24360000
*     Output           =  None; abend is allowed to percolate.        * 24370000
*     Return code      =  0                                           * 24380000
*                                                                     * 24390000
*   Exit (normal)      =  Return to RTM via SETRP.                    * 24400000
*     Conditions       =  Abend occurred during PSW area storage      * 24410000
*                         access.                                     * 24420000
*     Output           =  None.  Retry will be scheduled to resume    * 24430000
*                         execution in the mainline code at a point   * 24440000
*                         that will replace the PSW area storage      * 24450000
*                         display with a "NOT ACCESSIBLE" message.    * 24460000
*     Return code      =  4                                           * 24470000
*                                                                     * 24480000
*   Exit (normal)      =  Return to RTM via SETRP.                    * 24490000
*     Conditions       =  Abend did not occur during PSW area         * 24500000
*                         storage access.                             * 24510000
*     Output           =  Message IEA912I is written to indicate      * 24520000
*                         symptom dump failed.  Retry will be         * 24530000
*                         scheduled to resume execution in the        * 24540000
*                         mainline code at a point that will          * 24550000
*                         effectively skip further symptom            * 24560000
*                         dump processing.                            * 24570000
*     Return code      =  4                                           * 24580000
*                                                                     * 24590000
*                                                                     * 24600000
*********************************************************************** 24610000
         DROP  ,                   End all addressability               24620000
SYSVTSYM CSECT ,                   Resume main CSECT                    24630000
         EJECT ,                                                        24640000
******************************************************************      24650000
*                                                                *      24660000
*        ESTAERTN:                                               *      24670000
*                                                                *      24680000
*        Start of ESTAE routine.  Determine if RTM               *      24690000
*        provided an SDWA.  If not, exit immediately             *      24700000
*        and let RTM percolate the abend.                        *      24710000
*                                                                *      24720000
*        R1  = (at entry) Address of SDWA if one was provided.   *      24730000
*        R15 = (at entry) Address of ESTAE routine.              *      24740000
*                                                                *      24750000
******************************************************************      24760000
         SPACE 1                                                        24770000
*----------------------------------------------------------------*      24780000
*        ESTAE routine initialization.                           *      24790000
*----------------------------------------------------------------*      24800000
ESTAERTN DS    0H                  ESTAE routine                        24810000
         USING ESTAERTN,R15        Temporary addressability             24820000
         SPACE 1                                                        24830000
*----------------------------------------------------------------*      24840000
*        Test if RTM provided an SDWA.  If there is no           *      24850000
*        SDWA, return immediately to RTM indicating that         *      24860000
*        abend should percolate.                                 *      24870000
*----------------------------------------------------------------*      24880000
         CH    R0,=H'12'           Was SDWA provided?                   24890000
         BNE   ERSDWAOK            Continue if SDWA provided            24900000
         XR    R15,R15             Show abend is to percolate           24910000
         BR    R14                 Return to RTM                        24920000
         EJECT ,                                                        24930000
******************************************************************      24940000
*                                                                *      24950000
*        ERSDWAOK:                                               *      24960000
*                                                                *      24970000
*        An SDWA was provided.  Save registers and               *      24980000
*        initialize the recovery routine's environment.          *      24990000
*        Determine if we were entered for cleanup only.          *      25000000
*        If so, return to RTM and allow abend to percolate.      *      25010000
*                                                                *      25020000
*        R5  = Address of SDWA - set from R1 at entry.           *      25030000
*        R12 = ESTAE routine base register.                      *      25040000
*        R13 = ESTAE routine work area - set in this routine.    *      25050000
*                                                                *      25060000
******************************************************************      25070000
         SPACE 1                                                        25080000
*----------------------------------------------------------------*      25090000
*        Initialize permanent pointer to SDWA, and               *      25100000
*        set up save area chain.                                 *      25110000
*----------------------------------------------------------------*      25120000
ERSDWAOK DS    0H                  RTM provided an SDWA                 25130000
         STM   R14,R12,12(R13)     Save regs in RTM's save area         25140000
         LR    R12,R15             Set base for ESTAE routine           25150000
         DROP  R15                 Drop temporary base                  25160000
         USING ESTAERTN,R12        Addressability for ESTAE routine     25170000
         LR    R5,R1               Save SDWA address                    25180000
         USING SDWA,R5             Addressability for SDWA              25190000
         LR    R1,R13              Point to RTM's save area             25200000
         L     R13,SDWAPARM        Point our save/work area             25210000
         USING ERSAVEA,R13         Addressability for work area         25220000
         ST    R13,8(,R1)          Chain                                25230000
         ST    R1,ERSAVEA+4         save areas                          25240000
         SPACE 1                                                        25250000
*----------------------------------------------------------------*      25260000
*        See if the ESTAE routine was entered for cleanup        *      25270000
*        only.  If so, return immediately to RTM allowing        *      25280000
*        the abend to continue.                                  *      25290000
*----------------------------------------------------------------*      25300000
         TM    SDWAERRD,SDWACLUP   Entered for cleanup only?            25310000
         BZ    ER1                 Branch if not                        25320000
         XC    ERESTART,ERESTART   Else zero restart address            25330000
         MVI   FLAG1,X'00'         Clear storage access flags           25340000
         L     R13,4(,R13)         Restore RTM save area pointer   @D01 25350000
         SETRP RC=0,               Return to RTM to percolate          +25360000
               REGS=(14,12),       Restore regs from SDWA              +25370000
               RECORD=NO,          Don't write LOGREC record           +25380000
               DUMP=NO             Don't take a dump                    25390000
         EJECT ,                                                        25400000
******************************************************************      25410000
*                                                                *      25420000
*        ER1:                                                    *      25430000
*                                                                *      25440000
*        We were not called for cleanup only.  Determine if      *      25450000
*        the abend occurred during access of storage around      *      25460000
*        the PSW address.  If so, return to RTM requesting       *      25470000
*        retry at the designated address.                        *      25480000
*                                                                *      25490000
*        R2  = Retry address.                                    *      25500000
*        R5  = Address of SDWA.                                  *      25510000
*        R12 = ESTAE routine base register.                      *      25520000
*        R13 = ESTAE routine work area.                          *      25530000
*                                                                *      25540000
*                                                                *      25550000
******************************************************************      25560000
         SPACE 1                                                        25570000
*----------------------------------------------------------------*      25580000
*        Determine if the abend occurred during copy of          *      25590000
*        the storage around the PSW address (ESTORCP is on).     *      25600000
*----------------------------------------------------------------*      25610000
ER1      DS    0H                                                       25620000
         ICM   R15,15,ERESTART     If restart address is zero           25630000
         BZ    ERPERC               Don't try to retry                  25640000
         TM    FLAG1,ESTORCP       Were we copying PSW storage?         25650000
         BZ    ER3                 No, skip further symdump             25660000
         SPACE 1                                                        25670000
*----------------------------------------------------------------*      25680000
*        Abend occurred while we were copying storage from       *      25690000
*        the area around the PSW address.  Retry at the          *      25700000
*        designated address.                                     *      25710000
*----------------------------------------------------------------*      25720000
ER2      DS    0H                  Retry for validation or display      25730000
         L     R2,ERESTART         Set address for retry                25740000
         XC    ERESTART,ERESTART   Prevent recursive retries            25750000
         MVI   FLAG1,ESTORERR      Show error during PSW data copy      25760000
         L     R13,4(,R13)         Restore RTM save area pointer        25770000
         SETRP RC=4,               Return to RTM for retry             +25780000
               RETADDR=(2),        Specify retry routine address       +25790000
               REGS=(14,12),       Restore RTM's registers             +25800000
               FRESDWA=YES,        Free the SDWA                       +25810000
               WKAREA=(R5),        Address of SDWA                     +25820000
               RETREGS=YES,        Restore SDWA regs for retry         +25830000
               DUMP=NO             Don't take a dump                    25840000
         EJECT ,                                                        25850000
******************************************************************      25860000
*                                                                *      25870000
*        ER3:                                                    *      25880000
*                                                                *      25890000
*        Abend did not occur during access of PSW storage.       *      25900000
*        Display error message, take a dump if appropriate,      *      25910000
*        and retry into mainline.  The code at the retry         *      25920000
*        address will clean up and exit without attempting       *      25930000
*        further symptom dump processing.                        *      25940000
*                                                                *      25950000
*        R2  = Retry address.                                    *      25960000
*        R5  = Address of SDWA.                                  *      25970000
*        R12 = ESTAE routine base register.                      *      25980000
*        R13 = ESTAE routine work area.                          *      25990000
*                                                                *      26000000
******************************************************************      26010000
         SPACE 1                                                        26020000
*----------------------------------------------------------------*      26030000
*        Take a dump, unless someone else already has.           *      26040000
*----------------------------------------------------------------*      26050000
ER3      DS    0H                  Abend not in PSW storage access      26060000
         WTO   MF=(E,M912B)        Write error message                  26070000
         TM    SDWAERRC,SDWAEAS    Has someone already dumped?          26080000
         BO    ER4                 Branch if so                         26090000
         SDUMP MF=(E,SDPLIST)      Else take a dump                     26100000
         SPACE 1                                                        26110000
*----------------------------------------------------------------*      26120000
*        Schedule retry.                                         *      26130000
*----------------------------------------------------------------*      26140000
ER4      DS    0H                  Schedule retry                       26150000
         L     R2,ERESTART         Get address for retry                26160000
         XC    ERESTART,ERESTART   Zero restart address                 26170000
         MVI   FLAG1,X'00'         Clear storage access flags           26180000
         L     R13,4(,R13)         Restore RTM save area pointer        26190000
         SETRP RC=4,               Return to RTM for retry             +26200000
               RETADDR=(2),        Specify retry routine address       +26210000
               REGS=(14,12),       Restore RTM's registers             +26220000
               FRESDWA=YES,        Free the SDWA                       +26230000
               WKAREA=(R5),        Address of SDWA                     +26240000
               RETREGS=YES,        Restore SDWA regs for retry         +26250000
               DUMP=NO             Don't take a dump                    26260000
         EJECT ,                                                        26270000
******************************************************************      26280000
*                                                                *      26290000
*        ERPERC:                                                 *      26300000
*                                                                *      26310000
*        Exit from ESTAE routine in the case that                *      26320000
*        abend is allowed to percolate.  Clear flags             *      26330000
*        and retry address, and return to RTM directing          *      26340000
*        that abend should percolate.                            *      26350000
*                                                                *      26360000
*        R5  = Address of SDWA.                                  *      26370000
*        R12 = ESTAE routine base register.                      *      26380000
*                                                                *      26390000
******************************************************************      26400000
         SPACE 1                                                        26410000
*----------------------------------------------------------------*      26420000
*        Not going to retry, so percolate the abend.             *      26430000
*----------------------------------------------------------------*      26440000
ERPERC   DS    0H                  Exit and percolate                   26450000
         XC    ERESTART,ERESTART   Zero restart address                 26460000
         MVI   FLAG1,X'00'         Clear storage access flags           26470000
         L     R13,4(,R13)         Restore RTM save area pointer        26480000
         SETRP RC=0,               Return to RTM to percolate          +26490000
               REGS=(14,12),       Restore RTM's registers             +26500000
               RECORD=YES,         Write LOGREC record                 +26510000
               WKAREA=(R5),        Address of SDWA                     +26520000
               DUMP=YES            Take a dump                          26530000
         DROP  ,                   End all addressability               26540000
         EJECT ,                                                        26550000
*YSVTSYM CSECT ,                   RESUME MAIN CSECT                    26560000
******************************************************************      26570000
*                                                                *      26580000
*        ESTAE routine constants and literals.                   *      26590000
*                                                                *      26600000
******************************************************************      26610000
         SPACE 1                                                        26620000
*----------------------------------------------------------------*      26630000
*        SVC dump parameter list.                                *      26640000
*----------------------------------------------------------------*      26650000
SDPLIST  SDUMP HDR='ERROR IN SYMPTOM DUMP ROUTINE SYSVTSYM',           +26660000
               SDATA=(RGN,SQA,TRT),MF=L                                 26670000
         SPACE 1                                                        26680000
*----------------------------------------------------------------*      26690000
*        WPL for error message issued if the abend did not       *      26700000
*        occur during PSW area storage copy.                     *      26710000
*----------------------------------------------------------------*      26720000
M912B    WTO   '&P.912I RECOVERY/TERMINATION SYMPTOM DUMP FAILED DUE TO+26730000
                ABEND IN SYSVTSYM',MF=L,ROUTCDE=(2)                     26740000
         SPACE 1                                                   @D04 26750000
*----------------------------------------------------------------*      26760000
*        Generate ESTAE routine literal pool.                    *      26770000
*----------------------------------------------------------------*      26780000
         LTORG ,                   Generate literal pool                26790000
         END   ,                                                        26800000
??
//SMPCNTL  DD  *
  RECEIVE S(TMVS806)
        .
//*
//APPLYCK  EXEC SMPAPP,WORK='SYSALLDA'
//SMPCNTL  DD  *
  APPLY S(TMVS806)
        CHECK
        BYPASS(ID)
        .
//*
//APPLY    EXEC SMPAPP,COND=(0,NE),WORK='SYSALLDA'
//SMPCNTL  DD  *
  APPLY S(TMVS806)
        DIS(WRITE)
        .
//

//* ---- use the following if required for REJECT and RESTORE ----
//REJECT   EXEC SMPREC,WORK='SYSALLDA'
//SMPCNTL  DD  *
  REJECT S(TMVS806).
//
//RESTORE  EXEC SMPAPP,COND=(0,NE),WORK='SYSALLDA'
//SMPCNTL  DD  *
  RESTORE S(TMVS806).
//
