//SY20ZR00 JOB  (SYSGEN),TNIP800,
//*            RESTART=APPLYCK.SMP,
//*            RESTART=APPLY.SMP,
//             CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1),REGION=8192K
//*
//* 2006/11/30 @kl TNIP800 Add support for user-defined
//*                        system parameter PRISUB=.
//*
//RECEIVE  EXEC SMPREC,WORK='SYSALLDA'
//SMPPTFIN   DD DATA,DLM='??'
++ USERMOD(TNIP800) /* REWORK(20061130) */                 .
++ VER (Z038)
   FMID(EBB1102)
 /*
   PROBLEM DESCRIPTION(S):
     TNIP800 -
       Add support for user-defined system parameter PRISUB=
       to define primary subsystem name.

   COMPONENT: 5752-SC1B6-EBB1102
              5752-SC1C8-EBB1102

   APARS FIXED: TNIP800

   SPECIAL CONDITIONS:
     ACTION:  An IPL is required to after installation of
       this user modification.

   COMMENTS:
     LAST CHANGE:  2006/11/30

     This usermod makes the following changes:

       IEAVNP03 - modified to use IEAPPNIP macro to build system
                  parameters table

       IEAPPNIP - new macro to define system parameters and generate
                  system parameters table

       IEAPMNIP - IBM private macro to map parameter lists for NIP
                  service calls

       IEAVNPF1 - New RIM to set primary subsystem name from PRISUB=
                  parameter

       IEAVNIPM - modified to add new RIM IEAVNPF1 to the list of RIMs
                  to be called

       IEFJSINT - modified to use primary subsystem name set by IEAVNPF1

     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:

     MACROS
       IEAPMNIP
       IEAPPNIP
       IEAVNIPM
       IEAVNPF1
       IEAVNP03
       IEFJSINT

 */.
++ JCLIN.
//LKED  EXEC PGM=IEWL,
//           PARM='NCAL,LIST,XREF,LET'
//SYSLMOD DD DSN=SYS1.NUCLEUS
//SYSLIN  DD *
 INCLUDE SYSPUNCH(IEAVNPF1)
 NAME IEAVNPF1(R)
++ SRC      (IEAVNP03) DISTLIB(ASAMPLIB) SYSLIB(SAMPLIB ).
         TITLE 'IEAVNP03 - PARAMETER ANALYSIS/LINKLIB                  *
                        '
****************************************************************** @L01
*                                                                * @L01
*                                                                * @L01
* Module name          =  IEAVNP03                               * @L01
*                                                                * @L01
*                                                                * @L01
* Change activity      =                                         * @L01
*                                                                * @L01
*   Flag  Date        By    Description                          * @L01
*   ----  ----------  ----  ------------------------------------ * @L01
*   $L01  2003/04/14  @KL   Add hooks to support additional      * @L01
*                           system parameters.                   * @L01
*                                                                * @L01
****************************************************************** @L01
         SPACE 1                                                   @L01
*----------------------------------------------------------------* @L01
*        Generate DSECTs to map NIP Parameter Area and           * @L01
*        Parameter Table.                                        * @L01
*----------------------------------------------------------------* @L01
         IEAPPNIP DSECT=YES                                        @L01
         EJECT ,                                                   @L01
IEAVNP03 CSECT ,                                                   0001
@MAINENT DS    0H                                                  0001
         USING *,@15                                               0001
         B     @PROLOG                                             0001
         DC    AL1(19)                                             0001
*        DC    C'IEAVNP03R0300076086'                              0001
         DC    C'IEAVNP03 2003/04/14'                              @L01
         DROP  @15
@PROLOG  STM   @14,@00,12(@13)                                     0001
         STM   @02,@12,28(@13)                                     0001
         BALR  @11,0                                               0001
@PSTART  LA    @12,4095(,@11)                                      0001
         USING @PSTART,@11                                         0001
         USING @PSTART+4095,@12                                    0001
          USING @PSTART+8190,@13
          ST    @13,NP3R13                 SAVE SAVEAREA ADDR
          LA    @13,4095(0,@12)            R13 = THIRD BASE REG
*
** REFS ARE GENERATED FOR NVT FIELDS THAT CONTAIN ADDRESSES OF
** NIP SERVICE ROUTINES, SO IEAPMNIP MACRO CALLS TO THESE ROUTINES
** WILL ASSEMBLE PROPERLY.
*                                                                  0373
*   /*****************************************************************/
*   /*                                                               */
*   /* RESTRICT BASE ADDRESS REGISTER FOR THE CVT                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0374
*   NP3SAV1=RPARM;                  /* SAVE PARAMETER ADDR     Y02752*/
         ST    RPARM,NP3SAV1                                       0374
*   NP3FLAGS=NP3FLAGS&&NP3FLAGS;    /* SET CONTROL FLAG OFF          */
         XC    NP3FLAGS(3),NP3FLAGS                                0375
*   NP3MSGCL=''B;                   /* CLEAR ERROR TEXT FIELD  Y02752*/
         XC    NP3MSGCL(8),NP3MSGCL                                0376
*   RESPECIFY                                                      0377
*    (NP3BKADR,                                                    0377
*     NP3BKLN) RESTRICTED;          /*                         Y02752*/
*                                                                  0377
*   /*****************************************************************/
*   /*                                                               */
*   /* TRANSFER CONTROL TO THE NIP PROMPT CALL SEQUENCE IF THE NIP03 */
*   /* INITIALIZATION FUNCTION HAS COMPLETED.                  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0378
*   IF NVTSYSP='1'B                 /*                         Y02752*/
*     THEN                          /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           0378
         BNO   @RF00378                                            0378
*     CALL NPRMTRA3;                /*                         Y02752*/
         BAL   @14,NPRMTRA3                                        0379
*   ELSE                            /*                         Y02752*/
*     DO;                           /*                         Y02752
*                                                              Y02752*/
         B     @RC00378                                            0380
@RF00378 DS    0H                                                  0381
*       RESPECIFY                                                  0381
*         RPARM UNRESTRICTED;       /*                         Y02752*/
*       NP3BKADR=ADDR(OPTABLN);     /* ADDR OF AREA TO BE CLEARED  0382
*                                                              Y02752*/
         LA    NP3BKADR,OPTABLN                                    0382
*       NP3BKLN=LENGTH(OPTABLN);    /* LENGHT OF AREA TO BE CLEARED
*                                                              Y02752*/
*                                                                  0383
         LA    NP3BKLN,L'OPTABLN                                   @L01
*       /*************************************************************/
*       /*                                                           */
*       /* CLEAR OPERATOR PARM TABLE                           Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0384
*       CALL NP3CLRIT;              /*                         Y02752
*                                                              Y02752*/
         BAL   @14,NP3CLRIT                                        0384
*       NP3BKADR=ADDR(PTABLN);      /* ADDR OF AREA TO BE CLEARED  0385
*                                                              Y02752*/
         LA    NP3BKADR,PTABLN                                     0385
*       NP3BKLN=LENGTH(PTABLN);     /* LENGHT OF AREA TO BE CLEARED
*                                                              Y02752*/
*                                                                  0386
         LA    NP3BKLN,L'PTABLN                                    @L01
*       /*************************************************************/
*       /*                                                           */
*       /* CLEAR PARMLIB PARM TABLE                            Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0387
*       CALL NP3CLRIT;              /*                         Y02752*/
         BAL   @14,NP3CLRIT                                        0387
*       RESPECIFY                                                  0388
*        (NP3BKADR,                                                0388
*         NP3BKLN) UNRESTRICTED;    /*                         Y02752
*                                                              Y02752*/
*                                                                  0388
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO ANALYZE PARAMETERS FROM OPERATOR    Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0389
*       CALL NP3OPSP;               /*                         Y02752
*                                                              Y02752*/
*                                                                  0389
         BAL   @14,NP3OPSP                                         0389
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO DEFINE INITIAL PARMAREA BASE        Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0390
*       CALL NP3PBASE;              /*                         Y02752
*                                                              Y02752*/
*                                                                  0390
         BAL   @14,NP3PBASE                                        0390
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO OPEN SYS1.PARMLIB                   Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0391
*       CALL NP3PMLIB;              /*                         Y02752
*                                                              Y02752*/
*                                                                  0391
         BAL   @14,NP3PMLIB                                        0391
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO READ AND ANALYZE PARMLIB PARAMETERS Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0392
*       CALL NP3SYSP;               /*                         Y02752
*                                                              Y02752*/
*                                                                  0392
         BAL   @14,NP3SYSP                                         0392
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO MERGE OPERATOR AND PARMLIB INPUT    Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0393
*       CALL NP3PLMRG;              /*                         Y02752
*                                                              Y02752*/
*                                                                  0393
         BAL   @14,NP3PLMRG                                        0393
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO INITIALIZE PARMTAB (IN PARMAREA)    Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0394
*       CALL NP3PTAB;               /*                         Y02752
*                                                              Y02752*/
         BAL   @14,NP3PTAB                                         0394
*       NVTSYSP='1'B;               /* INDICATE THAT THE NIP03     0395
*                                      PARMLIB INITIALIZATION      0395
*                                      FUNCTION HAS COMPLETED  Y02752*/
         OI    NVTSYSP(RNVT),B'01000000'                           0395
*       NP3SLR13=NP3R13;            /* SAVE R13 TO ALLOW SECONDARY 0396
*                                      ENTRY FOR NIP PROMPT    Y02752
*                                                              Y02752*/
*                                                                  0396
         MVC   NP3SLR13(4),NP3R13                                  0396
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO OPEN SYS1.LINKLIB                   Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0397
*       CALL NP3LKLIB;              /*                         Y02752
*                                                              Y02752*/
*                                                                  0397
         BAL   @14,NP3LKLIB                                        0397
*       /*************************************************************/
*       /*                                                           */
*       /* CALL ROUTINE TO DEFINE LINKLIB CONCATENATIONS       Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0398
*       CALL NP3LCAT;               /*                         Y02752
*                                                              Y02752*/
         BAL   @14,NP3LCAT                                         0398
*       NP3R13=NP3SLR13;            /* RESTORE R13 SAVE AREA   Y02752*/
         MVC   NP3R13(4),NP3SLR13                                  0399
*     END;                          /*                         Y02752
*                                                              Y02752*/
*                                                                  0400
*   /*****************************************************************/
*   /*                                                               */
*   /* EXIT TO IEAVNIPM CONTROL ROUTINE                        Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0401
*   GO TO NP3EXIT;                  /*                         Y02752
*                                                              Y02752*/
*                                                                  0401
         B     NP3EXIT                                             0401
*   /*****************************************************************/
*   /*                                                               */
*   /* NIP PROMPT SERVICE ROUTINE ENTRY POINT                  Y02752*/
*   /* - USED INTERNALLY BY NP3LCAT -                          Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0402
*IEAVNPA3:                          /*                         Y02752*/
*   GENERATE NOSEQFLOW FLOWS(IEAVNP03) EXIT;                       0402
IEAVNPA3 DS    0H                                                  0402
           STM   @13,@14,NPA3RSAV-IEAVNPA3(@15)  SAVE REGS 13 AND 14
           LA    @13,NPA3RSAV-IEAVNPA3(@15)      SAVE AREA ADDR
           LA    @14,IEAVNPA3-IEAVNP03(0)        ENTRY ADDR DIFFERENCE
           SR    @15,@14           NIP03 ENTRY POINT
           BALR  @14,@15           GOTO NIP03 MAIN ENTRY
NP3AEXT    LM    @13,@14,NPA3RSAV-NP3AEXT(@14)  RESTORE REGS 13 AND 14
           BR    @14               RETURN TO CALLER
NPA3RSAV   DC    18F'0'            REGISTER SAVE AREA
*                                                                  0403
*   /*****************************************************************/
*   /*                                                               */
*   /* ANALYZE PARAMETERS FROM OPERATOR                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0403
*NP3OPSP:                                                          0403
*   NP3RTADR=REXIT;                 /* SAVE CALLERS RETURN ADDR      */
NP3OPSP  ST    REXIT,NP3RTADR                                      0403
*   NP3CTAB=ADDR(OPTABLN);          /* GET ADDR OF OPERATOR PARMTAB  */
         LA    @10,OPTABLN                                         0404
         ST    @10,NP3CTAB                                         0404
*   NP3CENT=ADDR(OPSPPGPM);         /* POINT TO PAGE(PARMLIB) ENTRY  */
         LA    @10,OPSPPGPM(,@10)                                  0405
         ST    @10,NP3CENT                                         0405
*   MRGOP='1'B;                     /* TURN MERGE BIT ON             */
*                                                                  0406
         OI    MRGOP(@10),B'10000000'                              0406
*   /*****************************************************************/
*   /*                                                               */
*   /* PICKUP ORIGIN SPE FROM NVT                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0407
*   NP3DSPE=ADDR(NVTSPE);           /* SET BASE ADDRESS FOR SPE      */
         LA    @10,NVTSPE(,RNVT)                                   0407
         ST    @10,NP3DSPE                                         0407
*   SCANREG=NIPSPEA;                /* POINT TO OPERATOR REPLY       */
*                                                                  0408
         L     SCANREG,NIPSPEA(,@10)                               0408
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK OPERATOR REPLY FOR U' OR EOB (DEFAULT REPLY TO USE      */
*   /* IEASYS00 MEMBER OF SYS1.PARMLIB FOR SYSTEM PARAMETERS).       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0409
*   IF OPREPLY1=NP3UQ               /* IS THIS U' OR                 */
*       WOPREPLY1=NP3BLNKQ          /* IS THIS EOB                   */
*     THEN                          /* IT IS U' OR EOB               */
         CLC   OPREPLY1(2,SCANREG),NP3UQ                           0409
         BE    @RT00409                                            0409
         CLC   OPREPLY1(2,SCANREG),NP3BLNKQ                        0409
         BNE   @RF00409                                            0409
@RT00409 DS    0H                                                  0410
*     GO TO NP3RTAD0;               /* RETURN AND DEFINE INITIAL   0410
*                                      PARMAREA BASE                 */
         L     @10,NP3RTADR                                        0410
         BR    @10                                                 0410
*   ELSE                                                           0411
*     ;                             /* NOT U' OR EOB , FALL THROUGH  */
*                                                                  0411
@RF00409 DS    0H                                                  0412
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK OPERATOR REPLY FOR U,L' (DEFAULT REPLY TO USE IEASYS00  */
*   /* MEMBER OF SYS1.PARMLIB FOR SYSTEM PARAMETERS WITH LIST OPTION */
*   /* SPECIFIED). IS THIS U,L'                                Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0412
*   IF OPREPLY2=NP3UCLQ             /*                         Y02752*/
*     THEN                          /* IT IS U,L'                    */
         CLC   OPREPLY2(4,SCANREG),NP3UCLQ                         0412
         BNE   @RF00412                                            0412
*     DO;                                                          0413
*       NVTFLLST='1'B;              /* SET "LIST" FLAG ON, IN NVT    */
         OI    NVTFLLST(RNVT),B'10000000'                          0414
*       GO TO NP3RTAD0;             /* RETURN AND DEFINE INITIAL   0415
*                                      PARMAREA BASE                 */
         L     @10,NP3RTADR                                        0415
         BR    @10                                                 0415
*     END;                                                         0416
*                                                                  0416
*   /*****************************************************************/
*   /*                                                               */
*   /* SETUP POINTERS AND CONTROL SWITCHES FOR ENTRY INTO THE NP3SCAN*/
*   /* SUBROUTINE FOR SCANNING OPERATOR REPLY PARAMETER CHARACTER    */
*   /* STRING.                                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0417
*NP3OPSCN:                                                         0417
*   NP3CONT='0'B;                   /* SET CONTINUE PARAMETER FLAG 0417
*                                      OFF                           */
@RF00412 DS    0H                                                  0417
NP3OPSCN NI    NP3CONT,B'01111111'                                 0417
*   OPSPCONT=OPSPCONT&&OPSPCONT;    /* ZERO CONT PARM                */
         L     @10,NP3CTAB                                         0418
         XC    OPSPCONT(16,@10),OPSPCONT(@10)                      0418
*   NP3INID='0000'X;                /* SET INPUT ID TO ZERO          */
         MVC   NP3INID(2),@CB02317                                 0419
*NP3SREPL:                                                         0420
*   NP3NCHAR=NIPSPEA;               /* POINT TO FIRST CHARACTER OF 0420
*                                      CURRENT SYMBOL IN PARAMETER 0420
*                                      CHARACTER STRING              */
NP3SREPL L     @10,NP3DSPE                                         0420
         MVC   NP3NCHAR(4),NIPSPEA(@10)                            0420
*NP3SCALL:                                                         0421
*   CALL NP3SCAN;                   /* BRANCH TO SCAN SUBROUTINE FOR
*                                      PARAMETER VALIDATION          */
*                                                                  0421
NP3SCALL BAL   @14,NP3SCAN                                         0421
*   /*****************************************************************/
*   /*                                                               */
*   /* THE FOLLOWING GENERATED STATEMENTS ARE A BRANCH TABLE RETURN +*/
*   /* 0 FROM NP3SCAN INDICATES A VALID PARAMETER RETURN + 4 FROM    */
*   /* NP3SCAN INDICATES AN INVALID PARAMETER RETURN + 8 FROM NP3SCAN*/
*   /* INDICATES A CONTINUATION OF OF SUBPARAMETERS OR END OF ALL    */
*   /* OPERATOR REPLY PARAMETERS.                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0422
*   GENERATE FLOWS(NP3OPIA,NP3OPRES,NP3OPCNT);                     0422
*                                                                  0422
         B     NP3OPIA             GO CHECK FOR OPERATOR OPI
         B     NP3OPRES            GO TO INVALID PARAMETER HANDLING
         B     NP3OPCNT            GO CHECK FOR CONTINUATION
*   /*****************************************************************/
*   /*                                                               */
*   /* IEAVNPA3 SUBROUTINE ENTRY POINT                         Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0423
*NPOPCNT:                                                          0423
*   NPRMRTN1=REXIT;                 /*                         Y02752
*                                                              Y02752*/
*                                                                  0423
NPOPCNT  ST    REXIT,NPRMRTN1                                      0423
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECKS FOR NON-ZERO CHAIN POINTER IN CURRENT SPE TO NEXT SPE  */
*   /* FOR CONTINUATION OF SYSTEM PARAMETERS.                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0424
*NP3OPCNT:                                                         0424
*   IF NIPSPEQ=0                    /* IS SPE CHAIN POINTER ZERO   0424
*                                      VALUE                         */
*     THEN                          /* YES- NO VALID CONTINUATION    */
NP3OPCNT L     @10,NP3DSPE                                         0424
         L     @10,NIPSPEQ(,@10)                                   0424
         LTR   @10,@10                                             0424
         BZ    @RT00424                                            0424
*     GO TO NP3OPIA;                /* BRANCH TO INVALID PREVIOUS  0425
*                                      PARAMETER CHECKING            */
*   ELSE                            /* SPE CHAIN POINTER IS NON-ZERO */
*     DO;                                                          0426
*       NP3TSPE=NIPSPEQ;            /* SAVE SPE CHAIN POINTER        */
         ST    @10,NP3TSPE                                         0427
*       NP3DSPE=NP3TSPE;            /* SET BASE ADDRESS FOR NEW SPE  */
         ST    @10,NP3DSPE                                         0428
*       GO TO NP3SREPL;             /* GO TO SCAN CONTINUATION FOR 0429
*                                      MORE PARAMETER ANALYSIS       */
         B     NP3SREPL                                            0429
*     END;                                                         0430
*NP3OPRTY:                                                         0431
*   NP3RTADR=REXIT;                 /* SAVE CALLERS RETURN ADDR      */
*                                                                  0431
NP3OPRTY ST    REXIT,NP3RTADR                                      0431
*   /*****************************************************************/
*   /*                                                               */
*   /* SET CURRENT PARMTAB POINTER TO ADDRESS OF OPERATOR'S PARMTAB  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0432
*   NP3CTAB=ADDR(OPTABLN);          /* POINT TO OPERATOR PARMTAB     */
*                                                                  0432
         LA    @10,OPTABLN                                         0432
         ST    @10,NP3CTAB                                         0432
*   /*****************************************************************/
*   /*                                                               */
*   /* IF PROMPT MODE, RETURN TO PROMPT CALL SEQUENCE          Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0433
*   IF NVTSYSP='1'B                 /*                         Y02752*/
*     THEN                          /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           0433
         BNO   @RF00433                                            0433
*     DO;                           /*                         Y02752*/
*       RETCODE=4;                  /* EXTRANEOUS INFO FOUND   Y02752*/
         MVC   RETCODE(4),@CF00371                                 0435
*       GOTO NPRMRTN1;              /* RETURN TO IEAVNPA3 CALL     0436
*                                      SEQUENCE                Y02752*/
         L     @10,NPRMRTN1                                        0436
         BR    @10                                                 0436
*     END;                          /*                         Y02752
*                                                              Y02752*/
*                                                                  0437
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATE THE INTERFACE BRANCH MACRO CALL TO NIPWTOR FOR       */
*   /* RESPECIFY PARAMETERS MESSAGE TO OPERATOR                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0438
*   GENERATE REFS(NVTWTOR) DEFS(NP3OPRES);                         0438
@RF00433 DS    0H                                                  0438
NP3OPRES IEAPMNIP   TYPE=WTOR,PARAM=PLIST01  CALL WTOR SERVICE ROUTINE
*   RESPECIFY                                                      0439
*     RPARM RESTRICTED;             /* PARAMETER INTERFACE REG(1)    */
*   RESPECIFY                                                      0440
*     OPREPLY1 BASED(RPARM);        /* MAP TO OPERATOR REPLY         */
*                                                                  0440
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK FOR OPERATOR REPLY OF EOB (CANCEL), WHICH IMPLIES       */
*   /* OPERATOR DID NOT SPECIFY ANY SYSTEM PARAMETERS                */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0441
*   IF OPREPLY1=NP3BLNKQ            /* DID OPERATOR CANCEL           */
*     THEN                          /* YES,OPERATOR CANCELLED        */
         CLC   OPREPLY1(2,RPARM),NP3BLNKQ                          0441
         BE    @RT00441                                            0441
*     GO TO NP3OPIA;                /* GO TO OPERATOR SPECIFIED "OPI"
*                                      CHECK HANDLER                 */
*   ELSE                            /* NO,OPERATOR HAS RESPECIFIED 0443
*                                      SYSTEM PARAMETERS             */
*     DO;                                                          0443
*       NP3OPSV=RPARM;              /* SAVE ADDRESS OF OPERATOR    0444
*                                      RESPECIFIED PARAMETERS        */
         ST    RPARM,NP3OPSV                                       0444
*     END;                                                         0445
*   RESPECIFY                                                      0446
*     RPARM UNRESTRICTED;           /* PARAMETER INTERFACE REG1      */
*   RESPECIFY                                                      0447
*     OPREPLY1 BASED(SCANREG);      /* RESET TO ORIGINAL MAPPING BASE
*                                      ADDRESS                 Y02752*/
*                                                                  0447
*   /*****************************************************************/
*   /*                                                               */
*   /* GET CORE FOR SPE - ISSUE 'CONTINUE SYSTEM PARAMETERS' MESSAGE */
*   /* IF THE OPERATOR REQUESTED CONTINUATION                  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0448
*   CALL NPGETMN;                   /*                         Y02752*/
         BAL   @14,NPGETMN                                         0448
*   GOTO NP3OPSCN;                  /* GO TO PARAMETER SCAN    Y02752*/
*                                                                  0449
         B     NP3OPSCN                                            0449
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS CHECKS TO SEE IF THE OPERATOR SPECIFIED "OPI" WITH THE   */
*   /* SYSTEM PARAMETERS HE SPECIFIED. IF YES,A MESSAGE IS ISSUED TO */
*   /* HIM, SAYING "OPI" IGNORED                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0450
*NP3OPIA:                                                          0450
*   IF OPSPOPI='00000000000000000000000000000000'X/* HAS OPER      0450
*                                      SPECIFIED "OPI"               */
*     THEN                          /* NO,HE HAS NOT SPECIFIED "OPI" */
NP3OPIA  L     @10,NP3CTAB                                         0450
         CLC   OPSPOPI(16,@10),@CB02424                            0450
         BNE   @RF00450                                            0450
*     DO;                                                          0451
*                                                                  0451
*       /*************************************************************/
*       /*                                                           */
*       /* IF PROMPT MODE, RETURN TO NIP PROMPT CALL SEQUENCE        */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0452
*       IF NVTSYSP='1'B             /*                         Y02752*/
*         THEN                                                     0452
         TM    NVTSYSP(RNVT),B'01000000'                           0452
         BNO   @RF00452                                            0452
*         GO TO NPRMRTN1;           /*                         Y02752*/
         L     @10,NPRMRTN1                                        0453
         BR    @10                                                 0453
*       GO TO NP3RTAD0;             /* RETURN TO CALLER        Y02752*/
@RF00452 L     @10,NP3RTADR                                        0454
         BR    @10                                                 0454
*     END;                          /*                         Y02752*/
*   ELSE                            /* YES, HE HAS SPECIFIED "OPI"   */
*     DO;                                                          0456
@RF00450 DS    0H                                                  0457
*       OPSPOPI=OPSPOPI&&OPSPOPI;   /* RESET OPI ENTRY IN OPERTAB TO
*                                      ZERO                          */
         L     @10,NP3CTAB                                         0457
         XC    OPSPOPI(16,@10),OPSPOPI(@10)                        0457
*       OPREPLY5=NP3OPIMG;          /* MOVE "OPI" KEYWORD INTO ERROR
*                                      MESSAGE TEXT                  */
         MVC   OPREPLY5(3),NP3OPIMG                                0458
*     END;                                                         0459
*                                                                  0459
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS GENERATED INTERFACE BRANCH MACRO CALLS THE NIPWTO SERVICE*/
*   /* ROUTINE IN IEAVNIPM TO WRITE OUT THE OPI IGNORE MESSAGE TEXT  */
*   /* TO THE OPERATOR                                               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0460
*   GENERATE REFS(NVTWTO);                                         0460
*                                                                  0460
         IEAPMNIP   TYPE=WTO,PARAM=MESG03    CALL WTO SERVICE ROUTINE
*   /*****************************************************************/
*   /*                                                               */
*   /* RETURN TO IEAVNPA3 CALL SEQUENCE IF IN NIP PROMPT MODE  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0461
*   IF NVTSYSP='1'B THEN            /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           0461
         BNO   @RF00461                                            0461
*     GO TO NPRMRTN1;               /*                         Y02752
*                                                              Y02752*/
         L     @10,NPRMRTN1                                        0462
         BR    @10                                                 0462
*   GO TO NP3RTAD0;                 /* RETURN TO CALLER              */
@RF00461 L     @10,NP3RTADR                                        0463
         BR    @10                                                 0463
*                                                                  0464
*   /*****************************************************************/
*   /*                                                               */
*   /* DEFINE INITIAL PARMAREA BASE                                  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0464
*NP3PBASE:                                                         0464
*   NP3RTADR=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
*                                                                  0464
NP3PBASE ST    REXIT,NP3RTADR                                      0464
*   /*****************************************************************/
*   /*                                                               */
*   /* CALL GETMAIN SUBROUTINE FOR INITIAL PAREA                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0465
*   CALL NP3PAGM;                   /* GO TO GETMAIN SUBROUTINE      */
*                                                                  0465
         BAL   @14,NP3PAGM                                         0465
*   /*****************************************************************/
*   /*                                                               */
*   /* SAVE ADDRESS OF INITIAL PAREA IN NVT AND SET BASE             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0466
*   NVTPAREA=NP3GBFR;               /* SET PAREA ADDRESS IN NVT      */
         L     @10,NP3GBFR                                         0466
         ST    @10,NVTPAREA(,RNVT)                                 0466
*   NP3PBFR=NP3GBFR;                /* SET BASE ADDRESS FOR HEADER   */
*                                                                  0467
         ST    @10,NP3PBFR                                         0467
*   /*****************************************************************/
*   /*                                                               */
*   /* CALCULATE ADDRESS SIZE REQUIREMENTS FOR IOB,DCB,DEB,          */
*   /* PARMTAB,I/O DATA AND PARMLTB READ AREA FOR PAREA              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0468
*   NIPPABYT=LENGTH(NIPPAREA)+NP3PBFR;/* SET NEXT AVAILABLE ADDRESS  */
         LA    @09,L'NIPPAREA                                      @L01
         ALR   @09,@10                                             0468
         ST    @09,NIPPABYT-NIPPAHDR(,@10)                         @L01
*   RESPECIFY                                                      0469
*     NP3BKLN RESTRICTED;           /* TRACKS LENGTH OF AREA   Y02752*/
*   RESPECIFY                                                      0470
*     NP3BKADR RESTRICTED;          /* TRACKS POSITION OF AREA Y02752*/
*                                                                  0470
*   /*****************************************************************/
*   /*                                                               */
*   /* CLEARS THE INITIAL PAREA (EXCEPT HEADER) TO ZERO'S CALCULATE  */
*   /* AREA LENGTH TO CLEAR                                          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0471
*   NP3BKLN=2048-(ADDR(NIPPA2BF)-ADDR(NIPPAREA));/*            Y02752*/
         LA    NP3BKLN,2048-(NIPPA2BF-NIPPAREA)                    @L01
*   NP3BKADR=ADDR(NIPPA2BF);        /* SET AREA POSITION POINTER TO
*                                      ADDRESS OF BYTE FOLLOWING   0472
*                                      HEADER IN INITIAL PAREA Y02752*/
*                                                                  0472
         LA    NP3BKADR,NIPPA2BF-NIPPAREA(,@10)                    @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* CLEAR INITIAL PAREA TO ZERO'S                           Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0473
*   CALL NP3CLRIT;                  /*                         Y02752*/
         BAL   @14,NP3CLRIT                                        0473
*   RESPECIFY                                                      0474
*     NP3BKLN UNRESTRICTED;         /* RELEASE LENGTH REG.     Y02752*/
*   RESPECIFY                                                      0475
*     NP3BKADR UNRESTRICTED;        /* RELEASE POSITION REG.   Y02752*/
*   NIPPABDH=BLDLHEAD;              /* MOVE BLDL HEADER TO PARMAREA  */
*                                                                  0476
         L     @10,NVTPAREA(,RNVT)                                 0476
         MVC   NIPPABDH-NIPPAREA(4,@10),BLDLHEAD                   @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* FILL IN IOB IN PARMAREA                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0477
*   IOBSTPTR=ADDR(NIPPAIOB);        /* SET IOB DSECT PTR = PARMAREA
*                                      IOB                           */
         LA    @09,NIPPAIOB-NIPPAREA(,@10)                         @L01
         ST    @09,IOBSTPTR                                        0477
*   ECBPTR=ADDR(NIPPAECB);          /* SET ECB BASE TO POINT TO    0478
*                                      PARMAREA ECB                  */
         LA    @15,NIPPAECB-NIPPAREA(,@10)                         @L01
         ST    @15,ECBPTR                                          0478
*   IOBFLAG1='42'X;                 /* SET IOB FOR COMMAND CHAINING
*                                      WITH NO RELATED REQUESTS      */
         MVI   IOBFLAG1(@09),X'42'                                 0479
*   IOBECBPT=ECBPTR;                /* SET ADDR OF ECB IN IOB        */
         ST    @15,IOBECBPT(,@09)                                  0480
*   IOBDCBPT=ADDR(DCBSTART);        /* SET ADDR OF DCB IN IOB        */
         LA    @15,NIPPADCB-NIPPAREA(,@10)                         @L01
         SH    @15,@CH02133                                        0481
         ST    @15,IOBDCBPT(,@09)                                  0481
*   IOBSTART=ADDR(NIPPAIOD);        /* SET ADDR OF CCW CHAIN IN IOB  */
*                                                                  0482
         LA    @15,NIPPAIOD-NIPPAREA(,@10)                         @L01
         ST    @15,IOBSTART(,@09)                                  0482
*   /*****************************************************************/
*   /*                                                               */
*   /* FILL IN DCB IN PARMAREA                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0483
*   DCBDEBAD=ADDR(NIPPADEB);        /* SET ADDR OF DEB IN DCB        */
*                                                                  0483
         LA    @09,NIPPADEB-NIPPAREA(,@10)                         @L01
         ST    @09,DCBDEBAD(,@10)                                  0483
*   /*****************************************************************/
*   /*                                                               */
*   /* FILL IN CCW ADDRESSES                                         */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0484
*   SRCHAD=ADDR(NIPPASID);                                         0484
         LA    @09,NIPPASID-NIPPAREA(,@10)                         @L01
         STCM  @09,7,SRCHAD                                        0484
*   TICAD=ADDR(NIPPATXT);                                          0485
         LA    @15,NIPPATXT-NIPPAREA(,@10)                         @L01
         STCM  @15,7,TICAD                                         0485
*   RDDATAD=ADDR(NIPPARCD);                                        0486
         LA    @15,NIPPARCD-NIPPAREA(,@10)                         @L01
         STCM  @15,7,RDDATAD                                       0486
*   RDCNTAD=ADDR(NIPPASID);                                        0487
         STCM  @09,7,RDCNTAD                                       0487
*   NIPPATXT=NP3CCW;                /* MOVE TEXT READ CCW'S TO     0488
*                                      PARMAREA                      */
         MVC   NIPPATXT-NIPPAREA(32,@10),NP3CCW                    @L01
*   GO TO NP3RTAD0;                 /* RETURN TO CALLER              */
         L     @10,NP3RTADR                                        0489
         BR    @10                                                 0489
*                                                                  0490
*   /*****************************************************************/
*   /*                                                               */
*   /* OPEN SYS1.PARMLIB                                             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0490
*NP3PMLIB:                                                         0490
*   NP3RTADR=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
NP3PMLIB ST    REXIT,NP3RTADR                                      0490
*   PRMLIB=PARMLIB;                 /* SET SYS1.PARMLIB NAME IN    0491
*                                      LOCATE                        */
*                                                                  0491
         MVC   PRMLIB(12),PARMLIB                                  0491
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATES LOCATE MACRO FOR SYS1.PARMLIB                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0492
*   GENERATE;                                                      0492
*                                                                  0492
         LOCATE LOCLIB              ISSUE LOCATE FOR SYS1.PARMLIB
*   /*****************************************************************/
*   /*                                                               */
*   /* EXAMINE RETURN CODE FROM LOCATE. IF ANYTHING OTHER THAN ZERO, */
*   /* SYS1.PARMLIB IS ASSUMED TO BE ON SYSRES.                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0493
*   IF LOCREG^=0                    /* IS RETURN CODE OTHER THAN ZERO*/
*     THEN                          /* YES - ASSUME SYSRES           */
         LTR   LOCREG,LOCREG                                       0493
         BZ    @RF00493                                            0493
*     DO;                                                          0494
*       NVTSPUCB=CVTSYSAD;          /* GET ADDR OF SYSRES UCB        */
         MVC   NVTSPUCB(2,RNVT),CVTSYSAD+2(CVTPTR)                 0495
*       GO TO NP3PLOPN;             /* GO TRY TO OPEN DATASET        */
         B     NP3PLOPN                                            0496
*     END;                                                         0497
*   ELSE                                                           0498
*     DO;                                                          0498
@RF00493 DS    0H                                                  0499
*       NMNTDS=PARMLIB;             /* SET SYS1.PARMLIB NAME IN MOUNT
*                                      PARAMETER LIST                */
         L     @10,NP3LST03                                        0499
         MVC   NMNTDS(12,@10),PARMLIB                              0499
*       NMNTVS=NP3VOLSR;            /* SET VOLUME SERIAL IN MOUNT  0500
*                                      PARAMETER LIST                */
         MVC   NMNTVS(6,@10),NP3VOLSR                              0500
*       NMNTDT=NP3DVTYP;            /* SET DEVICE TYPE IN MOUNT    0501
*                                      PARAMETER LIST                */
         MVC   NMNTDT(2,@10),NP3DVTYP                              0501
*     END;                                                         0502
*                                                                  0502
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO BRANCH INTERFACE TO NIPMOUNT (IEAVNP02)       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0503
*   GENERATE REFS(NVTMOUNT) SETS(RPARM,REXIT,RENTRY);              0503
          IEAPMNIP TYPE=MOUNT,PARAM=PLIST03     ISSUE NIPMOUNT CALL
*   NVTSPUCB=RPARM;                 /* SAVE PARMLIB UCB ADDR IN NVT  */
*                                                                  0504
         STH   RPARM,NVTSPUCB(,RNVT)                               0504
*   /*****************************************************************/
*   /*                                                               */
*   /* SET UP PARAMETERS FOR OPEN REQUEST (UNCONDITIONAL)            */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0505
*   RESPECIFY                                                      0505
*     NIPOPNPL BASED(NP3LST05);                                    0505
*NP3PLOPN:                                                         0506
*   NOPNUCB=NVTSPUCB;               /* SET UP UCB ADDR FOR OPEN LIST */
NP3PLOPN L     @10,NP3LST05                                        0506
         SLR   @09,@09                                             0506
         ICM   @09,3,NVTSPUCB(RNVT)                                0506
         ST    @09,NOPNUCB(,@10)                                   0506
*   NOPNDCB=ADDR(DCBSTART);         /* SET UP DCB ADDR FOR OPEN LIST */
*                                                                  0507
         L     @09,NVTPAREA(,RNVT)                                 0507
         LA    @09,NIPPADCB-NIPPAREA(,@09)                         @L01
         SH    @09,@CH02133                                        0507
         ST    @09,NOPNDCB(,@10)                                   0507
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO BRANCH INTERFACE TO NIPOPEN (UNCONDITIONAL)   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0508
*   GENERATE REFS(NVTOPEN) SETS(RPARM,REXIT,RENTRY,NOPNFL);        0508
          IEAPMNIP TYPE=OPEN,PARAM=PLIST05,OPT=(NB,,,SX)
*   GO TO NP3RTAD0;                 /* RETURN TO CALLER              */
         L     @10,NP3RTADR                                        0509
         BR    @10                                                 0509
*                                                                  0510
*   /*****************************************************************/
*   /*                                                               */
*   /* READ AND ANALYZE PARAMETERS IN SYS1.PARMLIB                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0510
*   RESPECIFY                                                      0510
*     NIPPAREA BASED(NVTPAREA);                                    0510
*   RESPECIFY                                                      0511
*     NIPPAHDR BASED(NVTPAREA);                                    0511
*NP3SYSP:                                                          0512
*   NP3SYPAD=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
*                                                                  0512
NP3SYSP  ST    REXIT,NP3SYPAD                                      0512
*   /*****************************************************************/
*   /*                                                               */
*   /* CALL GETMAIN SUBROUTINE FOR 2ND LEVEL PARMAREA                */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0513
*   CALL NP3PAGM;                   /* GET 2ND PARMAREA              */
         BAL   @14,NP3PAGM                                         0513
*NP3SYRCK:                                                         0514
*   PARMBASE=NIPPAQ;                /* SET BASE FOR SECONDARY      0514
*                                      PARMAREA                      */
NP3SYRCK L     @10,NVTPAREA(,RNVT)                                 0514
         MVC   PARMBASE(4),NIPPAQ-NIPPAHDR(@10)                    @L01
*   NP3CENT=ADDR(OPSPSYSP);         /* SET BASE FOR SYSP ENTRY       */
*                                                                  0515
         L     @10,NP3CTAB                                         0515
         LA    @10,OPSPSYSP(,@10)                                  0515
         ST    @10,NP3CENT                                         0515
*   /*****************************************************************/
*   /*                                                               */
*   /* IF EITHER THE NVT LIST FLAG OR THE SYSP LIST FLAG ARE ON, SET */
*   /* FLAG FOR THE LIST OPTION.                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0516
*   IF NVTFLLST='1'BWNIPPTLST='1'B THEN                            0516
         TM    NVTFLLST(RNVT),B'10000000'                          0516
         BO    @RT00516                                            0516
         TM    NIPPTOPF-NIPPTE(@10),B'01000000'                    @L01
         BNO   @RF00516                                            0516
@RT00516 DS    0H                                                  0517
*     NP3SYLST='1'B;                                               0517
         OI    NP3SYLST,B'00100000'                                0517
*   NP3CTAB=ADDR(PTABLN);           /* CURRENT PARM TABLE POINTER =
*                                      ADDR OF PLIBTAB               */
@RF00516 LA    @10,PTABLN                                          0518
         ST    @10,NP3CTAB                                         0518
*   IF SYSPRTRY^='1'B               /* IS SYSP RETRY SWITCH SET      */
*     THEN                          /* NO -                          */
         TM    SYSPRTRY,B'00000100'                                0519
         BNO   @RT00519                                            0519
*     GO TO NP3SYSDE;               /* GET SYSP DEFAULT              */
*NP3SYNDF:                                                         0521
*   SCANREG=NIPPTADR;               /* SCAN PTR = ADDR OF SYSP INPUT
*                                      FROM OPERATOR                 */
NP3SYNDF L     @10,NP3CENT                                         0521
         L     SCANREG,NIPPTADR-NIPPTE(,@10)                       @L01
*   IF SCANREG=0W                   /* IS THERE ANY SYSP INPUT TO BE
*                                      ANALYZED                      */
*       NP3SCAN4=SPLIST             /* CHECK FOR (,L) VALUE  @YM06755*/
*     THEN                          /* NO - CHECK RETRY SWITCH       */
         LTR   SCANREG,SCANREG                                     0522
         BZ    @RT00522                                            0522
         CLC   NP3SCAN4(4,SCANREG),@CB01889                        0522
         BE    @RT00522                                            0522
*     GO TO NP3SYXIT;               /* RETURN TO CALLER              */
*   SYSPRTRY='0'B;                  /* RESET SYSP RETRY SWITCH TO  0524
*                                      ZERO                          */
         NI    SYSPRTRY,B'11111011'                                0524
*NP3SYRTY:                                                         0525
*   IF NP3SCANR='('                 /* IS CHARACTER A '('            */
*     THEN                          /* YES - MUST BE MORE THAN ONE 0525
*                                      LIST SPECIFIED                */
NP3SYRTY CLI   NP3SCANR(SCANREG),C'('                              0525
         BNE   @RF00525                                            0525
*     DO;                                                          0526
*       MULTSYSP='1'B;              /* SET MULTI SYSP SWITCH ON      */
         OI    MULTSYSP,B'01000000'                                0527
*NP3UPDAT:                                                         0528
*       SCANREG=SCANREG+1;          /* UPDATE SCAN TO NEXT CHARACTER */
NP3UPDAT LA    SCANREG,1(,SCANREG)                                 0528
*       IF NP3SCANR='('             /* IS CHARACTER A '('            */
*         THEN                                                     0529
         CLI   NP3SCANR(SCANREG),C'('                              0529
         BE    @RT00529                                            0529
*         GO TO NP3UPDAT;           /* YES,UPDATE TO NEXT CHAR       */
*       ELSE                                                       0531
*         GO TO NP3ALPHA;           /* NO,CHECK FOR ALPHAMERIC       */
         B     NP3ALPHA                                            0531
*     END;                                                         0532
*   ELSE                                                           0533
*     DO;                                                          0533
*                                                                  0533
@RF00525 DS    0H                                                  0534
*       /*************************************************************/
*       /*                                                           */
*       /* ARE NEXT TWO CHACTERS ALPHMERIC                           */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0534
*NP3ALPHA:                                                         0534
*       IF NP3SCAN2>='AA'&NP3SCAN2<='99' THEN                      0534
NP3ALPHA CLC   NP3SCAN2(2,SCANREG),@CC02448                        0534
         BL    @RF00534                                            0534
         CLC   NP3SCAN2(2,SCANREG),@CC02449                        0534
         BH    @RF00534                                            0534
*         DO;                                                      0535
*           IF NP3SCAN5=CONTCHAR    /* ARE NEXT CHARS                */
*             THEN                  /* CONT'                         */
         CLC   NP3SCAN5(5,SCANREG),CONTCHAR                        0536
         BNE   @RF00536                                            0536
*             DO;                                                  0537
*               IF CONTAD^=0        /* IS CONT PTR                   */
*                 THEN              /* NON-ZERO                      */
         L     @10,NP3CENT                                         0538
         L     @10,CONTAD(,@10)                                    0538
         LTR   @10,@10                                             0538
         BZ    @RF00538                                            0538
*                 DO;               /* GET REST OF SYSP INPUT        */
*                   SCANREG=CONTAD; /* GET CONT ADDRESS              */
         LR    SCANREG,@10                                         0540
*                   GO TO NP3ALPHA;                                0541
         B     NP3ALPHA                                            0541
*                 END;                                             0542
*                                                                  0542
*               /*****************************************************/
*               /*                                                   */
*               /* INVALID - CONT HAS BEEN SPECIFIED WITHOUT A CONT  */
*               /* ADDR                                              */
*               /*                                                   */
*               /*****************************************************/
*                                                                  0543
*               ELSE                                               0543
*                 GO TO NP3SYINV;                                  0543
*             END;                                                 0544
*           ELSE                                                   0545
*             GO TO NP3SETXX;       /* GO SET UP TO READ SPECIFIED 0545
*                                      LIST                          */
*         END;                                                     0546
*       ELSE                                                       0547
*         GO TO NP3SYINV;           /* INVALID - XX OF IEASYSXX IS 0547
*                                      NOT ALPHAMERIC                */
*     END;                                                         0548
*NP3SYSDE:                                                         0549
*   LISTNAM='00';                   /* SET UP DEFAULT LIST NAME      */
NP3SYSDE MVC   LISTNAM(2),@CC01913                                 0549
*   GO TO NP3MOVNM;                                                0550
         B     NP3MOVNM                                            0550
*NP3SETXX:                                                         0551
*   LISTNAM=NP3SCAN2;               /* MOVE TWO CHARS FROM SCAN TO 0551
*                                      IEASYSXX NAME                 */
NP3SETXX MVC   LISTNAM(2),NP3SCAN2(SCANREG)                        0551
*NP3MOVNM:                                                         0552
*   NIPPANAM=IEASYS;                /* MOVE NAME TO PARMAREA         */
NP3MOVNM L     @10,NVTPAREA(,RNVT)                                 0552
         MVC   NIPPANAM-NIPPAREA(8,@10),IEASYS                     @L01
*   SAVESCAN=SCANREG;               /* SAVE SYSP POINTER             */
*                                                                  0553
         ST    SCANREG,SAVESCAN                                    0553
*   /*****************************************************************/
*   /*                                                               */
*   /* READ PDS DATA FOR IEASYSXX                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0554
*   CALL NIPPMPDS;                                                 0554
         BAL   @14,NIPPMPDS                                        0554
*   GENERATE FLOWS(NP3SINID,NP3SYPFL) NOSEQFLOW;                   0555
          B      NP3SINID
          B      NP3SYPFL
*   RESPECIFY                                                      0556
*     NIPPAREA BASED(PARMBASE);                                    0556
*   RESPECIFY                                                      0557
*     NIPPAHDR BASED(PARMBASE);                                    0557
*NP3SINID:                                                         0558
*   NP3INID=LISTNAM;                /* SET INPUT IDENTIFIER TO XX  0558
*                                      CHAR VALUE                    */
NP3SINID MVC   NP3INID(2),LISTNAM                                  0558
*   NP3SYHDR='1'B;                  /* INDICATE FIRST READ FOR MEMBER*/
         OI    NP3SYHDR,B'00000010'                                0559
*   NP3NCHAR=NIPPABYT;              /* POINT TO BEGINNING OF       0560
*                                      PARAMETERS                    */
*                                                                  0560
         L     @10,PARMBASE                                        0560
         MVC   NP3NCHAR(4),NIPPABYT-NIPPAHDR(@10)                  @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* READ IEASYS TEXT RECORD                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0561
*NP3SYTXT:                                                         0561
*   CALL NIPPMTXT;                                                 0561
NP3SYTXT BAL   @14,NIPPMTXT                                        0561
*   GENERATE FLOWS(NP3DETLN,NP3SYPFL) NOSEQFLOW;                   0562
          B     NP3DETLN
          B     NP3SYPFL
*NP3SYPFL:                                                         0563
*   PARM='SYSP';                    /* FILL IN SYSP CONSTANT         */
NP3SYPFL MVC   PARM(4),@CC01908                                    0563
*   NAME=IEASYS;                    /* FILL IN IEASYSXX NAME         */
*                                                                  0564
         MVC   NAME(8),IEASYS                                      0564
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO 'SYSP INPUT TERMINATED IN IEASYSXX' MESSAGE               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0565
*   GENERATE REFS(NVTWTO);                                         0565
          IEAPMNIP TYPE=WTO,PARAM=MESG07 CALL WTO SERVICE ROUTINE
*   SYSPRTRY='1'B;                  /* INDICATE SECOND LEVEL ENTRY TO
*                                      SYSP ROUTINE                  */
         OI    SYSPRTRY,B'00000100'                                0566
*   NP3SYSPD='1'B;                  /* INDICATE NOT TO DO IEASYS00 0567
*                                      AGAIN                         */
         OI    NP3SYSPD,B'00010000'                                0567
*   NP3CTAB=ADDR(OPTABLN);          /* POINT TO OPERATOR TABLE       */
         LA    @10,OPTABLN                                         0568
         ST    @10,NP3CTAB                                         0568
*   NP3CENT=ADDR(OPSPSYSP);         /* SET BASE FOR SYSP ENTRY       */
         LA    @10,OPSPSYSP(,@10)                                  0569
         ST    @10,NP3CENT                                         0569
*   NP3SYLST='0'B;                  /* TURN LIST INDICATOR OFF       */
*   MULTSYSP='0'B;                  /* TURN MULTI SYSP SWITCH OFF    */
         NI    NP3SYLST,B'10011111'                                0571
*   OPLIBENT=OPLIBENT&&OPLIBENT;    /* ZERO SYSP ENTRY IN OPERTAB    */
*                                                                  0572
         XC    OPLIBENT(16,@10),OPLIBENT(@10)                      0572
*   /*****************************************************************/
*   /*                                                               */
*   /* CHANGE PARAMETERS OPTION                                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0573
*   CALL NP3OPRTY;                                                 0573
         BAL   @14,NP3OPRTY                                        0573
*   GO TO NP3SYRCK;                                                0574
         B     NP3SYRCK                                            0574
*   RESPECIFY                                                      0575
*     NP3SCAN5 BASED(COUNTREG);                                    0575
*   RESPECIFY                                                      0576
*     RPARM RESTRICTED;                                            0576
*   RESPECIFY                                                      0577
*     COUNTREG RESTRICTED;                                         0577
*NP3DETLN:                                                         0578
*   COUNTREG=RPARM;                                                0578
*                                                                  0578
NP3DETLN LR    COUNTREG,RPARM                                      0578
*   /*****************************************************************/
*   /*                                                               */
*   /* IF FIRST CHARACTER RETURNED FROM READ TEXT ROUTINE IS BLANK,  */
*   /* THE ENTIRE RECORD READ IS BLANK.                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0579
*   IF NP3SCANR=' ' THEN            /* YES - NO PARAMETERS ARE     0579
*                                      SPECIFIED IN THIS READ FOR  0579
*                                      MEMBER                        */
         CLI   NP3SCANR(COUNTREG),C' '                             0579
         BNE   @RF00579                                            0579
*     DO;                                                          0580
*       IF NP3SYHDR='1'B            /* IS THIS FIRST MEMBER READ     */
*         THEN                      /* YES - NO PARAMS IN THIS MEMBER*/
         TM    NP3SYHDR,B'00000010'                                0581
         BO    @RT00581                                            0581
*         GO TO NP3SYNXT;           /* CHECK FOR ANOTHER LIST        */
*       ELSE                        /* NO - END OF PARAMS IN MEMBER  */
*         GO TO NP3SYTND;           /* INDICATE TEXT END             */
         B     NP3SYTND                                            0583
*     END;                                                         0584
*NP3DETL0:                                                         0585
*   IF NP3SCANR^=' '                /* IS CHAR BLANK                 */
*     THEN                          /* NO - UPDATE TO NEXT CHAR      */
@RF00579 DS    0H                                                  0585
NP3DETL0 CLI   NP3SCANR(COUNTREG),C' '                             0585
         BE    @RF00585                                            0585
*     DO;                                                          0586
*       COUNTREG=COUNTREG+1;                                       0587
         LA    COUNTREG,1(,COUNTREG)                               0587
*       GO TO NP3DETL0;             /* CHECK NEXT CHAR               */
         B     NP3DETL0                                            0588
*     END;                                                         0589
*   ELSE                            /* YES - END OF STRING           */
*     DO;                                                          0590
@RF00585 DS    0H                                                  0591
*       STRGLN=COUNTREG-RPARM;      /* GET STRING LENGTH             */
         LR    @10,COUNTREG                                        0591
         SLR   @10,RPARM                                           0591
         ST    @10,STRGLN                                          0591
*     END;                                                         0592
*   RESPECIFY                                                      0593
*     COUNTREG UNRESTRICTED;                                       0593
*   SAVEONE=RPARM;                  /* SAVE REG 1                    */
         ST    RPARM,SAVEONE                                       0594
*   IF NP3SYLST^='1'B               /* IS LIST FLAG ON               */
*     THEN                                                         0595
         TM    NP3SYLST,B'00100000'                                0595
         BNO   @RT00595                                            0595
*     GO TO NP3SPAVL;               /* NO - FIND IF THERE IS ENOUGH
*                                      SPACE AVAILABLE IN PRESENT  0596
*                                      PARMAREA                      */
*   RESPECIFY                                                      0597
*     NWTOHDR BASED(MSG08PT);                                      0597
*   STRING=MSGBUFF;                                                0598
         MVC   STRING(71),MSGBUFF(RPARM)                           0598
*   NWTOLNG=STRGLN+LENGTH(NWTOHDR);                                0599
         AL    @10,@CF00371                                        0599
         L     @09,MSG08PT                                         0599
         STH   @10,NWTOLNG(,@09)                                   0599
*   IF NP3SYHDR='1'B                /* IS THIS FIRST MEMBER READ     */
*     THEN                                                         0600
         TM    NP3SYHDR,B'00000010'                                0600
         BNO   @RF00600                                            0600
*     DO;                                                          0601
*       XX=LISTNAM;                 /* FILL IN LIST NAME (XX) FOR  0602
*                                      PARAM LIST HEADER             */
*                                                                  0602
         MVC   XX(2),LISTNAM                                       0602
*       /*************************************************************/
*       /*                                                           */
*       /* IEASYSXX PARAMETER LIST HEADER MESSAGE                    */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0603
*       GENERATE REFS(NVTWTO);                                     0603
          IEAPMNIP TYPE=WTO,PARAM=MESG17   CALL WTO SERVICE ROUTINE
*     END;                                                         0604
*                                                                  0604
*   /*****************************************************************/
*   /*                                                               */
*   /* PRINT PARAMETER STRING                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0605
*   GENERATE REFS(NVTWTO);                                         0605
*                                                                  0605
@RF00600 DS    0H                                                  0605
          IEAPMNIP TYPE=WTO,PARAM=MESG08 CALL WTO SERVICE ROUTINE
*   /*****************************************************************/
*   /*                                                               */
*   /* IS THE STRING LENGTH PLUS THE LENGTH OF CONT' GREATER THAN THE*/
*   /* SPACE AVAILABLE IN PARMAREA                                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0606
*NP3SPAVL:                                                         0606
*   NP3SYHDR='0'B;                  /* RESET SWITCH TO ZERO          */
NP3SPAVL NI    NP3SYHDR,B'11111101'                                0606
*   IF NIPPABYT+STRGLN+LENGTH(CONTCHAR)>ADDR(NIPPAHDR)+2048 THEN   0607
         L     @10,PARMBASE                                        0607
         L     @09,NIPPABYT-NIPPAHDR(,@10)                         @L01
         AL    @09,STRGLN                                          0607
         AH    @09,@CH00170                                        0607
         AH    @10,@CH02180                                        0607
         CR    @09,@10                                             0607
         BNH   @RF00607                                            0607
*     DO;                                                          0608
*                                                                  0608
*       /*************************************************************/
*       /*                                                           */
*       /* GET ADDITIONAL PARMAREA                                   */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0609
*       CALL NP3PAGM;                                              0609
         BAL   @14,NP3PAGM                                         0609
*       RESPECIFY                                                  0610
*         NP3SCAN5 BASED(NIPPABYT);                                0610
*                                                                  0610
*       /*************************************************************/
*       /*                                                           */
*       /* DETERMINE IF THE NEXT CHARACTER POINTER REFLECTS ADDITIONS*/
*       /* TO THE PREVIOUS PARMAREA                                  */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0611
*       IF NP3NCHAR^=NIPPABYT       /* DOES NEXT CHAR PTR = NEXT   0611
*                                      AVAILABLE BYTE                */
*         THEN                                                     0611
         L     @10,PARMBASE                                        0611
         L     @09,NIPPABYT-NIPPAHDR(,@10)                         @L01
         C     @09,NP3NCHAR                                        0611
         BE    @RF00611                                            0611
*         DO;                                                      0612
*           NP3SCAN5=CONTCHAR;      /* NO - MOVE CONT' TO PREVIOUS 0613
*                                      PARAMAREA                     */
         MVC   NP3SCAN5(5,@09),CONTCHAR                            0613
*           PARMBASE=NIPPAQ;        /* SET BASE FOR NEW PARMAREA     */
         L     @10,NIPPAQ-NIPPAHDR(,@10)                           @L01
         ST    @10,PARMBASE                                        0614
*         END;                                                     0615
*       ELSE                                                       0616
*         DO;                                                      0616
         B     @RC00611                                            0616
@RF00611 DS    0H                                                  0617
*           PARMBASE=NIPPAQ;        /* YES - POINT TO NEXT PARMAREA  */
         L     @10,PARMBASE                                        0617
         L     @10,NIPPAQ-NIPPAHDR(,@10)                           @L01
         ST    @10,PARMBASE                                        0617
*           NP3NCHAR=NIPPABYT;      /* NEXT CHAR PTR = NEXT AVAIL  0618
*                                      BYTE IN NEW PARMAREA          */
         MVC   NP3NCHAR(4),NIPPABYT-NIPPAHDR(@10)                  @L01
*         END;                                                     0619
*     END;                                                         0620
@RC00611 DS    0H                                                  0621
*   RPARM=SAVEONE;                  /* RESTORE REG 1                 */
*                                                                  0621
@RF00607 L     RPARM,SAVEONE                                       0621
*   /*****************************************************************/
*   /*                                                               */
*   /* MOVE PARM STRING TO NEXT AVAILABLE SPACE IN PARMAREA          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0622
*NP3MOVST:                                                         0622
*   IF STRGLN^=0                    /* HAS ALL OF STRING BEEN MOVED  */
*     THEN                          /* NO - MOVE REST                */
NP3MOVST L     @10,STRGLN                                          0622
         LTR   @10,@10                                             0622
         BZ    @RF00622                                            0622
*     DO;                                                          0623
*       NP3SCANR=MSGBUFF1;          /* MOVE NEXT CHAR TO PARMAREA    */
         L     @09,PARMBASE                                        0624
         L     @15,NIPPABYT-NIPPAHDR(,@09)                         @L01
         MVC   NP3SCANR(1,@15),MSGBUFF1(RPARM)                     0624
*       RPARM=RPARM+1;              /* INCREMENT STRING PTR          */
         LA    @14,1                                               0625
         ALR   RPARM,@14                                           0625
*       NIPPABYT=NIPPABYT+1; /* INCREMENT NEXT AVAILABLE BYTE
*                                      IN PARMAREA PTR               */
         ALR   @15,@14                                             0626
         ST    @15,NIPPABYT-NIPPAHDR(,@09)                         @L01
*       STRGLN=STRGLN-1;            /* DECREMENT STRING LENGTH       */
         BCTR  @10,0                                               0627
         ST    @10,STRGLN                                          0627
*       GO TO NP3MOVST;             /* CHECK STRING LENGTH           */
         B     NP3MOVST                                            0628
*     END;                                                         0629
*   RPARM=RPARM-1;                  /* POINT TO LAST CHAR MOVED      */
@RF00622 BCTR  RPARM,0                                             0630
*   IF MSGBUFF1=','                 /* IS LAST CHAR A ','            */
*     THEN                                                         0631
         CLI   MSGBUFF1(RPARM),C','                                0631
         BE    @RT00631                                            0631
*     GO TO NP3SYTXT;               /* YES - GO READ NEXT RECORD     */
*NP3SYTND:                                                         0633
*   NP3SCANR=QUOTE;                 /* APPEND EBCDIC QUOTE TO END OF
*                                      PARM STRING                   */
NP3SYTND L     @10,PARMBASE                                        0633
         L     @10,NIPPABYT-NIPPAHDR(,@10)                         @L01
         MVC   NP3SCANR(1,@10),QUOTE                               0633
*   RESPECIFY                                                      0634
*     RPARM UNRESTRICTED;                                          0634
*   NP3CTAB=ADDR(PTABLN);           /* SET OPLIBTAB BASE AS PLIBTAB  */
         LA    @10,PTABLN                                          0635
         ST    @10,NP3CTAB                                         0635
*   NP3CENT=ADDR(OPSPOPI);          /* POINT TO OPI ENTRY            */
         LA    @10,OPSPOPI(,@10)                                   0636
         ST    @10,NP3CENT                                         0636
*   OPLIBENT=OPLIBENT&&OPLIBENT;    /* SET OPI ENTRY TO ZERO IN    0637
*                                      PLIBTAB                       */
         XC    OPLIBENT(16,@10),OPLIBENT(@10)                      0637
*   SAVESCAN=SCANREG;               /* SAVE SYSP LIST SCAN POINTER   */
*                                                                  0638
         ST    SCANREG,SAVESCAN                                    0638
*   /*****************************************************************/
*   /*                                                               */
*   /* IDENTIFY PARAMETERS AND ENTER IN PLIBTAB                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0639
*NP3SYSFT:                                                         0639
*   CALL NP3SCAN;                                                  0639
NP3SYSFT BAL   @14,NP3SCAN                                         0639
*   GENERATE FLOWS(NP3SYOPI,NP3SYPFL,NP3SYCNT) NOSEQFLOW;          0640
          B     NP3SYOPI
          B     NP3SYPFL
          B     NP3SYCNT
*NP3SYCNT:                                                         0641
*   NP3NCHAR=NIPPAQ+LENGTH(NIPPAHDR);/* UPDATE NEXT CHAR POINTER TO
*                                      BYTE AFTER NEXT PARMAREA    0641
*                                      HEADER                        */
NP3SYCNT LA    @10,8                                               0641
         L     @09,PARMBASE                                        0641
         AL    @10,NIPPAQ-NIPPAHDR(,@09)                           @L01
         ST    @10,NP3NCHAR                                        0641
*   GO TO NP3SYSFT;                                                0642
         B     NP3SYSFT                                            0642
*   RESPECIFY                                                      0643
*     NP3SCAN5 BASED(NIPPTADR);                                    0643
*NP3SYOPI:                                                         0644
*   NP3CENT=ADDR(OPSPOPI);          /* POINT TO OPI ENTRY            */
NP3SYOPI L     @10,NP3CTAB                                         0644
         LA    @10,OPSPOPI(,@10)                                   0644
         ST    @10,NP3CENT                                         0644
*   IF NIPPTADR=0                   /* IS OPI SPECIFIED              */
*     THEN                                                         0645
         L     @10,NIPPTADR-NIPPTE(,@10)                           @L01
         LTR   @10,@10                                             0645
         BZ    @RT00645                                            0645
*     GO TO NP3SYNXT;               /* NO - CHECK NEXT LIST NAME     */
*   IF NP3SCAN3='YES'               /* IS OPI = YES                  */
*     THEN                                                         0647
         CLC   NP3SCAN3(3,@10),@CC02486                            0647
         BE    @RT00647                                            0647
*     GO TO NP3SYNXT;               /* YES - CHECK NEXT LIST NAME    */
*   IF NP3SCAN2^='NO'               /* IS OPI = NO                   */
*     THEN                          /* NO- WHAT OPI ='S IS INVALID   */
         CLC   NP3SCAN2(2,@10),@CC02487                            0649
         BE    @RF00649                                            0649
*     DO;                                                          0650
*NP3SYOER:                                                         0651
*       SYSNAME=IEASYS;             /* FILL IN MEMBER NAME           */
*                                                                  0651
NP3SYOER MVC   SYSNAME(8),IEASYS                                   0651
*       /*************************************************************/
*       /*                                                           */
*       /* INVALID OPI PARAMETER                                     */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0652
*       GENERATE REFS(NVTWTO);                                     0652
          IEAPMNIP TYPE=WTO,PARAM=MESG09 CALL WTO SERVICE ROUTINE
*       GO TO NP3SYPFL;                                            0653
         B     NP3SYPFL                                            0653
*     END;                                                         0654
*                                                                  0654
*   /*****************************************************************/
*   /*                                                               */
*   /* OPI = NO - SCAN PLIBTAB FOR INPUT ID AND RESTRICT THOSE       */
*   /* ENTRIES                                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0655
*   NP3CENT=ADDR(PTABLN);           /* GET BEGINNING ADDRESS OF    0655
*                                      PLIBTAB                       */
@RF00649 LA    @10,PTABLN                                          0655
         ST    @10,NP3CENT                                         0655
*NP3NXOPI:                                                         0656
*   NP3CENT=NP3CENT+LENGTH(OPLIBENT);/* SKIP DUMMY ENTRY FIRST TIME -
*                                      UPDATE TO NEXT ENTRIES LATER  */
NP3NXOPI LA    @10,16                                              0656
         AL    @10,NP3CENT                                         0656
         ST    @10,NP3CENT                                         0656
*   IF NP3CENT^=ADDR(PTABLN)+LENGTH(OPLIBTAB)/* IS THIS THE END OF 0657
*                                      THE TABLE                     */
*     THEN                          /* NO - CHECK PARAMETER          */
         LA    @09,PTABLN                                          0657
         AH    @09,@CH02860                                        0657
         CR    @10,@09                                             0657
         BE    @RF00657                                            0657
*     DO;                                                          0658
*       IF INSRCID=LISTNAM          /* IF THIS PARM IS SPECIFIED,    */
*         THEN                                                     0659
         CLC   INSRCID(2,@10),LISTNAM                              0659
         BNE   @RF00659                                            0659
*         OPIOPT='1'B;              /* SET OPI OPTION FOR THIS PARM  */
         OI    OPIOPT(@10),B'10000000'                             0660
*       GO TO NP3NXOPI;             /* GO CHECK NEXT PARM            */
         B     NP3NXOPI                                            0661
*     END;                                                         0662
*NP3SYNXT:                                                         0663
*   IF MULTSYSP='0'B                /* IS MULTI SYSP SWITCH SET      */
*     THEN                          /* NO -                          */
@RF00657 DS    0H                                                  0663
NP3SYNXT TM    MULTSYSP,B'01000000'                                0663
         BNZ   @RF00663                                            0663
*     DO;                                                          0664
*                                                                  0664
*       /*************************************************************/
*       /*                                                           */
*       /* IS SYSP DEFAULT SWITCH SET                                */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0665
*       IF NP3SYSPD='1'B THEN       /* YES - IEASYS00 DONE           */
         TM    NP3SYSPD,B'00010000'                                0665
         BO    @RT00665                                            0665
*         GO TO NP3SYXIT;           /* RETURN TO CALLER              */
*       ELSE                        /* NO -                          */
*         DO;                                                      0667
*           NP3SYSPD='1'B;          /* INDICATE IEASYS00 DONE        */
         OI    NP3SYSPD,B'00010000'                                0668
*           NP3CTAB=ADDR(OPTABLN);  /* POINT TO OPER TAB             */
         LA    @10,OPTABLN                                         0669
         ST    @10,NP3CTAB                                         0669
*           NP3CENT=ADDR(OPSPSYSP); /* PT TO OPER SYSP               */
         LA    @10,OPSPSYSP(,@10)                                  0670
         ST    @10,NP3CENT                                         0670
*           NP3CTAB=ADDR(PTABLN);   /* POINT BACK TO PTAB            */
         LA    @10,PTABLN                                          0671
         ST    @10,NP3CTAB                                         0671
*           GO TO NP3SYNDF;         /* GET REST OF SYSP              */
         B     NP3SYNDF                                            0672
*         END;                                                     0673
*     END;                                                         0674
*   SCANREG=SAVESCAN;               /* RESTORE SCAN LIST POINTER     */
@RF00663 L     SCANREG,SAVESCAN                                    0675
*   SCANREG=SCANREG+2;              /* POINT TO NEXT LIST NAME     0676
*                                      PARAMETER                     */
         LA    SCANREG,2(,SCANREG)                                 0676
*   RESPECIFY                                                      0677
*     NP3SCAN5 BASED(SCANREG);                                     0677
*NP3SYSCN:                                                         0678
*   IF NP3SCANR='FF'X               /* IS THIS A NULL CHAR           */
*     THEN                                                         0678
NP3SYSCN CLI   NP3SCANR(SCANREG),X'FF'                             0678
         BNE   @RF00678                                            0678
*     DO;                                                          0679
*       SCANREG=SCANREG+1;          /* UPDATE SCAN PTR               */
         LA    SCANREG,1(,SCANREG)                                 0680
*       GO TO NP3SYSCN;             /* CHECK NEXT CHAR               */
         B     NP3SYSCN                                            0681
*     END;                                                         0682
*   IF NP3SCANR=','                 /* IS CHAR A ','                 */
*     THEN                          /* YES - LOOK AT NEXT CHAR       */
@RF00678 CLI   NP3SCANR(SCANREG),C','                              0683
         BNE   @RF00683                                            0683
*     DO;                                                          0684
*       SCANREG=SCANREG+1;          /* UPDATE SCAN POINTER           */
         LA    SCANREG,1(,SCANREG)                                 0685
*       GO TO NP3ALPHA;             /* CHECK FOR ALPHAMERIC          */
         B     NP3ALPHA                                            0686
*     END;                                                         0687
*   IF NP3SCANR=')'                 /* IS CHAR A ')'                 */
*     THEN                                                         0688
@RF00683 CLI   NP3SCANR(SCANREG),C')'                              0688
         BE    @RT00688                                            0688
*     GO TO NP3SYXIT;               /* END OF LIST NAMES RETURN TO 0689
*                                      CALLER                        */
*NP3SYINV:                                                         0690
*   SYSPNAME=SYSPCHAR;                                             0690
*                                                                  0690
NP3SYINV MVC   SYSPNAME(4),SYSPCHAR                                0690
*   /*****************************************************************/
*   /*                                                               */
*   /* MESSAGE - INVALID SYSP PARM - RESPECIFY OR CANCEL             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0691
*   GENERATE REFS(NVTWTOR);                                        0691
          IEAPMNIP TYPE=WTOR,PARAM=PLIST10 CALL WTOR SERVICE ROUTINE
*   SCANREG=ADDR(RPLYBUF);          /* SET SCAN LIST POINTER TO    0692
*                                      OPERATOR REPLY                */
         LA    SCANREG,RPLYBUF                                     0692
*   IF NP3SCAN2=NP3BLNKQ            /* DID OPERATOR REPLY CANCEL   0693
*                                      (EOB)                         */
*     THEN                                                         0693
         CLC   NP3SCAN2(2,SCANREG),NP3BLNKQ                        0693
         BE    @RT00693                                            0693
*     GO TO NP3SYXIT;               /* YES - RETURN TO CALLER        */
*   IF NP3SCAN5^='SYSP='            /* IS PARM SYSP=                 */
*     THEN                                                         0695
         CLC   NP3SCAN5(5,SCANREG),@CC02498                        0695
         BNE   @RT00695                                            0695
*     GO TO NP3SYINV;               /* NO - INVALID PARM MESSAGE     */
*   SCANREG=SCANREG+LENGTH('SYSP=');/* POINT TO START OF           0697
*                                      SUBPARAMETERS                 */
         LA    SCANREG,5(,SCANREG)                                 0697
*   NP3CTAB=ADDR(OPTABLN);          /* SET BASE FOR SYSP ENTRY IN  0698
*                                      OPERTAB                       */
         LA    @10,OPTABLN                                         0698
         ST    @10,NP3CTAB                                         0698
*   NP3CENT=ADDR(OPSPSYSP);                                        0699
         LA    @10,OPSPSYSP(,@10)                                  0699
         ST    @10,NP3CENT                                         0699
*   CONTAD=CONTAD&&CONTAD;          /* RESET CONT PTR FOR SYSP IN  0700
*                                      OPERTAB TO ZERO               */
         L     @09,CONTAD(,@10)                                    0700
         LR    @15,@09                                             0700
         XR    @15,@09                                             0700
         ST    @15,CONTAD(,@10)                                    0700
*   MULTSYSP='0'B;                  /* TURN MULTI SYSP SWITCH OFF    */
         NI    MULTSYSP,B'10111111'                                0701
*   GO TO NP3SYRTY;                 /* GO ANALYZE NEW PARMS          */
         B     NP3SYRTY                                            0702
*NP3SYXIT:                                                         0703
*   GO TO NP3SYPA0;                 /* RETURN TO CALLER              */
NP3SYXIT L     @10,NP3SYPAD                                        0703
         BR    @10                                                 0703
*                                                                  0704
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SUBROUTINE MERGES THE OPERATOR SPECIFIED SYSTEM          */
*   /* PARAMETERS WITH THOSE SYSTEM PARAMETERS SPECIFIED THROUGH THE */
*   /* IEASYSXX MEMBERS OF SYS1.PARMLIB. SPECIFICALLY, THE OPERATORS */
*   /* PARMTAB IS MERGED INTO THE PARMLIB PARMTAB                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0704
*   RESPECIFY                                                      0704
*     OPERREG RESTRICTED;           /* POINTS TO OPERATOR PARMTAB    */
*   RESPECIFY                                                      0705
*     PARMREG RESTRICTED;           /* POINTS TO PARMLIB PARMTAB     */
*   RESPECIFY                                                      0706
*     INDEXREG RESTRICTED;          /* CONTAINS CELL INCREMENT FOR 0706
*                                      PARMTAB'S                     */
*   RESPECIFY                                                      0707
*     COUNTREG RESTRICTED;          /* TRACKS COUNT CYCLE FOR MERGE
*                                      OPERATION                     */
*NP3PLMRG:                                                         0708
*   NP3RTADR=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
NP3PLMRG ST    REXIT,NP3RTADR                                      0708
*   OPERREG=ADDR(OPTABLN);          /* SET MAPPING BASE ADDRESS FOR
*                                      OPERATOR PARMTAB              */
         LA    OPERREG,OPTABLN                                     0709
*   PARMREG=ADDR(PTABLN);           /* SET MAPPING BASE ADDRESS FOR
*                                      PARMLIB PARMTAB               */
         LA    PARMREG,PTABLN                                      0710
*   NP3CTAB=PARMREG;                /* MAP PARMTAB TO PARMLIB ADDRESS*/
*                                                                  0711
         ST    PARMREG,NP3CTAB                                     0711
*   /*****************************************************************/
*   /*                                                               */
*   /* GET NUMBER OF ENTRIES IN PARAMETER ADDRESS TABLE              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0712
*   COUNTREG=LENGTH(PARMTAB)/LENGTH(PTABSTRT);                     0712
         LA    COUNTREG,L'PARMTAB/L'PTABSTRT                       @L01
*   INDEXREG=0;                     /* SET INDEX CONTROL ELEMENT TO
*                                      ZERO ORIGIN                   */
*                                                                  0713
         SLR   INDEXREG,INDEXREG                                   0713
*   /*****************************************************************/
*   /*                                                               */
*   /* BEGIN MERGE SEQUENCE FOR OPERATOR/PARMLIB PARMTAB'S OPERATORS */
*   /* PARMTAB IS MERGED INTO THE PARMLIB PARMTAB CHECK TO SEE IF ALL*/
*   /* PARMTAB ENTRIES HAVE BEEN MERGED                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0714
*NP3MRGST:                                                         0714
*   IF COUNTREG^=0                  /* IS ENTRY COUNT GREATER THEN 0 */
*     THEN                          /* YES, MERGE SEQUENCE NOT DONE  */
NP3MRGST LTR   COUNTREG,COUNTREG                                   0714
         BZ    @RF00714                                            0714
*     DO;                                                          0715
*       NP3CENT=PARMREG;            /* POINT TO PLIBTAB              */
*                                                                  0716
         ST    PARMREG,NP3CENT                                     0716
*       /*************************************************************/
*       /*                                                           */
*       /* HAS THIS PARAMETER BEEN CANCELED                          */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0717
*       IF CANOPT='1'B THEN         /* YES -                         */
         L     @10,NP3CENT                                         0717
         TM    CANOPT(@10),B'00100000'                             0717
         BNO   @RF00717                                            0717
*         OPLIBENT=OPLIBENT&&OPLIBENT;/* ZERO PLIBTAB ENTRY          */
*                                                                  0718
         XC    OPLIBENT(16,@10),OPLIBENT(@10)                      0718
*       /*************************************************************/
*       /*                                                           */
*       /* CHECK TO SEE IF OPERATOR PARMTAB ENTRY IS EMPTY           */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0719
*       IF OPERVAL^=0               /* ENTRY GREATER THEN ZERO       */
*         THEN                      /* YES, THE OPERATOR HAS       0719
*                                      SPECIFIED PARAMETERS FOR THIS
*                                      CURRENT PARMTAB ENTRY         */
@RF00717 ICM   @10,15,OPERVAL(OPERREG)                             0719
         BZ    @RF00719                                            0719
*         DO;                                                      0720
*           NP3CENT=OPERREG;        /* POINT TO OPERTAB ENTRY        */
         ST    OPERREG,NP3CENT                                     0721
*           RESPECIFY                                              0722
*             NP3SCAN5 BASED(NIPPTADR);                            0722
*           IF NP3SCAN4='(,L)'      /* IS DEFAULT WITH LIST OPTION 0723
*                                      SPECIFIED(,L)                 */
*             THEN                                                 0723
         L     @10,NP3CENT                                         0723
         L     @10,NIPPTADR-NIPPTE(,@10)                           @L01
         CLC   NP3SCAN4(4,@10),@CC02504                            0723
         BNE   @RF00723                                            0723
*             DO;                   /* YES - SET LIST OPTION         */
*               NP3CENT=PARMREG;    /* POINT TO PARMTB               */
         ST    PARMREG,NP3CENT                                     0725
*               NIPPTLST='1'B;      /* SET LIST FLAG                 */
         L     @10,NP3CENT                                         0726
         OI    NIPPTOPF-NIPPTE(@10),B'01000000'                    @L01
*               GO TO NP3NXFLD;     /* BRANCH TO SET UP FOR NEXT   0727
*                                      ENTRY MERG                    */
         B     NP3NXFLD                                            0727
*             END;                                                 0728
*           ELSE                                                   0729
*             DO;                                                  0729
@RF00723 DS    0H                                                  0730
*               NP3CENT=PARMREG;    /* POINT TO PARMTB               */
         ST    PARMREG,NP3CENT                                     0730
*               IF NIPPTOPI='1'B    /* IS THIS A RESTRICTED PARM     */
*                 THEN                                             0731
         L     @10,NP3CENT                                         0731
         TM    NIPPTOPF-NIPPTE(@10),B'10000000'                    @L01
         BO    @RT00731                                            0731
*                 GO TO NP3IGNOP;   /* YES - GIVE PARM IGNORED MSG   */
*               NP3CENT=OPERREG;    /* POINT TO OPERTB               */
*                                                                  0733
         ST    OPERREG,NP3CENT                                     0733
*               /*****************************************************/
*               /*                                                   */
*               /* HAS THIS PARAMETER BEEN CANCELED                  */
*               /*                                                   */
*               /*****************************************************/
*                                                                  0734
*               IF CANOPT='1'B THEN /* YES - OPERATOR HAS CANCELLED
*                                      THIS PARM                     */
         L     @10,NP3CENT                                         0734
         TM    CANOPT(@10),B'00100000'                             0734
         BNO   @RF00734                                            0734
*                 DO;               /* ZERO ENTRY FOR THIS PARM IN 0735
*                                      OPERTAB AND PARMTAB           */
*                   OPLIBENT=OPLIBENT&&OPLIBENT;                   0736
         XC    OPLIBENT(16,@10),OPLIBENT(@10)                      0736
*                   NP3CENT=PARMREG;/* POINT TO PARMTAB              */
         ST    PARMREG,NP3CENT                                     0737
*                   OPLIBENT=OPLIBENT&&OPLIBENT;                   0738
         L     @10,NP3CENT                                         0738
         XC    OPLIBENT(16,@10),OPLIBENT(@10)                      0738
*                 END;                                             0739
*               NP3CENT=OPERREG;    /* POINT TO OPERTB               */
@RF00734 ST    OPERREG,NP3CENT                                     0740
*               IF NIPPTMRG='1'B    /* IS MERGE FLAG ON FOR THIS PARM*/
*                 THEN                                             0741
         L     @10,NP3CENT                                         0741
         TM    NIPPTATF-NIPPTE(@10),B'10000000'                    @L01
         BNO   @RF00741                                            0741
*                 DO;                                              0742
*                                                                  0742
*                   /*************************************************/
*                   /*                                               */
*                   /* DECREMENT COUNT CONTROL ELEMENT FOR THIS ENTRY*/
*                   /*                                               */
*                   /*************************************************/
*                                                                  0743
*                   COUNTREG=COUNTREG-1;                           0743
*                                                                  0743
         BCTR  COUNTREG,0                                          0743
*                   /*************************************************/
*                   /*                                               */
*                   /* MOVE OPERATOR SPECIFIED PARAMETER ENTRY       */
*                   /* CONTENTS INTO PARMLIB PARMTAB ENTRY.          */
*                   /*                                               */
*                   /*************************************************/
*                                                                  0744
*                   PARMTABO=OPERTABC;                             0744
*                                                                  0744
         LA    @10,16                                              0744
         LR    @09,PARMREG                                         0744
         ALR   @09,@10                                             0744
         MVC   PARMTABO(16,@09),OPERTABC(OPERREG)                  0744
*                   /*************************************************/
*                   /*                                               */
*                   /* INCREMENT OFFSET INTO PARMTABS BY ENTRY       */
*                   /* CELLSIZE                                      */
*                   /*                                               */
*                   /*************************************************/
*                                                                  0745
*                   INDEXREG=LENGTH(OPLIBENT)+INDEXREG;            0745
*                                                                  0745
         ALR   INDEXREG,@10                                        0745
*                   /*************************************************/
*                   /*                                               */
*                   /* BRANCH TO SET UP FOR NEXT ENTRY MERGE         */
*                   /*                                               */
*                   /*************************************************/
*                                                                  0746
*                   GO TO NP3NXFLD;                                0746
         B     NP3NXFLD                                            0746
*                 END;                                             0747
*               ELSE                                               0748
*                 DO;                                              0748
*                                                                  0748
@RF00741 DS    0H                                                  0749
*                   /*************************************************/
*                   /*                                               */
*                   /* MOVE THE OPERATOR ENTRY CONTENT INTO THE      */
*                   /* PARMLIB ENTRY                                 */
*                   /*                                               */
*                   /*************************************************/
*                                                                  0749
*                   PARMTABC=OPERTABC;                             0749
*                                                                  0749
         MVC   PARMTABC(16,PARMREG),OPERTABC(OPERREG)              0749
*                   /*************************************************/
*                   /*                                               */
*                   /* BRANCH TO SET UP FOR NEXT ENTRY MERGE         */
*                   /*                                               */
*                   /*************************************************/
*                                                                  0750
*                   GO TO NP3NXFLD;                                0750
         B     NP3NXFLD                                            0750
*                 END;                                             0751
*             END;                                                 0752
*         END;                                                     0753
*       ELSE                        /* OPERATOR DID NOT SPECIFY    0754
*                                      PARAM. FOR THIS CURRENT     0754
*                                      PARMTAB ENTRY                 */
*         GO TO NP3NXFLD;           /* BRANCH TO SETUP FOR NEXT ENTRY
*                                      MERGE                         */
*     END;                                                         0755
*   ELSE                            /* MERGE OPERATION IS COMPLETED  */
*     GO TO NP3RTAD0;               /* RETURN TO CALLER              */
*                                                                  0756
@RF00714 L     @10,NP3RTADR                                        0756
         BR    @10                                                 0756
*   /*****************************************************************/
*   /*                                                               */
*   /* SETUP FOR NEXT PARMTAB'S ENTRY MERGE                          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0757
*NP3NXFLD:                                                         0757
*   COUNTREG=COUNTREG-1;            /* DECREMENT PARMTAB ENTRY COUNT */
NP3NXFLD BCTR  COUNTREG,0                                          0757
*   INDEXREG=LENGTH(OPLIBENT)+INDEXREG;/* UPDATE INDEX BY ENTRY SIZE */
*                                                                  0758
         LA    INDEXREG,16(,INDEXREG)                              0758
*   /*****************************************************************/
*   /*                                                               */
*   /* UPDATE MAPPING BASE ADDRESS FOR PARMLIB PARMTAB               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0759
*   PARMREG=INDEXREG+ADDR(PTABLN);                                 0759
*                                                                  0759
         LA    PARMREG,PTABLN                                      0759
         ALR   PARMREG,INDEXREG                                    0759
*   /*****************************************************************/
*   /*                                                               */
*   /* UPDATE MAPPING BASE ADDRESS FOR OPERATOR PARMTAB              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0760
*   OPERREG=INDEXREG+ADDR(OPTABLN);                                0760
         LA    OPERREG,OPTABLN                                     0760
         ALR   OPERREG,INDEXREG                                    0760
*   GO TO NP3MRGST;                 /* BRANCH TO MERGE SEQUENCE      */
*                                                                  0761
         B     NP3MRGST                                            0761
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SUBROUTINE SETS UP TO ISSUE A PARAMETER IGNORE MESSAGE TO*/
*   /* THE OPERATOR AND CONVERTS THE NEGATIVE CONTENT OF THE CURRENT */
*   /* MERGE ENTRY IN THE PARMLIB PARMTAB                            */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0762
*   RESPECIFY                                                      0762
*     SYMBLREG RESTRICTED;          /* BASED ADDRESS OF IGNORED    0762
*                                      PARAMETER SYMBOL FROM SYMBOL
*                                      TABLE                         */
*NP3IGNOP:                                                         0763
*   SYMBLREG=INDEXREG/2+ADDR(NP3SYMBL);/* LOCATE ERROR PARAMETER   0763
*                                      SYMBOL IN SYMBOL TABLE        */
NP3IGNOP LR    SYMBLREG,INDEXREG                                   0763
         SRL   SYMBLREG,1                                          0763
         LA    @10,NP3SYMBL                                        0763
         ALR   SYMBLREG,@10                                        0763
*   PRMIGNOR=SYMBLID;               /* MOVE SYMBOL INTO IGNORE     0764
*                                      MESSAGE                       */
*                                                                  0764
         MVC   PRMIGNOR(8),SYMBLID(SYMBLREG)                       0764
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECKS THE LENGTH OF SYMBOL MOVED INTO IGNORE MESSAGE TEXT FOR*/
*   /* VALUE GREATER THEN SEVEN. IF YES, NO OVERSTRIKE OF LENGTH     */
*   /* VALUE IN TEXT IS NEEDED.                                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0765
*   IF SYMLNGTH>LENGTH(SYMBSTRT)-1  /* LENGTH VALUE GREATER THEN 7   */
*     THEN                          /* YES, NO OVERSTRIKE IS NEEDED  */
         CLI   SYMLNGTH,7                                          0765
         BH    @RT00765                                            0765
*     GO TO NP3IMSG;                /* BRANCH TO NIPWTO INTERFACE  0766
*                                      BRANCH CALL                   */
*   ELSE                            /* NO, OVERSTRIKE OF LENGTH VALUE
*                                      NEEDED                        */
*     DO;                                                          0767
*       SYMBREP=NP3BLANK;           /* MOVE BLANK ONTO LENGTH VALUE  */
         MVC   SYMBREP(1),NP3BLANK                                 0768
*       GO TO NP3IMSG;              /* BRANCH TO NIPWTO INTERFACE  0769
*                                      BRANCH CALL                   */
         B     NP3IMSG                                             0769
*     END;                                                         0770
*   RESPECIFY                                                      0771
*     SYMBLREG UNRESTRICTED;        /* RELEASE ADDRESS REG.          */
*                                                                  0771
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS GENERATED BRANCH INTERFACE MACRO CALL NIPWTO IN IEAVNIPM */
*   /* FOR ISSUING THE IGNORE MESSAGE TEXT TO THE OPERATOR.          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0772
*   GENERATE REFS(NVTWTO) DEFS(NP3IMSG);                           0772
NP3IMSG  DS    0H
         IEAPMNIP   TYPE=WTO,PARAM=MESG03
*   GO TO NP3NXFLD;                 /* BRANCH TO SETUP FOR NEXT ENTRY
*                                      FOR MERGE OPERATION           */
         B     NP3NXFLD                                            0773
*   RESPECIFY                                                      0774
*     OPERREG UNRESTRICTED;         /* RELEASE MERGE REGISTER        */
*   RESPECIFY                                                      0775
*     INDEXREG UNRESTRICTED;        /* RELEASE MERGE REGISTER        */
*                                                                  0776
*   /*****************************************************************/
*   /*                                                               */
*   /* MOVE PLIBTAB TO PARMTAB IN PARMAREA AND COMPRESS BY DELETING  */
*   /* NULL CHARACTERS                                               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0776
*   RESPECIFY                                                      0776
*     PLIBREG RESTRICTED;                                          0776
*   RESPECIFY                                                      0777
*     NIPPTE BASED(PARMREG);                                       0777
*   RESPECIFY                                                      0778
*     OPLIBENT BASED(PLIBREG);                                     0778
*   RESPECIFY                                                      0779
*     NIPPAREA BASED(PARMPTR);                                     0779
*   RESPECIFY                                                      0780
*     NIPPAHDR BASED(PARMPTR);                                     0780
*NP3PTAB:                                                          0781
*   NP3RTADR=REXIT;                 /* SAVE CALLER'S REUTRN ADDR     */
NP3PTAB  ST    REXIT,NP3RTADR                                      0781
*   PARMPTR=NVTPAREA;               /* POINT TO INITIAL PARMAREA     */
         L     @10,NVTPAREA(,RNVT)                                 0782
         ST    @10,PARMPTR                                         0782
*   NP3PAREA=NVTPAREA;              /* SET PTR TO LAST 2K AREA GOTTEN
*                                      = INITIAL PARMAREA (FOR     0783
*                                      GETMAIN SUBROUTINE)           */
         ST    @10,NP3PAREA                                        0783
*   NIPPABYT=ADDR(NIPPABUF);        /* NEXT AVAILABLE BYTE IS AREA 0784
*                                      FOLLOWING PARMTAB             */
         LA    @09,NIPPABUF-NIPPAREA(,@10)                         @L01
         ST    @09,NIPPABYT-NIPPAHDR(,@10)                         @L01
*   PARMQPTR=NIPPAQ;                /* SAVE QUEUE POINTER            */
         L     @09,NIPPAQ-NIPPAHDR(,@10)                           @L01
         ST    @09,PARMQPTR                                        0785
*   NIPPAQ=NIPPAQ&&NIPPAQ;          /* ZERO INITIAL PARMAREA CHAIN 0786
*                                      POINTER                       */
         LR    @05,@09                                             0786
         XR    @05,@09                                             0786
         ST    @05,NIPPAQ-NIPPAHDR(,@10)                           @L01
*   PARMREG=ADDR(NIPPAPTB);         /* GET ADDR OF PARMTAB           */
         LA    PARMREG,NIPPAPTB-NIPPAREA(,@10)                     @L01
*   PLIBREG=ADDR(PTABLN);           /* GET ADDR OF PLIBTAB           */
*                                                                  0788
         LA    PLIBREG,PTABLN                                      0788
*   /*****************************************************************/
*   /*                                                               */
*   /* GET NUMBER OF ENTRIES IN PARMTAB                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0789
*   COUNTREG=LENGTH(PARMTAB)/LENGTH(PTABSTRT);                     0789
         LA    COUNTREG,L'PARMTAB/L'PTABSTRT                       @L01
*NP3PTNXT:                                                         0790
*   IF COUNTREG=0                   /* IS ENTRY COUNT ZERO           */
*     THEN                                                         0790
NP3PTNXT SLR   @10,@10                                             0790
         CR    COUNTREG,@10                                        0790
         BE    @RT00790                                            0790
*     GO TO NP3PTINT;               /* YES - MERGE IS DONE - GO    0791
*                                      FREEMAIN QUEUE                */
*   IF ORAD=0                       /* IS THIS ENTRY ZERO            */
*     THEN                                                         0792
         C     @10,ORAD(,PLIBREG)                                  0792
         BE    @RT00792                                            0792
*     GO TO NP3PTINX;               /* YES - NO SPECIFICATION FOR  0793
*                                      THIS PARAMETER                */
*   IF ORLN='0000'X                 /* IS SUBSTRING LENGTH OF THIS 0794
*                                      ENTRY ZERO                    */
*     THEN                          /* YES - SET ADDRESS VALUE       */
         CLC   ORLN(2,PLIBREG),@CB02317                            0794
         BNE   @RF00794                                            0794
*     DO;                           /* IN CURRENT ENTRY TO X'0A'     */
*       NIPPTADR='0A'X;             /* ADDR = X'0A'                  */
         LA    @10,10                                              0796
         ST    @10,NIPPTADR-NIPPTE(,PARMREG)                       @L01
*       GO TO NP3PTKEY;                                            0797
         B     NP3PTKEY                                            0797
*     END;                          /*                         Y02752*/
*                                                                  0798
*   /*****************************************************************/
*   /*                                                               */
*   /* MOVE THE PARAMETER ENTRY INTO SYSTEM PARMLIB            Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0799
*   CALL NPMOVEP;                   /*                         Y02752
*                                                              Y02752*/
@RF00794 BAL   @14,NPMOVEP                                         0799
*NP3PTKEY:                                                         0800
*   NIPPTOPF=OPFLAG;                /* MOVE OPI ,LIST, AND           */
NP3PTKEY MVC   NIPPTOPF-NIPPTE(1,PARMREG),OPFLAG(PLIBREG)          @L01
*   NIPPTATF=ATTRFLAG;              /* MERGE FLAGS , AND INPUT       */
         MVC   NIPPTATF-NIPPTE(1,PARMREG),ATTRFLAG(PLIBREG)        @L01
*   NIPPTSID=INSRCID;               /* SOURCE ID TO PARMTAB          */
         MVC   NIPPTSID-NIPPTE(2,PARMREG),INSRCID(PLIBREG)         @L01
*NP3PTINX:                          /* WAS 'U,L' REQUESTED           */
*   IF NVTFLLST='1'B THEN           /* YES -                         */
NP3PTINX TM    NVTFLLST(RNVT),B'10000000'                          0803
         BNO   @RF00803                                            0803
*     NIPPTLST='1'B;                /* SET LIST FLAG IN PARMTAB ENTRY*/
         OI    NIPPTOPF-NIPPTE(PARMREG),B'01000000'                @L01
*   COUNTREG=COUNTREG-1;            /* DECREMENT COUNTER             */
@RF00803 BCTR  COUNTREG,0                                          0805
*   PARMREG=PARMREG+LENGTH(NIPPTE); /* UPDATE PARMTAB PTR BY ENTRY 0806
*                                      SIZE                          */
**       LA    PARMREG,8(,PARMREG)                                 0806
         LA    PARMREG,L'NIPPTE(,PARMREG)                          @L01
*   PLIBREG=PLIBREG+LENGTH(OPLIBENT);/* UPDATE PLIBTAB PTR BY ENTRY
*                                      SIZE                          */
         LA    PLIBREG,16(,PLIBREG)                                0807
*   GO TO NP3PTNXT;                                                0808
         B     NP3PTNXT                                            0808
*   RESPECIFY                                                      0809
*     NIPPAREA BASED(NVTPAREA);                                    0809
*NP3PTINT:                                                         0810
*   NVTPTAB=ADDR(NIPPAPTB);         /* MOVE PARMTAB ADDR TO NVT      */
NP3PTINT L     @10,NVTPAREA(,RNVT)                                 0810
         LA    @10,NIPPAPTB-NIPPAREA(,@10)                         @L01
         ST    @10,NVTPTAB(,RNVT)                                  0810
*   RESPECIFY                                                      0811
*     NIPPAREA BASED(PARMPTR);                                     0811
*NP3PAFM:                                                          0812
*   PARMPTR=PARMQPTR;               /* GET ADDR OF CURRENT PARMAREA
*                                      ON QUEUE                      */
NP3PAFM  L     @10,PARMQPTR                                        0812
         ST    @10,PARMPTR                                         0812
*   PARMQPTR=NIPPAQ;                /* SAVE ADDR OF NEXT PARMAREA ON
*                                      QUEUE                         */
*                                                                  0813
         MVC   PARMQPTR(4),NIPPAQ-NIPPAHDR(@10)                    @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* FREE 2K BLOCK OF PARMAREA                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0814
*   GENERATE;                                                      0814
          FREEMAIN E,LV=2048,A=PARMPTR
*   IF PARMQPTR^=0                  /* ARE THERE MORE PARMAREAS      */
*     THEN                                                         0815
         ICM   @10,15,PARMQPTR                                     0815
         BNZ   @RT00815                                            0815
*     GO TO NP3PAFM;                /* YES - GO FREE THEM            */
*                                                                  0816
*   /*****************************************************************/
*   /*                                                               */
*   /* NO MORE PARMAREAS TO FREE SO -                                */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0817
*NP3PTXIT:                                                         0817
*   GO TO NP3RTAD0;                 /* RETURN TO CALLER              */
NP3PTXIT L     @10,NP3RTADR                                        0817
         BR    @10                                                 0817
*   RESPECIFY                                                      0818
*     NIPPAREA BASED(NVTPAREA);                                    0818
*   RESPECIFY                                                      0819
*     PARMREG UNRESTRICTED;                                        0819
*   RESPECIFY                                                      0820
*     PLIBREG UNRESTRICTED;                                        0820
*   RESPECIFY                                                      0821
*     COUNTREG UNRESTRICTED;                                       0821
*                                                                  0822
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS ROUTINE IS FOR THE SYS1.LINKLIB DEFINITION               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0822
*   RESPECIFY                                                      0822
*     LNKLIB BASED(LCNAMPTR);                                      0822
*NP3LKLIB:                                                         0823
*   NP3RTADR=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
*                                                                  0823
NP3LKLIB ST    REXIT,NP3RTADR                                      0823
*   /*****************************************************************/
*   /*                                                               */
*   /* SEARCH FOR SYS1.LINKLIB VIA LOCATE                            */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0824
*   LNKLIB=LINKLIB;                 /* SET SYS1.LINKLIB NAME IN    0824
*                                      LOCATE LIST                   */
*                                                                  0824
         L     @10,LCNAMPTR                                        0824
         MVC   LNKLIB(12,@10),LINKLIB                              0824
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATES LOCATE MACRO FOR SYS1.LINKLIB SEARCH                */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0825
*   GENERATE;                                                      0825
*                                                                  0825
         LOCATE     LOCLIB         ISSUE LOCATE FOR SYS1.LINKLIB
*   /*****************************************************************/
*   /*                                                               */
*   /* EXAMINES RETURN CODE FROM LOCATE FOR SYS1.LINKLIB. IF THE     */
*   /* RETURN CODE IS ANYTHING OTHER THEN ZERO,AN ERROR CONDITION IS */
*   /* ASSUMED. IF AN ERROR CONDITION EXIST,THE OPERATOR IS NOTIFIED */
*   /* AN ACTION TO PLACE THE SYSTEM IN A DISABLED WAIT STATE IS     */
*   /* TAKEN.                                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0826
*   IF LOCREG^=0                    /* IS RETURN CODE OTHER THEN ZERO*/
*     THEN                          /* YES, ERROR CONDITION EXIST    */
         LTR   LOCREG,LOCREG                                       0826
         BZ    @RF00826                                            0826
*     DO;                                                          0827
*       NP3LOCER=LINKLIB;           /* MOVE DATA SET NAME INTO ERROR
*                                      MESSAGE TEXT                  */
*                                                                  0828
         MVC   NP3LOCER(12),LINKLIB                                0828
*       /*************************************************************/
*       /*                                                           */
*       /* GENERATED MACRO BRANCH INTERFACE CALL TO WTO              */
*       /*                                                           */
*       /*************************************************************/
*                                                                  0829
*       GENERATE REFS(NVTWTO);                                     0829
         IEAPMNIP   TYPE=WTO,PARAM=MESG06    ISSUE CALL TO WTO
*       NVTFLWSC=NVTFLWLC;          /* SET WAIT STATE CODE IN NVT    */
*                                                                  0830
         MVI   NVTFLWSC(RNVT),X'0A'                                0830
*       /*************************************************************/
*       /*                                                           */
*       /* GENERATE MACRO BRANCH INTERFACE CALL TO NIPSWAIT(IEAVNIPM)*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  0831
*       GENERATE REFS(NVTSWAIT);                                   0831
         IEAPMNIP   TYPE=SWAIT               ISSUE CALL TO SWAIT
*     END;                                                         0832
*   ELSE                                                           0833
*     ;                             /* NO, LOCATE WAS SUCCESSFULL    */
@RF00826 DS    0H                                                  0834
*   RESPECIFY                                                      0834
*     NIPMNTPL BASED(NP3LST03);                                    0834
*   NMNTDS=LINKLIB;                 /* SET SYS1.LINKLIB NAME IN MOUNT
*                                      PARAMETER LIST                */
         L     @10,NP3LST03                                        0835
         MVC   NMNTDS(12,@10),LINKLIB                              0835
*   NMNTVS=NP3VOLSR;                /* SET VOLUME SERIAL IN NIPMOUNT
*                                      PARAMETER LIST                */
         MVC   NMNTVS(6,@10),NP3VOLSR                              0836
*   NMNTDT=NP3DVTYP;                /* SET DEVICE TYPE IN NIPMOUNT 0837
*                                      PARAMETER LIST                */
*                                                                  0837
         MVC   NMNTDT(2,@10),NP3DVTYP                              0837
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO BRANCH INTERFACE TO NIPMOUNT(IEAVNPM3)        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0838
*   GENERATE REFS(NVTMOUNT) SETS(RPARM,REXIT,RENTRY);              0838
         IEAPMNIP   TYPE=MOUNT,PARAM=PLIST03      ISSUE NIPMOUNT CALL
*   RESPECIFY                                                      0839
*     NIPOPNPL BASED(NP3LST04);                                    0839
*   RESPECIFY                                                      0840
*     RPARM RESTRICTED;                                            0840
*NP3OPEN:                                                          0841
*   NOPNUCB=RPARM;                  /* SET UCB ADDR IN LIST          */
NP3OPEN  L     @10,NP3LST04                                        0841
         ST    RPARM,NOPNUCB(,@10)                                 0841
*   RESPECIFY                                                      0842
*     RPARM UNRESTRICTED;                                          0842
*   NOPNDCB=CVTLINK;                /* SET LINKLIB DCB ADDRESS IN  0843
*                                      NIPOPEN PARAMETER LIST        */
*                                                                  0843
         MVC   NOPNDCB(4,@10),CVTLINK(CVTPTR)                      0843
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO BRANCH INTERFACE TO NIPOPEN(IEAVNPM3)         */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0844
*   GENERATE REFS(NVTOPEN) SETS(RPARM,REXIT,RENTRY,NOPNFL);        0844
         IEAPMNIP   TYPE=OPEN,PARAM=PLIST04,OPT=(,LB,,,,,,RS)  @ZA01561
*   UCBPTR=NOPNUCB;                 /* SET BASE POINTER TO UCB       */
         L     @10,NP3LST04                                        0845
         L     @10,NOPNUCB(,@10)                                   0845
         ST    @10,UCBPTR                                          0845
*   UCBUSER=UCBUSER+1;              /* INCREMENT USE COUNT   @ZA02591*/
         LA    @09,1                                               0846
         SLR   @15,@15                                             0846
         IC    @15,UCBUSER(,@10)                                   0846
         ALR   @09,@15                                             0846
         STC   @09,UCBUSER(,@10)                                   0846
*   GO TO NP3RTAD0;                 /* RETURN TO CALLER              */
         L     @10,NP3RTADR                                        0847
         BR    @10                                                 0847
*                                                                  0848
*   /*****************************************************************/
*   /*                                                               */
*   /* DEFINE LINKLIB CONCATENATIONS                                 */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0848
*   DCL                                                            0848
*     YESS BIT(1) CONSTANT('1'B),   /* YES='1'BIT                    */
*     NONO BIT(1) CONSTANT('0'B),   /* NO='0'BIT                     */
*     LPARAN CHAR(1) CONSTANT('('), /* LEFT PARANTHESIS              */
*     RPARAN CHAR(1) CONSTANT(')'), /* RIGHT PARAN                   */
*     COMMA CHAR(1) CONSTANT(','),  /* COMMA CONSTANT                */
*     ONE FIXED(15) CONSTANT(01),   /* FOR ADDITION                  */
*     TWO FIXED(32) CONSTANT(02),   /* FOR ADDR UPDATE               */
*     FIVE FIXED(32) CONSTANT(05),  /* FOR TRT COMPARE               */
*     EIGHT FIXED(32) CONSTANT(08), /* FOR TRT COMPARE               */
*     SIXTEEN FIXED(32) CONSTANT(16),/* FOR END FILE TEST            */
*     UPCASE CHAR(2) CONSTANT('  '),/* FOR UPCASE SHIFT              */
*     ZERO FIXED(31) CONSTANT(00),  /* ZERO CONSTANT                 */
*     ZEROBIT BIT(1) CONSTANT('0'B),/* TO SET BITS                   */
*     ONEBIT BIT(1) CONSTANT('1'B); /* TO SET BITS             Y02754*/
*   DCL                                                            0849
*     MESG12B CHAR(8) GEND;         /* MESG MEM NAME           Y02754*/
*   DCL                                                            0850
*     ALLDONE BIT(1);               /* CONTROLER FORD          Y02754*/
*   DCL                                                            0851
*     PTRSAVE PTR(31);              /* SAVES ADDRESS           Y02754*/
*   DCL                                                            0852
*     #MEMBERS FIXED(15);           /* MEMS TO PROCES          Y02754*/
*   DCL                                                            0853
*     #PROCESD FIXED(15);           /* # MEMS PROCESD          Y02754*/
*   DCL                                                            0854
*     LNKPARMS CHAR(80) BASED;      /* RECORD IN PARM          Y02754*/
*   DCL                                                            0855
*     BADLNK CHAR(8) INIT('LNK') LOCAL;/* FOR MESG             Y02754*/
*   DCL                                                            0856
*     1 LNKMEM,                                                    0856
*       3 * CHAR(6),                /* MEM NAME HEAD           Y02754*/
*       3 NUMBER CHAR(2);           /* MEM NUMBER              Y02754*/
*   DCL                                                            0857
*     R2SAVE PTR(31);               /* SAVES NVT ADDR          Y02754*/
*   DCL                                                            0858
*     1 TRTTAB LOCAL,               /* TRANLATE + TEST               */
*       3 *(77) CHAR(1) INIT((77)'04'X),/* ERRORS                    */
*       3 * CHAR(1) INIT('03'X),    /* LEFTPARAN                     */
*       3 *(13) CHAR(1) INIT((13)'04'X),/* ERRORS                    */
*       3 * CHAR(1) INIT('00'X),    /* DOLLAR SIGN                   */
*       3 * CHAR(1) INIT('04'X),    /* ERROR                         */
*       3 * CHAR(1) INIT('08'X),    /* RIGHT PARAN                   */
*       3 *(13) CHAR(1) INIT((13)'04'X),/* ERROR CHARS               */
*       3 * CHAR(1) INIT('05'X),    /* COMMA                         */
*       3 *(15) CHAR(1) INIT((15)'04'X),/* ERROR CHARS               */
*       3 *(2) CHAR(1) INIT((2)'00'X),/* POUND + ATSING              */
*       3 * CHAR(1) INIT('01'X),    /* QOUTE TO STOP                 */
*       3 *(3) CHAR(1) INIT((3)'04'X),/* ERROR CHARS                 */
*       3 *(9) CHAR(1) INIT((9)'00'X),/* LOW CASE A-I                */
*       3 *(7) CHAR(1) INIT((7)'04'X),/* ERROR CHARS                 */
*       3 *(9) CHAR(1) INIT((9)'00'X),/* LOW CASE J-R                */
*       3 *(8) CHAR(1) INIT((8)'04'X),/* ERROR CHARS                 */
*       3 *(8) CHAR(1) INIT((8)'00'X),/* LOW CASE S-Z                */
*       3 *(23) CHAR(1) INIT((23)'04'X),/* ERROR CHARS               */
*       3 *(9) CHAR(1) INIT((9)'00'X),/* A-I                         */
*       3 *(7) CHAR(1) INIT((7)'04'X),/* ERROR CHARS                 */
*       3 *(9) CHAR(1) INIT((9)'00'X),/* J-R                         */
*       3 *(8) CHAR(1) INIT((8)'04'X),/* ERROR CHARS                 */
*       3 *(8) CHAR(1) INIT((8)'00'X),/* S-Z                         */
*       3 *(6) CHAR(1) INIT((6)'04'X),/* ERROR CHARS                 */
*       3 *(10) CHAR(1) INIT((10)'00'X),/* NUMERICS                  */
*       3 *(6) CHAR(1) INIT((6)'04'X);/* ERROR CHARS           Y02754*/
*NP3LCAT:                                                          0859
*   NP3RTADR=REXIT;                 /* SAVE CALLERS RETURN ADDRESS 0859
*                                                              Y02754*/
NP3LCAT  ST    REXIT,NP3RTADR                                      0859
*   R2SAVE=RNVT;                    /* SAVE THE NVT ADDRESS FOR NIP
*                                      SERVICES                Y02754*/
         ST    RNVT,R2SAVE                                         0860
*   ALLDONE=NONO;                   /* CONTROLLING FACTOR FOR THE DO
*                                      WHILE FOR SYNTAX        Y02754*/
         NI    ALLDONE,B'01111111'                                 0861
*   DO WHILE ALLDONE=NONO;          /* DO UNTIL THE SYNTAX IS CORRECT
*                                      FOR LNK PARAMETERS IN PARMTAB
*                                                              Y02754*/
         B     @DE00862                                            0862
@DL00862 DS    0H                                                  0863
*     RNVT=R2SAVE;                  /* USED IN DO WHILE GROUP  Y02754*/
         L     RNVT,R2SAVE                                         0863
*     RESPECIFY                                                    0864
*       PARMTAB BASED(NVTPTAB);     /*                         Y02754*/
*     PTRSAVE=LNK;                  /* SAVE PARMS PTR          Y02754*/
         L     @10,NVTPTAB(,RNVT)                                  0865
         L     @10,LNK-PARMTAB(,@10)                               @L01
         ST    @10,PTRSAVE                                         0865
*     #PROCESD=ZERO;                /* ZERO OUT                Y02754*/
         SLR   @09,@09                                             0866
         STH   @09,#PROCESD                                        0866
*     #MEMBERS=ONE;                 /* USED FOR END FILE FOR #     0867
*                                      MEMBERS TO PROCESS      Y02754*/
         MVC   #MEMBERS(2),@CH00034                                0867
*     RESPECIFY                                                    0868
*       LNKPARMS BASED(LNK);        /*                         Y02754*/
*     IF LNK=ZERO THEN              /* TEST FOR DEFAULT USE    Y02754*/
         CR    @10,@09                                             0869
         BNE   @RF00869                                            0869
*       ALLDONE=YESS;               /* IF IT IS ZERO THEN GET OUT OF
*                                      DO WHILE                Y02754*/
         OI    ALLDONE,B'10000000'                                 0870
*     ELSE                          /* PROCESS THE LNK PARM    Y02754*/
*       IF LNKPARMS(1:1)=LPARAN THEN/* TEST FOR MULTI MEM BERS     0871
*                                      SPECIFIED               Y02754*/
         B     @RC00869                                            0871
@RF00869 L     @10,NVTPTAB(,RNVT)                                  0871
         L     @10,LNK-PARMTAB(,@10)                               @L01
         CLI   LNKPARMS(@10),C'('                                  0871
         BNE   @RF00871                                            0871
*         DO;                       /* SO PROCESS THE PARM     Y02754*/
*           PTRSAVE=PTRSAVE+ONE;    /* POINT TO 1ST CHAR AFTER THE 0873
*                                      LEFT PARAN              Y02754*/
         LA    @10,1                                               0873
         AL    @10,PTRSAVE                                         0873
         ST    @10,PTRSAVE                                         0873
*           RESPECIFY                                              0874
*             LNKPARMS BASED(PTRSAVE);/*                       Y02754*/
*           DO WHILE RNVT^=EIGHT;   /* SCAN THE PARMS FOR A RIGHT  0875
*                                      PARAN THEN STOP         Y02754*/
         B     @DE00875                                            0875
@DL00875 DS    0H                                                  0876
*             RNVT=ZERO;            /* SET TO 00               Y02754*/
         SLR   RNVT,RNVT                                           0876
*             TRT(LNKPARMS,TRTTAB); /* TRT THE PARMS FOR AN INVALID
*                                      CHAR OR RPARAN AND ,    Y02754*/
         L     @10,PTRSAVE                                         0877
         TRT   LNKPARMS(80,@10),TRTTAB                             0877
*             IF RNVT=FIVE THEN     /* TEST IF IT STOPED ON A COMMA
*                                                              Y02754*/
         CH    RNVT,@CH00170                                       0878
         BNE   @RF00878                                            0878
*               DO;                 /* IF SO IS THE COMMA IN THE   0879
*                                      PROPER PLACE            Y02754*/
*                 PTRSAVE=PTRSAVE+TWO;/* MOVE THE PTR TO WHERE THE 0880
*                                      COMMA SHOULD BE         Y02754*/
         LA    @10,2                                               0880
         AL    @10,PTRSAVE                                         0880
         ST    @10,PTRSAVE                                         0880
*                 IF RPARM=PTRSAVE THEN/* TEST FOR COMMA IN PROPER 0881
*                                      PLACE IN PARMS          Y02754*/
         CR    RPARM,@10                                           0881
         BNE   @RF00881                                            0881
*                   DO;                                            0882
*                     #MEMBERS=#MEMBERS+ONE;/* ADD 1 TO # OF MEM   0883
*                                                              Y02754*/
         LA    @09,1                                               0883
         LH    @15,#MEMBERS                                        0883
         ALR   @15,@09                                             0883
         STH   @15,#MEMBERS                                        0883
*                     PTRSAVE=PTRSAVE+ONE;/* POINT TO CHAR AFTER THE
*                                      COMMA AND GO BACK' TO TRT THE
*                                      REST OF PARMS           Y02754*/
         ALR   @10,@09                                             0884
         ST    @10,PTRSAVE                                         0884
*                   END;                                           0885
*                 ELSE              /* THE COMMA IS WRONG      Y02754*/
*                   DO;                                            0886
         B     @RC00881                                            0886
@RF00881 DS    0H                                                  0887
*                     RNVT=R2SAVE;  /* SET THE NVT PTR         Y02754*/
         L     RNVT,R2SAVE                                         0887
*                     RCVT=CVTPTR;  /* SET THE CVT PTR         Y02754*/
*                     RPARM=ADDR(BADLNK);/* PONIT R1 TO LNKBAD Y02754*/
         LA    RPARM,BADLNK                                        0889
*                     RENTRY=ADDR(IEAVNPA3);/* ADDR PRMPT      Y02754*/
         LA    RENTRY,IEAVNPA3                                     0890
*                     GEN( LCR   RPARM,RPARM );/* COMPLIMENT R1    0891
*                                                              Y02754*/
          LCR   RPARM,RPARM
*                     GEN( BALR  REXIT,RENTRY  ) FLOWS(IEAVNPA3);/*
*                                      GO TO PRMPT OPERATOR    Y02754*/
          BALR  REXIT,RENTRY  ) FLOWS(IEAVNPA3
*                     RNVT=EIGHT;   /* TO GET OUT OF DO WHILE NO   0893
*                                      RPARAN AND START OVE    Y02754*/
         LA    RNVT,8                                              0893
*                   END;            /*                         Y02754*/
*               END;                /*                         Y02754*/
*             ELSE                  /* TRT STOPED ON A CHAR OTHER  0896
*                                      THAN A COMMA            Y02754*/
*               IF RNVT=EIGHT THEN  /* SEE IF IT IS A RPARAN         */
         B     @RC00878                                            0896
@RF00878 CH    RNVT,@CH00156                                       0896
         BNE   @RF00896                                            0896
*                 DO;               /*                         Y02754*/
*                   PTRSAVE=PTRSAVE+TWO;/* SET PTR TO VALID DELIMETER
*                                                              Y02754*/
         LA    @10,2                                               0898
         AL    @10,PTRSAVE                                         0898
         ST    @10,PTRSAVE                                         0898
*                   IF RPARM=PTRSAVE THEN/* IS RPARAN IN PROPER PLACE
*                                      IN PARMS                Y02754*/
         CR    RPARM,@10                                           0899
         BNE   @RF00899                                            0899
*                     IF LNKPARMS(2:2)=QUOTE THEN/* A QUOTE SHOULD BE
*                                      AFTER THE RIGHT PARAN         */
         CLC   LNKPARMS+1(1,@10),QUOTE                             0900
         BNE   @RF00900                                            0900
*                       ALLDONE=YESS;/* IF SO THEN THE SYNTAX CHECK
*                                      IS ALL OK GETOUT        Y02754*/
         OI    ALLDONE,B'10000000'                                 0901
*                     ELSE          /* ERROR SO PROMPT OPER.         */
*                       DO;         /*                         Y02754*/
         B     @RC00900                                            0902
@RF00900 DS    0H                                                  0903
*                         RNVT=R2SAVE;/* SET THE NVT PT        Y02754*/
         L     RNVT,R2SAVE                                         0903
*                         RCVT=CVTPTR;/* SET THE CVT PTR       Y02754*/
*                         RPARM=ADDR(BADLNK);/* POINT R1 TO BADLNK 0905
*                                      FOR ERR MSG             Y02754*/
         LA    RPARM,BADLNK                                        0905
*                         RENTRY=ADDR(IEAVNPA3);/* ADDR PRMPT  Y02754*/
         LA    RENTRY,IEAVNPA3                                     0906
*                         GEN( LCR   RPARM,RPARM );/* COMPLIMENT R1
*                                                              Y02754*/
          LCR   RPARM,RPARM
*                         GEN( BALR  REXIT,RENTRY ) FLOWS(IEAVNPA3);
          BALR  REXIT,RENTRY ) FLOWS(IEAVNPA3
*                                   /* GO TO PRMPT OPERATOR    Y02754*/
*                         RNVT=EIGHT;/* TO GETOUT OF DOWHILE   Y02754*/
         LA    RNVT,8                                              0909
*                       END;        /*                         Y02754*/
*                   ELSE            /* THE RPARAN WAS OUT OF PLACE SO
*                                      IT IS                   Y02754*/
*                     DO;                                          0911
         B     @RC00899                                            0911
@RF00899 DS    0H                                                  0912
*                       RNVT=R2SAVE;/* SET THE NVT PTR         Y02754*/
         L     RNVT,R2SAVE                                         0912
*                       RCVT=CVTPTR;/* SET THE CVT PTR         Y02754*/
*                       RENTRY=ADDR(IEAVNPA3);/* ADDR PRMPT    Y02754*/
         LA    RENTRY,IEAVNPA3                                     0914
*                       RPARM=ADDR(BADLNK);/* POINT TO BADLNK  Y02754*/
         LA    RPARM,BADLNK                                        0915
*                       GEN( LCR   RPARM,RPARM );/* COMPLIMENT R1  0916
*                                                              Y02754*/
          LCR   RPARM,RPARM
*                       GEN( BALR  REXIT,RENTRY ) FLOWS(IEAVNPA3);/*
*                                      GO TO PRMPT OPERATOR    Y02754*/
          BALR  REXIT,RENTRY ) FLOWS(IEAVNPA3
*                       RNVT=EIGHT; /* TO GETOUT OF DOWHILE    Y02754*/
         LA    RNVT,8                                              0918
*                     END;          /*                         Y02754*/
*                 END;              /*                         Y02754*/
*               ELSE                /* TRT STOPPED ON AN INV ALID  0921
*                                      CHAR IN THE PARMS       Y02754*/
*                 DO;               /*                         Y02754*/
         B     @RC00896                                            0921
@RF00896 DS    0H                                                  0922
*                   RNVT=R2SAVE;    /* SET THE NVT PTR         Y02754*/
         L     RNVT,R2SAVE                                         0922
*                   RCVT=CVTPTR;    /* SET THE CVT PTR         Y02754*/
*                   RPARM=ADDR(BADLNK);/* POINT TO BADLNK      Y02754*/
         LA    RPARM,BADLNK                                        0924
*                   RENTRY=ADDR(IEAVNPA3);/* PTR PRMPT         Y02754*/
         LA    RENTRY,IEAVNPA3                                     0925
*                   GEN( LCR   RPARM,RPARM );/* COMPLIMENT R1  Y02754*/
          LCR   RPARM,RPARM
*                   GEN( BALR  REXIT,RENTRY  ) FLOWS(IEAVNPA3);/* GO
*                                      TO PRMPT OPERATOR       Y02754*/
          BALR  REXIT,RENTRY  ) FLOWS(IEAVNPA3
*                   RNVT=EIGHT;     /* TO GET OUT OF WHILE LOOP    0928
*                                                              Y02754*/
         LA    RNVT,8                                              0928
*                 END;              /*                         Y02754*/
*           END;                    /* WHILE^=8                Y02754*/
@RC00896 DS    0H                                                  0930
@RC00878 DS    0H                                                  0930
@DE00875 CH    RNVT,@CH00156                                       0930
         BNE   @DL00875                                            0930
*         END;                      /* IF=RPARAN               Y02754*/
*       ELSE                        /* 1ST CHAR WAS NOT A LEFT PARAN
*                                      SO SYNTAX THIS PARM     Y02754*/
*         IF LNKPARMS(3:3)=QUOTE THEN/* IT IS A SINGLE MEM SPECIFIED
*                                      CHECK IT                Y02754*/
         B     @RC00871                                            0932
@RF00871 L     @10,PTRSAVE                                         0932
         CLC   LNKPARMS+2(1,@10),QUOTE                             0932
         BNE   @RF00932                                            0932
*           DO;                     /* FOR VALIDITY            Y02754*/
*             RNVT=ZERO;            /* SET TO 00               Y02754*/
         SLR   RNVT,RNVT                                           0934
*             TRT(LNKPARMS,TRTTAB); /* TRT FOR GOOD SYNTAX OF      0935
*                                      ALPHAMERIC CHARS        Y02754*/
         L     @10,PTRSAVE                                         0935
         TRT   LNKPARMS(80,@10),TRTTAB                             0935
*             IF RNVT^=ONE THEN     /* IT SHOULD STOP ON A QUOTE IF
*                                      ALL OK                  Y02754*/
         CH    RNVT,@CH00034                                       0936
         BE    @RF00936                                            0936
*               DO;                 /* PROCESS IT              Y02754*/
*                 RNVT=R2SAVE;      /* SET NVT PTR             Y02754*/
         L     RNVT,R2SAVE                                         0938
*                 RCVT=CVTPTR;      /* SET THE CVT PTR         Y02754*/
*                 RPARM=ADDR(BADLNK);/* POINT TO BADLNK        Y02754*/
         LA    RPARM,BADLNK                                        0940
*                 RENTRY=ADDR(IEAVNPA3);/* PTR PRMPT           Y02754*/
         LA    RENTRY,IEAVNPA3                                     0941
*                 GEN( LCR   RPARM,RPARM );/* COMPLIMENT R1    Y02754*/
          LCR   RPARM,RPARM
*                 GEN( BALR  REXIT,RENTRY   ) FLOWS(IEAVNPA3);     0943
*                                                                  0943
          BALR  REXIT,RENTRY   ) FLOWS(IEAVNPA3
*                 /***************************************************/
*                 /*                                                 */
*                 /* GO TO PRMPT OPERATOR                      Y02754*/
*                 /*                                                 */
*                 /***************************************************/
*                                                                  0944
*               END;                /*                         Y02754*/
*             ELSE                  /* ALL WAS OK              Y02754*/
*               ALLDONE=YESS;       /* TO GET OUT OF LOOP      Y02754*/
         B     @RC00936                                            0945
@RF00936 OI    ALLDONE,B'10000000'                                 0945
*           END;                    /* IF = QUOTE              Y02754*/
*         ELSE                      /* PARM IS INVALID         Y02754*/
*           DO;                     /* PRMPT OPERATOR          Y02754*/
         B     @RC00932                                            0947
@RF00932 DS    0H                                                  0948
*             RNVT=R2SAVE;          /* SET NVT PTR             Y02754*/
         L     RNVT,R2SAVE                                         0948
*             RCVT=CVTPTR;          /* SET CVT PTR             Y02754*/
*             RPARM=ADDR(BADLNK);   /* POINT TO BADLNK         Y02754*/
         LA    RPARM,BADLNK                                        0950
*             RENTRY=ADDR(IEAVNPA3);/* PTR PRMPT               Y02754*/
         LA    RENTRY,IEAVNPA3                                     0951
*             GEN( LCR   RPARM,RPARM );/* COMPLIMENT R1        Y02754*/
          LCR   RPARM,RPARM
*             GEN( BALR  REXIT,RENTRY   ) FLOWS(IEAVNPA3);/* GO TO 0953
*                                      PRMPT THE OPERATOR      Y02754*/
          BALR  REXIT,RENTRY   ) FLOWS(IEAVNPA3
*           END;                    /*                         Y02754*/
*   END;                            /* END OF ALLDONE DO WHILE Y02754*/
@RC00932 DS    0H                                                  0955
@RC00871 DS    0H                                                  0955
@RC00869 DS    0H                                                  0955
@DE00862 TM    ALLDONE,B'10000000'                                 0955
         BZ    @DL00862                                            0955
*   RESPECIFY                                                      0956
*     LNKPARMS BASED(LNK);          /* NEW BASE                Y02754*/
*   LNKMEM=LNKLST;                  /* BASIC MEMBER            Y02754*/
         MVC   LNKMEM(8),LNKLST                                    0957
*   RNVT=R2SAVE;                    /* RESTORE RNVT            Y02754*/
         L     RNVT,R2SAVE                                         0958
*   IF LNK^=ZERO THEN               /* TEST FOR DEFAULT        Y02754*/
         L     @10,NVTPTAB(,RNVT)                                  0959
         L     @10,LNK-PARMTAB(,@10)                               @L01
         LTR   @10,@10                                             0959
         BZ    @RF00959                                            0959
*     IF LNKPARMS(1:1)=LPARAN THEN  /* TEST FOR MULTI MEMBER       0960
*                                      SPECIFIED               Y02754*/
         CLI   LNKPARMS(@10),C'('                                  0960
         BNE   @RF00960                                            0960
*       DO;                         /* SET UP MEM NUM          Y02754*/
*         NUMBER(1:2)=LNKPARMS(2:3)WUPCASE;/* MOVE IN 1ST DIGIT OF 0962
*                                      NUM.                    Y02754*/
         MVC   NUMBER(2),LNKPARMS+1(@10)                           0962
         OC    NUMBER(2),@CC02547                                  0962
*         PTRSAVE=LNK+4;            /* POINT TO NEXT MEMBER NAME   0963
*                                      SPECIFIED               Y02754*/
         AL    @10,@CF00371                                        0963
         ST    @10,PTRSAVE                                         0963
*       END;                        /*                         Y02754*/
*     ELSE                          /* IT IS A SINGLE MEMBER   Y02754*/
*       NUMBER(1:2)=LNKPARMS(1:2)WUPCASE;/* MOVE IN 1ST + 2ND DIGIT
*                                      OF NUMBER               Y02754*/
         B     @RC00960                                            0965
@RF00960 L     @10,NVTPTAB(,RNVT)                                  0965
         L     @10,LNK-PARMTAB(,@10)                               @L01
         MVC   NUMBER(2),LNKPARMS(@10)                             0965
         OC    NUMBER(2),@CC02547                                  0965
*   ELSE                                                           0966
*     ;                             /* NULL ELSE               Y02754*/
@RF00959 DS    0H                                                  0967
*   GEN( GETMAIN EC,LV=2048,A=GETAREA,SP=0 );/*                Y02754*/
@RC00959 DS    0H                                                  0967
          GETMAIN EC,LV=2048,A=GETAREA,SP=0
*   IF GETMRTCD^=ZERO THEN          /* TEST GET OK             Y02754*/
         LTR   GETMRTCD,GETMRTCD                                   0968
         BNZ   @RT00968                                            0968
*     GO TO NP3SW38;                /* GO TO WAIT STATE        Y02754*/
*   GETPTR=GETAREA;                 /* SAVE GET PTR            Y02754*/
         MVC   GETPTR(4),GETAREA                                   0970
*   NIPPANAM=LNKMEM;                /* SET THE MEMBER NAME FOR FIND
*                                      AND READ                Y02754*/
         L     @10,NVTPAREA(,RNVT)                                 0971
         MVC   NIPPANAM-NIPPAREA(8,@10),LNKMEM                     @L01
*   MESG12B=LNKMEM;                 /* PUT MEM NAME IN MESS. FOR   0972
*                                      TRUNC LNKLST            Y02754*/
         MVC   MESG12B(8),LNKMEM                                   0972
*   RNVT=R2SAVE;                    /* SET NVT PTR             Y02754*/
         L     RNVT,R2SAVE                                         0973
*NP3LCTXT:                                                         0974
*   CALL NIPPMMEM;                  /* CALL PSIO TO DO THE READ OF 0974
*                                      PARMLIB                 Y02754*/
NP3LCTXT BAL   @14,NIPPMMEM                                        0974
*   IF RPRM1<ZERO THEN              /* THE I/O RTN SENDS A RETUTN  0975
*                                      ADDR IN REG1 IF POSITIVE ALLIS
*                                      OK                      Y02754*/
         LTR   RPRM1,RPRM1                                         0975
         BM    @RT00975                                            0975
*     GO TO NP3ENDFL;               /* HERE ON AN ERROR OR FOR END 0976
*                                      FILE SO FIND OUT        Y02754*/
*   ELSE                            /* A RECORD HAS BEEN READ        */
*     GO TO SCANRCD;                /* PROCESS IT              Y02754*/
         B     SCANRCD                                             0977
*NP3ENDFL:                                                         0978
*   #PROCESD=#PROCESD+ONE;          /* ADD ONE TO NUM          Y02754*/
NP3ENDFL LA    @10,1                                               0978
         AH    @10,#PROCESD                                        0978
         STH   @10,#PROCESD                                        0978
*   RESPECIFY                                                      0979
*     PARMTAB BASED(NP3CTAB);       /*                         Y02754*/
*   IF NIPPARC^=SIXTEEN THEN        /* 16 IS END FILE          Y02754*/
         L     @09,NVTPAREA(,RNVT)                                 0980
         CLC   NIPPARC-NIPPAREA(4,@09),@CF00173                    @L01
         BNE   @RT00980                                            0980
*     GO TO NP3LCTFL;               /* IF ^16 IT SIS AN ERROR  Y02754*/
*   ELSE                            /* IT WAS END FILE SO PROCESS THE
*                                      NUMBER OF MEMS          Y02754*/
*     IF #MEMBERS^=#PROCESD THEN    /* TEST TO SEE IF ALL MEM- BERS
*                                      HAVE BEEN PROCESSED     Y02754*/
         CH    @10,#MEMBERS                                        0982
         BE    @RF00982                                            0982
*       DO;                         /* PROCESS ANOTHER MEMBER FOR  0983
*                                      LNKLST                  Y02754*/
*         RFY                                                      0984
*           LNKPARMS BASED(PTRSAVE);/*                         Y02754*/
*         LNKMEM=LNKLST;            /* BASIC MEM NAME          Y02754*/
         MVC   LNKMEM(8),LNKLST                                    0985
*         NUMBER(1:2)=LNKPARMS(1:2)WUPCASE;/* SET 1ST + 2ND DIGIT OF
*                                      THE NUM                 Y02754*/
         L     @10,PTRSAVE                                         0986
         MVC   NUMBER(2),LNKPARMS(@10)                             0986
         OC    NUMBER(2),@CC02547                                  0986
*         PTRSAVE=PTRSAVE+3;        /* POINT TO NEXT           Y02754*/
         AH    @10,@CH00261                                        0987
         ST    @10,PTRSAVE                                         0987
*         MESG12B=LNKMEM;           /* SET FOR ERROR MESSAGE FOR   0988
*                                      PROPER MEM NAME USED    Y02754*/
         MVC   MESG12B(8),LNKMEM                                   0988
*         NIPPANAM=LNKMEM;          /* SET NEXT MEMBER NAME FOR THE
*                                      I/O RTN                 Y02754*/
         MVC   NIPPANAM-NIPPAREA(8,@09),LNKMEM                     @L01
*         GO TO NP3LCTXT;           /* GO READ IT              Y02754*/
         B     NP3LCTXT                                            0990
*       END;                        /*                         Y02754*/
*     ELSE                          /* ALL FINISHED READING SO DO THE
*                                      CONCAT                  Y02754*/
*       GO TO NP3LCNND;             /* RTN TO CONCAT.          Y02754*/
*   RESPECIFY                                                      0993
*     INDEXREG RESTRICTED;                                         0993
*   RESPECIFY                                                      0994
*     DSNCTR RESTRICTED;                                           0994
*   RESPECIFY                                                      0995
*     NP3SCAN5 BASED(SCANREG);                                     0995
*SCANRCD:                                                          0996
*   SCANREG=RPARM;                  /* SAVE ADDR OF TEXT RECORD      */
SCANRCD  LR    SCANREG,RPARM                                       0996
*NP3LCDSN:                                                         0997
*   DSNCTR=0;                       /* ZERO DATASET NAME COUNTER     */
NP3LCDSN SLR   DSNCTR,DSNCTR                                       0997
*   INDEXREG=SCANREG;               /* SAVE START ADDR OF NAME       */
*                                                                  0998
         LR    INDEXREG,SCANREG                                    0998
*   /*****************************************************************/
*   /*                                                               */
*   /* IS THIS CARACTER A ',' OR A BLANK                             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  0999
*NP3LCNCR:                                                         0999
*   IF NP3SCANR=','WNP3SCANR=' ' THEN                              0999
NP3LCNCR CLI   NP3SCANR(SCANREG),C','                              0999
         BE    @RT00999                                            0999
         CLI   NP3SCANR(SCANREG),C' '                              0999
         BE    @RT00999                                            0999
*     GO TO NP3LCNAM;               /* YES - GO MOVE NAME            */
*   IF DSNCTR=44                    /* IS NUMBER OF DSN CHAR=44      */
*     THEN                                                         1001
         CH    DSNCTR,@CH02133                                     1001
         BE    @RT01001                                            1001
*     GO TO NP3LCNAM;               /* GO MOVE NAME TO WORKAREA      */
*   DSNCTR=DSNCTR+1;                /* INCREMENT CHAR CTR            */
         LA    @10,1                                               1003
         ALR   DSNCTR,@10                                          1003
*   SCANREG=SCANREG+1;              /* INCREMENT CHAR PTR            */
         ALR   SCANREG,@10                                         1004
*   GO TO NP3LCNCR;                 /* GO CHECK NEXT CHAR            */
         B     NP3LCNCR                                            1005
*NP3LCNAM:                                                         1006
*   IF DSNCTR=0                     /* ARE THERE NO CHARS IN THE   1006
*                                      RECORD                        */
*     THEN                                                         1006
NP3LCNAM LTR   DSNCTR,DSNCTR                                       1006
         BZ    @RT01006                                            1006
*     GO TO NP3LCNXT;               /* NO - THERE IS NO CONCATENATION*/
*   IF NP3SCANC=LINKLIB&            /* IS DATASET NAME SYS1.LINKLIB
*                                                             YM04365*/
*       (LNKAREA(13:13)=' 'W        /* BLANK TEST             YM04365*/
*       LNKAREA(13:13)=',')         /* COMMA TEST             YM04365*/
*     THEN                                                         1008
         CLC   NP3SCANC(12,INDEXREG),LINKLIB                       1008
         BNE   @RF01008                                            1008
         CLI   LNKAREA+12(INDEXREG),C' '                           1008
         BE    @RT01008                                            1008
         CLI   LNKAREA+12(INDEXREG),C','                           1008
         BE    @RT01008                                            1008
*     GO TO NP3LCNXT;               /* YES - DO NOT MOVE TO NEXT   1009
*                                      WORKAREA. CHECK NEXT NAME     */
*   DSNAME=LNKAREA;                 /* MOVE DSN TO NEXT SLOT IN    1010
*                                      WORKAREA                      */
@RF01008 L     @10,GETPTR                                          1010
         MVC   DSNAME(44,@10),LNKAREA(INDEXREG)                    1010
*   LNKFLAG=LNKFLAG&&LNKFLAG;       /* ZERO FLAG BYTE                */
         XC    LNKFLAG(1,@10),LNKFLAG(@10)                         1011
*   LNKVOLID=LNKVOLID&&LNKVOLID;    /* ZERO VOLUME ID                */
         XC    LNKVOLID(6,@10),LNKVOLID(@10)                       1012
*   GETPTR=GETPTR+DSNCTR+1;         /* POINT TO END OF NAME          */
         ALR   @10,DSNCTR                                          1013
         AH    @10,@CH00034                                        1013
         ST    @10,GETPTR                                          1013
*   DSNCTR=44-DSNCTR;               /* GET NUMBER OF CHARACTERS TO BE
*                                      PADDED WITH BLANKS            */
         LA    @10,44                                              1014
         SLR   @10,DSNCTR                                          1014
         LR    DSNCTR,@10                                          1014
*NP3IFPAD:                                                         1015
*   IF DSNCTR^=0                    /* ARE THERE ANY OF THE 44 CHARS
*                                      THAT NEED PADDING WITH BLANKS */
*     THEN                          /* YES - PAD REMAINING BYTES WITH
*                                      BLANKS                        */
NP3IFPAD LTR   DSNCTR,DSNCTR                                       1015
         BZ    @RF01015                                            1015
*     DO;                                                          1016
*       RESPECIFY                                                  1017
*         NP3SCAN5 BASED(GETPTR);                                  1017
*       NP3SCANR=' ';               /* BLANK BYTE                    */
         L     @10,GETPTR                                          1018
         MVI   NP3SCANR(@10),C' '                                  1018
*       GETPTR=GETPTR+1;            /* POINT TO NEXT BYTE            */
         AH    @10,@CH00034                                        1019
         ST    @10,GETPTR                                          1019
*       DSNCTR=DSNCTR-1;            /* DECREMENT COUNTER             */
         BCTR  DSNCTR,0                                            1020
*       GO TO NP3IFPAD;                                            1021
         B     NP3IFPAD                                            1021
*     END;                                                         1022
*   GETPTR=GETPTR+6;                /* UPDATE PTR TO NEXT WORKAREA 1023
*                                      ENTRY                         */
@RF01015 LA    @10,6                                               1023
         AL    @10,GETPTR                                          1023
         ST    @10,GETPTR                                          1023
*   IF GETAREA+2048-GETPTR<LENGTH(LNKNAME)/* IS THERE ENOUGH SPACE 1024
*                                      FOR ADDITION                  */
*     THEN                                                         1024
         LA    @09,2048                                            1024
         AL    @09,GETAREA                                         1024
         SLR   @09,@10                                             1024
         CH    @09,@CH02625                                        1024
         BL    @RT01024                                            1024
*     GO TO NP3LCTRN;               /* NO - TRUNCATE                 */
*   RESPECIFY                                                      1026
*     NP3SCAN5 BASED(SCANREG);                                     1026
*NP3LCNXT:                                                         1027
*   IF NP3SCANR^=','                /* IS CHAR A ','                 */
*     THEN                          /* NO - GO LIMIT NUMBER OF     1027
*                                      ENTRIES TO 15 1ST CHECK IF ALL
*                                      MEMBERS HAVE BEEN PROCESSED 1027
*                                      FOR I/O READ AT EOFF          */
NP3LCNXT CLI   NP3SCANR(SCANREG),C','                              1027
         BE    @RF01027                                            1027
*     DO;                           /*                         Y02754*/
*       NIPPARC=SIXTEEN;            /* SO INDICATE EOF HAS OCCURED 1029
*                                                              Y02754*/
         L     @10,NVTPAREA(,RNVT)                                 1029
         MVC   NIPPARC-NIPPAREA(4,@10),@CF00173                    @L01
*       GO TO NP3ENDFL;             /* GO TEST EOF             Y02754*/
         B     NP3ENDFL                                            1030
*     END;                          /*                         Y02754*/
*   SCANREG=SCANREG+1;              /* POINT TO NEXT CHAR            */
@RF01027 LA    SCANREG,1(,SCANREG)                                 1032
*   IF NP3SCANR=' '                 /* IS CHAR A BLANK               */
*     THEN                                                         1033
         CLI   NP3SCANR(SCANREG),C' '                              1033
         BE    @RT01033                                            1033
*     GO TO NP3LCTXT;               /* YES - END OF RECORD. GO READ
*                                      ANOTHER                       */
*   GO TO NP3LCDSN;                 /* NOT A BLANK - GO ANALYZE NEXT
*                                      NAME                          */
         B     NP3LCDSN                                            1035
*NP3LCTRN:                                                         1036
*   GETPTR=GETPTR-51;               /* POINT TO BEGINNING OF LAST  1036
*                                      NAME                          */
NP3LCTRN L     @10,GETPTR                                          1036
         SH    @10,@CH02625                                        1036
         ST    @10,GETPTR                                          1036
*   RESPECIFY                                                      1037
*     DSN BASED(MSG12APT);                                         1037
*   DSN=DSNAME;                     /* FILL IN DSN IN MSG            */
*                                                                  1038
         L     @09,MSG12APT                                        1038
         MVC   DSN(44,@09),DSNAME(@10)                             1038
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO LNKLST TRUNCATED AT DSN MSG                               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1039
*   GENERATE REFS(NVTWTO);                                         1039
          IEAPMNIP TYPE=WTO,PARAM=MESG12 CALL WTO SERVICE ROUTINE
*   GETPTR=GETPTR+51;               /* POINT TO END OF LAST ENTRY    */
         LA    @10,51                                              1040
         AL    @10,GETPTR                                          1040
         ST    @10,GETPTR                                          1040
*NP3LCNND:                                                         1041
*   SCANREG=GETAREA;                /* RESET SCAN PTR TO FIRST     1041
*                                      WORKAREA ENTRY                */
NP3LCNND L     SCANREG,GETAREA                                     1041
*   IF SCANREG=GETPTR               /* IF ENTRY PTR = FIRST WORKAREA
*                                      ENTRY, THEN THERE IS NO     1042
*                                      CONCATENATION                 */
*     THEN                                                         1042
         C     SCANREG,GETPTR                                      1042
         BE    @RT01042                                            1042
*     GO TO NP3LCEND;               /* THE WORKAREA CAN BE FREED     */
*                                                                  1043
*   /*****************************************************************/
*   /*                                                               */
*   /* LIMIT THE ACTIVE CONCATENATED DATASETS TO 15                  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1044
*   DSNCTR=0;                       /* INITIALIZE DSN CTR TO 0       */
         SLR   DSNCTR,DSNCTR                                       1044
*   RESPECIFY                                                      1045
*     LNKAREA BASED(LCNAMPTR);                                     1045
*   RESPECIFY                                                      1046
*     LNKNAME BASED(SCANREG);                                      1046
*NP3LCLOC:                                                         1047
*   LNKAREA=DSNAME;                 /* SET DSNAME FOR LOCATE REQ     */
*                                                                  1047
NP3LCLOC L     @10,LCNAMPTR                                        1047
         MVC   LNKAREA(44,@10),DSNAME(SCANREG)                     1047
*   /*****************************************************************/
*   /*                                                               */
*   /* ISSUE LOCATE AND FIND VOLID FOR DSNAME                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1048
*   GENERATE;                                                      1048
          LOCATE LOCLIB  ISSUE LOCATE FOR DATASET
*   IF LOCREG^=0                    /* IS RETURN CODE ZERO           */
*     THEN                          /* NO - INDICATE LOCATE WAS NOT
*                                      SUCCESFUL                     */
         LTR   LOCREG,LOCREG                                       1049
         BZ    @RF01049                                            1049
*     DO;                                                          1050
*       LNKFLAG='FF'X;              /* SET FLAG IN CURRENT WORK AREA
*                                      ENTRY TO ZERO                 */
         MVI   LNKFLAG(SCANREG),X'FF'                              1051
*       GO TO NP3LCLXT;             /* GO DO NEXT ENTRY              */
         B     NP3LCLXT                                            1052
*     END;                                                         1053
*   ELSE                            /* LOCATE WAS SUCCESSFUL         */
*     DO;                                                          1054
@RF01049 DS    0H                                                  1055
*       LNKVOLID=NP3VOLSR;          /* MOVE VOLID TO CURRENT WORKAREA
*                                      ENTRY                         */
         MVC   LNKVOLID(6,SCANREG),NP3VOLSR                        1055
*     END;                                                         1056
*NP3LCLXT:                                                         1057
*   SCANREG=SCANREG+LENGTH(LNKNAME);/* UPDATE SCAN PTR TO NEXT ENTRY */
NP3LCLXT LA    SCANREG,51(,SCANREG)                                1057
*   IF SCANREG^=GETPTR              /* HAVE ALL ENTRIES BEEN LOC     */
*     THEN                                                         1058
         C     SCANREG,GETPTR                                      1058
         BNE   @RT01058                                            1058
*     GO TO NP3LCLOC;               /* NO - LOCATE NEXT ENTRY        */
*   SCANREG=GETAREA;                /* RESET SCAN PTR TO FIRST     1060
*                                      WORKAREA ENTRY                */
         L     SCANREG,GETAREA                                     1060
*NP3LCVL1:                                                         1061
*   IF LNKFLAG='FF'X                /* WAS THIS ENTRY LOCATED        */
*     THEN                                                         1061
NP3LCVL1 CLI   LNKFLAG(SCANREG),X'FF'                              1061
         BE    @RT01061                                            1061
*     GO TO NP3LCVXT;               /* NO - TRY NEXT WORKAREA ENTRY  */
*   IF DSNCTR=15                    /* HAVE 15 ENTRIES BEEN PROCESSED*/
*     THEN                                                         1063
         CH    DSNCTR,@CH00210                                     1063
         BE    @RT01063                                            1063
*     GO TO NP3LCVFL;               /* YES - NULL FOLLOWING ENTRIES  */
*                                                                  1064
*   /*****************************************************************/
*   /*                                                               */
*   /* SET UP PARAMETERS FOR MOUNT REQUEST                           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1065
*   RESPECIFY                                                      1065
*     NIPMNTPL BASED(NP3LST06);                                    1065
*NP3LCVOL:                                                         1066
*   NMNTVS=LNKVOLID;                /* FILL IN VOLID                 */
NP3LCVOL L     @10,NP3LST06                                        1066
         MVC   NMNTVS(6,@10),LNKVOLID(SCANREG)                     1066
*   NMNTDSA=SCANREG+1;              /* FILL IN DATA SET NAME PTR     */
*                                                                  1067
         LA    @09,1                                               1067
         ALR   @09,SCANREG                                         1067
         ST    @09,NMNTDSA(,@10)                                   1067
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO BRANCH TO NIPMOUNT (CONDITIONAL)              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1068
*   GENERATE REFS(NVTMOUNT) SETS(RPARM,REXIT,RENTRY);              1068
          IEAPMNIP TYPE=MOUNT,PARAM=PLIST06,OPT=(,LC,LI)
*   UCBPTR=RPARM;                   /* SET UCB BASE TO CURRENT UCB   */
         ST    RPARM,UCBPTR                                        1069
*   IF UCBPTR=0                     /* WAS REQUEST CANCELLED         */
*     THEN                                                         1070
         L     @10,UCBPTR                                          1070
         LTR   @10,@10                                             1070
         BZ    @RT01070                                            1070
*     GO TO NP3LCCAN;               /* YES - SCAN REMAINDER OF     1071
*                                      ENTRIES FOR THIS VOLID        */
*                                                                  1071
*   /*****************************************************************/
*   /*                                                               */
*   /* SET UP PARAMETERS FOR OPEN REQUEST                            */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1072
*   RESPECIFY                                                      1072
*     NIPOPNPL BASED(NP3LST07);                                    1072
*   NOPNDCB=CVTLINK;                /* GET ADDR OF DCB FROM CVT      */
         L     @09,NP3LST07                                        1073
         MVC   NOPNDCB(4,@09),CVTLINK(CVTPTR)                      1073
*   NOPNDSA=SCANREG+1;              /* FILL IN DATASET NAME PTR      */
         LA    @07,1                                               1074
         ALR   @07,SCANREG                                         1074
         ST    @07,NOPNDSA(,@09)                                   1074
*   NOPNUCB=UCBPTR;                 /* FILL IN UCB ADDR              */
*                                                                  1075
         ST    @10,NOPNUCB(,@09)                                   1075
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO BRANCH TO NIPOPEN (CONDITIONAL)               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1076
*   GENERATE REFS(NVTOPEN) SETS(RPARM,REXIT,RENTRY,NOPNFL);        1076
        IEAPMNIP TYPE=OPEN,PARAM=PLIST07,OPT=(,LB,LC,,,LI,,RS) @ZA01561
*   IF RPRM1<0                      /* DID OPEN FAIL                 */
*     THEN                          /* YES - SET NULL FLAG IN CURRENT
*                                      ENTRY TO X'FF'                */
         LTR   RPRM1,RPRM1                                         1077
         BNM   @RF01077                                            1077
*     DO;                                                          1078
*NP3LCVFL:                                                         1079
*       LNKFLAG='FF'X;                                             1079
NP3LCVFL MVI   LNKFLAG(SCANREG),X'FF'                              1079
*       GO TO NP3LCVXT;             /* TRY NEXT ENTRY                */
         B     NP3LCVXT                                            1080
*     END;                                                         1081
*   DSNCTR=DSNCTR+1;                /* INCREMENT ENTRY COUNTER       */
@RF01077 LA    @10,1                                               1082
         ALR   DSNCTR,@10                                          1082
*   UCBUSER=UCBUSER+1;              /* INCREMENT USE COUNT   @ZA02591*/
         L     @09,UCBPTR                                          1083
         SLR   @07,@07                                             1083
         IC    @07,UCBUSER(,@09)                                   1083
         ALR   @10,@07                                             1083
         STC   @10,UCBUSER(,@09)                                   1083
*   GO TO NP3LCVXT;                 /* TRY NEXT ENTRY                */
*                                                                  1084
         B     NP3LCVXT                                            1084
*   /*****************************************************************/
*   /*                                                               */
*   /* SCAN REMAINING ENTRIES FOR THE NON-LOCATABLE VOLID AND NULL   */
*   /* (X'FF') THE ONES FOUND                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1085
*NP3LCCAN:                                                         1085
*   SAVESCAN=SCANREG;               /* SAVE CURRENT ENTRY ADDR       */
NP3LCCAN ST    SCANREG,SAVESCAN                                    1085
*NP3IFLOC:                                                         1086
*   IF LNKVOLID=NMNTVS              /* DOES THIS ENTRY HAVE        1086
*                                      NON-LOCATABLE VOLID           */
*     THEN                                                         1086
NP3IFLOC L     @10,NP3LST06                                        1086
         CLC   LNKVOLID(6,SCANREG),NMNTVS(@10)                     1086
         BNE   @RF01086                                            1086
*     LNKFLAG='FF'X;                /* YES - NULL ENTRY              */
         MVI   LNKFLAG(SCANREG),X'FF'                              1087
*   SCANREG=SCANREG+LENGTH(LNKNAME);/* POINT TO NEXT ENTR            */
@RF01086 LA    SCANREG,51(,SCANREG)                                1088
*   IF SCANREG=GETPTR               /* IS THIS THE END OF THE ENTRIES*/
*     THEN                          /* YES - GO BACK TO NEXT ENTRY TO
*                                      BE LOCATED                    */
         C     SCANREG,GETPTR                                      1089
         BNE   @RF01089                                            1089
*     DO;                                                          1090
*       SCANREG=SAVESCAN;           /* RESET SCAN PTR TO LAST LOCATED
*                                      ENTRY                         */
         L     SCANREG,SAVESCAN                                    1091
*       GO TO NP3LCVXT;                                            1092
         B     NP3LCVXT                                            1092
*     END;                                                         1093
*   GO TO NP3IFLOC;                 /* CHECK VOLID OF NEXT ENTRY     */
         B     NP3IFLOC                                            1094
*NP3LCVXT:                                                         1095
*   SCANREG=SCANREG+LENGTH(LNKNAME);/* POINT TO NEXT ENTRY           */
NP3LCVXT LA    SCANREG,51(,SCANREG)                                1095
*   IF SCANREG^=GETPTR              /* ARE THERE ANY MORE ENTRIES    */
*     THEN                                                         1096
         C     SCANREG,GETPTR                                      1096
         BNE   @RT01096                                            1096
*     GO TO NP3LCVL1;               /* YES - PROCESS REST            */
*NP3LCVND:                                                         1098
*   SCANREG=GETAREA;                /* RESET SCAN PTR TO BEGINNING OF
*                                      WORKAREA                      */
NP3LCVND L     SCANREG,GETAREA                                     1098
*NP3LCMCK:                                                         1099
*   IF LNKFLAG^='FF'X               /* IS THIS ENTRY NULL            */
*     THEN                                                         1099
NP3LCMCK CLI   LNKFLAG(SCANREG),X'FF'                              1099
         BNE   @RT01099                                            1099
*     GO TO NP3LCMXT;               /* NO - CHECK NEXT ENTRY         */
*   IF NP3HDMSG='1'B                /* HAS HEADER BEEN ISSUED        */
*     THEN                                                         1101
         TM    NP3HDMSG,B'10000000'                                1101
         BO    @RT01101                                            1101
*     GO TO NP3LCMNH;               /* YES - DO NOT PRINT HEADER     */
*                                                                  1102
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO HEADER MESSAGE THAT FOLLOWING LINKLIB DATASETS WERE NOT   */
*   /* FOUND                                                         */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1103
*   GENERATE REFS(NVTWTO);                                         1103
          IEAPMNIP TYPE=WTO,PARAM=MESG13 ISSUE WTO SERVICE ROUTINE
*   NP3HDMSG='1'B;                  /* INDICATE HEADER MESSAGE HAS 1104
*                                      BEEN ISSUED                   */
         OI    NP3HDMSG,B'10000000'                                1104
*   RESPECIFY                                                      1105
*     DSN BASED(MSG14APT);                                         1105
*NP3LCMNH:                                                         1106
*   DSN=DSNAME;                     /* FILL IN DATASET NAME          */
*                                                                  1106
NP3LCMNH L     @10,MSG14APT                                        1106
         MVC   DSN(44,@10),DSNAME(SCANREG)                         1106
*   /*****************************************************************/
*   /*                                                               */
*   /* LIST MISSING DATA SET NAME                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1107
*   GENERATE REFS(NVTWTO);                                         1107
          IEAPMNIP TYPE=WTO,PARAM=MESG14 ISSUE WTO SERVICE ROUTINE
*NP3LCMXT:                                                         1108
*   SCANREG=SCANREG+LENGTH(LNKNAME);/* POINT TO NEXT ENTRY           */
NP3LCMXT LA    SCANREG,51(,SCANREG)                                1108
*   IF SCANREG^=GETPTR              /* ARE THERE MORE ENTRIES        */
*     THEN                                                         1109
         C     SCANREG,GETPTR                                      1109
         BNE   @RT01109                                            1109
*     GO TO NP3LCMCK;               /* YES - PRINT THEM OUT          */
*                                                                  1110
*   /*****************************************************************/
*   /*                                                               */
*   /* FREE 2K LNKLST WORKAREA FROM SP0                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1111
*   GENERATE DEFS(NP3LCEND);                                       1111
NP3LCEND  FREEMAIN E,LV=2048,A=GETAREA
*   GO TO NP3LCXIT;                 /* RETURN TO CALLER              */
*                                                                  1112
         B     NP3LCXIT                                            1112
*   /*****************************************************************/
*   /*                                                               */
*   /* FREE 2K LNKLST TEXT WORKAREA FROM SUBPOOL 0                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1113
*   GENERATE DEFS(NP3LCTFL);                                       1113
*                                                                  1113
NP3LCTFL  FREEMAIN E,LV=2048,A=GETAREA
*   /*****************************************************************/
*   /*                                                               */
*   /* TELL THE OPERATOR THE LNKLST FUNCTION IS INOPERATIVE          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1114
*NP3LCMFL:                                                         1114
*   LKNAME=LNKLSTNM;                /* FILL IN 'LNKLST00' NAME       */
NP3LCMFL MVC   LKNAME(6),LNKLSTNM                                  1114
*   GENERATE REFS(NVTWTO);                                         1115
         IEAPMNIP TYPE=WTO,PARAM=MESG11 ISSUE WTO SERVICE ROUTINE
*NP3LCXIT:                                                         1116
*   GO TO NP3RTAD0;                 /* RETURN TO CALLER              */
*                                                                  1116
NP3LCXIT L     @10,NP3RTADR                                        1116
         BR    @10                                                 1116
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO GETMAIN FAILED DURING INITIALIZATION                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1117
*   GENERATE REFS(NVTWTO) DEFS(NP3SW38);                           1117
NP3SW38  DS    0F
         IEAPMNIP TYPE=WTO,PARAM=MESG05 CALL WTO SERVICE ROUTINE
*   NVTFLWSC=NVTWCN01;              /* SET WAIT STATE CODE IN NVT /*
*                                                              Y02752*/
*                                                                  1118
         MVI   NVTFLWSC(RNVT),X'63'                                1118
*   /*****************************************************************/
*   /*                                                               */
*   /* MACRO BRANCH INTERFACE TO NIPSWAIT SERVICE ROUTINE IN IEAVNIPM*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1119
*   GENERATE REFS(NVTSWAIT);                                       1119
          IEAPMNIP TYPE=SWAIT   CALL WAIT SERVICE ROUTINE
*   RESPECIFY                                                      1120
*     INDEXREG UNRESTRICTED;                                       1120
*   RESPECIFY                                                      1121
*     DSNCTR UNRESTRICTED;                                         1121
*                                                                  1122
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SUBROUTINE (NP3SCAN) SCANS THE SYSTEM PARAMETERS FOR     */
*   /* VALIDITY. AFTER VERIFYING ONE LINE OF PARAMETERS,IT BRANCHES  */
*   /* BACK TO ITS CALLER AT: +0 FOR VALID PARAMETER AND SUBPARAMETER*/
*   /* OF PARAMETER +4 FOR INVALID PARAMETER OR SUBPARAMETER OF      */
*   /* PARAMETER +8 FOR CONTINUATION OF PARAMETERS OR SUBPARAMETERS  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1122
*   RESPECIFY                                                      1122
*     SYMBLREG RESTRICTED;          /* BASE ADDRESS OF SYMBOL TABLE
*                                      FOR MAPPING                   */
*   RESPECIFY                                                      1123
*     OFFSTREG RESTRICTED;          /* CONTAINS OFFSET INTO SYMBOL 1123
*                                      TABLE FOR PARAMETER VALIDATION*/
*   RESPECIFY                                                      1124
*     NP3SCAN5 BASED(SCANREG);                                     1124
*   RESPECIFY                                                      1125
*     OPLIBENT BASED(NP3CENT);                                     1125
*NP3SCAN:                                                          1126
*   NP3RTRN=REXIT;                  /* SAVE RETURN ADDRESS OF CALLER */
NP3SCAN  ST    REXIT,NP3RTRN                                       1126
*NP3SCNXT:                                                         1127
*   SCANREG=NP3NCHAR;               /* SET BASE ADDRESS FOR MAPPING
*                                      INTO PARAMETER CHARACTER    1127
*                                                              STRING*/
*                                                                  1127
NP3SCNXT L     SCANREG,NP3NCHAR                                    1127
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK TO IF CURRENT CHARACTER IS BLANK OR COMMA. IF YES       */
*   /* ,UPDATE TO NEXT CHARACTER IN PARAMETER STRING AND REPEAT      */
*   /* CHARACTER CHECK.                                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1128
*NP3PCHAR:                                                         1128
*   IF NP3SCANR=NP3BLANK            /* IS THIS A BLANK CHARACTER OR  */
*       WNP3SCANR=NP3COMMA          /* A COMMA CHARACTER             */
*     THEN                          /* YES,IT IS A BLANK OR A COMMA  */
NP3PCHAR CLC   NP3SCANR(1,SCANREG),NP3BLANK                        1128
         BE    @RT01128                                            1128
         CLC   NP3SCANR(1,SCANREG),NP3COMMA                        1128
         BNE   @RF01128                                            1128
@RT01128 DS    0H                                                  1129
*     DO;                                                          1129
*       SCANREG=1+SCANREG;          /* UPDATE TO NEXT CHARACTER      */
         LA    SCANREG,1(,SCANREG)                                 1130
*       GO TO NP3PCHAR;             /* GO BACK TO CHARACTER CHECK    */
         B     NP3PCHAR                                            1131
*     END;                                                         1132
*   ELSE                                                           1133
*     ;                             /* NO, IT IS NOT A BLANK OR A  1133
*                                      COMMA,FALL THROUGH            */
*                                                                  1133
@RF01128 DS    0H                                                  1134
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK TO SEE IF CONTINUE SUBPARAMETER SWITCH IS ON.IF YES,THEN*/
*   /* BRANCH TO SETUP FOR CONTINUATION OF SUBPARAMETERS FROM        */
*   /* PREVIOUS LINE OF SYSTEM PARAMETERS                            */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1134
*   IF NP3CONT='1'B                 /* IS CONTINUE PARAMETER FLAG ON */
*     THEN                          /* YES,IT IS ON                  */
         TM    NP3CONT,B'10000000'                                 1134
         BO    @RT01134                                            1134
*     GO TO NP3CHNDL;               /* BRANCH TO CONTINUE          1135
*                                      SUBPARAMETER BALANCING CHECK
*                                      SETUP                         */
*   ELSE                            /* NO,CONTINUE PARAMETER FLAG NOT
*                                      ON                            */
*     DO;                                                          1136
*       NP3CCHAR=SCANREG;           /* SET CURRENT CHARACTER POINTER
*                                      TO ADDRESS OF SCANNED       1137
*                                      CHARACTER                     */
         ST    SCANREG,NP3CCHAR                                    1137
*     END;                                                         1138
*                                                                  1138
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK FOR END OF CURRENT LINE OF PARAMETER CHARACTER          */
*   /* STRING.LOOKS FOR A QUOTE.                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1139
*   IF NP3SCANR=NP3QUOTE            /* IS THIS END OF LINE           */
*     THEN                          /* YES,IT IS END OF LINE         */
         CLC   NP3SCANR(1,SCANREG),NP3QUOTE                        1139
         BNE   @RF01139                                            1139
*     DO;                                                          1140
*       IF OPSPCONT^='00000000000000000000000000000000'X/* IS 'CONT'
*                                      SPECIFIED                     */
*         THEN                      /* YES- RESET 'CONT' PARM ENTRY
*                                      TO ZERO                       */
         L     @10,NP3CTAB                                         1141
         CLC   OPSPCONT(16,@10),@CB02424                           1141
         BE    @RF01141                                            1141
*         DO;                                                      1142
*NP3SCCNT:                                                         1143
*           OPSPCONT=OPSPCONT&&OPSPCONT;/*                     Y02752*/
*                                                                  1143
NP3SCCNT L     @10,NP3CTAB                                         1143
         XC    OPSPCONT(16,@10),OPSPCONT(@10)                      1143
*           /*********************************************************/
*           /*                                                       */
*           /* RETURN TO IEAVNPA3 CALL SEQUENCE IF IN NIP PROMPT MODE*/
*           /*                                                 Y02752*/
*           /*                                                       */
*           /*********************************************************/
*                                                                  1144
*           IF NVTSYSP='1'B         /*                         Y02752*/
*             THEN                  /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           1144
         BNO   @RF01144                                            1144
*             DO;                   /*                         Y02752*/
*               RETCODE=8;          /* CONTINUATION FOUND      Y02752*/
         MVC   RETCODE(4),@CF00156                                 1146
*               GO TO NPRMRTN1;     /* RETURN TO IEAVNPA3 CALL     1147
*                                      SEQUENCE                Y02752*/
         L     @10,NPRMRTN1                                        1147
         BR    @10                                                 1147
*             END;                  /*                         Y02752
*                                                              Y02752*/
*           GO TO NP3RTRN8;         /* CONTINUED PARAM EXIT          */
@RF01144 L     @10,NP3RTRN                                         1149
         LA    @10,NP3RTRN8(,@10)                                  1149
         BR    @10                                                 1149
*         END;                                                     1150
*       ELSE                                                       1151
*NP3SCLST:                                                         1151
*         DO;                       /*                         Y02752
*                                                              Y02752*/
*                                                                  1151
@RF01141 DS    0H                                                  1151
NP3SCLST DS    0H                                                  1152
*           /*********************************************************/
*           /*                                                       */
*           /* RETURN TO IEAVNPA3 CALL SEQUENCE IF IN NIP PROMPT MODE*/
*           /*                                                 Y02752*/
*           /*                                                       */
*           /*********************************************************/
*                                                                  1152
*           IF NVTSYSP='1'B         /*                         Y02752*/
*             THEN                  /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           1152
         BNO   @RF01152                                            1152
*             DO;                   /*                         Y02752*/
*               RETCODE=0;          /* VALID REPLY             Y02752*/
         SLR   @10,@10                                             1154
         ST    @10,RETCODE                                         1154
*               GO TO NPRMRTN1;     /* RETURN TO IEAVNPA3 CALL     1155
*                                      SEQUENCE                Y02752*/
         L     @10,NPRMRTN1                                        1155
         BR    @10                                                 1155
*             END;                  /*                         Y02752*/
*           GO TO NP3RTRN0;         /* NORMAL RETURN           Y02752*/
@RF01152 L     @10,NP3RTRN                                         1157
         BR    @10                                                 1157
*         END;                      /*                         Y02752*/
*     END;                          /*                         Y02752
*                                                              Y02752*/
*                                                                  1159
*   /*****************************************************************/
*   /*                                                               */
*   /* RETURN TO IEAVNPA3 CALL SEQUENCE IF IN NIP PROMPT MODE  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1160
*   IF NVTSYSP='1'B                 /*                         Y02752*/
*     THEN                          /*                         Y02752*/
@RF01139 TM    NVTSYSP(RNVT),B'01000000'                           1160
         BNO   @RF01160                                            1160
*     DO;                           /*                         Y02752*/
*       RETCODE=4;                  /* EXTRANEOUS INFO FOUND   Y02752*/
         MVC   RETCODE(4),@CF00371                                 1162
*       GO TO NPRMRTN1;             /* RETURN TO IEAVNPA3 CALL     1163
*                                      SEQUENCE                Y02752*/
         L     @10,NPRMRTN1                                        1163
         BR    @10                                                 1163
*     END;                          /*                         Y02752
*                                                              Y02752*/
*   CALL NP3MATCH;                  /* SCAN FOR MATCH IN SYMBOL TABLE
*                                                              Y02752*/
@RF01160 BAL   @14,NP3MATCH                                        1165
*   IF RENTRY=0                     /* RETURN CODE ZERO ON MATCH   1166
*                                                              Y02752*/
*     THEN                                                         1166
         LTR   RENTRY,RENTRY                                       1166
         BZ    @RT01166                                            1166
*     GO TO NP3EQUSB;               /* BRANCH TO PARMTAB ADDRESS MARK
*                                                              Y02752*/
*   ELSE                            /* INVALID PARM            Y02752*/
*     CAUSE04=UNDKEY;               /* FILL IN 'UNDEFINED KEYWORD' AS
*                                      CAUSE                   Y02752*/
*                                                                  1168
         MVC   CAUSE04(20),UNDKEY                                  1168
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO INVALID PARAMETER SYNTAX MESSAGE                          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1169
*NP3SCINV:                                                         1169
*   CALL NP3PINV;                                                  1169
*                                                                  1169
NP3SCINV BAL   @14,NP3PINV                                         1169
*   /*****************************************************************/
*   /*                                                               */
*   /* RETURN TO IEAVNPA3 CALL SEQUENCE IF IN NIP PROMPT MODE  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1170
*   IF NVTSYSP='1'B                 /*                         Y02752*/
*     THEN                          /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           1170
         BNO   @RF01170                                            1170
*     DO;                           /*                         Y02752*/
*       RETCODE=12;                 /* INDICATE ERROR MSG ISSUED   1172
*                                                              Y02752*/
         MVC   RETCODE(4),@CF00036                                 1172
*       GO TO NPRMRTN1;             /* RETURN TO CALLER        Y02752*/
         L     @10,NPRMRTN1                                        1173
         BR    @10                                                 1173
*     END;                          /*                         Y02752
*                                                              Y02752*/
*NP3SCRNV:                                                         1175
*   NP3CONT='0'B;                   /* RESET CONT PARM SWITCH=0    1175
*                                                              Y02752*/
@RF01170 DS    0H                                                  1175
NP3SCRNV NI    NP3CONT,B'01111111'                                 1175
*   OPSPCONT=OPSPCONT&&OPSPCONT;    /* RESET 'CONT' ENTRY TO ZERO  1176
*                                                              Y02752
*                                                              Y02752*/
*                                                                  1176
         L     @10,NP3CTAB                                         1176
         XC    OPSPCONT(16,@10),OPSPCONT(@10)                      1176
*   /*****************************************************************/
*   /*                                                               */
*   /* RETURN TO IEAVNPA3 CALL SEQUENCE IF IN NIP PROMPT MODE  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1177
*   IF NVTSYSP='1'B                 /*                         Y02752*/
*     THEN                          /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           1177
         BNO   @RF01177                                            1177
*     DO;                           /*                         Y02752*/
*       RETCODE=4;                  /* EXTRANEOUS INFO FOUND   Y02752*/
         MVC   RETCODE(4),@CF00371                                 1179
*       GO TO NPRMRTN1;             /* RETURN TO IEAVNPA3 CALL     1180
*                                      SEQUENCE                Y02752*/
         L     @10,NPRMRTN1                                        1180
         BR    @10                                                 1180
*     END;                          /*                         Y02752
*                                                              Y02752*/
*   GO TO NP3RTRN4;                 /* RETURN TO CALLER AT + 4     1182
*                                      INVALID PARAMETER RETURN      */
*                                                                  1182
@RF01177 L     @10,NP3RTRN                                         1182
         LA    @10,NP3RTRN4(,@10)                                  1182
         BR    @10                                                 1182
*   /*****************************************************************/
*   /*                                                               */
*   /* PARAMETER SYMBOL AND SYMBOL IN SYMBOL TABLE ARE EQUAL. CHECK  */
*   /* SYMBOL FOR "=" SIGN,WHICH IMPLIES PARAMETER HAS SUBPARAMETERS */
*   /* ASSOCIATED WITH IT.                                           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1183
*                                   /*                         Y02752*/
*NPEQCK:                            /* IEAVNPA3 SUBROUTINE ENTRY   1183
*                                      POINT                   Y02752*/
*   NPRMRTN1=REXIT;                 /* SAVE RETURN ADDR        Y02752*/
NPEQCK   ST    REXIT,NPRMRTN1                                      1183
*NP3EQUSB:                                                         1184
*   NP3EQADR=SYMBLREG+(SLN-1);      /* LOCATE "=" SIGN               */
*                                                                  1184
NP3EQUSB SLR   @10,@10                                             1184
         IC    @10,SLN                                             1184
         LR    @05,@10                                             1184
         BCTR  @05,0                                               1184
         ALR   @05,SYMBLREG                                        1184
         ST    @05,NP3EQADR                                        1184
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECKS TO SEE IF THIS PARAMETER HAS SUBPARAMETERS             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1185
*   IF NP3SUBSP=NP3EQUAL            /* DOES PARAMETER HAVE "=" SIGN  */
*     THEN                          /* YES, SUBPARAMETERS ASSOCIATED
*                                      WITH THIS PARAMETER           */
         CLC   NP3SUBSP(1,@05),NP3EQUAL                            1185
         BE    @RT01185                                            1185
*     GO TO NP3BALN;                /* BRANCH TO SUBPARAMETER BALANCE
*                                      CHECK SETUP                   */
*   ELSE                            /* NO,SUBPARAMETERS NOT        1187
*                                      ASSOCIATED WITH THIS PARAMETER*/
*     DO;                                                          1187
*       NP3EQADR=SCANREG+SLN;       /* UPDATE MAPPING BASE ADDRESS TO
*                                      POINT TO PARAMETER SYMBOL IN
*                                      CHARACTER STRING              */
         ALR   @10,SCANREG                                         1188
         ST    @10,NP3EQADR                                        1188
*       GO TO NP3NBALN;             /* BRANCH TO KEYWORD ENDING CHECK*/
         B     NP3NBALN                                            1189
*     END;                                                         1190
*                                                                  1190
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SETS UP FOR ENTRY INTO NP3NXSYM FOR CHECKING THE         */
*   /* BALANCING OF THE SUBPARAMETERS AND TO SET THE POSITION OF THE */
*   /* NEXT PARAMETER IN THE CURRENT CHARACTER STRING                */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1191
*NP3BALN:                                                          1191
*   SCANREG=NP3CCHAR+SLN;           /* SET MAPPING BASE ADDRESS TO 1191
*                                      SUBPARAMETERS                 */
NP3BALN  SLR   SCANREG,SCANREG                                     1191
         IC    SCANREG,SLN                                         1191
         AL    SCANREG,NP3CCHAR                                    1191
*   CALL NP3NXSYM;                  /* BRANCH TO BALANCING CHECK     */
*                                                                  1192
         BAL   @14,NP3NXSYM                                        1192
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS IS A GENERATED BRANCH TABLE FOR RETURN FROM NP3NXSYM.    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1193
*   GENERATE FLOWS(NP3ENTER,NP3SCRNV,NP3SCCNT) NOSEQFLOW;          1193
*                                                                  1193
         B     NP3ENTER            VALID SUBPARAMETERS BRANCH RETURN
         B     NP3SCRNV            INVALID SUBPARAMETERS BRANCH RETURN
         B     NP3SCCNT
*   /*****************************************************************/
*   /*                                                               */
*   /* CALCULATE THE ADDRESS OF ENTRY IN PARMTAB FOR THIS VALID      */
*   /* PARAMETER AND SET BASE                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1194
*NP3ENTER:                                                         1194
*   NP3CENT=NP3CTAB+(INDXELMT*LENGTH(OPLIBENT));                   1194
NP3ENTER SLR   @10,@10                                             1194
         IC    @10,INDXELMT                                        1194
         SLA   @10,4                                               1194
         AL    @10,NP3CTAB                                         1194
         ST    @10,NP3CENT                                         1194
*   ORAD=NP3CCHAR+SLN;              /* SET ADDRESS OF SUBPARAMETERS
*                                      IN PARMTAB ENTRY              */
         SLR   @05,@05                                             1195
         IC    @05,SLN                                             1195
         AL    @05,NP3CCHAR                                        1195
         ST    @05,ORAD(,@10)                                      1195
*   CONTAD=CONTAD&&CONTAD;          /* ZERO CONTINUE ADDRESS         */
         L     @15,CONTAD(,@10)                                    1196
         LR    @14,@15                                             1196
         XR    @14,@15                                             1196
         ST    @14,CONTAD(,@10)                                    1196
*   ORLN=NP3NCHAR-ORAD;             /* SET PARM LENGTH FOR THIS ENTRY*/
         LCR   @05,@05                                             1197
         AL    @05,NP3NCHAR                                        1197
         STH   @05,ORLN(,@10)                                      1197
*   CONTLN=CONTLN&&CONTLN;          /* ZERO CONTINUE LENGTH          */
         XC    CONTLN(2,@10),CONTLN(@10)                           1198
*NP3SCTID:                                                         1199
*   INSRCID=NP3INID;                /* SET INPUT SOURCE ID           */
NP3SCTID L     @10,NP3CENT                                         1199
         MVC   INSRCID(2,@10),NP3INID                              1199
*   OPFLAG=CUROPT;                  /* SET OPTION FLAGS IN ENTRY TO
*                                      CURRENT OPTION FLAGS          */
         MVC   OPFLAG(1,@10),CUROPT                                1200
*   CUROPT='00'X;                   /* TURN CURRENT OPTION FLAGS OFF */
         MVI   CUROPT,X'00'                                        1201
*   GO TO NP3SCNXT;                 /* SCAN NEXT PARM                */
*                                                                  1202
         B     NP3SCNXT                                            1202
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS CHECKS TO SEE THAT A PARAMETER WHICH HAS NO ASSOCIATED   */
*   /* SUBPARAMETERS IS TERMINATED CORRECTLY.                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1203
*NP3NBALN:                                                         1203
*   IF NP3SUBSP=NP3BLANK            /* IS CHARACTER A BLANK          */
*       WNP3SUBSP=NP3COMMA          /* IS CHARACTER A COMMA          */
*       WNP3SUBSP=NP3QUOTE          /* IS CHARACTER A QUOTE          */
*     THEN                          /* IT IS ONE OF THEM,PARAMETER IS
*                                      VALID                         */
NP3NBALN L     @10,NP3EQADR                                        1203
         CLC   NP3SUBSP(1,@10),NP3BLANK                            1203
         BE    @RT01203                                            1203
         CLC   NP3SUBSP(1,@10),NP3COMMA                            1203
         BE    @RT01203                                            1203
         CLC   NP3SUBSP(1,@10),NP3QUOTE                            1203
         BNE   @RF01203                                            1203
@RT01203 DS    0H                                                  1204
*     DO;                                                          1204
*       NP3NCHAR=NP3CCHAR+SLN;      /* UPDATE POINTER TO NEXT      1205
*                                      PARAMETER CHARACTER           */
         SLR   @10,@10                                             1205
         IC    @10,SLN                                             1205
         AL    @10,NP3CCHAR                                        1205
         ST    @10,NP3NCHAR                                        1205
*       GO TO NP3ENTER;             /* BRANCH TO PARMTAB ADDRESS MARK*/
         B     NP3ENTER                                            1206
*     END;                                                         1207
*   ELSE                            /* NOT A VALID PARAMETER         */
*     DO;                                                          1208
@RF01203 DS    0H                                                  1209
*       CAUSE04=IMPDEL;             /* SET CAUSE IN INVALID SYNTAX 1209
*                                      MESSAGE                       */
         MVC   CAUSE04(20),IMPDEL                                  1209
*       GO TO NP3SCINV;                                            1210
         B     NP3SCINV                                            1210
*     END;                                                         1211
*                                                                  1211
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SUBROUTINE IS ENTERED WHEN A CONTINUATION OF             */
*   /* SUBPARAMETERS HAS BEEN RECOGNIZED BY NP3SCAN.                 */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1212
*NP3CHNDL:                                                         1212
*   NP3CONT='0'B;                   /* RESET CONTINUE SUBPARAMETERS
*                                      FLAG TO OFF STATUS            */
NP3CHNDL NI    NP3CONT,B'01111111'                                 1212
*   NP3BALCK=SCANREG;               /* SAVE POINTER TO CONTINUED   1213
*                                      SUBPARAMETERS                 */
         ST    SCANREG,NP3BALCK                                    1213
*   CALL NP3CTSYM;                  /* BRANCH TO BALANCE CHECK     1214
*                                      ROUTINE AT ITS CONTINUATION 1214
*                                      ENTRY POINT                   */
*                                                                  1214
         BAL   @14,NP3CTSYM                                        1214
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS IS A GENERATED BRANCH TABLE FOR THE RETURN BRANCH FROM   */
*   /* NP3NXSYM.                                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1215
*   GENERATE FLOWS(NP3CHNTR,NP3SCRNV,NP3NGCNT) NOSEQFLOW;          1215
         B     NP3CHNTR            VALID SUBPARAMETER BRANCH ENTRY
         B     NP3SCRNV            INVALID SUBPARAMETER BRANCH ENTRY
         B     NP3NGCNT
*NP3NGCNT:                                                         1216
*   CAUSE04=INVCON;                 /* MOVE CAUSE INTO INVALID SYNTAX
*                                      MESSAGE                       */
NP3NGCNT MVC   CAUSE04(20),INVCON                                  1216
*   GO TO NP3SCINV;                 /* GIVE MESSAGE                  */
*                                                                  1217
         B     NP3SCINV                                            1217
*   /*****************************************************************/
*   /*                                                               */
*   /* CALCULATE THE ADDRESS OF ENTRY IN PARMTAB FOR THIS VALID      */
*   /* PARAMETER                                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1218
*NP3CHNTR:                                                         1218
*   NP3CENT=NP3CTAB+(INDXELMT*LENGTH(OPLIBENT));                   1218
NP3CHNTR SLR   @10,@10                                             1218
         IC    @10,INDXELMT                                        1218
         SLA   @10,4                                               1218
         AL    @10,NP3CTAB                                         1218
         ST    @10,NP3CENT                                         1218
*   CONTAD=NP3BALCK;                /* SET ADDRESS OF CONTINUED    1219
*                                      SUBPARAMETERS                 */
         L     @05,NP3BALCK                                        1219
         ST    @05,CONTAD(,@10)                                    1219
*   ORAD=NP3CCHAR+SLN;              /* SET ADDRESS OF BEGINNING OF 1220
*                                      SUBPARAMETERS                 */
         SLR   @15,@15                                             1220
         IC    @15,SLN                                             1220
         AL    @15,NP3CCHAR                                        1220
         ST    @15,ORAD(,@10)                                      1220
*   CONTLN=NP3NCHAR-CONTAD;         /* SET CONT PARM LENGTH          */
         LCR   @05,@05                                             1221
         AL    @05,NP3NCHAR                                        1221
         STH   @05,CONTLN(,@10)                                    1221
*   ORLN=PRENDPTR-ORAD;             /* SET PARM LENGTH               */
         LCR   @15,@15                                             1222
         AL    @15,PRENDPTR                                        1222
         STH   @15,ORLN(,@10)                                      1222
*   GO TO NP3SCTID;                                                1223
         B     NP3SCTID                                            1223
*                                                                  1224
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SUBROUTINE VERIFIES THE BALANCING OF SYNTACTICAL         */
*   /* CHARACTERS ASSOCIATED WITH SUBPARAMETERS. IT ALSO CHECKS FOR  */
*   /* AN OPERATES ON THE "CONT" SUBPARAMETERS OPTION.IT SECOND      */
*   /* OBJECTIVE IS TO LOCATE THE NEXT CHARACTER FOLLOWING THE       */
*   /* COMPLETED SUBPARAMETERS AND PLACE ITS ADDRESS IN THE NEXT     */
*   /* CHARACTER POINTER. THE NEXT CHARACTER POINTER IS USED BY      */
*   /* NP3SCAN AS THE POSITION IN THE CHARACTER STRING TO BEGIN      */
*   /* SCANNING FOR THE NEXT SYSTEM PARAMETER TO VERIFY.             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1224
*   RESPECIFY                                                      1224
*     NP3SCAN5 BASED(SCANREG);                                     1224
*                                                                  1224
*   /*****************************************************************/
*   /*                                                               */
*   /* ENTRY FOR CONTINUED PARAMETERS                                */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1225
*NP3CTSYM:                                                         1225
*   NP3SRTRN=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
*                                                                  1225
NP3CTSYM ST    REXIT,NP3SRTRN                                      1225
*   /*****************************************************************/
*   /*                                                               */
*   /* TEST FOR IMBEDDED PARM OPTION                                 */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1226
*   CALL NP3POPT;                                                  1226
         BAL   @14,NP3POPT                                         1226
*   GO TO NP3PCHCK;                                                1227
         B     NP3PCHCK                                            1227
*NP3NXSYM:                                                         1228
*   NP3SRTRN=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
NP3NXSYM ST    REXIT,NP3SRTRN                                      1228
*   NP3PAREN=0;                     /* SET PARENTHESIS COUNT TO ZERO */
         SLR   @10,@10                                             1229
         ST    @10,NP3PAREN                                        1229
*   CUROPT='00'X;                   /* TURN CURRENT OPTION FLAGS OFF */
*                                                                  1230
         MVI   CUROPT,X'00'                                        1230
*   /*****************************************************************/
*   /*                                                               */
*   /* IS CHARACTER A BLANK OR A QUOTE                               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1231
*   IF NP3SCANR=' 'WNP3SCANR=NP3QUOTE THEN                         1231
         CLI   NP3SCANR(SCANREG),C' '                              1231
         BE    @RT01231                                            1231
         CLC   NP3SCANR(1,SCANREG),NP3QUOTE                        1231
         BE    @RT01231                                            1231
*     GO TO NP3SNDER;               /* GO GIVE ERROR MESSAGE         */
*                                                                  1232
*   /*****************************************************************/
*   /*                                                               */
*   /* IS CHARACTER A COMMA                                          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1233
*   IF NP3SCANR=NP3COMMA THEN       /* YES - CANCEL                  */
         CLC   NP3SCANR(1,SCANREG),NP3COMMA                        1233
         BNE   @RF01233                                            1233
*     DO;                                                          1234
*       CURCANOP='1'B;              /* SET CANCEL FLAG IN CURRENT  1235
*                                      OPTION BYTE                   */
         OI    CURCANOP,B'00100000'                                1235
*       GO TO NP3OUT;               /* RETURN                        */
         B     NP3OUT                                              1236
*     END;                                                         1237
*                                                                  1237
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK CURRENT CHARACTER FOR LEFT PARENTHESIS                  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1238
*NP3PCHCK:                                                         1238
*   IF SCNPAREN^=LPAREN             /* CHARACTER OTHER THAN LEFT   1238
*                                      PAREN                         */
*     THEN                          /* YES, NOT A LEFT PAREN         */
*                                                                  1238
@RF01233 DS    0H                                                  1238
NP3PCHCK CLC   SCNPAREN(1,SCANREG),LPAREN                          1238
         BE    @RF01238                                            1238
*     /***************************************************************/
*     /*                                                             */
*     /* CHECK CURRENT CHARACTER FOR RIGHT PARENTHESIS               */
*     /*                                                             */
*     /***************************************************************/
*                                                                  1239
*     IF SCNPAREN^=RPAREN           /* CHARACTER OTHER THAN RIGHT  1239
*                                      PAREN                         */
*       THEN                        /* YES, NOT A RIGHT PAREN        */
*                                                                  1239
         CLC   SCNPAREN(1,SCANREG),RPAREN                          1239
         BE    @RF01239                                            1239
*       /*************************************************************/
*       /*                                                           */
*       /* CHECK CURRENT CHARACTER FOR COMMA,QUOTE BLANK             */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1240
*       IF NP3SCANR=NP3COMMA        /* CHARACTER = COMMA             */
*           WNP3SCANR=NP3QUOTE      /* CHAR. = QUOTE                 */
*           WNP3SCANR=NP3BLANK      /* CHAR. = BLANK                 */
*         THEN                      /* YES, CHARACTER = TO ONE OF  1240
*                                      THEM                          */
*                                                                  1240
         CLC   NP3SCANR(1,SCANREG),NP3COMMA                        1240
         BE    @RT01240                                            1240
         CLC   NP3SCANR(1,SCANREG),NP3QUOTE                        1240
         BE    @RT01240                                            1240
         CLC   NP3SCANR(1,SCANREG),NP3BLANK                        1240
         BNE   @RF01240                                            1240
@RT01240 DS    0H                                                  1241
*         /***********************************************************/
*         /*                                                         */
*         /* CHECK FOR PAREN COUNT OF ZERO, WHICH IMPLIES            */
*         /* SUBPARAMETERS HAVE BEEN COMPLETELY BALANCED CHECKED     */
*         /*                                                         */
*         /***********************************************************/
*                                                                  1241
*         IF NP3PAREN=0             /* COUNT = 0                     */
*           THEN                    /* YES                           */
         ICM   @10,15,NP3PAREN                                     1241
         BNZ   @RF01241                                            1241
*           DO;                     /* SET NEXT CHARACTER POINTER    */
*NP3OUT:                                                           1243
*             NP3NCHAR=SCANREG;     /* RETURN TO CALLER AT VALID   1243
*                                      PARAMETER ENTRY               */
NP3OUT   ST    SCANREG,NP3NCHAR                                    1243
*             GO TO NP3SRTN0;                                      1244
         L     @10,NP3SRTRN                                        1244
         BR    @10                                                 1244
*           END;                                                   1245
*         ELSE                      /* PAREN COUNT NOT ZERO,FALL   1246
*                                      THROUGH                       */
*           DO;                     /* CHECK CHARACTER FOR COMMA     */
@RF01241 DS    0H                                                  1247
*             IF NP3SCANR=NP3COMMA THEN/* YES, CHARACTER IS          */
         CLC   NP3SCANR(1,SCANREG),NP3COMMA                        1247
         BNE   @RF01247                                            1247
*               DO;                 /* A COMMA                       */
*                 NP3SUBCK='1'B;    /* TURN SUBPARAM CHECK SWITCH ON */
         OI    NP3SUBCK,B'00001000'                                1249
*                 GO TO NP3RECNT;   /* BRANCH TO POINTER UPDATE      */
         B     NP3RECNT                                            1250
*               END;                                               1251
*             ELSE                  /* NO, CHARACTER NOT A COMMA     */
*               GO TO NP3ENDL;      /* BRANCH TO END OF CHARACTER  1252
*                                      STRING CHECK                  */
*           END;                                                   1253
*       ELSE                        /* NO, CHARACTER NOT A COMMA OR A
*                                      QUOTE OR A BLANK              */
*         GO TO NP3RECNT;           /* BRANCH TO CHARACTER POINTER 1254
*                                      UPDATE                        */
*     ELSE                          /* YES, CHARACTER IS A RIGHT   1255
*                                      PAREN                         */
*       DO;                                                        1255
*                                                                  1255
@RF01239 DS    0H                                                  1256
*         /***********************************************************/
*         /*                                                         */
*         /* DECREMENT PARENTHESIS COUNT BY ONE(1)                   */
*         /*                                                         */
*         /***********************************************************/
*                                                                  1256
*         NP3PAREN=NP3PAREN-1;                                     1256
         L     @10,NP3PAREN                                        1256
         BCTR  @10,0                                               1256
         ST    @10,NP3PAREN                                        1256
*         GO TO NP3PRENC;           /* BRANCH TO PAREN COUNT CHK     */
         B     NP3PRENC                                            1257
*       END;                                                       1258
*   ELSE                            /* YES, CHARACTER IS A LEFT PAREN*/
*     DO;                                                          1259
*                                                                  1259
@RF01238 DS    0H                                                  1260
*       /*************************************************************/
*       /*                                                           */
*       /* INCREMENT PARENTHESIS COUNT BY ONE(1)                     */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1260
*       NP3PAREN=1+NP3PAREN;                                       1260
         LA    @10,1                                               1260
         AL    @10,NP3PAREN                                        1260
         ST    @10,NP3PAREN                                        1260
*       GO TO NP3PRENC;             /* BRANCH TO PAREN COUNT CHECK   */
         B     NP3PRENC                                            1261
*     END;                                                         1262
*                                                                  1262
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK CURRENT COUNT OF PARENTHESIS FOR THIS SUBPARAMETER      */
*   /* CHARACTER STRING FOR GREATER THAN ZERO                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1263
*NP3PRENC:                                                         1263
*   IF NP3PAREN>0                   /* IS COUNT GREATER THAN ZERO    */
*     THEN                                                         1263
NP3PRENC L     @10,NP3PAREN                                        1263
         SLR   @05,@05                                             1263
         CR    @10,@05                                             1263
         BH    @RT01263                                            1263
*     GO TO NP3RECNT;               /* YES - GREATER THAN ZERO       */
*                                                                  1264
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK CURRENT COUNT OF PARENTHESIS FOR THIS SUBPARAMETER      */
*   /* CHARACTER STRING FOR LESS THAN ZERO                           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1265
*   IF NP3PAREN<0                   /* COUNT LESS THAN ZERO          */
*     THEN                                                         1265
         CR    @10,@05                                             1265
         BL    @RT01265                                            1265
*     GO TO NP3PRINV;               /* YES,COUNT LESS THAN ZERO      */
*                                                                  1266
*   /*****************************************************************/
*   /*                                                               */
*   /* UPDATE SCAN POINTER BY ONE(1)                                 */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1267
*   SCANREG=1+SCANREG;                                             1267
*                                                                  1267
         LA    SCANREG,1(,SCANREG)                                 1267
*   /*****************************************************************/
*   /*                                                               */
*   /* THE PARENTHESIS COUNT IS ZERO. THE NEXT CHARACTER SHOULD BE A */
*   /* COMMA OR A BLANK OR A QUOTE. IF THE CHARACTER IS ONE OF THESE */
*   /* THEN THE SUBPARAMETERS HAVE BEEN TERMINATED PROPERLY. IF      */
*   /* NOT,THEN THE SUBPARAMETERS ARE NOT SPECIFIED CORRECTLY        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1268
*   IF NP3SCANR=NP3COMMA            /* CHARACTER A COMMA             */
*       WNP3SCANR=NP3BLANK          /* CHAR. A BLANK                 */
*       WNP3SCANR=NP3QUOTE          /* CHAR. A QUOTE                 */
*     THEN                          /* YES, CHARACTER IS ONE OF THEM,
*                                      SUBPARAMETERS ARE VALID       */
         CLC   NP3SCANR(1,SCANREG),NP3COMMA                        1268
         BE    @RT01268                                            1268
         CLC   NP3SCANR(1,SCANREG),NP3BLANK                        1268
         BE    @RT01268                                            1268
         CLC   NP3SCANR(1,SCANREG),NP3QUOTE                        1268
         BE    @RT01268                                            1268
*     GO TO NP3OUT;                 /* BRANCH TO CALLER RETURN     1269
*                                      HANDLER                       */
*                                                                  1269
*   /*****************************************************************/
*   /*                                                               */
*   /* NO, CHARACTER IS NONE OF THEM, INVALID SUBPARAMETERS          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1270
*NP3SNDER:                                                         1270
*   CAUSE04=IMPDEL;                 /* CAUSE IS IMPROPER DELIMETER   */
*                                                                  1270
NP3SNDER MVC   CAUSE04(20),IMPDEL                                  1270
*   /*****************************************************************/
*   /*                                                               */
*   /* PAREN COUNT IS LESS THAN ZERO WHICH IMPLIES THE SUBPARAMETERS */
*   /* WERE SPECIFIED INCORRECTLY                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1271
*NP3PRINV:                                                         1271
*   IF NP3PAREN^=0                  /* IS PAREN CTR ZERO             */
*     THEN                          /* NO - SET CAUSE AS IMBALENCED
*                                      PARENS                        */
NP3PRINV ICM   @10,15,NP3PAREN                                     1271
         BZ    @RF01271                                            1271
*     DO;                                                          1272
*       CAUSE04=IMBPAR;                                            1273
         MVC   CAUSE04(20),IMBPAR                                  1273
*     END;                                                         1274
*NP3PINV2:                                                         1275
*   NP3NCHAR=SCANREG;               /* SET NEXT CHAR. POINTER        */
*                                                                  1275
@RF01271 DS    0H                                                  1275
NP3PINV2 ST    SCANREG,NP3NCHAR                                    1275
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO INVALID PARAMETER SYNTAX MESSAGE                          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1276
*   CALL NP3PINV;                   /*                         Y02752*/
*                                                                  1276
         BAL   @14,NP3PINV                                         1276
*   /*****************************************************************/
*   /*                                                               */
*   /* RETURN TO NIP PROMPT CONTROL SEQUENCE IF IN PROMPT MODE Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1277
*   IF NVTSYSP='1'B                 /*                         Y02752*/
*     THEN                          /*                         Y02752*/
         TM    NVTSYSP(RNVT),B'01000000'                           1277
         BNO   @RF01277                                            1277
*     DO;                           /*                         Y02752*/
*       RETCODE=12;                 /* INVALID MSG ISSUED RTN CODE 1279
*                                                              Y02752*/
         MVC   RETCODE(4),@CF00036                                 1279
*       GO TO NPRMRTN1;             /* RETURN TO IEAVNPA3 CALL     1280
*                                      SEQUENCE                Y02752*/
         L     @10,NPRMRTN1                                        1280
         BR    @10                                                 1280
*     END;                          /*                         Y02752
*                                                              Y02752*/
*   GO TO NP3SRTN4;                 /* INVALID PARM - RETURN TO    1282
*                                      CALLER                        */
*                                                                  1282
@RF01277 L     @10,NP3SRTRN                                        1282
         LA    @10,NP3SRTN4(,@10)                                  1282
         BR    @10                                                 1282
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS CHECKS TO SEE IF "CONT" HAS BEEN SPECIFIED WITH THESE    */
*   /* SUBPARAMETERS. IF NOT, THE SUBPARAMETERS HAVE BEEN SPECIFIED  */
*   /* INCORRECTLY.                                                  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1283
*NP3ENDL:                                                          1283
*   IF NP3SCANR=NP3QUOTE            /* IS CURRENT CHARACTER A QUOTE  */
*     THEN                          /* YES, CHARACTER IS A QUOTE     */
NP3ENDL  CLC   NP3SCANR(1,SCANREG),NP3QUOTE                        1283
         BNE   @RF01283                                            1283
*     DO;                                                          1284
*                                                                  1284
*       /*************************************************************/
*       /*                                                           */
*       /* SET MAPPING BASE ADDRESS POINTER FOR "CONT" CHECK IN      */
*       /* SUBPARAMETER CHARACTER STRING                             */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1285
*       NP3LKCNT=SCANREG-4;                                        1285
*                                                                  1285
         LR    @10,SCANREG                                         1285
         SL    @10,@CF00371                                        1285
         ST    @10,NP3LKCNT                                        1285
*       /*************************************************************/
*       /*                                                           */
*       /* CHECK TO SEE IF "CONT" WAS SPECIFIED WITH THESE           */
*       /* SUBPARAMETERS                                             */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1286
*       IF BALNCONT=NP3RCONT        /* CHARACTERS = "CONT"           */
*         THEN                      /* YES, CONTINUE SUBPARAMETERS 1286
*                                      SPECIFIED                     */
         CLC   BALNCONT(4,@10),NP3RCONT                            1286
         BNE   @RF01286                                            1286
*         DO;                                                      1287
*           PRENDPTR=NP3LKCNT;      /* SET PRIME END PTR TO BEGINNING
*                                      OF 'CONT' CHARACTERS          */
         ST    @10,PRENDPTR                                        1288
*           NP3CONT='1'B;           /* SET CONTINUE SUBPARAMETERS  1289
*                                      SPECIFIED                     */
         OI    NP3CONT,B'10000000'                                 1289
*           GO TO NP3SRTN8;         /* CONT - RETURN TO CALLER       */
         L     @10,NP3SRTRN                                        1290
         LA    @10,NP3SRTN8(,@10)                                  1290
         BR    @10                                                 1290
*         END;                                                     1291
*       ELSE                        /* NO, CONTINUE SUBPARAMETERS NOT
*                                      SPECIFIED, IMPLIES          1292
*                                      SUBPARAMETERS ARE INVALID     */
*         GO TO NP3PRINV;           /* BRANCH TO INVALID           1292
*                                      SUBPARAMETERS RETURN HANDLER  */
*     END;                                                         1293
*   ELSE                            /* NO, CHARACTER IS NOT A QUOTE  */
*     GO TO NP3PRINV;               /* BRANCH TO INVALID           1294
*                                      SUBPARAMETERS RETURN HANDLER  */
*NP3RECNT:                                                         1295
*   SCANREG=1+SCANREG;              /* UPDATE SCAN POINTER           */
NP3RECNT LA    SCANREG,1(,SCANREG)                                 1295
*   IF NP3SUBCK^='1'B               /* IS SUBPARAM CHECK FLAG ON     */
*     THEN                                                         1296
         TM    NP3SUBCK,B'00001000'                                1296
         BNO   @RT01296                                            1296
*     GO TO NP3PCHCK;               /* NO - LOOK FOR PAREN           */
*   NP3SUBCK='0'B;                  /* RESET SUBPARAM SWITCH TO ZERO */
*                                                                  1298
         NI    NP3SUBCK,B'11110111'                                1298
*   /*****************************************************************/
*   /*                                                               */
*   /* TEST FOR IMBEDDED PARAMETER OPTIONS                           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1299
*   CALL NP3POPT;                                                  1299
         BAL   @14,NP3POPT                                         1299
*   GO TO NP3PCHCK;                 /* LOOK FOR PARENS               */
         B     NP3PCHCK                                            1300
*                                                                  1301
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS SUBROUTINE IS FOR ISSUING INVALID PARAMETER MESSAGES TO  */
*   /* THE CONSOLE OPERATOR THROUGH THE NIPWTO (IEAVNIPM) BRANCH     */
*   /* INTERFACE.                                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1301
*NP3PINV:                                                          1301
*   NP3PRTRN=REXIT;                 /* SAVE CALLERS RETURN ADDRESS   */
NP3PINV  ST    REXIT,NP3PRTRN                                      1301
*   NP3ECHMV=NP3ERCHR;              /* MOVE ERROR CHARACTERS INTO  1302
*                                      MESSAGE BUFFER                */
*                                                                  1302
         L     @10,NP3CCHAR                                        1302
         MVC   NP3ECHMV(8),NP3ERCHR(@10)                           1302
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK TO SEE IF LENGTH OF ERROR CHARACTERS IS LESS THAN       */
*   /* EIGHT(8). IF YES,THEN BLANK FILL CHARACTERS ARE NEEDED IN THE */
*   /* ERROR PARAMETER TEXT                                          */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1303
*   IF SLN<LENGTH(SYMBSTRT)         /* ERROR CHARACTERS LESS THAN  1303
*                                      EIGHT(8)                      */
*     THEN                          /* YES, LENGTH LESS THAN EIGHT(8)*/
         CLI   SLN,8                                               1303
         BNL   @RF01303                                            1303
*     DO;                                                          1304
*                                                                  1304
*       /*************************************************************/
*       /*                                                           */
*       /* CALCULATE FILL CHARACTER LENGTH VALUE                     */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1305
*       NP3MELNG=LENGTH(SYMBSTRT);                                 1305
*                                                                  1305
         LA    @10,8                                               1305
         STC   @10,NP3MELNG                                        1305
*       /*************************************************************/
*       /*                                                           */
*       /* MOVE BLANK FILL CHARACTERS INTO ERROR PARAMETER TEXT      */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1306
*       NP3ECHMI(SLN:NP3MELNG)=NP3FILL;                            1306
         SLR   @05,@05                                             1306
         IC    @05,SLN                                             1306
         LA    @01,NP3ECHMI-1(@05)                                 1306
         SLR   @10,@05                                             1306
         EX    @10,@SM02878                                        1306
*     END;                                                         1307
*   ELSE                                                           1308
*     ;                             /* NO, LENGTH NOT LESS THAN    1308
*                                      EIGHT, FALL THROUGH           */
*                                                                  1308
@RF01303 DS    0H                                                  1309
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS GENERATE IS A MACRO BRANCH INTERFACE TO NIPWTO           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1309
*   GENERATE REFS(NVTWTO);                                         1309
         IEAPMNIP   TYPE=WTO,PARAM=MESG04    CALL WTO SERVICE ROUTINE
*   GO TO NP3PRTR0;                 /* RETURN TO CALLER              */
         L     @10,NP3PRTRN                                        1310
         BR    @10                                                 1310
*                                                                  1311
*   /*****************************************************************/
*   /*                                                               */
*   /* PARAMETER OPTION ROUTINE SCANS FOR LIST OR OPI OPTIONS. IF    */
*   /* FOUND, THE CHARACTERS ('L,' , 'L)' , 'OPI=') ARE REPLACED BY  */
*   /* NULL CHARACTERS (X'FF') AND CORRESPONDING OPTION FLAGS ARE SET*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1311
*   RESPECIFY                                                      1311
*     NP3SCAN5 BASED(SCANREG);                                     1311
*NP3POPT:                                                          1312
*   NP3POADR=REXIT;                 /* SAVE CALLER'S RETURN ADDRESS  */
NP3POPT  ST    REXIT,NP3POADR                                      1312
*   IF NP3SCAN2='L,'                /* IS CHAR 'L,'                  */
*     THEN                                                         1313
         CLC   NP3SCAN2(2,SCANREG),@CC02718                        1313
         BE    @RT01313                                            1313
*     GO TO NP3POLST;               /* YES - OVERRIDE WITH NULL CHAR */
*   IF NP3SCAN2^='L)'               /* IS CHAR 'L)'                  */
*     THEN                                                         1315
         CLC   NP3SCAN2(2,SCANREG),@CC02720                        1315
         BNE   @RT01315                                            1315
*     GO TO NP3PONXT;               /* NO - CHECK FOR OPI OPTION     */
*NP3POLST:                                                         1317
*   NP3SCANR='FF'X;                 /* REPLACE 'L' WITH X'FF'        */
NP3POLST MVI   NP3SCANR(SCANREG),X'FF'                             1317
*   SCANREG=SCANREG-1;              /* POINT TO PRECEEDING COMMA     */
         BCTR  SCANREG,0                                           1318
*   NP3SCANR='FF'X;                 /* REPLACE PRECEEDING COMMA WITH
*                                      X'FF'                         */
         MVI   NP3SCANR(SCANREG),X'FF'                             1319
*   CLISTOPT='1'B;                  /* SET LIST OPTION IN CURRENT  1320
*                                      FLAG                          */
         OI    CLISTOPT,B'01000000'                                1320
*   SCANREG=SCANREG+2;              /* UPDATE SCAN PTR PAST ',L'     */
         LA    SCANREG,2(,SCANREG)                                 1321
*NP3PONXT:                                                         1322
*   IF NP3SCAN4^='OPI='             /* IS CHAR 'OPI='                */
*     THEN                                                         1322
NP3PONXT CLC   NP3SCAN4(4,SCANREG),@CC02723                        1322
         BNE   @RT01322                                            1322
*     GO TO NP3POXIT;               /* NO - RETURN                   */
*                                                                  1323
*   /*****************************************************************/
*   /*                                                               */
*   /* YES - OPI IS SPECIFIED                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1324
*   NP3SCAN4='FFFFFFFF'X;           /* OVERRIDE 'OPI=' WITH NULL     */
         MVC   NP3SCAN4(4,SCANREG),@CB02726                        1324
*   SCANREG=SCANREG-1;              /* POINT TO PRECEEDING COMMA     */
         BCTR  SCANREG,0                                           1325
*   NP3SCANR='FF'X;                 /* REPLACE PRECEEDING COMMA WITH
*                                      X'FF'                         */
         MVI   NP3SCANR(SCANREG),X'FF'                             1326
*   IF NP3INID='0000'X              /* IS OPERATOR THE SOURCE        */
*     THEN                                                         1327
         CLC   NP3INID(2),@CB02317                                 1327
         BE    @RT01327                                            1327
*     GO TO NP3INVOP;               /* YES - GIVE INVALID PARAMETER
*                                      SYNTAX MESSAGE                */
*   SCANREG=SCANREG+5;              /* POINT TO CHAR AFTER ',OPI='   */
         LA    SCANREG,5(,SCANREG)                                 1329
*   IF NP3SCAN2='NO'                /* IS OPI = NO SPECIFIED         */
*     THEN                                                         1330
         CLC   NP3SCAN2(2,SCANREG),@CC02487                        1330
         BNE   @RF01330                                            1330
*     DO;                           /* YES - SET OPI FLAG            */
*       COPIOPT='1'B;               /* SET OPI OPTION IN CURRENT FLAG*/
         OI    COPIOPT,B'10000000'                                 1332
*       NP3SCAN2='FFFF'X;           /* REPLACE WITH NULL CHARS       */
         MVC   NP3SCAN2(2,SCANREG),@CB02728                        1333
*       SCANREG=SCANREG+2;          /* UPDATE PAST OPI = NO          */
         LA    SCANREG,2(,SCANREG)                                 1334
*       GO TO NP3POXIT;             /* RETURN                        */
         B     NP3POXIT                                            1335
*     END;                                                         1336
*   IF NP3SCAN3='YES'               /* IS OPI = YES SPECIFIED        */
*     THEN                                                         1337
@RF01330 CLC   NP3SCAN3(3,SCANREG),@CC02486                        1337
         BNE   @RF01337                                            1337
*     DO;                                                          1338
*       NP3SCAN3='FFFFFF'X;         /* REPLACE WITH NULL CHARS       */
         MVC   NP3SCAN3(3,SCANREG),@CB02729                        1339
*       SCANREG=SCANREG+3;          /* UPDATE PAST OPI = YES         */
         LA    SCANREG,3(,SCANREG)                                 1340
*     END;                                                         1341
*   ELSE                                                           1342
*     GO TO NP3INVOP;               /* NEITHER OPI=YES NOR OPI=NO    */
*NP3POXIT:                                                         1343
*   GO TO NP3POAD0;                 /* RETURN TO CALLER              */
NP3POXIT L     @10,NP3POADR                                        1343
         BR    @10                                                 1343
*NP3INVOP:                                                         1344
*   CAUSE04=INVOPI;                 /* SET CAUSE AS 'INVALID OPI   1344
*                                      KEYWORD'                      */
NP3INVOP MVC   CAUSE04(20),INVOPI                                  1344
*   GO TO NP3PINV2;                 /* GO GIVE INVALID PARAMETER   1345
*                                      SYNTAX MESSAGE                */
         B     NP3PINV2                                            1345
*   RESPECIFY                                                      1346
*     SYMBLREG UNRESTRICTED;        /* RELEASE SCAN CONTROL REGISTER */
*   RESPECIFY                                                      1347
*     OFFSTREG UNRESTRICTED;        /* RELEASE SCAN CONTROL REGISTER */
*                                                                  1348
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS ROUTINE OBTAINS PAREAS FROM SUBPOOL 252. IF THE GETMAIN  */
*   /* IS UNSUCCESSFULL,THE OPERATOR IS NOTIFIED AN ACTION IS TAKEN  */
*   /* TO PLACE THE SYSTEM IN A DISABLED WAIT STATE.                 */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1348
*NP3PAGM:                                                          1348
*   NP3RTRN=REXIT;                  /* SAVE CALLERS RETURN ADDRESS   */
*                                                                  1348
NP3PAGM  ST    REXIT,NP3RTRN                                       1348
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS GENERATES A GETMAIN MACRO TO GET A 2K BUFFER FROM SUBPOOL*/
*   /* 0 .                                                           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1349
*   GENERATE;                                                      1349
*                                                                  1349
         GETMAIN    LC,LA=PAREA01,A=NP3GBFR,SP=0    ISSUE GETMAIN
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK FOR SUCCESSFULL GETMAIN - 0=YES, 4=NO                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1350
*   IF GETMRTCD=0                   /* WAS GETMAIN SUCCESSFULL       */
*     THEN                          /* YES, 2K BUFFER WAS GOTTEN     */
         SLR   @14,@14                                             1350
         CR    GETMRTCD,@14                                        1350
         BNE   @RF01350                                            1350
*     DO;                                                          1351
*       RESPECIFY                                                  1352
*         NIPPAHDR BASED(NP3GBFR);  /* RESET POINTER                 */
*       NIPPAQ=0;                   /* CLEAR FIRST HALF OF HEADER    */
         L     @10,NP3GBFR                                         1353
         ST    @14,NIPPAQ-NIPPAHDR(,@10)                           @L01
*       NIPPABYT=0;                 /* CLEAR SECOND HALF OF HEADER   */
*                                                                  1354
         ST    @14,NIPPABYT-NIPPAHDR(,@10)                         @L01
*       /*************************************************************/
*       /*                                                           */
*       /* CHECK TO SEE IF THIS IS THE INITIAL PAREA,,FIRST 2K BUFFER*/
*       /* GOTTEN                                                    */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1355
*       IF NP3ADBFR='1'B            /* IS THIS THE INITIAL PAREA     */
*         THEN                      /* NO, THIS IS NOT INITIAL PAREA */
         TM    NP3ADBFR,B'00100000'                                1355
         BNO   @RF01355                                            1355
*         DO;                                                      1356
*           RESPECIFY                                              1357
*             NIPPAHDR BASED(NP3PAREA);                            1357
*           NIPPAQ=NP3GBFR;         /* CHAIN THIS BUFFER TO LAST   1358
*                                      BUFFER GOTTEN                 */
         L     @09,NP3PAREA                                        1358
         ST    @10,NIPPAQ-NIPPAHDR(,@09)                           @L01
*           RESPECIFY                                              1359
*             NIPPAHDR BASED(NP3PBFR);                             1359
*         END;                                                     1360
*       ELSE                        /* YES, THIS IS FIRST PAREA      */
*         DO;                                                      1361
         B     @RC01355                                            1361
@RF01355 DS    0H                                                  1362
*           NP3ADBFR='1'B;          /* SET INITIAL PAREA GOTTEN FLAG
*                                      ON                            */
         OI    NP3ADBFR,B'00100000'                                1362
*         END;                                                     1363
*       NP3PAREA=NP3GBFR;           /* SAVE NEW BUFFER ADDRESS       */
@RC01355 L     @10,NP3GBFR                                         1364
         ST    @10,NP3PAREA                                        1364
*       RESPECIFY                                                  1365
*         NIPPAHDR BASED(NP3GBFR);  /* RESET POINTER                 */
*       NIPPABYT=NP3GBFR+LENGTH(NIPPAHDR);/* SET NEXT AVAILABLE BYTE
*                                      ADDRESS IN HEADER             */
         LA    @09,8                                               1366
         ALR   @09,@10                                             1366
         ST    @09,NIPPABYT-NIPPAHDR(,@10)                         @L01
*       RESPECIFY                                                  1367
*         NIPPAHDR BASED(NP3PBFR);  /* RESET POINTER                 */
*       GO TO NP3RTRN0;             /* RETURN TO CALLER              */
         L     @10,NP3RTRN                                         1368
         BR    @10                                                 1368
*     END;                                                         1369
*   ELSE                                                           1370
*     ;                             /* NO ,2K BUFFER WAS NOT       1370
*                                      ALLOCATED ,AN ERROR CONDITION
*                                      EXIST.                        */
@RF01350 DS    0H                                                  1371
*   GO TO NP3SW38;                  /* GO TELL OPERATOR GETMAIN    1371
*                                      FAILED DURING INITIALIZATION  */
         B     NP3SW38                                             1371
*/********************************************************************/
*/*                                                                  */
*/* MACRO-      IEAPSPIO                                             */
*/*                                                                  */
*/* STATUS-     VERSION DATE=10/24/73, VS/2 RELEASE 2                */
*/*                                                                  */
*/* FUNCTION-   IEAPSPIO IS PART OF THE  SUPERVISOR                  */
*/*             INITIALIZATION PROCESS FOR VS2.                      */
*/*                                                                  */
*/*             THIS MACRO GENERATES INLINE PL/S STATEMENTS          */
*/*             WHICH FORM A SUBROUTINE TO FIND AND READ TEXT        */
*/*             RECORDS FROM SYS1.PARMLIB.                           */
*/*                                                                  */
*/*  REGISTER DEPENDENCIES-                                          */
*/*                                                                  */
*/*                 1. IEAPSPIO DEPENDS ON THE INCLUDING ROUTINES    */
*/*                    BASE REGISTERS FOR ADDRESSABILITY             */
*/*                                                                  */
*/*                 2. REGISTER 3 MUST CONTAIN THE ADDRESS OF        */
*/*                    THE CVT ON ENTRY                              */
*/*                                                                  */
*/*                 3. REGISTER 2 MUST CONTAIN THE ADDRESS OF        */
*/*                    THE NVT ON ENTRY                              */
*/*                                                                  */
*/*                 4. REGISTER 14 MUST CONTAIN THE ADDRESS OF       */
*/*                    THE CALLERS RETURN POINT ON ENTRY             */
*/*                                                                  */
*/* ENTRY POINTS-                                                    */
*/*                                                                  */
*/*    TWO CALLING SEQUENCRS ARE AVAILABLE.  ONE PROVIDES            */
*/*    COMPATIBILITY WITH THE VS2-1 VERSION OF THIS MACRO,           */
*/*    THE OTHER CALLING SEQUENCE WAS DEVELOPED EXPRESSLY            */
*/*    FOR VS2-2.                                                    */
*/*                                                                  */
*/*        VS2-1 COMPATIBLE VERSION-                                 */
*/*                                                                  */
*/*            1. CALL NIPPMPDS TO LOCATE (VIA BLDL) THE MEMBER      */
*/*               OF SYS1.PARMLIB                                    */
*/*                                                                  */
*/*            2. CALL NIPPMTXT TO READ A TEXT RECORD FROM           */
*/*               SYS1.PARMLIB                                       */
*/*                                                                  */
*/*        VS2-2 VERSION-                                            */
*/*                                                                  */
*/*            1. CALL NIPPMMEM TO LOCATE THE MEMBER AND RETURN      */
*/*               A TEXT RECORD                                      */
*/*                                                                  */
*/*            2. REPEAT CALL TO NIPPMMEM TO READ ADDITIONAL         */
*/*               TEXT RECORDS                                       */
*/*                                                                  */
*/* OUTPUT (NORMAL) -                                                */
*/*                                                                  */
*/*     THE ROUTINE WILL SAVE AND RESTORE ALL GENERAL REGISTERS      */
*/*     WITH THE EXCEPTION OF RPARM.  ON A SUCCESSFUL READ,          */
*/*     RPARM (REGISTER 1) WILL BE SET TO POINT TO THE FIRST NON-    */
*/*     BLANK CHARACTER IN THE TEXT RECORD.  IF THE RECORD           */
*/*     COLUMNS 1 THRU 72 ALL CONTAIN BLANKS, RPARM WILL             */
*/*     POINT TO A BLANK IN COLUMN 72.  IF COLUMNS 1 THRU 71         */
*/*     ARE BLANK BUT COLUMN 72 IS NON-BLANK, THE ROUTINE            */
*/*     WILL AUTOMATICALLY ATTEMPT TO READ THE NEXT RECORD.  IN      */
*/*     ALL CASES, COLUMN 72 WILL BE SET TO BLANK AND COLUMN 73 WILL */
*/*     BE SET TO X'FF'.                                             */
*/*                                                                  */
*/* EXIT (NORMAL)-                                                   */
*/*                                                                  */
*/*     VS2-1 AND VS2-2 VERSIONS RETURN TO THE ADDRESS FOUND         */
*/*     IN REGISTER 14 ON ENTRY.                                     */
*/*                                                                  */
*/* EXIT (ERROR)-                                                    */
*/*                                                                  */
*/*     VS2-1 COMPATIBLE VERSION-                                    */
*/*                                                                  */
*/*         RETURN TO THE ADDRESS IN REGISTER 14 +4                  */
*/*                                                                  */
*/*         NOTE- WHEN AN ERROR OCCURS ON AN ATTEMP TO READ A RECORD */
*/*               THAT DOES NOT EXIST (E-O-F),                       */
*/*               IT IS CONSIDERED A PERMANENT I/O ERROR             */
*/*                                                                  */
*/*     VS2-2 VERSION-                                               */
*/*                                                                  */
*/*        RETURN TO THE ADDRESS FOUND IN REGISTER 14 ON ENTRY       */
*/*        WITH REGISTER 1 (RPARM) SET TO A NEGATIVE VALUE.  IN THE  */
*/*        CASE WHERE RPARM IS NEGATIVE ON RETURN, THE NIPPARC FIELD */
*/*        OF THE NIP PATAMETER AREA WILL INDICATE THE REASON FOR    */
*/*        FAILURE AS FOLLOWS-                                       */
*/*                            4 - MEMBER NOT FOUND                  */
*/*                            8 - I/O ERROR DURING BLDL             */
*/*                            12- I/O ERROR DURING READ             */
*/*                            16- END-OF-FILE                       */
*/*                                                                  */
*/*     COMMON TO BOTH VERSIONS-                                     */
*/*                                                                  */
*/*        AN INTERPRETIVE MESSAGE WILL BE WRITTEN TO THE OPERATOR   */
*/*        FOR EACH OF THE FIRST THREE ERROR CONDITIONS LISTED       */
*/*        ABOVE.  THE CALLER MAY SUPPRESS THE 'MEMBER NOT FOUND'    */
*/*        MESSAGE BY SETTING THE NIPPAFL1 FLAG FIELD TO BINARY      */
*/*        ONE IN THE NIP PARAMETER AREA BEFORE CALLING THIS         */
*/*        ROUTINE.  NO MESSAGE WILL BE WRITTEN FOR THE E-O-F        */
*/*        CONDITION IF THE VS2-2 VERSION IS USED.                   */
*/*                                                                  */
*/* MACROS-                                                          */
*/*     THE FOLLOWING MAPPING MACROS MUST BE                         */
*/*     INCLUDED IN THE MODULE WHICH INCLUDES                        */
*/*     IEAPSPIO-                                                    */
*/*                                       IEZIOB                     */
*/*                                       IHANVT                     */
*/*                                       IHAECB                     */
*/*                                       IEAPPNIP                   */
*/*                                       IEFUCBOB                   */
*/*                                       CVT                        */
*/*                                                                  */
*/* NOTES-                                                           */
*/*        THE FIRST FOUR LETTERS OF ALL IEAPSPIO SYMBOLES ARE:      */
*/*        NIPP OR IPPM.                                             */
*/*                                                                  */
*/*        REGISTERS 0, 1, 14, AND 15 WILL BE UNRESTRICTED AT THE    */
*/*        END OF THE SEGMENT GENERATED BY IEAPSPIO.                 */
*/*                                                                  */
*/*        NIPPAREA WILL BE BASED ON NVTPAREA AND IOBSTDRD WILL BE   */
*/*        BASED ON THE ADDR OF NIPPAIOB AT THE END OF THE SEGMENT   */
*/*        GENERATED BY IEAPSPIO                                     */
*/*                                                                  */
*/*        IEAPSPIO MUST BE INCLUDED IN A CODE SEGMENT,              */
*/*        NOT AT THE TOP OF THE PROCEDURE WITH THE                  */
*/*        MAPPING MACROS LISTED ABOVE.                              */
*/*                                                            Y02752*/
*/********************************************************************/
*                                                                  1372
*   /*****************************************************************/
*   /*                                                               */
*   /* REGISTERS                                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1372
*   DCL                                                            1372
*     NIPPMR00 REG(0) PTR(24);                                     1372
*   DCL                                                            1373
*     NIPPMR01 REG(1) PTR(24);                                     1373
*   DCL                                                            1374
*     NIPPMR02 REG(2) PTR(24);                                     1374
*   DCL                                                            1375
*     NIPPMR06 REG(6) PTR(24);                                     1375
*   DCL                                                            1376
*     NIPPMR09 REG(9) PTR(24);                                     1376
*   DCL                                                            1377
*     NIPPMR12 REG(12) PTR(24);                                    1377
*   DCL                                                            1378
*     NIPPMR13 REG(13) PTR(24);                                    1378
*   DCL                                                            1379
*     NIPPMR14 REG(14) PTR(24);                                    1379
*   DCL                                                            1380
*     NIPPMR15 REG(15) PTR(24);                                    1380
*                                                                  1380
*   /*****************************************************************/
*   /*                                                               */
*   /* SAVE AREA FOR CALLER'S REGISTERS                              */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1381
*   DCL                                                            1381
*     NIPPMREG(16) FIXED(31);                                      1381
*                                                                  1381
*   /*****************************************************************/
*   /*                                                               */
*   /* SAVE AREA FOR CALLER'S RETURN ADDRESS                         */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1382
*   DCL                                                            1382
*     NIPPMADR PTR(31);                                            1382
*                                                                  1382
*   /*****************************************************************/
*   /*                                                               */
*   /* POINTER TO DCB FOR BLDL                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1383
*   DCL                                                            1383
*     NIPPMDCB PTR(31);                                            1383
*                                                                  1383
*   /*****************************************************************/
*   /*                                                               */
*   /* POINTER TO BLDL HEADER FOR BLDL                               */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1384
*   DCL                                                            1384
*     NIPPMBDL PTR(31);                                            1384
*                                                                  1384
*   /*****************************************************************/
*   /*                                                               */
*   /* NORMAL RETURN TO CALLER                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1385
*   DCL                                                            1385
*     NIPPMAD0 LABEL BASED(NIPPMADR);                              1385
*                                                                  1385
*   /*****************************************************************/
*   /*                                                               */
*   /* ERROR RETURN TO CALLER                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1386
*   DCL                                                            1386
*     NIPPMAD4 LABEL BASED(NIPPMADR+4);                            1386
*                                                                  1386
*   /*****************************************************************/
*   /*                                                               */
*   /* ESTABLISH BASE FOR NIP COMMUNICATION AREA               Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1387
*   RESPECIFY                                                      1387
*     NIPPAREA BASED(NVTPAREA);     /*                         Y02752*/
*                                                                  1387
*   /*****************************************************************/
*   /*                                                               */
*   /* ONE BYTE SCANNING FIELD                                       */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1388
*   DCL                                                            1388
*     NIPPMBYT CHAR(1) BASED;                                      1388
*                                                                  1388
*   /*****************************************************************/
*   /*                                                               */
*   /* TEMPORARY POINTER                                       Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1389
*   DCL                                                            1389
*     NIPPMKPR PTR(31);             /*                         Y02752*/
*                                                                  1389
*   /*****************************************************************/
*   /*                                                               */
*   /* INPUT RECORD READ FROM PARMLIB                          Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1390
*   DCL                                                            1390
*     NIPPMBUF CHAR(80) BASED(NIPPMR01);/*                     Y02752*/
*                                                                  1390
*   /*****************************************************************/
*   /*                                                               */
*   /* MBBCCHHR OF PARMLIB MEMBERS                                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1391
*   DCL                                                            1391
*     1 NIPPMMBC CHAR(8),                                          1391
*      2 NIPPMMBB CHAR(3),                                         1391
*      2 NIPPMCCH CHAR(5);                                         1391
*                                                                  1391
*   /*****************************************************************/
*   /*                                                               */
*   /* CCHHR OF PARMLIB MEMBERS                              @ZA07472*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1392
*   DCL                                                            1392
*     1 NIPPMSID BDY(WORD) CHAR(5) BASED(ADDR(NIPPASID)),/*  @ZA07472*/
*      2 NIPPMCC FIXED(15),         /* CYLINDER # OF SEARCH ID     1392
*                                                            @ZA07472*/
*      2 NIPPMHH CHAR(2),           /* HEAD # OF SEARCH ID   @ZA07472*/
*      2 NIPPMR CHAR(1);            /* RECORD # OF SEARCH ID @ZA07472*/
*                                                                  1392
*   /*****************************************************************/
*   /*                                                               */
*   /* LOW ORDER 7 BYTES OF THE CSW STORED IN THE PARMLIB IOB BY EXCP*/
*   /*                                                         Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1393
*   DCL                                                            1393
*     1 NIPPMCSW BASED(ADDR(IOBCSW)) BDY(BYTE),/*              Y02752*/
*      2 * CHAR(3),                 /*                         Y02752*/
*      2 NIPPMCS2 BIT(8),           /* I/O OPERATION STATUS FLAGS /*
*                                                              Y02752*/
*      2 * CHAR(3);                 /*                         Y02752*/
*                                                                  1393
*   /*****************************************************************/
*   /*                                                               */
*   /* MASKS TO TEST THE STATUS FLAGS OF THE PARMLIB CSW Y02752      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1394
*   DCL                                                            1394
*     NIPPMMK1 BIT(8) BDY(BYTE) INIT('11110010'B);/*           Y02752*/
*   DCL                                                            1395
*     NIPPMMK2 BIT(8) BDY(BYTE) INIT('11110001'B);/*         @ZA07472*/
*                                                                  1395
*   /*****************************************************************/
*   /*                                                               */
*   /* MASK TO TEST THE IOBSENSE FLAGS                       @ZA07472*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1396
*   DCL                                                            1396
*     NIPPMMK3 BIT(8) BDY(BYTE) INIT('00100000'B);/*         @ZA07472*/
*                                                                  1396
*   /*****************************************************************/
*   /*                                                               */
*   /* INTERNALLY GENERATED LABELS                                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1397
*   DCL                                                            1397
*     NIPPMMB1 LABEL GENERATED INTERNAL;                           1397
*   DCL                                                            1398
*     NIPPMMB2 LABEL GENERATED INTERNAL;                           1398
*   DCL                                                            1399
*     NIPPMTND LABEL GENERATED INTERNAL;                           1399
*                                                                  1399
*   /*****************************************************************/
*   /*                                                               */
*   /* MAPPING AREAS INTO ERROR MESSAGES                             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1400
*   DCL                                                            1400
*     NIPPMME1 CHAR(8) BASED(ADDR(NIPPMMB1));                      1400
*   DCL                                                            1401
*     NIPPMME2 CHAR(8) BASED(ADDR(NIPPMMB2));                      1401
*   DCL                                                            1402
*     NIPPMNAM CHAR(8) INIT(' ');   /* MEMBER NAME SAVE AREA   Y02752*/
*   DCL                                                            1403
*     NIPPMNEG FIXED(31) INIT('FFFFFFFF'X);/* NEGATIVE VALUE   Y02752*/
*   RESPECIFY                                                      1404
*     IOBSTDRD BASED(ADDR(NIPPAIOB));/* IOB BASE               Y02752*/
*   RESPECIFY                                                      1405
*    (NIPPMR14,                                                    1405
*     NIPPMR15,                                                    1405
*     NIPPMR00,                                                    1405
*     NIPPMR01) RESTRICTED;         /*                         Y02752*/
*NIPPMMEM:                                                         1406
*   NIPPMADR=NIPPMR14;              /* SAVE CALLER'S RETURN REGISTER
*                                                              Y02752*/
NIPPMMEM ST    NIPPMR14,NIPPMADR                                   1406
*   GENERATE REFS(NIPPMR01,NIPPMR02) SETS(NIPPMREG);               1407
          STM   NIPPMR02,NIPPMR01,NIPPMREG   SAVE REGISTERS     Y02752
*   NIPPARC=NIPPARC&&NIPPARC;       /* SET RETURN CODE TO ZERO Y02752*/
         L     @10,NVTPAREA(,RNVT)                                 1408
         L     @09,NIPPARC-NIPPAREA(,@10)                          @L01
         LR    @07,@09                                             1408
         XR    @07,@09                                             1408
         ST    @07,NIPPARC-NIPPAREA(,@10)                          @L01
*   IF NIPPMNAM=NIPPANAM            /* IS THIS NEW MEMBER NAME Y02752*/
*     THEN                                                         1409
         CLC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
         BE    @RT01409                                            1409
*     GO TO NIPPMPRD;               /* NO- GO READ RECORD      Y02752*/
*   NIPPMNAM=NIPPANAM;              /* YES- SAVE MEMBER NAME   Y02752*/
         MVC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
*   GO TO NIPPMENT;                 /* GO FIND MEMBER          Y02752*/
         B     NIPPMENT                                            1412
*NIPPMPDS:                                                         1413
*   NIPPMADR=NIPPMR14;              /* SAVE CALLER'S RETURN ADDR     */
NIPPMPDS ST    NIPPMR14,NIPPMADR                                   1413
*   GENERATE REFS(NIPPMR01,NIPPMR02) SETS(NIPPMREG);               1414
         STM   NIPPMR02,NIPPMR01,NIPPMREG       SAVE REGS       Y02752
*   NIPPMNAM=NIPPMNAM&&NIPPMNAM;    /* CLEAR MEMBER NAME       Y02752*/
         XC    NIPPMNAM(8),NIPPMNAM                                1415
*NIPPMENT:                                                         1416
*   NIPPMR01=ADDR(NIPPADCB)-44;     /* R1= ADDR OF DCB               */
NIPPMENT L     @10,NVTPAREA(,RNVT)                                 1416
         LA    NIPPMR01,NIPPADCB-NIPPAREA(,@10)                    @L01
         SH    NIPPMR01,@CH02133                                   1416
*   NIPPMR00=ADDR(NIPPABDL);        /* R0= ADDR OF BLDL LIST         */
*                                                                  1417
         LA    NIPPMR00,NIPPABDL-NIPPAREA(,@10)                    @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* READ PDS ENTRY FOR MEMBER                                     */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1418
*   GENERATE;                                                      1418
          BLDL (1),(0)
*   NIPPARC=NIPPMR15;               /* SET RETURN CODE         Y02752*/
         L     @10,NVTPAREA(,RNVT)                                 1419
         ST    NIPPMR15,NIPPARC-NIPPAREA(,@10)                     @L01
*   IF NIPPMR15=4                   /* WAS MEMBER NAME FOUND   Y02752*/
*     THEN                                                         1420
         CH    NIPPMR15,@CH00371                                   1420
         BE    @RT01420                                            1420
*     GO TO NIPPMPFN;               /* NO - TELL OPERATOR NOT FOUND  */
*   IF NIPPMR15=8                   /* WAS THERE AN I/O ERROR        */
*     THEN                                                         1422
         CH    NIPPMR15,@CH00156                                   1422
         BE    @RT01422                                            1422
*     GO TO NIPPMPER;               /* YES - TELL OPERATOR I/O ERROR */
*                                                                  1423
*   /*****************************************************************/
*   /*                                                               */
*   /* SET UP PARAMETERS FOR CONVERSION ROUTINE                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1424
*   NIPPMR00=NIPPATTR;              /* R0 = ACTUAL TTR               */
         SLR   NIPPMR00,NIPPMR00                                   1424
         ICM   NIPPMR00,7,NIPPATTR-NIPPAREA(@10)                   @L01
*   GENERATE;                                                      1425
         SLL   0,8(0)                    ZERO LOW BYTE IN REG 0
*   NIPPMR01=ADDR(NIPPADEB);        /* R1 = ADDR OF DEB              */
         L     NIPPMR01,NVTPAREA(,RNVT)                            1426
         LA    NIPPMR01,NIPPADEB-NIPPAREA(,NIPPMR01)               @L01
*   NIPPMR15=CVTPCNVT;              /* R15 = ADDR OF CONVERSION    1427
*                                      ROUTINE                 Y02752*/
*                                                                  1427
         L     NIPPMR15,CVTPCNVT(,CVTPTR)                          1427
*   /*****************************************************************/
*   /*                                                               */
*   /* CONVERT TTR TO CCHHR FORMAT                             Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1428
*   GENERATE REFS(NIPPMR02,NIPPMR13) SETS(NIPPMR14,NIPPMR15,NIPPMMBC);
*                                                          /*
         STM   NIPPMR02,NIPPMR13,NIPPMSAV SAVE REGISTERS        Y02752
         LA    NIPPMR02,NIPPMMBC          CONVERSION AREA       Y02752
         BALR  NIPPMR14,NIPPMR15          CALL CONVERT RTN      Y02752
**         RESTORE CSECT AND DSECT BASE REGISTERS               Y02752
*NIPPMRST  DS  0H                                               Y02752
NIPPMRST LM    NIPPMR02,NIPPMR13,NIPPMSAV-NIPPMRST(NIPPMR14)    Y02752
         BC    15,NIPPMSKP                SKIP SAVE AREA        Y02752
*NIPPMSAV  DS  0F                                               Y02752
NIPPMSAV DC    12F'0'                     DECLARE REG SAVE AREA Y02752
*NIPPMSKP DS  0H                                                Y02752
NIPPMSKP DS    0H                         RESUME EXECUTION      Y02752
*   IOBSEEK=NIPPMMBC;               /* RESET PARMLIB IOBSEEK TO THIS
*                                      MBBCCHHR                      */
         L     @10,NVTPAREA(,RNVT)                                 1429
         MVC   IOBSEEK+72(8,@10),NIPPMMBC                          1429
*   NIPPASID=NIPPMCCH;              /* RESET PARMLIB SEARCH ID TO  1430
*                                      THIS CCHHR                    */
         MVC   NIPPASID-NIPPAREA(5,@10),NIPPMCCH                   @L01
*   IF NIPPMNAM=NIPPANAM            /* SEE IF MEM NAMES MATCH  Y02752*/
*     THEN                                                         1431
         CLC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
         BE    @RT01431                                            1431
*     GO TO NIPPMPRD;               /* YES- NEW VERSION- GO READ   1432
*                                                              Y02752*/
*   GENERATE REFS(NIPPMR01,NIPPMR02) SETS(NIPPMREG);               1433
          LM    NIPPMR02,NIPPMR01,NIPPMREG    RESTORE REGS      Y02752
*   GO TO NIPPMAD0;                 /* NORMAL RETURN TO CALLER Y02752*/
         L     @10,NIPPMADR                                        1434
         BR    @10                                                 1434
*NIPPMPER:                                                         1435
*   NIPPMME1=NIPPANAM;              /* MOVE MEMBER NAME TO I/O ERROR
*                                      MESSAGE                       */
*                                                                  1435
NIPPMPER LA    @10,NIPPMMB1                                        1435
         L     @09,NVTPAREA(,RNVT)                                 1435
         MVC   NIPPMME1(8,@10),NIPPANAM-NIPPAREA(@09)              @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO I/O ERROR DURING BLDL MESSAGE                             */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1436
*   GENERATE REFS(NVTWTO) SETS(RPARM,REXIT,RENTRY);                1436
          IEAPMNIP TYPE=WTO,PARAM=NIPPMMS1 CALL WTO SERVICE ROUTINE
*   GO TO NIPPMPXT;                 /* ERROR RETURN TO CALLER        */
         B     NIPPMPXT                                            1437
*NIPPMPFN:                                                         1438
*   IF NIPPMNAM=NIPPANAM            /* SEE IF MEMBER NAMES MATCH   1438
*                                                              Y02752*/
*     THEN                                                         1438
NIPPMPFN L     @10,NVTPAREA(,RNVT)                                 1438
         CLC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
         BNE   @RF01438                                            1438
*     IF NIPPAFL1='1'B              /* YES- SUPPRESS MESSAGE?  Y02752*/
*       THEN                                                       1439
         L     @10,NP3CTAB                                         1439
         TM    NIPPAFLG-PARMTAB(@10),B'10000000'                   @L01
         BO    @RT01439                                            1439
*       GO TO NIPPMPXT;             /* YES- GO EXIT TO CALLER  Y02752*/
*     ELSE                                                         1441
*       ;                           /*                         Y02752*/
*   NIPPMME2=NIPPANAM;              /* MOVE MEMBER NAME TO NOT FOUND
*                                      MESSAGE                 Y02752*/
*                                                                  1442
@RF01438 LA    @10,NIPPMMB2                                        1442
         L     @09,NVTPAREA(,RNVT)                                 1442
         MVC   NIPPMME2(8,@10),NIPPANAM-NIPPAREA(@09)              @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* WTO MEMBER NOT FOUND IN DATA SET MESSAGE                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1443
*   GENERATE REFS(NVTWTO) SETS(RPARM,REXIT,RENTRY);                1443
          IEAPMNIP TYPE=WTO,PARAM=NIPPMMS2 CALL WTO SERVICE ROUTINE
*NIPPMPXT:                                                         1444
*   IF NIPPMNAM=NIPPANAM            /* SEE IF NAMES MATCH      Y02752*/
*     THEN                                                         1444
NIPPMPXT L     @10,NVTPAREA(,RNVT)                                 1444
         CLC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
         BNE   @RF01444                                            1444
*     DO;                                                          1445
*       NIPPMNAM=NIPPMNAM&&NIPPMNAM;/* FORCE NEW NAME PATH ON NEXT 1446
*                                      ENTRY                   Y02752*/
         XC    NIPPMNAM(8),NIPPMNAM                                1446
*       NIPPMR01=NIPPMNEG;          /* SET NEGATIVE VALUE RC   Y02752*/
         L     NIPPMR01,NIPPMNEG                                   1447
*       GENERATE SETS(NIPPMR02,NIPPMR00) REFS(NIPPMREG);           1448
          LM    NIPPMR02,NIPPMR00,NIPPMREG    RESTORE REGS      Y02752
*       GO TO NIPPMAD0;             /* EXIT TO CALLER          Y02752*/
         L     @10,NIPPMADR                                        1449
         BR    @10                                                 1449
*     END;                          /*                         Y02752*/
*   GENERATE SETS(NIPPMR02,NIPPMR01) REFS(NIPPMREG);               1451
@RF01444 DS    0H                                                  1451
*                                                           /* Y02752*/
         LM    NIPPMR02,NIPPMR01,NIPPMREG     RESTORE REGS      Y02752
*   GO TO NIPPMAD4;                 /* READ ERROR - RETURN TO CALLER */
         L     @10,NIPPMADR                                        1452
         LA    @10,NIPPMAD4+4(,@10)                                1452
         BR    @10                                                 1452
*                                                                  1453
*   /*****************************************************************/
*   /*                                                               */
*   /* ROUTINE TO READ PARMLIB TEXT                                  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1453
*NIPPMTXT:                                                         1453
*   NIPPMADR=NIPPMR14;              /* SAVE CALLER'S RETURN ADDRESS  */
NIPPMTXT ST    NIPPMR14,NIPPMADR                                   1453
*   GENERATE REFS(NIPPMR02,NIPPMR01) SETS(NIPPMREG);               1454
         STM   NIPPMR02,NIPPMR01,NIPPMREG   SAVE CALLERS REGS
*NIPPMPRD:                                                         1455
*   NIPPAECB=NIPPAECB&&NIPPAECB;    /* ZERO WAIT ECB                 */
NIPPMPRD L     @10,NVTPAREA(,RNVT)                                 1455
         XC    NIPPAECB-NIPPAREA(4,@10),NIPPAECB-NIPPAREA(@10)     @L01
*   IOBSEEK(4:7)=NIPPASID;          /* FILL IN CCHH IN IOB           */
*                                                                  1456
         LA    @09,72                                              1456
         ALR   @09,@10                                             1456
         MVC   IOBSEEK+3(4,@09),NIPPASID-NIPPAREA(@10)             @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* REINITIALIZE IOB FLAGS                                        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1457
*   IOBFLAG1='42'X;                                                1457
         MVI   IOBFLAG1(@09),X'42'                                 1457
*   IOBFLAG2='00'X;                                                1458
         MVI   IOBFLAG2(@09),X'00'                                 1458
*   IOBFLAG3='00'X;                                                1459
         MVI   IOBFLAG3(@09),X'00'                                 1459
*   IOBERRCT='0000'X;                                              1460
         SLR   @07,@07                                             1460
         STH   @07,IOBERRCT(,@09)                                  1460
*   IOBCSW='00000000000000'X;                                      1461
         MVC   IOBCSW(7,@09),@CB02796                              1461
*   IOBSENS0='00'X;                                                1462
         MVI   IOBSENS0(@09),X'00'                                 1462
*   IOBSENS1='00'X;                                                1463
*                                                                  1463
         MVI   IOBSENS1(@09),X'00'                                 1463
*   /*****************************************************************/
*   /*                                                               */
*   /* READ PARMLIB TEXT RECORD                                      */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1464
*   NIPPMR01=ADDR(NIPPAIOB);                                       1464
         LA    NIPPMR01,NIPPAIOB-NIPPAREA(,@10)                    @L01
*   GENERATE;                                                      1465
          EXCP  (1)                 READ TEXT
*   NIPPMR01=ADDR(NIPPAECB);                                       1466
         L     NIPPMR01,NVTPAREA(,RNVT)                            1466
         LA    NIPPMR01,NIPPAECB-NIPPAREA(,NIPPMR01)               @L01
*   GENERATE;                                                      1467
*                                                                  1467
          WAIT  ECB=(1)                  AWAIT I/O COMPLETION
*   /*****************************************************************/
*   /*                                                               */
*   /* TEST FOR I/O ERROR AFTER PARMLIB READ                   Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1468
*   IF NIPPAECC^='7F'X              /* SKIP IF READ SUCCESSFUL Y02752*/
*     THEN                                                         1468
         L     @10,NVTPAREA(,RNVT)                                 1468
         CLI   NIPPAECC-NIPPAREA(@10),X'7F'                        @L01
         BE    @RF01468                                            1468
*     DO;                                                          1469
*       IF NIPPMNAM=NIPPANAM        /* SEE IF MEMBER NAMES MATCH   1470
*                                                              Y02752*/
*         THEN                                                     1470
         CLC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
         BNE   @RF01470                                            1470
*         DO;                                                      1471
*                                                                  1471
*           /*********************************************************/
*           /*                                                       */
*           /* DOES THE I/O ERROR REPRESENT EOF                Y02752*/
*           /*                                                       */
*           /*********************************************************/
*                                                                  1472
*           IF NIPPAECC='41'X&      /* IOBCSW FIELD VALID?           */
*                                                                  1472
*           /*********************************************************/
*           /*                                                       */
*           /* FALL THROUGH IF UNIT EXCEPTION, CHANNEL END AND DEVICE*/
*           /* END FLAGS ARE ON IN THE IOBCSW                        */
*           /*                                                       */
*           /*********************************************************/
*                                                                  1472
*               (NIPPMCS2WNIPPMMK1)='FF'X THEN                     1472
         CLI   NIPPAECC-NIPPAREA(@10),X'41'                        @L01
         BNE   @RF01472                                            1472
         MVC   @TS00001(1),NIPPMCS2+81(@10)                        1472
         OC    @TS00001(1),NIPPMMK1                                1472
         CLI   @TS00001,X'FF'                                      1472
         BNE   @RF01472                                            1472
*             DO;                                                  1473
*               NIPPARC=16;         /* INDICATE EOF CONDITION  Y02752*/
         MVC   NIPPARC-NIPPAREA(4,@10),@CF00173                    @L01
*               GOTO NIPPMPXT;      /* RETURN TO CALLER        Y02752*/
         B     NIPPMPXT                                            1475
*             END;                  /*                         Y02752*/
*                                                                  1476
*           /*********************************************************/
*           /*                                                       */
*           /* DOES THE I/O ERROR REPRESENT END OF CYL?      @ZA07472*/
*           /*                                                       */
*           /*********************************************************/
*                                                                  1477
*           IF NIPPAECC='41'X&      /*                       @ZA07472*/
*               (NIPPMCS2WNIPPMMK2)='FF'X&/*                 @ZA07472*/
*               (IOBSENS1&NIPPMMK3)='20'X THEN/*             @ZA07472*/
*                                                                  1477
@RF01472 L     @10,NVTPAREA(,RNVT)                                 1477
         CLI   NIPPAECC-NIPPAREA(@10),X'41'                        @L01
         BNE   @RF01477                                            1477
         MVC   @TS00001(1),NIPPMCS2+81(@10)                        1477
         OC    @TS00001(1),NIPPMMK2                                1477
         CLI   @TS00001,X'FF'                                      1477
         BNE   @RF01477                                            1477
         MVC   @TS00001(1),IOBSENS1+72(@10)                        1477
         NC    @TS00001(1),NIPPMMK3                                1477
         CLI   @TS00001,X'20'                                      1477
         BNE   @RF01477                                            1477
*             /*******************************************************/
*             /*                                                     */
*             /* IF YES, MAKE SEEK ADDRESS POINT TO START OF NEXT    */
*             /* CYLINDER                                    @ZA07472*/
*             /*                                                     */
*             /*******************************************************/
*                                                                  1478
*             DO;                   /*                       @ZA07472*/
*               NIPPMCC=NIPPMCC+1;  /* INCREMENT SEEK@ TO NEXT CYL,
*                                                            @ZA07472*/
         AH    @10,@CH02864                                        1479
         LA    @09,1                                               1479
         AH    @09,NIPPMCC(,@10)                                   1479
         STH   @09,NIPPMCC(,@10)                                   1479
*               NIPPMHH=NIPPMHH&&NIPPMHH;/* HEAD 0,          @ZA07472*/
         XC    NIPPMHH(2,@10),NIPPMHH(@10)                         1480
*               NIPPMR='01'X;       /* AND RECORD 1          @ZA07472*/
         MVI   NIPPMR(@10),X'01'                                   1481
*               GOTO NIPPMRCR;      /* CONTINUE TO PROCESS TEXT    1482
*                                                            @ZA07472*/
         B     NIPPMRCR                                            1482
*             END;                  /*                       @ZA07472*/
*         END;                      /*                         Y02752*/
*       GOTO NIPPMTER;              /* INDICATE I/O ERROR      Y02752*/
         B     NIPPMTER                                            1485
*     END;                          /*                         Y02752*/
*   RESPECIFY                                                      1487
*     NIPPMBYT BASED(NIPPMR01);                                    1487
@RF01468 DS    0H                                                  1488
*NIPPMRCR:                          /*                       @ZA07472*/
*   NIPPMR01=ADDR(NIPPARCD);        /* R1 = ADDR OF TEXT RECORD READ
*                                      IN                            */
*                                                                  1488
NIPPMRCR L     NIPPMR01,NVTPAREA(,RNVT)                            1488
         LA    NIPPMR01,NIPPARCD-NIPPAREA(,NIPPMR01)               @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* SCAN THROUGH LEADING BLANK CHARACTERS                         */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1489
*   NIPPMBUF(73:73)='FF'X;          /* PLACE 'FF'X IN COL 73         */
         MVI   NIPPMBUF+72(NIPPMR01),X'FF'                         1489
*   NIPPMKPR=1;                     /* COUNT STARTS AT ONE           */
         MVC   NIPPMKPR(4),@CF00034                                1490
*NIPPMPBK:                                                         1491
*   IF NIPPMBYT=' '                 /* IS THIS CHAR BLANK            */
*     THEN                          /* YES - CHECK NEXT CHAR         */
NIPPMPBK CLI   NIPPMBYT(NIPPMR01),C' '                             1491
         BNE   @RF01491                                            1491
*     DO;                                                          1492
*       NIPPMR01=NIPPMR01+1;        /* POINT TO NEXT CHAR      Y02752*/
         LA    @10,1                                               1493
         ALR   NIPPMR01,@10                                        1493
*       NIPPMKPR=NIPPMKPR+1;        /* INCREMENT COUNTER       Y02752*/
         AL    @10,NIPPMKPR                                        1494
         ST    @10,NIPPMKPR                                        1494
*       IF NIPPMKPR=72              /* ARE FIRST 71 CHARS BLANK    1495
*                                                              Y02752*/
*         THEN                      /* YES-CHECK FOR CONTINUATION    */
         CH    @10,@CH02808                                        1495
         BNE   @RF01495                                            1495
*         DO;                                                      1496
*           IF NIPPMBYT^=' '        /* IS 72'ND CHAR BLK             */
*             THEN                  /* NO - INDICATES CONTINUATION   */
         CLI   NIPPMBYT(NIPPMR01),C' '                             1497
         BNE   @RT01497                                            1497
*             GO TO NIPPMPRD;       /* READ NEXT RECORD              */
*           ELSE                    /* 72ND IS BLANK - NO          1499
*                                      CONTINUATION                  */
*             GO TO NIPPMTND;       /* REG 1 POINTS TO 72ND BLANK. 1499
*                                      NORMAL RETURN TO CALLER       */
         B     NIPPMTND                                            1499
*         END;                                                     1500
*       ELSE                                                       1501
*         GO TO NIPPMPBK;           /* COUNT IS NOT 72 YET- GO CHECK
*                                      NEXT CHAR                     */
*     END;                                                         1502
*   ELSE                            /* FIRST 71 CHARS ARE NOT        */
*     DO;                           /* BLANK                         */
@RF01491 DS    0H                                                  1504
*       NIPPMKPR=NIPPMR01-NIPPMKPR+72;/* POINT TO 72'ND BYTE   Y02752*/
         LR    @10,NIPPMR01                                        1504
         SL    @10,NIPPMKPR                                        1504
         AH    @10,@CH02808                                        1504
         ST    @10,NIPPMKPR                                        1504
*       RESPECIFY                                                  1505
*         NIPPMBYT BASED(NIPPMKPR); /*                         Y02752*/
*       NIPPMBYT=' ';               /* INSURE BLANK AT END BY SETTING
*                                      72'ND BYTE TO BLK             */
         MVI   NIPPMBYT(@10),C' '                                  1506
*     END;                                                         1507
*   GENERATE REFS(NIPPMREG) SETS(NIPPMR02,NIPPMR00);               1508
*                                                                /*
*NIPPMTND  DS  0H                                               Y02752
NIPPMTND LM    NIPPMR02,NIPPMR00,NIPPMREG     RESTORE CALLERS REGS
*   GO TO NIPPMAD0;                 /* NORMAL RETURN TO CALLER       */
         L     @10,NIPPMADR                                        1509
         BR    @10                                                 1509
*NIPPMTER:                                                         1510
*   NIPPMR01=ADDR(NIPPAIOB);        /* R1 = ADDR OF PARMLIB IOB      */
*                                                                  1510
NIPPMTER L     NIPPMR01,NVTPAREA(,RNVT)                            1510
         LA    NIPPMR01,NIPPAIOB-NIPPAREA(,NIPPMR01)               @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* NIPSENSE - FORMAT AND WRITE I/O ERROR MESSAGE                 */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1511
*   GENERATE REFS(NVTSENSE,NIPPMR01) SETS(RPARM,REXIT,RENTRY);     1511
         IEAPMNIP TYPE=SENSE,PARAM=NIPPMR01
*   NIPPARC=12;                     /* SET RETURN CODE TO 12   Y02752*/
         L     @10,NVTPAREA(,RNVT)                                 1512
         MVC   NIPPARC-NIPPAREA(4,@10),@CF00036                    @L01
*   IF NIPPMNAM=NIPPANAM            /* SEE IF MEMBER NAMES MATCH   1513
*                                                              Y02752*/
*     THEN                                                         1513
         CLC   NIPPMNAM(8),NIPPANAM-NIPPAREA(@10)                  @L01
         BE    @RT01513                                            1513
*     GO TO NIPPMPXT;               /* YES-TAKE NEW VERSION EXIT   1514
*                                                              Y02752*/
*   GENERATE REFS(NIPPMREG) SETS(NIPPMR01,NIPPMR02);               1515
         LM    NIPPMR02,NIPPMR01,NIPPMREG     RESTORE CALLERS REGS
*   GO TO NIPPMAD4;                 /* READ ERROR - RETURN TO CALLER
*                                      + 4                           */
         L     @10,NIPPMADR                                        1516
         LA    @10,NIPPMAD4+4(,@10)                                1516
         BR    @10                                                 1516
*   RESPECIFY                                                      1517
*    (NIPPMR01,                                                    1517
*     NIPPMR00,                                                    1517
*     NIPPMR14,                                                    1517
*     NIPPMR15)                     /*                         Y02752*/
*         UNRESTRICTED;                                            1517
*                                                                  1517
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO PARAMETER LISTS FOR MESSAGES                  */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1518
*   GENERATE DATA;                                                 1518
*                                                                  1518
*   /*****************************************************************/
*   /*                                                               */
*   /* GENERATED MACRO PARAMETER LISTS FOR INTERFACE BRANCHES        */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1519
*   GENERATE DATA;                                                 1519
*                                                                  1520
*   /*****************************************************************/
*   /*                                                               */
*   /* LOCATE PARAMETER LIST AREA                                    */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1520
*   GENERATE DATA;                                                 1520
*                                                                  1521
*   /*****************************************************************/
*   /*                                                               */
*   /* THE NP3MATCH ROUTINE COMPARES THE LIST OF VALID         Y02752*/
*   /* PARAMETERS TO THE DATA ADDRESED BY SCANREG.             Y02752*/
*   /* RETURN CODES: MATCH FOUND - 0                           Y02752*/
*   /* NO MATCH - 4                                            Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1521
*NP3MATCH:                          /*                         Y02752
*                                                              Y02752*/
*   RESPECIFY                                                      1521
*    (SYMBLREG,                                                    1521
*     OFFSTREG,                                                    1521
*     RNVT,                                                        1521
*     SCANREG) RESTRICTED;          /*                         Y02752*/
NP3MATCH DS    0H                                                  1522
*   RESPECIFY                                                      1522
*     NP3SCAN5 BASED(SCANREG);      /*                         Y02752*/
*   RESPECIFY                                                      1523
*     OPLIBENT BASED(NP3CENT);      /*                         Y02752*/
*                                                                  1523
*   /*****************************************************************/
*   /*                                                               */
*   /* ENTRY POINT TO SYMBOL TAB SCAN                          Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1524
*   NP3MSAVR=REXIT;                 /* SAVE RETURN ADDR        Y02752*/
         ST    REXIT,NP3MSAVR                                      1524
*   INDXELMT=0;                     /* INIT INDEX              Y02752*/
*                                                                  1525
         MVI   INDXELMT,X'00'                                      1525
*   /*****************************************************************/
*   /*                                                               */
*   /* CALCULATE OFFSET TO SYMBOL TABLE                        Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1526
*NP3OFST:                                                          1526
*   OFFSTREG=INDXELMT*LENGTH(SYMBSTRT);/*                      Y02752
*                                                              Y02752*/
*                                                                  1526
NP3OFST  SLR   OFFSTREG,OFFSTREG                                   1526
         IC    OFFSTREG,INDXELMT                                   1526
         SLA   OFFSTREG,3                                          1526
*   /*****************************************************************/
*   /*                                                               */
*   /* SET BASE ADDRESS OF SYMBOL IN SYMBOL TABLE FOR VALIDITY CHECK */
*   /* ON PARAMETER                                            Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1527
*   SYMBLREG=OFFSTREG+ADDR(NP3SYMBL);/*                        Y02752
*                                                              Y02752*/
         LA    SYMBLREG,NP3SYMBL                                   1527
         ALR   SYMBLREG,OFFSTREG                                   1527
*   IF SYMBLREG>=ADDR(SYMBEND) THEN                                1528
         LA    @10,SYMBEND                                         1528
         CR    SYMBLREG,@10                                        1528
         BL    @RF01528                                            1528
*     DO;                                                          1529
*       RENTRY=4;                   /* INDICATE NO MATCH     @Y30LPXD*/
*                                                                  1530
         LA    RENTRY,4                                            1530
*       /*************************************************************/
*       /*                                                           */
*       /* UPDATE SLN TO LENGTH OF INVALID CHARACTER STRING  @Y30LPXD*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  1531
*       DO SLN=0 TO 7 BY 1 WHILE NP3SCANR^='''';/*           @Y30LPXD*/
         SLR   @10,@10                                             1531
         STC   @10,SLN                                             1531
@DL01531 CLI   NP3SCANR(SCANREG),C''''                             1531
         BE    @DC01531                                            1531
*         SCANREG=SCANREG+1;        /* UPDATE NP3SCANR BASE TO NEXT
*                                      CHARACTER             @Y30LPXD*/
         LA    SCANREG,1(,SCANREG)                                 1532
*       END;                                                       1533
         AL    @10,@CF00034                                        1533
         STC   @10,SLN                                             1533
         CH    @10,@CH00168                                        1533
         BNH   @DL01531                                            1533
@DC01531 DS    0H                                                  1534
*       SCANREG=SCANREG-SLN;        /* RESET SCANREG         @Y30LPXD*/
         SLR   @10,@10                                             1534
         IC    @10,SLN                                             1534
         SLR   SCANREG,@10                                         1534
*       GO TO NP3MSAVR;             /* RETURN TO CALLER      @Y30LPXD*/
         L     @10,NP3MSAVR                                        1535
         BR    @10                                                 1535
*     END;                                                         1536
*                                                                  1536
*   /*****************************************************************/
*   /*                                                               */
*   /* SET SYMBOL LENGTH VALUE TO MAXIMUM MINUS ONE(1)       @Y30LPXD*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1537
*   SLN=LENGTH(SYMBSTRT)-1;         /*                       @Y30LPXD
*                                                              Y02752*/
*                                                                  1537
@RF01528 LA    @10,7                                               1537
         STC   @10,SLN                                             1537
*   /*****************************************************************/
*   /*                                                               */
*   /* SET MAPPING BASE ADDRESS TO LENGTH ELEMENT IN CURRENT SYMBOL  */
*   /* TABLE ENTRY                                             Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1538
*   NP3SYMLN=SYMBLREG+SLN;          /*                         Y02752
*                                                              Y02752*/
*                                                                  1538
         ALR   @10,SYMBLREG                                        1538
         ST    @10,NP3SYMLN                                        1538
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECKS FOR SYMBOL LENGTH. IF GREATER THAN 7,THEN SYMBOL LENGTH*/
*   /* VALUE IS SET TO 8. ELSE, SYMBOL LENGTH                  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1539
*   IF NP3LCHAR>SLN                 /* IS SYMBOL LENGTH GREATER THAN
*                                      7                       Y02752*/
*     THEN                          /* YES,LENGTH GREATER THEN 7   1539
*                                                              Y02752*/
         CLC   NP3LCHAR(1,@10),SLN                                 1539
         BNH   @RF01539                                            1539
*     SLN=LENGTH(SYMBSTRT);         /* SET MAXIMUM LENGTH      Y02752*/
         MVI   SLN,X'08'                                           1540
*   ELSE                            /* NO, LENGTH NOT GREATER THEN 7
*                                                              Y02752*/
*     SLN=NP3LCHAR;                 /* SET LENGTH TO SYMBOL LENGTH 1541
*                                                              Y02752*/
*                                                                  1541
         B     @RC01539                                            1541
@RF01539 L     @10,NP3SYMLN                                        1541
         MVC   SLN(1),NP3LCHAR(@10)                                1541
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK FOR SYMBOL IN SYMBOL TABLE EQUAL TO PARAMETER     Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1542
*   IF NP3TABSB(1:SLN)=NP3SCAN5(1:SLN)/* ARE SYMBOLS EQUAL   @Y30LPXD*/
*     THEN                                                         1542
@RC01539 SLR   @10,@10                                             1542
         IC    @10,SLN                                             1542
         BCTR  @10,0                                               1542
         EX    @10,@SC02880                                        1542
         BNE   @RF01542                                            1542
*     DO;                                                          1543
*       RENTRY=0;                   /* INDICATE MATCH        @Y30LPXD*/
         SLR   RENTRY,RENTRY                                       1544
*       GOTO NP3MSAVR;              /* RETURN TO CALLER      @Y30LPXD*/
         L     @10,NP3MSAVR                                        1545
         BR    @10                                                 1545
*     END;                                                         1546
*   INDXELMT=1                      /* UPDATE INDEX FOR NEXT SYMBOL
*                                                            @Y30LPXD*/
*       +INDXELMT;                                                 1547
@RF01542 IC    @10,INDXELMT                                        1547
         LA    @10,1(,@10)                                         1547
         STC   @10,INDXELMT                                        1547
*   GOTO NP3OFST;                   /* ATTEMP ANOTHER MATCH  @Y30LPXD*/
         B     NP3OFST                                             1548
*                                                                  1549
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS ROUTINE MOVES THE ENTRIES IN THE TEMPORARY         Y02752*/
*   /* PARMTAB INTO THE PARAMETER TABLE USED BY THE RIM'S            */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1549
*NPMOVEP:                                                          1549
*   RESPECIFY                                                      1549
*    (RNVT,                                                        1549
*     SCANREG,                                                     1549
*     PLIBREG,                                                     1549
*     COUNTREG) RESTRICTED;         /*                         Y02752*/
NPMOVEP  DS    0H                                                  1550
*   RESPECIFY                                                      1550
*    (PARMREG) RESTRICTED;                                         1550
*   RESPECIFY                                                      1551
*     NIPPAHDR BASED(PARMPTR);                                     1551
*   RESPECIFY                                                      1552
*     NIPPAREA BASED(PARMPTR);                                     1552
*   RESPECIFY                                                      1553
*     OPLIBENT BASED(PLIBREG);                                     1553
*   NPMSAVE=REXIT;                  /* SAVE RETURN ADDR        Y02752*/
         ST    REXIT,NPMSAVE                                       1554
*   STRINGSZ=ORLN+CONTLN+LENGTH('''');/* GET LENGTH OF PARM STRING +
*                                      QUOTE                   Y02752*/
*                                                                  1555
         SLR   @10,@10                                             1555
         ICM   @10,3,ORLN(PLIBREG)                                 1555
         SLR   @05,@05                                             1555
         ICM   @05,3,CONTLN(PLIBREG)                               1555
         ALR   @10,@05                                             1555
         LA    @10,1(,@10)                                         1555
         STH   @10,STRINGSZ                                        1555
*   /*****************************************************************/
*   /*                                                               */
*   /* WILL THE PARM STRING FIT IN THIS PARMAREA'S FREE SPACE  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1556
*FREEAREA:                                                         1556
*   IF STRINGSZ>ADDR(NIPPAREA)+2048-NIPPABYT THEN/* NO - TRY NEXT  1556
*                                      PARMAREA                Y02752*/
FREEAREA L     @10,PARMPTR                                         1556
         LA    @05,2048                                            1556
         ALR   @05,@10                                             1556
         SL    @05,NIPPABYT-NIPPAHDR(,@10)                         @L01
         SLR   @15,@15                                             1556
         ICM   @15,3,STRINGSZ                                      1556
         CR    @05,@15                                             1556
         BNL   @RF01556                                            1556
*     DO;                                                          1557
*       IF NIPPAQ=0                 /* IS THERE ANOTHER PARMAREA ON
*                                      THE QUEUE               Y02752*/
*         THEN                                                     1558
         ICM   @05,15,NIPPAQ-NIPPAHDR(@10)                         @L01
         BNZ   @RF01558                                            1558
*         CALL NP3PAGM;             /* N0 - FREE AREA NOT FOUND GET
*                                      ANOTHER PARMAREA        Y02752*/
         BAL   @14,NP3PAGM                                         1559
*       PARMPTR=NIPPAQ;             /* POINT TO NEXT PARMAREA  Y02752*/
@RF01558 L     @10,PARMPTR                                         1560
         L     @10,NIPPAQ-NIPPAHDR(,@10)                           @L01
         ST    @10,PARMPTR                                         1560
*       GO TO FREEAREA;             /* CHECK FREE AREA         Y02752*/
         B     FREEAREA                                            1561
*     END;                          /*                         Y02752*/
*   NIPPTADR=NIPPABYT;              /* SET START ADRRESS OF PARMAREA
*                                      PARAMETERS IN PARMTAB   Y02752*/
@RF01556 L     @10,PARMPTR                                         1563
         MVC   NIPPTADR-NIPPTE(4,PARMREG),NIPPABYT-NIPPAHDR(@10)   @L01
*   RESPECIFY                                                      1564
*     NP3SCAN5 BASED(ADPTR);        /*                         Y02752*/
*   RESPECIFY                                                      1565
*     MSGBUFF BASED(NIPPABYT);      /*                         Y02752*/
*   ADPTR=ORAD;                     /* POINT TO PLIBTAB PARMETER   1566
*                                      STRING ORGIN            Y02752*/
         MVC   ADPTR(4),ORAD(PLIBREG)                              1566
*   STRINGSZ=ORLN;                  /* SET PARM STRING LENGTH      1567
*                                      (WITHOUT CONTINUATION)  Y02752*/
         MVC   STRINGSZ(2),ORLN(PLIBREG)                           1567
*   CONTDONE='0'B;                  /* SET CONT SWITCH TO ZERO Y02752*/
         NI    CONTDONE,B'11111110'                                1568
*NP3NULL:                                                          1569
*   IF NP3SCANR^='FF'X              /* IS THIS CHAR X'FF'      Y02752*/
*     THEN                          /* N0 - MOVE CHAR TO PARMTAB   1569
*                                                              Y02752*/
NP3NULL  L     @10,ADPTR                                           1569
         CLI   NP3SCANR(@10),X'FF'                                 1569
         BE    @RF01569                                            1569
*     DO;                                                          1570
*       MSGBUFF1=NP3SCANR;          /* MOVE PARAMETER FROM PLIBTAB TO
*                                      PARMTAB                 Y02752*/
         L     @05,PARMPTR                                         1571
         L     @15,NIPPABYT-NIPPAHDR(,@05)                         @L01
         MVC   MSGBUFF1(1,@15),NP3SCANR(@10)                       1571
*       NIPPABYT=NIPPABYT+1;        /* POINT TO NEXT BYTE IN PARMTAB
*                                                              Y02752*/
         LA    @14,1                                               1572
         ALR   @15,@14                                             1572
         ST    @15,NIPPABYT-NIPPAHDR(,@05)                         @L01
*       ADPTR=ADPTR+1;              /* POINT TO NEXT BYTE IN PLIBTAB
*                                                              Y02752*/
         ALR   @10,@14                                             1573
         ST    @10,ADPTR                                           1573
*       STRINGSZ=STRINGSZ-1;        /* DECREMENT STRING BY ONE Y02752*/
         SLR   @10,@10                                             1574
         ICM   @10,3,STRINGSZ                                      1574
         BCTR  @10,0                                               1574
         STH   @10,STRINGSZ                                        1574
*       IF STRINGSZ=0               /* IF ALL OF STRING HAS BEEN   1575
*                                                              Y02752*/
*         THEN                      /* MOVED, GO CHECK FOR CONT    1575
*                                                              Y02752*/
         LTR   @10,@10                                             1575
         BZ    @RT01575                                            1575
*         GO TO CONTCHK;                                           1576
*       ELSE                                                       1577
*         GO TO NP3NULL;            /* OTHERWISE,CHECK NEXT CHAR   1577
*                                                              Y02752*/
         B     NP3NULL                                             1577
*     END;                                                         1578
*   ELSE                            /* CHAR IS NULL (X'FF')    Y02752*/
*     DO;                           /* SKIP NULL CHAR AND DO   Y02752*/
@RF01569 DS    0H                                                  1580
*       ADPTR=ADPTR+1;              /* NOT MOVE TO PARMTAB     Y02752*/
         LA    @10,1                                               1580
         AL    @10,ADPTR                                           1580
         ST    @10,ADPTR                                           1580
*       STRINGSZ=STRINGSZ-1;        /* DECREMENT SIZE          Y02752*/
         SLR   @10,@10                                             1581
         ICM   @10,3,STRINGSZ                                      1581
         BCTR  @10,0                                               1581
         STH   @10,STRINGSZ                                        1581
*       GO TO NP3NULL;              /* GO CHECK NEXT CHAR      Y02752*/
         B     NP3NULL                                             1582
*     END;                          /*                         Y02752*/
*CONTCHK:                                                          1584
*   IF CONTDONE^='1'B               /* HAS CONTINUATION BEEN MOVED 1584
*                                                              Y02752*/
*     THEN                                                         1584
CONTCHK  TM    CONTDONE,B'00000001'                                1584
         BO    @RF01584                                            1584
*     DO;                           /* NO - CHECK FOR CONTINUAT    1585
*                                                              Y02752*/
*       IF CONTAD^=0                /* NO - IS THERE CINTINUAT Y02752*/
*         THEN                      /* YES - MOVE CONT         Y02752*/
         L     @10,CONTAD(,PLIBREG)                                1586
         LTR   @10,@10                                             1586
         BZ    @RF01586                                            1586
*         DO;                                                      1587
*           CONTDONE='1'B;          /* INDICATE CONTINUATION IS BEING
*                                      MOVED                   Y02752*/
         OI    CONTDONE,B'00000001'                                1588
*           ADPTR=CONTAD;           /* SET BASE TO CONT STRING Y02752*/
         ST    @10,ADPTR                                           1589
*           STRINGSZ=CONTLN;        /* SET CONT STRING LENGTH  Y02752*/
         MVC   STRINGSZ(2),CONTLN(PLIBREG)                         1590
*           GO TO NP3NULL;          /* GO DO THE MOVE          Y02752*/
         B     NP3NULL                                             1591
*         END;                      /*                         Y02752*/
*     END;                          /*                         Y02752*/
*                                                                  1593
@RF01586 DS    0H                                                  1594
*   /*****************************************************************/
*   /*                                                               */
*   /* EITHER THERE WAS NO CONTINUATION OR THE CONTINUATION    Y02752*/
*   /* HAS BEEN MOVED                                          Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1594
*   MSGBUFF1=QUOTE;                 /* ADD QUOTE TO END OF PARAMETER
*                                      STRING                  Y02752*/
@RF01584 L     @10,PARMPTR                                         1594
         L     @05,NIPPABYT-NIPPAHDR(,@10)                         @L01
         MVC   MSGBUFF1(1,@05),QUOTE                               1594
*   NIPPABYT=NIPPABYT+1;            /* UPDATE NEXT AVAILABLE BYT   1595
*                                                              Y02752*/
*                                                                  1595
         AL    @05,@CF00034                                        1595
         ST    @05,NIPPABYT-NIPPAHDR(,@10)                         @L01
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK FOR NULL REPLY Y02752                                   */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1596
*   IF NIPPTADR^=0 THEN                                            1596
         L     @10,NIPPTADR-NIPPTE(,PARMREG)                       @L01
         LTR   @10,@10                                             1596
         BZ    @RF01596                                            1596
*     DO;                                                          1597
*                                                                  1597
*       /*************************************************************/
*       /*                                                           */
*       /* CHECK FOR LIST OPTION ONLY REPLY Y02752                   */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1598
*       IF NIPPTADR->NP3SCAN8(1:3)='()''' THEN                     1598
         CLC   NP3SCAN8(3,@10),@CC02828                            1598
         BNE   @RF01598                                            1598
*         DO;                                                      1599
*                                                                  1599
*           /*********************************************************/
*           /*                                                       */
*           /* PROMPT IN NIP PROMPT MODE IF ERROR OPTION NOT         */
*           /* SPECIFIED                                             */
*           /*                                                       */
*           /*********************************************************/
*                                                                  1600
*           IF NVTSYSP='1'B&NPEPRMT='0'B THEN                      1600
         TM    NVTSYSP(RNVT),B'01000000'                           1600
         BNO   @RF01600                                            1600
         TM    NPEPRMT,B'10000000'                                 1600
         BNZ   @RF01600                                            1600
*             RETCODE=4;                                           1601
         MVC   RETCODE(4),@CF00371                                 1601
*           ELSE                                                   1602
*             DO;                   /* NORMAL EOB PROCESSING   Y02752*/
         B     @RC01600                                            1602
@RF01600 DS    0H                                                  1603
*               NIPPTCAN='1'B;      /* SET CANCEL FLAG         Y02752*/
         OI    NIPPTOPF-NIPPTE(PARMREG),B'00100000'                @L01
*               NIPPTADR=NIPPTADR&&NIPPTADR;/* ZERO ENTRY ADDR Y02752*/
         L     @10,NIPPTADR-NIPPTE(,PARMREG)                       @L01
         LR    @05,@10                                             1604
         XR    @05,@10                                             1604
         ST    @05,NIPPTADR-NIPPTE(,PARMREG)                       @L01
*             END;                  /*                         Y02752*/
*         END;                      /*                         Y02752*/
@RC01600 DS    0H                                                  1607
*     END;                          /*                         Y02752*/
@RF01598 DS    0H                                                  1608
*   GO TO NPMSAVE;                  /* RETURN TO CALLER        Y02752*/
@RF01596 L     @10,NPMSAVE                                         1608
         BR    @10                                                 1608
*                                                                  1609
*   /*****************************************************************/
*   /*                                                               */
*   /* NIP PROMPT CONTROL ROUTINE                              Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1609
*NPRMTRA3:                                                         1609
*   RESPECIFY                                                      1609
*    (RNVT,                                                        1609
*     RPARM,                                                       1609
*     SCANREG) RESTRICTED;          /*                         Y02752*/
NPRMTRA3 DS    0H                                                  1610
*   NP3RTNR=REXIT;                  /* SAVE RETURN ADDR        Y02752*/
         ST    REXIT,NP3RTNR                                       1610
*   IF RPARMNEG<0                   /* RPARM COMPLEMEMTED BY IEAPMNIP
*                                      MACRO CODE FOR OPT = ERROR  1611
*                                      PROCESSING              Y02752*/
*     THEN                                                         1611
         LTR   RPARMNEG,RPARMNEG                                   1611
         BNM   @RF01611                                            1611
*     DO;                                                          1612
*       RPARMNEG=-RPARMNEG;         /* COMPLEMENT RPARM        Y02752*/
         LCR   RPARMNEG,RPARMNEG                                   1613
*       NPEPRMT='1'B;               /* TURN ON ERROR MODE INDICATOR
*                                                              Y02752*/
         OI    NPEPRMT,B'10000000'                                 1614
*     END;                                                         1615
*   ELSE                                                           1616
*     NPEPRMT='0'B;                 /* ZERO ERROR MODE INDICATOR   1616
*                                                              Y02752*/
         B     @RC01611                                            1616
@RF01611 NI    NPEPRMT,B'01111111'                                 1616
*   NPTPARM=NP3SCAN8;               /* MOVE INPUT PARM INTO WORK AREA
*                                                              Y02752*/
@RC01611 MVC   NPTPARM(8),NP3SCAN8(RPARM)                          1617
*   SCANREG=ADDR(NPTPARM);          /* SET UP NP3SCANR BASE    Y02752*/
         LA    SCANREG,NPTPARM                                     1618
*   RESPECIFY                                                      1619
*     NP3SCAN5 BASED(SCANREG);      /* NP3SCANR BASE           Y02752*/
*                                                                  1619
*   /*****************************************************************/
*   /*                                                               */
*   /* LOCATE LAST CHAR OF INPUT PARM                          Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1620
*   DO I=8 TO 1 BY-1 WHILE NP3SCANR^=' ';                          1620
         LA    @10,8                                               1620
         STH   @10,I                                               1620
@DL01620 CLI   NP3SCANR(SCANREG),C' '                              1620
         BE    @DC01620                                            1620
*     SCANREG=SCANREG+1;            /* INCREMENT NP3SCANR BASE Y02752*/
         LA    SCANREG,1(,SCANREG)                                 1621
*   END;                            /*                         Y02752*/
*                                                                  1622
         BCTR  @10,0                                               1622
         STH   @10,I                                               1622
         LTR   @10,@10                                             1622
         BP    @DL01620                                            1622
@DC01620 DS    0H                                                  1623
*   /*****************************************************************/
*   /*                                                               */
*   /* RETURN TO CALLER IF THE PARM IS EIGHT CHARACTERS LONG AND THE */
*   /* LAST CHARACTER IS NOT AN EQUAL SIGN                     Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1623
*   IF I^<1 THEN                                                   1623
         LH    @10,I                                               1623
         CH    @10,@CH00034                                        1623
         BL    @RF01623                                            1623
*     NP3SCANR='=';                                                1624
         MVI   NP3SCANR(SCANREG),C'='                              1624
*   ELSE                                                           1625
*     DO;                                                          1625
         B     @RC01623                                            1625
@RF01623 DS    0H                                                  1626
*       SCANREG=SCANREG-1;          /* BACK UP TO LAST VALID CHAR  1626
*                                                              Y02752*/
*                                                                  1626
         BCTR  SCANREG,0                                           1626
*       /*************************************************************/
*       /*                                                           */
*       /* RETURN TO CALLER INDICATING INVALID INPUT           Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  1627
*       IF NP3SCANR^='=' THEN                                      1627
         CLI   NP3SCANR(SCANREG),C'='                              1627
         BE    @RF01627                                            1627
*         DO;                                                      1628
*           NP3SAV1='FFFFFFFF'X;    /* NEGATIVE RPARM RETURN   Y02752*/
         MVC   NP3SAV1(4),@CF02726                                 1629
*           GOTO NP3RTNR;           /* RETURN TO CALLER        Y02752*/
         L     @10,NP3RTNR                                         1630
         BR    @10                                                 1630
*         END;                      /*                         Y02752*/
*     END;                          /*                         Y02752*/
@RF01627 DS    0H                                                  1633
*   NP3SAV1=0;                      /* RPARM ZERO ON NORMAL RETURN 1633
*                                                              Y02752*/
@RC01623 SLR   @10,@10                                             1633
         ST    @10,NP3SAV1                                         1633
*   NP3SCANR='=';                   /* PLACE = SIGN IN WORKAREA    1634
*                                                              Y02752*/
         MVI   NP3SCANR(SCANREG),C'='                              1634
*   SCANREG=ADDR(NPTPARM);          /* NPMATCH INPUT PARAMETER Y02752*/
         LA    SCANREG,NPTPARM                                     1635
*   CALL NP3MATCH;                  /* MATCH INPUT PARAMETER AGAINST
*                                      THE LIST OF VALID SYSTEM    1636
*                                      PARAMETER NAMES         Y02752*/
*                                                                  1636
         BAL   @14,NP3MATCH                                        1636
*   /*****************************************************************/
*   /*                                                               */
*   /* INVALID INPUT PARM PROCESSING                           Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1637
*   IF RENTRY^=0W                   /* MATCH FOUND IF RTN CODE IS 0
*                                                              Y02752*/
*       NPTPARM(1:4)=NP3OPI(1:4)    /* OPI PROMPT INVALID      Y02752*/
*     THEN                                                         1637
         LTR   RENTRY,RENTRY                                       1637
         BNZ   @RT01637                                            1637
         CLC   NPTPARM(4),NP3OPI                                   1637
         BNE   @RF01637                                            1637
@RT01637 DS    0H                                                  1638
*     DO;                                                          1638
*       NP3SAV1='FFFFFFFF'X;        /* NEGATIVE RPARM INDICATES    1639
*                                      INVALID INPUT PARAMETER Y02752*/
         MVC   NP3SAV1(4),@CF02726                                 1639
*       GO TO NP3RTNR;              /* RETURN TO CALLER        Y02752*/
         L     @10,NP3RTNR                                         1640
         BR    @10                                                 1640
*     END;                          /*                         Y02752*/
*   RESPECIFY                                                      1642
*     NIPPTE BASED(NP3NPPRM);       /*                         Y02752*/
@RF01637 DS    0H                                                  1643
*   RESPECIFY                                                      1643
*     PARMTAB BASED(NVTPTAB);       /*                         Y02752*/
*   NP3NPPRM=NVTPTAB+               /* CALCULATE ADDR OF PARM TAB  1644
*                                      ENTRY                   Y02752*/
*       INDXELMT*LENGTH(PTABSTRT);  /* CALCULATE OFF- SET INTO     1644
*                                      PARMTAB                 Y02752*/
         SLR   @10,@10                                             1644
         IC    @10,INDXELMT                                        1644
         SLA   @10,3                                               1644
         AL    @10,NVTPTAB(,RNVT)                                  1644
         ST    @10,NP3NPPRM                                        1644
*   IF NPTPARM(1:4)=NP3PAGE(1:4) THEN/* SECOND PAGE ENTRY FOR      1645
*                                      OPERATOR SPECIFIED PARM Y02752*/
         CLC   NPTPARM(4),NP3PAGE                                  1645
         BNE   @RF01645                                            1645
*     NP3NPPRM=NP3NPPRM+LENGTH(PTABSTRT);/*                    Y02752*/
         AL    @10,@CF00156                                        1646
         ST    @10,NP3NPPRM                                        1646
*   NP3NPSBL=ADDR(SYMBSTRT)+        /* CALCULATE ADDR SYMBLE TABLE 1647
*                                      ENTRY                   Y02752*/
*       INDXELMT*LENGTH(SYMBSTRT);  /* CALCULATE OFFSET INTO SYMBLE
*                                      TABLE                   Y02752*/
@RF01645 LA    @10,SYMBSTRT                                        1647
         SLR   @05,@05                                             1647
         IC    @05,INDXELMT                                        1647
         SLA   @05,3                                               1647
         ALR   @10,@05                                             1647
         ST    @10,NP3NPSBL                                        1647
*   SCANREG=SLN-1+NP3NPSBL;         /* POINT TO LAST CHAR      Y02752*/
*                                                                  1648
         SLR   @05,@05                                             1648
         IC    @05,SLN                                             1648
         BCTR  @05,0                                               1648
         ALR   @10,@05                                             1648
         LR    SCANREG,@10                                         1648
*   /*****************************************************************/
*   /*                                                               */
*   /* PREVENT EQUAL SIGN FROM APPEARING IN MSG TEXT           Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1649
*   IF SCANREG->NP3SCANR='=' THEN                                  1649
         CLI   NP3SCANR(SCANREG),C'='                              1649
         BNE   @RF01649                                            1649
*     SLNWOE=SLN-1;                 /* PARM WITH EQUAL SIGN    Y02752*/
*                                                                  1650
         STC   @05,SLNWOE                                          1650
*   /*****************************************************************/
*   /*                                                               */
*   /* ERROR EXIT IF PROMPT IS FOR PARM WITH OUT EQUAL SIGN    Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1651
*   ELSE                                                           1651
*     DO;                                                          1651
         B     @RC01649                                            1651
@RF01649 DS    0H                                                  1652
*       NP3SAV1='FFFFFFFF'X;        /* NEGATIVE RPARM          Y02752*/
         MVC   NP3SAV1(4),@CF02726                                 1652
*       GOTO NP3RTNR;               /* RETURN TO CALLER        Y02752*/
         L     @10,NP3RTNR                                         1653
         BR    @10                                                 1653
*     END;                          /*                         Y02752*/
*   NP3SAV1=0;                      /* NEGATIVE RPARM          Y02752*/
@RC01649 SLR   @10,@10                                             1655
         ST    @10,NP3SAV1                                         1655
*   RETCODE=255;                    /* 'DO WHILE' GROUP ENTRY VALUE
*                                                              Y02752*/
         MVC   RETCODE(4),@CF02834                                 1656
*                                                                  1657
*   /*****************************************************************/
*   /*                                                               */
*   /* PROMPT UNTIL A VALID REPLY IS RECEIVED AND THEN         Y02752*/
*   /* UPDATE OPLIBTAB                                         Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1657
*   DO WHILE RETCODE^=0;            /*                         Y02752*/
         B     @DE01657                                            1657
@DL01657 DS    0H                                                  1658
*     NP3FLAG1=NP3FLAG1&&NP3FLAG1;  /* ZERO FLAGS              Y02752*/
         XC    NP3FLAG1(1),NP3FLAG1                                1658
*     NP3FLAG2=NP3FLAG2&&NP3FLAG2;  /* ZERO FLAGS              Y02752*/
*                                                                  1659
         XC    NP3FLAG2(1),NP3FLAG2                                1659
*     /***************************************************************/
*     /*                                                             */
*     /* PROMPT FOR SYSTEM PARAMETER                           Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1660
*     CALL NPPROMPT;                                               1660
*                                                                  1660
         BAL   @14,NPPROMPT                                        1660
*     /***************************************************************/
*     /*                                                             */
*     /* REPLY IS PROCESSED BY NPPROMPT IF EOB RETURNED        Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1661
*     IF NPEOB^='1'B THEN                                          1661
         TM    NPEOB,B'00000100'                                   1661
         BO    @RF01661                                            1661
*       DO;                                                        1662
*         NP3CTAB=ADDR(OPTABLN);    /* SET CURRENT TABLE PTR TO    1663
*                                      OPERATOR PARMTAB        Y02752*/
         LA    @10,OPTABLN                                         1663
         ST    @10,NP3CTAB                                         1663
*         RESPECIFY                                                1664
*          (NP3BKADR,                                              1664
*           NP3BKLN) RESTRICTED;    /*                         Y02752*/
*         NP3BKADR=ADDR(OPTABLN);   /* ADDR OF AREA TO BE CLEARED  1665
*                                                              Y02752*/
         LR    NP3BKADR,@10                                        1665
*         NP3BKLN=LENGTH(OPTABLN);  /* LENGHT OF AREA TO BE CLEARED
*                                                              Y02752*/
*                                                                  1666
         LA    NP3BKLN,L'OPTABLN                                   @L01
*         /***********************************************************/
*         /*                                                         */
*         /* CLEAR OPLIB PARM TABLE                            Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1667
*         CALL NP3CLRIT;                                           1667
         BAL   @14,NP3CLRIT                                        1667
*         RESPECIFY                                                1668
*          (NP3BKADR,                                              1668
*           NP3BKLN) UNRESTRICTED;  /*                         Y02752*/
*         SYSPRTRY='1'B;            /* INDICATE SECOND LEVEL ENTRY 1669
*                                      INTO SYSP ROUTINE       Y02752*/
         OI    SYSPRTRY,B'00000100'                                1669
*         NP3SYSPD='1'B;            /* INDICATE NOT TO READ IEASYS00
*                                      AGAIN                   Y02752*/
*                                                                  1670
         OI    NP3SYSPD,B'00010000'                                1670
*         /***********************************************************/
*         /*                                                         */
*         /* PROCESS CONTINUE REQUESTS AND BUILD SPE CHAIN FOR       */
*         /* REPLIES CHAINED ACROSS MULTIPLE BUFFERS           Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1671
*         CALL NPGETMN;                                            1671
         BAL   @14,NPGETMN                                         1671
*         SYMBLREG=NP3NPSBL;        /* ADDR SYMBLE TABLE ENTRY Y02752*/
         L     SYMBLREG,NP3NPSBL                                   1672
*         CUROPT='00'X;             /* ZERO CURRENT OPTIONS FALGS  1673
*                                                              Y02752*/
         MVI   CUROPT,X'00'                                        1673
*         NP3INID='0000'X;          /* OPERATOR INPUT          Y02752*/
*                                                                  1674
         MVC   NP3INID(2),@CB02317                                 1674
*         /***********************************************************/
*         /*                                                         */
*         /* SCAN OPERATOR REPLY AND UPDATE OPLIBTAB           Y02752*/
*         /* RETURN CODE SET: 0 - VALID ENTRY FOUND, TABLE UPDATED 4 */
*         /* - INVALID INFORMATION PRESENT ON THE REPLY        Y02752*/
*         /* 8 - SUBPARAMETER CONTINUED                        Y02752*/
*         /* 12 - ERROR MSG ISSUED                             Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1675
*         CALL NPEQCK;                                             1675
*                                                                  1675
         BAL   @14,NPEQCK                                          1675
*         /***********************************************************/
*         /*                                                         */
*         /* IF SUBPARAMETERS ARE CONTINUED ONTO A THIRD LINE, Y02752*/
*         /* NPOPCNT WILL ISSUE AN ERROR MSG AND SET THE       Y02752*/
*         /* RETURN CODE TO 12                                 Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1676
*         IF RETCODE=8              /* PARAMETER CONTINUED ON RTN 8
*                                                              Y02752*/
*           THEN                                                   1676
         CLC   RETCODE(4),@CF00156                                 1676
         BNE   @RF01676                                            1676
*           CALL NPOPCNT;                                          1677
*                                                                  1677
         BAL   @14,NPOPCNT                                         1677
*         /***********************************************************/
*         /*                                                         */
*         /* ADD REPLY TO PARMTABLE                            Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1678
*         IF RETCODE=0 THEN                                        1678
@RF01676 ICM   @10,15,RETCODE                                      1678
         BNZ   @RF01678                                            1678
*           DO;                                                    1679
*             RESPECIFY                                            1680
*               NIPPAHDR BASED(PARMPTR);/*                     Y02752*/
*             RESPECIFY                                            1681
*               NIPPAREA BASED(PARMPTR);/*                     Y02752*/
*             RESPECIFY                                            1682
*               OPLIBENT BASED(PLIBREG);/*                     Y02752*/
*             PLIBREG=ADDR(OPTABLN)+/* ADDR OPTAB ENTRY        Y02752*/
*                 INDXELMT*LENGTH(OPSPDUM1);                       1683
         LA    PLIBREG,OPTABLN                                     1683
         SLR   @10,@10                                             1683
         IC    @10,INDXELMT                                        1683
         SLA   @10,4                                               1683
         ALR   PLIBREG,@10                                         1683
*             PARMPTR=NVTPAREA;     /* POINTER TO FIRST PARM AREA  1684
*                                                              Y02752*/
         MVC   PARMPTR(4),NVTPAREA(RNVT)                           1684
*             PARMREG=NP3NPPRM;     /* POINTER TO SYSTEM PARAMETER 1685
*                                      ENTRY                   Y02752*/
*                                                                  1685
         L     PARMREG,NP3NPPRM                                    1685
*             /*******************************************************/
*             /*                                                     */
*             /* MOVE OPERATOR PARMTAB ENTRY INTO PERMANENT PARMLIB  */
*             /*                                               Y02752*/
*             /*                                                     */
*             /*******************************************************/
*                                                                  1686
*             CALL NPMOVEP;                                        1686
*                                                                  1686
         BAL   @14,NPMOVEP                                         1686
*             /*******************************************************/
*             /*                                                     */
*             /* RETURN CODE SET BY NPMOVEP IF ERROR IS DETECTED     */
*             /*                                               Y02752*/
*             /*                                                     */
*             /*******************************************************/
*                                                                  1687
*             IF RETCODE=0 THEN                                    1687
         ICM   @10,15,RETCODE                                      1687
         BNZ   @RF01687                                            1687
*               DO;                                                1688
*                 NIPPTSID='0000'X; /* MOVE OPERATOR INPUT ID INTO 1689
*                                      PARMTAB                 Y02752*/
*                                                                  1689
         L     @10,NP3NPPRM                                        1689
         MVC   NIPPTSID-NIPPTE(2,@10),@CB02317                     @L01
*                 /***************************************************/
*                 /*                                                 */
*                 /* IF LIST OPTION SPECIFIED, TURN ON LIST FLAG     */
*                 /*                                           Y02752*/
*                 /*                                                 */
*                 /***************************************************/
*                                                                  1690
*                 IF LISTOPT='1'B THEN                             1690
         TM    LISTOPT(PLIBREG),B'01000000'                        1690
         BNO   @RF01690                                            1690
*                   NIPPTLST='1'B;                                 1691
*                                                                  1691
         OI    NIPPTOPF-NIPPTE(@10),B'01000000'                    @L01
*                 /***************************************************/
*                 /*                                                 */
*                 /* IF OPERATOR CANCELED THIS PARM, TURN ON CANCEL  */
*                 /* FLAG                                      Y02752*/
*                 /*                                                 */
*                 /***************************************************/
*                                                                  1692
*                 IF NIPPTADR=0 THEN                               1692
@RF01690 L     @10,NP3NPPRM                                        1692
         ICM   @05,15,NIPPTADR-NIPPTE(@10)                         @L01
         BNZ   @RF01692                                            1692
*                   NIPPTCAN='1'B;                                 1693
         OI    NIPPTOPF-NIPPTE(@10),B'00100000'                    @L01
*                 ELSE                                             1694
*                   NIPPTCAN='0'B;  /* TURN OFF CANCEL FLAG    Y02752*/
         B     @RC01692                                            1694
@RF01692 L     @10,NP3NPPRM                                        1694
         NI    NIPPTOPF-NIPPTE(@10),B'11011111'                    @L01
*                 NIPPTOPI='0'B;    /* ZERO OPI FLAG           Y02752*/
@RC01692 L     @10,NP3NPPRM                                        1695
         NI    NIPPTOPF-NIPPTE(@10),B'01111111'                    @L01
*               END;                /* NPMOVEP ERROR DETECTED  Y02752*/
*           END;                    /* PARM TABLE ENTRY GROUP      1697
*                                      COMPLETE                Y02752*/
@RF01687 DS    0H                                                  1698
*       END;                        /* NON-EOB REPLY GROUP COMPLETE
*                                                              Y02752*/
@RF01678 DS    0H                                                  1699
*   END;                            /* 'DO WHILE' GROUP COMPLETE     */
@RF01661 DS    0H                                                  1699
@DE01657 ICM   @10,15,RETCODE                                      1699
         BNZ   @DL01657                                            1699
*   GO TO NP3RTNR;                  /* RETURN TO CALLER        Y02752*/
         L     @10,NP3RTNR                                         1700
         BR    @10                                                 1700
*   GENERATE DATA;                                                 1701
*                                                                  1702
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS ROUTINE ISSUES NIP PROMPT FUNCTION MSG'S           Y02752*/
*   /* THAT REQUIRE A REPLY FROM THE OPERATOR                  Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1702
*NPPROMPT:                                                         1702
*   RESPECIFY                                                      1702
*    (SCANREG,                                                     1702
*     RPARM,                                                       1702
*     RNVT) RESTRICTED;             /*                         Y02752*/
NPPROMPT DS    0H                                                  1703
*   NPPMTSAV=REXIT;                 /* SAVE RETURN ADDR        Y02752*/
*                                                                  1703
         ST    REXIT,NPPMTSAV                                      1703
*   /*****************************************************************/
*   /*                                                               */
*   /* INITIATE PROMPT SEQUENCE SEGMENT                        Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1704
*   DO WHILE RETCODE^=0;            /*                         Y02752*/
*                                                                  1704
         B     @DE01704                                            1704
@DL01704 DS    0H                                                  1705
*     /***************************************************************/
*     /*                                                             */
*     /* ISSUE INVALID REPLY FORMAT MESSAGE ON RETRY           Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1705
*     IF RETCODE=4 THEN                                            1705
         CLC   RETCODE(4),@CF00371                                 1705
         BNE   @RF01705                                            1705
*       DO;                                                        1706
*         GENERATE REFS(NVTWTOR) DEFS(NP3NP03M);                   1707
NP3NP03M IEAPMNIP TYPE=WTOR,PARAM=NPPLIST3
*       END;                        /* END INVALID FORMAT MSG SEGMENT
*                                                              Y02752*/
*     ELSE                                                         1709
*       DO;                         /* FIRST PROMPT MSG SEGMENT    1709
*                                                              Y02752*/
*                                                                  1709
         B     @RC01705                                            1709
@RF01705 DS    0H                                                  1710
*         /***********************************************************/
*         /*                                                         */
*         /* ISSUE FIRST PROMPT MSG WHEN OPT = ERROR NOT SPECIFIED   */
*         /*                                                   Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1710
*         IF NPEPRMT='0'B THEN                                     1710
         TM    NPEPRMT,B'10000000'                                 1710
         BNZ   @RF01710                                            1710
*           DO;                                                    1711
*             NP3PID02='        ';  /* BLANK OUT PARM NAME     Y02752*/
         MVC   NP3PID02(8),@CC01891                                1712
*             NP3PID02(1:SLNWOE)=NPSYSP(1:SLNWOE);/*           Y02752
*                                      PLACE SYSP NAME IN MESSAGE  1713
*                                      SEGMENT                 Y02752*/
         SLR   @10,@10                                             1713
         IC    @10,SLNWOE                                          1713
         BCTR  @10,0                                               1713
         L     @05,NP3NPSBL                                        1713
         EX    @10,@SM02885                                        1713
*             GENERATE REFS(NVTWTOR) DEFS(NP3NP02M);               1714
NP3NP02M IEAPMNIP TYPE=WTOR,PARAM=NPPLIST2
*           END;                    /* END OPT NOT = ERROR SEGMENT 1715
*                                                              Y02752*/
*         ELSE                                                     1716
*           DO;                                                    1716
*                                                                  1716
         B     @RC01710                                            1716
@RF01710 DS    0H                                                  1717
*             /*******************************************************/
*             /*                                                     */
*             /* ISSUE SYSP PROMPT IF OPT = ERROR SPECIFIED    Y02752*/
*             /*                                                     */
*             /*******************************************************/
*                                                                  1717
*             NP3PID01='        ';  /* BLANK OUT PARM NAME     Y02752*/
         MVC   NP3PID01(8),@CC01891                                1717
*             NP3PID01(1:SLNWOE)=NPSYSP(1:SLNWOE);/* PLACE SYSP NAME
*                                      IN MESSAGE SEGMENT      Y02752*/
         SLR   @10,@10                                             1718
         IC    @10,SLNWOE                                          1718
         BCTR  @10,0                                               1718
         L     @05,NP3NPSBL                                        1718
         EX    @10,@SM02887                                        1718
*             GENERATE REFS(NVTWTOR) DEFS(NP3NP01M);               1719
NP3NP01M IEAPMNIP   TYPE=WTOR,PARAM=NPPLIST1
*           END;                    /* END FIRST MESSAGE SEGMENT   1720
*                                                              Y02752*/
*       END;                        /* END OP = ERROR PROMPT SEGMENT */
*                                                                  1721
@RC01710 DS    0H                                                  1722
*     /***************************************************************/
*     /*                                                             */
*     /* INITIATE SCAN OF OPERATOR REPLY                       Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1722
*     NP3NCHAR=RPARM;               /* INITIATE WITH REPLY ADDR    1722
*                                                              Y02752*/
@RC01705 ST    RPARM,NP3NCHAR                                      1722
*     NP3OPSV=RPARM;                /* SAVE ADDR OPERATOR REPLY    1723
*                                                              Y02752*/
         ST    RPARM,NP3OPSV                                       1723
*     SCANREG=RPARM;                /* ESTABLISH SCAN BASE POINTER 1724
*                                                              Y02752*/
         LR    SCANREG,RPARM                                       1724
*     NP3CCHAR=RPARM;               /* INITIATE WITH REPLY ADDR    1725
*                                                              Y02752*/
         ST    RPARM,NP3CCHAR                                      1725
*     RESPECIFY                                                    1726
*       NIPSPE BASED(NP3DSPE);      /*                         Y02752*/
*     NP3DSPE=ADDR(NVTSPE);         /* FIRST SPE CHAINED OUT OF NVT
*                                                              Y02752*/
*                                                                  1727
         LA    @10,NVTSPE(,RNVT)                                   1727
         ST    @10,NP3DSPE                                         1727
*     /***************************************************************/
*     /*                                                             */
*     /* UPDATE NP3DSPE TO LAST SPE ON CHAIN                   Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1728
*     DO WHILE NIPSPEQ^=0;                                         1728
         B     @DE01728                                            1728
@DL01728 DS    0H                                                  1729
*       NP3DSPE=NIPSPEQ;            /* PICK UP SPE CHAIN PTR   Y02752*/
         L     @10,NP3DSPE                                         1729
         L     @10,NIPSPEQ(,@10)                                   1729
         ST    @10,NP3DSPE                                         1729
*     END;                                                         1730
@DE01728 SLR   @10,@10                                             1730
         L     @05,NP3DSPE                                         1730
         C     @10,NIPSPEQ(,@05)                                   1730
         BNE   @DL01728                                            1730
*     RESPECIFY                                                    1731
*       NIPPTE BASED(NP3NPPRM);                                    1731
*     RETCODE=0;                    /* ASSUME NORMAL RETURN CODE   1732
*                                                              Y02752*/
*                                                                  1732
         ST    @10,RETCODE                                         1732
*     /***************************************************************/
*     /*                                                             */
*     /* PROCESS EOB REPLY                                     Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1733
*     IF NP3SCAN2=' ''' THEN                                       1733
         CLC   NP3SCAN2(2,SCANREG),@CC01867                        1733
         BNE   @RF01733                                            1733
*       DO;                                                        1734
*                                                                  1734
*         /***********************************************************/
*         /*                                                         */
*         /* NULL REPLY NOT ALLOWED IF OPT NOT EQUAL ERROR     Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1735
*         IF NPEPRMT='0'B THEN                                     1735
         TM    NPEPRMT,B'10000000'                                 1735
         BNZ   @RF01735                                            1735
*           RETCODE=4;                                             1736
         MVC   RETCODE(4),@CF00371                                 1736
*         ELSE                                                     1737
*           DO;                                                    1737
         B     @RC01735                                            1737
@RF01735 DS    0H                                                  1738
*             NPEOB='1'B;           /* INDICATE EOB REPLY      Y02752*/
         OI    NPEOB,B'00000100'                                   1738
*             NIPPTOPI='0'B;        /* ZERO PARMTAB ENTRY OPI FLAG 1739
*                                                              Y02752*/
*             NIPPTCAN='1'B;        /* SET CANCEL INDICATOR FLAG ON
*                                                              Y02752*/
         L     @10,NP3NPPRM                                        1740
         OI    NIPPTOPF-NIPPTE(@10),B'00100000'                    @L01
         NI    NIPPTOPF-NIPPTE(@10),B'01111111'                    @L01
*             NIPPTADR=NIPPTADR&&NIPPTADR;/* ZERO PTR TO ORIGINAL  1741
*                                      PARMTAB ENTRY           Y02752*/
         L     @05,NIPPTADR-NIPPTE(,@10)                           @L01
         LR    @00,@05                                             1741
         XR    @00,@05                                             1741
         ST    @00,NIPPTADR-NIPPTE(,@10)                           @L01
*             NIPPTSID=NIPPTSID&&NIPPTSID;/* ZERO INPUT ID INDICATES
*                                      OPERATOR                Y02752*/
         XC    NIPPTSID-NIPPTE(2,@10),NIPPTSID-NIPPTE(@10)         @L01
*           END;                    /* NULL REPLY ERROR        Y02752*/
*       END;                        /* END EOB PROCESSING      Y02752*/
*                                                                  1744
*     /***************************************************************/
*     /*                                                             */
*     /* ISSUE PROMPT IF THE PROPER PARM WAS NOT SPECIFIED     Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1745
*     ELSE                                                         1745
*       DO;                                                        1745
         B     @RC01733                                            1745
@RF01733 DS    0H                                                  1746
*         RPARM=SCANREG+SLN;        /* FIRST VALUE CHARACTER   Y02752*/
*                                                                  1746
         LR    RPARM,SCANREG                                       1746
         SLR   @10,@10                                             1746
         IC    @10,SLN                                             1746
         ALR   RPARM,@10                                           1746
*         /***********************************************************/
*         /*                                                         */
*         /* DOES A VALID VALUE CHAR FOLLOW EQUAL SIGN         Y02752*/
*         /*                                                         */
*         /***********************************************************/
*                                                                  1747
*         IF RPARM->NP3SCANR=NP3COMMAWRPARM->NP3SCANR=NP3QUOTEWRPARM->
*             NP3SCANR=NP3BLANK THEN                               1747
         CLC   NP3SCANR(1,RPARM),NP3COMMA                          1747
         BE    @RT01747                                            1747
         CLC   NP3SCANR(1,RPARM),NP3QUOTE                          1747
         BE    @RT01747                                            1747
         CLC   NP3SCANR(1,RPARM),NP3BLANK                          1747
         BNE   @RF01747                                            1747
@RT01747 DS    0H                                                  1748
*           RETCODE=4;                                             1748
         MVC   RETCODE(4),@CF00371                                 1748
*         RPARM=SCANREG;            /* RESTORE RPARM           Y02752*/
@RF01747 LR    RPARM,SCANREG                                       1749
*         IF NP3SCAN7(1:SLN)^=NPSYSP(1:SLN) THEN                   1750
         SLR   @10,@10                                             1750
         IC    @10,SLN                                             1750
         BCTR  @10,0                                               1750
         L     @05,NP3NPSBL                                        1750
         EX    @10,@SC02889                                        1750
         BE    @RF01750                                            1750
*           RETCODE=4;              /* INDICATE ERROR          Y02752*/
         MVC   RETCODE(4),@CF00371                                 1751
*       END;                        /*                         Y02752*/
@RF01750 DS    0H                                                  1753
*   END;                            /* END PROMPT SEQUENCE     Y02752*/
@RC01733 DS    0H                                                  1753
@DE01704 ICM   @10,15,RETCODE                                      1753
         BNZ   @DL01704                                            1753
*   GO TO NPPMTSAV;                 /* RETURN TO CALLER        Y02752*/
         L     @10,NPPMTSAV                                        1754
         BR    @10                                                 1754
*                                                                  1755
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS ROUTINE ISSUES THE CONTINUE SYSTEM PARAMETERS MESSAGE AND*/
*   /* CHAINS THE CORRESPONDING OPERATOR REPLIES ON THE SPE QUEUE    */
*   /*                                                         Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1755
*NPGETMN:                                                          1755
*   RESPECIFY                                                      1755
*    (RNVT,                                                        1755
*     SCANREG) RESTRICTED;          /*                         Y02752*/
NPGETMN  DS    0H                                                  1756
*   NPGETSAV=REXIT;                 /* SAVE RETURN ADDR        Y02752*/
*                                                                  1756
         ST    REXIT,NPGETSAV                                      1756
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS GENERATES A GETMAIN FOR 8 BYTES FROM SUBPOOL 255, TO     */
*   /* HOUSE A NEW SPE TO BE ADDED TO THE CURRENT CHAIN OF SPE'S     */
*   /*                                                         Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1757
*   GENERATE DEFS(NP3GETMN);                                       1757
NP3GETMN GETMAIN    LC,LA=SPESZ01,A=NP3ADSPE,SP=255
*   IF GETMRTCD^=ZERO THEN          /* TEST GET OK           @ZA00093*/
         SLR   @14,@14                                             1758
         CR    GETMRTCD,@14                                        1758
         BNE   @RT01758                                            1758
*     GO TO NP3SW38;                /* WAIT STATE            @ZA00093*/
*/*                                                            Y02752*/
*                                                                  1760
*   RESPECIFY                                                      1760
*     NIPSPE BASED(NP3ADSPE);       /* RESET SPE MAPPING             */
*   NIPSPEA=NP3OPSV;                /* SET POINTER TO OPERATOR     1761
*                                      RESPECIFIED SYSTEM PARAMETERS
*                                      IN NEW SPE              Y02752*/
         L     @10,NP3ADSPE                                        1761
         MVC   NIPSPEA(4,@10),NP3OPSV                              1761
*/*                                                            Y02752*/
*                                                                  1762
*   NIPSPEQ=0;                      /* CLEAR CHAIN POINTER TO ZEROS  */
         ST    @14,NIPSPEQ(,@10)                                   1762
*/*                                                            Y02752*/
*                                                                  1763
*   RESPECIFY                                                      1763
*     NIPSPE BASED(NP3DSPE);        /* RESET SPE MAPPING TO ORIGINAL
*                                      BASE ADDRESS                  */
*   NIPSPEQ=NP3ADSPE;               /* CHAIN NEW SPE TO CURRENT SPE
*                                      QUE                     Y02752*/
         L     @05,NP3DSPE                                         1764
         ST    @10,NIPSPEQ(,@05)                                   1764
*/*                                                            Y02752*/
*                                                                  1765
*   /*****************************************************************/
*   /*                                                               */
*   /* THIS CHECKS FOR FIRST NEW SPE BEING ADDED. IF SO, IT SAVES ITS*/
*   /* ADDRESS FOR LOCATING THE ORIGIN SPE FOR OPERATOR RESPECIFIED  */
*   /* SYSTEM PARAMETERS                                       Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1765
*   IF NP3NWSPE='1'B                /* IS THIS FIRST SPE ADDED Y02752*/
*     THEN                          /* NO, IT IS NOT FIRST SPE ADDED */
         TM    NP3NWSPE,B'00010000'                                1765
         BO    @RT01765                                            1765
*     GO TO NP3SPERS;               /* BRANCH TO SPE ADDRESS RESET   */
*   ELSE                            /* YES, IT IS FIRST SPE ADDED    */
*     DO;                                                          1767
*                                                                  1767
*/*                                                            Y02752*/
*                                                                  1768
*       NP3NWSPE='1'B;              /* SET FIRST NEW SPE FLAG ON     */
         OI    NP3NWSPE,B'00010000'                                1768
*/*                                                            Y02752*/
*                                                                  1769
*       NP3FSPE=NP3ADSPE;           /* SAVE ADDRESS OF FIRST SPE     */
         ST    @10,NP3FSPE                                         1769
*     END;                                                         1770
*NP3SPERS:                                                         1771
*   NP3DSPE=NP3ADSPE;               /* SET SPE MAPPING BASE ADDRESS
*                                      TO ADDRESS OF NEW SPE   Y02752*/
NP3SPERS L     @10,NP3ADSPE                                        1771
         ST    @10,NP3DSPE                                         1771
*/*                                                            Y02752*/
*                                                                  1772
*   SCANREG=NIPSPEA;                /* POINT TO OPERATOR REPLY Y02752*/
         L     SCANREG,NIPSPEA(,@10)                               1772
*/*                                                            Y02752*/
*                                                                  1773
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECK OPERATOR REPLY FOR CONTINUATION OF PARAMETERS REQUESTED */
*   /* - "CONT". IF YES, THEN A BRANCH TO THE                  Y02752*/
*   /* NIPWTOR BRANCH INTERFACE IS TAKEN                       Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1773
*NP3RCYCL:                                                         1773
*   IF OPREPLY3=NP3RCONT            /* IS CONTINUATION REQUESTED     */
*     THEN                          /* YES,CONTINUATION OF SYSTEM  1773
*                                      PARAMETERS FROM THE OPERATOR
*                                      WAS REQUESTED           Y02752*/
NP3RCYCL CLC   OPREPLY3(4,SCANREG),NP3RCONT                        1773
         BE    @RT01773                                            1773
*     GO TO NPCSYSP;                /* BRANCH TO NIPWTOR INTERFACE 1774
*                                      CALL HANDLER            Y02752*/
*   ELSE                                                           1775
*     ;                             /* NOT "CONT", FALL THROUGH    1775
*                                                              Y02752*/
*                                                                  1775
*   /*****************************************************************/
*   /*                                                               */
*   /* CHECKS FOR END OF OPERATOR RESPECIFIED SYSTEM           Y02752*/
*   /* PARAMETERS. IF THE CURRENT CHARACTER IN THE SCAN IS A         */
*   /* QUOTE,THEN END OF RESPECIFIED PARAMETERS IS ASSUMED           */
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1776
*   IF OPREPLY4=NP3QUOTE            /* IS THIS END OF PARAMETERS     */
*     THEN                          /* YES,(A QUOTE WAS FOUND) Y02752*/
         CLC   OPREPLY4(1,SCANREG),NP3QUOTE                        1776
         BE    @RT01776                                            1776
*     GO TO NP3SPEST;               /* BRANCH TO ORIGIN NEW SPE SETUP*/
*   ELSE                            /* NO, (A QUOTE WAS NOT FOUND)   */
*/*                                                            Y02752*/
*                                                                  1778
*     DO;                                                          1778
*                                                                  1778
*/*                                                            Y02752*/
*                                                                  1779
*       SCANREG=1+SCANREG;          /* UPDATE BASE ADDRESS BY ONE FOR
*                                      RESCAN                        */
         LA    SCANREG,1(,SCANREG)                                 1779
*/*                                                            Y02752*/
*                                                                  1780
*       GO TO NP3RCYCL;             /* BRANCH TO SCAN FOR "CONT"     */
         B     NP3RCYCL                                            1780
*     END;                          /*                         Y02752*/
*NP3SPEST:                                                         1782
*   NP3DSPE=NP3FSPE;                /* SET SPE MAPPING BASE ADDRESS
*                                      TO ADDRESS OF FIRST NEW SPE 1782
*                                      ADDED TO SPE CHAIN      Y02752*/
NP3SPEST MVC   NP3DSPE(4),NP3FSPE                                  1782
*/*                                                            Y02752*/
*                                                                  1783
*   NP3NWSPE='0'B;                  /* RESET FIRST NEW SPE FLAG,OFF  */
         NI    NP3NWSPE,B'11101111'                                1783
*   GO TO NPGETSAV;                 /* RETURN TO CALLER        Y02752*/
         L     @10,NPGETSAV                                        1784
         BR    @10                                                 1784
*/*                                                            Y02752*/
*                                                                  1785
*NPCSYSP:                           /* ISSUE CONTINUE MESSAGE IF THE
*                                      NIP PROMPT FUNCTION           */
*                                                                  1785
*   /*****************************************************************/
*   /*                                                               */
*   /* IS BEING EXECUTED                                       Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1785
*   IF NVTSYSP='1'B THEN                                           1785
NPCSYSP  TM    NVTSYSP(RNVT),B'01000000'                           1785
         BNO   @RF01785                                            1785
*     DO;                                                          1786
*       NP3PID04='        ';        /* BLANK OUT NAME AREA           */
         MVC   NP3PID04(8),@CC01891                                1787
*       NP3PID04(1:SLNWOE)=NPSYSP(1:SLNWOE);/* MOVE IN PARM NAME   1788
*                                                              Y02752*/
         SLR   @10,@10                                             1788
         IC    @10,SLNWOE                                          1788
         BCTR  @10,0                                               1788
         L     @05,NP3NPSBL                                        1788
         EX    @10,@SM02892                                        1788
*       RESPECIFY                                                  1789
*         RPARM RESTRICTED;         /* PARAMETER INTERFACE REG(1)    */
*                                                                  1789
*       /*************************************************************/
*       /*                                                           */
*       /* GENERATE A BRANCH INTERFACE CALL TO THE NIPWTOR     Y02752*/
*       /* SERVICE ROUTINE IN IEAVNIPM. SEND A MESSAGE TO      Y02752*/
*       /* THE OPERATOR TELLING HIM TO CONTINUE                Y02752*/
*       /*                                                           */
*       /*************************************************************/
*                                                                  1790
*       GENERATE DEFS(NPSYSPC);                                    1790
NPSYSPC DS 0H
        IEAPMNIP TYPE=WTOR,PARAM=NPPLIST4
*     END;                                                         1791
*   ELSE                                                           1792
*     DO;                                                          1792
*                                                                  1792
         B     @RC01785                                            1792
@RF01785 DS    0H                                                  1793
*       /*************************************************************/
*       /*                                                           */
*       /* GENERATE A BRANCH INTERFACE CALL TO THE NIPWTOR     Y02752*/
*       /* SERVICE ROUTINE IN IEAVNIPM. SEND A MESSAGE TO THE        */
*       /* OPERATOR TELLING HIM TO CONTINUE SYSTEM PARAMETERS        */
*       /*                                                           */
*       /*************************************************************/
*                                                                  1793
*       GENERATE REFS(NVTWTOR) DEFS(NP3CSYSP);                     1793
NP3CSYSP DS    0H
         IEAPMNIP   TYPE=WTOR,PARAM=PLIST02  CALL WTOR SERVICE ROUTINE
*     END;                          /*                         Y02752*/
*   NP3OPSV=RPARM;                  /* SAVE ADDRESS OF OPERATOR    1795
*                                      RESPECIFIED PARAMETERS  Y02752*/
@RC01785 ST    RPARM,NP3OPSV                                       1795
*   GO TO NP3GETMN;                 /* BRANCH TO SPE GETMAIN TO GET
*                                      AN SPE FOR TRACKING         1796
*                                      RESPECIFIED PARAMETERS  Y02752*/
         B     NP3GETMN                                            1796
*NP3CLRIT:                                                         1797
*   RESPECIFY                                                      1797
*    (RNVT,                                                        1797
*     SCANREG,                                                     1797
*     NP3BKADR,                                                    1797
*     NP3BKLN) RESTRICTED;          /*                         Y02752*/
NP3CLRIT DS    0H                                                  1798
*   NP3CLRSV=REXIT;                 /* SAVE RETURN ADDRESS     Y02752*/
*                                                                  1798
         ST    REXIT,NP3CLRSV                                      1798
*   /*****************************************************************/
*   /*                                                               */
*   /* CLEAR STORAGE IN 256 BYTE BLOCKS                        Y02752*/
*   /*                                                               */
*   /*****************************************************************/
*                                                                  1799
*   DO WHILE NP3BKLN>=256;                                         1799
*                                                                  1799
         B     @DE01799                                            1799
@DL01799 DS    0H                                                  1800
*     /***************************************************************/
*     /*                                                             */
*     /* CLEAR 256 BYTES OF STORAGE                            Y02752*/
*     /*                                                             */
*     /***************************************************************/
*                                                                  1800
*     NP3CLEAR(1:256)=NP3CLEAR(1:256)&&NP3CLEAR(1:256);            1800
         XC    NP3CLEAR(256,NP3BKADR),NP3CLEAR(NP3BKADR)           1800
*     NP3BKADR=NP3BKADR+256;        /* INCREMENT START ADDR          */
         LA    @10,256                                             1801
         ALR   NP3BKADR,@10                                        1801
*     NP3BKLN=NP3BKLN-256;          /* DECREMENT LENGTH COUNT  Y02752*/
         SLR   NP3BKLN,@10                                         1802
*   END;                            /* END DO WHILE GROUP      Y02752*/
@DE01799 CH    NP3BKLN,@CH01457                                    1803
         BNL   @DL01799                                            1803
*/*                                                            Y02752*/
*                                                                  1804
*   IF NP3BKLN>0 THEN                                              1804
         LTR   NP3BKLN,NP3BKLN                                     1804
         BNP   @RF01804                                            1804
*     NP3CLEAR(1:NP3BKLN)=NP3CLEAR(1:NP3BKLN)&&NP3CLEAR(1:NP3BKLN);
         LR    @10,NP3BKLN                                         1805
         BCTR  @10,0                                               1805
         EX    @10,@SX02894                                        1805
*   GO TO NP3CLRSV;                 /* RETURN TO CALLER        Y02752*/
@RF01804 L     @10,NP3CLRSV                                        1806
         BR    @10                                                 1806
*   RESPECIFY                                                      1807
*    (NP3BKADR,                                                    1807
*     NP3BKLN) UNRESTRICTED;        /*                         Y02752*/
*NP3EXIT:                                                          1808
*   RESPECIFY                                                      1808
*     RPARM RESTRICTED;             /*                         Y02752*/
NP3EXIT  DS    0H                                                  1809
*   RPARM=NP3SAV1;                  /*                         Y02752*/
         L     RPARM,NP3SAV1                                       1809
*   GENERATE REFS(NP3R13);                                         1810
          L     @13,NP3R13                                       Y02752
*   END IEAVNP03                    /* END OF PROCEDURE - IEAVNP03   */
*                                                                  1811
*/* THE FOLLOWING INCLUDE STATEMENTS WERE FOUND IN THIS PROGRAM.     */
*/*%INCLUDE SYSLIB  (IEZIOB  )                                       */
*/*%INCLUDE SYSLIB  (IHAECB  )                                       */
*/*%INCLUDE SYSLIB  (IHANVT  )                                       */
*/*%INCLUDE SYSLIB  (IEAPMNIP)                                       */
*/*%INCLUDE SYSLIB  (IEAPPNIP)                                       */
*/*%INCLUDE SYSLIB  (CVT     )                                       */
*/*%INCLUDE SYSLIB  (IEFUCBOB)                                       */
*/*%INCLUDE SYSLIB  (IEAPSPIO)                                       */
*                                                                  1811
*       ;                                                          1811
@EL00001 DS    0H                                                  1811
@EF00001 DS    0H                                                  1811
@ER00001 LM    @14,@00,12(@13)                                     1811
         LM    @02,@12,28(@13)                                     1811
         BR    @14                                                 1811
@DATA    DS    0H
@CH00261 DC    H'3'
@CH00170 DC    H'5'
@CH00168 DC    H'7'
@CH00210 DC    H'15'
@CH02133 DC    H'44'
@CH02625 DC    H'51'
@CH02864 DC    H'64'
@CH02808 DC    H'72'
@CH01457 DC    H'256'
@CH02860 DC    Y(L'PARMTAB*2)                                      @L01
@CH02180 DC    H'2048'
@SM02878 MVC   0(0,@01),NP3FILL
@SC02880 CLC   NP3TABSB(0,SYMBLREG),NP3SCAN5(SCANREG)
@SM02885 MVC   NP3PID02(0),NPSYSP(@05)
@SM02887 MVC   NP3PID01(0),NPSYSP(@05)
@SC02889 CLC   NP3SCAN7(0,SCANREG),NPSYSP(@05)
@SM02892 MVC   NP3PID04(0),NPSYSP(@05)
@SX02894 XC    NP3CLEAR(0,NP3BKADR),NP3CLEAR(NP3BKADR)
         DS    0F
         DS    0F
@CF00034 DC    F'1'
@CH00034 EQU   @CF00034+2
@CF00371 DC    F'4'
@CH00371 EQU   @CF00371+2
@CF00156 DC    F'8'
@CH00156 EQU   @CF00156+2
@CF00036 DC    F'12'
@CF00173 DC    F'16'
@CF02834 DC    F'255'
@CF02726 DC    XL4'FFFFFFFF'
         DS    0D
NP3SAV1  DS    A
UCBPTR   DS    A
IOBSTPTR DS    A
ECBPTR   DS    A
NP3GBFR  DS    A
NP3DSPE  DS    A
NP3CTAB  DS    A
NP3CENT  DS    A
NP3NCHAR DS    A
NP3TSPE  DS    A
NP3OPSV  DS    A
NP3ADSPE DS    A
NP3PBFR  DS    A
NP3FSPE  DS    A
NP3RTRN  DS    A
NP3PRTRN DS    A
NP3CCHAR DS    A
NP3SYMLN DS    A
NP3EQADR DS    A
NP3BALCK DS    A
NP3SRTRN DS    A
NP3LKCNT DS    A
NP3PAREA DS    A
NP3PAREN DS    F
NP3LST03 DC    AL4(PLIST03)
NP3LST04 DC    AL4(PLIST04)
NP3LST05 DC    AL4(PLIST05)
NP3LST06 DC    AL4(PLIST06)
NP3LST07 DC    AL4(PLIST07)
NP3RTADR DS    A
NP3SYPAD DS    A
NP3POADR DS    A
PRENDPTR DS    A
PARMBASE DS    A
SAVESCAN DS    A
SAVEONE  DS    A
NP3MSG08 DC    AL4(MESG08)
PARMQPTR DS    A
PARMPTR  DS    A
ADPTR    DS    A
GETAREA  DS    A
GETPTR   DS    A
NP3R13   DS    A
NPMSAVE  DS    A
NP3MSAVR DS    A
NP3CLRSV DS    A
NPGETSAV DS    A
NPPMTSAV DS    A
NP3NPPRM DS    A
NP3RTNR  DS    A
NP3NPSBL DS    A
NP3SLR13 DS    A
RETCODE  DS    A
NPRMRTN1 DS    A
LCNAMPTR DC    AL4(LCNAM)
MSG08PT  DC    AL4(MESG08)
MSG12APT DC    AL4(MESG12A)
MSG14APT DC    AL4(MESG14A)
STRGLN   DS    F
PTRSAVE  DS    A
R2SAVE   DS    A
NIPPMADR DS    A
NIPPMKPR DS    A
NIPPMNEG DC    XL4'FFFFFFFF'
NIPPMBDL DS    A
NIPPMDCB DS    A
SAVMYBAS DS    F
I        DS    H
#MEMBERS DS    H
#PROCESD DS    H
INDXELMT DS    AL1
SLN      DS    AL1
NP3MELNG DS    AL1
SLNWOE   DS    AL1
NP3ERLNG DS    AL1
@TS00001 DS    CL1
@CC01891 DC    C'        '
@CC02498 DC    C'SYSP='
@CC01908 EQU   @CC02498
@CC02504 DC    C'(,L)'
@CC02723 DC    C'OPI='
@CC02486 DC    C'YES'
@CC02828 DC    C'()'''
@CC01867 DC    C' '''
@CC01913 DC    C'00'
@CC02448 DC    C'AA'
@CC02449 DC    C'99'
@CC02487 DC    C'NO'
@CC02547 EQU   @CC01891
@CC02718 DC    C'L,'
@CC02720 DC    C'L)'
@CB02424 DC    X'00000000000000000000000000000000'
@CB02796 EQU   @CB02424
@CB01889 DC    X'4DFFFF5D'
@CB02726 DC    X'FFFFFFFF'
@CB02729 EQU   @CB02726
@CB02317 EQU   @CB02424
@CB02728 EQU   @CB02726
NP3UQ    DC    CL2'U'''
NP3BLNKQ DC    CL2' '''
NP3UCLQ  DC    CL4'U,L'''
NP3RCONT DC    CL4'CONT'
NP3CLWU  DC    CL3',L'''
NP3QUOTE DC    CL1''''
NP3OPIMG DC    CL3'OPI'
NP3BLANK DC    CL1' '
NP3EQUAL DC    CL1'='
NP3COMMA DC    CL1','
RPAREN   DC    CL1')'
LPAREN   DC    CL1'('
NP3FILL  DC    CL8'        '
PARMLIB  DC    CL12'SYS1.PARMLIB'
LINKLIB  DC    CL12'SYS1.LINKLIB'
BLDLHEAD DC    X'0001000E'
CONTCHAR DC    CL5'CONT'''
IEASYS   DS    CL8
         ORG   IEASYS
@NM00083 DC    CL6'IEASYS'
LISTNAM  DS    CL2
         ORG   IEASYS+8
QUOTE    DC    CL1''''
SYSPCHAR DC    CL4'SYSP'
LNKLST   DS    CL8
         ORG   LNKLST
LNKLSTNM DC    CL6'LNKLST'
LNKLST00 DC    CL2'00'
         ORG   LNKLST+8
UNDKEY   DC    CL20'UNDEFINED KEYWORD  '
IMPDEL   DC    CL20'IMPROPER DELIMETER  '
INVCON   DC    CL20'INVALID CONTINUATION'
INVOPI   DC    CL20'INVALID OPI KEYWORD '
IMBPAR   DC    CL20'UNBALANCED PARENS   '
NP3FLAGS DS    CL3
         ORG   NP3FLAGS
NP3FLAG1 DS    CL1
         ORG   NP3FLAG1
NP3CONT  DS    BL1
NP3INVLD EQU   NP3FLAG1+0
NP3ADBFR EQU   NP3FLAG1+0
NP3NWSPE EQU   NP3FLAG1+0
NP3SUBCK EQU   NP3FLAG1+0
SYSPRTRY EQU   NP3FLAG1+0
NP3SYHDR EQU   NP3FLAG1+0
CONTDONE EQU   NP3FLAG1+0
         ORG   NP3FLAGS+1
NP3FLAG2 DS    CL1
         ORG   NP3FLAG2
NP3HDMSG DS    BL1
MULTSYSP EQU   NP3FLAG2+0
NP3SYLST EQU   NP3FLAG2+0
NP3SYSPD EQU   NP3FLAG2+0
@NM00086 EQU   NP3FLAG2+0
NPEOB    EQU   NP3FLAG2+0
@NM00087 EQU   NP3FLAG2+0
@NM00088 EQU   NP3FLAG2+0
         ORG   NP3FLAGS+2
NP3FLAG3 DS    CL1
         ORG   NP3FLAG3
NPEPRMT  DS    BL1
@NM00089 EQU   NP3FLAG3+0
         ORG   NP3FLAGS+3
         DS    CL2
         SPACE 1
*----------------------------------------------------------------* @L01
*        Reserve space for operator parmtab.  The operator       * @L01
*        parmtab will contain flags and pointers to              * @L01
*        values of system parameters entered from the            * @L01
*        console.                                                * @L01
*----------------------------------------------------------------* @L01
OPTABLN  DS    CL(L'PARMTAB*2)                                     @L01
         SPACE 1                                                   @L01
*----------------------------------------------------------------* @L01
*        Reserve space for SYS1.PARMLIB parmtab.  The            * @L01
*        SYS1.PARMLIB parmtab will contain flags and             * @L01
*        pointers to values of system parameters read            * @L01
*        from SYS1.PARMLIB.                                      * @L01
*----------------------------------------------------------------* @L01
PTABLN   DS    CL(L'PARMTAB*2)                                     @L01
         SPACE 1                                                   @L01
NP3INID  DS    CL2
         DS    CL2
NP3SZ01  DS    CL8
         ORG   NP3SZ01
SPESZ01  DS    CL4
         ORG   SPESZ01
SPESZ02  DC    X'80'
SPESZ03  DC    AL3(8)
         ORG   NP3SZ01+4
PAREA01  DS    CL4
         ORG   PAREA01
PAREA02  DC    X'80'
PAREA03  DC    AL3(2048)
         ORG   NP3SZ01+8
         SPACE 1
*----------------------------------------------------------------* @L01
*        Define system parameters table.                         * @L01
*----------------------------------------------------------------* @L01
NP3SYMB# DS    0C                                                  @L01
         IEAPPNIP TYPE=GENERATE                                    @L01
NP3SYMBL EQU   NP3SYMB#,*-NP3SYMB#                                 @L01
         SPACE 1
NP3CCW   DS    CL32
         ORG   NP3CCW
@NM00129 DS    CL8
         ORG   @NM00129
SRCH     DC    X'31'
SRCHAD   DC    AL3(NIPPASID-NIPPAREA)                              @L01
SRCHFLG  DC    X'4000'
SRCHCNT  DC    X'0005'
         ORG   NP3CCW+8
@NM00130 DS    CL8
         ORG   @NM00130
TIC      DC    X'08'
TICAD    DC    AL3(NP3CCW)
TICFLG   DC    X'0000'
TICCNT   DC    X'0000'
         ORG   NP3CCW+16
@NM00131 DS    CL8
         ORG   @NM00131
RDDAT    DC    X'06'
RDDATAD  DC    AL3(NIPPARCD-NIPPAREA)                              @L01
RDDATFLG DC    X'6000'
RDDATCNT DC    X'0050'
         ORG   NP3CCW+24
@NM00132 DS    CL8
         ORG   @NM00132
RDCNT    DC    X'92'
RDCNTAD  DC    AL3(NIPPASID-NIPPAREA)                              @L01
RDCNTFLG DC    X'0000'
RDCNTCNT DC    X'0008'
         ORG   NP3CCW+32
RPLYBUF  DS    CL80
STRINGSZ DS    CL2
CUROPT   DC    X'00'
         ORG   CUROPT
COPIOPT  DS    BL1
CLISTOPT EQU   CUROPT+0
CURCANOP EQU   CUROPT+0
@NM00133 EQU   CUROPT+0
         ORG   CUROPT+1
NPTPARM  DS    CL8
ALLDONE  DS    BL1
BADLNK   DC    CL8'LNK'
LNKMEM   DS    CL8
         ORG   LNKMEM
@NM00134 DS    CL6
NUMBER   DS    CL2
         ORG   LNKMEM+8
TRTTAB   DS    CL256
         ORG   TRTTAB
@NM00135 DC    77X'04'
@NM00136 DC    X'03'
@NM00137 DC    13X'04'
@NM00138 DC    X'00'
@NM00139 DC    X'04'
@NM00140 DC    X'08'
@NM00141 DC    13X'04'
@NM00142 DC    X'05'
@NM00143 DC    15X'04'
@NM00144 DC    2X'00'
@NM00145 DC    X'01'
@NM00146 DC    3X'04'
@NM00147 DC    9X'00'
@NM00148 DC    7X'04'
@NM00149 DC    9X'00'
@NM00150 DC    8X'04'
@NM00151 DC    8X'00'
@NM00152 DC    23X'04'
@NM00153 DC    9X'00'
@NM00154 DC    7X'04'
@NM00155 DC    9X'00'
@NM00156 DC    8X'04'
@NM00157 DC    8X'00'
@NM00158 DC    6X'04'
@NM00159 DC    10X'00'
@NM00160 DC    6X'04'
         ORG   TRTTAB+256
NIPPMMBC DS    CL8
         ORG   NIPPMMBC
NIPPMMBB DS    CL3
NIPPMCCH DS    CL5
         ORG   NIPPMMBC+8
NIPPMMK1 DC    B'11110010'
NIPPMMK2 DC    B'11110001'
NIPPMMK3 DC    B'00100000'
NIPPMNAM DC    CL8' '
         DS    CL1
NIPPMREG DS    16F
SAVEREGS DS    18F
IEAVNP03 CSECT
         DS   0H
PATCHLOC DC ((@DATA-@PSTART)/20)X'00'
IEAVNP03 CSECT
*                              /*
*NIPPMMS1 DS   0F                                               Y02752
NIPPMMS1 DS    0F                                               Y02752
         IEAPMNIP TYPE=HEADER,MSGST=NIPPMMS1,MSGEND=NIPPMED1    Y02752
         DC    CL34'IEA300I I/O ERROR DURING BLDL FOR '
*NIPPMMB1  EQU *                                                Y02752
NIPPMMB1 DC    CL8'        '
         DC    CL16' IN SYS1.PARMLIB'
*NIPPMED1 EQU   *                                               Y02752
NIPPMED1 EQU   *                                                Y02752
         SPACE 1
*NIPPMMS2 DS    0F                                              Y02752
NIPPMMS2 DS    0F                                               Y02752
         IEAPMNIP TYPE=HEADER,MSGST=NIPPMMS2,MSGEND=NIPPMED2
         DC    CL8'IEA301I '
*NIPPMMB2 EQU  *                                                Y02752
NIPPMMB2 DC    CL8'        '                                    Y02752
         DC    CL26' NOT FOUND IN SYS1.PARMLIB'
*NIPPMED2 EQU   *                                               Y02752
NIPPMED2 EQU   *                                                Y02752
IEAVNP03 CSECT
RMESG    DS    0F                  DUMMY REPLY BUFFER
PLIST01  EQU   *                   START OF PARAMETER LIST
         IEAPMNIP   TYPE=PLIST,RMSGST=SQARBUF,RMSGL=0,MSGST=MESG01,    X
               ASYNCH='NO'
         SPACE 1
PLIST02  DS    0F                  START OF PARAMETER LIST
         IEAPMNIP   TYPE=PLIST,RMSGST=SQARBUF,RMSGL=0,MSGST=MESG02,    X
               ASYNCH='NO'
         SPACE 1
PLIST03  DS    0F                  NIPMOUNT PARAMETER LIST START
         IEAPMNIP   TYPE=MOUNTPL,PARAM=SYS1.LINKLIB
         SPACE 1
PLIST04  DS    0F                  NIPOPEN PARAMETER LIST START
         IEAPMNIP   TYPE=OPENPL,PARAM=SYS1.LINKLIB
         SPACE 1
PLIST05  DS    0F
         IEAPMNIP   TYPE=OPENPL,PARAM=SYS1.PARMLIB
         SPACE 1
PLIST06  DS    0F         NIP MOUNT FOR LINKLIB CONCATENATION
         IEAPMNIP TYPE=MOUNTPL,OPT=PTR
         SPACE 1
PLIST07  DS    0F         NIP OPEN FOR LINKLIB CONCATENATION
         IEAPMNIP TYPE=OPENPL,OPT=PTR
         SPACE 1
PLIST10  DS    0F
         IEAPMNIP TYPE=PLIST,RMSGST=RPLYBUF,RMSGL=80,MSGST=MESG10,     X
               ASYNCH='NO'
         SPACE 1
MESG01   DS    0F                  MESSAGE START ADDRESS
         IEAPMNIP   TYPE=HEADER,MSGST=MESG01,MSGEND=MEND01
         DC    CL39'IEA320A  RESPECIFY PARAMETERS OR CANCEL'
MEND01   EQU   *                   MESSAGE END ADDRESS
         SPACE 1
MESG02   DS    0F                  MESSAGE STSRT ADDRESS
         IEAPMNIP   TYPE=HEADER,MSGST=MESG02,MSGEND=MEND02
         DC    CL35'IEA116A  CONTINUE SYSTEM PARAMETERS'
MEND02   EQU   *                   MESSAGE END ADDRESS
         SPACE 1
MESG03   DS    0F                  MESSAGE STSRT ADDRESS
         IEAPMNIP   TYPE=HEADER,MSGST=MESG03,MSGEND=MEND03
         DC    CL9'IEA107I  '
MESG03B  DC    CL7'       '
MESG03L  DC    CL1' '
         DC    CL8' IGNORED'
MEND03   EQU   *                   MESSAGE END ADDRESS
         SPACE 1
MESG04   DS    0F                  MESSAGE START ADDRESS
         IEAPMNIP   TYPE=HEADER,MSGST=MESG04,MSGEND=MEND04
         DC    CL34'IEA321I  INVALID PARAMETER SYNTAX '
MESG04B  DC    CL8'        '
         DC   CL3' - '
MESG04C  DC   CL20'                    '
MEND04   EQU   *                   MESSAGE END ADDRESS
         SPACE 1
MESG05   DS    0F                  MESSAGE START ADDRESS
         IEAPMNIP   TYPE=HEADER,MSGST=MESG05,MSGEND=MEND05
         DC    CL45'IEA216I  GETMAIN FAILED DURING INITIALIZATION'
MEND05   EQU   *                   MESSAGE END ADDRESS
         SPACE 1
MESG06   DS    0F                  MESSAGE START ADDRESS
         IEAPMNIP   TYPE=HEADER,MSGST=MESG06,MSGEND=MEND06
         DC    CL27'IEA326I  LOCATE FAILED FOR '
MESG06B  DC    CL12'            '
MEND06   EQU   *                   MESSAGE END ADDRESS
         SPACE 1
MESG07   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG07,MSGEND=MEND07
         DC    CL8'IEA324I '
MESG07A  DC    CL4'    '
         DC    CL21' INPUT TERMINATED IN '
MESG07B  DC    CL8'        '
MEND07   EQU   *
         SPACE 1
MESG08   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG08,MSGEND=MEND08
MESG08A  DC    CL30'                              '
         DC    CL41'                                         '
MEND08   EQU   *
         SPACE 1
MESG09   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG09,MSGEND=MEND09
         DC    CL23'IEA323I OPI INVALID IN '
MESG09A  DC    CL8'        '
MEND09   EQU   *
         SPACE 1
MESG10   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG10,MSGEND=MEND10
         DC    CL16'IEA322A INVALID '
MESG10A  DC    CL4'    '
         DC    CL27' PARM - RESPECIFY OR CANCEL'
MEND10   EQU   *
         SPACE 1
MESG11   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG11,MSGEND=MEND11
         DC    CL8'IEA208I '
MESG11A  DC    CL6'      '
         DC    CL21' FUNCTION INOPERATIVE'
MEND11   EQU   *
         SPACE 1
MESG12   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG12,MSGEND=MEND12
         DC    CL8'IEA328I '
MESG12B   DC     CL8'LNKLST00'
          DC     CL20' INPUT TRUNCATED AT '
MESG12A  DC    CL44'                                            '
MEND12   EQU   *
         SPACE 1
MESG13   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG13,MSGEND=MEND13
         DC    CL41'IEA327I LINK LIBRARY DATA SETS NOT FOUND'
MEND13   EQU   *
         SPACE 1
MESG14   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG14,MSGEND=MEND14
MESG14A  DC    CL44'                                            '
MEND14   EQU   *
         SPACE 1
MESG17   DS    0F
         IEAPMNIP TYPE=HEADER,MSGST=MESG17,MSGEND=MEND17
         DC    CL14'IEA325I IEASYS'
MESG17A  DC    CL2'  '
         DC    CL15' PARAMETER LIST'
MEND17   EQU   *
         SPACE 1
IEAVNP03 CSECT
LOCLIB   CAMLST     NAME,LCNAM,,LCDIR  LOCATE PARAMETER LIST
LCNAM    DC    CL44'SYS1.LINKLIB                                '
         DS    0D
LCDIR    DS    265C                    VOLUME LIST READIN AREA
IEAVNP03 CSECT
MESGNP01   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP  TYPE=HEADER,MSGST=MESGNP01,MSGEND=MENDNP01  Y02752
           DC  CL18'IEA906A RESPECIFY '                          Y02752
NP3PID01   DC  CL8'        '                                     Y02752
           DC  CL19'PARM OR ENTER EOB  '                         Y02752
MENDNP01   EQU *                                                 Y02752
           SPACE 1                                               Y02752
MESGNP02   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP  TYPE=HEADER,MSGST=MESGNP02,MSGEND=MENDNP02  Y02752
           DC  CL16'IEA332A SPECIFY '                            Y02752
NP3PID02   DC  CL8'        '                                     Y02752
MENDNP02   EQU *                                                 Y02752
           SPACE 1                                               Y02752
MESGNP03   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP  TYPE=HEADER,MSGST=MESGNP03,MSGEND=MENDNP03  Y02752
           DC  CL34'IEA310A INVALID REPLY - RESPECIFY '          Y02752
MENDNP03   EQU *                                                 Y02752
NP3PID03   DC  CL8'        '                                     Y02752
           SPACE 1                                               Y02752
MESGNP04   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP  TYPE=HEADER,MSGST=MESGNP04,MSGEND=MENDNP04  Y02752
           DC  CL17'IEA330A CONTINUE '                           Y02752
NP3PID04   DC  CL8'        '                                     Y02752
           DC  CL5'PARM '                                        Y02752
MENDNP04   EQU *                                                 Y02752
           SPACE 1                                               Y02752
NPPLIST1   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP TYPE=PLIST,RMSGST=SQARBUF,MSGST=MESGNP01     Y02752
           SPACE 1                                               Y02752
NPPLIST2   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP TYPE=PLIST,RMSGST=SQARBUF,MSGST=MESGNP02     Y02752
           SPACE 1                                               Y02752
NPPLIST3   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP TYPE=PLIST,RMSGST=SQARBUF,MSGST=MESGNP03     Y02752
           SPACE 1                                               Y02752
NPPLIST4   DS  0F                  MESSAGE START ADDR            Y02752
           IEAPMNIP TYPE=PLIST,RMSGST=SQARBUF,MSGST=MESGNP04     Y02752
IEAVNP03 CSECT
@00      EQU   00                      EQUATES FOR REGISTERS 0-15
@01      EQU   01
@02      EQU   02
@03      EQU   03
@04      EQU   04
@05      EQU   05
@06      EQU   06
@07      EQU   07
@08      EQU   08
@09      EQU   09
@10      EQU   10
@11      EQU   11
@12      EQU   12
@13      EQU   13
@14      EQU   14
@15      EQU   15
SCANREG  EQU   @08
RPARM    EQU   @01
RPARMNEG EQU   @01
RPRM1    EQU   @01
BFRADDR  EQU   @04
OPERREG  EQU   @07
PARMREG  EQU   @04
PLIBREG  EQU   @07
INDEXREG EQU   @05
COUNTREG EQU   @06
SYMBLREG EQU   @09
OFFSTREG EQU   @04
GETMRTCD EQU   @15
LOCREG   EQU   @15
CVTPTR   EQU   @03
DSNCTR   EQU   @06
IOBPRPTR EQU   @09
RNVT     EQU   @02
RCVT     EQU   @03
REXIT    EQU   @14
RENTRY   EQU   @15
NP3BKLN  EQU   @07
NP3BKADR EQU   @04
NIPPMR00 EQU   @00
NIPPMR01 EQU   @01
NIPPMR02 EQU   @02
NIPPMR13 EQU   @13
NIPPMR14 EQU   @14
NIPPMR15 EQU   @15
LNGTHFLD EQU   @07
NIPPMR06 EQU   @06
NIPPMR09 EQU   @09
NIPPMR12 EQU   @12
UCBDCPTR EQU   @09
IOBPREFX EQU   0
IOBCFLG1 EQU   IOBPREFX
IOBSTDRD EQU   0
IOBFLAG1 EQU   IOBSTDRD
IOBCYCCK EQU   IOBFLAG1
IOBRSTRT EQU   IOBFLAG1
IOBFLAG2 EQU   IOBSTDRD+1
IOBPURGE EQU   IOBFLAG2
IOBRDHA0 EQU   IOBFLAG2
IOBSENS0 EQU   IOBSTDRD+2
IOBS0B7  EQU   IOBSENS0
IOBSENS1 EQU   IOBSTDRD+3
IOBECBPT EQU   IOBSTDRD+4
IOBFLAG3 EQU   IOBSTDRD+8
IOBFL3   EQU   IOBFLAG3
IOBCNC   EQU   IOBFL3
IOBICL   EQU   IOBFL3
IOBCSW   EQU   IOBSTDRD+9
IOBIOCSW EQU   IOBCSW
IOBSTBYT EQU   IOBIOCSW+3
IOBUSTAT EQU   IOBSTBYT
IOBCSTAT EQU   IOBSTBYT+1
IOBSTART EQU   IOBSTDRD+16
IOBDCBPT EQU   IOBSTDRD+20
IOBFLAG4 EQU   IOBDCBPT
IOBRESTR EQU   IOBSTDRD+24
IOBINCAM EQU   IOBSTDRD+28
IOBBTAMF EQU   IOBINCAM
IOBERRCT EQU   IOBSTDRD+30
ECB      EQU   0
ECBRB    EQU   ECB
ECBEVTB  EQU   ECBRB
ECBEXTB  EQU   ECBEVTB
ECBCC    EQU   ECBEXTB
ECBCCCNT EQU   ECBEXTB+1
ECBRBA   EQU   ECBCCCNT
ECBEVTBA EQU   ECBRBA
ECBEXTBA EQU   ECBEVTBA
ECBBYTE3 EQU   ECBEXTBA+2
ECBEXTND EQU   ECBBYTE3
NVT      EQU   0
NVTNPATR EQU   NVT+54
NVTNPREN EQU   NVTNPATR
NVTFLLB  EQU   NVT+55
NVTABSAV EQU   NVT+140
NVTFLCN  EQU   NVT+211
NVTWTPSW EQU   NVT+224
NVTWPSW2 EQU   NVTWTPSW+4
NVTFLWSC EQU   NVTWPSW2+3
NVTLOAD  EQU   NVT+232
NVTSENSE EQU   NVT+236
NVTSWAIT EQU   NVT+240
NVTTIME  EQU   NVT+244
NVTUCBFN EQU   NVT+248
NVTWTO   EQU   NVT+252
NVTWTOR  EQU   NVT+256
NVTWTOR2 EQU   NVT+260
NVTOPEN  EQU   NVT+264
NVTMOUNT EQU   NVT+268
NVTVIRT  EQU   NVT+276
NVTREAL  EQU   NVT+280
NVTSCHED EQU   NVT+284
NVTOPIO  EQU   NVT+288
NVTSPE   EQU   NVT+344
NVTPAREA EQU   NVT+368
NVTPTAB  EQU   NVT+372
NVTSPUCB EQU   NVT+382
NVTXCTL  EQU   NVT+428
NVTLOCAT EQU   NVT+436
NVTFLPO  EQU   NVT+528
NVTFLLST EQU   NVTFLPO
NVTSYSP  EQU   NVTFLPO
NWTOHDR  EQU   0
NWTOLNG  EQU   NWTOHDR
NWTOFL   EQU   NWTOHDR+2
NWTORLST EQU   0
NWTORFL  EQU   NWTORLST+10
NIPSPE   EQU   0
NIPSPEQ  EQU   NIPSPE
NIPSPEA  EQU   NIPSPE+4
NIPMNTPL EQU   0
NMNTDS   EQU   NIPMNTPL
NMNTDSA  EQU   NMNTDS
NMNTVS   EQU   NIPMNTPL+12
NMNTDT   EQU   NIPMNTPL+18
NMNTFL   EQU   NIPMNTPL+20
NIPOPNPL EQU   0
NOPNDS   EQU   NIPOPNPL
NOPNDSA  EQU   NOPNDS
NOPNDCB  EQU   NIPOPNPL+12
NOPNUCB  EQU   NIPOPNPL+16
NOPNFL   EQU   NIPOPNPL+20
NIPSCHDL EQU   0
*NIPPAHDR EQU   0                                                  @L01
*NIPPAQ   EQU   NIPPAHDR                                           @L01
*NIPPABYT EQU   NIPPAHDR+4                                         @L01
*NIPPAREA EQU   0                                                  @L01
*NIPPARC  EQU   NIPPAREA+8                                         @L01
*NIPPABDL EQU   NIPPAREA+12                                        @L01
*NIPPABDH EQU   NIPPABDL                                           @L01
*NIPPA2BF EQU   NIPPABDH                                           @L01
*NIPPANAM EQU   NIPPABDL+4                                         @L01
*NIPPATTR EQU   NIPPABDL+12                                        @L01
*NIPPAIOD EQU   NIPPAREA+32                                        @L01
*NIPPATXT EQU   NIPPAIOD                                           @L01
*NIPPASID EQU   NIPPAIOD+32                                        @L01
*NIPPAIOB EQU   NIPPAIOD+40                                        @L01
*NIPPADCB EQU   NIPPAIOD+80                                        @L01
*NIPPAECB EQU   NIPPAIOD+84                                        @L01
*NIPPAECC EQU   NIPPAECB                                           @L01
*NIPPADEB EQU   NIPPAIOD+88                                        @L01
*NIPPARCD EQU   NIPPAIOD+136                                       @L01
*NIPPAPTB EQU   NIPPAREA+252                                       @L01
*NIPPABUF EQU   NIPPAREA+572                                       @L01
*PARMTAB  EQU   0                                                  @L01
*PTABSTRT EQU   PARMTAB                                            @L01
*LNK      EQU   PARMTAB+120                                        @L01
@NM00068 EQU   PARMTAB+272
*NIPPAFLG EQU   @NM00068                                           @L01
*NIPPAFL1 EQU   NIPPAFLG                                           @L01
*NIPPTE   EQU   0                                                  @L01
*NIPPTADR EQU   NIPPTE                                             @L01
*NIPPTOPF EQU   NIPPTE+4                                           @L01
*NIPPTOPI EQU   NIPPTOPF                                           @L01
*NIPPTLST EQU   NIPPTOPF                                           @L01
*NIPPTCAN EQU   NIPPTOPF                                           @L01
*NIPPTATF EQU   NIPPTE+5                                           @L01
*NIPPTMRG EQU   NIPPTATF                                           @L01
*NIPPTSID EQU   NIPPTE+6                                           @L01
CVTMAP   EQU   0
CVTLINK  EQU   CVTMAP+8
CVTPCNVT EQU   CVTMAP+28
CVTSYSAD EQU   CVTMAP+48
CVTDAR   EQU   CVTMAP+72
CVTFLGS1 EQU   CVTDAR
CVTDCB   EQU   CVTMAP+116
CVTIERLC EQU   CVTMAP+144
CVTOPTA  EQU   CVTMAP+182
CVTOPTB  EQU   CVTMAP+183
CVTGTF   EQU   CVTMAP+236
CVTGTFST EQU   CVTGTF
CVTGTFS  EQU   CVTGTFST
CVTSTATE EQU   CVTGTFST
CVTTMODE EQU   CVTGTFST
CVTFORM  EQU   CVTGTFST
CVTAQAVT EQU   CVTMAP+240
CVTTCMFG EQU   CVTAQAVT
CVTVOLM2 EQU   CVTMAP+244
CVTTATA  EQU   CVTVOLM2
CVTTSKS  EQU   CVTTATA
CVTVOLF2 EQU   CVTTSKS
CVTTAT   EQU   CVTTATA+1
CVTATER  EQU   CVTMAP+248
CVTEXT1  EQU   CVTMAP+252
CVTPURG  EQU   CVTMAP+260
CVTQMSG  EQU   CVTMAP+268
CVTDMSR  EQU   CVTMAP+272
CVTRSV37 EQU   CVTDMSR
CVTDMSRF EQU   CVTRSV37
CVTERPV  EQU   CVTMAP+316
CVTINTLA EQU   CVTMAP+320
CVTAPF   EQU   CVTMAP+324
CVTEXT2  EQU   CVTMAP+328
CVTHJES  EQU   CVTMAP+332
CVTPGSIA EQU   CVTMAP+348
CVTA1F1  EQU   CVTMAP+356
CVTSYSK  EQU   CVTMAP+357
CVTVOLM1 EQU   CVTMAP+380
CVTVOLF1 EQU   CVTVOLM1
CVTATMCT EQU   CVTMAP+388
CVTXTNT1 EQU   0
CVTXTNT2 EQU   0
CVTDSSV  EQU   CVTXTNT2
CVTFLGBT EQU   CVTXTNT2+5
CVTQID   EQU   CVTXTNT2+24
CVTRV400 EQU   CVTXTNT2+52
CVTRV409 EQU   CVTXTNT2+53
CVTATCVT EQU   CVTXTNT2+64
CVTRV429 EQU   CVTXTNT2+84
CVTRV438 EQU   CVTXTNT2+85
CVTRV457 EQU   CVTXTNT2+112
CVTRV466 EQU   CVTXTNT2+113
CVTFIX   EQU   0
CVTRELNO EQU   CVTFIX+252
UCB      EQU   0
UCBOB    EQU   0
UCBJBNR  EQU   UCBOB
UCBFL5   EQU   UCBOB+1
UCBAF    EQU   UCBFL5
UCBSTAT  EQU   UCBOB+3
UCBCHAN  EQU   UCBOB+4
UCBSFLS  EQU   UCBOB+6
UCBFLA   EQU   UCBSFLS
UCBFL1   EQU   UCBFLA
UCBBSY   EQU   UCBFL1
UCBNRY   EQU   UCBFL1
UCBPST   EQU   UCBFL1
UCBCUB   EQU   UCBFL1
UCBFLB   EQU   UCBSFLS+1
UCBCHM   EQU   UCBOB+8
UCBCHM1  EQU   UCBCHM
UCBPTH0  EQU   UCBCHM1
UCBPTH1  EQU   UCBCHM1
UCBWGT   EQU   UCBOB+12
UCBTYP   EQU   UCBOB+16
UCBTBYT1 EQU   UCBTYP
UCB1FEA5 EQU   UCBTBYT1
UCB1FEA6 EQU   UCBTBYT1
UCBTBYT2 EQU   UCBTYP+1
UCB2OPT2 EQU   UCBTBYT2
UCBDUDN1 EQU   UCB2OPT2
UCB2OPT3 EQU   UCBTBYT2
UCBDUDN2 EQU   UCB2OPT3
UCB2OPT4 EQU   UCBTBYT2
UCBRWTAU EQU   UCB2OPT4
UCB2OPT6 EQU   UCBTBYT2
UCB2OPT7 EQU   UCBTBYT2
UCBTBYT3 EQU   UCBTYP+2
UCBDVCLS EQU   UCBTBYT3
UCBTBYT4 EQU   UCBTYP+3
UCBEXTPT EQU   UCBOB+20
UCBFLC   EQU   UCBEXTPT
UCBDEV   EQU   UCBOB+24
UCBCMEXT EQU   0
UCBATI   EQU   UCBCMEXT+3
@NM00082 EQU   UCBATI
UCBFLP1  EQU   UCBCMEXT+5
UCBMT    EQU   0
UCBOCR   EQU   0
UCB3540X EQU   0
UCBDKBYT EQU   UCB3540X+6
UCB3800X EQU   0
UCBOPTNS EQU   UCB3800X
UCBACTIV EQU   UCB3800X+3
UCBMDRBF EQU   UCB3800X+36
UCBUCS   EQU   0
UCBUCSOP EQU   UCBUCS+4
UCBFCBOP EQU   UCBUCS+5
NP3RTRN0 EQU   0
NP3SYPA0 EQU   0
NP3RTRN4 EQU   4
NP3RTRN8 EQU   8
NP3PRTR0 EQU   0
NP3SRTN0 EQU   0
NP3SRTN4 EQU   4
NP3SRTN8 EQU   8
NP3POAD0 EQU   0
NP3RTAD0 EQU   0
OPLIBTAB EQU   0
OPSPDUM1 EQU   OPLIBTAB
OPSPCONT EQU   OPLIBTAB+112
OPSPOPI  EQU   OPLIBTAB+336
OPSPPGPM EQU   OPLIBTAB+368
OPSPSYSP EQU   OPLIBTAB+448
OPLIBENT EQU   0
ORAD     EQU   OPLIBENT
OPFLAG   EQU   OPLIBENT+4
OPIOPT   EQU   OPFLAG
LISTOPT  EQU   OPFLAG
CANOPT   EQU   OPFLAG
ATTRFLAG EQU   OPLIBENT+5
MRGOP    EQU   ATTRFLAG
INSRCID  EQU   OPLIBENT+6
ORLN     EQU   OPLIBENT+8
CONTLN   EQU   OPLIBENT+10
CONTAD   EQU   OPLIBENT+12
DCBSTART EQU   0
OPREPLY1 EQU   0
OPREPLY2 EQU   0
OPREPLY3 EQU   0
OPREPLY4 EQU   0
OPERVAL  EQU   0
PARMTABC EQU   0
OPERTABC EQU   0
PARMTABO EQU   0
SYMBLID  EQU   0
NP3SCAN5 EQU   0
NP3SCAN4 EQU   NP3SCAN5
NP3SCAN3 EQU   NP3SCAN4
NP3SCAN2 EQU   NP3SCAN3
NP3SCANR EQU   NP3SCAN2
NP3SCAN7 EQU   0
NP3SCAN8 EQU   0
NP3LCHAR EQU   0
NP3TABSB EQU   0
NP3SUBSP EQU   0
SCNPAREN EQU   0
BALNCONT EQU   0
NP3ERCHR EQU   0
LNKLIB   EQU   0
MSGBUFF  EQU   0
MSGBUFF1 EQU   MSGBUFF
LNKNAME  EQU   0
LNKFLAG  EQU   LNKNAME
DSNAME   EQU   LNKNAME+1
LNKVOLID EQU   LNKNAME+45
LNKAREA  EQU   0
DSN      EQU   0
NP3SCANC EQU   0
NPSYSP   EQU   0
NP3CLEAR EQU   0
LNKPARMS EQU   0
NIPPMAD0 EQU   0
NIPPMAD4 EQU   0
NIPPMBYT EQU   0
NIPPMBUF EQU   0
NIPPMSID EQU   0
NIPPMCC  EQU   NIPPMSID
NIPPMHH  EQU   NIPPMSID+2
NIPPMR   EQU   NIPPMSID+4
NIPPMCSW EQU   0
NIPPMCS2 EQU   NIPPMCSW+3
NIPPMME1 EQU   0
NIPPMME2 EQU   0
ISYMBL   EQU   0
NP3BFRCL EQU   0
PARMVAL  EQU   0
UCBBGN   EQU   0
IOBORG01 EQU   IOBPREFX+8
IOBNIOBA EQU   IOBORG01
IOBNFLG1 EQU   IOBNIOBA
IOBPRTOV EQU   IOBNFLG1
IOBORG02 EQU   IOBPREFX+8
IOBDQADA EQU   IOBORG02
IOBDEQIN EQU   IOBDQADA
IOBORG03 EQU   IOBPREFX+12
IOBORG04 EQU   IOBINCAM
IOBORG12 EQU   IOBINCAM
IOBFL4   EQU   IOBORG12
IOBEXTEN EQU   IOBSTDRD+32
IOBSEEK  EQU   IOBEXTEN
IOBBB    EQU   IOBSEEK+1
IOBCC    EQU   IOBSEEK+3
IOBHH    EQU   IOBSEEK+5
IOBORG05 EQU   IOBEXTEN
IOBORG06 EQU   IOBEXTEN
IOBNXTPT EQU   IOBORG06+4
IOBSTATA EQU   IOBNXTPT
IOBORG07 EQU   IOBEXTEN+8
W1IEXTEN EQU   IOBORG07
IOBORG08 EQU   IOBEXTEN+8
IOBINDCT EQU   IOBORG08+4
IOBUNSQR EQU   IOBORG08+5
IOBFCHAD EQU   IOBORG08+8
IOBORG09 EQU   IOBEXTEN+8
IOBDPLAD EQU   IOBORG09+4
IOBDTYPE EQU   IOBORG09+8
IOBDTYP2 EQU   IOBORG09+9
IOBDSTAT EQU   IOBORG09+10
IOBSTAT1 EQU   IOBDSTAT
IOBORG10 EQU   IOBEXTEN+8
IOBSEEK2 EQU   IOBORG10
IOBORG11 EQU   IOBEXTEN
IOBERCT  EQU   IOBORG11
IOBUCBXV EQU   IOBERCT
IOBNAME  EQU   IOBORG11+4
IOBORG13 EQU   IOBEXTEN
IOBSKADR EQU   IOBORG13
CVTS01   EQU   CVTPGSIA
CVTLPDIA EQU   CVTS01+12
CVTDIRST EQU   CVTLPDIA
CVTSLIDA EQU   CVTS01+24
CVTCTLFG EQU   CVTS01+50
CVTRV210 EQU   CVTS01+424
CVTRV219 EQU   CVTS01+425
CVTRV228 EQU   CVTS01+426
CVTRV237 EQU   CVTS01+427
CVTMFRTR EQU   CVTS01+452
CVTRV262 EQU   CVTS01+468
CVTRV271 EQU   CVTS01+469
CVTRV280 EQU   CVTS01+470
CVTRV289 EQU   CVTS01+471
CVTGSDA  EQU   CVTS01+600
UCBOBS01 EQU   UCBDEV
UCBSTAB  EQU   UCBOBS01+10
UCBBSVL  EQU   UCBSTAB
UCBPRSRS EQU   UCBSTAB
UCBDMCT  EQU   UCBOBS01+11
UCBFL4   EQU   UCBOBS01+13
UCBUSER  EQU   UCBOBS01+14
UCBOBS02 EQU   UCBDEV
UCBTFL1  EQU   UCBOBS02+19
UCBXTN   EQU   UCBOBS02+20
UCBVOPT  EQU   UCBXTN
UCBOBS03 EQU   UCBDEV
UCBXTADR EQU   UCBOBS03
UCBOBS04 EQU   UCBDEV
UCBBTA   EQU   UCBOBS04+12
UCBOBS06 EQU   UCBDEV
UCBAOF   EQU   UCBOBS06
UCBAOF1  EQU   UCBAOF
UCBAOF2  EQU   UCBAOF+1
@NM00081 EQU   UCBOBS06+3
UCBIRB   EQU   UCBOBS06+4
UCBGRAF  EQU   UCBIRB
UCBLDNCA EQU   UCBOBS06+8
UCBRDYQ  EQU   UCBLDNCA
UCBIRLN  EQU   UCBRDYQ
UCBLDNCB EQU   UCBRDYQ+1
UCBCTLNK EQU   UCBOBS06+12
UCBOBS07 EQU   UCBDEV
UCBOBS08 EQU   UCBDEV
UCBCTCAD EQU   UCBOBS08
UCBCTCF1 EQU   UCBOBS08+4
UCBOBS09 EQU   UCBDEV
DCB      EQU   NIPPADCB-NIPPAREA                                   @L01
DCBDEBAD EQU   DCB
NP3VLBLK EQU   LCDIR
NP3DVTYP EQU   NP3VLBLK+4
NP3VOLSR EQU   NP3VLBLK+6
OPREPLY5 EQU   MESG03B
PRMIGNOR EQU   MESG03B
SYMLNGTH EQU   MESG03L
SYMBREP  EQU   MESG03L
NP3ECHMV EQU   MESG04B
NP3ECHMI EQU   MESG04B+1
NP3LOCER EQU   MESG06B
NP3MSGCL EQU   MESG03B
PRMLIB   EQU   LCNAM
STRING   EQU   MESG08A
PARM     EQU   MESG07A
NAME     EQU   MESG07B
XX       EQU   MESG17A
SYSPNAME EQU   MESG10A
LKNAME   EQU   MESG11A
SYSNAME  EQU   MESG09A
CAUSE04  EQU   MESG04C
NP3PMCLR EQU   PTABLN
NP3PMCL0 EQU   PTABLN+256
NP3TBCLR EQU   OPTABLN
NP3TBCL0 EQU   OPTABLN+256
         AGO   .@UNREFD                START UNREFERENCED COMPONENTS
@NM00094 EQU   NP3VLBLK+12
@NM00093 EQU   NP3VLBLK+2
@NM00092 EQU   NP3VLBLK
DCBFLGS  EQU   DCB+4
UCBRV066 EQU   UCBOBS09+4
UCBIOSBA EQU   UCBOBS09
UCBRV042 EQU   UCBOBS08+5
UCBRV082 EQU   UCBCTCF1
UCBRV081 EQU   UCBCTCF1
UCBRV080 EQU   UCBCTCF1
UCBRV079 EQU   UCBCTCF1
UCBRV078 EQU   UCBCTCF1
UCBRV077 EQU   UCBCTCF1
UCBRV076 EQU   UCBCTCF1
UCBCTC80 EQU   UCBCTCF1
UCBCTCAL EQU   UCBCTCAD
UCBICNCB EQU   UCBOBS07+4
UCBRV040 EQU   UCBOBS07
UCBCTLNA EQU   UCBCTLNK+1
UCBRLN   EQU   UCBCTLNK
UCBRDYQA EQU   UCBLDNCB
UCBINRLN EQU   UCBIRLN
UCBIRBA  EQU   UCBIRB+1
UCBRV039 EQU   UCBGRAF
UCBDWNR  EQU   UCBGRAF
UCBRPND  EQU   UCBGRAF
UCBUPM   EQU   UCBGRAF
UCBBTAM  EQU   UCBGRAF
UCBDRNO  EQU   UCBGRAF
UCBDRO   EQU   UCBGRAF
UCBOIP   EQU   UCBGRAF
UCBATRCD EQU   @NM00081
UCBSKPFG EQU   @NM00081
UCBRIPND EQU   @NM00081
UCBRTIAC EQU   @NM00081
UCBRSV79 EQU   @NM00081
UCBRSV78 EQU   @NM00081
UCBRSV77 EQU   @NM00081
UCBOLTEP EQU   @NM00081
UCBATNCT EQU   UCBOBS06+2
UCBRSV76 EQU   UCBAOF2
UCBRSV75 EQU   UCBAOF2
UCBRSV74 EQU   UCBAOF2
UCBRSV73 EQU   UCBAOF2
UCBRSV72 EQU   UCBAOF2
UCBRSV71 EQU   UCBAOF2
UCBRSV70 EQU   UCBAOF2
UCBRSV69 EQU   UCBAOF2
UCBRSV68 EQU   UCBAOF1
UCBRSV67 EQU   UCBAOF1
UCBRSV66 EQU   UCBAOF1
UCBRSV65 EQU   UCBAOF1
UCBRSV64 EQU   UCBAOF1
UCBOFNL  EQU   UCBAOF1
UCBOFSP  EQU   UCBAOF1
UCBOFMCR EQU   UCBAOF1
UCBBTB   EQU   UCBBTA+1
UCBDI    EQU   UCBBTA
UCBSNS   EQU   UCBOBS04+8
UCBTEB   EQU   UCBOBS04+4
UCBGCB   EQU   UCBOBS04+3
UCBOPEN  EQU   UCBOBS04+2
UCBSTART EQU   UCBOBS04
UCBXTNB  EQU   UCBXTN+1
UCBRSV22 EQU   UCBVOPT
UCBRSV21 EQU   UCBVOPT
UCBRSV20 EQU   UCBVOPT
UCBESVE  EQU   UCBVOPT
UCBERPC  EQU   UCBVOPT
UCBESVC  EQU   UCBVOPT
UCBEVA   EQU   UCBVOPT
UCBESV   EQU   UCBVOPT
UCBRV009 EQU   UCBTFL1
UCBRV008 EQU   UCBTFL1
UCBRV007 EQU   UCBTFL1
UCBRV006 EQU   UCBTFL1
UCBRV005 EQU   UCBTFL1
UCBRV038 EQU   UCBTFL1
UCBNSLTP EQU   UCBTFL1
UCBNLTP  EQU   UCBTFL1
UCBRES1B EQU   UCBOBS02+18
UCBFSER  EQU   UCBOBS02+12
@NM00080 EQU   UCBOBS02+4
UCBFSEQ  EQU   UCBOBS02+2
UCBFSCT  EQU   UCBOBS02
UCBNEXP  EQU   UCBOBS01+20
UCBBASE  EQU   UCBOBS01+16
UCBRES1A EQU   UCBOBS01+15
UCBFL47  EQU   UCBFL4
UCBFL46  EQU   UCBFL4
UCBFL45  EQU   UCBFL4
UCBRV065 EQU   UCBFL4
UCBDSS   EQU   UCBFL4
UCBRV028 EQU   UCBFL4
UCBWDAV  EQU   UCBFL4
UCBDAVV  EQU   UCBFL4
UCBSQC   EQU   UCBOBS01+12
UCBDATP  EQU   UCBOBS01+12
UCBDMC   EQU   UCBDMCT
UCBMOUNT EQU   UCBDMCT
UCBBNUL  EQU   UCBSTAB
UCBSHAR  EQU   UCBSTAB
UCBBSTR  EQU   UCBSTAB
UCBBPUB  EQU   UCBSTAB
UCBBPRV  EQU   UCBSTAB
UCBBALB  EQU   UCBPRSRS
UCBPGFL  EQU   UCBSTAB
UCBDVSHR EQU   UCBBSVL
UCBVOLI  EQU   UCBOBS01+4
UCBVTOC  EQU   UCBOBS01
CVTRV628 EQU   CVTS01+728
CVTRV627 EQU   CVTS01+724
CVTRV626 EQU   CVTS01+720
CVTRV625 EQU   CVTS01+716
CVTRV624 EQU   CVTS01+712
CVTRV623 EQU   CVTS01+708
CVTRV622 EQU   CVTS01+704
CVTRV621 EQU   CVTS01+700
CVTIHASU EQU   CVTS01+696
CVTSUSP  EQU   CVTS01+692
CVTT6SVC EQU   CVTS01+688
CVTCDAL  EQU   CVTS01+684
CVTTCTL  EQU   CVTS01+680
CVTRSUME EQU   CVTS01+676
CVTJTERM EQU   CVTS01+672
CVTASMRM EQU   CVTS01+668
CVTTCASP EQU   CVTS01+664
CVT0PT03 EQU   CVTS01+660
CVT0PT0E EQU   CVTS01+656
CVTRV609 EQU   CVTS01+652
CVTCGK   EQU   CVTS01+648
CVTRAC   EQU   CVTS01+644
CVTRV606 EQU   CVTS01+640
CVTRV605 EQU   CVTS01+636
CVTRV604 EQU   CVTS01+632
CVTEFF02 EQU   CVTS01+628
CVTCBBR  EQU   CVTS01+624
CVTSSCR  EQU   CVTS01+620
CVTEVENT EQU   CVTS01+616
CVTCRCA  EQU   CVTS01+612
CVTTPIO  EQU   CVTS01+608
CVTADV   EQU   CVTS01+604
CVTGSDAB EQU   CVTGSDA
CVTQV3   EQU   CVTS01+596
CVTQV2   EQU   CVTS01+592
CVTQV1   EQU   CVTS01+588
CVTRPT   EQU   CVTS01+584
CVTSSRB  EQU   CVTS01+580
CVTCSDRL EQU   CVTS01+576
CVTEXP1  EQU   CVTS01+572
CVTRMPMT EQU   CVTS01+568
CVTRMPTT EQU   CVTS01+564
CVTVPSA  EQU   CVTS01+560
CVTVSTOP EQU   CVTS01+556
CVTGTFR8 EQU   CVTS01+552
CVTQUIT  EQU   CVTS01+548
CVTVACR  EQU   CVTS01+544
CVTWTCB  EQU   CVTS01+540
CVTSTPRS EQU   CVTS01+536
CVT0PT02 EQU   CVTS01+532
CVTDARCM EQU   CVTS01+528
CVTIRECM EQU   CVTS01+524
CVTJRECM EQU   CVTS01+520
CVTVEMS0 EQU   CVTS01+516
CVTSPFRR EQU   CVTS01+512
CVTRLSTG EQU   CVTS01+508
CVT0TC0A EQU   CVTS01+504
CVTGMBR  EQU   CVTS01+500
CVTLFRM  EQU   CVTS01+496
CVTRMBR  EQU   CVTS01+492
CVTVIOP  EQU   CVTS01+488
CVTRV307 EQU   CVTS01+486
CVTRV306 EQU   CVTS01+484
CVTRV305 EQU   CVTS01+482
CVTRV304 EQU   CVTS01+480
CVTRV303 EQU   CVTS01+478
CVTRV302 EQU   CVTS01+476
CVTTRCA  EQU   CVTS01+472
CVTRV297 EQU   CVTRV289
CVTRV296 EQU   CVTRV289
CVTRV295 EQU   CVTRV289
CVTRV294 EQU   CVTRV289
CVTRV293 EQU   CVTRV289
CVTRV292 EQU   CVTRV289
CVTRV291 EQU   CVTRV289
CVTRV290 EQU   CVTRV289
CVTRV288 EQU   CVTRV280
CVTRV287 EQU   CVTRV280
CVTRV286 EQU   CVTRV280
CVTRV285 EQU   CVTRV280
CVTRV284 EQU   CVTRV280
CVTRV283 EQU   CVTRV280
CVTRV282 EQU   CVTRV280
CVTRV281 EQU   CVTRV280
CVTRV279 EQU   CVTRV271
CVTRV278 EQU   CVTRV271
CVTRV277 EQU   CVTRV271
CVTRV276 EQU   CVTRV271
CVTRV275 EQU   CVTRV271
CVTRV274 EQU   CVTRV271
CVTRV273 EQU   CVTRV271
CVTRV272 EQU   CVTRV271
CVTRV270 EQU   CVTRV262
CVTRV269 EQU   CVTRV262
CVTRV268 EQU   CVTRV262
CVTRV267 EQU   CVTRV262
CVTRV266 EQU   CVTRV262
CVTRV265 EQU   CVTRV262
CVTRV264 EQU   CVTRV262
CVTRV263 EQU   CVTRV262
CVTVFP   EQU   CVTS01+464
CVTVSI   EQU   CVTS01+460
CVTVPSIB EQU   CVTS01+456
CVTMFACT EQU   CVTMFRTR
CVTMFCTL EQU   CVTS01+448
CVTPVBP  EQU   CVTS01+444
CVTPWI   EQU   CVTS01+440
CVTRV254 EQU   CVTS01+438
CVTRV253 EQU   CVTS01+436
CVTRV252 EQU   CVTS01+434
CVTRV251 EQU   CVTS01+433
CVTRV250 EQU   CVTS01+432
CVTRV249 EQU   CVTS01+431
CVTRV248 EQU   CVTS01+430
CVTRV247 EQU   CVTS01+429
CVTRV246 EQU   CVTS01+428
CVTRV245 EQU   CVTRV237
CVTRV244 EQU   CVTRV237
CVTRV243 EQU   CVTRV237
CVTRV242 EQU   CVTRV237
CVTRV241 EQU   CVTRV237
CVTRV240 EQU   CVTRV237
CVTRV239 EQU   CVTRV237
CVTRV238 EQU   CVTRV237
CVTRV236 EQU   CVTRV228
CVTRV235 EQU   CVTRV228
CVTRV234 EQU   CVTRV228
CVTRV233 EQU   CVTRV228
CVTRV232 EQU   CVTRV228
CVTRV231 EQU   CVTRV228
CVTRV230 EQU   CVTRV228
CVTRV229 EQU   CVTRV228
CVTRV227 EQU   CVTRV219
CVTRV226 EQU   CVTRV219
CVTRV225 EQU   CVTRV219
CVTRV224 EQU   CVTRV219
CVTRV223 EQU   CVTRV219
CVTRV222 EQU   CVTRV219
CVTRV221 EQU   CVTRV219
CVTRV220 EQU   CVTRV219
CVTRV218 EQU   CVTRV210
CVTRV217 EQU   CVTRV210
CVTRV216 EQU   CVTRV210
CVTRV215 EQU   CVTRV210
CVTRV214 EQU   CVTRV210
CVTRV213 EQU   CVTRV210
CVTRV212 EQU   CVTRV210
CVTRV211 EQU   CVTRV210
CVTLCCAT EQU   CVTS01+420
CVTPCCAT EQU   CVTS01+416
CVTIPCRP EQU   CVTS01+412
CVTIPCRI EQU   CVTS01+408
CVTIPCDS EQU   CVTS01+404
CVTAIDVT EQU   CVTS01+400
CVTSSAP  EQU   CVTS01+396
CVTEHCIR EQU   CVTS01+392
CVTEHDEF EQU   CVTS01+388
CVTDAIR  EQU   CVTS01+384
CVTPERFM EQU   CVTS01+380
CVT044R2 EQU   CVTS01+376
CVTFETCH EQU   CVTS01+372
CVTRSTWD EQU   CVTS01+368
CVTSPOST EQU   CVTS01+364
CVTIOBP  EQU   CVTS01+360
CVTASMVT EQU   CVTS01+356
CVTRECRQ EQU   CVTS01+352
CVTWSAC  EQU   CVTS01+348
CVTRV149 EQU   CVTS01+344
CVTWSAL  EQU   CVTS01+340
CVTSPSA  EQU   CVTS01+336
CVTGLMN  EQU   CVTS01+332
CVTVEAC0 EQU   CVTS01+328
CVT062R1 EQU   CVTS01+324
CVTRPOST EQU   CVTS01+320
CVTDQIQE EQU   CVTS01+316
CVTCSD   EQU   CVTS01+312
CVTLKRMA EQU   CVTS01+308
CVTRSPIE EQU   CVTS01+304
CVTRENQ  EQU   CVTS01+300
CVTLQCB  EQU   CVTS01+296
CVTFQCB  EQU   CVTS01+292
CVTQCS01 EQU   CVTS01+288
CVTAPFT  EQU   CVTS01+284
CVTPARRL EQU   CVTS01+280
CVTVWAIT EQU   CVTS01+276
CVTGSPL  EQU   CVTS01+272
CVTLSMQ  EQU   CVTS01+268
CVTGSMQ  EQU   CVTS01+264
CVTEXPRO EQU   CVTS01+260
CVTOPCTP EQU   CVTS01+256
CVTSIC   EQU   CVTS01+252
CVTTPIOS EQU   CVTS01+248
CVTRTMS  EQU   CVTS01+244
CVTSDBF  EQU   CVTS01+240
CVTSCBP  EQU   CVTS01+236
CVTSDMP  EQU   CVTS01+232
CVTSV60  EQU   CVTS01+228
CVTRTMCT EQU   CVTS01+224
CVTASCBL EQU   CVTS01+220
CVTASCBH EQU   CVTS01+216
CVTGDA   EQU   CVTS01+212
CVTASVT  EQU   CVTS01+208
CVTVVMDI EQU   CVTS01+204
CVTAQTOP EQU   CVTS01+200
CVTIOSCS EQU   CVTS01+196
CVTSDRM  EQU   CVTS01+192
CVTOPTE  EQU   CVTS01+188
CVTSTXU  EQU   CVTS01+184
CVTQUIS  EQU   CVTS01+180
CVTPARS  EQU   CVTS01+176
CVTS1EE  EQU   CVTS01+172
CVTFRAS  EQU   CVTS01+168
CVTQSAS  EQU   CVTS01+164
CVTCRAS  EQU   CVTS01+160
CVTCRMN  EQU   CVTS01+156
CVTDELCP EQU   CVTS01+152
CVTFRECL EQU   CVTS01+148
CVTGETCL EQU   CVTS01+144
CVTBLDCP EQU   CVTS01+140
CVTAUTHL EQU   CVTS01+136
CVTSCAN  EQU   CVTS01+132
CVTRV144 EQU   CVTS01+130
CVTMAXMP EQU   CVTS01+128
CVTSTCK  EQU   CVTS01+124
CVTRV139 EQU   CVTS01+123
CVTDSSAC EQU   CVTS01+122
CVTRV513 EQU   CVTS01+121
CVTIOSPL EQU   CVTS01+120
CVTPTGT  EQU   CVTS01+116
CVTCSPIE EQU   CVTS01+112
CVTSMFEX EQU   CVTS01+108
CVTOLT0A EQU   CVTS01+104
CVTSRBRT EQU   CVTS01+100
CVTPUTL  EQU   CVTS01+96
CVTASCRL EQU   CVTS01+92
CVTASCRF EQU   CVTS01+88
CVTRV326 EQU   CVTS01+84
CVTRV325 EQU   CVTS01+80
CVTRV324 EQU   CVTS01+76
CVT0VL01 EQU   CVTS01+72
CVTSHRVM EQU   CVTS01+68
CVTRV332 EQU   CVTS01+64
CVTTAS   EQU   CVTS01+60
CVTRSCN  EQU   CVTS01+56
CVTTRAC2 EQU   CVTS01+54
CVTTRACE EQU   CVTS01+52
CVTAPG   EQU   CVTS01+51
CVTSDTRC EQU   CVTCTLFG
CVTGTRCE EQU   CVTCTLFG
CVTNOMP  EQU   CVTCTLFG
CVTRSV79 EQU   CVTCTLFG
CVTDSTAT EQU   CVTCTLFG
CVTRSV78 EQU   CVTCTLFG
CVTRV333 EQU   CVTCTLFG
CVTRV323 EQU   CVTCTLFG
CVTSPVLK EQU   CVTS01+49
CVTRSV77 EQU   CVTS01+48
CVTRV331 EQU   CVTS01+44
CVTRV330 EQU   CVTS01+40
CVTRV329 EQU   CVTS01+36
CVTRV328 EQU   CVTS01+32
CVTRV322 EQU   CVTS01+28
CVTSLID  EQU   CVTSLIDA+1
CVTSYLK  EQU   CVTSLIDA
CVTRV321 EQU   CVTS01+20
CVTRV320 EQU   CVTS01+16
CVTLPDIR EQU   CVTLPDIA+1
CVTRSV69 EQU   CVTDIRST
CVTRSV68 EQU   CVTDIRST
CVTRSV67 EQU   CVTDIRST
CVTRSV66 EQU   CVTDIRST
CVTRSV65 EQU   CVTDIRST
CVTRSV64 EQU   CVTDIRST
CVTRSV63 EQU   CVTDIRST
CVTDICOM EQU   CVTDIRST
CVTPVTP  EQU   CVTS01+8
CVTLPDSR EQU   CVTS01+4
CVTGETL  EQU   CVTS01
IOBSKSS  EQU   IOBSKADR+3
IOBSK0   EQU   IOBSKADR+2
IOBSKTT  EQU   IOBSKADR+1
IOBSKRV  EQU   IOBSKADR
IOBCSWSV EQU   IOBORG11+17
IOBSENSV EQU   IOBORG11+16
IOBRCD   EQU   IOBORG11+12
IOBMDREC EQU   IOBORG11+8
IOBNAMEA EQU   IOBNAME+1
IOBNAMSZ EQU   IOBNAME
IOBERCTA EQU   IOBERCT+1
IOBRTYPE EQU   IOBUCBXV
IOBRDCHP EQU   IOBORG10+20
IOBNEXTA EQU   IOBORG10+16
IOBREADA EQU   IOBORG10+12
IOBBUFC  EQU   IOBORG10+8
IOBSK2R  EQU   IOBSEEK2+7
IOBSK2HH EQU   IOBSEEK2+5
IOBSK2CC EQU   IOBSEEK2+3
IOBSK2BB EQU   IOBSEEK2+1
IOBSK2M  EQU   IOBSEEK2
IOBCHNPR EQU   IOBORG09+40
IOBDNCRF EQU   IOBORG09+32
IOBRSV35 EQU   IOBORG09+24
IOBDQPTR EQU   IOBORG09+20
IOBRSV34 EQU   IOBORG09+18
IOBDBYTN EQU   IOBORG09+16
IOBDCPND EQU   IOBORG09+12
IOBSTAT2 EQU   IOBDSTAT+1
IOBSIORT EQU   IOBSTAT1
IOBADDVU EQU   IOBSTAT1
IOBBUFF  EQU   IOBSTAT1
IOBENQUE EQU   IOBSTAT1
IOBPASS2 EQU   IOBSTAT1
IOBSYNCH EQU   IOBSTAT1
IOBNEWVL EQU   IOBSTAT1
IOBABNRM EQU   IOBSTAT1
IOBRELEX EQU   IOBDTYP2
IOBADDTY EQU   IOBDTYP2
IOBTYPE  EQU   IOBDTYP2
IOBRQUST EQU   IOBDTYP2
IOBSUFFX EQU   IOBDTYP2
IOBSBLKL EQU   IOBDTYP2
IOBSKEY  EQU   IOBDTYP2
IOBRELBL EQU   IOBDTYPE
IOBRDEXC EQU   IOBDTYPE
IOBDYNBF EQU   IOBDTYPE
IOBACTAD EQU   IOBDTYPE
IOBFDBCK EQU   IOBDTYPE
IOBEXTSC EQU   IOBDTYPE
IOBOVFLO EQU   IOBDTYPE
IOBVERFY EQU   IOBDTYPE
IOBDPLB  EQU   IOBDPLAD+1
IOBDAYLI EQU   IOBDPLAD
IOBDIOBS EQU   IOBORG09+2
IOBDBYTR EQU   IOBORG09
IOBBCHAD EQU   IOBORG08+12
IOBFCHNB EQU   IOBFCHAD+1
IOBCOUNT EQU   IOBFCHAD
IOBASYN  EQU   IOBORG08+7
IOBAPP   EQU   IOBORG08+6
IOBRSV32 EQU   IOBUNSQR
IOBRSV31 EQU   IOBUNSQR
IOBRSV30 EQU   IOBUNSQR
IOBKNRWR EQU   IOBUNSQR
IOBKNWR  EQU   IOBUNSQR
IOBNTAV2 EQU   IOBUNSQR
IOBNTAV1 EQU   IOBUNSQR
IOBCPBSY EQU   IOBUNSQR
IOBCHNNL EQU   IOBINDCT
IOBRSV29 EQU   IOBINDCT
IOBRSV28 EQU   IOBINDCT
IOBRSV27 EQU   IOBINDCT
IOBKEYAD EQU   IOBINDCT
IOBOVPTR EQU   IOBINDCT
IOBUNSCH EQU   IOBINDCT
IOBDEQCP EQU   IOBINDCT
IOBCCWAD EQU   IOBORG08
W1OEXTEN EQU   W1IEXTEN
IOBCCW   EQU   IOBORG06+8
IOBNXTPB EQU   IOBNXTPT+1
IOBRSV26 EQU   IOBSTATA
IOBRSV25 EQU   IOBSTATA
IOBRSV24 EQU   IOBSTATA
IOBRSV23 EQU   IOBSTATA
IOBRSV22 EQU   IOBSTATA
IOBRSV21 EQU   IOBSTATA
IOBRSV20 EQU   IOBSTATA
IOBAVLFL EQU   IOBSTATA
IOBRSV37 EQU   IOBORG06+1
IOBUCBXG EQU   IOBORG06
IOBCPA   EQU   IOBORG05+32
IOBERINF EQU   IOBORG05+16
IOBERCCW EQU   IOBORG05+8
IOBSNDPT EQU   IOBORG05+7
IOBRCVPT EQU   IOBORG05+6
IOBWORK  EQU   IOBORG05+1
IOBUCBX  EQU   IOBORG05
IOBR     EQU   IOBSEEK+7
IOBHH2   EQU   IOBHH+1
IOBHH1   EQU   IOBHH
IOBCC2   EQU   IOBCC+1
IOBCC1   EQU   IOBCC
IOBBB2   EQU   IOBBB+1
IOBBB1   EQU   IOBBB
IOBM     EQU   IOBSEEK
IOBRSV46 EQU   IOBFL4
IOBRSV47 EQU   IOBFL4
IOBENT   EQU   IOBFL4
IOBEQP   EQU   IOBFL4
IOBBUS   EQU   IOBFL4
IOBDCK   EQU   IOBFL4
IOBREJ   EQU   IOBFL4
IOBOVR   EQU   IOBFL4
IOBCRILC EQU   IOBORG04+1
IOBCRDCC EQU   IOBORG04
IOBGQECB EQU   IOBORG03
IOBSWAP  EQU   IOBORG02+4
IOBDQADB EQU   IOBDQADA+1
IOBRSV13 EQU   IOBDEQIN
IOBRSV12 EQU   IOBDEQIN
IOBRSV11 EQU   IOBDEQIN
IOBRSV10 EQU   IOBDEQIN
IOBRSV09 EQU   IOBDEQIN
IOBRSV08 EQU   IOBDEQIN
IOBRSV07 EQU   IOBDEQIN
IOBDEQ   EQU   IOBDEQIN
IOBNECB  EQU   IOBORG01+4
IOBNIOBB EQU   IOBNIOBA+1
IOBFIRST EQU   IOBNFLG1
IOBUPERR EQU   IOBNFLG1
IOBSPAN  EQU   IOBNFLG1
IOBBKSPC EQU   IOBNFLG1
IOBUPDAT EQU   IOBNFLG1
IOBREAD  EQU   IOBNFLG1
IOBWRITE EQU   IOBNFLG1
IOBSEGMT EQU   IOBPRTOV
@NM00162 EQU   NIPPMCSW+4
@NM00161 EQU   NIPPMCSW
MSGBUFF2 EQU   MSGBUFF+1
@NM00085 EQU   ATTRFLAG
@NM00084 EQU   OPFLAG
OPSPDUM2 EQU   OPLIBTAB+624
OPSPDUPL EQU   OPLIBTAB+608
OPSPPAGN EQU   OPLIBTAB+592
OPSPSWAP EQU   OPLIBTAB+576
OPSPRSU  EQU   OPLIBTAB+560
OPSPFLG  EQU   OPLIBTAB+544
OPSPPURG EQU   OPLIBTAB+528
OPSPWTOR EQU   OPLIBTAB+512
OPSPWTOB EQU   OPLIBTAB+496
OPSPVRRG EQU   OPLIBTAB+480
OPSPVAP  EQU   OPLIBTAB+464
OPSPSQA  EQU   OPLIBTAB+432
OPSPSMF  EQU   OPLIBTAB+416
OPSPREAL EQU   OPLIBTAB+400
OPSPPGOP EQU   OPLIBTAB+384
OPSPOPT  EQU   OPLIBTAB+352
OPSPNUCM EQU   OPLIBTAB+320
OPSPMLPA EQU   OPLIBTAB+304
OPSPMAXU EQU   OPLIBTAB+288
OPSPLOGL EQU   OPLIBTAB+272
OPSPLOGC EQU   OPLIBTAB+256
OPSPLNK  EQU   OPLIBTAB+240
OPSPIPS  EQU   OPLIBTAB+224
OPSPHDCP EQU   OPLIBTAB+208
OPSPFIX  EQU   OPLIBTAB+192
OPSPDUMP EQU   OPLIBTAB+176
OPSPCVAM EQU   OPLIBTAB+160
OPSPCSA  EQU   OPLIBTAB+144
OPSPCPQE EQU   OPLIBTAB+128
OPSPCMD  EQU   OPLIBTAB+96
OPSPCLPA EQU   OPLIBTAB+80
OPSPBLDF EQU   OPLIBTAB+64
OPSPBLDL EQU   OPLIBTAB+48
OPSPAPGP EQU   OPLIBTAB+32
OPSPAPF  EQU   OPLIBTAB+16
UCBERADR EQU   UCBUCS+12
UCBFCBID EQU   UCBUCS+8
UCBERCNT EQU   UCBUCS+7
UCBRSV51 EQU   UCBUCS+6
UCBRSV50 EQU   UCBFCBOP
UCBRSV49 EQU   UCBFCBOP
UCBRSV48 EQU   UCBFCBOP
UCBRSV47 EQU   UCBFCBOP
UCBRSV46 EQU   UCBFCBOP
UCBRSV45 EQU   UCBFCBOP
UCBRSV44 EQU   UCBFCBOP
UCBFCBO1 EQU   UCBFCBOP
UCBUCSPE EQU   UCBUCSOP
UCBRSV43 EQU   UCBUCSOP
UCBRSV42 EQU   UCBUCSOP
UCBRSV41 EQU   UCBUCSOP
UCBRSV40 EQU   UCBUCSOP
UCBRSV39 EQU   UCBUCSOP
UCBUCSO2 EQU   UCBUCSOP
UCBUCSO1 EQU   UCBUCSOP
UCBUCSID EQU   UCBUCS
UCBMDRBA EQU   UCBMDRBF+1
UCBRV075 EQU   UCBMDRBF
UCBRV074 EQU   UCB3800X+32
UCBIMAGE EQU   UCB3800X+28
UCBFCBNM EQU   UCB3800X+24
UCBCHAR4 EQU   UCB3800X+20
UCBCHAR3 EQU   UCB3800X+16
UCBCHAR2 EQU   UCB3800X+12
UCBCHAR1 EQU   UCB3800X+8
UCBCGMID EQU   UCB3800X+4
UCBBRSTA EQU   UCBACTIV
UCBRV063 EQU   UCBACTIV
UCBRV062 EQU   UCBACTIV
UCBRV061 EQU   UCBACTIV
UCBRV060 EQU   UCBACTIV
UCBRV059 EQU   UCBACTIV
UCBRV058 EQU   UCBACTIV
UCBRV057 EQU   UCBACTIV
UCBRV050 EQU   UCB3800X+2
UCBCGMNO EQU   UCB3800X+1
UCBRV083 EQU   UCBOPTNS
UCBBRSTR EQU   UCBOPTNS
UCBRV056 EQU   UCBOPTNS
UCBRV055 EQU   UCBOPTNS
UCBRV054 EQU   UCBOPTNS
UCBRV053 EQU   UCBOPTNS
UCBRV052 EQU   UCBOPTNS
UCBRV051 EQU   UCBOPTNS
UCBRV073 EQU   UCB3540X+7
UCBRV072 EQU   UCBDKBYT
UCBRV071 EQU   UCBDKBYT
UCBRV070 EQU   UCBDKBYT
UCBRV069 EQU   UCBDKBYT
UCBRV068 EQU   UCBDKBYT
UCBRV067 EQU   UCBDKBYT
UCBVLVER EQU   UCBDKBYT
UCBDKAMX EQU   UCBDKBYT
UCBVLSER EQU   UCB3540X
UCBRDATA EQU   UCBOCR+4
UCBFRID  EQU   UCBOCR
UCBCLN   EQU   UCBMT+14
UCBERG   EQU   UCBMT+12
UCBMS    EQU   UCBMT+11
UCBNB    EQU   UCBMT+10
UCBPW    EQU   UCBMT+9
UCBPR    EQU   UCBMT+8
UCBSIO   EQU   UCBMT+6
UCBTW    EQU   UCBMT+5
UCBTR    EQU   UCBMT+4
UCBTWT   EQU   UCBMT+3
UCBTRT   EQU   UCBMT+2
UCBCTD   EQU   UCBMT
UCBWTOID EQU   UCBCMEXT+17
UCBRV043 EQU   UCBCMEXT+16
UCBASID  EQU   UCBCMEXT+14
UCBMFCNT EQU   UCBCMEXT+12
UCBPMSK  EQU   UCBCMEXT+10
UCBCCWOF EQU   UCBCMEXT+8
UCBRV041 EQU   UCBCMEXT+6
UCBRV036 EQU   UCBFLP1
UCBRV035 EQU   UCBFLP1
UCBERLOG EQU   UCBFLP1
UCBRV033 EQU   UCBFLP1
UCBRV032 EQU   UCBFLP1
UCBRV031 EQU   UCBFLP1
UCBSHRUP EQU   UCBFLP1
UCBNSRCH EQU   UCBFLP1
UCBSNSCT EQU   UCBCMEXT+4
UCBHPDV  EQU   @NM00082
UCBHALI  EQU   @NM00082
UCBRSV09 EQU   @NM00082
UCBRSV08 EQU   @NM00082
UCBRSV07 EQU   @NM00082
UCBRSV06 EQU   @NM00082
UCBRSV05 EQU   @NM00082
UCBRSV04 EQU   @NM00082
UCBDTI   EQU   UCBCMEXT+2
UCBSTI   EQU   UCBCMEXT+1
UCBETI   EQU   UCBCMEXT
UCBEXTP  EQU   UCBEXTPT+1
UCBDDRSW EQU   UCBFLC
UCBTICBT EQU   UCBFLC
UCBIVRR  EQU   UCBFLC
UCBIVRS  EQU   UCBFLC
UCBITF   EQU   UCBFLC
UCBUDE   EQU   UCBFLC
UCBWAA   EQU   UCBFLC
UCBATTP  EQU   UCBFLC
UCBUNTYP EQU   UCBTBYT4
UCBRSV11 EQU   UCBDVCLS
UCBRSV10 EQU   UCBDVCLS
UCB3CHAR EQU   UCBDVCLS
UCB3UREC EQU   UCBDVCLS
UCB3DISP EQU   UCBDVCLS
UCB3DACC EQU   UCBDVCLS
UCB3COMM EQU   UCBDVCLS
UCB3TAPE EQU   UCBDVCLS
UCBDVPWR EQU   UCB2OPT7
UCBVLPWR EQU   UCB2OPT6
UCB2OPT5 EQU   UCBTBYT2
UCBRVDEV EQU   UCBRWTAU
UCBRPS   EQU   UCBDUDN2
UCBRR    EQU   UCBDUDN1
UCB2OPT1 EQU   UCBTBYT2
UCB2OPT0 EQU   UCBTBYT2
UCB1FEA7 EQU   UCBTBYT1
UCBD6250 EQU   UCB1FEA6
UCBD1600 EQU   UCB1FEA5
UCB1FEA4 EQU   UCBTBYT1
UCB1FEA3 EQU   UCBTBYT1
UCB1FEA2 EQU   UCBTBYT1
UCB1FEA1 EQU   UCBTBYT1
UCB1FEA0 EQU   UCBTBYT1
UCBNAME  EQU   UCBOB+13
UCBRV029 EQU   UCBWGT
UCBVHRSN EQU   UCBWGT
UCBVORSN EQU   UCBWGT
UCBMTPXP EQU   UCBWGT
UCBREW   EQU   UCBWGT
UCBPUB   EQU   UCBWGT
UCBOUT   EQU   UCBWGT
UCBIN    EQU   UCBWGT
UCBCPU   EQU   UCBOB+11
UCBLCI   EQU   UCBOB+10
UCBCNT   EQU   UCBOB+9
UCBRV017 EQU   UCBCHM1
UCBRV016 EQU   UCBCHM1
UCBRV015 EQU   UCBCHM1
UCBRV014 EQU   UCBCHM1
UCBSPB   EQU   UCBPTH1
UCBPPB   EQU   UCBPTH1
UCBSPA   EQU   UCBPTH0
UCBPPA   EQU   UCBPTH0
UCBSIGP  EQU   UCBFLB
UCBVALPH EQU   UCBFLB
UCBCRHSN EQU   UCBFLB
UCBCRHRV EQU   UCBFLB
UCBRESVH EQU   UCBFLB
UCBSPST  EQU   UCBFLB
UCBASNS  EQU   UCBFLB
UCBIORST EQU   UCBFLB
UCBQISCE EQU   UCBFL1
UCBACTV  EQU   UCBFL1
UCBSAP   EQU   UCBFL1
UCBNOTRC EQU   UCBCUB
UCBPSNS  EQU   UCBFL1
UCBUSING EQU   UCBPST
UCBNOTRD EQU   UCBNRY
UCBBUSYD EQU   UCBBSY
UCBUA    EQU   UCBCHAN+1
UCBCHA   EQU   UCBCHAN
UCBDADI  EQU   UCBSTAT
UCBSYSR  EQU   UCBSTAT
UCBPRES  EQU   UCBSTAT
UCBALOC  EQU   UCBSTAT
UCBUNLD  EQU   UCBSTAT
UCBRESV  EQU   UCBSTAT
UCBCHGS  EQU   UCBSTAT
UCBONLI  EQU   UCBSTAT
UCBID    EQU   UCBOB+2
UCBALTPH EQU   UCBFL5
UCBALTCU EQU   UCBFL5
UCBNALOC EQU   UCBFL5
UCBENVRD EQU   UCBFL5
UCBVSDR  EQU   UCBFL5
UCBSASK  EQU   UCBFL5
UCBAMV   EQU   UCBAF
UCBDCC   EQU   UCBFL5
UCBMONT  EQU   UCBJBNR
UCBRV011 EQU   UCBJBNR
UCBRSV02 EQU   UCBJBNR
UCBOLDSM EQU   UCBJBNR
UCBRV003 EQU   UCBJBNR
UCBDUC   EQU   UCBJBNR
UCBJES3  EQU   UCBJBNR
UCBVRDEV EQU   UCBJBNR
UCBCMSEG EQU   UCBOB
UCBPFXND EQU   UCB+512
UCBIOQ   EQU   UCB+508
UCBLOCK  EQU   UCB+504
UCBPXST  EQU   UCB+504
@NM00079 EQU   UCB
CVTLEVL  EQU   CVTRELNO+2
CVTNUMB  EQU   CVTRELNO
CVTMDL   EQU   CVTFIX+250
@NM00078 EQU   CVTFIX+248
@NM00077 EQU   CVTFIX
CVTRV482 EQU   CVTXTNT2+128
CVTRV481 EQU   CVTXTNT2+124
CVTRV480 EQU   CVTXTNT2+120
CVTRV479 EQU   CVTXTNT2+118
CVTRV478 EQU   CVTXTNT2+117
CVTRV477 EQU   CVTXTNT2+116
CVTRV476 EQU   CVTXTNT2+115
CVTRV475 EQU   CVTXTNT2+114
CVTRV474 EQU   CVTRV466
CVTRV473 EQU   CVTRV466
CVTRV472 EQU   CVTRV466
CVTRV471 EQU   CVTRV466
CVTRV470 EQU   CVTRV466
CVTRV469 EQU   CVTRV466
CVTRV468 EQU   CVTRV466
CVTRV467 EQU   CVTRV466
CVTRV465 EQU   CVTRV457
CVTRV464 EQU   CVTRV457
CVTRV463 EQU   CVTRV457
CVTRV462 EQU   CVTRV457
CVTRV461 EQU   CVTRV457
CVTRV460 EQU   CVTRV457
CVTRV459 EQU   CVTRV457
CVTRV458 EQU   CVTRV457
CVTRV456 EQU   CVTXTNT2+108
CVTRV455 EQU   CVTXTNT2+104
CVTRV454 EQU   CVTXTNT2+100
CVTRV453 EQU   CVTXTNT2+96
CVTRV452 EQU   CVTXTNT2+94
CVTRV451 EQU   CVTXTNT2+92
CVTRV450 EQU   CVTXTNT2+90
CVTRV449 EQU   CVTXTNT2+88
CVTRV448 EQU   CVTXTNT2+87
CVTRV447 EQU   CVTXTNT2+86
CVTRV446 EQU   CVTRV438
CVTRV445 EQU   CVTRV438
CVTRV444 EQU   CVTRV438
CVTRV443 EQU   CVTRV438
CVTRV442 EQU   CVTRV438
CVTRV441 EQU   CVTRV438
CVTRV440 EQU   CVTRV438
CVTRV439 EQU   CVTRV438
CVTRV437 EQU   CVTRV429
CVTRV436 EQU   CVTRV429
CVTRV435 EQU   CVTRV429
CVTRV434 EQU   CVTRV429
CVTRV433 EQU   CVTRV429
CVTRV432 EQU   CVTRV429
CVTRV431 EQU   CVTRV429
CVTRV430 EQU   CVTRV429
CVTRV428 EQU   CVTXTNT2+80
CVTRV427 EQU   CVTXTNT2+76
CVTRV426 EQU   CVTXTNT2+72
CVTRV425 EQU   CVTXTNT2+68
CVTATACT EQU   CVTATCVT
CVTRV423 EQU   CVTXTNT2+62
CVTRV422 EQU   CVTXTNT2+60
CVTRV421 EQU   CVTXTNT2+58
CVTRV420 EQU   CVTXTNT2+56
CVTRV419 EQU   CVTXTNT2+55
CVTRV418 EQU   CVTXTNT2+54
CVTRV417 EQU   CVTRV409
CVTRV416 EQU   CVTRV409
CVTRV415 EQU   CVTRV409
CVTRV414 EQU   CVTRV409
CVTRV413 EQU   CVTRV409
CVTRV412 EQU   CVTRV409
CVTRV411 EQU   CVTRV409
CVTRV410 EQU   CVTRV409
CVTRV408 EQU   CVTRV400
CVTRV407 EQU   CVTRV400
CVTRV406 EQU   CVTRV400
CVTRV405 EQU   CVTRV400
CVTRV404 EQU   CVTRV400
CVTRV403 EQU   CVTRV400
CVTRV402 EQU   CVTRV400
CVTRV401 EQU   CVTRV400
CVTICB   EQU   CVTXTNT2+48
CVTSKTA  EQU   CVTXTNT2+44
CVTRSV99 EQU   CVTXTNT2+40
CVTRSV98 EQU   CVTXTNT2+36
CVTRSV97 EQU   CVTXTNT2+34
CVTRSV96 EQU   CVTXTNT2+32
CVTOLTEP EQU   CVTXTNT2+28
CVTQIDA  EQU   CVTQID+1
CVTRSV95 EQU   CVTQID
CVTRSV94 EQU   CVTXTNT2+20
CVTRSV93 EQU   CVTXTNT2+16
CVTRSV92 EQU   CVTXTNT2+12
CVTDEBVR EQU   CVTXTNT2+8
CVTRSV91 EQU   CVTXTNT2+6
CVTRSV9H EQU   CVTFLGBT
CVTRSV9G EQU   CVTFLGBT
CVTRSV9F EQU   CVTFLGBT
CVTRSV9E EQU   CVTFLGBT
CVTRSV9D EQU   CVTFLGBT
CVTRSV9C EQU   CVTFLGBT
CVTVME   EQU   CVTFLGBT
CVTNPE   EQU   CVTFLGBT
CVTNUCLS EQU   CVTXTNT2+4
CVTDSSVA EQU   CVTDSSV+1
CVTRSV89 EQU   CVTDSSV
CVTRSV88 EQU   CVTXTNT1+8
CVTRSV87 EQU   CVTXTNT1+4
CVTFACHN EQU   CVTXTNT1
CVTRV488 EQU   CVTMAP+412
CVTRV487 EQU   CVTMAP+408
CVTRV486 EQU   CVTMAP+404
CVTRV485 EQU   CVTMAP+400
CVTACTAP EQU   CVTMAP+396
CVTAUTH  EQU   CVTMAP+392
CVTATMCA EQU   CVTATMCT+1
CVTATMST EQU   CVTATMCT
CVTRSV61 EQU   CVTMAP+384
CVTVOLT1 EQU   CVTVOLM1+1
CVTVOLI1 EQU   CVTVOLF1
CVTSTOA  EQU   CVTMAP+376
CVTRSV58 EQU   CVTMAP+374
CVTRSV57 EQU   CVTMAP+372
CVTDDCE  EQU   CVTMAP+368
CVTPNWFR EQU   CVTMAP+364
CVTSMF   EQU   CVTMAP+360
CVTSULK  EQU   CVTMAP+358
CVTSLKO  EQU   CVTSYSK
CVTSLKP  EQU   CVTSYSK
CVTSLKQ  EQU   CVTSYSK
CVTSLKR  EQU   CVTSYSK
CVTRSV56 EQU   CVTSYSK
CVTRSV55 EQU   CVTSYSK
CVTRSV54 EQU   CVTSYSK
CVTRSV53 EQU   CVTSYSK
CVTRSV52 EQU   CVTA1F1
CVTRSV51 EQU   CVTA1F1
CVTRSV50 EQU   CVTA1F1
CVTRSV49 EQU   CVTA1F1
CVTRSV48 EQU   CVTA1F1
CVTRSV47 EQU   CVTA1F1
CVTSRSW  EQU   CVTA1F1
CVTPFSW  EQU   CVTA1F1
CVTPCVT  EQU   CVTMAP+352
CVTRSV46 EQU   CVTMAP+344
CVTRSV45 EQU   CVTMAP+340
CVTRSV44 EQU   CVTMAP+338
CVTRSV43 EQU   CVTMAP+336
CVTHJESA EQU   CVTHJES+1
CVTRSV42 EQU   CVTHJES
CVTEXT2A EQU   CVTEXT2+1
CVTRSV41 EQU   CVTEXT2
CVTAPFA  EQU   CVTAPF+1
CVTRSV40 EQU   CVTAPF
CVTRV518 EQU   CVTINTLA
CVTRV517 EQU   CVTERPV
CVTEORM  EQU   CVTMAP+312
CVTMCHPR EQU   CVTMAP+308
CVTTZ    EQU   CVTMAP+304
CVTJEPS  EQU   CVTMAP+300
CVTJESCT EQU   CVTMAP+296
CVTMODE  EQU   CVTMAP+292
CVTPTRV  EQU   CVTMAP+288
CVTREAL  EQU   CVTMAP+284
CVTRSV39 EQU   CVTMAP+280
CVTRSV38 EQU   CVTMAP+276
CVTDMSRA EQU   CVTDMSR+1
CVTRV634 EQU   CVTDMSRF
CVTRV633 EQU   CVTDMSRF
CVTRV632 EQU   CVTDMSRF
CVTRV631 EQU   CVTDMSRF
CVTRV630 EQU   CVTDMSRF
CVTRV629 EQU   CVTDMSRF
CVTUDUMP EQU   CVTDMSRF
CVTSDUMP EQU   CVTDMSRF
CVTQMSGA EQU   CVTQMSG+1
CVTRSV36 EQU   CVTQMSG
CVTAMFF  EQU   CVTMAP+264
CVTPURGA EQU   CVTPURG+1
CVTRSV35 EQU   CVTPURG
CVTCBSP  EQU   CVTMAP+256
CVTATERA EQU   CVTATER+1
CVTSYST  EQU   CVTATER
CVTVOLT2 EQU   CVTTAT
CVTVOLI2 EQU   CVTVOLF2
CVTAQAVB EQU   CVTAQAVT+1
CVTRSV34 EQU   CVTTCMFG
CVTRSV33 EQU   CVTTCMFG
CVTRSV32 EQU   CVTTCMFG
CVTRSV31 EQU   CVTTCMFG
CVTRSV30 EQU   CVTTCMFG
CVTRSV29 EQU   CVTTCMFG
CVTRSV28 EQU   CVTTCMFG
CVTTCRDY EQU   CVTTCMFG
CVTGTFA  EQU   CVTGTF+1
CVTRSV27 EQU   CVTGTFST
CVTRNIO  EQU   CVTGTFST
CVTUSR   EQU   CVTGTFST
CVTRV318 EQU   CVTFORM
CVTRV317 EQU   CVTTMODE
CVTRV316 EQU   CVTSTATE
CVTRV315 EQU   CVTGTFS
CVTGTFAV EQU   CVTGTFS
CVT0SCR1 EQU   CVTMAP+232
CVTRV515 EQU   CVTMAP+228
CVTRMS   EQU   CVTMAP+224
CVTPATCH EQU   CVTMAP+220
CVTTSCE  EQU   CVTMAP+216
CVTLNKSC EQU   CVTMAP+214
CVTQABST EQU   CVTMAP+212
CVTMDLDS EQU   CVTMAP+208
CVTUSER  EQU   CVTMAP+204
CVTABEND EQU   CVTMAP+200
CVTSMCA  EQU   CVTMAP+196
CVTRSV18 EQU   CVTMAP+192
CVTQLPAQ EQU   CVTMAP+188
CVTQCDSR EQU   CVTMAP+184
CVTRSV17 EQU   CVTOPTB
CVTRSV16 EQU   CVTOPTB
CVTFP    EQU   CVTOPTB
CVTAPTHR EQU   CVTOPTB
CVTNLOG  EQU   CVTOPTB
CVTTOD   EQU   CVTOPTB
CVTCTIMS EQU   CVTOPTB
CVTPROT  EQU   CVTOPTB
CVTXPFP  EQU   CVTOPTA
CVTASCII EQU   CVTOPTA
CVTRSV13 EQU   CVTOPTA
CVTRSV12 EQU   CVTOPTA
CVTNIP   EQU   CVTOPTA
CVTDDR   EQU   CVTOPTA
CVTAPR   EQU   CVTOPTA
CVTCCH   EQU   CVTOPTA
CVTSNCTR EQU   CVTMAP+180
CVTQMWR  EQU   CVTMAP+176
CVTQOCR  EQU   CVTMAP+172
CVT1EF00 EQU   CVTMAP+168
CVTMZ00  EQU   CVTMAP+164
CVTHEAD  EQU   CVTMAP+160
CVTRSV11 EQU   CVTMAP+156
CVT0PT01 EQU   CVTMAP+152
CVTMSER  EQU   CVTMAP+148
CVTRV516 EQU   CVTIERLC
CVTILCH  EQU   CVTMAP+140
CVT0DS   EQU   CVTMAP+136
CVTFBOSV EQU   CVTMAP+132
CVTNUCB  EQU   CVTMAP+128
CVTIXAVL EQU   CVTMAP+124
CVTIOQET EQU   CVTMAP+120
CVTDCBA  EQU   CVTMAP+117
CVTMVS2  EQU   CVTDCB
CVT6DAT  EQU   CVTDCB
CVT4MPS  EQU   CVTDCB
CVTRSV09 EQU   CVTDCB
CVT4MS1  EQU   CVTDCB
CVT2SPS  EQU   CVTDCB
CVT1SSS  EQU   CVTDCB
CVTRSV08 EQU   CVTDCB
CVTSTB   EQU   CVTMAP+112
CVTQTD00 EQU   CVTMAP+108
CVTQTE00 EQU   CVTMAP+104
CVTCUCB  EQU   CVTMAP+100
CVTSJQ   EQU   CVTMAP+96
CVTPBLDL EQU   CVTMAP+92
CVTTPC   EQU   CVTMAP+88
CVTSVDCB EQU   CVTMAP+84
CVTBRET  EQU   CVTMAP+82
CVTEXIT  EQU   CVTMAP+80
CVT0FN00 EQU   CVTMAP+76
CVTDARA  EQU   CVTDAR+1
CVTRSV07 EQU   CVTFLGS1
CVTRSV06 EQU   CVTFLGS1
CVTRSV05 EQU   CVTFLGS1
CVTRSV04 EQU   CVTFLGS1
CVTRSV03 EQU   CVTFLGS1
CVTRSV02 EQU   CVTFLGS1
CVTRSV01 EQU   CVTFLGS1
CVTDMPLK EQU   CVTFLGS1
CVTXITP  EQU   CVTMAP+68
CVTZDTAB EQU   CVTMAP+64
CVTMSLT  EQU   CVTMAP+60
CVTDATE  EQU   CVTMAP+56
CVTBTERM EQU   CVTMAP+52
CVTXTLER EQU   CVTMAP+44
CVTILK2  EQU   CVTMAP+40
CVTILK1  EQU   CVTMAP+36
CVTPRLTV EQU   CVTMAP+32
CVT0VL00 EQU   CVTMAP+24
CVTXAPG  EQU   CVTMAP+20
CVTBUF   EQU   CVTMAP+16
CVTJOB   EQU   CVTMAP+12
CVT0EF00 EQU   CVTMAP+4
CVTTCBP  EQU   CVTMAP
CVT      EQU   CVTMAP
*@NM00076 EQU   NIPPTATF                                           @L01
*@NM00075 EQU   NIPPTOPF                                           @L01
PTABEND  EQU   PARMTAB+312
@NM00074 EQU   PARMTAB+308
DUPLEX   EQU   PARMTAB+304
@NM00073 EQU   PARMTAB+300
PAGNUM   EQU   PARMTAB+296
@NM00072 EQU   PARMTAB+292
SWAP     EQU   PARMTAB+288
@NM00071 EQU   PARMTAB+284
RSU      EQU   PARMTAB+280
@NM00070 EQU   @NM00068+1
*@NM00069 EQU   NIPPAFLG                                           @L01
@NM00067 EQU   PARMTAB+268
PURGE    EQU   PARMTAB+264
@NM00066 EQU   PARMTAB+260
WTORPLY  EQU   PARMTAB+256
@NM00065 EQU   PARMTAB+252
WTOBFRS  EQU   PARMTAB+248
@NM00064 EQU   PARMTAB+244
VRREGN   EQU   PARMTAB+240
@NM00063 EQU   PARMTAB+236
VAL      EQU   PARMTAB+232
@NM00062 EQU   PARMTAB+228
SYSP     EQU   PARMTAB+224
@NM00061 EQU   PARMTAB+220
SQA      EQU   PARMTAB+216
@NM00060 EQU   PARMTAB+212
SMF      EQU   PARMTAB+208
@NM00059 EQU   PARMTAB+204
REAL     EQU   PARMTAB+200
@NM00058 EQU   PARMTAB+196
PAGEO    EQU   PARMTAB+192
@NM00057 EQU   PARMTAB+188
PAGEP    EQU   PARMTAB+184
@NM00056 EQU   PARMTAB+180
OPT      EQU   PARMTAB+176
@NM00055 EQU   PARMTAB+172
OPI      EQU   PARMTAB+168
@NM00054 EQU   PARMTAB+164
NUCMAP   EQU   PARMTAB+160
@NM00053 EQU   PARMTAB+156
MLPA     EQU   PARMTAB+152
@NM00052 EQU   PARMTAB+148
MAXUSER  EQU   PARMTAB+144
@NM00051 EQU   PARMTAB+140
LOGLMT   EQU   PARMTAB+136
@NM00050 EQU   PARMTAB+132
LOGCLS   EQU   PARMTAB+128
@NM00049 EQU   PARMTAB+124
@NM00048 EQU   PARMTAB+116
IPS      EQU   PARMTAB+112
@NM00047 EQU   PARMTAB+108
HARDCPY  EQU   PARMTAB+104
@NM00046 EQU   PARMTAB+100
FIX      EQU   PARMTAB+96
@NM00045 EQU   PARMTAB+92
DUMP     EQU   PARMTAB+88
@NM00044 EQU   PARMTAB+84
CVIO     EQU   PARMTAB+80
@NM00043 EQU   PARMTAB+76
CSA      EQU   PARMTAB+72
@NM00042 EQU   PARMTAB+68
CPQE     EQU   PARMTAB+64
@NM00041 EQU   PARMTAB+60
CONT     EQU   PARMTAB+56
@NM00040 EQU   PARMTAB+52
CMD      EQU   PARMTAB+48
@NM00039 EQU   PARMTAB+44
CLPA     EQU   PARMTAB+40
@NM00038 EQU   PARMTAB+36
BLDLF    EQU   PARMTAB+32
@NM00037 EQU   PARMTAB+28
BLDL     EQU   PARMTAB+24
@NM00036 EQU   PARMTAB+20
APG      EQU   PARMTAB+16
@NM00035 EQU   PARMTAB+12
APF      EQU   PARMTAB+8
@NM00034 EQU   NIPPAREA+248
*@NM00033 EQU   NIPPAECB+1                                         @L01
*@NM00032 EQU   NIPPAIOD+37                                        @L01
@NM00031 EQU   NIPPAREA+30
*@NM00030 EQU   NIPPABDL+15                                        @L01
@NM00029 EQU   NIPPAREA
NSCHDCPU EQU   NIPSCHDL+8
NSCHDPRM EQU   NIPSCHDL+4
NSCHDPTR EQU   NIPSCHDL
@NM00028 EQU   NIPOPNPL+22
NOPNRC   EQU   NIPOPNPL+21
NOPNFLSX EQU   NOPNFL
NOPNFLLC EQU   NOPNFL
NOPNFLLB EQU   NOPNFL
NOPNFLNB EQU   NOPNFL
NOPNFLI  EQU   NOPNFL
NOPNFLM  EQU   NOPNFL
NOPNFAU  EQU   NOPNFL
NOPNFRS  EQU   NOPNFL
@NM00027 EQU   NIPMNTPL+21
NMNTFLB  EQU   NMNTFL
NMNTFLC  EQU   NMNTFL
NMNTFLI  EQU   NMNTFL
NMNTFUS  EQU   NMNTFL
@NM00026 EQU   NMNTFL
NMNTUCB  EQU   NMNTVS
NWTORMSG EQU   NWTORLST+12
@NM00025 EQU   NWTORLST+11
@NM00024 EQU   NWTORFL
NWTORFLB EQU   NWTORFL
@NM00023 EQU   NWTORFL
NWTORFLA EQU   NWTORFL
NMTORRDL EQU   NWTORLST+8
NWTORECB EQU   NWTORLST+4
NWTORRPA EQU   NWTORLST
@NM00022 EQU   NWTOFL
NWTOFLNC EQU   NWTOFL
NWTOFLNH EQU   NWTOFL
NVTLPAHA EQU   NVT+548
NVTLPALO EQU   NVT+544
NVTRMSG  EQU   NVT+540
NVTRLOCK EQU   NVT+536
NVTRCODE EQU   NVT+532
@NM00021 EQU   NVT+529
@NM00020 EQU   NVTFLPO
NVTFLWS  EQU   NVTFLPO
NVTFLQS  EQU   NVTFLPO
@NM00019 EQU   NVTFLPO
NVTRSV48 EQU   NVT+524
NVTRSV47 EQU   NVT+520
NVTRSV46 EQU   NVT+516
@NM00018 EQU   NVT+512
NVTREALR EQU   NVT+508
NVTFASVT EQU   NVT+504
NVTRSV45 EQU   NVT+496
NVTVRLNG EQU   NVT+492
NVTVRREG EQU   NVT+488
NVTLVIRT EQU   NVT+484
NVTRSV4A EQU   NVT+480
NVTLPAND EQU   NVT+476
NVTRMSS  EQU   NVT+472
NVTRPQE  EQU   NVT+468
NVTRLLE  EQU   NVT+464
NVTRJPQ  EQU   NVT+460
NVTVMSS  EQU   NVT+456
NVTVPQE  EQU   NVT+452
NVTVLLE  EQU   NVT+448
NVTVJPQ  EQU   NVT+444
NVTLSEC  EQU   NVTLOCAT+4
NVTLFST  EQU   NVTLOCAT
NVTXSEC  EQU   NVTXCTL+4
NVTXFST  EQU   NVTXCTL
@NM00017 EQU   NVT+425
NVTLPACT EQU   NVT+424
NVTCSLPG EQU   NVT+420
NVTCSIOB EQU   NVT+416
NVTCSLNM EQU   NVT+412
NVTCSLIB EQU   NVT+408
NVTBLDL  EQU   NVT+404
NVTVRBLD EQU   NVT+400
@NM00016 EQU   NVT+392
NVTVRTCB EQU   NVT+388
NVTVVTCB EQU   NVT+384
NVTRSV44 EQU   NVT+380
NVTQSBUF EQU   NVT+376
NVTRSV43 EQU   NVT+364
@NM00015 EQU   NVT+363
NVTABWS1 EQU   NVT+362
NVTABCD1 EQU   NVT+360
@NM00014 EQU   NVT+358
NVTCPUAD EQU   NVT+356
NVTTOD   EQU   NVT+352
NVTMBEND EQU   NVT+340
NVTMBUF  EQU   NVT+336
NVTDCBSN EQU   NVT+332
NVTDCBOC EQU   NVT+328
NVTDCBIC EQU   NVT+324
@NM00013 EQU   NVT+308
NVTNMBLD EQU   NVT+304
NVTNIPM  EQU   NVT+292
NVTPRMPT EQU   NVT+272
NVTIX    EQU   NVTFLWSC
NVTFLWS1 EQU   NVTWPSW2+2
NVTIDPSW EQU   NVTWPSW2
NVTWPSW1 EQU   NVTWTPSW
NVTMCPSW EQU   NVT+216
@NM00012 EQU   NVT+212
@NM00011 EQU   NVTFLCN
NVTFLRAC EQU   NVTFLCN
NVTFLNCK EQU   NVTFLCN
NVTFLNHC EQU   NVTFLCN
NVTFLASM EQU   NVTFLCN
NVTMP    EQU   NVTFLCN
NVTFLIOC EQU   NVTFLCN
NVTFLAC  EQU   NVTFLCN
NVTFLSG  EQU   NVT+210
NVTTRACE EQU   NVT+208
NVTNXPTR EQU   NVT+204
NVTNXSIZ EQU   NVT+202
@NM00010 EQU   NVT+200
NVTSGPSA EQU   NVT+196
NVTN0MSG EQU   NVT+192
NVTVVPG1 EQU   NVT+188
NVTNBFND EQU   NVT+184
NVTNUCND EQU   NVT+180
NVTSTMAP EQU   NVT+176
NVTRTMSA EQU   NVT+172
NVTMFASA EQU   NVT+168
NVTLSPQE EQU   NVT+164
NVTALSQA EQU   NVT+160
NVTPQSAV EQU   NVT+156
NVTSVC60 EQU   NVT+148
NVTABSEC EQU   NVTABSAV+4
NVTABFST EQU   NVTABSAV
NVTNVSQA EQU   NVT+138
NVTRSVMN EQU   NVT+136
NVTNBMIN EQU   NVT+134
NVTRGNAV EQU   NVT+132
NVTLSQNO EQU   NVT+130
NVTSQANO EQU   NVT+128
NVTLSQAS EQU   NVT+124
NVTLNGFX EQU   NVT+120
NVTIGXER EQU   NVT+116
@NM00009 EQU   NVT+112
NVTRSV49 EQU   NVT+108
NVTNVRSZ EQU   NVT+104
NVTMFA   EQU   NVT+100
NVTDSSNG EQU   NVT+96
NVTMSLNK EQU   NVT+92
NVTVVMDI EQU   NVT+88
NVTIGCER EQU   NVT+84
NVTVBLDL EQU   NVT+80
NVTSVCTB EQU   NVT+76
NVTRSV42 EQU   NVT+72
NVTRSV41 EQU   NVT+68
NVTMASCB EQU   NVT+64
NVTCMTCB EQU   NVT+60
NVTMSTCB EQU   NVT+56
@NM00008 EQU   NVTFLLB
NVTFLSLB EQU   NVTFLLB
@NM00007 EQU   NVTNPATR
NVTNPREU EQU   NVTNPREN
@NM00006 EQU   NVTNPREN
NVTNPSFX EQU   NVT+53
@NM00005 EQU   NVT+52
NVTNPSUF EQU   NVT
ECBEVNT  EQU   ECBEXTND
@NM00004 EQU   ECBEXTND
@NM00003 EQU   ECBBYTE3
@NM00002 EQU   ECBEXTBA
@NM00001 EQU   ECBCC
ECBPOSTB EQU   ECBCC
ECBWAITB EQU   ECBCC
IOBRSV19 EQU   IOBINCAM+1
IOBOLTST EQU   IOBBTAMF
IOBRFTMG EQU   IOBBTAMF
IOBRSV17 EQU   IOBBTAMF
IOBRSV16 EQU   IOBBTAMF
IOBRSV15 EQU   IOBBTAMF
IOBRSV14 EQU   IOBBTAMF
IOBINUSE EQU   IOBBTAMF
IOBPRMER EQU   IOBBTAMF
IOBRSTRB EQU   IOBRESTR+1
IOBREPOS EQU   IOBRESTR
IOBDCBPB EQU   IOBDCBPT+1
IOBRSV44 EQU   IOBFLAG4
IOBJES3I EQU   IOBFLAG4
IOBRSV42 EQU   IOBFLAG4
IOBRSV41 EQU   IOBFLAG4
IOBRSV40 EQU   IOBFLAG4
IOBPMERR EQU   IOBFLAG4
IOBCC3WE EQU   IOBFLAG4
IOBGDPOL EQU   IOBFLAG4
IOBSTRTB EQU   IOBSTART+1
IOBSIOCC EQU   IOBSTART
IOBCSB7  EQU   IOBCSTAT
IOBCSB6  EQU   IOBCSTAT
IOBCSB5  EQU   IOBCSTAT
IOBCSB4  EQU   IOBCSTAT
IOBCSB3  EQU   IOBCSTAT
IOBCSB2  EQU   IOBCSTAT
IOBCSB1  EQU   IOBCSTAT
IOBCSB0  EQU   IOBCSTAT
IOBUSB7  EQU   IOBUSTAT
IOBUSB6  EQU   IOBUSTAT
IOBUSB5  EQU   IOBUSTAT
IOBUSB4  EQU   IOBUSTAT
IOBUSB3  EQU   IOBUSTAT
IOBUSB2  EQU   IOBUSTAT
IOBUSB1  EQU   IOBUSTAT
IOBUSB0  EQU   IOBUSTAT
IOBCMDA  EQU   IOBIOCSW
IOBLOG   EQU   IOBFL3
IOBJAM   EQU   IOBICL
IOBMSG   EQU   IOBFL3
IOBSDR   EQU   IOBCNC
IOBACU   EQU   IOBFL3
IOBCDC   EQU   IOBFL3
IOBICC   EQU   IOBFL3
IOBCCC   EQU   IOBFL3
IOBECBPB EQU   IOBECBPT+1
IOBECBCC EQU   IOBECBPT
IOBS1B7  EQU   IOBSENS1
IOBS1B6  EQU   IOBSENS1
IOBS1B5  EQU   IOBSENS1
IOBS1B4  EQU   IOBSENS1
IOBS1B3  EQU   IOBSENS1
IOBS1B2  EQU   IOBSENS1
IOBS1B1  EQU   IOBSENS1
IOBS1B0  EQU   IOBSENS1
IOBSNSC9 EQU   IOBS0B7
IOBS0B6  EQU   IOBSENS0
IOBS0B5  EQU   IOBSENS0
IOBS0B4  EQU   IOBSENS0
IOBS0B3  EQU   IOBSENS0
IOBS0B2  EQU   IOBSENS0
IOBS0B1  EQU   IOBSENS0
IOBS0B0  EQU   IOBSENS0
IOBPNCH  EQU   IOBFLAG2
IOBSTATO EQU   IOBFLAG2
IOBSKUPD EQU   IOBFLAG2
IOBALTTR EQU   IOBFLAG2
IOBRRT2  EQU   IOBRDHA0
IOBRRT3  EQU   IOBPURGE
IOBSENSE EQU   IOBFLAG2
IOBHALT  EQU   IOBFLAG2
IOBSPSVC EQU   IOBRSTRT
IOBUNREL EQU   IOBFLAG1
IOBIOERR EQU   IOBFLAG1
IOBFCREX EQU   IOBCYCCK
IOBRPSTN EQU   IOBFLAG1
IOBERRTN EQU   IOBFLAG1
IOBCMDCH EQU   IOBFLAG1
IOBDATCH EQU   IOBFLAG1
IOBCNOPA EQU   IOBPREFX+12
IOBCICB  EQU   IOBPREFX+8
IOBCECB  EQU   IOBPREFX+4
IOBCONOP EQU   IOBPREFX+3
IOBCINOP EQU   IOBPREFX+2
IOBRSV05 EQU   IOBPREFX+1
IOBPCI   EQU   IOBCFLG1
IOBRSTCH EQU   IOBCFLG1
IOBABAPP EQU   IOBCFLG1
IOBPTST  EQU   IOBCFLG1
IOBRSV04 EQU   IOBCFLG1
IOBRSV03 EQU   IOBCFLG1
IOBRSV02 EQU   IOBCFLG1
IOBRSV01 EQU   IOBCFLG1
.@UNREFD ANOP                          END UNREFERENCED COMPONENTS
@RC00378 EQU   NP3EXIT
@RT00424 EQU   NP3OPIA
@RT00441 EQU   NP3OPIA
@RT00519 EQU   NP3SYSDE
@RT00522 EQU   NP3SYXIT
@RT00529 EQU   NP3UPDAT
@RF00529 EQU   NP3ALPHA
@RF00538 EQU   NP3SYINV
@RF00536 EQU   NP3SETXX
@RF00534 EQU   NP3SYINV
@RT00581 EQU   NP3SYNXT
@RF00581 EQU   NP3SYTND
@RT00595 EQU   NP3SPAVL
@RT00631 EQU   NP3SYTXT
@RT00645 EQU   NP3SYNXT
@RT00647 EQU   NP3SYNXT
@RF00659 EQU   NP3NXOPI
@RT00665 EQU   NP3SYXIT
@RT00688 EQU   NP3SYXIT
@RT00693 EQU   NP3SYXIT
@RT00695 EQU   NP3SYINV
@RT00731 EQU   NP3IGNOP
@RF00719 EQU   NP3NXFLD
@RT00765 EQU   NP3IMSG
@RT00790 EQU   NP3PTINT
@RT00792 EQU   NP3PTINX
@RT00815 EQU   NP3PAFM
@RC00881 EQU   @RC00878
@RC00899 EQU   @RC00896
@RC00936 EQU   @RC00932
@RC00960 EQU   @RC00959
@RT00968 EQU   NP3SW38
@RT00975 EQU   NP3ENDFL
@RF00975 EQU   SCANRCD
@RT00980 EQU   NP3LCTFL
@RF00982 EQU   NP3LCNND
@RT00999 EQU   NP3LCNAM
@RT01001 EQU   NP3LCNAM
@RT01006 EQU   NP3LCNXT
@RT01008 EQU   NP3LCNXT
@RT01024 EQU   NP3LCTRN
@RT01033 EQU   NP3LCTXT
@RT01042 EQU   NP3LCEND
@RT01058 EQU   NP3LCLOC
@RT01061 EQU   NP3LCVXT
@RT01063 EQU   NP3LCVFL
@RT01070 EQU   NP3LCCAN
@RF01089 EQU   NP3IFLOC
@RT01096 EQU   NP3LCVL1
@RT01099 EQU   NP3LCMXT
@RT01101 EQU   NP3LCMNH
@RT01109 EQU   NP3LCMCK
@RT01134 EQU   NP3CHNDL
@RT01166 EQU   NP3EQUSB
@RT01185 EQU   NP3BALN
@RT01231 EQU   NP3SNDER
@RF01247 EQU   NP3ENDL
@RF01240 EQU   NP3RECNT
@RT01263 EQU   NP3RECNT
@RT01265 EQU   NP3PRINV
@RT01268 EQU   NP3OUT
@RF01286 EQU   NP3PRINV
@RF01283 EQU   NP3PRINV
@RT01296 EQU   NP3PCHCK
@RT01313 EQU   NP3POLST
@RT01315 EQU   NP3PONXT
@RT01322 EQU   NP3POXIT
@RT01327 EQU   NP3INVOP
@RF01337 EQU   NP3INVOP
@RT01409 EQU   NIPPMPRD
@RT01420 EQU   NIPPMPFN
@RT01422 EQU   NIPPMPER
@RT01431 EQU   NIPPMPRD
@RT01439 EQU   NIPPMPXT
@RF01470 EQU   NIPPMTER
@RF01477 EQU   NIPPMTER
@RT01497 EQU   NIPPMPRD
@RF01497 EQU   NIPPMTND
@RF01495 EQU   NIPPMPBK
@RT01513 EQU   NIPPMPXT
@RT01575 EQU   CONTCHK
@RF01575 EQU   NP3NULL
@RC01735 EQU   @RC01733
@RT01758 EQU   NP3SW38
@RT01765 EQU   NP3SPERS
@RT01773 EQU   NPCSYSP
@RT01776 EQU   NP3SPEST
@RC00900 EQU   @RC00899
@ENDDATA EQU   *
         END   IEAVNP03,(C'PLS2208',0701,76086)
++ MAC      (IEAPPNIP) DISTLIB(AMACLIB ) SYSLIB(MACLIB  )
                       ASSEM(IEAVNP03).
         MACRO ,
&LABEL   IEAPPNIP &PARM=,&DSECT=NO,&TYPE=ENTRY
.*****************************************************************
.*
.* 2003/04/08 NIP system parameters table generation and mappping.
.*
.* Invocation format:
.*
.*  label   IEAPPNIP     TYPE= GENERATE | INITIAL | ENTRY | FINAL
.*                      ,PARM=value
.*                      ,DSECT= YES | NO
.*
.*      Where:
.*
.*       label
.*          is an optional 1 to 8 character alphanumeric character
.*          input string, starting in column 1 (that is, the assembler
.*          label on the macro).
.*          DEFAULT: Null label.
.*
.*       TYPE= GENERATE | INITIAL  | ENTRY | FINAL
.*          describes the type of macro invocation, and is one of:
.*
.*          GENERATE
.*             to generate the entire system parameters table.
.*             There should only be one occurrence of TYPE=GENERATE
.*             in IEAVNP03.
.*
.*          INITIAL
.*             to create the initial system parameters table entry.
.*             TYPE=INITIAL should be coded only in the TYPE=GENERATE
.*             expansion of the IEAPPNIP macro, and should only
.*             appear once, prior to all IEAPPNIP macros with
.*             TYPE=ENTRY.
.*
.*          ENTRY
.*             to create one system parameter table entry.  When
.*             TYPE=ENTRY is specified, the PARM= parameter must
.*             also be specified to define the value for the
.*             parameter table entry.  IEAPPNIP macros with TYPE=ENTRY
.*             should be coded only in the TYPE=GENERATE expansion of
.*             the IEAPPNIP macro, between the TYPE=INITIAL macro
.*             that marks the beginning of the system parameters
.*             table and the TYPE=FINAL macro that signals the end.
.*
.*          FINAL
.*             to create the final system parameters table entry.
.*             TYPE=FINAL should be coded only in the TYPE=GENERATE
.*             expansion of the IEAPPNIP macro, and should only
.*             appear once, after all IEAPPNIP macros with TYPE=ENTRY.
.*
.*          DEFAULT: ENTRY
.*
.*       PARM=value
.*          defines the value for one system parameter table entry.
.*          PARM is required when TYPE=ENTRY is specified.  "value"
.*          may be specified in either of two ways:
.*
.*          o   As a simple quoted string.  In this case, the
.*              string is assumed to be a character string that
.*              is eight or fewer characters.  If the string is
.*              exactly eight bytes long, a "DC CL8'value'" constant
.*              is generated.  If the string is shorter than eight
.*              bytes, a "DC CL7'value'" constant is generated followed
.*              by a one-byte binary field containing the length of
.*              the string.
.*
.*          o   As a raw string.  The string is considered "raw"
.*              if the first character of PARM is not a "'".  In
.*              this case, the entire value of PARM is generated
.*              as-is without modification as the operand of a "DC".
.*
.*          DEFAULT: none
.*
.*       DSECT= YES | NO
.*          is an optional parameter to specify whether the macro
.*          should generate mapping DSECTs (YES) or actual code (NO).
.*          If DSECT=YES is specified, no other parameters should
.*          be specified.  If DSECT=NO is specified or defaulted,
.*          the TYPE parameter is required, and the PARM parameter
.*          is also required if TYPE=ENTRY.
.*          DEFAULT: NO
.*
.* Notes:
.*
.*      New system parameters must be added in two places:
.*
.*          o   To the generated system parameter table after
.*              label NP3IBMEN.
.*
.*          o   To the DSECT that maps the system parameter
.*              table, after label PPENDIBM.
.*
.*      The generated table and the DSECT must match.
.*
.* Change activity:
.*
.*   Flag  Date        By    Description
.*   ----  ----------  ----  -----------------------------------
.*
.*
.*****************************************************************
.*
         LCLA  &PARMLEN
.*
.*---------------------------------------------------------------*
.*       Test if DSECTs are to be generated.  If so, go to       *
.*       generate them.                                          *
.*---------------------------------------------------------------*
         AIF   ('&DSECT' EQ 'YES').DSECTS
.*
.*---------------------------------------------------------------*
.*       Test for specification of TYPE=GENERATE and go          *
.*       to generate the table code if so.                       *
.*---------------------------------------------------------------*
         AIF   ('&TYPE' EQ 'GENERATE').GEN
.*
.*---------------------------------------------------------------*
.*       Not TYPE=GENERATE.  Test for TYPE=INITIAL, and go       *
.*       to create the first table entry if TYPE=INITIAL.        *
.*---------------------------------------------------------------*
         AIF   ('&TYPE' EQ 'INITIAL').INITIAL
.*
.*---------------------------------------------------------------*
.*       Not TYPE=INITIAL.  Test for TYPE=FINAL, and go          *
.*       to create the last table entry if TYPE=FINAL.           *
.*---------------------------------------------------------------*
         AIF   ('&TYPE' EQ 'FINAL').FINAL
.*
.*---------------------------------------------------------------*
.*       The only remaining valid possibility for TYPE           *
.*       is TYPE=ENTRY.  Test for that, and exit with            *
.*       with error if anything else was specified.              *
.*---------------------------------------------------------------*
         AIF   ('&TYPE' NE 'ENTRY').E1
.*
.*---------------------------------------------------------------*
.*       TYPE is ENTRY.  PARM is required for TYPE=ENTRY.        *
.*       Verify that it is present and exit with error           *
.*       if not.                                                 *
.*---------------------------------------------------------------*
         AIF   ('&PARM' EQ '').E2
.*
.*---------------------------------------------------------------*
.*       TYPE is ENTRY.  Test for raw parm value.                *
.*---------------------------------------------------------------*
&PARMLEN SETA  K'&PARM
         AIF   ('&PARM'(1,1) NE '''').ENTRAW
.*
.*---------------------------------------------------------------*
.*       TYPE is ENTRY and PARM value starts with a quote,       *
.*       so we will assume it's a simple quoted string.          *
.*       Determine the string length not counting the            *
.*       enclosing quotes.  If the string is 8 bytes long,       *
.*       go create an 8 byte entry with no length byte.          *
.*       Otherwise, go create a 7 byte entry with a 1 byte       *
.*       length field.                                           *
.*---------------------------------------------------------------*
&PARMLEN SETA  K'&PARM-2
         AIF   (&PARMLEN GT 8).E3
         AIF   (&PARMLEN EQ 8).ENT8
         AGO   .ENT7
.*
.*---------------------------------------------------------------*
.*       TYPE=INITIAL.  Create the first table entry.            *
.*---------------------------------------------------------------*
.INITIAL ANOP  ,
&LABEL   DC    X'FF00000000000001' Initial entry
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       TYPE=FINAL.  Create the last table entry.               *
.*---------------------------------------------------------------*
.FINAL   ANOP  ,
&LABEL   DC    X'FF00000000000001' Final entry
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       TYPE=ENTRY parameter value is a simple quoted           *
.*       string, and the string is exactly 8 bytes long.         *
.*       Create 8 byte table entry with no length field.         *
.*---------------------------------------------------------------*
.ENT8    ANOP  ,
&LABEL   DC    CL8&PARM            Parameter value
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       TYPE=ENTRY parameter value is a simple quoted           *
.*       string, and the string is less than 8 bytes long.       *
.*       Create table entry that is 7 bytes long with a 1        *
.*       byte length field.                                      *
.*---------------------------------------------------------------*
.ENT7    ANOP  ,
&LABEL   DC    CL7&PARM            Parameter value
         DC    AL1(&PARMLEN)       Parameter length
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       Raw parameter.  Create table entry that is              *
.*       exactly the specified value.                            *
.*---------------------------------------------------------------*
.ENTRAW  ANOP  ,
&LABEL   DC    &PARM               Parameter value
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       TYPE=GENERATE.  Generate code for the entire            *
.*       parameter table.                                        *
.*---------------------------------------------------------------*
.GEN     ANOP  ,
SYMBSTRT IEAPPNIP TYPE=INITIAL
*----------------------------------------------------------------*
*        Start of IBM-defined parameters.  Because IBM           *
*        NIP modules assume offsets into this table for          *
*        specific parameters, the IBM-defined parameters         *
*        must not be changed, reordered or deleted, and          *
*        new parameters must not be inserted among the           *
*        IBM-defined parameters.  Place all new parameters       *
*        following the IBM defined section.                      *
*----------------------------------------------------------------*
NP3APF   IEAPPNIP TYPE=ENTRY,PARM='APF='
NP3APG   IEAPPNIP TYPE=ENTRY,PARM='APG='
NP3BLDL  IEAPPNIP TYPE=ENTRY,PARM='BLDL='
NP3BLDLF IEAPPNIP TYPE=ENTRY,PARM='BLDLF='
NP3CLPA  IEAPPNIP TYPE=ENTRY,PARM='CLPA'
NP3CMD   IEAPPNIP TYPE=ENTRY,PARM='CMD='
NP3CNTN  IEAPPNIP TYPE=ENTRY,PARM='CONT'
NP3CPQE  IEAPPNIP TYPE=ENTRY,PARM='CPQE='
NP3CSA   IEAPPNIP TYPE=ENTRY,PARM='CSA='
NP3CVAM  IEAPPNIP TYPE=ENTRY,PARM='CVIO'
NP3DUMP  IEAPPNIP TYPE=ENTRY,PARM='DUMP='
NP3FIX   IEAPPNIP TYPE=ENTRY,PARM='FIX='
NP3HCPY  IEAPPNIP TYPE=ENTRY,PARM='HARDCPY='
NP3IPS   IEAPPNIP TYPE=ENTRY,PARM='IPS='
NP3LNK   IEAPPNIP TYPE=ENTRY,PARM='LNK='
NP3LOGC  IEAPPNIP TYPE=ENTRY,PARM='LOGCLS='
NP3LOGL  IEAPPNIP TYPE=ENTRY,PARM='LOGLMT='
NP3MAXUS IEAPPNIP TYPE=ENTRY,PARM='MAXUSER='
NP3MLPA  IEAPPNIP TYPE=ENTRY,PARM='MLPA='
NP3NUCM  IEAPPNIP TYPE=ENTRY,PARM='NUCMAP'
NP3OPI   IEAPPNIP TYPE=ENTRY,PARM='OPI='
NP3OPT   IEAPPNIP TYPE=ENTRY,PARM='OPT='
NP3PAGE  IEAPPNIP TYPE=ENTRY,PARM='PAGE='
NP3DP    IEAPPNIP TYPE=ENTRY,PARM=X'0000000000000001'
NP3REAL  IEAPPNIP TYPE=ENTRY,PARM='REAL='
NP3SMF   IEAPPNIP TYPE=ENTRY,PARM='SMF='
NP3SQA   IEAPPNIP TYPE=ENTRY,PARM='SQA='
NP3SYSX  IEAPPNIP TYPE=ENTRY,PARM='SYSP='
NP3VAP   IEAPPNIP TYPE=ENTRY,PARM='VAL='
NP3VRREG IEAPPNIP TYPE=ENTRY,PARM='VRREGN='
NP3WTOBF IEAPPNIP TYPE=ENTRY,PARM='WTOBFRS='
NP3WTORB IEAPPNIP TYPE=ENTRY,PARM='WTORPLY='
NP3PURGE IEAPPNIP TYPE=ENTRY,PARM='PURGE'
         IEAPPNIP TYPE=ENTRY,PARM=X'0000000000000007'
NP3RSU   IEAPPNIP TYPE=ENTRY,PARM='RSU='
NP3SWAP  IEAPPNIP TYPE=ENTRY,PARM='SWAP='
NP3PAGNU IEAPPNIP TYPE=ENTRY,PARM='PAGNUM='
NP3DUPLE IEAPPNIP TYPE=ENTRY,PARM='DUPLEX='
         SPACE 1
*----------------------------------------------------------------*
*        End of IBM-defined parameters.  Additional              *
*        system parameters should be placed here.                *
*----------------------------------------------------------------*
NP3IBMEN EQU   *                   End of IBM-defined parameters
NP3PRISU IEAPPNIP TYPE=ENTRY,PARM='PRISUB='
         SPACE 1
SYMBEND  IEAPPNIP TYPE=FINAL
.GENDONE MEXIT ,
.*
.*---------------------------------------------------------------*
.*       DSECT=YES was specfied.  Generate DSECTs for NIP        *
.*       Parameter Area and Parameter Address Table.             *
.*---------------------------------------------------------------*
.DSECTS  ANOP  ,
*      %INCLUDE SYSLIB(IEAPPNIP)                                   */
*/*  *****************************************************************/
*/*                          I E A P P N I P                         */
*/*     MAPPING OF NIP PARAMETER AREA AND PARAMETER ADDRESS TABLE    */
*/*                                                                  */
*/*                     DATE=05/22/74,VS2-3 VERSION                  */
*/*                                                                  */
*/*  *****************************************************************/
*/*  *****          NIP  PARAMETER  AREA  (NIPPAREA)            ******/
*
*----------------------------------------------------------------*
*        NIP Parameter Area header.                              *
*----------------------------------------------------------------*
NIPPAHD# DSECT ,                   NIP Parameter Area header
NIPPAQ   DS    A                   Address of next NPA or zero
NIPPABYT DS    A                   Next available byte
NIPPAHDR EQU   NIPPAHD#,*-NIPPAHD# Alias with length
*
*----------------------------------------------------------------*
*        NIP Parameter Address Table (PARMTAB).                  *
*----------------------------------------------------------------*
PARMTAB# DSECT ,                   BEGIN PARAMETER ADDRESS TAB
PTABSTRT DS    CL8                 DUMMY HEADER
*----------------------------------------------------------------*
*        Start of IBM-defined parameters.  Because IBM           *
*        NIP modules assume offsets into this table for          *
*        specific parameters, the IBM-defined parameters         *
*        must not be changed, reordered or deleted.  New         *
*        parameters must be placed following the IBM             *
*        defined section.                                        *
*----------------------------------------------------------------*
APF      DS    A                   Authorized program libraries
         DS    XL4                   Flags and source ID
APG      DS    A                   Automatic priority group
         DS    XL4                   Flags and source ID
BLDL     DS    A                   PARMLIB member for BLDL
         DS    XL4                   Flags and source ID
BLDLF    DS    A                   Fixed BLDL list
         DS    XL4                   Flags and source ID
CLPA     DS    A                   Create link pack area
         DS    XL4                   Flags and source ID
CMD      DS    A                   Canned operator commands
         DS    XL4                   Flags and source ID
CONT     DS    A                   Line continuation
         DS    XL4                   Flags and source ID
CPQE     DS    A                   Channel prog queue extension
         DS    XL4                   Flags and source ID
CSA      DS    A                   Common service area size
         DS    XL4                   Flags and source ID
CVIO     DS    A                   Warm start VIO data sets
         DS    XL4                   Flags and source ID
DUMP     DS    A                   Tape for SYS1.DUMP
         DS    XL4                   Flags and source ID
FIX      DS    A                   Routines in fixed LPA extn
         DS    XL4                   Flags and source ID
HARDCPY  DS    A                   Hardcopy log
         DS    XL4                   Flags and source ID
IPS      DS    A                   Optimizer IPS group
         DS    XL4                   Flags and source ID
LNK      DS    A                   LNKLSTxx values
         DS    XL4                   Flags and source ID
LOGCLS   DS    A                   Log class values
         DS    XL4                   Flags and source ID
LOGLMT   DS    A                   Log limit values
         DS    XL4                   Flags and source ID
MAXUSER  DS    A                   Maximum no. of address spaces
         DS    XL4                   Flags and source ID
MLPA     DS    A                   Routines in LPA extension
         DS    XL4                   Flags and source ID
NUCMAP   DS    A                   Build another nucmap for DSS
         DS    XL4                   Flags and source ID
OPI      DS    A                   Operator intervention
         DS    XL4                   Flags and source ID
OPT      DS    A                   Optimizer tuning parameters
         DS    XL4                   Flags and source ID
PAGEP    DS    A                   Page DS parms - PARMLIB
         DS    XL4                   Flags and source ID
PAGEO    DS    A                   Page DS parms - operator
         DS    XL4                   Flags and source ID
REAL     DS    A                   V=R address limit
         DS    XL4                   Flags and source ID
SMF      DS    A                   Ptr to SMF parmlib member
         DS    XL4                   Flags and source ID
SQA      DS    A                   SQA virtual space
         DS    XL4                   Flags and source ID
SYSP     DS    A                   System parameter list
         DS    XL4                   Flags and source ID
VAL      DS    A                   Volume attribute processing
         DS    XL4                   Flags and source ID
VRREGN   DS    A                   Default V=R space allocated
         DS    XL4                   Flags and source ID
WTOBFRS  DS    A                   Number of WTO buffers
         DS    XL4                   Flags and source ID
WTORPLY  DS    A                   WTOR reply buffer number
         DS    XL4                   Flags and source ID
PURGE    DS    A                   Purge keyword
         DS    XL4                   Flags and source ID
NIPPAF   DS    0CL8                PARMLIB read Flags
NIPPAFLG DS    XL1                 PARMLIB read Flags
NIPPAFL1 EQU   X'80'               -- Member not found msg suppress
*        EQU   X'7F'               -- Reserved
         DS    XL7                 Reserved
RSU      DS    A                   RSU parm pointer
         DS    XL4                   Flags and source ID
SWAP     DS    A                   Swap data sets
         DS    XL4                   Flags and source ID
PAGNUM   DS    A                   Page/swap DS additions
         DS    XL4                   Flags and source ID
DUPLEX   DS    A                   Common duplex option
         DS    XL4                   Flags and source ID
*----------------------------------------------------------------*
*        End of IBM-defined parameters.  Additional              *
*        system parameters should be placed here.                *
*----------------------------------------------------------------*
PPENDIBM EQU   *                   End of IBM-defined parameters
PRISUB   DS    A                   Primary job entry subsystem
         DS    XL4                   Flags and source ID
.*
PTABEND  DS    2A                  DUMMY TRAILER
PARMTAB  EQU   PARMTAB#,*-PARMTAB# ALIAS WITH LENGTH
         EJECT ,
*----------------------------------------------------------------*
*        NIP Parameter Table (PARMTAB) entry mapping.            *
*----------------------------------------------------------------*
NIPPTE#  DSECT ,                   Begin PARMTAB entry
NIPPTADR DS    A                    PARAMETER ORIGIN ADDRESS
NIPPTOPF DS    XL1                  OPTION FLAGS BYTE
NIPPTOPI EQU   X'80'                -- OPI OPTION
NIPPTLST EQU   X'40'                -- LIST REQUEST OPTION
NIPPTCAN EQU   X'20'                -- CANCEL REQUEST FLAG
*        EQU   X'1F'                -- UNASSIGNED
NIPPTATF DS    XL1                  ATTRIBUTE FLAGS BYTE
NIPPTMRG EQU   X'80'                -- MERGE ATTRIBUTE
*        EQU   X'7F'                -- UNASSIGNED
NIPPTSID DS    CL2                  INPUT SOURCE ID
*                                   -- X'0000' -- OPERATOR
*                                   -- C'XX'   -- PLIB MEMBER SUFFIX
NIPPTE   EQU   NIPPTE#,*-NIPPTE#   Alias with length
*/*  *****    END OF NIP  PARAMETER  ADDRESS  TABLE  ENTRY      ******/
         EJECT ,
*----------------------------------------------------------------*
*        NIP Parameter Area.                                     *
*----------------------------------------------------------------*
NIPPARE# DSECT ,                   Start of parameter area
         DS    CL(L'NIPPAHDR)      PARMAREA HEADER
*
*     /***************************************************************/
*     /*                                                             */
*     /* HERE BEGINS: FOR INITIAL PARMAREA - INITIAL FIELDS FOR OTHER*/
*     /* PARMAREAS - RECORD BUFFER AREA                              */
*     /*                                                             */
*     /***************************************************************/
*
NIPPARC  DS    F                   RETURN CODE FROM IEAPSPIO
NIPPABDL DS    0CL18               PARMLIB BLDL ENTRY
NIPPABDH DS    0CL4                BLDL HEADER
NIPPA2BF DS    CL1                 BEGINNING OF BUFFER AREA
         DS    CL3                 FILLER
NIPPANAM DS    CL8                 PARMLIB MEMBER NAME
NIPPATTR DS    CL3                 MEMBER TTR ENTRY
         DS    CL3                 RESERVED FOR BLDL ENTRY
         DS    CL2                 UNASSIGNED
*      2 NIPPAIOD CHAR(216) BDY(DWORD),/* I/O DATA AREA              */
NIPPAIOD DS    0C                  I/O DATA AREA              */
NIPPATXT DS    CL32                CCW'S - READ TEXT RECORDS
NIPPASID DS    CL5                 SEARCH ID FOR NEXT TEXT RCD
         DS    CL3                 UNASSIGNED
NIPPAIOB DS    CL40                PARMLIB IOB
NIPPADCB DS    CL4                 PARMLIB DCB
NIPPAECB DS    0CL4                PARMLIB ECB
NIPPAECC DS    CL1                 - PARMLIB ECB CONDITION CODE
         DS    CL3                 - REST OF PARMLIB ECB
NIPPADEB DS    CL48                PARMLIB DEB
NIPPARCD DS    CL80                READ AREA FOR PARMLIB RCDS
         DS    CL4                 UNASSIGNED
NIPPAPTB DS    CL(L'PARMTAB)       PARAMETER ADDR TABLE
NIPPABUF DS    CL1                 BEGIN INITIAL PARMAREA BUFFER
NIPPAREA EQU   NIPPARE#,*-NIPPARE# Alias with length
*/*  *****             END  OF  NIP  PARAMETER  AREA            ******/
         MEXIT ,                   .End of DSECTs
.*
.*---------------------------------------------------------------*
.*       Error:  TYPE is not GENERATE or ENTRY.                  *
.*---------------------------------------------------------------*
.E1      ANOP  ,                   .TYPE not GENERATE or ENTRY
         MNOTE 8,'INVALID TYPE "&TYPE"'
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       Error:  PARM required but not specified.                *
.*---------------------------------------------------------------*
.E2      ANOP  ,                   .PARM not specified
         MNOTE 8,'"PARM" IS REQUIRED ON IEAPPNIP MACRO WITH LABEL "&LAB+
               EL"'
         MEXIT ,
.*
.*---------------------------------------------------------------*
.*       Error:  PARM value is longer than eight characters.     *
.*---------------------------------------------------------------*
.E3      ANOP  ,                   .PARM is too long
         MNOTE 8,'"PARM" VALUE EXCEEDS EIGHT CHARACTERS'
         MEXIT ,
         MEND  ,
++ MAC      (IEAPMNIP) DISTLIB(AMACLIB ) SYSLIB(MACLIB  )
                       ASSEM(IEAVNP03).
         MACRO                                                          00010000
&NAME    IEAPMNIP  &TYPE=,&MSGST=,&MSGEND=,&RMSGST=,&RMSGL=,&MOD=,     X00020000
               &ASYNCH=,&PARAM=,&BUFREL=,&OPT=,&CPUID=,&ADDR=           00030000
         LCLC  &NB,&LB,&LC,&SX,&LM,&LI,&AU,&RS,&US                      00040000
.********************************************************************** 00050000
.*           06/27/74   VS2-3 VERSION                                   00060000
.*       INITIALIZE ALL FLAG-SETTING SWITCHES TO ZERO                   00070000
.*                                                                      00080000
.********************************************************************** 00090000
&NB      SETC  '0'                    OPEN - NON-NUCLEUS DEB            00100000
&LB      SETC  '0'                    OPEN - END OF NUCLEUS DEB         00110000
.*                                    MOUNT - UCB ADDRESS GIVEN         00120000
&LC      SETC  '0'                    OPEN,MOUNT - CONDITIONAL REQUEST  00130000
&SX      SETC  '0'                    OPEN - SINGLE EXTENT              00140000
&LM      SETC  '0'                    OPEN - SUPPRESS OPEN MSGS         00150000
&LI      SETC  '0'                    OPEN,MOUNT - DS NAME PTR GIVEN    00160000
&AU      SETC  '0'                    OPEN - AUTHORINZED LIBRARY        00170000
&RS      SETC  '0'                    OPEN - PERMANENTLY RESIDENT DS    00180000
&US      SETC  '0'                    MOUNT- UCB SCAN ONLY              00190000
         AIF   ('&TYPE' EQ 'PLIST').LISTMAC                             00200000
         AIF   ('&TYPE' EQ 'MOUNTPL').LISTMAC                           00210000
         AIF   ('&TYPE' EQ 'OPENPL').LISTMAC                            00220000
         AIF   ('&TYPE' EQ 'SCHEDL').LISTMAC                            00230000
&NAME    DS    0H                                                       00240000
         AGO   .EXMACRO                                                 00250000
.LISTMAC ANOP                                                           00260000
&NAME    DS    0F                                                       00270000
.EXMACRO ANOP                                                           00280000
         AIF   ('&TYPE' NE 'MOUNTPL').NOMPL                             00290000
.**************                                                         00300000
.*                                                                      00310000
.*        NIPMOUNT  PARAMETER  LIST                                     00320000
.*                                                                      00330000
.**************                                                         00340000
         AIF   ('&OPT' NE 'PTR').MNOPTR                                 00350000
         AIF   (K'&PARAM EQ 0).MNOPRM                                   00360000
         DC    A(&PARAM)              DATA SET NAME ADDRESS             00370000
         AGO   .MZER                                                    00380000
.MNOPRM  ANOP                                                           00390000
         DC    A(0)                   DATA SET NAME ADDRESS             00400000
.MZER    ANOP                                                           00410000
         DC    XL8'0000000000000000'  RESERVED                          00420000
         AGO   .MPTR                                                    00430000
.MNOPTR  ANOP                                                           00440000
         DC    CL12'&PARAM '          DATASET NAME                      00450000
.MPTR    ANOP                                                           00460000
         DC    CL6' '                 VOLUME SERIAL OR UCB ADDRESS      00470000
         DC    XL2'0000'              DEVICE TYPE                       00480000
         DC    X'00'                  NIPMOUNT FLAGS                    00490000
         DC    XL3'000000'            UNASSIGNED                        00500000
         AGO   .MACEND                                                  00510000
.NOMPL   AIF   ('&TYPE' NE 'OPENPL').NOOPL                              00520000
.**************                                                         00530000
.*                                                                      00540000
.*        NIPOPEN  PARAMETER  LIST                                      00550000
.*                                                                      00560000
.**************                                                         00570000
         AIF   ('&OPT' NE 'PTR').ONOPTR                                 00580000
         AIF   (K'&PARAM EQ 0).ONOPRM                                   00590000
         DC    A(&PARAM)              DATA SET NAME ADDRESS             00600000
         AGO   .OZER                                                    00610000
.ONOPRM  ANOP                                                           00620000
         DC    A(0)                   DATA SET NAME ADDRESS             00630000
.OZER    ANOP                                                           00640000
         DC    XL8'0000000000000000'  RESERVED                          00650000
         AGO   .OPTR                                                    00660000
.ONOPTR  ANOP                                                           00670000
         DC    CL12'&PARAM '          DATASET NAME                      00680000
.OPTR    ANOP                                                           00690000
         DC    A(0)                   DCB ADDRESS                       00700000
         DC    A(0)                   UCB ADDRESS                       00710000
         DC    X'00'                  NIPOPEN FLAGS                     00720000
         DC    X'00'                  NIPOPEN RETURN CODE               00730000
         DC    XL2'0000'              UNASSIGNED                        00740000
         AGO   .MACEND                                                  00750000
.NOOPL   AIF   ('&TYPE' NE 'MOUNT').NOMNT                               00760000
.**************                                                         00770000
.*                                                                      00780000
.*        LINKAGE TO  NIPMOUNT                                          00790000
.*                                                                      00800000
.**************                                                         00810000
         AIF   ('&OPT(1)' NE 'LB').MNOLB                                00820000
&LB      SETC  '1'                                                      00830000
.MNOLB   AIF   ('&OPT(2)' NE 'LC').MNOLC                                00840000
&LC      SETC  '1'                                                      00850000
.MNOLC   AIF   ('&OPT(3)' NE 'LI').MNOLI                                00860000
&LI      SETC  '1'                                                      00870000
.MNOLI   AIF   ('&OPT(4)' NE 'US').MNOUS                                00880000
&US      SETC  '1'                                                      00890000
.MNOUS   ANOP                                                           00900000
         LA    RPARM,&PARAM           LOAD PARM LIST ADDRESS            00910000
         MVI   NMNTFL(RPARM),B'0000&US&LI&LC&LB'  SET FLAG BITS         00920000
         AGO   .ELOAD                                                   00930000
.NOMNT   AIF   ('&TYPE' NE 'OPEN').NOOPN                                00940000
.**************                                                         00950000
.*                                                                      00960000
.*        LINKAGE TO  NIPOPEN                                           00970000
.*                                                                      00980000
.**************                                                         00990000
         AIF   ('&OPT(1)' NE 'NB').NONB                                 01000000
&NB      SETC  '1'                                                      01010000
.NONB    AIF   ('&OPT(2)' NE 'LB').NOLB                                 01020000
&LB      SETC  '1'                                                      01030000
.NOLB    AIF   ('&OPT(3)' NE 'LC').NOLC                                 01040000
&LC      SETC  '1'                                                      01050000
.NOLC    AIF   ('&OPT(4)' NE 'SX').NOSX                                 01060000
&SX      SETC  '1'                                                      01070000
.NOSX    AIF   ('&OPT(5)' NE 'LM').NOLM                                 01080000
&LM      SETC  '1'                                                      01090000
.NOLM    AIF   ('&OPT(6)' NE 'LI').NOLI                                 01100000
&LI      SETC  '1'                                                      01110000
.NOLI    AIF   ('&OPT(7)' NE 'AU').NOAU                                 01120000
&AU      SETC  '1'                                                      01130000
.NOAU    AIF   ('&OPT(8)' NE 'RS').NORS                                 01140000
&RS      SETC  '1'                                                      01150000
.NORS    ANOP                                                           01160000
         LA    RPARM,&PARAM           LOAD PARM LIST ADDRESS            01170000
         MVI   NOPNFL(RPARM),B'&RS&AU&LM&LI&NB&LB&LC&SX' SET FLAG BITS  01180000
         AGO   .ELOAD                                                   01190000
.NOOPN   AIF   ('&TYPE' NE 'HEADER').NOHEAD                             01200000
.**************                                                         01210000
.*                                                                      01220000
.*        NIPWTO  MESSAGE  HEADER                                       01230000
.*                                                                      01240000
.**************                                                         01250000
         DC    Y(&MSGEND-&MSGST)      MESSAGE LENGTH                    01260000
         AIF   ('&OPT(1)' NE 'NHC').NONHC                               01270000
         AIF   ('&OPT(2)' NE 'NBC').NONBC1                              01280000
         DC    X'C0'                  FLAG BYTE 1                       01290000
         AGO   .HEADB2                                                  01300000
.NONBC1  DC    X'80'                  FLAG BYTE 1                       01310000
         AGO   .HEADB2                                                  01320000
.NONHC   AIF ('&OPT(2)' NE 'NBC').NONBC2                                01330000
         DC    X'40'                 FLAG BYTE 1                        01340000
         AGO   .HEADB2                                                  01350000
.NONBC2  DC    X'00'                 FLAG BYTE 1                        01360000
.HEADB2  DC    X'00'                 FLAG BYTE 2                        01370000
         AGO   .MACEND                                                  01380000
.NOHEAD  AIF   ('&TYPE' NE 'PLIST').NOLIST                              01390000
.**************                                                         01400000
.*                                                                      01410000
.*        NIPWTOR  PARAMETER  LIST                                      01420000
.*                                                                      01430000
.**************                                                         01440000
         AIF   ('&RMSGST' EQ 'SQARBUF').ZERRPA                          01450000
         DC    A(&RMSGST)             REPLY AREA ADDRESS                01460000
         DC    A(0)                   REPLY ECB ADDRESS                 01470000
         DC    H'&RMSGL'              REPLY AREA LENGTH                 01480000
         AIF   ('&ASYNCH' EQ 'YES').ASYN1                               01490000
         DC    XL1'00'                NIP WTOR FLAGS                    01500000
         AGO   .PARM1                                                   01510000
.ASYN1   DC    XL1'80'                NIP WTOR FLAGS                    01520000
         AGO   .PARM1                                                   01530000
.ZERRPA  DC    A(0)                   REPLY AREA ADDRESS                01540000
         DC    A(0)                   REPLY ECB ADDRESS                 01550000
         DC    H'0'                   REPLY AREA LENGTH                 01560000
         AIF   ('&ASYNCH' EQ 'YES').ASYN2                               01570000
         DC    XL1'08'                NIP WTOR FLAGS                    01580000
         AGO   .PARM1                                                   01590000
.ASYN2   DC    XL1'88'                NIP WTOR FLAGS                    01600000
.PARM1   DC    XL1'00'                RESERVED                          01610000
         DC    A(&MSGST)              WTOR MESSAGE ADDRESS              01620000
         AGO   .MACEND                                                  01630000
.********************                                                   01640000
.*                                                                      01650000
.*            NIPSCHED PARAMETER LIST                                   01660000
.*                                                                      01670000
.**********************                                                 01680000
.NOLIST  AIF   ('&TYPE' NE 'SCHEDL').NOSCHDL                            01690000
         AIF   (K'&ADDR EQ 0).SCHDL1                                    01700000
         DC    A(&ADDR)                                                 01710000
         AGO   .SCHDL2                                                  01720000
.SCHDL1  DC    A(0)                                                     01730000
.SCHDL2  AIF   (K'&PARAM EQ 0).SCHDL3                                   01740000
         DC     A(&PARAM)                                               01750000
         AGO    .SCHDL4                                                 01760000
.SCHDL3  DC     A(0)                                                    01770000
.SCHDL4  DC     XL2'0000'                                               01780000
         AGO   .MACEND                                                  01790000
.********************                                                   01800000
.*                                                                      01810000
.*       LINKAGE FOR THE NIPSCHED  ROUTINE                              01820000
.*                                                                      01830000
.*********************                                                  01840000
.NOSCHDL AIF   ('&TYPE' NE 'SCHED').NOSCHED                             01850000
         LA    RPARM,&PARAM                                             01860000
         MVC   8(2,RPARM),0(&CPUID)                                     01870000
         AIF   (K'&ADDR EQ 0).ELOAD                                     01880000
         ST    &ADDR,0(0,RPARM)                                @YM1995P 01890000
         AGO   .ELOAD                                                   01900000
.NOSCHED AIF   ('&TYPE' NE 'PRMPT').NOPRMPT                             01910000
.*******************************************                            01920000
.*                                                                      01930000
.*      LINKAGE FOR THE NIPPRMPT ROUTINE                                01940000
.*                                                                      01950000
.******************************************                             01960000
         LA     RPARM,&PARAM       ADDRESS OF PARAMETER FOR PROMPT      01970000
         AIF   ('&OPT' NE 'ERROR').PRMPT1                               01980000
         LCR   RPARM,RPARM         COMPLEMENT PARAM REGISTER (ERROR)    01990000
.PRMPT1  AGO   .ELOAD                                                   02000000
.**************                                                         02010000
.*                                                                      02020000
.*        LINKAGE  FOR:  NIPSENSE, NIPSWAIT,NIPTIME,NIPUCBFN,           02030000
.*                       NIPWTO, NIPWTOR, NIPWTOR2                      02040000
.*                       NIPOPIO,NIPVIRT,NIPREAL,NIPPRMPT               02050000
.*                                                                      02060000
.**************                                                         02070000
.NOPRMPT AIF   ('&TYPE' EQ 'SENSE').PLOAD                               02080000
         AIF   ('&TYPE' EQ 'SWAIT').ELOAD                               02090000
         AIF   ('&TYPE' EQ 'OPIO').ELOAD                                02100000
         AIF   ('&TYPE' EQ 'VIRT').ELOAD                                02110000
         AIF   ('&TYPE' EQ 'REAL').ELOAD                                02120000
         AIF   ('&TYPE' NE 'TIME').NTIME                                02130000
         AIF   ('&PARAM' NE 'DEC').BTIME                                02140000
         SR    RPARM,RPARM            REQUEST DECIMAL TIME              02150000
         AGO   .ELOAD                                                   02160000
.BTIME   LA    RPARM,4(0,0)           REQUEST BINARY TIME      @YM1995P 02170000
         AGO   .ELOAD                                                   02180000
.NTIME   AIF   ('&TYPE' EQ 'UCBFN').PLOAD                               02190000
         AIF   ('&TYPE' EQ 'WTOR2').WTOR2                               02200000
         LA    RPARM,&PARAM           LOAD PARM REGISTER                02210000
         AGO   .ELOAD                                                   02220000
.WTOR2   AIF   ('&BUFREL' NE 'YES').PLOAD                               02230000
         LCR   RPARM,&PARAM           INDICATE SQA RELEASE              02240000
         AGO   .ELOAD                                                   02250000
.PLOAD   AIF   ('&PARAM' EQ 'RPARM').ELOAD                              02260000
         LR    RPARM,&PARAM           LOAD PARM REGISTER                02270000
.ELOAD   AIF   ('&MOD' EQ 'NIPM').ELOAD1                                02280000
         L     RENTRY,NVT&TYPE.(0,RNVT)   LOAD BRANCH ADDRESS  @YM1995P 02290000
         BALR  REXIT,RENTRY               CALL THE ROUTINE              02300000
         AGO   .MACEND                                                  02310000
.ELOAD1  ANOP                                                           02320000
         L     RENTRY,NVT&TYPE        LOAD BRANCH ADDRESS               02330000
         BALR  REXIT,RENTRY           BRANCH TO ROUTINE                 02340000
.MACEND  ANOP                                                           02350000
         MEND  ,                      */                                02360000
++ SRC      (IEAVNPF1) DISTLIB(ASAMPLIB) SYSLIB(SAMPLIB ).
*----------------------------------------------------------------*
*        Generate DSECTs to map NIP Parameter Area and           *
*        Parameter Table.                                        *
*----------------------------------------------------------------*
         IEAPPNIP DSECT=YES
         EJECT ,
IEAVNPF1 CSECT ,
* 2003/04/09 @kl NIP RIM to process user-defined system parameters.
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
RNVT     EQU   2
RCVT     EQU   3
REXIT    EQU   14
RENTRY   EQU   15
RPARM    EQU   1
NVTWTO   EQU   252
NVTPRMPT EQU   272
NVTPTAB  EQU   372
         EJECT
***********************************************************************
*                                                                     *
*        PROGRAM INITIALIZATION.                                      *
*                                                                     *
***********************************************************************
         SPACE 1
         PRINT GEN
INIT     DS    0H                  INITIALIZATION
         USING INIT,R15            SET ENTRY ADDRESSABILITY
         B     PASTID              BRANCH AROUND ID
         DC    AL1(IDLEN)
ID       DC    C'IEAVNPF1 &SYSDATE &SYSTIME $D00'
IDLEN    EQU   *-ID
PASTID   DS    0H                  HERE TO BRANCH ROUND ID
         DROP  R15                 END TEMPORARY ADDRESSABILITY
         STM   R14,R12,12(R13)     SAVE CALLER'S REGISTERS
         LR    R12,R15             SET BASE REGISTER
         USING IEAVNPF1,R12        ADDRESSABILITY FOR PROGRAM
         LR    R15,R13             SAVE CALLER'S SAVE AREA ADDRESS
         LA    R13,SAVEA           POINT TO OUR SAVE AREA
         ST    R15,SAVEA+4         CHAIN
         ST    R13,8(,R15)          SAVE AREAS
         EJECT ,
         ST    R2,ANVT             SAVE ADDRESS OF NVT
         SPACE 1
*----------------------------------------------------------------*
*        SEE IF WE HAVE A "PRISUB=" PARM AND EXIT IF NOT.        *
*----------------------------------------------------------------*
LOOP     DS    0H
         L     R15,ANVT            GET ADDRESS OF PARMTAB
         L     R15,NVTPTAB(,R15)    IN R15
         USING PARMTAB,R15         ADDRESSABILITY FOR PARMTAB
         ICM   R7,15,PRISUB        GET ADDRESS OF PRISUB= PARM
         BZ    RETURN              BRANCH IF NO PARM
         DROP  R15                 END PARMTAB ADDRESSABILITY
         SPACE 1
*----------------------------------------------------------------*
*        WE HAVE A "PRISUB=" PARM.  VERIFY THAT IT IS            *
*        VALID AND FIND THE END.                                 *
*----------------------------------------------------------------*
         LA    R1,5(,R7)           INITIALIZE END POINTER
         XR    R2,R2               CLEAR REGISTER FOR TRT
         TRT   0(5,R7),TRTTAB      VALIDATE THE PARM
         CL    R2,=F'1'            FIND A QUOTE?
         BNE   PROMPT              GO PROMPT FOR INPUT IF NOT
         SR    R1,R7               ELSE CALCULATE LENGTH
         BCTR  R1,0                 AND DECREMENT FOR EX
         EX    R1,MVCSUBN          MOVE PARM TO MESSAGE
         L     R15,CVTPTR          GET CVT ADDRESS
         USING CVT,R15             ADDRESSABILITY FOR CVT
         L     R15,CVTJESCT        GET ADDRESS OF JESCT
         USING JESCT,R15           ADDRESSABILITY FOR JESCT
         MVC   JESPJESN,=CL4' '    BLANK JESPJESN
         EX    R1,MVCSUBN2         MOVE PARM TO JESCT
         B     ISSMSG              GO ISSUE THE MESSAGE
MVCSUBN  MVC   M01SUBN(*-*),0(R7)  ** EXECUTED
MVCSUBN2 MVC   JESPJESN(*-*),0(R7) ** EXECUTED
         DROP  R15                 END JESCT ADDRESSABILITY
         SPACE 1
*----------------------------------------------------------------*
*        AN ERROR HAS OCCURRED.  INSULT THE OPERATOR             *
*        AND DEMAND ANOTHER REPLY.                               *
*----------------------------------------------------------------*
KPRISUB  DC    CL8'PRISUB'         TEXT FOR PROMPT
PROMPT   DS    0H                  BAD PARM, PROMPT FOR ANOTHER
         L     R2,ANVT             RESTORE NVT ADDRESS TO R2
         IEAPMNIP TYPE=WTO,PARAM=MSG321
         L     R2,ANVT             RESTORE NVT ADDRESS TO R2
         IEAPMNIP TYPE=PRMPT,PARAM=KPRISUB,OPT=ERROR
         B     LOOP                TRY AGAIN
         SPACE 1
*----------------------------------------------------------------*
*        DISPLAY THE RESULTS.                                    *
*----------------------------------------------------------------*
ISSMSG   DS    0H                  DISPLAY RESULTS
         L     R2,ANVT             RESTORE NVT ADDRESS TO R2
         IEAPMNIP TYPE=WTO,PARAM=MSG001
         SPACE 1
*----------------------------------------------------------------*
*        RESTORE CALLER'S REGISTERS AND RETURN.                  *
*----------------------------------------------------------------*
RETURN   DS    0H                  BACK TO RADIO CENTRAL
         L     R13,SAVEA+4         RESTORE CALLER'S SAVE AREA ADDRESS
         LM    R14,R12,12(R13)     RESTORE CALLER'S REGISTERS
         XR    R15,R15             SET ZERO RETURN CODE
         BR    R14                 RETURN TO CALLER
         EJECT ,
TRTTAB   DS    CL256
         ORG   TRTTAB
@NM00122 DC    77X'04'             ERRORS
@NM00123 DC    X'03'               LEFT PARENTHESIS
@NM00124 DC    13X'04'             ERRORS
@NM00125 DC    X'00'               DOLLAR SIGN
@NM00126 DC    X'04'               ERROR
@NM00127 DC    X'08'               RIGHT PARENTHESIS
@NM00128 DC    13X'04'             ERRORS
@NM00129 DC    X'05'               COMMA
@NM00130 DC    15X'04'             ERRORS
@NM00131 DC    1X'00'              POUND SIGN
         DC    1X'00'              AT SIGN
@NM00132 DC    X'01'               SINGLE QUOTE
@NM00133 DC    3X'04'              ERRORS
@NM00134 DC    9X'00'              LOWERCASE A-I
@NM00135 DC    7X'04'              ERRORS
@NM00136 DC    9X'00'              LOWERCASE J-R
@NM00137 DC    8X'04'              ERRORS
@NM00138 DC    8X'00'              LOWERCASE S-Z
@NM00139 DC    22X'04'             ERRORS
         DS    1XL1
@NM00140 DC    9X'00'              UPPERCASE A-I
@NM00141 DC    7X'04'              ERRORS
@NM00142 DC    9X'00'              UPPERCASE J-R
@NM00143 DC    8X'04'              ERRORS
@NM00144 DC    8X'00'              UPPERCASE S-Z
@NM00145 DC    6X'04'              ERRORS
@NM00146 DC    10X'00'             NUMERICS
@NM00147 DC    6X'04'              ERRORS
         ORG   TRTTAB+256
TRTTAB2  DS    0X
         DC    77X'04'             ERRORS
         DC    X'03'               LEFT PARENTHESIS
         DC    13X'04'             ERRORS
         DC    X'00'               DOLLAR SIGN
         DC    X'04'               ERROR
         DC    X'08'               RIGHT PARENTHESIS
         DC    13X'04'             ERRORS
         DC    X'05'               COMMA
         DC    15X'04'             ERRORS
         DC    1X'00'              POUND SIGN
         DC    1X'00'              AT SIGN
         DC    X'01'               SINGLE QUOTE
         DC    3X'04'              ERRORS
         DC    9X'00'              LOWERCASE A-I
         DC    7X'04'              ERRORS
         DC    9X'00'              LOWERCASE J-R
         DC    8X'04'              ERRORS
         DC    8X'00'              LOWERCASE S-Z
         DC    22X'04'             ERRORS
         DS    1XL1
         DC    9X'00'              UPPERCASE A-I
         DC    7X'04'              ERRORS
         DC    9X'00'              UPPERCASE J-R
         DC    8X'04'              ERRORS
         DC    8X'00'              UPPERCASE S-Z
         DC    6X'04'              ERRORS
         DC    10X'00'             NUMERICS
         DC    6X'04'              ERRORS
L2       EQU   *-TRTTAB2
         EJECT ,
*----------------------------------------------------------------*
*        CONSTANTS AND WORK AREAS.                               *
*----------------------------------------------------------------*
SAVEA    DS    18F                 PROGRAM SAVE AREA
ANVT     DS    A(*)                ADDRESS OF NVT
         SPACE 1
*----------------------------------------------------------------*
*        MESSAGES.                                               *
*----------------------------------------------------------------*
MSG001   DS     0F
         IEAPMNIP TYPE=HEADER,MSGST=MSG001,MSGEND=M01END
         DC     C'IEA370I PRIMARY SUBSYSTEM SELECTED IS '
M01SUBN  DC     C'     '
M01END   EQU    *
         SPACE 1
MSG321   DS     0F
         IEAPMNIP TYPE=HEADER,MSGST=MSG321,MSGEND=M321END
         DC     C'IEA321I INVALID PARAMETER SYNTAX - PRISUB'
M321END  EQU    *
**       DC     C'IEA322A INVALID PRISUB PARM - RESPECIFY OR CANCEL'
         EJECT ,
*----------------------------------------------------------------*
*        MAP OS COMMUNICATIONS VECTOR TABLE (CVT).               *
*----------------------------------------------------------------*
         CVT   DSECT=YES,LIST=NO
         SPACE 1
*----------------------------------------------------------------*
*        MAP JOB ENTRY SUBSYSTEM COMMUNICATION TABLE (JESCT).    *
*----------------------------------------------------------------*
         IEFJESCT ,
         END   ,
++ SRC      (IEAVNIPM) DISTLIB(ASAMPLIB) SYSLIB(SAMPLIB ).
         TITLE 'IEAVNIPM - NIP CONTROL/SERVICE ROUTINES                *00001000
                        '                                               00002000
****************************************************************** @L01 00002020
*                                                                * @L01 00002040
*                                                                * @L01 00002060
* Module name          =  IEAVNIPM                               * @L01 00002080
*                                                                * @L01 00002100
*                                                                * @L01 00002120
* Change activity      =                                         * @L01 00002140
*                                                                * @L01 00002150
*   Flag  Date        By    Description                          * @L01 00002160
*   ----  ----------  ----  ------------------------------------ * @L01 00002200
*   $L01  2005/02/17  KL    Add user-defined RIM IEAVNPF1 to     * @L01 00002220
*                           list of NIP RIM processors.          * @L01 00002240
*                                                                * @L01 00002250
****************************************************************** @L01 00002260
         SPACE 1                                                   @L01 00002300
         MACRO                                                          00003000
         NIPMENTR   &SAVE,&LABEL                                        00004000
         BALR  RENTRY,0                                                 00005000
         BCTR  RENTRY,0                                                 00006000
         BCTR  RENTRY,0                                                 00007000
         STM   RNVT,RPARM,&SAVE-&LABEL.(RENTRY)  SAVE REGISTERS         00008000
         LM    RBASE,RBASE2,NVTNIPM-NVT(RNVT)                           00009000
         MEND                                                           00010000
IEAVNIPM CSECT ,                                                   0006 00011000
@MAINENT DS    0H                                                  0006 00012000
         USING *,@15                                               0006 00013000
         B     @PROLOG                                             0006 00014000
         DC    AL2(@EP00006-@MAINENT)                                   00015000
         DC    AL1(16)                                             0006 00016000
         DC    C'IEAVNIPM  77.111'                                 0006 00017000
NIPXCDIC DS    0H                                                  0006 00018000
         USING *,@15                                               0006 00019000
         B     @PROLOG                                             0006 00020000
         DC    AL2(@EP00604-NIPXCDIC)                                   00021000
         ENTRY NIPXCDIC                                                 00022000
NIPEBCDX DS    0H                                                  0006 00023000
         USING *,@15                                               0006 00024000
         B     @PROLOG                                             0006 00025000
         DC    AL2(@EP00612-NIPEBCDX)                                   00026000
         ENTRY NIPEBCDX                                                 00027000
         DROP  @15                                                      00028000
@PROLOG  BALR  @10,0                                               0006 00029000
@PSTART  LA    @11,4095(,@10)                                      0006 00030000
         LA    @12,4095(,@11)                                      0006 00031000
         USING @PSTART,@10                                         0006 00032000
         USING @PSTART+4095,@11                                    0006 00033000
         USING @PSTART+8190,@12                                    0006 00034000
         AH    @15,4(,@15)                                         0006 00035000
         BR    @15                                                 0006 00036000
@EP00006 DS    0H                                                  0007 00037000
RBPRFXLN EQU 64                                                         00038000
RBPRFLNA EQU 32                                                         00039000
PRBLEN   EQU 136                                                        00040000
SIRBLEN  EQU 200                                                        00041000
TIRBLEN  EQU 136                                                        00042000
IRBLEN   EQU 128                                                        00043000
SVRBLEN  EQU 224                                                        00044000
         LA   RSAVE,NIPSAVE                                             00045000
         STM  RBASE,RBASE2,NVTNIPM                                      00046000
*   NVTFTCHA=REG5;                  /*                       @ZM00857*/ 00047000
*                                                                  0420 00048000
         ST    REG5,NVTFTCHA                                       0420 00049000
*   /*****************************************************************/ 00050000
*   /*                                                               */ 00051000
*   /* MOVE INITIAL NVT FROM NIP0 TO IEAVNIPM                        */ 00052000
*   /*                                                               */ 00053000
*   /*****************************************************************/ 00054000
*                                                                  0421 00055000
*/*                                                           YM2448 */ 00056000
*                                                                  0421 00057000
*   N=ADDR(NVTIX)-ADDR(NVT)+1;      /* COMPUTE INVT LENGTH           */ 00058000
         LA    @05,232                                             0421 00059000
         ST    @05,N                                               0421 00060000
*   NVT(1:N)=INVT(1:N);             /* MOVE INVT DATA TO NVT         */ 00061000
         BCTR  @05,0                                               0422 00062000
         EX    @05,@SM05051                                        0422 00063000
*   RNVT=ADDR(NVT);                 /* SET POINTER TO NVT            */ 00064000
*                                                                  0423 00065000
         LA    RNVT,NVT                                            0423 00066000
*   /*****************************************************************/ 00067000
*   /*                                                               */ 00068000
*   /* MOVE SYS1.NUC DEB EXTENT AND SYSTEM APPENDAGE TABLE ADDR TO   */ 00069000
*   /* NIPM                                                          */ 00070000
*   /*                                                               */ 00071000
*   /*****************************************************************/ 00072000
*                                                                  0424 00073000
*   RPARM=RPARM->DCBDEBAD;          /* LOAD SYS1.NUC DEB ADDRESS     */ 00074000
         L     @05,DCBDEBAD-1(,RPARM)                              0424 00075000
         LA    @05,0(,@05)                                         0424 00076000
         LR    RPARM,@05                                           0424 00077000
*   RNIPM=ADDR(NIPDEBSN);           /* LOAD PTR TO NIPM DEB          */ 00078000
         LA    RNIPM,NIPDEBSN                                      0425 00079000
*   RNIPM->DEBAPPAD=RPARM->DEBAPPAD;/* MOVE APPENDAGE ADDR           */ 00080000
         L     @05,DEBAPPAD(,RPARM)                                0426 00081000
         ST    @05,DEBAPPAD(,RNIPM)                                0426 00082000
*   RNIPM->DEBAPFIN='1'B;           /* SET APF FLAG                  */ 00083000
         OI    DEBAPFIN(RNIPM),B'00000010'                         0427 00084000
*   RESPECIFY                                                      0428 00085000
*     DEBBASIC BASED(RPARM);        /* POINT TO NIP0 DEB             */ 00086000
*   RPARM=ADDR(DEBBASND);           /* ADDRESS OF NIP0 DEB EXTENT    */ 00087000
         LA    @05,DEBBASND(,RPARM)                                0429 00088000
         LR    RPARM,@05                                           0429 00089000
*   RESPECIFY                                                      0430 00090000
*     DEBBASIC BASED(RNIPM);        /* POINT TO NIPM DEB             */ 00091000
*   RNIPM=ADDR(DEBBASND);           /* ADDRESS OF NIPM DEB EXTENT    */ 00092000
         LA    @05,DEBBASND(,RNIPM)                                0431 00093000
         LR    RNIPM,@05                                           0431 00094000
*   RNIPM->DEBDASD=RPARM->DEBDASD;  /* MOVE DEB EXTENT               */ 00095000
*                                                                  0432 00096000
         MVC   DEBDASD(16,RNIPM),DEBDASD(RPARM)                    0432 00097000
*   /*****************************************************************/ 00098000
*   /*                                                               */ 00099000
*   /* CALCULATE THE SIZE OF THE LOGREC RECORD FOR SYSTEM TERMINATION*/ 00100000
*   /* PROCESSING, AND ALLOCATE SPACE IN THE TOP OF THE NUCLEUS      */ 00101000
*   /* BUFFER FOR IT. THIS RECORD IS USED BY THE NIPSWAIT ROUTINE TO */ 00102000
*   /* PASS INFORMATION TO THE RMS SYSTEM TERMINATION ROUTINE WHEN   */ 00103000
*   /* TERMINATING THE IPL.                                          */ 00104000
*   /*                                                               */ 00105000
*   /*****************************************************************/ 00106000
*                                                                  0433 00107000
*   NVTNBFND=(NVTNBFND-(LENGTH(LRB)+LENGTH(LRBTTER)))7&&7;        0433 00108000
         LA    @05,7                                               0433 00109000
         LA    @15,32                                              0433 00110000
         L     @00,NVTNBFND                                        0433 00111000
         SLR   @00,@15                                             0433 00112000
         OR    @00,@05                                             0433 00113000
         XR    @00,@05                                             0433 00114000
         ST    @00,NVTNBFND                                        0433 00115000
*   NVTNBFND->LRB=NVTNBFND->LRB&&NVTNBFND->LRB;/* SET TO 0'S         */ 00116000
         LR    @05,@00                                             0434 00117000
         XC    LRB(24,@05),LRB(@05)                                0434 00118000
*   NVTNBFND->LRBHTYPE=LRBHTER;     /* IDENTIFY RECORD AS SYS TER    */ 00119000
         LR    @05,@00                                             0435 00120000
         MVI   LRBHTYPE(@05),X'81'                                 0435 00121000
*   NVTNBFND->LRBTLNH=LENGTH(LRB)+LENGTH(LRBTTER);                 0436 00122000
*                                                                  0436 00123000
         LR    @05,@00                                             0436 00124000
         ST    @15,LRBTLNH(,@05)                                   0436 00125000
*   /*****************************************************************/ 00126000
*   /*                                                               */ 00127000
*   /* THE FOLLOWING CODE SETS THE MACHINE CHECK TRAPS FOR THE       */ 00128000
*   /* REMAINDER OF NIP PROCESSING. IT REPLACES THE MACHINE CHECK NEW*/ 00129000
*   /* PSW ADDRESS PORTION WITH A POINTER TO THE NIP MACHINE CHECK   */ 00130000
*   /* TRAP. IT SEARCHES FOR ALL CPUS THAT ARE ONLINE AND SETS THE   */ 00131000
*   /* TRAP FOR EACH CPU. THIS TRAP IS RESET AT THE END OF NIP       */ 00132000
*   /* PROCESSING BY IEAVNP06 (MCH RIM).                             */ 00133000
*   /*                                                               */ 00134000
*   /*****************************************************************/ 00135000
*                                                                  0437 00136000
*   DO I=1 BY 1 TO 16;              /* SEARCH FOR ONLINE CPUS        */ 00137000
         LA    @05,1                                               0437 00138000
         ST    @05,I                                               0437 00139000
@DL00437 DS    0H                                                  0438 00140000
*     RNIPM=PCCAT00P(I);            /* ADDRESS OF PCCA               */ 00141000
         SLA   @05,2                                               0438 00142000
         L     @15,CVTPTR                                          0438 00143000
         L     @15,CVTPCCAT(,@15)                                  0438 00144000
         AL    @15,@CF05054                                        0438 00145000
         L     RNIPM,PCCAT00P(@05,@15)                             0438 00146000
*     IF RNIPM^=0                   /* IS THIS CPU ONLINE?           */ 00147000
*       THEN                        /* IF SO, SET THE MCH TRAP       */ 00148000
         LTR   RNIPM,RNIPM                                         0439 00149000
         BZ    @RF00439                                            0439 00150000
*       ADDR(RNIPM->PCCAPSAV->FLCMNPSW)->NPMCADDR=ADDR(NPMMCTRP);  0440 00151000
         L     @05,PCCAPSAV(,RNIPM)                                0440 00152000
         LA    @00,NPMMCTRP                                        0440 00153000
         ST    @00,NPMCADDR+112(,@05)                              0440 00154000
*     ELSE                                                         0441 00155000
*       ;                                                          0441 00156000
@RF00439 DS    0H                                                  0442 00157000
*   END;                                                           0442 00158000
         LA    @05,1                                               0442 00159000
         AL    @05,I                                               0442 00160000
         ST    @05,I                                               0442 00161000
         C     @05,@CF00081                                        0442 00162000
         BNH   @DL00437                                            0442 00163000
*   ADDR(FLCMNPSW)->NPMCADDR=ADDR(NPMMCTRP);/* TRAP THIS CPU         */ 00164000
*                                                                  0443 00165000
         LA    @05,112                                             0443 00166000
         LA    @00,NPMMCTRP                                        0443 00167000
         ST    @00,NPMCADDR(,@05)                                  0443 00168000
*   /*****************************************************************/ 00169000
*   /*                                                               */ 00170000
*   /* INITIALIZE MALFUNCTION ALERT ADDR TO POINT TO TRAP            */ 00171000
*   /*                                                               */ 00172000
*   /*****************************************************************/ 00173000
*                                                                  0444 00174000
*   NVTMFA->MFAADDR=ADDR(NPMMFA);                                  0444 00175000
*                                                                  0444 00176000
         LA    @05,NPMMFA                                          0444 00177000
         L     @15,NVTMFA                                          0444 00178000
         ST    @05,MFAADDR(,@15)                                   0444 00179000
*   /*****************************************************************/ 00180000
*   /*                                                               */ 00181000
*   /* SET TRAP FOR RTM1 BRANCH ENTRIES. IEAVNIP0 HAS ALREADY SAVED  */ 00182000
*   /* THE REAL RTM1 BRANCH TABLE ADDRESS IN THE NVT.                */ 00183000
*   /*                                                               */ 00184000
*   /*****************************************************************/ 00185000
*                                                                  0445 00186000
*   CVTBTERM=ADDR(NPRTMTAB);        /* SETUP RTM1 TRAP ROUTINE       */ 00187000
         L     @05,CVTPTR                                          0445 00188000
         LA    @00,NPRTMTAB                                        0445 00189000
         ST    @00,CVTBTERM(,@05)                                  0445 00190000
*   CVTBTERM->RTMBMACH=NVTRTMSA->RTMBMACH;/* OPEN M/C ENTRY          */ 00191000
*                                                                  0446 00192000
         L     @15,NVTRTMSA                                        0446 00193000
         L     @15,RTMBMACH(,@15)                                  0446 00194000
         LR    @14,@00                                             0446 00195000
         ST    @15,RTMBMACH(,@14)                                  0446 00196000
*   /*****************************************************************/ 00197000
*   /*                                                               */ 00198000
*   /* INITIALIZE XCTL AND TYPE 3 & 4 SVC TRAPS                      */ 00199000
*   /*                                                               */ 00200000
*   /*****************************************************************/ 00201000
*                                                                  0447 00202000
*   RNIPM=CVTABEND->SCVTSVCT;       /* LOAD ADDR OF SVC TABLE FROM 0447 00203000
*                                      SECONDARY CVT                 */ 00204000
*                                                                  0447 00205000
         L     @15,CVTABEND(,@05)                                  0447 00206000
         L     RNIPM,SCVTSVCT(,@15)                                0447 00207000
*   /*****************************************************************/ 00208000
*   /*                                                               */ 00209000
*   /* SAVE LOCATE SVC ENTRY IN NVT AND MOVE IN TRAP ENTRY           */ 00210000
*   /*                                                               */ 00211000
*   /*****************************************************************/ 00212000
*                                                                  0448 00213000
*   NVTLOCAT=NPLOCENT;              /* SAVE OLD ENTRY                */ 00214000
         MVC   NVTLOCAT(8),NPLOCENT(RNIPM)                         0448 00215000
*   NPLOCENT=LOCTRAP;               /* SET NIP LOCATE TRAP (SETS TO     00216000
*                                      TYPE 3 AND 4 SVC)             */ 00217000
         MVC   NPLOCENT(8,RNIPM),LOCTRAP                           0449 00218000
*   NVTXCTL=XCTLEP;                 /* SAVE XCTL ENTRY POINT IN NVT  */ 00219000
         MVC   NVTXCTL(8),XCTLEP(RNIPM)                            0450 00220000
*   XCTLADDR=ADDR(NIPSVC);          /* SET XCTL ENTRY TO ADDR OF   0451 00221000
*                                      NIPSVCX ROUTINE               */ 00222000
*                                                                  0451 00223000
         LA    @05,NIPSVC                                          0451 00224000
         STCM  @05,15,XCTLADDR(RNIPM)                              0451 00225000
*   /*****************************************************************/ 00226000
*   /*                                                               */ 00227000
*   /* FIND TYPE 3 AND 4 SVC'S IN TABLE AND SET ADDRESSES TO POINT TO*/ 00228000
*   /* NIPSVC ROUTINE                                                */ 00229000
*   /*                                                               */ 00230000
*   /*****************************************************************/ 00231000
*                                                                  0452 00232000
*   TOTCOUNT='0100'X;               /* GET TOTAL NUMBER OF IBM SVC   */ 00233000
         MVC   TOTCOUNT(2),@CH04814                                0452 00234000
*NPMSVC:                            /* SVC ENTRY TEST LOOP           */ 00235000
*                                                                  0453 00236000
*   /*****************************************************************/ 00237000
*   /*                                                               */ 00238000
*   /* HAVE ALL ENTRIES BEEN CHECKED ?                               */ 00239000
*   /*                                                               */ 00240000
*   /*****************************************************************/ 00241000
*                                                                  0453 00242000
*   IF TOTCOUNT^=0                  /* COUNT DECREMENTED TO ZERO?    */ 00243000
*     THEN                          /* NO - CONTINUE                 */ 00244000
NPMSVC   LH    @05,TOTCOUNT                                        0453 00245000
         LTR   @05,@05                                             0453 00246000
         BZ    @RF00453                                            0453 00247000
*     DO;                           /* CHECK SVC TYPE                */ 00248000
*                                                                  0454 00249000
*       /*************************************************************/ 00250000
*       /*                                                           */ 00251000
*       /* IS THIS A TYPE 3 OR 4                                     */ 00252000
*       /*                                                           */ 00253000
*       /*************************************************************/ 00254000
*                                                                  0455 00255000
*       IF SVCTYPE='1100'B          /* TYPE 3 OR 4 ?                 */ 00256000
*         THEN                      /* YES - SET TRAP                */ 00257000
         TM    SVCTYPE(RNIPM),B'11000000'                          0455 00258000
         BNO   @RF00455                                            0455 00259000
         TM    SVCTYPE(RNIPM),B'00110000'                          0455 00260000
         BNZ   @RF00455                                            0455 00261000
*         SVCAD=ADDR(NIPSVC);       /* POINT SVC TO NIPSVC ROUTINE   */ 00262000
         LA    @05,NIPSVC                                          0456 00263000
         ST    @05,SVCAD(,RNIPM)                                   0456 00264000
*       TOTCOUNT=TOTCOUNT-'0001'X;  /* DECREMENT COUNT               */ 00265000
@RF00455 LH    @05,TOTCOUNT                                        0457 00266000
         BCTR  @05,0                                               0457 00267000
         STH   @05,TOTCOUNT                                        0457 00268000
*       RNIPM=RNIPM+8;              /* POINT TO NEXT ENTRY           */ 00269000
         AL    RNIPM,@CF00125                                      0458 00270000
*       GO TO NPMSVC;               /* CONTINUE SEARCH               */ 00271000
         B     NPMSVC                                              0459 00272000
*     END;                                                         0460 00273000
*                                                                  0460 00274000
*   /*****************************************************************/ 00275000
*   /*                                                               */ 00276000
*   /* SET TRAP FOR UNEXPECTED ABEND REQUESTS                        */ 00277000
*   /*                                                               */ 00278000
*   /*****************************************************************/ 00279000
*                                                                  0461 00280000
*   RNIPM=CVTABEND->SCVTSVCT;       /* LOAD ADDRESS OF SVC TABLE FROM   00281000
*                                      SECONDARY CVT                 */ 00282000
@RF00453 L     @15,CVTPTR                                          0461 00283000
         L     @14,CVTABEND(,@15)                                  0461 00284000
         L     RNIPM,SCVTSVCT(,@14)                                0461 00285000
*   ABEND=ABENDAD;                  /* STORE TRAP IN SVC TABLE       */ 00286000
*                                                                  0462 00287000
         MVC   ABEND(8,RNIPM),ABENDAD                              0462 00288000
*   /*****************************************************************/ 00289000
*   /*                                                               */ 00290000
*   /* SET TRAP FOR SVC 60 (ESTAE) ENTRIES                           */ 00291000
*   /*                                                               */ 00292000
*   /*****************************************************************/ 00293000
*                                                                  0463 00294000
*   SVC60AD=ADDR(NPMSVC60);         /* SET SVC TABLE ENTRY           */ 00295000
         LA    @05,NPMSVC60                                        0463 00296000
         ST    @05,SVC60AD(,RNIPM)                                 0463 00297000
*   CVTSV60=ADDR(NPMSVC60);         /* SET CVT BRANCH ENTRY          */ 00298000
*                                                                  0464 00299000
         ST    @05,CVTSV60(,@15)                                   0464 00300000
*   /*****************************************************************/ 00301000
*   /*                                                               */ 00302000
*   /* SET TRAP FOR SQA EXPANSION REQUEST. REQUEST IS INVALID UNTIL  */ 00303000
*   /* THE PAGING SUPERVISIOR HAS BEEN INITIALIZED.                  */ 00304000
*   /*                                                               */ 00305000
*   /*****************************************************************/ 00306000
*                                                                  0465 00307000
*   NVTPQSAV=CVTPVTP->PVTPSQA;      /* SAVE PAGING SUPERVISOR'S    0465 00308000
*                                      GET-SQA-PAGE RTN IN NVT     0465 00309000
*                                      (ALREADY BACKED BY 2 SEGS)    */ 00310000
         L     @05,CVTPVTP(,@15)                                   0465 00311000
         L     @00,PVTPSQA(,@05)                                   0465 00312000
         ST    @00,NVTPQSAV                                        0465 00313000
*   CVTPVTP->PVTPSQA=ADDR(NIPSQEND);/* SET TRAP FOR SQA EXPANSION    */ 00314000
*                                                                  0466 00315000
         LA    @00,NIPSQEND                                        0466 00316000
         ST    @00,PVTPSQA(,@05)                                   0466 00317000
*   /*****************************************************************/ 00318000
*   /*                                                               */ 00319000
*   /* PRIME THE V=V AND V=R TCB PTRS WITH MASTERS ADDRESS           */ 00320000
*   /*                                                               */ 00321000
*   /*****************************************************************/ 00322000
*                                                                  0467 00323000
*   NVTVVTCB=NVTMSTCB;                                             0467 00324000
         L     @05,NVTMSTCB                                        0467 00325000
         ST    @05,NVTVVTCB                                        0467 00326000
*   NVTVRTCB=NVTMSTCB;                                             0468 00327000
*                                                                  0468 00328000
         ST    @05,NVTVRTCB                                        0468 00329000
*   /*****************************************************************/ 00330000
*   /*                                                               */ 00331000
*   /* GET TOD CLOCK VALUE FROM A GOOD CLOCK AND SAVE IN NVT         */ 00332000
*   /*                                                               */ 00333000
*   /*****************************************************************/ 00334000
*                                                                  0469 00335000
*   TOTCOUNT=0;                     /* INIT COUNT OF CPU'S SEARCHED     00336000
*                                      FOR GOOD CLOCK                */ 00337000
         SLR   @05,@05                                             0469 00338000
         STH   @05,TOTCOUNT                                        0469 00339000
*   NVTCPUAD=PSAPCCAV->PCCACPUA;    /* SAVE CPU ADDRESS IN NVT FOR 0470 00340000
*                                      NIPTIME                       */ 00341000
         L     @05,PSAPCCAV(,@05)                                  0470 00342000
         LH    @05,PCCACPUA(,@05)                                  0470 00343000
         STH   @05,NVTCPUAD                                        0470 00344000
*NPMTTIME:                                                         0471 00345000
*   GEN(IEAPMNIP TYPE=TIME,PARAM=DEC,MOD=NIPM);                    0471 00346000
NPMTTIME IEAPMNIP TYPE=TIME,PARAM=DEC,MOD=NIPM                          00347000
*   IF NVTFLNCK^='1'B               /* CLOCK INOPERATIVE FLAG ON?    */ 00348000
*     THEN                          /* IF NOT,                       */ 00349000
         TM    NVTFLNCK,B'00000100'                                0472 00350000
         BO    @RF00472                                            0472 00351000
*     NVTTOD=CONSTANT;              /* SAVE GOOD CLOCK VALUE.        */ 00352000
         L     @05,CONSTANT                                        0473 00353000
         ST    @05,NVTTOD                                          0473 00354000
*   ELSE                            /* IF CLOCK INOPERATIVE,         */ 00355000
*     IF NVTMP='1'B                 /* CHECK FOR MP.                 */ 00356000
*       THEN                        /* IF MP, SEARCH FOR A           */ 00357000
         B     @RC00472                                            0474 00358000
@RF00472 TM    NVTMP,B'00100000'                                   0474 00359000
         BNO   @RF00474                                            0474 00360000
*       DO;                         /* GOOD CLOCK ON ANOTHER CPU.    */ 00361000
*         IF TOTCOUNT=0             /* IS THIS FIRST CPU SRCHED      */ 00362000
*           THEN                    /* IF FIRST CPU,                 */ 00363000
         LH    @05,TOTCOUNT                                        0476 00364000
         LTR   @05,@05                                             0476 00365000
         BNZ   @RF00476                                            0476 00366000
*           IPLEDCPU=NVTCPUAD;      /* SAVE IPLED CPU ADDR           */ 00367000
         MVC   IPLEDCPU(2),NVTCPUAD                                0477 00368000
*NPMPFIND:                                                         0478 00369000
*         IF TOTCOUNT<'0010'X       /* ARE ALL CPU'S SEARCHED?       */ 00370000
*           THEN                    /* NO, CONTINUE SEARCH           */ 00371000
@RF00476 DS    0H                                                  0478 00372000
NPMPFIND LH    @05,TOTCOUNT                                        0478 00373000
         C     @05,@CF04822                                        0478 00374000
         BNL   @RF00478                                            0478 00375000
*           DO;                                                    0479 00376000
*                                                                  0479 00377000
*             /*******************************************************/ 00378000
*             /*                                                     */ 00379000
*             /* UPDATE PTR TO PCCA VECTOR TABLE ENTRY               */ 00380000
*             /*                                                     */ 00381000
*             /*******************************************************/ 00382000
*                                                                  0480 00383000
*             RNIPM=CVTPCCAT+(TOTCOUNT*4);                         0480 00384000
         LR    RNIPM,@05                                           0480 00385000
         SLA   RNIPM,2                                             0480 00386000
         L     @15,CVTPTR                                          0480 00387000
         AL    RNIPM,CVTPCCAT(,@15)                                0480 00388000
*             IF RNIPM->PCCAT00P(1)=0/* OFFLINE CPU                  */ 00389000
*               THEN                /* YES, GO TRY NEXT ONE          */ 00390000
         L     @00,PCCAT00P(,RNIPM)                                0481 00391000
         LTR   @00,@00                                             0481 00392000
         BNZ   @RF00481                                            0481 00393000
*               DO;                                                0482 00394000
*                 TOTCOUNT=TOTCOUNT+'0001'X;                       0483 00395000
         AL    @05,@CF04818                                        0483 00396000
         STH   @05,TOTCOUNT                                        0483 00397000
*                 GO TO NPMPFIND;                                  0484 00398000
         B     NPMPFIND                                            0484 00399000
*               END;                                               0485 00400000
*             ELSE                  /* NO, PICKUP CPU ADDR           */ 00401000
*               DO;                                                0486 00402000
@RF00481 DS    0H                                                  0487 00403000
*                 IF RNIPM->PCCAT00P(1)->PCCACPUA=IPLEDCPU THEN/* IF    00404000
*                                      IPLED CPU, SKIP TO NXT        */ 00405000
         L     @05,PCCAT00P(,RNIPM)                                0487 00406000
         CLC   PCCACPUA(2,@05),IPLEDCPU                            0487 00407000
         BNE   @RF00487                                            0487 00408000
*                   DO;                                            0488 00409000
*                     TOTCOUNT=TOTCOUNT+'0001'X;                   0489 00410000
         LA    @05,1                                               0489 00411000
         AH    @05,TOTCOUNT                                        0489 00412000
         STH   @05,TOTCOUNT                                        0489 00413000
*                     GO TO NPMPFIND;                              0490 00414000
         B     NPMPFIND                                            0490 00415000
*                   END;                                           0491 00416000
*                 ELSE              /* TRY THE NEW CPU               */ 00417000
*                   DO;                                            0492 00418000
@RF00487 DS    0H                                                  0493 00419000
*                     NVTCPUAD=RNIPM->PCCAT00P(1)->PCCACPUA;       0493 00420000
         L     @05,PCCAT00P(,RNIPM)                                0493 00421000
         LH    @05,PCCACPUA(,@05)                                  0493 00422000
         STH   @05,NVTCPUAD                                        0493 00423000
*                     TOTCOUNT=TOTCOUNT+'0001'X;                   0494 00424000
         LA    @05,1                                               0494 00425000
         AH    @05,TOTCOUNT                                        0494 00426000
         STH   @05,TOTCOUNT                                        0494 00427000
*                     NVTFLNCK='0'B;                               0495 00428000
         NI    NVTFLNCK,B'11111011'                                0495 00429000
*                     GO TO NPMTTIME;                              0496 00430000
         B     NPMTTIME                                            0496 00431000
*                   END;                                           0497 00432000
*               END;                                               0498 00433000
*           END;                                                   0499 00434000
*         ELSE                                                     0500 00435000
*           ;                                                      0500 00436000
@RF00478 DS    0H                                                  0501 00437000
*       END;                                                       0501 00438000
*     ELSE                                                         0502 00439000
*       ;                                                          0502 00440000
*                                                                  0502 00441000
@RF00474 DS    0H                                                  0503 00442000
*   /*****************************************************************/ 00443000
*   /*                                                               */ 00444000
*   /* GET STORAGE TO MOVE FETCH FROM NIP0 TO GETMAINED STORAGE FOR  */ 00445000
*   /* USE UNTIL NP05 HAS BUILT PLPA                                 */ 00446000
*   /*                                                               */ 00447000
*   /*****************************************************************/ 00448000
*                                                                  0503 00449000
*   REG5=NPFTCHE-NPFTCHB;           /* LENGTH OF STORAGE     @ZM00857*/ 00450000
@RC00472 L     @15,NVTFTCHA                                        0503 00451000
         L     REG5,NPFTCHE(,@15)                                  0503 00452000
         SL    REG5,NPFTCHB(,@15)                                  0503 00453000
*   GEN(GETMAIN R,LV=(5),SP=252);   /* GET STORAGE FOR FETCH @ZM00857*/ 00454000
         GETMAIN R,LV=(5),SP=252                                        00455000
*   FTCHSTRT=RPARM;                 /* SAVE START ADDRESS    @ZM00857*/ 00456000
*                                                                  0505 00457000
         ST    RPARM,FTCHSTRT                                      0505 00458000
*   /*****************************************************************/ 00459000
*   /*                                                               */ 00460000
*   /* SET UP TO MOVE FETCH TO NEW AREA                              */ 00461000
*   /*                                                               */ 00462000
*   /*****************************************************************/ 00463000
*                                                                  0506 00464000
*   RFY                                                            0506 00465000
*    (REG4,                                                        0506 00466000
*     REG5,                                                        0506 00467000
*     REG6,                                                        0506 00468000
*     REG7) RSTD;                                                  0506 00469000
*   REG4=FTCHSTRT;                  /* START OF NEW AREA     @ZM00857*/ 00470000
         L     @15,FTCHSTRT                                        0507 00471000
         LR    REG4,@15                                            0507 00472000
*   REG6=NPFTCHB;                   /* FROM ADDRESS          @ZM00857*/ 00473000
         L     @15,NVTFTCHA                                        0508 00474000
         L     @14,NPFTCHB(,@15)                                   0508 00475000
         LR    REG6,@14                                            0508 00476000
*   REG5=NPFTCHE-NPFTCHB;           /* LENGTH OF MOVE        @ZM00857*/ 00477000
         LCR   @14,@14                                             0509 00478000
         AL    @14,NPFTCHE(,@15)                                   0509 00479000
         LR    REG5,@14                                            0509 00480000
*   REG7=REG5;                      /* LENGTH OF MOVE        @ZM00857*/ 00481000
         LR    REG7,REG5                                           0510 00482000
*   GEN(MVCL REG4,REG6);            /* MOVE FETCH            @ZM00857*/ 00483000
*                                                                  0511 00484000
         MVCL REG4,REG6                                                 00485000
*   /*****************************************************************/ 00486000
*   /*                                                               */ 00487000
*   /* MOVE APPENDAGES TO NUC BUFFER                                 */ 00488000
*   /*                                                               */ 00489000
*   /*****************************************************************/ 00490000
*                                                                  0512 00491000
*   REG4=NVTNUCND;                  /* ADDRESS OF NUC BUFFER @ZM00857*/ 00492000
         L     REG4,NVTNUCND                                       0512 00493000
*   REG5=(NPFTCHT-NPFTCHA);         /* LENGTH OF TABLE       @ZM00857*/ 00494000
         L     @15,NVTFTCHA                                        0513 00495000
         L     @14,NPFTCHA(,@15)                                   0513 00496000
         L     REG5,NPFTCHT(,@15)                                  0513 00497000
         SLR   REG5,@14                                            0513 00498000
*   REG6=NPFTCHA;                   /* ADDRESS OF APPENDAGES @ZM00857*/ 00499000
         LR    REG6,@14                                            0514 00500000
*   REG7=REG5;                      /* LENGTH OF MOVE        @ZM00857*/ 00501000
         LR    REG7,REG5                                           0515 00502000
*   GEN(MVCL REG4,REG6);            /* MOVE APPENDAGES       @ZM00857*/ 00503000
         MVCL REG4,REG6                                                 00504000
*   RFY                                                            0517 00505000
*    (REG4,                                                        0517 00506000
*     REG5,                                                        0517 00507000
*     REG6,                                                        0517 00508000
*     REG7) UNRSTD;                                                0517 00509000
*   ADCONBAS=NVTNUCND;              /* ADDRESS OF ADCONS     @ZM00857*/ 00510000
         L     @05,NVTNUCND                                        0518 00511000
         ST    @05,ADCONBAS                                        0518 00512000
*   DO I=5 TO 1 BY-1;               /* LOOP TO UPDATE 5 ADCONS     0519 00513000
*                                                            @ZM00857*/ 00514000
         LA    @05,5                                               0519 00515000
         ST    @05,I                                               0519 00516000
@DL00519 DS    0H                                                  0520 00517000
*     FTCHADCN=FTCHADCN-(NPFTCHA-NVTNUCND);/* ADD NEW OFFSET @ZM00857*/ 00518000
         L     @15,ADCONBAS                                        0520 00519000
         L     @14,NVTFTCHA                                        0520 00520000
         L     @00,NPFTCHA(,@14)                                   0520 00521000
         SL    @00,NVTNUCND                                        0520 00522000
         LCR   @00,@00                                             0520 00523000
         AL    @00,FTCHADCN(,@15)                                  0520 00524000
         ST    @00,FTCHADCN(,@15)                                  0520 00525000
*     ADCONBAS=ADCONBAS+4;          /* INCREMENT TO NEXT ADCON     0521 00526000
*                                                            @ZM00857*/ 00527000
         AL    @15,@CF00109                                        0521 00528000
         ST    @15,ADCONBAS                                        0521 00529000
*   END;                                                           0522 00530000
*                                                                  0522 00531000
         BCTR  @05,0                                               0522 00532000
         ST    @05,I                                               0522 00533000
         LTR   @05,@05                                             0522 00534000
         BP    @DL00519                                            0522 00535000
*   /*****************************************************************/ 00536000
*   /*                                                               */ 00537000
*   /* UPDATE ADDRESS OF ADCON TABLE IN FETCH CSECT WHICH WAS MOVED  */ 00538000
*   /* TO NIP TRANSIENT AREA                                         */ 00539000
*   /*                                                               */ 00540000
*   /*****************************************************************/ 00541000
*                                                                  0523 00542000
*   ADCONBAS=FTCHSTRT+(NPFTCHA-NPFTCHB)-4;/* ADDR OF ADCON PTR     0523 00543000
*                                                            @ZM00857*/ 00544000
         L     @05,FTCHSTRT                                        0523 00545000
         L     @15,NVTFTCHA                                        0523 00546000
         L     @14,NPFTCHA(,@15)                                   0523 00547000
         LR    @00,@14                                             0523 00548000
         SL    @00,NPFTCHB(,@15)                                   0523 00549000
         ALR   @00,@05                                             0523 00550000
         SL    @00,@CF00109                                        0523 00551000
         ST    @00,ADCONBAS                                        0523 00552000
*   FTCHADCN=NVTNUCND;              /* POINT TO NEW LOCATION @ZM00857*/ 00553000
*                                                                  0524 00554000
         L     @09,NVTNUCND                                        0524 00555000
         LR    @08,@00                                             0524 00556000
         ST    @09,FTCHADCN(,@08)                                  0524 00557000
*   /*****************************************************************/ 00558000
*   /*                                                               */ 00559000
*   /* UPDATE NUC END ADDRESS                                        */ 00560000
*   /*                                                               */ 00561000
*   /*****************************************************************/ 00562000
*                                                                  0525 00563000
*   NVTNUCND=NVTNUCND+(NPFTCHT-NPFTCHA)+77&&7;/* ROUND UP   @ZM00857*/ 00564000
*                                                                  0525 00565000
         LA    @08,7                                               0525 00566000
         LCR   @14,@14                                             0525 00567000
         AL    @14,NPFTCHT(,@15)                                   0525 00568000
         ALR   @09,@14                                             0525 00569000
         ALR   @09,@08                                             0525 00570000
         OR    @09,@08                                             0525 00571000
         XR    @09,@08                                             0525 00572000
         ST    @09,NVTNUCND                                        0525 00573000
*   /*****************************************************************/ 00574000
*   /*                                                               */ 00575000
*   /* UPDATE CVT TO POINT TO NEW FETCH                              */ 00576000
*   /*                                                               */ 00577000
*   /*****************************************************************/ 00578000
*                                                                  0526 00579000
*   CVTFETCH=FTCHSTRT;              /* NEW LOCATION OF FETCH @ZM00857*/ 00580000
*                                                                  0526 00581000
         L     @15,CVTPTR                                          0526 00582000
         ST    @05,CVTFETCH(,@15)                                  0526 00583000
*   /*****************************************************************/ 00584000
*   /*                                                               */ 00585000
*   /* MOVE STORAGE MAP FROM NIP0 OVER TO GETMAINED AREA             */ 00586000
*   /*                                                               */ 00587000
*   /*****************************************************************/ 00588000
*                                                                  0527 00589000
*   GEN(  GETMAIN  R,LV=4096,SP=252);/* GETMAIN FOR STORAGE MAP TO BE   00590000
*                                      MOVED.                        */ 00591000
           GETMAIN  R,LV=4096,SP=252                                    00592000
*   DO I=0 BY 1 TO 15;              /* MOVE MAP TO NEW AREA          */ 00593000
         SLR   @05,@05                                             0528 00594000
         ST    @05,I                                               0528 00595000
@DL00528 DS    0H                                                  0529 00596000
*     RPARM->STORMAP(1+I*256:256+I*256)=NVTSTMAP->STORMAP(1+I*256:256+I 00597000
*         *256);                                                   0529 00598000
         LR    @15,@05                                             0529 00599000
         SLA   @15,8                                               0529 00600000
         ST    @15,@TF00001                                        0529 00601000
         ALR   @15,RPARM                                           0529 00602000
         L     @14,NVTSTMAP                                        0529 00603000
         AL    @14,@TF00001                                        0529 00604000
         MVC   STORMAP(256,@15),STORMAP(@14)                       0529 00605000
*   END;                                                           0530 00606000
         AL    @05,@CF00144                                        0530 00607000
         ST    @05,I                                               0530 00608000
         C     @05,@CF00122                                        0530 00609000
         BNH   @DL00528                                            0530 00610000
*   NVTSTMAP=RPARM;                 /* UPDATE NVT POINTER TO MAP     */ 00611000
         ST    RPARM,NVTSTMAP                                      0531 00612000
*   IF NVTSGPSA^=0                  /* SEE IF PSA WAS SAVED          */ 00613000
*     THEN                          /* IF SO, MOVE IT TO NIP REGN    */ 00614000
         L     @05,NVTSGPSA                                        0532 00615000
         LTR   @05,@05                                             0532 00616000
         BZ    @RF00532                                            0532 00617000
*     DO;                                                          0533 00618000
*       GEN( GETMAIN R,LV=4096,SP=252);/* GETMAIN PSA AREA           */ 00619000
          GETMAIN R,LV=4096,SP=252                                      00620000
*       DO I=0 BY 1 TO 15;                                         0535 00621000
         SLR   @05,@05                                             0535 00622000
         ST    @05,I                                               0535 00623000
@DL00535 DS    0H                                                  0536 00624000
*         RPARM->NIPSGPSA(1+I*256:256+I*256)=NVTSGPSA->NIPSGPSA(1+I*256 00625000
*             :256+I*256);                                         0536 00626000
         LR    @15,@05                                             0536 00627000
         SLA   @15,8                                               0536 00628000
         ST    @15,@TF00001                                        0536 00629000
         ALR   @15,RPARM                                           0536 00630000
         L     @14,NVTSGPSA                                        0536 00631000
         AL    @14,@TF00001                                        0536 00632000
         MVC   NIPSGPSA(256,@15),NIPSGPSA(@14)                     0536 00633000
*       END;                                                       0537 00634000
         AL    @05,@CF00144                                        0537 00635000
         ST    @05,I                                               0537 00636000
         C     @05,@CF00122                                        0537 00637000
         BNH   @DL00535                                            0537 00638000
*       NVTSGPSA=RPARM;             /* SAVE NEW ADDRESS OF PSA MAP   */ 00639000
         ST    RPARM,NVTSGPSA                                      0538 00640000
*     END;                                                         0539 00641000
*   ELSE                                                           0540 00642000
*     ;                                                            0540 00643000
@RF00532 DS    0H                                                  0541 00644000
*                                                                  0541 00645000
*   /*****************************************************************/ 00646000
*   /*                                                               */ 00647000
*   /* LOAD, EXECUTE AND DELETE NIP PROCESSOR MODULES                */ 00648000
*   /*                                                               */ 00649000
*   /*****************************************************************/ 00650000
*                                                                  0541 00651000
*   SFXINDEX=1;                     /* INIT. SUFFIX LIST INDEX       */ 00652000
         MVC   SFXINDEX(4),@CF00144                                0541 00653000
*NPMNEXT:                           /* LOAD NEXT PROCESSOR           */ 00654000
*   SUFFIX=SUFXLIST(SFXINDEX);      /* OBTAIN PROCESSOR SUFFIX       */ 00655000
NPMNEXT  L     @05,SFXINDEX                                        0542 00656000
         ALR   @05,@05                                             0542 00657000
         LA    @15,SUFXLIST-2(@05)                                 0542 00658000
         MVC   SUFFIX(2),0(@15)                                    0542 00659000
*   RPARM=ADDR(NIPMNAME);           /* PLACE PROCESSOR NAME ADDR IN     00660000
*                                      PARAMETER REGISTER            */ 00661000
         LA    RPARM,NIPMNAME                                      0543 00662000
*NPMLOAD:                           /* CALL FIND-AND-LOAD PROCESSOR     00663000
*                                      MODULE ROUTINE                */ 00664000
*   CALL NIPLOAD;                   /* CALL LOAD ROUTINE             */ 00665000
NPMLOAD  BAL   @14,NIPLOAD                                         0544 00666000
*   GENERATE;                                                      0545 00667000
*                                                                  0545 00668000
*                                      /* GEN LINKAGE TO MODULE      */ 00669000
          LR    RENTRY,RPARM              LOAD BRANCH ADDRESS           00670000
          BALR  REXIT,RENTRY              BRANCH TO PROCESSOR           00671000
*   /*****************************************************************/ 00672000
*   /*                                                               */ 00673000
*   /* DELETE PROCESSOR ON ITS RETURN                                */ 00674000
*   /*                                                               */ 00675000
*   /*****************************************************************/ 00676000
*                                                                  0546 00677000
*   GEN( DELETE DE=NIPMNAME);       /* DELETE PROCESSOR MODULE       */ 00678000
*                                                                  0546 00679000
          DELETE DE=NIPMNAME                                            00680000
*   /*****************************************************************/ 00681000
*   /*                                                               */ 00682000
*   /* CHECK FOR SPECIAL CONDITIONS TO HANDLE IN SUBROUTINES         */ 00683000
*   /*                                                               */ 00684000
*   /*****************************************************************/ 00685000
*                                                                  0547 00686000
*   IF NVTPAREA^=0                  /* IF PARMAREA HAS BEEN CREATED     00687000
*                                      (SET UP BY IEAVNP03)          */ 00688000
*     THEN                                                         0547 00689000
         L     @05,NVTPAREA                                        0547 00690000
         LTR   @05,@05                                             0547 00691000
         BZ    @RF00547                                            0547 00692000
*     NVTPAREA->NIPPAFL1='0'B;      /* TURN OFF SPIO SPECIAL FLAG    */ 00693000
         NI    NIPPAFL1(@05),B'01111111'                           0548 00694000
*   SFXINDEX=SFXINDEX+1;            /* INCREMENT SUFFIX INDEX        */ 00695000
@RF00547 LA    @05,1                                               0549 00696000
         AL    @05,SFXINDEX                                        0549 00697000
         ST    @05,SFXINDEX                                        0549 00698000
*   IF SUFFIX='01'                  /* IF IEAVNPA1 WAS LAST MODULE   */ 00699000
*     THEN                          /* THEN INITIATE OPERATOR        */ 00700000
         CLC   SUFFIX(2),@CC04830                                  0550 00701000
         BNE   @RF00550                                            0550 00702000
*     CALL NIPOPIOC;                /* COMMUNICATION.                */ 00703000
         BAL   @14,NIPOPIOC                                        0551 00704000
*   IF SUFFIX='B2'                  /* IF IEAVNP01 WAS LAST MODULE   */ 00705000
*     THEN                          /* THEN OPEN SVCLIB AND LOGREC 0552 00706000
*                                      (PSEUDO OPEN - BUILDS PARTIAL    00707000
*                                      DEB)                          */ 00708000
@RF00550 CLC   SUFFIX(2),@CC04831                                  0552 00709000
         BNE   @RF00552                                            0552 00710000
*     CALL NPMOPLIB;                /* DATA SETS.                    */ 00711000
         BAL   @14,NPMOPLIB                                        0553 00712000
*/*                                                           YM01632*/ 00713000
*                                                                  0554 00714000
*   IF SUFFIX='03'                  /* IF LAST MODULE WAS IEAVNP03   */ 00715000
*     THEN                          /* THEN CHECK FOR CLPA AND       */ 00716000
@RF00552 CLC   SUFFIX(2),@CC04832                                  0554 00717000
         BNE   @RF00554                                            0554 00718000
*     DO;                           /* PARAMETERS.            YM01632*/ 00719000
*       IF NVTPTAB->CLPA=0          /* WAS CLPA SPECIFIED ?YM01632   */ 00720000
*         THEN                      /* IF SO, SET QS FLAG.    YM01632*/ 00721000
         L     @05,NVTPTAB                                         0556 00722000
         L     @05,CLPA(,@05)                                      0556 00723000
         LTR   @05,@05                                             0556 00724000
         BNZ   @RF00556                                            0556 00725000
*         NVTFLQS='1'B;             /* SET QS FLAG ON.        YM01632*/ 00726000
         OI    NVTFLQS,B'00001000'                                 0557 00727000
*       IF NVTPTAB->CVIO=0          /* WAS CVAM SPECIFIED     YM01632*/ 00728000
*         THEN                      /* IF SO SET WS FLAG      YM01632*/ 00729000
@RF00556 L     @05,NVTPTAB                                         0558 00730000
         L     @05,CVIO(,@05)                                      0558 00731000
         LTR   @05,@05                                             0558 00732000
         BNZ   @RF00558                                            0558 00733000
*         NVTFLWS='1'B;             /* SET WS FLAG ON.        YM01632*/ 00734000
         OI    NVTFLWS,B'00000100'                                 0559 00735000
*     END;                                                         0560 00736000
*                                                                  0560 00737000
@RF00558 DS    0H                                                  0561 00738000
*/*                                                           YM00138*/ 00739000
*                                                                  0561 00740000
*   IF SUFXLIST(SFXINDEX)='10'      /* IF IEAVNP10 IS NEXT   @Z40WPXA*/ 00741000
*     THEN                          /* THEN BUILD PFTES AND SETUP    */ 00742000
@RF00554 L     @05,SFXINDEX                                        0561 00743000
         ALR   @05,@05                                             0561 00744000
         LA    @15,SUFXLIST-2(@05)                                 0561 00745000
         CLC   0(2,@15),@CC04833                                   0561 00746000
         BNE   @RF00561                                            0561 00747000
*     CALL NPMPFTBL;                /* FOR PAGING.                   */ 00748000
         BAL   @14,NPMPFTBL                                        0562 00749000
*   IF SUFXLIST(SFXINDEX)='04' THEN /* IF NP04 IS NEXT       @Z40WPXA*/ 00750000
@RF00561 L     @05,SFXINDEX                                        0563 00751000
         ALR   @05,@05                                             0563 00752000
         LA    @15,SUFXLIST-2(@05)                                 0563 00753000
         CLC   0(2,@15),@CC04834                                   0563 00754000
         BNE   @RF00563                                            0563 00755000
*     CALL NPMPREP4;                /* GO LOAD ILRPREAD      @Z40WPXA*/ 00756000
         BAL   @14,NPMPREP4                                        0564 00757000
*   IF SUFXLIST(SFXINDEX)='A8'      /* IF NEXT MODULE IS IEAVNPA8    */ 00758000
*     THEN                          /* THEN SETUP FOR SQA ANALYSIS   */ 00759000
@RF00563 L     @05,SFXINDEX                                        0565 00760000
         ALR   @05,@05                                             0565 00761000
         LA    @15,SUFXLIST-2(@05)                                 0565 00762000
         CLC   0(2,@15),@CC04836                                   0565 00763000
         BNE   @RF00565                                            0565 00764000
*     CALL NPMPREP8;                /* AND INITIALIZATION OF C.B.S   */ 00765000
         BAL   @14,NPMPREP8                                        0566 00766000
*   IF SUFXLIST(SFXINDEX)='05'      /* IF NEXT MODULE IS IEAVNP05    */ 00767000
*     THEN                          /* THEN SETUP FOR QUICK START    */ 00768000
@RF00565 L     @05,SFXINDEX                                        0567 00769000
         ALR   @05,@05                                             0567 00770000
         LA    @15,SUFXLIST-2(@05)                                 0567 00771000
         CLC   0(2,@15),@CC04837                                   0567 00772000
         BNE   @RF00567                                            0567 00773000
*     CALL NPMPREP5;                /* PROCESSING.                   */ 00774000
         BAL   @14,NPMPREP5                                        0568 00775000
*   IF SUFFIX='05'                  /* IF IEAVNP05 WAS LAST MODULE   */ 00776000
*     THEN                          /* THEN CLEANUP V=V REGION       */ 00777000
@RF00567 CLC   SUFFIX(2),@CC04837                                  0569 00778000
         BNE   @RF00569                                            0569 00779000
*     CALL NPMCLNUP;                /* AND FREE QUICK START RECORD   */ 00780000
         BAL   @14,NPMCLNUP                                        0570 00781000
*   IF SUFXLIST(SFXINDEX)='C8'      /* IF NEXT MODULE IS IEAVNPC8    */ 00782000
*     THEN                          /* THEN SETUP V=R VALUES FOR     */ 00783000
@RF00569 L     @05,SFXINDEX                                        0571 00784000
         ALR   @05,@05                                             0571 00785000
         LA    @15,SUFXLIST-2(@05)                                 0571 00786000
         CLC   0(2,@15),@CC04838                                   0571 00787000
         BNE   @RF00571                                            0571 00788000
*     CALL NPMVRREG;                /* IT TO PROCESS.                */ 00789000
         BAL   @14,NPMVRREG                                        0572 00790000
*   IF SUFXLIST(SFXINDEX)='XX'      /* IF NEXT MODULE IS IEAVNIPX    */ 00791000
*     THEN                          /* THEN PICK UP NAME OF NIPX     */ 00792000
@RF00571 L     @05,SFXINDEX                                        0573 00793000
         ALR   @05,@05                                             0573 00794000
         LA    @15,SUFXLIST-2(@05)                                 0573 00795000
         CLC   0(2,@15),@CC04839                                   0573 00796000
         BNE   @RF00573                                            0573 00797000
*     DO;                                                          0574 00798000
*       RPARM=ADDR(NIPXNAME);       /* ADDRESS OF NIPX               */ 00799000
         LA    RPARM,NIPXNAME                                      0575 00800000
*       GO TO NPMLOAD;              /* GO LOAD THE LAST MODULE       */ 00801000
         B     NPMLOAD                                             0576 00802000
*     END;                                                         0577 00803000
*   GO TO NPMNEXT;                  /* GO TO RETRIEVE NEXT SUFFIX    */ 00804000
         B     NPMNEXT                                             0578 00805000
*                                                                  0579 00806000
*   /*****************************************************************/ 00807000
*   /*                                                               */ 00808000
*   /* THIS ROUTINE TRAPS OUT SVC CALLS TO TYPE 3 AND 4        SVC'S.*/ 00809000
*   /* IF THE CALL IS TO THE SYSTEM LOCATE ROUTINE (SVC 26), IT LOADS*/ 00810000
*   /* THE LOCATE RIM (IEAVNP12) AND GIVES IT CONTROL TO DO THE      */ 00811000
*   /* LOCATE FUNCTION. IF THE CALL IS FOR ANY OTHER TYPE 3 OR 4 SVC,*/ 00812000
*   /* IT IS AN ERROR AND THE SYSTEM IS PLACED IN A DISABLED WAIT    */ 00813000
*   /* STATE. THIS TRAP IS REMOVED BY IEAVNP05 WHEN THE LPA HAS BEEN */ 00814000
*   /* CONSTRUCTED AND THE SVC ROUTINES RESIDING THERE ARE AVAILABLE.*/ 00815000
*   /* LOCATE TRAP AND ABEND TRAP NOT TAKEN OUT UNTIL NIPX.          */ 00816000
*   /*                                                               */ 00817000
*   /*****************************************************************/ 00818000
*                                                                  0579 00819000
*/*           RESTRICT REGISTERS FOR NIPSVC ROUTINE                  */ 00820000
*                                                                  0579 00821000
*   RESPECIFY                                                      0579 00822000
*    (RPARM,                        /* PARAMETER REGISTER            */ 00823000
*     RUCB,                         /* UCB POINTER                   */ 00824000
*     RBSECPTR,                     /* RB POINTER                    */ 00825000
*     ENTPT6) RESTRICTED;           /* ENTRY ADDRESS                 */ 00826000
*NIPSVC:                                                           0580 00827000
*   GENERATE REFS(SVCREGS,FLCCVT,RBLINK);                          0580 00828000
NIPSVC   DS    0H                                                  0580 00829000
          STM   RNVT,RPARM,SVCREGS-NIPSVC(ENTPT6)  SAVE REGISTERS       00830000
          LR    RBASE,ENTPT6                                            00831000
          LA    RBASE2,NIPSVC-@PSTART    FIND SUBROUTINE OFFSET         00832000
          SR    RBASE,RBASE2             LOAD NIPM BASE 1               00833000
          LA    RBASE1,4095(0,RBASE)     LOAD NIPM BASE 2               00834000
          LA    RBASE2,4095(0,RBASE1)    LOAD NIPM BASE 3               00835000
          LA    RNVT,NVT                 SET NVT PTR                    00836000
          L     RCVT,FLCCVT              SET CVT PTR                    00837000
          L     RBSECPTR,RBLINK(5)        LINK BACK TO PREVIOUS RB      00838000
          LA    RSAVE,NSVCSAV             SETUP TEMPORARY SAVE AREA     00839000
*   IF RBINTCOD='001A'X             /* IF IT IS THE LOCATE SVC       */ 00840000
*     THEN                          /* PASS BACK VOLSER.             */ 00841000
         LR    @07,RBSECPTR                                        0581 00842000
         BCTR  @07,0                                               0581 00843000
         BCTR  @07,0                                               0581 00844000
         CLC   RBINTCOD-62(2,@07),@CB04842                         0581 00845000
         BNE   @RF00581                                            0581 00846000
*     DO;                                                          0582 00847000
*                                                                  0582 00848000
*       /*************************************************************/ 00849000
*       /*                                                           */ 00850000
*       /* CHECK TO SEE IF NP12 HAS ALREADY BEEN LOADED. IF SO PICK  */ 00851000
*       /* UP ADDRESS AND BALR                                       */ 00852000
*       /*                                                           */ 00853000
*       /*************************************************************/ 00854000
*                                                                  0583 00855000
*       IF NP12EP^=0 THEN           /* NIP12 LOADED?         @ZM30464*/ 00856000
         L     @07,NP12EP                                          0583 00857000
         LTR   @07,@07                                             0583 00858000
         BZ    @RF00583                                            0583 00859000
*         DO;                                                      0584 00860000
*           PARMSAVE=RPARM;         /* SAVE PARM REG         @ZM30464*/ 00861000
         ST    RPARM,PARMSAVE                                      0585 00862000
*           RPARM=NP12EP;           /* PICK UP NIP12 EP      @ZM30464*/ 00863000
         LR    RPARM,@07                                           0586 00864000
*         END;                                                     0587 00865000
*       ELSE                                                       0588 00866000
*                                                                  0588 00867000
*         /***********************************************************/ 00868000
*         /*                                                         */ 00869000
*         /* NIP12 HAS NOT BEEN LOADED. LOAD MODULE, AND SAVE IT'S   */ 00870000
*         /* ENTRY POINT FOR FOLLOWING CALLS                         */ 00871000
*         /*                                                         */ 00872000
*         /***********************************************************/ 00873000
*                                                                  0588 00874000
*         DO;                                                      0588 00875000
         B     @RC00583                                            0588 00876000
@RF00583 DS    0H                                                  0589 00877000
*           PARMSAVE=RPARM;         /* SAVE PARAMETER LIST           */ 00878000
         ST    RPARM,PARMSAVE                                      0589 00879000
*           RPARM=ADDR(NPLOCMOD);   /* ADDR OF IEAVNP12 NAME         */ 00880000
         LA    RPARM,NPLOCMOD                                      0590 00881000
*           CALL NIPLOAD;           /* DOES BLDL AND LOADS THE MODULE*/ 00882000
         BAL   @14,NIPLOAD                                         0591 00883000
*           NP12EP=RPARM;           /* SAVE ENTRY POINT      @ZM30464*/ 00884000
         ST    RPARM,NP12EP                                        0592 00885000
*         END;                                                     0593 00886000
*       GENERATE;                                                  0594 00887000
@RC00583 DS    0H                                                  0594 00888000
         LR    RENTRY,RPARM             GET ADDRESS OF IEAVNP12         00889000
         L     RPARM,PARMSAVE           RESTORE PARAMETER LIST          00890000
         BALR  REXIT,RENTRY             GO TO LOCATE ROUTINE            00891000
         ST    RENTRY,SVCREGS+52        SAVE RETURN CODE                00892000
         LM    RNVT,RPARM,SVCREGS       RESTORE REGISTERS               00893000
         BR    REXIT                    RETURN TO CALLER                00894000
*SVCREGS:                           /* SAVEAREA FOR THIS RTN         */ 00895000
*       GEN(DS 16F);                                               0595 00896000
SVCREGS  DS 16F                                                         00897000
*NSVCSAV:                                                          0596 00898000
*       GEN(DS  18F);               /* TEMPORARY SAVE AREA           */ 00899000
NSVCSAV  DS  18F                                                        00900000
*     END;                          /* END OF 'DO' CODE              */ 00901000
*   ELSE                                                           0598 00902000
*     ;                                                            0598 00903000
@RF00581 DS    0H                                                  0599 00904000
*   CALL NIPLKCHK;                  /* GO GET NIP LOCK               */ 00905000
         BAL   @14,NIPLKCHK                                        0599 00906000
*   NPMIDPSW=RBINTCOD;              /* PUT SVC CODE IN PSW           */ 00907000
         LR    @07,RBSECPTR                                        0600 00908000
         BCTR  @07,0                                               0600 00909000
         BCTR  @07,0                                               0600 00910000
         MVC   NPMIDPSW(2),RBINTCOD-62(@07)                        0600 00911000
*   NPMFLWSC=NVTWCN12;              /* SET WAIT STATE CODE           */ 00912000
         MVI   NPMFLWSC,X'65'                                      0601 00913000
*   GEN(IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* GO TO DISABLED WAIT         */ 00914000
         IEAPMNIP TYPE=SWAIT,MOD=NIPM                                   00915000
*   RESPECIFY                                                      0603 00916000
*    (RUCB,                                                        0603 00917000
*     RBSECPTR,                                                    0603 00918000
*     ENTPT6) UNRESTRICTED;                                        0603 00919000
*NIPXCDIC:                                                         0604 00920000
*   ENTRY;                          /* HEX TO EBCDIC CONVERT         */ 00921000
*                                                                  0604 00922000
@EP00604 DS    0H                                                  0605 00923000
*   /*****************************************************************/ 00924000
*   /*                                                               */ 00925000
*   /* THIS ROUTINE CONVERTS UP TO 4 HEXADECIMAL BYTES TO EBCDIC     */ 00926000
*   /* REPRESENTATION.                                               */ 00927000
*   /*                                                               */ 00928000
*   /*****************************************************************/ 00929000
*                                                                  0605 00930000
*   GEN(STM  RNVT,RPARM,HEXSAV);    /* SAVE CALLERS REGISTERS        */ 00931000
         STM  RNVT,RPARM,HEXSAV                                         00932000
*   GEN(UNPK CONVERT(9),CONVERT(5));/* UNPACK THE HEX CHAR           */ 00933000
*                                                                  0606 00934000
         UNPK CONVERT(9),CONVERT(5)                                     00935000
*   /*****************************************************************/ 00936000
*   /*                                                               */ 00937000
*   /* LOOP THRU UNPACKED DIGITS CONVERTING ANY OCCURENCE OF DIGITS  */ 00938000
*   /* 'FA'-'FF' TO 'C1'-'C6' (LETTERS 'A'-'F')                      */ 00939000
*   /*                                                               */ 00940000
*   /*****************************************************************/ 00941000
*                                                                  0607 00942000
*   DO I=DIGITS TO 1 BY-1;          /* LOOP THRU UNPACKED DIGITS     */ 00943000
         L     @05,DIGITS                                          0607 00944000
         ST    @05,I                                               0607 00945000
         B     @DE00607                                            0607 00946000
@DL00607 DS    0H                                                  0608 00947000
*     IF CONVERT(I)>'F9'X           /* IF CHAR IS NOT NUMERIC        */ 00948000
*       THEN                        /* CONVERT IT TO LETTER          */ 00949000
*                                                                  0608 00950000
         LA    @15,CONVERT-1(@05)                                  0608 00951000
         CLI   0(@15),X'F9'                                        0608 00952000
         BNH   @RF00608                                            0608 00953000
*       /*************************************************************/ 00954000
*       /*                                                           */ 00955000
*       /* CONVERT UNPACKED HEX LETTER TO EBCDIC                     */ 00956000
*       /*                                                           */ 00957000
*       /*************************************************************/ 00958000
*                                                                  0609 00959000
*       CONVERT(I)=CONVERT(I)-'39'X;                               0609 00960000
         SLR   @00,@00                                             0609 00961000
         IC    @00,CONVERT-1(@05)                                  0609 00962000
         SL    @00,@CF02070                                        0609 00963000
         STC   @00,CONVERT-1(@05)                                  0609 00964000
*   END;                            /* END OF CONVERT DO LOOP        */ 00965000
@RF00608 SLR   @05,@05                                             0610 00966000
         BCTR  @05,0                                               0610 00967000
         AL    @05,I                                               0610 00968000
         ST    @05,I                                               0610 00969000
@DE00607 LTR   @05,@05                                             0610 00970000
         BP    @DL00607                                            0610 00971000
*   GENERATE;                                                      0611 00972000
*                                      /* GENERATE EXIT LINKAGE      */ 00973000
           LM   RNVT,RPARM,HEXSAV         RESTORE CALLERS REGS          00974000
           BR  REXIT                      RETURN TO CALLER              00975000
*NIPEBCDX:                                                         0612 00976000
*   ENTRY;                          /* CONVERT EBCDIC TO HEX         */ 00977000
*                                                                  0612 00978000
@EP00612 DS    0H                                                  0613 00979000
*   /*****************************************************************/ 00980000
*   /*                                                               */ 00981000
*   /* THIS ROUTINE IS TO CONVERT EBCDIC TO HEXADECIMAL.             */ 00982000
*   /*                                                               */ 00983000
*   /*****************************************************************/ 00984000
*                                                                  0613 00985000
*   GEN(STM RNVT,RPARM,HEXSAV);     /* SAVE CALLERS REGISTERS        */ 00986000
         STM RNVT,RPARM,HEXSAV                                          00987000
*   CUA=RPARM;                      /* STORE EBCDIC UNIT NAME        */ 00988000
*                                                                  0614 00989000
         ST    RPARM,CUA                                           0614 00990000
*   /*****************************************************************/ 00991000
*   /*                                                               */ 00992000
*   /* LOOP THRU CONVERT AREA. CONVERT ANY OCCURENCE OF BYTES        */ 00993000
*   /* 'C1'-'C6' TO 'CA'-'CF'. THAT IS, CONVERT NUMERIC PORTION TO   */ 00994000
*   /* HEX (CONVERTABLE INPUT ASSUMED).                              */ 00995000
*   /*                                                               */ 00996000
*   /*****************************************************************/ 00997000
*                                                                  0615 00998000
*   DO I=1 TO 3;                    /* LOOP THRU 3 BYTES             */ 00999000
*                                                                  0615 01000000
         LA    @05,1                                               0615 01001000
         ST    @05,I                                               0615 01002000
@DL00615 DS    0H                                                  0616 01003000
*     /***************************************************************/ 01004000
*     /*                                                             */ 01005000
*     /* IF LETTER IS LESS THAN NUMERIC, ASSUME IT IS A-F.           */ 01006000
*     /*                                                             */ 01007000
*     /***************************************************************/ 01008000
*                                                                  0616 01009000
*     IF LETTER(I)<'F0'X            /* LETTER NOT NUMERAL ?          */ 01010000
*       THEN                        /* THEN IS ALPHABETIC            */ 01011000
         SLR   @15,@15                                             0616 01012000
         IC    @15,LETTER-1(@05)                                   0616 01013000
         C     @15,@CF01887                                        0616 01014000
         BNL   @RF00616                                            0616 01015000
*       LETTER(I)=LETTER(I)+9;      /* CONVERT NUMERIC DIGIT TO HEX     01016000
*                                      VALUE                         */ 01017000
         AL    @15,@CF01418                                        0617 01018000
         STC   @15,LETTER-1(@05)                                   0617 01019000
*   END;                            /* END OF CONVERT DO LOOP        */ 01020000
@RF00616 LA    @05,1                                               0618 01021000
         AL    @05,I                                               0618 01022000
         ST    @05,I                                               0618 01023000
         C     @05,@CF00381                                        0618 01024000
         BNH   @DL00615                                            0618 01025000
*   GEN(PACK CUA(4),CUA(4));        /* PACK THE BYTES TO COMPLETE THE   01026000
*                                      CONVERSION                    */ 01027000
         PACK CUA(4),CUA(4)                                             01028000
*   RPARM=CUA;                      /* PUT RESULT IN INTERFACE REG   */ 01029000
         L     RPARM,CUA                                           0620 01030000
*   GENERATE;                                                      0621 01031000
*                                                                  0621 01032000
*                                      /* GENERATE EXIT LINKAGE      */ 01033000
           LM    RNVT,RZERO,HEXSAV        RESTORE CALLERS REGS          01034000
           BR    REXIT                    RETURN TO CALLER              01035000
*                                                                       01036000
*                PROCEDURE  SAVEAREAS                                   01037000
*                                                                       01038000
NIPSAVE  DS    18F           SAVE AREA FOR NIP PROCESSORS               01039000
HEXSAV   DS    16F           SAVE AREA FOR HEX CONVERT RTNS             01040000
*   /*****************************************************************/ 01041000
*   /*                                                               */ 01042000
*   /* RELEASE REGISTERS FOR NIPM MAINLINE                           */ 01043000
*   /*                                                               */ 01044000
*   /*****************************************************************/ 01045000
*                                                                  0622 01046000
*   RESPECIFY                                                      0622 01047000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 01048000
*     RNVT,                         /* NVT BASE REGISTER             */ 01049000
*     RCVT,                         /* CVT BASE REGISTER             */ 01050000
*     RNIPM) UNRESTRICTED;          /* NIPM WORK REGISTER            */ 01051000
*NIPLOAD:                           /* PROCESSOR LOAD ROUTINE        */ 01052000
*                                                                  0623 01053000
*   /*****************************************************************/ 01054000
*   /*                                                               */ 01055000
*   /* THIS ROUTINE IS ENTERED FROM THE IEAVNIPM CONTROL TO FIND AND */ 01056000
*   /* LOAD INDIVIDUAL NIP PROCESSOR MODULES. NIPLOAD RECEIVES, AS   */ 01057000
*   /* INPUT, A POINTER IN REGISTER RPARM TO AN AREA CONTAINING THE  */ 01058000
*   /* EIGHT-CHARACTER NAME OF THE MODULE WHICH IS TO BE LOADED.     */ 01059000
*   /* NIPLOAD CAN ALSO BE ENTERED FROM NIP PROCESSORS, WITH THE SAME*/ 01060000
*   /* INPUT, TO LOAD THE NIPOPEN, NIPMOUNT, AND NIPPAGIO SERVICE    */ 01061000
*   /* ROUTINES.                                                     */ 01062000
*   /*                                                               */ 01063000
*   /*****************************************************************/ 01064000
*                                                                  0623 01065000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/* PROC STATEMENT              */ 01066000
*                                                                  0623 01067000
         B     @PB00002                                            0623 01068000
NIPLOAD  DS    0H                                                  0624 01069000
*   /*****************************************************************/ 01070000
*   /*                                                               */ 01071000
*   /* RESTRICT REGISTERS FOR NIPLOAD SUBROUTINE                     */ 01072000
*   /*                                                               */ 01073000
*   /*****************************************************************/ 01074000
*                                                                  0624 01075000
*   RESPECIFY                                                      0624 01076000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 01077000
*     RNVT,                         /* NVT BASE REGISTER             */ 01078000
*     RCVT,                         /* CVT BASE REGISTER             */ 01079000
*     RNIPM) RESTRICTED;            /* NIPM WORK REGISTER            */ 01080000
*   GEN(NIPMENTR  LOADSAV,NIPLOAD); /* GEN ENTRY LINKAGE             */ 01081000
         NIPMENTR  LOADSAV,NIPLOAD                                      01082000
*   NAME=RPARM->MODNAME;            /* PUT MOD NAME IN BLDL AREA     */ 01083000
         MVC   NAME(8),MODNAME(RPARM)                              0626 01084000
*   RPARM=NVTDCBSN;                 /* LOAD SYS1.NUCLEUS DCB ADDR    */ 01085000
         L     RPARM,NVTDCBSN                                      0627 01086000
*   GEN( BLDL  (1),NPMLBLDL );      /* ISSUE BLDL                    */ 01087000
*                                                                  0628 01088000
          BLDL  (1),NPMLBLDL                                            01089000
*   /*****************************************************************/ 01090000
*   /*                                                               */ 01091000
*   /* TEST FOR ERROR CODE INDICATING ENTRY NOT FOUND                */ 01092000
*   /*                                                               */ 01093000
*   /*****************************************************************/ 01094000
*                                                                  0629 01095000
*   IF RENTRY=4                     /* IF MODULE NOT FOUND           */ 01096000
*     THEN                          /* IF NOT, WRITE MESSAGE         */ 01097000
         C     RENTRY,@CF00109                                     0629 01098000
         BNE   @RF00629                                            0629 01099000
*     DO;                           /* AND LOAD WAIT STATE           */ 01100000
*       MODNAM2=NAME;               /* MOVE MOD NAME TO MSG AREA     */ 01101000
         MVC   MODNAM2(8),NAME                                     0631 01102000
*       NVTFLWSC=NVTFLWNN;          /* SET NVT WAIT STATE CODE       */ 01103000
         MVI   NVTFLWSC,X'32'                                      0632 01104000
*       RPARM=ADDR(IEA301I);        /* LOAD MSG HEADER ADDRESS       */ 01105000
         LA    RPARM,IEA301I                                       0633 01106000
*       RENTRY=NVTWTO;              /* LOAD WTO ROUTINE ADDR         */ 01107000
         L     RENTRY,NVTWTO                                       0634 01108000
*       GEN(BALR REXIT,RENTRY);     /* BALR TO WRITE MSG             */ 01109000
         BALR REXIT,RENTRY                                              01110000
*       GO TO NPMLXIT;              /* BRANCH TO EXIT ROUTINE        */ 01111000
         B     NPMLXIT                                             0636 01112000
*     END;                                                         0637 01113000
*                                                                  0637 01114000
*   /*****************************************************************/ 01115000
*   /*                                                               */ 01116000
*   /* TEST FOR ERROR CODE INDICATING INPUT/OUTPUT ERROR             */ 01117000
*   /*                                                               */ 01118000
*   /*****************************************************************/ 01119000
*                                                                  0638 01120000
*   IF RENTRY=8                     /* I/O ERROR ON BLDL ?           */ 01121000
*     THEN                          /* IF SO, WRITE MSG AND -        */ 01122000
@RF00629 C     RENTRY,@CF00125                                     0638 01123000
         BNE   @RF00638                                            0638 01124000
*     DO;                           /* LOAD WAIT STATE               */ 01125000
*       MODNAM1=NAME;               /* MOVE MOD NAME TO MSG AREA     */ 01126000
         MVC   MODNAM1(8),NAME                                     0640 01127000
*       NVTFLWSC=NVTFLWBN;          /* SET NVT WAIT STATE CODE       */ 01128000
         MVI   NVTFLWSC,X'33'                                      0641 01129000
*       RPARM=ADDR(IEA300I);        /* LOAD MSG HEADER ADDRESS       */ 01130000
         LA    RPARM,IEA300I                                       0642 01131000
*       RENTRY=NVTWTO;              /* LOAD WTO ROUTINE ADDR         */ 01132000
         L     RENTRY,NVTWTO                                       0643 01133000
*       GEN(BALR REXIT,RENTRY) ;    /* BALR TO WRITE MSG             */ 01134000
         BALR REXIT,RENTRY                                              01135000
*       GO TO NPMLXIT;              /* BRANCH TO EXIT ROUTINE        */ 01136000
         B     NPMLXIT                                             0645 01137000
*     END;                                                         0646 01138000
*                                                                  0646 01139000
*   /*****************************************************************/ 01140000
*   /*                                                               */ 01141000
*   /* THE NEXT 3 STATEMENTS SET THE PDS ATTRIBUTE FLAGS FROM THE    */ 01142000
*   /* VALUES IN THE NVT                                             */ 01143000
*   /*                                                               */ 01144000
*   /*****************************************************************/ 01145000
*                                                                  0647 01146000
*   BMASK=NVTNPATR&'C0'X;           /* 'AND' IN NVT ATTRIBUTES       */ 01147000
@RF00638 MVC   BMASK(1),NVTNPATR                                   0647 01148000
         NI    BMASK,X'C0'                                         0647 01149000
*   ATTRIB=ATTRIB&'3F'X;            /* CLEAR ATTRIBUTE FLAGS         */ 01150000
         NI    ATTRIB,X'3F'                                        0648 01151000
*   ATTRIB=ATTRIBBMASK;            /* 'OR' NVT VALUES TO FLAGS      */ 01152000
         OC    ATTRIB(1),BMASK                                     0649 01153000
*   NVTNPREN='11'B;                 /* SET NVT ATTRIBUTES TO RENT SO    01154000
*                                      THAT SP252 IS USED            */ 01155000
         OI    NVTNPREN,B'11000000'                                0650 01156000
*   RPARM=NVTDCBSN;                 /* LOAD SYS1.NUCLEUS DCB ADDR    */ 01157000
*                                                                  0651 01158000
         L     RPARM,NVTDCBSN                                      0651 01159000
*   /*****************************************************************/ 01160000
*   /*                                                               */ 01161000
*   /* ISSUE SVC LOAD FOR MODULE                                     */ 01162000
*   /*                                                               */ 01163000
*   /*****************************************************************/ 01164000
*                                                                  0652 01165000
*   GEN(LOAD  DE=NAME,DCB=(1));                                    0652 01166000
         LOAD  DE=NAME,DCB=(1)                                          01167000
*   RPARM=RZERO;                    /* PUT MODULE ADR IN PARM REG    */ 01168000
         LR    RPARM,RZERO                                         0653 01169000
*   GEN(LM  RNVT,RZERO,LOADSAV);    /* RESTORE CALLER'S REGS         */ 01170000
         LM  RNVT,RZERO,LOADSAV                                         01171000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 01172000
*                                                                  0655 01173000
         BR REXIT                                                       01174000
*   /*****************************************************************/ 01175000
*   /*                                                               */ 01176000
*   /* GENERATE NIPLOAD REGISTER SAVEAREA                            */ 01177000
*   /*                                                               */ 01178000
*   /*****************************************************************/ 01179000
*                                                                  0656 01180000
*LOADSAV:                                                          0656 01181000
*   GEN(DS    16F    NIPLOAD SAVEAREA);                            0656 01182000
LOADSAV  DS    16F    NIPLOAD SAVEAREA                                  01183000
*NPMLXIT:                           /* LOAD WAIT STATE EXIT          */ 01184000
*                                                                  0657 01185000
*   /*****************************************************************/ 01186000
*   /*                                                               */ 01187000
*   /* MOVE THE IDENTIFIER FOR THE NAME OF THE MODULE FOR WHICH BLDL */ 01188000
*   /* FAILED INTO THE WAIT STATE PSW (NVTIDPSW) IN THE NVT          */ 01189000
*   /*                                                               */ 01190000
*   /*****************************************************************/ 01191000
*                                                                  0657 01192000
*   HMASK=NAMSUFF;                  /* MOVE NAME SUFFIX TO WORK      */ 01193000
NPMLXIT  LH    @05,NAMSUFF                                         0657 01194000
         N     @05,@CF05060                                        0657 01195000
         STH   @05,HMASK                                           0657 01196000
*   IF NAMSUFF='PX'                 /* SEE IF NIPX WAS MODULE        */ 01197000
*     THEN                          /* IF SO, TREAT SPECIAL          */ 01198000
         CLC   NAMSUFF(2),@CC04863                                 0658 01199000
         BNE   @RF00658                                            0658 01200000
*     DO;                                                          0659 01201000
*       HMASK=HMASK&'0FFF'X;        /* TURN OFF HIGH 4 BITS          */ 01202000
         NC    HMASK(2),@CB04864                                   0660 01203000
*       NVTIDPSW=HMASK;             /* MOVE TO PSW ID FIELD          */ 01204000
         LH    @05,HMASK                                           0661 01205000
         N     @05,@CF05060                                        0661 01206000
         STH   @05,NVTIDPSW                                        0661 01207000
*       GEN( IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE IPL          */ 01208000
          IEAPMNIP TYPE=SWAIT,MOD=NIPM                                  01209000
*     END;                                                         0663 01210000
*   ELSE                                                           0664 01211000
*     ;                                                            0664 01212000
@RF00658 DS    0H                                                  0665 01213000
*   RPARM=HMASKCON;                 /* SETUP FOR CONVERSION          */ 01214000
         L     RPARM,HMASKCON                                      0665 01215000
*   CALL NIPEBCDX;                  /* CONVERT IT TO HEXIDECIMAL     */ 01216000
         L     @15,@CA04765                                        0666 01217000
         BALR  @14,@15                                             0666 01218000
*   GEN( SRL  RPARM,12);            /* SHIFT OUT UNUSED BITS         */ 01219000
          SRL  RPARM,12                                                 01220000
*   HMASK=RPARM;                    /* MOVE SIGNIFICANT BITS BACK TO    01221000
*                                      WORKAREA.                     */ 01222000
         STH   RPARM,HMASK                                         0668 01223000
*   NVTIDPSW=NVTIDPSW&'F000'X;      /* CLEAR 12 BITS IN NVT          */ 01224000
         NC    NVTIDPSW(2),@CB04865                                0669 01225000
*   NVTIDPSW=NVTIDPSWHMASK;        /* 'OR' SUFFIX INTO NVT          */ 01226000
         OC    NVTIDPSW(2),HMASK                                   0670 01227000
*   GEN(IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE THE IPL           */ 01228000
         IEAPMNIP TYPE=SWAIT,MOD=NIPM                                   01229000
*NIPABEND:                                                         0672 01230000
*   ENTRY;                          /* ABEND TRAP ROUTINE            */ 01231000
*                                                                  0672 01232000
         B     @EC00672                                            0672 01233000
NIPABEND DS    0H                                                  0672 01234000
@EC00672 DS    0H                                                  0673 01235000
*   /*****************************************************************/ 01236000
*   /*                                                               */ 01237000
*   /* IF AN ATTEMPT IS MADE TO INVOKE THE ABEND SVC DURING NIP      */ 01238000
*   /* PROCESSING AFTER THE IEAVNIPM CONTROL ROUTINE HAS ENTERED,    */ 01239000
*   /* THIS ROUTINE IS ENTERED AS A TYPE 2 SVC FROM SVC SLIH AS IF IT*/ 01240000
*   /* WERE, IN FACT, THE ABEND SVC. IT OBTAINS THE NIP LOCK AND SETS*/ 01241000
*   /* UP THE ABEND CODE IN A PARAMETER LIST ALONG WITH THE WAIT     */ 01242000
*   /* STATE CODE FOR ABENDS, TO PASS TO THE NIPSWAIT ROUTINE TO     */ 01243000
*   /* TERMINATE THE IPL PROCESS. WHEN THE SYSTEM IS PLACED IN THE   */ 01244000
*   /* WAIT STATE, THE ABEND CODE AND WAIT STATE CODE WILL BE IN THE */ 01245000
*   /* ADDRESS PORTION OF THE WAIT STATE PSW. A MESSAGE IS ALSO      */ 01246000
*   /* PREPARED AND PASSED TO NIPSWAIT TO BE WRITTEN TO A CONSOLE BY */ 01247000
*   /* THE RMS SYSTEM TERMINATION ROUTINE IF POSSIBLE.               */ 01248000
*   /*                                                               */ 01249000
*   /*****************************************************************/ 01250000
*                                                                  0673 01251000
*/*           RESTRICT TCBPTR FOR NIPABEND ROUTINE                   */ 01252000
*                                                                  0673 01253000
*   RESPECIFY                                                      0673 01254000
*     TCBPTR RESTRICTED;                                           0673 01255000
*   GENERATE;                                                      0674 01256000
*                                      /* GENERATE ENTRY LINKAGE     */ 01257000
         BALR  RENTRY,0                   SET TEMP ADDRESSABILITY       01258000
NPMAB    L     RNVT,NPMABADC-NPMAB(0,RENTRY)     LOAD NVT ADDRESS       01259000
         LM    RBASE,RBASE2,NVTNIPM-NVT(RNVT)  SET UP BASE REGS         01260000
*   CALL NIPLKCHK;                  /* GO GET THE NIP LOCK           */ 01261000
         BAL   @14,NIPLKCHK                                        0675 01262000
*   GEN(SRL RPARM,12);              /* SHIFT COMPLETION CODE TO LOW     01263000
*                                      END OF REGISTER 1             */ 01264000
         SRL RPARM,12                                                   01265000
*   BITFLD=RPARM;                   /* STORE ABEND CODE IN HWORD     */ 01266000
         ST    RPARM,BITFLD                                        0677 01267000
*   CODE=CODE&'0FFF'X;              /* 'AND' OUT TOP 4 BITS          */ 01268000
         NC    CODE(2),@CB04864                                    0678 01269000
*   NPMIDPSW=NPMIDPSWCODE;         /* 'OR' IN 12 BIT ABEND CODE     */ 01270000
         OC    NPMIDPSW(2),CODE                                    0679 01271000
*   NPMFLWSC=NVTFLWAM;              /* SET WAIT STATE CODE IN PSW    */ 01272000
         MVI   NPMFLWSC,X'40'                                      0680 01273000
*   RPARM=NPMWPSW2;                 /* MOVE ABEND CODE TO REG 1      */ 01274000
         L     RPARM,NPMWPSW2                                      0681 01275000
*   GEN(SLL  RPARM,4);              /* SHIFT TO HIGH ORDER POS.      */ 01276000
         SLL  RPARM,4                                                   01277000
*   CONVERT(1:4)=RPARM;             /* STORE IN CONVERT AREA         */ 01278000
         STCM  RPARM,15,CONVERT                                    0683 01279000
*   DIGITS=LENGTH(CODE303I);        /* SET CONVERT LENGTH            */ 01280000
         MVC   DIGITS(4),@CF00381                                  0684 01281000
*   RPARM=ADDR(DIGITS);             /* LOAD PARM REG WITH ADDR       */ 01282000
         LA    RPARM,DIGITS                                        0685 01283000
*   CALL NIPXCDIC;                  /* CALL HEX-TO-EBCDIC ROUTINE    */ 01284000
         L     @15,@CA04764                                        0686 01285000
         BALR  @14,@15                                             0686 01286000
*   CODE303I=CONVERT(1:LENGTH(CODE303I));/* MOVE TO MSG              */ 01287000
         MVC   CODE303I(3),CONVERT                                 0687 01288000
*   NPSWAITM=ADDR(IEA303I);         /* LOAD MSG HEADER ADDRESS       */ 01289000
         LA    @05,IEA303I                                         0688 01290000
         ST    @05,NPSWAITM                                        0688 01291000
*   GEN( IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE IPL              */ 01292000
          IEAPMNIP TYPE=SWAIT,MOD=NIPM                                  01293000
*NPMABADC:                                                         0690 01294000
*   GEN( DC  A(NVT));               /* ADCON FOR NVT                 */ 01295000
*                                                                  0690 01296000
NPMABADC  DC  A(NVT)                                                    01297000
*   /*****************************************************************/ 01298000
*   /*                                                               */ 01299000
*   /* RELEASE REGISTERS USED IN NIPLOAD ROUTINE                     */ 01300000
*   /*                                                               */ 01301000
*   /*****************************************************************/ 01302000
*                                                                  0691 01303000
*   RESPECIFY                                                      0691 01304000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 01305000
*     RNVT,                         /* NVT BASE REGISTER             */ 01306000
*     RCVT,                         /* CVT BASE REGISTER             */ 01307000
*     RNIPM,                        /* NIPM WORK REGISTER            */ 01308000
*     TCBPTR) UNRESTRICTED;         /* TCB BASE (NIPABEND)           */ 01309000
*   END NIPLOAD;                    /* END - NIPLOAD PROCEDURE       */ 01310000
@EL00002 DS    0H                                                  0692 01311000
@EF00002 DS    0H                                                  0692 01312000
@ER00002 BR    @14                                                 0692 01313000
*                                                                  0693 01314000
*   /*****************************************************************/ 01315000
*   /*                                                               */ 01316000
*   /* THIS ROUTINE OPENS SYS1.LOGREC AND SYS1.SVCLIB AND BUILDS A   */ 01317000
*   /* BASIC DEB FOR SYS1.LINKLIB BY INVOKING THE NIPOPEN SERVICE    */ 01318000
*   /* ROUTINE.                                                      */ 01319000
*   /*                                                               */ 01320000
*   /*****************************************************************/ 01321000
*                                                                  0693 01322000
*NPMOPLIB:                                                         0693 01323000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0693 01324000
NPMOPLIB DS    0H                                                  0694 01325000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 01326000
*    (RNIPM,                        /* WORK REGISTER                 */ 01327000
*     RNVT,                         /* NVT POINTER                   */ 01328000
*     RCVT,                         /* CVT POINTER                   */ 01329000
*     RDCB) RESTRICTED;             /* DCB POINTER                   */ 01330000
*   GEN(NIPMENTR OPLIBSAV,NPMOPLIB);/* ENTRY LINKAGE                 */ 01331000
         NIPMENTR OPLIBSAV,NPMOPLIB                                     01332000
*   RESPECIFY                                                      0696 01333000
*     NIPOPNPL BASED(NPMPPTR);      /* BASE FOR OPEN LIST            */ 01334000
*   RESPECIFY                                                      0697 01335000
*     DUMMYDCB BASED(DCBPTR1);      /* BASE FOR DCB MAP              */ 01336000
*   NPMPPTR=ADDR(LIBOPL);           /* ADDRESS OF OPEN LIST          */ 01337000
         LA    @15,LIBOPL                                          0698 01338000
         ST    @15,NPMPPTR                                         0698 01339000
*   NOPNUCB=CVTSYSAD;               /* ADDRESS OF SYSRES UCB         */ 01340000
         L     @14,CVTPTR                                          0699 01341000
         L     @09,CVTSYSAD(,@14)                                  0699 01342000
         ST    @09,NOPNUCB(,@15)                                   0699 01343000
*   NOPNDS=LOGREC;                  /* EBCDIC DSNAME- LOGREC-        */ 01344000
         MVC   NOPNDS(12,@15),LOGREC                               0700 01345000
*   RDCB=CVTDCBA;                   /* ADDRESS OF LOGREC DCB         */ 01346000
         L     RDCB,CVTDCBA-1(,@14)                                0701 01347000
         LA    RDCB,0(,RDCB)                                       0701 01348000
*   NOPNDCB=RDCB;                   /* PUT ADDRESS IN OPEN LIST      */ 01349000
         ST    RDCB,NOPNDCB(,@15)                                  0702 01350000
*   RNIPM=RDCB->DCBDEBAD;           /* GET DEB ADDRESS FROM DCB      */ 01351000
         L     RNIPM,DCBDEBAD-1(,RDCB)                             0703 01352000
         LA    RNIPM,0(,RNIPM)                                     0703 01353000
*   RNIPM->DEBAPPB=CVTXAPG;         /* GET ADDR. OF APP. VECT. TAB.  */ 01354000
         MVC   DEBAPPB(3,RNIPM),CVTXAPG+1(@14)                     0704 01355000
*   RESPECIFY                                                      0705 01356000
*    (RDCB) UNRESTRICTED;                                          0705 01357000
*                                                                  0705 01358000
*   /*****************************************************************/ 01359000
*   /*                                                               */ 01360000
*   /* THE FOLLOWING TWO OPENS CANT BE DONE UNTIL AFTER NP01 CONSOLE */ 01361000
*   /* INITIALIZATION CALL NIPOPEN TO CREATE DEB FOR LOGREC DATA SET */ 01362000
*   /*                                                               */ 01363000
*   /*****************************************************************/ 01364000
*                                                                  0706 01365000
*   GENERATE REFS(RNVT,NVTOPEN,LIBOPL) SETS(RPARM,REXIT,RENTRY,NOPNFL)  01366000
*       (IEAPMNIP TYPE=OPEN,PARAM=LIBOPL,OPT=(,,,SX,,,,RS),MOD=NIPM);   01367000
         IEAPMNIP TYPE=OPEN,PARAM=LIBOPL,OPT=(,,,SX,,,,RS),MOD=NIPM     01368000
*   NOPNDCB=CVTSVDCB;               /* PUT SVCLIB DCB IN OPEN LIST   */ 01369000
         L     @05,NPMPPTR                                         0707 01370000
         L     @01,CVTPTR                                          0707 01371000
         L     @15,CVTSVDCB(,@01)                                  0707 01372000
         ST    @15,NOPNDCB(,@05)                                   0707 01373000
*   NOPNDS=SVCLIB;                  /* EBCDIC DSNAME- SVCLIB -       */ 01374000
*                                                                  0708 01375000
         MVC   NOPNDS(12,@05),SVCLIB                               0708 01376000
*   /*****************************************************************/ 01377000
*   /*                                                               */ 01378000
*   /* CALL NIPOPEN TO CREATE DEB FOR SVCLIB DATA SET FOR NP05       */ 01379000
*   /*                                                               */ 01380000
*   /*****************************************************************/ 01381000
*                                                                  0709 01382000
*   GENERATE REFS(RNVT,NVTOPEN,LIBOPL) SETS(RPARM,REXIT,RENTRY,NOPNFL)  01383000
*(IEAPMNIP TYPE=OPEN,PARAM=LIBOPL,OPT=(NB,LB,,,,,AU,RS),MOD=NIPM); 0709 01384000
*                                                                  0709 01385000
         IEAPMNIP TYPE=OPEN,PARAM=LIBOPL,OPT=(NB,LB,,,,,AU,RS),MOD=NIPM 01386000
*   /*****************************************************************/ 01387000
*   /*                                                               */ 01388000
*   /* DUMMY SYS1.LINKLIB DEFINITION                                 */ 01389000
*   /*                                                               */ 01390000
*   /*****************************************************************/ 01391000
*                                                                  0710 01392000
*   NOPNDCB=CVTLINK;                /* PTR TO LINKLIB DCB            */ 01393000
*                                                                  0710 01394000
         L     @05,NPMPPTR                                         0710 01395000
         L     @01,CVTPTR                                          0710 01396000
         L     @15,CVTLINK(,@01)                                   0710 01397000
         ST    @15,NOPNDCB(,@05)                                   0710 01398000
*   /*****************************************************************/ 01399000
*   /*                                                               */ 01400000
*   /* SET DSNAME TO ZERO TO SIGNAL NIPOPEN TO CONSTRUCT ONLY THE    */ 01401000
*   /* BASIC PORTION OF THE DEB.                                     */ 01402000
*   /*                                                               */ 01403000
*   /*****************************************************************/ 01404000
*                                                                  0711 01405000
*   NOPNDS=NOPNDS&&NOPNDS;          /* SET DSNAME FIELD TO ZEROES    */ 01406000
*                                                                  0711 01407000
         XC    NOPNDS(12,@05),NOPNDS(@05)                          0711 01408000
*   /*****************************************************************/ 01409000
*   /*                                                               */ 01410000
*   /* CALL NIPOPEN TO CREATE BASIC DEB FOR SYS1.LINKLIB             */ 01411000
*   /*                                                               */ 01412000
*   /*****************************************************************/ 01413000
*                                                                  0712 01414000
*   GENERATE REFS(RNVT,NVTOPEN,LIBOPL) SETS(RPARM,REXIT,RENTRY,NOPNFL)  01415000
*       (IEAPMNIP TYPE=OPEN,PARAM=LIBOPL,OPT=(NB,LB,,,,,AU),MOD=NIPM);  01416000
*                                                                  0712 01417000
         IEAPMNIP TYPE=OPEN,PARAM=LIBOPL,OPT=(NB,LB,,,,,AU),MOD=NIPM    01418000
*   /*****************************************************************/ 01419000
*   /*                                                               */ 01420000
*   /* UPDATE NVTNUCND TO REFLECT SPACE TAKEN FROM THE NUCLEUS BUFFER*/ 01421000
*   /* FOR THE BASIC DEB. THIS IS NOT DONE BY NIPOPEN WITH A REQUEST */ 01422000
*   /* FOR A DASD BASIC DEB ONLY.                                    */ 01423000
*   /*                                                               */ 01424000
*   /*****************************************************************/ 01425000
*                                                                  0713 01426000
*   NVTNUCND=NOPNDCB->DCBDEBAD+LENGTH(DEBDASD);                    0713 01427000
         L     @05,NPMPPTR                                         0713 01428000
         L     @05,NOPNDCB(,@05)                                   0713 01429000
         LA    @15,16                                              0713 01430000
         L     @05,DCBDEBAD-1(,@05)                                0713 01431000
         LA    @05,0(,@05)                                         0713 01432000
         ALR   @15,@05                                             0713 01433000
         ST    @15,NVTNUCND                                        0713 01434000
*   NVTFLSLB='1'B;                  /* TURN LIBRARY ACTIVE FLAG ON   */ 01435000
         OI    NVTFLSLB,B'10000000'                                0714 01436000
*   GEN(LM RNVT,RPARM,OPLIBSAV);    /* RESTORE REGISTERS             */ 01437000
         LM RNVT,RPARM,OPLIBSAV                                         01438000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 01439000
         BR REXIT                                                       01440000
*OPLIBSAV:                                                         0717 01441000
*   GEN(DS 16F);                    /* SAVEAREA FOR THIS ROUTINE.    */ 01442000
OPLIBSAV DS 16F                                                         01443000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 01444000
*    (RNIPM,                        /* WORK REGISTER                 */ 01445000
*     RNVT,                         /* NVT POINTER                   */ 01446000
*     RCVT) UNRESTRICTED;           /* CVT POINTER                   */ 01447000
*   END NPMOPLIB;                   /* END OF PROCEDURE-NPMOPLIB-    */ 01448000
@EL00003 DS    0H                                                  0719 01449000
@EF00003 DS    0H                                                  0719 01450000
@ER00003 BR    @14                                                 0719 01451000
*                                                                  0720 01452000
*   /*****************************************************************/ 01453000
*   /*                                                               */ 01454000
*   /* THIS ROUTINE IS CALLED BY IEAVNP01 AFTER A MASTER CONSOLE HAS */ 01455000
*   /* BEEN FOUND SO THAT THE INITIAL OPERATOR COMMUNICATIONS CAN BE */ 01456000
*   /* ESTABLISHED AND SYSTEM PARAMETER INPUT FROM THE OPERATOR CAN  */ 01457000
*   /* BEGIN. THE OPERATOR REPLY IS NOT WAITED ON BY THIS ROUTINE,   */ 01458000
*   /* BUT IS WAITED ON AFTER IEAVNP01 COMPLETES ITS PROCESSING OF   */ 01459000
*   /* ALTERNATE CONSOLES THUS ALLOWING SOME OVERLAP OF PROCESSING   */ 01460000
*   /* WITH THE OPERATOR RESPONSE ACTIVITY.                          */ 01461000
*   /*                                                               */ 01462000
*   /*****************************************************************/ 01463000
*                                                                  0720 01464000
*NIPOPIO:                                                          0720 01465000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0720 01466000
NIPOPIO  DS    0H                                                  0721 01467000
*   RESPECIFY                       /* RESTRICT REGISTERS NEEDED     */ 01468000
*    (RPARM,                        /* PARAMETER REGISTER            */ 01469000
*     RNIPM,                        /* WORK REGISTER                 */ 01470000
*     RNVT,                         /* NVT POINTER                   */ 01471000
*     RCVT) RESTRICTED;             /* CVT POINTER                   */ 01472000
*   GEN(NIPMENTR OPIOSAV,NIPOPIO);  /* ENTRY PROCESSING              */ 01473000
         NIPMENTR OPIOSAV,NIPOPIO                                       01474000
*   IF NVTFLNCK='1'B                /* TOD CLOCK INOPERATIVE?        */ 01475000
*     THEN                          /* YES, PUT OUT MESSAGE          */ 01476000
         TM    NVTFLNCK,B'00000100'                                0723 01477000
         BNO   @RF00723                                            0723 01478000
*     GEN( IEAPMNIP TYPE=WTO,PARAM=IEA302I,MOD=NIPM);              0724 01479000
          IEAPMNIP TYPE=WTO,PARAM=IEA302I,MOD=NIPM                      01480000
*   RENTRY=NVTWTO;                  /* GET ADDR OF NIPWTO ROUTINE    */ 01481000
@RF00723 L     RENTRY,NVTWTO                                       0725 01482000
*   RNIPM=NVTN0MSG;                 /* GET PTR TO NIP0 MSG LIST      */ 01483000
         L     RNIPM,NVTN0MSG                                      0726 01484000
*   RPARM=RNIPM->NP0MSGS;           /* PTR TO FIRST NIP0 MSG         */ 01485000
         L     RPARM,NP0MSGS(,RNIPM)                               0727 01486000
*   DO WHILE RPARM^=0&RNIPM^=0;     /* PROCESS MESSAGES              */ 01487000
         B     @DE00728                                            0728 01488000
@DL00728 DS    0H                                                  0729 01489000
*     GEN(BALR  REXIT,RENTRY);      /* GO WRITE A MESSAGE            */ 01490000
         BALR  REXIT,RENTRY                                             01491000
*     RNIPM=RNIPM+4;                /* GET NEXT MSG PTR IN LIST      */ 01492000
         AL    RNIPM,@CF00109                                      0730 01493000
*     RPARM=RNIPM->NP0MSGS;         /* GET ADDR OF NEXT MESSAGE      */ 01494000
         L     RPARM,NP0MSGS(,RNIPM)                               0731 01495000
*   END;                                                           0732 01496000
@DE00728 SLR   @05,@05                                             0732 01497000
         CR    RPARM,@05                                           0732 01498000
         BE    @DC00728                                            0732 01499000
         CR    RNIPM,@05                                           0732 01500000
         BNE   @DL00728                                            0732 01501000
@DC00728 DS    0H                                                  0733 01502000
*   RELNO1=CVTNUMB;                 /* PUT RELEASE NO. IN IEA101A    */ 01503000
         L     @05,CVTPTR                                          0733 01504000
         SL    @05,@CF01069                                        0733 01505000
         MVC   RELNO1(2),CVTNUMB(@05)                              0733 01506000
*   RELNO2=CVTLEVL;                 /* PUT RELEASE LEVEL IN MSG      */ 01507000
         MVC   RELNO2(2),CVTLEVL(@05)                              0734 01508000
*   WTORPTR=ADDR(LIST1);            /* SAVE ADDRESS OF CURRENT WTOR     01509000
*                                      PARAMETER LIST                */ 01510000
*                                                                  0735 01511000
         LA    @05,LIST1                                           0735 01512000
         ST    @05,WTORPTR                                         0735 01513000
*   /*****************************************************************/ 01514000
*   /*                                                               */ 01515000
*   /* WRITE IEA101A SPECIFY SYSTEM PARAMETERS MESSAGE               */ 01516000
*   /*                                                               */ 01517000
*   /*****************************************************************/ 01518000
*                                                                  0736 01519000
*   GENERATE REFS(RNVT,NVTWTOR,LIST1) SETS(RPARM,REXIT,RENTRY)     0736 01520000
*       (IEAPMNIP TYPE=WTOR,PARAM=LIST1,MOD=NIPM);                 0736 01521000
         IEAPMNIP TYPE=WTOR,PARAM=LIST1,MOD=NIPM                        01522000
*   GEN(LM RNVT,RPARM,OPIOSAV);     /* RESTORE REGISTERS             */ 01523000
         LM RNVT,RPARM,OPIOSAV                                          01524000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 01525000
         BR REXIT                                                       01526000
*OPIOSAV:                                                          0739 01527000
*   GEN(DS 16F);                    /* SAVE AREA FOR THIS ROUTINE    */ 01528000
OPIOSAV  DS 16F                                                         01529000
*   RESPECIFY                       /* FREE REGISTERS FOR USE        */ 01530000
*    (RPARM,                        /* PARAMETER REGISTER            */ 01531000
*     RNIPM,                        /* WORK REGISTER                 */ 01532000
*     RNVT,                         /* NVT POINTER                   */ 01533000
*     RCVT) UNRESTRICTED;           /* CVT POINTER                   */ 01534000
*   END NIPOPIO;                    /* END OF PROCEDURE              */ 01535000
@EL00004 DS    0H                                                  0741 01536000
@EF00004 DS    0H                                                  0741 01537000
@ER00004 BR    @14                                                 0741 01538000
*                                                                  0742 01539000
*   /*****************************************************************/ 01540000
*   /*                                                               */ 01541000
*   /* THIS ROUTINE IS CALLED BY NIP MAINLINE TO WAIT ON THE OPERATOR*/ 01542000
*   /* RESPONSE(S) TO THE 'SPECIFY SYSTEM PARAMETERS' MESSAGE. IT    */ 01543000
*   /* PROCESSES EACH LINE OF THE RESPONSE AND QUEUES THEM UP TO BE  */ 01544000
*   /* LATER PROCESSED BY THE NIP PARAMETER SIFT AND ANALYSIS ROUTINE*/ 01545000
*   /* (IEAVNP03).                                                   */ 01546000
*   /*                                                               */ 01547000
*   /*****************************************************************/ 01548000
*                                                                  0742 01549000
*NIPOPIOC:                                                         0742 01550000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0742 01551000
NIPOPIOC DS    0H                                                  0743 01552000
*   RESPECIFY                       /* RESTRICT REGISTERS USED       */ 01553000
*    (RPARM,                        /* PARAMETER REGISTER            */ 01554000
*     RNVT,                         /* NVT POINTER                   */ 01555000
*     RCVT) RESTRICTED;             /* CVT POINTER                   */ 01556000
*   GEN(NIPMENTR OPIOCSAV,NIPOPIOC);/* ENTRY PROCESSING              */ 01557000
         NIPMENTR OPIOCSAV,NIPOPIOC                                     01558000
*OPIOCENT:                                                         0745 01559000
*   RPARM=WTORPTR;                  /* GET PTR TO MOST RECENT WTOR 0745 01560000
*                                      PARAMETER LIST.               */ 01561000
*                                                                  0745 01562000
OPIOCENT L     RPARM,WTORPTR                                       0745 01563000
*   /*****************************************************************/ 01564000
*   /*                                                               */ 01565000
*   /* CALL THE NIPWTOR2 ROUTINE TO BUFFER THE REPLY                 */ 01566000
*   /*                                                               */ 01567000
*   /*****************************************************************/ 01568000
*                                                                  0746 01569000
*   GENERATE REFS(RNVT,NVTWTOR2) SETS(REXIT,RENTRY)                0746 01570000
*       (IEAPMNIP TYPE=WTOR2,PARAM=RPARM,BUFREL=NO,MOD=NIPM);      0746 01571000
         IEAPMNIP TYPE=WTOR2,PARAM=RPARM,BUFREL=NO,MOD=NIPM             01572000
*   RHOLD=RPARM;                    /* SAVE PTR TO OPERATOR REPLY    */ 01573000
         ST    RPARM,RHOLD                                         0747 01574000
*   RNEXTSPE=ADDR(NVTSPE);          /* OBTAIN PTR TO SYSTEM-PARAM  0748 01575000
*                                      ELEMENT (SPE) IN THE NVT      */ 01576000
*                                                                  0748 01577000
         LA    @00,NVTSPE                                          0748 01578000
         ST    @00,RNEXTSPE                                        0748 01579000
*   /*****************************************************************/ 01580000
*   /*                                                               */ 01581000
*   /* CHECK FOR NO ELEMENTS ON THE SPE QUEUE                        */ 01582000
*   /*                                                               */ 01583000
*   /*****************************************************************/ 01584000
*                                                                  0749 01585000
*   IF RNEXTSPE->NIPSPEA=0          /* IF NO DATA PTR IN THE NVT     */ 01586000
*     THEN                          /* SET REQUIRED 8 BYTES TO NIP   */ 01587000
         LR    @15,@00                                             0749 01588000
         L     @15,NIPSPEA(,@15)                                   0749 01589000
         LTR   @15,@15                                             0749 01590000
         BNZ   @RF00749                                            0749 01591000
*     DO;                           /* SPE QUEUE.                    */ 01592000
*       RNEXTSPE->NIPSPEA=RPARM;    /* PUT REPLY ADDR IN ADDRESS     */ 01593000
         LR    @15,@00                                             0751 01594000
         ST    RPARM,NIPSPEA(,@15)                                 0751 01595000
*       GO TO NP1SCAN;              /* BRANCH TO REPLY SCAN RTN      */ 01596000
         B     NP1SCAN                                             0752 01597000
*     END;                                                         0753 01598000
*                                                                  0753 01599000
*   /*****************************************************************/ 01600000
*   /*                                                               */ 01601000
*   /* ISSUE GETMAIN FOR 8 BYTE SPE                                  */ 01602000
*   /*                                                               */ 01603000
*   /*****************************************************************/ 01604000
*                                                                  0754 01605000
*   GEN( GETMAIN EU,LV=8,A=SPEBUF,SP=245);                         0754 01606000
@RF00749 DS    0H                                                  0754 01607000
          GETMAIN EU,LV=8,A=SPEBUF,SP=245                               01608000
*NP1SPEL:                           /* CHECK FOR A NIPSPE QUEUE    0755 01609000
*                                      ELEMENT WITH NO FORWARD PTR   */ 01610000
*   IF RNEXTSPE->NIPSPEQ^=0         /* LAST ELEMENT OF CHAIN?        */ 01611000
*     THEN                          /* IF NOT -                      */ 01612000
NP1SPEL  L     @15,RNEXTSPE                                        0755 01613000
         L     @15,NIPSPEQ(,@15)                                   0755 01614000
         LTR   @15,@15                                             0755 01615000
         BZ    @RF00755                                            0755 01616000
*     DO;                           /* CHAIN TO LAST                 */ 01617000
*       RNEXTSPE=RNEXTSPE->NIPSPEQ; /* SET PTR TO NEXT               */ 01618000
         ST    @15,RNEXTSPE                                        0757 01619000
*       GO TO NP1SPEL;              /* CONTINUE CHAIN TO LAST        */ 01620000
         B     NP1SPEL                                             0758 01621000
*     END;                                                         0759 01622000
*   RNEXTSPE->NIPSPEQ=SPEBUF;       /* SET CHAIN PTR TO NEW ELEMNT   */ 01623000
@RF00755 L     @15,SPEBUF                                          0760 01624000
         L     @14,RNEXTSPE                                        0760 01625000
         ST    @15,NIPSPEQ(,@14)                                   0760 01626000
*   RNEXTSPE=SPEBUF;                /* SET PTR TO NEW ELEMENT        */ 01627000
         ST    @15,RNEXTSPE                                        0761 01628000
*   RNEXTSPE->NIPSPEQ=0;            /* ZERO CHAIN PTR IN NEW ELMNT   */ 01629000
         SLR   @00,@00                                             0762 01630000
         ST    @00,NIPSPEQ(,@15)                                   0762 01631000
*   RNEXTSPE->NIPSPEA=RHOLD;        /* SET PARAMETER PTR TO OPERATORS   01632000
*                                      REPLY.                        */ 01633000
*                                                                  0763 01634000
         L     @00,RHOLD                                           0763 01635000
         ST    @00,NIPSPEA(,@15)                                   0763 01636000
*   /*****************************************************************/ 01637000
*   /*                                                               */ 01638000
*   /* CHECK FOR END OF LINE INDICATION                              */ 01639000
*   /*                                                               */ 01640000
*   /*****************************************************************/ 01641000
*                                                                  0764 01642000
*NP1SCAN:                                                          0764 01643000
*   IF OPREPLY1=QUOTE               /* IS THIS A QUOTE               */ 01644000
*     THEN                          /* IF SO -                       */ 01645000
NP1SCAN  L     @15,RHOLD                                           0764 01646000
         CLC   OPREPLY1(1,@15),QUOTE                               0764 01647000
         BE    @RT00764                                            0764 01648000
*     GO TO OPIOCXIT;               /* DONE, EXIT THIS ROUTINE       */ 01649000
*                                                                  0765 01650000
*   /*****************************************************************/ 01651000
*   /*                                                               */ 01652000
*   /* IF NEXT CHARACTER IS BLANK OR COMMA, SEE IF CONT FOLLOWS      */ 01653000
*   /*                                                               */ 01654000
*   /*****************************************************************/ 01655000
*                                                                  0766 01656000
*   IF OPREPLY1=' 'OPREPLY1=',' THEN                              0766 01657000
         CLI   OPREPLY1(@15),C' '                                  0766 01658000
         BE    @RT00766                                            0766 01659000
         CLI   OPREPLY1(@15),C','                                  0766 01660000
         BNE   @RF00766                                            0766 01661000
@RT00766 DS    0H                                                  0767 01662000
*     DO;                                                          0767 01663000
*       RHOLD=RHOLD+'0001'X;                                       0768 01664000
*                                                                  0768 01665000
         LA    @00,1                                               0768 01666000
         AL    @00,RHOLD                                           0768 01667000
         ST    @00,RHOLD                                           0768 01668000
*       /*************************************************************/ 01669000
*       /*                                                           */ 01670000
*       /* CHECK FOR CONTINUATION OF PARAMETERS- CONT                */ 01671000
*       /*                                                           */ 01672000
*       /*************************************************************/ 01673000
*                                                                  0769 01674000
*       IF OPREPLY1=CONTCHAR        /* IS THIS CONT OF PARAMETERS    */ 01675000
*         THEN                      /* IF SO -                       */ 01676000
         LR    @15,@00                                             0769 01677000
         CLC   OPREPLY1(5,@15),CONTCHAR                            0769 01678000
         BNE   @RF00769                                            0769 01679000
*         DO;                       /* SETUP FOR MORE PARAMETERS     */ 01680000
*           RPARM=ADDR(LIST2);      /* SET PARM INTERFACE REG TO   0771 01681000
*                                      ADDR. OF PARAMETER LIST       */ 01682000
         LA    RPARM,LIST2                                         0771 01683000
*           WTORPTR=RPARM;          /* SAVE CURRENT LIST POINTER     */ 01684000
*                                                                  0772 01685000
         ST    RPARM,WTORPTR                                       0772 01686000
*           /*********************************************************/ 01687000
*           /*                                                       */ 01688000
*           /* CALL THE NIP WTOR SERVICE ROUTINE                     */ 01689000
*           /*                                                       */ 01690000
*           /*********************************************************/ 01691000
*                                                                  0773 01692000
*           GENERATE REFS(RNVT,NVTWTOR,LIST2) SETS(REXIT,RENTRY)   0773 01693000
*               (IEAPMNIP TYPE=WTOR,PARAM=LIST2,MOD=NIPM);         0773 01694000
         IEAPMNIP TYPE=WTOR,PARAM=LIST2,MOD=NIPM                        01695000
*           GO TO OPIOCENT;         /* GO PROCESS NEW REPLY          */ 01696000
         B     OPIOCENT                                            0774 01697000
*         END;                                                     0775 01698000
*       ELSE                        /* NOT CONT AND NOT A QUOTE.   0776 01699000
*                                      UPDATE SCAN POINTER TO RE-DO     01700000
*                                      SCAN CHECK.                   */ 01701000
*         GO TO NP1SCAN;            /* BRANCH TO SCAN CYCLE          */ 01702000
*     END;                                                         0777 01703000
*   ELSE                                                           0778 01704000
*     DO;                                                          0778 01705000
@RF00766 DS    0H                                                  0779 01706000
*       RHOLD=RHOLD+'0001'X;        /* UPDATE SCAN POINTER           */ 01707000
         LA    @00,1                                               0779 01708000
         AL    @00,RHOLD                                           0779 01709000
         ST    @00,RHOLD                                           0779 01710000
*       GO TO NP1SCAN;              /* BRANCH TO SCAN CYCLE          */ 01711000
         B     NP1SCAN                                             0780 01712000
*     END;                                                         0781 01713000
*OPIOCXIT:                          /* EXIT PROCESSING               */ 01714000
*   GEN(LM RNVT,RPARM,OPIOCSAV);    /* RESTORE REGISTERS             */ 01715000
OPIOCXIT LM RNVT,RPARM,OPIOCSAV                                         01716000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 01717000
         BR REXIT                                                       01718000
*OPIOCSAV:                                                         0784 01719000
*   GEN(DS 16F);                    /* LOCAL SAVEAREA                */ 01720000
OPIOCSAV DS 16F                                                         01721000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 01722000
*    (RPARM,                        /* PARAMETER REGISTER            */ 01723000
*     RNVT,                         /* NVT PTR                       */ 01724000
*     RCVT) UNRESTRICTED;           /* CVT PTR                       */ 01725000
*   END NIPOPIOC;                   /* END OF NIPOPIOC PROCEDURE     */ 01726000
@EL00005 DS    0H                                                  0786 01727000
@EF00005 DS    0H                                                  0786 01728000
@ER00005 BR    @14                                                 0786 01729000
*                                                                  0787 01730000
*   /*****************************************************************/ 01731000
*   /*                                                               */ 01732000
*   /* THIS ROUTINE ESTABLISHES LINKAGE TO THE NIP PROMPT ROUTINE,   */ 01733000
*   /* IEAVNP03. IT LOADS THE PROMPT MODULE, GIVES IT CONTROL, AND   */ 01734000
*   /* DELETES IT WHEN IT HAS COMPLETED. IT THEN RETURNS CONTROL TO  */ 01735000
*   /* THE CALLER OF NIPPRMPT WITH THE CONTENTS OF RPARM (REG 1) AS  */ 01736000
*   /* IT WAS LEFT BY IEAVNP03.                                      */ 01737000
*   /*                                                               */ 01738000
*   /*****************************************************************/ 01739000
*                                                                  0787 01740000
*NIPPRMPT:                          /* NIPPRMPT ROUTINE ENTRY        */ 01741000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0787 01742000
NIPPRMPT DS    0H                                                  0788 01743000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 01744000
*    (RPARM,                        /* PARAMETER REGISTER            */ 01745000
*     RNVT,                         /* POINTER TO NVT                */ 01746000
*     RCVT,                         /* POINTER TO CVT                */ 01747000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 01748000
*   GEN(NIPMENTR PRMPTSAV,NIPPRMPT);/* ENTRY LINKAGE                 */ 01749000
         NIPMENTR PRMPTSAV,NIPPRMPT                                     01750000
*   GEN(LA   RSAVE,PRMPTTEM);       /* SETUP LOCAL SAVE AREA         */ 01751000
         LA   RSAVE,PRMPTTEM                                            01752000
*   RNIPM=RPARM;                    /* SAVE PARAMETER REGISTER       */ 01753000
         LR    RNIPM,RPARM                                         0791 01754000
*   RPARM=ADDR(NPRMPTRT);           /* GET ADDR OF NAME OF PROMPT  0792 01755000
*                                      MODULE, IEAVNP03.             */ 01756000
         LA    RPARM,NPRMPTRT                                      0792 01757000
*   RENTRY=NVTLOAD;                 /* ADDRESS OF LOAD ROUTINE       */ 01758000
         L     RENTRY,NVTLOAD                                      0793 01759000
*   GEN(BALR REXIT,RENTRY);         /* GO LOAD THE MODULE            */ 01760000
         BALR REXIT,RENTRY                                              01761000
*   RENTRY=RPARM;                   /* MOVE ADDR OF IEAVNP03         */ 01762000
         LR    RENTRY,RPARM                                        0795 01763000
*   RPARM=RNIPM;                    /* RESTORE PARAMETER REG         */ 01764000
         LR    RPARM,RNIPM                                         0796 01765000
*   GEN(BALR REXIT,RENTRY);         /* CALL NIP PROMPT MODULE        */ 01766000
         BALR REXIT,RENTRY                                              01767000
*   GEN(DELETE DE=NPRMPTRT);        /* DELETE THE MODULE             */ 01768000
         DELETE DE=NPRMPTRT                                             01769000
*   GEN(LM   RNVT,RZERO,PRMPTSAV);  /* RESTORE REGS EXCEPT 1         */ 01770000
         LM   RNVT,RZERO,PRMPTSAV                                       01771000
*   GEN(BR   REXIT);                /* RETURN TO CALLER              */ 01772000
         BR   REXIT                                                     01773000
*PRMPTSAV:                                                         0801 01774000
*   GEN(DS   16F);                  /* SAVE AREA - LOCAL             */ 01775000
PRMPTSAV DS   16F                                                       01776000
*PRMPTTEM:                                                         0802 01777000
*   GEN(DS   18F);                  /* LOCAL SAVEAREA FOR PROMPT     */ 01778000
PRMPTTEM DS   18F                                                       01779000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 01780000
*    (RPARM,                                                       0803 01781000
*     RNVT,                                                        0803 01782000
*     RCVT,                                                        0803 01783000
*     RNIPM) UNRESTRICTED;          /* REGISTERS UNRESTRICTED        */ 01784000
*   END NIPPRMPT;                   /* END OF NIPPRMPT               */ 01785000
@EL00006 DS    0H                                                  0804 01786000
@EF00006 DS    0H                                                  0804 01787000
@ER00006 BR    @14                                                 0804 01788000
*                                                                  0805 01789000
*   /*****************************************************************/ 01790000
*   /*                                                               */ 01791000
*   /* ALLOCATE PAGE FRAME TABLE. SPACE FOR THE PAGE FRAME TABLE IS  */ 01792000
*   /* ALLOCATED FROM THE NEXT AVAILABLE SPACE IN THE NUCLEUS BUFFER.*/ 01793000
*   /* THE SPACE REQUIRED TO DESCRIBE THE PAGES FROM THE START OF THE*/ 01794000
*   /* PFT TO THE END OF STORAGE IS CALUCULATED, AND THEN            */ 01795000
*   /* RECALCULATED EXCLUDING THE SPACE REQUIRED FOR THE PFT ITSELF. */ 01796000
*   /*                                                               */ 01797000
*   /*****************************************************************/ 01798000
*                                                                  0805 01799000
*NPMPFTBL:                          /* PFT BUILD ROUTINE START       */ 01800000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0805 01801000
NPMPFTBL DS    0H                                                  0806 01802000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 01803000
*    (RPARM,                        /* REG 1 IS A WORK REGISTER      */ 01804000
*     RNVT,                         /* REG 2 POINTS TO NVT           */ 01805000
*     RCVT,                         /* REG 3 POINTS TO CVT           */ 01806000
*     PFTEPTR2,                     /* REG 4 IS A WORK REGISTER      */ 01807000
*     PFTEPTR,                      /* REG 5 IS BASE FOR PFTE        */ 01808000
*     RWRK1,                        /* REG 6 IS A WORK REGISTER      */ 01809000
*     RWRK4) RESTRICTED;            /* REG 7 IS A WORK REGISTER      */ 01810000
*   GEN(NIPMENTR PFTBLSAV,NPMPFTBL);/* ENTRY PROCESSING              */ 01811000
*                                                                  0807 01812000
         NIPMENTR PFTBLSAV,NPMPFTBL                                     01813000
*   /*****************************************************************/ 01814000
*   /*                                                               */ 01815000
*   /* BEGIN PFT AT FIRST 16 BYTE BOUNDARY IN NUCLEUS BUFFER         */ 01816000
*   /*                                                               */ 01817000
*   /*****************************************************************/ 01818000
*                                                                  0808 01819000
*   PFTEPTR=((NVTNUCND+15)15)&&15;                                0808 01820000
*                                                                  0808 01821000
         LA    @15,15                                              0808 01822000
         L     PFTEPTR,NVTNUCND                                    0808 01823000
         ALR   PFTEPTR,@15                                         0808 01824000
         OR    PFTEPTR,@15                                         0808 01825000
         XR    PFTEPTR,@15                                         0808 01826000
*   /*****************************************************************/ 01827000
*   /*                                                               */ 01828000
*   /* 1ST CALCULATION: FIND SIZE OF PFT TO DESCRIBE START OF PFT TO */ 01829000
*   /* END OF STORAGE.                                               */ 01830000
*   /*                                                               */ 01831000
*   /*****************************************************************/ 01832000
*                                                                  0809 01833000
*   RPFTAR=CVTEORM-PFTEPTR;         /* NUMBER OF BYTES               */ 01834000
*                                                                  0809 01835000
         L     @15,CVTPTR                                          0809 01836000
         L     RPFTAR,CVTEORM(,@15)                                0809 01837000
         SLR   RPFTAR,PFTEPTR                                      0809 01838000
*   /*****************************************************************/ 01839000
*   /*                                                               */ 01840000
*   /* ROUND THE NUMBER OF BYTES UP TO A PAGE BOUNDARY               */ 01841000
*   /*                                                               */ 01842000
*   /*****************************************************************/ 01843000
*                                                                  0810 01844000
*   RPFTAR=((RPFTAR+4095)4095)&&4095;                             0810 01845000
*                                                                  0810 01846000
         LA    @15,4095                                            0810 01847000
         LR    @00,RPFTAR                                          0810 01848000
         ALR   @00,@15                                             0810 01849000
         OR    @00,@15                                             0810 01850000
         XR    @00,@15                                             0810 01851000
         LR    RPFTAR,@00                                          0810 01852000
*   /*****************************************************************/ 01853000
*   /*                                                               */ 01854000
*   /* FIND THE SIZE FROM END OF PFT TO END OF STORAGE               */ 01855000
*   /*                                                               */ 01856000
*   /*****************************************************************/ 01857000
*                                                                  0811 01858000
*   RPFTAR=RPFTAR                   /* SIZE = 1ST SIZE MINUS         */ 01859000
*       -(RPFTAR/4096)*LENGTH(PFTE);/* SIZE OF PFT                   */ 01860000
*                                                                  0811 01861000
         LR    @00,RPFTAR                                          0811 01862000
         SRL   @00,12                                              0811 01863000
         SLA   @00,4                                               0811 01864000
         SLR   RPFTAR,@00                                          0811 01865000
*   /*****************************************************************/ 01866000
*   /*                                                               */ 01867000
*   /* 2ND CALCULATION: FIND TRUE SIZE OF PFT ( END OF PFT TO END OF */ 01868000
*   /* STORAGE). UPDATE NUCLEUS BUFFER POINTER                       */ 01869000
*   /*                                                               */ 01870000
*   /*****************************************************************/ 01871000
*                                                                  0812 01872000
*   RPFTAR=((RPFTAR+4095)4095)&&4095;                             0812 01873000
         LR    @00,RPFTAR                                          0812 01874000
         ALR   @00,@15                                             0812 01875000
         OR    @00,@15                                             0812 01876000
         XR    @00,@15                                             0812 01877000
         LR    RPFTAR,@00                                          0812 01878000
*   NVTNUCND=PFTEPTR+(RPFTAR/4096)*LENGTH(PFTE);                   0813 01879000
         LR    @00,RPFTAR                                          0813 01880000
         SRL   @00,12                                              0813 01881000
         SLA   @00,4                                               0813 01882000
         ALR   @00,PFTEPTR                                         0813 01883000
         ST    @00,NVTNUCND                                        0813 01884000
*   NVTNUCND=NVTNUCND+16;           /* NUCLEUS DUMMY PFTE.   @G559P2L*/ 01885000
         AL    @00,@CF00081                                        0814 01886000
         ST    @00,NVTNUCND                                        0814 01887000
*   NPMPFTAD=PFTEPTR;               /* SAVE PFT BASE POINTER         */ 01888000
*                                                                  0815 01889000
         ST    PFTEPTR,NPMPFTAD                                    0815 01890000
*   /*****************************************************************/ 01891000
*   /*                                                               */ 01892000
*   /* DETERMINE IF SPACE EXISTS IN NUCLEUS BUFFER TO HOLD THE PFT.  */ 01893000
*   /* IF NOT, WRITE MESSAGE TO OPERATOR AND CALL NIPSWAIT ROUTINE TO*/ 01894000
*   /* PUT SYSTEM INTO WAIT STATE.                                   */ 01895000
*   /*                                                               */ 01896000
*   /*****************************************************************/ 01897000
*                                                                  0816 01898000
*   IF NVTNUCND>NVTNBFND            /* ENOUGH SPACE?                 */ 01899000
*     THEN                          /* IF NOT -                      */ 01900000
         C     @00,NVTNBFND                                        0816 01901000
         BNH   @RF00816                                            0816 01902000
*     DO;                                                          0817 01903000
*       GENERATE REFS(NVTWTO) SETS(RPARM,REXIT,RENTRY)             0818 01904000
*           (IEAPMNIP TYPE=WTO,PARAM=IEA340I,MOD=NIPM);            0818 01905000
*                                                                  0818 01906000
         IEAPMNIP TYPE=WTO,PARAM=IEA340I,MOD=NIPM                       01907000
*       /*************************************************************/ 01908000
*       /*                                                           */ 01909000
*       /* NOW SET WAIT STATE CODE AND LOAD DISABLED WAIT            */ 01910000
*       /*                                                           */ 01911000
*       /*************************************************************/ 01912000
*                                                                  0819 01913000
*       NVTFLWSC=NVTFLWRS;          /* SET WAIT STATE CODE           */ 01914000
         MVI   NVTFLWSC,X'38'                                      0819 01915000
*       GENERATE REFS(NVTSWAIT) SETS(REXIT,RENTRY)                 0820 01916000
*           (IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* PUT SYSTEM IN WAIT   0820 01917000
*                                      STATE                         */ 01918000
         IEAPMNIP TYPE=SWAIT,MOD=NIPM                                   01919000
*     END;                                                         0821 01920000
*   RPFTAR=NVTNUCND-PFTEPTR;        /* GET SIZE OF PFT               */ 01921000
*                                                                  0822 01922000
@RF00816 L     RPFTAR,NVTNUCND                                     0822 01923000
         SLR   RPFTAR,PFTEPTR                                      0822 01924000
*   /*****************************************************************/ 01925000
*   /*                                                               */ 01926000
*   /* ZERO OUT THE PFT AREA                                         */ 01927000
*   /*                                                               */ 01928000
*   /*****************************************************************/ 01929000
*                                                                  0823 01930000
*   DO RPFTAR=RPFTAR TO 1 BY-1;     /* ZERO ONE BYTE AT A TIME       */ 01931000
         B     @DE00823                                            0823 01932000
@DL00823 DS    0H                                                  0824 01933000
*     PFT(RPFTAR)='00'X;            /* SET BYTE TO ZERO              */ 01934000
         LR    @15,PFTEPTR                                         0824 01935000
         ALR   @15,RPFTAR                                          0824 01936000
         BCTR  @15,0                                               0824 01937000
         MVI   PFT(@15),X'00'                                      0824 01938000
*   END;                                                           0825 01939000
*                                                                  0825 01940000
         BCTR  RPFTAR,0                                            0825 01941000
@DE00823 LTR   RPFTAR,RPFTAR                                       0825 01942000
         BP    @DL00823                                            0825 01943000
*   /*****************************************************************/ 01944000
*   /*                                                               */ 01945000
*   /* BUILD PAGE FRAME TABLE. THE PFT IS BUILT IN THE REGION        */ 01946000
*   /* ALLOCATED FROM THE NUCLEUS BUFFER. THE INITIAL PFT BUILT BY   */ 01947000
*   /* IEAVNIP0 CONTAINS PAGE ENTRIES FOR THE SQA PAGES AND MUST BE  */ 01948000
*   /* MOVED INTO THE PERMANENT PFT BEING CONSTRUCTED. THE NIP       */ 01949000
*   /* STORAGE MAP IS USED TO FIND OFFLINE STORAGE SO THAT THE PFTES */ 01950000
*   /* FOR THOSE FRAMES CAN BE MARKED AS OFFLINE. THE RESERVED PAGE  */ 01951000
*   /* FRAMES ARE NOW MADE AVAILABLE ON THE AVAILABLE PAGE FRAME     */ 01952000
*   /* QUEUE, AND THE PAGES OCCUPIED BY NIP ARE MARKED AS V=R        */ 01953000
*   /* ALLOCATED.                                                    */ 01954000
*   /*                                                               */ 01955000
*   /*****************************************************************/ 01956000
*                                                                  0826 01957000
*   RPARM=ADDR(NPLOCKSV);           /* GET ADDR OF A TEMP SAVEAREA   */ 01958000
         LA    RPARM,NPLOCKSV                                      0826 01959000
*   GENERATE REFS(NPLOCKSV,PSALITA,FLC);                           0827 01960000
*                                                /*GET SALLOC LOCK   */ 01961000
          STM 0,15,0(RPARM)             /*SAVE REGISTERS             */ 01962000
NPBPFTGL  SETLOCK OBTAIN,TYPE=SALLOC,MODE=UNCOND,                      *01963000
               RELATED=(RSM,IEAVNIPM(NPBPFTFL))                         01964000
          LM  0,15,0(RPARM)             RESTORE REGISTERS               01965000
*   PVTPTR=CVTPVTP;                 /* GET PVT BASE POINTER          */ 01966000
         L     @15,CVTPTR                                          0828 01967000
         L     @00,CVTPVTP(,@15)                                   0828 01968000
         ST    @00,PVTPTR                                          0828 01969000
*   RWRK1=(NVTSQANO+NVTLSQNO)*LENGTH(PFTE);/* SIZE OF PFTE'S         */ 01970000
         LH    RWRK1,NVTSQANO                                      0829 01971000
         AH    RWRK1,NVTLSQNO                                      0829 01972000
         SLA   RWRK1,4                                             0829 01973000
*   RINDX1=PVTLPFN-RWRK1+LENGTH(PFTE);/* INDEX OF FIRST SQA PAGE PFTE*/ 01974000
         LR    @15,@00                                             0830 01975000
         LH    RINDX1,PVTLPFN(,@15)                                0830 01976000
         N     RINDX1,@CF05060                                     0830 01977000
         SLR   RINDX1,RWRK1                                        0830 01978000
         AL    RINDX1,@CF00081                                     0830 01979000
*   PFTEPTR=NPMPFTAD;               /* LOAD PFT BEGIN ADDRESS        */ 01980000
*                                                                  0831 01981000
         L     PFTEPTR,NPMPFTAD                                    0831 01982000
*   /*****************************************************************/ 01983000
*   /*                                                               */ 01984000
*   /* CALCULATE FIRST PFTE INDEX                                    */ 01985000
*   /*                                                               */ 01986000
*   /*****************************************************************/ 01987000
*                                                                  0832 01988000
*   RWRK4=NVTNUCND;                 /* LOAD ADDRESS FOR 1ST PFTE     */ 01989000
         L     RWRK4,NVTNUCND                                      0832 01990000
*   GEN(SRL RWRK4,12);              /* SHIFT TO FORM PAGE FRAME NO   */ 01991000
         SRL RWRK4,12                                                   01992000
*   PFNSAVE=RWRK4;                  /* TO UPDATE ONLINE FRAME COUNT,    01993000
*                                      SAVE PAGE FRAME NUMBER FOR  0834 01994000
*                                      NPMVRREG ROUNTINE      YM06075*/ 01995000
         ST    RWRK4,PFNSAVE                                       0834 01996000
*   GEN(SLL RWRK4,4);               /* SHIFT TO FORM PFT INDEX       */ 01997000
*                                                                  0835 01998000
         SLL RWRK4,4                                                    01999000
*   /*****************************************************************/ 02000000
*   /*                                                               */ 02001000
*   /* POINT TO FIRST SQA PAGE IN NEW PFT                            */ 02002000
*   /*                                                               */ 02003000
*   /*****************************************************************/ 02004000
*                                                                  0836 02005000
*   PFTEPTR=PFTEPTR-RWRK4+RINDX1;   /* NEW SQA PFTE POINTER          */ 02006000
         LR    @00,PFTEPTR                                         0836 02007000
         SLR   @00,RWRK4                                           0836 02008000
         ALR   @00,RINDX1                                          0836 02009000
         LR    PFTEPTR,@00                                         0836 02010000
*   PFTEPTR2=PVTPFTP+RINDX1;        /* OLD SQA PFTE POINTER          */ 02011000
*                                                                  0837 02012000
         LR    PFTEPTR2,RINDX1                                     0837 02013000
         L     @15,PVTPTR                                          0837 02014000
         AL    PFTEPTR2,PVTPFTP(,@15)                              0837 02015000
*   /*****************************************************************/ 02016000
*   /*                                                               */ 02017000
*   /* MOVE SQA PFTES TO THE NEW PAGE FRAME TABLE                    */ 02018000
*   /*                                                               */ 02019000
*   /*****************************************************************/ 02020000
*                                                                  0838 02021000
*   DO WHILE(RWRK1>256);            /* MOVE 256 BYTES                */ 02022000
         B     @DE00838                                            0838 02023000
@DL00838 DS    0H                                                  0839 02024000
*     PFT1(1:256)=PFTEPTR2->PFT1(1:256);                           0839 02025000
         MVC   PFT1(256,PFTEPTR),PFT1(PFTEPTR2)                    0839 02026000
*     RWRK1=RWRK1-256;              /* DECREMENT BYTE COUNTER        */ 02027000
         LA    @15,256                                             0840 02028000
         SLR   RWRK1,@15                                           0840 02029000
*     PFTEPTR=PFTEPTR+256;          /* BUMP PFTE POINTER             */ 02030000
         ALR   PFTEPTR,@15                                         0841 02031000
*     PFTEPTR2=PFTEPTR2+256;        /* BUMP SECOND PFTE PTR          */ 02032000
         ALR   PFTEPTR2,@15                                        0842 02033000
*   END;                                                           0843 02034000
@DE00838 C     RWRK1,@CF01069                                      0843 02035000
         BH    @DL00838                                            0843 02036000
*   PFT1(1:RWRK1)=PFTEPTR2->PFT1(1:RWRK1);                         0844 02037000
         LR    @15,RWRK1                                           0844 02038000
         BCTR  @15,0                                               0844 02039000
         EX    @15,@SM05062                                        0844 02040000
*   PVTFPFN=RWRK4;                  /* RESET 1ST PFTE RBN IN PVT     */ 02041000
         L     @15,PVTPTR                                          0845 02042000
         STH   RWRK4,PVTFPFN(,@15)                                 0845 02043000
*   PVTPFTP=NPMPFTAD-RWRK4;         /* RESET PFT APPARENT ORIGIN     */ 02044000
         L     @00,NPMPFTAD                                        0846 02045000
         SLR   @00,RWRK4                                           0846 02046000
         ST    @00,PVTPFTP(,@15)                                   0846 02047000
*   PFTEPTR2=0;                     /* PREVIOUS AVAIL PFTE = 0       */ 02048000
*                                                                  0847 02049000
         SLR   PFTEPTR2,PFTEPTR2                                   0847 02050000
*   /*****************************************************************/ 02051000
*   /*                                                               */ 02052000
*   /* FIND PAGE FRAME INDEX OF FIRST V=V PAGE                       */ 02053000
*   /*                                                               */ 02054000
*   /*****************************************************************/ 02055000
*                                                                  0848 02056000
*   RWRK4=NVTVVPG1;                 /* 1ST V=V PAGE ADDRESS          */ 02057000
         L     RWRK4,NVTVVPG1                                      0848 02058000
*   GEN(SRL RWRK4,12);              /* SHIFT TO FORM FRAME NUMBER    */ 02059000
         SRL RWRK4,12                                                   02060000
*   GEN(SLL RWRK4,4);               /* SHIFT TO FORM PFTE INDEX      */ 02061000
         SLL RWRK4,4                                                    02062000
*   NPMVVNDX=RWRK4;                 /* RETAIN V=V PAGE INDEX         */ 02063000
*                                                                  0851 02064000
         ST    RWRK4,NPMVVNDX                                      0851 02065000
*   /*****************************************************************/ 02066000
*   /*                                                               */ 02067000
*   /* CALCULATE INDEX OF HIGHEST POSSIBLE PAGE TO USE FOR ENTRY TO  */ 02068000
*   /* THE PAGE BUILD LOOP. ALSO POINT TO BYTE IN STORAGE MAP THAT   */ 02069000
*   /* CORRESPONDS TO THIS PAGE. THIS IS DONE TO CHECK FOR OFFLINE   */ 02070000
*   /* STORAGE EXISTING ON THE TOP END OR IN THE MIDDLE OF REAL      */ 02071000
*   /* ONLINE STORAGE ADDRESS RANGES.                                */ 02072000
*   /*                                                               */ 02073000
*   /*****************************************************************/ 02074000
*                                                                  0852 02075000
*   RINDX1=CVTEORM4095&&4095;      /* ROUND DOWN TO PAGE BNDRY      */ 02076000
         LA    @15,4095                                            0852 02077000
         L     @14,CVTPTR                                          0852 02078000
         L     RINDX1,CVTEORM(,@14)                                0852 02079000
         OR    RINDX1,@15                                          0852 02080000
         XR    RINDX1,@15                                          0852 02081000
*   GEN(SRL RINDX1,12);             /* SHIFT TO GET PAGE FRAME NO.   */ 02082000
         SRL RINDX1,12                                                  02083000
*   RWRK1=NVTSTMAP+RINDX1;          /* OFFSET INTO STORAGE MAP       */ 02084000
         LR    RWRK1,RINDX1                                        0854 02085000
         AL    RWRK1,NVTSTMAP                                      0854 02086000
*   GEN(SLL RINDX1,4);              /* SHIFT TO FORM PAGE INDEX      */ 02087000
         SLL RINDX1,4                                                   02088000
*   PVTLPFN=RINDX1;                 /* SET PVT LAST PAGE INDEX       */ 02089000
         L     @15,PVTPTR                                          0856 02090000
         STH   RINDX1,PVTLPFN(,@15)                                0856 02091000
*   PFTEPTR=PVTPFTP+RINDX1;         /* PTR TO LAST PFTE              */ 02092000
         LR    PFTEPTR,RINDX1                                      0857 02093000
         AL    PFTEPTR,PVTPFTP(,@15)                               0857 02094000
*   RSUCNT=PVTRSUS;                 /* SET UP COUNTER        @YD03005*/ 02095000
         LH    @00,PVTRSUS(,@15)                                   0858 02096000
         N     @00,@CF05060                                        0858 02097000
         ST    @00,RSUCNT                                          0858 02098000
*   GO TO NPMPFTLP;                 /* GO START PFTE BUILD LOOP      */ 02099000
         B     NPMPFTLP                                            0859 02100000
*NPMBPIPG:                          /* PFT BUILD LOOP RE-ENTRY       */ 02101000
*   RINDX1=RINDX1-LENGTH(PFTE);     /* DECREMENT PFTE INDEX          */ 02102000
NPMBPIPG LA    @15,16                                              0860 02103000
         SLR   RINDX1,@15                                          0860 02104000
*   PFTEPTR=PFTEPTR-LENGTH(PFTE);   /* DECREMENT PFTE PTR            */ 02105000
         SLR   PFTEPTR,@15                                         0861 02106000
*   RWRK1=RWRK1-1;                  /* DECREMENT STORAGE MAP PTR     */ 02107000
*                                                                  0862 02108000
         BCTR  RWRK1,0                                             0862 02109000
*   /*****************************************************************/ 02110000
*   /*                                                               */ 02111000
*   /* SEE IF FRAME IS BELOW LAST FRAME MAPPED, AND IF SO WE ARE ALL */ 02112000
*   /* DONE.                                                         */ 02113000
*   /*                                                               */ 02114000
*   /*****************************************************************/ 02115000
*                                                                  0863 02116000
*   IF RINDX1<PVTFPFN               /* IS INDEX LOWER THAN 1ST       */ 02117000
*     THEN                          /* IF SO, ALL DONE               */ 02118000
         L     @15,PVTPTR                                          0863 02119000
         LH    @00,PVTFPFN(,@15)                                   0863 02120000
         N     @00,@CF05060                                        0863 02121000
         CR    RINDX1,@00                                          0863 02122000
         BL    @RT00863                                            0863 02123000
*     GO TO NPMPFTXT;               /* GO DO EXIT PROCESSING         */ 02124000
*   ELSE                                                           0865 02125000
*     ;                                                            0865 02126000
*                                                                  0865 02127000
*   /*****************************************************************/ 02128000
*   /*                                                               */ 02129000
*   /* CHECK CURRENT FRAME BYTE IN STORAGE MAP TO DETERMINE IF IT IS */ 02130000
*   /* OFFLINE STORAGE. IF NOT, CHECK THE PFTE TO SEE IF IT IS ONE   */ 02131000
*   /* SETUP BY IEAVNIP0 (SQA AND LSQA). IF NOT, CHECK PFTE INDEX TO */ 02132000
*   /* SEE IF IT IS BELOW V=R LINE AND IF NOT, QUEUE IT ON AVAILABLE */ 02133000
*   /* FRAME QUEUE.                                                  */ 02134000
*   /*                                                               */ 02135000
*   /*****************************************************************/ 02136000
*                                                                  0866 02137000
*NPMPFTLP:                                                         0866 02138000
*   IF RWRK1->STORMAP1='01'X THEN   /* IF OFFLINE PAGE,              */ 02139000
NPMPFTLP CLI   STORMAP1(RWRK1),X'01'                               0866 02140000
         BNE   @RF00866                                            0866 02141000
*     DO;                           /* SET PFTE OFFLINE FLAG         */ 02142000
*       PFTOFFLN='1'B;              /* PAGE OFFLINE FLAG SET         */ 02143000
         OI    PFTOFFLN(PFTEPTR),B'01000000'                       0868 02144000
*       PFTQNDX=PFTNQN;             /* SET INDEX AS NOT QUEUED       */ 02145000
         MVI   PFTQNDX(PFTEPTR),X'FF'                              0869 02146000
*       GO TO NPMBPIPG;             /* GO TRY NEXT PAGE              */ 02147000
         B     NPMBPIPG                                            0870 02148000
*     END;                                                         0871 02149000
*   IF RSUCNT>0 THEN                /* CNT GREATER THAN 0    @YD03005*/ 02150000
@RF00866 L     @15,RSUCNT                                          0872 02151000
         LTR   @15,@15                                             0872 02152000
         BNP   @RF00872                                            0872 02153000
*     DO;                           /*                       @YD03005*/ 02154000
*       RSUCNT=RSUCNT-1;            /* DECREMENT COUNTER     @YD03005*/ 02155000
         BCTR  @15,0                                               0874 02156000
         ST    @15,RSUCNT                                          0874 02157000
*       PFTPREF='1'B;               /* SET PROTECTED         @YD03005*/ 02158000
         OI    PFTPREF(PFTEPTR),B'00000100'                        0875 02159000
*     END;                          /*                       @YD03005*/ 02160000
*   ELSE                                                           0877 02161000
*     ;                             /*                       @YD03005*/ 02162000
@RF00872 DS    0H                                                  0878 02163000
*   NDYNAMCT=NDYNAMCT+1;            /* KEEP COUNT OF ONLINE FRAMES   */ 02164000
         LH    @15,NDYNAMCT                                        0878 02165000
         LA    @15,1(,@15)                                         0878 02166000
         STH   @15,NDYNAMCT                                        0878 02167000
*   IF PFTASID^='0000'X             /* SEE IF PFTE IS INITIALIZED    */ 02168000
*     THEN                          /* IF SO,                        */ 02169000
         LH    @00,PFTASID(,PFTEPTR)                               0879 02170000
         N     @00,@CF05060                                        0879 02171000
         LTR   @00,@00                                             0879 02172000
         BNZ   @RT00879                                            0879 02173000
*     GO TO NPMBPIPG;               /* GO TRY NEXT PAGE FRAME        */ 02174000
*   IF RINDX1^<NPMVVNDX             /* INDEX LOWER THAN V=R LINE?    */ 02175000
*     THEN                          /* IF NOT, PUT ON AVAILABLE Q    */ 02176000
         C     RINDX1,NPMVVNDX                                     0881 02177000
         BNL   @RT00881                                            0881 02178000
*     GO TO NPMQPFTE;               /* GO TO QUEUEING ROUTINE        */ 02179000
*NPMBPNIP:                          /* PAGE MUST BE IN NIP REGION    */ 02180000
*                                                                  0883 02181000
*   /*****************************************************************/ 02182000
*   /*                                                               */ 02183000
*   /* PUT THE PAGE IN NIP REGION.                                   */ 02184000
*   /*                                                               */ 02185000
*   /*****************************************************************/ 02186000
*                                                                  0883 02187000
*   PFTVBN=RINDX1;                  /* SET VBN IN PFTE - 1 TO 1    0883 02188000
*                                      MAPPING                       */ 02189000
NPMBPNIP STH   RINDX1,PFTVBN(,PFTEPTR)                             0883 02190000
*   PFTASID=NVTMASCB->ASCBASID;     /* PUT IN M.S. ASID              */ 02191000
         L     @15,NVTMASCB                                        0884 02192000
         LH    @00,ASCBASID(,@15)                                  0884 02193000
         N     @00,@CF05060                                        0884 02194000
         STH   @00,PFTASID(,PFTEPTR)                               0884 02195000
*   PFTVRALC='1'B;                  /* SET V=R ALLOCATED FLAG        */ 02196000
         OI    PFTVRALC(PFTEPTR),B'00000010'                       0885 02197000
*   PFTQNDX=PFTNQN;                 /* SET INDEX AS NOT QUEUED       */ 02198000
         MVI   PFTQNDX(PFTEPTR),X'FF'                              0886 02199000
*   GO TO NPMBPIPG;                 /* CONTINUE PFT BUILD            */ 02200000
         B     NPMBPIPG                                            0887 02201000
*NPMQPFTE:                          /* PLACE PFTE ON AVAILABLE Q     */ 02202000
*                                                                  0888 02203000
*   /*****************************************************************/ 02204000
*   /*                                                               */ 02205000
*   /* PLACE THE PFTE ON THE AVAILABLE QUEUE. IF THIS IS THE FIRST   */ 02206000
*   /* TIME ENTERED, PUT A PFTE ON THE SQA RESERVED QUEUE. SET CHAIN */ 02207000
*   /* POINTER AND QUEUE INDEX OF PFTES.                             */ 02208000
*   /*                                                               */ 02209000
*   /*****************************************************************/ 02210000
*                                                                  0888 02211000
*   IF PFTEPTR2=0                   /* PREVIOUS PTR ZERO?            */ 02212000
*     THEN                          /* IF SO,                        */ 02213000
*                                                                  0888 02214000
NPMQPFTE LTR   PFTEPTR2,PFTEPTR2                                   0888 02215000
         BNZ   @RF00888                                            0888 02216000
*     /***************************************************************/ 02217000
*     /*                                                             */ 02218000
*     /*                                                     @Z40WPXA*/ 02219000
*     /* CHECK IF ALL RESERVED FRAMES HAVE BEEN SAVED                */ 02220000
*     /*                                                             */ 02221000
*     /***************************************************************/ 02222000
*                                                                  0889 02223000
*     IF PVTRSRVF='0000'X           /* ANY ON SQA RESERVED QUEUE?    */ 02224000
*       THEN                        /* IF NOT, PUT ONE ON            */ 02225000
         L     @15,PVTPTR                                          0889 02226000
         CLC   PVTRSRVF(2,@15),@CB02240                            0889 02227000
         BNE   @RF00889                                            0889 02228000
*       DO;                                                        0890 02229000
*         PVTRSRVL=RINDX1;          /* LAST ONE ON QUEUE             */ 02230000
         STH   RINDX1,PVTRSRVL(,@15)                               0891 02231000
*         PVTRSRVF=RINDX1;          /* FIRST ONE ON QUEUE            */ 02232000
         STH   RINDX1,PVTRSRVF(,@15)                               0892 02233000
*         PFTQNDX=PFTSRQN;          /* SET QUEUE IDENTIFIER          */ 02234000
         MVI   PFTQNDX(PFTEPTR),X'04'                              0893 02235000
*         GO TO NPMBPIPG;           /* GO GET NEXT PAGE FRAME        */ 02236000
         B     NPMBPIPG                                            0894 02237000
*       END;                                                       0895 02238000
*     ELSE                                                         0896 02239000
*       PVTAFQF=RINDX1;             /* FIRST ON AVAILABLE QUEUE      */ 02240000
@RF00889 L     @15,PVTPTR                                          0896 02241000
         STH   RINDX1,PVTAFQF(,@15)                                0896 02242000
*   ELSE                            /* NOT FIRST ON AVAILABLE Q      */ 02243000
*     DO;                           /* DOUBLE CHAIN TO PREVIOUS      */ 02244000
         B     @RC00888                                            0897 02245000
@RF00888 DS    0H                                                  0898 02246000
*       PFTEPTR2->PFTFQPTR=RINDX1;  /* FOWARD CHAIN                  */ 02247000
         STH   RINDX1,PFTFQPTR(,PFTEPTR2)                          0898 02248000
*       PFTBQPTR=PFTEPTR2-PVTPFTP;  /* BACK CHAIN                    */ 02249000
         LR    @00,PFTEPTR2                                        0899 02250000
         L     @15,PVTPTR                                          0899 02251000
         SL    @00,PVTPFTP(,@15)                                   0899 02252000
         STH   @00,PFTBQPTR(,PFTEPTR)                              0899 02253000
*     END;                                                         0900 02254000
*   PFTONAVQ='1'B;                  /* FLAG AS AVAILABLE QUEUE       */ 02255000
@RC00888 OI    PFTONAVQ(PFTEPTR),B'10000000'                       0901 02256000
*   PFTQNDX=PFTAFQN;                /* SET AVAILABLE QUEUE INDEX     */ 02257000
         MVI   PFTQNDX(PFTEPTR),X'00'                              0902 02258000
*   PFTEPTR2=PFTEPTR;               /* SET CURRENT AS PREVIOUS       */ 02259000
         LR    PFTEPTR2,PFTEPTR                                    0903 02260000
*   PVTAFQL=RINDX1;                 /* LAST ON QUEUE IS CURRENT      */ 02261000
         L     @15,PVTPTR                                          0904 02262000
         STH   RINDX1,PVTAFQL(,@15)                                0904 02263000
*   PVTAFC=PVTAFC+1;                /* INCREMENT AVAILABLE COUNT     */ 02264000
         LA    @00,1                                               0905 02265000
         AH    @00,PVTAFC(,@15)                                    0905 02266000
         STH   @00,PVTAFC(,@15)                                    0905 02267000
*   GO TO NPMBPIPG;                 /* CONTINUE PFT BUILD            */ 02268000
         B     NPMBPIPG                                            0906 02269000
*NPMPFTXT:                          /* EXIT PROCESSING               */ 02270000
*                                                                  0907 02271000
*   /*****************************************************************/ 02272000
*   /*                                                               */ 02273000
*   /* INIT NUCLEUS PAGEOUT DUMMY PFTE                               */ 02274000
*   /*                                                               */ 02275000
*   /*****************************************************************/ 02276000
*                                                                  0907 02277000
*   PFTEPTR=PVTPFTP+PVTLPFN+16;     /* DUMMY PFTE PTR.       @G559P2L*/ 02278000
NPMPFTXT L     @15,PVTPTR                                          0907 02279000
         LH    PFTEPTR,PVTLPFN(,@15)                               0907 02280000
         N     PFTEPTR,@CF05060                                    0907 02281000
         AL    PFTEPTR,PVTPFTP(,@15)                               0907 02282000
         AL    PFTEPTR,@CF00081                                    0907 02283000
*   PFTASID=NVTMASCB->ASCBASID;     /* INIT TO MASTER'S ID   @G559P2L*/ 02284000
         L     @14,NVTMASCB                                        0908 02285000
         LH    @00,ASCBASID(,@14)                                  0908 02286000
         N     @00,@CF05060                                        0908 02287000
         STH   @00,PFTASID(,PFTEPTR)                               0908 02288000
*   PFTVRALC='1'B;                  /* INIT TO V=R ALLOCATED.      0909 02289000
*                                                            @G559P2L*/ 02290000
         OI    PFTVRALC(PFTEPTR),B'00000010'                       0909 02291000
*   PFTQNDX=PFTNQN;                 /* INIT TO NOT ON ANY QUEUE.   0910 02292000
*                                                            @G559P2L*/ 02293000
*                                                                  0910 02294000
         MVI   PFTQNDX(PFTEPTR),X'FF'                              0910 02295000
*   /*****************************************************************/ 02296000
*   /*                                                               */ 02297000
*   /* SET FINAL FIELDS IN PVT NECESSARY TO GET PAGING GOING AND     */ 02298000
*   /* RELEASE THE LOCK.                                             */ 02299000
*   /*                                                               */ 02300000
*   /*****************************************************************/ 02301000
*                                                                  0911 02302000
*   PVTPOOL=NDYNAMCT;               /* DYNAMIC PAGE(ONLINE) COUNT    */ 02303000
*                                                                  0911 02304000
         LH    @00,NDYNAMCT                                        0911 02305000
         STH   @00,PVTPOOL(,@15)                                   0911 02306000
*   /*****************************************************************/ 02307000
*   /*                                                               */ 02308000
*   /* THE FOLLOWING FIELDS, PVTLQSA AND PVTHQSA, ARE SET TO A HIGH  */ 02309000
*   /* VALUE BECAUSE RSM CHECKS THE PVTLQSA AND ASSUMES THAT ALL     */ 02310000
*   /* PAGES ASSIGNED TO VIRTUAL ADDRESSES ABOVE THE VALUE ARE IN THE*/ 02311000
*   /* READ ONLY AREA AND SHOULD NOT BE PAGED OUT. THESE VALUES ARE  */ 02312000
*   /* RESET AFTER IEAVNP05 COMPLETES THE PLPA TO ALLOW PLPA TO BE   */ 02313000
*   /* PAGED OUT (COLD START).                                       */ 02314000
*   /*                                                               */ 02315000
*   /*****************************************************************/ 02316000
*                                                                  0912 02317000
*   PVTLQSA='FFF0'X;                /* SET LPA LOW ADDR HIGH         */ 02318000
         MVC   PVTLQSA(2,@15),@CB04917                             0912 02319000
*   PVTHQSA='FFF0'X;                /* SET LPA HIGH ADDR HIGH        */ 02320000
*                                                                  0913 02321000
         MVC   PVTHQSA(2,@15),@CB04917                             0913 02322000
*   /*****************************************************************/ 02323000
*   /*                                                               */ 02324000
*   /* THE FOLLOWING BLOCK OF CODE SELECTS A NUMBER OF REAL PAGE     */ 02325000
*   /* FRAMES OFF THE FRONT END OF THE AVAILABLE QUEUE AND RESERVES  */ 02326000
*   /* THEM ON THE IEAVNIPM QUEUES, NPMAFQF AND NPMAFQL, WHICH ARE   */ 02327000
*   /* USED TO CONTROL THE ASSIGNMENT OF PAGE FRAMES TO LSQA AND SQA.*/ 02328000
*   /* THE PAGES THAT ARE SELECTED FOR THIS QUEUE ARE THE HIGHEST    */ 02329000
*   /* AVAILABLE PAGE FRAMES IN REAL MEMORY, AND ARE ASSIGNED FROM   */ 02330000
*   /* THE TOP DOWN IN ORDER TO PREVENT POLUTION OF THE POTENTIAL V=R*/ 02331000
*   /* AREA WITH LONG FIXED PAGES.                                   */ 02332000
*   /*                                                               */ 02333000
*   /*****************************************************************/ 02334000
*                                                                  0914 02335000
*   IF PVTAFC/2<NPMLFPGN            /* SEE IF HALF OF AVAILABLE      */ 02336000
*     THEN                          /* PAGE FRAMES IS LESS THAN      */ 02337000
         LA    @14,2                                               0914 02338000
         LH    @15,PVTAFC(,@15)                                    0914 02339000
         LR    @08,@15                                             0914 02340000
         SRDA  @08,32                                              0914 02341000
         DR    @08,@14                                             0914 02342000
         CH    @09,NPMLFPGN                                        0914 02343000
         BNL   @RF00914                                            0914 02344000
*     RWRK1=PVTAFC/2;               /* CONSTANT NUMBER.              */ 02345000
         LR    @08,@15                                             0915 02346000
         SRDA  @08,32                                              0915 02347000
         DR    @08,@14                                             0915 02348000
         LR    RWRK1,@09                                           0915 02349000
*   ELSE                            /* IF NOT, SELECT THE ASSIGNED   */ 02350000
*     RWRK1=NPMLFPGN;               /* CONSTANT NUMBER TO RESERVE.   */ 02351000
         B     @RC00914                                            0916 02352000
@RF00914 LH    RWRK1,NPMLFPGN                                      0916 02353000
*   NPMAFC=RWRK1;                   /* SET AVAILABLE CNT IN NIPM.    */ 02354000
@RC00914 STH   RWRK1,NPMAFC                                        0917 02355000
*   PVTAFC=PVTAFC-RWRK1;            /* DECREMENT REAL AVAIL. CNT.    */ 02356000
         L     @15,PVTPTR                                          0918 02357000
         LH    @00,PVTAFC(,@15)                                    0918 02358000
         SLR   @00,RWRK1                                           0918 02359000
         STH   @00,PVTAFC(,@15)                                    0918 02360000
*   PFTEPTR=PVTPFTP+PVTAFQF;        /* ADDR OF FIRST PFTE ON Q       */ 02361000
         LH    PFTEPTR,PVTAFQF(,@15)                               0919 02362000
         N     PFTEPTR,@CF05060                                    0919 02363000
         AL    PFTEPTR,PVTPFTP(,@15)                               0919 02364000
*   DO I=RWRK1 BY-1 TO 1;           /* FIND PFTE'S TO STEAL          */ 02365000
         LR    @00,RWRK1                                           0920 02366000
         ST    @00,I                                               0920 02367000
         B     @DE00920                                            0920 02368000
@DL00920 DS    0H                                                  0921 02369000
*     PFTEPTR=PVTPFTP+PFTFQPTR;     /* GET ADDR OF NEXT PFTE         */ 02370000
         LH    @15,PFTFQPTR(,PFTEPTR)                              0921 02371000
         N     @15,@CF05060                                        0921 02372000
         L     @14,PVTPTR                                          0921 02373000
         AL    @15,PVTPFTP(,@14)                                   0921 02374000
         LR    PFTEPTR,@15                                         0921 02375000
*   END;                            /* SEARCH ALL DONE               */ 02376000
         BCTR  @00,0                                               0922 02377000
         ST    @00,I                                               0922 02378000
@DE00920 LTR   @00,@00                                             0922 02379000
         BP    @DL00920                                            0922 02380000
*   NPMAFQF=PVTAFQF;                /* SAVE INDEX OF 1ST PFTE        */ 02381000
         L     @15,PVTPTR                                          0923 02382000
         MVC   NPMAFQF(2),PVTAFQF(@15)                             0923 02383000
*   PFTEPTR2=PVTPFTP+PFTBQPTR;      /* ADDR OF LAST PFTE       STOLEN*/ 02384000
         LH    PFTEPTR2,PFTBQPTR(,PFTEPTR)                         0924 02385000
         N     PFTEPTR2,@CF05060                                   0924 02386000
         AL    PFTEPTR2,PVTPFTP(,@15)                              0924 02387000
*   PVTAFQF=PFTEPTR2->PFTFQPTR;     /* REMOVE FROM RSM QUEUES        */ 02388000
         MVC   PVTAFQF(2,@15),PFTFQPTR(PFTEPTR2)                   0925 02389000
*   PFTEPTR2->PFTFQPTR=0;           /* UNHOOK SELECTED PFTES         */ 02390000
         SLR   @14,@14                                             0926 02391000
         STH   @14,PFTFQPTR(,PFTEPTR2)                             0926 02392000
*   NPMAFQL=PFTBQPTR;               /* SET LAST PFTE INDEX (NIPM)    */ 02393000
         MVC   NPMAFQL(2),PFTBQPTR(PFTEPTR)                        0927 02394000
*   PFTBQPTR=0;                     /* ZERO BACK CHAIN TO PFTES    0928 02395000
*                                      STOLEN FOR USE BY NIPM.       */ 02396000
         STH   @14,PFTBQPTR(,PFTEPTR)                              0928 02397000
*   PVTPSQA=ADDR(NPMSQBCK);         /* SET TRAP TO INTERCEPT LSQA SQA   02398000
*                                      PAGE BACKING REQUESTS.        */ 02399000
         LA    @00,NPMSQBCK                                        0929 02400000
         ST    @00,PVTPSQA(,@15)                                   0929 02401000
*   PVTLPRIV=NPMVVNDX;              /* SET START OF PRIVATE AREA   0930 02402000
*                                      EQUAL TO FIRST V=V PAGE       */ 02403000
         L     @14,NPMVVNDX                                        0930 02404000
         STH   @14,PVTLPRIV(,@15)                                  0930 02405000
*   PVTFVR=PVTFPFN;                 /* SET FIRST V=R EQUAL TO FIRST     02406000
*                                      PFTER INDEX.                  */ 02407000
         MVC   PVTFVR(2,@15),PVTFPFN(@15)                          0931 02408000
*   PVTLVR=NPMVVNDX-LENGTH(PFTE);   /* SET LAST V=R EQUAL TO HIGH NIP   02409000
*                                      PAGE INDEX                    */ 02410000
         SL    @14,@CF00081                                        0932 02411000
         STH   @14,PVTLVR(,@15)                                    0932 02412000
*   PVTLCSA=PVTLPRIV;               /* END OF PRIVATE AREA EQUALS  0933 02413000
*                                      START OF PRIVATE AREA.        */ 02414000
*                                                                  0933 02415000
         MVC   PVTLCSA(2,@15),PVTLPRIV(@15)                        0933 02416000
*   /*****************************************************************/ 02417000
*   /*                                                               */ 02418000
*   /* RELEASE THE SALLOC LOCK                                       */ 02419000
*   /*                                                               */ 02420000
*   /*****************************************************************/ 02421000
*                                                                  0934 02422000
*   RPARM=ADDR(NPLOCKSV);           /* ADDR OF TEMP SAVEAREA         */ 02423000
         LA    RPARM,NPLOCKSV                                      0934 02424000
*   GENERATE REFS(NPLOCKSV,PSALITA,FLC);                           0935 02425000
          STM  0,15,0(RPARM)            SAVE REGISTERS                  02426000
NPBPFTFL  SETLOCK RELEASE,TYPE=SALLOC,RELATED=(RSM,IEAVNIPM(NPBPFTGL))  02427000
          LM   0,15,0(RPARM)            RESTORE REGISTERS               02428000
*   CVTGDA->NIPFOURK='0'B;          /* REMOVE FREE SQA PAGE TRAP - NO   02429000
*                                      INTERFACE TO RSM TO FREE PAGES   02430000
*                                      UNTIL BIT IS TURNED OFF       */ 02431000
         L     @15,CVTPTR                                          0936 02432000
         L     @15,CVTGDA(,@15)                                    0936 02433000
         NI    NIPFOURK(@15),B'11011111'                           0936 02434000
*   RPARM=NVTSTMAP;                 /* GET ADDRESS OF STORAGE MAP    */ 02435000
         L     RPARM,NVTSTMAP                                      0937 02436000
*   GEN(FREEMAIN R,LV=4096,A=(1),SP=252);/* FREE THE MAP             */ 02437000
         FREEMAIN R,LV=4096,A=(1),SP=252                                02438000
*   GEN(LM RNVT,RPARM,PFTBLSAV);    /* RESTORE REGISTERS             */ 02439000
         LM RNVT,RPARM,PFTBLSAV                                         02440000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 02441000
         BR REXIT                                                       02442000
*PFTBLSAV:                          /* SAVE AREA LABEL               */ 02443000
*   GEN(DS 16F);                    /* SAVE AREA                     */ 02444000
PFTBLSAV DS 16F                                                         02445000
*   RESPECIFY                                                      0942 02446000
*    (RPARM,                                                       0942 02447000
*     RNVT,                                                        0942 02448000
*     RCVT,                         /* UNRESTRICT REGISTERS          */ 02449000
*     PFTEPTR2,                                                    0942 02450000
*     PFTEPTR,                                                     0942 02451000
*     RPFTAR,                                                      0942 02452000
*     RWRK1) UNRESTRICTED;                                         0942 02453000
*   END NPMPFTBL;                   /* END OF NPMPFTBL               */ 02454000
@EL00007 DS    0H                                                  0943 02455000
@EF00007 DS    0H                                                  0943 02456000
@ER00007 BR    @14                                                 0943 02457000
*                                                                  0944 02458000
*   /*****************************************************************/ 02459000
*   /*                                                               */ 02460000
*   /* THIS ROUTINE LOADS THE MODULE ILRPREAD WHICH WILL BE USED BY  */ 02461000
*   /* THE ASM RIM IEAVNP04 AND BY THE RSM RIM IEAVNP05.     @Z40WPXA*/ 02462000
*   /*                                                               */ 02463000
*   /*****************************************************************/ 02464000
*                                                                  0944 02465000
*NPMPREP4:                                                         0944 02466000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/*                     @Z40WPXA*/ 02467000
NPMPREP4 DS    0H                                                  0945 02468000
*   RFY                                                            0945 02469000
*    (RPARM,                                                       0945 02470000
*     RNVT,                                                        0945 02471000
*     RCVT,                                                        0945 02472000
*     RNIPM) RSTD;                  /*                       @Z40WPXA*/ 02473000
*   GEN(NIPMENTR  PREP4SAV,NPMPREP4);/*                      @Z40WPXA*/ 02474000
         NIPMENTR  PREP4SAV,NPMPREP4                                    02475000
*   RZERO=ADDR(PREAD);              /* ADDRESS OF NAME       @Z40WPXA*/ 02476000
         LA    RZERO,PREAD                                         0947 02477000
*   RPARM=0;                        /*                       @Z40WPXA*/ 02478000
         SLR   RPARM,RPARM                                         0948 02479000
*   GEN(SVC  8);                    /* LOAD ILRPREAD         @Z40WPXA*/ 02480000
         SVC  8                                                         02481000
*   GEN(LM  RNVT,RPARM,PREP4SAV);   /*                       @Z40WPXA*/ 02482000
         LM  RNVT,RPARM,PREP4SAV                                        02483000
*   GEN(BR  REXIT);                 /*                       @Z40WPXA*/ 02484000
         BR  REXIT                                                      02485000
*PREP4SAV:                                                         0952 02486000
*   GEN(DS  16F);                   /*                       @Z40WPXA*/ 02487000
PREP4SAV DS  16F                                                        02488000
*   RFY                                                            0953 02489000
*    (RPARM,                                                       0953 02490000
*     RNVT,                                                        0953 02491000
*     RCVT,                                                        0953 02492000
*     RNIPM) UNRSTD;                /*                       @Z40WPXA*/ 02493000
*   END NPMPREP4;                   /*                       @Z40WPXA*/ 02494000
@EL00008 DS    0H                                                  0954 02495000
@EF00008 DS    0H                                                  0954 02496000
@ER00008 BR    @14                                                 0954 02497000
*                                                                  0955 02498000
*   /*****************************************************************/ 02499000
*   /*                                                               */ 02500000
*   /* THIS ROUTINE CONSTRUCTS CONTROL BLOCKS FOR THE V=V COMMON AREA*/ 02501000
*   /* REGION, INCLUDING THE PLPA AREA IF IT IS A COLD START.        */ 02502000
*   /*                                                               */ 02503000
*   /*****************************************************************/ 02504000
*                                                                  0955 02505000
*NPMPREP5:                          /* NPMPREP5 SUBROUTINE           */ 02506000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0955 02507000
NPMPREP5 DS    0H                                                  0956 02508000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 02509000
*    (RPARM,                        /* PARAMETER REGISTERS           */ 02510000
*     RNVT,                         /* POINTER TO NVT                */ 02511000
*     RCVT,                         /* POINTER TO CVT                */ 02512000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 02513000
*   GEN(NIPMENTR PREP5SAV,NPMPREP5);/* ENTRY LINKAGE                 */ 02514000
*                                                                  0957 02515000
         NIPMENTR PREP5SAV,NPMPREP5                                     02516000
*   /*****************************************************************/ 02517000
*   /*                                                               */ 02518000
*   /* IF QUICK START, SET UP NVTLVIRT WITH LOW ADDR OF PLPA.        */ 02519000
*   /*                                                               */ 02520000
*   /*****************************************************************/ 02521000
*                                                                  0958 02522000
*   IF NVTFLQS='1'B                 /* IF QUICK START        @Z40WPXA*/ 02523000
*     THEN                          /*                       @Z40WPXA*/ 02524000
         TM    NVTFLQS,B'00001000'                                 0958 02525000
         BNO   @RF00958                                            0958 02526000
*     DO;                           /* DO QS. PROCESSING     @Z40WPXA*/ 02527000
*       NVTLVIRT=NVTLPALO;          /* LOW ADDR OF PLPA      @Z40WPXA*/ 02528000
         L     @06,NVTLPALO                                        0960 02529000
         ST    @06,NVTLVIRT                                        0960 02530000
*     END;                          /*                       @Z40WPXA*/ 02531000
*                                                                  0961 02532000
*   /*****************************************************************/ 02533000
*   /*                                                               */ 02534000
*   /* GET AREA FOR V=V REGION CONTROL BLOCKS AND INITIALIZE THEM TO */ 02535000
*   /* DESCRIBE EVERYTHING ABOVE 8 MEGS, UP TO SQA IF A COLD START,  */ 02536000
*   /* OR UP TO PLPA IF A QUICK START                        @Z40WPXA*/ 02537000
*   /*                                                               */ 02538000
*   /*****************************************************************/ 02539000
*                                                                  0962 02540000
*   NGETLEN=LENGTH(PQESECT)+LENGTH(FBQESECT)+8;/* AREA SIZE          */ 02541000
@RF00958 MVC   NGETLEN(3),@CF03004+1                               0962 02542000
*   RZERO=NGETSIZE;                 /* SETUP FOR GETMAIN-SP 245      */ 02543000
         L     RZERO,NGETSIZE                                      0963 02544000
*   GEN(GETMAIN R,LV=(0));          /* GET AREA FOR CONTROL BLOCKS   */ 02545000
         GETMAIN R,LV=(0)                                               02546000
*   RPARM=RPARM-8;                  /* BACK OFF ADDR FOR DPQE        */ 02547000
         SL    RPARM,@CF00125                                      0965 02548000
*   NVTVPQE=RPARM;                  /* SAVE ADDR OF DPQE FOR REGN    */ 02549000
*                                                                  0966 02550000
         ST    RPARM,NVTVPQE                                       0966 02551000
*   /*****************************************************************/ 02552000
*   /*                                                               */ 02553000
*   /* ZERO THE BACK POINTER                                         */ 02554000
*   /*                                                               */ 02555000
*   /*****************************************************************/ 02556000
*                                                                  0967 02557000
*   RPARM->PQEBPQE=RPARM->PQEBPQE&&RPARM->PQEBPQE;                 0967 02558000
*                                                                  0967 02559000
         L     @06,PQEBPQE(,RPARM)                                 0967 02560000
         LR    @05,@06                                             0967 02561000
         XR    @05,@06                                             0967 02562000
         ST    @05,PQEBPQE(,RPARM)                                 0967 02563000
*   /*****************************************************************/ 02564000
*   /*                                                               */ 02565000
*   /* SET FORWARD CHAIN POINTER IN DPQE                             */ 02566000
*   /*                                                               */ 02567000
*   /*****************************************************************/ 02568000
*                                                                  0968 02569000
*   RPARM->PQEFPQE=RPARM+16;                                       0968 02570000
*                                                                  0968 02571000
         LA    @06,16                                              0968 02572000
         LR    @05,RPARM                                           0968 02573000
         ALR   @05,@06                                             0968 02574000
         ST    @05,PQEFPQE(,RPARM)                                 0968 02575000
*   /*****************************************************************/ 02576000
*   /*                                                               */ 02577000
*   /* ALSO PUT PQE PTR IN LDA TO INSURE THAT GETMAIN/FREEMAIN WILL  */ 02578000
*   /* FIND THE CORRECT PQE FOR THE V=V REGION WHETHER THEY SEARCH   */ 02579000
*   /* FROM THE LDA OR TCBPQE FIELD TO FIND IT. THE PQE POINTER      */ 02580000
*   /* ORIGINALLY SETUP IN LDA IS SAVED AND RESTORED LATER IN THE    */ 02581000
*   /* NPMCLNUP ROUTINE WHICH CLEANS UP AFTER IEAVNP05 HAS BUILT THE */ 02582000
*   /* PLPA.                                                         */ 02583000
*   /*                                                               */ 02584000
*   /*****************************************************************/ 02585000
*                                                                  0969 02586000
*   NLDAPQEA=NVTMASCB->ASCBLDA->ASDPQE;/* SAVE CURRENT PTR           */ 02587000
         L     @15,NVTMASCB                                        0969 02588000
         L     @15,ASCBLDA(,@15)                                   0969 02589000
         L     @00,ASDPQE(,@15)                                    0969 02590000
         ST    @00,NLDAPQEA                                        0969 02591000
*   NVTMASCB->ASCBLDA->ASDPQE=RPARM+16;/* SET PTR TO V=V PQE         */ 02592000
*                                                                  0970 02593000
         ST    @05,ASDPQE(,@15)                                    0970 02594000
*   /*****************************************************************/ 02595000
*   /*                                                               */ 02596000
*   /* BUMP UP BASE TO REAL PQE FOR REGION                           */ 02597000
*   /*                                                               */ 02598000
*   /*****************************************************************/ 02599000
*                                                                  0971 02600000
*   RPARM=RPARM+16;                                                0971 02601000
*                                                                  0971 02602000
         ALR   RPARM,@06                                           0971 02603000
*   /*****************************************************************/ 02604000
*   /*                                                               */ 02605000
*   /* SET PQE TO ZEROES                                             */ 02606000
*   /*                                                               */ 02607000
*   /*****************************************************************/ 02608000
*                                                                  0972 02609000
*   RPARM->PQESECT=RPARM->PQESECT&&RPARM->PQESECT;                 0972 02610000
*                                                                  0972 02611000
         XC    PQESECT(32,RPARM),PQESECT(RPARM)                    0972 02612000
*   /*****************************************************************/ 02613000
*   /*                                                               */ 02614000
*   /* SET CHAIN POINTERS TO FBQE                                    */ 02615000
*   /*                                                               */ 02616000
*   /*****************************************************************/ 02617000
*                                                                  0973 02618000
*   RPARM->PQEFFBQE=RPARM+LENGTH(PQESECT);                         0973 02619000
         LA    @05,32                                              0973 02620000
         LR    @14,RPARM                                           0973 02621000
         ALR   @14,@05                                             0973 02622000
         ST    @14,PQEFFBQE(,RPARM)                                0973 02623000
*   RPARM->PQEBFBQE=RPARM+LENGTH(PQESECT);                         0974 02624000
*                                                                  0974 02625000
         ST    @14,PQEBFBQE(,RPARM)                                0974 02626000
*   /*****************************************************************/ 02627000
*   /*                                                               */ 02628000
*   /* SET BACK CHAIN PQE POINTER TO DPQE                            */ 02629000
*   /*                                                               */ 02630000
*   /*****************************************************************/ 02631000
*                                                                  0975 02632000
*   RPARM->PQEBPQE=RPARM-16;                                       0975 02633000
         LCR   @06,@06                                             0975 02634000
         ALR   @06,RPARM                                           0975 02635000
         ST    @06,PQEBPQE(,RPARM)                                 0975 02636000
*   RPARM->PQETCB=NVTVVTCB;         /* SET POINTER TO TCB            */ 02637000
         L     @06,NVTVVTCB                                        0976 02638000
         ST    @06,PQETCB(,RPARM)                                  0976 02639000
*   RPARM->PQESIZE=NVTLVIRT-NVTVVPG1;/* SIZE OF V=V REGION           */ 02640000
         L     @06,NVTLVIRT                                        0977 02641000
         L     @14,NVTVVPG1                                        0977 02642000
         LR    @09,@06                                             0977 02643000
         SLR   @09,@14                                             0977 02644000
         ST    @09,PQESIZE(,RPARM)                                 0977 02645000
*   RPARM->PQEREGN=NVTVVPG1;        /* ADDR OF START OF REGION       */ 02646000
         ST    @14,PQEREGN(,RPARM)                                 0978 02647000
*   RPARM=RPARM+LENGTH(PQESECT);    /* SET BASE TO FBQE              */ 02648000
*                                                                  0979 02649000
         ALR   RPARM,@05                                           0979 02650000
*   /*****************************************************************/ 02651000
*   /*                                                               */ 02652000
*   /* CLEAR THE FBQE FORWARD CHAIN POINTER TO ZEROES                */ 02653000
*   /*                                                               */ 02654000
*   /*****************************************************************/ 02655000
*                                                                  0980 02656000
*   RPARM->FBQESECT=RPARM->FBQESECT&&RPARM->FBQESECT;              0980 02657000
         XC    FBQESECT(16,RPARM),FBQESECT(RPARM)                  0980 02658000
*   RPARM->FWDPTR=RPARM-LENGTH(PQESECT);/* SET BACK CHAIN            */ 02659000
         LCR   @05,@05                                             0981 02660000
         ALR   @05,RPARM                                           0981 02661000
         ST    @05,FWDPTR(,RPARM)                                  0981 02662000
*   RPARM->BCKPTR=RPARM-LENGTH(PQESECT);/* POINT BACK TO PQE         */ 02663000
         ST    @05,BCKPTR(,RPARM)                                  0982 02664000
*   RPARM->SIZE=NVTLVIRT-NVTVVPG1;  /* SET SIZE OF AREA              */ 02665000
         ST    @09,SIZE(,RPARM)                                    0983 02666000
*   RPARM->FBQAREA=NVTVVPG1;        /* ADDRESS OF AREA               */ 02667000
         ST    @14,FBQAREA(,RPARM)                                 0984 02668000
*   NVTMASCB->ASCBLDA->CURRGNTP=NVTLVIRT;/* SET CURRENT TOP          */ 02669000
*                                                                  0985 02670000
         ST    @06,CURRGNTP(,@15)                                  0985 02671000
*   /*****************************************************************/ 02672000
*   /*                                                               */ 02673000
*   /* INCREASE PASIZE VALUE IN GDA TO INCLUDE V=V AREA FOR BUILDING */ 02674000
*   /* THE PLPA. THIS WILL KEEP FREEMAIN FROM GETTING CONFUSED.      */ 02675000
*   /* PASIZE MUST INCLUDE AREA FROM PASTRT TO BOTTOM OF SQA.        */ 02676000
*   /*                                                               */ 02677000
*   /*****************************************************************/ 02678000
*                                                                  0986 02679000
*   CVTGDA->PASIZE=NVTLVIRT-CVTGDA->PASTRT;                        0986 02680000
         L     @05,CVTPTR                                          0986 02681000
         L     @05,CVTGDA(,@05)                                    0986 02682000
         SL    @06,PASTRT(,@05)                                    0986 02683000
         ST    @06,PASIZE(,@05)                                    0986 02684000
*   GEN(LM  RNVT,RPARM,PREP5SAV);   /* RESTORE REGISTERS             */ 02685000
         LM  RNVT,RPARM,PREP5SAV                                        02686000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 02687000
         BR REXIT                                                       02688000
*PREP5SAV:                                                         0989 02689000
*   GEN(DS  16F);                   /* SAVE AREA                     */ 02690000
PREP5SAV DS  16F                                                        02691000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 02692000
*    (RPARM,                                                       0990 02693000
*     RNVT,                                                        0990 02694000
*     RCVT,                                                        0990 02695000
*     RNIPM) UNRESTRICTED;          /* REGISTERS UNRESTRICTED        */ 02696000
*   END NPMPREP5;                   /* END OF NPMPREP5 PROC          */ 02697000
@EL00009 DS    0H                                                  0991 02698000
@EF00009 DS    0H                                                  0991 02699000
@ER00009 BR    @14                                                 0991 02700000
*                                                                  0992 02701000
*   /*****************************************************************/ 02702000
*   /*                                                               */ 02703000
*   /* THIS ROUTINE GETS CONTROL AFTER THE LPAS ARE BUILT (THE CSA   */ 02704000
*   /* NOT ALLOCATED YET). IT SWAPS ITSELF TO V=V STATUS AND FREES   */ 02705000
*   /* THE PART OF THE AREA ALLOCATED FOR UPPER COMMON THAT WAS NOT  */ 02706000
*   /* USED BY ISSUING A FREEMAIN FOR THE SPACE FROM SP 252. THIS    */ 02707000
*   /* FREES THE PAGE TABLES CONSTRUCTED FOR THIS UNUSED PORTION. THE*/ 02708000
*   /* SUBPOOL DEFINITION BLOCKS ARE FREED BY IEAVNIPX. THE PLPA IS  */ 02709000
*   /* ALSO ESTABLISHED AS A READ ONLY AREA BY SETTING THE NECESSARY */ 02710000
*   /* FIELDS IN THE PVT. HEREAFTER, NO PAGE OUTS WILL BE HONORED FOR*/ 02711000
*   /* THE PLPA AREA BY RSM.                                         */ 02712000
*   /*                                                               */ 02713000
*   /*****************************************************************/ 02714000
*                                                                  0992 02715000
*NPMCLNUP:                          /* NPMCLNUP SUBROUTINE           */ 02716000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             0992 02717000
NPMCLNUP DS    0H                                                  0993 02718000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 02719000
*    (RPARM,                        /* PARAMETER REGISTER            */ 02720000
*     RNIPM,                        /* WORK REGISTER                 */ 02721000
*     RNVT,                         /* NVT POINTER                   */ 02722000
*     RCVT,                         /* CVT POINTER                   */ 02723000
*     RZERO) RESTRICTED;            /* FREEMAIN REGISTER             */ 02724000
*   GEN(NIPMENTR CLNUPSAV,NPMCLNUP);/* ENTRY LINKAGE                 */ 02725000
*                                                                  0994 02726000
         NIPMENTR CLNUPSAV,NPMCLNUP                                     02727000
*   /*****************************************************************/ 02728000
*   /*                                                               */ 02729000
*   /* SWAP TO V=V STATUS                                            */ 02730000
*   /*                                                               */ 02731000
*   /*****************************************************************/ 02732000
*                                                                  0995 02733000
*   GEN(IEAPMNIP TYPE=VIRT,MOD=NIPM);                              0995 02734000
*                                                                  0995 02735000
         IEAPMNIP TYPE=VIRT,MOD=NIPM                                    02736000
*   /*****************************************************************/ 02737000
*   /*                                                               */ 02738000
*   /* IF PSA HAS BEEN SAVED BY IEAVNIP0, MOVE IT TO V=V AREA        */ 02739000
*   /*                                                               */ 02740000
*   /*****************************************************************/ 02741000
*                                                                  0996 02742000
*   IF NVTSGPSA^=0                  /* WAS PSA SAVED                 */ 02743000
*     THEN                          /* YES, COPY IT TO V=V           */ 02744000
         SLR   @06,@06                                             0996 02745000
         C     @06,NVTSGPSA                                        0996 02746000
         BE    @RF00996                                            0996 02747000
*     DO;                                                          0997 02748000
*       NVTLVIRT=((NVTLVIRT-4096)4095)&&4095;/* ROUND DOWN          */ 02749000
         LA    @05,4095                                            0998 02750000
         L     @15,NVTLVIRT                                        0998 02751000
         SL    @15,@CF04798                                        0998 02752000
         OR    @15,@05                                             0998 02753000
         XR    @15,@05                                             0998 02754000
         ST    @15,NVTLVIRT                                        0998 02755000
*       DO I=0 BY 1 TO 15;          /* MOVE A FULL PAGE              */ 02756000
         ST    @06,I                                               0999 02757000
@DL00999 DS    0H                                                  1000 02758000
*         NVTLVIRT->NIPSGPSA(1+I*256:256+I*256)=NVTSGPSA->NIPSGPSA(1+I* 02759000
*             256:256+I*256);                                      1000 02760000
         LR    @05,@06                                             1000 02761000
         SLA   @05,8                                               1000 02762000
         L     @15,NVTLVIRT                                        1000 02763000
         ALR   @15,@05                                             1000 02764000
         L     @14,NVTSGPSA                                        1000 02765000
         ALR   @14,@05                                             1000 02766000
         MVC   NIPSGPSA(256,@15),NIPSGPSA(@14)                     1000 02767000
*       END;                                                       1001 02768000
*                                                                  1001 02769000
         AL    @06,@CF00144                                        1001 02770000
         ST    @06,I                                               1001 02771000
         C     @06,@CF00122                                        1001 02772000
         BNH   @DL00999                                            1001 02773000
*       /*************************************************************/ 02774000
*       /*                                                           */ 02775000
*       /* SET CVTVPSA FIELD TO ADDRESS OF PSA PAGE                  */ 02776000
*       /*                                                           */ 02777000
*       /*************************************************************/ 02778000
*                                                                  1002 02779000
*       CVTVPSA=NVTLVIRT;                                          1002 02780000
         L     @06,NVTLVIRT                                        1002 02781000
         L     @05,CVTPTR                                          1002 02782000
         ST    @06,CVTVPSA(,@05)                                   1002 02783000
*     END;                                                         1003 02784000
*   ELSE                                                           1004 02785000
*     ;                                                            1004 02786000
@RF00996 DS    0H                                                  1005 02787000
*   RNIPM=NVTLVIRT/256;             /* VBN FOR LOWEST USED V=V       */ 02788000
         L     @06,NVTLVIRT                                        1005 02789000
         LR    RNIPM,@06                                           1005 02790000
         SRL   RNIPM,8                                             1005 02791000
*   CVTPVTP->PVTLCSA=RNIPM;         /* PLACE IN PVTLCSA SO THAT RSM     02792000
*                                      WILL DESTROY PAGE TABLES AND     02793000
*                                      SGT ENTRIES ON FREEMAIN       */ 02794000
         L     @05,CVTPTR                                          1006 02795000
         L     @05,CVTPVTP(,@05)                                   1006 02796000
         STH   RNIPM,PVTLCSA(,@05)                                 1006 02797000
*   NPMFRLEN=NVTLVIRT-NVTVVPG1;     /* SIZE OF AREA TO FREE          */ 02798000
         SL    @06,NVTVVPG1                                        1007 02799000
         STCM  @06,7,NPMFRLEN                                      1007 02800000
*   RZERO=NPMFRRGN;                 /* INPUT TO FREEMAIN             */ 02801000
         L     RZERO,NPMFRRGN                                      1008 02802000
*   GEN(FREEMAIN R,LV=(0),A=NVTVVPG1);                             1009 02803000
         FREEMAIN R,LV=(0),A=NVTVVPG1                                   02804000
*   RNIPM=NVTVVPG1/256;             /* RECONSTRUCT ORIGINAL VALUE    */ 02805000
         L     RNIPM,NVTVVPG1                                      1010 02806000
         SRL   RNIPM,8                                             1010 02807000
*   CVTPVTP->PVTLCSA=RNIPM;         /* RETURN VALUE TO PVTLCSA       */ 02808000
         L     @06,CVTPTR                                          1011 02809000
         L     @06,CVTPVTP(,@06)                                   1011 02810000
         STH   RNIPM,PVTLCSA(,@06)                                 1011 02811000
*   GEN(IEAPMNIP TYPE=REAL,MOD=NIPM);/* SWAP BACK TO V=R             */ 02812000
*                                                                  1012 02813000
         IEAPMNIP TYPE=REAL,MOD=NIPM                                    02814000
*   /*****************************************************************/ 02815000
*   /*                                                               */ 02816000
*   /* AS A RESULT OF RESETTING THE PVTLCSA FIELD, ABOVE, PRIOR TO   */ 02817000
*   /* THE FREEMAIN, RSM MADE ADJUSTMENTS TO THE COUNTS ASSOCIATED   */ 02818000
*   /* WITH THE WRONG QUEUES. ANY REAL PAGE FRAMES ASSIGNED TO THE   */ 02819000
*   /* AREA BEING FREED, WERE ACCOUNTED FOR ON THE COMMON QUEUE      */ 02820000
*   /* COUNT, PVTCFMCT, BUT SINCE PVTLCSA WAS RESET ABOVE THE AREA   */ 02821000
*   /* BEING FREED SO THAT PAGE TABLES WOULD BE DESTROYED, ANY REAL  */ 02822000
*   /* PAGES BEING RELEASED AS A RESULT OF THE FREEMAIN WILL RESULT  */ 02823000
*   /* IN THE LOCAL QUEUE COUNT, ASCBFMCT, BEING DECREMENTED. THIS   */ 02824000
*   /* ROUTINE MUST THEREFORE ADJUST THESE COUNTS TO MAKE THEM RIGHT.*/ 02825000
*   /* THE LOCAL QUEUE COUNT, ASCBFMCT, SHOULD ONLY REFLECT THE      */ 02826000
*   /* INITIAL LSQA PAGES SETUP BY IEAVNIP0, SO BY SUBTRACTING OUT   */ 02827000
*   /* THE COUNT FOR THESE PAGES, AND THEN ADDING THE RESULT TO THE  */ 02828000
*   /* COMMON QUEUE COUNT, PVTCFMCT, AND THEN SETTING THE LOCAL QUEUE*/ 02829000
*   /* COUNT TO THE NUMBER OF LSQA PAGES ASSIGNED BOTH QUEUE COUNTS  */ 02830000
*   /* SHOULD BE CORRECT. THE SALLOC LOCK MUST BE HELD SINCE SOME    */ 02831000
*   /* PAGING COULD BE GOING ON AT THIS TIME TO CLEANUP THE LPA.     */ 02832000
*   /*                                                               */ 02833000
*   /*****************************************************************/ 02834000
*                                                                  1013 02835000
*   RPARM=ADDR(NPLOCKSV);           /* SETLOCK SAVE AREA      YM02651*/ 02836000
         LA    RPARM,NPLOCKSV                                      1013 02837000
*/*                                                           YM02651*/ 02838000
*                                                                  1014 02839000
*   GENERATE REFS(PSALITA,FLC);                                    1014 02840000
*                                                                  1014 02841000
           STM 0,15,0(RPARM)             SAVE REGS              YM02651 02842000
NPMCLNGL  SETLOCK OBTAIN,TYPE=SALLOC,MODE=UNCOND,                      *02843000
               RELATED=(RSM,IEAVNIPM(NPMCLNFL))                 YM02651 02844000
          LM   0,15,0(RPARM)             RESTORE REGISTERS      YM02651 02845000
*/*                                                          @OZ00057*/ 02846000
*                                                                  1015 02847000
*   CVTPVTP->PVTCFMCT=CVTPVTP->PVTCFMCT+NVTMASCB->ASCBFMCT-NVTLSQNO;    02848000
         L     @06,CVTPTR                                          1015 02849000
         L     @05,CVTPVTP(,@06)                                   1015 02850000
         LH    @15,NVTLSQNO                                        1015 02851000
         L     @14,NVTMASCB                                        1015 02852000
         LH    @09,PVTCFMCT(,@05)                                  1015 02853000
         AH    @09,ASCBFMCT(,@14)                                  1015 02854000
         SLR   @09,@15                                             1015 02855000
         STH   @09,PVTCFMCT(,@05)                                  1015 02856000
*                                   /* ADJUST COMMON QUEUE COUNT     */ 02857000
*   NVTMASCB->ASCBFMCT=NVTLSQNO;    /* SET LOCAL QUEUE CNT    YM02651*/ 02858000
*                                                                  1016 02859000
         STH   @15,ASCBFMCT(,@14)                                  1016 02860000
*   /*****************************************************************/ 02861000
*   /*                                                               */ 02862000
*   /* NOW THE SLOT COUNTS IN MASTERS ASCB AND THE ASMVT MUST BE     */ 02863000
*   /* ADJUSTED. NO LOCAL PAGING I/O HAS OCCURED YET, SO THE COUNTS  */ 02864000
*   /* ARE SET TO ZERO AT THIS POINT.                        @Z40WPXA*/ 02865000
*   /*                                                               */ 02866000
*   /*****************************************************************/ 02867000
*                                                                  1017 02868000
*   NVTMASCB->ASCBNVSC=0;           /* SET SLOT COUNT IN ASCB TO ZERO   02869000
*                                                            @Z40WPXA*/ 02870000
         SLR   @05,@05                                             1017 02871000
         STH   @05,ASCBNVSC(,@14)                                  1017 02872000
*   CVTASMVT->ASMNVSC=0;            /* SET SLOT COUNT IN ASMVT TO 0     02873000
*                                                            @Z40WPXA*/ 02874000
         L     @06,CVTASMVT(,@06)                                  1018 02875000
         ST    @05,ASMNVSC(,@06)                                   1018 02876000
*   RPARM=ADDR(NPLOCKSV);           /* SETLOCK SAVE AREA      YM02651*/ 02877000
         LA    RPARM,NPLOCKSV                                      1019 02878000
*/*                                                           YM02651*/ 02879000
*                                                                  1020 02880000
*   GENERATE REFS(PSALITA,FLC);                                    1020 02881000
*                                                                  1020 02882000
           STM  0,15,0(RPARM)           SAVE REGS               YM02651 02883000
*                                                               YM02651 02884000
NPMCLNFL  SETLOCK RELEASE,TYPE=SALLOC,RELATED=(RSM,IEAVNIPM(NPMCLNGL))  02885000
           LM   0,15,0(RPARM)           RESTORE REGISTERS       YM02651 02886000
*   /*****************************************************************/ 02887000
*   /*                                                               */ 02888000
*   /* IF PSA PAGE WAS SAVED PREVIOUSLY, FREEMAIN THE SAVEAREA       */ 02889000
*   /*                                                               */ 02890000
*   /*****************************************************************/ 02891000
*                                                                  1021 02892000
*   IF NVTSGPSA^=0 THEN                                            1021 02893000
         L     @06,NVTSGPSA                                        1021 02894000
         LTR   @06,@06                                             1021 02895000
         BZ    @RF01021                                            1021 02896000
*     DO;                                                          1022 02897000
*       RPARM=NVTSGPSA;             /* GET ADDRESS OF AREA TO FREE   */ 02898000
         LR    RPARM,@06                                           1023 02899000
*       GEN( FREEMAIN R,LV=4096,A=(1),SP=252);                     1024 02900000
          FREEMAIN R,LV=4096,A=(1),SP=252                               02901000
*     END;                                                         1025 02902000
*   ELSE                                                           1026 02903000
*     ;                                                            1026 02904000
@RF01021 DS    0H                                                  1027 02905000
*   RNIPM=(NVTLPALO/4096)*16;       /* VBN FOR LOW PLPA      @Z40WPXA*/ 02906000
         L     RNIPM,NVTLPALO                                      1027 02907000
         SRL   RNIPM,12                                            1027 02908000
         SLA   RNIPM,4                                             1027 02909000
*   CVTPVTP->PVTLQSA=RNIPM;         /* SET LOW READ-ONLY AREA ADDR   */ 02910000
         L     @06,CVTPTR                                          1028 02911000
         L     @06,CVTPVTP(,@06)                                   1028 02912000
         STH   RNIPM,PVTLQSA(,@06)                                 1028 02913000
*   RNIPM=(NVTLPAND/4096)*16;       /* VBN FOR HIGH PLPA     @Z40WPXA*/ 02914000
         L     RNIPM,NVTLPAND                                      1029 02915000
         SRL   RNIPM,12                                            1029 02916000
         SLA   RNIPM,4                                             1029 02917000
*   CVTPVTP->PVTHQSA=RNIPM;         /* SET HIGH ADDR OF READ-ONLY    */ 02918000
*                                                                  1030 02919000
         STH   RNIPM,PVTHQSA(,@06)                                 1030 02920000
*   /*****************************************************************/ 02921000
*   /*                                                               */ 02922000
*   /* RESTORE THE PQE PTR IN THE MASTERS LDA TO POINT TO THE PQE IN */ 02923000
*   /* LDA. IT WAS MODIFIED TO POINT TO THE V=V PQE BUILT FOR        */ 02924000
*   /* CONSTRUCTION OF THE PLPA BEFORE IEAVNP05 WAS LOADED AND       */ 02925000
*   /* EXECUTED.                                                     */ 02926000
*   /*                                                               */ 02927000
*   /*****************************************************************/ 02928000
*                                                                  1031 02929000
*   NVTMASCB->ASCBLDA->ASDPQE=NLDAPQEA;/* RESTORE PQE PTR            */ 02930000
         L     @06,NVTMASCB                                        1031 02931000
         L     @06,ASCBLDA(,@06)                                   1031 02932000
         L     @05,NLDAPQEA                                        1031 02933000
         ST    @05,ASDPQE(,@06)                                    1031 02934000
*   RZERO=ADDR(PREAD);              /*                       @Z40WPXA*/ 02935000
         LA    RZERO,PREAD                                         1032 02936000
*   GEN(SVC 9);                     /* DELETE ILRPREAD       @Z40WPXA*/ 02937000
         SVC 9                                                          02938000
*   GEN(LM  RNVT,RPARM,CLNUPSAV);   /* RESTORE REGISTERS             */ 02939000
         LM  RNVT,RPARM,CLNUPSAV                                        02940000
*   GEN(BR   REXIT);                /* RETURN TO CALLER              */ 02941000
         BR   REXIT                                                     02942000
*CLNUPSAV:                                                         1036 02943000
*   GEN(DS   16F);                  /* SAVEAREA FOR THIS ROUTINE     */ 02944000
CLNUPSAV DS   16F                                                       02945000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 02946000
*    (RPARM,                                                       1037 02947000
*     RNVT,                                                        1037 02948000
*     RNIPM,                                                       1037 02949000
*     RCVT,                                                        1037 02950000
*     RZERO) UNRESTRICTED;                                         1037 02951000
*   END NPMCLNUP;                   /* END OF NPMCLNUP ROUTINE       */ 02952000
@EL00010 DS    0H                                                  1038 02953000
@EF00010 DS    0H                                                  1038 02954000
@ER00010 BR    @14                                                 1038 02955000
*                                                                  1039 02956000
*   /*****************************************************************/ 02957000
*   /*                                                               */ 02958000
*   /* THIS ROUTINE SCHEDULES AN SRB AND SERIALIZES ITS EXECUTION.   */ 02959000
*   /* THE SRB IS SCHEDULED WITH CPU AFFINITY TO THE CPU SPECIFIED IN*/ 02960000
*   /* THE INPUT PARAMETER LIST. AFTER THE SRB IS SCHEDULED, A WAIT  */ 02961000
*   /* IS ISSUED FROM THIS ROUTINE ON AN ECB THAT IS POSTED (BRANCH  */ 02962000
*   /* ENTRY) WHEN THE ROUTINE RUNNING UNDER THE SRB COMPLETES.      */ 02963000
*   /*                                                               */ 02964000
*   /*****************************************************************/ 02965000
*                                                                  1039 02966000
*NIPSCHED:                          /* NIP SCHED ROUTINE             */ 02967000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1039 02968000
NIPSCHED DS    0H                                                  1040 02969000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 02970000
*    (RPARM,                        /* PARAMETER REGISTER            */ 02971000
*     RNVT,                         /* POINTER TO NVT                */ 02972000
*     RCVT,                         /* POINTER TO CVT                */ 02973000
*     RWRK1,                        /* WORK REGISTER                 */ 02974000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 02975000
*   GEN(NIPMENTR SCHEDSAV,NIPSCHED);/* ENTRY PROCESSING              */ 02976000
         NIPMENTR SCHEDSAV,NIPSCHED                                     02977000
*   PARMHOLD=RPARM;                 /* SAVE CALLERS PARM LIST        */ 02978000
         ST    RPARM,PARMHOLD                                      1042 02979000
*   NSRBSP=245;                     /* GET SUBPOOL ID-SRB SHOULD BE     02980000
*                                      PLACED IN SP245 SO THAT IT IS    02981000
*                                      ADDRESSABLE BY ALL (GLOBAL) 1043 02982000
*                                                            @YM08126*/ 02983000
         MVI   NSRBSP,X'F5'                                        1043 02984000
*   NSRBLEN=LENGTH(SRB);            /* GET SIZE OF SRB               */ 02985000
         MVC   NSRBLEN(3),@CF02923+1                               1044 02986000
*   RZERO=GETWORD;                  /* GET SIZE AND SP IN REG 0      */ 02987000
         L     RZERO,GETWORD                                       1045 02988000
*   GEN(GETMAIN R,LV=(0));          /* GETMAIN THE AREA FOR SRB      */ 02989000
*                                                                  1046 02990000
         GETMAIN R,LV=(0)                                               02991000
*   /*****************************************************************/ 02992000
*   /*                                                               */ 02993000
*   /* INITIALIZE THE SRB TO RUN LOCALLY AT SYSTEM PRIORITY.         */ 02994000
*   /* ESTABLISH CPU AFFINITY WITH CPU SPECIFIED IN PARAMETER LIST   */ 02995000
*   /* PASSED TO THIS ROUTINE BY THE CALLER. SET ENTRY POINT IN SRB  */ 02996000
*   /* TO POINT TO LABEL NPSRBENT IN THIS ROUTINE. THE CODE AT LABEL */ 02997000
*   /* NPSRBENT WILL THEN IN TURN CALL THE ROUTINE (BALR) THAT THE   */ 02998000
*   /* CALLER OF NIPSCHED SPECIFIED IN THE PARAMETER LIST.           */ 02999000
*   /*                                                               */ 03000000
*   /*****************************************************************/ 03001000
*                                                                  1047 03002000
*   RPARM->SRB=RPARM->SRB&&RPARM->SRB;/* ZERO THE AREA               */ 03003000
         XC    SRB(44,RPARM),SRB(RPARM)                            1047 03004000
*   RPARM->SRBID='SRB ';            /* SRB IDENTIFIER FIELD          */ 03005000
         MVC   SRBID(4,RPARM),@CC04940                             1048 03006000
*   RPARM->SRBASCB=NVTMASCB;        /* ASCB ADDRESS INTO SRB         */ 03007000
         L     @05,NVTMASCB                                        1049 03008000
         ST    @05,SRBASCB(,RPARM)                                 1049 03009000
*   RPARM->SRBEP=ADDR(NPSRBENT);    /* ENTRY POINT ADDRESS           */ 03010000
         LA    @05,NPSRBENT                                        1050 03011000
         ST    @05,SRBEP(,RPARM)                                   1050 03012000
*   RPARM->SRBPRIOR=0;              /* SYSTEM LEVEL PRIORITY         */ 03013000
         MVI   SRBPRIOR(RPARM),X'00'                               1051 03014000
*   RNIPM=NAFFMASK;                 /* PUT AFFINITY MASK IN REG      */ 03015000
         L     RNIPM,NAFFMASK                                      1052 03016000
*   RWRK1=PARMHOLD->NSCHDCPU;       /* GET CPU ADDR                  */ 03017000
*                                                                  1053 03018000
         L     @05,PARMHOLD                                        1053 03019000
         LH    RWRK1,NSCHDCPU(,@05)                                1053 03020000
         N     RWRK1,@CF05060                                      1053 03021000
*   /*****************************************************************/ 03022000
*   /*                                                               */ 03023000
*   /* CONVERT THE CPU ADDRESS (2 BYTES) INTO AN AFFINITY MASK THAT  */ 03024000
*   /* CAN BE PLACED INTO THE SRB.                                   */ 03025000
*   /*                                                               */ 03026000
*   /*****************************************************************/ 03027000
*                                                                  1054 03028000
*   DO WHILE RWRK1^=0;              /* CONVERT ADDR TO MASK VALUE    */ 03029000
         B     @DE01054                                            1054 03030000
@DL01054 DS    0H                                                  1055 03031000
*     GEN(SRL  RNIPM,1);            /* SHIFT TO NEXT MASK VALUE      */ 03032000
         SRL  RNIPM,1                                                   03033000
*     RWRK1=RWRK1-1;                /* DECREMENT ADDR UNTIL ZERO     */ 03034000
         BCTR  RWRK1,0                                             1056 03035000
*   END;                                                           1057 03036000
@DE01054 LTR   RWRK1,RWRK1                                         1057 03037000
         BNZ   @DL01054                                            1057 03038000
*   NCPUAFF=RNIPM;                  /* MOVE MASK TO STORAGE          */ 03039000
         ST    RNIPM,NCPUAFF                                       1058 03040000
*   RPARM->SRBCPAFF=NSRBAFF;        /* PUT MASK INTO SRB             */ 03041000
         LH    @05,NSRBAFF                                         1059 03042000
         STH   @05,SRBCPAFF(,RPARM)                                1059 03043000
*   RPARM->SRBPARM=ADDR(SCHEDSAV);  /* PASS SAVEARE AS PARAM         */ 03044000
         LA    @05,SCHEDSAV                                        1060 03045000
         ST    @05,SRBPARM(,RPARM)                                 1060 03046000
*   RNIPM=RPARM;                    /* SAVE SRB ADDRESS              */ 03047000
         LR    RNIPM,RPARM                                         1061 03048000
*   NPMECB=NPMECB&&NPMECB;          /* CLEAR ECB FIELD               */ 03049000
*                                                                  1062 03050000
         L     @05,NPMECB                                          1062 03051000
         LR    @00,@05                                             1062 03052000
         XR    @00,@05                                             1062 03053000
         ST    @00,NPMECB                                          1062 03054000
*   /*****************************************************************/ 03055000
*   /*                                                               */ 03056000
*   /* SCHEDULE THE SRB (LOCAL, SYSTEM PRIORITY, CPU AFFINITY)       */ 03057000
*   /*                                                               */ 03058000
*   /*****************************************************************/ 03059000
*                                                                  1063 03060000
*   GEN REFS(CVTLSMQ,SRBFLNK)(SCHEDULE SRB=(1));                   1063 03061000
*                                                                  1063 03062000
         SCHEDULE SRB=(1)                                               03063000
*   /*****************************************************************/ 03064000
*   /*                                                               */ 03065000
*   /* WAIT FOR SRB ROUTINE TO COMPLETE PROCESSING                   */ 03066000
*   /*                                                               */ 03067000
*   /*****************************************************************/ 03068000
*                                                                  1064 03069000
*   GEN(WAIT  ECB=NPMECB);          /* WAIT ON COMPLETION            */ 03070000
         WAIT  ECB=NPMECB                                               03071000
*   RPARM=RNIPM;                    /* GET BACK THE SRB ADDRESS      */ 03072000
         LR    RPARM,RNIPM                                         1065 03073000
*   RZERO=GETWORD;                  /* GET SUPPOOL ID AND SIZE       */ 03074000
         L     RZERO,GETWORD                                       1066 03075000
*   GEN(FREEMAIN R,LV=(0),A=(1));   /* FREE THE SRB AREA             */ 03076000
         FREEMAIN R,LV=(0),A=(1)                                        03077000
*   GEN(LM RNVT,RPARM,SCHEDSAV);    /* RESTORE REGISTERS             */ 03078000
         LM RNVT,RPARM,SCHEDSAV                                         03079000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 03080000
*                                                                  1069 03081000
         BR REXIT                                                       03082000
*   /*****************************************************************/ 03083000
*   /*                                                               */ 03084000
*   /* THE FOLLOWING BLOCK OF CODE GETS CONTROL UNDER THE THE SRB    */ 03085000
*   /* THAT WAS SCHEDULED. IT PASSES CONTROL TO THE ROUTINE SPECIFIED*/ 03086000
*   /* BY THE CALLER OF NIPSCHED, AND WHEN CONTROL RETURNS, POSTS THE*/ 03087000
*   /* WAITING TASK AND EXITS.                                       */ 03088000
*   /*                                                               */ 03089000
*   /*****************************************************************/ 03090000
*                                                                  1070 03091000
*NPSRBENT:                          /* ENTERED IN SRB MODE           */ 03092000
*   GEN(LM  RNVT,RSAVE,0(RPARM));   /* SETUP ADDRESSABILITY          */ 03093000
NPSRBENT LM  RNVT,RSAVE,0(RPARM)                                        03094000
*   GEN(LM RBASE,RBASE2,NVTNIPM-NVT(RNVT));/* GET BASES              */ 03095000
         LM RBASE,RBASE2,NVTNIPM-NVT(RNVT)                              03096000
*   NSRBEXIT=REXIT;                 /* SAVE ADDR OF SRB EXIT RTN     */ 03097000
         ST    REXIT,NSRBEXIT                                      1072 03098000
*   RENTRY=PARMHOLD->NSCHDPTR;      /* GET ENTRY TO CALLERS RTN      */ 03099000
         L     @05,PARMHOLD                                        1073 03100000
         L     RENTRY,NSCHDPTR(,@05)                               1073 03101000
*   RPARM=PARMHOLD->NSCHDPRM;       /* GET PTR TO CALLERS PARMLIST   */ 03102000
         L     RPARM,NSCHDPRM(,@05)                                1074 03103000
*   GEN(BALR  REXIT,RENTRY);        /* GO TO CALLERS SRB ROUTINE     */ 03104000
         BALR  REXIT,RENTRY                                             03105000
*NPSRBRTN:                                                         1076 03106000
*   GEN(LM    RNVT,RSAVE,SCHEDSAV-NPSRBRTN(REXIT));                1076 03107000
NPSRBRTN LM    RNVT,RSAVE,SCHEDSAV-NPSRBRTN(REXIT)                      03108000
*   GEN(LM RBASE,RBASE2,NVTNIPM-NVT(RNVT));/* GET BASES              */ 03109000
         LM RBASE,RBASE2,NVTNIPM-NVT(RNVT)                              03110000
*   GEN(ST    RENTRY,SCHEDSAV+52);  /* SAVE RETURN CODE              */ 03111000
         ST    RENTRY,SCHEDSAV+52                                       03112000
*   RENTRY=CVT0PT01;                /* GET BRANCH ENTRY TO POST      */ 03113000
         L     @05,CVTPTR                                          1079 03114000
         L     RENTRY,CVT0PT01(,@05)                               1079 03115000
*   GENERATE REFS(NPMECB,NSRBEXIT,PSALITA);                        1080 03116000
         LA    5,NPLOCKSV              MOVE SAVEAREA ADDR TO A          03117000
*                                      NON-VOLATILE REGISTER.           03118000
         STM   0,15,NPLOCKSV           SAVE REGISTERS LOCALLY           03119000
NPSET1   SETLOCK OBTAIN,TYPE=LOCAL,MODE=UNCOND,                        *03120000
               RELATED=(POST,IEAVNIPM(NPREL1))                          03121000
         LM    0,15,0(5)             RESTORE REGISTERS                  03122000
         SR    10,10                   NO COMP CODE FOR POST ENTRY      03123000
         LA    11,NPMECB               ADDR OF ECB TO BE POSTED         03124000
         BALR  14,15                   BRANCH TO POST ECB               03125000
         LM    0,15,0(5)               RESTORE REGISTERS                03126000
NPREL1   SETLOCK RELEASE,TYPE=LOCAL,RELATED=(POST,IEAVNIPM(NPSET1))     03127000
         LM    0,15,0(5)               RESTORE REGISTERS                03128000
         L     REXIT,NSRBEXIT          GET ADDR OF SRB EXIT ROUTINE     03129000
         BR    REXIT                   EXIT FROM SRB PROCESSING         03130000
*SCHEDSAV:                          /* SAVE AREA LABEL               */ 03131000
*   GEN(DS 16F);                    /* SAVE AREA                     */ 03132000
SCHEDSAV DS 16F                                                         03133000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 03134000
*    (RPARM,                                                       1082 03135000
*     RNVT,                                                        1082 03136000
*     RCVT,                                                        1082 03137000
*     RNIPM,                                                       1082 03138000
*     RWRK1) UNRESTRICTED;                                         1082 03139000
*   END NIPSCHED;                   /* END OF NIPSCHED ROUTINE       */ 03140000
@EL00011 DS    0H                                                  1083 03141000
@EF00011 DS    0H                                                  1083 03142000
@ER00011 BR    @14                                                 1083 03143000
*                                                                  1084 03144000
*   /*****************************************************************/ 03145000
*   /*                                                               */ 03146000
*   /* THIS ROUTINE SWAPS THE TCB FIELDS OF THE MASTER SCHEDULER TCB */ 03147000
*   /* UNDER WHICH NIP IS RUNNING TO V=V                      STATUS.*/ 03148000
*   /* A V=V REGION HAS PREVIOUSLY BEEN DEFINED AND THE ADDRESS OF   */ 03149000
*   /* THE CONTROL BLOCKS SAVED IN THE NVT. IF THE TCB IS ALREADY IN */ 03150000
*   /* V=V STATE, THEN THE SWAP DOES NOT TAKE PLACE.                 */ 03151000
*   /*                                                               */ 03152000
*   /*****************************************************************/ 03153000
*                                                                  1084 03154000
*NIPVIRT:                           /* NIP VIRT ROUTINE (VR TO VV)   */ 03155000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1084 03156000
NIPVIRT  DS    0H                                                  1085 03157000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 03158000
*    (RPARM,                        /* PARAMETER REGISTER            */ 03159000
*     RNVT,                         /* POINTER TO NVT                */ 03160000
*     RCVT,                         /* POINTER TO CVT                */ 03161000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 03162000
*   GEN(NIPMENTR VIRTSAV,NIPVIRT);  /* ENTRY PROCESSING              */ 03163000
*                                                                  1086 03164000
         NIPMENTR VIRTSAV,NIPVIRT                                       03165000
*   /*****************************************************************/ 03166000
*   /*                                                               */ 03167000
*   /* SET LOCK GOES HERE TO DISABLE PROCESSING                      */ 03168000
*   /*                                                               */ 03169000
*   /*****************************************************************/ 03170000
*                                                                  1087 03171000
*   IF NVTMSTCB->TCBRV^='1'B        /* SEE IF ALREADY IN V=V STATE   */ 03172000
*     THEN                          /* IF SO, RETURN TO CALLER       */ 03173000
         L     @06,NVTMSTCB                                        1087 03174000
         TM    TCBRV(@06),B'10000000'                              1087 03175000
         BNO   @RT01087                                            1087 03176000
*     GO TO NPMSCHXT;               /* GO TO EXIT                    */ 03177000
*   RPARM=ADDR(NPLOCKSV);           /* ADDR OF SAVEAREA              */ 03178000
         LA    RPARM,NPLOCKSV                                      1089 03179000
*   GENERATE REFS(PSALITA,FLC);                                    1090 03180000
          STM  0,15,0(RPARM)           SAVE THE REGISTERS               03181000
NPVIRTGL  SETLOCK OBTAIN,TYPE=DISP,MODE=UNCOND,                        *03182000
               RELATED=(TCB,IEAVNIPM(NPVIRTFL))   GET DISPATCHER LOCK   03183000
          LM   0,15,0(RPARM)      RESTORE REGISTERS                     03184000
*   RNIPM=NVTMSTCB;                 /* GET POINTER TO TCB            */ 03185000
         L     RNIPM,NVTMSTCB                                      1091 03186000
*   NVTRMSS=RNIPM->TCBMSS;          /* SAVE V=R TCB MSS FIELD        */ 03187000
         L     @06,TCBMSS(,RNIPM)                                  1092 03188000
         ST    @06,NVTRMSS                                         1092 03189000
*   NVTRJPQ=RNIPM->TCBJPQ;          /* SAVE V=R TCB JPQ FIELD        */ 03190000
         L     @06,TCBJPQ(,RNIPM)                                  1093 03191000
         ST    @06,NVTRJPQ                                         1093 03192000
*   NVTRPQE=RNIPM->TCBPQE;          /* SAVE V=R TCB PQE FIELD        */ 03193000
         L     @06,TCBPQE(,RNIPM)                                  1094 03194000
         ST    @06,NVTRPQE                                         1094 03195000
*   NVTRLLE=RNIPM->TCBLLS;          /* SAVE V=R TCB LLS FIELD        */ 03196000
         L     @06,TCBLLS(,RNIPM)                                  1095 03197000
         ST    @06,NVTRLLE                                         1095 03198000
*   RNIPM->TCBRV='0'B;              /* SET TCB V=V STATUS FLAG       */ 03199000
         NI    TCBRV(RNIPM),B'01111111'                            1096 03200000
*   RNIPM->TCBMSS=NVTVMSS;          /* SET TCB MSS FIELD TO V=V      */ 03201000
         L     @06,NVTVMSS                                         1097 03202000
         ST    @06,TCBMSS(,RNIPM)                                  1097 03203000
*   RNIPM->TCBJPQ=NVTVJPQ;          /* SET TCB JPQ FIELD TO V=V      */ 03204000
         L     @06,NVTVJPQ                                         1098 03205000
         ST    @06,TCBJPQ(,RNIPM)                                  1098 03206000
*   RNIPM->TCBPQE=NVTVPQE;          /* SET TCB PQE FIELD TO V=V      */ 03207000
         L     @06,NVTVPQE                                         1099 03208000
         ST    @06,TCBPQE(,RNIPM)                                  1099 03209000
*   RNIPM->TCBLLS=NVTVLLE;          /* SET TCB LLS FIELD TO V=V      */ 03210000
         L     @06,NVTVLLE                                         1100 03211000
         ST    @06,TCBLLS(,RNIPM)                                  1100 03212000
*   RPARM=ADDR(NPLOCKSV);           /* SAVE ADDR OF SAVEAREA         */ 03213000
         LA    RPARM,NPLOCKSV                                      1101 03214000
*   GENERATE REFS(PSALITA,FLC);                                    1102 03215000
*                                       /*FREE DISPATCHER LOCK       */ 03216000
          STM  0,15,0(RPARM)           SAVE REGISTERS                   03217000
NPVIRTFL  SETLOCK RELEASE,TYPE=DISP,RELATED=(TCB,IEAVNIPM(NPVIRTGL))    03218000
          LM   0,15,0(RPARM)      RESTORE REGISTERS                     03219000
*NPMSCHXT:                          /* EXIT PROCESSING               */ 03220000
*   GEN(LM RNVT,RPARM,VIRTSAV);     /* RESTORE REGISTERS             */ 03221000
NPMSCHXT LM RNVT,RPARM,VIRTSAV                                          03222000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 03223000
         BR REXIT                                                       03224000
*VIRTSAV:                           /* SAVE AREA LABEL               */ 03225000
*   GEN(DS 16F);                    /* SAVE AREA                     */ 03226000
VIRTSAV  DS 16F                                                         03227000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 03228000
*    (RPARM,                                                       1106 03229000
*     RNVT,                                                        1106 03230000
*     RCVT,                                                        1106 03231000
*     RNIPM) UNRESTRICTED;                                         1106 03232000
*   END NIPVIRT;                    /* END NIPVIRT ROUTINE           */ 03233000
@EL00012 DS    0H                                                  1107 03234000
@EF00012 DS    0H                                                  1107 03235000
@ER00012 BR    @14                                                 1107 03236000
*                                                                  1108 03237000
*   /*****************************************************************/ 03238000
*   /*                                                               */ 03239000
*   /* THIS ROUTINE SWAPS THE MASTERS TCB FROM V=V STATUS BACK TO THE*/ 03240000
*   /* NORMAL V=R STATUS THAT NIP NORMALLY RUNS UNDER. IT FIRST      */ 03241000
*   /* CHECKS TO SEE IF THE TCB IS ALREADY IN V=R STATUS AND IF IT   */ 03242000
*   /* IS, EXITS WITHOUT SWAPPING.                                   */ 03243000
*   /*                                                               */ 03244000
*   /*****************************************************************/ 03245000
*                                                                  1108 03246000
*NIPREAL:                           /* NIP REAL (VV TO VR) ROUTINE   */ 03247000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1108 03248000
NIPREAL  DS    0H                                                  1109 03249000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 03250000
*    (RPARM,                        /* PARAMETER REGISTER            */ 03251000
*     RNVT,                         /* POINTER TO NVT                */ 03252000
*     RCVT,                         /* POINTER TO CVT                */ 03253000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 03254000
*   GEN(NIPMENTR REALSAV,NIPREAL);  /* ENTRY PROCESSING              */ 03255000
         NIPMENTR REALSAV,NIPREAL                                       03256000
*   IF NVTMSTCB->TCBRV='1'B         /* SEE IF ALREADY V=R STATUS     */ 03257000
*     THEN                          /* YES, GO RETURN TO CALLER      */ 03258000
         L     @06,NVTMSTCB                                        1111 03259000
         TM    TCBRV(@06),B'10000000'                              1111 03260000
         BO    @RT01111                                            1111 03261000
*     GO TO NPMREALX;               /* RETURN TO CALLER              */ 03262000
*   RPARM=ADDR(NPLOCKSV);           /* SAVE ADDR OF SAVEAREA         */ 03263000
         LA    RPARM,NPLOCKSV                                      1113 03264000
*   GENERATE REFS(PSALITA,FLC);                                    1114 03265000
*                                       /* ISSUE SETLOCK INSTRUCTION */ 03266000
          STM  0,15,0(RPARM)           SAVE REGISTERS                   03267000
NPREALGL  SETLOCK OBTAIN,TYPE=DISP,MODE=UNCOND,                        *03268000
               RELATED=(TCB,IEAVNIPM(NPREALFL))                         03269000
          LM   0,15,0(RPARM)       RESTORE REGISTERS                    03270000
*   RNIPM=NVTMSTCB;                 /* GET TCB ADDRESS               */ 03271000
         L     RNIPM,NVTMSTCB                                      1115 03272000
*   NVTVMSS=RNIPM->TCBMSS;          /* SAVE V=V TCB MSS FIELD        */ 03273000
         L     @06,TCBMSS(,RNIPM)                                  1116 03274000
         ST    @06,NVTVMSS                                         1116 03275000
*   NVTVJPQ=RNIPM->TCBJPQ;          /* SAVE V=V TCB JPQ FIELD        */ 03276000
         L     @06,TCBJPQ(,RNIPM)                                  1117 03277000
         ST    @06,NVTVJPQ                                         1117 03278000
*   NVTVPQE=RNIPM->TCBPQE;          /* SAVE V=V TCB PQE FIELD        */ 03279000
         L     @06,TCBPQE(,RNIPM)                                  1118 03280000
         ST    @06,NVTVPQE                                         1118 03281000
*   NVTVLLE=RNIPM->TCBLLS;          /* SAVE V=V TCB LLS FIELD        */ 03282000
         L     @06,TCBLLS(,RNIPM)                                  1119 03283000
         ST    @06,NVTVLLE                                         1119 03284000
*   RNIPM->TCBRV='1'B;              /* SET TCB STATUS FLAG TO V=R    */ 03285000
         OI    TCBRV(RNIPM),B'10000000'                            1120 03286000
*   RNIPM->TCBMSS=NVTRMSS;          /* RESTORE V=R TCB MSS FIELD     */ 03287000
         L     @06,NVTRMSS                                         1121 03288000
         ST    @06,TCBMSS(,RNIPM)                                  1121 03289000
*   RNIPM->TCBJPQ=NVTRJPQ;          /* RESTORE V=R TCB JPQ FIELD     */ 03290000
         L     @06,NVTRJPQ                                         1122 03291000
         ST    @06,TCBJPQ(,RNIPM)                                  1122 03292000
*   RNIPM->TCBPQE=NVTRPQE;          /* RESTORE V=R TCB PQE FIELD     */ 03293000
         L     @06,NVTRPQE                                         1123 03294000
         ST    @06,TCBPQE(,RNIPM)                                  1123 03295000
*   RNIPM->TCBLLS=NVTRLLE;          /* RESTORE V=R TCB LLS FIELD     */ 03296000
         L     @06,NVTRLLE                                         1124 03297000
         ST    @06,TCBLLS(,RNIPM)                                  1124 03298000
*   RPARM=ADDR(NPLOCKSV);           /* SAVE ADDR OF SAVEAREA         */ 03299000
         LA    RPARM,NPLOCKSV                                      1125 03300000
*   GENERATE REFS(PSALITA,FLC);                                    1126 03301000
           STM  0,15,0(RPARM)           SAVE REGISTERS                  03302000
NPREALFL  SETLOCK RELEASE,TYPE=DISP,RELATED=(TCB,IEAVNIPM(NPREALGL))    03303000
          LM   0,15,0(RPARM)      RESTORE REGISTERS                     03304000
*NPMREALX:                          /* EXIT PROCESSING               */ 03305000
*   GEN( LM RNVT,RPARM,REALSAV);    /* RESTORE REGISTERS             */ 03306000
NPMREALX  LM RNVT,RPARM,REALSAV                                         03307000
*   GEN( BR   REXIT);               /* RETURN TO CALLER              */ 03308000
          BR   REXIT                                                    03309000
*REALSAV:                           /* SAVE AREA LABEL               */ 03310000
*   GEN(DS 16F);                    /* SAVE AREA                     */ 03311000
REALSAV  DS 16F                                                         03312000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 03313000
*    (RPARM,                                                       1130 03314000
*     RNVT,                                                        1130 03315000
*     RCVT,                                                        1130 03316000
*     RPARM) UNRESTRICTED;                                         1130 03317000
*   END NIPREAL;                    /* END OF NIP REAL ROUTINE       */ 03318000
@EL00013 DS    0H                                                  1131 03319000
@EF00013 DS    0H                                                  1131 03320000
@ER00013 BR    @14                                                 1131 03321000
*                                                                  1132 03322000
*   /*****************************************************************/ 03323000
*   /*                                                               */ 03324000
*   /* THIS ROUTINE SETS THE LOW VIRTUAL ADDRESS FIELD IN THE NVT    */ 03325000
*   /* WITH THE BOTTOM OF THE INITIAL SQA THAT IEAVNIP0 SETS UP. IT  */ 03326000
*   /* ALSO ESTABLISHES THE LOW WATER MARK FOR ALLOCATING COMMON     */ 03327000
*   /* VIRTUAL STORAGE. THESE VALUES ARE USED FOR ALLOCATING SQA, THE*/ 03328000
*   /* LPA'S AND THE CSA AREA.                                       */ 03329000
*   /*                                                               */ 03330000
*   /*****************************************************************/ 03331000
*                                                                  1132 03332000
*NPMPREP8:                          /* START OF NPMPREP8             */ 03333000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1132 03334000
NPMPREP8 DS    0H                                                  1133 03335000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 03336000
*    (RPARM,                        /* PARAMETER REGISTER            */ 03337000
*     RNVT,                         /* POINTER TO NVT                */ 03338000
*     RCVT,                         /* POINTER TO CVT                */ 03339000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 03340000
*   GEN(NIPMENTR PREP8SAV,NPMPREP8);/* ENTRY PROCESSING              */ 03341000
*                                                                  1134 03342000
         NIPMENTR PREP8SAV,NPMPREP8                                     03343000
*   /*****************************************************************/ 03344000
*   /*                                                               */ 03345000
*   /* SET LOW VIRTUAL ADDRESS TO 16 MEGS MINUS THE NUMBER OF SQA    */ 03346000
*   /* SEGMENTS ALLOCATED BY IEAVNIP0. THEN SET THE LOW WATER MARK   */ 03347000
*   /* FOR ALLOCATING COMMON VIRTUAL MEMORY.                         */ 03348000
*   /*                                                               */ 03349000
*   /*****************************************************************/ 03350000
*                                                                  1135 03351000
*   NVTLVIRT=16777216-(NVTNVSQA*65536);                            1135 03352000
         LH    @06,NVTNVSQA                                        1135 03353000
         SLA   @06,16                                              1135 03354000
         LCR   @06,@06                                             1135 03355000
         AL    @06,@CF04964                                        1135 03356000
         ST    @06,NVTLVIRT                                        1135 03357000
*   NPMVVPG1=NVTVVPG1;              /* SAVE NVTVVPG1 FIELD           */ 03358000
*                                                                  1136 03359000
         L     @06,NVTVVPG1                                        1136 03360000
         ST    @06,NPMVVPG1                                        1136 03361000
*   /*****************************************************************/ 03362000
*   /*                                                               */ 03363000
*   /* USE THE TOP OF M.S. LSQA FOR LOW WATER MARK FOR BUILDING THE  */ 03364000
*   /* UPPER COMMON AREA (SQA, LPA CSA, ETC.)                        */ 03365000
*   /*                                                               */ 03366000
*   /*****************************************************************/ 03367000
*                                                                  1137 03368000
*   NVTVVPG1=NVTLSQAS;              /* SET IT TO HIGH LSQA @         */ 03369000
*                                                                  1137 03370000
         L     @06,NVTLSQAS                                        1137 03371000
         ST    @06,NVTVVPG1                                        1137 03372000
*   /*****************************************************************/ 03373000
*   /*                                                               */ 03374000
*   /* ISSUE SYSEVENT 22 TO PASS RSM CONSTANTS TO THE SYSTEM RESOURSE*/ 03375000
*   /* MANAGER. THIS SYSEVENT IS ISSUED IN THIS ROUTINE INSTEAD OF   */ 03376000
*   /* THE NPMPFTBL ROUTINE WHERE THEY ARE DETERMINED, BECAUSE THE   */ 03377000
*   /* SRM RIM IEAVNP10 HAD NOT BEEN EXECUTED AT THAT TIME.          */ 03378000
*   /*                                                               */ 03379000
*   /*****************************************************************/ 03380000
*                                                                  1138 03381000
*   NAVFRMCT=CVTPVTP->PVTAFCOK;     /* GET AVAILABLE FRAME CNT     1138 03382000
*                                                             YM05617*/ 03383000
         L     @06,CVTPTR                                          1138 03384000
         L     @06,CVTPVTP(,@06)                                   1138 03385000
         LH    @06,PVTAFCOK(,@06)                                  1138 03386000
         STH   @06,NAVFRMCT                                        1138 03387000
*   RPARM=NSYSEV22;                 /* PUT VALUES IN REGISTER        */ 03388000
         L     RPARM,NSYSEV22                                      1139 03389000
*   GEN REFS(CVTOPTE,CVT)           /* ISSUE SYSEVENT 22             */ 03390000
*       ( SYSEVENT RSMCNSTS,ENTRY=BRANCH);                         1140 03391000
*                                                                  1140 03392000
          SYSEVENT RSMCNSTS,ENTRY=BRANCH                                03393000
*   /*****************************************************************/ 03394000
*   /*                                                               */ 03395000
*   /* EXIT FROM THIS ROUTINE.                                       */ 03396000
*   /*                                                               */ 03397000
*   /*****************************************************************/ 03398000
*                                                                  1141 03399000
*   GEN(LM RNVT,RPARM,PREP8SAV);    /* RESTORE REGISTERS             */ 03400000
         LM RNVT,RPARM,PREP8SAV                                         03401000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 03402000
         BR REXIT                                                       03403000
*PREP8SAV:                          /* SAVEAREA LABEL                */ 03404000
*   GEN(DS 16F);                    /* SAVEAREA FOR REGISTERS        */ 03405000
PREP8SAV DS 16F                                                         03406000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 03407000
*    (RPARM,                                                       1144 03408000
*     RNVT,                                                        1144 03409000
*     RCVT,                                                        1144 03410000
*     RNIPM) UNRESTRICTED;                                         1144 03411000
*   END NPMPREP8;                   /* END OF NPMPREP8 ROUTINE       */ 03412000
@EL00014 DS    0H                                                  1145 03413000
@EF00014 DS    0H                                                  1145 03414000
@ER00014 BR    @14                                                 1145 03415000
*                                                                  1146 03416000
*   /*****************************************************************/ 03417000
*   /*                                                               */ 03418000
*   /* THIS ROUTINE SET UP VALUES FOR VRREGN PROCESSING. IT ROUNDS UP*/ 03419000
*   /* THE TOP NUCLEUS ADDRESS TO A SEGMENT BOUNDARY AND SAVES IT IN */ 03420000
*   /* THE CVT AND NVT. IT THEN DETERMINES THE NUMBER OF PAGES       */ 03421000
*   /* AVAILABLE FOR V=R ALLOCATION AND SAVES THE VALUE IN THE NVT.  */ 03422000
*   /*                                                               */ 03423000
*   /*****************************************************************/ 03424000
*                                                                  1146 03425000
*NPMVRREG:                          /* ENTER NPMVRREG ROUTINE        */ 03426000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1146 03427000
NPMVRREG DS    0H                                                  1147 03428000
*   RESPECIFY                       /* RESTRICT REGISTERS            */ 03429000
*    (RPARM,                        /* PARAMETER REGISTER            */ 03430000
*     RNVT,                         /* POINTER TO THE NVT            */ 03431000
*     RCVT,                         /* POINTER TO THE CVT            */ 03432000
*     PFTEPTR,                      /* POINTER FOR PFTE BASE         */ 03433000
*     RNIPM) RESTRICTED;            /* WORK REGISTER                 */ 03434000
*   GEN(NIPMENTR VRREGSAV,NPMVRREG);/* ENTRY PROCESSING              */ 03435000
*                                                                  1148 03436000
         NIPMENTR VRREGSAV,NPMVRREG                                     03437000
*   /*****************************************************************/ 03438000
*   /*                                                               */ 03439000
*   /* ROUND NUCLEUS END ADDRESS UP TO A SEGMENT BOUNDARY            */ 03440000
*   /*                                                               */ 03441000
*   /*****************************************************************/ 03442000
*                                                                  1149 03443000
*   RNIPM=((NVTNUCND+65535)65535)&&65535;                         1149 03444000
         L     @06,@CF04971                                        1149 03445000
         L     @15,NVTNUCND                                        1149 03446000
         LR    RNIPM,@15                                           1149 03447000
         ALR   RNIPM,@06                                           1149 03448000
         OR    RNIPM,@06                                           1149 03449000
         XR    RNIPM,@06                                           1149 03450000
*   CVTNUCB=RNIPM;                  /* PLACE RESULT IN CVT           */ 03451000
         L     @06,CVTPTR                                          1150 03452000
         ST    RNIPM,CVTNUCB(,@06)                                 1150 03453000
*   NVTVRREG=RNIPM;                 /* AND IN THE NVT.               */ 03454000
*                                                                  1151 03455000
         ST    RNIPM,NVTVRREG                                      1151 03456000
*   /*****************************************************************/ 03457000
*   /*                                                               */ 03458000
*   /* SET PVTFPFN TO RBN OF FIRST PAGE ABOVE THE USED PORTION OF THE*/ 03459000
*   /* NUCLEUS BUFFER. THIS VALUE WILL REFLECT THE ACTUAL END OF THE */ 03460000
*   /* NUCLEUS IN REAL MEMORY.                                       */ 03461000
*   /*                                                               */ 03462000
*   /*****************************************************************/ 03463000
*                                                                  1152 03464000
*   RNIPM=(((NVTNUCND+4095)4095)&&4095)/256;                      1152 03465000
         LA    @14,4095                                            1152 03466000
         LR    @08,@15                                             1152 03467000
         ALR   @08,@14                                             1152 03468000
         OR    @08,@14                                             1152 03469000
         XR    @08,@14                                             1152 03470000
         SRL   @08,8                                               1152 03471000
         LR    RNIPM,@08                                           1152 03472000
*   CVTPVTP->PVTFPFN=RNIPM;         /* SET PVTFPFN FIELD TO RBN      */ 03473000
         L     @06,CVTPVTP(,@06)                                   1153 03474000
         STH   RNIPM,PVTFPFN(,@06)                                 1153 03475000
*   PVTPOOL=PVTPOOL-((RNIPM/16)-PFNSAVE);/* UPDATE DYNAMIC PAGE COUNT   03476000
*                                      TO REFLECT SHIFT OF NUCLEUS 1154 03477000
*                                      END IN REAL MEMORY (IF ANY) 1154 03478000
*                                      SINCE NPMPFTBL ROUTINE YM06075*/ 03479000
*                                                                  1154 03480000
         L     @06,PVTPTR                                          1154 03481000
         LR    @00,RNIPM                                           1154 03482000
         SRL   @00,4                                               1154 03483000
         SL    @00,PFNSAVE                                         1154 03484000
         LCR   @00,@00                                             1154 03485000
         AH    @00,PVTPOOL(,@06)                                   1154 03486000
         STH   @00,PVTPOOL(,@06)                                   1154 03487000
*   /*****************************************************************/ 03488000
*   /*                                                               */ 03489000
*   /* REPLACE ANY PAGE FRAMES RESERVED BY NIPM TO BE USED IN THE    */ 03490000
*   /* LSQA/SQA TRAP ROUTINE, NPMSQBCK, BACK ON THE RSM PFTE         */ 03491000
*   /* AVAILABLE QUEUE, AND UPDATE COUNTS ACCORDINGLY. THEN DETERMINE*/ 03492000
*   /* THE POTENTIAL V=R AREA TO BE USED BY IEAVNPC8 IN PROCESSING   */ 03493000
*   /* THE REAL SYSTEM PARAMETER.                                    */ 03494000
*   /*                                                               */ 03495000
*   /*****************************************************************/ 03496000
*                                                                  1155 03497000
*   RPARM=ADDR(NPLOCKSV);           /* SET SAVE AREA FOR SETLOCK     */ 03498000
         LA    RPARM,NPLOCKSV                                      1155 03499000
*   GENERATE REFS(PSALITA,FLC);                                    1156 03500000
            STM 0,15,0(RPARM)          SAVE REGISTERS ACCROSS SETLOCK   03501000
NPMVRRGL    SETLOCK OBTAIN,TYPE=SALLOC,MODE=UNCOND,                    *03502000
               RELATED=(RSM,IEAVNIPM(NPMVRRFL))                         03503000
            LM 0,15,0(RPARM)              RESTORE REGISTERS             03504000
*   IF NPMAFQF^=0                   /* ANY NIPM FRAMES TO RETURN     */ 03505000
*     THEN                          /* IF SO, GIVE THEM TO RSM.      */ 03506000
         ICM   @06,3,NPMAFQF                                       1157 03507000
         BZ    @RF01157                                            1157 03508000
*     DO;                                                          1158 03509000
*       IF PVTAFQF=0                /* IS RSM QUEUE EMPTY            */ 03510000
*         THEN                      /* IF SO , MAKES IT EASY         */ 03511000
         L     @06,PVTPTR                                          1159 03512000
         LH    @00,PVTAFQF(,@06)                                   1159 03513000
         N     @00,@CF05060                                        1159 03514000
         LTR   @00,@00                                             1159 03515000
         BNZ   @RF01159                                            1159 03516000
*         DO;                                                      1160 03517000
*           PVTAFQF=NPMAFQF;        /* FIRST PFTE INDEX              */ 03518000
         MVC   PVTAFQF(2,@06),NPMAFQF                              1161 03519000
*           PVTAFQL=NPMAFQL;        /* LAST PFTE INDEX               */ 03520000
         MVC   PVTAFQL(2,@06),NPMAFQL                              1162 03521000
*         END;                                                     1163 03522000
*       ELSE                                                       1164 03523000
*         DO;                       /* ADD TO FRONT OF RSM QUEUE     */ 03524000
         B     @RC01159                                            1164 03525000
@RF01159 DS    0H                                                  1165 03526000
*           PFTEPTR=PVTPFTP+PVTAFQF;/* ADDR OF RSM 1ST PFTE          */ 03527000
         L     @06,PVTPTR                                          1165 03528000
         L     @08,PVTPFTP(,@06)                                   1165 03529000
         LH    PFTEPTR,PVTAFQF(,@06)                               1165 03530000
         N     PFTEPTR,@CF05060                                    1165 03531000
         ALR   PFTEPTR,@08                                         1165 03532000
*           PFTBQPTR=NPMAFQL;       /* BACK CHAIN TO LAST NIPM PFTE  */ 03533000
         MVC   PFTBQPTR(2,PFTEPTR),NPMAFQL                         1166 03534000
*           PFTEPTR=PVTPFTP+NPMAFQL;/* ADDR OF LAST PFTE             */ 03535000
         SLR   PFTEPTR,PFTEPTR                                     1167 03536000
         ICM   PFTEPTR,3,NPMAFQL                                   1167 03537000
         ALR   @08,PFTEPTR                                         1167 03538000
         LR    PFTEPTR,@08                                         1167 03539000
*           PFTFQPTR=PVTAFQF;       /* FORWARD CHAIN TO RSM FIRST    */ 03540000
         MVC   PFTFQPTR(2,PFTEPTR),PVTAFQF(@06)                    1168 03541000
*           PVTAFQF=NPMAFQF;        /* FIRST PFTE INDEX              */ 03542000
         MVC   PVTAFQF(2,@06),NPMAFQF                              1169 03543000
*         END;                                                     1170 03544000
*     END;                                                         1171 03545000
*   ELSE                                                           1172 03546000
*     ;                                                            1172 03547000
@RF01157 DS    0H                                                  1173 03548000
*   PVTAFC=PVTAFC+NPMAFC;           /* UPDATE RSM FRAME COUNT        */ 03549000
@RC01157 L     @06,PVTPTR                                          1173 03550000
         LH    @00,PVTAFC(,@06)                                    1173 03551000
         AH    @00,NPMAFC                                          1173 03552000
         STH   @00,PVTAFC(,@06)                                    1173 03553000
*   PVTPSQA=NVTPQSAV;               /* RESET TRAP TO RSM ADDRESS     */ 03554000
         L     @00,NVTPQSAV                                        1174 03555000
         ST    @00,PVTPSQA(,@06)                                   1174 03556000
*   IF NPMAFQF=0                    /* NONE ON NIPM QUEUE            */ 03557000
*     THEN                          /* USE LAST ONE THAT WAS RESERVED   03558000
*                                      AS TOP OF V=R ELECT           */ 03559000
         ICM   @06,3,NPMAFQF                                       1175 03560000
         BNZ   @RF01175                                            1175 03561000
*     NVTVRLNG=(NPMAFQL-(NVTVRREG/256))/LENGTH(PFTE);/* GIVES NO. OF    03562000
*                                      4K PAGES IN THAT AREA         */ 03563000
         L     @06,NVTVRREG                                        1176 03564000
         SRL   @06,8                                               1176 03565000
         LR    @14,@06                                             1176 03566000
         LCR   @14,@14                                             1176 03567000
         SLR   @06,@06                                             1176 03568000
         ICM   @06,3,NPMAFQL                                       1176 03569000
         ALR   @14,@06                                             1176 03570000
         SRDA  @14,32                                              1176 03571000
         D     @14,@CF00081                                        1176 03572000
         ST    @15,NVTVRLNG                                        1176 03573000
*   ELSE                            /* OTHERWISE, USE THE LAST ONE 1177 03574000
*                                      ASSIGNED.                     */ 03575000
*     NVTVRLNG=(NPMAFQF-(NVTVRREG/256))/LENGTH(PFTE);/*      @ZA10750*/ 03576000
         B     @RC01175                                            1177 03577000
@RF01175 L     @06,NVTVRREG                                        1177 03578000
         SRL   @06,8                                               1177 03579000
         LR    @14,@06                                             1177 03580000
         LCR   @14,@14                                             1177 03581000
         SLR   @06,@06                                             1177 03582000
         ICM   @06,3,NPMAFQF                                       1177 03583000
         ALR   @14,@06                                             1177 03584000
         SRDA  @14,32                                              1177 03585000
         D     @14,@CF00081                                        1177 03586000
         ST    @15,NVTVRLNG                                        1177 03587000
*   RPARM=ADDR(NPLOCKSV);           /* SETUP SAVEAREA FOR SETLOCK    */ 03588000
@RC01175 LA    RPARM,NPLOCKSV                                      1178 03589000
*   GENERATE REFS(PSALITA,FLC);                                    1179 03590000
            STM 0,15,0(RPARM)          SAVE REGISTERS DURING SETLOCK    03591000
NPMVRRFL SETLOCK RELEASE,TYPE=SALLOC,RELATED=(RSM,IEAVNIPM(NPMVRRGL))   03592000
            LM 0,15,0(RPARM)           RESTORE REGISTERS                03593000
*   NVTVVPG1=NPMVVPG1;              /* RESTORE VVPG1 TO ORIGINAL - 1180 03594000
*                                      NOW POINTING TO TOP OF NIP  1180 03595000
*                                      TRANSIENT AREA                */ 03596000
         L     @06,NPMVVPG1                                        1180 03597000
         ST    @06,NVTVVPG1                                        1180 03598000
*   GEN(LM RNVT,RPARM,VRREGSAV);    /* RESTORE REGISTERS             */ 03599000
         LM RNVT,RPARM,VRREGSAV                                         03600000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 03601000
         BR REXIT                                                       03602000
*VRREGSAV:                          /* SAVE AREA LABEL               */ 03603000
*   GEN(DS 16F);                    /* SAVE AREA FOR REGISTERS       */ 03604000
VRREGSAV DS 16F                                                         03605000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 03606000
*    (RPARM,                                                       1184 03607000
*     RNVT,                                                        1184 03608000
*     RCVT,                                                        1184 03609000
*     PFTEPTR,                                                     1184 03610000
*     RNIPM) UNRESTRICTED;                                         1184 03611000
*   END NPMVRREG;                   /* END OF NPMVRREG ROUTINE       */ 03612000
@EL00015 DS    0H                                                  1185 03613000
@EF00015 DS    0H                                                  1185 03614000
@ER00015 BR    @14                                                 1185 03615000
*NPMMCTRP:                                                         1186 03616000
*                                                                  1186 03617000
*   /*****************************************************************/ 03618000
*   /*                                                               */ 03619000
*   /* THIS ROUTINE IS THE MACHINE CHECK TRAP ROUTINE FOR NIP. UPON  */ 03620000
*   /* ENTRY TO IEAVNIPM FROM IEAVNIP0, THE MACHINE CHECK NEW PSW IN */ 03621000
*   /* THE PSA FOR EACH ACTIVE CPU IS POINTED TO A TRAP IN IEAVNIP0  */ 03622000
*   /* THAT WILL LOAD A WAIT STATE PSW. IEAVNIPM RESETS ALL THESE    */ 03623000
*   /* PSW'S TO POINT TO THIS TRAP ROUTINE. THE SYSGENED MACHINE     */ 03624000
*   /* CHECK NEW PSW WAS SAVED BY IEAVNIP0 IN THE NVTMCPSW FIELD OF  */ 03625000
*   /* THE NVT, AND IS RESTORED BY IEAVNP06. THIS ROUTINE WILL       */ 03626000
*   /* ATTEMPT TO GET THE NIP LOCK AND THEN TAKE THE CPU LOGICAL     */ 03627000
*   /* ADDRESS AND A WAIT STATE CODE AND PASS IT TO THE NIPSWAIT     */ 03628000
*   /* ROUTINE WHICH WILL IN TURN INVOKE THE RMS SYSTEM TERMINATION  */ 03629000
*   /* ROUTINE. WHEN THE SYSTEM IS PLACED IN A DISABLED WAIT STATE,  */ 03630000
*   /* THE LOGICAL CPU ADDR AND THE WAIT STATE CODE WILL BE          */ 03631000
*   /* DISPLAYED.                                                    */ 03632000
*   /*                                                               */ 03633000
*   /*****************************************************************/ 03634000
*                                                                  1186 03635000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1186 03636000
NPMMCTRP DS    0H                                                  1187 03637000
*   GENERATE;                                                      1187 03638000
*                                       /* SETUP ADDRESSABILITY      */ 03639000
          BALR  15,0                                                    03640000
NPMMC     L     RNVT,NPMMCADC-NPMMC(0,15) /* GET NVT ADDRESS         */ 03641000
          LM    RBASE,RBASE2,NVTNIPM-NVT(RNVT) GET BASE REGISTERS       03642000
*   CALL NIPLKCHK;                  /* GO GET THE NIP LOCK-PREVENTS     03643000
*                                      RECURSION IF 2 CPUS GET HITS     03644000
*                                      ONLY 1 WILL GO TO SYS TERM    */ 03645000
         BAL   @14,NIPLKCHK                                        1188 03646000
*   IF NVTMP='1'B THEN              /* STAP EXECUTABLE?      @ZA10135*/ 03647000
         TM    NVTMP,B'00100000'                                   1189 03648000
         BNO   @RF01189                                            1189 03649000
*     STAP(NPMCHCPU);               /* GET PHYS. ADDR OF THE CPU THIS   03650000
*                                      CODE IS EXECUTING ON. @ZA10135*/ 03651000
         STAP  NPMCHCPU                                            1190 03652000
*   NPMIDPSW=NPMCHCPU+'40'X;        /* GET LOGICAL CPU ADDR  @ZA10135*/ 03653000
@RF01189 LA    @06,64                                              1191 03654000
         LH    @08,NPMCHCPU                                        1191 03655000
         N     @08,@CF05060                                        1191 03656000
         ALR   @06,@08                                             1191 03657000
         STH   @06,NPMIDPSW                                        1191 03658000
*   NPMFLWSC=NVTWCN14;              /* SET WAIT STATE CODE           */ 03659000
         MVI   NPMFLWSC,X'44'                                      1192 03660000
*   GEN( IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE THE IPL          */ 03661000
          IEAPMNIP TYPE=SWAIT,MOD=NIPM                                  03662000
*NPMMCADC:                                                         1194 03663000
*   GEN( DC  A(NVT));               /* ADCON FOR NVT                 */ 03664000
NPMMCADC  DC  A(NVT)                                                    03665000
*   END NPMMCTRP;                   /* END OF ROUTINE                */ 03666000
@EL00016 DS    0H                                                  1195 03667000
@EF00016 DS    0H                                                  1195 03668000
@ER00016 BR    @14                                                 1195 03669000
*NPMMFA:                                                           1196 03670000
*                                                                  1196 03671000
*   /*****************************************************************/ 03672000
*   /*                                                               */ 03673000
*   /* THIS ROUTINE IS THE MALFUNCTION ALERT TRAP FOR NIP. IEAVNIP0  */ 03674000
*   /* SAVES THE ADDRESS TO THE SYSTEM MFA ROUTINE IN THE NVTMFASA   */ 03675000
*   /* FIELD OF THE NVT AND REPLACES IT WITH A POINTER TO A TRAP     */ 03676000
*   /* ROUTINE. IEAVNIPM REPLACES THE IEAVNIP0 TRAP ROUTINE POINTER  */ 03677000
*   /* WITH A POINTER TO THIS ROUTINE. IEAVNIPX WILL REPLACE THE MFA */ 03678000
*   /* TRAP ADDRESS WITH THE ADDRESS OF THE REAL SYSTEM MFA ROUTINE  */ 03679000
*   /* BEFORE EXIT TO IEEVIPL AT THE END OF NIP. THIS ROUTINE SAVES  */ 03680000
*   /* THE CPUAD OF THE FAILING CPU, AND CONVERTS IT TO A LOGICAL CPU*/ 03681000
*   /* ADDRESS. THE LOGICAL CPU ADDRESS AND THE WAIT STATE CODE FOR  */ 03682000
*   /* MFA ARE PASSED TO THE NIPSWAIT ROUTINE WHICH WILL TERMINATE   */ 03683000
*   /* THE SYSTEM. WHEN THE SYSTEM IS PLACED IN A DISABLED WAIT      */ 03684000
*   /* STATE, THE LOGICAL CPU ADDRESS AND WAIT STATE CODE WILL BE IN */ 03685000
*   /* THE ADDRESS PORTION OF THE WAIT STATE PSW.                    */ 03686000
*   /*                                                               */ 03687000
*   /*****************************************************************/ 03688000
*                                                                  1196 03689000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1196 03690000
NPMMFA   DS    0H                                                  1197 03691000
*   GENERATE;                                                      1197 03692000
*                                       /* SETUP ADDRESSABILITY      */ 03693000
           BALR  15,0                                                   03694000
NPMMFA1    L     RNVT,NPMMFADC-NPMMFA1(0,15) /* GET ADDRESS OF NVT   */ 03695000
           LM    RBASE,RBASE2,NVTNIPM-NVT(RNVT) SETUP BASE REGISTERS    03696000
*   CALL NIPLKCHK;                  /* GO GET NIP LOCK               */ 03697000
         BAL   @14,NIPLKCHK                                        1198 03698000
*   NPMIDPSW=PSASPAD+'40'X;         /* GET LOGICAL CPU ADDRESS - MFA    03699000
*                                      STORES FAILING CPU @          */ 03700000
         SLR   @06,@06                                             1199 03701000
         LA    @08,64                                              1199 03702000
         AH    @08,PSASPAD(,@06)                                   1199 03703000
         STH   @08,NPMIDPSW                                        1199 03704000
*   NPMFLWSC=NVTF0MFA;              /* SAVE WAIT STATE CODE          */ 03705000
         MVI   NPMFLWSC,X'47'                                      1200 03706000
*   GEN( IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE THE IPL          */ 03707000
          IEAPMNIP TYPE=SWAIT,MOD=NIPM                                  03708000
*NPMMFADC:                                                         1202 03709000
*   GEN( DC A(NVT));                /* ADCON FOR NVT                 */ 03710000
NPMMFADC  DC A(NVT)                                                     03711000
*   END NPMMFA;                     /* END OF ROUTINE                */ 03712000
@EL00017 DS    0H                                                  1203 03713000
@EF00017 DS    0H                                                  1203 03714000
@ER00017 BR    @14                                                 1203 03715000
@PB00017 DS    0H                                                  1204 03716000
*   GEN( DS  0F);                   /* ALLIGN RTM TRAP ON FULLWORD   */ 03717000
          DS  0F                                                        03718000
*NPRTMTAB:                                                         1205 03719000
*                                                                  1205 03720000
*   /*****************************************************************/ 03721000
*   /*                                                               */ 03722000
*   /* THIS ROUTINE CONSISTS OF A TABLE USED TO REPLACE THE RTM1     */ 03723000
*   /* TABLE POINTED TO BY CVTBTERM, AND CODE TO DIAGNOSE THE ENTRY  */ 03724000
*   /* TAKEN AND INTERFACE WITH NIPSWAIT TO TERMINATE THE IPL        */ 03725000
*   /* PROCESS. ALL ENTRIES TO RTM1 ARE TRAPPED TO PREVENT FRR'S FROM*/ 03726000
*   /* GETTING CONTROL DURING NIP WHEN THE THE SYSTEM IS IN A        */ 03727000
*   /* VARIABLE STATE OF INITIALIZATION. IF FRR'S WERE ALLOWED TO    */ 03728000
*   /* EXECUTE AT THIS TIME, RESOURCES REQUIRED BY THEM MIGHT NOT BE */ 03729000
*   /* AVAILABLE RESULTING IN THE PROPAGATION OF FURTHUR ERRORS.     */ 03730000
*   /* ALSO, THE RTM IS NOT FULLY INITIALIZED UNTIL MID WAY THROUGH  */ 03731000
*   /* NIP PROCESSING. IT IS ASSUMED THAT ALL ENTRIES TO THE RTM     */ 03732000
*   /* INDICATE THAT AN ERROR IN THE SYSTEM SOFTWARE/HARDWARE HAS    */ 03733000
*   /* OCCURRED. THE POSSIBLE EXCEPTION TO THIS IS TASK TERMINATION  */ 03734000
*   /* WHICH SHOULD NOT BE ENTERED DURING NIP SINCE NIP AND ASM ARE  */ 03735000
*   /* THE ONLY FUNCTIONS RUNNING AT THAT TIME. THIS ROUTINE, AFTER  */ 03736000
*   /* TRAPPING THE ENTRY TO RTM1, GENERATES A CODE INDICATING WHICH */ 03737000
*   /* ENTRY WAS TAKEN, AND PASSES THE CODE AND A WAIT STATE CODE TO */ 03738000
*   /* THE NIPSWAIT ROUTINE. WHEN THE SYSTEM IS PLACED IN A WAIT     */ 03739000
*   /* STATE, THE RIGHT HALF OF THE WAIT STATE PSW WILL CONTAIN THE  */ 03740000
*   /* RTM TRAP ENTRY CODE AND A WAIT STATE CODE IDENTIFYING THE WAIT*/ 03741000
*   /* STATE CONDITION.                                              */ 03742000
*   /*                                                               */ 03743000
*   /*****************************************************************/ 03744000
*                                                                  1205 03745000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1205 03746000
         B     @PB00018                                            1205 03747000
NPRTMTAB DS    0H                                                  1206 03748000
*   RESPECIFY                                                      1206 03749000
*    (RPARM,                                                       1206 03750000
*     RNVT,                                                        1206 03751000
*     RENTRY,                                                      1206 03752000
*     RCVT) RESTRICTED;                                            1206 03753000
*   GENERATE;                                                      1207 03754000
         BALR  15,0               COMPATIBLE ABTERM ENTRY               03755000
         DC    XL2'0700'          USE UP REST OF FULLWORD               03756000
         DC    XL2'47FF'          UNCONDITIONAL BRANCH OP               03757000
         DC    AL2((NPRTTRAP-NPRTMTAB)-2) DISPLACEMENT TO ROUTINE       03758000
         DC    A(NPRTENT2)         RTM1 ENTRY 2 ADDRESS                 03759000
         DC    A(NPRTENT3)         RTM1 ENTRY 3 TRAP ADDRESS            03760000
         DC    A(NPRTENT4)         RTM1 ENTRY 4 TRAP ADDRESS            03761000
         DC    A(NPRTENT5)         RTM1 ENTRY 5 TRAP ADDRESS            03762000
         DC    A(NPRTENT6)         RTM1 ENTRY 6 TRAP ADDRESS            03763000
         DC    A(NPRTENT7)         RTM1 ENTRY 7 TRAP ADDRESS            03764000
         DC    A(NPRTENT8)         RTM1 ENTRY 8 TRAP ADDRESS            03765000
         DC    A(NPRTENT9)         RTM1 ENTRY 9 TRAP ADDRESS            03766000
         DC    A(NPRTEN10)         RTM1 ENTRY 10 TRAP ADDRESS           03767000
         DC    A(NPRTEN11)         RTM1 ENTRY 11 TRAP ADDRESS           03768000
         DC    A(NPRTEN12)         RTM1 ENTRY 12 TRAP ADDRESS           03769000
         DC    A(NPRTEN13)         RTM1 ENTRY 13 TRAP ADDRESS           03770000
         DC    A(NPRTEN14)         RTM1 ENTRY 14 TRAP ADDRESS           03771000
         DC    A(NPRTEN15)         RTM1 ENTRY 15 TRAP ADDRESS           03772000
NPRTTRAP BALR  15,0                FIRST ENTRY TO RTM ROUTINE           03773000
NPRTENT1 STM   0,15,NPRTMSAV-NPRTENT1(RENTRY) SAVE CALLERSREGS @YM08196 03774000
         LA    RPARM,1             INDICATE ENTRY 1 CALLED              03775000
         L     15,NPRTADCN-NPRTENT1(0,RENTRY) GET ADDR OF NIP RTM       03776000
         BR    RENTRY              GO PROCESS ERROR                     03777000
NPRTENT2 STM   0,15,NPRTMSAV-NPRTENT2(RENTRY) SAVE CALLERSREGS @YM08196 03778000
         L     RENTRY,NPRTADCN-NPRTENT2(0,RENTRY) ADDR OF NIP RTM       03779000
         LA    RPARM,2             INDICATE ENTRY 2 CALLED              03780000
         BR    RENTRY              GO PROCESS ERROR                     03781000
NPRTENT3 STM   0,15,NPRTMSAV-NPRTENT3(RENTRY) SAVE CALLERSREGS @YM08196 03782000
         L     RENTRY,NPRTADCN-NPRTENT3(0,RENTRY) ADDR OF NIP RTM       03783000
         LA    RPARM,3             INDICATE ENTRY 3 CALLED              03784000
         BR    RENTRY              GO PROCESS ERROR                     03785000
NPRTENT4 STM   0,15,NPRTMSAV-NPRTENT4(RENTRY) SAVE CALLERSREGS @YM08196 03786000
         L     RENTRY,NPRTADCN-NPRTENT4(0,RENTRY) ADDR OF NIP RTM       03787000
         LA    RPARM,4             INDICATE ENTRY 4 CALLED              03788000
         BR    RENTRY              GO PROCESS ERROR                     03789000
NPRTENT5 STM   0,15,NPRTMSAV-NPRTENT5(RENTRY) SAVE CALLERSREGS @YM08196 03790000
         L     RENTRY,NPRTADCN-NPRTENT5(0,RENTRY) ADDR OF NIP RTM       03791000
         LA    RPARM,5             INDICATE ENTRY 5 CALLED              03792000
         BR    RENTRY              GO PROCESS ERROR                     03793000
NPRTENT6 STM   0,15,NPRTMSAV-NPRTENT6(RENTRY) SAVE CALLERSREGS @YM08196 03794000
         L     RENTRY,NPRTADCN-NPRTENT6(0,RENTRY) ADDR OF NIP RTM       03795000
         LA    RPARM,6             INDICATE ENTRY 6 CALLED              03796000
         BR    RENTRY              GO PROCESS ERROR                     03797000
NPRTENT7 STM   0,15,NPRTMSAV-NPRTENT7(RENTRY) SAVE CALLERSREGS @YM08196 03798000
         L     RENTRY,NPRTADCN-NPRTENT7(0,RENTRY) ADDR OF NIP RTM       03799000
         LA    RPARM,7             INDICATE ENTRY 7 CALLED              03800000
         BR    RENTRY              GO PROCESS ERROR                     03801000
NPRTENT8 STM   0,15,NPRTMSAV-NPRTENT8(RENTRY) SAVE CALLERSREGS @YM08196 03802000
         L     RENTRY,NPRTADCN-NPRTENT8(0,RENTRY) ADDR OF NIP RTM       03803000
         LA    RPARM,8             INDICATE ENTRY 8 CALLED              03804000
         BR    RENTRY              GO PROCESS ERROR                     03805000
NPRTENT9 STM   0,15,NPRTMSAV-NPRTENT9(RENTRY) SAVE CALLERSREGS @YM08196 03806000
         L     RENTRY,NPRTADCN-NPRTENT9(0,RENTRY) ADDR OF NIP RTM       03807000
         LA    RPARM,9             INDICATE ENTRY 9 CALLED              03808000
         BR    RENTRY              GO PROCESS ERROR                     03809000
NPRTEN10 STM   0,15,NPRTMSAV-NPRTEN10(RENTRY) SAVE CALLERSREGS @YM08196 03810000
         L     RENTRY,NPRTADCN-NPRTEN10(0,RENTRY) ADDR OF NIP RTM       03811000
         LA    RPARM,10            INDICATE ENTRY 10 CALLED             03812000
         BR    RENTRY              GO PROCESS ERROR                     03813000
NPRTEN11 STM   0,15,NPRTMSAV-NPRTEN11(RENTRY) SAVE CALLERSREGS @YM08196 03814000
         L     RENTRY,NPRTADCN-NPRTEN11(0,RENTRY) ADDR OF NIP RTM       03815000
         LA    RPARM,11            INDICATE ENTRY 11 CALLED             03816000
         BR    RENTRY              GO PROCESS ERROR                     03817000
NPRTEN12 STM   0,15,NPRTMSAV-NPRTEN12(RENTRY) SAVE CALLERSREGS @YM08196 03818000
         L     RENTRY,NPRTADCN-NPRTEN12(0,RENTRY) ADDR OF NIP RTM       03819000
         LA    RPARM,12            INDICATE ENTRY 12 CALLED             03820000
         BR    RENTRY              GO PROCESS ERROR                     03821000
NPRTEN13 STM   0,15,NPRTMSAV-NPRTEN13(RENTRY) SAVE CALLERSREGS @YM08196 03822000
         L     RENTRY,NPRTADCN-NPRTEN13(0,RENTRY) ADDR OF NIP RTM       03823000
         LA    RPARM,13            INDICATE ENTRY 13 CALLED             03824000
         BR    RENTRY              GO PROCESS ERROR                     03825000
NPRTEN14 STM   0,15,NPRTMSAV-NPRTEN14(RENTRY) SAVE CALLERSREGS @YM08196 03826000
         L     RENTRY,NPRTADCN-NPRTEN14(0,RENTRY) ADDR OF NIP RTM       03827000
         LA    RPARM,14            INDICATE ENTRY 14 CALLED             03828000
         BR    RENTRY              GO PROCESS ERROR                     03829000
NPRTEN15 STM   0,15,NPRTMSAV-NPRTEN15(RENTRY) SAVE CALLERSREGS @YM08196 03830000
         L     RENTRY,NPRTADCN-NPRTEN15(0,RENTRY) ADDR OF NIP RTM       03831000
         LA    RPARM,15            INDICATE ENTRY 15 CALLED             03832000
         BR    RENTRY              GO PROCESS ERROR                     03833000
NPRTADCN DC    A(NIPRTMTR)         ADDRESS OF RTM TRAP ROUTINE          03834000
*                                                                  1208 03835000
*   /*****************************************************************/ 03836000
*   /*                                                               */ 03837000
*   /* THIS ROUTINE GETS CONTROL VIA THE NIP RTM1 TRAP TABLE THAT IS */ 03838000
*   /* DEFINED ABOVE WHEN THE RTM IS CALLED FROM WITHIN THE SYSTEM.  */ 03839000
*   /* IT TAKES THE RTM1 ENTRY CODE PLACED IN RPARM BY THE NIP RTM   */ 03840000
*   /* TRAPS AND PASSES IT ALONG WITH A WAIT STATE CODE TO THE       */ 03841000
*   /* NIPSWAIT ROUTINE TO TERMINATE THE IPL PROCESS.                */ 03842000
*   /*                                                               */ 03843000
*   /*****************************************************************/ 03844000
*                                                                  1208 03845000
*NIPRTMTR:                                                         1208 03846000
*   GENERATE;                                                      1208 03847000
NIPRTMTR DS    0H                                                  1208 03848000
*                                      /* SETUP ADDRESSABILITY      */  03849000
         BALR RENTRY,0                                                  03850000
NPMRTM   L    RNVT,NPRTMNVT-NPMRTM(0,RENTRY) GET ADDRESS OF NVT         03851000
         LM   RBASE,RBASE2,NVTNIPM-NVT(RNVT) SETUP BASE REGS FOR NIPM   03852000
*   CALL NIPLKCHK;                  /* GO GET NIP LOCK               */ 03853000
         BAL   @14,NIPLKCHK                                        1209 03854000
*   NPMIDPSW=RPARM;                 /* SAVE ENTRY IDENTIFIER         */ 03855000
         STH   RPARM,NPMIDPSW                                      1210 03856000
*   NPMFLWSC=NVTWCN11;              /* SET WAIT STATE CODE           */ 03857000
         MVI   NPMFLWSC,X'64'                                      1211 03858000
*   GEN( IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE THE IPL          */ 03859000
          IEAPMNIP TYPE=SWAIT,MOD=NIPM                                  03860000
*NPRTMNVT:                                                         1213 03861000
*   GEN( DC  A(NVT));               /* ADCON FOR NVT                 */ 03862000
NPRTMNVT  DC  A(NVT)                                                    03863000
*NPRTMSAV:                                                         1214 03864000
*   GEN( DS  16F);                  /* CALLERS REG SAVE AREA @YM06975*/ 03865000
NPRTMSAV  DS  16F                                                       03866000
*   END NPRTMTAB;                   /* END OF RTM TRAP ROUTINE       */ 03867000
@EL00018 DS    0H                                                  1215 03868000
@EF00018 DS    0H                                                  1215 03869000
@ER00018 BR    @14                                                 1215 03870000
*   RESPECIFY                                                      1216 03871000
*    (RPARM,                                                       1216 03872000
*     RNVT,                                                        1216 03873000
*     RENTRY,                                                      1216 03874000
*     RCVT) UNRESTRICTED;                                          1216 03875000
*NIPLKCHK:                                                         1217 03876000
*                                                                  1217 03877000
*   /*****************************************************************/ 03878000
*   /*                                                               */ 03879000
*   /* THIS ROUTINE IS CALLED BY OTHER NIP ABNORMAL CONDITION        */ 03880000
*   /* DETECTION ROUTINES TO OBTAIN THE NIP LOCK AND THUS BLOCK      */ 03881000
*   /* RECURSIVE ENTRIES TO THE NIP TERMINATION PROCESS. THE NIP LOCK*/ 03882000
*   /* IS OBTAINED ONLY ONCE AND NEVER FREED. IF A RECURSION OCCURS, */ 03883000
*   /* THE CPU DETECTING THE ERROR IS PLACED IN A DISABLED WAIT      */ 03884000
*   /* STATE. IF THE LOCK IS OBTAINED, THIS ROUTINE RETURNS TO CALLER*/ 03885000
*   /* AND WITH THIS CPU DISABLED FOR I/O AND EXTERNAL INTERRUPTS.   */ 03886000
*   /*                                                               */ 03887000
*   /*****************************************************************/ 03888000
*                                                                  1217 03889000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1217 03890000
NIPLKCHK DS    0H                                                  1218 03891000
*   RESPECIFY                       /* RESTRICT REGISTES USED        */ 03892000
*    (RCS1,                         /* WORK REG                      */ 03893000
*     RCS3,                         /* WORK REG                      */ 03894000
*     RNVT) RESTRICTED;             /* ADDR OF NVT                   */ 03895000
*   GEN REFS(NIPDISAB)( STNSM NIPDISAB,X'FC');/* DISABLE             */ 03896000
          STNSM NIPDISAB,X'FC'                                          03897000
*   RCS3=PSACPULA;                  /* GET ADDRESS OF THIS CPU       */ 03898000
         SLR   @06,@06                                             1220 03899000
         LH    RCS3,PSACPULA(,@06)                                 1220 03900000
*   RCS1=0;                         /* CS ARGUMENT IS 0              */ 03901000
         SLR   RCS1,RCS1                                           1221 03902000
*   GENERATE REFS(NIPLOCK,RCS1,RCS3,REXIT);                        1222 03903000
            CS RCS1,RCS3,NIPLOCK        GET THE NIP LOCK                03904000
            BCR 8,REXIT                 GOT IT, RETURN TO CALLER        03905000
*   IF NPMFLWSC^=0                  /* ERROR TRAP IN PROGESS?        */ 03906000
*     THEN                          /* IF SO, PICK THAT PSW          */ 03907000
         CLI   NPMFLWSC,0                                          1223 03908000
         BE    @RF01223                                            1223 03909000
*     GEN( LPSW NPMWTPSW);          /* PUT SYSTEM IN WAIT STATE      */ 03910000
*                                                                  1224 03911000
          LPSW NPMWTPSW                                                 03912000
*   /*****************************************************************/ 03913000
*   /*                                                               */ 03914000
*   /* OTHER WISE, A NIP MODULE DETECTED AN ERROR AND IS GOING       */ 03915000
*   /* THROUGH SYSTEM TERMINATION PROCESS, SO SELECT THE PSW FROM THE*/ 03916000
*   /* NVT AND STOP THIS CPU.                                        */ 03917000
*   /*                                                               */ 03918000
*   /*****************************************************************/ 03919000
*                                                                  1225 03920000
*   GEN( LPSW NVTWTPSW);            /* PUT SYSTEM IN WAIT STATE      */ 03921000
@RF01223 DS    0H                                                  1225 03922000
          LPSW NVTWTPSW                                                 03923000
*   RESPECIFY                                                      1226 03924000
*    (RCS1,                                                        1226 03925000
*     RCS3,                                                        1226 03926000
*     RNVT) UNRESTRICTED;           /* FREE REGISTERS                */ 03927000
*   END NIPLKCHK;                   /* END OF NIPLKCHK ROUTINE       */ 03928000
@EL00019 DS    0H                                                  1227 03929000
@EF00019 DS    0H                                                  1227 03930000
@ER00019 BR    @14                                                 1227 03931000
*NIPSQEND:                          /* GET-SQA TRAP ROUTINE          */ 03932000
*                                                                  1228 03933000
*   /*****************************************************************/ 03934000
*   /*                                                               */ 03935000
*   /* THE NIPSQEND SUBROUTINE GAINS CONTROL IF AN ATTEMPT HAS BEEN  */ 03936000
*   /* MADE TO INVOKE THE PAGING SUPERVISION GET- SQA-PAGE ROUTINE   */ 03937000
*   /* PRIOR TO COMPLETION OF PAGING SUPERVISOR INITIALIZATION. IT   */ 03938000
*   /* OBTAINS THE NIP LOCK AND SETS UP A WAIT STATE CODE TO BE      */ 03939000
*   /* PASSED TO THE NIPSWAIT ROUTINE FOR SYSTEM TERMINATION. THIS   */ 03940000
*   /* TRAP IS REMOVED AFTER THE PAGE FRAME TABLE HAS BEEN CREATED   */ 03941000
*   /* AND SQA CAN NOW BE EXPANDED AS NEEDED.                        */ 03942000
*   /*                                                               */ 03943000
*   /*****************************************************************/ 03944000
*                                                                  1228 03945000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/* PROC STATEMENT              */ 03946000
*                                                                  1228 03947000
NIPSQEND DS    0H                                                  1229 03948000
*   /*****************************************************************/ 03949000
*   /*                                                               */ 03950000
*   /* RESTRICT RNVT FOR NIPSQEND SUBROUTINE                         */ 03951000
*   /*                                                               */ 03952000
*   /*****************************************************************/ 03953000
*                                                                  1229 03954000
*   RESPECIFY                                                      1229 03955000
*     RNVT RESTRICTED;                                             1229 03956000
*   GENERATE;                                                      1230 03957000
*                                      /* GEN ENTRY LINKAGE          */ 03958000
         BALR  RENTRY,0                   SET TEMP ADDRESSABILITY       03959000
NPMSQ    L     RNVT,ADDRNVT-NPMSQ(0,RENTRY)     LOAD NVT ADDRESS        03960000
         LM    RBASE,RBASE2,NVTNIPM-NVT(RNVT) RESTORE BASE REGS         03961000
*   CALL NIPLKCHK;                  /* GO GET NIP LOCK               */ 03962000
         BAL   @14,NIPLKCHK                                        1231 03963000
*   NPMFLWSC=NVTFLWSQ;              /* SET WAIT STATE CODE IN NVT    */ 03964000
         MVI   NPMFLWSC,X'36'                                      1232 03965000
*   GEN( IEAPMNIP TYPE=SWAIT,MOD=NIPM);/* TERMINATE THE IPL          */ 03966000
          IEAPMNIP TYPE=SWAIT,MOD=NIPM                                  03967000
*   GENERATE;                                                      1234 03968000
*                                      /* GENERATE NVT ADDRESS       */ 03969000
ADDRNVT  DC    A(NVT)                     NVT ADDRESS                   03970000
*   RESPECIFY                                                      1235 03971000
*     RNVT UNRESTRICTED;                                           1235 03972000
*   END NIPSQEND;                   /* END - NIPSQEND PROCEDURE      */ 03973000
@EL00020 DS    0H                                                  1236 03974000
@EF00020 DS    0H                                                  1236 03975000
@ER00020 BR    @14                                                 1236 03976000
*NPMSQBCK:                          /* SQA/LSQA PAGE BACKING TRAP    */ 03977000
*                                                                  1237 03978000
*   /*****************************************************************/ 03979000
*   /*                                                               */ 03980000
*   /* THIS ROUTINE IS BRANCH ENTERED BY VSM VIA THE PVTPSQA FIELD OF*/ 03981000
*   /* THE PVT, WHEN A GETMAIN REQUEST HAS BEEN MADE FOR LSQA/SQA    */ 03982000
*   /* STORAGE. SQA/LSQA STORAGE IS LONG TERM FIXED STORAGE THAT IS  */ 03983000
*   /* BACKED UP IMMEDIATELY UPON REQUEST BY VSM BY ENTERING RSM     */ 03984000
*   /* THROUGH THE PVTPSQA FIELD OF THE PVT. IEAVNIPM TRAPS THESE    */ 03985000
*   /* REQUESTS AND CONTROLS THE ASSIGNMENT OF REAL PAGE FRAMES TO   */ 03986000
*   /* BACK LSQA/SQA BY PLACING A PFTE REPRESENTING PAGE FRAMES      */ 03987000
*   /* PREVIOUSLY RESERVED FOR THIS PURPOSE, ON THE FRONT OF THE     */ 03988000
*   /* AVAILABLE QUEUE (PVTAFQF). RSM IS GIVEN CONTROL AT THE END OF */ 03989000
*   /* THIS ROUTINES PROCESSING, AS IF CONTROL HAD COME DIRECTLY FROM*/ 03990000
*   /* VSM. RSM SELECTS THE FIRST PAGE FRAME IT FINDS, SEARCHING THE */ 03991000
*   /* AVAILABLE QUEUE, THAT IS WITHIN THE PREFERRED AREA (ABOVE THE */ 03992000
*   /* PVTLRA VALUE). THE FRAME THAT THIS ROUTINE PLACES ON THE      */ 03993000
*   /* AVAILABLE QUEUE WILL BE SELECTED BY RSM, BECAUSE IT WILL BE   */ 03994000
*   /* THE FIRST ONE CHECKED, AND WILL MEET ALL THE CRITERIA FOR     */ 03995000
*   /* SELECTION. THE PURPOSE OF THIS ROUTINE IS TO FORCE LONG FIXED */ 03996000
*   /* PAGES ASSIGNED DURING NIP TO BE PLACED IN THE UPPER PORTION OF*/ 03997000
*   /* REAL STORAGE. THIS PREVENTS POLUTION OF THE POTENTIAL V=R AREA*/ 03998000
*   /* DURING NIP PROCESS- ING. SUBROUTINE NPMPFTBL RESERVES PAGES TO*/ 03999000
*   /* BE USED BY THIS ROUTINE FOR SQA/LSQA ASSIGNMENT. THE NPMVRREG */ 04000000
*   /* ROUTINE OF NIP WILL RESET THE TRAP AND UPDATE THE RSM QUEUES  */ 04001000
*   /* AND COUNTS.                                                   */ 04002000
*   /*                                                               */ 04003000
*   /*****************************************************************/ 04004000
*                                                                  1237 04005000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);                             1237 04006000
NPMSQBCK DS    0H                                                  1238 04007000
*   GENERATE;                                                      1238 04008000
*                                                                  1238 04009000
            STM 0,15,NPMSQSAV-NPMSQBCK(15)  SAVE REGISTERS              04010000
            L   RNVT,NPMSQADC-NPMSQBCK(15)  GET NVT ADDRESS             04011000
            LM  RBASE,RBASE2,NVTNIPM-NVT(RNVT) GET BASE REGISTERS       04012000
*   /*****************************************************************/ 04013000
*   /*                                                               */ 04014000
*   /* PVTPTR ALREADY POINTS TO THE PVT, SETUP BY NPMPFTBL.          */ 04015000
*   /*                                                               */ 04016000
*   /*****************************************************************/ 04017000
*                                                                  1239 04018000
*   RESPECIFY                       /* RESTRICT REGISTERS USED       */ 04019000
*    (RNVT,                         /* ADDR OF NVT                   */ 04020000
*     PFTEPTR) RESTRICTED;          /* WORK REG FOR PFTE ADDR.       */ 04021000
*   IF PVTAFQF=0                    /* IF NO PFTES ON AVAILABLE      */ 04022000
*     THEN                          /* QUEUE,                        */ 04023000
         L     @06,PVTPTR                                          1240 04024000
         LH    @04,PVTAFQF(,@06)                                   1240 04025000
         N     @04,@CF05060                                        1240 04026000
         LTR   @04,@04                                             1240 04027000
         BZ    @RT01240                                            1240 04028000
*     GO TO NPMSQ01;                /* SKIP QUEUE SEARCH.            */ 04029000
*   PFTEPTR=PVTAFQF+PVTPFTP;        /* ADDRESS OF FIRST AV. PFTE     */ 04030000
         AL    @04,PVTPFTP(,@06)                                   1242 04031000
         LR    PFTEPTR,@04                                         1242 04032000
*   IF PFTPREF='1'B                 /* SEE IF FIRST PFTE ON THE    1243 04033000
*                                                            @YD03005*/ 04034000
*     THEN                          /* AVAILABLE QUEUE IS OK.        */ 04035000
         TM    PFTPREF(PFTEPTR),B'00000100'                        1243 04036000
         BO    @RT01243                                            1243 04037000
*     GO TO NPMSQXIT;               /* IF SO, WE ARE ALL DONE.       */ 04038000
*                                                                  1244 04039000
*   /*****************************************************************/ 04040000
*   /*                                                               */ 04041000
*   /* FIRST, SEARCH AVAILABLE QUEUE FOR PFTE'S REPRESENTING PAGE    */ 04042000
*   /* FRAMES THAT ARE IN THE PREFERRED AREA. IF ONE IS FOUND, THIS  */ 04043000
*   /* MEANS SOME SQA MUST HAVE BEEN RELEASED FREEING UP A PAGE FRAME*/ 04044000
*   /* THAT IS HIGHER IN STORAGE THAN THE ONES RESERVED FOR THIS     */ 04045000
*   /* ROUTINE. IF ONE IS FOUND, THEN THIS ROUTINE EXITS TO RSM TO   */ 04046000
*   /* ALLOW THE PAGE TO BE SELECTED.                                */ 04047000
*   /*                                                               */ 04048000
*   /*****************************************************************/ 04049000
*                                                                  1245 04050000
*   DO WHILE PFTFQPTR^=0;           /* SEARCH FOR FRAME              */ 04051000
         B     @DE01245                                            1245 04052000
@DL01245 DS    0H                                                  1246 04053000
*     IF PFTPREF='1'B               /* IS FRAME IN PREFERRED AREA  1246 04054000
*                                                            @YD03005*/ 04055000
*       THEN                                                       1246 04056000
         TM    PFTPREF(PFTEPTR),B'00000100'                        1246 04057000
         BO    @RT01246                                            1246 04058000
*       GO TO NPMSQXIT;             /* IF SO, EXIT TO RSM            */ 04059000
*     ELSE                          /* OTHERWISE, CHECK NEXT FRAME   */ 04060000
*       PFTEPTR=PFTFQPTR+PVTPFTP;   /* CALCULATE NEW ADDR            */ 04061000
         LH    @06,PFTFQPTR(,PFTEPTR)                              1248 04062000
         N     @06,@CF05060                                        1248 04063000
         L     @04,PVTPTR                                          1248 04064000
         AL    @06,PVTPFTP(,@04)                                   1248 04065000
         LR    PFTEPTR,@06                                         1248 04066000
*   END;                            /* GO TRY AGAIN.                 */ 04067000
*                                                                  1249 04068000
@DE01245 LH    @06,PFTFQPTR(,PFTEPTR)                              1249 04069000
         N     @06,@CF05060                                        1249 04070000
         LTR   @06,@06                                             1249 04071000
         BNZ   @DL01245                                            1249 04072000
*   /*****************************************************************/ 04073000
*   /*                                                               */ 04074000
*   /* NONE AVAILABLE ON RSM QUEUES, SO SELECT A FRAME FROM THE NIPM */ 04075000
*   /* QUEUES. FIRST, SEE IF THE NIPM FRAMES ARE ALL USED UP. IF SO, */ 04076000
*   /* RESET TRAP TO NORMAL RSM ADDRESS AND EXIT.                    */ 04077000
*   /*                                                               */ 04078000
*   /*****************************************************************/ 04079000
*                                                                  1250 04080000
*NPMSQ01:                                                          1250 04081000
*   IF NPMAFQF=0                    /* ANY PAGE FRAMES LEFT          */ 04082000
*     THEN                          /* IF NOT, RSM IS ON ITS OWN AND    04083000
*                                      POLLUTION COULD OCCUR.        */ 04084000
NPMSQ01  ICM   @06,3,NPMAFQF                                       1250 04085000
         BNZ   @RF01250                                            1250 04086000
*     DO;                                                          1251 04087000
*       PVTPSQA=NVTPQSAV;           /* RESET TRAP TO NORMAL RSM @    */ 04088000
         L     @06,NVTPQSAV                                        1252 04089000
         L     @04,PVTPTR                                          1252 04090000
         ST    @06,PVTPSQA(,@04)                                   1252 04091000
*       GO TO NPMSQXIT;             /* GO EXIT THIS ROUTINE          */ 04092000
         B     NPMSQXIT                                            1253 04093000
*     END;                                                         1254 04094000
*   ELSE                                                           1255 04095000
*     ;                                                            1255 04096000
@RF01250 DS    0H                                                  1256 04097000
*   IF PVTAFQF=0                    /* SEE IF NONE ON RSM QUEUE      */ 04098000
*     THEN                          /* IF SO, MAKES IT EASY          */ 04099000
         L     @06,PVTPTR                                          1256 04100000
         LH    @04,PVTAFQF(,@06)                                   1256 04101000
         N     @04,@CF05060                                        1256 04102000
         LTR   @04,@04                                             1256 04103000
         BNZ   @RF01256                                            1256 04104000
*     DO;                                                          1257 04105000
*       PVTAFQF=NPMAFQF;            /* PUT FIRST ONE ON RSM QUEUE    */ 04106000
         MVC   PVTAFQF(2,@06),NPMAFQF                              1258 04107000
*       PVTAFQL=NPMAFQF;            /* SAME ONE IS LAST ON RSM Q     */ 04108000
         MVC   PVTAFQL(2,@06),NPMAFQF                              1259 04109000
*       PFTEPTR=PVTPFTP+NPMAFQF;    /* GET ADDR OF PFTE              */ 04110000
         SLR   PFTEPTR,PFTEPTR                                     1260 04111000
         ICM   PFTEPTR,3,NPMAFQF                                   1260 04112000
         AL    PFTEPTR,PVTPFTP(,@06)                               1260 04113000
*       NPMAFQF=PFTFQPTR;           /* UPDATE NIPM TO NEXT PFTE      */ 04114000
         MVC   NPMAFQF(2),PFTFQPTR(PFTEPTR)                        1261 04115000
*       PFTFQPTR=0;                 /* TAKE PFTE OFF NIPM QUEUE      */ 04116000
         SLR   @06,@06                                             1262 04117000
         STH   @06,PFTFQPTR(,PFTEPTR)                              1262 04118000
*     END;                                                         1263 04119000
*   ELSE                            /* NORMAL CASE LOGIC FOLLOWS     */ 04120000
*     DO;                           /* BOTH QUEUES CONTAIN PFTE'S    */ 04121000
         B     @RC01256                                            1264 04122000
@RF01256 DS    0H                                                  1265 04123000
*       PFTEPTR=PVTPFTP+PVTAFQF;    /* ADDR OF RSM FIRST PFTE        */ 04124000
         L     @06,PVTPTR                                          1265 04125000
         L     @03,PVTPFTP(,@06)                                   1265 04126000
         LH    @08,PVTAFQF(,@06)                                   1265 04127000
         N     @08,@CF05060                                        1265 04128000
         ALR   @08,@03                                             1265 04129000
         LR    PFTEPTR,@08                                         1265 04130000
*       PFTBQPTR=NPMAFQF;           /* BACK CHAIN TO NIPM PFTE       */ 04131000
         MVC   PFTBQPTR(2,PFTEPTR),NPMAFQF                         1266 04132000
*       PFTEPTR=NPMAFQF+PVTPFTP;    /* ADDR OF NIPM PFTE             */ 04133000
         SLR   PFTEPTR,PFTEPTR                                     1267 04134000
         ICM   PFTEPTR,3,NPMAFQF                                   1267 04135000
         ALR   @03,PFTEPTR                                         1267 04136000
         LR    PFTEPTR,@03                                         1267 04137000
*       NPMAFQF=PFTFQPTR;           /* NIPM UPDATED TO NEXT PFTE     */ 04138000
         MVC   NPMAFQF(2),PFTFQPTR(PFTEPTR)                        1268 04139000
*       PFTFQPTR=PVTAFQF;           /* NIPM PFTE CHAINED TO RSM Q    */ 04140000
         MVC   PFTFQPTR(2,PFTEPTR),PVTAFQF(@06)                    1269 04141000
*       PFTEPTR=PVTPFTP+PVTAFQF;    /* ADDR OF RSM PFTE              */ 04142000
         LR    PFTEPTR,@08                                         1270 04143000
*       PVTAFQF=PFTBQPTR;           /* RSM Q NOW INCLUDES NEW PFTE   */ 04144000
         MVC   PVTAFQF(2,@06),PFTBQPTR(PFTEPTR)                    1271 04145000
*     END;                                                         1272 04146000
*                                                                  1272 04147000
*   /*****************************************************************/ 04148000
*   /*                                                               */ 04149000
*   /* A PFTE HAS NOW BEEN TRANSFERRED FROM NIPM QUEUES TO RSM       */ 04150000
*   /* AVAILABLE QUEUE. CLEAN UP NIPM QUEUE, DO ACCOUNTING, AND EXIT */ 04151000
*   /* TO RSM.                                                       */ 04152000
*   /*                                                               */ 04153000
*   /*****************************************************************/ 04154000
*                                                                  1273 04155000
*   PFTEPTR=PVTPFTP+NPMAFQF;        /* ADDR OF NEW NIPM FIRST        */ 04156000
@RC01256 SLR   @06,@06                                             1273 04157000
         ICM   @06,3,NPMAFQF                                       1273 04158000
         L     @03,PVTPTR                                          1273 04159000
         L     PFTEPTR,PVTPFTP(,@03)                               1273 04160000
         ALR   PFTEPTR,@06                                         1273 04161000
*   IF NPMAFQF^=0                   /* SEE IF QUEUE IS EMPTY         */ 04162000
*     THEN                          /* IF NOT, ZERO BACK CHAIN       */ 04163000
         LTR   @06,@06                                             1274 04164000
         BZ    @RF01274                                            1274 04165000
*     PFTBQPTR=0;                   /* IN NEW FIRST PFTE             */ 04166000
         SLR   @06,@06                                             1275 04167000
         STH   @06,PFTBQPTR(,PFTEPTR)                              1275 04168000
*   ELSE                                                           1276 04169000
*     ;                                                            1276 04170000
@RF01274 DS    0H                                                  1277 04171000
*   PVTAFC=PVTAFC+1;                /* UP RSM FRAME COUNT            */ 04172000
         L     @06,PVTPTR                                          1277 04173000
         LA    @04,1                                               1277 04174000
         AH    @04,PVTAFC(,@06)                                    1277 04175000
         STH   @04,PVTAFC(,@06)                                    1277 04176000
*   NPMAFC=NPMAFC-1;                /* DECREMENT NIPM FRAME CNT      */ 04177000
         LH    @06,NPMAFC                                          1278 04178000
         BCTR  @06,0                                               1278 04179000
         STH   @06,NPMAFC                                          1278 04180000
*NPMSQXIT:                          /* EXIT FROM THIS ROUTINE        */ 04181000
*   RENTRY=NVTPQSAV;                /* GET SAVED ADDR OF RSM         */ 04182000
NPMSQXIT L     RENTRY,NVTPQSAV                                     1279 04183000
*   GEN(LM 0,14,NPMSQSAV);          /* RESTORE REGISTERS             */ 04184000
         LM 0,14,NPMSQSAV                                               04185000
*   GEN( BR RENTRY);                /* GO TO RSM                     */ 04186000
          BR RENTRY                                                     04187000
*NPMSQSAV:                                                         1282 04188000
*   GEN(DS 16F);                    /* SAVE AREA FOR NPMSQBCK        */ 04189000
NPMSQSAV DS 16F                                                         04190000
*NPMSQADC:                                                         1283 04191000
*   GEN(DC A(NVT));                 /* NVT ADDRESS CONSTANT          */ 04192000
NPMSQADC DC A(NVT)                                                      04193000
*   RESPECIFY                       /* UNRESTRICT REGISTERS          */ 04194000
*    (RNVT,                                                        1284 04195000
*     PFTEPTR) UNRESTRICTED;                                       1284 04196000
*   END NPMSQBCK;                   /* END OF NPMSQBCK PROC          */ 04197000
@EL00021 DS    0H                                                  1285 04198000
@EF00021 DS    0H                                                  1285 04199000
@ER00021 BR    @14                                                 1285 04200000
*NIPSWAIT:                          /* LOAD DISABLED WAIT ROUTINE    */ 04201000
*                                                                  1286 04202000
*   /*****************************************************************/ 04203000
*   /*                                                               */ 04204000
*   /* THIS ROUTINE IS ENTERED FROM OTHER IEAVNIPM ROUTINES AND NIP  */ 04205000
*   /* PROCESSOR MODULES TO PLACE THE SYSTEM IN A DISABLED WAIT      */ 04206000
*   /* STATE. THE NIP WAIT STATE PSW IN THE NVT MUST BE INITIALIZED  */ 04207000
*   /* WITH APPLICABLE VARIABLES (MODULE ID, ABEND CODE OR SYSTEM    */ 04208000
*   /* FAILURE ID, AND/OR WAIT STATE CODE) PRIOR TO ENTRY TO         */ 04209000
*   /* NIPSWAIT.                                                     */ 04210000
*   /*                                                               */ 04211000
*   /*****************************************************************/ 04212000
*                                                                  1286 04213000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/* PROC STATEMENT              */ 04214000
NIPSWAIT DS    0H                                                  1287 04215000
*   DCL                                                            1287 04216000
*     WAITLVL2 CHAR(64) GENERATED;  /* NIPSWAIT SAVEAREA 2           */ 04217000
*                                                                  1287 04218000
*   /*****************************************************************/ 04219000
*   /*                                                               */ 04220000
*   /* RESTRICT REGISTERS FOR NIPSWAIT SUBROUTINE                    */ 04221000
*   /*                                                               */ 04222000
*   /*****************************************************************/ 04223000
*                                                                  1288 04224000
*   RESPECIFY                                                      1288 04225000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04226000
*     RNVT,                         /* NVT BASE REGISTER             */ 04227000
*     RCVT) RESTRICTED;             /* CVT BASE REGISTER             */ 04228000
*   GEN(NIPMENTR WAITLVL2,NIPSWAIT);/* GEN ENTRY LINKAGE             */ 04229000
         NIPMENTR WAITLVL2,NIPSWAIT                                     04230000
*   IF NIPLOCK1^=PSACPULA           /* IF NIP LOCK NOT HELD, THEN    */ 04231000
*     THEN                          /* THIS IS AN EXTERNAL CALL      */ 04232000
         SLR   @06,@06                                             1290 04233000
         CLC   NIPLOCK1(2),PSACPULA(@06)                           1290 04234000
         BE    @RF01290                                            1290 04235000
*     CALL NIPLKCHK;                /* RIM REQUEST, GO GET LOCK      */ 04236000
*                                                                  1291 04237000
         BAL   @14,NIPLKCHK                                        1291 04238000
*   /*****************************************************************/ 04239000
*   /*                                                               */ 04240000
*   /* MOVE WAIT STATE CODE TO HEX-TO-EBCDIC CONVERT AREA            */ 04241000
*   /*                                                               */ 04242000
*   /*****************************************************************/ 04243000
*                                                                  1292 04244000
*   IF NPSWAITM=0                   /* SEE IF MESSAGE WAS PASSED     */ 04245000
*     THEN                          /* IF NOT, CREATE MESSAGE        */ 04246000
@RF01290 L     @06,NPSWAITM                                        1292 04247000
         LTR   @06,@06                                             1292 04248000
         BNZ   @RF01292                                            1292 04249000
*     DO;                                                          1293 04250000
*       IF NPMFLWSC=0               /* ERROR TRAP TAKEN?             */ 04251000
*         THEN                      /* IF NOT, USE NVT INFO.         */ 04252000
         CLI   NPMFLWSC,0                                          1294 04253000
         BNE   @RF01294                                            1294 04254000
*         NPMPSW2=NVTWPSW2;         /* COPY PSW TO NIPSWAIT AREA     */ 04255000
         L     @06,NVTWPSW2                                        1295 04256000
         ST    @06,NPMPSW2                                         1295 04257000
*       CONVERT=NPMWPSW2;           /* CONVERT PSW ID PORTION        */ 04258000
@RF01294 MVI   CONVERT+4,C' '                                      1296 04259000
         MVC   CONVERT+5(15),CONVERT+4                             1296 04260000
         MVC   CONVERT(4),NPMWPSW2                                 1296 04261000
*       DIGITS=LENGTH(CODE304W);    /* SET CONVERT LENGTH            */ 04262000
         MVC   DIGITS(4),@CF00125                                  1297 04263000
*       RPARM=ADDR(DIGITS);         /* SET RPARM TO LENGTH ADDR      */ 04264000
         LA    RPARM,DIGITS                                        1298 04265000
*       CALL NIPXCDIC;              /* CALL CONVERT TO EBCDIC RTN    */ 04266000
         L     @15,@CA04764                                        1299 04267000
         BALR  @14,@15                                             1299 04268000
*       CODE304W=CONVERT(1:LENGTH(CODE304W));/* PUT IN MSG           */ 04269000
         MVC   CODE304W(8),CONVERT                                 1300 04270000
*       NPSWAITM=ADDR(IEA304W);     /* LOAD MSG HEADER ADDRESS       */ 04271000
         LA    @06,IEA304W                                         1301 04272000
         ST    @06,NPSWAITM                                        1301 04273000
*     END;                                                         1302 04274000
*   ELSE                                                           1303 04275000
*     ;                                                            1303 04276000
@RF01292 DS    0H                                                  1304 04277000
*   NVTNBFND->LRBTWSC=NPMPSW2;      /* MOVE PSW WAIT CODE TO LRB     */ 04278000
         L     @06,NVTNBFND                                        1304 04279000
         L     @00,NPMPSW2                                         1304 04280000
         ST    @00,LRBTWSC(,@06)                                   1304 04281000
*   NPMSTLRB=NVTNBFND;              /* ADDR OF LRB IN PARAM LIST     */ 04282000
         ST    @06,NPMSTLRB                                        1305 04283000
*   NPMSTADD=CVTRMS->RVTPTERM;      /* PUT ADDR OF SYS TER IN PSW    */ 04284000
         L     @06,CVTPTR                                          1306 04285000
         L     @06,CVTRMS(,@06)                                    1306 04286000
         L     @06,RVTPTERM(,@06)                                  1306 04287000
         ST    @06,NPMSTADD                                        1306 04288000
*   RPARM=ADDR(NPMSTLST);           /* GET ADDRESS OF PARM LIST      */ 04289000
         LA    RPARM,NPMSTLST                                      1307 04290000
*   GEN(LPSW  NPMSTPSW);            /* GO TO SYS TERM ROUTINE        */ 04291000
         LPSW  NPMSTPSW                                                 04292000
*   GENERATE;                                                      1309 04293000
*                                                                  1309 04294000
*                                      /* GEN NIPSWAIT SAVEAREAS     */ 04295000
WAITLVL2 DS    16F                        NIPSWAIT SAVEAREA2            04296000
*   /*****************************************************************/ 04297000
*   /*                                                               */ 04298000
*   /* RELEASE REGISTERS USED IN NIPSWAIT SUBROUTINE                 */ 04299000
*   /*                                                               */ 04300000
*   /*****************************************************************/ 04301000
*                                                                  1310 04302000
*   RESPECIFY                                                      1310 04303000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04304000
*     RNVT,                         /* NVT BASE REGISTER             */ 04305000
*     RCVT) UNRESTRICTED;           /* CVT BASE REGISTER             */ 04306000
*   END NIPSWAIT;                   /* END - NIPSWAIT PROCEDURE      */ 04307000
@EL00022 DS    0H                                                  1311 04308000
@EF00022 DS    0H                                                  1311 04309000
@ER00022 BR    @14                                                 1311 04310000
*NIPUCBFN:                          /* UCB FIND SUBROUTINE           */ 04311000
*                                                                  1312 04312000
*   /*****************************************************************/ 04313000
*   /*                                                               */ 04314000
*   /* THIS ROUTINE IS ENTERED FROM NIP PROCESSORS TO FIND A UCB     */ 04315000
*   /* RELATED TO A SPECIFIC DEVICE. THE CALLER OF NIPUCBFN SUPPLIES,*/ 04316000
*   /* AS INPUT, EITHER THE EBCDIC UNIT NAME OR THE HEXADECIMAL UNIT */ 04317000
*   /* ADDRESS (CUA) IN REGISTER RPARM.                              */ 04318000
*   /*                                                               */ 04319000
*   /*****************************************************************/ 04320000
*                                                                  1312 04321000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/* PROC STATEMENT              */ 04322000
*                                                                  1312 04323000
NIPUCBFN DS    0H                                                  1313 04324000
*   /*****************************************************************/ 04325000
*   /*                                                               */ 04326000
*   /* RESTRICT REGISTERS FOR UCB FIND SUBROUTINE                    */ 04327000
*   /*                                                               */ 04328000
*   /*****************************************************************/ 04329000
*                                                                  1313 04330000
*   RESPECIFY                                                      1313 04331000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04332000
*     RCVT) RESTRICTED;             /* CVT BASE REGISTER             */ 04333000
*   GEN(NIPMENTR UCBFNSAV,NIPUCBFN);/* GEN ENTRY LINKAGE             */ 04334000
         NIPMENTR UCBFNSAV,NIPUCBFN                                     04335000
*   GEN(LA  RSAVE,NIOSSAV);         /* SETUP SAVE AREA               */ 04336000
*                                                                  1315 04337000
         LA  RSAVE,NIOSSAV                                              04338000
*   /*****************************************************************/ 04339000
*   /*                                                               */ 04340000
*   /* THIS IF STATEMENT DETERMINES WHETHER THE PARAMETER PASSED IS  */ 04341000
*   /* AN EBCDIC UNIT NAME OR A HEXADECIMAL ADDR                     */ 04342000
*   /*                                                               */ 04343000
*   /*****************************************************************/ 04344000
*                                                                  1316 04345000
*   IF RPRM1>=0                     /* PARM REGISTER POSITIVE ?      */ 04346000
*     THEN                          /* IF SO, HEX UNIT ADDRESS       */ 04347000
         LTR   RPRM1,RPRM1                                         1316 04348000
         BNM   @RT01316                                            1316 04349000
*     GO TO NIPMLOOK;               /* GO TO LOOKUP ALGORITHM        */ 04350000
*                                                                  1317 04351000
*   /*****************************************************************/ 04352000
*   /*                                                               */ 04353000
*   /* CONVERT EBCDIC UNIT ADDRESS TO HEXADECIMAL                    */ 04354000
*   /*                                                               */ 04355000
*   /*****************************************************************/ 04356000
*                                                                  1318 04357000
*   CALL NIPEBCDX;                                                 1318 04358000
         L     @15,@CA04765                                        1318 04359000
         BALR  @14,@15                                             1318 04360000
*   GEN(SRL  RPARM,8);              /* RIGHT ADJUST IN REGISTER 1    */ 04361000
         SRL  RPARM,8                                                   04362000
*   GEN REFS(CVTILK1,CVTILK2,CVTIXAVL,IOCOM,IOCOMEX,CVTMAP,IOX,IOCUCBBM 04363000
*       ,                           /*                        YM02128*/ 04364000
*       IOXHICH,                    /*                        YM06032*/ 04365000
*       UCBOB,UCBCHAN,UCBFL5,UCBLCI,CVTILCH,LCH,LCHTCH);           1320 04366000
*NIPMLOOK:                                                         1321 04367000
*   GENERATE;                                                      1321 04368000
NIPMLOOK DS    0H                                                  1321 04369000
*                                      /* GEN LINKAGE FOR LOOKUP     */ 04370000
         IOSGEN  UCBLOOK,UCB=(7),REG=(1)                                04371000
         LTR   REG15,REG15                TEST RETURN CODE              04372000
         BZ    NPMHVUCB                   0 RETURN CODE, HAVE A UCB     04373000
         SR    7,7                        INDICATE NO UCB               04374000
NPMHVUCB LR    RPARM,7                    LOAD RESULT IN RPARM          04375000
*   GEN(LM  RNVT,RZERO,UCBFNSAV);   /* RESTORE REGISTERS             */ 04376000
         LM  RNVT,RZERO,UCBFNSAV                                        04377000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 04378000
         BR REXIT                                                       04379000
*NIOSSAV:                                                          1324 04380000
*   GEN(DS   16F);                  /* IOS SAVE AREA                 */ 04381000
NIOSSAV  DS   16F                                                       04382000
*UCBFNSAV:                                                         1325 04383000
*   GEN(DS    16F);                 /* NIPUCBFN SAVEAREA             */ 04384000
*                                                                  1325 04385000
UCBFNSAV DS    16F                                                      04386000
*   /*****************************************************************/ 04387000
*   /*                                                               */ 04388000
*   /* RELEASE REGISTERS RESTRICTED FOR NIPUCBFN ROUTINE             */ 04389000
*   /*                                                               */ 04390000
*   /*****************************************************************/ 04391000
*                                                                  1326 04392000
*   RESPECIFY                                                      1326 04393000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04394000
*     RCVT) UNRESTRICTED;           /* CVT BASE REGISTER             */ 04395000
*   END NIPUCBFN;                   /* END - NIPUCBFN PROCEDURE      */ 04396000
@EL00023 DS    0H                                                  1327 04397000
@EF00023 DS    0H                                                  1327 04398000
@ER00023 BR    @14                                                 1327 04399000
*NIPTIME:                           /* TIMING SERVICE ROUTINE        */ 04400000
*                                                                  1328 04401000
*   /*****************************************************************/ 04402000
*   /*                                                               */ 04403000
*   /* THIS ROUTINE IS ENTERED TO PROVIDE EITHER THE TIME IN DECIMAL */ 04404000
*   /* AS INDICATED BY THE TIME OF DAY CLOCK OR TO PROVIDE A FULLWORD*/ 04405000
*   /* BINARY VALUE WHICH IS BASED ON THE TOD CLOCK AND WHICH        */ 04406000
*   /* REFLECTS THE NUMBER OF 100THS OF SECONDS ELAPSED SINCE        */ 04407000
*   /* IEAVNIPM WAS FIRST ENTERED FOR THE CURRENT IPL PROCESS. THE   */ 04408000
*   /* MEASURE OF TIME REQUESTED IS DETERMINED BY THE CODE IN THE    */ 04409000
*   /* PARAMETER REGISTER, RPARM (ZERO FOR DECIMAL REQUESTS AND FOUR */ 04410000
*   /* FOR BINARY REQUESTS).                                         */ 04411000
*   /*                                                               */ 04412000
*   /*****************************************************************/ 04413000
*                                                                  1328 04414000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/* PROC STATEMENT              */ 04415000
*                                                                  1328 04416000
NIPTIME  DS    0H                                                  1329 04417000
*   /*****************************************************************/ 04418000
*   /*                                                               */ 04419000
*   /* RESTRICT REGISTERS USED IN NIPTIME ROUTINE                    */ 04420000
*   /*                                                               */ 04421000
*   /*****************************************************************/ 04422000
*                                                                  1329 04423000
*   RESPECIFY                                                      1329 04424000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04425000
*     RNIPM,                        /* NIPM WORK REGISTER            */ 04426000
*     RNVT,                         /* NVT BASE REGISTER             */ 04427000
*     RCVT,                         /* CVT BASE REGISTER             */ 04428000
*     REVEN,                        /* EVEN OF EVEN-ODD PAIR         */ 04429000
*     RODD) RESTRICTED;             /* ODD OF EVEN-ODD PAIR          */ 04430000
*   GEN(NIPMENTR TIMESAV,NIPTIME);  /* GEN ENTRY LINKAGE             */ 04431000
*                                                                  1330 04432000
         NIPMENTR TIMESAV,NIPTIME                                       04433000
*   /*****************************************************************/ 04434000
*   /*                                                               */ 04435000
*   /* TEST IF TOD CLOCK INOPERATIVE FLAG IS ON. IF SO, THIS IS ENTRY*/ 04436000
*   /* FROM NIPWTO WHILE WRITING CLOCK INOPERATIVE MESSAGE. KEEP A   */ 04437000
*   /* 'PSEUDOCLOCK' RUNNING SO THAT WTO WOULD EVENTUALLY TIME OUT.  */ 04438000
*   /*                                                               */ 04439000
*   /*****************************************************************/ 04440000
*                                                                  1331 04441000
*NIPTODCK:                                                         1331 04442000
*   IF NVTFLNCK='1'B                /* TOD CLOCK INOPERATIVE ?       */ 04443000
*     THEN                          /* IF SO -                       */ 04444000
NIPTODCK TM    NVTFLNCK,B'00000100'                                1331 04445000
         BNO   @RF01331                                            1331 04446000
*     DO;                           /* TEST TYPE OF REQUEST          */ 04447000
*                                                                  1332 04448000
*       /*************************************************************/ 04449000
*       /*                                                           */ 04450000
*       /* TEST FOR BINARY REQUEST. IF SO, INCREMENT 'CLOCK'         */ 04451000
*       /* (WORKTIME) FOR EACH 10000TH ENTRY.                        */ 04452000
*       /*                                                           */ 04453000
*       /*************************************************************/ 04454000
*                                                                  1333 04455000
*       IF RPARM=4                  /* BINARY REQUEST ?              */ 04456000
*         THEN                      /* IF SO -                       */ 04457000
         C     RPARM,@CF00109                                      1333 04458000
         BNE   @RF01333                                            1333 04459000
*         DO;                       /* INCREMENT 'PSEUDOCLOCK'       */ 04460000
*           WORKTIME=WORKTIME+1;    /* ADD 1 TO SUM                  */ 04461000
         LA    @06,1                                               1335 04462000
         AL    @06,WORKTIME                                        1335 04463000
         ST    @06,WORKTIME                                        1335 04464000
*           RPARM=WORKTIME/C10000;  /* MICROS TO 100THS              */ 04465000
         LR    @00,@06                                             1336 04466000
         SRDA  @00,32                                              1336 04467000
         D     @00,C10000                                          1336 04468000
*           GO TO NIPTRSR;          /* BRANCH TO RESTORE REGS        */ 04469000
         B     NIPTRSR                                             1337 04470000
*         END;                                                     1338 04471000
*       RPARM=0;                    /* DEC. REQUEST - ZERO RPARM     */ 04472000
@RF01333 SLR   RPARM,RPARM                                         1339 04473000
*       GO TO NIPTRSR;              /* BRANCH TO RESTORE REGS        */ 04474000
         B     NIPTRSR                                             1340 04475000
*     END;                                                         1341 04476000
*                                                                  1341 04477000
*   /*****************************************************************/ 04478000
*   /*                                                               */ 04479000
*   /* CALL THE NIPSCHED ROUTINE TO GET DISPATCHED ON THE CPU THAT WE*/ 04480000
*   /* KNOW HAS A GOOD CLOCK.                                        */ 04481000
*   /*                                                               */ 04482000
*   /*****************************************************************/ 04483000
*                                                                  1342 04484000
*   RNIPM=ADDR(NPMSCHDL);           /* GET ADDRESS OF NIPSCHED     1342 04485000
*                                      PARAMETER LIST.               */ 04486000
@RF01331 LA    RNIPM,NPMSCHDL                                      1342 04487000
*   RNIPM->NSCHDPRM=RNVT;           /* PASS ADDRESS OF NVT TO ROUTINE   04488000
*                                      TO BE SCHEDULED.              */ 04489000
         ST    RNVT,NSCHDPRM(,RNIPM)                               1343 04490000
*   RNIPM=ADDR(NVTCPUAD);           /* ADDRESS OF CPU ADDRESS        */ 04491000
*                                                                  1344 04492000
         LA    RNIPM,NVTCPUAD                                      1344 04493000
*   /*****************************************************************/ 04494000
*   /*                                                               */ 04495000
*   /* CALL THE NIPSCHED ROUTINE TO GET TOD CODE DISPATCHED          */ 04496000
*   /*                                                               */ 04497000
*   /*****************************************************************/ 04498000
*                                                                  1345 04499000
*   GEN(IEAPMNIP TYPE=SCHED,PARAM=NPMSCHDL,CPUID=RNIPM,MOD=NIPM);  1345 04500000
         IEAPMNIP TYPE=SCHED,PARAM=NPMSCHDL,CPUID=RNIPM,MOD=NIPM        04501000
*   GEN(L RPARM,PARMSAV);           /* RESTORE RAPARM TO ORIG. VALUE */ 04502000
         L RPARM,PARMSAV                                                04503000
*   IF NVTFLNCK='1'B                /* IF CLOCK IS INOPERATIVE       */ 04504000
*     THEN                          /* PROCESS AS INOPERATIVE        */ 04505000
         TM    NVTFLNCK,B'00000100'                                1347 04506000
         BO    @RT01347                                            1347 04507000
*     GO TO NIPTODCK;               /* GO TO EXIT PROCESSING         */ 04508000
*   GO TO NIPTOP;                   /* GO PROCESS THE TOD            */ 04509000
         B     NIPTOP                                              1349 04510000
*                                                                  1350 04511000
*   /*****************************************************************/ 04512000
*   /*                                                               */ 04513000
*   /* THE FOLLOWING CODE IS EXECUTED UNDER AN SRB SCHEDULED BY THE  */ 04514000
*   /* NIPSCHED SERVICE ROUTINE ON A PARTICULAR CPU.                 */ 04515000
*   /*                                                               */ 04516000
*   /*****************************************************************/ 04517000
*                                                                  1350 04518000
*NIPTTOD:                                                          1350 04519000
*   ENTRY;                                                         1350 04520000
NIPTTOD  DS    0H                                                  1351 04521000
*   RNVT=RPARM;                     /* RESTORE NVT POINTER WITH    1351 04522000
*                                      ADDRESS PASSED IN RPARM.      */ 04523000
         LR    RNVT,RPARM                                          1351 04524000
*   GENERATE;                                                      1352 04525000
            USING  NVT,RNVT                                             04526000
            LM  RBASE,RBASE2,NVTNIPM   RESTORE BASE REGISTERS           04527000
            DROP   RNVT                                                 04528000
            STCK TIME                  STORE CLOCK VALUE                04529000
            BC   12,NIPTEND            IF GOOD CLOCK, RETURN            04530000
*   NVTFLNCK='1'B;                  /* INDICATE CLOCK INOPERATIVE    */ 04531000
         OI    NVTFLNCK,B'00000100'                                1353 04532000
*NIPTEND:                                                          1354 04533000
*   GEN(BR REXIT);                  /* RETURN TO CALLER              */ 04534000
*                                                                  1354 04535000
NIPTEND  BR REXIT                                                       04536000
*   /*****************************************************************/ 04537000
*   /*                                                               */ 04538000
*   /* IF TOD CLOCK IS OPERATIVE, THIS ROUTINE PROCESSES TIME        */ 04539000
*   /*                                                               */ 04540000
*   /*****************************************************************/ 04541000
*                                                                  1355 04542000
*NIPTOP:                            /* TOD CLOCK OPERATIVE           */ 04543000
*   IF NVTTOD=0                     /* SEE IF WE ARE IN MAINLINES    */ 04544000
*     THEN                          /* SEARCH FOR A GOOD CLOCK.      */ 04545000
NIPTOP   L     @06,NVTTOD                                          1355 04546000
         SLR   @05,@05                                             1355 04547000
         CR    @06,@05                                             1355 04548000
         BE    @RT01355                                            1355 04549000
*     GO TO NIPTRSR;                /* YES, RETURN WITHOUT CONVERT 1356 04550000
*                                      ING THE TIME.                 */ 04551000
*                                                                  1356 04552000
*   /*****************************************************************/ 04553000
*   /*                                                               */ 04554000
*   /* CHECK FOR TYPE OF TIME VALUE TO BE RETURNED TO CALLER         */ 04555000
*   /*                                                               */ 04556000
*   /*****************************************************************/ 04557000
*                                                                  1357 04558000
*   IF RPARM=0                      /* DECIMAL TIME REQUEST ?        */ 04559000
*     THEN                          /* IF SO -                       */ 04560000
         CR    RPARM,@05                                           1357 04561000
         BE    @RT01357                                            1357 04562000
*     GO TO NIPTDEC;                /* BRANCH TO DECIMAL TIME RTN    */ 04563000
*                                                                  1358 04564000
*   /*****************************************************************/ 04565000
*   /*                                                               */ 04566000
*   /* BINARY ELAPSED TIME ROUTINE SUBTRACT NVT-STORED HIGH ORDER    */ 04567000
*   /* WORD FROM CURRENT TIME                                        */ 04568000
*   /*                                                               */ 04569000
*   /*****************************************************************/ 04570000
*                                                                  1359 04571000
*   CONSTANT=CONSTANT-NVTTOD;                                      1359 04572000
         LCR   @06,@06                                             1359 04573000
         AL    @06,CONSTANT                                        1359 04574000
         ST    @06,CONSTANT                                        1359 04575000
*   GENERATE;                                                      1360 04576000
*                                      /* CONVERT TO 100THS OF SECS  */ 04577000
          LM    REVEN,RODD,TIME           LOAD REL. TIME INTO REGS      04578000
          SRDL  REVEN,12                  SHIFT OUT UNUSED LOW BITS     04579000
          D     REVEN,C10000              CONVERT TO 100THS SEC         04580000
*   RPARM=RODD;                     /* PUT TIME IN PARM REG          */ 04581000
         LR    RPARM,RODD                                          1361 04582000
*   GO TO NIPTRSR;                  /* BRANCH TO RESTORE REGS        */ 04583000
         B     NIPTRSR                                             1362 04584000
*NIPTDEC:                           /* DECIMAL TIME OF DAY ROUTINE   */ 04585000
*                                                                  1363 04586000
*   /*****************************************************************/ 04587000
*   /*                                                               */ 04588000
*   /* THIS ROUTINE CONVERTS BINARY CLOCK TIME INTO HOURS, MINUTES,  */ 04589000
*   /* SECONDS, 10THS, AND 100THS OF SECONDS IN HEXADECIMAL FORMAT - */ 04590000
*   /* HHMMSSTH                                                      */ 04591000
*   /*                                                               */ 04592000
*   /*****************************************************************/ 04593000
*                                                                  1363 04594000
*   GENERATE;                                                      1363 04595000
*                                                                  1363 04596000
NIPTDEC  DS    0H                                                  1363 04597000
*                                      /* FIND ELAPSED TIME          */ 04598000
         LM    REVEN,RODD,TIME    GET CLOCK VALUE                       04599000
         SRDL  REVEN,12           REMOVE UNUSED BITS                    04600000
         D     REVEN,C60MIL       DIVIDE BY # OF USECS. IN  1  MIN. TO  04601000
*                                   DETERMINE # OF MINS SINCE JAN 1900. 04602000
         ST    REVEN,TIME         SAVE REMAINDER (# OF USECS LEFT OVER) 04603000
         SR    REVEN,REVEN        CLEAR REG FOR DIVIDE                  04604000
         D     REVEN,C1440        DIVIDE BY # MINS PER DAY. REMAINDER   04605000
*                                   IS # MINS SINCE MIDNIGHT.           04606000
         LR    RODD,REVEN         SAVE MINS SINCE MIDNIGHT              04607000
         M     REVEN,C60MIL       CONVERT MIN SINCE MIDNIGHT TO USECS.  04608000
         AL    RODD,TIME          ADD # USECS INTO NEXT MIN TO LOW      04609000
*                                   ORDER WORD OF USECS SINCE MIDNIGHT  04610000
         BC    12,NOVRFLOW        CHECK FOR OVERFLOW                    04611000
         LA    REVEN,1(REVEN)     COMPENSATE FOR OVERFLOW               04612000
*   /*****************************************************************/ 04613000
*   /*                                                               */ 04614000
*   /* REVEN AND RODD NOW CONTAIN THE NUMBER OF MICRO SECONDS ELAPSED*/ 04615000
*   /* SINCE MIDNIGHT THE FOLLOWING CODE DERIVES 8 DECIMAL DIGITS (IN*/ 04616000
*   /* THE FORM HHMMSSTH) FROM THE BINARY TIME OF DAY VALUE. THIS IS */ 04617000
*   /* DONE BY SUCCESSIVELY DIVIDING THE BINARY TIME BY              */ 04618000
*   /* 10,10,10,6,10,6,10,AND 6 AND RETAINING THE REMAINDER OF THE   */ 04619000
*   /* DIVISIONS FOR THE RESULT.                                     */ 04620000
*   /*                                                               */ 04621000
*   /*****************************************************************/ 04622000
*                                                                  1364 04623000
*   GENERATE;                                                      1364 04624000
*                                                                  1364 04625000
*                                      /* CONVERT TO 100TH OF SECS   */ 04626000
NOVRFLOW  D     REVEN,C10000              REDUCE VALUE TO 100THS        04627000
          SR    REVEN,REVEN               CLEAR REMAINDER               04628000
*   /*****************************************************************/ 04629000
*   /*                                                               */ 04630000
*   /* BEGIN SUCCESSIVE DIVISIONS                                    */ 04631000
*   /*                                                               */ 04632000
*   /*****************************************************************/ 04633000
*                                                                  1365 04634000
*   DIVISOR=10;                     /* DEFINE INITIAL DIVISOR        */ 04635000
*                                                                  1365 04636000
         MVC   DIVISOR(4),@CF04594                                 1365 04637000
*   /*****************************************************************/ 04638000
*   /*                                                               */ 04639000
*   /* LOOP TO DO THE FIRST THREE DIVSIONS BY 10                     */ 04640000
*   /*                                                               */ 04641000
*   /*****************************************************************/ 04642000
*                                                                  1366 04643000
*   DO I=1 TO 3;                    /* DIVIDE BY 10 3 TIMES          */ 04644000
         LA    @06,1                                               1366 04645000
         ST    @06,I                                               1366 04646000
@DL01366 DS    0H                                                  1367 04647000
*     GEN(D  REVEN,DIVISOR);        /* DIVIDE - GET REMAINDER        */ 04648000
         D  REVEN,DIVISOR                                               04649000
*     GEN(LR  RZERO,REVEN);         /* MOVE DIGIT TO REGISTER        */ 04650000
         LR  RZERO,REVEN                                                04651000
*     GEN(SR  REVEN,REVEN);         /* CLEAR REMAINDER               */ 04652000
         SR  REVEN,REVEN                                                04653000
*     GEN(SRDL  RZERO,4);           /* SHIFT DIGIT INTO PARM REG     */ 04654000
         SRDL  RZERO,4                                                  04655000
*   END;                            /* END OF FIRST LOOP             */ 04656000
*                                                                  1371 04657000
         LA    @06,1                                               1371 04658000
         AL    @06,I                                               1371 04659000
         ST    @06,I                                               1371 04660000
         C     @06,@CF00381                                        1371 04661000
         BNH   @DL01366                                            1371 04662000
*   /*****************************************************************/ 04663000
*   /*                                                               */ 04664000
*   /* SECOND DO LOOP. DIVIDE BY 6,10,6,10,6                         */ 04665000
*   /*                                                               */ 04666000
*   /*****************************************************************/ 04667000
*                                                                  1372 04668000
*   DO I=1 TO 5;                    /* DO 5 DIVISIONS                */ 04669000
*                                                                  1372 04670000
         LA    @06,1                                               1372 04671000
         ST    @06,I                                               1372 04672000
@DL01372 DS    0H                                                  1373 04673000
*     /***************************************************************/ 04674000
*     /*                                                             */ 04675000
*     /* DIVIDE ALTERNATELY BY 6 AND 10                              */ 04676000
*     /*                                                             */ 04677000
*     /***************************************************************/ 04678000
*                                                                  1373 04679000
*     IF DIVISOR=10                 /* WAS LAST DIVISOR 10 ?         */ 04680000
*       THEN                        /* IF SO -                       */ 04681000
         CLC   DIVISOR(4),@CF04594                                 1373 04682000
         BNE   @RF01373                                            1373 04683000
*       DIVISOR=6;                  /* MAKE NEXT ONE 6               */ 04684000
         MVC   DIVISOR(4),@CF01156                                 1374 04685000
*     ELSE                          /* IF NOT, IT WAS 6              */ 04686000
*       DIVISOR=10;                 /* MAKE NEXT ONE 10              */ 04687000
         B     @RC01373                                            1375 04688000
@RF01373 MVC   DIVISOR(4),@CF04594                                 1375 04689000
*     GEN(D  REVEN,DIVISOR);        /* GET DECIMAL REMAINDER         */ 04690000
@RC01373 DS    0H                                                  1376 04691000
         D  REVEN,DIVISOR                                               04692000
*     GEN(LR  RZERO,REVEN);         /* MOVE DIGIT TO REGISTER        */ 04693000
         LR  RZERO,REVEN                                                04694000
*     GEN(SR  REVEN,REVEN);         /* CLEAR REMAINDER               */ 04695000
         SR  REVEN,REVEN                                                04696000
*     GEN(SRDL  RZERO,4);           /* SHIFT DIGIT TO PARM REG       */ 04697000
         SRDL  RZERO,4                                                  04698000
*   END;                            /* END OF SECOND DIVIDE LOOP     */ 04699000
         LA    @06,1                                               1380 04700000
         AL    @06,I                                               1380 04701000
         ST    @06,I                                               1380 04702000
         C     @06,@CF01507                                        1380 04703000
         BNH   @DL01372                                            1380 04704000
*NIPTRSR:                           /* THIS CODE RESTORES REGISTERS     04705000
*                                      AND RETURNS TO CALLER         */ 04706000
*   GEN(LM  RNVT,RZERO,TIMESAV);    /* RESTORE CALLER'S REGS         */ 04707000
NIPTRSR  LM  RNVT,RZERO,TIMESAV                                         04708000
*   GEN(BR  REXIT);                 /* RETURN CONTROL TO CALLER      */ 04709000
         BR  REXIT                                                      04710000
*TIMESAV:                                                          1383 04711000
*   GEN(DS  15F);                   /* NIPTIME SAVEAREA              */ 04712000
TIMESAV  DS  15F                                                        04713000
*PARMSAV:                                                          1384 04714000
*   GEN(DS  F);                     /* RPARM SAVE AREA               */ 04715000
*                                                                  1384 04716000
PARMSAV  DS  F                                                          04717000
*   /*****************************************************************/ 04718000
*   /*                                                               */ 04719000
*   /* RELEASE REGISTERS USED IN NIPTIME ROUTINE                     */ 04720000
*   /*                                                               */ 04721000
*   /*****************************************************************/ 04722000
*                                                                  1385 04723000
*   RESPECIFY                                                      1385 04724000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04725000
*     RNIPM,                        /* NIPM WORK REGISTER            */ 04726000
*     RNVT,                         /* NVT BASE REGISTER             */ 04727000
*     RCVT,                         /* CVT BASE REGISTER             */ 04728000
*     REVEN,                        /* EVEN OF EVEN-ODD PAIR         */ 04729000
*     RODD) UNRESTRICTED;           /* ODD OF EVEN-ODD PAIR          */ 04730000
*   END NIPTIME;                    /* END - NIPTIME PROCEDURE       */ 04731000
@EL00024 DS    0H                                                  1386 04732000
@EF00024 DS    0H                                                  1386 04733000
@ER00024 BR    @14                                                 1386 04734000
*NIPSENSE:                          /* PRINT SENSE INFO ROUTINE      */ 04735000
*                                                                  1387 04736000
*   /*****************************************************************/ 04737000
*   /*                                                               */ 04738000
*   /* THIS ROUTINE IS ENTERED FROM NIP PROCESSOR MODULES TO WRITE AN*/ 04739000
*   /* INTERPRETIVE I/O ERROR MESSAGE TO THE MASTER CONSOLE. INPUT IS*/ 04740000
*   /* THE ADDRESS OF AN IOB (WHICH REPRE- SENTS THE FAILING I/O     */ 04741000
*   /* OPERATION) IN REGISTER RPARM.                                 */ 04742000
*   /*                                                               */ 04743000
*   /*****************************************************************/ 04744000
*                                                                  1387 04745000
*   PROC OPTIONS(DONTSAVE,NOSAVEAREA);/* PROC STATEMENT              */ 04746000
*                                                                  1387 04747000
NIPSENSE DS    0H                                                  1388 04748000
*   /*****************************************************************/ 04749000
*   /*                                                               */ 04750000
*   /* RESTRICT REGISTERS FOR NIPSENSE SUBROUTINE                    */ 04751000
*   /*                                                               */ 04752000
*   /*****************************************************************/ 04753000
*                                                                  1388 04754000
*   RESPECIFY                                                      1388 04755000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04756000
*     RNVT,                         /* NVT BASE REGISTER             */ 04757000
*     RCVT,                         /* CVT BASE REGISTER             */ 04758000
*     RUCB,                         /* UCB BASE REGISTER             */ 04759000
*     RIOB) RESTRICTED;             /* IOB BASE REGISTER             */ 04760000
*   GEN(NIPMENTR SENSESAV,NIPSENSE);/* GEN ENTRY LINKAGE             */ 04761000
*                                                                  1389 04762000
         NIPMENTR SENSESAV,NIPSENSE                                     04763000
*   /*****************************************************************/ 04764000
*   /*                                                               */ 04765000
*   /* LOCATE UCB FOR DEVICE ASSOCIATED WITH I/O FAILURE             */ 04766000
*   /*                                                               */ 04767000
*   /*****************************************************************/ 04768000
*                                                                  1390 04769000
*   RUCB=RPARM->IOBDCBPT->DCBDEBAD->DEBSUCBB;                      1390 04770000
         L     @06,IOBDCBPT(,RPARM)                                1390 04771000
         L     @06,DCBDEBAD-1(,@06)                                1390 04772000
         L     RUCB,DEBSUCBB-1(,@06)                               1390 04773000
         LA    RUCB,0(,RUCB)                                       1390 04774000
*   ADR306I=UCBNAME;                /* MOVE UNIT NAME TO MESSAGE     */ 04775000
         MVC   ADR306I(3),UCBNAME(UCBPTR)                          1391 04776000
*   RIOB=RPARM;                     /* SET IOB POINTER               */ 04777000
         LR    RIOB,RPARM                                          1392 04778000
*   RPARM=IOBCSWCA-8;               /* LOCATE ADDR OF FAILING CCW    */ 04779000
*                                                                  1393 04780000
         L     RPARM,IOBCSWCA-1(,RIOB)                             1393 04781000
         LA    RPARM,0(,RPARM)                                     1393 04782000
         SL    RPARM,@CF00125                                      1393 04783000
*   /*****************************************************************/ 04784000
*   /*                                                               */ 04785000
*   /* MOVE CCW COMMAND CODE TO CONVERT TO EBCDIC AREA               */ 04786000
*   /*                                                               */ 04787000
*   /*****************************************************************/ 04788000
*                                                                  1394 04789000
*   CONVERT(1)=RPARM->P;                                           1394 04790000
         IC    @06,P(,RPARM)                                       1394 04791000
         STC   @06,CONVERT                                         1394 04792000
*   DIGITS=LENGTH(CM306I);          /* SET NUMBER OF CHARACTERS      */ 04793000
         MVC   DIGITS(4),@CF00265                                  1395 04794000
*   CALL NIPXCDIC;                  /* CALL CONVERT-TO-EBCDIC RTN    */ 04795000
         L     @15,@CA04764                                        1396 04796000
         BALR  @14,@15                                             1396 04797000
*   CM306I=CONVERT(1:LENGTH(CM306I));/* MOVE CODE TO MSG             */ 04798000
         MVC   CM306I(2),CONVERT                                   1397 04799000
*   CONVERT(1:2)=IOBCSWST;          /* MOVE IOB CSW STATUS           */ 04800000
         MVC   CONVERT(2),IOBCSWST(RIOB)                           1398 04801000
*   DIGITS=LENGTH(STA306I);         /* SET NUMBER OF CHARACTERS      */ 04802000
         MVC   DIGITS(4),@CF00109                                  1399 04803000
*   CALL NIPXCDIC;                  /* CALL CONVERT-TO-EBCDIC RTN    */ 04804000
         L     @15,@CA04764                                        1400 04805000
         BALR  @14,@15                                             1400 04806000
*   STA306I=CONVERT(1:LENGTH(STA306I));/* MOVE STAT TO MSG           */ 04807000
*                                                                  1401 04808000
         MVC   STA306I(4),CONVERT                                  1401 04809000
*   /*****************************************************************/ 04810000
*   /*                                                               */ 04811000
*   /* CHECK FOR TYPE OF MESSAGE ENDING TO BE USED IF UNIT CHECK, ADD*/ 04812000
*   /* SENSE DATA TO MESSAGE                                         */ 04813000
*   /*                                                               */ 04814000
*   /*****************************************************************/ 04815000
*                                                                  1402 04816000
*   IF IOBCSWUC='1'B                /* UNIT CHECK BIT ON ?           */ 04817000
*     THEN                          /* IF SO -                       */ 04818000
         TM    IOBCSWUC(RIOB),B'00000010'                          1402 04819000
         BNO   @RF01402                                            1402 04820000
*     DO;                           /* ISSUE MSG WITH SENSE BYTES    */ 04821000
*       CONVERT(1)=IOBSENS0;        /* MOVE SENSE BYTE 1 TO AREA     */ 04822000
         MVC   CONVERT(1),IOBSENS0(RIOB)                           1404 04823000
*       CONVERT(2)=IOBSENS1;        /* MOVE SENSE BYTE 2 TO AREA     */ 04824000
         MVC   CONVERT+1(1),IOBSENS1(RIOB)                         1405 04825000
*       DIGITS=LENGTH(SENS306I);    /* SET NO OF CHARACTERS          */ 04826000
         MVC   DIGITS(4),@CF00109                                  1406 04827000
*       CALL NIPXCDIC;              /* CALL CONVERT-TO-EBCDIC RTN    */ 04828000
*                                                                  1407 04829000
         L     @15,@CA04764                                        1407 04830000
         BALR  @14,@15                                             1407 04831000
*       /*************************************************************/ 04832000
*       /*                                                           */ 04833000
*       /* MOVE SENSE BYTES TO ERROR MESSAGE                         */ 04834000
*       /*                                                           */ 04835000
*       /*************************************************************/ 04836000
*                                                                  1408 04837000
*       SENS306I=CONVERT(1:LENGTH(SENS306I));                      1408 04838000
         MVC   SENS306I(4),CONVERT                                 1408 04839000
*       SER306I=UCBVOLI;            /* MOVE VOL SERIAL NUMBER        */ 04840000
         MVC   SER306I(6),UCBVOLI(UCBPTR)                          1409 04841000
*       VRB306I=UCBON;              /* MOVE ENDING TO MESSAGE        */ 04842000
         MVC   VRB306I(11),UCBON                                   1410 04843000
*     END;                                                         1411 04844000
*   ELSE                            /* NOT ON UNIT CHECK             */ 04845000
*     DO;                           /* WRITE NO SENSE BYTES          */ 04846000
         B     @RC01402                                            1412 04847000
@RF01402 DS    0H                                                  1413 04848000
*       SRL306I=UCBVOLI;            /* MOVE VOL SERIAL NO. TO END    */ 04849000
         MVC   SRL306I(6),UCBVOLI(UCBPTR)                          1413 04850000
*       VRB306I=UCBOFF;             /* MOVE ENDING TO MESSAGE        */ 04851000
         MVC   VRB306I(11),UCBOFF                                  1414 04852000
*     END;                                                         1415 04853000
*   RPARM=ADDR(IEA306I);            /* LOAD MSG HEADER ADDRESS       */ 04854000
@RC01402 LA    RPARM,IEA306I                                       1416 04855000
*   CALL NIPWTO;                    /* CALL NIPWTO ROUTINE           */ 04856000
         L     @15,@CV00098                                        1417 04857000
         BALR  @14,@15                                             1417 04858000
*   GEN(LM  RNVT,RPARM,SENSESAV);   /* RESTORE CALLER'S REGS         */ 04859000
         LM  RNVT,RPARM,SENSESAV                                        04860000
*   GEN(BR  REXIT);                 /* RETURN TO CALLING PROGRAM     */ 04861000
         BR  REXIT                                                      04862000
*SENSESAV:                                                         1420 04863000
*   GEN(DS   16F);                  /* NIPSENSE SAVEAREA             */ 04864000
*                                                                  1420 04865000
SENSESAV DS   16F                                                       04866000
*   /*****************************************************************/ 04867000
*   /*                                                               */ 04868000
*   /* RELEASE REGISTERS USED IN NIPSENSE SUBROUTINE                 */ 04869000
*   /*                                                               */ 04870000
*   /*****************************************************************/ 04871000
*                                                                  1421 04872000
*   RESPECIFY                                                      1421 04873000
*    (RPARM,                        /* PARM INTERFACE REGISTER       */ 04874000
*     RNVT,                         /* NVT BASE REGISTER             */ 04875000
*     RCVT,                         /* CVT BASE REGISTER             */ 04876000
*     RUCB,                         /* UCB BASE REGISTER             */ 04877000
*     RIOB) UNRESTRICTED;           /* IOB BASE REGISTER             */ 04878000
*   END NIPSENSE;                   /* END - NIPSENSE PROCEDURE      */ 04879000
@EL00025 DS    0H                                                  1422 04880000
@EF00025 DS    0H                                                  1422 04881000
@ER00025 BR    @14                                                 1422 04882000
*   END IEAVNIPM;                   /* END - IEAVNIPM PROCEDURE      */ 04883000
@EL00001 DS    0H                                                  1423 04884000
@EF00001 DS    0H                                                  1423 04885000
@ER00001 BR    @14                                                 1423 04886000
*/*IEAVNIPM:   CHART (SEQ)                                           */ 04887000
*/*HEADER                                                          1424 04888000
*/*                                                                1424 04889000
*/*                                                       PAGE #   1424 04890000
*/*                                                                1424 04891000
*/*                                                                1424 04892000
*/*3.1.1.1.17 DETAILED FLOWCHART - NIP CONTROL/SERVICE ROUTINES    1424 04893000
*/*(IEAVNIPM)                                                        */ 04894000
*/*FOOTING                                                         1424 04895000
*/*                                                                1424 04896000
*/*                                                                  */ 04897000
*/* E IEAVNIPM                                                       */ 04898000
*/* N ENTERED FROM IEAVNIP0                                          */ 04899000
*/* P MOVE INITIAL NVT FROM IEAVNIP0                                 */ 04900000
*/* P MOVE SYS1.NUCLEUS DEB EXTENT TO IEAVNIPM                       */ 04901000
*/* P MOVE SYS1.NUCLEUS APPENDAGE TABLE ADDRESS TO IEAVNIPM          */ 04902000
*/* P CALCULATE LOGREC RECORD SIZE                                   */ 04903000
*/* P ALLOCATE SPACE FOR LOGREC RECORD IN TOP OF NUCLEUS BUFFER      */ 04904000
*/* N MACHINE CHECK TRAPS SET - RESET BY IEAVNP06                    */ 04905000
*/* P SET COUNTER TO 16                                              */ 04906000
*/*%CPUCHK: D (YES,,NO,%DECRE) CPU ONLINE                            */ 04907000
*/* P SET MACHINE CHECK TRAP FOR CPU                                 */ 04908000
*/*%DECRE: P DECREMENT COUNT BY ONE                                  */ 04909000
*/* D (YES,,NO,%CPUCHK) COUNTER = 0                                  */ 04910000
*/* P PUT PTR TO MCH CHK TRAP IN ADDR PORTION OF NEW PSW             */ 04911000
*/* P PUT MALFUNTION ALERT TRAP ROUTINE ADDR INTO NVT                */ 04912000
*/* N SET TRAP FOR RTM1 BRANCH ENTRIES                               */ 04913000
*/* P PUT ADDR OF RTM1 TRAP ROUTINES INTO THE CVT (CVTBTERM)         */ 04914000
*/* P OPEN MACHINE CHECK ENTRY                                       */ 04915000
*/* N INITIALIZE XCTL AND TYPE 3 AND 4 SVC TRAPS                     */ 04916000
*/* P SAVE ADDR OF LOCATE SVC IN NVT                                 */ 04917000
*/* P SET NIPM LOCATE TRAP                                           */ 04918000
*/* P SAVE XCTL ENTRY POINT IN NVT                                   */ 04919000
*/* P SET XCTL ENTRY POINT TO NIPMS NIPSVC ROUTINE                   */ 04920000
*/* P SET COUNTER TO TOTAL NUMBER OF IBM SVCS                        */ 04921000
*/*%CHKCNT: D (YES,%ABEND,NO,) COUNTER ZERO                          */ 04922000
*/* D (YES,,NO,%MINUS1) SVC TYPE 3 OR 4                              */ 04923000
*/* P POINT SVC TO NIPSVC ROUTINE                                    */ 04924000
*/*%MINUS1: P DECREMENT COUNT BY ONE                                 */ 04925000
*/* P (,%CHKCNT) POINT TO NEXT SVC ENTRY (ADD EIGHT TO POINTER)      */ 04926000
*/*%ABEND: N SET TRAP FOR UNEXPECTED ABEND REQUESTS                  */ 04927000
*/* P STORE ADDR OF ABEND TRAP IN SVC TABLE                          */ 04928000
*/* N SET TRAP FOR SVC 60 (ESTAE) ENTRIES                            */ 04929000
*/* P PUT SVC 60 TRAP ADDR INTO SVC TABLE                            */ 04930000
*/* P PUT ADDR OF SVC 60 TRAP INTO CVT (CVTSV60)                     */ 04931000
*/* N SET SQA EXPANSION REQUEST TRAP                                 */ 04932000
*/* N REQUEST INVALID UNTIL AFTER PAGING SPVR INITIALIZED            */ 04933000
*/* P SAVE GET-SQA-PAGE ROUTINE ADDR IN NVT (NVTPQSAV)               */ 04934000
*/* P PUT ADDR OF NIPSQEND TRAP ROUTINE INTO PVT (PVTPSQA)           */ 04935000
*/* P PUT MASTERS TCB ADDR INTO V=V TCB POINTER (NVTVVTCB)           */ 04936000
*/* P PUT MASTERS TCB ADDR INTO V=R TCB POINTER (NVTVRTCB)           */ 04937000
*/* N GET TOD CLOCK VALUE FROM A GOOD CLOCK AND SAVE IN NVT          */ 04938000
*/* P INITIALIALIZE CPU COUNT TO ZERO                                */ 04939000
*/* P SAVE CPU ADDR FOR NIPTIME IN NVT (NVTCPUAD)                    */ 04940000
*/*%TIME: L IEAPMNIP: TYPE = TIME                                    */ 04941000
*/* D (YES,%CLKINOP,NO,) CLOCK INOPERATIVE FLAG ON                   */ 04942000
*/* P (,%MOVEFET) PUT GOOD CLOCK VALUE IN NVT (NVTTOD)               */ 04943000
*/*%CLKINOP: D (YES,,NO,%MOVEFET) MP ENVIRONMENT                     */ 04944000
*/* D (YES,,NO,%ALLCPU) FIRST CPU CHECKED - CNT = ZERO               */ 04945000
*/* P SAVE IPLED CPU ADDRESS                                         */ 04946000
*/*%ALLCPU: D (YES,%MOVEMAP,NO,)  ALL CPUS CHECKED (COUNT = 16)      */ 04947000
*/* P UPDATE PCCA VECTOR TABLE ENTRY POINTER                         */ 04948000
*/* D (YES,,NO,%IPLED) CPU OFFLINE                                   */ 04949000
*/*%PLUS1: P (,%ALLCPU) INCREMENT COUNT BY ONE                       */ 04950000
*/*%IPLED: D (YES,%PLUS1,NO,) IS THIS IPLED CPU                      */ 04951000
*/* P PUT CPU ADDR INTO NVT (NVTCPUAD                                */ 04952000
*/* P INCREASE CPU COUNT BY ONE                                      */ 04953000
*/* P (,%TIME) TURN CLOCK INOPERATIVE FLAG OFF (NVTFLNCK)            */ 04954000
*/*%MOVEFET: N MOVE FETCH FROM NIP0 TO GETMAINED STG               1424 04955000
*/*FOR USE UNTIL NP05 BUILDS PLPA                                    */ 04956000
*/* P GETMAIN STORAGE AND MOVE FETCH (IEWFTMIN)                      */ 04957000
*/* P MOVE APPENDAGES TO NUCLEUS BUFFER                              */ 04958000
*/* P UPDATE @ OF ADCON TABLE IN FETCH CSECT                         */ 04959000
*/* P UPDATE NUCLEUS END ADDRESS                                     */ 04960000
*/* P UPDATE CVT (CVTFETCH) TO POINT TO NEW FETCH                    */ 04961000
*/* N MOVE STORAGE MAP FROM IEAVNIP0                                 */ 04962000
*/* L GETMAIN: GET AREA FOR STORAGE MAP TO BE MOVED                  */ 04963000
*/* P MOVE MAP TO NEW AREA                                           */ 04964000
*/* P UPDATE POINTER TO MAP (NVTSTMAP)                               */ 04965000
*/* D (YES,,NO,%SUFFIX) PSA SAVED                                    */ 04966000
*/* L GETMAIN: GET AREA FOR PSA TO BE MOVED                          */ 04967000
*/* P MOVE PSA TO NEW AREA                                           */ 04968000
*/* P UPDATE ADDRESS OF PSA IN NVT (NVTSGPSA)                        */ 04969000
*/*%SUFFIX: P INITIALIZE SUFFIX LIST INDEX TO ONE                    */ 04970000
*/*%NXTSFX: P GET RIM SUFFIX FROM SUFFIX LIST (SUFXLIST)             */ 04971000
*/* P PUT ADDR OF RIM NAME INTO PARAMETER REGISTER ONE               */ 04972000
*/* S NIPLOAD: FIND - AND - LOAD - RIM ROUTINE                       */ 04973000
*/* L DELETE: DELETE RIM ON ITS RETURN                               */ 04974000
*/* N CHECK FOR SPECIAL CONDITIONS TO BE MET FOR RIMS                */ 04975000
*/* D (YES,,NO,%ADDONE)  PARMAREA CREATED BY IEAVNP03                */ 04976000
*/* P TURN OFF SPIO SPECIAL FLAG                                     */ 04977000
*/*%ADDONE: P INCREMENT SUFFIX LIST POINTER BY ONE                   */ 04978000
*/* D (YES,,NO,%B2) IEAVNPA1 LAST MODULE LOADED                      */ 04979000
*/* S NIPOPIOC: INITIATE OPERATOR COMMUNICATIONS                     */ 04980000
*/*%B2: D (YES,,NO,%R03) IEAVNP01 LAST MODULE LOADED                 */ 04981000
*/* S NPMOPLIB: OPEN SVCLIB AND LOGREC                               */ 04982000
*/*%R03: D (YES,,N,%R04) IEAVNP03 LAST MODULE LOADED                 */ 04983000
*/* D (YES,%CVIO,NO,) CLPA SPECIFIED                                 */ 04984000
*/* P SET QUICKSTART FLAG ON (NVTFLQS)                               */ 04985000
*/*%CVIO: D (YES,%R04,NO,) CVIO SPECIFIED                            */ 04986000
*/* P SET WARMSTART FLAG ON (NVTFLWS)                                */ 04987000
*/*%R04: D (YES,,NO,%A8) IEAVNP10 NEXT MODULE                        */ 04988000
*/* S NPMPFTBL: BUILD PFTES AND SETUP FOR PAGING                     */ 04989000
*/*%A8: D (YES,,NO,%R05) NEXT MODULE IEAVNPA8                        */ 04990000
*/* S NPMPREP8: SET FOR SQA ANALYSIS                                 */ 04991000
*/*%R05: D (YES,,NO,%RR05) NEXT MODULE IEAVNP05                      */ 04992000
*/* S NPMPREP5: SET UP FOR QUICKSTART                                */ 04993000
*/*%RR05: D (YES,,NO,%C8) IEAVNP05 LAST MODULE LOADED                */ 04994000
*/* S NPMCLNUP: CLEANUP V=V REGION AND FREE QSR                      */ 04995000
*/*%C8: D (YES,,NO,%XX) NEXT MODULE IEAVNPC8                         */ 04996000
*/* S NPMVVREG: SETUP V=R VALUES                                     */ 04997000
*/*%XX: D (YES,,NO,%NXTSFX) NEXT MODULE IEAVNIPX                     */ 04998000
*/* P PUT ADDR OF IEAVNIPX INTO PARM REG                             */ 04999000
*/* N CONTROL GOES TO IEAVNIPX AND NIPM IS DELETED                   */ 05000000
*/* R EXIT TO IEAVNIPX                                               */ 05001000
*/*NIPSVC: E ENTRY TO TYPE 3 AND 4 SVC TRAP                          */ 05002000
*/* N TRAP IS REMOVED BY IEAVNP05 WHEN LPA IS BUILT                  */ 05003000
*/* N LOCATE AND ABEND TRAPS REMOVED BY IEAVNIPX                     */ 05004000
*/* D (YES,,NO,%NIPLOCK) LOCATE SVC                                  */ 05005000
*/* P PUT ADDRESS OF IEAVNP12 (LOCATE RIM) INTO PARM REG             */ 05006000
*/* S NIPLOAD: FIND - AND - LOAD - RIM ROUTINE                       */ 05007000
*/* L DELETE: DELETE RIM ON ITS RETURN                               */ 05008000
*/* R RETURN TO CALLER                                               */ 05009000
*/*%NIPLOCK: S NIPLKCHK: GET NIP LOCK                                */ 05010000
*/* P PUT SVC CODE INTO PSW                                          */ 05011000
*/* P SET WAITSTATE CODE X'65' IN PSW (INVALID SVC ISSUED)           */ 05012000
*/* L IEAPMNIP: TYPE = SWAIT                                         */ 05013000
*/* R GO INTO DISABLED WAIT                                          */ 05014000
*/*NIPXCDIC: E ROUTINE TO CONVERT 4 HEX BYTES TO EBCDIC              */ 05015000
*/* P UNPACK THE HEX CHARACTERS                                      */ 05016000
*/* N CONVERT ANY UNPACKED DIGITS FA-FF TO C1-C6                     */ 05017000
*/*%D: D (YES,%RET,NO,) DIGIT COUNT ZERO                             */ 05018000
*/* D (YES,,NO,%DIGIT) DIGIT GREATER THAN X'C9'                      */ 05019000
*/* P CONVERT UNPACKED HEX LETTER TO EBCDIC                          */ 05020000
*/*%DIGIT: P (,%D) DECREMENT DIGIT COUNT AND ADJUST POINTER BY ONE   */ 05021000
*/*%RET: R RETURN TO CALLER                                          */ 05022000
*/*NIPEBCDX: E CONVERT 3 EBCDIC BYTES TO HEX ROUTINE                 */ 05023000
*/* N CONVERT ANY BYTES C1-C6 TO CA-CF                               */ 05024000
*/*%BYTECNT: D (YES,%PACK,NO,) BYTE COUNT 3                          */ 05025000
*/* N IF LETTER LESS THAN NUMERIC ASSUME IT IS A - F                 */ 05026000
*/* D (YES,,NO,%BYTE) BYTE LESS THAN X'F0'                           */ 05027000
*/* P CONVERT NUMERICAL DIGIT TO HEX VALUE                           */ 05028000
*/*%BYTE: P (,%BYTECNT) INCREMENT BYTE COUNT AND POINTER BY ONE      */ 05029000
*/*%PACK: P PACK THE BYTES TO COMPLETE CONVERSION                    */ 05030000
*/* R RETURN TO CALLER                                               */ 05031000
*/*NIPLOAD: E FIND AND LOAD NIP PROCESSOR RIMS                       */ 05032000
*/* P PUT MODULE NAME IN BLDL AREA                                   */ 05033000
*/* P PUT ADDR OF SYS1.NUCLEUS DCB INTO PARM REG                     */ 05034000
*/* L BLDL: FIND MODULE IN BLDL LIST                                 */ 05035000
*/* D (YES,%IOERR,NO,) ENTRY FOUND BY BLDL                           */ 05036000
*/* P PUT MODULE NAME IN MESSAGE                                     */ 05037000
*/* P SET NVT WAIT STATE CODE IN PSW (X'32')                         */ 05038000
*/* S NIPWTO: WRITE IEA301I MSG                                      */ 05039000
*/*%NPX: D (YES,,NO,%CNVERT) BLDL DIDNT FIND NIPX                    */ 05040000
*/*%PUTNAME: P PUT NAME SUFFIX OF MODULE INTO PSW                    */ 05041000
*/* L IEAPMNIP: TYPE = SWAIT                                         */ 05042000
*/* R GO INTO DISABLED WAIT                                          */ 05043000
*/*%CNVERT: P PUT SUFFIX OF MODULE INTO PARM REG                     */ 05044000
*/* S (,%PUTNAME) NIPEBCDX: CONVERT SUFFIX TO HEX                    */ 05045000
*/*%IOERR: D (YES,,NO,%ATTRIB) I/O ERROR ON BLDL                     */ 05046000
*/* P PUT MODULE NAME IN MESSAGE                                     */ 05047000
*/* P SET NVT WAIT STATE CODE IN PSW (X'33')                         */ 05048000
*/* S (,%NPX) NIPWTO: WRITE IEA300I MSG                              */ 05049000
*/*%ATTRIB: P SET NVT ATTRIBUTES TO RENT SO THAT SP252 IS USED       */ 05050000
*/* P PUT ADDR OF SYS1.NUCLEUS DCB INTO PARM REG                     */ 05051000
*/* L LOAD: LOAD MODULE                                              */ 05052000
*/* P PUT MODULE ADDR FROM REG 0 INTO PARM REG                       */ 05053000
*/* R RETURN TO CALLER                                               */ 05054000
*/*NIPABEND: E ABEND TRAP ROUTINE                                    */ 05055000
*/* S NIPLKCHK: GET NIP LOCK                                         */ 05056000
*/* N ABEND CODE IS PASSED TO TRAP ROUTINE IN PARM REG 1             */ 05057000
*/* P PUT ABEND CODE IN TO PSW                                       */ 05058000
*/* P SET NVT WAIT STATE CODE IN PSW (X'40')                         */ 05059000
*/* P PUT ABEND CODE WITH TOP 4 BITS ANDED OUT IN PARM REG           */ 05060000
*/* P SET CONVERSION LENGTH                                          */ 05061000
*/* S NIPXCDIC: HEX TO EBCDIC ROUTINE                                */ 05062000
*/* P MOVE CONVERTED ABEND CODE TO MESSAGE IEA303I                   */ 05063000
*/* P LOAD MSG HEADER ADDR                                           */ 05064000
*/* L IEAPMNIP: TYPE = SWAIT                                         */ 05065000
*/* R GO INTO DISABLED WAIT                                          */ 05066000
*/*NPMOPLIB: E OPEN SYS1.LOCREC AND SYS1.SVCLIB                      */ 05067000
*/* P POINT TO OPEN LIST                                             */ 05068000
*/* P GET ADDR OF SYSRES UCB FROM CVT (CVTSYSAD)                     */ 05069000
*/* P PUT EBCDIC NAME OF LOGREC INTO OPEN LIST                       */ 05070000
*/* P GET ADDR OF LOGREC DCB FROM CVT (CVTDCBA)                      */ 05071000
*/* P PUT ADDR OF LOGREC DCB INTO OPEN LIST                          */ 05072000
*/* P GET DEB ADDR FROM LOCREC DCB (DCBDEBAD)                        */ 05073000
*/* N LOGREC AND SVCLIB CANT BE OPENED UNTIL AFTER NP01 CONSOLE INIT */ 05074000
*/* N CALL NIPOPEN TO CREATE LOGREC DEB                              */ 05075000
*/* L IEAPMNIP: TYPE = OPEN                                          */ 05076000
*/* P GET ADDR OF SVCLIB DCB FROM CVT (CVTSVDCB)                     */ 05077000
*/* P PUT ADDR OF SVCLIB DCB INTO OPEN LIST                          */ 05078000
*/* P PUT EBCDIC NAME OF SVCLIB INTO OPEN LIST                       */ 05079000
*/* N CALL NIPOPEN TO CREATE SVCLIB DEB                              */ 05080000
*/* L IEAPMNIP: TYPE = OPEN                                          */ 05081000
*/* P GET ADDR OF LINKLIB DCB FROM CVT (CVTLINK)                     */ 05082000
*/* P PUT ADDR OF LINKLIB DCB INTO OPEN LIST                         */ 05083000
*/* N NIPOPEN WILL CONSTRUCT ONLY BASIC DEB FOR LINKLIB              */ 05084000
*/* P SET LINKLIB DSNAME TO ZERO IN OPEN LIST                        */ 05085000
*/* N CALL NIPOPEN TO CREATE LINKLIB BASIC DEB                       */ 05086000
*/* L IEAPMNIP: TYPE = OPEN                                          */ 05087000
*/* P UPDATE END OF NUC BUF TO INDICATE SPACE FOR LINKLIB BASIC DEB  */ 05088000
*/* P TURN LIBRARY ACTIVE FLAG ON (NVTFLSLB)                         */ 05089000
*/* R RETURN TO CALLER                                               */ 05090000
*/*NIPOPIO: E ESTABLISH INIT OPERATOR COMMUNICATIONS                 */ 05091000
*/* N CALLED BY NP01 AFTER MASTER CONSOLE INITIALIZATION             */ 05092000
*/* D (YES,,NO,%NWTO) TOD CLOCK INOPERATIVE                          */ 05093000
*/* N ISSUE MSG IEA302I                                              */ 05094000
*/* S IEAPMNIP: TYPE = WTO                                           */ 05095000
*/*  P POINT TO FIRST NIP0 MSG                                       */ 05096000
*/*%NWTO:  D (YES,,NO,%RELNO) NIP0 MSG                               */ 05097000
*/* S IEAPMNIP: TYPE = WTO                                           */ 05098000
*/* P GET NEXT MSG POINTER                                           */ 05099000
*/* P (,%NWTO)  GET ADDR OF NEXT MSG                                 */ 05100000
*/*%RELNO: P PUT RELEASE NUMBER (FROM CVTNUMB) INTO MSG IEA101A      */ 05101000
*/* P PUT LEVEL NUMBER (FROM CVTLEVL) INTO MSG IEA101A               */ 05102000
*/* N WRITE IEA101A SPECIFY SYSTEM PARAMETERS MSG                    */ 05103000
*/* S IEAPMNIP: TYPE = WTOR                                          */ 05104000
*/* R RETURN TO CALLER                                               */ 05105000
*/*NIPOPIOC: E PROCESS PARAMETER RESPONSE                            */ 05106000
*/*%OPIOC: P PUT PTR TO MOST RECENT WTOR PARM LIST INTO PARM REG     */ 05107000
*/* N CALL NIPWTOR2 ROUTINE TO BUFFER REPLY                          */ 05108000
*/* S IEAPMNIP: TYPE = WTOR2                                         */ 05109000
*/* P GET PTR TO SPE FROM NVT (NVTSPE)                               */ 05110000
*/* D (YES,,NO,%GETM) DATA PTR IN NVT = ZERO                         */ 05111000
*/* P SET REQD 8 BYTES TO NIP SPE QUEUE                              */ 05112000
*/* P (,%SCAN) POINT TO REPLY ADDRESS                                */ 05113000
*/*%GETM: L GETMAIN: GET 8 BYTES FOR SPE                             */ 05114000
*/*%LASTEL: D (YES,,NO,%NEXTSPE) NOT LAST SPE ON CHAIN               */ 05115000
*/* P (,%LASTEL) SET PTR TO NEXT SPE ON CHAIN                        */ 05116000
*/*%NEXTSPE: P SET CHAIN PTR TO NEW ELEMENT                          */ 05117000
*/* P SET PTR TO NEW ELEMENT                                         */ 05118000
*/* P SET PARM PTR TO OPERATORS REPLY                                */ 05119000
*/* N CHECK FOR END OF LINE INDICATION                               */ 05120000
*/*%SCAN: D (YES,%GOBACK,NO,) IS THIS A QUOTE                        */ 05121000
*/* D (YES,,NO,%UPDAT) BLANK OR COMMA                                */ 05122000
*/* P UPDATE PARM POINTER BY ONE                                     */ 05123000
*/* D (YES,,NO,%SCAN) CONT OF PARAMETERS                             */ 05124000
*/* P PUT PARM LIST ADDR INTO PARM REG                               */ 05125000
*/* S (,%OPIOC) IEAPMNIP: TYPE = WTOR                                */ 05126000
*/*%UPDAT: P (,%SCAN) UPDATE PARM POINTER BY ONE                     */ 05127000
*/*%GOBACK: R RETURN TO CALLER                                       */ 05128000
*/*NIPPRMPT: E IEAVNP03 LINKAGE                                      */ 05129000
*/* P SAVE CONTENTS OF PARM REG UPON ENTRY TO ROUTINE                */ 05130000
*/* P PUT ADDR OF IEAVNP03 PROMPT MODULE INTO PARM REG               */ 05131000
*/* S NIPLOAD: LOAD IEAVNP03                                         */ 05132000
*/* P RESTORE CONTENTS OF PARM REG SAVED UPON ENTRY TO ROUTINE       */ 05133000
*/* S IEAVNP03: NIP PROMPT MODULE                                    */ 05134000
*/* L DELETE: DELETE PROMPT MODULE                                   */ 05135000
*/* N CONTROL RETURNED TO CALLER WITH PARM REG SET BY IEAVNP03       */ 05136000
*/* R RETURN TO CALLER                                               */ 05137000
*/*NPMPFTBL: E PAGE FRAME TABLE BUILD                                */ 05138000
*/* P SET PFT PTR TO 1ST 16 BYTE BOUNDARY IN NUCLEUS BUFFER          */ 05139000
*/* P SUBTRACT PFT PTR FROM CVTEORM (START OF PFT TO STORAGE END)    */ 05140000
*/* P ROUND NUMBER OF BYTES UP TO A PAGE BOUNDARY                    */ 05141000
*/* P SUBTRACT SIZE OF PFT FROM PREVIOUS NUMBER                      */ 05142000
*/* P ROUND UP THAT NUMBER TO A PAGE BOUNDARY                        */ 05143000
*/* P ADD TRUE SIZE OF PFT TO PFT PTR (1ST 16 BYTE BOUNDARY IN NUC BUF) 05144000
*/*                                                                  */ 05145000
*/* P SAVE PFT BASE POINTER                                          */ 05146000
*/* D (YES,%PFTSIZE,NO,) ENOUGH SPACE FOR PFT IN NUC BUF             */ 05147000
*/* N NOT ENOUGH SPACE WRITE MSG IEA340I                             */ 05148000
*/* L IEAPMNIP: TYPE = WTO                                           */ 05149000
*/* P SET WAITSTATE CODE X'38' IN PSW (INSUFFICIENT REAL STORAGE)    */ 05150000
*/* L IEAPMNIP: TYPE = SWAIT                                         */ 05151000
*/* R GO INTO DISABLED WAIT                                          */ 05152000
*/*%PFTSIZE: P SUBTRACT PFT PTR FROM END OF NUC BUFFER (NVTNUCND)    */ 05153000
*/* P ZERO OUT THE PFT AREA ONE BYTE AT A TIME                       */ 05154000
*/* N BUILD PAGE FRAME TABLE                                         */ 05155000
*/* L SETLOCK: TYPE = SALLOC (GET SALLOCK LOCK)                      */ 05156000
*/* P GET PVT BASE POINTER FROM CVT (CVTPVTP)                        */ 05157000
*/* P SIZE OF PFTES = NO OF SQA AND LSQA PAGES TIMES LENGTH OF PFTE  */ 05158000
*/* N FIRST SQA PAGE PFTE INDEX IS THE FOLLOWING:                    */ 05159000
*/* P  LAST PFTE IN PFT INDEX - SIZE OF PFTES + ONE PFTE LENGTH      */ 05160000
*/* P PUT BEGIN ADDR OF PFTES BUILT BY NIP0 INTO PFTE PTR            */ 05161000
*/* P ADDR OF END OF NUC BUF IS ADDR FOR 1ST PFTE TO BE MOVED        */ 05162000
*/* P SHIFT ADDR 12 BITS TO FORM PAGE FRAME NUMBER                   */ 05163000
*/* P SAVE PAGE FRAME NO. FOR NPMVRREG ROUTINE TO UPDATE PVTPOOL     */ 05164000
*/* P SHIFT ADDR 4 BITS LEFT TO FORM PFT INDEX                       */ 05165000
*/* P NEW SQA PFTE PTR = PFTE PTR - ADDR OF 1ST PFTE + 1ST SQA PAGE     05166000
*/*PFTE INDEX                                                        */ 05167000
*/* P OLD SQA PFTE PTR = ORIGIN OF PFT + INDEX OF 1ST SQA PFTE       */ 05168000
*/* P MOVE SQA PFTES TO NEW PAGE FRAME TABLE IN INCREMENTS OF 256  1424 05169000
*/*BYTES                                                             */ 05170000
*/* P RESET 1ST PFTE RBN IN PVT (PVTFPFN)                            */ 05171000
*/* P  PFT APPARENT ORIGIN = PFT BEGINNING ADDR  - 1ST PFTE ADDR     */ 05172000
*/* P SET PREVIOUS AVAILABLE PFTE = ZERO                             */ 05173000
*/* N FIND PAGE FRAME INDEX OF FIRST V=V PAGE                        */ 05174000
*/* P GET FIRST V=V PAGE ADDRESS                                     */ 05175000
*/* P SHIFT ADDR 12 BITS TO FORM PAGE FRAME NUMBER                   */ 05176000
*/* P SHIFT ADDR 4 BITS LEFT TO FORM PFT INDEX               